/*
 * Decompiled with CFR 0.152.
 */
package br.com.vdt.controller;

import br.com.vdt.dao.ConexaoDao;
import br.com.vdt.model.Estatisticas;
import br.com.vdt.model.Eventos;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class EstatisticasController {
    private ConexaoDao conexaoDao;
    private String campanha;
    private String arquivoDiscador;
    private File file;
    private Logger log = Logger.getLogger(EstatisticasController.class.getName());
    private List<String> conteudo;
    private Estatisticas estatisticas;
    private double total_telefones = 0.0;
    private double total_eventos = 0.0;
    private double total_eventos_a_proc = 0.0;
    private double total_eventos_a_proc_mail = 0.0;
    private double telefones_a_processar = 0.0;
    private double total_reagendamentos = 0.0;
    private double telefones_a_processar_mail = 0.0;
    private double telefones_a_processar_reag = 0.0;
    private double porcent_eventos_a_proc = 0.0;
    private double porcent_eventos_a_proc_mail = 0.0;
    private double porcent_eventos_a_proc_reag = 0.0;

    public void setConexaoDao(ConexaoDao conexao) {
        this.conexaoDao = conexao;
    }

    public void setCampanha(String campanha) {
        this.campanha = campanha;
    }

    public String getCampanha() {
        return this.campanha;
    }

    public String getArquivoDiscador() {
        return this.arquivoDiscador;
    }

    public void setArquivoDiscador(String arquivoDiscador) {
        this.arquivoDiscador = arquivoDiscador;
    }

    public Estatisticas getEstatisticas() {
        return this.estatisticas;
    }

    public void setEstatisticas(Estatisticas estatisticas) {
        this.estatisticas = estatisticas;
    }

    public void le_arquivo_discador() {
        this.estatisticas = new Estatisticas();
        this.log = Logger.getLogger(Estatisticas.class.getName());
        this.log.info("Tratando a campanha " + this.getCampanha() + "...");
        this.log.info("Tentando ler o arquivo: " + this.arquivoDiscador + "...");
        this.file = new File(this.arquivoDiscador);
        if (!this.file.exists()) {
            this.log.warn("N\u00e3o foi poss\u00edvel encontrar ou ler o arquivo: " + this.arquivoDiscador);
        }
        this.log.info("Arquivo existente!");
        this.conteudo = new ArrayList<String>();
        try {
            String linha;
            FileReader reader = new FileReader(this.file);
            BufferedReader buffer = new BufferedReader(reader);
            while ((linha = buffer.readLine()) != null) {
                this.conteudo.add(linha);
            }
            this.log.info("Quantidade de linhas no arquivo " + this.arquivoDiscador + ": " + this.conteudo.size());
            buffer.close();
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.fatal("N\u00e3o foi poss\ufffdvel ler o arquivo: " + this.file.getAbsolutePath() + "\n" + e.getMessage());
        }
    }

    public void calcularEstatisticasEvento() {
        ArrayList<Eventos> eventos = new ArrayList<Eventos>();
        ArrayList<String> telefones = new ArrayList<String>();
        Eventos evt = new Eventos();
        evt.setConexaoDao(this.conexaoDao);
        int i = 0;
        while (i < this.conteudo.size()) {
            if (!this.conteudo.get(i).isEmpty() && !this.conteudo.get(i).equals(";;;;;") && this.conteudo.get(i) != null) {
                String[] dados_linha = this.conteudo.get(i).split(";");
                String[] dados_ant_linha = null;
                dados_ant_linha = i < this.conteudo.size() - 1 && !this.conteudo.get(i + 1).equals(";;;;;") ? this.conteudo.get(i + 1).split(";") : new String[]{"", "", "", "", "", ""};
                if (dados_linha.length >= 6 && !dados_linha[5].isEmpty() && !dados_linha[0].isEmpty()) {
                    if (!dados_linha[0].equals(dados_ant_linha[0])) {
                        telefones.add(String.valueOf(dados_linha[4]) + dados_linha[5]);
                        evt.setEvento(Integer.parseInt(dados_linha[0]));
                        evt.setTelefones(telefones);
                        evt.verificaEventoValido(this.file.getName());
                        if (evt.isValido()) {
                            this.total_eventos_a_proc += 1.0;
                            this.telefones_a_processar += (double)telefones.size();
                            evt.verificaReagendamento(this.file.getName());
                            if (evt.isReagendamento()) {
                                this.log.info("Evento reagendado: " + evt.getEvento());
                                this.total_reagendamentos += 1.0;
                                this.telefones_a_processar_reag += 1.0;
                                this.telefones_a_processar_mail += (double)(telefones.size() - 1);
                            } else {
                                this.telefones_a_processar_mail += (double)telefones.size();
                                this.total_eventos_a_proc_mail += 1.0;
                            }
                        }
                        this.total_telefones += (double)telefones.size();
                        eventos.add(evt);
                        telefones.clear();
                    } else {
                        telefones.add(String.valueOf(dados_linha[4]) + dados_linha[5]);
                    }
                }
            }
            ++i;
        }
        this.total_eventos = eventos.size();
        this.porcent_eventos_a_proc = this.total_eventos_a_proc * 100.0 / this.total_eventos;
        this.porcent_eventos_a_proc_mail = (this.total_eventos_a_proc - this.total_reagendamentos) * 100.0 / this.total_eventos;
        this.porcent_eventos_a_proc_reag = this.total_reagendamentos * 100.0 / this.total_eventos;
        DecimalFormat df = new DecimalFormat("0.##");
        String s_porcent_eventos_a_proc = String.valueOf(df.format(this.porcent_eventos_a_proc)) + "%";
        String s_porcent_eventos_a_proc_mail = String.valueOf(df.format(this.porcent_eventos_a_proc_mail)) + "%";
        String s_porcent_eventos_a_proc_reag = String.valueOf(df.format(this.porcent_eventos_a_proc_reag)) + "%";
        this.estatisticas.setTotal_eventos(this.total_eventos);
        this.estatisticas.setTotal_eventos_a_proc(this.total_eventos_a_proc);
        this.estatisticas.setTotal_eventos_a_proc_mail(this.total_eventos_a_proc_mail);
        this.estatisticas.setTotal_reagendamentos(this.total_reagendamentos);
        this.estatisticas.setTotal_telefones(this.total_telefones);
        this.estatisticas.setTelefones_a_processar(this.telefones_a_processar);
        this.estatisticas.setTelefones_a_processar_mail(this.telefones_a_processar_mail);
        this.estatisticas.setTelefones_a_processar_reag(this.telefones_a_processar_reag);
        this.estatisticas.setPorcent_eventos_a_proc(s_porcent_eventos_a_proc);
        this.estatisticas.setPorcent_eventos_a_proc_mail(s_porcent_eventos_a_proc_mail);
        this.estatisticas.setPorcent_eventos_a_proc_reag(s_porcent_eventos_a_proc_reag);
        this.conteudo.clear();
        this.conteudo = null;
        this.log.info("Total de eventos em " + this.file.getName() + ": " + this.total_eventos);
        this.log.info("Total de eventos a processar: " + this.total_eventos_a_proc);
        this.log.info("Total de eventos a processar de mailing: " + this.total_eventos_a_proc_mail);
        this.log.info("Total de telefones: " + this.total_telefones);
        this.log.info("Total de telefones a processar: " + this.telefones_a_processar);
        this.log.info("Total de telefones a processar de mailing: " + this.telefones_a_processar_mail);
        this.log.info("Total de reagendamentos: " + this.total_reagendamentos);
        this.log.info("Total de telefones a processar de reagendamentos: " + this.telefones_a_processar_reag);
        this.log.info("Porcentagem de eventos a processar: " + s_porcent_eventos_a_proc);
        this.log.info("Porcentagem de eventos a processar em mailing: " + s_porcent_eventos_a_proc_mail);
        this.log.info("Porcentagem de eventos a processar em reagendamento: " + s_porcent_eventos_a_proc_reag);
    }

    protected void finalize() {
        this.arquivoDiscador = null;
        this.conteudo = null;
        this.file = null;
        this.porcent_eventos_a_proc = 0.0;
        this.porcent_eventos_a_proc_mail = 0.0;
        this.porcent_eventos_a_proc_reag = 0.0;
        this.telefones_a_processar = 0.0;
        this.telefones_a_processar_mail = 0.0;
        this.telefones_a_processar_reag = 0.0;
        this.total_eventos = 0.0;
        this.total_eventos_a_proc = 0.0;
        this.total_eventos_a_proc_mail = 0.0;
        this.total_reagendamentos = 0.0;
        this.total_telefones = 0.0;
    }
}

