/*
 * Decompiled with CFR 0.152.
 */
package br.com.vdt.controller;

import br.com.vdt.controller.EstatisticasController;
import br.com.vdt.dao.ConexaoDao;
import br.com.vdt.dao.MailingsDao;
import br.com.vdt.model.Mailings;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class MailingsController {
    private ConexaoDao conexaoDao = new ConexaoDao();
    private MailingsDao mailDao = new MailingsDao();
    private List<Mailings> mailings;
    private Gson gson;
    private Logger log;

    public MailingsController() {
        this.mailDao.setConexao(this.conexaoDao);
        this.gson = new Gson();
        this.log = Logger.getLogger(MailingsController.class.getName());
    }

    public void run() {
        EstatisticasController estatisticasController = new EstatisticasController();
        this.mailings = this.mailDao.getMailingsVisiveis();
        String json = "";
        String caminho = this.carrega_caminho_arquivo();
        File arquivo = new File(String.valueOf(caminho) + "data-discador.json");
        boolean arquivo_existe = false;
        if (arquivo.exists()) {
            arquivo_existe = true;
            arquivo = new File(String.valueOf(caminho) + "data-discador.json.tmp");
        }
        try {
            FileWriter fw = new FileWriter(arquivo);
            PrintWriter pw = new PrintWriter(fw);
            for (Mailings mail : this.mailings) {
                estatisticasController.setCampanha(mail.getCampanha());
                estatisticasController.setArquivoDiscador(mail.getFilename());
                estatisticasController.le_arquivo_discador();
                estatisticasController.setConexaoDao(this.conexaoDao);
                estatisticasController.calcularEstatisticasEvento();
                mail.setEstatisticas(estatisticasController.getEstatisticas());
                json = this.gson.toJson(mail);
                pw.println(json);
                mail = null;
                json = null;
                estatisticasController.setEstatisticas(null);
                estatisticasController.finalize();
            }
            pw.flush();
            pw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (arquivo_existe) {
            arquivo = new File(String.valueOf(caminho) + "data-discador.json");
            arquivo.delete();
            arquivo = new File(String.valueOf(caminho) + "data-discador.json.tmp");
            File dest = new File(String.valueOf(caminho) + "data-discador.json");
            arquivo.renameTo(dest);
        }
    }

    public String carrega_caminho_arquivo() {
        String caminho = "";
        Properties props = new Properties();
        try {
            FileInputStream in = new FileInputStream("/usr/local/apache2/htdocs/vdt/configs.properties");
            props.load(in);
            caminho = props.getProperty("filepath");
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return caminho;
    }
}

