/*
 * Decompiled with CFR 0.152.
 */
package br.com.vdt.dao;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConexaoDao {
    private Connection conexao;
    private String ip;
    private String usuario;
    private String senha;
    private String nome_banco;
    private Properties props;
    private FileInputStream in;
    private Logger log = Logger.getLogger(ConexaoDao.class.getName());

    public ConexaoDao() {
        this.props = new Properties();
        try {
            this.log.info("Carregando as configurac\u00f5es do banco de dados.");
            File file = new File("/usr/local/apache2/htdocs/vdt/configs.properties");
            if (!file.exists()) {
                this.log.error("N\u00e3o foi poss\u00edvel encontrar o arquivo configs.properties.");
                System.exit(0);
            }
            this.in = new FileInputStream("/usr/local/apache2/htdocs/vdt/configs.properties");
            this.props.load(this.in);
            this.log.info("Configurac\u00f5es carregadas com sucesso.");
        }
        catch (IOException ioe) {
            this.log.fatal("Erro ao carregar as configurac\u00f5es: " + ioe.getMessage());
            ioe.printStackTrace();
        }
        this.ip = this.props.getProperty("ip");
        this.usuario = this.props.getProperty("usuario");
        this.senha = this.props.getProperty("senha");
        this.nome_banco = this.props.getProperty("nome_banco");
        try {
            this.log.info("Carregando a biblioteca mysql: com.mysql.jdbc.Driver");
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            this.log.fatal("Erro ao carregar com.mysql.jdbc.Driver: " + e.getMessage());
            e.printStackTrace();
        }
        String url = "jdbc:mysql://" + this.ip + "/" + this.nome_banco + "?zeroDateTimeBehavior=convertToNull";
        try {
            if (this.conexao == null) {
                this.log.info("Tentando conectar no banco de dados: " + url);
                this.conexao = DriverManager.getConnection(url, this.usuario, this.senha);
            } else {
                this.log.info("Conex\u00e3o com o banco de dados j\u00e1 estabelecida.");
            }
        }
        catch (SQLException e) {
            this.log.fatal("Erro ao conectar no banco de dados: " + e.getMessage());
            e.printStackTrace();
        }
        this.log.info("Conectado ao banco de dados!");
    }

    public boolean desconectar() {
        try {
            this.conexao.close();
            this.log.info("Conex\u00e3o com banco de dados fechada com sucesso.");
            return true;
        }
        catch (SQLException e) {
            this.log.warn("N\u00e3o foi poss\u00edvel fechar a conex\u00e3o com mysql: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public Connection getConexao() {
        return this.conexao;
    }
}

