var restify = require('restify');
var settings = require('./settings.js');
var MysqlDao = require('./dao/mysqlDao.js');

var mysqlDao = new MysqlDao(
    settings.mysql.host, 
    settings.mysql.port, 
    settings.mysql.username, 
    settings.mysql.password, 
    settings.mysql.database
);

var app = restify.createServer();
app.use(restify.bodyParser({ mapParams: false })); // mapped in req.body
app.use(restify.queryParser());
app.use(restify.CORS());

require(__dirname + '/routes/api/cancelar_agendamento.js')(app, mysqlDao);

app.listen(settings.server.port, settings.server.ipaddress, function () {
    console.log('Server running on %s', app.url);
});