var mysql = require('mysql');

class MysqlDao {

    constructor(host, port, username, password, database){
        console.log("[MysqlDao] - Criando conexão do Mysql...");
        this.connection = mysql.createConnection({
            host: host,
            port: port,
            user: username, 
            password: password,
            database: database
        });

        this.connect();
    }

    connect(){
        console.log("[MysqlDao] - Conectando no Mysql...");
        this.connection.connect();
    }

    query(sql){
        console.log("[MysqlDao] - Executando query no Mysql: " + sql);
        var self = this;
        return new Promise((resolve, reject) => {
            self.connection.query(sql, function(error, results, fields){
                if(error) return reject(error);
                else return resolve(results);
            });
        });
    }
}

module.exports = MysqlDao;