<?php
/**************************************************************
 * Nome:    Agentes
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-02-13 (V1.0.1)
 * Descr.:  Cria classe de agentes
 *************************************************************/


/**************************************************************
  Classe Agentes
  Eh a classe principal de unidades de negocio.
 *************************************************************/
class Agentes {
  var $Bd;
  var $Meia;
  var $Ami;
  var $TabelaA;
  var $TabelAG;
  var $TabelAR;
  var $TabelAL;
  var $TabelAT;
  var $TabelaF;
  var $TabelFA;
  var $TabelFT;
  var $TabelFG;
  var $TabelaG;
  var $TabelaR;
  var $TabelaM;
  var $TabelaP;
  var $TabelRA;
  var $TabelRG;
  var $TabelaD;
  var $TabelMS; //tabela de mensagens de agente para agente...
  var $TabelML;
  var $TabelLG;
  var $TabelCC;
  var $TabelGE; //Tabela que guarda as configura��es gerais que o supervisor definiu..
  var $TabelUG;
  var $TabelMM;
  var $DistrCh;
  var $FilArqu;
  var $FilBanc;
  var $ConCont;
  var $Hoje;
  var $Fotos;
  var $Df01, $Df02, $Df03, $Df04, $Df05;
  var $Df06, $Df07, $Df08, $Df09, $Df10;
  var $Df11, $Df12, $Df13, $Df14, $Df15;
  var $Df16, $Df17, $Df18, $Df19, $Df20;
  var $TabelaLoginGrupo;
  var $TipoFilaDinamica;
  var $TabelTR;
  var $Dir_conf_aterisk;

  //---------------------------------------------------
  // Construtor da classe.
  //---------------------------------------------------
  function Agentes() {
    ($_SERVER['DOCUMENT_ROOT'] != "") ? $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/' : $DirRaiz = '/usr/local/apache2/htdocs/vdt/';
    include($DirRaiz.'config.php');
    include($DirRaiz.'config.cc.php');
	include($DirRaiz.'config.pbx.php');
    include_once($DirRaiz.$DirClass.'bd.class.php');
    include_once($DirRaiz.$DirClass.'soquete.class.php');
	include_once($DirRaiz.$DirClass.'ami.class.php');
    $this->Bd      = new Banco();
    $this->Meia    = new Soquetes();
	$this->Ami	   = new Ami();
    $this->TabelaA = $Tb_Agent;
    $this->TabelAG = $Tb_AgGru;
	$this->TabelAR = $Tb_AgRam;
    $this->TabelAL = $Tb_AgLog;
    $this->TabelAT = $Tb_AgTur;
    $this->TabelaF = $Tb_Fila;
    $this->TabelFA = $Tb_AgeFi;
    $this->TabelFT = $Tb_TurFi;
    $this->TabelFG = $Tb_GraFi;
    $this->TabelaG = $Tb_Grupo;
    $this->TabelGF = $Tb_GruFi;
    $this->TabelaR = $Tb_VRama;
    $this->TabelaM = $Tb_AgeFi;
    $this->TabelaP = $Tb_Pausa;
    $this->TabelaD = $Tb_Perio;
	$this->TabelMS = $Tb_Mensa; //tabela de mensagens de agente para agente..
    $this->TabelML = $Tb_MLogi;
    $this->TabelLG = $Tb_Ligac;
    $this->TabelCC = $Tb_ClasC;
	$this->TabelGE = $Tb_Geral; //Tabela que guarda as configura��es gerais que o supervisor definiu..
	$this->TabelMM = $Tb_MosMo; //tabela que cont�m os dados dos agentes que o supervisor nao quer ver no monitoramento...
	$this->TabelUG = $Tb_UsuGr;
    $this->ConCont = $Contexto;
    $this->Fotos   = $DirRaiz.$DirCCen.$DirFoto;
    $this->DistrCh = array('rrmemory', 'ringall', 'roundrobin', 'leastrecent', 'feweastcalls', 'random');
    $this->FilArqu = array('nome','strategy','music','timeout','retry','maxlen','weight','wrapuptime','memberdelay','timeoutrestart','autofill','setinterfacevar','announce-frequency','periodic-announce-frequency','announce-holdtime','announce-round-seconds','ringinuse','joinempty','leavewhenempty','eventwhencalled','eventmemberstatus');
    $this->FilBanc = array('nome','estrategia','musica','timeout','tentardenovo','limitedafila','prioridade','delaydeencaminhamento','delaydeatendimento','resetatimeout','distribuicaodacparalela','setavariavel','anundeposicaonafila','anunperiodicos','anunesperaestimada','anundesegundos','segchamadanapa','entradafilasemmembros','removechamsesemmembros','geraeventochamagente','geraeventomembstatus');
    $this->Hoje    = date("d/m/y");
	$this->TabelaLoginGrupo = $Tb_LoginGrupo;
	$this->TipoFilaDinamica = $TipoFilaDinamica;
	$this->TabelTR = $Tb_Tronc;
	$this->Dir_conf_aterisk = $Diretorio_config_asterisk;
  }


  //---------------------------------------------------
  // Funcao lista_metodo_logins
  //---------------------------------------------------
  function lista_metodo_logins($Ativo='') {
    $Pes  = "SELECT metodo FROM ".$this->TabelML." LIMIT 1";
    $Res1 = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res1) $Saida = false;
    else $Saida = $Res1[0]['metodo'];
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao metodo_logins
  //---------------------------------------------------
  function altera_metodo_logins($Metodo) {
    $Troca   = "UPDATE ".$this->TabelML." SET metodo='".$Metodo."'";
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_grupos
  //---------------------------------------------------
function lista_grupos($Ativo='',$Usuar='') {
		$Pes  = "SELECT * FROM ".$this->TabelaG." ORDER BY nome";
    	$Res1 = $this->Bd->executa_query_com_saida($Pes);

		$Pes  = "SELECT ".$this->TabelGF.".grupo as id, ".$this->TabelaF.".pseudonimo as fila FROM ".$this->TabelGF." INNER JOIN ".$this->TabelaF." ON ".$this->TabelGF.".fila=".$this->TabelaF.".id ORDER BY ".$this->TabelGF.".grupo";
        $Res2 = $this->Bd->executa_query_com_saida($Pes);

		if($Usuar != ''){
			$Pes = "SELECT g.id, g.nome FROM ".$this->TabelaG." g, ".$this->TabelUG." u WHERE g.id = u.grupo AND u.usuario = ".$Usuar;
			$Res3 = $this->Bd->executa_query_com_saida($Pes);
		}

        $Saida = array($Res1,$Res2,$Res3);
    return $Saida;
}

    function listar_agentes_pelo_grupo($grupo){
        $sql = "SELECT * FROM vm50_agentes WHERE grupo = '".$grupo."' ORDER BY situacao = 'NLogado' ASC";
        $res = $this->Bd->executa_query_com_saida($sql);
        return $res;
    }


  //---------------------------------------------------
  // Funcao apaga_grupos
  //---------------------------------------------------
  function apaga_grupos($Identif) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Apa = "DELETE FROM ".$this->TabelaG." WHERE id='".$Identif."'";
      $Res = $this->Bd->executa_query_sem_saida($Apa);
      if (!$Res) $Saida = false;
      else {
        $Apa = "DELETE FROM ".$this->TabelGF." WHERE grupo='".$Identif."'";
        $Res = $this->Bd->executa_query_sem_saida($Apa);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_grupos
  //---------------------------------------------------
  function altera_grupos($Identif,$Nome,$tipoPainel,$iepau,$irpau,$epaut,$tipau,$tempp,$class,$pppChamEnt,$minsai,$maxsai,$minint,$maxint,$minddr,$maxddr,$minfil,$maxfil,$maxliv,$maxedd,$maxeco,$maxmon,$minsad,$maxsad,$minate,$maxate,$adient,$adisai,$mincon,$maxcon,$conmemf,$epquali,$habEnvioWebservice) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    $Nome    = $this->Bd->limpa_query(trim($Nome));
	$iepau   = $this->Bd->limpa_query(trim($iepau));
	$irpau   = $this->Bd->limpa_query(trim($irpau));
	$epaut   = $this->Bd->limpa_query(trim($epaut));
	$tipau   = $this->Bd->limpa_query(trim($tipau));
	$tempp   = $this->Bd->limpa_query(trim($tempp));
    $minsai  = $this->Bd->limpa_query(trim($minsai));
    $maxsai  = $this->Bd->limpa_query(trim($maxsai));
    $minint  = $this->Bd->limpa_query(trim($minint));
    $maxint  = $this->Bd->limpa_query(trim($maxint));
    $minddr  = $this->Bd->limpa_query(trim($minddr));
    $maxddr  = $this->Bd->limpa_query(trim($maxddr));
    $minfil  = $this->Bd->limpa_query(trim($minfil));
    $maxfil  = $this->Bd->limpa_query(trim($maxfil));
    $maxliv  = $this->Bd->limpa_query(trim($maxliv));
    $maxedd  = $this->Bd->limpa_query(trim($maxedd));
    $maxeco  = $this->Bd->limpa_query(trim($maxeco));
    $maxmon  = $this->Bd->limpa_query(trim($maxmon));
    $minsad  = 10;
    $maxsad  = 10;
    $minate  = $this->Bd->limpa_query(trim($minate));
    $maxate  = $this->Bd->limpa_query(trim($maxate));
    $adient  = $this->Bd->limpa_query(trim($adient));
    $adisai  = $this->Bd->limpa_query(trim($adisai));
    $mincon  = $this->Bd->limpa_query(trim($mincon));
    $maxcon  = $this->Bd->limpa_query(trim($maxcon));
    $conmemf = $this->Bd->limpa_query(trim($conmemf));
    $epquali = $this->Bd->limpa_query(trim($epquali));
    $Troca   = "UPDATE ".$this->TabelaG." SET nome='".$Nome."', minsaida=".$minsai.", maxsaida=".$maxsai.", mininter=".$minint.", maxinter=".$maxint.", minddr=".$minddr.", maxddr=".$maxddr.", minfila=".$minfil.", maxfila=".$maxfil.", maxlivre=".$maxliv.", maxesddr=".$maxedd.", maxeco=".$maxeco.", maxmon=".$maxmon.", minsai=".$minsad.", maxsai=".$maxsad.", minate=".$minate.", maxate=".$maxate.", adient=".$adient.", adisai=".$adisai.", mincon=".$mincon.", maxcon=".$maxcon.", entrarpausaauto='".$epaut."', pausaautomatica='".$tipau."', tempodepausa='".$tempp."', ignorarretiradapausaauto = '".$irpau."', ignorarentradapausaauto = '".$iepau."', classifica_chamadas = '".$class."', tipo_painel_pa = '".$tipoPainel."', popup_chamadas_entrantes = ".$pppChamEnt.", consultar_membros_filas = ".$conmemf.", entrar_pausa_qualificacao='".$epquali."', habEnvioWebservice = ".$habEnvioWebservice." WHERE id='".$Identif."'";
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_grupos
  //---------------------------------------------------
  function insere_grupos($Nome,$iepau,$irpau,$epaut,$tipau,$tempp,$classCham,$minsai,$maxsai,$minint,$maxint,$minddr,$maxddr,$minfil,$maxfil,$maxliv,$maxedd,$maxeco,$maxmon,$minsad,$maxsad,$minate,$maxate,$adient,$adisai,$mincon,$maxcon,$conmemf,$epquali,$habEnvioWebservice) {
    $Nome   = $this->Bd->limpa_query(trim($Nome));
	$iepau  = $this->Bd->limpa_query(trim($iepau));
	$irpau  = $this->Bd->limpa_query(trim($irpau));
	$epaut  = $this->Bd->limpa_query(trim($epaut));
	$tipau  = $this->Bd->limpa_query(trim($tipau));
	$tempp  = $this->Bd->limpa_query(trim($tempp));
    $minsai = $this->Bd->limpa_query(trim($minsai));
    $maxsai = $this->Bd->limpa_query(trim($maxsai));
    $minint = $this->Bd->limpa_query(trim($minint));
    $maxint = $this->Bd->limpa_query(trim($maxint));
    $minddr = $this->Bd->limpa_query(trim($minddr));
    $maxddr = $this->Bd->limpa_query(trim($maxddr));
    $minfil = $this->Bd->limpa_query(trim($minfil));
    $maxfil = $this->Bd->limpa_query(trim($maxfil));
    $maxliv = $this->Bd->limpa_query(trim($maxliv));
    $maxedd = $this->Bd->limpa_query(trim($maxedd));
    $conmemf = $this->Bd->limpa_query(trim($conmemf));
    $epquali = $this->Bd->limpa_query(trim($epquali));
    $Pes  = "SELECT id FROM ".$this->TabelaG." WHERE nome='".$Nome."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO ".$this->TabelaG." (nome,minsaida,maxsaida,mininter,maxinter,minddr,maxddr,minfila,maxfila,maxlivre,maxesddr,maxeco,maxmon,minsai,maxsai,minate,maxate,adient,adisai,mincon,maxcon,entrarpausaauto,pausaautomatica,tempodepausa,ignorarretiradapausaauto,ignorarentradapausaauto,classifica_chamadas,consultar_membros_filas,entrar_pausa_qualificacao,habEnvioWebservice) VALUES ('".$Nome."',".$minsai.",".$maxsai.",".$minint.",".$maxint.",".$minddr.",".$maxddr.",".$minfil.",".$maxfil.",".$maxliv.",".$maxedd.",".$maxeco.",".$maxmon.",".$minsad.",".$maxsad.",".$minate.",".$maxate.",".$adient.",".$adisai.",".$mincon.",".$maxcon.",'".$epaut."','".$tipau."',".$tempp.",'".$irpau."','".$iepau."', '".$classCham."', ".$conmemf.",'".$epquali."',".$habEnvioWebservice.")";
      //return $Insere;
	$Res    = $this->Bd->executa_query_sem_saida($Insere);
      if (!$Res) $Saida = false;
      else $Saida = $Res;
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_grupos_filas
  //---------------------------------------------------
  function insere_grupos_filas($Nome,$Fila) {
    $Nome = $this->Bd->limpa_query(trim($Nome));
    $Pes1 = "SELECT id FROM ".$this->TabelaG." WHERE nome='".$Nome."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if ($Res1) {
      $Pes2 = "SELECT id FROM ".$this->TabelaF." WHERE pseudonimo='".$Fila."'";
      $Res2 = $this->Bd->executa_query_com_saida($Pes2);
      if ($Res2) {
        $Insere = "INSERT INTO ".$this->TabelGF." (grupo,fila) VALUES (".$Res1[0]['id'].",".$Res2[0]['id'].")";
        $Res    = $this->Bd->executa_query_sem_saida($Insere);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
      }
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_grupos_filas
  //---------------------------------------------------
  function altera_grupos_filas($Nome,$Lista_Fila) {
    $Nome = $this->Bd->limpa_query(trim($Nome));
    $Pes1 = "SELECT id FROM ".$this->TabelaG." WHERE nome='".$Nome."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if ($Res1) {
      $Pes2 = "DELETE FROM ".$this->TabelGF." WHERE grupo='".$Res1[0]['id']."'";
      $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
      if ($Res2) {
        for ($x=0; $x<count($Lista_Fila); $x++) {
          $Saida = $this->insere_grupos_filas($Nome,$Lista_Fila[$x]);
        }
      }
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao estado_agentes
  // Saida = array(Situacao, Desde, Tipopausa/Com quem, Fila/Servico, Desde com data, Arquivo de gravao)
  //---------------------------------------------------
  function estado_agentes($Agente) {
    $Pes1 = "SELECT situacao, falandocom, tipopausa, EXTRACT(EPOCH FROM DATE_TRUNC('second',ult_estad)) as ultimo, fila, ramal FROM ".$this->TabelaA." WHERE login='".$Agente."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = array('','','','','','');
    else {
      $Situ = $Res1[0]['situacao'];
      //Le o nome do arquivo de gravacao
      if (($Situ == 'Chamando') || ($Situ == 'Fazendo chamada externa') || ($Situ == 'Em conversa&ccedil;&atilde;o')) {
//        if ($Res1[0]['ramal']>'!') {
          $Ramal = trim($Res1[0]['ramal']);
          $Pes2 = "SELECT gravacao_nova FROM ".$this->TabelLG." WHERE pa='".$Ramal."' OR numero_orig='".$Ramal."' OR numero_dest='".$Ramal."' AND estado!='Desligado' LIMIT 1";
          $Res2 = $this->Bd->executa_query_com_saida($Pes2);
          if (!$Res2) $Arquivograva = '';
          else  $Arquivograva = $Res2[0]['gravacao_nova'];
//        } else $Arquivograva = '';
      }
//      $Arquivograva = $Pes2;
      if ($Situ == 'NLogado')                          $Saida = array('Nao Logado','','','','','');
      elseif ($Situ == 'Livre')                        $Saida = array('Livre'                       ,date("H:i:s",$Res1[0]['ultimo']),'','','','');
      elseif ($Situ == 'Em Pausa')                     $Saida = array('Em Pausa'                    ,date("H:i:s",$Res1[0]['ultimo']),$Res1[0]['tipopausa'],'','','');
      elseif ($Situ == 'Chamando')                     $Saida = array('Chamando'                    ,date("H:i:s",$Res1[0]['ultimo']),$Res1[0]['falandocom'],$Res1[0]['fila'],date("d/m/y às H:i:s",$Res1[0]['ultimo']),$Arquivograva);
      elseif ($Situ == 'Fazendo chamada externa')      $Saida = array('Fazendo chamada externa'     ,date("H:i:s",$Res1[0]['ultimo']),$Res1[0]['falandocom'],$Res1[0]['fila'],date("d/m/y às H:i:s",$Res1[0]['ultimo']),$Arquivograva);
      elseif ($Situ == 'Em conversa&ccedil;&atilde;o') $Saida = array('Em conversa&ccedil;&atilde;o',date("H:i:s",$Res1[0]['ultimo']),$Res1[0]['falandocom'],$Res1[0]['fila'],date("d/m/y às H:i:s",$Res1[0]['ultimo']),$Arquivograva);
      elseif ($Situ == 'Monitorando PA')               $Saida = array('Monitorando PA'              ,date("H:i:s",$Res1[0]['ultimo']),$Res1[0]['falandocom'],'','','');
      else                                             $Saida = array('','','','','','');
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_agentes
  //---------------------------------------------------
  function lista_agentes($Ativo='') {
    $Pes1 = "SELECT * FROM ".$this->TabelaA." ORDER BY login";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else {
      //Grupos
      $Pes2 = "SELECT ".$this->TabelAG.".agente as id, ".$this->TabelaG.".nome as grupo FROM ".$this->TabelAG." INNER JOIN ".$this->TabelaG." ON ".$this->TabelAG.".grupo=".$this->TabelaG.".id";
      $Res2 = $this->Bd->executa_query_com_saida($Pes2);
      //Logins relacionados
      $Pes3 = "SELECT ".$this->TabelAL.".agente as id, ".$this->TabelaA.".login as login FROM ".$this->TabelAL." INNER JOIN ".$this->TabelaA." ON ".$this->TabelAL.".login=".$this->TabelaA.".id";
      $Res3 = $this->Bd->executa_query_com_saida($Pes3);
      //Turnos
      $Pes4 = "SELECT * FROM ".$this->TabelAT. " ORDER BY agente, id";
      $Res4 = $this->Bd->executa_query_com_saida($Pes4);

	  $Pes5 = "SELECT * FROM ".$this->TabelaR. " ORDER BY ramal";
      $Res5 = $this->Bd->executa_query_com_saida($Pes5);

      $Saida = array($Res1,$Res2,$Res3,$Res4,$Res5);

    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_agentes_para_troncos
  //---------------------------------------------------
  function lista_agentes_para_troncos($Ativo='') {
    $Pes1 = "SELECT * FROM ".$this->TabelaA." ORDER BY login";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else $Saida = array($Res1);
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao descobre_agente_pelo_ramal
  //---------------------------------------------------
  function descobre_agente_pelo_ramal($Ramal) {
    $Pes1 = "SELECT * FROM ".$this->TabelaA." WHERE ramal='".$Ramal."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else $Saida = $Res1;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao apaga_agentes
  //---------------------------------------------------
  function apaga_agentes($Identif) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    $Saida = true;
    $Apa = "DELETE FROM ".$this->TabelaA." WHERE id='".$Identif."'";
    $Res = $this->Bd->executa_query_sem_saida($Apa);
    if (!$Res) $Saida = false;
    else {
      $Pes = "SELECT id FROM ".$this->TabelAG." WHERE agente='".$Identif."'";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if ($Res) {
        $Apa = "DELETE FROM ".$this->TabelAG." WHERE agente='".$Identif."'";
        $Res = $this->Bd->executa_query_sem_saida($Apa);
        if (!$Res) $Saida = false;
      }
      $Pes = "SELECT id FROM ".$this->TabelAL." WHERE agente='".$Identif."'";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if ($Res) {
        $Apa = "DELETE FROM ".$this->TabelAL." WHERE agente='".$Identif."'";
        $Res = $this->Bd->executa_query_sem_saida($Apa);
        if (!$Res) $Saida = false;
      }
      $Pes = "SELECT id FROM ".$this->TabelAT." WHERE agente='".$Identif."'";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if ($Res) {
        $Apa = "DELETE FROM ".$this->TabelAT." WHERE agente='".$Identif."'";
        $Res = $this->Bd->executa_query_sem_saida($Apa);
        if (!$Res) $Saida = false;
      }
    }
    return $Saida;
  }


    //---------------------------------------------------
    // Funcao altera_agentes
    //---------------------------------------------------
    function altera_agentes(
        $Identif,
        $nome,
        $psed,
        $logi,
        $senh,
        $hor1,
        $hor2,
        $grup,
        $flog,
        $cont,
        $notificaPausaAuto, 
        $notificaDepoisDe, 
        $notificaLivreDepoisDe,
        $setarIpAstman,
        $ipAstman
    ) {
        $Identif2 = $this->Bd->limpa_query(trim($Identif));
        $nome    = $this->Bd->limpa_query(trim($nome));
        $psed    = $this->Bd->limpa_query(trim($psed));
        $logi    = $this->Bd->limpa_query(trim($logi));
        $senh    = $this->Bd->limpa_query(trim($senh));
        $grup    = $this->Bd->limpa_query(trim($grup));
        $flog    = $this->Bd->limpa_query(trim($flog));
        $cont	 = $this->Bd->limpa_query(trim($cont));
        ($notificaPausaAuto=='t') ? $notificaPausaAuto = "true" : $notificaPausaAuto = "false";
        ($setarIpAstman=='t') ? $setarIpAstman = "true" : $setarIpAstman = "false";


        $Pes = "SELECT id FROM ".$this->TabelaA." WHERE id='".$Identif."'";
        $Res = $this->Bd->executa_query_com_saida($Pes);
        
        if ($Res) {
            $Troca = "UPDATE ".$this->TabelaA." SET nome='".$nome."', pseudonimo='".$psed."', login='".$logi."', senha='".$senh."', horario1='".$hor1."', horario2='".$hor2."', grupo='".$grup."', grupos='".$grup."', funcai='".$flog."', contexto='".$cont."', notificapausaauto=".$notificaPausaAuto.", notificadepoisde=".$notificaDepoisDe.", notificalivredepoisde = ".$notificaLivreDepoisDe.", setar_ip_astman = '".$setarIpAstman."', ip_astman = '".$ipAstman."' WHERE id='".$Identif."'";
            $Res   = $this->Bd->executa_query_sem_saida($Troca);
            
            if (!$Res) $Saida = false;
            else $Saida = $Res;
        } else $Saida = false;
        
        return $Saida;
    }


  //---------------------------------------------------
  // Funcao altera_agentes_grupos
  //---------------------------------------------------
  function altera_agentes_grupos($Agente,$Grupo) {
    $Agente = $this->Bd->limpa_query(trim($Agente));
    $Pes1   = "SELECT id,grupo FROM ".$this->TabelaA." WHERE id='".$Agente."'";
    $Res1   = $this->Bd->executa_query_com_saida($Pes1);
    if ($Res1) {
      $Pes2 = "DELETE FROM ".$this->TabelAG." WHERE agente='".$Res1[0]['id']."'";
      $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
      $GrupS = $Res1[0]['grupo'];
      if (is_array($Grupo)) {
        for ($x=0; $x<count($Grupo); $x++) {
          if ($Grupo[$x] != $GrupS) {
            $Saida = $this->insere_agentes_grupos($Agente,$Grupo[$x]);
            $GrupS .= "||".$Grupo[$x];
          }
        }
      }
      $Troca = "UPDATE ".$this->TabelaA." SET grupos='".$GrupS."' WHERE id='".$Agente."'";
      $Res   = $this->Bd->executa_query_sem_saida($Troca);
      if (!$Res) $Saida = false;
      else $Saida = $Res;
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_agentes_logins
  //---------------------------------------------------
  function altera_agentes_logins($Agente,$Login) {
    $Pes1   = "SELECT id FROM ".$this->TabelaA." WHERE id='".$Agente."'";
    $Res1   = $this->Bd->executa_query_com_saida($Pes1);
    if ($Res1) {
      $Pes2 = "DELETE FROM ".$this->TabelAL." WHERE agente='".$Res1[0]['id']."'";
      $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
      if ($Res2) {
        $LoginR = "";
        for ($x=0; $x<count($Login); $x++) {
          $Saida = $this->insere_agentes_logins($Agente,$Login[$x]);
          if ($x>0) $LoginR .= "||";
          $LoginR .= $Login[$x];
        }
        $Troca = "UPDATE ".$this->TabelaA." SET loginr='".$LoginR."' WHERE id='".$Agente."'";
        $Res   = $this->Bd->executa_query_sem_saida($Troca);
        if (!$Res) $Saida = false;
        else $Saida;
      }
      else $Saida = false;
    }
    else $Saida = false;
    return $Saida;
  }


    //---------------------------------------------------
    // Funcao insere_agentes
    //---------------------------------------------------
    function insere_agentes(
        $nome,
        $psed,
        $logi,
        $senh,
        $hor1,
        $hor2,
        $grup,
        $flog,
        $cont,
        $notificaPausaAuto, 
        $notificaDepoisDe, 
        $notificaLivreDepoisDe,
        $setarIpAstman,
        $ipAstman
    ) {
        $nome = $this->Bd->limpa_query(trim($nome));
        $psed = $this->Bd->limpa_query(trim($psed));
        $logi = $this->Bd->limpa_query(trim($logi));
        $senh = $this->Bd->limpa_query(trim($senh));
        $grup = $this->Bd->limpa_query(trim($grup));
        $flog = $this->Bd->limpa_query(trim($flog));
        $cont    = $this->Bd->limpa_query(trim($cont));
        ($notificaPausaAuto=='t') ? $notificaPausaAuto = "true" : $notificaPausaAuto = "false";
        ($setarIpAstman=='t') ? $setarIpAstman = "true" : $setarIpAstman = "false";
        
        $Pes  = "SELECT id FROM ".$this->TabelaA." WHERE pseudonimo='".$psed."'";
        $Res  = $this->Bd->executa_query_com_saida($Pes);
        
        if (!$Res) {
            $Insere = "INSERT INTO ".$this->TabelaA." (nome,pseudonimo,login,senha,horario1,horario2,grupo,funcai,situacao,contexto,notificapausaauto,notificadepoisde,notificalivredepoisde,setar_ip_astman,ip_astman) VALUES ('".$nome."','".$psed."','".$logi."','".$senh."','".$hor1."','".$hor2."','".$grup."','".$flog."','NLogado','".$cont."', '".$notificaPausaAuto."', '".$notificaDepoisDe."', '".$notificaLivreDepoisDe."', '".$setarIpAstman."', '".$ipAstman."')";
            $Res    = $this->Bd->executa_query_sem_saida($Insere);
            
            if (!$Res) $Saida = false;
            else $Saida = $Res;
        } else $Saida = false;
        
        return $Saida;
    }


  //---------------------------------------------------
  // Funcao insere_agentes_grupos
  //---------------------------------------------------
  function insere_agentes_grupos($Agente,$Grupo) {
    $Pes1 = "SELECT id FROM ".$this->TabelaA." WHERE id='".$Agente."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if ($Res1) {
      $Pes2 = "SELECT * FROM ".$this->TabelaG." WHERE nome='".$Grupo."'";
      $Res2 = $this->Bd->executa_query_com_saida($Pes2);
      if ($Res2) {
        $Insere = "INSERT INTO ".$this->TabelAG." (agente,grupo) VALUES (".$Res1[0]['id'].",".$Res2[0]['id'].")";
        $Res    = $this->Bd->executa_query_sem_saida($Insere);
        if (!$Res) $Saida = false;
//        else {
//          $Troca = "INSERT INTO ".$this->TabelRG." (data, grupoid, grupo, agente, login, funcai) VALUES (CURRENT_TIMESTAMP,".$Res2[0]['id'].",'".$Grupo."','".$Agente."','".$Res2[0]['login']."','".$Res2[0]['funcai']."')";
//          $Res   = $this->Bd->executa_query_sem_saida($Troca);
//          if (!$Res) $Saida = false;
//          else $Saida = $Res;
//        }
      }
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_agentes_logins
  //---------------------------------------------------
  function insere_agentes_logins($Agente,$Login) {
    $Pes1 = "SELECT id FROM ".$this->TabelaA." WHERE id='".$Agente."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if ($Res1) {
        $Insere = "INSERT INTO ".$this->TabelAL." (agente,login) VALUES (".$Res1[0]['id'].",".$Login.")";
        $Res    = $this->Bd->executa_query_sem_saida($Insere);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_agentes_foto
  //---------------------------------------------------
  function insere_agentes_foto($Agente,$Arquivo) {
    $Saida = false;
    $Nome = $Arquivo['name'];
    $Tipo = $Arquivo['type'];
    $Tama = $Arquivo['size'];
    $Loca = $Arquivo['tmp_name'];
    move_uploaded_file($Loca, $this->Fotos.$Nome);
    if (file_exists($this->Fotos.$Nome)) $Saida = true;
    return $this->Fotos.$Loca;
  }



  //---------------------------------------------------
  // Funcao insere_agentes_turnos
  //---------------------------------------------------
  function insere_agentes_turnos($NomeAgente,$Turnos) {
    //Arruma turnos
    $Pes = "SELECT id FROM ".$this->TabelaA." WHERE nome='".$NomeAgente."'";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else {
      $Agente = $Res[0]['id'];
      $Diasem["dom"] = '1'; $Diasem["seg"] = '2'; $Diasem["ter"] = '3'; $Diasem["qua"] = '4'; $Diasem["qui"] = '5'; $Diasem["sex"] = '6'; $Diasem["sab"] = '7';
      $Arrumado = $Indice = array();
      for ($x=1; $x<=count($Turnos); $x++) {
        $Arrumado[] = $Diasem[$Turnos[$x]['ds']] + $Turnos[$x]['de'] + $Turnos[$x]['aa'];
        $Indice[]   = $x;
      }
      array_multisort($Arrumado, $Indice);
      $Pes = "SELECT id FROM ".$this->TabelAT." WHERE agente = ".$Agente;
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if ($Res) {
        $Apaga = "DELETE FROM ".$this->TabelAT." WHERE agente = ".$Agente;
        $Res   = $this->Bd->executa_query_sem_saida($Apaga);
        if (!$Res) return false;
      }
      for ($x=1; $x<=count($Indice); $x++) {
        $Pos = $Indice[$x-1];
        $Insere = "INSERT INTO ".$this->TabelAT." (agente, dia_sem, de, aa, nom) VALUES (".$Agente.",'".$Turnos[$Pos]['ds']."', '".$Turnos[$Pos]['de']."', '".$Turnos[$Pos]['aa']."', '".$Turnos[$Pos]['no']."')";
        $Res    = $this->Bd->executa_query_sem_saida($Insere);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_filas
  // Data Modificacao: 05/04/2011
  // Descricao: Incluido pesquisa da tabela Usuario_Grupo
  //            em $Res5
  //---------------------------------------------------
  function lista_filas($Ativo='',$Grupo='',$Usuar=0) {
	$Pes1 = "SELECT * FROM ".$this->TabelaF;
	if ($Grupo!="") {
	  $Pes3 = "SELECT id FROM ".$this->TabelaG." WHERE nome='".$Grupo."'";
	  $Res3 = $this->Bd->executa_query_com_saida($Pes3);
	  $Pes1.= " INNER JOIN ".$this->TabelGF." ON ".$this->TabelaF.".id=".$this->TabelGF.".fila WHERE ".$this->TabelGF.".grupo='".$Res3[0]['id']."' ";
	}
	$Pes1.= " ORDER BY ".$this->TabelaF.".nome";
	$Res1 = $this->Bd->executa_query_com_saida($Pes1);
	if (!$Res1) $Saida = false;
	else {
	//Agentes
	  $Pes  = "SELECT ".$this->TabelFA.".fila as id, ".$this->TabelaA.".pseudonimo as agente, ".$this->TabelaA.".login as login FROM ".$this->TabelFA." INNER JOIN ".$this->TabelaA." ON ".$this->TabelFA.".agente=".$this->TabelaA.".id ORDER BY ".$this->TabelFA.".fila, ".$this->TabelaA.".login";
	  $Res2 = $this->Bd->executa_query_com_saida($Pes);
	  $Pes  = "SELECT fr.fila as id, r.ramal as login FROM vm50_filas_ramais as fr INNER JOIN vm50_ramais as r ON r.id = fr.ramal ORDER BY fr.fila, r.ramal";
	  $ResAux2 = $this->Bd->executa_query_com_saida($Pes);
	  //foreach($ResAux2 as $valor) $Res2[] = $valor;
	  for($i = 0; $i < count($Res2); $i++) $AuxRes2[$Res2[$i]['id']][] = $Res2[$i]['login'];
	  for($i = 0; $i < count($ResAux2); $i++) $AuxRes2[$ResAux2[$i]['id']][] = $ResAux2[$i]['login'];
	  $Res2 = $AuxRes2;
	  ksort($Res2);
	  $j = 0;
	  foreach($Res2 as $chave => $valor){
		for($i = 0; $i < count($valor); $i++){
			$SaidaAux[$j]['id'] = $chave;
			$SaidaAux[$j]['login'] = $valor[$i];
			$j++;
		}
	  }
	  $Res2 = $SaidaAux;

//      if (!$Res2) $Saida =array($Res1);
//      else {
	  //Turnos
		$Pes  = "SELECT * FROM ".$this->TabelFT. " ORDER BY fila, id";
		$Res3 = $this->Bd->executa_query_com_saida($Pes);
//        if (!$Res3) $Saida = array($Res1,$Res2);
 //       else {
		//Grades
		  $Pes  = "SELECT * FROM ".$this->TabelFG. " ORDER BY fila, tipo";
		  $Res4 = $this->Bd->executa_query_com_saida($Pes);

		  $Pes  = "SELECT ".$this->TabelFA.".fila as id, ".$this->TabelaR.".pseudonimo as nome, ".$this->TabelaR.".ramal as ramal FROM ".$this->TabelFA." INNER JOIN ".$this->TabelaR." ON ".$this->TabelFA.".agente=".$this->TabelaR.".id "; //ORDER BY ".$this->TabelFA.".fila, ".$this->TabelaR.".ramal";
          $Res6 = $this->Bd->executa_query_com_saida($Pes);
		  if($Grupo == ""){
			  $Pes  = "SELECT distinct ".$this->TabelaF.".pseudonimo FROM ".$this->TabelUG." INNER JOIN ";
			  $Pes .= $this->TabelaG." on ".$this->TabelUG.".grupo = ".$this->TabelaG.".id INNER JOIN ";
			  $Pes .= $this->TabelGF." on ".$this->TabelaG.".id = ".$this->TabelGF.".grupo INNER JOIN ";
			  $Pes .= $this->TabelaF." on ".$this->TabelGF.".fila = ".$this->TabelaF.".id WHERE ".$this->TabelUG.".usuario =".$Usuar;
			  $Res5 = $this->Bd->executa_query_com_saida($Pes);
		  }
 //         if (!$Res4) $Saida = array($Res1,$Res2,$Res3);
 //         else $Saida = array($Res1,$Res2,$Res3,$Res4);
		  $Saida = array($Res1,$Res2,$Res3,$Res4,$Res5,$Res6);
//        }
//      }
	}
    return $Saida;
  }



  //---------------------------------------------------
  // Funcao lista_filas_para_monitoramento
  // Data Modificacao: 05/04/2011
  // Descricao: Incluido pesquisa da tabela Usuario_Grupo
  //            em $Res5
  //---------------------------------------------------
  function lista_filas_para_monitoramento($Ativo='',$Grupo='',$Usuar=0) {
    if($Grupo == "") {
      $Pes  = "SELECT distinct ".$this->TabelaF.".pseudonimo FROM ".$this->TabelUG." INNER JOIN ";
      $Pes .= $this->TabelaG." on ".$this->TabelUG.".grupo = ".$this->TabelaG.".id INNER JOIN ";
      $Pes .= $this->TabelGF." on ".$this->TabelaG.".id = ".$this->TabelGF.".grupo INNER JOIN ";
      $Pes .= $this->TabelaF." on ".$this->TabelGF.".fila = ".$this->TabelaF.".id WHERE ".$this->TabelUG.".usuario =".$Usuar;
      $Saida = $this->Bd->executa_query_com_saida($Pes);
    } else {
		$Pes1 = "SELECT g.nome as grupo, f.pseudonimo FROM vm50_grupos_filas as gf INNER JOIN vm50_grupos as g ";
		$Pes1.= "ON gf.grupo = g.id INNER JOIN vm50_filas as f ON f.id = gf.fila WHERE g.nome LIKE '".$Grupo."'";
      //$Pes1 = "SELECT pseudonimo FROM ".$this->TabelaF;
      //$Pes1.= " ORDER BY ".$this->TabelaF.".nome";
      $Saida = $this->Bd->executa_query_com_saida($Pes1);
    }
    return $Saida;
  }




  //---------------------------------------------------
  // Funcao apaga_filas
  //---------------------------------------------------
  function apaga_filas($Identif) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    $Saida = true;
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Apa = "DELETE FROM ".$this->TabelaF." WHERE id=".$Identif;
      $Res = $this->Bd->executa_query_sem_saida($Apa);
      if (!$Res) $Saida = false;
      else {
        $Apa = "DELETE FROM ".$this->TabelFA." WHERE fila=".$Identif;
        $Res = $this->Bd->executa_query_sem_saida($Apa);
        $Apa = "DELETE FROM ".$this->TabelFT." WHERE fila=".$Identif;
        $Res = $this->Bd->executa_query_sem_saida($Apa);
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_filas
  //---------------------------------------------------
  function altera_filas($Identif,$nomef,$psedo,$numer,$tronc,$estra,$music,$timeo,$retry,$maxle,$weigh,$wrapu,$mdela,$timer,$autof,$sintf,$annfr,$annpe,$annht,$annrs,$ringi,$joine,$leave,$evwca,$evmbs,$tmini,$tmaxi,$tmaxe,$qmaxe,$qmaxr,$compo,$epaut,$tipau,$tempp,$vsupe,$direc,$tadic,$tmine,$mrela) {
    $Identif = trim($Identif);
	if($qmaxr=='') $qmaxr=0;
	if($qmaxe=='') $qmaxe=0;
	if($tmaxe=='') $tmaxe=0;
	if($tmaxi=='') $tmaxi=0;
	if($tmini=='') $tmini=0;
	if($tempp=='') $tempp=0;
    $Troca   = "UPDATE ".$this->TabelaF." SET nome='".$nomef."', pseudonimo='".$psedo."', numero='".$numer."', tronco='".$tronc."', estrategia='".$estra."', musica='".$music."', timeout='".$timeo."', tentardenovo='".$retry."', limitedafila='".$maxle."', prioridade='".$weigh."', delaydeencaminhamento='".$wrapu."', delaydeatendimento='".$mdela."', resetatimeout='".$timer."', distribuicaodacparalela='".$autof."', setavariavel='".$sintf."', anundeposicaonafila='".$annfr."', anunperiodicos='".$annpe."', anunesperaestimada='".$annht."', anundesegundos='".$annrs."', segchamadanapa='".$ringi."', entradafilasemmembros='".$joine."', removechamsesemmembros='".$leave."', geraeventochamagente='".$evwca."', geraeventomembstatus='".$evmbs."', tempominconvatend='".$tmini."', tempomaxconvatend='".$tmaxi."', tempomaxespeatend='".$tmaxe."', qtdemaxchamafilaesp='".$qmaxe."', qtdemaxchamarecebid='".$qmaxr."', dinamica='".$compo."', entrarpausaauto='".$epaut."', pausaautomatica='".$tipau."', tempodepausa='".$tempp."', visivelsupervisao='".$vsupe."', direcao='".$direc."', tempoadidional=".$tadic.", tempominespera=".$tmine.", mostrarrelplansimp = '".$mrela."' WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Troca;
  }


  //---------------------------------------------------
  // Funcao altera_filas_agentes
  //---------------------------------------------------
  function altera_filas_agentes($Fila,$Agente) {
	$Saida = true;
    $Fila = $this->Bd->limpa_query(trim($Fila));
    $Pes1 = "SELECT id FROM ".$this->TabelaF." WHERE nome='".$Fila."'";
    $Res1  = $this->Bd->executa_query_com_saida($Pes1);
    if ($Res1) {
	  for ($x=0; $x<count($Agente); $x++) {
		$Pes3 = "SELECT id FROM ".$this->TabelaA." WHERE login = '".$Agente[$x]."'";
		$Res3 = $this->Bd->executa_query_com_saida($Pes3);
		//Pega o penalty
		$Pes4 = "SELECT id, penalty FROM ".$this->TabelFA." WHERE fila = ".$Res1[0]['id']." AND agente = ".$Res3[0]['id'];
		$Res4 = $this->Bd->executa_query_com_saida($Pes4);
		//Deleta os registros
		$Pes2 = "DELETE FROM ".$this->TabelFA." WHERE id='".$Res4[0]['id']."'";
      	$Res2 = $this->Bd->executa_query_sem_saida($Pes2);
		//Insere os registros
		$Saida = $this->insere_filas_agentes($Fila,$Agente[$x],$Res4[0]['penalty']);
		$Saida1 .= $Agente[$x]." ... ";
	  }
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_filas
  //---------------------------------------------------
  function insere_filas($nomef,$psedo,$numer,$tronc,$estra,$music,$timeo,$retry,$maxle,$weigh,$wrapu,$mdela,$timer,$autof,$sintf,$annfr,$annpe,$annht,$annrs,$ringi,$joine,$leave,$evwca,$evmbs,$tmini,$tmaxi,$tmaxe,$qmaxe,$qmaxr,$compo,$epaut,$tipau,$tempp,$vsupe,$direc,$tadic,$tmine) {
    $Pes  = "SELECT id FROM ".$this->TabelaF." WHERE nome='".$nomef."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
    $Insere = "INSERT INTO ".$this->TabelaF." (nome,pseudonimo,numero,tronco,estrategia,musica,timeout,tentardenovo,limitedafila,prioridade,delaydeencaminhamento,delaydeatendimento,resetatimeout,distribuicaodacparalela,setavariavel,anundeposicaonafila,anunperiodicos,anunesperaestimada,anundesegundos,segchamadanapa,entradafilasemmembros,removechamsesemmembros,geraeventochamagente,geraeventomembstatus,tempominconvatend,tempomaxconvatend, tempomaxespeatend,qtdemaxchamafilaesp,qtdemaxchamarecebid,dinamica,entrarpausaauto,pausaautomatica,tempodepausa,visivelsupervisao,direcao,tempoadidional,tempominespera) VALUES ('".$nomef."','".$psedo."','".$numer."','".$tronc."','".$estra."','".$music."',".$timeo.",".$retry.",".$maxle.",".$weigh.",".$wrapu.",".$mdela.",'".$timer."','".$autof."','".$sintf."',".$annfr.",".$annpe.",'".$annht."',".$annrs.",'".$ringi."','".$joine."','".$leave."','".$evwca."','".$evmbs."',".$tmini.",".$tmaxi.",".$tmaxe.",".$qmaxe.",".$qmaxr.",'".$compo."','".$epaut."','".$tipau."','".$tempp."','".$vsupe."','".$direc."',".$tadic.",".$tmine.")";
		//$_SESSION["Debug"] = $Insere;
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      if (!$Res) $Saida = false;
      else $Saida = $Res;
    }
    else
        $Saida = $Pes;
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao insere_filas_grades
  //---------------------------------------------------
  function insere_filas_grades($Fila,$Esperas,$Desistencias,$Queue,$Atendimentos) {
    $Pes1 = "SELECT id FROM ".$this->TabelaF." WHERE nome='".$Fila."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if ($Res1) {
      $Apaga = "DELETE FROM ".$this->TabelFG." WHERE fila=".$Res1[0]['id'];
      $Res   = $this->Bd->executa_query_sem_saida($Apaga);
      $Insere = "INSERT INTO ".$this->TabelFG." (fila,tipo,pos01,pos02,pos03,pos04,pos05,pos06,pos07,pos08,pos09,pos10,pos11,pos12,pos13,pos14,pos15,pos16,pos17,pos18,pos19,pos20) VALUES (".$Res1[0]['id'].",'esperas',".$Esperas[0].",".$Esperas[1].",".$Esperas[2].",".$Esperas[3].",".$Esperas[4].",".$Esperas[5].",".$Esperas[6].",".$Esperas[7].",".$Esperas[8].",".$Esperas[9].",".$Esperas[10].",".$Esperas[11].",".$Esperas[12].",".$Esperas[13].",".$Esperas[14].",".$Esperas[15].",".$Esperas[16].",".$Esperas[17].",".$Esperas[18].",".$Esperas[19].")";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      if ($Res) {
        $Insere = "INSERT INTO ".$this->TabelFG." (fila,tipo,pos01,pos02,pos03,pos04,pos05,pos06,pos07,pos08,pos09,pos10,pos11,pos12,pos13,pos14,pos15,pos16,pos17,pos18,pos19,pos20) VALUES (".$Res1[0]['id'].",'desistencias',".$Desistencias[0].",".$Desistencias[1].",".$Desistencias[2].",".$Desistencias[3].",".$Desistencias[4].",".$Desistencias[5].",".$Desistencias[6].",".$Desistencias[7].",".$Desistencias[8].",".$Desistencias[9].",".$Desistencias[10].",".$Desistencias[11].",".$Desistencias[12].",".$Desistencias[13].",".$Desistencias[14].",".$Desistencias[15].",".$Desistencias[16].",".$Desistencias[17].",".$Desistencias[18].",".$Desistencias[19].")";
        $Res    = $this->Bd->executa_query_sem_saida($Insere);
        if ($Res) {
          $Insere = "INSERT INTO ".$this->TabelFG." (fila,tipo,pos01,pos02,pos03,pos04,pos05,pos06,pos07,pos08,pos09,pos10,pos11,pos12,pos13,pos14,pos15,pos16,pos17,pos18,pos19,pos20) VALUES (".$Res1[0]['id'].",'queue',".$Queue[0].",".$Queue[1].",".$Queue[2].",".$Queue[3].",".$Queue[4].",".$Queue[5].",".$Queue[6].",".$Queue[7].",".$Queue[8].",".$Queue[9].",".$Queue[10].",".$Queue[11].",".$Queue[12].",".$Queue[13].",".$Queue[14].",".$Queue[15].",".$Queue[16].",".$Queue[17].",".$Queue[18].",".$Queue[19].")";
          $Res    = $this->Bd->executa_query_sem_saida($Insere);
          if ($Res) {
            $Insere = "INSERT INTO ".$this->TabelFG." (fila,tipo,pos01,pos02,pos03,pos04,pos05,pos06,pos07,pos08,pos09,pos10,pos11,pos12,pos13,pos14,pos15,pos16,pos17,pos18,pos19,pos20) VALUES (".$Res1[0]['id'].",'atendimentos',".$Atendimentos[0].",".$Atendimentos[1].",".$Atendimentos[2].",".$Atendimentos[3].",".$Atendimentos[4].",".$Atendimentos[5].",".$Atendimentos[6].",".$Atendimentos[7].",".$Atendimentos[8].",".$Atendimentos[9].",".$Atendimentos[10].",".$Atendimentos[11].",".$Atendimentos[12].",".$Atendimentos[13].",".$Atendimentos[14].",".$Atendimentos[15].",".$Atendimentos[16].",".$Atendimentos[17].",".$Atendimentos[18].",".$Atendimentos[19].")";
            $Res    = $this->Bd->executa_query_sem_saida($Insere);
            $Saida  = $Res;
          }
          else $Saida = false;
        }
        else $Saida = false;
      }
      else $Saida = false;
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_filas_agentes
  //---------------------------------------------------
  function insere_filas_agentes($Fila,$Agente,$Penalty=0) {
    $Pes1 = "SELECT id FROM ".$this->TabelaF." WHERE nome='".$Fila."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if ($Res1) {
      $Pes2 = "SELECT id FROM ".$this->TabelaA." WHERE login='".$Agente."'";
      $Res2 = $this->Bd->executa_query_com_saida($Pes2);
      if ($Res2) {
        $Insere = "INSERT INTO ".$this->TabelFA." (fila,agente,penalty) VALUES (".$Res1[0]['id'].",".$Res2[0]['id'].",".$Penalty.")";
        $Res    = $this->Bd->executa_query_sem_saida($Insere);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
      } else {
		$Pes2 = "SELECT id FROM ".$this->TabelaR." WHERE ramal = '".trim($Agente)."'";
		$Res2 = $this->Bd->executa_query_com_saida($Pes2);
		if($Res2){
			$Insere = "INSERT INTO vm50_filas_ramais (fila,ramal,penalty) VALUES (".$Res1[0]['id'].",".$Res2[0]['id'].",".$Penalty.")";
			$Res    = $this->Bd->executa_query_sem_saida($Insere);
			if (!$Res) $Saida = false;
			else $Saida = $Res;
		}
	  }
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_membros_filas
  //---------------------------------------------------
  function lista_membros_filas($Fila,$Ativo='') {
    $Pes = "SELECT ".$this->TabelFA.".membername ,".$this->TabelFA.".queue_name,".$this->TabelaA.".nome FROM ".$this->TabelFA." INNER JOIN ".$this->TabelaA." ON ".$this->TabelaA.".login=".$this->TabelFA.".membername WHERE ".$this->TabelFA.".queue_name='".$Fila."' ORDER BY ".$this->TabelFA.".membername";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao apaga_membros_filas
  //---------------------------------------------------
  function apaga_membros_filas($Fila,$Membro) {
    $Apa = "DELETE FROM ".$this->TabelFA." WHERE membername='".$Membro."' AND queue_name='".$Fila."'";
    $Res = $this->Bd->executa_query_sem_saida($Apa);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_membros_filas
  //---------------------------------------------------
  function insere_membros_filas($Fila,$Membro) {
    $Pes = "SELECT id FROM ".$this->TabelaF." WHERE nome='".$Fila."'";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else {
      $Pes = "SELECT id FROM ".$this->TabelaA." WHERE login='".$Membro."'";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) $Saida = false;
      else {
        $Pes = "SELECT id FROM ".$this->TabelFA." WHERE membername='".$Membro."' AND queue_name='".$Fila."'";
        $Res = $this->Bd->executa_query_com_saida($Pes);
        if (!$Res) {
          $Insere = "INSERT INTO ".$this->TabelFA." (membername,queue_name) VALUES ('".$Membro."','".$Fila."')";
          $Res    = $this->Bd->executa_query_sem_saida($Insere);
          if (!$Res) $Saida = false;
          else $Saida = $Res;
        }
        else $Saida = false;
      }
    }
    return $Saida;
  }



  //---------------------------------------------------
  // Funcao insere_filas_turnos
  //---------------------------------------------------
  function insere_filas_turnos($NomeFila,$Turnos) {
    //Arruma turnos
    $Pes = "SELECT id FROM ".$this->TabelaF." WHERE nome='".$NomeFila."'";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else {
      $Fila = $Res[0]['id'];
      $Diasem["dom"] = '1'; $Diasem["seg"] = '2'; $Diasem["ter"] = '3'; $Diasem["qua"] = '4'; $Diasem["qui"] = '5'; $Diasem["sex"] = '6'; $Diasem["sab"] = '7';
      $Arrumado = $Indice = array();
      for ($x=1; $x<=count($Turnos); $x++) {
        $Arrumado[] = $Diasem[$Turnos[$x]['ds']] . $Turnos[$x]['de'] . $Turnos[$x]['aa'];
        $Indice[]   = $x;
      }
      array_multisort($Arrumado, $Indice);
      $Pes = "SELECT id FROM ".$this->TabelFT." WHERE fila = ".$Fila;
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if ($Res) {
        $Apaga = "DELETE FROM ".$this->TabelFT." WHERE fila = ".$Fila;
        $Res   = $this->Bd->executa_query_sem_saida($Apaga);
        if (!$Res) return false;
      }
      for ($x=1; $x<=count($Indice); $x++) {
        $Pos = $Indice[$x-1];
        $Insere = "INSERT INTO ".$this->TabelFT." (fila, dia_sem, de, aa, nom) VALUES (".$Fila.",'".$Turnos[$Pos]['ds']."', '".$Turnos[$Pos]['de']."', '".$Turnos[$Pos]['aa']."', '".$Turnos[$Pos]['no']."')";
        $Res    = $this->Bd->executa_query_sem_saida($Insere);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
      }
    }
    return $Saida;
  }



  //---------------------------------------------------
  // Funcao lista_filas_turnos_por_fila
  // Diasem = dom, seg, ter...
  // Tipo = fha ou ha
  //---------------------------------------------------
  function lista_filas_turnos_por_fila($NomeFila,$Diasem,$Tipo='ha') {
    //Arruma turnos
    $Pes = "SELECT id FROM ".$this->TabelaF." WHERE nome='".$NomeFila."'";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else {
      $Fila = $Res[0]['id'];
      $Pes = "SELECT * FROM ".$this->TabelFT." WHERE fila=".$Fila." AND dia_sem='".$Diasem."' AND nom='".$Tipo."'";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) $Saida = false;
      else $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_periodos
  //---------------------------------------------------
  function lista_periodos($Ativo='') {
    $Pes = "SELECT * FROM ".$this->TabelaD." ORDER BY perd";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao salva_periodos
  //---------------------------------------------------
  function salva_periodos($Dados,$Quantidade) {
    $Pes = "DELETE FROM ".$this->TabelaD."";
    $Res = $this->Bd->executa_query_sem_saida($Pes);
    for ($x=0; $x<$Quantidade+1; $x++) {
      $Ped = trim($Dados['ppd_'.sprintf('%03d',$x)]);
      $Pea = trim($Dados['ppa_'.sprintf('%03d',$x)]);
      if (($Ped>"") && ($Pea>"")) {
        $Insere = "INSERT INTO ".$this->TabelaD." (perd, pera) VALUES ('".$Ped."','".$Pea."')";
        $Res = $this->Bd->executa_query_sem_saida($Insere);
        if ($Saida) $Saida = $Res;
      }
    }
    return true;
  }


  //---------------------------------------------------
  // Funcao apaga_periodo
  //---------------------------------------------------
  function apaga_periodo($Identif) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    $Saida = true;
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Apa = "DELETE FROM ".$this->TabelaD." WHERE id='".$Identif."'";
      $Res = $this->Bd->executa_query_sem_saida($Apa);
      $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_pausas
  //---------------------------------------------------
  function lista_pausas($Ativo='') {
    $Pes = "SELECT * FROM ".$this->TabelaP." ORDER BY nome";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao apaga_pausas
  //---------------------------------------------------
  function apaga_pausas($Identif) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    $Saida = true;
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Apa = "DELETE FROM ".$this->TabelaP." WHERE id='".$Identif."'";
      $Res = $this->Bd->executa_query_sem_saida($Apa);
      $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_pausas
  //---------------------------------------------------
  function altera_pausas($Identif,$Nome,$Maximo,$Tipo,$RetirarAuto,$TempoRetirada,$CorMonitPa,$HabilitaParaPa) {
    $Identif = trim($Identif);
    $Troca   = "UPDATE ".$this->TabelaP." SET nome='".$Nome."', tempomax='".$Maximo."', tipo='".$Tipo."', retirarauto='".$RetirarAuto."', temporetirada='".$TempoRetirada."', cormonitpa = '".$CorMonitPa."', habilitaparapa = '".$HabilitaParaPa."' WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_pausas
  //---------------------------------------------------
  function insere_pausas($Nome,$Maximo,$Tipo,$RetirarAuto,$TempoRetirada,$CorMonitPa,$HabilitaParaPa) {
    $Pes  = "SELECT id FROM ".$this->TabelaP." WHERE nome='".$Nome."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO ".$this->TabelaP." (nome, tempomax, tipo, retirarauto, temporetirada, cormonitpa, habilitaparapa) VALUES ('".$Nome."','".$Maximo."','".$Tipo."', '".$RetirarAuto."', '".$TempoRetirada."', '".$CorMonitPa."', '".$HabilitaParaPa."')";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      $Saida  = $Res;
    }
    else $Saida = false;
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao lista_classificacao_chamadas
  //---------------------------------------------------
  function lista_classificacao_chamadas($Ativo='') {
    $Pes = "SELECT * FROM ".$this->TabelCC." WHERE id_pai = 0 ORDER BY nome";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao apaga_classificacao_chamadas
  //---------------------------------------------------
  function apaga_classificacao_chamadas($Identif) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    $Saida = true;
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Apa = "DELETE FROM ".$this->TabelCC." WHERE id='".$Identif."'";
      $Res = $this->Bd->executa_query_sem_saida($Apa);
      $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_classificacao_chamadas
  //---------------------------------------------------
  function altera_classificacao_chamadas($Identif,$Nome) {
    $Identif = trim($Identif);
    $Troca   = "UPDATE ".$this->TabelCC." SET nome='".$Nome."' WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_classificacao_chamadas
  //---------------------------------------------------
  function insere_classificacao_chamadas($Nome) {
    $Pes  = "SELECT id FROM ".$this->TabelCC." WHERE nome='".$Nome."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO ".$this->TabelCC." (nome) VALUES ('".$Nome."')";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      $Saida  = $Res;
    }
    else $Saida = false;
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao lista_subclassificacao_chamadas
  //---------------------------------------------------
  function lista_subclassificacao_chamadas($Ativo='') {
    $Pes = "SELECT * FROM ".$this->TabelCC." WHERE id_pai != 0 ORDER BY nome";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    $Saida = $Res;
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao lista_subclassificacao_chamadas
  //---------------------------------------------------
  function lista_subclassificacao_chamadas_por_grupo($idGrupo) {
    $Pes = "SELECT * FROM ".$this->TabelCC." WHERE id_pai = ".$idGrupo." ORDER BY nome";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    $Saida = $Res;
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao insere_subclassificacao_chamadas
  //---------------------------------------------------
  function insere_subclassificacao_chamadas($Nome, $idPai) {
    $Pes  = "SELECT id FROM ".$this->TabelCC." WHERE nome='".$Nome."' AND id_pai = ".$idPai;
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO ".$this->TabelCC." (nome, id_pai) VALUES ('".$Nome."', ".$idPai.")";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      $Saida  = $Res;
    }
    else $Saida = false;
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao altera_subclassificacao_chamadas
  //---------------------------------------------------
  function altera_subclassificacao_chamadas($Identif, $Nome, $idPai) {
    $Identif = trim($Identif);
    $Troca   = "UPDATE ".$this->TabelCC." SET nome='".$Nome."', id_pai = ".$idPai." WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Saida = $Res;
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao le_ramais
  //---------------------------------------------------
  function le_ramais() {
    $Pes       = "DELETE FROM ".$this->TabelaR;
    $Res       = $this->Bd->executa_query_com_saida($Pes);
    $Resultado = $this->Meia->envia_socket("Action: SIPpeers\r\n\r\n");
    if (!$Resultado) return false;
    //Verifica se estah OK
    $Aux = explode(":",$Resultado[0]);
    if (trim($Aux[1])!="Success") $Saida = false;
    else {
      for ($x=1; $x<count($Resultado); $x++){
        $Aux = explode(":",$Resultado[$x]);
        $Aux[0] = trim($Aux[0]);
        if ($Aux[0]=="ObjectName") $Ramal = trim($Aux[1]);
        if ($Aux[0]=="IPaddress")  $this->grava_ramal($Ramal,trim($Aux[1]));
      }
      $Saida = true;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao grava_ramal
  //---------------------------------------------------
  function grava_ramal($Ramal,$Ender) {
    $Ramal = trim($Ramal);
    if ( is_numeric($Ramal) && (strlen($Ramal)==4) ) {
      $Pes  = "SELECT id FROM ".$this->TabelaR." WHERE ramal='".$Ramal."'";
      $Res  = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) {
        $Insere = "INSERT INTO ".$this->TabelaR." (ramal,endereco) VALUES ('".$Ramal."', '".$Ender."')";
        $Res    = $this->Bd->executa_query_sem_saida($Insere);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
      }
      else {
        $Identif = $Res[0]['id'];
        $Troca = "UPDATE ".$this->TabelaR." SET endereco='".$Ender."' WHERE id='".$Identif."'";
        $Res   = $this->Bd->executa_query_sem_saida($Troca);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao que_ramal_eu_sou
  //---------------------------------------------------
  function que_ramal_eu_sou() {
    $Ender = $_SERVER['REMOTE_ADDR'];
    $Pes  = "SELECT ramal FROM ".$this->TabelaR." WHERE endereco='".$Ender."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = 0;
    else $Saida = $Res[0]['ramal'];
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao carrega_agents_conf
  //---------------------------------------------------
  function carrega_agents_conf(){
    $Nome_Arquivo = "/etc/asterisk/agents.conf";
    $Arq   = fopen($Nome_Arquivo, 'r');
    $Linha = fgets($Arq);
    $Saida = false;
    while ($Linha) {
      $Linha = $this->limpa_texto($Linha);
      if ($Linha[0] == "[")  $Nada = '';
      elseif ($Linha[0] == ";") $Nada = '';
      elseif (strtolower(substr($Linha,0,5)) == "agent") {
        list($Nada,$Aux) = explode("=>", $Linha);
        list($Login,$Senha,$Nome) = explode(",", $Aux);
        $Login = $this->limpa_texto($Login);
        $Senha = $this->limpa_texto($Senha);
        $Nome  = $this->limpa_texto($Nome);
        $Saida = $this->grava_agente($Login,$Nome,$Senha)."<br>";
      }
      elseif ($Linha != "") $Nada = '';
      $Linha = fgets($Arq);
    }
    fclose($Arq);
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao grava_agente
  //---------------------------------------------------
  function grava_agente($Agente,$Nome,$Senha) {
    $Agente = trim($Agente);
    if ( is_numeric($Agente) && (strlen($Agente)==4) ) {
      $Pes  = "SELECT id FROM ".$this->TabelaA." WHERE login='".$Agente."'";
      $Res  = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) {
        $Insere = "INSERT INTO ".$this->TabelaA." (login,nome,pseudonimo,senha,situacao,pausa) VALUES ('".$Agente."', '".$Nome."', '".$Nome."', '".$Senha."','NLogado','0')";
        $Res    = $this->Bd->executa_query_sem_saida($Insere);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
      }
      else {
        $Identif = $Res[0]['id'];
        $Troca = "UPDATE ".$this->TabelaA." SET senha='".$Senha."', pseudonimo='".$Nome."', situacao='NLogado', pausa='0' WHERE id='".$Identif."'";
        $Res   = $this->Bd->executa_query_sem_saida($Troca);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao carrega_filas
  //---------------------------------------------------
  function carrega_filas(){
    $Nome_Arquivo = "/etc/asterisk/queues.conf";
    $Arq   = fopen($Nome_Arquivo, 'r');
    $Linha = fgets($Arq);
    $Fila  = array();
    $Saida = false;
    $FilaM = array();
    while ($Linha) {
      $Linha = $this->limpa_texto($Linha);
      if ($Linha[0] == "[") {
        $Valor = str_replace("[", "", $Linha);
        $Valor = str_replace("]", "", $Valor);
        $Valor = $this->limpa_texto($Valor);
        if ($Fila['nome'] > "!") {
          $Saida = $this->grava_fila($Fila);
          unset($Fila);
          $Fila = array();
        }
        $Fila['nome'] = $Valor;
      }
      elseif ($Linha[0] == ";") $Nada = '';
      elseif (strtolower(substr($Linha,0,6)) == "member") {
        list($Nada,$Aux)   = explode("=>", $Linha);
        list($Nada,$Login) = explode("/", $Aux);
        $Login = $this->limpa_texto($Login);
        $FilaM[] = $Fila['nome']."filacomoagente".$Login;
      }
      elseif ($Linha != "") {
        list($Campo,$Valor) = explode ("=", $Linha);
        $Campo = $this->limpa_texto($Campo);
        $Valor = $this->limpa_texto($Valor);
        $Fila[$Campo] = $Valor;
      }
      $Linha = fgets($Arq);
    }
    fclose($Arq);
    $Saida = $this->grava_fila($Fila);
    $Cas = $FilaM."<br>";
    $Cas = count($FilaM)."<br>";
    for ($x=0; $x<count($FilaM); $x++) {
      list ($Ff, $Aa) = explode ('filacomoagente', $FilaM[$x]);
      $Cas .= $Ff."=".$Aa."<br>";
      $Saida = $this->grava_membro($Ff,$Aa);
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao limpa_texto
  //---------------------------------------------------
  function limpa_texto($Texto) {
    $Aux = trim($Texto);
    $Aux = str_replace("\n", "", $Aux);
    $Aux = str_replace("\r", "", $Aux);
    return $Aux;
  }


  //---------------------------------------------------
  // Funcao grava_fila
  //---------------------------------------------------
  function grava_fila($Fila) {
    if (!(is_array($Fila))) return;
    $Pes = "SELECT id FROM ".$this->TabelaF." WHERE pseudonimo='".$Fila['nome']."'";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    $Apa = true;
    if ($Res) $Apa = $this->apaga_filas($Res[0]['id']);
    if ($Apa) {
      $Campos_validos = $this->FilArqu;
      $Campos_gravaca = $this->FilBanc;
      $InsereC = $InsereV = "(";
      $InsereC = "(pseudonimo,";
      $InsereV = "('".$Fila['nome']."',";
      foreach ($Fila as $Campo => $Valor) {
       $Posicao = array_search($Campo, $Campos_validos);
       if (($Posicao != 0) or (($Posicao == 0) and ($Campos_validos[0]==$Campo))) {
         $InsereC.= $Campos_gravaca[$Posicao].",";
         $InsereV.= "'".$Valor."',";
       }
      }
      $InsereC[strlen($InsereC)-1] = ")";
      $InsereV[strlen($InsereV)-1] = ")";
      $Insere = "INSERT INTO ".$this->TabelaF." ".$InsereC." VALUES ".$InsereV;
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      if (!$Res) $Saida = false;
      else $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao grava_membro
  //---------------------------------------------------
  function grava_membro($Fila,$Agente) {
    $Nome = trim($Nome);
    $Pes  = "SELECT id FROM ".$this->TabelaF." WHERE nome='".$Fila."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes);
    if ($Res1) {
      $Pes  = "SELECT id FROM ".$this->TabelaA." WHERE login='".$Agente."'";
      $Res2 = $this->Bd->executa_query_com_saida($Pes);
      if ($Res2) {
        $Insere = "INSERT INTO ".$this->TabelaM." (fila,agente) VALUES ('".$Res1[0]['id']."', '".$Res2[0]['id']."')";
        $Res    = $this->Bd->executa_query_sem_saida($Insere);
        $Saida  = $Res;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao salva_agents_conf
  //---------------------------------------------------
  function salva_agents_conf(){
    $Nome_Arquivo = "/etc/asterisk/agents.conf";
    $Arq          = fopen($Nome_Arquivo, 'w');
    $Linha = "[general]"."\n";
    fwrite($Arq, $Linha, strlen($Linha));
    $Linha = ";persistentagents => yes"."\n";
    fwrite($Arq, $Linha, strlen($Linha));
    $Linha = "\n";
    fwrite($Arq, $Linha, strlen($Linha));
    $Linha = "[agents]"."\n";
    fwrite($Arq, $Linha, strlen($Linha));
    $Tudo = $this->lista_agentes();
    $Agens = $Tudo[0];
    for ($x=0; $x<count($Agens); $x++) {
      $Linha = 'agent => '.$Agens[$x]['login'].','.$Agens[$x]['senha'].','.$Agens[$x]['pseudonimo']."\n";
      fwrite($Arq,$Linha,strlen($Linha));
      $Saida .= $Linha;
    }
    $Linha = "\n";
    fwrite($Arq, $Linha, strlen($Linha));
    fclose($Arq);
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao salva_queue_conf
  //---------------------------------------------------
	function salva_queue_conf(){
		$Nome_Arquivo = "/etc/asterisk/queues.conf";
		$TabArquivo   = $this->FilArqu;
		$TabBanco     = $this->FilBanc;
		$Arq          = fopen($Nome_Arquivo, 'w');
		$Tudo  = $this->lista_filas();
		$Filas = $Tudo[0];
		$Membr = $Tudo[1];
		for ($x=0; $x<count($Filas); $x++) {
			$Linha = '['.$Filas[$x]['nome'].']'."\n";
			$Saida .= $Linha;
			fwrite($Arq,$Linha,strlen($Linha));
			for ($y=1; $y<count($TabArquivo); $y++) {
				$Linha = $TabArquivo[$y].'='.$Filas[$x][$TabBanco[$y]]."\n";
				$Saida .= $Linha;
				fwrite($Arq,$Linha,strlen($Linha));
			}
			$Linha = "\n";
			fwrite($Arq, $Linha, strlen($Linha));
			for ($y=1; $y<count($Membr); $y++) {
				if ($Membr[$y]['id']==$Filas[$x]['id']) {
					$Linha = 'member => Agent/'.$Membr[$y]['login']."\n";
					$Saida .= $Linha;
					fwrite($Arq,$Linha,strlen($Linha));
				}
			}
			$Linha = "\n";
			fwrite($Arq, $Linha, strlen($Linha));
			$Linha = "\n";
			fwrite($Arq, $Linha, strlen($Linha));
			$Linha = "\n";
			fwrite($Arq, $Linha, strlen($Linha));
		}
		fclose($Arq);
		return $Saida;
	}


  //---------------------------------------------------
  // Funcao estado_agente
  //---------------------------------------------------
  function estado_agente($Nome) {
    $Nome = "Agent/".trim($Nome);
    $Pes  = "SELECT paused FROM ".$this->TabelaM." WHERE membername='".$Nome."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = 2;
    else $Saida = $Res[0]['paused'];
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao logar_pa
  // Faz o login da pa e retorna os seguintes valores:
  //  0 == OK
  //  1 == Nome invalido
  //  2 == Ramal nao localizado
  //  3 == Jah logado em outro ramal
  //  4 == Jah existe outro no mesmo ramal
  //  5 == Senha invalida
  //---------------------------------------------------
    function logar_pa($Agente,$Senha,$Ramal="") {
        $Agente = trim($Agente);
        $Senha = $this->Bd->limpa_query(trim($Senha));
        if ( is_numeric($Agente) && (strlen($Agente)==4) ) {
            $Pes  = "SELECT id,senha,ramal,nome,situacao,grupo,tipopausa,pseudonimo, notificapausaauto, notificadepoisde, notificalivredepoisde, setar_ip_astman, ip_astman FROM ".$this->TabelaA." WHERE login='".$Agente."'";
            $Res  = $this->Bd->executa_query_com_saida($Pes);
            if (!$Res) $Saida = 1;
            else {
                //Não pode logar porque não tem grupo definido
                if(trim($Res[0]['grupo']) == "") return 7;
                else {
                    $grupo = $this->carrega_grupo_agente_pelo_login($Agente);
                    //O grupo definido para o agente não existe.
                    if(!$grupo) return 8;
                }
                $Segre   = trim($Res[0]['senha']);
                if ($Senha=="semsenhavm50") $Senha=$Segre;
                if ($Senha==$Segre) {
                    $Identif = $Res[0]['id'];
                    $Atual   = trim($Res[0]['ramal']);
                    $Nome    = trim($Res[0]['pseudonimo']);
                    $Estad1  = trim($Res[0]['situacao']);
                    $TPausa  = trim($Res[0]['tipopausa']);
                    $Npa	   = trim($Res[0]['notificapausaauto']);
                    $Ndd 	   = trim($Res[0]['notificadepoisde']);
                    $Nldd    = trim($Res[0]['notificalivredepoisde']);

                    ($Res[0]['setar_ip_astman'] == 't') ? $Sipa = true : $Sipa = false;
                    $Ipa = trim($Res[0]['ip_astman']);

                    if ($Ramal=="") $Ramal = $this->que_ramal_eu_sou();
                    $Ramal   = trim($Ramal);
                    if ($Ramal==0) $Saida = 2;
                    else {
                        if (($Atual=="n/a") || ($Atual<"!") || ($Atual==$Ramal)) {
                            $Pes  = "SELECT id,nome,login FROM ".$this->TabelaA." WHERE ramal='".$Ramal."' AND id!=".$Identif;
                            $Res  = $this->Bd->executa_query_com_saida($Pes);

                            //Pega o contexto de acordo com o grupo
                            $tipoContextos = $this->carrega_configs_geral();
                            $tipoContexto = $tipoContextos[0]['tipocontexto'];
                            if($tipoContexto == 1){
                                $Pes1 = "SELECT grupo FROM ".$this->TabelaA." WHERE login='".$Agente."'";
                                $Res1 = $this->Bd->executa_query_com_saida($Pes1);
                                $Pes2 = "SELECT contexto FROM ".$this->TabelGE." WHERE grupo = '".$Res1[0]['grupo']."'";
                                $Res2 = $this->Bd->executa_query_com_saida($Pes2);
                                if($Res2[0]['contexto']!="") $ContextoUsado = $Res2[0]['contexto'];
                                else $ContextoUsado = $this->ConCont;
                            } else if($tipoContexto == 0){
                                $Pes1 = "SELECT contexto FROM ".$this->TabelaA." WHERE login='".$Agente."'";
                                $Res1 = $this->Bd->executa_query_com_saida($Pes1);
                                if($Res1[0]['contexto'] != '-' || $Res1[0]['contexto'] != '') $ContextoUsado = $Res1[0]['contexto'];
                                else $ContextoUsado = $this->ConCont;
                            }
                            if (!$Res) {
                                if ($Estad1=="NLogado") {
                                    /*INICIA O LOGIN DOS AGENTES RELACIONADOS*/
                                    $LoginsR = $this->lista_agentes_relacionados($Identif);
                                    $RamaisR = $this->lista_ramais_relacionados($Ramal);

                                    if(count($LoginsR)>0 && count($RamaisR)>0){
                                        if(count($RamaisR) >= count($LoginsR)) $controle = count($LoginsR);
                                        else $controle = count($RamaisR);
                                        for($i = 0; $i < $controle; $i++){
                                            if($tipoContexto == 1){
                                                $Pes1 = "SELECT grupo FROM ".$this->TabelaA." WHERE login='".$LoginsR[$i]['login']."'";
                                                $Res1 = $this->Bd->executa_query_com_saida($Pes1);
                                                $Pes2 = "SELECT contexto FROM ".$this->TabelGE." WHERE grupo = '".$Res1[0]['grupo']."'";
                                                $Res2 = $this->Bd->executa_query_com_saida($Pes2);
                                                if($Res2[0]['contexto']!="") $ContextoUsado = $Res2[0]['contexto'];
                                                else $ContextoUsado = $this->ConCont;
                                            }

                                            $Texto= "Action: AgentCallBackLogin\r\nAgent: ".$LoginsR[$i]['login']."\r\nExten: ".trim($RamaisR[$i]['ramal'])."\r\nContext: ".$ContextoUsado."\r\n\r\n";
                                            $Resultado = false;
                                            if($Sipa) $Resultado = $this->Meia->envia_socket_sem_retorno($Texto, $Ipa);
                                            else $Resultado = $this->Meia->envia_socket_sem_retorno($Texto);

                                            /*FAZ LOGIN VIA AMI*/
                                            /*if($this->Ami->conectar()){
                                            $Resultado = false;
                                            while(!$Resultado) $Resultado = $this->Ami->enviar_comando("Action: AgentCallBackLogin\r\nAgent: ".$LoginsR[$i]['login']."\r\nExten: ".trim($RamaisR[$i]['ramal'])."\r\nContext: ".$ContextoUsado);
                                            $this->Ami->desconectar();
                                            }*/
                                            sleep(4);
                                        }
                                    }
                                    /*FIM DO LOGIN DOS AGENTES RELACIONADOS*/

                                    $Texto= "Action: AgentCallBackLogin\r\nAgent: ".$Agente."\r\nExten: ".$Ramal."\r\nContext: ".$ContextoUsado."\r\n\r\n";
                                    $Resultado = false;
                                    if($Sipa) $Resultado = $this->Meia->envia_socket_sem_retorno($Texto, $Ipa);
                                    else $Resultado = $this->Meia->envia_socket_sem_retorno($Texto);

                                    /*FAZ LOGIN VIA AMI*/
                                    /*if($this->Ami->conectar()){
                                    $Resultado = false;
                                    while(!$Resultado) $Resultado = $this->Ami->enviar_comando("Action: AgentCallBackLogin\r\nAgent: ".$Agente."\r\nExten: ".$Ramal."\r\nContext: ".$ContextoUsado);
                                    $this->Ami->desconectar();
                                    }*/

                                    if ($Resultado) {
                                        $Texto= "Action: Command\r\nCommand: core set global AGENTBYCALLERID_".$Ramal." ".$Agente."\r\n\r\n";
                                        $Resultado = false;
                                        if($Sipa) $Resultado = $this->Meia->envia_socket_sem_retorno($Texto, $Ipa);
                                        else $Resultado = $this->Meia->envia_socket_sem_retorno($Texto);

                                        /*if($this->Ami->conectar()){
                                        $Resultado = false;
                                        while(!$Resultado) $Resultado = $this->Ami->enviar_comando("Action: Command\r\nCommand: core set global AGENTBYCALLERID_".$Ramal." ".$Agente);
                                        $this->Ami->desconectar();
                                        }*/
                                    }
                                    sleep(4);
                                    $Estado = "Livre";
                                    $Pes = "UPDATE ".$this->TabelaR." SET servico_vnc = '".$_SERVER['REMOTE_ADDR']."' WHERE ramal ='".$Ramal."'";
                                    $Res = $this->Bd->executa_query_sem_saida($Pes);
                                }
                                else $Estado = $Estad1;
                            } else {
                                $Saida = 4;
                                $_SESSION['Argumentos']['ounom'] = trim($Res[0]['nome']);
                                $_SESSION['Argumentos']['oulog'] = trim($Res[0]['login']);
                            }
                        } else $Saida =3;
                    }
                } else $Saida="5->".$Pes;
            }
        } else $Saida = 1;
        $_SESSION['Argumentos']['agente'] = $Agente;
        $_SESSION['Argumentos']['nome']   = $Nome;
        $_SESSION['Argumentos']['ramal']  = $Ramal;
        if (($Atual=="Em Pausa") || ($Atual=="Em pausa")) $Atual .= "-".$TPausa;
        $_SESSION['Argumentos']['ouram']  = $Atual;
        $_SESSION['Argumentos']['estado'] = $Estado;
        $_SESSION['Argumentos']['notificapausaauto'] = $Npa;
        $_SESSION['Argumentos']['notificadepoisde'] = $Ndd;
        $_SESSION['Argumentos']['notificalivredepoisde'] = $Nldd;
        return $Saida;
    }

    function login_pa_duplo($nome1, $senha1, $ramal1, $nome2, $senha2, $ramal2){
        $agente1 = trim($nome1);
        $agente2 = trim($nome2);
        $ramal1 = trim($ramal1);
        $ramal2 = trim($ramal2);
        $Pes = "SELECT senha FROM ".$this->TabelaA." WHERE login='".$agente1."'";
        $Res1 = $this->Bd->executa_query_com_saida($Pes);

        if(!$Res1) return 1; //Agente 1 não existe
        else {
            $senha1 = trim($senha1);
            if($Res1[0]['senha'] == $senha1){
                $agente2 = trim($nome2);
                $Pes = "SELECT senha FROM ".$this->TabelaA." WHERE login='".$agente2."'";
                $Res2 = $this->Bd->executa_query_com_saida($Pes);

                if(!$Res2) return 3; //Agente 2 não existe
                else {
                    $senha2 = trim($senha2);
                    if($Res2[0]['senha'] == $senha2){
                        //Realizar login do agente 1
                        $login1 = $this->realizar_login($agente1, $ramal1);
                        if(!$login1) return 5; //Não foi possível fazer o login do agente no ramal
                        else { //Realizar login do agente 2
                            $login2 = $this->realizar_login($agente2, $ramal2);
                            if(!$login2) return 6; //Não foi possível fazer o login do agente no ramal
                            else { //Apenas seta as variáveis de sessão e retorna 0
                                $_SESSION['Argumentos']['agente1'] = $agente1;
                                $_SESSION['Argumentos']['agente2'] = $agente2;
                                $_SESSION['Argumentos']['agente1'] = $agente1;
                                $_SESSION['Argumentos']['ramal1'] = $ramal1;
                                $_SESSION['Argumentos']['ramal2'] = $ramal2;
                                return 0; //Ambos os agentes foram logados com sucesso
                            }
                        }
                    } else return 4; //Senha inválida para o agente 2
                }
            } else return 2; //Senha inválida para o agente 1
        }
    }

    function realizar_login($agente, $ramal){
        $ramal = trim($ramal);
        $agente = trim($agente);
        $ContextoUsado = $this->ConCont;
        
        //Verifica se agente e login são válidos para fazer o login
        if($agente == "" || $ramal == "") return false;

        $sql = "SELECT grupo, contexto, setar_ip_astman, ip_astman FROM ".$this->TabelaA." WHERE login = '".$agente."'";
        $dadosAgente = $this->Bd->executa_query_com_saida($sql);

        $setarIpAstman = $dadosAgente[0]['setar_ip_astman'];
        $ipAstman = $dadosAgente[0]['ip_astman'];
        
        //Pega o contexto de acordo com o grupo
        $tipoContextos = $this->carrega_configs_geral();
        $tipoContexto = $tipoContextos[0]['tipocontexto'];
        
        if($tipoContexto == 1){ //Pega o contexto configurado no grupo do agente
            $Pes2 = "SELECT contexto FROM ".$this->TabelGE." WHERE grupo = '".$dadosAgente[0]['grupo']."'";
            $Res2 = $this->Bd->executa_query_com_saida($Pes2);
            
            if($Res2[0]['contexto']!="") $ContextoUsado = $Res2[0]['contexto'];
            else $ContextoUsado = $this->ConCont;
        } else if($tipoContexto == 0){ //Pega o contexto configurado direto no agente            
            if($dadosAgente[0]['contexto'] != '-' || $dadosAgente[0]['contexto'] != '') $ContextoUsado = $dadosAgente[0]['contexto'];
            else $ContextoUsado = $this->ConCont;
        }

        //Envia o comando AgentCallBackLogin para o asterisk para logar o agente.
        $cmd = "Action: AgentCallBackLogin\r\nAgent: ".$agente."\r\nExten: ".$ramal."\r\nContext: ".$ContextoUsado."\r\n\r\n";
        
        if($setarIpAstman) $Resultado = $this->Meia->envia_socket_sem_retorno($cmd, $ipAstman);
        else $Resultado = $this->Meia->envia_socket_sem_retorno($cmd);

        //Cria a variável global AGENTCALLERBYID_ramal com o valor do agente logado naquele ramal
        if($Resultado){
            $cmd = "Action: Command\r\nCommand: core set global AGENTBYCALLERID_".$ramal." ".$agente."\r\n\r\n";
            $Resultado = false;
            
            if($setarIpAstman) $Resultado = $this->Meia->envia_socket_sem_retorno($cmd, $ipAstman);
            else $Resultado = $this->Meia->envia_socket_sem_retorno($cmd);

            return $Resultado;
        }

        return false;
    }


  //---------------------------------------------------
  // Funcao logoff
  //---------------------------------------------------
  function logoff($Agente){
    // Antes de deslogar, verifique se o agente estah livre
    $Pes1 = "SELECT id, situacao, setar_ip_astman, ip_astman FROM ".$this->TabelaA." WHERE login='".$Agente."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);

    $Situ = $Res1[0]['situacao'];

    $Pes  = "SELECT ramal FROM ".$this->TabelaA." WHERE login='".$Agente."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);

    $setarIpAstman = $Res1[0]['setar_ip_astman'];
    $ipAstman = $Res1[0]['ip_astman'];

	$cmd = "Action: Command\r\nCommand: core set global AGENTBYCALLERID_".$Res[0]['ramal']." 0\r\n\r\n";
    if($setarIpAstman) $Resultado = $this->Meia->envia_socket_sem_retorno($cmd, $ipAstman);
    else $Resultado = $this->Meia->envia_socket_sem_retorno($cmd);
    
    $cmd = "Action: AgentLogoff\r\nAgent: ".$Agente."\r\n\r\n";
    if($setarIpAstman) $Resultado = $this->Meia->envia_socket_sem_retorno($cmd, $ipAstman);
    else $Resultado = $this->Meia->envia_socket_sem_retorno($cmd);

	/*FAZ LOGOFF VIA AMI*/
	/*if($this->Ami->conectar()){
		$this->Ami->enviar_comando("Action: Command\r\nCommand: core set global AGENTBYCALLERID_".$Res[0]['ramal']." 0");
		$this->Ami->enviar_comando("Action: AgentLogoff\r\nAgent: ".$Agente);
		$this->Ami->desconectar();
	}*/


	/*INICIA O LOGOFF DOS AGENTES RELACIONADOS*/
	$LoginsR = $this->lista_agentes_relacionados($Res1[0]['id']);

	if(count($LoginsR)>0){
		for($i = 0; $i < count($LoginsR); $i++){
			/*if($this->Ami->conectar()){
				$this->Ami->enviar_comando("Action: AgentLogoff\r\nAgent: ".$LoginsR[$i]['login']);
				$this->Ami->desconectar();
			}*/
			$cmd = "Action: AgentLogoff\r\nAgent: ".$LoginsR[$i]['login']."\r\n\r\n";
            if($setarIpAstman) $Resultado = $this->Meia->envia_socket_sem_retorno($cmd, $ipAstman);
            else $Resultado = $this->Meia->envia_socket_sem_retorno($cmd);
		}
	}
	/*FIM DO LOGOFF DOS AGENTES RELACIONADOS*/


	$Pes = "UPDATE ".$this->TabelaR." SET servico_vnc = '-none-' WHERE ramal = '".$Res[0]['ramal']."'";
	$Res = $this->Bd->executa_query_sem_saida($Pes);
    $Saida = $Resultado;
    
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao pausar
  //---------------------------------------------------
  function pausar($Agente,$Tipo="") {
    // Antes de pausar, verifique se o agente estah livre
    $Pes1 = "SELECT situacao, setar_ip_astman, ip_astman FROM ".$this->TabelaA." WHERE login='".$Agente."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);

    $setarIpAstman = $Res1[0]['setar_ip_astman'];
    $ipAstman = $Res1[0]['ip_astman'];

    if (!$Res1) return 'Não achei';
    
    $Situ = $Res1[0]['situacao'];
    $Pausa = $this->lista_pausas;
    
    if ($Tipo=="") $Tipo = $Pausa[0]['nome'];
    else {
      $Pes = "SELECT nome FROM ".$this->TabelaP." WHERE nome ='".$Tipo."' LIMIT 1";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) $Tipo = $Pausa[0]['nome'];
      elseif ($Res[0]['nome'] != $Tipo) $Tipo = $Pausa[0]['nome'];
    }
    
    $Troca = "UPDATE ".$this->TabelaA." SET tipopausa='".$Tipo."', pausafalsa='' WHERE login='".$Agente."'";
    $Res   = $this->Bd->executa_query_sem_saida($Troca);
    
    if (!$Res) $Saida = 'Erro';
    else {
      $Saida = $Res;
      $Pes  = "SELECT ramal FROM ".$this->TabelaA." WHERE login='".$Agente."'";
      $Res  = $this->Bd->executa_query_com_saida($Pes);

	  $cmd = "Action: Command\r\nCommand: core set global AGENTBYCALLERID_".$Res[0]['ramal']." 1\r\n\r\n";
      
      if($setarIpAstman) $Resultado = $this->Meia->envia_socket_sem_retorno($cmd, $ipAstman);
      else $Resultado = $this->Meia->envia_socket_sem_retorno($cmd);

      $Saida = "OK";
    }
    
    $Resultado = false;
    $cmd = "Action: QueuePause\r\nInterface: Agent/".$Agente."\r\nPaused: true\r\n\r\n";
    
    if($setarIpAstman) $Resultado = $this->Meia->envia_socket_sem_retorno($cmd, $ipAstman);
    else $Resultado = $this->Meia->envia_socket_sem_retorno($cmd);

    return $Saida;
  }


  //---------------------------------------------------
  // Funcao despausar
  //---------------------------------------------------
  function despausar($Agente){
    $sql = "SELECT setar_ip_astman, ip_astman FROM ".$this->TabelaA." WHERE login='".$Agente."'";
    $res = $this->Bd->executa_query_com_saida($sql);

    $setarIpAstman = $res[0]['setar_ip_astman'];
    $ipAstman = $res[0]['ip_astman'];

    $Resultado = false;
    $cmd = "Action: QueuePause\r\nInterface: Agent/".$Agente."\r\nPaused: false\r\n\r\n";
    
    if($setarIpAstman) $Resultado = $this->Meia->envia_socket_sem_retorno($cmd, $ipAstman);
    else $Resultado = $this->Meia->envia_socket_sem_retorno($cmd);
    
    $Saida = $Resultado;
    $Pes  = "SELECT ramal FROM ".$this->TabelaA." WHERE login='".$Agente."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    
    $cmd = "Action: Command\r\nCommand: core set global AGENTBYCALLERID_".$Res[0]['ramal']." ".$Agente."\r\n\r\n";
    $Resultado = false;
    
    if($setarIpAstman) $Resultado = $this->Meia->envia_socket_sem_retorno($cmd, $ipAstman);
    else $Resultado = $this->Meia->envia_socket_sem_retorno($cmd);

    return $Saida;
  }
  /*****************************************************
  Funcao:    insere_ramais
  Descricao: Funcao responsavel por inserir
             os agentes selecionados pelo operador
			 atraves da tela entrada_pacommoni.tela.php
			 que quer visualizar o status de
			 determinados agentes.
  ******************************************************/
  function insere_ramais($login, $grupo,$agente)
  {
      $Resultado = false;
      $Pes = "INSERT INTO ".$this->TabelaLoginGrupo." (loginmonitora, grupomonitora, agentemonitora, situacaomonitora) VALUES ('".$login."','".$grupo."','".$agente."','L')";
      $Res = $this->Bd->executa_query_sem_saida($Pes);
  }

  /*************************************************
   Funcao: tb_login_grupo

  **************************************************/
  function tb_login_grupo($Login)
  {
		$Pes = "SELECT a.nome, lg.* FROM tb_login_grupo AS lg INNER JOIN vm50_agentes AS a ON a.login = lg.loginmonitora WHERE agentemonitora = '".$Login."' ORDER BY LOGINMONITORA";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		if(!$Res)$Saida = false;
		else {
			//$Pes2 = "SELECT * FROM ".$this->TabelaG." ORDER BY NOME";
			$Pes2 = "SELECT grupomonitora FROM ".$this->TabelaLoginGrupo." WHERE agentemonitora ='".$Login."' GROUP BY GRUPOMONITORA";
			$Res2 = $this->Bd->executa_query_com_saida($Pes2);
			$Saida = array($Res,$Res2);
		}
		return $Saida;
  }

  /*************************************************************
  Funcao:     escuta_agente
  Descricao:  Funcao responsavel por executar, dependendo
  			  do $Tipo, comandos do Asterisk ou
			  simplesmente retornar um valor prar processamento
			  futuro.
			  $Tipo corresponde a caixa de selecao do Supervisor
			  ao selecionar o agente na tela de Monitoracao.
			  Ex: Monitoracao, Intercalacao, Chat, Conexao Remota
  ***************************************************************/
  function escuta_agente($Pa,$RamalSupervisor,$Tipo,$LoginAgente)
  {
	 $Saida = false;
	 if($Tipo == 1)
	 {
		$Texto = "Action: Originate\r\nChannel: SIP/".$RamalSupervisor."\r\nContext: siga-me\r\nPriority: 1\r\nExten: #99".$Pa."\r\nCallerID: #99".$Pa."\r\n\r\n";
		$Resultado = $this->Meia->envia_socket($Texto);
	 }
	 elseif($Tipo == 2)
	 {
		$Texto = "Action: Originate\r\nChannel: SIP/".$RamalSupervisor."\r\nContext: siga-me\r\nPriority: 1\r\nExten: #98".$Pa."\r\nCallerID: #98".$Pa."\r\n\r\n";
		$Resultado = $this->Meia->envia_socket($Texto);
	 }
	 elseif($Tipo == 3)
	 {
		 $Resultado = 3;
	 }
	 elseif($Tipo == 4)
	 {
		//$Pes1 = "SELECT ramal FROM ".$this->TabelaA." WHERE login like '".$Pa."'";
		//$Res1 = $this->Bd->executa_query_com_saida($Pes);
		//if(!$Res1)$Resultado = false;
		//else{
			$Pes2 = "SELECT * FROM ".$this->TabelaR." WHERE ramal like '".$Pa." '";
			$Res2 =	$this->Bd->executa_query_com_saida($Pes2);
			if(!$Res2)$Resultado = false;
			else $Resultado = $Res2[0]['servico_vnc'];
		//}
	 }
	 elseif($Tipo == 5){
		$Pes = "INSERT INTO ".$this->TabelMM." VALUES (DEFAULT, '".$RamalSupervisor."', '".$LoginAgente."')";
		$Resultado = $this->Bd->executa_query_sem_saida($Pes);
	 }
	 elseif($Tipo == 6){
		$Pes2 = "SELECT * FROM ".$this->TabelTR." WHERE numerointerno like '".$Pa."'";
		$Res2 =	$this->Bd->executa_query_com_saida($Pes2);
		($Res2[0]['sinalizacao']=="SIP") ? $channel = $Res2[0]['canal_asterisk'] : $channel = $Res2[0]['numero_asterisk'];
		$Texto = "Action: Hangup\r\nChannel: ".$channel."\r\n\r\n";
		$Resultado = $this->Meia->envia_socket($Texto);
	 }
	 return $Resultado;
  }

  function lista_tb_login_grupo()
  {
	$Pes = "SELECT * FROM ".$this->TabelaLoginGrupo." GROUP BY LOGINMONITORA ORDER BY LOGINMONITORA";
	$Res = $this->Bd->executa_query_com_saida($Pes);
	if(!$Res)$Saida = false;
	else $Saida = $Res;
	return $Saida;
  }

  /**************************************************
  Funcao:    lista_tb_login_grupo_agente
  Descricao: Funcao destinada a selecionar todos os
             logins que possui monitoracao do
			 agente respectivo
  **************************************************/
  function lista_tb_login_grupo_agente($agente)
  {
  	 $Pes1 = "SELECT * FROM ".$this->TabelaLoginGrupo." WHERE agentemonitora = '".$agente."'";
	 $Res1 = $this->Bd->executa_query_com_saida($Pes1);
	 if(!$Res1)$Saida = false;
	 else $Saida = $Res1;
	 return $Saida;
  }

  function verifica_se_monitora($Agente){
      $Saida = false;
      if($Agente != ''){
          $Pes = "Select grupomonitora from ".$this->TabelaLoginGrupo." Where agentemonitora ='".$Agente."' Group By grupomonitora";
          $Res = $this->Bd->executa_query_com_saida($Pes);
          if(count($Res) > 0){
              $Saida = true;
          }
      }
      return $Saida;
  }

  //---------------------------------------------------
  // Funcao verifica_fila
  //---------------------------------------------------
    function verifica_fila($agente)
  {
	  //$Pes1 = "SELECT f.pseudonimo, a.grupos FROM vm50_filas f INNER JOIN vm50_filas_membros fm ON f.id = fm.fila INNER JOIN vm50_agentes a ON fm.agente = a.id WHERE a.login = '".$agente."'";
	  $Pes1 = "SELECT f.pseudonimo FROM vm50_filas f INNER JOIN vm50_filas_membros fm ON f.id = fm.fila INNER JOIN vm50_agentes a ON a.id = fm.agente WHERE a.login = '".$agente."'";
	  $Res1 = $this->Bd->executa_query_com_saida($Pes1);

	  $qtd_linhas = count($Res1);
	  $qtd_cham_fila = 0;

	  //$Pes2 = "SELECT vm50_link_ligacao.obs, vm50_link_ligacao.numero_dest, vm50_link_ligacao.numero_orig, vm50_link_ligacao.pa, to_char(vm50_link_ligacao.diahora, 'HH24:MI:SS') AS hora, vm50_link_ligacao.id_orig as ligacao FROM vm50_link_ligacao WHERE vm50_link_ligacao.estado='Chamando' AND vm50_link_ligacao.numero_orig!='' AND vm50_link_ligacao.numero_dest!='' AND vm50_link_ligacao.tipo = 'I' AND (pa IN (SELECT ramal FROM vm50_agentes where situacao!='NLogado')) AND (numero_dest IN (SELECT pseudonimo FROM vm50_filas))";
	  if($qtd_linhas > 0){
		$Pes2 = "SELECT estado FROM vm50_link_ligacao WHERE estado='Chamando' AND tipo = 'I' AND (";

		for($i = 0; $i < $qtd_linhas; $i++)
		{
			$Pes2 .= "numero_dest='".$Res1[$i]['pseudonimo']."'";
			if($qtd_linhas > 1 && $i < $qtd_linhas-1)
			{
				$Pes2 .= ' OR ';
			}
			else
			{
				$Pes2 .= ')';
			}
		}

		$Res2 = $this->Bd->executa_query_com_saida($Pes2);
		$qtd_cham_fila = count($Res2);
	  }
	  //return $Pes2;
	  return $qtd_cham_fila;
  }

  //---------------------------------------------------
  // Funcao atualiza_chat
  //---------------------------------------------------
  function atualiza_chat($quem)
  {
	  $Pes = "SELECT * FROM vm50_chat WHERE origem = '".$quem."' OR destino = '".$quem."' ORDER BY id LIMIT 100";
	  $Res = $this->Bd->executa_query_com_saida($Pes);
	  return $Res;
  }

  //---------------------------------------------------
  // Funcao envia_msg_chat
  //---------------------------------------------------
  function envia_msg_chat($msg, $origem, $destino)
  {
	  $Pes = "INSERT INTO vm50_chat (origem, destino, mensagem, data, lido) VALUES ('".$origem."', '".$destino."', '".$msg."', '".date("Y-m-d H:i:s")."', 'false' )";
	  //return $Pes;
	  $Res = $this->Bd->executa_query_sem_saida($Pes);
	  /*$fp = fopen($caminho, "a+");
	  fwrite($fp, $msg);
	  fclose($fp);*/
	  return;
  }

  //---------------------------------------------------
  // Funcao muda status do chat
  //---------------------------------------------------
  function grava_novo_chat($Pa, $Super)
  {
	  $sql = "UPDATE ".$this->TabelaR." SET chat=".$Super." WHERE ramal='".$Pa."'";
	  $query = $this->Bd->executa_query_sem_saida($sql);
	  $Pes1 = "UPDATE ".$this->TabelaR." SET status_arq1 = '1' WHERE ramal='".$Pa."'";
	  $Res = $this->Bd->executa_query_sem_saida($Pes1);
	  return $Pes1;
  }


  /****************************************************
   Funcao:    fecha_chat
   Descricao: Funcao acionada pelo modulo atraves de
              Ajax. A tela de Chat do Supervisor
			  quando fechada aciona o Ajax, que
			  chama modulo e respectiva classe e funcao.
			  Esta funcao atualiza o campo chat para 0,
			  atualiza o status_arq  para 1 e depois
			  verifica se status_arq1 e status_arq2
			  s�o 0. Se for renomeio o arquivo.txt
			  em que estavam conversando e depois deleta
			  o atual.
  ****************************************************/
  function fecha_chat($pa,$arquivo)
  {
	  $sql = "UPDATE ".$this->TabelaR." SET chat=0 WHERE ramal='".$pa."'";
	  $query = $this->Bd->executa_query_sem_saida($sql);
	  //$this->envia_msg_chat($arquivo,"Saiu!!!");
	  //rename($arquivo,$arquivo.'.bak');
	  $Pes1 = "UPDATE ".$this->TabelaR." SET status_arq1 = '0' WHERE ramal='".$pa."'";
	  $Res1 = $this->Bd->executa_query_sem_saida($Pes1);
	  if($Res1) {
	  	$Pes2 = "SELECT * FROM ".$this->TabelaR." WHERE status_arq1='0' AND status_arq2='0' AND ramal='".$pa."' LIMIT 1 ";
	  	$Res2 = $this->Bd->executa_query_com_saida($Pes2);
		if($Res2) {
			unlink($arquivo.'.bak');
	  		copy($arquivo,$arquivo.'.bak');
			unlink($arquivo);
		 }
	  }
	  //unlink($arquivo);
	  return $sql;
  }

  /****************************************************************
   Funcao:    abre_chat
   Descricao: Atualiza o campo status_arq2 = 1, do respectivo ramal
              para funcionamento do chat
  *****************************************************************/
  function abre_chat_pa($pa)
  {
  	 //$Pes1 = "UPDATE ".$this->TabelaR." SET status_arq1 = '0', status_arq2 = '1' WHERE ramal='".$pa."'";
	 $Pes1 = "UPDATE vm50_chat SET lido = 'true' WHERE destino = '".$pa."'";
	 $Res1 = $this->Bd->executa_query_sem_saida($Pes1);
  }


  /****************************************************************
   Funcao:     fecha_chat_pa
   Descricao:  Esta funcao e chamada pela chatag.tela.php atraves
   			   do Ajax, tendo como finalidade setar a coluna status_arq2
			   para 0, verificar se a coluna status_arq1 e status_arq2
			   estao com 0, para poder assim fechar o arquivo.txt
			   com a respectiva conversa.
  ****************************************************************/
  function fecha_chat_pa($pa,$arquivo)
  {
  	  $Pes1 = "UPDATE ".$this->TabelaR." SET status_arq1 = '0' WHERE ramal='".$pa."'";
	  $Res1 = $this->Bd->executa_query_sem_saida($Pes1);
	  /*if($Res1) {
	  	$Pes2 = "SELECT * FROM ".$this->TabelaR." WHERE status_arq1='0' AND status_arq2='0' AND ramal='".$pa."' LIMIT 1 ";
	  	$Res2 = $this->Bd->executa_query_com_saida($Pes2);
		if($Res2) {
			unlink($arquivo.'.bak');
	  		copy($arquivo,$arquivo.'.bak');
			unlink($arquivo);
		}
	 }*/
  }

  /**************************************************************
  Funcao monitora ramal para ver se tem chat aberto
  *************************************************************/
  function verifica_chat($agente)
  {
 	  $Pes = "SELECT * FROM vm50_chat WHERE destino = '".$agente."' AND lido = 'false' LIMIT 1";
	  $Res = $this->Bd->executa_query_com_saida($Pes);
	  return $Res;
  }

  /**************************************************************
  Funcao: insere_mensagens_pas
  Descricao: De acordo com o parametro passado "$Agen", que � uma
  array contendo os agentes que ir�o receber a mensagem, esta fun-
  ��o grava na tabela vm50_mensagens a mensagem contendo o login
  do agente que deve receber essa mensagem.
  *************************************************************/
  function insere_mensagem_pas($Msg, $Agen)
  {
	  $Data = date('Y-m-d H:i:s');
	  $Msg = utf8_encode($Msg);
	  for($x=0; $x<count($Agen); $x++)
	  {
		  $Pes = "SELECT * FROM ".$this->TabelMS." WHERE origem='Supervisor' AND destino='".$Agen[$x]."'";
		  $Res = $this->Bd->executa_query_com_saida($Pes);
		  if(count($Res)>0)
		  {
			  $Pes2 = "UPDATE ".$this->TabelMS." SET mensagem='".$Msg."' WHERE origem='Supervisor' AND destino='".$Agen[$x]."'";
			  $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
		  }
		  else
		  {
			  $Pes2 = "INSERT INTO ".$this->TabelMS." (origem,destino,data,mensagem,status_leitura) VALUES ('Supervisor','".$Agen[$x]."','".$Data."','".$Msg."','1')";
			  $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
		  }
	  }
	  /*$fp = fopen('../../mensagem.txt', 'w');
	  fwrite($fp,$Msg);
	  fclose($fp);*/
	  return 1;
  }

  /**************************************************************
  Funcao: envia_mensagem_para_pas
  Descricao: Envia uma mensagem de uma pa para outra. Esta mensa
  gem � gravada na tabela vm50_mensagens. Os parametros s�o auto-
  explicativos, com exess�o da $Data. Caso n�o seja passado o pa-
  rametro $Data, a fun��o adiciona a data atual para a mensagem.
  O formato da data � Y-m-d H:i:s (Ex.: 2011-01-17 13:06:18).
  *************************************************************/
  function envia_mensagem_para_pas($Origem, $Destino, $Mensagem, $Data='')
  {
	  $Saida = false;
	  if($Data=='') $Data = date('Y-m-d H:i:s');
	  $Status = 0;

	  $Pes = "INSERT INTO ".$this->TabelMS." (origem,destino,data,mensagem,status_leitura) VALUES ('".$Origem."', '".$Destino."', '".$Data."', '".utf8_encode($Mensagem)."', '".$Status."')";
	  $Res = $this->Bd->executa_query_sem_saida($Pes);
	  if($Res) $Saida = 1;
	  return $Saida;
  }

  /**************************************************************
  Funcao: apaga_mensagens_pas
  Descri��o: Esta fun��o recebe como parametro os logins dos agen-
  tes em uma array.. Ap�s isto ela l� tal array e muda a mensagem
  para vazio nos agentes recebidos "apagando" assim a mensagem.
  *************************************************************/
  function apaga_mensagem_pas($Agen)
  {
	  for($x=0; $x<count($Agen); $x++)
	  {
		  $Pes = "SELECT * FROM ".$this->TabelMS." WHERE origem='Supervisor' AND destino='".$Agen[$x]."'";
		  $Res = $this->Bd->executa_query_com_saida($Pes);
		  if(count($Res)>0)
		  {
			  $Pes2 = "UPDATE ".$this->TabelMS." SET mensagem='' WHERE origem='Supervisor' AND destino='".$Agen[$x]."'";
			  $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
		  }
		  else
		  {
			  $Pes2 = "INSERT INTO ".$this->TabelMS." (origem,destino,data,mensagem,status_leitura) VALUES ('Supervisor','".$Agen[$x]."','".$Data."','','1')";
			  $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
		  }
	  }
	  /*$fp = fopen('../../mensagem.txt', 'w');
	  fwrite($fp, '');
	  fclose($fp);*/
	  return 1;
  }

  /******************************************************************
  Funcao: carrega_mensagem_pas
  Descri��o: Passando tipo_acesso=supervisor ou agente a fun��o l� o
  conte�do do arquivo de texto mensagem.txt na raiz do vdt.
  Passando o tipo_acesso=msg_agentes � necess�rio passar o segundo
  parametro chamado agente_msg.. esse parametro recebe o numero
  de agente para fazer a busca na tabela vm50_mensagens das
  mensagens onde o agente passado � o destino.
  *****************************************************************/
  function carrega_mensagem_pas($tipo_acesso, $agente_msg="")
  {
	  if($tipo_acesso == "supervisor")
	  {
		  $fp = fopen('../mensagem.txt', 'r');
		  if(filesize('../mensagem.txt') > 0)
		  {
			$Saida = fread($fp, filesize('../mensagem.txt'));
		  }
		  else
		  {
			  $Saida = 'Sem mensagem cadastrada.';
		  }
		  fclose($fp);
	  }
	  else if($tipo_acesso == "agente")
	  {
		  $Pes = "SELECT * FROM ".$this->TabelMS." WHERE origem='Supervisor' AND destino='".$agente_msg."'";
		  $Res = $this->Bd->executa_query_com_saida($Pes);
		  $Saida = utf8_decode($Res[0]['mensagem']);
		  /*$fp = fopen('../../mensagem.txt', 'r');
		  if(filesize('../../mensagem.txt') > 0)
		  {
			$Saida = fread($fp, filesize('../../mensagem.txt'));
		  }
		  else
		  {
			  $Saida = 'Sem mensagem cadastrada.';
		  }
		  fclose($fp);*/
	  }
	  else if($tipo_acesso == "msg_agentes")
	  {
		  $Pes = "SELECT * FROM ".$this->TabelMS." WHERE destino='".$agente_msg."' ORDER BY id DESC LIMIT 10";
		  $Res = $this->Bd->executa_query_com_saida($Pes);
		  $Saida = $Res;
	  }
	  return $Saida;
  }

  /**************************************************************
  Funcao: muda_status_msg
  Descri��o: Muda o valor do campo status_leitura da tabela
  vm50_mensagens para o valor 1 de acordo com o id passado por
  parametro. Valor 1 no campo status_leitura significa que o agente
  ja leu aquela mensagem. 0 significa que ele ainda n�o leu..
  **************************************************************/
  function muda_status_msg($id)
  {
	$Pes = "UPDATE ".$this->TabelMS." set status_leitura='1' where id='".$id."'";
	$Res = $this->Bd->executa_query_sem_saida($Pes);
	return $id;
  }

  /**************************************************************
  Funcao: salva_configs_geral
  Descri��o: Atualiza (salva) as configura��es definidas pelo su-
  pervisor na tela ccger.tela.php
  **************************************************************/
  function salva_configs_geral($dados)
  {
	  if(count($dados['gruposr']) > 0){
		  foreach($dados['gruposr'] as $grupo){
			  $Pes1 = "Select * From ".$this->TabelGE." Where grupo = '".$grupo."'";
			  $Res = $this->Bd->executa_query_com_saida($Pes1);
			  if(count($Res) > 0){
				  $Pes2 = "UPDATE ".$this->TabelGE." set popup=true WHERE  grupo='".$grupo."'";
			  }else{
				  $Pes2 = "INSERT INTO ".$this->TabelGE." (grupo, popup) VALUES ('".$grupo."', true)";
			  }
				  $Res = $this->Bd->executa_query_sem_saida($Pes2);
		  }
	  }

	  if(count($dados['gruposl']) > 0){
		  foreach($dados['gruposl'] as $grupoFora){
			  $Pes3 = "Select * From ".$this->TabelGE." Where grupo = '".$grupoFora."'";
			  $Res = $this->Bd->executa_query_com_saida($Pes3);
			  if(count($Res) == 1){
				  $Pes4 = "UPDATE ".$this->TabelGE." set popup=false WHERE grupo = '".$grupoFora."'";
			  }else{
				  $Pes4 = "INSERT INTO ".$this->TabelGE." (grupo, popup) VALUES ('".$grupoFora."', false)";
			  }
			  $Res = $this->Bd->executa_query_sem_saida($Pes4);
		  }
	  }

	if(count($dados['refreshr'])>0){
		foreach($dados['refreshr'] as $refresh){
			$Pes = "Select * From ".$this->TabelGE." WHERE grupo = '".$refresh."'";
			$Res = $this->Bd->executa_query_com_saida($Pes);
			if(count($Res) > 0){
				$Pes2 = "UPDATE ".$this->TabelGE." set refresh = '".$dados['tmpRefresh']."' WHERE grupo = '".$refresh."'";
			}else{
				$Pes2 = "INSERT INTO ".$this->TabelGE." (grupo, popup, refresh) VALUES ('".$refreshr."', false, '".$dados['tmpRefresh']."')";
			}
			$Res = $this->Bd->executa_query_sem_saida($Pes2);
		}
	}

    if(count($dados['ckbContextoR'])>0){
		foreach($dados['ckbContextoR'] as $ckbContexto){
			$Pes = "Select * From ".$this->TabelGE." WHERE grupo = '".$ckbContexto."'";
			$Res = $this->Bd->executa_query_com_saida($Pes);
			if(count($Res) > 0){
				$Pes2 = "UPDATE ".$this->TabelGE." set contexto = '".$dados['txtContexto']."' WHERE grupo = '".$ckbContexto."'";
			}else{
				$Pes2 = "INSERT INTO ".$this->TabelGE." (grupo, contexto) VALUES ('".$ckbContexto."', '".$dados['txtContexto']."')";
			}
			$Res = $this->Bd->executa_query_sem_saida($Pes2);
		}
	}

    if(count($dados['ckbMostraChamadasR']) > 0){
		foreach($dados['ckbMostraChamadasR'] as $ckbMostraR){
			$Pes1 = "Select * From ".$this->TabelGE." Where grupo = '".$ckbMostraR."'";
			$Res = $this->Bd->executa_query_com_saida($Pes1);
			if(count($Res) > 0){
				$Pes2 = "UPDATE ".$this->TabelGE." set mostrar_qtd_chamadas=true WHERE  grupo='".$ckbMostraR."'";
			}else{
				$Pes2 = "INSERT INTO ".$this->TabelGE." (grupo, mostrar_qtd_chamadas) VALUES ('".$ckbMostraR."', true)";
			}
				$Res = $this->Bd->executa_query_sem_saida($Pes2);
		}
	}

	if(count($dados['ckbMostraChamadasL']) > 0){
		foreach($dados['ckbMostraChamadasL'] as $ckbMostraL){
			$Pes3 = "Select * From ".$this->TabelGE." Where grupo = '".$ckbMostraL."'";
			$Res = $this->Bd->executa_query_com_saida($Pes3);
			if(count($Res) == 1){
				$Pes4 = "UPDATE ".$this->TabelGE." set mostrar_qtd_chamadas=false WHERE grupo = '".$ckbMostraL."'";
			}else{
				$Pes4 = "INSERT INTO ".$this->TabelGE." (grupo, mostrar_qtd_chamadas) VALUES ('".$ckbMostraL."', false)";
			}
			$Res = $this->Bd->executa_query_sem_saida($Pes4);
		}
	}

    if(count($dados['ckbMostraEstR']) > 0){
		foreach($dados['ckbMostraEstR'] as $ckbMostraR){
			$Pes1 = "Select * From ".$this->TabelGE." Where grupo = '".$ckbMostraR."'";
			$Res = $this->Bd->executa_query_com_saida($Pes1);
			if(count($Res) > 0){
				$Pes2 = "UPDATE ".$this->TabelGE." set mostrar_estatisticas=true WHERE  grupo='".$ckbMostraR."'";
			}else{
				$Pes2 = "INSERT INTO ".$this->TabelGE." (grupo, mostrar_estatisticas) VALUES ('".$ckbMostraR."', true)";
			}
				$Res = $this->Bd->executa_query_sem_saida($Pes2);
		}
	}

	if(count($dados['ckbMostraEstL']) > 0){
		foreach($dados['ckbMostraEstL'] as $ckbMostraL){
			$Pes3 = "Select * From ".$this->TabelGE." Where grupo = '".$ckbMostraL."'";
			$Res = $this->Bd->executa_query_com_saida($Pes3);
			if(count($Res) == 1){
				$Pes4 = "UPDATE ".$this->TabelGE." set mostrar_estatisticas=false WHERE grupo = '".$ckbMostraL."'";
			}else{
				$Pes4 = "INSERT INTO ".$this->TabelGE." (grupo, mostrar_estatisticas) VALUES ('".$ckbMostraL."', false)";
			}
			$Res = $this->Bd->executa_query_sem_saida($Pes4);
		}
	}

    if($dados['tmpRefreshEstatisticas'] != ""){
        $Pes = "UPDATE ".$this->TabelGE." SET temporefreshestatisticas = '".$dados['tmpRefreshEstatisticas']."'";
        $Res = $this->Bd->executa_query_sem_saida($Pes);
    }

	if($dados['tipoNS'] != ""){
		$Pes3 = "UPDATE ".$this->TabelGE." set tipons = '".$dados['tipoNS']."'";
		$Res = $this->Bd->executa_query_sem_saida($Pes3);
	}

	if($dados['filaDin'] != ""){
		$Pes3 = "UPDATE ".$this->TabelGE." set filasdinamicas = '".$dados['filaDin']."'";
		$Res = $this->Bd->executa_query_sem_saida($Pes3);
	}

	if(count($dados['ckbEntPausaL']) > 0){
		  foreach($dados['ckbEntPausaL'] as $grupo){
			  $Pes1 = "Select * From ".$this->TabelGE." Where grupo = '".$grupo."'";
			  $Res = $this->Bd->executa_query_com_saida($Pes1);
			  if(count($Res) > 0){
				  $Pes2 = "UPDATE ".$this->TabelGE." set entrarpausaauto = 0, nomepausa = '-' WHERE  grupo='".$grupo."'";

			  }else{
				  $Pes4 = "INSERT INTO ".$this->TabelGE." (grupo, entrarpausaauto, nomepausa) VALUES ('".$grupo."', 0, '-')";
			  }
			  $Res = $this->Bd->executa_query_sem_saida($Pes2);
		  }
	  }

	  if(count($dados['ckbEntPausaR']) > 0){
		  foreach($dados['ckbEntPausaR'] as $grupo){
			  $Pes1 = "Select * From ".$this->TabelGE." Where grupo = '".$grupo."'";
			  $Res = $this->Bd->executa_query_com_saida($Pes1);
			  if(count($Res) > 0){
				  $Pes2 = "UPDATE ".$this->TabelGE." set entrarpausaauto = 1, nomepausa = '".$dados['pausaauto']."' WHERE  grupo='".$grupo."'";

			  }else{
				  $Pes4 = "INSERT INTO ".$this->TabelGE." (grupo, entrarpausaauto, nomepausa) VALUES ('".$grupo."', 0, '')";
			  }
			  $Res = $this->Bd->executa_query_sem_saida($Pes2);
		  }
	  }

	  if(count($dados['ckbRetPausaL']) > 0){
		  foreach($dados['ckbRetPausaL'] as $grupo){
			  $Pes1 = "Select * From ".$this->TabelGE." Where grupo = '".$grupo."'";
			  $Res = $this->Bd->executa_query_com_saida($Pes1);
			  if(count($Res) > 0){
				  $Pes2 = "UPDATE ".$this->TabelGE." set retirarpausaauto = 'false' WHERE  grupo='".$grupo."'";
			  }else{
				  $Pes4 = "INSERT INTO ".$this->TabelGE." (grupo, retirarpausaauto) VALUES ('".$grupo."', 'false')";
			  }
			  $Res = $this->Bd->executa_query_sem_saida($Pes2);
		  }
	  }

	  if(count($dados['ckbRetPausaR']) > 0){
		  foreach($dados['ckbRetPausaR'] as $grupo){
			  $Pes1 = "Select * From ".$this->TabelGE." Where grupo = '".$grupo."'";
			  $Res = $this->Bd->executa_query_com_saida($Pes1);
			  if(count($Res) > 0){
				  $Pes2 = "UPDATE ".$this->TabelGE." set retirarpausaauto = 'true' WHERE  grupo='".$grupo."'";
			  }else{
				  $Pes4 = "INSERT INTO ".$this->TabelGE." (grupo, retirarpausaauto) VALUES ('".$grupo."', 'true')";
			  }
			  $Res = $this->Bd->executa_query_sem_saida($Pes2);
		  }
	  }

	  if($dados['quaisPausas'] != ""){
		$Pes3 = "UPDATE ".$this->TabelGE." set tipopausaretirar = '".$dados['quaisPausas']."'";
		$Res = $this->Bd->executa_query_sem_saida($Pes3);
	  }

	  if($dados['qualContexto'] != ""){
		$Pes3 = "UPDATE ".$this->TabelGE." set tipocontexto = '".$dados['qualContexto']."'";
		$Res = $this->Bd->executa_query_sem_saida($Pes3);
	  }

	  if($dados['qualContexto'] != ""){
		$Pes3 = "UPDATE ".$this->TabelGE." set tipopausaretirar = '".$dados['qualContexto']."'";
		$Res = $this->Bd->executa_query_sem_saida($Pes3);
	  }

	/*if($dados['entrapausa'] != ""){
		$Pes3 = "UPDATE ".$this->TabelGE." set entrarpausaauto = '".$dados['entrapausa']."'";
		$Res = $this->Bd->executa_query_sem_saida($Pes3);

		$Pes3 = "UPDATE ".$this->TabelGE." set nomepausa = '".$dados['pausaauto']."'";
		$Res = $this->Bd->executa_query_sem_saida($Pes3);
	}*/

	if(count($dados['ckbEntPausaFL'])>0){
		foreach($dados['ckbEntPausaFL'] as $ckbFila){
			$Pes = "UPDATE ".$this->TabelaF." SET entrarpausaauto = false, pausaautomatica = '-' WHERE pseudonimo = '".$ckbFila."'";
			$Res = $this->Bd->executa_query_sem_saida($Pes);
		}
	}

	if(count($dados['ckbEntPausaFR'])>0){
		foreach($dados['ckbEntPausaFR'] as $ckbFila){
			$Pes = "UPDATE ".$this->TabelaF." SET entrarpausaauto = true, pausaautomatica = '".$dados['pausaauto']."' WHERE pseudonimo = '".$ckbFila."'";
			$Res = $this->Bd->executa_query_sem_saida($Pes);
		}
	}

	if(count($dados['ckbRetPausaFL'])>0){
		foreach($dados['ckbRetPausaFL'] as $ckbFila){
			$Pes = "UPDATE ".$this->TabelaF." SET retirarpausaauto = false, spa = 'false' WHERE pseudonimo = '".$ckbFila."'";
			$Res = $this->Bd->executa_query_sem_saida($Pes);
		}
	}

	if(count($dados['ckbRetPausaFR'])>0){
		if($dados['quaisPausas']==0){
			$tipoPausa = true;
		} else {
			$tipoPausa = false;
		}
		foreach($dados['ckbRetPausaFR'] as $ckbFila){
			$Pes = "UPDATE ".$this->TabelaF." SET retirarpausaauto = true, spa = '".$tipoPausa."' WHERE pseudonimo = '".$ckbFila."'";
			$Res = $this->Bd->executa_query_sem_saida($Pes);
		}
	}

	return true;
  }

  /**************************************************************
  Funcao: carrega_configs_geral
  Descri��o: Carrega as configura��es definidas pelo supervisor
  			 na tela ccger.tela.php
  **************************************************************/
  function carrega_configs_geral($agente="-")
  {
	if($agente == "-"){
		$Pes = "SELECT * FROM ".$this->TabelGE;
	}else{
		$Pes = "SELECT g.popup, g.refresh, g.mostrar_qtd_chamadas, g.filasdinamicas, g.entrarpausaauto, g.nomepausa, g.retirarpausaauto, g.tipopausaretirar FROM ".$this->TabelGE." g INNER JOIN ".$this->TabelaA." a On a.grupo = g.grupo WHERE a.login = '".$agente."'";
	}
	  $Res = $this->Bd->executa_query_com_saida($Pes);
	  return $Res;
  }


/**************************************************************
  Funcao: carrega_tipoNS()
  Descri��o: Carrega o tipo de formula que ser� usada para os
			 relat�rios nos relat�rios.
  Retorno: 0 -> % de chamadas que n�o ultrapassaram o tempo
		   m�ximo de espera da fila, dentre o total de recebidas
		   na fila.

		   1 -> % de chamadas que n�o ultrapassaram o tempo
		   m�ximo de espera da fila, dentre o total de
	       atendidas por operadores na fila.
  **************************************************************/
  function carrega_tipoNS(){
	$Pes = "Select tipons from ".$this->TabelGE." Limit 1";
	$Res = $this->Bd->executa_query_com_saida($Pes);
	return $Res;
  }


  function apaga_agente_monitoramento($Monitora, $Monitorado)
  {
	  $Pes = "DELETE FROM ".$this->TabelaLoginGrupo." WHERE loginmonitora='".$Monitora."' AND agentemonitora='".$Monitorado."'";
	  $Res = $this->Bd->executa_query_sem_saida($Pes);
	  if($Res) return 0;
	  else return 1;
  }
  /*********************************************
   Funcao:      lista_campos_tabelagrade
   Descricao:   Esta funcao busca do banco
                os tempos de atendimentos,
				esperas e desistencia das filas
  *********************************************/
  function lista_campos_tabelagrade($Fila){
      $Saida = false;
      /*$Pes = "SELECT ".$this->TabelaF.".id FROM ".$this->TabelaF." WHERE pseudonimo='".$Fila."'";
	  $Res = $this->Bd->executa_query_com_saida($Pes);
	  if($Res) $Saida = $Res;

	  $Pes = "SELECT * FROM ".$this->TabelFG." WHERE ".$this->TabelFG.".fila =".$Saida[0]['id'];
	  $Res = $this->Bd->executa_query_com_saida($Pes);
	  if($Res) $Saida = $Res;*/

	  $Pes = "SELECT * FROM ".$this->TabelaF." , ".$this->TabelFG." WHERE ";
	  $Pes .= $this->TabelaF.".id = ".$this->TabelFG.".fila AND ";
	  $Pes .= $this->TabelaF.".nome ='".$Fila."'";

      $Res = $this->Bd->executa_query_com_saida($Pes);
      if($Res) $Saida = $Res;
	  return $Saida;
  }

  function lista_agentes_ocultos($RS){
	$Saida = false;
	$Pes = "SELECT * FROM ".$this->TabelMM." WHERE ramal_supervisor='".$RS."'";
	$agentes = $this->Bd->executa_query_com_saida($Pes);
	if($agentes) $Saida = $agentes;
	return $Saida;
  }

  function deleta_agente_da_lista_de_ocultos($id){
	$Saida = false;
	$Pes = "DELETE FROM ".$this->TabelMM." WHERE id=".$id;
	$Res = $this->Bd->executa_query_sem_saida($Pes);
	if($Res) $Saida = true;
	return $Saida;
  }

/************************************************
  Lista todas as filas de um agente de acordo com
  o numero do agente passado por par�metro.
*************************************************/
  function lista_filas_pelo_agente($agente=''){
	$Saida = false;
	if($agente != ''){
        //Antes pegava as filas do grupo...
		//$Pes = "Select f.pseudonimo From ".$this->TabelaF." f Inner Join ".$this->TabelGF." gf On gf.fila = f.id Inner Join ".$this->TabelaG." g On gf.grupo = g.id Inner Join ".$this->TabelaA." a On a.grupo = g.nome Where a.login = '".$agente."'";
        $Pes = "SELECT f.pseudonimo FROM vm50_filas AS f INNER JOIN vm50_filas_membros AS fm ON fm.fila = f.id INNER JOIN vm50_agentes AS a ON a.id = fm.agente WHERE a.login = '".$agente."'";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		$Saida = $Res;
	}
	return $Saida;
  }

/************************************************
	Lista todas as filas de um grupo de acordo
	com o nome do grupo passado por par�metro
*************************************************/
	function lista_filas_pelo_grupo($grupo=""){
		$saida = false;
		if($grupo!=""){
			$Pes = "SELECT id FROM vm50_grupos WHERE nome like '".$grupo."'";
			$Res = $this->Bd->executa_query_com_saida($Pes);
			$Pes = "SELECT f.pseudonimo as fila FROM vm50_filas as f INNER JOIN vm50_grupos_filas AS gf ON gf.fila = f.id WHERE gf.grupo = ".$Res[0]["id"];
        	$saida = $this->Bd->executa_query_com_saida($Pes);
		}
		return $saida;
	}

/************************************************
Retorna o penalty de acordo com os dados passados
por par�metro.
*************************************************/
	function buscarPenalty($var, $tipo="id"){
		if($var['fila']!="" && $var['agente']!="" && $tipo=="id"){
			$Pes = "SELECT fa.id, fa.penalty FROM ".$this->TabelFA." fa INNER JOIN ".$this->TabelaA." a On a.id = fa.agente WHERE a.login = '".$var['agente']."' And fa.fila = '".$var['fila']."'";

		} elseif ($var['fila']!="" && $var['agente']!="" && $tipo=="nome"){
			$Pes = "SELECT fa.id, fa.penalty FROM ".$this->TabelFA." fa INNER JOIN ".$this->TabelaA." a ON a.id = fa.agente INNER JOIN ".$this->TabelaF." f ON fa.fila = f.id WHERE f.nome = '".$var['fila']."' AND a.login = '".$var['agente']."'";
		}
		$Res = $this->Bd->executa_query_com_saida($Pes);
		return $Res;
	}

	/****************************************************************************
		Insere o agente na fila pelo asterisk com o QueueAdd
	*****************************************************************************/
	function atualiza_agentes_filas_asterisk($Agente, $Fila, $Penalty=0, $Tipo='agente'){
		$Agente = trim($Agente);
		if($this->TipoFilaDinamica=="0"){
			if($Tipo == "agente"){
				/*FAZ INSER��O VIA AMI*/
				if($this->Ami->conectar()){
					$this->Ami->enviar_comando("Action: QueueRemove\r\nQueue: ".$Fila."\r\nInterface: Agent/".$Agente);
					$this->Ami->enviar_comando("Action: QueueAdd\r\nQueue: ".$Fila."\r\nInterface: Agent/".$Agente."\r\nPenalty: ".$Penalty."\r\nPaused: false");
					$this->Ami->desconectar();
				}
				/*$this->Meia->envia_socket("Action: QueueRemove\r\nQueue: ".$Fila."\r\nInterface: Agent/".$Agente);
				$resposta = $this->Meia->envia_socket("Action: QueueAdd\r\nQueue: ".$Fila."\r\nInterface: Agent/".$Agente."\r\nPenalty: ".$Penalty."\r\nPaused: false");*/
			} else if($Tipo == "ramal"){
				/*FAZ INSER��O VIA AMI*/
				if($this->Ami->conectar()){
					$this->Ami->enviar_comando("Action: QueueRemove\r\nQueue: ".$Fila."\r\nInterface: Sip/".$Agente);
					$this->Ami->enviar_comando("Action: QueueAdd\r\nQueue: ".$Fila."\r\nInterface: Sip/".$Agente."\r\nPenalty: ".$Penalty."\r\nPaused: false");
					$this->Ami->desconectar();
				}
				/*$this->Meia->envia_socket("Action: QueueRemove\r\nQueue: ".$Fila."\r\nInterface: Sip/".$Agente);
				$resposta = $this->Meia->envia_socket("Action: QueueAdd\r\nQueue: ".$Fila."\r\nInterface: Sip/".$Agente."\r\nPenalty: ".$Penalty."\r\nPaused: false");*/
			}
		} else if($this->TipoFilaDinamica=="1"){
			$linhas = file_get_contents($this->Dir_conf_aterisk."queues.conf");
			$linhas = explode("\n", $linhas);
			$out = "";
			$insere = false;
			for($i = 0; $i < count($linhas); $i++){
				if(trim($linhas[$i]) == "[".$Fila."]") $insere = true;
				if($linhas[$i][0] == "[") $out .= "\n";
				if($linhas[$i] != ""){
					$aux1 = explode(",", $linhas[$i]);
					if($Tipo=="agente"){
						if($insere && $aux1[0] == "member => Agent/".$Agente) {
							$aux = explode(",", $linhas[$i]);
							if($aux[1] != $Penalty) $linhas[$i] = $aux[0].",".$Penalty;
							$insere = false;
						}
					} else {
						if($insere && $aux1[0] == "member => SIP/".$Agente) {
							$aux = explode(",", $linhas[$i]);
							if($aux[1] != $Penalty) $linhas[$i] = $aux[0].",".$Penalty;
							$insere = false;
						}
					}

					$out .= $linhas[$i]."\n";
					if(trim($linhas[$i+1]) == "" && $insere){
						if($Tipo=="agente") $out .= "member => Agent/".$Agente.",".$Penalty."\n";
						else $out .= "member => SIP/".$Agente.",".$Penalty."\n";
						$insere = false;
					}
					if(substr($linhas[$i], 0, 6) == "member" && $insere && $linhas[$i+1]==""){
						if($Tipo=="agente") $out .= "member => Agent/".$Agente.",".$Penalty."\n";
						else $out .= "member => SIP/".$Agente.",".$Penalty."\n";
						$insere = false;
					}
				}
			}
			unlink($this->Dir_conf_aterisk."queues.conf");
			file_put_contents($this->Dir_conf_aterisk."queues.conf", $out);
			$this->reload_asterisk();
			return true;
		}
		return $resposta;
	}

	/****************************************************************************
		Atualiza o penalty daquele agente de acordo com a fila
	*****************************************************************************/
	function atualiza_agentes_filas($Agente, $Fila, $Penalty=0){
		$Saida = false;

		$Pes = "SELECT id FROM ".$this->TabelaA." WHERE login = '".$Agente."'";
		$Res = $this->Bd->executa_query_com_saida($Pes);

		if(count($Res) > 0){
			$Pes = "SELECT fa.id FROM ".$this->TabelFA." fa INNER JOIN ".$this->TabelaA." a ON a.login = '".$Agente."' INNER JOIN ".$this->TabelaF." f ON f.nome = '".$Fila."' WHERE fa.fila = f.id AND fa.agente = a.id";
			$Res = $this->Bd->executa_query_com_saida($Pes);

			if(count($Res) == 1){
				$resp = $this->atualiza_agentes_filas_asterisk($Agente,$Fila,$Penalty,'agente');
				$Pes = "UPDATE ".$this->TabelFA." SET penalty = '".$Penalty."' WHERE id = '".$Res[0]['id']."'";
				$Res = $this->Bd->executa_query_sem_saida($Pes);
				//if($Res) $Saida = true;
				$Saida = $resp;
			}else{
				$resp = $this->atualiza_agentes_filas_asterisk($Agente,$Fila,$Penalty,'agente');
				//return $resp;
				$Saida = $this->insere_filas_agentes($Fila,$Agente,$Penalty);
				//if($Res) $Saida = true;
				$Saida = $resp;
			}
		}else{
			$Pes = "SELECT id FROM ".$this->TabelaR." WHERE ramal = '".$Agente."'";
			$Res = $this->Bd->executa_query_com_saida($Pes);
			if(count($Res) > 0){
				$Pes = "SELECT fa.id FROM ".$this->TabelFA." fa INNER JOIN ".$this->TabelaR." r ON r.ramal = '".trim($Agente)."' INNER JOIN ".$this->TabelaF." f ON f.nome = '".$Fila."' WHERE fa.fila = f.id AND fa.agente = r.id";
				$Res = $this->Bd->executa_query_com_saida($Pes);

				if(count($Res) == 1){
					$resp = $this->atualiza_agentes_filas_asterisk($Agente,$Fila,$Penalty,'ramal');
					$Pes = "UPDATE ".$this->TabelFA." SET penalty = '".$Penalty."' WHERE id = '".$Res[0]['id']."'";
					$Res = $this->Bd->executa_query_sem_saida($Pes);
					if($Res) $Saida = true;
				}else{
					$resp = $this->atualiza_agentes_filas_asterisk($Agente,$Fila,$Penalty,'ramal');
					$Saida = $this->insere_filas_agentes($Fila,$Agente,$Penalty);
					return $Saida;
					if($Res) $Saida = true;
				}
			}
		}
		return $Saida;
	}

	/*********************************************************************************
	Busca as filas do agente de acordo com o agente passado e retorna uma string
	no seguinte formato: 0800|SUPORTE|VOICE|0500
	Separados por pipe |
	**********************************************************************************/
	function carrega_filas_agente($Agente, $tipo="string"){
		$Pes = "SELECT id FROM ".$this->TabelaA." WHERE login = '".$Agente."'";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		if(count($Res) == 1){
			$Pes = "SELECT f.*, fa.penalty FROM ".$this->TabelaF." f INNER JOIN ".$this->TabelFA." fa ON f.id = fa.fila WHERE fa.agente = ".$Res[0]['id'];
			$Res = $this->Bd->executa_query_com_saida($Pes);
			if($tipo == "array") return $Res;
		}
		if(count($Res)>0){
			$saida = "";
			foreach($Res as $dados){
				if($tipo == "string") $saida .= $dados['pseudonimo']."|".$dados['penalty']."||";
			}
		}else{
			$saida = false;
		}
		return $saida;
	}

	/*****************************************************************************************
	Busca as filas antigas do agente (aquelas que est�o na tabela vm50_agentes_desabilitados.
	Retorno:
		Tipo: array
		Dados: campos da tabela fila
	******************************************************************************************/
	function carrega_filas_antigas($agente){
		$sql = "SELECT f.* FROM vm50_filas as f INNER JOIN vm50_agentes_desabilitados as ad ON f.id = ad.id_fila INNER JOIN vm50_agentes as a ON a.id = ad.id_agente WHERE a.login = '".$agente."'";
		return $this->Bd->executa_query_com_saida($sql);
	}

	/*****************************************************************************************
	Insere agente e fila na tabela vm50_agentes_desabilitados
	******************************************************************************************/
	function insere_fila_antiga($agente, $fila){
		$sql = "SELECT id FROM vm50_agentes WHERE login = '".$agente."'";
		$agente = $this->Bd->executa_query_com_saida($sql);

		$sql = "SELECT id FROM vm50_filas WHERE nome like '".$fila."'";
		$fila = $this->Bd->executa_query_com_saida($sql);

		$sql = "INSERT INTO vm50_agentes_desabilitados (id_agente, id_fila) VALUES (".$agente[0]['id'].", ".$fila[0]['id'].")";
		$res = $this->Bd->executa_query_sem_saida($sql);
	}

	/****************************************************************************
	Deleta agente e fila da tabela vm50_agentes_desabilitados
	*****************************************************************************/
	function deleta_agente_fila_antiga($agente, $fila){
		$sql = "DELETE FROM vm50_agentes_desabilitados WHERE id_agente = (SELECT id FROM vm50_agentes WHERE login = '".$agente."') AND id_fila = (SELECT id FROM vm50_filas WHERE nome LIKE '".$fila."')";
		$res = $this->Bd->executa_query_sem_saida($sql);
	}

	/****************************************************************************
		Remove o agente na fila pelo asterisk com o QueueRemove
	*****************************************************************************/
	function remove_agentes_filas_asterisk($Agente, $Fila){
		$Agente = trim($Agente);
		$Pes = "SELECT id FROM ".$this->TabelaA." WHERE login = '".$Agente."'";
		$Res = $this->Bd->executa_query_com_saida($Pes);

		if(count($Res) > 0){
			if($this->TipoFilaDinamica=="0"){
				if($this->Ami->conectar()){
					$this->Ami->enviar_comando("Action: QueueRemove\r\nQueue: ".$Fila."\r\nInterface: Agent/".$Agente);
					$this->Ami->desconectar();
				}

				//$this->Meia->envia_socket("Action: QueueRemove\r\nQueue: ".$Fila."\r\nInterface: Agent/".$Agente);
			}else if($this->TipoFilaDinamica=="1"){
				$linhas = file_get_contents($this->Dir_conf_aterisk."queues.conf");
				$linhas = explode("\n", $linhas);
				$out = "";
				$remove = false;
				for($i = 0; $i < count($linhas); $i++){
					if(trim($linhas[$i]) == "[".$Fila."]") $remove = true;
					if($linhas[$i][0] == "[" && trim($linhas[$i]) != "[".$Fila."]") $remove = false;
					if($linhas[$i][0] == "[") $out .= "\n";
					if($linhas[$i] != ""){
						if(substr($linhas[$i], 0, (16 + strlen($Agente))) == "member => Agent/".$Agente && $remove){
							$remove = false;
							continue;
						}
						$out .= $linhas[$i]."\n";
					}
				}
				unlink($this->Dir_conf_aterisk."queues.conf");
				file_put_contents($this->Dir_conf_aterisk."queues.conf", $out);
				$this->reload_asterisk();
			}

			$Pes = "SELECT fa.id FROM ".$this->TabelFA." fa INNER JOIN ".$this->TabelaA." a ON a.login = '".$Agente."' INNER JOIN ".$this->TabelaF." f ON f.nome = '".$Fila."' WHERE fa.fila = f.id AND fa.agente = a.id";
			$Res = $this->Bd->executa_query_com_saida($Pes);

			if($Res){
				$Pes = "DELETE FROM ".$this->TabelFA." WHERE id = ".$Res[0]['id'];
				$Res = $this->Bd->executa_query_sem_saida($Pes);
			}
		} else {
			$Pes = "SELECT id FROM ".$this->TabelaR." WHERE ramal = '".$Agente."'";
			$Res = $this->Bd->executa_query_com_saida($Pes);
			if(count($Res) > 0){
					if($this->TipoFilaDinamica=="0"){
						if($this->Ami->conectar()){
						$this->Ami->enviar_comando("Action: QueueRemove\r\nQueue: ".$Fila."\r\nInterface: Sip/".$Agente);
						$this->Ami->desconectar();
					}
					//$this->Meia->envia_socket("Action: QueueRemove\r\nQueue: ".$Fila."\r\nInterface: Sip/".$Agente);
				}else if($this->TipoFilaDinamica=="1"){
					$linhas = file_get_contents($this->Dir_conf_aterisk."queues.conf");
					$linhas = explode("\n", $linhas);
					$out = "";
					$remove = false;
					for($i = 0; $i < count($linhas); $i++){
						if(trim($linhas[$i]) == "[".$Fila."]") $remove = true;
						if($linhas[$i][0] == "[") $out .= "\n";
						if($linhas[$i] != ""){
							if(substr($linhas[$i], 0, (14 + strlen($Agente))) == "member => SIP/".$Agente && $remove){
								$remove = false;
								continue;
							}
							$out .= $linhas[$i]."\n";
						}
					}
					unlink($this->Dir_conf_aterisk."queues.conf");
					file_put_contents($this->Dir_conf_aterisk."queues.conf", $out);
					$this->reload_asterisk();
				}

				//$Pes = "SELECT fa.id FROM ".$this->TabelFA." fa INNER JOIN ".$this->TabelaR." r ON r.ramal = '".$Agente."' INNER JOIN ".$this->TabelaF." f ON f.pseudonimo = '".$Fila."' WHERE fa.fila = f.id AND fa.agente = r.id";
				$Pes = "SELECT id FROM vm50_filas_ramais WHERE ramal = (SELECT id FROM vm50_ramais WHERE ramal = '".trim($Agente)."') AND fila = (SELECT id FROM vm50_filas WHERE nome = '".$Fila."')";
				$Res = $this->Bd->executa_query_com_saida($Pes);

				if($Res){
					$Pes = "DELETE FROM vm50_filas_ramais WHERE id = ".$Res[0]['id'];
					$Res = $this->Bd->executa_query_sem_saida($Pes);
				}
			}
		}

		return 1;
	}

	function lista_codigos_contas(){
		$Pes = "Select * from vm50_codigo_conta";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		return $Res;
	}

	function inserir_cod_conta($codigo, $nome){
		$Pes = "INSERT INTO vm50_codigo_conta (codigo, nome) VALUES (".$codigo.", '".$nome."')";
		$Res = $this->Bd->executa_query_sem_saida($Pes);
		return $Res;
	}

	function alterar_cod_conta($id, $codigo, $nome){
		$Pes = "UPDATE vm50_codigo_conta SET codigo = ".$codigo.", nome = '".$nome."' WHERE id = ".$id;
		$Res = $this->Bd->executa_query_sem_saida($Pes);
		return $Res;
	}

	function deletar_cod_conta($id){
		$Pes = "DELETE FROM vm50_codigo_conta WHERE id = ".$id;
		$Res = $this->Bd->executa_query_sem_saida($Pes);
		return $Res;
	}

	function carrega_fila_entrar_pausa_auto($agente=""){
		if($agente=="") $Pes = "SELECT pseudonimo, entrarpausaauto, pausaautomatica, tempodepausa FROM ".$this->TabelaF;
		else $Pes = "SELECT f.pseudonimo, f.entrarpausaauto, f.pausaautomatica FROM ".$this->TabelaF." f
					INNER JOIN ".$this->TabelFA." fm ON f.id = fm.fila
					INNER JOIN ".$this->TabelaA." a ON a.id = fm.agente
					WHERE a.login = '".$agente."'";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		return $Res;
	}

	function carrega_fila_retirar_pausa_auto($agente=""){
		if($agente=="") $Pes = "SELECT pseudonimo, retirarpausaauto FROM ".$this->TabelaF;
		else $Pes = "SELECT f.pseudonimo, f.retirarpausaauto, f.spa FROM ".$this->TabelaF." f
					INNER JOIN ".$this->TabelFA." fm ON f.id = fm.fila
					INNER JOIN ".$this->TabelaA." a ON a.id = fm.agente
					WHERE a.login = '".$agente."'";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		return $Res;
	}

	function carrega_pausa_pelo_agente($Agente){
		$Pes = "SELECT p.* FROM ".$this->TabelaP." p
				INNER JOIN ".$this->TabelaA." a ON p.nome = a.tipopausa
				WHERE a.login = '".$Agente."'";
				//return $Pes;
		$Res = $this->Bd->executa_query_com_saida($Pes);
		return $Res;
	}

	function consulta_pausa($Nome){
		$Pes = "SELECT * FROM ".$this->TabelaP." WHERE nome = '".$Nome."'";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		return $Res;
	}

	function carrega_agentes_fila($fila){
		$Pes = "SELECT a.login FROM ".$this->TabelaA." as a INNER JOIN ".$this->TabelFA." as fm ON a.id = fm.agente INNER JOIN ".$this->TabelaF." as f ON f.id = fm.fila WHERE f.nome = '".$fila."' ORDER BY a.login";
		return $this->Bd->executa_query_com_saida($Pes);
	}

	function lista_agentes_ramais(){
		$Pes = "SELECT r.ramal, a.login, a.id FROM vm50_agentes as a INNER JOIN ".$this->TabelAR." as ar ON ar.agente = a.id INNER JOIN vm50_ramais as r ON ar.ramal = r.id ORDER BY a.login";
		return $this->Bd->executa_query_com_saida($Pes);
	}

	function consulta_agente_do_ramal($id_ramal){
		$Pes = "SELECT a.login, a.pseudonimo, a.id FROM ".$this->TabelaA." as a INNER JOIN ".$this->TabelAR." as ar ON ar.agente = a.id INNER JOIN ".$this->TabelaR." as r ON r.id = ar.ramal WHERE r.id = ".$id_ramal;
		return $this->Bd->executa_query_com_saida($Pes);
	}

	function inserir_agente_ramal($id_agente, $id_ramal){
		$Pes = "SELECT * FROM ".$this->TabelAR." WHERE ramal = ".$id_ramal;
		$Res = $this->Bd->executa_query_com_saida($Pes);
		if(count($Res) == 0) $Pes = "INSERT INTO ".$this->TabelAR." (agente, ramal) VALUES (".$id_agente.", ".$id_ramal.")";
		else $Pes = "UPDATE ".$this->TabelAR." SET agente = ".$id_agente." WHERE id = ".$Res[0]['id'];
		return $this->Bd->executa_query_sem_saida($Pes);
	}

	function deletar_agente_ramal($id_ramal){
		$Pes = "DELETE FROM ".$this->TabelAR." WHERE ramal = ".$id_ramal;
		return $this->Bd->executa_query_sem_saida($Pes);
	}

	function inserir_agente_ramal_asterisk($Ramal, $Agente){
		$Pes = "SELECT senha FROM ".$this->TabelaA." WHERE login = '".$Agente."'";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		if(count($Res) > 0){
			$Senha = $Res[0]['senha'];
			$Saida = $this->logar_pa($Agente,$Senha,$Ramal);
		}
		return $Saida;
	}

	function atualiza_campo_filas_agente($agente, $filas){
		$Pes = "UPDATE vm50_agentes SET filas = '".$filas."' WHERE id = ".$agente;
		return $this->Bd->executa_query_com_saida($Pes);
	}

	function carrega_agente_por_login($login){
		$Pes = "SELECT * FROM ".$this->TabelaA." WHERE login = '".$login."'";
		return $this->Bd->executa_query_com_saida($Pes);
	}

	function carrega_grupo_agente_pelo_login($login){
		$Pes = "SELECT g.* FROM ".$this->TabelaG." AS g INNER JOIN ".$this->TabelaA." AS a ON g.nome = a.grupo WHERE a.login = '".$login."'";
		return $this->Bd->executa_query_com_saida($Pes);
	}

	function lista_agentes_nao_relacionados(){
		$Pes = "SELECT login FROM ".$this->TabelAL." GROUP BY login";
		$Res = $this->Bd->executa_query_com_saida($Pes);

		$Pes2 = "SELECT * FROM ".$this->TabelaA." ORDER BY login";
		$Res2 = $this->Bd->executa_query_com_saida($Pes2);

		$Saida = array();
		for($i = 0; $i < count($Res2); $i++){
			$jaFoi = false;
			for($j = 0; $j < count($Res); $j++){
				if($Res2[$i]['id'] == $Res[$j]['login']) $jaFoi = true;
			}
			if(!$jaFoi) array_push($Saida, $Res2[$i]);
		}
		return $Saida;
	}

	function lista_agentes_relacionados($id_agente){
		$Pes = "SELECT ag.* FROM ".$this->TabelaA." AS ag INNER JOIN ".$this->TabelAL." AS al ON ag.id = al.login WHERE al.agente = ".$id_agente." ORDER BY login";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		return $Res;
	}

	function lista_ramais_relacionados($Ramal){
		$Pes = "SELECT id FROM vm50_ramais WHERE ramal = '".$Ramal."'";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		$Pes = "SELECT r.* FROM vm50_ramais AS r INNER JOIN vm50_ramais_relacionados AS rr ON rr.ramal = r.id WHERE rr.pai = ".$Res[0]['id']." ORDER BY r.ramal";
		return $this->Bd->executa_query_com_saida($Pes);
	}

	function lista_id_pelo_login($login){
		$Pes = "SELECT id FROM vm50_agentes WHERE login = '".$login."'";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		return $Res[0]['id'];
	}

	function carrega_status_agente($agente){
		$Pes = "SELECT situacao, EXTRACT(EPOCH FROM DATE_TRUNC('second',ult_estad)) as ultimo FROM vm50_agentes WHERE login = '".$agente."'";
		return $this->Bd->executa_query_com_saida($Pes);
	}

	function carrega_grupo_por_agente($agente){
		$Pes = "SELECT g.* FROM vm50_grupos as g INNER JOIN vm50_agentes as a ON a.grupo = g.nome WHERE a.login = '".$agente."'";
		return $this->Bd->executa_query_com_saida($Pes);
	}

	function carrega_alarmes_por_id($Id){
		$Pes = "SELECT * FROM vm50_alarmes WHERE usuario = ".$Id;
		return $this->Bd->executa_query_com_saida($Pes);
	}

	function altera_alarmes($usuario, $gcon, $fcon, $xcon, $tpau, $tliv, $tcos, $tcoa, $tcon, $tesa){
		$Pes = "SELECT * FROM vm50_alarmes WHERE usuario = ".$usuario;
		$Res = $this->Bd->executa_query_com_saida($Pes);
		if(count($Res) > 0){
			$Pes = "UPDATE vm50_alarmes SET grupo_congestionado='".$gcon."', fila_congestionada='".$fcon."', feixe_congestionado='".$xcon."', tempo_pausa='".$tpau."', tempo_livre='".$tliv."', tempo_conversacao_saida='".$tcos."', tempo_conversacao_atendimento='".$tcoa."', tempo_consulta='".$tcon."', tempo_fila_espera='".$tesa."' WHERE usuario=".$usuario;
			$Res = $this->Bd->executa_query_sem_saida($Pes);
		} else {
			$Pes = "INSERT INTO vm50_alarmes (grupo_congestionado, fila_congestionada, feixe_congestionado, tempo_pausa, tempo_livre, tempo_conversacao_saida, tempo_consulta, tempo_fila_espera, usuario) VALUES('".$gcon."', '".$fcon."', '".$xcon."', '".$tpau."', '".$tliv."', '".$tcos."', '".$tcoa."', '".$tcon."', '".$tesa."', ".$usuario.")";
			$Res = $this->Bd->executa_query_sem_saida($Pes);
		}
		return $Res;
	}

	function informa_livre_discador($enderecoApi, $agente, $campanhas){
		$tipo = "S";
		for($i = 0; $i < count($campanhas); $i++){
			$sql = "SELECT c.titulo as nomecamp, c.prioridade as prioridadecamp, g.nome as nomegrupo, g.prioridade as prioridadegrupo, g.tipo as tipogrupo FROM vm50_campanhas as c INNER JOIN vm50_arvore_grupos as g ON c.grupo = g.id WHERE c.titulo LIKE '".$campanhas[$i]."' ORDER BY g.prioridade, c.prioridade";
			$res = $this->Bd->executa_query_com_saida($sql);
			$campanhasArr["grupo"][$res[0]["prioridadegrupo"]]["campanha"][$res[0]["prioridadecamp"]] = $res[0]["nomecamp"];
			if($res[0]["tipogrupo"] == "balanceado") $tipo = "B";
		}

		ksort($campanhasArr["grupo"]);
		foreach($campanhasArr["grupo"] as $camp){
			ksort($camp["campanha"]);
		}
		$campanhas_s = "";
		foreach($campanhasArr["grupo"] as $grupo){
			foreach($grupo["campanha"] as $camp){
				if($camp!='') $campanhas_s .= $camp.",";
			}
		}
		if($campanhas_s=="") return "Erro: campanhas n�o encontradas em prioridades.";
		$campanhas_s = substr($campanhas_s, 0, -1)."&tipo=".$tipo;

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_URL, $enderecoApi."/discador/acao/agente/".$agente."?campanha=".$campanhas_s);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $ordem);

		$result = curl_exec($ch);
		curl_close($ch);
		//return $enderecoApi."/discador/acao/agente/".$agente."?campanha=".$campanhas_s;
		return "Retorno API: ".$result;
	}

	function informa_indisponivel_discador($enderecoApi, $agente, $campanhas){
		$tipo = "I";
		for($i = 0; $i < count($campanhas); $i++){
			$sql = "SELECT c.titulo as nomecamp, c.prioridade as prioridadecamp, g.nome as nomegrupo, g.prioridade as prioridadegrupo, g.tipo as tipogrupo FROM vm50_campanhas as c INNER JOIN vm50_arvore_grupos as g ON c.grupo = g.id WHERE c.titulo LIKE '".$campanhas[$i]."' ORDER BY g.prioridade, c.prioridade";
			$res = $this->Bd->executa_query_com_saida($sql);
			$campanhasArr["grupo"][$res[0]["prioridadegrupo"]]["campanha"][$res[0]["prioridadecamp"]] = $res[0]["nomecamp"];
		}

		ksort($campanhasArr["grupo"]);
		foreach($campanhasArr["grupo"] as $camp){
			ksort($camp["campanha"]);
		}
		$campanhas_s = "";
		foreach($campanhasArr["grupo"] as $grupo){
			foreach($grupo["campanha"] as $camp){
				$campanhas_s .= $camp.",";
			}
		}
		if($campanhas_s=="") return "Erro: campanhas n�o encontradas em prioridades.";
		$campanhas_s = substr($campanhas_s, 0, -1)."&tipo=".$tipo;

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_URL, $enderecoApi."/discador/acao/agente/".$agente."?campanha=".$campanhas_s);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $ordem);

		$result = curl_exec($ch);
		curl_close($ch);
		return "Retorno API: ".$result;
	}

	function reload_asterisk(){
		$this->Ami->conectar();
		$Saida = $this->Ami->enviar_comando("ACTION: COMMAND\r\ncommand: reload");
		$this->Ami->desconectar();
		return print_r($Saida, true);
	}

	function limpa_fila($Fila){
		if($this->TipoFilaDinamica=="0") return;
		$linhas = file_get_contents($this->Dir_conf_aterisk."queues.conf");
		$linhas = explode("\n", $linhas);
		$out = "";
		$insere = false;
		for($i = 0; $i < count($linhas); $i++){
			if(trim($linhas[$i]) == "[".$Fila."]") $insere = true;
			if($linhas[$i][0] == "[") $out .= "\n";
			if($linhas[$i] != ""){
				if($insere) {
					if(substr($linhas[$i], 0, 6) != "member") $out .= $linhas[$i]."\n";
					if($linhas[$i][0] == "[" && trim($linhas[$i]) != "[".$Fila."]") $insere = false;
				} else $out .= $linhas[$i]."\n";
			}
		}
		unlink($this->Dir_conf_aterisk."queues.conf");
		file_put_contents($this->Dir_conf_aterisk."queues.conf", $out);
	}

	function lista_uf($tipo="uf"){
		if($tipo=="uf") $Pes = "SELECT uf FROM vm50_ddd GROUP BY uf ORDER BY uf";
		return $this->Bd->executa_query_com_saida($Pes);
	}

	function alterar_config_syonet($ip_crm, $usuario_crm, $senha_crm, $dominio_crm){
		$sql = "SELECT * FROM vm50_config_syonet";
		$res = $this->Bd->executa_query_com_saida($sql);
		if(count($res) > 0){
			$sql = "UPDATE vm50_config_syonet SET ip_crm = '".$ip_crm."', usuario_crm = '".$usuario_crm."', senha_crm = '".$senha_crm."', dominio_crm = '".$dominio_crm."'";
		} else {
			$sql = "INSERT INTO vm50_config_syonet (ip_crm, usuario_crm, senha_crm, dominio_crm) VALUES ('".$ip_crm."', '".$usuario_crm."', '".$senha_crm."', '".$dominio_crm."')";
		}
		$res = $this->Bd->executa_query_sem_saida($sql);
		return $res;
	}

	function listar_config_syonet(){
		$sql = "SELECT * FROM vm50_config_syonet";
		$res = $this->Bd->executa_query_com_saida($sql);
		return $res;
	}

	function incluir_fila_syonet($fila_crm, $operacao_crm, $empresa_crm, $mcdu_crm, $caixa_crm, $email_notifica){
		$sql = "INSERT INTO vm50_filas_syonet (fila_crm, operacao_crm, empresa_crm, mcdu_crm, caixa_postal_crm, email_notifica) VALUES ('".$fila_crm."', '".$operacao_crm."', '".$empresa_crm."', '".$mcdu_crm."', '".$caixa_crm."', '".$email_notifica."')";
		$res = $this->Bd->executa_query_sem_saida($sql);
		return $res;
	}

	function alterar_fila_syonet($id, $fila_crm, $operacao_crm, $empresa_crm, $mcdu_crm, $caixa_crm, $email_notifica){
		$sql = "UPDATE vm50_filas_syonet SET fila_crm = '".$fila_crm."', operacao_crm = '".$operacao_crm."', empresa_crm = '".$empresa_crm."', mcdu_crm = '".$mcdu_crm."', caixa_postal_crm = '".$caixa_crm."', email_notifica = '".$email_notifica."' WHERE id = ".$id;
		$res = $this->Bd->executa_query_sem_saida($sql);
		return $res;
	}

	function deletar_fila_syonet($id){
		$sql = "DELETE FROM vm50_filas_syonet WHERE id = ".$id;
		$res = $this->Bd->executa_query_sem_saida($sql);
		return $res;
	}

	function listar_filas_syonet(){
		$sql = "SELECT * FROM vm50_filas_syonet ORDER BY fila_crm";
		$res = $this->Bd->executa_query_com_saida($sql);
		return $res;
	}

    function alterar_config_painel_pa($id, $ip_discador, $ddd_local){
        $sql = "UPDATE vm50_config_painel_pa SET ip_discador = '".$ip_discador."', ddd_local = ".$ddd_local." WHERE id = ".$id;
        $res = $this->Bd->executa_query_sem_saida($sql);
        return $res;
    }

    function listar_config_painel_pa(){
        $sql = "SELECT * FROM vm50_config_painel_pa ORDER BY id";
        $res = $this->Bd->executa_query_com_saida($sql);
        return $res;
    }

    function enviar_ligacao_painel($agente, $ip_discador, $numero, $campanha){
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, "http://".$ip_discador."/discador/chamada/send/?agent=".$agente."&phone=".$numero."&campanha=".$campanha);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPGET, true);
        $result = curl_exec($curl);
        curl_close($curl);
        return $result;
    }

    function desligar_ramal($ramal){
        $Texto= "Action: Command\r\nCommand: show channels";
        $Resultado = "";
        if($this->Ami->conectar()){
            $Resultado = false;
            $Resultado = $this->Ami->enviar_comando($Texto);
            $this->Ami->desconectar();
        }
        $channel = "";
        if($Resultado != ""){
            $dados = explode("|", $Resultado);
            foreach($dados as $chave => $valor){
                if(substr($valor, 4, strlen($ramal)) == $ramal){
                    list($channel, $tmp) = explode(" ", $valor);
                    $channel = trim($channel);
                }
            }
        }
        $Texto= "Action: Hangup\r\nChannel: ".$channel."\r\n\r\n";
        if($this->Ami->conectar()){
            $Resultado = false;
            $Resultado = $this->Ami->enviar_comando($Texto);
            $this->Ami->desconectar();
        }
        return $Resultado;
    }

    function transferirLigacao($agente, $origem, $destino, $status, $numero){
        $Texto= "Action: Command\r\nCommand: show channels";
        $Resultado = "";
        $channel = "";
        if($this->Ami->conectar()){
            $Resultado = false;
            $Resultado = $this->Ami->enviar_comando($Texto);
            $this->Ami->desconectar();
        }

        $dados = explode("|", $Resultado);

        foreach($dados as $chave => $valor){
            if(substr($valor, 4, strlen($origem)) == $origem){
                list($channel, $tmp) = explode(" ", $valor);
                $channel = trim($channel);
            }
        }

        if($channel!=""){
            $comando = "Action: Status\r\nChannel: ".$channel;
            //return $comando;
            if($this->Ami->conectar()){
                $retorno = false;
                $retorno = $this->Ami->enviar_comando($comando, "Event: StatusComplete\r\n", "Message: No such channel\r\n");
                $this->Ami->desconectar();
            }

            if($retorno != ""){
                $dados = explode("|", $retorno);
                $channelDest = "";
                foreach($dados as $chave => $valor){
                    if(substr($valor, 0, 4) == "Link"){
                        list($tmp, $channelDest) = explode(" ", $valor);
                        $channelDest = trim($channelDest);
                    }
                }

                if($channelDest != "" && substr($channelDest, 0, 5) != "Agent"){
                    $channel = $channelDest;
                } else {
                    $comando = "Action: Status\r\nChannel: ".$channelDest;
                    //return $comando;
                    if($this->Ami->conectar()){
                        $retorno = false;
                        $retorno = $this->Ami->enviar_comando($comando, "Event: StatusComplete\r\n", "Message: No such channel\r\n");
                        $this->Ami->desconectar();
                    }

                    if($retorno != ""){
                        $dados = explode("|", $retorno);
                        $channelDest = "";
                        foreach($dados as $chave => $valor){
                            if(substr($valor, 0, 4) == "Link"){
                                list($tmp, $channelDest) = explode(" ", $valor);
                                $channelDest = trim($channelDest);
                            }
                        }
                    }

                    $channel = $channelDest;
                }
            }
        }

        /*if($Resultado!=""){
            $dados = explode("|", $Resultado);
            if($status == "Consulta") {
                foreach($dados as $chave => $valor){
                    if(substr($valor, 4, strlen($numero)) == $numero){
                        list($channel, $tmp) = explode(" ", $valor);
                        $channel = trim($channel);
                    }
                }
            } else if($status == "DDR"){
                for($i = 0; $i < count($dados); $i++){
                    if(substr($dados[$i], 4, strlen($origem)) == $origem){
                        list($channel, $tmp) = explode(" ", $dados[$i+1]);
                    }
                }
            } else {
                for($i = 0; $i < count($dados); $i++){
                    if(substr($dados[$i], 4, strlen($origem)) == $origem){
                        if(substr($dados[$i-1], 0, 5) != "Agent"){
                            list($channel, $tmp) = explode(" ", $dados[$i-1]);
                        } else if(substr($dados[$i-1], 0, 10) == "Agent/".trim($agente)){
                            list($channel, $tmp) = explode(" ", $dados[$i+1]);
                        }
                    }
                }
            }
            $channel = trim($channel);
        }

        if($channel!=""){
            $comando = "Action: Redirect\r\nChannel: ".$channel."\r\nContext: interno\r\nExten: ".$destino."\r\nPriority: 1";
            if($this->Ami->conectar()){
                $retorno = false;
                $retorno = $this->Ami->enviar_comando($comando);
                $this->Ami->desconectar();
            }
            return $retorno;
        }*/
        if($channel!=""){
            $comando = "Action: Redirect\r\nChannel: ".$channel."\r\nContext: interno\r\nExten: ".$destino."\r\nPriority: 1";
            //return $comando;
            if($this->Ami->conectar()){
                $retorno = false;
                $retorno = $this->Ami->enviar_comando($comando);
                $this->Ami->desconectar();
            }
            return $retorno;
        }
        return false;
    }

    function listar_agentes_pela_fila($fila){
        $sql = "SELECT a.* FROM vm50_agentes AS a INNER JOIN vm50_filas_membros AS fm ON fm.agente = a.id INNER JOIN vm50_filas AS f ON f.id = fm.fila WHERE f.nome LIKE '".$fila."' ORDER BY a.login";
        $res = $this->Bd->executa_query_com_saida($sql);
        return $res;
    }

    function alterar_config_email($email, $senha, $smtp, $porta_smtp){
        $sql = "SELECT * FROM vm50_conf_email LIMIT 1";
        $res = $this->Bd->executa_query_com_saida($sql);

        if(count($res) == 1) $sql = "UPDATE vm50_conf_email SET email = '".$email."', senha = '".$senha."', smtp = '".$smtp."', porta_smtp = ".$porta_smtp." WHERE id = ".$res[0]["id"];
        else $sql = "INSERT INTO vm50_conf_email (email, senha, smtp, porta_smtp) VALUES ('".$email."', '".$senha."', '".$smtp."', ".$porta_smtp.")";

        return $this->Bd->executa_query_sem_saida($sql);
    }

    function carregar_conf_email(){
        $sql = "SELECT * FROM vm50_conf_email LIMIT 1";
        $res = $this->Bd->executa_query_com_saida($sql);
        return $res[0];
    }

    function deletar_pausas_grupo($idGrupo){
        $sql = "DELETE FROM vm50_pausas_grupos WHERE id_grupo = ".$idGrupo;
        return $this->Bd->executa_query_sem_saida($sql);
    }

    function inserir_pausa_grupo($idGrupo, $idPausa){
        $sql = "INSERT INTO vm50_pausas_grupos (id_grupo, id_pausa) VALUES (".$idGrupo.", ".$idPausa.")";
        return $this->Bd->executa_query_sem_saida($sql);
    }

    function listar_pausas_grupo($idGrupo){
        $sql = "SELECT p.* FROM vm50_pausas AS p INNER JOIN vm50_pausas_grupos as pg ON pg.id_pausa = p.id WHERE pg.id_grupo = ".$idGrupo;
        return $this->Bd->executa_query_com_saida($sql);
    }

    function listar_grupos_consultar_membros_filas(){
        $sql = "SELECT * FROM vm50_grupos WHERE consultar_membros_filas = true";
        return $this->Bd->executa_query_com_saida($sql);
    }

    function listar_filas_grupo($grupo){
        $sql = "SELECT f.* FROM vm50_filas AS f INNER JOIN vm50_grupos_filas AS gf ON gf.fila = f.id INNER JOIN vm50_grupos AS g ON gf.grupo = g.id WHERE g.nome = '".$grupo."'";
        return $this->Bd->executa_query_com_saida($sql);
    }

    function listar_grupos_filas_relat(){
		$saida = array();
		$pes = "SELECT * FROM vm50_grupos_filas_relat ORDER BY nome";
		$res = $this->Bd->executa_query_com_saida($pes);
		$saida = $res;
		$res = array();
		for($i = 0; $i < count($saida); $i++){
			$pes = "SELECT * FROM vm50_filas WHERE id_grupo_relat = ".$saida[$i]["id"];
			$res = $this->Bd->executa_query_com_saida($pes);
			for($j = 0; $j < count($res); $j++){
				$saida[$i]["filas"] = $res;
			}
		}
		return $saida;
	}

	function incluir_grupo_filas_relat($nome){
		$sql = "SELECT * FROM vm50_grupos_filas_relat WHERE nome like '".$nome."'";
		$res = $this->Bd->executa_query_com_saida($sql);
		$id = false;
		if(count($res) == 0){
			$sql = "INSERT INTO vm50_grupos_filas_relat (nome) VALUES ('".$nome."')";
			$res = $res = $this->Bd->executa_query_sem_saida($sql);
			if($res){
				$sql = "SELECT * FROM vm50_grupos_filas_relat WHERE nome like '".$nome."'";
				$res = $this->Bd->executa_query_com_saida($sql);
				$id = $res[0]['id'];
			}
		}
		return $id;
	}

	function alterar_grupo_fila_relat($idGrupo, $idFila){
		if($idGrupo != 0){
			$sql = "SELECT * FROM vm50_grupos_filas_relat WHERE id = ".$idGrupo;
			$res = $this->Bd->executa_query_com_saida($sql);
			if(count($res) > 0){
				$sql = "UPDATE vm50_filas SET id_grupo_relat = ".$idGrupo." WHERE id = ".$idFila;
				$res = $this->Bd->executa_query_sem_saida($sql);
			}
		} else {
			$sql = "UPDATE vm50_filas SET id_grupo_relat = 0 WHERE id = ".$idFila;
			$res = $this->Bd->executa_query_sem_saida($sql);
		}
		return $res;
	}

	function alterar_grupo_filas_relat($id, $nome){
		$sql = "SELECT * FROM vm50_grupos_filas_relat WHERE id = ".$id;
		$res = $this->Bd->executa_query_com_saida($sql);
		if(count($res) > 0){
			$res = false;
			$sql = "UPDATE vm50_grupos_filas_relat SET nome = '".$nome."' WHERE id = ".$id;
			$res = $this->Bd->executa_query_sem_saida($sql);
		}
		return $res;
	}

	function deletar_grupo_filas_relat($id){
		$sql = "DELETE FROM vm50_grupos_filas_relat WHERE id = ".$id;
		$this->Bd->executa_query_sem_saida($sql);
		$sql = "UPDATE vm50_filas SET id_grupo_relat = 0 WHERE id_grupo_relat = ".$id;
		return $this->Bd->executa_query_sem_saida($sql);
	}

	function deletar_grupos_qualificacoes($idGrupo){
		$sql = "DELETE FROM vm50_grupos_qualificacoes WHERE id_grupo = ".$idGrupo;
		return $this->Bd->executa_query_sem_saida($sql);
	}

	function inserir_qualificacao_grupo($idGrupo, $idQualificacao){
		$sql = "INSERT INTO vm50_grupos_qualificacoes (id_grupo, id_classificacao) VALUES (".$idGrupo.", ".$idQualificacao.")";
		return $this->Bd->executa_query_sem_saida($sql);
	}

	function listar_grupo_pelo_nome($nome){
		$sql = "SELECT * FROM vm50_grupos WHERE nome like '".$nome."'";
		return $this->Bd->executa_query_com_saida($sql);
	}

	function listar_qualificacoes_pelo_grupo($idGrupo){
		$sql = "SELECT q.* FROM vm50_classificacao_chamadas AS q INNER JOIN vm50_grupos_qualificacoes AS gq ON gq.id_classificacao = q.id WHERE gq.id_grupo = ".$idGrupo." ORDER BY q.nome";
		return $this->Bd->executa_query_com_saida($sql);
	}

    function listar_fila_pelo_id($id){
        $sql = "SELECT * FROM vm50_filas WHERE id = ".$id;
        return $this->Bd->executa_query_com_saida($sql);
    }

    function listar_agentes_fila($id){
        $sql = "SELECT a.* FROM vm50_agentes AS a INNER JOIN vm50_filas_membros AS fm ON fm.agente = a.id WHERE fm.fila = ".$id;
        return $this->Bd->executa_query_com_saida($sql);
    }

    function listar_turnos_fila_por_id($id_fila){
        $sql = "SELECT * FROM vm50_turnos_filas WHERE fila = ".$id_fila;
        return $this->Bd->executa_query_com_saida($sql);
    }

    function listar_grades_fila_por_id($id_fila){
        $sql = "SELECT * FROM vm50_grades_filas WHERE fila = ".$id_fila;
        return $this->Bd->executa_query_com_saida($sql);
    }
}
?>
