<?php
/**************************************************************
 * Nome:    Monitor
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-01-30 (V1.0.1)
 * Descr.:  Cria classe de monitorar call center
 *************************************************************/

/**************************************************************
Classe Monitores
 *************************************************************/
class Monitores {
	var $Bd;
	var $BdRelat;
	var $BdDiscador;
	var $TabelaU;
	var $TabelaR;
	var $TabelRH;
	var $TabelaF;
	var $TabelaA;
	var $TabelAL;
	var $TabelaG;
	var $TabelaO;
	var $TabelOF;
	var $TabelaL;
	var $TabelaP;
	var $TabelUG;
	var $TabelDD;
	var $TabelFA;
	//var $QNA = array();
	var $Hoje;

	//---------------------------------------------------
	// Construtor da classe.
	//---------------------------------------------------
	function Monitores() {
		$DirRaiz = $_SERVER['DOCUMENT_ROOT'] . '/vdt/';
		include $DirRaiz . 'config.php';
        include $DirRaiz . 'configuracoes.php';
		include $DirRaiz . 'config.cc.php';
		include_once $DirRaiz . $DirClass . 'bd.class.php';
		include_once $DirRaiz . $DirClass . 'bd.relat.class.php';
		include_once $DirRaiz . $DirClass . 'discador.class.php';
		$this->Bd = new Banco();
		$this->BdRelat = new BancoRelat();
		if ($conectar_discador) {
			$this->BdDiscador = new BdDiscador();
		}

		$this->TabelaU = $Tb_Usuar;
		$this->TabelaR = $Tb_FRela;
		$this->TabelRH = $Tb_FRelH;
		$this->TabelaA = $Tb_Agent;
		$this->TabelAL = $Tb_AgLog;
		$this->TabelaG = $Tb_AgeFi;
		$this->TabelaF = $Tb_Fila;
		$this->TabelaO = $Tb_Grupo;
		$this->TabelOF = $Tb_GruFi;
		$this->TabelaL = $Tb_Ligac;
		$this->TabelaP = $Tb_Pausa;
		$this->TabelUG = $Tb_UsuGr;
		$this->Hoje = date("d/m/y");
		$this->TabelDD = $Tb_ddd;
		$this->TabelFA = $Tb_AgeFi;
		//$Pes   = "SELECT pseudonimo,timeout FROM ".$this->TabelaF;
		//$Res   = $this->Bd->executa_query_com_saida($Pes);
		//for ($x=0; $x<count($Res); $x++) $QNA[$Res[$x]['pseudonimo']] = $Res[$x]['timeout'];
	}

	//---------------------------------------------------
	// Funcao le_fila
	//---------------------------------------------------
	function le_fila($Fila = "", $Dehoje = "") {
		$Dia = date("d");
		$Mes = date("m");
		$Ano = date("Y");
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Pes = "SELECT nome AS filas FROM " . $this->TabelaF;
		if ($Fila != "") {
			$Pes .= " WHERE nome='" . $Fila . "'";
		}

		$Pes .= " ORDER BY nome";
		//$Res  = $this->Bd->executa_query_com_saida($Pes);
		$Res = $this->BdRelat->executa_query_com_saida($Pes);
		if (!$Res) {
			$Saida = false;
		} else {
			$Saida = $Res;
		}

		if (false) {
			$Filas = $Res;
			for ($x = 0; $x < count($Filas); $x++) {
				$Filas[$x]['chamadas'] = $Filas[$x]['holdtime'] = $Filas[$x]['atendidas'] = $Filas[$x]['desistencias'] = 0;
			}

			$Pes = "SELECT fila AS filas, COUNT(*) AS chamadas, 0 AS holdtime, COUNT(info2) AS atendidas, (COUNT(*) - COUNT(info2)) AS desistencias FROM " . $Tabela;
			$Pes .= " WHERE EXTRACT(DAY FROM(diahora))=" . $Dia . " AND EXTRACT(MONTH FROM(diahora))=" . $Mes . " AND EXTRACT(YEAR FROM(diahora))=" . $Ano;
			$Pes .= " AND ( info3='Agente' OR info3='Cliente' OR info3='Abandono')";
			if ($Fila != "") {
				$Pes .= " AND fila='" . $Fila . "'";
			}

			$Pes .= " GROUP BY fila ORDER BY fila";
			$Res = $this->Bd->executa_query_com_saida($Pes);
			for ($x = 0; $x < count($Filas); $x++) {
				$y = 0;
				$Achei = 0;
				($Res) ? $Fim = count($Res) : $Fim = 0;
				while (($Achei == 0) && ($y < $Fim)) {
					if ($Filas[$x]['filas'] == $Res[$y]['filas']) {
						$Achei = 1;
						$Filas[$x]['chamadas'] = $Res[$y]['chamadas'];
						$Filas[$x]['holdtime'] = $Res[$y]['holdtime'];
						$Filas[$x]['atendidas'] = $Res[$y]['atendidas'];
						$Filas[$x]['desistencias'] = $Res[$y]['desistencias'];
					}
					$y++;
				}
			}
			$Saida = $Filas;
		}
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao relatorio_agentes
	//
	// Faz select no banco com ou sem login relacionado
	//---------------------------------------------------
	function relatorio_agentes($Agente, $Inicio, $Fim, $Relacionado = false, $Dehoje = "", $tempoMinCon = 0, $eliminaRamais = 0, $filtroNumero = "", $tipoPes = 'monit') {
		$Inicio = trim($Inicio);
		$Fim = trim($Fim);
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$LiR = "";
		if ($Relacionado) {
			$Pes1 = "SELECT " . $this->TabelaA . ".login, " . $this->TabelaA . ".nome, " . $this->TabelaA . ".funcai FROM (SELECT " . $this->TabelAL . ".login  FROM " . $this->TabelAL . " INNER JOIN " . $this->TabelaA . " ON " . $this->TabelaA . ".id=" . $this->TabelAL . ".agente WHERE " . $this->TabelaA . ".login = '" . substr($Agente, 0, 4) . "') as relaciona INNER JOIN " . $this->TabelaA . " ON " . $this->TabelaA . ".id=relaciona.login";
			if ($tipoPes == 'monit') {
				$LogR = $this->Bd->executa_query_com_saida($Pes1);
			}

			if ($tipoPes == 'relat') {
				$LogR = $this->BdRelat->executa_query_com_saida($Pes1);
			}

			if ($LogR) {
				for ($x = 0; $x < count($LogR); $x++) {
					$LiR .= " OR agente='" . $LogR[$x]['login'] . "-" . $LogR[$x]['nome'] . "'";
				}

			}
		}
        //--Verifica a partir de onde considerar o relatório, se desde o início ou se a partir do login--
        list($data_a_aux, $hora_a_aux) = explode(' ', $Inicio);

        //$data_u_aux = date('Y-m-d', strtotime('-1 day', strtotime($data_a_aux)));
        //$sql = "SELECT oque FROM vm50_relatorios_cc WHERE agente LIKE '".$Agente."%' AND diahora >= '".$data_u_aux." 00:00' AND diahora <= '".$data_u_aux." 23:59' ORDER BY diahora DESC limit 1";
        //$resL = $this->Bd->executa_query_com_saida($sql);

        //if($resL[0]['oque'] == 'Logout'){
        $sql = "SELECT diahora FROM vm50_relatorios_cc WHERE agente LIKE '".$Agente."%' AND diahora >= '".$data_a_aux." 00:00' AND diahora <= '".$data_a_aux." 23:59' AND oque LIKE 'Login' ORDER BY diahora ASC LIMIT 1";
        $res = $this->Bd->executa_query_com_saida($sql);
        if(count($res) >= 1){
            $strTime1 = strtotime($Inicio);
            $strTime2 = strtotime($res[0]['diahora']);
            $strTime3 = strtotime($Fim);
            if($strTime1 < $strTime2 && $strTime2 < $strTime3) $Inicio = $res[0]['diahora'];
        }
        //}
        //----------Fim da verificação------------

		if ($eliminaRamais == 0) {
			$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, diahora, agente, fila, ligacao, numero, oque, funcai FROM " . $Tabela . " WHERE ( agente LIKE '" . $Agente . "%'  ) AND diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND (numero LIKE '%" . $filtroNumero . "%' OR numero like '') AND numero != '1234' ORDER BY diahora";
		} else {
			$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, diahora, agente, fila, ligacao, numero, oque, funcai FROM " . $Tabela . " WHERE ( agente LIKE '" . $Agente . "%'  ) AND diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND (length(numero) > 3 OR length(numero) = 0 OR oque LIKE 'Login' OR oque LIKE 'Logout') AND (numero LIKE '%" . $filtroNumero . "%' OR numero like '') AND numero != '1234' ORDER BY diahora";
		}
		//return $Pes;
		//    $Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, agente, fila, ligacao, numero, oque, funcai FROM ".$this->TabelaR." WHERE ( agente='".$Agente."' ".$LiR." ) AND diahora >= '".$Inicio."' AND diahora <= '".$Fim."' AND agente!=numero ORDER BY diahora";

		if ($tipoPes == 'monit') {
			$Resut = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$Resut = $this->BdRelat->executa_query_com_saida($Pes);
		}

		if (($Resut) or (count($Resut) > 1)) {
			$Saida1 = $this->le_dados_relatorios($Resut, $Agente, $LiR, $Inicio, $Fim, $Dehoje, $tipoPes, $tempoMinCon);
		} else {
			$Saida1 = false;
		}

		return $Saida1;
	}

	//---------------------------------------------------
	// Funcao relatorio_grupos
	//
	// Faz select no banco por grupos
	//---------------------------------------------------
	function relatorio_grupos($Grupo, $Inicio, $Fim, $Dehoje = "", $tipoPes = 'monit') {
		$DirRaiz = $_SERVER['DOCUMENT_ROOT'] . '/vdt/';
//    include($DirRaiz.'config.php');
		//    include($DirRaiz.$DirModul.'geral.modu.php');
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Fim = trim($Fim);
		$Pes1 = "SELECT agente FROM " . $Tabela . " WHERE (grupos like '" . $Grupo . "%') AND diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND agente !='0000' GROUP BY agente ORDER BY agente";
		if ($tipoPes == 'monit') {
			$LogR = $this->Bd->executa_query_com_saida($Pes1);
		}

		if ($tipoPes == 'relat') {
			$LogR = $this->BdRelat->executa_query_com_saida($Pes1);
		}

		$TotalAg = count($LogR);
		$ResultadoV = array();
		for ($x = 0; $x < $TotalAg; $x++) {
			$Agente = $LogR[$x]['agente'];
			/*if(is_array($Agentes)){
				      if(is_null($Agentes[$Agente])) $Agentes[$Agente] = 0;
				      else $Agentes[$Agente]++;
				      }else{
				          $Agentes[$Agente] = 0;
				      }
			*/
			$Saida1 = $this->relatorio_agentes($Agente, $Inicio, $Fim, false, '', $tipoPes);
			$Agora[$x] = array($Agente, $Saida1[2]['Fila']['Atendendo']);

			foreach ($Saida1 as $ChaveA => $TabA) {
				if (is_array($TabA)) {
					foreach ($TabA as $ChaveB => $TabB) {
						if (is_array($TabB)) {
							foreach ($TabB as $ChaveC => $TabC) {
								if (is_array($TabC)) {
									foreach ($TabC as $ChaveD => $TabD) {
										if (is_array($TabD)) {
											foreach ($TabD as $ChaveE => $TabE) {
												if (is_array($TabE)) {
													foreach ($TabE as $ChaveF => $TabF) {
														if (is_array($TabF)) {
															foreach ($TabF as $ChaveG => $TabG) {
																if (is_array($TabG)) {
																	foreach ($TabG as $ChaveH => $TabH) {
																		if (is_array($TabH)) {
																			foreach ($TabH as $ChaveI => $TabI) {
																				if (is_array($TabI)) {
																					foreach ($TabI as $ChaveJ => $TabJ) {
																						if (is_array($TabJ)) {
																							foreach ($TabJ as $ChaveK => $TabK) {
																								if (is_array($TabK)) {
																									foreach ($TabK as $ChaveL => $TabL) {
																										if (is_array($TabL)) {
																											foreach ($TabL as $ChaveM => $TabM) {
																												if (is_array($TabM)) {
																													foreach ($TabM as $ChaveN => $TabN) {
																														$ResultadoV[$ChaveA][$ChaveB][$ChaveC][$ChaveD][$ChaveE][$ChaveF][$ChaveG][$ChaveH][$ChaveI][$ChaveJ][$ChaveK][$ChaveL][$ChaveM][$ChaveN] += $TabN;
																													}
																												} else {
																													$ResultadoV[$ChaveA][$ChaveB][$ChaveC][$ChaveD][$ChaveE][$ChaveF][$ChaveG][$ChaveH][$ChaveI][$ChaveJ][$ChaveK][$ChaveL][$ChaveM] += $TabM;
																												}

																											}
																										} else {
																											$ResultadoV[$ChaveA][$ChaveB][$ChaveC][$ChaveD][$ChaveE][$ChaveF][$ChaveG][$ChaveH][$ChaveI][$ChaveJ][$ChaveK][$ChaveL] += $TabL;
																										}

																									}
																								} else {
																									$ResultadoV[$ChaveA][$ChaveB][$ChaveC][$ChaveD][$ChaveE][$ChaveF][$ChaveG][$ChaveH][$ChaveI][$ChaveJ][$ChaveK] += $TabK;
																								}

																							}
																						} else {
																							$ResultadoV[$ChaveA][$ChaveB][$ChaveC][$ChaveD][$ChaveE][$ChaveF][$ChaveG][$ChaveH][$ChaveI][$ChaveJ] += $TabJ;
																						}

																					}
																				} else {
																					$ResultadoV[$ChaveA][$ChaveB][$ChaveC][$ChaveD][$ChaveE][$ChaveF][$ChaveG][$ChaveH][$ChaveI] += $TabI;
																				}

																			}
																		} else {
																			$ResultadoV[$ChaveA][$ChaveB][$ChaveC][$ChaveD][$ChaveE][$ChaveF][$ChaveG][$ChaveH] += $TabH;
																		}

																	}
																} else {
																	$ResultadoV[$ChaveA][$ChaveB][$ChaveC][$ChaveD][$ChaveE][$ChaveF][$ChaveG] += $TabG;
																}

															}
														} else {
															$ResultadoV[$ChaveA][$ChaveB][$ChaveC][$ChaveD][$ChaveE][$ChaveF] += $TabF;
														}

													}
												} else {
													$ResultadoV[$ChaveA][$ChaveB][$ChaveC][$ChaveD][$ChaveE] += $TabE;
												}

											}
										} elseif (is_numeric($TabD)) {
											$ResultadoV[$ChaveA][$ChaveB][$ChaveC][$ChaveD] += $TabD;
										}

									}
								} else {
									$ResultadoV[$ChaveA][$ChaveB][$ChaveC] += $TabC;
								}

							}
						} elseif (is_numeric($TabB)) {
							$ResultadoV[$ChaveA][$ChaveB] += $TabB;
						}

					}
				} elseif (is_numeric($TabA)) {
					$ResultadoV[$ChaveA] += $TabA;
				}

			}
			//}
			//    }
		}
//return $Agora;
		$Resultado[0] = $Grupo;
		$Resultado[1] = $ResultadoV;
		$Resultado[3]['Total Agentes'] = $TotalAg;
		$Resultado[4] = $Agentes;
//    return $Saida2;
		return $Resultado;
	}

	//---------------------------------------------------
	// Funcao monitora_grupos
	//---------------------------------------------------
	function monitora_grupos($Grupo) {
		$Pes1 = "SELECT login, situacao FROM " . $this->TabelaA . " WHERE grupo = '" . $Grupo . "' AND ramal!=''";
		$Resu1 = $this->Bd->executa_query_com_saida($Pes1);
		$Saida = array($Resu1);
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao le_dados_relatorios
	//
	// Estados no relatorio
	//   Login - Logout => Agente login ou logout
	//   Desligado      => Ligacao desligada
	//   Em Pausa       => Agente em pausa
	//   Livre          => Agente livre
	//   --Entrada        => Nova ligacao
	//   Em conversa&ccedil;&atilde;o => Agente em conversacao
	//   Chamando       => Agente chamando ou sendo chamado
	//   Monitorando PA => Agente monitorando PA
	//
	// Tipos de ligacao
	//   (em branco)    => Sem tipo (login, logout, livre, em pausa, entrada)
	//   --Externa        => Fazendo ligacao externa
	//   Transfer&ecirc;ncia... => Algum t3ipo de transferencia
	//   Consulta       => Fazendo ou recebendo consulta
	//   DDR            => Recebendo ligacao externa
	//   FILA           => Chamada na fila
	//   --Externo...     => Ligacao externa
	//   Fazendo chamada externa = > Ligando para fora
	//---------------------------------------------------
	function le_dados_relatorios3($Res, $Agente, $LR = "", $Inicio, $Fim, $tipoPes = 'monit') {
		$Said1 = '<br><br><spam style="font-size:12pt;">';
		//$NaoAtenfila = $this->QNA;
		$DesisteAPartir = 4;
		if (!is_array($Res)) {
			$Saida = false;
		} else {
			list($Dia_inicial, $Horario_inicial) = explode(' ', $Inicio);
			list($Dia_final, $Horario_final) = explode(' ', $Fim);
			//Tempos
			$Tempo['Livre'] = $Tempo['Em Pausa'] = $Tempo['Login'] = $Tempo['Monitorando PA'] = 0;
			$Tempo['Deslogado'] = 0;
			$Tempo['Fazendo chamada externa']['Atendendo'] = 0;
			$Tempo['DDR']['Atendendo'] = 0;
			$Tempo['Transfer-DDR']['Atendendo'] = 0;
			$Tempo['Consulta-Atendidas']['Atendendo'] = 0;
			$Tempo['Consulta-Realizadas']['Atendendo'] = 0;
			$Tempo['Fila']['Atendendo'] = 0;
			$Tempo['Fazendo chamada externa']['Chamando'] = 0;
			$Tempo['DDR']['Chamando'] = 0;
			$Tempo['Transfer-DDR']['Chamando'] = 0;
			$Tempo['Consulta-Atendidas']['Chamando'] = 0;
			$Tempo['Consulta-Realizadas']['Chamando'] = 0;
			$Tempo['Fila']['Chamando'] = 0;
			$Tempo['Fazendo chamada externa-funcao']['Atendendo']['ativo'] = 0;
			$Tempo['Pausas'] = array(); //[nome da pausa][inicio]=duracao
			//Quantidades
			$Quant['Em Pausa'] = 0;
			$Quant['Fazendo chamada externa']['Atendendo'] = 0;
			$Quant['DDR']['Atendendo'] = 0;
			$Quant['Transfer-DDR-Atendidas']['Atendendo'] = 0;
			$Quant['Transfer-DDR-Realizadas']['Atendendo'] = 0;
			$Quant['Transfer-FILA-Atendidas']['Atendendo'] = 0;
			$Quant['Transfer-FILA-Realizadas']['Atendendo'] = 0;
			$Quant['Consulta-Atendidas']['Atendendo'] = 0;
			$Quant['Consulta-Realizadas']['Atendendo'] = 0;
			$Quant['Fila']['Atendendo'] = 0;
			$Quant['Fazendo chamada externa']['Chamando'] = 0;
			$Quant['DDR']['Chamando'] = 0;
			$Quant['Transfer-DDR-Realizadas']['Chamando'] = 0;
			$Quant['Transfer-FILA-Realizadas']['Chamando'] = 0;
			$Quant['Consulta-Atendidas']['Chamando'] = 0;
			$Quant['Consulta-Realizadas']['Chamando'] = 0;
			$Quant['Fila']['Chamando'] = 0;
			$Quant['Fazendo chamada externa']['Nao Atendidas'] = 0;
			$Quant['DDR']['Nao Atendidas'] = 0;
			$Quant['Transfer-DDR-Atendidas']['Nao Atendidas'] = 0;
			$Quant['Transfer-DDR-Realizadas']['Nao Atendidas'] = 0;
			$Quant['Transfer-FILA-Atendidas']['Nao Atendidas'] = 0;
			$Quant['Transfer-FILA-Realizadas']['Nao Atendidas'] = 0;
			$Quant['Consulta-Atendidas']['Nao Atendidas'] = 0;
			$Quant['Consulta-Realizadas']['Nao Atendidas'] = 0;
			$Quant['Fila']['Nao Atendidas'] = 0;
			$Quant['Fazendo chamada externa-funcao']['Atendendo']['ativo'] = 0;
			$Quant['Fazendo chamada externa-funcao']['Nao Atendidas']['ativo'] = 0;
			$Quant['Total Agentes'] = 1;
			//Auxiliares
			$Login_hora_inicial = $Login_hora_final = 0;
			$TipoPausa = "";
			//Monta os timeout
			$Timeo = array();
			$PesT = "SELECT pseudonimo,timeout FROM " . $this->TabelaF;
			if ($tipoPes == 'monit') {
				$ResT = $this->Bd->executa_query_com_saida($PesT);
			}

			if ($tipoPes == 'relat') {
				$ResT = $this->BdRelat->executa_query_com_saida($PesT);
			}

			for ($k = 0; $k < count($ResT); $k++) {
				$Timeo[$ResT[$k]['pseudonimo']] = $ResT[$k]['timeout'];
				$FilasNome[] = $ResT[$k]['pseudonimo'];
			}
			//Primeira acao
			$Insta = trim($Res[0]['diahorario']);
			$Oque = "";
			$Fila = trim($Res[0]['fila']);
			$Numer = trim($Res[0]['numero']);
			$Agent = trim($Res[0]['agente']);
			$Funca = trim($Res[0]['funcai']);
			//A primeira entrada deve ser um login, se nao for
			//eh porque ficou logado
			list($DiaA_inicial, $DiaM_inicial, $DiaD_inicial) = explode('-', $Dia_inicial);
			list($HorH_inicial, $HorM_inicial) = explode(':', $Horario_inicial);
			if (trim($Res[0]['oque']) != "Login") {
				$Login_hora_inicial = mktime($HorH_inicial, $HorM_inicial, 0, $DiaM_inicial, $DiaD_inicial, $DiaA_inicial);
				$Insta = $Login_hora_inicial;
				$Oque = "Livre";
			} else {
				$Login_hora_inicial = $Insta;
			}

			$Login_hora_inicial = $Insta;
			//A ultima entrada deve ser um logout, se nao for
			//eh porque ficou logado
			list($DiaA_final, $DiaM_final, $DiaD_final) = explode('-', $Dia_final);
			list($HorH_final, $HorM_final) = explode(':', $Horario_final);
			$Hora_final = mktime($HorH_final, $HorM_final, 59, $DiaM_final, $DiaD_final, $DiaA_final);
			if ($Hora_final > time()) {
				$Hora_final = time();
			} elseif ($Hora_final < $Res[count($Res) - 1]['diahorario']) {
				$Hora_final = $Res[count($Res) - 1]['diahorario'];
			}

			$Login_hora_final = $Hora_final;
			$Fila = $RamAu = "";
			$Pausa_aberta = $Pausa_abertaQ = $Deslogado_aberto = 0;
			//Limpa os problemas antes de comecar a ler
			$Anterior = "";
			for ($x = 0; $x < count($Res); $x++) {
				if ($Anterior == "Logout") {
					if ((trim($Res[$x]['oque'])) != "Login") {
						$Res[$x]['fila'] = "";
						$Res[$x]['numero'] = "";
						$Res[$x]['ligacao'] = "";
						$Res[$x]['oque'] = "";
						continue;
					}
				}
				if ((trim($Res[$x]['fila'])) == "Transfer&ecirc;ncia-Fazendo chamada externa") {
					array_splice($Res, $x, 1);
					continue;
				}
				$Anterior = $Res[$x]['oque'];
			}
			$y = count($Res) - 1;
			$Flag = true;
			while ($Flag) {
				if ($Res[$y]['oque'] == "") {
					$y--;
					continue;
				}
				if ($Res[$y]['oque'] == "Logout") {
					$Login_hora_final = trim($Res[$y]['diahorario']);
					$Flag = false;
					continue;
				}
				$Flag = false;
			}
			//Primeira acao
			$Insta = trim($Res[0]['diahorario']);
			$Oque = "";
			$Ligac = "";
			$Minimo = 4;
			//Comeca a ler a linha do tempo
			$x = 0;while ($x < count($Res)) {
//      for ($x=0; $x<count($Res); $x++) {
				//So contabilizar se mudar o estado
				if (($Oque == trim($Res[$x]['oque'])) && ($Ligac == trim($Res[$x]['ligacao']))) {
					$x++;
					continue;
				}
				$Said1 .= trim($Res[$x]['diahorario']) . " | " . trim($Res[$x]['fila']) . " | " . trim($Res[$x]['ligacao']) . " | " . trim($Res[$x]['numero']) . " | " . trim($Res[$x]['oque']) . "<br>";
				$H = intval(date('G', $Insta), 10);
				$K = intval(date('j', $Insta), 10);
				if ($Ligac != trim($Res[$x]['ligacao'])) {
					//$Insta = trim($Res[$x]['diahorario']);
					$Oque = "";
					$Desligado = 0;
					$LCham = 0;
					$LConv = 0;
					$LDesF = 0;
					$LDesC = 0;
					$LDesM = 0;
					$LDesD = 0;
					$FilasH = -1;
					$TEspera = 0;
					$ExpMax = 0;
					$Jachamou = 0;
					$Quant['Chamadas Recebidas']++;
					$Quant['H'][$H]['Chamadas Recebidas']++;
					$Quant['D'][$K]['Chamadas Recebidas']++;
				}
//        switch (trim($Res[$x]['oque'])) {
				switch ($Oque) {
					case "Logout":
						$Deslogado_aberto = $Insta;
						if (($x == count($Res) - 1) && ($Pausa_aberta == 0)) {
							if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['Livre'] += trim($Res[$x]['diahorario']) - $Insta;
							}

						}
						if ($Pausa_abertaQ > 0) {
							if ($TipoPausa != "") {
								$Quant['Em Pausa']++;
								$Quant['Em Pausa Diferenciada'][$TipoPausa]++;
								$Quant['H'][$H]['Em Pausa']++;
							}
							if ($Pausa_aberta > 0) {
								if ($TipoPausa != "") {
									$Tempo['Em Pausa'] += $Insta - $Pausa_aberta;
									$Tempo['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
									$Tempo['Pausas'][$TipoPausa][$Pausa_aberta] += $Insta - $Pausa_aberta;
								}
							}
							$Pausa_aberta = 0;
							$Pausa_abertaQ = 0;
						}
						$TipoPausa = "";
						break;
					case "Login":
						if ($Deslogado_aberto > 0) {
							$Tempo['Deslogado'] += $Insta - $Deslogado_aberto;
							$Deslogado_aberto = 0;
							if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['Livre'] += trim($Res[$x]['diahorario']) - $Insta;
							}

							if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['Livre Funca'] += trim($Res[$x]['diahorario']) - $Insta;
							}

						}
						break;
					case "Em Pausa":
						$Pausa_aberta = $Insta;
						$Pausa_abertaQ = 1;
						if ($TipoPausa == "") {
							$TipoPausa = $Fila;
						}

						break;
					case "Livre":
						$Tempo['Livre'] += trim($Res[$x]['diahorario']) - $Insta;
						if ($Pausa_abertaQ > 0) {
							if ($TipoPausa != "") {
								$Quant['Em Pausa']++;
								$Quant['Em Pausa Diferenciada'][$TipoPausa]++;
								$Quant['H'][$H]['Em Pausa']++;
							}
							if ($Pausa_aberta > 0) {
								if ($TipoPausa != "") {
									$Tempo['Em Pausa'] += $Insta - $Pausa_aberta;
									$Tempo['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
									$Tempo['Pausas'][$TipoPausa][$Pausa_aberta] += $Insta - $Pausa_aberta;
								}
							}
							$Pausa_aberta = 0;
							$Pausa_abertaQ = 0;
						}
						$TipoPausa = "";
						break;
					case "Chamando":
						(trim($Res[$x]['diahorario']) > $Insta) ? $Dura = trim($Res[$x]['diahorario']) - $Insta : $Dura = 0;
						if (($LCham == 0) && ($Dura > $Minimo)) {
							if ($Fila == "Fazendo chamada externa") {
								$Quant['Fazendo chamada externa']['Chamando']++;
								$Quant['H'][$H]['Fazendo chamada externa']['Chamando']++;
								if (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o") {
									$Tempo['Fazendo chamada externa']['Chamando'] += $Dura;
									$Tempo['H'][$H]['Fazendo chamada externa']['Chamando'] += $Dura;
								}
								if ((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) {
									$Quant['Fazendo chamada externa']['Nao Atendidas']++;
									$Quant['H'][$H]['Fazendo chamada externa']['Nao Atendidas']++;
									$Fffun = $Funca;
									if ($Fffun > "") {
										$Quant['Fazendo chamada externa-funcao']['Nao Atendidas'][$Fffun]++;
										$Quant['H'][$H]['Fazendo chamada externa-funcao']['Nao Atendidas'][$Fffun]++;
									}
								}
								if ($Pausa_aberta > 0) {
									if ($TipoPausa != "") {
										$Tempo['Em Pausa'] += $Insta - $Pausa_aberta;
										$Tempo['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
										$Tempo['Pausas'][$TipoPausa][$Pausa_aberta] += $Insta - $Pausa_aberta;
										$Quant['Em Pausa']++;
										$Quant['Em Pausa Diferenciada'][$TipoPausa]++;
										$Quant['H'][$H]['Em Pausa']++;
									}
									$Pausa_aberta = 0;
								}
							} elseif ($Fila == "DDR") {
								$Quant['DDR']['Chamando']++;
								$Quant['H'][$H]['DDR']['Chamando']++;
								if (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o") {
									$Tempo['DDR']['Chamando'] += $Dura;
									$Tempo['H'][$H]['DDR']['Chamando'] += $Dura;
								}
								if ((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) {
									$Quant['DDR']['Nao Atendidas']++;
									$Quant['H'][$H]['DDR']['Nao Atendidas']++;
								}
								if ($Pausa_aberta > 0) {
									if ($TipoPausa != "") {
										$Tempo['Em Pausa'] += $Insta - $Pausa_aberta;
										$Tempo['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
										$Tempo['Pausas'][$TipoPausa][$Pausa_aberta] += $Insta - $Pausa_aberta;
										$Quant['Em Pausa']++;
										$Quant['Em Pausa Diferenciada'][$TipoPausa]++;
										$Quant['H'][$H]['Em Pausa']++;
									}
									$Pausa_aberta = 0;
								}
							} elseif ($Fila == "Transfer&ecirc;ncia-DDR") {
								($Numer == $Agente) ? $VetorT = "Realizadas" : $VetorT = "Atendidas";
								$Quant['Transfer-DDR-' . $VetorT]['Chamando']++;
								$Quant['H'][$H]['Transfer-DDR-' . $VetorT]['Chamando']++;
								if (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o") {
									$Tempo['Transfer-DDR-' . $VetorT]['Chamando'] += $Dura;
									$Tempo['H'][$H]['Transfer-DDR-' . $VetorT]['Chamando'] += $Dura;
								}
								if ((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) {
									$Quant['Transfer-DDR-' . $VetorT]['Nao Atendidas']++;
									$Quant['H'][$H]['Transfer-DDR-' . $VetorT]['Nao Atendidas']++;
								}
								if ($Pausa_aberta > 0) {
									if ($TipoPausa != "") {
										$Tempo['Em Pausa'] += $Insta - $Pausa_aberta;
										$Tempo['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
										$Tempo['Pausas'][$TipoPausa][$Pausa_aberta] += $Insta - $Pausa_aberta;
										$Quant['Em Pausa']++;
										$Quant['Em Pausa Diferenciada'][$TipoPausa]++;
										$Quant['H'][$H]['Em Pausa']++;
									}
									$Pausa_aberta = 0;
								}
							} elseif ($Fila == "Transfer&ecirc;ncia-Fazendo chamada externa") {
								if ((trim($Numer) != '0000') && (trim($Numer) != '0')) {
									$Quant['Transfer-Fazendo chamada externa-Realizadas']['Chamando']++;
									$Quant['H'][$H]['Transfer-Fazendo chamada externa-Realizadas']['Chamando']++;
									if (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o") {
										$Tempo['Transfer-Fazendo chamada externa-Realizadas']['Chamando'] += $Dura;
										$Tempo['H'][$H]['Transfer-Fazendo chamada externa-Realizadas']['Chamando'] += $Dura;
									}
									if ((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) {
										$Quant['Transfer-Fazendo chamada externa-Realizadas']['Nao Atendidas']++;
										$Quant['H'][$H]['Transfer-Fazendo chamada externa-Realizadas']['Nao Atendidas']++;
									}
									if ($Pausa_aberta > 0) {
										if ($TipoPausa != "") {
											$Tempo['Em Pausa'] += $Insta - $Pausa_aberta;
											$Tempo['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
											$Tempo['Pausas'][$TipoPausa][$Pausa_aberta] += $Insta - $Pausa_aberta;
											$Quant['Em Pausa']++;
											$Quant['Em Pausa Diferenciada'][$TipoPausa]++;
											$Quant['H'][$H]['Em Pausa']++;
										}
										$Pausa_aberta = 0;
									}
								}
							} elseif (substr($Fila, 0, 20) == "Transfer&ecirc;ncia-") {
								($Numer == $Agente) ? $VetorT = "Realizadas" : $VetorT = "Atendidas";
								$Quant['Transfer-FILA-' . $VetorT]['Chamando']++;
								$Quant['H'][$H]['Transfer-FILA-' . $VetorT]['Chamando']++;
								if (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o") {
									$Tempo['Transfer-FILA-' . $VetorT]['Chamando'] += $Dura;
									$Tempo['H'][$H]['Transfer-FILA-' . $VetorT]['Chamando'] += $Dura;
								}
								if ((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) {
									$Quant['Transfer-FILA-' . $VetorT]['Nao Atendidas']++;
									$Quant['H'][$H]['Transfer-FILA-' . $VetorT]['Nao Atendidas']++;
								}
								if ($Pausa_aberta > 0) {
									if ($TipoPausa != "") {
										$Tempo['Em Pausa'] += $Insta - $Pausa_aberta;
										$Tempo['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
										$Tempo['Pausas'][$TipoPausa][$Pausa_aberta] += $Insta - $Pausa_aberta;
										$Quant['Em Pausa']++;
										$Quant['Em Pausa Diferenciada'][$TipoPausa]++;
										$Quant['H'][$H]['Em Pausa']++;
									}
									$Pausa_aberta = 0;
								}
							} elseif ($Fila == "Consulta") {
								if ($Agente != $Numer) {
									$Consult = "SELECT numero FROM " . $this->TabelaR . " WHERE ligacao = '" . $Ligac . "' ORDER BY diahora LIMIT 1";
									if ($tipoPes == 'monit') {
										$Respost = $this->Bd->executa_query_com_saida($Consult);
									}

									if ($tipoPes == 'relat') {
										$Respost = $this->BdRelat->executa_query_com_saida($Consult);
									}

									($Respost[0]['numero'] == $Agente) ? $Vetor = "Realizadas" : $Vetor = "Atendidas";
									$Quant['Consulta-' . $Vetor]['Chamando']++;
									$Quant['H'][$H]['Consulta-' . $Vetor]['Chamando']++;
									if (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o") {
										$Tempo['Consulta-' . $Vetor]['Chamando'] += $Dura;
										$Tempo['H'][$H]['Consulta-' . $Vetor]['Chamando'] += $Dura;
									}
									if ((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) {
										$Quant['Consulta-' . $Vetor]['Nao Atendidas']++;
										$Quant['H'][$H]['Consulta-' . $Vetor]['Nao Atendidas']++;
									}
									if ($Pausa_aberta > 0) {
										if ($TipoPausa != "") {
											$Tempo['Em Pausa'] += $Insta - $Pausa_aberta;
											$Tempo['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
											$Tempo['Pausas'][$TipoPausa][$Pausa_aberta] += $Insta - $Pausa_aberta;
											$Quant['Em Pausa']++;
											$Quant['Em Pausa Diferenciada'][$TipoPausa]++;
											$Quant['H'][$H]['Em Pausa']++;
										}
										$Pausa_aberta = 0;
									}
								}
							} else {
								$Quant['Fila']['Chamando']++;
								$Quant['Fila'][$Fila]['Chamando']++;
								$Quant['H'][$H]['Fila']['Chamando']++;
								$Quant['H'][$H]['Fila'][$Fila]['Chamando']++;
								if (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o") {
									$Tempo['Fila']['Chamando'] += $Dura;
									$Tempo['Fila'][$Fila]['Chamando'] += $Dura;
									$Tempo['H'][$H]['Fila']['Chamando'] += $Dura;
									$Tempo['H'][$H]['Fila'][$Fila]['Chamando'] += $Dura;
								}
								if ((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) {
									$Quant['DDR']['Nao Atendidas']++;
									$Quant['H'][$H]['DDR']['Nao Atendidas']++;
								}
								if ((($Oque == "Livre") || ($Oque == "Em Pausa") || ($Oque == "Desligado") || (substr($Oque, 0, 11) == "Desistencia") || ($Oque == "Rejeitado") || ($Ligac != trim($Res[$x]['ligacao']))) && ($Timeo[$Fila] <= $Dura)) {
									$Quant['Fila']['Nao Atendidas']++;
									$Quant['Fila'][$Fila]['Nao Atendidas']++;
									$Quant['H'][$H]['Fila']['Nao Atendidas']++;
									$Quant['H'][$H]['Fila'][$Fila]['Nao Atendidas']++;
								}

								if ($Pausa_aberta > 0) {
									if ($TipoPausa != "") {
										$Tempo['Em Pausa'] += $Insta - $Pausa_aberta;
										$Tempo['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
										$Tempo['Pausas'][$TipoPausa][$Pausa_aberta] += $Insta - $Pausa_aberta;
										$Quant['Em Pausa']++;
										$Quant['Em Pausa Diferenciada'][$TipoPausa]++;
										$Quant['H'][$H]['Em Pausa']++;
									}
									$Pausa_aberta = 0;
								}
							}
							$LCham = 1;
						}
						break;
					case "Em conversa&ccedil;&atilde;o":
//              if (($LConv==0) && ($LCham==1)) {
						if ($LConv == 0) {
							if ($Fila == "Fazendo chamada externa") {
								$Quant['Fazendo chamada externa']['Atendendo']++;
								$Quant['H'][$H]['Fazendo chamada externa']['Atendendo']++;
								if ($Fffun > "") {
									$Quant['Fazendo chamada externa-funcao']['AtendendoF'][$Fffun]++;
									$Quant['H'][$H]['Fazendo chamada externa-funcao']['AtendendoF'][$Fffun]++;
								}
								$Vale = true;
//                  while (($Ligac == trim($Res[$x]['ligacao'])) && ($x<count($Res)) && ($Vale)) {
								while (($Ligac == trim($Res[$x]['ligacao'])) && ($x < count($Res)) && ((trim($Res[$x]['oque']) == "Desligado") || (trim($Res[$x]['oque']) == "Desistencia-FilA") || (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o"))) {
//                    if ((trim($Res[$x]['oque'])!="Desligado") && (trim($Res[$x]['oque'])!="Desistencia-FilA")) {
									//                      $Vale = false; continue;
									//                    }
									$Ligac = trim($Res[$x]['ligacao']);
									$x++;
								}
								$x = $x - 1;
								(trim($Res[$x]['diahorario']) > $Insta) ? $Dura = trim($Res[$x]['diahorario']) - $Insta : $Dura = 0;
								if ($Dura > $Minimo) {
									$Tempo['Fazendo chamada externa']['Atendendo'] += $Dura;
									$Tempo['H'][$H]['Fazendo chamada externa']['Atendendo'] += $Dura;
									if ($Fffun > "") {
										$Tempo['Fazendo chamada externa']['AtendendoF'][$Fffun] += $Dura;
										$Tempo['H'][$H]['Fazendo chamada externa']['AtendendoF'][$Fffun] += $Dura;
									}
								}
							} elseif ($Fila == "DDR") {
								$Quant['DDR']['Atendendo']++;
								$Quant['H'][$H]['DDR']['Atendendo']++;
								if ($Fffun > "") {
									$Quant['DDR-funcao']['AtendendoF'][$Fffun]++;
									$Quant['H'][$H]['DDR-funcao']['AtendendoF'][$Fffun]++;
								}
								$Vale = true;
//                  while (($Ligac == trim($Res[$x]['ligacao'])) && ($x<count($Res)) && ($Vale)) {
								while (($Ligac == trim($Res[$x]['ligacao'])) && ($x < count($Res)) && ((trim($Res[$x]['oque']) == "Desligado") || (trim($Res[$x]['oque']) == "Desistencia-FilA") || (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o"))) {
//                    if ((trim($Res[$x]['oque'])!="Desligado") && (trim($Res[$x]['oque'])!="Desistencia-FilA")) {
									//                      $Vale = false; continue;
									//                    }
									$Ligac = trim($Res[$x]['ligacao']);
									$x++;
								}
								$x = $x - 1;
								(trim($Res[$x]['diahorario']) > $Insta) ? $Dura = trim($Res[$x]['diahorario']) - $Insta : $Dura = 0;
								if ($Dura > $Minimo) {
									$Tempo['DDR']['Atendendo'] += $Dura;
									$Tempo['H'][$H]['DDR']['Atendendo'] += $Dura;
									if ($Fffun > "") {
										$Tempo['DDR-funcao']['AtendendoF'][$Fffun] += $Dura;
										$Tempo['H'][$H]['DDR-funcao']['AtendendoF'][$Fffun] += $Dura;
									}
								}
							} elseif ($Fila == "Transfer&ecirc;ncia-DDR") {
								$Quant['Transfer-DDR-Atendidas']['Atendendo']++;
								$Quant['H'][$H]['Transfer-DDR-Atendidas']['Atendendo']++;
								if ($Fffun > "") {
									$Quant['Transfer-DDR-funcao-Atendidas']['AtendendoF'][$Fffun]++;
									$Quant['H'][$H]['Transfer-DDR-funcao-Atendidas']['AtendendoF'][$Fffun]++;
								}
								$Vale = true;
//                  while (($Ligac == trim($Res[$x]['ligacao'])) && ($x<count($Res)) && ($Vale)) {
								while (($Ligac == trim($Res[$x]['ligacao'])) && ($x < count($Res)) && ((trim($Res[$x]['oque']) == "Desligado") || (trim($Res[$x]['oque']) == "Desistencia-FilA") || (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o"))) {
//                    if ((trim($Res[$x]['oque'])!="Desligado") && (trim($Res[$x]['oque'])!="Desistencia-FilA")) {
									//                      $Vale = false; continue;
									//                    }
									$Ligac = trim($Res[$x]['ligacao']);
									$x++;
								}
								$x = $x - 1;
								(trim($Res[$x]['diahorario']) > $Insta) ? $Dura = trim($Res[$x]['diahorario']) - $Insta : $Dura = 0;
								if ($Dura > $Minimo) {
									$Tempo['Transfer-DDR-Atendidas']['Atendendo'] += $Dura;
									$Tempo['H'][$H]['Transfer-DDR-Atendidas']['Atendendo'] += $Dura;
									if ($Fffun > "") {
										$Tempo['Transfer-DDR-funcao-Atendidas']['AtendendoF'][$Fffun] += $Dura;
										$Tempo['H'][$H]['Transfer-DDR-Atendidas']['AtendendoF'][$Fffun] += $Dura;
									}
								}
							} elseif (substr($Fila, 0, 20) == "Transfer&ecirc;ncia-") {
								$Quant['Transfer-FILA-Atendidas']['Atendendo']++;
								$Quant['H'][$H]['Transfer-FILA-Atendidas']['Atendendo']++;
								if ($Fffun > "") {
									$Quant['Transfer-FILA-funcao-Atendidas']['AtendendoF'][$Fffun]++;
									$Quant['H'][$H]['Transfer-FILA-funcao-Atendidas']['AtendendoF'][$Fffun]++;
								}
								$Vale = true;
//                  while (($Ligac == trim($Res[$x]['ligacao'])) && ($x<count($Res)) && ($Vale)) {
								while (($Ligac == trim($Res[$x]['ligacao'])) && ($x < count($Res)) && ((trim($Res[$x]['oque']) == "Desligado") || (trim($Res[$x]['oque']) == "Desistencia-FilA") || (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o"))) {
//                    if ((trim($Res[$x]['oque'])!="Desligado") && (trim($Res[$x]['oque'])!="Desistencia-FilA")) {
									//                      $Vale = false; continue;
									//                    }
									$Ligac = trim($Res[$x]['ligacao']);
									$x++;
								}
								$x = $x - 1;
								(trim($Res[$x]['diahorario']) > $Insta) ? $Dura = trim($Res[$x]['diahorario']) - $Insta : $Dura = 0;
								if ($Dura > $Minimo) {
									$Tempo['Transfer-FILA-Atendidas']['Atendendo'] += $Dura;
									$Tempo['H'][$H]['Transfer-FILA-Atendidas']['Atendendo'] += $Dura;
									if ($Fffun > "") {
										$Tempo['Transfer-FILA-Atendidas']['AtendendoF'][$Fffun] += $Dura;
										$Tempo['H'][$H]['Transfer-FILA-Atendidas']['AtendendoF'][$Fffun] += $Dura;
									}
								}
							} elseif ($Fila == "Consulta") {
								$Quant['Consulta-' . $Vetor]['Atendendo']++;
								$Quant['H'][$H]['Consulta-' . $Vetor]['Atendendo']++;
								if ($Fffun > "") {
									$Quant['Consulta-funcao-' . $Vetor]['AtendendoF'][$Fffun]++;
									$Quant['H'][$H]['Consulta-funcao-' . $Vetor]['AtendendoF'][$Fffun]++;
								}
								$Vale = true;
//                  while (($Ligac == trim($Res[$x]['ligacao'])) && ($x<count($Res)) && ($Vale)) {
								while (($Ligac == trim($Res[$x]['ligacao'])) && ($x < count($Res)) && ((trim($Res[$x]['oque']) == "Desligado") || (trim($Res[$x]['oque']) == "Desistencia-FilA") || (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o"))) {
//                    if ((trim($Res[$x]['oque'])!="Desligado") && (trim($Res[$x]['oque'])!="Desistencia-FilA")) {
									//                      $Vale = false; continue;
									//                    }
									$Ligac = trim($Res[$x]['ligacao']);
									$x++;
								}
								$x = $x - 1;
								(trim($Res[$x]['diahorario']) > $Insta) ? $Dura = trim($Res[$x]['diahorario']) - $Insta : $Dura = 0;
								if ($Dura > $Minimo) {
									$Tempo['Consulta-' . $Vetor]['Atendendo'] += $Dura;
									$Tempo['H'][$H]['Consulta-' . $Vetor]['Atendendo'] += $Dura;
									if ($Fffun > "") {
										$Tempo['Consulta-' . $Vetor]['AtendendoF'][$Fffun] += $Dura;
										$Tempo['H'][$H]['Consulta-' . $Vetor]['AtendendoF'][$Fffun] += $Dura;
									}
								}
							} else {
								$Quant['Fila']['Atendendo']++;
								$Quant['DN']['Fila']++;
								$Quant['H'][$H]['Fila']['Atendendo']++;
//???                  $Quant['H'][$H]['Chamadas Atendidas'] ++;
								if ($Fffun > "") {
									$Quant['Fila-funcao']['AtendendoF'][$Fffun]++;
									$Quant['H'][$H]['Fila-funcao']['AtendendoF'][$Fffun]++;
								}
								$Vale = true;
//                  while (($Ligac == trim($Res[$x]['ligacao'])) && ($x<count($Res)) && ($Vale)) {
								while (($Ligac == trim($Res[$x]['ligacao'])) && ($x < count($Res)) && ((trim($Res[$x]['oque']) == "Desligado") || (trim($Res[$x]['oque']) == "Desistencia-FilA") || (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o"))) {
//                    if ((trim($Res[$x]['oque'])!="Desligado") && (trim($Res[$x]['oque'])!="Desistencia-FilA")) {
									//                      $Vale = false; continue;
									//                    }
									$Ligac = trim($Res[$x]['ligacao']);
									$x++;
								}
								$x = $x - 1;
								(trim($Res[$x]['diahorario']) > $Insta) ? $Dura = trim($Res[$x]['diahorario']) - $Insta : $Dura = 0;
								if ($Dura > $Minimo) {
									$Tempo['Fila']['Atendendo'] += $Dura;
									$Tempo['H'][$H]['Fila']['Atendendo'] += $Dura;
									if ($Fffun > "") {
										$Tempo['Fila']['AtendendoF'][$Fffun] += $Dura;
										$Tempo['H'][$H]['Fila']['AtendendoF'][$Fffun] += $Dura;
									}
								}
							}
							$LConv = 1;
						}
						break;
					case "Monitorando PA":
						$Tempo['Monitorando PA'] += trim($Res[$x]['diahorario']) - $Insta;
						if (trim($Res[$x]['diahorario']) > $Insta) {
							$Tempo['H'][$H]['Monitorando PA'] += trim($Res[$x]['diahorario']) - $Insta;
						}

						if ($Pausa_aberta > 0) {
							if ($TipoPausa != "") {
								$Tempo['Em Pausa'] += $Insta - $Pausa_aberta;
								$Tempo['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
								$Tempo['Pausas'][$TipoPausa][$Pausa_aberta] += $Insta - $Pausa_aberta;
								$Quant['Em Pausa']++;
								$Quant['Em Pausa Diferenciada'][$TipoPausa]++;
								$Quant['H'][$H]['Em Pausa']++;
							}
							$Pausa_aberta = 0;
						}
						break;
				}
				$Oque = trim($Res[$x]['oque']);
				$Fila = trim($Res[$x]['fila']);
				$Numer = trim($Res[$x]['numero']);
				$Ligac = trim($Res[$x]['ligacao']);
				$Insta = trim($Res[$x]['diahorario']);
				$Agent = trim($Res[$x]['agente']);
				$Funca = trim($Res[$x]['funcai']);
				//       }
				$x++;
			}
			//Tempo em login
			$Tempo['Login'] = $Login_hora_final - $Login_hora_inicial - $Tempo['Deslogado'];
			//Deixou a pausa ligada, soma ate o fim
			if ($Pausa_aberta > 0) {
				if ($TipoPausa != "") {
					$Quant['Em Pausa']++;
					$Tempo['Em Pausa'] += $Insta - $Pausa_aberta;
					$Quant['Em Pausa Diferenciada'][$TipoPausa]++;
					$Tempo['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
					$Tempo['Pausas'][$TipoPausa][$Pausa_aberta] += $Insta - $Pausa_aberta;
					$Quant['H'][$H]['Em Pausa']++;
				}
				$Pausa_aberta = 0;
				$TipoPausa = "";
			}
			//Tempo total chamando chamadas externas (Fila + Transferência + DDR)
			$Tempo['Chamadas externas']['Chamando'] = $Tempo['Fila']['Chamando'] + $Tempo['DDR']['Chamando'] + $Tempo['Transfer-FILA-Atendidas']['Chamando'] + $Tempo['Transfer-DDR-Atendidas']['Chamando'];
			$Quant['Chamadas externas']['Chamando'] = $Quant['Fila']['Chamando'] + $Quant['DDR']['Chamando'] + $Quant['Transfer-FILA-Atendidas']['Chamando'] + $Quant['Transfer-DDR-Atendidas']['Chamando'];
			//Tempo conversando em atendimento de fila (Transferência + FILA)
			$Tempo['Total Fila']['Atendendo'] = $Tempo['Fila']['Atendendo'];
			//Tempo conversando em atendimento de fila (Transferência + FILA)
			$Tempo['Total Transfer']['Atendendo'] = $Tempo['Transfer-FILA-Atendidas']['Atendendo'] + $Tempo['Transfer-DDR-Atendidas']['Atendendo'];
			$Quant['Total Transfer']['Atendendo'] = $Quant['Transfer-FILA-Atendidas']['Atendendo'] + $Quant['Transfer-DDR-Atendidas']['Atendendo'];
			//Tempo conversando em atendimento de Ligacoes Diretas recebidas (Transferência + DDR)
			$Tempo['Total DDR']['Atendendo'] = $Tempo['DDR']['Atendendo'];
			//Tempo total atendendo chamadas externas (Fila + Transferência + DDR)
			$Tempo['Chamadas externas']['Atendendo'] = $Tempo['Fila']['Atendendo'] + $Tempo['DDR']['Atendendo'] + $Tempo['Transfer-FILA-Atendidas']['Atendendo'] + $Tempo['Transfer-DDR-Atendidas']['Atendendo'];
			$Quant['Chamadas externas']['Atendendo'] = $Quant['Fila']['Atendendo'] + $Quant['DDR']['Atendendo'] + $Quant['Transfer-FILA-Atendidas']['Atendendo'] + $Quant['Transfer-DDR-Atendidas']['Atendendo'];
			//Tempo médio conversando em atendimento (Fila + Transferência + DDR)
			($Quant['Chamadas externas']['Atendendo'] == 0) ? $Tempo['Chamadas externas']['Atendendo-Media'] = 0 : $Tempo['Chamadas externas']['Atendendo-Media'] = ($Tempo['Chamadas externas']['Atendendo'] / $Quant['Chamadas externas']['Atendendo']);
			//Tempo médio conversando em saída (fazendo chamadas externas)
			($Quant['Fazendo chamada externa']['Atendendo'] == 0) ? $Tempo['Fazendo chamada externa']['Atendendo-Media'] = 0 : $Tempo['Fazendo chamada externa']['Atendendo-Media'] = ($Tempo['Fazendo chamada externa']['Atendendo'] / $Quant['Fazendo chamada externa']['Atendendo']);
			//Tempo médio geral em chamadas externas (Saídas + Fila + Transferência + DDR)
			$Tempo['Total chamadas externas']['Atendendo'] = $Tempo['Fazendo chamada externa']['Atendendo'] + $Tempo['Fila']['Atendendo'] + $Tempo['Transfer-DDR-Atendidas']['Atendendo'] + $Tempo['Transfer-FILA-Atendidas']['Atendendo'] + $Tempo['DDR']['Atendendo'];
			$Quant['Total chamadas externas']['Atendendo'] = $Quant['Fazendo chamada externa']['Atendendo'] + $Quant['Fila']['Atendendo'] + $Quant['Transfer-DDR-Atendidas']['Atendendo'] + $Quant['Transfer-FILA-Atendidas']['Atendendo'] + $Quant['DDR']['Atendendo'];
			($Quant['Total chamadas externas']['Atendendo'] == 0) ? $Tempo['Total chamadas externas']['Atendendo-Media'] = 0 : $Tempo['Total chamadas externas']['Atendendo-Media'] = ($Tempo['Total chamadas externas']['Atendendo'] / $Quant['Total chamadas externas']['Atendendo']);
			//Tempo médio conversando em chamadas internas realizadas
			($Quant['Consulta-Realizadas']['Atendendo'] == 0) ? $Tempo['Consulta-Realizadas']['Atendendo-Media'] = 0 : $Tempo['Consulta-Realizadas']['Atendendo-Media'] = ($Tempo['Consulta-Realizadas']['Atendendo'] / $Quant['Consulta-Realizadas']['Atendendo']);
			//Tempo médio conversando em chamadas internas recebidas
			($Quant['Consulta-Atendidas']['Atendendo'] == 0) ? $Tempo['Consulta-Atendidas']['Atendendo-Media'] = 0 : $Tempo['Consulta-Atendidas']['Atendendo-Media'] = ($Tempo['Consulta-Atendidas']['Atendendo'] / $Quant['Consulta-Atendidas']['Atendendo']);
			//Tempo médio conversando em chamadas internas
			$Quant['Consulta']['Atendendo'] = $Quant['Consulta-Atendidas']['Atendendo'] + $Quant['Consulta-Realizadas']['Atendendo'];
			($Quant['Consulta']['Atendendo'] == 0) ? $Tempo['Consulta']['Atendendo-Media'] = 0 : $Tempo['Consulta']['Atendendo-Media'] = ($Tempo['Consulta-Atendidas']['Atendendo'] + $Tempo['Consulta-Realizadas']['Atendendo']) / $Quant['Consulta']['Atendendo'];
			//Tempo médio de demora para atendimento
			$Quant['Demora atendimento']['Chamando'] = $Quant['Chamadas externas']['Atendendo'] + $Tempo['Total externas recebidas']['Nao Atendidas'];
			$Tempo['Demora atendimento']['Chamando'] = $Tempo['Chamadas externas']['Atendendo'];
			($Quant['Demora atendimento']['Chamando'] == 0) ? $Tempo['Demora atendimento']['Chamando-Media'] = 0 : $Tempo['Demora atendimento']['Chamando-Media'] = ($Tempo['Demora atendimento']['Chamando'] / $Quant['Demora atendimento']['Chamando']);
			//Quantidade de transferencias atendidas (Filas + DDR)
			$Quant['Total transfer atendidas']['Atendendo'] = $Quant['Transfer-DDR-Atendidas']['Atendendo'] + $Quant['Transfer-FILA-Atendidas']['Atendendo'];
			//Quantidade de transferencias efetuadas (Filas + DDR)
			$Quant['Total transfer efetuadas']['Chamando'] = $Quant['Transfer-DDR-Realizadas']['Chamando'] + $Quant['Transfer-FILA-Realizadas']['Chamando'] + $Quant['Transfer-Fazendo chamada externa-Realizadas']['Chamando'];
			//Quantidade de transferencias nao atendidas (Filas + DDR)
			$Quant['Total transfer']['Nao Atendidas'] = $Quant['Transfer-DDR-Atendidas']['Nao Atendidas'] + $Quant['Transfer-FILA-Atendidas']['Nao Atendidas'];
			//Quantidade total de chamadas atendidas (Filas + DDR + Transferências)
			$Quant['Total externa atendidas']['Atendendo'] = $Quant['DDR']['Atendendo'] + $Quant['Fila']['Atendendo'] + $Quant['Total transfer atendidas']['Atendendo'];
			$Tempo['Total externa atendidas']['Atendendo'] = $Tempo['DDR']['Atendendo'] + $Tempo['Fila']['Atendendo'];
			($Quant['Total externa atendidas']['Atendendo'] == 0) ? $Tempo['Total externa atendidas']['Atendendo-Media'] = 0 : $Tempo['Total externa atendidas']['Atendendo-Media'] = ($Tempo['Total externa atendidas']['Atendendo'] / $Quant['Total externa atendidas']['Atendendo']);
			//Quantidade de chamadas externas não atendidas (Filas + DDR + Transferências)
			$Quant['Total externas recebidas']['Nao Atendidas'] = $Quant['DDR']['Nao Atendidas'] + $Quant['Fila']['Nao Atendidas'] + $Quant['Transfer-FILA-Atendidas']['Nao Atendidas'] + $Quant['Transfer-DDR-Atendidas']['Nao Atendidas'];
			$Tempo['Total externas recebidas']['Nao Atendidas'] = $Tempo['DDR']['Nao Atendidas'] + $Tempo['Fila']['Nao Atendidas'] + $Tempo['Transfer-FILA-Atendidas']['Nao Atendidas'] + $Tempo['Transfer-DDR-Atendidas']['Nao Atendidas'];
			($Quant['Total externas recebidas']['Nao Atendidas'] == 0) ? $Tempo['Total externas recebidas']['Nao Atendidas-Media'] = 0 : $Tempo['Total externas recebidas']['Nao Atendidas-Media'] = ($Tempo['Total externas recebidas']['Nao Atendidas'] / $Quant['Total externas recebidas']['Nao Atendidas']);
			//Primeiro Login
			$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora FROM " . $this->TabelaR . " WHERE ( agente='" . $Agente . "' " . $LR . " ) AND diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND oque='Login' ORDER BY diahora ASC LIMIT 1";
			if ($tipoPes == 'monit') {
				$Res = $this->Bd->executa_query_com_saida($Pes);
			}

			if ($tipoPes == 'relat') {
				$Res = $this->BdRelat->executa_query_com_saida($Pes);
			}

			if ($Res) {
				$Tempo['Primeiro login'] = date("d/m H:i:s", $Res[0]['agora']);
				$Tempo['Acesso']['I'][$K] = $Tempo['Primeiro login'];
			} else {
				$Tempo['Primeiro login'] = '00:00';
				$Tempo['Acesso']['I'][$K] = '00:00';
			}
			//Ultimo Logout
			$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora FROM " . $this->TabelaR . " WHERE ( agente='" . $Agente . "' " . $LR . " ) AND diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND oque='Logout' ORDER BY diahora DESC LIMIT 1";
			if ($tipoPes == 'monit') {
				$Res = $this->Bd->executa_query_com_saida($Pes);
			}

			if ($tipoPes == 'relat') {
				$Res = $this->BdRelat->executa_query_com_saida($Pes);
			}

			if ($Res) {
				$Tempo['Ultimo logout'] = date("d/m H:i:s", $Res[0]['agora']);
				$Tempo['Acesso']['O'][$K] = $Tempo['Ultimo logout'];
			} else {
				$Tempo['Ultimo logout'] = '00:00';
				$Tempo['Acesso']['O'][$K] = '00:00';
			}
			//Primeiro Login Ativo
			$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora FROM " . $this->TabelaR . " WHERE ( agente='" . $Agente . "' " . $LR . " ) AND diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND oque='Login' AND funcai='ativo' ORDER BY diahora ASC LIMIT 1";
			if ($tipoPes == 'monit') {
				$Res = $this->Bd->executa_query_com_saida($Pes);
			}

			if ($tipoPes == 'relat') {
				$Res = $this->BdRelat->executa_query_com_saida($Pes);
			}

			//Tempo logado Ativo
			if ($Res) {
				$Aux = $Res[0]['agora'];
				$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora FROM " . $this->TabelaR . " WHERE ( agente='" . $Agente . "' " . $LR . " ) AND diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND oque='Logout' AND funcai='ativo' ORDER BY diahora DESC LIMIT 1";
				if ($tipoPes == 'monit') {
					$Res = $this->Bd->executa_query_com_saida($Pes);
				}

				if ($tipoPes == 'relat') {
					$Res = $this->BdRelat->executa_query_com_saida($Pes);
				}

				($Res) ? $Tempo['Logado Followup'] = ($Res[0]['agora'] - $Aux) : $Tempo['Logado Followup'] = ($Login_hora_final - $Aux);
			} else {
				$Tempo['Logado Followup'] = '00:00';
			}

			$Tempo['Livre'] = $Tempo['Login'] - (
				$Tempo['Total DDR']['Atendendo'] +
				$Tempo['Transfer-DDR-Atendidas']['Atendendo'] +
				$Tempo['Fazendo chamada externa']['Atendendo'] +
				$Tempo['Consulta-Realizadas']['Atendendo'] +
				$Tempo['Consulta-Atendidas']['Atendendo'] +
				$Tempo['Fila']['Atendendo'] +
				$Tempo['Transfer-FILA-Atendidas']['Atendendo'] +
				$Tempo['Em Pausa'] +
				$Tempo['DDR']['Chamando'] +
				$Tempo['Fila']['Chamando'] +
				$Tempo['Fazendo chamada externa']['Chamando'] +
				$Tempo['Transfer-FILA-Atendidas']['Chamando'] +
				$Tempo['Transfer-DDR-Atendidas']['Chamando'] +
				$Tempo['Consulta-Realizadas']['Chamando']
			);
			if ($Tempo['Livre'] < 0) {
				$Tempo['Livre'] = 0;
			}

			$Saida = array($Agente, $Tempo, $Quant);
		}
//    return $Said1;
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao le_dados_relatorios
	//
	// Estados no relatorio
	//   Login - Logout => Agente login ou logout
	//   Desligado      => Ligacao desligada
	//   Em Pausa       => Agente em pausa
	//   Livre          => Agente livre
	//   --Entrada        => Nova ligacao
	//   Em conversa&ccedil;&atilde;o => Agente em conversacao
	//   Chamando       => Agente chamando ou sendo chamado
	//   Monitorando PA => Agente monitorando PA
	//
	// Tipos de ligacao
	//   (em branco)    => Sem tipo (login, logout, livre, em pausa, entrada)
	//   --Externa        => Fazendo ligacao externa
	//   Transfer&ecirc;ncia... => Algum tipo de transferencia
	//   Consulta       => Fazendo ou recebendo consulta
	//   DDR            => Recebendo ligacao externa
	//   FILA           => Chamada na fila
	//   --Externo...     => Ligacao externa
	//   Fazendo chamada externa = > Ligando para fora
	//---------------------------------------------------
	function le_dados_relatorios($Res, $Agente, $LR = "", $Inicio, $Fim, $Dehoje = "", $tipoPes = 'monit', $tempoMinCon = 0) {
		$Said1 = '<br><br><spam style="font-size:12pt;">';
		//$NaoAtenfila = $this->QNA;
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$DesisteAPartir = 4;
		$cont1 = 0;
		$cont2 = 0;
		$cont3 = 0;
		$retorno = "";
		if (!is_array($Res)) {
			return false;
		}

		list($Dia_inicial, $Horario_inicial) = explode(' ', $Inicio);
		list($Dia_final, $Horario_final) = explode(' ', $Fim);
		//Tempos
		$Tempo['Livre'] = $Tempo['Em Pausa'] = $Tempo['Login'] = $Tempo['Monitorando PA'] = 0;
		$Tempo['Deslogado'] = 0;
		$Tempo['Fazendo chamada externa']['Atendendo'] = 0;
		$Tempo['DDR']['Atendendo'] = 0;
		$Tempo['Transfer-DDR']['Atendendo'] = 0;
		$Tempo['Consulta-Atendidas']['Atendendo'] = 0;
		$Tempo['Consulta-Realizadas']['Atendendo'] = 0;
		$Tempo['Fila']['Atendendo'] = 0;
		$Tempo['Fazendo chamada externa']['Chamando'] = 0;
		$Tempo['DDR']['Chamando'] = 0;
		$Tempo['Transfer-DDR']['Chamando'] = 0;
		$Tempo['Consulta-Atendidas']['Chamando'] = 0;
		$Tempo['Consulta-Realizadas']['Chamando'] = 0;
		$Tempo['Fila']['Chamando'] = 0;
		$Tempo['Fazendo chamada externa-funcao']['Atendendo']['ativo'] = 0;
		$Tempo['Fila']['Entrada']['Atendendo'] = 0;
		$Tempo['Fila']['Saida']['Atendendo'] = 0;
		$Tempo['Fila']['EntradaSaida']['Atendendo'] = 0;
		$Tempo['Pausas'] = array(); //[nome da pausa][inicio]=duracao
		$Tempo['Pausa']['Manual'] = $Tempo['Pausa']['Automatica'] = 0;
		//Tempos seprados por dia e mes
		$Tempo['DM'] = array();
		$Tempo['H'] = array();
		$indice = 0;
		$teste['tst'] = 0;
		//Quantidades
		$Quant['Em Pausa'] = 0;
		$Quant['Pausa']['Automatica'] = 0;
		$Quant['Pausa']['Manual'] = 0;
		$Quant['Fazendo chamada externa']['Atendendo'] = 0;
		$Quant['DDR']['Atendendo'] = 0;
		$Quant['Transfer-DDR-Atendidas']['Atendendo'] = 0;
		$Quant['Transfer-DDR-Realizadas']['Atendendo'] = 0;
		$Quant['Transfer-FILA-Atendidas']['Atendendo'] = 0;
		$Quant['Transfer-FILA-Realizadas']['Atendendo'] = 0;
		$Quant['Consulta-Atendidas']['Atendendo'] = 0;
		$Quant['Consulta-Realizadas']['Atendendo'] = 0;
		$Quant['Fila']['Atendendo'] = 0;
		$Quant['Fazendo chamada externa']['Chamando'] = 0;
		$Quant['DDR']['Chamando'] = 0;
		$Quant['Transfer-DDR-Realizadas']['Chamando'] = 0;
		$Quant['Transfer-FILA-Realizadas']['Chamando'] = 0;
		$Quant['Consulta-Atendidas']['Chamando'] = 0;
		$Quant['Consulta-Realizadas']['Chamando'] = 0;
		$Quant['Fila']['Chamando'] = 0;
		$Quant['Fazendo chamada externa']['Nao Atendidas'] = 0;
		$Quant['DDR']['Nao Atendidas'] = 0;
		$Quant['Transfer-DDR-Atendidas']['Nao Atendidas'] = 0;
		$Quant['Transfer-DDR-Realizadas']['Nao Atendidas'] = 0;
		$Quant['Transfer-FILA-Atendidas']['Nao Atendidas'] = 0;
		$Quant['Transfer-FILA-Realizadas']['Nao Atendidas'] = 0;
		$Quant['Consulta-Atendidas']['Nao Atendidas'] = 0;
		$Quant['Consulta-Realizadas']['Nao Atendidas'] = 0;
		$Quant['Fila']['Nao Atendidas'] = 0;
		$Quant['Fazendo chamada externa-funcao']['Atendendo']['ativo'] = 0;
		$Quant['Fazendo chamada externa-funcao']['Nao Atendidas']['ativo'] = 0;
		$Quant['Fila']['Entrada']['Atendendo'] = 0;
		$Quant['Fila']['Saida']['Atendendo'] = 0;
		$Quant['Fila']['EntradaSaida']['Atendendo'] = 0;
		$Quant['Total Agentes'] = 1;
		$Quant['DN']['Fila'] = 0;
		$Quant['Transfer-Fazendo chamada externa-Realizadas']['Atendidas'] = 0;
		$Quant['Transfer-Fazendo chamada externa-Realizadas']['Nao Atendidas'] = 0;
		$Quant['H'] = array();
		$Deslog = 0;
		$Deslogado_aberto['H'] = array();
		//Quantidade separados por dia e mes
		//$Quant['DM'] = 0;

		$dia_a = substr($Inicio, 8, 2);
		$mes_a = substr($Inicio, 5, 2);
		$ano_a = substr($Inicio, 0, 4);

		$dia1 = mktime(0, 0, 0, $mes_a, $dia_a, $ano_a);

		//Auxiliares
		$Login_hora_inicial = $Login_hora_final = 0;
		$TipoPausa = "";
		$aux_pausas = array();
		$Aux = $this->lista_pausas('relat');
		for ($l = 0; $l < count($Aux); $l++) {
			$aux_pausas[$Aux[$l]['nome']] = $Aux[$l]['habilitaparapa'];
		}

		//return print_r($aux_pausas, true);
		for ($l = 0; $l < count($Aux); $l++) {
			$Lista_Pausas[] = $Aux[$l]['nome'];
		}

		$LAten = array();
		$LCham = array();
		//Monta os timeout
		$Timeo = array();
		$PesT = "SELECT pseudonimo,timeout FROM " . $this->TabelaF;
		if ($tipoPes == 'monit') {
			$ResT = $this->Bd->executa_query_com_saida($PesT);
		}

		if ($tipoPes == 'relat') {
			$ResT = $this->BdRelat->executa_query_com_saida($PesT);
		}

		for ($k = 0; $k < count($ResT); $k++) {
			$Timeo[$ResT[$k]['pseudonimo']] = $ResT[$k]['timeout'];
			$FilasNome[] = $ResT[$k]['pseudonimo'];
		}
		//Monta as filas de saída e entrada
		$FilasES = array();
		$PesF = "SELECT nome, pseudonimo, direcao FROM " . $this->TabelaF;
		if ($tipoPes == 'monit') {
			$ResF = $this->Bd->executa_query_com_saida($PesF);
		}

		if ($tipoPes == 'relat') {
			$ResF = $this->BdRelat->executa_query_com_saida($PesF);
		}

		for ($l = 0; $l < count($ResF); $l++) {
			if ($ResF[$l]['direcao'] == "") {
				$FilasES[$ResF[$l]['pseudonimo']] = "E ";
			} else {
				$FilasES[$ResF[$l]['pseudonimo']] = $ResF[$l]['direcao'];
			}

		}
		//Primeira acao
		$Insta = trim($Res[0]['diahorario']);
		$Oque = "";
		$Fila = trim($Res[0]['fila']);
		$Numer = trim($Res[0]['numero']);
		$Agent = trim($Res[0]['agente']);
		$Funca = trim($Res[0]['funcai']);
		//A primeira entrada deve ser um login, se nao for
		//eh porque ficou logado
		list($DiaA_inicial, $DiaM_inicial, $DiaD_inicial) = explode('-', $Dia_inicial);
		list($HorH_inicial, $HorM_inicial) = explode(':', $Horario_inicial);
		if (trim($Res[0]['oque']) != "Login") {
			$Login_hora_inicial = mktime($HorH_inicial, $HorM_inicial, 0, $DiaM_inicial, $DiaD_inicial, $DiaA_inicial);
			$Insta = $Login_hora_inicial;
			$Oque = "Livre";
		} else {
			$Login_hora_inicial = $Insta;
		}

		$Login_hora_inicial = $Insta;
		//Primeiro Login
		$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora FROM " . $Tabela . " WHERE ( agente='" . $Agente . "' " . $LR . " ) AND diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND oque='Login' ORDER BY diahora ASC LIMIT 1";
		if ($tipoPes == 'monit') {
			$ResL = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$ResL = $this->BdRelat->executa_query_com_saida($Pes);
		}

		if ($ResL) {
			$Tempo['Primeiro login'] = date("d/m H:i:s", $ResL[0]['agora']);
		} else {
			$Tempo['Primeiro login'] = '00:00';
		}
		//$Login_hora_inicial = $Tempo['Primeiro login'];

		//A ultima entrada deve ser um logout, se nao for
		//eh porque ficou logado
		list($DiaA_final, $DiaM_final, $DiaD_final) = explode('-', $Dia_final);
		list($HorH_final, $HorM_final) = explode(':', $Horario_final);
		$Hora_final = mktime($HorH_final, $HorM_final, 59, $DiaM_final, $DiaD_final, $DiaA_final);
		if ($Hora_final > time()) {
			$Hora_final = time();
		} elseif ($Hora_final < $Res[count($Res) - 1]['diahorario']) {
			$Hora_final = $Res[count($Res) - 1]['diahorario'];
		}

		$Login_hora_final = $Hora_final;
		$Fila = $RamAu = "";
		$Pausa_aberta = $Pausa_abertaQ = $Deslogado_aberto = 0;
		//Limpa os problemas antes de comecar a ler
		$Anterior = "";

		for ($x = 0; $x < count($Res); $x++) {
			if ($Anterior == "Logout") {
				if ((trim($Res[$x]['oque'])) != "Login") {
					$Res[$x]['fila'] = "";
					$Res[$x]['numero'] = "";
					$Res[$x]['ligacao'] = "";
					$Res[$x]['oque'] = "";
					continue;
				}
			}
			if ((trim($Res[$x]['fila'])) == "Transfer&ecirc;ncia-Fazendo chamada externa") {
				array_splice($Res, $x, 1);
				continue;
			}
			$Anterior = $Res[$x]['oque'];
		}
		$y = count($Res) - 1;
		$Flag = true;
		while ($Flag) {
			if ($Res[$y]['oque'] == "") {
				$y--;
				continue;
			}
			if ($Res[$y]['oque'] == "Logout") {
				$Login_hora_final = trim($Res[$y]['diahorario']);
				$Flag = false;
				continue;
			}
			$Flag = false;
		}

		//return $Res;
		//$conta = 0;

		//Comeca a ler a linha do tempo
		for ($x = 0; $x < count($Res); $x++) {
			//So contabilizar se mudar o estado
			if (
				!(
					($Oque == trim($Res[$x]['oque'])) &&
					($Fila == trim($Res[$x]['fila'])) &&
					($Numer == trim($Res[$x]['numero']) || substr($Numer, -8) == substr(trim($Res[$x]['numero']), -8))
				) && (
					substr(trim($Res[$x]['numero']), 0, 3) != 'SIP'
				)
			) {
				$saiTeste .= $Res[$x]['oque'] . " - " . $Res[$x]['fila'] . " - " . $Res[$x]['numero'] . "<br/>";

				if (
					($Numer == trim($Res[$x]['numero'])) &&
					($Ligac != trim($Res[$x]['ligacao'])) &&
					(substr($Res[$x]['fila'], 0, 20) == "Transfer&ecirc;ncia-")
				) {
					continue;
				}

				if (substr(trim($Res[$x]['numero']), 0, $TamAgente) == $Agente) {
					continue;
				}

				if (
					(trim($Res[$x]['ligacao']) == "") &&
					((trim($Res[$x]['oque']) == "Chamando") || (trim($Res[$x]['oque']) == "Em conversa&ccedil;&atilde;o"))
				) {
					continue;
				}

				$Said1 .= trim($Res[$x]['diahorario']) . " | " . trim($Res[$x]['fila']) . " | " . trim($Res[$x]['ligacao']) . " | " . trim($Res[$x]['numero']) . " | " . trim($Res[$x]['oque']) . "<br>";
				$H = intval(date('G', $Insta), 10);
				$K = intval(date('j', $Insta), 10);
				$Mes = intval(date('m', $Insta), 10);
				$Ano = intval(date('Y', $Insta), 10);

				$dia_2 = mktime(0, 0, 0, $Mes, $K, $Ano);
				$Diferenca = ($dia_2 - $dia1);
				$Data = $Diferenca / (60 * 60 * 24);

				//$Tempo['Login'] = $Login_hora_final - $Login_hora_inicial - $Tempo['Deslogado'];

				//monta_array_tempo($K,$Mes, $Ano, $Tabela);

				//$Detalhes['Acumulado'][$cont3] = $Oque;
				//$cont3++;
				switch ($Oque) {
					case "Logout":
						$Deslogado_aberto = $Insta;
						//$Deslog = 1;
						//              if ( ($x==count($Res)-1) && ($Pausa_aberta==0) ) {
						//                if (trim($Res[$x]['diahorario']) > $Insta) $Tempo['Livre']     += trim($Res[$x]['diahorario']) - $Insta;
						//              }

						if ($Res[$x - 2]['oque'] == "Login") {
							$Detalhes['Acumulado'][$cont3]['Estado'] = "Livre";
							$Detalhes['Acumulado'][$cont3]['Inicio'] = $Res[$x - 1]['diahora'];
							$Detalhes['Acumulado'][$cont3]['Duracao'] = $Insta - $inicioEstado;
							$inicioEstado = $Res[$x]['diahorario'];
							$inicioTempoEstado = $Res[$x]['diahora'];
							$cont3++;
						}

						$Detalhes['Acumulado'][$cont3]['Estado'] = "<b>Logoff</b>";
						$Detalhes['Acumulado'][$cont3]['Inicio'] = $Res[$x - 1]['diahora'];
						$Detalhes['Acumulado'][$cont3]['Duracao'] = 0;
						$inicioEstado = $Insta;
						$cont3++;

						if ($Res[$x]['oque'] == "Login") {
							$Detalhes['Acumulado'][$cont3]['Estado'] = "<i>Tempo em logoff</i>";
							$Detalhes['Acumulado'][$cont3]['Inicio'] = $Res[$x - 1]['diahora'];
							$Detalhes['Acumulado'][$cont3]['Duracao'] = $Res[$x]['diahorario'] - $inicioEstado;
							$inicioEstado = $Res[$x]['diahorario'];
							$inicioTempoEstado = $Res[$x]['diahora'];
							$cont3++;
						}

						break;
					case "Login":
						if ($Deslogado_aberto > 0) {
							$Tempo['Deslogado'] += $Insta - $Deslogado_aberto;
							//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Deslogado'] += $Insta - $Deslogado_aberto;
							if ($tipoPes == "relat") {
								$H_deslog = date('G', $Deslogado_aberto);
								$Me_deslog = date('m', $Deslogado_aberto);
								$D_deslog = date('j', $Deslogado_aberto);
								$A_deslog = date('Y', $Deslogado_aberto);
								$H_deslog = intval($H_deslog, 10);
								$Me_deslog = intval($Me_deslog, 10);
								$D_deslog = intval($D_deslog, 10);
								$A_deslog = intval($A_deslog, 10);
								if ($H == $H_deslog) {
									$Tempo['H'][$H]['Deslogado'] += $Insta - $Deslogado_aberto;
								} else {
									for ($h_calc = $H_deslog; $h_calc <= $H; $h_calc++) {
										$h_desl_li = mktime($h_deslog + 1, 0, 0, $Me_deslog, $D_deslog, $A_deslog);
										$h_inic_lo = mktime($H, 0, 0, $Mes, $K, $Ano);
										if ($h_calc == $h_deslog) {
											$retorno .= '<br/>CAIU NA PRIMEIRA AS ' . $h_calc . '<br/>';
											$Tempo['H'][$h_calc]['Deslogado'] += $h_desl_li - $Deslogado_aberto;
										} else if (($h_calc > $h_deslog) && ($h_calc < $H)) {
											$retorno .= '<br/>CAIU NA SEGUNDA AS ' . $h_calc . '<br/>';
											$Tempo['H'][$h_calc]['Deslogado'] += 3600;
										} else if ($h_calc == $H) {
											$retorno .= '<br/>CAIU NA TERCEIRA AS ' . $h_calc . '<br/>';
											$Tempo['H'][$H]['Deslogado'] += $Insta - $h_inic_lo;
										}
									}
								}
							}
							$Deslogado_aberto = 0;
							//$Deslog = 0;
						}

						$Detalhes['Acumulado'][$cont3]['Estado'] = "<b>Login</b>";
						$Detalhes['Acumulado'][$cont3]['Inicio'] = $Res[$x - 1]['diahora'];
						$inicioEstado = $Insta;
						$inicioTempoEstado = $Res[$x]['diahora'];
						$cont3++;

						if ($Res[$x]['oque'] == "Chamando") {
							$Detalhes['Acumulado'][$cont3]['Estado'] = "Livre";
							$Detalhes['Acumulado'][$cont3]['Inicio'] = $Res[$x - 1]['diahora'];
							$Detalhes['Acumulado'][$cont3]['Duracao'] = $Res[$x]['diahorario'] - $inicioEstado;
							$inicioEstado = $Res[$x]['diahorario'];
							$inicioTempoEstado = $Res[$x]['diahora'];
							$cont3++;
						}

						break;
					case "Em Pausa":
                        /********** Filtros ************/
						if ($Res[$x]['oque'] == "Desligado" && $Res[$x + 1]['oque'] == "Em Pausa") break;
                        if(trim($Res[$x - 1]['fila']) == "") break;
                        if($Res[$x]['diahorario'] - $inicioEstado == 0) break;
                        /********** Fim dos Filtros ************/

                        /********** Fix de horario ************/
						$Insta = $Res[$x]['diahorario'];
						if ($Res[$x]['oque'] == "Desligado" && $Res[$x + 1]['oque'] == "Livre") $Insta = $Res[$x + 1]['diahorario'];
                        /********** Fim do Fix de horario ************/

                        if ($aux_pausas[$Fila] == "t") {
                            $Quant['Pausa']['Manual']++;
                            $Tempo['Pausa']['Manual'] += $Insta - $inicioEstado;
                        } else {
                            $Quant['Pausa']['Automatica']++;
                            $Tempo['Pausa']['Automatica'] += $Insta - $inicioEstado;
                        }

                        $Quant['Em Pausa']++;
                        $Quant['Em Pausa Diferenciada'][$Fila]++;
                        $Quant['H'][$H]['Em Pausa Diferenciada'][$Fila]++;
                        $Quant['H'][$H]['Em Pausa']++;
                        $Quant['DH'][$K][$H]['Em Pausa']++;
                        $Quant['DM'][$Data]['Em Pausa']++;
                        $Tempo['Em Pausa'] += $Insta - $inicioEstado;
                        $Tempo['H'][$H]['Em Pausa'] += $Insta - $inicioEstado;
                        $Tempo['Em Pausa Diferenciada'][$Fila] += $Insta - $inicioEstado;
                        $Tempo['H'][$H]['Em Pausa Diferenciada'][$Fila] += $Insta - $inicioEstado;
                        $Tempo['Pausas'][$Fila][$inicioEstado] = $Insta - $inicioEstado;

						$Detalhes['Acumulado'][$cont3]['Estado'] = "Em Pausa";
						$Detalhes['Acumulado'][$cont3]['Inicio'] = $inicioTempoEstado;
						$Detalhes['Acumulado'][$cont3]['Duracao'] = $Insta - $inicioEstado;
						$Detalhes['Acumulado'][$cont3]['Servico'] = $Fila;
						$inicioEstado = $Res[$x]['diahorario'];
						$inicioTempoEstado = $Res[$x]['diahora'];
						$cont3++;

						break;
					case "Livre":
						//              $Tempo['Livre'] += trim($Res[$x]['diahorario']) - $Insta;
						//
						/*
	     Livre                   Filtro para:
	                        - Livre
	                        - Desligado
	                        - Livre
	                        Desconsiderar o final do livre...
*/
						if ($Res[$x]['oque'] == "Desligado" && $Res[$x + 1]['oque'] == "Livre") {
							break;
						}

						if (!$inicioTempoEstado == 0 || !$inicioTempoEstado == "") {
							$Detalhes['Acumulado'][$cont3]['Estado'] = "Livre";
							$Detalhes['Acumulado'][$cont3]['Inicio'] = $inicioTempoEstado;
							$Detalhes['Acumulado'][$cont3]['Duracao'] = $Res[$x]['diahorario'] - $inicioEstado;
							$cont3++;
						}
						$inicioEstado = $Res[$x]['diahorario'];
						$inicioTempoEstado = $Res[$x]['diahora'];

						break;
					case "Em conversa&ccedil;&atilde;o":
						$AConsiderar = trim($Res[$x]['diahorario']);
						//if ((trim($Res[$x]['oque'])=="Desligado") && ($Ligac == trim($Res[$x+1]['ligacao']))) $AConsiderar = trim($Res[$x+1]['diahorario']);

						if ((trim($Res[$x]['oque']) == "Desligado") && ((trim($Res[$x + 1]['oque']) != "Chamando") || (trim($Res[$x + 1]['oque']) != "Em conversa&ccedil;&atilde;o"))) {
							$AConsiderar = trim($Res[$x + 1]['diahorario']);
						}

						$Said1 .= $Insta . " < = > " . $AConsiderar . "<br>";
						if ($Fila == "Fazendo chamada externa" && ($AConsiderar - $Insta) > $tempoMinCon) {
							$Quant['Fazendo chamada externa']['Atendendo']++;
							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fazendo chamada externa']['Atendendo']++;
							$Quant['H'][$H]['Fazendo chamada externa']['Atendendo']++;
							$Quant['DH'][$K][$H]['Fazendo chamada externa']['Atendendo']++;
							$Quant['DM']['Fazendo chamada externa']['Atendendo']++;

							//Guarda os detalhes da ligação
                                                        if(is_numeric(trim($Res[$x]['numero']))) $Detalhes['Chamadas efetuadas'][$cont2]['Numero'] = $Res[$x]['numero'];
							elseif(is_numeric(trim($Res[$x + 1]['numero']))) $Detalhes['Chamadas efetuadas'][$cont2]['Numero'] = $Res[$x + 1]['numero']; 
                                                        elseif(is_numeric(trim($Res[$x - 1]['numero']))) $Detalhes['Chamadas efetuadas'][$cont2]['Numero'] = $Res[$x - 1]['numero'];
                                                        
							$Detalhes['Chamadas efetuadas'][$cont2]['Data'] = $Res[$x - 1]['diahora'];
							$Detalhes['Chamadas efetuadas'][$cont2]['Tempo em conversacao'] = $AConsiderar - $Insta;
							$Detalhes['Chamadas efetuadas'][$cont2]['Status'] = "Atendida";

							if ($AConsiderar > $Insta) {
								$Tempo['Fazendo chamada externa']['Atendendo'] += $AConsiderar - $Insta;
								//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fazendo chamada externa']['Atendendo'] += $AConsiderar - $Insta;
								$Tempo['H'][$H]['Fazendo chamada externa']['Atendendo'] += $AConsiderar - $Insta;
							}
							$Fffun = $Funca;
							if ($Fffun > "") {
								$Quant['Fazendo chamada externa-funcao']['Atendendo'][$Fffun]++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fazendo chamada externa-funcao']['Atendendo']++;
								$Quant['H'][$H]['Fazendo chamada externa-funcao']['Atendendo'][$Fffun]++;
								$Quant['DH'][$K][$H]['Fazendo chamada externa-funcao']['Atendendo'][$Fffun]++;

								$Quant['DM']['Fazendo chamada externa-funcao']['Atendendo'][$Fffun]++;

								if ($AConsiderar > $Insta) {
									$Tempo['Fazendo chamada externa-funcao']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
									//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fazendo chamada externa-funcao']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
									$Tempo['H'][$H]['Fazendo chamada externa-funcao']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
								}
							}
							$cont2++;
						} elseif ($Fila == "DDR") {
							$Quant['DDR']['Atendendo']++;
							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['DDR']['Atendendo']++;
							$Quant['H'][$H]['DDR']['Atendendo']++;
							$Quant['DH'][$K][$H]['DDR']['Atendendo']++;

							$Quant['DM']['DDR']['Atendendo']++;

							$Quant['H'][$H]['Chamadas Atendidas']++;
							$Quant['DH'][$K][$H]['Chamadas Atendidas']++;
							$Quant['DM'][$Data]['Chamadas Atendidas']++;

							$Detalhes['Chamadas atendidas'][$cont1]['Numero'] = $Res[$x - 1]['numero'];
							$Detalhes['Chamadas atendidas'][$cont1]['Data'] = $Res[$x - 1]['diahora'];
							$Detalhes['Chamadas atendidas'][$cont1]['Tempo em conversacao'] = $AConsiderar - $Insta;
							$cont1++;

							if ($AConsiderar > $Insta) {
								$Tempo['DDR']['Atendendo'] += $AConsiderar - $Insta;
								//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['DDR']['Atendendo'];
								$Tempo['H'][$H]['DDR']['Atendendo'] += $AConsiderar - $Insta;
							}
							$Fffun = $Funca;
							if ($Fffun > "") {
								$Quant['DDR-funcao']['Atendendo'][$Fffun]++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['DDR-funcao']['Atendendo'][$Fffun]++;
								$Quant['H'][$H]['DDR-funcao']['Atendendo'][$Fffun]++;
								$Quant['DH'][$K][$H]['DDR-funcao']['Atendendo'][$Fffun]++;

								$Quant['DM'][$Data]['DDR']['Atendendo'][$Fffun]++;

								if ($AConsiderar > $Insta) {
									$Tempo['DDR-funcao']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
									//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['DDR-funcao']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
									$Tempo['H'][$H]['DDR-funcao']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
								}
							}
						} elseif ($Fila == "Transfer&ecirc;ncia-DDR") {
							$Quant['Transfer-DDR-Atendidas']['Atendendo']++;
							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-DDR-Atendidas']['Atendendo']++;
							$Quant['H'][$H]['Transfer-DDR-Atendidas']['Atendendo']++;
							$Quant['DH'][$K][$H]['Transfer-DDR-Atendidas']['Atendendo']++;

							$Quant['DM'][$Data]['Transfer-DDR-Atendidas']['Atendendo']++;

							$Quant['H'][$H]['Chamadas Atendidas']++;
							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Chamadas Atendidas']++;
							$Quant['DH'][$K][$H]['Chamadas Atendidas']++;
							$Quant['DM'][$Data]['Chamadas Atendidas']++;

							$Detalhes['Chamadas atendidas'][$cont1]['Numero'] = $Res[$x - 1]['numero'];
							$Detalhes['Chamadas atendidas'][$cont1]['Data'] = $Res[$x - 1]['diahora'];
							$Detalhes['Chamadas atendidas'][$cont1]['Tempo em conversacao'] = $AConsiderar - $Insta;
							$cont1++;

							if ($AConsiderar > $Insta) {
								$Tempo['Transfer-DDR-Atendidas']['Atendendo'] += $AConsiderar - $Insta;
								//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-DDR-Atendidas']['Atendendo'] += $AConsiderar - $Insta;
								$Tempo['H'][$H]['Transfer-DDR-Atendidas']['Atendendo'] += $AConsiderar - $Insta;
							}
							$Fffun = $Funca;
							if ($Fffun > "") {
								$Quant['Transfer-DDR-funcao-Atendidas']['Atendendo'][$Fffun]++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-DDR-funcao-Atendidas']['Atendendo'][$Fffun]++;
								$Quant['H'][$H]['Transfer-DDR-funcao-Atendidas']['Atendendo'][$Fffun]++;
								$Quant['DH'][$K][$H]['Transfer-DDR-funcao-Atendidas']['Atendendo'][$Fffun]++;

								if (is_scalar($Quant['DM'][$Data]['Transfer-DDR-Atendidas']['Atendendo'][$Fffun])) {
									$Quant['DM'][$Data]['Transfer-DDR-Atendidas']['Atendendo'][$Fffun]++;
								}

								if ($AConsiderar > $Insta) {
									$Tempo['Transfer-DDR-funcao-Atendidas']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
									//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-DDR-funcao-Atendidas']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
									$Tempo['H'][$H]['Transfer-DDR-funcao-Atendidas']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
								}
							}
						} elseif (substr($Fila, 0, 20) == "Transfer&ecirc;ncia-") {
                            if($Res[$x]["oque"] == "Desligado") $AConsiderar = $Res[$x]['diahorario'];
							$Quant['Transfer-FILA-Atendidas']['Atendendo']++;
							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-FILA-Atendidas']['Atendendo']++;
							$Quant['H'][$H]['Transfer-FILA-Atendidas']['Atendendo']++;
							$Quant['DH'][$K][$H]['Transfer-FILA-Atendidas']['Atendendo']++;

							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Chamadas Atendidas']++;
							$Quant['H'][$H]['Chamadas Atendidas']++;
							$Quant['DH'][$K][$H]['Chamadas Atendidas']++;
							$Quant['DM'][$Data]['Chamadas Atendidas']++;

							$Detalhes['Chamadas atendidas'][$cont1]['Numero'] = $Res[$x - 1]['numero'];
							$Detalhes['Chamadas atendidas'][$cont1]['Data'] = $Res[$x - 1]['diahora'];
							$Detalhes['Chamadas atendidas'][$cont1]['Tempo em conversacao'] = $AConsiderar - $Insta;
							$cont1++;

							if ($AConsiderar > $Insta) {
								$Tempo['Transfer-FILA-Atendidas']['Atendendo'] += $AConsiderar - $Insta;
								//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-FILA-Atendidas']['Atendendo'] += $AConsiderar - $Insta;
								$Tempo['H'][$H]['Transfer-FILA-Atendidas']['Atendendo'] += $AConsiderar - $Insta;
							}
							$Fffun = $Funca;
							if ($Fffun > "") {
								$Quant['Transfer-FILA-funcao-Atendidas']['Atendendo'][$Fffun]++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-FILA-funcao-Atendidas']['Atendendo'][$Fffun]++;
								$Quant['H'][$H]['Transfer-FILA-funcao-Atendidas']['Atendendo'][$Fffun]++;
								$Quant['DH'][$K][$H]['Transfer-FILA-funcao-Atendidas']['Atendendo'][$Fffun]++;
								if ($AConsiderar > $Insta) {
									$Tempo['Transfer-FILA-funcao-Atendidas']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
									//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-FILA-funcao-Atendidas']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
									$Tempo['H'][$H]['Transfer-FILA-funcao-Atendidas']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
								}
							}
						} elseif ($Fila == "Consulta") {
							$Quant['Consulta-' . $Vetor]['Atendendo']++;
							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Consulta-'.$Vetor]['Atendendo']++;
							$Quant['H'][$H]['Consulta-' . $Vetor]['Atendendo']++;
							$Quant['DH'][$K][$H]['Consulta-' . $Vetor]['Atendendo']++;
							if ($AConsiderar > $Insta) {
								$Tempo['Consulta-' . $Vetor]['Atendendo'] += $AConsiderar - $Insta;
								//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Consulta-'.$Vetor]['Atendendo'] += $AConsiderar - $Insta;
								$Tempo['H'][$H]['Consulta-' . $Vetor]['Atendendo'] += $AConsiderar - $Insta;
							}
							$Fffun = $Funca;
							if ($Fffun > "") {
								$Quant['Consulta-funcao-' . $Vetor]['Atendendo'][$Fffun]++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Consulta-funcao-'.$Vetor]['Atendendo'][$Fffun]++;
								$Quant['H'][$H]['Consulta-funcao-' . $Vetor]['Atendendo'][$Fffun]++;
								$Quant['DH'][$K][$H]['Consulta-funcao-' . $Vetor]['Atendendo'][$Fffun]++;
								if ($AConsiderar > $Insta) {
									$Tempo['Consulta-funcao-' . $Vetor]['Atendendo'][$Fffun] += $AConsiderar - $Insta;
									//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Consulta-funcao-'.$Vetor]['Atendendo'][$Fffun] += $AConsiderar - $Insta;
									$Tempo['H'][$H]['Consulta-funcao-' . $Vetor]['Atendendo'][$Fffun] += $AConsiderar - $Insta;
								}
							}
						} else if (substr($Fila, 0, 8) == 'Externo-') {
							if ($Res[$x - 1]['oque'] == "Em conversa&ccedil;&atilde;o" && $Res[$x - 1]['ligacao'] == $Res[$x]['ligacao']) {
								break;
							}

							$Quant['DDR']['Atendendo']++;
							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['DDR']['Atendendo']++;
							$Quant['H'][$H]['DDR']['Atendendo']++;
							$Quant['DH'][$K][$H]['DDR']['Atendendo']++;
							$Quant['DM']['DDR']['Atendendo']++;

							$Quant['H'][$H]['Chamadas Atendidas']++;
							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Chamadas Atendidas']++;
							$Quant['DH'][$K][$H]['Chamadas Atendidas']++;
							$Quant['DM'][$Data]['Chamadas Atendidas']++;

							$Detalhes['Chamadas atendidas'][$cont1]['Numero'] = $Res[$x - 1]['numero'];
							$Detalhes['Chamadas atendidas'][$cont1]['Data'] = $Res[$x - 1]['diahora'];
							$Detalhes['Chamadas atendidas'][$cont1]['Tempo em conversacao'] = $AConsiderar - $Insta;
							$cont1++;
						} else {
                            if($Res[$x]['fila'] == "Consulta") $AConsiderar = $Res[$x+1]["diahorario"];
							$Said1 .= $LAten[$Ligac] . '...' . $Tempo['Fila']['Atendendo'] . "<br>";
							if ($LAten[$Ligac] == 0 && ($AConsiderar - $Insta) > $tempoMinCon) {
								//if ( ($LAten==0) && (($AConsiderar - $Insta) > $DesisteAPartir) ) {
								$Quant['Fila']['Atendendo']++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila']['Atendendo']++;
								$Quant['DM']['Fila']['Atendendo']++;
								$Quant['H'][$H]['Fila']['Atendendo']++;
								$Quant['DH'][$K][$H]['Fila']['Atendendo']++;
								$teste['tst']++;
								$Quant['DN']['Fila']++;

								if ($FilasES[$Fila] == "E ") {
									$Quant['Fila']['Entrada']['Atendendo']++;
								} else if ($FilasES[$Fila] == "S ") {
									$Quant['Fila']['Saida']['Atendendo']++;
								} else {
									$Quant['Fila']['EntradaSaida']['Atendendo']++;
								}

								if ($FilasES[$Fila] == "E ") {
									$Tempo['Fila']['Entrada']['Atendendo'] += $AConsiderar - $Insta;
								} else if ($FilasES[$Fila] == "S ") {
									$Tempo['Fila']['Saida']['Atendendo'] += $AConsiderar - $Insta;
								} else {
									$Tempo['Fila']['EntradaSaida']['Atendendo'] += $AConsiderar - $Insta;
								}

								$Quant['H'][$H]['Chamadas Atendidas']++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Chamadas Atendidas']++;
								$Quant['DH'][$K][$H]['Chamadas Atendidas']++;
								$Quant['DM'][$Data]['Chamadas Atendidas']++;

								$Detalhes['Chamadas atendidas'][$cont1]['Numero'] = $Res[$x - 1]['numero'];
								$Detalhes['Chamadas atendidas'][$cont1]['Data'] = $Res[$x - 1]['diahora'];
								$Detalhes['Chamadas atendidas'][$cont1]['Tempo em conversacao'] = $AConsiderar - $Insta;
								$Detalhes['Chamadas atendidas'][$cont1]['Fila'] = $Fila;

								if ($AConsiderar > $Insta) {
									$Tempo['Fila']['Atendendo'] += $AConsiderar - $Insta;
									//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila']['Atendendo'] += $AConsiderar - $Insta;
									$Tempo['H'][$H]['Fila']['Atendendo'] += $AConsiderar - $Insta;
								}
								$Fffun = $Funca;
								if ($Fffun > "") {
									$Quant['Fila-funcao']['Atendendo'][$Fffun]++;
									//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila-funcao']['Atendendo'][$Fffun]++;
									$Quant['H'][$H]['Fila-funcao']['Atendendo'][$Fffun]++;
									$Quant['DH'][$K][$H]['Fila-funcao']['Atendendo'][$Fffun]++;

									$Quant['DM'][$Data]['Fila-funcao']['Atendendo'];

									if ($AConsiderar > $Insta) {
										$Tempo['Fila-funcao']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
										//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila-funcao']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
										$Tempo['H'][$H]['Fila-funcao']['Atendendo'][$Fffun] += $AConsiderar - $Insta;
									}
								}
								$Quant['Fila'][$Fila]['Atendendo']++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila'][$Fila]['Atendendo']++;
								$Quant['H'][$H]['Fila'][$Fila]['Atendendo']++;
								$Quant['DH'][$K][$H]['Fila'][$Fila]['Atendendo']++;

								$Quant['DM'][$Data]['Fila'][$Fila]['Atendendo']++;

								if ($AConsiderar > $Insta) {
									$Tempo['Fila'][$Fila]['Atendendo'] += $AConsiderar - $Insta;
									//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila'][$Fila]['Atendendo'] += $AConsiderar - $Insta;
									$Tempo['H'][$H]['Fila'][$Fila]['Atendendo'] += $AConsiderar - $Insta;
								}
								$Fffun = $Funca;
								if ($Fffun > "") {
									$Quant['Fila-funcao'][$Fila]['Atendendo'][$Fffun]++;
									//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila-funcao'][$Fila]['Atendendo'][$Fffun]++;
									$Quant['H'][$H]['Fila-funcao'][$Fila]['Atendendo'][$Fffun]++;
									$Quant['DH'][$K][$H]['Fila-funcao'][$Fila]['Atendendo'][$Fffun]++;
									if ($AConsiderar > $Insta) {
										$Tempo['Fila-funcao'][$Fila]['Atendendo'][$Fffun] += $AConsiderar - $Insta;
										//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila-funcao'][$Fila]['Atendendo'][$Fffun] += $AConsiderar - $Insta;
										$Tempo['H'][$H]['Fila-funcao'][$Fila]['Atendendo'][$Fffun] += $AConsiderar - $Insta;
									}
								}
								$cont1++;
							}
						}
						$LAten[$Ligac] = 1;

						$Detalhes['Acumulado'][$cont3]['Estado'] = "Em conversação";
						$Detalhes['Acumulado'][$cont3]['Inicio'] = $inicioTempoEstado;
						if ($Res[$x + 1]['oque'] == "Desistencia-FilA") {
							$Detalhes['Acumulado'][$cont3]['Duracao'] = $Res[$x + 1]['diahorario'] - $inicioEstado;
						} else {
							$Detalhes['Acumulado'][$cont3]['Duracao'] = $Res[$x]['diahorario'] - $inicioEstado;
						}

						$Detalhes['Acumulado'][$cont3]['Servico'] = $Fila;
						$Detalhes['Acumulado'][$cont3]['Numero'] = $Numer;
						$inicioEstado = $Res[$x]['diahorario'];
						$inicioTempoEstado = $Res[$x]['diahora'];
						$cont3++;

						break;
					case "Chamando":
						if ($Fila == "Fazendo chamada externa") {
							$Quant['Fazendo chamada externa']['Chamando']++;
							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fazendo chamada externa']['Chamando']++;
							$Quant['H'][$H]['Fazendo chamada externa']['Chamando']++;
							$Quant['DH'][$K][$H]['Fazendo chamada externa']['Chamando']++;

							$Quant['DM'][$Data]['Fazendo chamada externa']['Chamando']++;

							if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['Fazendo chamada externa']['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
								//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fazendo chamada externa']['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['H'][$H]['Fazendo chamada externa']['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
							}
							if (((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) && ((trim($Res[$x]['diahorario']) - $Insta) > $DesisteAPartir)) {
								$Quant['Fazendo chamada externa']['Nao Atendidas']++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fazendo chamada externa']['Nao Atendidas']++;
								$Quant['H'][$H]['Fazendo chamada externa']['Nao Atendidas']++;
								$Quant['DH'][$K][$H]['Fazendo chamada externa']['Nao Atendidas']++;

								$Quant['DM'][$Data]['Fazendo chamada externa']['Nao Atendidas']++;

								//Guarda os detalhes da ligação
								if(is_numeric(trim($Res[$x]['numero']))) $Detalhes['Chamadas efetuadas'][$cont2]['Numero'] = $Res[$x]['numero'];
                                                                elseif(is_numeric(trim($Res[$x - 2]['numero']))) $Detalhes['Chamadas efetuadas'][$cont2]['Numero'] = $Res[$x - 2]['numero'];
                                                                elseif(is_numeric(trim($Res[$x - 1]['numero']))) $Detalhes['Chamadas efetuadas'][$cont2]['Numero'] = $Res[$x - 1]['numero'];
								$Detalhes['Chamadas efetuadas'][$cont2]['Data'] = $Res[$x - 1]['diahora'];
								$Detalhes['Chamadas efetuadas'][$cont2]['Tempo em conversacao'] = 0;
								$Detalhes['Chamadas efetuadas'][$cont2]['Status'] = "N&atilde;o atendida";
								$cont2++;

								$Fffun = $Funca;
								if ($Fffun > "") {
									$Quant['Fazendo chamada externa-funcao']['Nao Atendidas'][$Fffun]++;
									//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fazendo chamada externa-funcao']['Nao Atendidas'][$Fffun]++;
									$Quant['H'][$H]['Fazendo chamada externa-funcao']['Nao Atendidas'][$Fffun]++;
									$Quant['DH'][$K][$H]['Fazendo chamada externa-funcao']['Nao Atendidas'][$Fffun]++;
									$Quant['DM'][$Data]['Fazendo chamada externa-funcao']['Nao Atendidas'][$Fffun]++;
								}
							}
							$Liga = $Res[$x]['ligacao'];
						} elseif ($Fila == "DDR") {
							$Quant['DDR']['Chamando']++;
							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['DDR']['Chamando']++;
							$Quant['H'][$H]['DDR']['Chamando']++;
							$Quant['DH'][$K][$H]['DDR']['Chamando']++;
							if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['DDR']['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
								//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['DDR']['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['H'][$H]['DDR']['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
							}
							if (((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) && ((trim($Res[$x]['diahorario']) - $Insta) > $DesisteAPartir)) {
								$Quant['DDR']['Nao Atendidas']++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['DDR']['Nao Atendidas']++;
								$Quant['H'][$H]['DDR']['Nao Atendidas']++;
								$Quant['DH'][$K][$H]['DDR']['Nao Atendidas']++;
							}
							$Quant['DM']['DDR']['Nao Atendidas']++;
							$Liga = $Res[$x]['ligacao'];
						} elseif ($Fila == "Transfer&ecirc;ncia-DDR") {
							($Numer == $Agente) ? $VetorT = "Realizadas" : $VetorT = "Atendidas";
							$Quant['Transfer-DDR-' . $VetorT]['Chamando']++;
							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-DDR-'.$VetorT]['Chamando']++;
							$Quant['H'][$H]['Transfer-DDR-' . $VetorT]['Chamando']++;
							$Quant['DH'][$K][$H]['Transfer-DDR-' . $VetorT]['Chamando']++;
							if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['Transfer-DDR-' . $VetorT]['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
								//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-DDR-'.$Vetor]['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['H'][$H]['Transfer-DDR-' . $VetorT]['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
							}
							if (((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) && ((trim($Res[$x]['diahorario']) - $Insta) > $DesisteAPartir)) {
								$Quant['Transfer-DDR-' . $VetorT]['Nao Atendidas']++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-DDR-'.$VetorT]['Nao Atendidas']++;
								$Quant['H'][$H]['Transfer-DDR-' . $VetorT]['Nao Atendidas']++;
								$Quant['DH'][$K][$H]['Transfer-DDR-' . $VetorT]['Nao Atendidas']++;
							}$Quant['DM']['Transfer-DDR-' . $VetorT]['Nao Atendidas']++;
							$Liga = $Res[$x]['ligacao'];
						} elseif ($Fila == "Transfer&ecirc;ncia-Fazendo chamada externa") {
							if ((trim($Numer) != '0000') && (trim($Numer) != '0')) {
								$Quant['Transfer-Fazendo chamada externa-Realizadas']['Chamando']++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-Fazendo chamada externa-Realizadas']['Chamando']++;
								$Quant['H'][$H]['Transfer-Fazendo chamada externa-Realizadas']['Chamando']++;
								$Quant['DH'][$K][$H]['Transfer-Fazendo chamada externa-Realizadas']['Chamando']++;
								if (trim($Res[$x]['diahorario']) > $Insta) {
									$Tempo['Transfer-Fazendo chamada externa-Realizadas']['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
									//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-Fazendo chamada externa-Realizadas']['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
									$Tempo['H'][$H]['Transfer-Fazendo chamada externa-Realizadas']['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
								}
								//if (((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']),0,11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) && ((trim($Res[$x]['diahorario']) - $Insta)> $DesisteAPartir)) {
								if ($Res[$x]['diahorario'] - $Insta > 15) {
									$Quant['Transfer-Fazendo chamada externa-Realizadas']['Atendidas']++;
									//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-Fazendo chamada externa-Realizadas']['Nao Atendidas'] ++;
									$Quant['H'][$H]['Transfer-Fazendo chamada externa-Realizadas']['Atendidas']++;
									$Quant['DH'][$K][$H]['Transfer-Fazendo chamada externa-Realizadas']['Atendidas']++;
									$Quant['DM']['Transfer-Fazendo chamada externa-Realizadas']['Atendidas']++;
								} else {
									$Quant['Transfer-Fazendo chamada externa-Realizadas']['Nao Atendidas']++;
									//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-Fazendo chamada externa-Realizadas']['Nao Atendidas'] ++;
									$Quant['H'][$H]['Transfer-Fazendo chamada externa-Realizadas']['Nao Atendidas']++;
									$Quant['DH'][$K][$H]['Transfer-Fazendo chamada externa-Realizadas']['Nao Atendidas']++;
									$Quant['DM']['Transfer-Fazendo chamada externa-Realizadas']['Nao Atendidas']++;
								}
								//}
								$Liga = $Res[$x]['ligacao'];
							}
						} elseif (substr($Fila, 0, 20) == "Transfer&ecirc;ncia-") {
							($Numer == $Agente) ? $VetorT = "Realizadas" : $VetorT = "Atendidas";
							$Quant['Transfer-FILA-' . $VetorT]['Chamando']++;
							//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-FILA-'.$VetorT]['Chamando'] ++;
							$Quant['H'][$H]['Transfer-FILA-' . $VetorT]['Chamando']++;
							$Quant['DH'][$K][$H]['Transfer-FILA-' . $VetorT]['Chamando']++;
							if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['Transfer-FILA-' . $VetorT]['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
								//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-FILA-'.$VetorT]['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['H'][$H]['Transfer-FILA-' . $VetorT]['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
							}
							if (((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) && ((trim($Res[$x]['diahorario']) - $Insta) > $DesisteAPartir)) {
								$Quant['Transfer-FILA-' . $VetorT]['Nao Atendidas']++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Transfer-FILA-'.$VetorT]['Nao Atendidas'] ++;
								$Quant['H'][$H]['Transfer-FILA-' . $VetorT]['Nao Atendidas']++;
								$Quant['DH'][$K][$H]['Transfer-FILA-' . $VetorT]['Nao Atendidas']++;
								$Quant['DM']['Transfer-FILA-' . $VetorT]['Nao Atendidas']++;
							}
							$Liga = $Res[$x]['ligacao'];
						} elseif ($Fila == "Consulta") {
							if ($Agente != $Numer) {
								$Consult = "SELECT numero FROM " . $Tabela . " WHERE ligacao = '" . $Ligac . "' ORDER BY diahora LIMIT 1";
								if ($tipoPes == 'monit') {
									$Respost = $this->Bd->executa_query_com_saida($Consult);
								}

								if ($tipoPes == 'relat') {
									$Respost = $this->BdRelat->executa_query_com_saida($Consult);
								}

								($Respost[0]['numero'] == $Agente) ? $Vetor = "Realizadas" : $Vetor = "Atendidas";
								$Quant['Consulta-' . $Vetor]['Chamando']++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Consulta-'.$Vetor]['Chamando'] ++;
								$Quant['H'][$H]['Consulta-' . $Vetor]['Chamando']++;
								$Quant['DH'][$K][$H]['Consulta-' . $Vetor]['Chamando']++;
								if (trim($Res[$x]['diahorario']) > $Insta) {
									$Tempo['Consulta-' . $Vetor]['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
									//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Consulta-'.$Vetor]['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
									$Tempo['H'][$H]['Consulta-' . $Vetor]['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
								}
								if (((trim($Res[$x]['oque']) == "Livre") || (trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) && ((trim($Res[$x]['diahorario']) - $Insta) > $DesisteAPartir)) {
									$Quant['Consulta-' . $Vetor]['Nao Atendidas']++;
									//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Consulta-'.$Vetor]['Nao Atendidas'] ++;
									$Quant['H'][$H]['Consulta-' . $Vetor]['Nao Atendidas']++;
									$Quant['DH'][$K][$H]['Consulta-' . $Vetor]['Nao Atendidas']++;
									$Quant['DM']['Consulta-' . $Vetor]['Nao Atendidas']++;
								}
								$Liga = $Res[$x]['ligacao'];
							}
						} else {
							if (((trim($Res[$x]['oque']) == "Em Pausa") || (trim($Res[$x]['oque']) == "Desligado") || (substr(trim($Res[$x]['oque']), 0, 11) == "Desistencia") || (trim($Res[$x]['oque']) == "Rejeitado")) && ((trim($Res[$x]['diahorario']) - $Insta) > $DesisteAPartir)) {
								if ((trim($Res[$x]['diahorario']) - $Insta) > $Timeo[$Fila]) {
									$Quant['Fila']['Nao Atendidas']++;
									//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila']['Nao Atendidas'] ++;
									$Quant['DM']['Fila']['Nao Atendidas']++;

									$Quant['Fila'][$Fila]['Nao Atendidas']++;
									//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila'][$Fila]['Nao Atendidas'] ++;
									$Quant['H'][$H]['Fila']['Nao Atendidas']++;
									$Quant['DH'][$K][$H]['Fila']['Nao Atendidas']++;
									$Quant['H'][$H]['Fila'][$Fila]['Nao Atendidas']++;
									$Quant['DH'][$K][$H]['Fila'][$Fila]['Nao Atendidas']++;
									$Quant['DM']['Fila'][$Fila]['Nao Atendidas']++;
								}
							}
							if ((trim($Res[$x]['oque']) == "Livre") && ($Timeo[$Fila] <= (trim($Res[$x]['diahorario']) - $Insta))) {
								$Quant['Fila']['Nao Atendidas']++;
							}

							if ((trim($Res[$x]['diahorario']) - $Insta) > 0) {
								$Quant['Fila']['Chamando']++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila']['Chamando'] ++;
								$Quant['Fila'][$Fila]['Chamando']++;
								//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila'][$Fila]['Chamando'] ++;
								$Quant['H'][$H]['Fila']['Chamando']++;
								$Quant['DH'][$K][$H]['Fila']['Chamando']++;
								$Quant['H'][$H]['Fila'][$Fila]['Chamando']++;
								$Quant['DH'][$K][$H]['Fila'][$Fila]['Chamando']++;
								if (trim($Res[$x]['diahorario']) > $Insta) {
									$Tempo['Fila']['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
									$Tempo['Fila'][$Fila]['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
									//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila']['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
									//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Fila'][$Fila]['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
									$Tempo['H'][$H]['Fila']['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
									$Tempo['H'][$H]['Fila'][$Fila]['Chamando'] += trim($Res[$x]['diahorario']) - $Insta;
								}
							}
							$Liga = $Res[$x]['ligacao'];
						}
						$LCham[$Ligac] = 1;

						//if(trim($Res[$x]['oque'])=="Em conversa&ccedil;&atilde;o"){
						//$Tempo['Livre1'][$indice]['Duracao'] = $Res[$x]['diahorario'] - $inicioLivre;
						//}

						$Detalhes['Acumulado'][$cont3]['Estado'] = "Chamando";
						$Detalhes['Acumulado'][$cont3]['Inicio'] = $inicioTempoEstado;
						$Detalhes['Acumulado'][$cont3]['Servico'] = $Fila;
						$Detalhes['Acumulado'][$cont3]['Numero'] = $Numer;
						$Detalhes['Acumulado'][$cont3]['Duracao'] = $Res[$x]['diahorario'] - $inicioEstado;
						$inicioEstado = $Res[$x]['diahorario'];
						$inicioTempoEstado = $Res[$x]['diahora'];
						$cont3++;

						break;
					case "Monitorando PA":
						$Tempo['Monitorando PA'] += trim($Res[$x]['diahorario']) - $Insta;
						if (trim($Res[$x]['diahorario']) > $Insta) {
							$Tempo['H'][$H]['Monitorando PA'] += trim($Res[$x]['diahorario']) - $Insta;
						}

						break;
				}

				if ($Oque == "Desistencia-FilA") {
					//$Detalhes['Acumulado'][$cont3]['Estado'] = "Desistência fila";
					//$Detalhes['Acumulado'][$cont3]['Inicio'] = $inicioTempoEstado;
					//$Detalhes['Acumulado'][$cont3]['Duracao'] = 0;//$Res[$x]['diahorario'] - $inicioEstado;
					$inicioEstado = $Res[$x]['diahorario'];
					$inicioTempoEstado = $Res[$x]['diahora'];
					//$cont3++;
				}

				$Oque = trim($Res[$x]['oque']);
				$Fila = trim($Res[$x]['fila']);
				$Numer = trim($Res[$x]['numero']);
				$Ligac = trim($Res[$x]['ligacao']);
				$Insta = trim($Res[$x]['diahorario']);
				$Agent = trim($Res[$x]['agente']);
				$Funca = trim($Res[$x]['funcai']);
			}

			//Trata o último registro
			if ($x >= (count($Res) - 1)) {
				if ($Res[$x]['oque'] == "Login") {
					$Detalhes['Acumulado'][$cont3]['Estado'] = "<b>Login</b>";
					$Detalhes['Acumulado'][$cont3]['Inicio'] = $inicioTempoEstado;
					$Detalhes['Acumulado'][$cont3]['Duracao'] = 0; //$Res[$x]['diahorario'] - $inicioEstado;
					$inicioEstado = $Res[$x]['diahorario'];
					$inicioTempoEstado = $Res[$x]['diahora'];
					$cont3++;
					$Detalhes['Acumulado'][$cont3]['Estado'] = "Livre";
					$Detalhes['Acumulado'][$cont3]['Inicio'] = $inicioTempoEstado;
					$Detalhes['Acumulado'][$cont3]['Duracao'] = $Login_hora_final - $inicioEstado;
					$inicioEstado = $Res[$x]['diahorario'];
					$inicioTempoEstado = $Res[$x]['diahora'];
					$cont3++;
				}
			}
		} //Fim do for(...

		//return $saiTeste;

		//$teste['tst']= 100;

		//return $contaTeste;

		//Tempo em login
		$Tempo['Login'] = $Login_hora_final - $Login_hora_inicial - $Tempo['Deslogado'];
		if ($Tempo['Login'] < 0) {
			$Tempo['Login'] = 0;
		}

		//Deixou a pausa ligada, soma ate o fim
		if ($Pausa_aberta > 0) {
			if (($TipoPausa != "") && (in_array($TipoPausa, $Lista_Pausas))) {
				if ($aux_pausas[$TipoPausa] == "t") {
					$Quant['Pausa']['Manual']++;
					$Tempo['Pausa']['Manual'] += $Insta - $Pausa_aberta;
				} else {
					$Quant['Pausa']['Automatica']++;
					$Tempo['Pausa']['Automatica'] += $Insta - $Pausa_aberta;
				}
				$Quant['Em Pausa']++;
				//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Em Pausa'] ++;
				$Tempo['Em Pausa'] += $Insta - $Pausa_aberta;
				//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Em Pausa'] += $Insta - $Pausa_aberta;
				$Quant['H'][$H]['Em Pausa']++;
				$Tempo['H'][$H]['Em Pausa'] += $Insta - $Pausa_aberta;
				$Quant['Em Pausa Diferenciada'][$TipoPausa]++;
				//$Quant['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Em Pausa Diferenciada'][$TipoPausa] ++;
				$Quant['H'][$H]['Em Pausa Diferenciada'][$TipoPausa]++;
				$Tempo['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
				//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
				$Tempo['H'][$H]['Em Pausa Diferenciada'][$TipoPausa] += $Insta - $Pausa_aberta;
				$Tempo['Pausas'][$TipoPausa][$Pausa_aberta] = $Insta - $Pausa_aberta;
				//$Tempo['Ano'][$Ano]['Mes'][$Mes]['Dia'][$k]['Pausas'][$TipoPausa][$Pausa_aberta]  = $Insta - $Pausa_aberta;
				$Quant['DH'][$K][$H]['Em Pausa']++;
			}
			$Pausa_aberta = 0;
			$TipoPausa = "";
		}
		//Tempo total chamando chamadas externas (Fila + Transferência + DDR)
		$Tempo['Chamadas externas']['Chamando'] = $Tempo['Fila']['Chamando'] + $Tempo['DDR']['Chamando'] + $Tempo['Transfer-FILA-Atendidas']['Chamando'] + $Tempo['Transfer-DDR-Atendidas']['Chamando'];
		$Quant['Chamadas externas']['Chamando'] = $Quant['Fila']['Chamando'] + $Quant['DDR']['Chamando'] + $Quant['Transfer-FILA-Atendidas']['Chamando'] + $Quant['Transfer-DDR-Atendidas']['Chamando'];
		//Tempo conversando em atendimento de fila (Transferência + FILA)
		$Tempo['Total Fila']['Atendendo'] = $Tempo['Fila']['Atendendo'];
		//Tempo conversando em atendimento de fila (Transferência + FILA)
		$Tempo['Total Transfer']['Atendendo'] = $Tempo['Transfer-FILA-Atendidas']['Atendendo'] + $Tempo['Transfer-DDR-Atendidas']['Atendendo'];
		$Quant['Total Transfer']['Atendendo'] = $Quant['Transfer-FILA-Atendidas']['Atendendo'] + $Quant['Transfer-DDR-Atendidas']['Atendendo'];
		//Tempo conversando em atendimento de Ligacoes Diretas recebidas (Transferência + DDR)
		$Tempo['Total DDR']['Atendendo'] = $Tempo['DDR']['Atendendo'];
		//Tempo total atendendo chamadas externas (Fila + Transferência + DDR)
		$Tempo['Chamadas externas']['Atendendo'] = $Tempo['Fila']['Atendendo'] + $Tempo['DDR']['Atendendo'] + $Tempo['Transfer-FILA-Atendidas']['Atendendo'] + $Tempo['Transfer-DDR-Atendidas']['Atendendo'];
		$Quant['Chamadas externas']['Atendendo'] = $Quant['Fila']['Atendendo'] + $Quant['DDR']['Atendendo'] + $Quant['Transfer-FILA-Atendidas']['Atendendo'] + $Quant['Transfer-DDR-Atendidas']['Atendendo'];
		//Tempo médio conversando em atendimento (Fila + Transferência + DDR)
		($Quant['Chamadas externas']['Atendendo'] == 0) ? $Tempo['Chamadas externas']['Atendendo-Media'] = 0 : $Tempo['Chamadas externas']['Atendendo-Media'] = ($Tempo['Chamadas externas']['Atendendo'] / $Quant['Chamadas externas']['Atendendo']);
		//Tempo médio conversando em saída (fazendo chamadas externas)
		($Quant['Fazendo chamada externa']['Atendendo'] == 0) ? $Tempo['Fazendo chamada externa']['Atendendo-Media'] = 0 : $Tempo['Fazendo chamada externa']['Atendendo-Media'] = ($Tempo['Fazendo chamada externa']['Atendendo'] / $Quant['Fazendo chamada externa']['Atendendo']);
		//Tempo médio geral em chamadas externas (Saídas + Fila + Transferência + DDR)
		$Tempo['Total chamadas externas']['Atendendo'] = $Tempo['Fazendo chamada externa']['Atendendo'] + $Tempo['Fila']['Atendendo'] + $Tempo['Transfer-DDR-Atendidas']['Atendendo'] + $Tempo['Transfer-FILA-Atendidas']['Atendendo'] + $Tempo['DDR']['Atendendo'];
		$Quant['Total chamadas externas']['Atendendo'] = $Quant['Fazendo chamada externa']['Atendendo'] + $Quant['Fila']['Atendendo'] + $Quant['Transfer-DDR-Atendidas']['Atendendo'] + $Quant['Transfer-FILA-Atendidas']['Atendendo'] + $Quant['DDR']['Atendendo'];
		($Quant['Total chamadas externas']['Atendendo'] == 0) ? $Tempo['Total chamadas externas']['Atendendo-Media'] = 0 : $Tempo['Total chamadas externas']['Atendendo-Media'] = ($Tempo['Total chamadas externas']['Atendendo'] / $Quant['Total chamadas externas']['Atendendo']);
		//Tempo médio conversando em chamadas internas realizadas
		($Quant['Consulta-Realizadas']['Atendendo'] == 0) ? $Tempo['Consulta-Realizadas']['Atendendo-Media'] = 0 : $Tempo['Consulta-Realizadas']['Atendendo-Media'] = ($Tempo['Consulta-Realizadas']['Atendendo'] / $Quant['Consulta-Realizadas']['Atendendo']);
		//Tempo médio conversando em chamadas internas recebidas
		($Quant['Consulta-Atendidas']['Atendendo'] == 0) ? $Tempo['Consulta-Atendidas']['Atendendo-Media'] = 0 : $Tempo['Consulta-Atendidas']['Atendendo-Media'] = ($Tempo['Consulta-Atendidas']['Atendendo'] / $Quant['Consulta-Atendidas']['Atendendo']);
		//Tempo médio conversando em chamadas internas
		$Quant['Consulta']['Atendendo'] = $Quant['Consulta-Atendidas']['Atendendo'] + $Quant['Consulta-Realizadas']['Atendendo'];
		($Quant['Consulta']['Atendendo'] == 0) ? $Tempo['Consulta']['Atendendo-Media'] = 0 : $Tempo['Consulta']['Atendendo-Media'] = ($Tempo['Consulta-Atendidas']['Atendendo'] + $Tempo['Consulta-Realizadas']['Atendendo']) / $Quant['Consulta']['Atendendo'];
		//Tempo médio de demora para atendimento
		$Quant['Demora atendimento']['Chamando'] = $Quant['Chamadas externas']['Atendendo'] + $Tempo['Total externas recebidas']['Nao Atendidas'];
		$Tempo['Demora atendimento']['Chamando'] = $Tempo['Chamadas externas']['Atendendo'];
		($Quant['Demora atendimento']['Chamando'] == 0) ? $Tempo['Demora atendimento']['Chamando-Media'] = 0 : $Tempo['Demora atendimento']['Chamando-Media'] = ($Tempo['Demora atendimento']['Chamando'] / $Quant['Demora atendimento']['Chamando']);
		//Quantidade de transferencias atendidas (Filas + DDR)
		$Quant['Total transfer atendidas']['Atendendo'] = $Quant['Transfer-DDR-Atendidas']['Atendendo'] + $Quant['Transfer-FILA-Atendidas']['Atendendo'];
		//Quantidade de transferencias efetuadas (Filas + DDR)
		$Quant['Total transfer efetuadas']['Chamando'] = $Quant['Transfer-DDR-Realizadas']['Chamando'] + $Quant['Transfer-FILA-Realizadas']['Chamando'] + $Quant['Transfer-Fazendo chamada externa-Realizadas']['Chamando'];
		//Quantidade de transferencias nao atendidas (Filas + DDR)

		$Quant['Total transfer']['Nao Atendidas'] = $Quant['Transfer-DDR-Atendidas']['Nao Atendidas'] + $Quant['Transfer-FILA-Atendidas']['Nao Atendidas'];
		//Quantidade total de chamadas atendidas (Filas + DDR + Transferências)
		$Quant['Total externa atendidas']['Atendendo'] = $Quant['DDR']['Atendendo'] + $Quant['Fila']['Atendendo'] + $Quant['Total transfer atendidas']['Atendendo'];
		$Tempo['Total externa atendidas']['Atendendo'] = $Tempo['DDR']['Atendendo'] + $Tempo['Fila']['Atendendo'];
		($Quant['Total externa atendidas']['Atendendo'] == 0) ? $Tempo['Total externa atendidas']['Atendendo-Media'] = 0 : $Tempo['Total externa atendidas']['Atendendo-Media'] = ($Tempo['Total externa atendidas']['Atendendo'] / $Quant['Total externa atendidas']['Atendendo']);
		//Quantidade de chamadas externas não atendidas (Filas + DDR + Transferências)
		$Quant['DM']['Total externas recebidas']['Nao Atendidas'] = $Quant['DM']['DDR']['Nao Atendidas'] + $Quant['DM']['Fila']['Nao Atendidas'] + $Quant['DM']['Transfer-FILA-Atendidas']['Nao Atendidas'] + $Quant['DM']['Transfer-DDR-Atendidas']['Nao Atendidas'];
		$Quant['Total externas recebidas']['Nao Atendidas'] = $Quant['DDR']['Nao Atendidas'] + $Quant['Fila']['Nao Atendidas'] + $Quant['Transfer-FILA-Atendidas']['Nao Atendidas'] + $Quant['Transfer-DDR-Atendidas']['Nao Atendidas'];
		$Tempo['Total externas recebidas']['Nao Atendidas'] = $Tempo['DDR']['Nao Atendidas'] + $Tempo['Fila']['Nao Atendidas'] + $Tempo['Transfer-FILA-Atendidas']['Nao Atendidas'] + $Tempo['Transfer-DDR-Atendidas']['Nao Atendidas'];
		($Quant['Total externas recebidas']['Nao Atendidas'] == 0) ? $Tempo['Total externas recebidas']['Nao Atendidas-Media'] = 0 : $Tempo['Total externas recebidas']['Nao Atendidas-Media'] = ($Tempo['Total externas recebidas']['Nao Atendidas'] / $Quant['Total externas recebidas']['Nao Atendidas']);
		//Primeiro Login
		$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora FROM " . $Tabela . " WHERE ( agente='" . $Agente . "' " . $LR . " ) AND diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND oque='Login' ORDER BY diahora ASC LIMIT 1";
		if ($tipoPes == 'monit') {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

		if ($Res) {
			$Tempo['Primeiro login'] = date("d/m H:i:s", $Res[0]['agora']);
			$K = date("d", $Res[0]['agora']);
			$K = intval($K, 10);
			$Tempo['Acesso']['I'][$K] = $Tempo['Primeiro login'];
		} else {
			$Tempo['Primeiro login'] = '00:00';
			$Tempo['Acesso']['I'][$K] = '00:00';
		}
		//Ultimo Logout
		$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora FROM " . $Tabela . " WHERE ( agente='" . $Agente . "' " . $LR . " ) AND diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND oque='Logout' ORDER BY diahora DESC LIMIT 1";
		if ($tipoPes == 'monit') {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

		if ($Res) {
			$Tempo['Ultimo logout'] = date("d/m H:i:s", $Res[0]['agora']);
			$K = date("d", $Res[0]['agora']);
			$K = intval($K, 10);
			$Tempo['Acesso']['O'][$K] = $Tempo['Ultimo logout'];
		} else {
			$Tempo['Ultimo logout'] = '00:00';
			$Tempo['Acesso']['O'][$K] = '00:00';
		}
		//Primeiro Login Ativo
		$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora FROM " . $Tabela . " WHERE ( agente='" . $Agente . "' " . $LR . " ) AND diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND oque='Login' AND funcai='ativo' ORDER BY diahora ASC LIMIT 1";
		if ($tipoPes == 'monit') {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

		//Tempo logado Ativo
		if ($Res) {
			$Aux = $Res[0]['agora'];
			$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora FROM " . $Tabela . " WHERE ( agente='" . $Agente . "' " . $LR . " ) AND diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND oque='Logout' AND funcai='ativo' ORDER BY diahora DESC LIMIT 1";
			if ($tipoPes == 'monit') {
				$Res = $this->Bd->executa_query_com_saida($Pes);
			}

			if ($tipoPes == 'relat') {
				$Res = $this->BdRelat->executa_query_com_saida($Pes);
			}

			($Res) ? $Tempo['Logado Followup'] = ($Res[0]['agora'] - $Aux) : $Tempo['Logado Followup'] = ($Login_hora_final - $Aux);
		} else {
			$Tempo['Logado Followup'] = '00:00';
		}

		$Tempo['Livre'] = $Tempo['Login'] - (
			$Tempo['Total DDR']['Atendendo'] +
			$Tempo['Transfer-DDR-Atendidas']['Atendendo'] +
			$Tempo['Fazendo chamada externa']['Atendendo'] +
			$Tempo['Consulta-Realizadas']['Atendendo'] +
			$Tempo['Consulta-Atendidas']['Atendendo'] +
			$Tempo['Fila']['Atendendo'] +
			$Tempo['Transfer-FILA-Atendidas']['Atendendo'] +
			$Tempo['Em Pausa'] +
			$Tempo['DDR']['Chamando'] +
			$Tempo['Fila']['Chamando'] +
			$Tempo['Fazendo chamada externa']['Chamando'] +
			$Tempo['Transfer-FILA-Atendidas']['Chamando'] +
			$Tempo['Transfer-DDR-Atendidas']['Chamando'] +
			$Tempo['Consulta-Realizadas']['Chamando']
		);
		if ($Tempo['Livre'] < 0) {
			$Tempo['Livre'] = 0;
		}

		//Encontrando uma nova solução...
		//INÍCIO DO COMENTÁRIO
		if ($tipoPes == "relat") {
			$retorno = "";
			list($Data_inicial, $Horario_inicial) = explode(' ', $Inicio);
			list($ano, $mes, $dia) = explode('-', $Data_inicial);
			$ano = intval($ano, 10);
			$mes = intval($mes, 10);
			$dia = intval($dia, 10);
			//$retorno = $dia."/".$mes."/".$ano;
			$HorH_inicial = intval($HorH_inicial);
			$HorH_final = intval($HorH_final);
			for ($h = $HorH_inicial; $h <= $HorH_final; $h++) {
				//Tempo em login
				$H_compara = mktime($h, 0, 0, $mes, $dia, $ano); //$H * 3600;
				$H_comp_li = mktime($h + 1, 0, 0, $mes, $dia, $ano);
				//$retorno .= '<br/><br/><br/>H_compara: '.date("d/m/Y H:i:s", $H_compara).' <br/>Login_hora_inicial: '.date("d/m/Y H:i:s", $Login_hora_inicial);
				//$retorno .= '<br/>H_comp_li: '.date("d/m/Y H:i:s", $H_comp_li).'<br/>Login_hora_final: '.date("d/m/Y H:i:s", $Login_hora_final);
				if (($Login_hora_inicial >= $H_compara) && ($Login_hora_inicial < $H_comp_li)) {

					if (($Login_hora_final >= $H_compara) && ($Login_hora_final < $H_comp_li)) {
						$Tempo['H'][$h]['Login'] += $Login_hora_final - $Login_hora_inicial - $Tempo['H'][$h]['Deslogado'];
						$retorno .= '<br/>CAIU NA PRIMEIRA AS<br/>' . $h . ' - ' . $Tempo['H'][$h]['Login'];
					} else if (($Login_hora_final > $H_comp_li)) {
						$Tempo['H'][$h]['Login'] += $H_comp_li - $Login_hora_inicial - $Tempo['H'][$h]['Deslogado'];
						$retorno .= '<br/>CAIU NA SEGUNDA AS <br/>' . $h . ' - ' . $Tempo['H'][$h]['Login'];
					}
				} else if (($Login_hora_inicial < $H_compara) && ($Login_hora_final > $H_comp_li)) {
					//$Tempo['H'][$h]['Login'] += (3600 - ($Tempo['H'][$h]['Deslogado']+0));
					$Tempo['H'][$h]['Login'] += $H_comp_li - $H_compara - $Tempo['H'][$h]['Deslogado'];
					$retorno .= '<br/>CAIU NA HORA CHEIA AS <br/>' . $h . ' - ' . $Tempo['H'][$h]['Login'] . ' - ' . $H_comp_li . ' - ' . $H_compara;
				} else if (($Login_hora_final < $H_comp_li) && ($Login_hora_inicial < $H_compara) && ($Login_hora_final > $H_compara)) {
					$Tempo['H'][$h]['Login'] += $Login_hora_final - $H_compara - $Tempo['H'][$h]['Deslogado'];
					$retorno .= '<br/>CAIU NA ULTIMA AS <br/>' . $h . ' - ' . $Tempo['H'][$h]['Login'];
				}
				//$retorno .= '<br/>Dados: '.$Tempo['H'][$h]['Em Pausa'];
				$Tempo['H'][$h]['Livre'] = $Tempo['H'][$h]['Login'] - (
					$Tempo['H'][$h]['DDR']['Atendendo'] +
					$Tempo['H'][$h]['Transfer-DDR-Atendidas']['Atendendo'] +
					$Tempo['H'][$h]['Fazendo chamada externa']['Atendendo'] +
					$Tempo['H'][$h]['Consulta-Realizadas']['Atendendo'] +
					$Tempo['H'][$h]['Consulta-Atendidas']['Atendendo'] +
					$Tempo['H'][$h]['Fila']['Atendendo'] +
					$Tempo['H'][$h]['Transfer-FILA-Atendidas']['Atendendo'] +
					$Tempo['H'][$h]['Em Pausa'] +
					$Tempo['H'][$h]['DDR']['Chamando'] +
					$Tempo['H'][$h]['Fila']['Chamando'] +
					$Tempo['H'][$h]['Fazendo chamada externa']['Chamando'] +
					$Tempo['H'][$h]['Transfer-FILA-Atendidas']['Chamando'] +
					$Tempo['H'][$h]['Transfer-DDR-Atendidas']['Chamando'] +
					$Tempo['H'][$h]['Consulta-Realizadas']['Chamando'] +
					0
				);
				//if($Tempo['H'][$h]['Livre']<0) $Tempo['H'][$h]['Livre'] = 0;
			}
		}
		//FINAL DO COMENTÁRIO

		$Saida = array($Agente, $Tempo, $Quant, $Detalhes, $retorno);
		//return $Said1;
		//return $SaidaTst;
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao le_agentes_logados_por_hora
	//---------------------------------------------------
	function le_agentes_logados_por_hora($Fila, $Inicio, $Fim, $Dehoje = '', $tipoPes = 'monit') {
		if ($Dehoje == '') {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Tempo = array();
		$Quant = array();

		//Descobre os grupos que tem a fila que deseja pesquisa
		$Pes = "SELECT g.nome AS grupo, f.pseudonimo AS fila FROM " . $this->TabelaO . " AS g INNER JOIN " . $this->TabelOF . " AS r ON r.grupo = g.id INNER JOIN " . $this->TabelaF . " AS f ON f.id = r.fila WHERE f.pseudonimo = '" . $Fila . "'";
		if ($tipoPes == 'monit') {
			$ResG = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$ResG = $this->BdRelat->executa_query_com_saida($Pes);
		}

		$Grup = "";
		for ($x = 0; $x < count($ResG); $x++) {
			$Grup .= " grupos = '" . $ResG[$x]['grupo'] . "' ";
			if ($x != (count($ResG) - 1)) {
				$Grup .= " or ";
			}

		}

		//Pesquisa os logins e os logouts
		list($Dia_inicial, $Horario_inicial) = explode(' ', $Inicio);
		list($Dia_final, $Horario_final) = explode(' ', $Fim);
		$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) AS agora, oque, agente FROM " . $Tabela . " WHERE diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND (oque='Login' OR oque='Logout') AND (" . $Grup . ") ORDER BY diahora";
		if ($tipoPes == 'monit') {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

		$DiasI = explode('/', $Dia_inicial);
		$DiasF = explode('/', $Dia_final);
		$HorsI = explode('/', $Horario_inicial);
		$HorsF = explode('/', $Horario_final);
		for ($d = $DiasI[2] + 0; $d <= ($DiasF[2] + 0); $d++) {
			for ($h = $HorsI[0] + 0; $h <= ($HorsF[0] + 0); $h++) {
				$Quant['DH'][$K][$H]['Agentes-min'] = 0;
				$Quant['DH'][$K][$H]['Agentes'] = 0;
				$Quant['DH'][$K][$H]['Agentes-max'] = 0;
			}
		}
		//Le os dados
		$Ko = $DiasI[0];
		$Ho = $HorsI[0];
		for ($x = 0; $x < count($Res); $x++) {
			$Oque = trim($Res[$x]['oque']);
			$Insta = trim($Res[$x]['agora']);
			$Agent = trim($Res[$x]['agente']);
			$H = intval(date('G', $Insta), 10);
			$K = intval(date('j', $Insta), 10);
			//Arrumas as horas vazias
			if ($H != $Ho) {
				for ($z = $Ko; $z <= $K; $z++) {
					for ($h = $Ho + 1; $h <= ($HorsF[0] + 0); $h++) {
						$Quant['DH'][$z][$h]['Agentes-min'] = $Quant['DH'][$z][$h - 1]['Agentes'];
						$Quant['DH'][$z][$h]['Agentes'] = $Quant['DH'][$z][$h - 1]['Agentes'];
						$Quant['DH'][$z][$h]['Agentes-max'] = $Quant['DH'][$z][$h - 1]['Agentes'];
					}
					if ($z != $K) {
						$Quant['DH'][$z + 1][$HorsI[0]]['Agentes-min'] = $Quant['DH'][$z][$HorsF[0]]['Agentes'];
						$Quant['DH'][$z + 1][$HorsI[0]]['Agentes'] = $Quant['DH'][$z][$HorsF[0]]['Agentes'];
						$Quant['DH'][$z + 1][$HorsI[0]]['Agentes-max'] = $Quant['DH'][$z][$HorsF[0]]['Agentes'];
					}
				}
			}
			switch ($Oque) {
				case "Logout":
					$Quant['DH'][$K][$H]['Agentes']--;
					if ($Quant['DH'][$K][$H]['Agentes'] < 0) {
						$Quant['DH'][$K][$H]['Agentes'] = 0;
					}

					if ($Quant['DH'][$K][$H]['Agentes'] < $Quant['DH'][$K][$H]['Agentes-min']) {
						$Quant['DH'][$K][$H]['Agentes-min'] = $Quant['DH'][$K][$H]['Agentes'];
					}

					break;
				case "Login":
					$Quant['DH'][$K][$H]['Agentes']++;
					if ($Quant['DH'][$K][$H]['Agentes'] > $Quant['DH'][$K][$H]['Agentes-max']) {
						$Quant['DH'][$K][$H]['Agentes-max'] = $Quant['DH'][$K][$H]['Agentes'];
					}

					break;
			}
			$Ho = $H;
			$Ko = $K;
		}
		$Saida = array($Fila, $Tempo, $Quant);
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao relatorio_agentes_acessos
	//
	// Faz select no banco com ou sem login relacionado
	//---------------------------------------------------
	function relatorio_agentes_acessos($Agente, $Inicio, $Fim, $Relacionado = false, $Dehoje = '', $tipoPes = 'monit') {
		if ($Dehoje == '') {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Inicio = trim($Inicio);
		$Fim = trim($Fim);
		$LiR = "";
		if ($Relacionado) {
			$Pes1 = "SELECT " . $this->TabelaA . ".login, " . $this->TabelaA . ".nome, " . $this->TabelaA . ".funcai FROM (SELECT " . $this->TabelAL . ".login  FROM " . $this->TabelAL . " INNER JOIN " . $this->TabelaA . " ON " . $this->TabelaA . ".id=" . $this->TabelAL . ".agente WHERE " . $this->TabelaA . ".login = '" . substr($Agente, 0, 4) . "') as relaciona INNER JOIN " . $this->TabelaA . " ON " . $this->TabelaA . ".id=relaciona.login";
			if ($tipoPes == 'monit') {
				$LogR = $this->Bd->executa_query_com_saida($Pes1);
			}

			if ($tipoPes == 'relat') {
				$LogR = $this->BdRelat->executa_query_com_saida($Pes1);
			}

			if ($LogR) {
				for ($x = 0; $x < count($LogR); $x++) {
					$LiR .= " OR agente='" . $LogR[$x]['login'] . "-" . $LogR[$x]['nome'] . "'";
				}

			}
		}
		$Dini = intval(substr($Inicio, 8, 2), 10);
		$Dfim = intval(substr($Fim, 8, 2), 10);
		for ($k = $Dini; $k <= $Dfim; $k++) {
			$Selecao1 = substr($Inicio, 0, 8) . sprintf('%02d', $k) . ' 00:00';
			$Selecao2 = substr($Inicio, 0, 8) . sprintf('%02d', $k) . ' 23:59';
			//Primeiro Login
			$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora FROM " . $Tabela . " WHERE ( agente='" . $Agente . "' " . $LiR . " ) AND diahora >= '" . $Selecao1 . "' AND diahora <= '" . $Selecao2 . "' AND oque='Login' ORDER BY diahora ASC LIMIT 1";
			if ($tipoPes == 'monit') {
				$Res = $this->Bd->executa_query_com_saida($Pes);
			}

			if ($tipoPes == 'relat') {
				$Res = $this->BdRelat->executa_query_com_saida($Pes);
			}

			if ($Res) {
				$Tempo['Acesso']['I'][$k] = $Res[0]['agora'];
			} else {
				$Tempo['Acesso']['I'][$k] = '00:00';
			}
			$Tempo['Acesso']['X'][$k] = $Selecao1 . "..." . $Selecao2 . "..." . $Pes;
			$Tempo['Acesso']['Y'][$k] = $Inicio;
			//Ultimo Logout
			$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora FROM " . $Tabela . " WHERE ( agente='" . $Agente . "' " . $LiR . " ) AND diahora >= '" . $Selecao1 . "' AND diahora <= '" . $Selecao2 . "' AND oque='Logout' ORDER BY diahora DESC LIMIT 1";
			if ($tipoPes == 'monit') {
				$Res = $this->Bd->executa_query_com_saida($Pes);
			}

			if ($tipoPes == 'relat') {
				$Res = $this->BdRelat->executa_query_com_saida($Pes);
			}

			if ($Res) {
				$Tempo['Acesso']['O'][$k] = $Res[0]['agora'];
			} else {
				$Tempo['Acesso']['O'][$k] = '00:00';
			}
			$Tempo['Acesso']['X'][$k] .= ".." . $Pes;
		}
		return $Tempo;
	}

	//---------------------------------------------------
	// Funcao relatorio_filas
	//
	// Estados no relatorio
	//   Login - Logout => Agente login ou logout
	//   Desligado      => Ligacao desligada
	//   Em Pausa       => Agente em pausa
	//   Livre          => Agente livre
	//   --Entrada        => Nova ligacao
	//   Em conversa&ccedil;&atilde;o => Agente em conversacao
	//   Chamando       => Agente chamando ou sendo chamado
	//   Monitorando PA => Agente monitorando PA
	//
	// Tipos de ligacao
	//   (em branco)    => Sem tipo (login, logout, livre, em pausa, entrada)
	//   --Externa        => Fazendo ligacao externa
	//   Transfer&ecirc;ncia... => Algum tipo de transferencia
	//   Consulta       => Fazendo ou recebendo consulta
	//   DDR            => Recebendo ligacao externa
	//   FILA           => Chamada na fila
	//   --Externo...     => Ligacao externa
	//   Fazendo chamada externa = > Ligando para fora
	//---------------------------------------------------
	function relatorio_filas($Fila, $Inicio, $Fim, $Ligas = false, $MinimoEspera = 0, $Dehoje = "", $tipoPes = 'monit') {
//return $MinimoEspera;
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Said1 = '<br><br><spam style="font-size:12pt;">';
		$Fila = trim($Fila);
		$Pes = "SELECT pseudonimo,tempomaxespeatend,timeout FROM " . $this->TabelaF . " WHERE pseudonimo = '" . $Fila . "'";
		if ($tipoPes == 'monit') {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

		$EsperaMax = $Res[0]['tempomaxespeatend'];
		$NaoAtenfila = $Res[0]['timeout'];
//    if ($MinimoEspera == 0) $DesisteAPartir = 4;
		if ($MinimoEspera <= 4) {
			$DesisteAPartir = 4;
		} else {
			$DesisteAPartir = $MinimoEspera;
		}

//$DesisteAPartir = $MinimoEspera;
		$NomeFila = $Fila;
//    $Pes   = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahora, id, agente, fila, numero, oque, ligacao  FROM ".$this->TabelaR." WHERE diahora >= '".$Inicio."' AND diahora <= '".$Fim."' AND fila LIKE '%".$Fila."%' and agente='0000' ORDER BY ligacao, diahora";
		$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, diahora, id, agente, fila, numero, oque, ligacao  FROM " . $Tabela . " WHERE diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND fila LIKE '" . $Fila . "' AND ligacao>'0' AND (agente!=numero OR oque LIKE 'Desistencia%')
 AND (substring(numero from 1 for 5) NOT IN (SELECT login||'-' FROM " . $this->TabelaA . ")) AND numero != '1234' ORDER BY ligacao, diahora";
		if ($tipoPes == 'monit') {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

//return $Pes;
		if (!is_array($Res)) {
			$Saida = false;
		} else {
			list($Dia_inicial, $Horario_inicial) = explode(' ', $Inicio);
			list($Dia_final, $Horario_final) = explode(' ', $Fim);
			//Determinar a hora final
			list($DiaA_final, $DiaM_final, $DiaD_final) = explode('-', $Dia_final);
			list($HorH_final, $HorM_final) = explode(':', $Horario_final);
			$Hora_final = @mktime($HorH_final, $HorM_final, 59, $DiaM_final, $DiaD_final, $DiaA_final);
			if (!$Hora_final) {
				return false;
			}

			$K = intval($DiaD_final, 10);
			if ($Hora_final > time()) {
				$Hora_final = time();
			}

			//Tempos
			$Tempo['Espera'] = $Tempo['Media Espera'] = $Tempo['Conversacao'] = $Tempo['Maior espera'] = 0;
			//Quantidades
			$Quant['Espera'] = 0;
			$Quant['Espera Maxima'] = 0;
			$Quant['Chamadas Atendidas'] = 0;
			$Quant['Chamadas Recebidas'] = 0;
			$Quant['Chamadas Atendidas no prazo'] = 0;
			$Quant['Desistencias'] = $Quant['Desistencias Fila'] = $Quant['Desistencias Cx'] = $Quant['Desistencias Msg'] = $Quant['Desistencias Desliga'] = 0;
			$Quant['Desistencias 10s'] = $Quant['Desistencias 20s'] = $Quant['Desistencias 30s'] = $Quant['Desistencias 40s'] = 0;
			//Tempos por hora
			$Tempo['H'] = $Quant['H'] = array();
			$FilasH = -1;
			//Tempos por dia
			$Tempo['D'] = $Quant['D'] = array();
			//Tempos por dia e hora
			$Tempo['DH'] = $Quant['DH'] = array();
			//Tempos por hora e minuto
			$Tempo['HM'] = $Quant['HM'] = array();
			//Ligacoes
			$Ligacoes['Desistencias'] = array();
			$Ligacoes['Desistencias Fila'] = array();
			$Ligacoes['Desistencias Cx'] = array();
			$Ligacoes['Desistencias Msg'] = array();
			$Ligacoes['Desistencias Desliga'] = array();
			//Primeira acao
			$Insta = trim($Res[0]['diahorario']);
			$Oque = "";
			$Ligac = "";
			$SaidaT = "";
			$i = 0;
//Comeca a ler a linha do tempo
			for ($x = 0; $x < count($Res); $x++) {
				if (($Oque == trim($Res[$x]['oque'])) && ($Ligac == trim($Res[$x]['ligacao']))) {
					continue;
				}

				$Said1 .= trim($Res[$x]['diahorario']) . " | " . trim($Res[$x]['fila']) . " | " . trim($Res[$x]['ligacao']) . " | " . trim($Res[$x]['numero']) . " | " . trim($Res[$x]['oque']) . "<br>";
				$H = intval(date('G', $Insta), 10);
				if ((intval(date('i', $Insta), 10) >= 0) && (intval(date('i', $Insta), 10) <= 15)) {
					$M = 0;
				}

				if ((intval(date('i', $Insta), 10) > 15) && (intval(date('i', $Insta), 10) <= 30)) {
					$M = 15;
				}

				if ((intval(date('i', $Insta), 10) > 30) && (intval(date('i', $Insta), 10) <= 45)) {
					$M = 30;
				}

				if ((intval(date('i', $Insta), 10) > 45) && (intval(date('i', $Insta), 10) <= 59)) {
					$M = 45;
				}

				//$SaidaT .= $H.":".intval(date('i',$Insta),10)."<br>";

				if ($Ligac != trim($Res[$x]['ligacao'])) {
					if (($Oque == "Chamando") && (trim($Res[$x]['ligacao']) != trim($Res[$x + 1]['ligacao']))) {
						$Insta = trim($Res[$x]['diahorario']);
						$Oque = "";
						$Desligado = 0;
						$LCham = 0;
						$LConv = 0;
						$LDesF = 0;
						$LDesC = 0;
						$LDesM = 0;
						$LDesD = 0;
						$FilasH = -1;
						$TEspera = 0;
						$TempodeEspera = 0;
						$ExpMax = 0;
						$Jachamou = 0;
						continue;
					}
//          if (($Oque == "Chamando") && ($Ligac == trim($Res[$x-1]['ligacao']))) {
					//          if ($LConv == 0)  {
					if (false) {
						if (trim($Res[$x - 1]['diahorario']) > $Insta) {
							if ((trim($Res[$x - 1]['diahorario']) - $Insta) > $MinimoEspera) {
								$Tempo['Espera'] += trim($Res[$x - 1]['diahorario']) - $Insta;
								$TEspera += trim($Res[$x - 1]['diahorario']) - $Insta;
								$Tempo['H'][$H]['Espera'] += trim($Res[$x - 1]['diahorario']) - $Insta;
								$Tempo['D'][$K]['Espera'] += trim($Res[$x - 1]['diahorario']) - $Insta;
								$Tempo['HM'][$H][$M]['Espera'] += trim($Res[$x - 1]['diahorario']) - $Insta;
								$Quant['Espera']--;
								$Quant['H'][$H]['Espera']--;
								$Quant['HM'][$H][$M]['Espera']--;
								$Quant['D'][$K]['Espera']--;
								$Quant['DH'][$K][$H]['Espera']--;
							}
						}
						if ((trim($Res[$x - 1]['diahorario']) - $Insta) > $MinimoEspera) {
							$TempodeEspera = trim($Res[$x - 1]['diahorario']) - $Insta;
							if (($TEspera > $EsperaMax) && ($ExpMax == 0)) {
								$Quant['Espera Maxima']++;
								$Quant['H'][$H]['Espera Maxima']++;
								$Quant['D'][$K]['Espera Maxima']++;
								$Quant['HM'][$H][$M]['Espera Maxima']++;
								$Quant['DH'][$K][$H]['Espera Maxima']++;
								$ExpMax++;
							}
							if ($TEspera > $Tempo['Maior espera']) {
								$Tempo['Maior espera'] = $TEspera;
							}

							if ($TEspera > $Tempo['H'][$H]['Maior espera']) {
								$Tempo['H'][$H]['Maior espera'] = $TEspera;
							}

							if ($TEspera > $Tempo['HM'][$H][$M]['Maior espera']) {
								$Tempo['HM'][$H][$M]['Maior espera'] = $TEspera;
							}

							if ($TEspera > $Tempo['D'][$K]['Maior espera']) {
								$Tempo['D'][$K]['Maior espera'] = $TEspera;
							}

						}
						if ($TempodeEspera > $DesisteAPartir) {
							$Quant['Desistencias FilA']++;
							$Quant['H'][$H]['Desistencias FilA']++;
							$Quant['HM'][$H][$M]['Desistencias FilA']++;
							$Quant['D'][$K]['Desistencias FilA']++;
							$Quant['DH'][$K][$H]['Espera Maxima']++;
							//$Ligacoes['Desistencias FilA'][] = array($Aux_Insta,$Aux_Numer,$TempodeEspera);
							$Ligacoes['Desistencias FilA'][] = array($Res[$x - 1]['diahorario'], $Res[$x - 1]['numero'], $TempodeEspera);
							$FilasH = $H;
							$Quant['DH'][$K][$H]['Desistencias FilA']++;
							$Quant['DH'][$K][$H]['Chamadas Recebidas']++;
						}
					}

					$Insta = trim($Res[$x]['diahorario']);
					$Oque = "";
					$Desligado = 0;
					$LCham = 0;
					$LConv = 0;
					$LDesF = 0;
					$LDesC = 0;
					$LDesM = 0;
					$LDesD = 0;
					$FilasH = -1;
					$TEspera = 0;
					$TempodeEspera = 0;
					$ExpMax = 0;
					$Jachamou = 0;
					$Quant['Chamadas Recebidas']++;
					$Quant['H'][$H]['Chamadas Recebidas']++;
					$Quant['D'][$K]['Chamadas Recebidas']++;
					$Quant['HM'][$H][$M]['Chamadas Recebidas']++;
				}
				switch (trim($Res[$x]['oque'])) {
					case "Chamando":
						//if ((trim($Res[$x]['diahorario']) - $Insta)>4) {
						if ($LCham == 0) {
							if ($Oque == "Em conversa&ccedil;&atilde;o") {
								$Quant['Espera']++;
								$Quant['H'][$H]['Espera']++;
								$Quant['HM'][$H][$M]['Espera']++;
								$Quant['D'][$K]['Espera']++;
								$Quant['DH'][$K][$H]['Espera']++;
								//if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['H'][$H]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['HM'][$H][$M]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['D'][$K]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['DH'][$K][$H]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								//}
								$Quant['DH'][$K][$H]['Conversacao']++;
							}
							$LCham = 1;
						}
						//}
						break;
					case "Em conversa&ccedil;&atilde;o":
						//if ((trim($Res[$x]['diahorario']) - $Insta)>4) {
						//if ($LConv==0) {
						if ($Oque == "Chamando") {
							if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
								$TEspera += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['H'][$H]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['HM'][$H][$M]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['D'][$K]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
								$i = $x; //$Tempo['Conversacao']+= 0;// trim($Res[$x]['diahorario']) - $Insta;
							}
							if (($TEspera > $EsperaMax) && ($ExpMax == 0)) {
								$Quant['Espera Maxima']++;
								$Quant['H'][$H]['Espera Maxima']++;
								$Quant['HM'][$H][$M]['Espera Maxima']++;
								$Quant['D'][$K]['Espera Maxima']++;
								$Quant['DH'][$K][$H]['Espera Maxima']++;
								$Quant['Chamadas Atendidas fora do prazo']++;
								$Quant['H'][$H]['Chamadas Atendidas fora do prazo']++;
								$Quant['HM'][$H][$M]['Chamadas Atendidas fora do prazo']++;
								$Quant['D'][$K]['Chamadas Atendidas fora do prazo']++;
								$Quant['DH'][$K][$H]['Chamadas Atendidas fora do prazo']++;
								$ExpMax++;
							} else {
								$Quant['Chamadas Atendidas no prazo']++;
								$Quant['H'][$H]['Chamadas Atendidas no prazo']++;
								$Quant['HM'][$H][$M]['Chamadas Atendidas no prazo']++;
								$Quant['D'][$K]['Chamadas Atendidas no prazo']++;
								$Quant['DH'][$K][$H]['Chamadas Atendidas no prazo']++;
							}
							if ($TEspera > $Tempo['Maior espera']) {
								$Tempo['Maior espera'] = $TEspera;
							}

							if ($TEspera > $Tempo['H'][$H]['Maior espera']) {
								$Tempo['H'][$H]['Maior espera'] = $TEspera;
							}

							if ($TEspera > $Tempo['HM'][$H][$M]['Maior espera']) {
								$Tempo['HM'][$H][$M]['Maior espera'] = $TEspera;
							}

							if ($TEspera > $Tempo['D'][$K]['Maior espera']) {
								$Tempo['D'][$K]['Maior espera'] = $TEspera;
							}

							$Quant['Chamadas Atendidas']++;
							$Quant['H'][$H]['Chamadas Atendidas']++;
							$Quant['HM'][$H][$M]['Chamadas Atendidas']++;
							$Quant['D'][$K]['Chamadas Atendidas']++;
							$Quant['DH'][$K][$H]['Chamadas Atendidas']++;
							$Quant['DH'][$K][$H]['Chamadas Recebidas']++; /////-4255
							//$Tempo['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
							//}
							//$LConv++;
						}
						//}
						break;
					case "Desligado":
//if ( ($Ligac != trim($Res[$x+1]['ligacao'])) || (($Ligac == trim($Res[$x+1]['ligacao'])) && (trim($Res[$x+1]['oque']) != 'Chamando') && (trim($Res[$x+1]['oque']) != 'Em conversa&ccedil;&atilde;o')) ) {
						//if ((trim($Res[$x]['diahorario']) - $Insta)>4) {
						if ($Oque == "Chamando") {
							$LCham++;
							if (trim($Res[$x]['diahorario']) > $Insta) {
								if ((trim($Res[$x]['diahorario']) - $Insta) > $MinimoEspera) {
									$Tempo['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
									$TEspera += trim($Res[$x]['diahorario']) - $Insta;
									$Tempo['H'][$H]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
									$Tempo['HM'][$H][$M]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
									$Tempo['D'][$K]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
									$Quant['Espera']--;
									$Quant['H'][$H]['Espera']--;
									$Quant['HM'][$H][$M]['Espera']--;
									$Quant['D'][$K]['Espera']--;
									$Quant['DH'][$K][$H]['Espera']--;
								}
							}
							if ((trim($Res[$x]['diahorario']) - $Insta) > $MinimoEspera) {
								$TempodeEspera = trim($Res[$x]['diahorario']) - $Insta;
								if (($TEspera > $EsperaMax) && ($ExpMax == 0)) {
									$Quant['Espera Maxima']++;
									$Quant['H'][$H]['Espera Maxima']++;
									$Quant['HM'][$H][$M]['Espera Maxima']++;
									$Quant['D'][$K]['Espera Maxima']++;
									$Quant['DH'][$K][$H]['Espera Maxima']++;
									$ExpMax++;
								}
								if (($LDesD == 0) && ($LDesM == 0) && ($LDesC == 0) && ($LDesF == 0) && ($TEspera > $DesisteAPartir)) {
									$AuxLD = count($Ligacoes['Desistencias']) - 1;
									if ($Ligacoes['Desistencias'][$AuxLD][1] != $Res[$x]['numero']) {
										$Quant['Desistencias']++;
										$Quant['H'][$H]['Desistencias']++;
										$Quant['HM'][$H][$M]['Desistencias']++;
										$Quant['D'][$K]['Desistencias']++;
										$Ligacoes['Desistencias'][] = array($Res[$x]['diahorario'], $Res[$x]['numero'], $TEspera);
										$Quant['DH'][$K][$H]['Desistencias']++;
										$Quant['DH'][$K][$H]['Chamadas Recebidas']++;
										if ($TEspera <= 10) {
											$Quant['Desistencias 10s']++;
											$Quant['H'][$H]['Desistencias 10s']++;
											$Quant['HM'][$H][$M]['Desistencias 10s']++;
											$Quant['D'][$K]['Desistencias 10s']++;
											$Quant['DH'][$K][$H]['Desistencias 10s']++;
										} elseif ($TEspera <= 20) {
											$Quant['Desistencias 20s']++;
											$Quant['H'][$H]['Desistencias 20s']++;
											$Quant['HM'][$H][$M]['Desistencias 20s']++;
											$Quant['D'][$K]['Desistencias 20s']++;
											$Quant['DH'][$K][$H]['Desistencias 20s']++;
										} elseif ($TEspera <= 30) {
											$Quant['Desistencias 30s']++;
											$Quant['H'][$H]['Desistencias 30s']++;
											$Quant['HM'][$H][$M]['Desistencias 30s']++;
											$Quant['D'][$K]['Desistencias 30s']++;
											$Quant['DH'][$K][$H]['Desistencias 30s']++;
										} else {
											$Quant['Desistencias 40s']++;
											$Quant['H'][$H]['Desistencias 40s']++;
											$Quant['HM'][$H][$M]['Desistencias 40s']++;
											$Quant['D'][$K]['Desistencias 40s']++;
											$Quant['DH'][$K][$H]['Desistencias 40s']++;
										}
///
										if ($TEspera > $Tempo['Maior espera']) {
											$Tempo['Maior espera'] = $TEspera;
										}

										if ($TEspera > $Tempo['H'][$H]['Maior espera']) {
											$Tempo['H'][$H]['Maior espera'] = $TEspera;
										}

										if ($TEspera > $Tempo['HM'][$H][$M]['Maior espera']) {
											$Tempo['HM'][$H][$M]['Maior espera'] = $TEspera;
										}

										if ($TEspera > $Tempo['D'][$K]['Maior espera']) {
											$Tempo['D'][$K]['Maior espera'] = $TEspera;
										}

									}
///
								}
							}
						}
						if ($Oque == "Em conversa&ccedil;&atilde;o") {
							//if (trim($Res[$x]['diahorario']) > $Insta) {
							$Tempo['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
							$Tempo['H'][$H]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
							$Tempo['HM'][$H][$M]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
							$Tempo['D'][$K]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
							//}
						}
						$Desligado = 1;
//}
						//}
						break;
//          case "Desistencia-Fila":
					case "Desistencia-FilA":
						//if ((trim($Res[$x]['diahorario']) - $Insta)>4) {
						$Said1 .= "Desistencia-filA - ";
						if (($Desligado == 0) && ($LDesD == 0) && ($LDesM == 0) && ($LDesC == 0) && ($LDesF == 0) && ($Ligac == trim($Res[$x]['ligacao']))) {
							$Said1 .= "Passei 1 - ";
							$TempodeEspera = 0;
							if (($Oque == "Chamando") && ($LCham == 1)) {
								$Said1 .= "Passei 2 - ";
								$LCham++;
//                if ((trim($Res[$x+1]['oque'])=="Chamando") && ($Ligac == trim($Res[$x+1]['ligacao']))) {
								//                  $Oque  = "Chamando";
								//                  continue;
								//                }
								if (trim($Res[$x]['diahorario']) > $Insta) {
									if ((trim($Res[$x]['diahorario']) - $Insta) > $MinimoEspera) {
										$Tempo['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$TEspera += trim($Res[$x]['diahorario']) - $Insta;
										$Tempo['H'][$H]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$Tempo['HM'][$H][$M]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$Tempo['D'][$K]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$Quant['Espera']--;
										$Quant['H'][$H]['Espera']--;
										$Quant['HM'][$H][$M]['Espera']--;
										$Quant['D'][$K]['Espera']--;
										$Quant['DH'][$K][$H]['Espera']--;
									}
								}
								if ((trim($Res[$x]['diahorario']) - $Insta) > $MinimoEspera) {

									$TempodeEspera = trim($Res[$x]['diahorario']) - $Insta;
									if (($TEspera > $EsperaMax) && ($ExpMax == 0)) {
										$Quant['Espera Maxima']++;
										$Quant['H'][$H]['Espera Maxima']++;
										$Quant['HM'][$H][$M]['Espera Maxima']++;
										$Quant['D'][$K]['Espera Maxima']++;
										$Quant['DH'][$K][$H]['Espera Maxima']++;
										$ExpMax++;
									}
									if ($TEspera > $Tempo['Maior espera']) {
										$Tempo['Maior espera'] = $TEspera;
									}

									if ($TEspera > $Tempo['H'][$H]['Maior espera']) {
										$Tempo['H'][$H]['Maior espera'] = $TEspera;
									}

									if ($TEspera > $Tempo['HM'][$H][$M]['Maior espera']) {
										$Tempo['HM'][$H][$M]['Maior espera'] = $TEspera;
									}

									if ($TEspera > $Tempo['D'][$K]['Maior espera']) {
										$Tempo['D'][$K]['Maior espera'] = $TEspera;
									}

								}
							}
							if ($Oque == "Em conversa&ccedil;&atilde;o") {
								$Said1 .= "Passei 3 - ";
								//if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['H'][$H]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['HM'][$H][$M]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['D'][$K]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								//}
							}
							//} else {
							//if ($TempodeEspera>$NaoAtenfila) {
							$Said1 .= "TempodeEspera:" . $TempodeEspera . " DesisteAPartir:" . $DesisteAPartir . " LCham:" . $LCham . " LConv:" . $LConv;
//              if (($TempodeEspera>$DesisteAPartir) && (($LCham==1) || ($LConv==1))) {
							//              if (($LCham>0) || ($LConv>0)) {
							if (($LCham > 0) && ($LConv == 0) && ((trim($Res[$x]['diahorario']) - $Insta) > $MinimoEspera)) {

								$Said1 .= "Passei 4 - ";
								$Quant['Desistencias FilA']++;
								$Quant['H'][$H]['Desistencias FilA']++;
								$Quant['HM'][$H][$M]['Desistencias FilA']++;
								$Quant['D'][$K]['Desistencias FilA']++;
								$Quant['DH'][$K][$H]['Espera Maxima']++;
								//$Ligacoes['Desistencias FilA'][] = array($Aux_Insta,$Aux_Numer,$TempodeEspera);
								$Ligacoes['Desistencias FilA'][] = array($Res[$x]['diahorario'], $Res[$x]['numero'], $TempodeEspera);
								$FilasH = $H;
								$Quant['DH'][$K][$H]['Desistencias FilA']++;
								$Quant['DH'][$K][$H]['Chamadas Recebidas']++;
								if ($TEspera <= 10) {
									$Quant['Desistencias FilA 10s']++;
									$Quant['H'][$H]['Desistencias FilA 10s']++;
									$Quant['HM'][$H][$M]['Desistencias FilA 10s']++;
									$Quant['D'][$K]['Desistencias FilA 10s']++;
									$Quant['DH'][$K][$H]['Desistencias FilA 10s']++;
								} elseif ($TEspera <= 20) {
									$Quant['Desistencias FilA 20s']++;
									$Quant['H'][$H]['Desistencias FilA 20s']++;
									$Quant['HM'][$H][$M]['Desistencias FilA 20s']++;
									$Quant['D'][$K]['Desistencias FilA 20s']++;
									$Quant['DH'][$K][$H]['Desistencias FilA 20s']++;
								} elseif ($TEspera <= 30) {
									$Quant['Desistencias FilA 30s']++;
									$Quant['H'][$H]['Desistencias FilA 30s']++;
									$Quant['HM'][$H][$M]['Desistencias FilA 30s']++;
									$Quant['D'][$K]['Desistencias FilA 30s']++;
									$Quant['DH'][$K][$H]['Desistencias FilA 30s']++;
								} else {
									$Quant['Desistencias FilA 40s']++;
									$Quant['H'][$H]['Desistencias FilA 40s']++;
									$Quant['HM'][$H][$M]['Desistencias FilA 40s']++;
									$Quant['D'][$K]['Desistencias FilA 40s']++;
									$Quant['DH'][$K][$H]['Desistencias FilA 40s']++;
								}
							}
							//}
						}
						$Said1 .= "<br>";
						$LDesF = 1;
						//}
						break;
					case "Desistencia-Caixa_Postal":
						//if ((trim($Res[$x]['diahorario']) - $Insta)>4) {
						if (($Desligado == 0) && ($LDesD == 0) && ($LDesM == 0) && ($LDesC == 0) && ($LDesF == 0)) {
							$TempodeEspera = 0;
							if (($Oque == "Chamando") && ($LCham == 1)) {
								$LCham++;
								if (trim($Res[$x]['diahorario']) > $Insta) {
									if ((trim($Res[$x]['diahorario']) - $Insta) >= $MinimoEspera) {
										$Tempo['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$TEspera += trim($Res[$x]['diahorario']) - $Insta;
										$Tempo['H'][$H]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$Tempo['HM'][$H][$M]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$Tempo['D'][$K]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$Quant['Espera']--;
										$Quant['H'][$H]['Espera']--;
										$Quant['HM'][$H][$M]['Espera']--;
										$Quant['D'][$K]['Espera']--;
										$Quant['DH'][$K][$H]['Espera']--;
									}
								}
								if ((trim($Res[$x]['diahorario']) - $Insta) >= $MinimoEspera) {

									$TempodeEspera = trim($Res[$x]['diahorario']) - $Insta;
									if (($TEspera > $EsperaMax) && ($ExpMax == 0)) {
										$Quant['Espera Maxima']++;
										$Quant['H'][$H]['Espera Maxima']++;
										$Quant['HM'][$H][$M]['Espera Maxima']++;
										$Quant['D'][$K]['Espera Maxima']++;
										$Quant['DH'][$K][$H]['Espera Maxima']++;
										$ExpMax++;
									}
									if ($TEspera > $Tempo['Maior espera']) {
										$Tempo['Maior espera'] = $TEspera;
									}

									if ($TEspera > $Tempo['H'][$H]['Maior espera']) {
										$Tempo['H'][$H]['Maior espera'] = $TEspera;
									}

									if ($TEspera > $Tempo['HM'][$H][$M]['Maior espera']) {
										$Tempo['HM'][$H][$M]['Maior espera'] = $TEspera;
									}

									if ($TEspera > $Tempo['D'][$K]['Maior espera']) {
										$Tempo['D'][$K]['Maior espera'] = $TEspera;
									}

								}
							}
							if ($Oque == "Em conversa&ccedil;&atilde;o") {
								//if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['H'][$H]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['HM'][$H][$M]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['D'][$K]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								//}
							}
							if ($TempodeEspera >= $MinimoEspera) {
								$Quant['Desistencias Cx']++;
								$Quant['H'][$H]['Desistencias Cx']++;
								$Quant['HM'][$H][$M]['Desistencias Cx']++;
								$Quant['D'][$K]['Desistencias Cx']++;
								$Ligacoes['Desistencias Cx'][] = array($Res[$x]['diahorario'], $Res[$x]['numero'], $TempodeEspera);
								$LDesC = 1;
								$Quant['DH'][$K][$H]['Desistencias Cx']++;
								$Quant['DH'][$K][$H]['Chamadas Recebidas']++; /////2364
							}
						}
						//}
						break;
					case "Desistencia-Msg_Atendimento":
						//if ((trim($Res[$x]['diahorario']) - $Insta)>4) {
						if (($Desligado == 0) && ($LDesD == 0) && ($LDesM == 0) && ($LDesC == 0) && ($LDesF == 0)) {
							$TempodeEspera = 0;
							if (($Oque == "Chamando") && ($LCham == 1)) {
								$LCham++;
								if (trim($Res[$x]['diahorario']) > $Insta) {
									if ((trim($Res[$x]['diahorario']) - $Insta) >= $MinimoEspera) {
										$Tempo['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$TEspera += trim($Res[$x]['diahorario']) - $Insta;
										$Tempo['H'][$H]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$Tempo['HM'][$H][$M]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$Tempo['D'][$K]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$Quant['Espera']--;
										$Quant['H'][$H]['Espera']--;
										$Quant['HM'][$H][$M]['Espera']--;
										$Quant['D'][$K]['Espera']--;
										$Quant['DH'][$K][$H]['Espera']--;
									}
								}
								if ((trim($Res[$x]['diahorario']) - $Insta) >= $MinimoEspera) {
									$TempodeEspera = trim($Res[$x]['diahorario']) - $Insta;
									if (($TEspera > $EsperaMax) && ($ExpMax == 0)) {
										$Quant['Espera Maxima']++;
										$Quant['H'][$H]['Espera Maxima']++;
										$Quant['HM'][$H][$M]['Espera Maxima']++;
										$Quant['D'][$K]['Espera Maxima']++;
										$Quant['DH'][$K][$H]['Espera Maxima']++;
										$ExpMax++;
									}
								}
							}
							if ($Oque == "Em conversa&ccedil;&atilde;o") {
								//if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['H'][$H]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['HM'][$H][$M]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['D'][$K]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								//}
							}
							if ($TempodeEspera >= $MinimoEspera) {
								$Quant['Desistencias Msg']++;
								$Quant['H'][$H]['Desistencias Msg']++;
								$Quant['HM'][$H][$M]['Desistencias Msg']++;
								$Quant['D'][$K]['Desistencias Msg']++;
								$Ligacoes['Desistencias Msg'][] = array($Res[$x]['diahorario'], $Res[$x]['numero'], $TempodeEspera);
								$LDesM = 1;
								$Quant['DH'][$K][$H]['Desistencias Msg']++;
								$Quant['DH'][$K][$H]['Chamadas Recebidas']++; /////0
								if ($TEspera > $Tempo['Maior espera']) {
									$Tempo['Maior espera'] = $TEspera;
								}

								if ($TEspera > $Tempo['H'][$H]['Maior espera']) {
									$Tempo['H'][$H]['Maior espera'] = $TEspera;
								}

								if ($TEspera > $Tempo['HM'][$H][$M]['Maior espera']) {
									$Tempo['HM'][$H][$M]['Maior espera'] = $TEspera;
								}

								if ($TEspera > $Tempo['D'][$K]['Maior espera']) {
									$Tempo['D'][$K]['Maior espera'] = $TEspera;
								}

							}
						}
						//}
						break;
					case "Desistencia-Desligamento":
						//if ((trim($Res[$x]['diahorario']) - $Insta)>4) {
						if (($Desligado == 0) && ($LDesD == 0) && ($LDesM == 0) && ($LDesC == 0) && ($LDesF == 0)) {
							$TempodeEspera = 0;
							if (($Oque == "Chamando") && ($LCham == 1)) {
								$LCham++;
								if (trim($Res[$x]['diahorario']) > $Insta) {
									if ((trim($Res[$x]['diahorario']) - $Insta) > $MinimoEspera) {
										$Tempo['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$TEspera += trim($Res[$x]['diahorario']) - $Insta;
										$Tempo['H'][$H]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$Tempo['HM'][$H][$M]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$Tempo['D'][$K]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
										$Quant['Espera']--;
										$Quant['H'][$H]['Espera']--;
										$Quant['HM'][$H][$M]['Espera']--;
										$Quant['D'][$K]['Espera']--;
										$Quant['DH'][$K][$H]['Espera']--;
									}
								}
								if ((trim($Res[$x]['diahorario']) - $Insta) >= $MinimoEspera) {

									$TempodeEspera = trim($Res[$x]['diahorario']) - $Insta;
									if (($TEspera > $EsperaMax) && ($ExpMax == 0)) {
										$Quant['Espera Maxima']++;
										$Quant['H'][$H]['Espera Maxima']++;
										$Quant['HM'][$H][$M]['Espera Maxima']++;
										$Quant['D'][$K]['Espera Maxima']++;
										$Quant['DH'][$K][$H]['Espera Maxima']++;
										$ExpMax++;
									}
									if ($TempodeEspera > $DesisteAPartir) {
										$AuxLD = count($Ligacoes['Desistencias']) - 1;
										if ($Ligacoes['Desistencias'][$AuxLD][1] != $Res[$x]['numero']) {
											$Quant['Desistencias']++;
											$Quant['H'][$H]['Desistencias']++;
											$Quant['HM'][$H][$M]['Desistencias']++;
											$Quant['D'][$K]['Desistencias']++;
											$Ligacoes['Desistencias'][] = array($Res[$x]['diahorario'], $Res[$x]['numero'], $TempodeEspera);
											//if ($TEspera<=10) $Quant['Desistencias 10s']++;
											//elseif ($TEspera<=20) $Quant['Desistencias 20s']++;
											//elseif ($TEspera<=30) $Quant['Desistencias 30s']++;
											//else  $Quant['Desistencias 40s']++;
											if ($TEspera <= 10) {
												$Quant['Desistencias 10s']++;
												$Quant['H'][$H]['Desistencias 10s']++;
												$Quant['HM'][$H][$M]['Desistencias 10s']++;
												$Quant['D'][$K]['Desistencias 10s']++;
												$Quant['DH'][$K][$H]['Desistencias 10s']++;
											} elseif ($TEspera <= 20) {
												$Quant['Desistencias 20s']++;
												$Quant['H'][$H]['Desistencias 20s']++;
												$Quant['HM'][$H][$M]['Desistencias 20s']++;
												$Quant['D'][$K]['Desistencias 20s']++;
												$Quant['DH'][$K][$H]['Desistencias 20s']++;
											} elseif ($TEspera <= 30) {
												$Quant['Desistencias 30s']++;
												$Quant['H'][$H]['Desistencias 30s']++;
												$Quant['HM'][$H][$M]['Desistencias 30s']++;
												$Quant['D'][$K]['Desistencias 30s']++;
												$Quant['DH'][$K][$H]['Desistencias 30s']++;
											} else {
												$Quant['Desistencias 40s']++;
												$Quant['H'][$H]['Desistencias 40s']++;
												$Quant['HM'][$H][$M]['Desistencias 40s']++;
												$Quant['D'][$K]['Desistencias 40s']++;
												$Quant['DH'][$K][$H]['Desistencias 40s']++;
											}
											$LDesD = 1;
											$Quant['DH'][$K][$H]['Desistencias']++;
											if ($TEspera > $Tempo['Maior espera']) {
												$Tempo['Maior espera'] = $TEspera;
											}

											if ($TEspera > $Tempo['H'][$H]['Maior espera']) {
												$Tempo['H'][$H]['Maior espera'] = $TEspera;
											}

											if ($TEspera > $Tempo['HM'][$H][$M]['Maior espera']) {
												$Tempo['HM'][$H][$M]['Maior espera'] = $TEspera;
											}

											if ($TEspera > $Tempo['D'][$K]['Maior espera']) {
												$Tempo['D'][$K]['Maior espera'] = $TEspera;
											}

										}
									}
								}
							} else {
								if ($TempodeEspera > $DesisteAPartir) {
									$Quant['Desistencias Desliga']++;
									$Quant['H'][$H]['Desistencias Desliga']++;
									$Quant['HM'][$H][$M]['Desistencias Desliga']++;
									$Quant['D'][$K]['Desistencias Desliga']++;
									$Ligacoes['Desistencias Desliga'][] = array($Res[$x]['diahorario'], $Res[$x]['numero'], $TempodeEspera);
									if ($TEspera <= 10) {
										$Quant['Desistencias Desliga 10s']++;
										$Quant['H'][$H]['Desistencias Desliga 10s']++;
										$Quant['HM'][$H][$M]['Desistencias Desliga 10s']++;
										$Quant['D'][$K]['Desistencias Desliga 10s']++;
										$Quant['DH'][$K][$H]['Desistencias Desliga 10s']++;
									} elseif ($TEspera <= 20) {
										$Quant['Desistencias Desliga 20s']++;
										$Quant['H'][$H]['Desistencias Desliga 20s']++;
										$Quant['HM'][$H][$M]['Desistencias Desliga 20s']++;
										$Quant['D'][$K]['Desistencias Desliga 20s']++;
										$Quant['DH'][$K][$H]['Desistencias Desliga 20s']++;
									} elseif ($TEspera <= 30) {
										$Quant['Desistencias Desliga 30s']++;
										$Quant['H'][$H]['Desistencias Desliga 30s']++;
										$Quant['HM'][$H][$M]['Desistencias Desliga 30s']++;
										$Quant['D'][$K]['Desistencias Desliga 30s']++;
										$Quant['DH'][$K][$H]['Desistencias Desliga 30s']++;
									} else {
										$Quant['Desistencias Desliga 40s']++;
										$Quant['H'][$H]['Desistencias Desliga 40s']++;
										$Quant['HM'][$H][$M]['Desistencias Desliga 40s']++;
										$Quant['D'][$K]['Desistencias Desliga 40s']++;
										$Quant['DH'][$K][$H]['Desistencias Desliga 40s']++;
									}
									$LDesD = 1;
									$Quant['DH'][$K][$H]['Desistencias Desliga']++;
								}
							}
							if ($Oque == "Em conversa&ccedil;&atilde;o") {
								//if (trim($Res[$x]['diahorario']) > $Insta) {
								$Tempo['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['H'][$H]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['HM'][$H][$M]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								$Tempo['D'][$K]['Conversacao'] += trim($Res[$x]['diahorario']) - $Insta;
								//}
							}
//              $Quant['Desistencias Desliga']++;
							//              $Quant['H'][$H]['Desistencias Desliga']++;
							//              $Quant['D'][$K]['Desistencias Desliga']++;
							//              $Ligacoes['Desistencias Desliga'][] = array($Res[$x]['diahorario'],$Res[$x]['numero'],$TempodeEspera);
							//              $LDesD=1;
							//              $Quant['DH'][$K][$H]['Desistencias Desliga']++;
							//              $Quant['DH'][$K][$H]['Chamadas Recebidas']++; ////0
							$Quant['DH'][$K][$H]['Chamadas Recebidas']++; ////0

						}
						//}
						break;
				}
				$Insta = trim($Res[$x]['diahorario']);
				$Ligac = trim($Res[$x]['ligacao']);
				$Oque = trim($Res[$x]['oque']);
			}
			//Quando tirou o relatorio estavam conversando
			if ($Oque == "Em conversa&ccedil;&atilde;o") {
				$Tempo['Conversacao'] += trim($Res[$i]['diahorario']) - $Insta;
				//if (trim($Res[$x]['diahorario']) > $Insta) {
				$Tempo['H'][$H]['Conversacao'] += trim($Res[$i]['diahorario']) - $Insta;
				$Tempo['HM'][$H][$M]['Conversacao'] += trim($Res[$i]['diahorario']) - $Insta;
				$Tempo['D'][$K]['Conversacao'] += trim($Res[$i]['diahorario']) - $Insta;
				//}
			}
			//Quando tirou o relatorio estavam chamando
			if ($Oque == "Chamando") {
				if (trim($Res[$x]['diahorario']) > $Hora_final) {
					if ((trim($Res[$x]['diahorario']) - $Hora_final) > $MinimoEspera) {
						$Tempo['Espera'] += trim($Res[$x]['diahorario']) - $Hora_final;
						$TEspera += trim($Res[$x]['diahorario']) - $Hora_final;
						$Quant['Espera']--;
					}
				}
				if (trim($Res[$x]['diahorario']) > $Insta) {
					if ((trim($Res[$x]['diahorario']) - $Insta) > $MinimoEspera) {
						$Tempo['H'][$H]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
						$Tempo['HM'][$H][$M]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
						$Tempo['D'][$K]['Espera'] += trim($Res[$x]['diahorario']) - $Insta;
					}
				}
			}
			//Compatibilidade com a versao anterior do relatorio
			if ($Quant['Desistencias FilA'] > 0) {
				$Quant['D'][$K]['Desistencias Fila'] = $Quant['D'][$K]['Desistencias FilA'];
				$Quant['Desistencias Fila'] = $Quant['Desistencias FilA'];
				$Ligacoes['Desistencias Fila'] = $Ligacoes['Desistencias FilA'];
				foreach ($Tempo['H'] as $Hora => $Valor) {
					$Quant['H'][$Hora]['Desistencias Fila'] = $Quant['H'][$Hora]['Desistencias FilA'];
				}
			}
			//Tempo médio de espera para atendimento
			($Quant['Espera'] == 0) ? $Tempo['Media Espera'] = 0 : $Tempo['Media Espera'] = ($Tempo['Espera'] / $Quant['Espera']);
			$Tempo['D'][$K]['Media Espera'] = $Tempo['Media Espera'];
			foreach ($Tempo['H'] as $Hora => $Valor) {
				($Quant['H'][$Hora]['Espera'] == 0) ? $Tempo['H'][$Hora]['Media Espera'] = 0 : $Tempo['H'][$Hora]['Media Espera'] = ($Tempo['H'][$Hora]['Espera'] / $Quant['H'][$Hora]['Espera']);
			}
			//$Quant['Espera Maxima'] = $EsperaMax;

			if ($Ligas) {
				$Saida = $Ligacoes;
			} else {
				$Saida = array($NomeFila, $Tempo, $Quant);
			}

		}
		//$SaidaT = $Quant['HM'][8][0]['Espera Maxima'];
		//return $SaidaT;
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao chamadas_nao_atendidas
	//
	// Estados no relatorio
	//   Login - Logout => Agente login ou logout
	//   Desligado      => Ligacao desligada
	//   Em Pausa       => Agente em pausa
	//   Livre          => Agente livre
	//   --Entrada        => Nova ligacao
	//   Em conversa&ccedil;&atilde;o => Agente em conversacao
	//   Chamando       => Agente chamando ou sendo chamado
	//   Monitorando PA => Agente monitorando PA
	//
	// Tipos de ligacao
	//   (em branco)    => Sem tipo (login, logout, livre, em pausa, entrada)
	//   --Externa        => Fazendo ligacao externa
	//   Transfer&ecirc;ncia... => Algum tipo de transferencia
	//   Consulta       => Fazendo ou recebendo consulta
	//   DDR            => Recebendo ligacao externa
	//   FILA           => Chamada na fila
	//   --Externo...     => Ligacao externa
	//   Fazendo chamada externa = > Ligando para fora
	//---------------------------------------------------
	function chamadas_nao_atendidas($Fila, $Inicio, $Fim, $Dehoje = "") {
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Said1 = '<br><br><spam style="font-size:12pt;">';
		$Fila = trim($Fila);
		$Pes = "SELECT pseudonimo,tempomaxespeatend,timeout FROM " . $this->TabelaF . " WHERE pseudonimo = '" . $Fila . "'";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		$NaoAtenfila = $Res[0]['timeout'];
		$DesisteAPartir = 4;
		$NomeFila = $Fila;
		$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, id, agente, fila, numero, oque, ligacao  FROM " . $Tabela . " WHERE diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND fila LIKE '%" . $Fila . "%' and agente='0000' ORDER BY ligacao, diahora";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		if (!is_array($Res)) {
			$Saida = false;
		} else {
			list($Dia_inicial, $Horario_inicial) = explode(' ', $Inicio);
			list($Dia_final, $Horario_final) = explode(' ', $Fim);
			//Determinar a hora final
			list($DiaA_final, $DiaM_final, $DiaD_final) = explode('-', $Dia_final);
			list($HorH_final, $HorM_final) = explode(':', $Horario_final);
			$Hora_final = mktime($HorH_final, $HorM_final, 59, $DiaM_final, $DiaD_final, $DiaA_final);
			$K = $DiaD_final;
			if ($Hora_final > time()) {
				$Hora_final = time();
			}

			//Lista ligacoes
			$Ligacoes['Desistencias'] = array();
			$Ligacoes['Desistencias Fila'] = array();
			$Ligacoes['Desistencias Cx'] = array();
			$Ligacoes['Desistencias Msg'] = array();
			$Ligacoes['Desistencias Desliga'] = array();
			//Primeira acao
			$Insta = trim($Res[0]['diahorario']);
			$Oque = "";
			$Ligac = "";
			$Numer = "";
			//Comeca a ler a linha do tempo
			for ($x = 0; $x < count($Res); $x++) {
				if (($Oque == trim($Res[$x]['oque'])) && ($Ligac == trim($Res[$x]['ligacao']))) {
					continue;
				}

				$Said1 .= trim($Res[$x]['diahorario']) . " | " . trim($Res[$x]['fila']) . " | " . trim($Res[$x]['ligacao']) . " | " . trim($Res[$x]['numero']) . " | " . trim($Res[$x]['oque']) . "<br>";
				if ($Ligac != trim($Res[$x]['ligacao'])) {
					if ($LDesF == 1) {
						$Ligacoes['Desistencias Fila'][] = array($Aux_Insta, $Aux_Numer);
					}

					$LCham = 0;
					$LConv = 0;
					$LDesF = 0;
					$LDesC = 0;
					$LDesM = 0;
					$LDesD = 0;
				}
				switch (trim($Res[$x]['oque'])) {
					case "Chamando":
						if ($LCham == 0) {
							$LCham = 1;
						}

						if ($LDesF > 0) {
							$LDesF++;
						}

						break;
					case "Em conversa&ccedil;&atilde;o":
						if ($LConv == 0) {
							$LConv++;
						}

						if ($LDesF > 0) {
							$LDesF++;
						}

						break;
					case "Desligado":
						if (($Oque == "Chamando") && ($LCham == 1)) {
							$LCham++;
							$Ligacoes['Desistencias'][] = array($Res[$x]['diahorario'], $Res[$x]['numero']);
						}
						if ($LDesF > 0) {
							$LDesF++;
						}

						break;
					case "Desistencia-FilA":
						$LDesF++;
						$Aux_Insta = $Res[$x]['diahorario'];
						$Aux_Numer = $Res[$x]['numero'];
						break;
					case "Desistencia-Caixa_Postal":
						if ($LDesC == 0) {
							if (($Oque == "Chamando") && ($LCham == 1)) {
								$LCham++;
							}

							$Ligacoes['Desistencias Cx'][] = array($Res[$x]['diahorario'], $Res[$x]['numero']);
							$LDesC = 1;
						}
						if ($LDesF > 0) {
							$LDesF++;
						}

						break;
					case "Desistencia-Msg_Atendimento":
						if ($LDesM == 0) {
							if (($Oque == "Chamando") && ($LCham == 1)) {
								$LCham++;
							}

							$Ligacoes['Desistencias Msg'][] = array($Res[$x]['diahorario'], $Res[$x]['numero']);
							$LDesM = 1;
						}
						if ($LDesF > 0) {
							$LDesF++;
						}

						break;
					case "Desistencia-Desligamento":
						if ($LDesD == 0) {
							if (($Oque == "Chamando") && ($LCham == 1)) {
								$LCham++;
							}

							$Ligacoes['Desistencias Desliga'][] = array($Res[$x]['diahorario'], $Res[$x]['numero']);
							$LDesD = 1;
						}
						if ($LDesF > 0) {
							$LDesF++;
						}

						break;
				}
				$Ligac = trim($Res[$x]['ligacao']);
				$Oque = trim($Res[$x]['oque']);
			}
			$Saida = $Ligacoes;
		}
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao chamadas_atendidas
	//
	// Estados no relatorio
	//   Login - Logout => Agente login ou logout
	//   Desligado      => Ligacao desligada
	//   Em Pausa       => Agente em pausa
	//   Livre          => Agente livre
	//   --Entrada        => Nova ligacao
	//   Em conversa&ccedil;&atilde;o => Agente em conversacao
	//   Chamando       => Agente chamando ou sendo chamado
	//   Monitorando PA => Agente monitorando PA
	//
	// Tipos de ligacao
	//   (em branco)    => Sem tipo (login, logout, livre, em pausa, entrada)
	//   --Externa        => Fazendo ligacao externa
	//   Transfer&ecirc;ncia... => Algum tipo de transferencia
	//   Consulta       => Fazendo ou recebendo consulta
	//   DDR            => Recebendo ligacao externa
	//   FILA           => Chamada na fila
	//   --Externo...     => Ligacao externa
	//   Fazendo chamada externa = > Ligando para fora
	//---------------------------------------------------
	function chamadas_atendidas($Agente, $Inicio, $Fim, $Dehoje = "", $tipoPes = 'monit') {
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Said1 = '<br><br><spam style="font-size:12pt;">';
		$Agente = trim($Agente);
		$NomeFila = $Agente;
		$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, id, agente, fila, numero, oque, ligacao  FROM " . $Tabela . " WHERE diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND agente LIKE '%" . $Agente . "%' ORDER BY diahora";
		if ($tipoPes == 'monit') {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

		if (!is_array($Res)) {
			$Saida = false;
		} else {
			list($Dia_inicial, $Horario_inicial) = explode(' ', $Inicio);
			list($Dia_final, $Horario_final) = explode(' ', $Fim);
			//Determinar a hora final
			list($DiaA_final, $DiaM_final, $DiaD_final) = explode('-', $Dia_final);
			list($HorH_final, $HorM_final) = explode(':', $Horario_final);
			$Hora_final = mktime($HorH_final, $HorM_final, 59, $DiaM_final, $DiaD_final, $DiaA_final);
			$K = $DiaD_final;
			if ($Hora_final > time()) {
				$Hora_final = time();
			}

			//Lista ligacoes
			$Ligacoes['Fazendo chamada externa'] = array();
			$Ligacoes['DDR'] = array();
			$Ligacoes['Transfer-DDR-Atendidas-Realizadas'] = array();
			$Ligacoes['Transfer-DDR-Atendidas-Atendidas'] = array();
			$Ligacoes['Transfer-FILA-Atendidas-Realizadas'] = array();
			$Ligacoes['Transfer-FILA-Atendidas-Atendidas'] = array();
			$Ligacoes['Consulta-Realizadas'] = array();
			$Ligacoes['Consulta-Atendidas'] = array();
			$Ligacoes['Fila'] = array();
			//Primeira acao
			$Insta = trim($Res[0]['diahorario']);
			$Oque = "";
			$Ligac = "";
			$Fila = trim($Res[0]['fila']);
			$Numer = trim($Res[0]['numero']);
			$Agent = trim($Res[0]['agente']);
			$Funca = trim($Res[0]['funcai']);
			//Comeca a ler a linha do tempo
			for ($x = 0; $x < count($Res); $x++) {
				if (($Oque == trim($Res[$x]['oque'])) && ($Ligac == trim($Res[$x]['ligacao']))) {
					continue;
				}

				$Said1 .= trim($Res[$x]['diahorario']) . " | " . trim($Res[$x]['fila']) . " | " . trim($Res[$x]['ligacao']) . " | " . trim($Res[$x]['numero']) . " | " . trim($Res[$x]['oque']) . " | " . $Vetor . "<br>";
				$Fila = trim($Res[$x]['fila']);
				switch (trim($Res[$x]['oque'])) {
					case "Chamando":
						if ($Conv == 1) {
							$Atend = trim($Res[$x]['diahorario']) - $LigaAux[0];
							if ($Atend > 0) {
								$Aux = array($LigaAux[0], $LigaAux[1], $Atend);
								$Ligacoes[$LigaAux[2]][] = $Aux;
								$Ligacoes[$LigaAux[3]][] = $Aux;
								unset($LigaAux);unset($Aux);
							}
							$Conv = 0;
						}
						$Vetor = "";
						if ($Fila == "Fazendo chamada externa") {
							$Vetor = "Efetuada";
							$Conv = 0;
						} elseif ($Fila == "DDR") {
							$Vetor = "Atendida";
							$Conv = 0;
						} elseif ($Fila == "Transfer&ecirc;ncia-DDR") {
							($Numer == $Agente) ? $Vetor = "Efetuada" : $Vetor = "Atendida";
							$Conv = 0;
						}
//            elseif ($Fila == "Transfer&ecirc;ncia-Fazendo chamada externa") {
						//              $Vetor = "";
						//              if ($Conv==1) {
						//              }
						//            }
						elseif (substr($Fila, 0, 20) == "Transfer&ecirc;ncia-") {
							($Numer == $Agente) ? $Vetor = "Efetuada" : $Vetor = "Atendida";
							$Conv = 0;
						} elseif ($Fila == "Consulta") {
							if ($Agente != $Numer) {
								$Consult = "SELECT numero FROM " . $Tabela . " WHERE ligacao = '" . $Ligac . "' ORDER BY diahora LIMIT 1";
								if ($tipoPes == 'monit') {
									$Respost = $this->Bd->executa_query_com_saida($Consult);
								}

								if ($tipoPes == 'relat') {
									$Respost = $this->BdRelat->executa_query_com_saida($Consult);
								}

								($Respost[0]['numero'] == $Agente) ? $Vetor = "Efetuada" : $Vetor = "Atendida";
							}
							$Conv = 0;
						} else {
							$Vetor = "Atendida";
							$Conv = 0;
						}
						break;
					case "Em conversa&ccedil;&atilde;o":
						if ($Fila == "Fazendo chamada externa") {
							unset($LigaAux);
							$LigaAux = array($Res[$x]['diahorario'], $Res[$x]['numero'], $Fila, $Vetor);
							$Conv = 1;
						} elseif ($Fila == "DDR") {
							unset($LigaAux);
							$LigaAux = array($Res[$x]['diahorario'], $Res[$x]['numero'], $Fila, $Vetor);
							$Conv = 1;
						} elseif ($Fila == "Transfer&ecirc;ncia-DDR") {
							unset($LigaAux);
							$LigaAux = array($Res[$x]['diahorario'], $Res[$x]['numero'], $Fila, $Vetor);
							$Conv = 1;
						} elseif (substr($Fila, 0, 20) == "Transfer&ecirc;ncia-") {
							unset($LigaAux);
							$LigaAux = array($Res[$x]['diahorario'], $Res[$x]['numero'], $Fila, $Vetor);
							$Conv = 1;
						} elseif ($Fila == "Consulta") {
							unset($LigaAux);
							$LigaAux = array($Res[$x]['diahorario'], $Res[$x]['numero'], $Fila, $Vetor);
							$Conv = 1;
						} else {
							if ($Vetor == "") {
								$Vetor = "Atendida";
							}

							unset($LigaAux);
							$LigaAux = array($Res[$x]['diahorario'], $Res[$x]['numero'], 'Fila', $Vetor);
							$Conv = 1;
						}
						$Vetor = "";
						break;
					case "Livre":
						if ($Conv == 1) {
							$Atend = trim($Res[$x]['diahorario']) - $LigaAux[0];
							if ($Atend > 0) {
								$Aux = array($LigaAux[0], $LigaAux[1], $Atend);
								$Ligacoes[$LigaAux[2]][] = $Aux;
								$Ligacoes[$LigaAux[3]][] = $Aux;
								unset($LigaAux);unset($Aux);
							}
							$Conv = 0;
						}
						$Vetor = "";
						break;
				}
				$Ligac = trim($Res[$x]['ligacao']);
				$Insta = trim($Res[$x]['diahorario']);
				$Oque = trim($Res[$x]['oque']);
				$Fila = trim($Res[$x]['fila']);
				$Numer = trim($Res[$x]['numero']);
				$Agent = trim($Res[$x]['agente']);
			}
			$Saida = $Ligacoes;
		}
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao acha_funcai
	//---------------------------------------------------
	function acha_funcai($Lista, $Oque) {
		$x = 0;
		$f = -1;
		$Oque = substr($Oque, 0, 4);
		if (is_array($Lista)) {
			while (($x < count($Lista)) and ($f == -1)) {
				if ($Lista[$x]['login'] == $Oque) {
					$f = $x;
				}

				$x++;
			}
			if ($f == -1) {
				$Saida = "";
			} else {
				$Saida = $Lista[$f]['funcai'];
			}

		} else {
			$Saida = "";
		}

		return $Saida;
	}

	//---------------------------------------------------
	// Funcao lista_pausas
	//---------------------------------------------------
	function lista_pausas($tipoPes = 'monit') {
		$Pes = "SELECT * FROM " . $this->TabelaP . " ORDER BY nome";
		if ($tipoPes == 'monit') {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

		return $Res;
	}

	//---------------------------------------------------
	// Funcao lista_agentes
	//---------------------------------------------------
	function lista_agentes() {
		$Pes = "SELECT nome, login FROM " . $this->TabelaA . " ORDER BY login";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		return $Res;
	}

	//---------------------------------------------------
	// Funcao lista_agentes_relatorio
	//---------------------------------------------------
	function lista_agentes_relatorio($Inicio, $Fim, $Dehoje = "") {
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Pes = "SELECT agente FROM " . $Tabela . " WHERE diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND agente != '0000' AND agente > '!' AND agente NOT LIKE 'Agent%' GROUP BY agente ORDER BY agente";
		if ($Dehoje == "") {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

		if ($Dehoje == "hoje") {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		$Saida = "";
		for ($x = 0; $x < count($Res); $x++) {
			$Res[$x]['agente'] = trim($Res[$x]['agente']);
			$Pes1 = "SELECT * FROM " . $this->TabelaA . " WHERE login='" . substr($Res[$x]['agente'], 0, 4) . "' LIMIT 1";
			$Res1 = $this->Bd->executa_query_com_saida($Pes1);
			$Saida .= '<option value="' . $Res[$x]['agente'] . '">' . $Res[$x]['agente'] . ' (' . $Res1[0]['funcai'] . ')</option>' . "\n";
		}
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao lista_todos_agentes_relatorio
	//---------------------------------------------------
	function lista_todos_agentes_relatorio() {
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Pes = "SELECT login, pseudonimo FROM vm50_agentes ORDER BY login";
		if ($Dehoje == "") {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

		if ($Dehoje == "hoje") {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		$Saida = "";
		for ($x = 0; $x < count($Res); $x++) {
			$Res[$x]['agente'] = trim($Res[$x]['login'] . "-" . $Res[$x]['pseudonimo']);
			$Pes1 = "SELECT * FROM " . $this->TabelaA . " WHERE login='" . substr($Res[$x]['agente'], 0, 4) . "' LIMIT 1";
			$Res1 = $this->Bd->executa_query_com_saida($Pes1);
			$Saida .= '<option value="' . $Res[$x]['agente'] . '">' . $Res[$x]['agente'] . ' (' . $Res1[0]['funcai'] . ')</option>' . "\n";
		}
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao lista_grupos_agentes_relatorio
	//---------------------------------------------------
	function lista_grupos_agentes_relatorio($Inicio, $Fim, $Dehoje = "") {
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Pes = "SELECT agente FROM " . $Tabela . " WHERE diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND agente != '0000' GROUP BY agente ORDER BY agente";
		if ($Dehoje == "") {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		} else {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		$Agentes = array();
		$Grupos = array();
		$k = 0;
		for ($x = 0; $x < count($Res); $x++) {
			$Res[$x]['agente'] = trim($Res[$x]['agente']);
			$Pes1 = "SELECT * FROM " . $this->TabelaA . " WHERE login='" . substr($Res[$x]['agente'], 0, 4) . "' LIMIT 1";
			if ($Dehoje == "") {
				$Res1 = $this->BdRelat->executa_query_com_saida($Pes1);
			} else {
				$Res1 = $this->Bd->executa_query_com_saida($Pes1);
			}

			$Gr = $Res1[0]['grupo'];
			$Grupos[$Gr] = $Gr;
			$Agentes[$Gr][] = $Res[$x]['agente'];
			$k++;
		}
		$Saida1 = "";
		$Saida2 = "";
		if (count($Grupos) > 0) {
			asort($Grupos);
			$k = 0;
			foreach ($Grupos as $key => $value) {
				if (trim($value) > "!") {
					$Valor = 'Grupo-' . $value;
					$Saida1 .= '<option value="Grupo' . sprintf('%02d', $k) . '">' . $Valor . '</option>' . "\n";
					$Membros = "";
					for ($y = 0; $y < count($Agentes[$key]); $y++) {
						$Membros .= $Agentes[$key][$y] . "#";
					}

					$Saida2 .= '<input type="hidden" id="Grupo' . sprintf('%02d', $k) . '" value="' . $Membros . '" />' . "\n";
					$k++;
				}
			}
		}
		$Saida = array($Saida1, $Saida2);
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao lista_grupos_todos_agentes_relatorio
	//---------------------------------------------------
	function lista_grupos_todos_agentes_relatorio() {
		$Pes = "SELECT login, pseudonimo FROM vm50_agentes ORDER BY login";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		$Agentes = array();
		$Grupos = array();
		$k = 0;
		for ($x = 0; $x < count($Res); $x++) {
			$Res[$x]['login'] = trim($Res[$x]['login']);
			$Pes1 = "SELECT * FROM " . $this->TabelaA . " WHERE login='" . $Res[$x]['login'] . "' LIMIT 1";
			$Res1 = $this->Bd->executa_query_com_saida($Pes1);
			$Gr = $Res1[0]['grupo'];
			$Grupos[$Gr] = $Gr;
			$Agentes[$Gr][] = $Res[$x]['login'] . "-" . $Res[$x]['pseudonimo'];
			$k++;
		}
		$Saida1 = "";
		$Saida2 = "";
		if (count($Grupos) > 0) {
			asort($Grupos);
			$k = 0;
			foreach ($Grupos as $key => $value) {
				if (trim($value) > "!") {
					$Valor = 'Grupo-' . $value;
					$Saida1 .= '<option value="Grupo' . sprintf('%02d', $k) . '">' . $Valor . '</option>' . "\n";
					$Membros = "";
					for ($y = 0; $y < count($Agentes[$key]); $y++) {
						$Membros .= $Agentes[$key][$y] . "#";
					}

					$Saida2 .= '<input type="hidden" id="Grupo' . sprintf('%02d', $k) . '" value="' . $Membros . '" />' . "\n";
					$k++;
				}
			}
		}
		$Saida = array($Saida1, $Saida2);
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao lista_agentes_do_dia
	//---------------------------------------------------
	function lista_agentes_do_dia($Inicio, $Fim, $Dehoje = "") {
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Pes = "SELECT agente FROM " . $Tabela . " WHERE diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND agente != '0000' GROUP BY agente ORDER BY agente";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		if ($Res) {
			$Saida = array();
			//for ($x=0; $x<count($Res); $x++) $Saida[$x] = $Res[$x]['agente']."-".$Res[$x]['pseudonimo'];
			for ($x = 0; $x < count($Res); $x++) {
				$Saida[$x] = $Res[$x]['agente'];
			}

		} else {
			$Saida = false;
		}

		return $Saida;
	}

	//---------------------------------------------------
	// Funcao lista_grupos_relatorio
	//---------------------------------------------------
	function lista_grupos_relatorio($Inicio, $Fim, $Dehoje = "") {
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Pes = "SELECT " . $this->TabelaA . ".grupo FROM " . $Tabela . " INNER JOIN " . $this->TabelaA . " ON " . $this->TabelaA . ".login = SUBSTR(" . $Tabela . ".agente,1,4) WHERE diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' GROUP BY " . $this->TabelaA . ".grupo ORDER BY " . $this->TabelaA . ".grupo";
		$Res = $this->Bd->executa_query_com_saida($Pes);

		$Pes2 = "SELECT grupos FROM " . $Tabela . " WHERE diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' GROUP BY grupos ORDER BY grupos";
		if ($Dehoje == "") {
			$Res2 = $this->BdRelat->executa_query_com_saida($Pes2);
		}

		if ($Dehoje == "hoje") {
			$Res2 = $this->Bd->executa_query_com_saida($Pes2);
		}

		$Grups = array();
		for ($k = 0; $k < count($Res2); $k++) {
			if ($Res2[$k]['grupos'] > "!") {
				$Pos = strstr($Res2[$k]['grupos'], "\|\|");
				if ($Pos === false) {
					$Aux = explode("\|\|", $Res2[$k]['grupos']);
				} else {
					$Aux[] = $Res2[$k]['grupos'];
				}
				for ($y = 0; $y < count($Aux); $y++) {
					if (($Aux[$y] > "!") && (!(in_array($Aux[$y], $Grups)))) {
						$Grups[] = $Aux[$y];
					}
				}
			}
		}
		for ($k = 0; $k < count($Res); $k++) {
			if (($Res[$k]['grupo'] > "!") && (!(in_array($Res[$k]['grupo'], $Grups)))) {
				$Grups[] = $Res[$k]['grupo'];
			}
		}
		sort($Grups);

		$Saida = "";
		for ($x = 0; $x < count($Grups); $x++) {
			$Saida .= '<option value="' . $Grups[$x] . '">' . $Grups[$x] . '</option>';
		}
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao lista_filas_relatorio
	//---------------------------------------------------
	function lista_filas_relatorio($Inicio, $Fim, $Dehoje = "") {
		if ($Dehoje == "") {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

//    $Pes   = "SELECT fila FROM ".$this->TabelaR." WHERE diahora >= '".$Inicio."' AND diahora <= '".$Fim."' AND fila!='Fazendo chamada externa' AND fila!='DDR' AND fila!='Transfer&ecirc;ncia-DDR' AND fila!='Consulta' AND fila!='Transfer&ecirc;ncia-Fazendo chamada externa' AND fila>'' AND oque!='Em Pausa' AND agente='0000' GROUP BY fila ORDER BY fila";
		$Pes = "SELECT fila FROM " . $Tabela . " WHERE diahora >= '" . $Inicio . "' AND diahora <= '" . $Fim . "' AND fila!='Fazendo chamada externa' AND fila!='DDR' AND fila!='Transfer&ecirc;ncia-DDR' AND fila!='Consulta' AND fila!='Transfer&ecirc;ncia-Fazendo chamada externa' AND fila>'' AND fila NOT LIKE 'Externo-%' AND oque!='Em Pausa' AND oque!='Livre' GROUP BY fila ORDER BY fila";
		if ($Dehoje == "hoje") {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($Dehoje == "") {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

		$Saida = "";
		for ($x = 0; $x < count($Res); $x++) {
			if (substr($Res[$x]['fila'], 0, 20) == "Transfer&ecirc;ncia-") {
				continue;
			}

			if ($Res[$x]['fila'] != "Externa") {
				$Saida .= '<option value="' . $Res[$x]['fila'] . '">' . $Res[$x]['fila'] . '</option>';
			}
		}
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao lista_congestionamento_fila
	//---------------------------------------------------
	function lista_congestionamento_fila($Fila) {
		$Pes1 = "SELECT nome, login, ramal, situacao FROM " . $this->TabelaA . " WHERE id IN (SELECT " . $this->TabelaG . ".agente FROM " . $this->TabelaG . " INNER JOIN " . $this->TabelaF . " ON " . $this->TabelaF . ".id=" . $this->TabelaG . ".fila WHERE " . $this->TabelaF . ".pseudonimo='" . $Fila . "')";
		//return $Pes1;
		$Res1 = $this->Bd->executa_query_com_saida($Pes1);
		if (!$Res1) {
			$Saida = false;
		}

		$livre = $nLivre = 0;
		for ($i = 0; $i < count($Res1); $i++) {
			if ($Res1[$i]["situacao"] == "Livre") {
				$livre++;
			} else if ($Res1[$i]["situacao"] != "NLogado") {
				$nLivre++;
			}

		}

		$Saida = 0;
		if (count($Res1) == 0) {
			$Saida = 0;
		} else if ($nLivre > $livre) {
			$Saida = 1;
		}

		return $Saida;
	}

	//---------------------------------------------------
	// Funcao lista_padroes_alarme
	//---------------------------------------------------
	function lista_padroes_alarme() {
		$Pes = "SELECT nome, maxsaida, maxddr, maxfila, maxinter, maxlivre, maxesddr FROM " . $this->TabelaO . " ORDER BY nome";
		$ResG = $this->Bd->executa_query_com_saida($Pes);
		$Pes = "SELECT nome, pseudonimo, tempomaxconvatend, tempomaxespeatend FROM " . $this->TabelaF . " ORDER BY pseudonimo";
		$ResF = $this->Bd->executa_query_com_saida($Pes);
		$Pes = "SELECT nome, tempomax FROM " . $this->TabelaP . " ORDER BY nome";
		$ResP = $this->Bd->executa_query_com_saida($Pes);
		$Pes = "SELECT login, pseudonimo, ramal FROM " . $this->TabelaA . " WHERE ramal>'' ORDER BY login";
		$ResA = $this->Bd->executa_query_com_saida($Pes);
		$Res = array($ResG, $ResF, $ResP, $ResA);
		return $Res;
	}

	//---------------------------------------------------
	// Funcao le_agente
	//---------------------------------------------------
	function le_agente($Estado = "", $Fila = "", $Grupo = "", $Ordem = "agente", $user) {
		$Dia = date("d");
		$Mes = date("m");
		$Ano = date("Y");

		$Pes = "SELECT " . $this->TabelaA . ".pseudonimo as nome, " . $this->TabelaA . ".login, " . $this->TabelaA . ".ramal, " . $this->TabelaA . ".falandocom, to_char(" . $this->TabelaA . ".tempo, 'HH24:MI:SS') AS tempo, " . $this->TabelaA . ".situacao, " . $this->TabelaA . ".fila, " . $this->TabelaA . ".tipopausa, to_char(" . $this->TabelaA . ".ult_estad, 'HH24:MI:SS') AS ult_estad, " . $this->TabelaA . ".grupo, " . $this->TabelaA . ".grupos FROM " . $this->TabelaA;

		if ($Fila != "") {
			$Pes .= " INNER JOIN (SELECT " . $this->TabelaG . ".agente AS fid FROM " . $this->TabelaG . " INNER JOIN " . $this->TabelaF . " ON " . $this->TabelaF . ".id=" . $this->TabelaG . ".fila WHERE " . $this->TabelaF . ".pseudonimo='" . $Fila . "') AS fagente ON " . $this->TabelaA . ".id=fagente.fid";
		}

		//Join de tabela do usuario_grupo para listar
		//os grupos cadastrados de cada usuario
		elseif ($Fila == "") {
			$Pes .= " LEFT JOIN " . $this->TabelaO . " on " . $this->TabelaA . ".grupo = " . $this->TabelaO . ".nome";
			$Pes .= " LEFT JOIN " . $this->TabelUG . " on " . $this->TabelaO . ".id = " . $this->TabelUG . ".grupo";
		}

		if (($Estado != "") || (($Grupo != "") && ($Grupo != "."))) {
			$Pes .= " WHERE ";
		}

		//Condicao para trazer os grupos cadastrado do respectivo usuario
		/*if (($Estado!="") && ($Fila=="" && $user!='')) $Pes .= " ".$this->TabelUG.".usuario = ".$user." AND ";

	    if ($Estado!="") $Pes .= $this->TabelaA.".situacao!='NLogado' AND ".$this->TabelaA.".ramal !=''";
	    if (($Estado!="") && (($Grupo!="") && ($Grupo!="."))) $Pes .= " AND ";
*/
		if (($Estado != "") && ($Fila == "" && $user != '')) {
			$Pes .= " " . $this->TabelUG . ".usuario = " . $user;
		}

		if (($Estado != "" && $Estado != "Tudo") || ($Grupo != "" && $Grupo != ".")) {
			$Pes .= " AND ";
		}

		if ($Estado != "" && $Estado != "Tudo") {
			$Pes .= $this->TabelaA . ".situacao!='NLogado' AND " . $this->TabelaA . ".ramal !=''";
		}

		if ($Estado != "" && $Estado != "Tudo" && $Grupo != "" && $Grupo != ".") {
			$Pes .= " AND ";
		}

		if (($Grupo != "") && ($Grupo != ".")) {
			$Pes .= $this->TabelaA . ".grupo='" . $Grupo . "'";
		}

		switch ($Ordem) {
			case "agente":
				$Pes .= " ORDER BY " . $this->TabelaA . ".grupo, " . $this->TabelaA . ".ramal";
				break;
			case "codigo":
				$Pes .= " ORDER BY " . $this->TabelaA . ".grupo, " . $this->TabelaA . ".login";
				break;
			case "pa":
				$Pes .= " ORDER BY " . $this->TabelaA . ".grupo, " . $this->TabelaA . ".ramal";
				break;
			case "estado":
				$Pes .= " ORDER BY " . $this->TabelaA . ".situacao, " . $this->TabelaA . ".grupo";
				break;
			case "servico":
				$Pes .= " ORDER BY " . $this->TabelaA . ".fila, " . $this->TabelaA . ".grupo";
				break;
			case "origemDestino":
				$Pes .= " ORDER BY " . $this->TabelaA . ".falandocom, " . $this->TabelaA . ".grupo";
				break;
			case "tempoDecorrido":
				$Pes .= " ORDER BY " . $this->TabelaA . ".ult_estad desc, " . $this->TabelaA . ".grupo";
				break;
			default:
				$Pes .= " ORDER BY " . $this->TabelaA . ".grupo, " . $this->TabelaA . ".ramal";
				break;
		}
		$Res = $this->Bd->executa_query_com_saida($Pes);
		if ($Estado == "Tudo") {
			$Aux_Logados = $Aux_Deslogados = array();
			$k = $l = 0;
			$flag = false;
			//$pes = "SELECT agente FROM vm50_relatorios_cc_hoje WHERE diahora >= '" . date("Y-m-d") . " 00:00' AND oque LIKE 'Login' GROUP BY agente";
            //Fix to show agentes com login forçado
            $pes = "SELECT agente FROM vm50_relatorios_cc_hoje WHERE diahora >= '" . date("Y-m-d") . " 00:00' AND oque LIKE 'Login' OR oque LIKE 'Livre' GROUP BY agente";
			//$pes = "SELECT agente FROM vm50_relatorios_cc_hoje WHERE diahora >= '2014-04-24 00:00' AND oque LIKE 'Login' GROUP BY agente";
			$aux_res = $this->Bd->executa_query_com_saida($pes);
			//return $Res;
			for ($i = 0; $i < count($Res); $i++) {
				$flag = false;
				for ($j = 0; $j < count($aux_res); $j++) {
					if ($Res[$i]['login'] . "-" . $Res[$i]['nome'] == $aux_res[$j]['agente']) {
						$flag = true;
						continue;
					}
				}
				if ($flag == true) {
					$Aux_Logados[$k] = $Res[$i];
					$k++;
				}
			}
			$Res = $Aux_Logados;
		}
		if (!$Res) {
			$Saida = false;
		} else {
			$Agentes = $Res;
			$Saida = $Agentes;
		}
		//return $Pes;
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao le_chamadas_entrantes
	//---------------------------------------------------
	function le_chamadas_entrantes($Fila = "", $Grupo = "") {
		$Dia = date("d");
		$Mes = date("m");
		$Ano = date("Y");
		$Pes = "SELECT " . $this->TabelaL . ".obs, " . $this->TabelaL . ".numero_dest, " . $this->TabelaL . ".numero_orig, " . $this->TabelaL . ".pa, to_char(" . $this->TabelaL . ".diahora, 'HH24:MI:SS') AS hora, " . $this->TabelaL . ".id_orig as ligacao FROM " . $this->TabelaL;
		$Pes .= " WHERE " . $this->TabelaL . ".estado='Chamando' AND " . $this->TabelaL . ".numero_orig!='' AND " . $this->TabelaL . ".numero_dest!='' AND " . $this->TabelaL . ".tipo = 'I'";
		$Pes .= " AND ((pa IN (SELECT ramal FROM " . $this->TabelaA . " where situacao!='NLogado')) ";
		$Pes .= " OR (numero_dest IN (SELECT pseudonimo FROM " . $this->TabelaF . "))) ";
		$Filas = "";
		if ($Fila != "") {
			$Filas .= " AND (";
			$Filas .= " " . $this->TabelaL . ".numero_dest='" . $Fila . "' ";
			$Filas .= ") ";
		}

		if (($Grupo != "") && ($Grupo != ".")) {
			$Pes1 = "SELECT " . $this->TabelaF . ".pseudonimo as fila FROM " . $this->TabelOF . " INNER JOIN " . $this->TabelaF . " ON " . $this->TabelOF . ".fila=" . $this->TabelaF . ".id INNER JOIN " . $this->TabelaO . " ON " . $this->TabelOF . ".grupo=" . $this->TabelaO . ".id WHERE " . $this->TabelaO . ".nome='" . $Grupo . "' ORDER BY " . $this->TabelaF . ".pseudonimo";
			$Res1 = $this->Bd->executa_query_com_saida($Pes1);
			if (count($Res1) > 0) {
				if ($Fila == '') {
					$Filas .= " AND (";
				} else {
					$Filas .= " OR (";
				}

				for ($x = 0; $x < count($Res1); $x++) {
					if ($x > 0) {
						$Filas .= " OR ";
					}

					$Filas .= " " . $this->TabelaL . ".numero_dest='" . $Res1[$x]['fila'] . "' ";
				}
				$Filas .= ") ";
			}
		}
		if ($Fila != '.' || $Fila != '' || $Grupo != '.' || $Grupo != '') {
			$Pes .= $Filas;
		}

		$Pes .= " ORDER BY hora";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		for ($x = 0; $x < count($Res); $x++) {
			if ($Res[$x]['pa'] > "1") {
				$PesA = "SELECT pseudonimo FROM " . $this->TabelaA . " WHERE ramal='" . $Res[$x]['pa'] . "' LIMIT 1";
				$ResA = $this->Bd->executa_query_com_saida($PesA);
				if ($ResA) {
					$Res[$x]['pa'] .= '-' . $ResA[0]['pseudonimo'];
				}

			}
		}
		$Saida = $Res;
		return $Saida;
	}

	function quantidade_chamadas_grupo($Grupo = "") {
		$Saida = 0;
		$Pes1 = "SELECT " . $this->TabelaF . ".pseudonimo as fila FROM " . $this->TabelOF . " INNER JOIN " . $this->TabelaF . " ON " . $this->TabelOF . ".fila=" . $this->TabelaF . ".id INNER JOIN " . $this->TabelaO . " ON " . $this->TabelOF . ".grupo=" . $this->TabelaO . ".id WHERE " . $this->TabelaO . ".nome='" . $Grupo . "' ORDER BY " . $this->TabelaF . ".pseudonimo";
		$Res1 = $this->Bd->executa_query_com_saida($Pes1);
		if (count($Res1) > 0) {
			for ($i = 0; $i < count($Res1); $i++) {
				$Pes2 = "SELECT count(numero_orig) AS qtd FROM " . $this->TabelaL . " WHERE numero_dest = '" . $Res1[$i]['fila'] . "' AND numero_orig != '' AND estado = 'Chamando' AND pa IN (SELECT ramal FROM " . $this->TabelaA . " WHERE situacao != 'NLogado')";
				$Res2 = $this->Bd->executa_query_com_saida($Pes2);
				$Saida += $Res2[0]['qtd'];
			}
		}
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao conversando_com
	//---------------------------------------------------
	function conversando_com($Ramal) {
		$Dia = date("d");
		$Mes = date("m");
		$Ano = date("Y");
		$Pes = "SELECT " . $this->TabelaL . ".obs, " . $this->TabelaL . ".numero_dest, " . $this->TabelaL . ".numero_orig, " . $this->TabelaL . ".pa, to_char(" . $this->TabelaL . ".diahora, 'HH24:MI:SS') AS hora, " . $this->TabelaL . ".id_orig as ligacao, " . $this->TabelaL . ".tipo FROM " . $this->TabelaL;
		$Pes .= " WHERE " . $this->TabelaL . ".estado='Em conversa&ccedil;&atilde;o' AND " . $this->TabelaL . ".numero_orig!='' AND " . $this->TabelaL . ".numero_dest!=''";
		$Pes .= " AND (" . $this->TabelaL . ".numero_dest='" . $Ramal . "' OR " . $this->TabelaL . ".numero_orig='" . $Ramal . "')";
		$Pes .= " ORDER BY hora";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		$Saida = $Res;
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao le_membros_nao_logados
	//---------------------------------------------------
	function le_membros_nao_logados($Fila) {
		$Dia = date("d");
		$Mes = date("m");
		$Ano = date("Y");
		$Pes = "SELECT membername AS login FROM vm50_ast_queue_member WHERE queue_name='" . $Fila . "'";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		if (!$Res) {
			$Saida = false;
		} else {
			for ($x = 0; $x < count($Res); $x++) {
				$Membros[$x] = substr($Res[$x]['login'], 6, 4);
			}

			$Pes = "SELECT nome, login FROM " . $this->TabelaA . " INNER JOIN " . $this->TabelaG . " ON  concat('Agent/'," . $this->TabelaA . ".login)=" . $this->TabelaG . ".membername WHERE " . $this->TabelaG . ".queue_name='" . $Fila . "'";
			$Pes .= " ORDER BY " . $this->TabelaA . ".nome";
			$Res = $this->Bd->executa_query_com_saida($Pes);
			if (!$Res) {
				$Saida = false;
			} else {
				$Agentes = $Res;
				$Saida = array();
				$y = 0;
				for ($x = 0; $x < count($Agentes); $x++) {
					$k = 0;
					while (($Membros[$k] != $Agentes[$x]['login']) && ($k < count($Membros))) {
						$k++;
					}

					if ($k <= count($Agentes)) {
						if ($Agentes[$x]['situacao'] != "Livre") {
							$Saida[$y] = $Agentes[$x];
							$y++;
						}
					}
				}
			}
		}
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao monta_lista
	//---------------------------------------------------
	function monta_lista($Entrada, $Pos) {
		$Flag1 = true;
		$x = $Pos;
		$Saida = array();
		while ($Flag1) {
			$Aux = explode(":", $Entrada[$x]);
			$Aux[0] = trim($Aux[0]);
			$Aux[1] = trim($Aux[1]);
			if ($Aux[0] < "!") {
				$Flag1 = false;
			} else {
				$Saida[$Aux[0]] = $Aux[1];
			}

			$x++;
			if ($x == count($Entrada)) {
				$Flag1 = false;
			}

		}
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao remove_agente
	//---------------------------------------------------
	function remove_agente($Ag, $Fi) {
		$Resultado = $this->Meia->envia_socket("Action: QueueRemove\r\nQueue: " . $Fi . "\r\nInterface: " . $Ag . "\r\n\r\n");
		//Verifica se estah OK
		$Aux = explode(":", $Resultado[0]);
		if (trim($Aux[1]) != "Success") {
			$Saida = false;
		} else {
			$Saida = true;
		}

		foreach ($Resultado as $Chave => $Valor) {
			$Nada .= $Valor . "<br>";
		}
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao adiciona_agente
	//---------------------------------------------------
	function adiciona_agente($Ag, $Fi) {
		$Resultado = $this->Meia->envia_socket("Action: QueueAdd\r\nQueue: " . $Fi . "\r\nInterface: " . $Ag . "\r\nPenalty: 1\r\nPaused: true\r\n\r\n");
		//Verifica se estah OK
		$Aux = explode(":", $Resultado[0]);
		if (trim($Aux[1]) != "Success") {
			$Saida = false;
		} else {
			$Saida = true;
		}

		foreach ($Resultado as $Chave => $Valor) {
			$Nada .= $Valor . "<br>";
		}
		return $Saida;
	}

	//---------------------------------------------------
	// Funcao importa_relatorio_txt
	//---------------------------------------------------
	function importa_relatorio_txt() {
		$Arquivo = '/var/log/asterisk/vm50_relatorios_cc.log';
		if (!file_exists($Arquivo)) {
			return false;
		}

		$Arq = fopen($Arquivo, 'r+');
		while (!feof($arq)) {
//    for ($x=0; $x<40; $x++) {
			$Aux = fgetcsv($Arq, 500, ",", "'");
			if (($Aux[0] == "") && ($Aux[1] == "") && ($Aux[2] == "") && ($Aux[3] == "") && ($Aux[4] == "") && ($Aux[5] == "") && ($Aux[6] == "") && ($Aux[7] == "") && ($Aux[8] == "")) {
				continue;
			}

			$Pes = "SELECT id FROM " . $this->TabelaR . " WHERE diahora='" . $Aux[0] . "' AND agente='" . $Aux[1] . "' AND fila='" . $Aux[2] . "' AND ligacao='" . $Aux[3] . "' AND numero='" . $Aux[4] . "' AND oque='" . $Aux[5] . "' AND info1='" . $Aux[6] . "' AND info2='" . $Aux[7] . "' AND info3='" . $Aux[8] . "'";
			$Res = $this->Bd->executa_query_com_saida($Pes);
			if ((!$Res) || !is_array($Res)) {
				$Pes = "INSERT INTO " . $this->TabelaR . " VALUES ('','" . $Aux[0] . "','" . $Aux[1] . "','" . $Aux[2] . "','" . $Aux[3] . "','" . $Aux[4] . "','" . $Aux[5] . "','" . $Aux[6] . "','" . $Aux[7] . "','" . $Aux[8] . "')";
				$Res = $this->Bd->executa_query_sem_saida($Pes);
//        $Saida .= print_r($Aux,true)."<br>";
			}
		}
		$Saida = ftruncate($Arquivo, 0);
		fclose($Arquivo);
		return $Saida;
	}

	/****************************************************
		  Funcao:        relatorio_grades_filas
		  Descricao:     Esta funcao busca das tabelas
		                 vm50_link_ligacao e
						 vm50_relatorios_cc as ligacoes das
						 filas para poder montar as tabelas
	*/
	function relatorio_grades_filas($NomeFila, $DataInicio, $DataFim, $Array, $Tipo) {
		$Fila = $NomeFila;
		$Pes = "SELECT distinct c.ligacao, c.oque, c.fila,";
		$Pes .= "EXTRACT(EPOCH FROM DATE_TRUNC('second',lk.diahora)) AS horaini,";
		$Pes .= "EXTRACT(EPOCH FROM DATE_TRUNC('second',lk.diahora_ult_est)) AS horafim, ";
		$Pes .= "lk.obs, lk.conversou, c.numero FROM vm50_relatorios_cc c INNER JOIN vm50_link_ligacao lk ";
		$Pes .= "ON c.ligacao = lk.id_orig WHERE c.diahora >= '" . $DataInicio . "%' AND ";
		$Pes .= "c.diahora <= '" . $DataFim . "%' AND lk.obs = '' AND c.oque LIKE 'Desistencia%' ";
		$Pes .= "AND c.fila = '" . $Fila . "'";
		$Res = $this->Bd->executa_query_com_saida($Pes);

		$Tempo = $TempoInicial = $TempoFinal = 0;

		if ($Res) {
			for ($i = 1; $i <= count($Array[$NomeFila . "_" . $Tipo]); $i++) {
				if ($i <= 9) {
					$Quant['pos0' . $i] = 0;
				} else {
					$Quant['pos' . $i] = 0;
				}

			}
			switch ($Tipo) {
				case "desistencias":
					for ($i = 0; $i < count($Res); $i++) {
						$TempoInicial = $Res[$i]['horaini'];
						$TempoFinal = $Res[$i]['horafim'];
						$Tempo = $TempoFinal - $TempoInicial;

						for ($x = 1; $x <= count($Array[$NomeFila . "_" . $Tipo]); $x++) {
							if ($x <= 9) {
								if ($x == 1 && $Tempo <= $Array[$NomeFila . "_" . $Tipo]['pos0' . $x]) {
									$Quant['pos0' . $x]++;
									break;
								} elseif ($Tempo > $Array[$NomeFila . "_" . $Tipo]['pos0' . $x - 1] &&
									$Tempo <= $Array[$NomeFila . "_" . $Tipo]['pos0' . $x]) {
									$Quant['pos0' . $x]++;
									break;
								}
							} else {
								if ($x == 10) {
									if ($Tempo > $Array[$NomeFila . "_" . $Tipo]['pos0' . $x - 1] &&
										$Tempo <= $Array[$NomeFila . "_" . $Tipo]['pos' . $x]) {
										$Quant['pos' . $x]++;
										break;
									}
								} else {
									if ($Tempo > $Array[$NomeFila . "_" . $Tipo]['pos' . $x - 1] &&
										$Tempo <= $Array[$NomeFila . "_" . $Tipo]['pos' . $x]) {
										$Quant['pos' . $x]++;
										break;
									}
								}
							}
						}
					}
					break;
			}
		} else {
			$Quant = false;
		}

		$Saida = array($Quant);
		return $Saida;
	}

	function usuarioGrupo($user) {
		$Pes = "SELECT * FROM vm50_usuarios_grupos ug INNER JOIN ";
		$Pes .= " vm50_grupos g ON ug.grupo = g.id WHERE ";
		$Pes .= " ug.usuario =" . $user;

		$Res = $this->Bd->executa_query_com_saida($Pes);
		return $Res;
	}

	function relatorio_desistencia_fila($Fila, $DataInicial, $DataFinal, $Dehoje = '', $tipoPes = 'monit') {
		//Original
		/*$Chamadas1 = $this->relatorio_filas_geral($Fila, $DataInicial, $DataFinal, "", $Dehoje, $tipoPes);
	        for($i = 0; $i < count($Chamadas1); $i++){
	            $Data = explode(" ", $Chamadas1['Detalhes desistencias'][$i]['Data']);
	            $Numero = $Chamadas1['Detalhes desistencias'][$i]['Numero'];
	            $Ligacoes[$Data[0]][$Numero]['Quantidade']++;
*/

		//Alterado
		$Chamadas1 = $this->relatorio_filas_geral($Fila, $DataInicial, $DataFinal, "", $Dehoje, $tipoPes);

		foreach ($Chamadas1['Detalhes desistencias'] as $i => $chamadaPerdida) {
			$Data = explode(" ", $chamadaPerdida['Data']);

			$Pes = "SELECT count(id) FROM " . $this->TabelRH . " WHERE diahora > '" . $chamadaPerdida['Data'] . "' and diahora <= '" . $DataFinal . "' and numero = '" . $chamadaPerdida['Numero'] . "' and oque LIKE '%Em conversa&ccedil;&atilde;o%'";
			$Res = $this->Bd->executa_query_com_saida($Pes);
			if ($Res[0]['count'] == 0) {
				$Numero = $chamadaPerdida['Numero'];
				$Ligacoes[$Data[0]][$Numero]['Quantidade']++;
			}
		}

		return $Ligacoes;
	}

	function verifica_chamadas_atendidas_pela_data($Fila, $DataInicial, $DataFinal, $Dehoje = '', $tipoPes = 'monit') {
		if ($Dehoje == '') {
			$Tabela = $this->TabelaR;
		} else {
			$Tabela = $this->TabelRH;
		}

		$Pes = "select count(to_char(diahora, 'yyyy-mm-dd')) as diahorario, numero, to_char(diahora, 'yyyy-mm-dd') as dia , fila from " . $Tabela . " where diahora >= '" . $DataInicial . "%' and diahora <= '" . $DataFinal . "%' and fila = '" . $Fila . "' and oque LIKE '%Em conversa&ccedil;&atilde;o%' and agente='' AND numero != '<Unknown>' AND numero != '' AND numero != 'NULL' group by numero, dia order by dia, diahorario Desc";
		if ($tipoPes == 'monit') {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

		return $Res;
	}

	function relatorio_chamadas_atendidas($Filas, $DataInicial, $DataFinal, $MinimoEspera, $Dehoje = '', $tipoPes = 'monit') {
		$Chamadas = $this->relatorio_filas_geral($Filas, $DataInicial, $DataFinal, $MinimoEspera, $Dehoje, $tipoPes);
		for ($x = 0; $x < count($Chamadas['Detalhes chamadas atendidas']); $x++) {
			$Dados[$x]['Tempo de espera'] = $Chamadas['Detalhes chamadas atendidas'][$x]['Tempo em espera'];
			$Dados[$x]['Data'] = $Chamadas['Detalhes chamadas atendidas'][$x]['Data'];
			$Dados[$x]['Numero'] = $Chamadas['Detalhes chamadas atendidas'][$x]['Numero'];
		}
		$Dados['Quantidade'] = $Chamadas['Quantidade chamadas atendidas'] + 0;
		$Dados['Quantidade tempo maximo'] = $Chamadas['Quantidade chamadas atendidas com tempo espera > maximo'] + 0;
		$Saida = $Dados;
		return $Saida;
	}

	function relatorio_chamadas_nao_atendidas($Filas, $DataInicial, $DataFinal, $MinimoEspera, $Dehoje = '', $tipoPes = 'monit') {
		$Chamadas = $this->relatorio_filas_geral($Filas, $DataInicial, $DataFinal, $MinimoEspera, $Dehoje, $tipoPes);
		for ($x = 0; $x < count($Chamadas['Detalhes desistencias']); $x++) {
			$Dados[$x]['Status'] = $Chamadas['Detalhes desistencias'][$x]['Status'];
			$Dados[$x]['Tempo de espera'] = $Chamadas['Detalhes desistencias'][$x]['Tempo em espera'];
			$Dados[$x]['Data'] = $Chamadas['Detalhes desistencias'][$x]['Data'];
			$Dados[$x]['Numero'] = $Chamadas['Detalhes desistencias'][$x]['Numero'];
		}
		$Dados['Quantidade'] = $Chamadas['Quantidade desistencias'] + 0;
		$Dados['Quantidade tempo maximo'] = $Chamadas['Quantidade desistencia com tempo espera > maximo'] + 0;
		$Saida = $Dados;
		return $Saida;
	}

	function monta_array_tempo($Dia, $Mes, $Ano, $Tabela, $Agente, $LiR) {
		/*if(($Tempo['DM'][$Dia][$Mes]['Primeiro Login dia'] == '')
			            &&(!isset($Tempo['DM'][$Dia][$Mes]['Primeiro Login dia']))){
			            $inicio_pesquisa = $Ano."-".$Mes."-".$Dia." 00:00";
			            $datas_pesquisa  = $Ano."-".$Mes."-".$Dia;
				    $fim_pesquisa    = $Ano."-".$Mes."-".$Dia." 23:59";

			            $PesquisaLogin = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, ";
			            $PesquisaLogin.= "oque FROM ".$Tabela." WHERE ( agente='".$Agente."' ".$LiR." ) ";
			            $PesquisaLogin.= "AND diahora >= '".$inicio_pesquisa."' AND diahora <= '".$fim_pesquisa."' ORDER BY diahora";

			            if($tipoPes=='monit') $ResLogin  = $this->Bd->executa_query_com_saida($PesquisaLogin);
			            if($tipoPes=='relat') $ResLogin  = $this->BdRelat->executa_query_com_saida($PesquisaLogin);

		*/
	}

	function relatorio_agentes_acessos_dia_mes($Agente, $Inicio, $Fim, $Relacionado = false, $Dehoje = '', $tipoPes = 'monit') {
		$Inicio = trim($Inicio);
		$Fim = trim($Fim);
		$LiR = "";
		if ($Relacionado) {
			$Pesquisa = "SELECT " . $this->TabelaA . ".login, " . $this->TabelaA . ".nome, ";
			$Pesquisa .= $this->TabelaA . ".funcai FROM (SELECT " . $this->TabelAL . ".login  FROM ";
			$Pesquisa .= $this->TabelAL . " INNER JOIN " . $this->TabelaA . " ON ";
			$Pesquisa .= $this->TabelaA . ".id=" . $this->TabelAL . ".agente WHERE ";
			$Pesquisa .= $this->TabelaA . ".login = '" . substr($Agente, 0, 4) . "') as relaciona ";
			$Pesquisa .= "INNER JOIN " . $this->TabelaA . " ON " . $this->TabelaA . ".id=relaciona.login";

			if ($tipoPes == 'monit') {
				$LoginRelacionado = $this->Bd->executa_query_com_saida($Pesquisa);
			}

			if ($tipoPes == 'relat') {
				$LoginRelacionado = $this->BdRelat->executa_query_com_saida($Pesquisa);
			}

			if ($LoginRelacionado) {
				for ($x = 0; $x < count($LoginRelacionado); $x++) {
					$LiR .= " OR agente='" . $LoginRealacionado[$x]['login'] . "-" . $LoginRelacionado[$x]['nome'] . "'";
				}

			}
		}
		$DataInicio = intval(substr($Inicio, 8, 2), 10);
		$DataFim = intval(substr($Fim, 8, 2), 10);

		$dia_a = substr($Inicio, 8, 2);
		$mes_a = substr($Inicio, 5, 2);
		$ano_a = substr($Inicio, 0, 4);

		$dia_d = substr($Fim, 8, 2);
		$mes_d = substr($Fim, 5, 2);
		$ano_d = substr($Fim, 0, 4);

		$dia1 = mktime(0, 0, 0, $mes_a, $dia_a, $ano_a);
		$dia2 = mktime(0, 0, 0, $mes_d, $dia_d, $ano_d);

		$Diferenca = ($dia2 - $dia1);
		$Data = $Diferenca / (60 * 60 * 24);
		$totaldiasmensais = array(31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
		$anos = $ano_a;
		while ($anos <= $ano_d) {
			$meses = $mes_a;
			while (($meses <= $mes_d) && ($anos <= $ano_d)) {
				if ($meses == $mes_a) {
					$dia_a1 = $dia_a;
				} else {
					$dia_a1 = '01';
				}
				if ($meses == $mes_d) {
					$dia_d1 = $dia_d;
				} else {
					$dia_d1 = $totaldiasmensais[$meses - 1];
				}
				for ($dias = $dia_a1; $dias <= $dia_d1; $dias++) {
					$selecao1 = $anos . "-" . $meses . "-" . $dias . " 00:00";
					$selecao2 = $anos . "-" . $meses . "-" . $dias . " 23:59";
					$dias = intval($dias, 10);
					$meses = intval($meses, 10);
					$Pesquisa = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora , diahora FROM ";
					$Pesquisa .= $this->TabelaR . " WHERE ( agente='" . $Agente . "' " . $LiR . " ) AND diahora >= '";
					$Pesquisa .= $selecao1 . "' AND diahora <= '" . $selecao2 . "' AND oque='Login' ORDER BY diahora ASC LIMIT 1";

					if ($tipoPes == 'monit') {
						$Resultado = $this->Bd->executa_query_com_saida($Pesquisa);
					}

					if ($tipoPes == 'relat') {
						$Resultado = $this->BdRelat->executa_query_com_saida($Pesquisa);
					}

					if ($Resultado) {
						$Tempo['Acesso']['Login'][$dias][$meses][$anos] = $Resultado[0]['agora'];
					} else {
						$Tempo['Acesso']['Login'][$dias][$meses][$anos] = mktime(0, 0, 0, null, null, null);
					}

					$Pesquisa = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as agora , diahora FROM ";
					$Pesquisa .= $this->TabelaR . " WHERE ( agente='" . $Agente . "' " . $LiR . " ) AND diahora >= '";
					$Pesquisa .= $selecao1 . "' AND diahora <= '" . $selecao2 . "' AND oque='Logout' ORDER BY diahora ASC LIMIT 1";
					if ($tipoPes == 'monit') {
						$Resultado = $this->Bd->executa_query_com_saida($Pesquisa);
					}

					if ($tipoPes == 'relat') {
						$Resultado = $this->BdRelat->executa_query_com_saida($Pesquisa);
					}

					if ($Resultado) {
						$Tempo['Acesso']['Logout'][$dias][$meses][$anos] = $Resultado[0]['agora'];
					} else {
						$Tempo['Acesso']['Logout'][$dias][$meses][$anos] = mktime(0, 0, 0, null, null, null);
					}

				}$meses++;
				if ($meses == 13) {
					$meses = 1;
					$anos++;
				}
				$anos++;
			}
		}
		return $Tempo;
	}

	function carrega_estados() {
		$Pes = "Select uf From " . $this->TabelDD . " group by uf order by uf";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		return $Res;
	}

	function relatorio_filas_geral($Fila, $DataInicial, $DataFinal, $MinimoEspera = 0, $Dehoje = '', $tipoPes = 'monit', $tempoConv = 0, $filtroNumero = "") {
		//Define qual tabela de relatórios será usada de acordo com o parâmetro "Dehoje"
		if ($Dehoje == '') {
			$Tabela = "vm50_relatorios_cc";
		} else {
			$Tabela = "vm50_relatorios_cc_hoje";
		}

		//Inicializa a matriz $Dados com valores padrão
		$Dados = array();
		$Dados['Quantidade chamadas recebidas'] = 0;
		$Dados['Quantidade chamadas atendidas'] = 0;
		$Dados['Quantidade Desistencia-FilA'] = 0;
		$Dados['Quantidade Desistencia-Desligamento'] = 0;
		$Dados['Chamadas com tempo espera > maximo'] = 0;
		$Dados['Chamadas atendidas com tempo espera > maximo'] = 0;
		$Dados['Maior tempo em espera'] = 0;
		$Dados['Tempo em conversacao'] = 0;
		$Dados['Quantidade Desistencia-Caixa'] = 0;
		$Dados['Quantidade Desistencia-Msg'] = 0;

		//Cria o SQL para pesquisa
		$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, diahora, id, agente, fila, numero, oque, ligacao FROM " . $Tabela . " WHERE diahora >= '" . $DataInicial . "' AND diahora <= '" . $DataFinal . "' AND fila LIKE '" . $Fila . "' AND ligacao>'0' AND (agente!=numero OR oque LIKE 'Desistencia%') AND (substring(numero from 1 for 5) NOT IN (SELECT login||'-' FROM " . $this->TabelaA . ")) AND (numero like '%" . $filtroNumero . "%' OR numero like '') AND numero != 'NULL' ORDER BY ligacao, diahora";
		//return $Pes;
		if ($tipoPes == 'monit') {
			$Res = $this->Bd->executa_query_com_saida($Pes);
		}

		if ($tipoPes == 'relat') {
			$Res = $this->BdRelat->executa_query_com_saida($Pes);
		}

		//Cria o SQL para pegar o tempo máximo de espera daquela fila
		$Pes = "Select tempomaxespeatend From " . $this->TabelaF . " Where pseudonimo = '" . $Fila . "'";
		$Res_tempoMax = $this->Bd->executa_query_com_saida($Pes);
		$TempoMax = $Res_tempoMax[0]['tempomaxespeatend'];

		//Armazena algumas variáveis para facilitar
		$oque_atual = $Res[0]['oque'];
		$x = 0;
		$y = 0;
		$z = 0;
		$controle = 0;

		//Verifica se o tempo MinimoEspera é menor ou igual a 4
		//Caso seja, define o valor mínimo para espera que é 4
		//Senão, deixa o valor definido na variável...
		/*if ($MinimoEspera <= 4) {
			$DesisteAPartir = 4;
		} else {
			$DesisteAPartir = $MinimoEspera;
		}*/

		//Começa a tratar os dados
		for ($i = 0; $i < count($Res); $i++) {
			//Grava as variáveis ligacao_atual e oque_atual com os dados que estão sendo lidos naquele
			//momento...
			$ligacao_atual = $Res[$i]['ligacao'];
			$oque_atual = $Res[$i]['oque'];

			//Verifica de qual estado é aquela ligação
			//if($tipoPes == 'relat' && strlen($Res[$i]['numero']) > 4){
			$verPrimeiro = substr($Res[$i]['numero'], 0, 1);
			if ($verPrimeiro == "0") {
				$DDD = substr($Res[$i]['numero'], 1, 2);
			} else {
				$DDD = substr($Res[$i]['numero'], 0, 2);
			}

			if (is_numeric($DDD)) {
				$PesDDD = "Select uf From " . $this->TabelDD . " Where ddd = " . $DDD . " Limit 1";
				$ResDDD = $this->Bd->executa_query_com_saida($PesDDD);
				$UF = $ResDDD[0]['uf'];
			} else {
				$UF = '';
			}
			//} else {
			//$UF = '';
			//}

			//Verifica se o registro que está sendo lido atualmente é = "Chamando" e se o próximo
			//registro é diferente de "Chamando", caso seja, significa que aquele é o ultimo "Chamando"
			//antes de um novo registro, por isso aquele deve ser guardado para calculos de tempo...
			/*if(($Res[$i]['oque'] == "Chamando") && ($Res[$i+1]['oque'] != "Chamando")){
	                $Dados_anterior = $Res[$i];
*/
			if (($Res[$i]['oque'] == "Chamando") && (($Res[$i - 1]['oque'] != "Chamando") || ($Res[$i - 1]['ligacao'] != $Res[$i]['ligacao'])) && ($Res[$i + 1]['ligacao'] == $Res[$i]['ligacao'])) {
				$Dados_anterior = $Res[$i];
				$controle = 0;
			}

			//Trata o horario e a data do registro atual para poder mostrar quando foi registrado aquele evento
			list($data, $horario) = explode(" ", $Res[$i]['diahora']);
			list($ano, $mes, $dia) = explode("-", $data);
			list($hora, $hora_tmp) = explode(".", $horario);
			$horario = $hora;
			$dia_array = intval($dia, 10);
			$hora_array = intval($hora, 10);

			//Quebra o horario em hora e minutos...
			list($hora, $minuto, $segundo) = explode(":", $horario);

			//Trata os minutos para separar de 15 em 15 minutos
			if ((intval($minuto) >= 0) && (intval($minuto) <= 15)) {
				$minuto_separado = 0;
			}

			if ((intval($minuto) > 15) && (intval($minuto) <= 30)) {
				$minuto_separado = 15;
			}

			if ((intval($minuto) > 30) && (intval($minuto) <= 45)) {
				$minuto_separado = 30;
			}

			if ((intval($minuto) > 45) && (intval($minuto) <= 59)) {
				$minuto_separado = 45;
			}

			//Verifica se o oque é algum tipo de mensagem e formata para cair certo no switch
			if (substr($oque_atual, 0, 15) == "Desistencia-Msg") {
				$oque_atual = "Desistencia-Msg";
			}

			//Começa a filtrar os registros para ver o que é cada um...
			switch ($oque_atual) {

				//Aqui começa a tratar as ligações que foram atendidas...
				case "Em conversa&ccedil;&atilde;o":

                    //Filtro para Em conversacao em local errado
                    if(
                        (trim($Res[$i-1]["oque"]) == "Desistencia-FilA" || trim($Res[$i-1]["oque"]) == "Desligado") && 
                        (trim($Res[$i+1]['oque']) == "Chamando" || trim($Res[$i+1]['oque']) == "Desligado")
                    ) continue;

					//Calcula o tempo que a pessoa ficou em espera
					if (($Dados_anterior['ligacao'] == $ligacao_atual) && ($Res[$i + 1]['oque'] == "Em conversa&ccedil;&atilde;o") && ($Res[$i]['numero'] != 'Procurando PA')) {
						$controle++;
					}

					//Verifica aquele "Em conversa&ccedil;&atilde;o" é realmente uma ligação pois existem registros que vem fora de ordem... ainda não sabemos porque eles vem fora de ordem...
					//if (($Dados_anterior['ligacao'] == $ligacao_atual) && ($Res[$i + 1]['oque'] != "Em conversa&ccedil;&atilde;o") && ($Res[$i - 1]['oque'] != "Chamando")) {
                    if($Dados_anterior['numero'] == $Res[$i]['numero'] && ($Res[$i + 1]['oque'] != "Em conversa&ccedil;&atilde;o") /*&& ($Res[$i - 1]['oque'] != "Chamando")*/) {

						//Calcula o tempo que a ligação ficou em espera e o tempo em que ficou em conversação
						$tempoEsp = $Res[$i - $controle]['diahorario'] - $Dados_anterior['diahorario'];
						if (is_numeric($Res[$i + 1]['diahorario'])) {
							$tempoCon = $Res[$i + 1]['diahorario'] - $Res[$i - $controle]['diahorario'];
						} else {
							$tempoCon = 0;
						}

						if ($tempoCon <= $tempoConv) {
							continue;
						}

						$tempoCon = $this->pega_duracao($Res[$i]['ligacao']);

						//Verifica qual a classificação daquela chamada
						list($dataCC, $horarioCC) = explode(" ", $Res[$i - $controle]['diahora']);
						list($horaCC, $hora_tmpCC) = explode(".", $horarioCC);
						list($agt, $agt_tmp) = explode("-", $Res[$i]['agente']);
						$Pes = "SELECT opcao FROM vm50_chamadas_classificadas WHERE datahora::text like '" . $dataCC . " " . substr($horaCC, 0, 4) . "%' AND numero like '%" . $Res[$i]['numero'] . "%' AND login like '" . $agt . "' limit 1";

						$class_cham = $this->Bd->executa_query_com_saida($Pes);
						if (count($class_cham) > 0) {
							$class_cham = $class_cham[0]['opcao'];
						} else {
							$class_cham = "";
						}

						$SaidaTst .= "Data e hora: " . $Res[$i - $controle]['diahora'] . "<br/>Fila: " . $Res[$i]['fila'] . "<br/>Numero: " . $Res[$i]['numero'] . "<br/>Classificação: " . $class_cham . "<br/>SQL: " . $Pes . "<br/><br/>";

						//Verifica se o tempo de espera é maior que o tempo de espera máximo definido
						//para aquela fila. Se for, soma no tempo de espera > maximo, senao, soma nas
						//chamadas atendidas no prazo...
						if ($tempoEsp > $TempoMax) {
							$Dados['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas com tempo espera > maximo']++;
							//------------------------------------------------------------------//
							$Dados['Quantidade chamadas atendidas com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas atendidas com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas atendidas com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas atendidas com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas atendidas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas atendidas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas atendidas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas atendidas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas atendidas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Quantidade chamadas atendidas com tempo espera > maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas atendidas com tempo espera > maximo']++;
							$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas atendidas com tempo espera > maximo']++;
						} else {
							$Dados['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas com tempo espera <= maximo']++;
							//--------------------------------------------------------------//
							$Dados['Quantidade chamadas atendidas com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas atendidas com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas atendidas com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas atendidas com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas atendidas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas atendidas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas atendidas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas atendidas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas atendidas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Quantidade chamadas atendidas com tempo espera <= maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas atendidas com tempo espera <= maximo']++;
							$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas atendidas com tempo espera <= maximo']++;
						}

						if ($tempoEsp > $Dados['Maior tempo em espera']) {
							$Dados['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Dia'][$dia_array]['Maior tempo em espera']) {
							$Dados['Dia'][$dia_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Hora'][$hora_array]['Maior tempo em espera']) {
							$Dados['Hora'][$hora_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera']) {
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Dia'][$dia_array]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Dia'][$dia_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Hora'][$hora_array]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Hora'][$hora_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['ClassCham'][$class_cham]['Maior tempo em espera']) {
							$Dados['ClassCham'][$class_cham]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['ClassCham'][$class_cham]['UF'][$UF]['Maior tempo em espera']) {
							$Dados['ClassCham'][$class_cham]['UF'][$UF]['Maior tempo em espera'] = $tempoEsp;
						}

						//Guarda as informações nas variáveis

						//Guarda somente chamadas atendidas
						$Dados['Detalhes chamadas atendidas'][$y]['Numero'] = $Res[$i]['numero'];
						$Dados['Detalhes chamadas atendidas'][$y]['Status'] = "Atendida";
						$Dados['Detalhes chamadas atendidas'][$y]['Quem atendeu'] = $Res[$i]['agente'];
						$Dados['Detalhes chamadas atendidas'][$y]['Data'] = $dia . "/" . $mes . "/" . $ano . " " . $horario;
						$Dados['Detalhes chamadas atendidas'][$y]['Tempo em conversacao'] = $tempoCon;
						$Dados['Detalhes chamadas atendidas'][$y]['Tempo em espera'] = $tempoEsp;
						$Dados['Detalhes chamadas atendidas'][$y]['UF'] = $UF;

						//Guarda todas as chamadas juntas
						$Dados['Geral'][$x]['Numero'] = $Res[$i]['numero'];
						$Dados['Geral'][$x]['Status'] = "Atendida";
						$Dados['Geral'][$x]['Quem atendeu'] = $Res[$i]['agente'];
						$Dados['Geral'][$x]['Data'] = $dia . "/" . $mes . "/" . $ano . " " . $horario;
						$Dados['Geral'][$x]['Tempo em conversacao'] = $tempoCon;
						$Dados['Geral'][$x]['Tempo em espera'] = $tempoEsp;
						$Dados['Geral'][$x]['UF'] = $UF;

						$Dados['Tempo em espera']['Total'] += $tempoEsp;
						$Dados['Dia'][$dia_array]['Tempo em espera']['Total'] += $tempoEsp;
						$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
						$Dados['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
						$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Total'] += $tempoEsp;
						$Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em espera']['Total'] += $tempoEsp;
						$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
						$Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
						$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Total'] += $tempoEsp;
						$Dados['UF'][$UF]['Tempo em espera']['Total'] += $tempoEsp;
						$Dados['ClassCham'][$class_cham]['Tempo em espera']['Total'] += $tempoEsp;
						$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em espera']['Total'] += $tempoEsp;

						$Dados['Tempo em espera']['Chamadas atendidas'] += $tempoEsp;
						$Dados['Dia'][$dia_array]['Tempo em espera']['Chamadas atendidas'] += $tempoEsp;
						$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Chamadas atendidas'] += $tempoEsp;
						$Dados['Hora'][$hora_array]['Tempo em espera']['Chamadas atendidas'] += $tempoEsp;
						$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Chamadas atendidas'] += $tempoEsp;
						$Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em espera']['Chamadas atendidas'] += $tempoEsp;
						$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Chamadas atendidas'] += $tempoEsp;
						$Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em espera']['Chamadas atendidas'] += $tempoEsp;
						$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Chamadas atendidas'] += $tempoEsp;
						$Dados['UF'][$UF]['Tempo em espera']['Chamadas atendidas'] += $tempoEsp;
						$Dados['ClassCham'][$class_cham]['Tempo em espera']['Chamadas atendidas'] += $tempoEsp;
						$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em espera']['Chamadas atendidas'] += $tempoEsp;

						$Dados['Tempo em conversacao'] += $tempoCon;
						$Dados['Dia'][$dia_array]['Tempo em conversacao'] += $tempoCon;
						$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em conversacao'] += $tempoCon;
						$Dados['Hora'][$hora_array]['Tempo em conversacao'] += $tempoCon;
						$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em conversacao'] += $tempoCon;
						$Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em conversacao'] += $tempoCon;
						$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em conversacao'] += $tempoCon;
						$Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em conversacao'] += $tempoCon;
						$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em conversacao'] += $tempoCon;
						$Dados['UF'][$UF]['Tempo em conversacao'] += $tempoCon;
						$Dados['ClassCham'][$class_cham]['Tempo em conversacao'] += $tempoCon;
						$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em conversacao'] += $tempoCon;

						$Dados['Quantidade chamadas recebidas']++;
						$Dados['Dia'][$dia_array]['Quantidade chamadas recebidas']++;
						$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
						$Dados['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
						$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas recebidas']++;
						$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas recebidas']++;
						$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
						$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
						$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas recebidas']++;
						$Dados['UF'][$UF]['Quantidade chamadas recebidas']++;
						$Dados['ClassCham'][$class_cham]['Quantidade chamadas recebidas']++;
						$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas recebidas']++;

						$Dados['Quantidade chamadas atendidas']++;
						$Dados['Dia'][$dia_array]['Quantidade chamadas atendidas']++;
						$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas atendidas']++;
						$Dados['Hora'][$hora_array]['Quantidade chamadas atendidas']++;
						$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas atendidas']++;
						$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas atendidas']++;
						$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas atendidas']++;
						$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas atendidas']++;
						$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas atendidas']++;
						$Dados['UF'][$UF]['Quantidade chamadas atendidas']++;
						$Dados['ClassCham'][$class_cham]['Quantidade chamadas atendidas']++;
						$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas atendidas']++;

						$x++;
						$y++;
					}
					break;

				//Trata as ligações que foram de desistencia da fila, ou seja, aquelas que ficaram na fila de
				//espera e desistiram de esperar...
				case "Desistencia-FilA":

					//Verifica se aquela ligação é realmente uma ligação de desistencia, pois alguns dados estão
					//vindo fora de ordem..
                    //if (($ligacao_atual == $Dados_anterior['ligacao']) && ($Res[$i + 1]['oque'] != "Desistencia-FilA") && ($Res[$i - 1]['oque'] != "Em conversa&ccedil;&atilde;o") && ($Res[$i - 1]['oque'] != "Desistencia-FilA") && (substr($Res[$i + 1]['oque'], 0, 12) != "Desistencia-")) {
                    if (($ligacao_atual == $Dados_anterior['ligacao']) && ($Res[$i - 1]['oque'] != "Desistencia-FilA") && ($Res[$i - 1]['oque'] != "Em conversa&ccedil;&atilde;o")) {
						$valido = true;
						for ($iD = 1; $iD <= 4; $iD++) {
							if ($Res[$i - $iD]['oque'] == "Desistencia-Caixa_Postal") {
								$valido = false;
							}
						}

                        if($this->verificar_transbordo($ligacao_atual, $Fila)) $valido = false;

						if (!$valido) break;

						//Verifica qual a classificação daquela chamada
						//$Pes = "SELECT opcao FROM vm50_chamadas_classificadas WHERE id_origem = '".$ligacao_atual."' OR id_destino = '".$ligacao_atual."' LIMIT 1";
						list($dataCC, $horarioCC) = explode(" ", $Res[$i - $controle]['diahora']);
						list($horaCC, $hora_tmpCC) = explode(".", $horarioCC);
						list($agt, $agt_tmp) = explode("-", $Res[$i]['agente']);
						$Pes = "SELECT opcao FROM vm50_chamadas_classificadas WHERE datahora::text like '" . $dataCC . " " . substr($horaCC, 0, 4) . "%' AND numero like '%" . substr($Res[$i]['numero'], 2) . "%' AND login like '" . $agt . "' limit 1";
						$class_cham = $this->Bd->executa_query_com_saida($Pes);
						if (count($class_cham) > 0) {
							$class_cham = $class_cham[0]['opcao'];
						} else {
							$class_cham = "";
						}

						//Calcula o tempo de espera daquela ligação
						$tempoEsp = $Res[$i]['diahorario'] - $Dados_anterior['diahorario'];

						//Se o tempo de espera for maior que o $DesisteAPartir (tempo definido abaixo do box que mostra as filas) ele nao considera a desistencia...
						if ($tempoEsp <= $DesisteAPartir) {
							break;
						}

						//Verifica se o tempo de espera é maior que o tempo de espera máximo definido
						//para aquela fila. Se for, soma no tempo de espera > maximo, senao, soma nas
						//chamadas atendidas no prazo...
						if ($tempoEsp > $TempoMax) {
							$Dados['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas com tempo espera > maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas com tempo espera > maximo']++;
							//------------------------------------------------------------------------//
							$Dados['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade desistencia com tempo espera > maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencia com tempo espera > maximo']++;
						} else {
							$Dados['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas com tempo espera <= maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas com tempo espera <= maximo']++;
							//------------------------------------------------------------------------//
							$Dados['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade desistencia com tempo espera <= maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencia com tempo espera <= maximo']++;
						}

						if ($tempoEsp > $Dados['Maior tempo em espera']) {
							$Dados['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Dia'][$dia_array]['Maior tempo em espera']) {
							$Dados['Dia'][$dia_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Hora'][$hora_array]['Maior tempo em espera']) {
							$Dados['Hora'][$hora_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera']) {
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Dia'][$dia_array]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Dia'][$dia_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Hora'][$hora_array]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Hora'][$hora_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['ClassCham'][$class_cham]['Maior tempo em espera']) {
							$Dados['ClassCham'][$class_cham]['Maior tempo em espera'] = $tempoEsp;
						}

						//if($tempoEsp > $Dados['ClassCham'][$class_cham]['UF'][$UF]['Maior tempo em espera']) $Dados['UF'][$UF]['ClassCham'][$class_cham]['Maior tempo em espera'] = $tempoEsp;

						//Se o tempo de espera for maior que o tempo de desistencia definido da fila, então a
						//desistencia é considerada e contada. Caso contrário, a mesma é ignorada...
						if ($tempoEsp > $DesisteAPartir) {
							//Guarda os valores nas variáveis

							//Guarda somente chamadas de desistencias
							$Dados['Detalhes desistencias'][$z]['Numero'] = $Res[$i]['numero'];
							$Dados['Detalhes desistencias'][$z]['Status'] = "N&atilde;o atendida";
							$Dados['Detalhes desistencias'][$z]['Quem atendeu'] = " - ";
							$Dados['Detalhes desistencias'][$z]['Data'] = $dia . "/" . $mes . "/" . $ano . " " . $horario;
							$Dados['Detalhes desistencias'][$z]['Tempo em conversacao'] = 0;
							$Dados['Detalhes desistencias'][$z]['Tempo em espera'] = $tempoEsp;
							$Dados['Detalhes desistencias'][$z]['UF'] = $UF;

							//Guarda todas as chamadas juntas
							$Dados['Geral'][$x]['Numero'] = $Res[$i]['numero'];
							$Dados['Geral'][$x]['Status'] = "N&atilde;o atendida";
							$Dados['Geral'][$x]['Quem atendeu'] = " - ";
							$Dados['Geral'][$x]['Data'] = $dia . "/" . $mes . "/" . $ano . " " . $horario;
							$Dados['Geral'][$x]['Tempo em conversacao'] = 0;
							$Dados['Geral'][$x]['Tempo em espera'] = $tempoEsp;
							$Dados['Geral'][$x]['UF'] = $UF;

							$Dados['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['ClassCham'][$class_cham]['Tempo em espera']['Total'] += $tempoEsp;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em espera']['Total'] += $tempoEsp;

							$Dados['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
							$Dados['UF'][$UF]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
							$Dados['ClassCham'][$class_cham]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;

							$Dados['Quantidade chamadas recebidas']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas recebidas']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Quantidade chamadas recebidas']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas recebidas']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas recebidas']++;

							$Dados['Quantidade Desistencia-FilA']++;
							$Dados['Dia'][$dia_array]['Quantidade Desistencia-FilA']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade Desistencia-FilA']++;
							$Dados['Hora'][$hora_array]['Quantidade Desistencia-FilA']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade Desistencia-FilA']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade Desistencia-FilA']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade Desistencia-FilA']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade Desistencia-FilA']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade Desistencia-FilA']++;
							$Dados['UF'][$UF]['Quantidade Desistencia-FilA']++;
							$Dados['ClassCham'][$class_cham]['Quantidade Desistencia-FilA']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade Desistencia-FilA']++;

							$Dados['Quantidade desistencias']++;
							$Dados['Dia'][$dia_array]['Quantidade desistencias']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Quantidade desistencias']++;
							$Dados['ClassCham'][$class_cham]['Quantidade desistencias']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencias']++;

							//Guarda a quantidade de ligações que tiveram o atendimento < que o tempo indicado
							if ($tempoEsp <= 10) {
								$Dados['Espera < 10s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera < 10s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Espera < 10s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera < 10s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 10s']['Total']++;
								//------------------------------------------------------------------//
								$Dados['Espera < 10s']['Desistencia-FilA']++;
								$Dados['Dia'][$dia_array]['Espera < 10s']['Desistencia-FilA']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Desistencia-FilA']++;
								$Dados['Hora'][$hora_array]['Espera < 10s']['Desistencia-FilA']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 10s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 10s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Espera < 10s']['Desistencia-FilA']++;
								$Dados['ClassCham'][$class_cham]['Espera < 10s']['Desistencia-FilA']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 10s']['Desistencia-FilA']++;
							}
							if ($tempoEsp > 10 && $tempoEsp <= 20) {
								$Dados['Espera < 20s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera < 20s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Espera < 20s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera < 20s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 20s']['Total']++;
								//-----------------------------------------------------------------//
								$Dados['Espera < 20s']['Desistencia-FilA']++;
								$Dados['Dia'][$dia_array]['Espera < 20s']['Desistencia-FilA']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Desistencia-FilA']++;
								$Dados['Hora'][$hora_array]['Espera < 20s']['Desistencia-FilA']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 20s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 20s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Espera < 20s']['Desistencia-FilA']++;
								$Dados['ClassCham'][$class_cham]['Espera < 20s']['Desistencia-FilA']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 20s']['Desistencia-FilA']++;
							}
							if ($tempoEsp > 20 && $tempoEsp <= 30) {
								$Dados['Espera < 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera < 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Espera < 30s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera < 30s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 30s']['Total']++;
								//-----------------------------------------------------------------//
								$Dados['Espera < 30s']['Desistencia-FilA']++;
								$Dados['Dia'][$dia_array]['Espera < 30s']['Desistencia-FilA']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Desistencia-FilA']++;
								$Dados['Hora'][$hora_array]['Espera < 30s']['Desistencia-FilA']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 30s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 30s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Espera < 30s']['Desistencia-FilA']++;
								$Dados['ClassCham'][$class_cham]['Espera < 30s']['Desistencia-FilA']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 30s']['Desistencia-FilA']++;
							}
							if ($tempoEsp > 30) {
								$Dados['Espera > 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera > 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Espera > 30s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera > 30s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera > 30s']['Total']++;
								//---------------------------------------------------------------------------------------//
								$Dados['Espera > 30s']['Desistencia-FilA']++;
								$Dados['Dia'][$dia_array]['Espera > 30s']['Desistencia-FilA']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Desistencia-FilA']++;
								$Dados['Hora'][$hora_array]['Espera > 30s']['Desistencia-FilA']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera > 30s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera > 30s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Desistencia-FilA']++;
								$Dados['UF'][$UF]['Espera > 30s']['Desistencia-FilA']++;
								$Dados['ClassCham'][$class_cham]['Espera > 30s']['Desistencia-FilA']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera > 30s']['Desistencia-FilA']++;
							}

							$x++;
							$z++;
						}
					}
					break;

				//Trata as ligações de Desistencia por desligamento, ou seja, aquelas que o agente
				//desligou..
				case "Desistencia-Desligamento":

					//Verifica se aquela ligação realmente é uma ligação de desistencia, pois pode acontecer
					//de um registro estar com Desistencia-Desligamento mais ela pode ser um registro fora
					//do ligar devido a erros na pesquisa que ainda não descobri como filtrar pelo sql...
					if (($ligacao_atual == $Dados_anterior['ligacao']) && ($Res[$i + 1]['oque'] != "Desistencia-Desligamento") && ($Res[$i - 1]['oque'] != "Em conversa&ccedil;&atilde;o") && (substr($Res[$i + 1]['oque'], 0, 12) != "Desistencia-")) {

						//Verifica qual a classificação daquela chamada
						//$Pes = "SELECT opcao FROM vm50_chamadas_classificadas WHERE id_origem = '".$ligacao_atual."' OR id_destino = '".$ligacao_atual."' LIMIT 1";
						list($dataCC, $horarioCC) = explode(" ", $Res[$i - $controle]['diahora']);
						list($horaCC, $hora_tmpCC) = explode(".", $horarioCC);
						list($agt, $agt_tmp) = explode("-", $Res[$i]['agente']);
						$Pes = "SELECT opcao FROM vm50_chamadas_classificadas WHERE datahora::text like '" . $dataCC . " " . substr($horaCC, 0, 4) . "%' AND numero like '%" . substr($Res[$i]['numero'], 2) . "%' AND login like '" . $agt . "' limit 1";
						$class_cham = $this->Bd->executa_query_com_saida($Pes);
						if (count($class_cham) > 0) {
							$class_cham = $class_cham[0]['opcao'];
						} else {
							$class_cham = "";
						}

                        //Verificar transbordo
                        $valido = true;
                        if($this->verificar_transbordo($ligacao_atual, $Fila)) $valido = false;

                        if(!$valido) break;

						//Calcula o tempo de espera que aquela ligação ficou na fila...
						$tempoEsp = $Res[$i]['diahorario'] - $Dados_anterior['diahorario'];

						//Se o tempo de espera for maior que o $DesisteAPartir (tempo definido abaixo do box que mostra as filas) ele nao considera a desistencia...
						if ($tempoEsp <= $DesisteAPartir) {
							break;
						}

						if ($tempoEsp > $TempoMax) {
							$Dados['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas com tempo espera > maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas com tempo espera > maximo']++;
							//------------------------------------------------------------------------//
							$Dados['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade desistencia com tempo espera > maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencia com tempo espera > maximo']++;
						} else {
							$Dados['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas com tempo espera <= maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas com tempo espera <= maximo']++;
							//------------------------------------------------------------------------//
							$Dados['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade desistencia com tempo espera <= maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencia com tempo espera <= maximo']++;
						}

						if ($tempoEsp > $Dados['Maior tempo em espera']) {
							$Dados['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Dia'][$dia_array]['Maior tempo em espera']) {
							$Dados['Dia'][$dia_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Hora'][$hora_array]['Maior tempo em espera']) {
							$Dados['Hora'][$hora_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera']) {
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Dia'][$dia_array]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Dia'][$dia_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Hora'][$hora_array]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Hora'][$hora_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['ClassCham'][$class_cham]['Maior tempo em espera']) {
							$Dados['ClassCham'][$class_cham]['Maior tempo em espera'] = $tempoEsp;
						}

						//if($tempoEsp > $Dados['ClassCham'][$class_cham]['UF'][$UF]['Maior tempo em espera']) $Dados['UF'][$UF]['ClassCham'][$class_cham]['Maior tempo em espera'] = $tempoEsp;

						//Verifica se o tempo de espera é maior que o tempo mínimo de desistencia,
						//Caso seja, então a ligação é contada...
						if ($tempoEsp > $DesisteAPartir) {

							//Guarda as informações nas variáveis

                            $statusLigacao = "N&atilde;o atendida";

							//Guarda somente chamadas de desistencias
							$Dados['Detalhes desistencias'][$z]['Numero'] = $Res[$i]['numero'];
							$Dados['Detalhes desistencias'][$z]['Status'] = $statusLigacao;
							$Dados['Detalhes desistencias'][$z]['Quem atendeu'] = " - ";
							$Dados['Detalhes desistencias'][$z]['Data'] = $dia . "/" . $mes . "/" . $ano . " " . $horario;
							$Dados['Detalhes desistencias'][$z]['Tempo em conversacao'] = 0;
							$Dados['Detalhes desistencias'][$z]['Tempo em espera'] = $tempoEsp;
							$Dados['Detalhes desistencias'][$z]['UF'] = $UF;

							//Guarda somente as chamadas geral
							$Dados['Geral'][$x]['Numero'] = $Res[$i]['numero'];
							$Dados['Geral'][$x]['Status'] = $statusLigacao;
							$Dados['Geral'][$x]['Quem atendeu'] = " - ";
							$Dados['Geral'][$x]['Data'] = $dia . "/" . $mes . "/" . $ano . " " . $horario;
							$Dados['Geral'][$x]['Tempo em espera'] = $tempoEsp;
							$Dados['Geral'][$x]['UF'] = $UF;

							$Dados['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['ClassCham'][$class_cham]['Tempo em espera']['Total'] += $tempoEsp;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em espera']['Total'] += $tempoEsp;

							$Dados['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['UF'][$UF]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['ClassCham'][$class_cham]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;

							$Dados[$x]['Tempo em conversacao'] = 0;

							$Dados['Quantidade chamadas recebidas']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas recebidas']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Quantidade chamadas recebidas']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas recebidas']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas recebidas']++;

							$Dados['Quantidade Desistencia-Desligamento']++;
							$Dados['Dia'][$dia_array]['Quantidade Desistencia-Desligamento']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade Desistencia-Desligamento']++;
							$Dados['Hora'][$hora_array]['Quantidade Desistencia-Desligamento']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade Desistencia-Desligamento']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade Desistencia-Desligamento']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade Desistencia-Desligamento']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade Desistencia-Desligamento']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade Desistencia-Desligamento']++;
							$Dados['UF'][$UF]['Quantidade Desistencia-Desligamento']++;
							$Dados['ClassCham'][$class_cham]['Quantidade Desistencia-Desligamento']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade Desistencia-Desligamento']++;

							$Dados['Quantidade desistencias']++;
							$Dados['Dia'][$dia_array]['Quantidade desistencias']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Quantidade desistencias']++;
							$Dados['ClassCham'][$class_cham]['Quantidade desistencias']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencias']++;

							//Guarda a quantidade de ligações que tiveram o atendimento < que o tempo indicado
							if ($tempoEsp <= 10) {
								$Dados['Espera < 10s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera < 10s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Espera < 10s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera < 10s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 10s']['Total']++;
								//---------------------------------------------------------------------------------------------//
								$Dados['Espera < 10s']['Desistencia-Desligamento']++;
								$Dados['Dia'][$dia_array]['Espera < 10s']['Desistencia-Desligamento']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Desistencia-Desligamento']++;
								$Dados['Hora'][$hora_array]['Espera < 10s']['Desistencia-Desligamento']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 10s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 10s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Espera < 10s']['Desistencia-Desligamento']++;
								$Dados['ClassCham'][$class_cham]['Espera < 10s']['Desistencia-Desligamento']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 10s']['Desistencia-Desligamento']++;
							}
							if ($tempoEsp > 10 && $tempoEsp <= 20) {
								$Dados['Espera < 20s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera < 20s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Espera < 20s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera < 20s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 20s']['Total']++;
								//----------------------------------------------------------------------------------------------//
								$Dados['Espera < 20s']['Desistencia-Desligamento']++;
								$Dados['Dia'][$dia_array]['Espera < 20s']['Desistencia-Desligamento']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Desistencia-Desligamento']++;
								$Dados['Hora'][$hora_array]['Espera < 20s']['Desistencia-Desligamento']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 20s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 20s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Espera < 20s']['Desistencia-Desligamento']++;
								$Dados['ClassCham'][$class_cham]['Espera < 20s']['Desistencia-Desligamento']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 20s']['Desistencia-Desligamento']++;
							}
							if ($tempoEsp > 20 && $tempoEsp <= 30) {
								$Dados['Espera < 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera < 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Espera < 30s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera < 30s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 30s']['Total']++;
								//----------------------------------------------------------------------------------------------//
								$Dados['Espera < 30s']['Desistencia-Desligamento']++;
								$Dados['Dia'][$dia_array]['Espera < 30s']['Desistencia-Desligamento']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Desistencia-Desligamento']++;
								$Dados['Hora'][$hora_array]['Espera < 30s']['Desistencia-Desligamento']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 30s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 30s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Espera < 30s']['Desistencia-Desligamento']++;
								$Dados['ClassCham'][$class_cham]['Espera < 30s']['Desistencia-Desligamento']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 30s']['Desistencia-Desligamento']++;
							}
							if ($tempoEsp > 30) {
								$Dados['Espera > 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera > 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Espera > 30s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera > 30s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera > 30s']['Total']++;
								//----------------------------------------------------------------------------------------------//
								$Dados['Espera > 30s']['Desistencia-Desligamento']++;
								$Dados['Dia'][$dia_array]['Espera > 30s']['Desistencia-Desligamento']['Desistencia-Desligamento']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Desistencia-Desligamento']++;
								$Dados['Hora'][$hora_array]['Espera > 30s']['Desistencia-Desligamento']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera > 30s']['Desistencia-Desligamento']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera > 30s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Desistencia-Desligamento']++;
								$Dados['UF'][$UF]['Espera > 30s']['Desistencia-Desligamento']++;
								$Dados['ClassCham'][$class_cham]['Espera > 30s']['Desistencia-Desligamento']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera > 30s']['Desistencia-Desligamento']++;
							}

							$x++;
							$z++;
						}
					}
					break;

				//Filtra as ligações que foram desistidas pela caixa postal
				case "Desistencia-Caixa_Postal":

					//Verifica se aquela ligação realmente é uma ligação de desistencia, pois pode acontecer de um registro estar com Desistencia-Desligamento mais ela pode ser um registro fora do ligar devido a erros na pesquisa que ainda não descobri como filtrar pelo sql...
					if (($ligacao_atual == $Dados_anterior['ligacao']) && ($Res[$i + 1]['oque'] != "Desistencia-Caixa_Postal") && ($Res[$i - 1]['oque'] != "Em conversa&ccedil;&atilde;o") /*&& (substr($Res[$i+1]['oque'], 0, 12) != "Desistencia-")*/) {

						//Verifica qual a classificação daquela chamada
						//$Pes = "SELECT opcao FROM vm50_chamadas_classificadas WHERE id_origem = '".$ligacao_atual."' OR id_destino = '".$ligacao_atual."' LIMIT 1";
						list($dataCC, $horarioCC) = explode(" ", $Res[$i - $controle]['diahora']);
						list($horaCC, $hora_tmpCC) = explode(".", $horarioCC);
						list($agt, $agt_tmp) = explode("-", $Res[$i]['agente']);
						$Pes = "SELECT opcao FROM vm50_chamadas_classificadas WHERE datahora::text like '" . $dataCC . " " . substr($horaCC, 0, 4) . "%' AND numero like '%" . substr($Res[$i]['numero'], 2) . "%' AND login like '" . $agt . "' limit 1";
						$class_cham = $this->Bd->executa_query_com_saida($Pes);
						if (count($class_cham) > 0) {
							$class_cham = $class_cham[0]['opcao'];
						} else {
							$class_cham = "";
						}

						//Calcula o tempo de espera que aquela ligação ficou na fila...
						$tempoEsp = $Res[$i]['diahorario'] - $Dados_anterior['diahorario'];

						//Se o tempo de espera for maior que o $DesisteAPartir (tempo definido abaixo do box que mostra as filas) ele nao considera a desistencia...
						if ($tempoEsp <= $DesisteAPartir) {
							break;
						}

						if ($tempoEsp > $TempoMax) {
							$Dados['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas com tempo espera > maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas com tempo espera > maximo']++;
							//------------------------------------------------------------------------//
							$Dados['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade desistencia com tempo espera > maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencia com tempo espera > maximo']++;
						} else {
							$Dados['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Quantidade chamadas com tempo espera <= maximo'];
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas com tempo espera <= maximo'];
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas com tempo espera <= maximo'];
							//------------------------------------------------------------------------//
							$Dados['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade desistencia com tempo espera <= maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencia com tempo espera <= maximo']++;
						}

						if ($tempoEsp > $Dados['Maior tempo em espera']) {
							$Dados['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Dia'][$dia_array]['Maior tempo em espera']) {
							$Dados['Dia'][$dia_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Hora'][$hora_array]['Maior tempo em espera']) {
							$Dados['Hora'][$hora_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera']) {
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Dia'][$dia_array]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Dia'][$dia_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Hora'][$hora_array]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Hora'][$hora_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['ClassCham'][$class_cham]['Maior tempo em espera']) {
							$Dados['ClassCham'][$class_cham]['Maior tempo em espera'] = $tempoEsp;
						}

						//if($tempoEsp > $Dados['ClassCham'][$class_cham]['UF'][$UF]['Maior tempo em espera']) $Dados['UF'][$UF]['ClassCham'][$class_cham]['Maior tempo em espera'] = $tempoEsp;

						//Verifica se o tempo de espera é maior que o tempo mínimo de desistencia,
						//Caso seja, então a ligação é contada...
						if ($tempoEsp > $DesisteAPartir) {

							//Guarda as informações nas variáveis

							//Guarda somente chamadas de desistencias
							$Dados['Detalhes desistencias'][$z]['Numero'] = $Res[$i]['numero'];
							$Dados['Detalhes desistencias'][$z]['Status'] = "Caixa Postal";
							$Dados['Detalhes desistencias'][$z]['Quem atendeu'] = " - ";
							$Dados['Detalhes desistencias'][$z]['Data'] = $dia . "/" . $mes . "/" . $ano . " " . $horario;
							$Dados['Detalhes desistencias'][$z]['Tempo em conversacao'] = 0;
							$Dados['Detalhes desistencias'][$z]['Tempo em espera'] = $tempoEsp;
							$Dados['Detalhes desistencias'][$z]['UF'] = $UF;

							//Guarda em todas as chamadas de entrada
							$Dados['Geral'][$x]['Numero'] = $Res[$i]['numero'];
							$Dados['Geral'][$x]['Status'] = "Caixa Postal";
							$Dados['Geral'][$x]['Quem atendeu'] = " - ";
							$Dados['Geral'][$x]['Data'] = $dia . "/" . $mes . "/" . $ano . " " . $horario;
							$Dados['Geral'][$x]['Tempo em espera'] = $tempoEsp;
							$Dados['Geral'][$x]['UF'] = $UF;

							$Dados['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['ClassCham'][$class_cham]['Tempo em espera']['Total'] += $tempoEsp;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em espera']['Total'] += $tempoEsp;

							$Dados['Tempo em espera']['Desistencia-Caixa'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Tempo em espera']['Desistencia-Caixa'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Desistencia-Caixa'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['Tempo em espera']['Desistencia-Caixa'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Desistencia-Caixa'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em espera']['Desistencia-Caixa'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Desistencia-Caixa'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em espera']['Desistencia-Caixa'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Desistencia-Caixa'] += $tempoEsp;
							$Dados['UF'][$UF]['Tempo em espera']['Desistencia-Caixa'] += $tempoEsp;
							$Dados['ClassCham'][$class_cham]['Tempo em espera']['Desistencia-Caixa'] += $tempoEsp;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em espera']['Desistencia-Caixa'] += $tempoEsp;

							$Dados[$x]['Tempo em conversacao'] = 0;

							$Dados['Quantidade chamadas recebidas']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas recebidas']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Quantidade chamadas recebidas']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas recebidas']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas recebidas']++;

							$Dados['Quantidade Desistencia-Caixa']++;
							$Dados['Dia'][$dia_array]['Quantidade Desistencia-Caixa']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade Desistencia-Caixa']++;
							$Dados['Hora'][$hora_array]['Quantidade Desistencia-Caixa']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade Desistencia-Caixa']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade Desistencia-Caixa']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade Desistencia-Caixa']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade Desistencia-Caixa']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade Desistencia-Caixa']++;
							$Dados['UF'][$UF]['Quantidade Desistencia-Caixa']++;
							$Dados['ClassCham'][$class_cham]['Quantidade Desistencia-Caixa']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade Desistencia-Caixa']++;

							$Dados['Quantidade desistencias']++;
							$Dados['Dia'][$dia_array]['Quantidade desistencias']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Quantidade desistencias']++;
							$Dados['ClassCham'][$class_cham]['Quantidade desistencias']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencias']++;

							//Guarda a quantidade de ligações que tiveram o atendimento < que o tempo indicado
							if ($tempoEsp <= 10) {
								$Dados['Espera < 10s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera < 10s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Espera < 10s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera < 10s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 10s']['Total']++;
								//-------------------------------------------------------------------------//
								$Dados['Espera < 10s']['Desistencia-Caixa']++;
								$Dados['Dia'][$dia_array]['Espera < 10s']['Desistencia-Caixa']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Desistencia-Caixa']++;
								$Dados['Hora'][$hora_array]['Espera < 10s']['Desistencia-Caixa']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 10s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 10s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Espera < 10s']['Desistencia-Caixa']++;
								$Dados['ClassCham'][$class_cham]['Espera < 10s']['Desistencia-Caixa']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 10s']['Desistencia-Caixa']++;
							}
							if ($tempoEsp > 10 && $tempoEsp <= 20) {
								$Dados['Espera < 20s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera < 20s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Espera < 20s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera < 20s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 20s']['Total']++;
								//-------------------------------------------------------------------------//
								$Dados['Espera < 20s']['Desistencia-Caixa']++;
								$Dados['Dia'][$dia_array]['Espera < 20s']['Desistencia-Caixa']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Desistencia-Caixa']++;
								$Dados['Hora'][$hora_array]['Espera < 20s']['Desistencia-Caixa']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 20s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 20s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Espera < 20s']['Desistencia-Caixa']++;
								$Dados['ClassCham'][$class_cham]['Espera < 20s']['Desistencia-Caixa']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 20s']['Desistencia-Caixa']++;
							}
							if ($tempoEsp > 20 && $tempoEsp <= 30) {
								$Dados['Espera < 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera < 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Espera < 30s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera < 30s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 30s']['Total']++;
								//------------------------------------------------------------------------------------------//
								$Dados['Espera < 30s']['Desistencia-Caixa']++;
								$Dados['Dia'][$dia_array]['Espera < 30s']['Desistencia-Caixa']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Desistencia-Caixa']++;
								$Dados['Hora'][$hora_array]['Espera < 30s']['Desistencia-Caixa']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 30s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 30s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Espera < 30s']['Desistencia-Caixa'];
								$Dados['ClassCham'][$class_cham]['Espera < 30s']['Desistencia-Caixa'];
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 30s']['Desistencia-Caixa'];
							}
							if ($tempoEsp > 30) {
								$Dados['Espera > 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera > 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Espera > 30s']['Total'];
								$Dados['ClassCham'][$class_cham]['Espera > 30s']['Total'];
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera > 30s']['Total'];
								//------------------------------------------------------------------------------------------//
								$Dados['Espera > 30s']['Desistencia-Caixa']++;
								$Dados['Dia'][$dia_array]['Espera > 30s']['Desistencia-Caixa']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Desistencia-Caixa']++;
								$Dados['Hora'][$hora_array]['Espera > 30s']['Desistencia-Caixa']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera > 30s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera > 30s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Desistencia-Caixa']++;
								$Dados['UF'][$UF]['Espera > 30s']['Desistencia-Caixa'];
								$Dados['ClassCham'][$class_cham]['Espera > 30s']['Desistencia-Caixa'];
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera > 30s']['Desistencia-Caixa'];
							}

							$x++;
							$z++;
						}
					}
					break;

				//Filtra as ligações que foram desistidas pela mensagem
				case "Desistencia-Msg":

					//Verifica se aquela ligação realmente é uma ligação de desistencia, pois pode acontecer
					//de um registro estar com Desistencia-Desligamento mais ela pode ser um registro fora
					//do ligar devido a erros na pesquisa que ainda não descobri como filtrar pelo sql...
					if (($ligacao_atual == $Dados_anterior['ligacao']) && ($Res[$i + 1]['oque'] != "Desistencia-Caixa") && ($Res[$i - 1]['oque'] != "Em conversa&ccedil;&atilde;o") && (substr($Res[$i + 1]['oque'], 0, 12) != "Desistencia-")) {

						//Verifica qual a classificação daquela chamada
						//$Pes = "SELECT opcao FROM vm50_chamadas_classificadas WHERE id_origem = '".$ligacao_atual."' OR id_destino = '".$ligacao_atual."' LIMIT 1";
						list($dataCC, $horarioCC) = explode(" ", $Res[$i - $controle]['diahora']);
						list($horaCC, $hora_tmpCC) = explode(".", $horarioCC);
						list($agt, $agt_tmp) = explode("-", $Res[$i]['agente']);
						$Pes = "SELECT opcao FROM vm50_chamadas_classificadas WHERE datahora::text like '" . $dataCC . " " . substr($horaCC, 0, 4) . "%' AND numero like '%" . substr($Res[$i]['numero'], 2) . "%' AND login like '" . $agt . "' limit 1";
						$class_cham = $this->Bd->executa_query_com_saida($Pes);
						if (count($class_cham) > 0) {
							$class_cham = $class_cham[0]['opcao'];
						} else {
							$class_cham = "";
						}

						//Calcula o tempo de espera que aquela ligação ficou na fila...
						$tempoEsp = $Res[$i]['diahorario'] - $Dados_anterior['diahorario'];

						//Se o tempo de espera for maior que o $DesisteAPartir (tempo definido abaixo do box que mostra as filas) ele nao considera a desistencia...
						if ($tempoEsp <= $DesisteAPartir) {
							break;
						}

						if ($tempoEsp > $TempoMax) {
							$Dados['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Quantidade chamadas com tempo espera > maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas com tempo espera > maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas com tempo espera > maximo']++;
							//------------------------------------------------------------------------//
							$Dados['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['UF'][$UF]['Quantidade desistencia com tempo espera > maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade desistencia com tempo espera > maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencia com tempo espera > maximo']++;
						} else {
							$Dados['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Quantidade chamadas com tempo espera <= maximo']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas com tempo espera <= maximo']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas com tempo espera <= maximo']++;
							//------------------------------------------------------------------------//
							$Dados['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera <= maximo']++;
							$Dados['UF'][$UF]['Quantidade desistencia com tempo espera <= maximo'];
							$Dados['ClassCham'][$class_cham]['Quantidade desistencia com tempo espera <= maximo'];
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencia com tempo espera <= maximo'];
						}

						if ($tempoEsp > $Dados['Maior tempo em espera']) {
							$Dados['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Dia'][$dia_array]['Maior tempo em espera']) {
							$Dados['Dia'][$dia_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Hora'][$hora_array]['Maior tempo em espera']) {
							$Dados['Hora'][$hora_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera']) {
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Dia'][$dia_array]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Dia'][$dia_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Hora'][$hora_array]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Hora'][$hora_array]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['UF'][$UF]['Maior tempo em espera']) {
							$Dados['UF'][$UF]['Maior tempo em espera'] = $tempoEsp;
						}

						if ($tempoEsp > $Dados['ClassCham'][$class_cham]['Maior tempo em espera']) {
							$Dados['ClassCham'][$class_cham]['Maior tempo em espera'] = $tempoEsp;
						}

						//if($tempoEsp > $Dados['ClassCham'][$class_cham]['UF'][$UF]['Maior tempo em espera']) $Dados['UF'][$UF]['ClassCham'][$class_cham]['Maior tempo em espera'] = $tempoEsp;

						//Verifica se o tempo de espera é maior que o tempo mínimo de desistencia,
						//Caso seja, então a ligação é contada...
						if ($tempoEsp > $DesisteAPartir) {

							//Guarda as informações nas variáveis

							//Guarda somente chamadas de desistencias
							$Dados['Detalhes desistencias'][$z]['Numero'] = $Res[$i]['numero'];
							$Dados['Detalhes desistencias'][$z]['Status'] = "Mensagem";
							$Dados['Detalhes desistencias'][$z]['Quem atendeu'] = " - ";
							$Dados['Detalhes desistencias'][$z]['Data'] = $dia . "/" . $mes . "/" . $ano . " " . $horario;
							$Dados['Detalhes desistencias'][$z]['Tempo em conversacao'] = 0;
							$Dados['Detalhes desistencias'][$z]['Tempo em espera'] = $tempoEsp;
							$Dados['Detalhes desistencias'][$z]['UF'] = $UF;

							//Guarda em todas as chamadas juntas
							$Dados['Geral'][$x]['Numero'] = $Res[$i]['numero'];
							$Dados['Geral'][$x]['Status'] = "Mensagem";
							$Dados['Geral'][$x]['Quem atendeu'] = " - ";
							$Dados['Geral'][$x]['Data'] = $dia . "/" . $mes . "/" . $ano . " " . $horario;
							$Dados['Geral'][$x]['Tempo em espera'] = $tempoEsp;
							$Dados['Geral'][$x]['UF'] = $UF;

							$Dados['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['UF'][$UF]['Tempo em espera']['Total'] += $tempoEsp;
							$Dados['ClassCham'][$class_cham]['Tempo em espera']['Total'] += $tempoEsp;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em espera']['Total'] += $tempoEsp;
							//-------------------------------------------------------------------------------------------------//
							$Dados['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['UF'][$UF]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							$Dados['ClassCham'][$class_cham]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em espera']['Desistencia-Desligamento'] += $tempoEsp;

							$Dados[$x]['Tempo em conversacao'] = 0;

							$Dados['Quantidade chamadas recebidas']++;
							$Dados['Dia'][$dia_array]['Quantidade chamadas recebidas']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas recebidas']++;
							$Dados['UF'][$UF]['Quantidade chamadas recebidas']++;
							$Dados['ClassCham'][$class_cham]['Quantidade chamadas recebidas']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas recebidas']++;
							//-------------------------------------------------------------------------------------------------//
							$Dados['Quantidade Desistencia-Msg']++;
							$Dados['Dia'][$dia_array]['Quantidade Desistencia-Msg']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade Desistencia-Msg']++;
							$Dados['Hora'][$hora_array]['Quantidade Desistencia-Msg']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade Desistencia-Msg']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade Desistencia-Msg']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade Desistencia-Msg']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade Desistencia-Msg']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade Desistencia-Msg']++;
							$Dados['UF'][$UF]['Quantidade Desistencia-Msg']++;
							$Dados['ClassCham'][$class_cham]['Quantidade Desistencia-Msg']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade Desistencia-Msg']++;

							$Dados['Quantidade desistencias']++;
							$Dados['Dia'][$dia_array]['Quantidade desistencias']++;
							$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencias']++;
							$Dados['UF'][$UF]['Quantidade desistencias']++;
							$Dados['ClassCham'][$class_cham]['Quantidade desistencias']++;
							//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencias']++;

							//Guarda a quantidade de ligações que tiveram o atendimento < que o tempo indicado
							if ($tempoEsp <= 10) {
								$Dados['Espera < 10s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera < 10s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Total']++;
								$Dados['UF'][$UF]['Espera < 10s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera < 10s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 10s']['Total']++;
								//---------------------------------------------------------------//
								$Dados['Espera < 10s']['Desistencia-Msg']++;
								$Dados['Dia'][$dia_array]['Espera < 10s']['Desistencia-Msg']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Desistencia-Msg']++;
								$Dados['Hora'][$hora_array]['Espera < 10s']['Desistencia-Msg']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 10s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 10s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Espera < 10s']['Desistencia-Msg']++;
								$Dados['ClassCham'][$class_cham]['Espera < 10s']['Desistencia-Msg']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 10s']['Desistencia-Msg']++;
							}
							if ($tempoEsp > 10 && $tempoEsp <= 20) {
								$Dados['Espera < 20s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera < 20s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Total']++;
								$Dados['UF'][$UF]['Espera < 20s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera < 20s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 20s']['Total']++;
								//-----------------------------------------------------------------//
								$Dados['Espera < 20s']['Desistencia-Msg']++;
								$Dados['Dia'][$dia_array]['Espera < 20s']['Desistencia-Msg']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Desistencia-Msg']++;
								$Dados['Hora'][$hora_array]['Espera < 20s']['Desistencia-Msg']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 20s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 20s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Espera < 20s']['Desistencia-Msg']++;
								$Dados['ClassCham'][$class_cham]['Espera < 20s']['Desistencia-Msg']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 20s']['Desistencia-Msg']++;
							}
							if ($tempoEsp > 20 && $tempoEsp <= 30) {
								$Dados['Espera < 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera < 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Total']++;
								$Dados['UF'][$UF]['Espera < 30s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera < 30s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 30s']['Total']++;
								//--------------------------------------------------------------------------------//
								$Dados['Espera < 30s']['Desistencia-Msg']++;
								$Dados['Dia'][$dia_array]['Espera < 30s']['Desistencia-Msg']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Desistencia-Msg']++;
								$Dados['Hora'][$hora_array]['Espera < 30s']['Desistencia-Msg']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 30s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 30s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Espera < 30s']['Desistencia-Msg']++;
								$Dados['ClassCham'][$class_cham]['Espera < 30s']['Desistencia-Msg']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 30s']['Desistencia-Msg']++;
							}
							if ($tempoEsp > 30) {
								$Dados['Espera > 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Espera > 30s']['Total']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Total']++;
								$Dados['UF'][$UF]['Espera > 30s']['Total']++;
								$Dados['ClassCham'][$class_cham]['Espera > 30s']['Total']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera > 30s']['Total']++;
								//---------------------------------------------------------------------------//
								$Dados['Espera > 30s']['Desistencia-Msg']++;
								$Dados['Dia'][$dia_array]['Espera > 30s']['Desistencia-Msg']++;
								$Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Desistencia-Msg']++;
								$Dados['Hora'][$hora_array]['Espera > 30s']['Desistencia-Msg']++;
								$Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Espera > 30s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['Espera > 30s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Desistencia-Msg']++;
								$Dados['UF'][$UF]['Espera > 30s']['Desistencia-Msg']++;
								$Dados['ClassCham'][$class_cham]['Espera > 30s']['Desistencia-Msg']++;
								//$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera > 30s']['Desistencia-Msg']++;
							}

							$x++;
							$z++;
						}
					}
					break;

                default:
                    if(substr($oque_atual, 0, 10) == "Transbordo"){
                        $tempoEsp = $Res[$i]['diahorario'] - $Dados_anterior['diahorario'];

                        //Verifica se o tempo de espera é maior que o tempo de espera máximo definido
                        //para aquela fila. Se for, soma no tempo de espera > maximo, senao, soma nas
                        //chamadas atendidas no prazo...
                        if ($tempoEsp > $TempoMax) {
                            $Dados['Quantidade chamadas com tempo espera > maximo']++;
                            $Dados['Dia'][$dia_array]['Quantidade chamadas com tempo espera > maximo']++;
                            $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
                            $Dados['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
                            $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera > maximo']++;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas com tempo espera > maximo']++;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas com tempo espera > maximo']++;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera > maximo']++;
                            $Dados['UF'][$UF]['Quantidade chamadas com tempo espera > maximo']++;
                            $Dados['ClassCham'][$class_cham]['Quantidade chamadas com tempo espera > maximo']++;
                            //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas com tempo espera > maximo']++;
                            //------------------------------------------------------------------------//
                            $Dados['Quantidade desistencia com tempo espera > maximo']++;
                            $Dados['Dia'][$dia_array]['Quantidade desistencia com tempo espera > maximo']++;
                            $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
                            $Dados['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
                            $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera > maximo']++;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencia com tempo espera > maximo']++;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencia com tempo espera > maximo']++;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera > maximo']++;
                            $Dados['UF'][$UF]['Quantidade desistencia com tempo espera > maximo']++;
                            $Dados['ClassCham'][$class_cham]['Quantidade desistencia com tempo espera > maximo']++;
                            //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencia com tempo espera > maximo']++;
                        } else {
                            $Dados['Quantidade chamadas com tempo espera <= maximo']++;
                            $Dados['Dia'][$dia_array]['Quantidade chamadas com tempo espera <= maximo']++;
                            $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
                            $Dados['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
                            $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera <= maximo']++;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas com tempo espera <= maximo']++;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas com tempo espera <= maximo']++;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas com tempo espera <= maximo']++;
                            $Dados['UF'][$UF]['Quantidade chamadas com tempo espera <= maximo']++;
                            $Dados['ClassCham'][$class_cham]['Quantidade chamadas com tempo espera <= maximo']++;
                            //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas com tempo espera <= maximo']++;
                            //------------------------------------------------------------------------//
                            $Dados['Quantidade desistencia com tempo espera <= maximo']++;
                            $Dados['Dia'][$dia_array]['Quantidade desistencia com tempo espera <= maximo']++;
                            $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
                            $Dados['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
                            $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera <= maximo']++;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade desistencia com tempo espera <= maximo']++;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade desistencia com tempo espera <= maximo']++;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade desistencia com tempo espera <= maximo']++;
                            $Dados['UF'][$UF]['Quantidade desistencia com tempo espera <= maximo']++;
                            $Dados['ClassCham'][$class_cham]['Quantidade desistencia com tempo espera <= maximo']++;
                            //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade desistencia com tempo espera <= maximo']++;
                        }

                        if ($tempoEsp > $Dados['Maior tempo em espera']) {
                            $Dados['Maior tempo em espera'] = $tempoEsp;
                        }

                        if ($tempoEsp > $Dados['Dia'][$dia_array]['Maior tempo em espera']) {
                            $Dados['Dia'][$dia_array]['Maior tempo em espera'] = $tempoEsp;
                        }

                        if ($tempoEsp > $Dados['Hora'][$hora_array]['Maior tempo em espera']) {
                            $Dados['Hora'][$hora_array]['Maior tempo em espera'] = $tempoEsp;
                        }

                        if ($tempoEsp > $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera']) {
                            $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera'] = $tempoEsp;
                        }

                        if ($tempoEsp > $Dados['UF'][$UF]['Dia'][$dia_array]['Maior tempo em espera']) {
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Maior tempo em espera'] = $tempoEsp;
                        }

                        if ($tempoEsp > $Dados['UF'][$UF]['Hora'][$hora_array]['Maior tempo em espera']) {
                            $Dados['UF'][$UF]['Hora'][$hora_array]['Maior tempo em espera'] = $tempoEsp;
                        }

                        if ($tempoEsp > $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera']) {
                            $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Maior tempo em espera'] = $tempoEsp;
                        }

                        if ($tempoEsp > $Dados['UF'][$UF]['Maior tempo em espera']) {
                            $Dados['UF'][$UF]['Maior tempo em espera'] = $tempoEsp;
                        }

                        if ($tempoEsp > $Dados['ClassCham'][$class_cham]['Maior tempo em espera']) {
                            $Dados['ClassCham'][$class_cham]['Maior tempo em espera'] = $tempoEsp;
                        }

                        //if($tempoEsp > $Dados['ClassCham'][$class_cham]['UF'][$UF]['Maior tempo em espera']) $Dados['UF'][$UF]['ClassCham'][$class_cham]['Maior tempo em espera'] = $tempoEsp;

                        //Se o tempo de espera for maior que o tempo de desistencia definido da fila, então a
                        //desistencia é considerada e contada. Caso contrário, a mesma é ignorada...
                        if ($tempoEsp > $DesisteAPartir) {
                            //Guarda os valores nas variáveis

                            //Guarda somente chamadas de desistencias
                            $Dados['Detalhes transbordo'][$z]['Numero'] = $Res[$i]['numero'];
                            $Dados['Detalhes transbordo'][$z]['Status'] = $oque_atual;
                            $Dados['Detalhes transbordo'][$z]['Quem atendeu'] = " - ";
                            $Dados['Detalhes transbordo'][$z]['Data'] = $dia . "/" . $mes . "/" . $ano . " " . $horario;
                            $Dados['Detalhes transbordo'][$z]['Tempo em conversacao'] = 0;
                            $Dados['Detalhes transbordo'][$z]['Tempo em espera'] = $tempoEsp;
                            $Dados['Detalhes transbordo'][$z]['UF'] = $UF;

                            //Guarda todas as chamadas juntas
                            $Dados['Geral'][$x]['Numero'] = $Res[$i]['numero'];
                            $Dados['Geral'][$x]['Status'] = $oque_atual;
                            $Dados['Geral'][$x]['Quem atendeu'] = " - ";
                            $Dados['Geral'][$x]['Data'] = $dia . "/" . $mes . "/" . $ano . " " . $horario;
                            $Dados['Geral'][$x]['Tempo em conversacao'] = 0;
                            $Dados['Geral'][$x]['Tempo em espera'] = $tempoEsp;
                            $Dados['Geral'][$x]['UF'] = $UF;

                            $Dados['Tempo em espera']['Total'] += $tempoEsp;
                            $Dados['Dia'][$dia_array]['Tempo em espera']['Total'] += $tempoEsp;
                            $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
                            $Dados['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
                            $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Total'] += $tempoEsp;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em espera']['Total'] += $tempoEsp;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em espera']['Total'] += $tempoEsp;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Total'] += $tempoEsp;
                            $Dados['UF'][$UF]['Tempo em espera']['Total'] += $tempoEsp;
                            $Dados['ClassCham'][$class_cham]['Tempo em espera']['Total'] += $tempoEsp;
                            //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em espera']['Total'] += $tempoEsp;

                            $Dados['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
                            $Dados['Dia'][$dia_array]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
                            $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
                            $Dados['Hora'][$hora_array]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
                            $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
                            $Dados['UF'][$UF]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
                            $Dados['ClassCham'][$class_cham]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;
                            //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Tempo em espera']['Desistencia-FilA'] += $tempoEsp;

                            $Dados['Quantidade chamadas recebidas']++;
                            $Dados['Dia'][$dia_array]['Quantidade chamadas recebidas']++;
                            $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
                            $Dados['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
                            $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas recebidas']++;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade chamadas recebidas']++;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade chamadas recebidas']++;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade chamadas recebidas']++;
                            $Dados['UF'][$UF]['Quantidade chamadas recebidas']++;
                            $Dados['ClassCham'][$class_cham]['Quantidade chamadas recebidas']++;
                            //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade chamadas recebidas']++;

                            $Dados['Quantidade Transbordo']++;
                            $Dados['Dia'][$dia_array]['Quantidade Transbordo']++;
                            $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade Transbordo']++;
                            $Dados['Hora'][$hora_array]['Quantidade Transbordo']++;
                            $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade Transbordo']++;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Quantidade Transbordo']++;
                            $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Quantidade Transbordo']++;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['Quantidade Transbordo']++;
                            $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Quantidade Transbordo']++;
                            $Dados['UF'][$UF]['Quantidade Transbordo']++;
                            $Dados['ClassCham'][$class_cham]['Quantidade Transbordo']++;
                            //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Quantidade Desistencia-FilA']++;

                            //Guarda a quantidade de ligações que tiveram o atendimento < que o tempo indicado
                            if ($tempoEsp <= 10) {
                                $Dados['Espera < 10s']['Total']++;
                                $Dados['Dia'][$dia_array]['Espera < 10s']['Total']++;
                                $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Total']++;
                                $Dados['Hora'][$hora_array]['Espera < 10s']['Total']++;
                                $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Total']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 10s']['Total']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Total']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 10s']['Total']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Total']++;
                                $Dados['UF'][$UF]['Espera < 10s']['Total']++;
                                $Dados['ClassCham'][$class_cham]['Espera < 10s']['Total']++;
                                //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 10s']['Total']++;
                                //------------------------------------------------------------------//
                                $Dados['Espera < 10s']['Transbordo']++;
                                $Dados['Dia'][$dia_array]['Espera < 10s']['Transbordo']++;
                                $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Transbordo']++;
                                $Dados['Hora'][$hora_array]['Espera < 10s']['Transbordo']++;
                                $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Transbordo']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 10s']['Transbordo']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 10s']['Transbordo']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 10s']['Transbordo']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 10s']['Transbordo']++;
                                $Dados['UF'][$UF]['Espera < 10s']['Transbordo']++;
                                $Dados['ClassCham'][$class_cham]['Espera < 10s']['Transbordo']++;
                                //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 10s']['Desistencia-FilA']++;
                            }
                            if ($tempoEsp > 10 && $tempoEsp <= 20) {
                                $Dados['Espera < 20s']['Total']++;
                                $Dados['Dia'][$dia_array]['Espera < 20s']['Total']++;
                                $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Total']++;
                                $Dados['Hora'][$hora_array]['Espera < 20s']['Total']++;
                                $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Total']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 20s']['Total']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Total']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 20s']['Total']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Total']++;
                                $Dados['UF'][$UF]['Espera < 20s']['Total']++;
                                $Dados['ClassCham'][$class_cham]['Espera < 20s']['Total']++;
                                //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 20s']['Total']++;
                                //-----------------------------------------------------------------//
                                $Dados['Espera < 20s']['Transbordo']++;
                                $Dados['Dia'][$dia_array]['Espera < 20s']['Transbordo']++;
                                $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Transbordo']++;
                                $Dados['Hora'][$hora_array]['Espera < 20s']['Transbordo']++;
                                $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Transbordo']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 20s']['Transbordo']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 20s']['Transbordo']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 20s']['Transbordo']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 20s']['Transbordo']++;
                                $Dados['UF'][$UF]['Espera < 20s']['Transbordo']++;
                                $Dados['ClassCham'][$class_cham]['Espera < 20s']['Transbordo']++;
                                //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 20s']['Desistencia-FilA']++;
                            }
                            if ($tempoEsp > 20 && $tempoEsp <= 30) {
                                $Dados['Espera < 30s']['Total']++;
                                $Dados['Dia'][$dia_array]['Espera < 30s']['Total']++;
                                $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Total']++;
                                $Dados['Hora'][$hora_array]['Espera < 30s']['Total']++;
                                $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Total']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 30s']['Total']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Total']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 30s']['Total']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Total']++;
                                $Dados['UF'][$UF]['Espera < 30s']['Total']++;
                                $Dados['ClassCham'][$class_cham]['Espera < 30s']['Total']++;
                                //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 30s']['Total']++;
                                //-----------------------------------------------------------------//
                                $Dados['Espera < 30s']['Desistencia-FilA']++;
                                $Dados['Dia'][$dia_array]['Espera < 30s']['Transbordo']++;
                                $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Transbordo']++;
                                $Dados['Hora'][$hora_array]['Espera < 30s']['Transbordo']++;
                                $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Transbordo']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Espera < 30s']['Transbordo']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera < 30s']['Transbordo']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['Espera < 30s']['Transbordo']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera < 30s']['Transbordo']++;
                                $Dados['UF'][$UF]['Espera < 30s']['Transbordo']++;
                                $Dados['ClassCham'][$class_cham]['Espera < 30s']['Transbordo']++;
                                //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera < 30s']['Desistencia-FilA']++;
                            }
                            if ($tempoEsp > 30) {
                                $Dados['Espera > 30s']['Total']++;
                                $Dados['Dia'][$dia_array]['Espera > 30s']['Total']++;
                                $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Total']++;
                                $Dados['Hora'][$hora_array]['Espera > 30s']['Total']++;
                                $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Total']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Espera > 30s']['Total']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Total']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['Espera > 30s']['Total']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Total']++;
                                $Dados['UF'][$UF]['Espera > 30s']['Total']++;
                                $Dados['ClassCham'][$class_cham]['Espera > 30s']['Total']++;
                                //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera > 30s']['Total']++;
                                //---------------------------------------------------------------------------------------//
                                $Dados['Espera > 30s']['Desistencia-FilA']++;
                                $Dados['Dia'][$dia_array]['Espera > 30s']['Transbordo']++;
                                $Dados['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Transbordo']++;
                                $Dados['Hora'][$hora_array]['Espera > 30s']['Transbordo']++;
                                $Dados['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Transbordo']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Espera > 30s']['Transbordo']++;
                                $Dados['UF'][$UF]['Dia'][$dia_array]['Hora'][$hora_array]['Espera > 30s']['Transbordo']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['Espera > 30s']['Transbordo']++;
                                $Dados['UF'][$UF]['Hora'][$hora_array]['De 15 em 15 minutos'][$minuto_separado]['Espera > 30s']['Transbordo']++;
                                $Dados['UF'][$UF]['Espera > 30s']['Transbordo']++;
                                $Dados['ClassCham'][$class_cham]['Espera > 30s']['Transbordo']++;
                                //$Dados['ClassCham'][$class_cham]['UF'][$UF]['Espera > 30s']['Desistencia-FilA']++;
                            }

                            $x++;
                            $z++;
                        }
                    }
                    break;
			}
		}
		//return $SaidaTst;
		return $Dados;
	}

	function relatorio_filas_estatisticas($Fila, $Inicio, $Fim, $Ligas = false, $MinimoEspera = 0, $Dehoje = "", $tipoPes = 'monit', $tempoCon = 0, $ufs = array()) {
		$Quant['Chamadas Atendidas'] = 0;
		$Quant['Desistencias Fila'] = 0;
		$Quant['Desistencias Desliga'] = 0;
		$Quant['Recebidas'] = 0;
		$Quant['Total desistencias'] = 0;
		$Quant['Desistencias 10s'] = 0;
		$Quant['Desistencias 20s'] = 0;
		$Quant['Desistencias 30s'] = 0;
		$Quant['Desistencias 40s'] = 0;
		$Quant['Espera Maxima'] = 0;
		$Quant['Desistencias Cx'] = 0;
		$Quant['Desistencias Msg'] = 0;
		$Quant['Chamadas Atendidas no prazo'] = 0;
		$Quant['Chamadas Atendidas fora do prazo'] = 0;
		$Quant['Espera'] = 0;
        $Quant['Quantidade Transbordo'] = 0;
		$Tempo['Espera'] = 0;
		$Tempo['Maior espera'] = 0;
		$Tempo['Conversacao'] = 0;
		//----------------------------------------------------------------------
		//Calcula os dados do relatório de estatísticas de fila e envia para o ccrelat.modu.php
		//----------------------------------------------------------------------
		$Chamadas = $this->relatorio_filas_geral($Fila, $Inicio, $Fim, $MinimoEspera, $Dehoje, $tipoPes, $tempoCon);
		//return $Chamadas;
		if ($ufs[0] == "") {
			$Quant['Chamadas Atendidas'] = $Chamadas['Quantidade chamadas atendidas'];
			$Quant['Desistencias Fila'] = $Chamadas['Quantidade Desistencia-FilA'];
			$Quant['Desistencias Desliga'] = $Chamadas['Quantidade Desistencia-Desligamento'];
			$Quant['Recebidas'] = $Chamadas['Quantidade chamadas recebidas'];
			$Quant['Total desistencias'] = $Chamadas['Quantidade desistencias'];
			$Quant['Desistencias 10s'] = $Chamadas['Espera < 10s']['Total'];
			$Quant['Desistencias 20s'] = $Chamadas['Espera < 20s']['Total'];
			$Quant['Desistencias 30s'] = $Chamadas['Espera < 30s']['Total'];
			$Quant['Desistencias 40s'] = $Chamadas['Espera > 30s']['Total'];
			$Quant['Desistencias Cx'] = $Chamadas['Quantidade Desistencia-Caixa'];
			$Quant['Desistencias Msg'] = $Chamadas['Quantidade Desistencia-Msg'];
			$Quant['Espera Maxima'] = $Chamadas['Quantidade chamadas com tempo espera > maximo'];
			$Quant['Chamadas Atendidas no prazo'] = $Chamadas['Quantidade chamadas atendidas com tempo espera <= maximo'];
			$Quant['Chamadas Atendidas fora do prazo'] = $Chamadas['Quantidade chamadas atendidas com tempo espera > maximo'];
            $Quant['Quantidade Transbordo'] = $Chamadas['Quantidade Transbordo'];
			$Tempo['Espera'] = $Chamadas['Tempo em espera']['Total'];
			$Tempo['Maior espera'] = $Chamadas['Maior tempo em espera'];
			$Tempo['Conversacao'] = $Chamadas['Tempo em conversacao'];
		} else {
			foreach ($ufs as $uf) {
				$Quant['Chamadas Atendidas'] += $Chamadas['UF'][$uf]['Quantidade chamadas atendidas'];
				$Quant['Desistencias Fila'] += $Chamadas['UF'][$uf]['Quantidade Desistencia-FilA'];
				$Quant['Desistencias Desliga'] += 0;
				$Quant['Recebidas'] += $Chamadas['UF'][$uf]['Quantidade chamadas recebidas'];
				$Quant['Total desistencias'] += $Chamadas['UF'][$uf]['Quantidade desistencias'];
				$Quant['Desistencias 10s'] += $Chamadas['UF'][$uf]['Espera < 10s']['Total'];
				$Quant['Desistencias 20s'] += $Chamadas['UF'][$uf]['Espera < 20s']['Total'];
				$Quant['Desistencias 30s'] += $Chamadas['UF'][$uf]['Espera < 30s']['Total'];
				$Quant['Desistencias 40s'] += $Chamadas['UF'][$uf]['Espera > 30s']['Total'];
				$Quant['Desistencias Cx'] += $Chamadas['UF'][$uf]['Quantidade Desistencia-Caixa'];
				$Quant['Desistencias Msg'] += $Chamadas['UF'][$uf]['Quantidade Desistencia-Msg'];
				$Quant['Espera Maxima'] += $Chamadas['UF'][$uf]['Quantidade chamadas com tempo espera > maximo'];
				$Quant['Chamadas Atendidas no prazo'] += $Chamadas['UF'][$uf]['Quantidade chamadas atendidas com tempo espera <= maximo'];
				$Quant['Chamadas Atendidas fora do prazo'] += $Chamadas['UF'][$uf]['Quantidade chamadas atendidas com tempo espera > maximo'];
                $Quant['Quantidade Transbordo'] += $Chamadas['UF'][$uf]['Quantidade Transbordo'];
				$Tempo['Espera'] += $Chamadas['UF'][$uf]['Tempo em espera']['Total'];
				$Tempo['Maior espera'] += $Chamadas['UF'][$uf]['Maior tempo em espera'];
				$Tempo['Conversacao'] += $Chamadas['UF'][$uf]['Tempo em conversacao'];
			}
		}
		//----------------------------------------------------------------------
		$Saida = array($Fila, $Tempo, $Quant);
		return $Saida;
	}

	function relatorio_filas_por_dia($Fila, $Inicio, $Fim, $Ligas = false, $MinimoEspera = 0, $Dehoje = "", $tipoPes = 'monit', $tempoCon = 0, $ufs = array()) {
		$Totaldiasmensais = array(31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);

		$Saida = "";

		//Faz os calculos e guarda na variável $Chamadas
		//$Chamadas = $this->relatorio_filas_geral_json($Fila, $Inicio, $Fim, $MinimoEspera, $Dehoje, $tipoPes, $tempoCon);
        $Chamadas = $this->relatorio_filas_geral($Fila, $Inicio, $Fim, $MinimoEspera, $Dehoje, $tipoPes, $tempoCon);

		//Começa a formatar o tempo para poder fazer o for que varre as variáveis
		list($data, $horario) = explode(" ", $Inicio);
		list($ano_d, $mes_d, $dia_d) = explode("-", $data);
		$dia_d = intval($dia_d, 10);
		$mes_d = intval($mes_d, 10);
		$ano_d = intval($ano_d, 10);
		//$Saida = $dia_d;
		if ($ufs[0] == "") {
			$Quant['D'][$dia_d]['Chamadas Atendidas'] = $Chamadas['Dia'][$dia_d]['Quantidade chamadas atendidas'];
			$Quant['D'][$dia_d]['Desistencias Fila'] = $Chamadas['Dia'][$dia_d]['Quantidade Desistencia-FilA'];
			$Quant['D'][$dia_d]['Desistencias Desliga'] = $Chamadas['Dia'][$dia_d]['Quantidade Desistencia-Desligamento'];
			$Quant['D'][$dia_d]['Recebidas'] = $Chamadas['Dia'][$dia_d]['Quantidade chamadas recebidas'];
			$Quant['D'][$dia_d]['Total desistencias'] = $Chamadas['Dia'][$dia_d]['Quantidade desistencias'];
			$Quant['D'][$dia_d]['Desistencias 10s'] = $Chamadas['Dia'][$dia_d]['Espera < 10s']['Total'];
			$Quant['D'][$dia_d]['Desistencias 20s'] = $Chamadas['Dia'][$dia_d]['Espera < 20s']['Total'];
			$Quant['D'][$dia_d]['Desistencias 30s'] = $Chamadas['Dia'][$dia_d]['Espera < 30s']['Total'];
			$Quant['D'][$dia_d]['Desistencias 40s'] = $Chamadas['Dia'][$dia_d]['Espera > 30s']['Total'];
			$Quant['D'][$dia_d]['Desistencias Cx'] = $Chamadas['Dia'][$dia_d]['Quantidade Desistencias-Caixa'];
			$Quant['D'][$dia_d]['Desistencias Msg'] = $Chamadas['Dia'][$dia_d]['Quantidade Desistencias-Msg'];
			$Quant['D'][$dia_d]['Espera Maxima'] = $Chamadas['Dia'][$dia_d]['Quantidade chamadas com tempo espera > maximo'];
			$Quant['D'][$dia_d]['Chamadas Atendidas no prazo'] = $Chamadas['Dia'][$dia_d]['Quantidade chamadas atendidas com tempo espera <= maximo'];
			$Quant['D'][$dia_d]['Chamadas Atendidas fora do prazo'] = $Chamadas['Dia'][$dia_d]['Quantidade chamadas atendidas com tempo espera > maximo'];
            $Quant['D'][$dia_d]['Quantidade Transbordo'] = $Chamadas['Dia'][$dia_d]['Quantidade Transbordo'];
			$Tempo['D'][$dia_d]['Espera'] = $Chamadas['Dia'][$dia_d]['Tempo em espera']['Total'];
			$Tempo['D'][$dia_d]['Maior espera'] = $Chamadas['Dia'][$dia_d]['Maior tempo em espera'];
			$Tempo['D'][$dia_d]['Conversacao'] = $Chamadas['Dia'][$dia_d]['Tempo em conversacao'];
		} else {
			foreach ($ufs as $uf) {
				$Quant['D'][$dia_d]['Chamadas Atendidas'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Quantidade chamadas atendidas'];
				$Quant['D'][$dia_d]['Desistencias Fila'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Quantidade Desistencia-FilA'];
				$Quant['D'][$dia_d]['Desistencias Desliga'] = 0;
				$Quant['D'][$dia_d]['Recebidas'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Quantidade chamadas recebidas'];
				$Quant['D'][$dia_d]['Total desistencias'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Quantidade desistencias'];
				$Quant['D'][$dia_d]['Desistencias 10s'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Espera < 10s']['Total'];
				$Quant['D'][$dia_d]['Desistencias 20s'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Espera < 20s']['Total'];
				$Quant['D'][$dia_d]['Desistencias 30s'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Espera < 30s']['Total'];
				$Quant['D'][$dia_d]['Desistencias 40s'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Espera > 30s']['Total'];
				$Quant['D'][$dia_d]['Desistencias Cx'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Quantidade Desistencias-Caixa'];
				$Quant['D'][$dia_d]['Desistencias Msg'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Quantidade Desistencias-Msg'];
				$Quant['D'][$dia_d]['Espera Maxima'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Quantidade chamadas com tempo espera > maximo'];
				$Quant['D'][$dia_d]['Chamadas Atendidas no prazo'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Quantidade chamadas atendidas com tempo espera <= maximo'];
				$Quant['D'][$dia_d]['Chamadas Atendidas fora do prazo'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Quantidade chamadas atendidas com tempo espera > maximo'];
                $Quant['D'][$dia_d]['Quantidade Transbordo'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Quantidade Transbordo'];
				$Tempo['D'][$dia_d]['Espera'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Tempo em espera']['Total'];
				$Tempo['D'][$dia_d]['Maior espera'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Maior tempo em espera'];
				$Tempo['D'][$dia_d]['Conversacao'] += $Chamadas['UF'][$uf]['Dia'][$dia_d]['Tempo em conversacao'];
			}
		}

		$Saida = array($Fila, $Tempo, $Quant);
		return $Saida;
	}

	function relatorio_filas_por_hora($Fila, $Inicio, $Fim, $Ligas = false, $MinimoEspera = 0, $Dehoje = "", $tipoPes = 'monit', $tempoCon = 0, $ufs = array()) {
		list($data, $horario) = explode(" ", $Inicio);
		list($ano_d, $mes_d, $dia_d) = explode("-", $data);
		list($hora_d, $minuto_d) = explode(":", $horario);
		$dia_df = intval($dia_d, 10);
		$mes_df = intval($mes_d, 10);
		$ano_df = intval($ano_d, 10);
		$hora_df = intval($hora_d, 10);
		$minuto_df = intval($minuto_d, 10);

		list($data, $horario) = explode(" ", $Fim);
		list($ano_a, $mes_a, $dia_a) = explode("-", $data);
		list($hora_a, $minuto_a) = explode(":", $horario);
		$dia_af = intval($dia_a, 10);
		$mes_af = intval($mes_a, 10);
		$ano_af = intval($ano_a, 10);
		$hora_af = intval($hora_a, 10);
		$minuto_af = intval($minuto_a, 10);

		$Chamadas = $this->relatorio_filas_geral($Fila, $Inicio, $Fim, $MinimoEspera, $Dehoje, $tipoPes, $tempoCon);

		//return $Chamadas['Hora'][9]['Desistencias'];
		if ($ufs[0] == "") {
			for ($h = $hora_df; $h <= $hora_af; $h++) {
				$Quant['H'][$h]['Chamadas Atendidas'] = $Chamadas['Hora'][$h]['Quantidade chamadas atendidas'];
				$Quant['H'][$h]['Desistencias Fila'] = $Chamadas['Hora'][$h]['Quantidade Desistencia-FilA'];
				$Quant['H'][$h]['Desistencias Desliga'] = $Chamadas['Hora'][$h]['Quantidade Desistencia-Desligamento'];
				$Quant['H'][$h]['Recebidas'] = $Chamadas['Hora'][$h]['Quantidade chamadas recebidas'];
				$Quant['H'][$h]['Total desistencias'] = $Chamadas['Hora'][$h]['Quantidade desistencias'];
				$Quant['H'][$h]['Desistencias 10s'] = $Chamadas['Hora'][$h]['Espera < 10s']['Total'];
				$Quant['H'][$h]['Desistencias 20s'] = $Chamadas['Hora'][$h]['Espera < 20s']['Total'];
				$Quant['H'][$h]['Desistencias 30s'] = $Chamadas['Hora'][$h]['Espera < 30s']['Total'];
				$Quant['H'][$h]['Desistencias 40s'] = $Chamadas['Hora'][$h]['Espera > 30s']['Total'];
				$Quant['H'][$h]['Desistencias Cx'] = $Chamadas['Hora'][$h]['Quantidade Desistencias-Caixa'];
				$Quant['H'][$h]['Desistencias Msg'] = $Chamadas['Hora'][$h]['Quantidade Desistencias-Msg'];
				$Quant['H'][$h]['Espera Maxima'] = $Chamadas['Hora'][$h]['Quantidade chamadas com tempo espera > maximo'];
				$Quant['H'][$h]['Chamadas Atendidas no prazo'] = $Chamadas['Hora'][$h]['Quantidade chamadas atendidas com tempo espera <= maximo'];
				$Quant['H'][$h]['Chamadas Atendidas fora do prazo'] = $Chamadas['Hora'][$h]['Quantidade chamadas atendidas com tempo espera > maximo'];
                $Quant['H'][$h]['Quantidade Transbordo'] = $Chamadas['Hora'][$h]['Quantidade Transbordo'];
				$Tempo['H'][$h]['Espera'] = $Chamadas['Hora'][$h]['Tempo em espera']['Total'];
				$Tempo['H'][$h]['Maior espera'] = $Chamadas['Hora'][$h]['Maior tempo em espera'];
				$Tempo['H'][$h]['Conversacao'] = $Chamadas['Hora'][$h]['Tempo em conversacao'];
			}
		} else {
			foreach ($ufs as $uf) {
				for ($h = $hora_df; $h <= $hora_af; $h++) {
					$Quant['H'][$h]['Chamadas Atendidas'] += $Chamadas['UF'][$uf]['Hora'][$h]['Quantidade chamadas atendidas'];
					$Quant['H'][$h]['Desistencias Fila'] += $Chamadas['UF'][$uf]['Hora'][$h]['Quantidade Desistencia-FilA'];
					$Quant['H'][$h]['Desistencias Desliga'] += 0;
					$Quant['H'][$h]['Recebidas'] += $Chamadas['UF'][$uf]['Hora'][$h]['Quantidade chamadas recebidas'];
					$Quant['H'][$h]['Total desistencias'] = $Chamadas['UF'][$uf]['Hora'][$h]['Quantidade desistencias'];
					$Quant['H'][$h]['Desistencias 10s'] += $Chamadas['UF'][$uf]['Hora'][$h]['Espera < 10s']['Total'];
					$Quant['H'][$h]['Desistencias 20s'] += $Chamadas['UF'][$uf]['Hora'][$h]['Espera < 20s']['Total'];
					$Quant['H'][$h]['Desistencias 30s'] += $Chamadas['UF'][$uf]['Hora'][$h]['Espera < 30s']['Total'];
					$Quant['H'][$h]['Desistencias 40s'] += $Chamadas['UF'][$uf]['Hora'][$h]['Espera > 30s']['Total'];
					$Quant['H'][$h]['Desistencias Cx'] += $Chamadas['UF'][$uf]['Hora'][$h]['Quantidade Desistencias-Caixa'];
					$Quant['H'][$h]['Desistencias Msg'] += $Chamadas['UF'][$uf]['Hora'][$h]['Quantidade Desistencias-Msg'];
					$Quant['H'][$h]['Espera Maxima'] += $Chamadas['UF'][$uf]['Hora'][$h]['Quantidade chamadas com tempo espera > maximo'];
					$Quant['H'][$h]['Chamadas Atendidas no prazo'] += $Chamadas['UF'][$uf]['Hora'][$h]['Quantidade chamadas atendidas com tempo espera <= maximo'];
					$Quant['H'][$h]['Chamadas Atendidas fora do prazo'] += $Chamadas['UF'][$uf]['Hora'][$h]['Quantidade chamadas atendidas com tempo espera > maximo'];
                    $Quant['H'][$h]['Quantidade Transbordo'] = $Chamadas['UF'][$uf]['Hora'][$h]['Quantidade Transbordo'];
					$Tempo['H'][$h]['Espera'] += $Chamadas['UF'][$uf]['Hora'][$h]['Tempo em espera']['Total'];
					$Tempo['H'][$h]['Maior espera'] += $Chamadas['UF'][$uf]['Hora'][$h]['Maior tempo em espera'];
					$Tempo['H'][$h]['Conversacao'] += $Chamadas['UF'][$uf]['Hora'][$h]['Tempo em conversacao'];
				}
			}
		}
		$Saida = array($Fila, $Tempo, $Quant);

		return $Saida;
	}

	function relatorio_filas_de_15_em_15($Fila, $Inicio, $Fim, $Ligas = false, $MinimoEspera = 0, $Dehoje = "", $tipoPes = 'monit', $tempoCon = 0, $ufs = array()) {
		list($data, $horario) = explode(" ", $Inicio);
		list($ano_d, $mes_d, $dia_d) = explode("-", $data);
		list($hora_d, $minuto_d) = explode(":", $horario);
		$dia_df = intval($dia_d, 10);
		$mes_df = intval($mes_d, 10);
		$ano_df = intval($ano_d, 10);
		$hora_df = intval($hora_d, 10);
		$minuto_df = intval($minuto_d, 10);

		list($data, $horario) = explode(" ", $Fim);
		list($ano_a, $mes_a, $dia_a) = explode("-", $data);
		list($hora_a, $minuto_a) = explode(":", $horario);
		$dia_af = intval($dia_a, 10);
		$mes_af = intval($mes_a, 10);
		$ano_af = intval($ano_a, 10);
		$hora_af = intval($hora_a, 10);
		$minuto_af = intval($minuto_a, 10);

		$Chamadas = $this->relatorio_filas_geral($Fila, $Inicio, $Fim, $MinimoEspera, $Dehoje, $tipoPes, $tempoCon);

		if (($minuto_df >= 0) && ($minuto_df <= 15)) {
			$min_df_tmp = 0;
		}

		if (($minuto_df > 15) && ($minuto_df <= 30)) {
			$min_df_tmp = 15;
		}

		if (($minuto_df > 30) && ($minuto_df <= 45)) {
			$min_df_tmp = 30;
		}

		if (($minuto_df > 45) && ($minuto_df <= 59)) {
			$min_df_tmp = 45;
		}

		if (($minuto_af >= 0) && ($minuto_af <= 15)) {
			$min_af_tmp = 0;
		}

		if (($minuto_af > 15) && ($minuto_af <= 30)) {
			$min_af_tmp = 15;
		}

		if (($minuto_af > 30) && ($minuto_af <= 45)) {
			$min_af_tmp = 30;
		}

		if (($minuto_af > 45) && ($minuto_af <= 59)) {
			$min_af_tmp = 45;
		}

		if ($ufs[0] == "") {
			for ($h = $hora_df; $h <= $hora_af; $h++) {
				if ($h == $hora_df) {
					$min_df_tmp = $minuto_df;
				} else {
					$min_df_tmp = 0;
				}

				if ($h == $hora_af) {
					$min_af_tmp = $minuto_af;
				} else {
					$min_af_tmp = 60;
				}

				for ($m = $min_df_tmp; $m <= $min_af_tmp; $m += 15) {
					$Quant['HM'][$h][$m]['Chamadas Atendidas'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade chamadas atendidas'];
					$Quant['HM'][$h][$m]['Desistencias Fila'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade Desistencia-FilA'];
					$Quant['HM'][$h][$m]['Desistencias Desliga'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade Desistencia-Desligamento'];
					$Quant['HM'][$h][$m]['Recebidas'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade chamadas recebidas'];
					$Quant['HM'][$h][$m]['Total desistencias'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade desistencias'];
					$Quant['HM'][$h][$m]['Desistencias 10s'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Espera < 10s']['Total'];
					$Quant['HM'][$h][$m]['Desistencias 20s'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Espera < 20s']['Total'];
					$Quant['HM'][$h][$m]['Desistencias 30s'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Espera < 30s']['Total'];
					$Quant['HM'][$h][$m]['Desistencias 40s'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Espera > 30s']['Total'];
					$Quant['HM'][$h][$m]['Desistencias Cx'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade Desistencias-Caixa'];
					$Quant['HM'][$h][$m]['Desistencias Msg'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade Desistencias-Msg'];
					$Quant['HM'][$h][$m]['Espera Maxima'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade chamadas com tempo espera > maximo'];
					$Quant['HM'][$h][$m]['Chamadas Atendidas no prazo'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade chamadas atendidas com tempo espera <= maximo'];
					$Quant['HM'][$h][$m]['Chamadas Atendidas fora do prazo'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade chamadas atendidas com tempo espera > maximo'];
                    $Quant['HM'][$h][$m]['Quantidade Transbordo'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Transbordo'];
					$Tempo['HM'][$h][$m]['Espera'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Tempo em espera']['Total'];
					$Tempo['HM'][$h][$m]['Maior espera'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Maior tempo em espera'];
					$Tempo['HM'][$h][$m]['Conversacao'] = $Chamadas['Hora'][$h]['De 15 em 15 minutos'][$m]['Tempo em conversacao'];
				}
			}
		} else {
			foreach ($ufs as $uf) {
				for ($h = $hora_df; $h <= $hora_af; $h++) {
					if ($h == $hora_df) {
						$min_df_tmp = $minuto_df;
					} else {
						$min_df_tmp = 0;
					}

					if ($h == $hora_af) {
						$min_af_tmp = $minuto_af;
					} else {
						$min_af_tmp = 60;
					}

					for ($m = $min_df_tmp; $m <= $min_af_tmp; $m += 15) {
						$Quant['HM'][$h][$m]['Chamadas Atendidas'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade chamadas atendidas'];
						$Quant['HM'][$h][$m]['Desistencias Fila'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade Desistencia-FilA'];
						$Quant['HM'][$h][$m]['Desistencias Desliga'] += 0;
						$Quant['HM'][$h][$m]['Recebidas'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade chamadas recebidas'];
						$Quant['HM'][$h][$m]['Total desistencias'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade desistencias'];
						$Quant['HM'][$h][$m]['Desistencias 10s'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Espera < 10s']['Total'];
						$Quant['HM'][$h][$m]['Desistencias 20s'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Espera < 20s']['Total'];
						$Quant['HM'][$h][$m]['Desistencias 30s'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Espera < 30s']['Total'];
						$Quant['HM'][$h][$m]['Desistencias 40s'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Espera > 30s']['Total'];
						$Quant['HM'][$h][$m]['Desistencias Cx'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade Desistencias-Caixa'];
						$Quant['HM'][$h][$m]['Desistencias Msg'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade Desistencias-Msg'];
						$Quant['HM'][$h][$m]['Espera Maxima'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade chamadas com tempo espera > maximo'];
						$Quant['HM'][$h][$m]['Chamadas Atendidas no prazo'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade chamadas atendidas com tempo espera <= maximo'];
						$Quant['HM'][$h][$m]['Chamadas Atendidas fora do prazo'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Quantidade chamadas atendidas com tempo espera > maximo'];
                        $Quant['HM'][$h][$m]['Quantidade Transbordo'] = $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Transbordo'];
						$Tempo['HM'][$h][$m]['Espera'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Tempo em espera']['Total'];
						$Tempo['HM'][$h][$m]['Maior espera'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Maior tempo em espera'];
						$Tempo['HM'][$h][$m]['Conversacao'] += $Chamadas['UF'][$uf]['Hora'][$h]['De 15 em 15 minutos'][$m]['Tempo em conversacao'];
					}
				}
			}
		}

		$Saida = array($Fila, $Tempo, $Quant);

		return $Saida;
	}

	function relatorio_filas_dimensionamento($Fila, $Inicio, $Fim, $Ligas = false, $MinimoEspera = 0, $Dehoje = "", $tipoPes = 'monit', $tempoCon = 0, $ufs) {
		list($data, $horario) = explode(" ", $Inicio);
		list($ano_d, $mes_d, $dia_d) = explode("-", $data);
		list($hora_d, $minuto_d) = explode(":", $horario);
		$dia_df = intval($dia_d, 10);
		$mes_df = intval($mes_d, 10);
		$ano_df = intval($ano_d, 10);
		$hora_df = intval($hora_d, 10);
		$minuto_df = intval($minuto_d, 10);

		list($data, $horario) = explode(" ", $Fim);
		list($ano_a, $mes_a, $dia_a) = explode("-", $data);
		list($hora_a, $minuto_a) = explode(":", $horario);
		$dia_af = intval($dia_a, 10);
		$mes_af = intval($mes_a, 10);
		$ano_af = intval($ano_a, 10);
		$hora_af = intval($hora_a, 10);
		$minuto_af = intval($minuto_a, 10);

		$Chamadas = $this->relatorio_filas_geral($Fila, $Inicio, $Fim, $MinimoEspera, $Dehoje, $tipoPes, $tempoCon);
		//$Chamadas = $this->relatorio_filas_geral_json($Fila, $Inicio, $Fim, $MinimoEspera, $Dehoje, $tipoPes, $tempoCon);
		//return $Chamadas['Hora'][9]['Desistencias'];
		if ($ufs[0] == "") {
			for ($h = $hora_df; $h <= $hora_af; $h++) {
				$Quant['DH'][$dia_df][$h]['Recebidas'] = $Chamadas['Dia'][$dia_df]['Hora'][$h]['Quantidade chamadas recebidas'];
			}
		} else {
			foreach ($ufs as $uf) {
				for ($h = $hora_df; $h <= $hora_af; $h++) {
					$Quant['DH'][$dia_df][$h]['Recebidas'] += $Chamadas['UF'][$uf]['Dia'][$dia_df]['Hora'][$h]['Quantidade chamadas recebidas'];
				}
			}
		}
		/*for($h = $hora_df; $h <= $hora_af; $h++){
			            $Quant['DH'][$dia_df][$h]['Recebidas'] = $Chamadas['Dia'][$dia_df]['Hora'][$h]['Quantidade chamadas recebidas'];
		*/

		$Saida = array($Fila, $Tempo, $Quant);

		return $Saida;
	}

	function relatorio_agentes_chamadas_atendidas($Agente, $Inicio, $Fim, $Dehoje, $tempoMinCon, $eliminaRamais, $filtroNumero, $tipoPes) {
		$Chamadas = $this->relatorio_agentes($Agente, $Inicio, $Fim, false, $Dehoje, $tempoMinCon, $eliminaRamais, $filtroNumero, $tipoPes);
		//$Chamadas = $this->relatorio_agentes_json($Agente, $Inicio, $Fim, false, $Dehoje, $tempoMinCon, $eliminaRamais, $filtroNumero, $tipoPes);
		//return $Chamadas[3]['Chamadas atendidas'];
		/* As informações vem nesse formato abaixo:
	         * $Detalhes['Chamadas atendidas'][$cont]['Numero'] = $Res[$x]['numero'];
	         * $Detalhes['Chamadas atendidas'][$cont]['Data'] = $Res[$x]['diahora'];
	         * $Detalhes['Chamadas atendidas'][$cont]['Tempo em conversacao'] = $AConsiderar - $Insta;
*/
		for ($i = 0; $i < count($Chamadas[3]['Chamadas atendidas']); $i++) {
			//Formata a data e a hora
			list($data, $horario) = explode(" ", $Chamadas[3]['Chamadas atendidas'][$i]['Data']);
			list($ano, $mes, $dia) = explode("-", $data);
			list($hora, $lixo) = explode(".", $horario);
			$data = $dia . "/" . $mes . "/" . $ano;

			$Ligacoes['Atendida'][$i][0] = $data;
			$Ligacoes['Atendida'][$i][1] = $hora;
			$Ligacoes['Atendida'][$i][2] = $Chamadas[3]['Chamadas atendidas'][$i]['Numero'];
			$Ligacoes['Atendida'][$i][3] = $Chamadas[3]['Chamadas atendidas'][$i]['Tempo em conversacao'];
			$Ligacoes['Atendida'][$i][4] = $Chamadas[3]['Chamadas atendidas'][$i]['Fila'];
		}
		return $Ligacoes;
	}

	function relatorio_agentes_chamadas_efetuadas($Agente, $Inicio, $Fim, $Dehoje, $tempoMinCon, $eliminaRamais, $filtroNumero, $tipoPes) {
		$Chamadas = $this->relatorio_agentes($Agente, $Inicio, $Fim, false, $Dehoje, $tempoMinCon, $eliminaRamais, $filtroNumero, $tipoPes);
		//$Chamadas = $this->relatorio_agentes_json($Agente, $Inicio, $Fim, false, $Dehoje, $tempoMinCon, $eliminaRamais, $filtroNumero, $tipoPes);
		/*
	         * Os dados vem no formato abaixo:
	         * $Detalhes['Chamadas efetuadas'][$cont2]['Numero'] = $Res[$x]['numero'];
	         * $Detalhes['Chamadas efetuadas'][$cont2]['Data'] = $Res[$x]['diahora'];
	         * $Detalhes['Chamadas efetuadas'][$cont2]['Tempo em conversacao'] = $AConsiderar - $Insta;
			 * $Detalhes['Chamadas efetuadas'][$cont2]['Status'] = "Atendida";
*/

		$Ligacoes['Com sucesso'] = $Chamadas[2]['Fazendo chamada externa']['Atendendo'];
		$Ligacoes['Sem sucesso'] = $Chamadas[2]['Fazendo chamada externa']['Nao Atendidas'];
		$Ligacoes['Total'] = $Ligacoes['Com sucesso'] + $Ligacoes['Sem sucesso'];

		for ($i = 0; $i < count($Chamadas[3]['Chamadas efetuadas']); $i++) {
			list($data, $horario) = explode(" ", $Chamadas[3]['Chamadas efetuadas'][$i]['Data']);
			list($ano, $mes, $dia) = explode("-", $data);
			list($hora, $lixo) = explode(".", $horario);
			$data = $dia . "/" . $mes . "/" . $ano;

			$Ligacoes['Efetuada'][$i][0] = $data;
			$Ligacoes['Efetuada'][$i][1] = $hora;
			$Ligacoes['Efetuada'][$i][2] = $Chamadas[3]['Chamadas efetuadas'][$i]['Numero'];
			$Ligacoes['Efetuada'][$i][3] = $Chamadas[3]['Chamadas efetuadas'][$i]['Tempo em conversacao'];
			$Ligacoes['Efetuada'][$i][4] = $Chamadas[3]['Chamadas efetuadas'][$i]['Status'];
		}
		return $Ligacoes;
	}

	function lista_codcontas_relatorio() {
		$Pes = "Select * from vm50_codigo_conta";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		$Saida = "";
		for ($x = 0; $x < count($Res); $x++) {
			$Saida .= '<option value="' . $Res[$x]['codigo'] . '">' . $Res[$x]['codigo'] . " - " . $Res[$x]['nome'] . '</option>';
		}
		return $Saida;
	}

	function lista_discador_relatorio() {
		$Saida = "";
		$Pes = "Select * from campaign ORDER BY name";
		$Res = $this->BdDiscador->executa_query_com_saida($Pes);
		$Saida = "";
		for ($x = 0; $x < count($Res); $x++) {
			$Saida .= '<option value="' . $Res[$x]['id'] . '">' . $Res[$x]['name'] . '</option>';
		}
		return $Saida;
	}

	function relatorio_agentes_tempo_livre($Agente, $Inicio, $Fim, $Dehoje, $tempoMinCon, $filtroNumero, $tipoPes) {
		//Exemplo de como vem o array do relatório
		//$Tempo['Livre'][$livreC]['Hora'] = $Insta;

		//$Livre = $this->relatorio_agentes_json($Agente, $Inicio, $Fim, false, $Dehoje,  $tempoMinCon, '0', $filtroNumero, $tipoPes);
		$Livre = $this->relatorio_agentes($Agente, $Inicio, $Fim, false, $Dehoje, $tempoMinCon, '0', $filtroNumero, $tipoPes);

		for ($i = 0; $i < count($Livre[3]['Acumulado']); $i++) {
			list($Dados[$i]['Horario'], $lixo) = explode(".", $Livre[3]['Acumulado'][$i]['Inicio']);
			$Dados[$i]['Duracao'] = $Livre[3]['Acumulado'][$i]['Duracao'];
			if (substr($Livre[3]['Acumulado'][$i]['Estado'], 0, 8) == "Efetuado") {
				list($Dados[$i]['Estado'], $Dados[$i]['Servico']) = explode(":", $Livre[3]['Acumulado'][$i]['Estado']);
			} else {
				$Dados[$i]['Estado'] = $Livre[3]['Acumulado'][$i]['Estado'];
				$Dados[$i]['Servico'] = $Livre[3]['Acumulado'][$i]['Servico'];
			}

			$Dados[$i]['Numero'] = $Livre[3]['Acumulado'][$i]['Numero'];
		}
		return $Dados;
	}

	function relatorio_membros_fila($Fila, $Inicio, $Fim, $Ligas = false, $MinimoEspera = 0, $Dehoje = "", $tipoPes = 'monit') {
		$Pes = "SELECT a.*, f.id as id_fila, f.nome as nome_fila FROM " . $this->TabelaA . " AS a INNER JOIN " . $this->TabelFA . " AS fa ON a.id = fa.agente INNER JOIN " . $this->TabelaF . " AS f on f.id = fa.fila WHERE f.nome = '" . $Fila . "' ORDER BY a.login";
		$MembrosFilas = $this->Bd->executa_query_com_saida($Pes);
		return $MembrosFilas;
	}

	/*****************************************************
		*	      Parte dos relatorios do Discador			 *
	*/
	function pesquisa_campanha_pelo_id($id) {
		$Res = array();
		$Pes = "Select * From campaign Where id = " . $id;
		$Res = $this->BdDiscador->executa_query_com_saida($Pes);
		return $Res;
	}

	/*****************************************************
		*	      Parte dos relatorios do Discador			 *
	*/
	function relatorio_campanhas($idCampanha, $dia_d, $dia_a, $NuDisc = "", $EvDisc = "") {
		//Inicializa variáveis
		$Detalhes = array();
		$Quantidade = array();
		$AgentesAux = array();
		$Quantidade['Processadas']['Geral']++;
		$Quantidade['Atendidas']['Destinatario e Operador'] = 0;
		$Quantidade['Nao atendidas']['Operador'] = 0;
		$Quantidade['Nao atendidas']['Geral'] = 0;
		$Quantidade['Nao atendidas']['Timeout'] = 0;
		$Quantidade['Nao atendidas']['Sem atendimento'] = 0;
		$Quantidade['Nao atendidas']['Ocupado'] = 0;
		$Quantidade['Nao atendidas']['Incompleto ou nao existe'] = 0;
		$Quantidade['Nao efetuadas']['Falta de tronco'] = 0;
		$Quantidade['Reagendamentos'] = 0;
		$Quantidade['Canceladas']['Limitação de tentativa pelo vdt'] = 0;
		$Quantidade['Canceladas']['Pelo CRM'] = 0;
		$Quantidade['Canceladas']['Evento pelo CRM'] = 0;
		$Quantidade['Canceladas']['Reagendamento pelo CRM'] = 0;
		$Quantidade['Canceladas']['Desconectadas'] = 0;
		$a = 0;
		$b = 0;

		//trata o numero discador e o evento discador
		if (!is_numeric($NuDisc)) {
			$NuDisc = '';
		}

		if (!is_numeric($EvDisc)) {
			$EvDisc = '';
		}

		//Cria o SQL
		$Pes = "SELECT 	ms.*, ";
		$Pes .= "sv.host AS server_host, ";
		$Pes .= "sv.port AS server_port, ";
		$Pes .= "mt.name AS message_type, ";
		$Pes .= "ag.name AS agent_name, ";
		$Pes .= "ac.name AS message_action_name, ";
		$Pes .= "ct.code AS customer_code, ";
		$Pes .= "ph.channel AS phone_channel, ";
		$Pes .= "ph.prefix AS phone_prefix, ";
		$Pes .= "ph.phone AS phone_number, ";
		$Pes .= "st.name AS source_name, ";
		$Pes .= "cp.name AS campaign_name, ";
		$Pes .= "sc.action_id AS source_action_id ";
		$Pes .= "FROM message_send AS ms ";
		$Pes .= "INNER JOIN server AS sv ";
		$Pes .= "ON ms.server_id = sv.id ";
		$Pes .= "INNER JOIN message_type AS mt ";
		$Pes .= "ON ms.type_id = mt.id ";
		$Pes .= "INNER JOIN agent AS ag ";
		$Pes .= "ON ms.agent_id = ag.id ";
		$Pes .= "INNER JOIN message_action AS ac ";
		$Pes .= "ON ms.action_id = ac.id ";
		$Pes .= "INNER JOIN customer AS ct ";
		$Pes .= "ON ms.customer_id = ct.id ";
		$Pes .= "INNER JOIN customer_phone AS ph ";
		$Pes .= "ON ms.phone_id = ph.id ";
		$Pes .= "INNER JOIN source AS sc ";
		$Pes .= "ON ms.source_id = sc.id ";
		$Pes .= "INNER JOIN source_type AS st ";
		$Pes .= "ON sc.source_type_id = st.id ";
		$Pes .= "INNER JOIN campaign AS cp ";
		$Pes .= "ON sc.campaign_id = cp.id ";
		$Pes .= "WHERE sc.campaign_id = " . $idCampanha . " ";
		$Pes .= "AND timestamp >= '" . $dia_d . "' ";
		$Pes .= "AND timestamp <= '" . $dia_a . "' ";
		if ($NuDisc != "") {
			$Pes .= "AND ph.phone LIKE '%" . $NuDisc . "%' ";
		}

		if ($EvDisc != "") {
			$Pes .= "AND ct.code = " . $EvDisc . " ";
		}

		$Pes .= "ORDER BY timestamp";
		$Res = $this->BdDiscador->executa_query_com_saida($Pes);

		$PesAg = "SELECT login, nome FROM vm50_agentes";
		$ResAg = $this->Bd->executa_query_com_saida($PesAg);
		$totalAg = count($ResAg);
		for ($i = 0; $i < $totalAg; $i++) {
			$AgentesAux[$ResAg[$i]["login"]] = $ResAg[$i]["nome"];
		}

		if (count($Res) > 0) {
			//Percorre os send's
			$total = count($Res);
			for ($i = 0; $i < $total; $i++) {
				$id_send = $Res[$i]['id'];

				//Busca por uma resposta na tabela message_recv
				$Pes = "SELECT 	mr.*, ";
				$Pes .= "sv.host AS server_recv_host, ";
				$Pes .= "sv.port AS server_recv_port, ";
				$Pes .= "mt.name AS message_type, ";
				$Pes .= "ag.name AS agent_recv, ";
				$Pes .= "ma.name AS action_recv, ";
				$Pes .= "mr.extra_id AS extra_id ";
				$Pes .= "FROM message_recv AS mr ";
				$Pes .= "INNER JOIN server AS sv ";
				$Pes .= "ON mr.server_id = sv.id ";
				$Pes .= "INNER JOIN message_type AS mt ";
				$Pes .= "ON mr.type_id = mt.id ";
				$Pes .= "INNER JOIN agent AS ag ";
				$Pes .= "ON mr.agent_id = ag.id ";
				$Pes .= "INNER JOIN message_action AS ma ";
				$Pes .= "ON mr.action_id = ma.id ";
				$Pes .= "WHERE message_send_id = " . $id_send . " ";
				//$Pes.= "AND action_id = 4";
				$Pes .= "LIMIT 10";
				$Res2 = $this->BdDiscador->executa_query_com_saida($Pes);

				if (count($Res2) > 0) {
					//Organiza as respostas do message_recv
					$msg_recv = array();
					for ($j = 0; $j < count($Res2); $j++) {
						$msg_recv[$Res2[$j]["action_recv"]]["id"] = $Res2[$j]["id"];
						$msg_recv[$Res2[$j]["action_recv"]]["timestamp"] = $Res2[$j]["timestamp"];
						$msg_recv[$Res2[$j]["action_recv"]]["server_recv_host"] = $Res2[$j]["server_recv_host"];
						$msg_recv[$Res2[$j]["action_recv"]]["server_recv_port"] = $Res2[$j]["server_recv_port"];
						$msg_recv[$Res2[$j]["action_recv"]]["message_type"] = $Res2[$j]["message_type"];
						$msg_recv[$Res2[$j]["action_recv"]]["agent_recv"] = $Res2[$j]["agent_recv"];
						$msg_recv[$Res2[$j]["action_recv"]]["action_recv"] = $Res2[$j]["action_recv"];
						$msg_recv[$Res2[$j]["action_recv"]]["extra_id"] = $Res2[$j]["extra_id"];
						$msg_recv[$Res2[$j]["action_recv"]]["reason"] = $Res2[$j]["reason"];
					}

					//Começa os tratamentos para divisão dos Originates
					$timestamp = strtotime($msg_recv["OriginateResponse"]["timestamp"]);
					$msg_recv["OriginateResponse"]["timestamp"] = date('d/m/Y H:i:s', $timestamp);
					$Detalhes['Geral'][$a]['Data e hora'] = $msg_recv["OriginateResponse"]["timestamp"];
					$Detalhes['Geral'][$a]['Campanha'] = $Res[$i]['campaign_name'];
					$Detalhes['Geral'][$a]['Evento'] = $Res[$i]['customer_code'];
					$Detalhes['Geral'][$a]['Telefone'] = "(" . $Res[$i]['phone_prefix'] . ") " . $Res[$i]['phone_number'];
					switch ($Res[$i]['source_name']) {
						case "campanha":{
								$Detalhes['Geral'][$a]['Tipo'] = "Mailing";
							}break;
						case "reg-user":{
								$Detalhes['Geral'][$a]['Tipo'] = "Reagendamento de usuário";
								$Quantidade['Reagendamentos']++;

								if ($msg_recv["AgentCalled"]) {
									$Detalhes['Reagendamentos'][$b]['Agente'] = $msg_recv["AgentCalled"]["agent_recv"] . ' - ' . $AgentesAux[$msg_recv["AgentCalled"]["agent_recv"]];
								} else {
									$Detalhes['Reagendamentos'][$b]['Agente'] = '-';
								}

								$Detalhes['Reagendamentos'][$b]['Data e hora'] = $msg_recv["OriginateResponse"]["timestamp"];
								$Detalhes['Reagendamentos'][$b]['Campanha'] = $Res[$i]['campaign_name'];
								$Detalhes['Reagendamentos'][$b]['Evento'] = $Res[$i]['customer_code'];
								$Detalhes['Reagendamentos'][$b]['Telefone'] = "(" . $Res[$i]['phone_prefix'] . ") " . $Res[$i]['phone_number'];
								$Detalhes['Reagendamentos'][$b]['Tipo'] = "Reagendamento de usuário";
								$b++;
							}break;
						case "reg-any":{
								$Detalhes['Geral'][$a]['Tipo'] = "Reagendamento de campanha";
								$Quantidade['Reagendamentos']++;

								if ($msg_recv["AgentCalled"]) {
									$Detalhes['Reagendamentos'][$b]['Agente'] = $msg_recv["AgentCalled"]["agent_recv"] . ' - ' . $AgentesAux[$msg_recv["AgentCalled"]["agent_recv"]];
								} else {
									$Detalhes['Reagendamentos'][$b]['Agente'] = '-';
								}

								$Detalhes['Reagendamentos'][$b]['Data e hora'] = $msg_recv["OriginateResponse"]["timestamp"];
								$Detalhes['Reagendamentos'][$b]['Campanha'] = $Res[$i]['campaign_name'];
								$Detalhes['Reagendamentos'][$b]['Evento'] = $Res[$i]['customer_code'];
								$Detalhes['Reagendamentos'][$b]['Telefone'] = "(" . $Res[$i]['phone_prefix'] . ") " . $Res[$i]['phone_number'];
								$Detalhes['Reagendamentos'][$b]['Tipo'] = "Reagendamento de campanha";
								$b++;
							}break;
						default:{
								$Detalhes['Geral'][$a]['Tipo'] = "Desconhecido";
							}break;
					}

					//Define o status do originate.
					//Ligação atendida pelo destinatário e não atendida pelo operador.
					if ($Res[0]['agent_recv'] != '') {
						$Detalhes['Geral'][$a]['Agente'] = "";
						$Detalhes['Geral'][$a]['Status'] = "Ligação atendida pelo destinatário e não atendida pelo operador.";
						$Quantidade['Nao atendidas']['Operador']++;
					} else {
						if ($msg_recv["AgentCalled"]) {
							$Detalhes['Geral'][$a]['Agente'] = $msg_recv["AgentCalled"]["agent_recv"] . ' - ' . $AgentesAux[$msg_recv["AgentCalled"]["agent_recv"]];
						} else {
							$Detalhes['Geral'][$a]['Agente'] = '-';
						}

						switch ($msg_recv["OriginateResponse"]["reason"]) {

							//Número discado é inexistente ou está incompleto
							case 0:{
									$Detalhes['Geral'][$a]['Status'] = "Número inexistente ou incompleto.";
									$Quantidade['Processadas']['Geral']++;
									$Quantidade['Nao atendidas']['Geral']++;
									$Quantidade['Nao atendidas']['Incompleto ou nao existe']++;
								}break;

							//Destinatário não atendeu a ligação
							case 1:{
									$Detalhes['Geral'][$a]['Status'] = "Número ocupado.";
									$Quantidade['Processadas']['Geral']++;
									$Quantidade['Nao atendidas']['Geral']++;
									$Quantidade['Nao atendidas']['Ocupado']++;
								}break;

							//Número ocupado
							case 2:{
									$Detalhes['Geral'][$a]['Status'] = "Número ocupado.";
									$Quantidade['Processadas']['Geral']++;
									$Quantidade['Nao atendidas']['Geral']++;
									$Quantidade['Nao atendidas']['Ocupado']++;
								}break;

							//Ligação não atendida e desistida por timeout
							case 3:{
									$Detalhes['Geral'][$a]['Status'] = "Não atendida. Estourou o tempo de timeout.";
									$Quantidade['Processadas']['Geral']++;
									$Quantidade['Nao atendidas']['Geral']++;
									$Quantidade['Nao atendidas']['Timeout']++;
								}break;

							//Ligação atendida pelo destinatário e pelo operador
							case 4:{
									if ($msg_recv["AgentCalled"]) {
										$Detalhes['Geral'][$a]['Status'] = "Atendida.";
										$Quantidade['Atendidas']['Destinatario e Operador']++;
									} else {
										$Detalhes['Geral'][$a]['Status'] = "Ligação atendida pelo destinatário e não atendida pelo operador.";
										$Quantidade['Nao atendidas']['Operador']++;
									}
									$Quantidade['Processadas']['Geral']++;
								}break;

							//Número discado está ocupado
							case 5:{
									$Detalhes['Geral'][$a]['Status'] = "Número ocupado.";
									$Quantidade['Processadas']['Geral']++;
									$Quantidade['Nao atendidas']['Geral']++;
									$Quantidade['Nao atendidas']['Ocupado']++;
								}break;

							//Tentou enviar a ligação mais estava sem linha disponível
							case 8:{
									$Detalhes['Geral'][$a]['Status'] = "Congestionado. Sem tronco disponível.";
									$Quantidade['Processadas']['Geral']++;
									$Quantidade['Nao efetuadas']['Falta de tronco']++;
								}break;
						}
					}
					$a++;
				} else {
					//Quando da algum erro no servidor, um Originate não tem o OriginateResponse...
					$Detalhes['Geral'][$a]['Data e hora'] = $Res[$i]['timestamp'];
					$Detalhes['Geral'][$a]['Campanha'] = $Res[$i]['campaign_name'];
					$Detalhes['Geral'][$a]['Evento'] = $Res[$i]['customer_code'];
					$Detalhes['Geral'][$a]['Telefone'] = "(" . $Res[$i]['phone_prefix'] . ") " . $Res[$i]['phone_number'];
					$Detalhes['Geral'][$a]['Tipo'] = "Desconhecido";
					$Detalhes['Geral'][$a]['Status'] = "Erro no servidor.";
					$a++;
				}
			}
		}

		$Saida[0] = $Detalhes;
		$Saida[1] = $Quantidade;
		/*************************************
			 * Saida[0] = Detalhes de ligações   *
		*/
		return $Saida;
	}

	function relatorio_cancelamentos_campanhas($idCampanha, $dia_d, $dia_a, $NuDisc = "", $EvDisc = "") {
		$Detalhes['Geral'][$a]['Data e hora'] = "";
		$Detalhes['Geral'][$a]['Tipo'] = "";
		$Detalhes['Geral'][$a]['Campanha'] = "";
		$Detalhes['Geral'][$a]['Evento'] = "";
		$Detalhes['Geral'][$a]['Telefone'] = "";
		$Quantidade['Canceladas']['Pelo CRM'] = 0;
		$Quantidade['Canceladas']['Limitação de tentativa pelo vdt'] = 0;
		$Quantidade['Canceladas']['Evento pelo CRM'] = 0;
		$Quantidade['Canceladas']['Reagendamento pelo CRM'] = 0;
		$Quantidade['Canceladas']['Desconectadas'] = 0;

		$a = 0;

		//Começa o calculo do cancelamento
		$Pes = "SELECT cl.*, ";
		$Pes .= "		ct.name AS cancel_name, ";
		$Pes .= "		cm.code AS customer_code, ";
		$Pes .= "		ca.name AS campaign_name, ";
		$Pes .= "		mt.name AS reason_name ";
		$Pes .= "		cp.channel AS phone_channel, ";
		$Pes .= "		cp.prefix AS phone_prefix, ";
		$Pes .= "		cp.phone AS phone_number ";
		$Pes .= "FROM cancel AS cl ";
		$Pes .= "INNER JOIN cancel_type AS ct ";
		$Pes .= "ON cl.cancel_type_id = ct.id ";
		$Pes .= "INNER JOIN customer AS cm ";
		$Pes .= "ON cl.customer_id = cm.id ";
		$Pes .= "INNER JOIN campaign AS ca ";
		$Pes .= "ON cl.campaign_id = ca.id ";
		$Pes .= "INNER JOIN message_type AS mt ";
		$Pes .= "ON cl.reason = mt.id ";
		$Pes .= "INNER JOIN customer_phone AS cp ";
		$Pes .= "ON cl.customer_phone_id = cp.id ";
		$Pes .= "WHERE cl.campaign_id = " . $idCampanha . " ";
		$Pes .= "AND timestamp >= '" . $dia_d . "' ";
		$Pes .= "AND timestamp <= '" . $dia_a . "' ";
		//if($NuDisc != "") $Pes .= "AND cp.phone LIKE '%".$NuDisc."%' ";
		if ($EvDisc != "") {
			$Pes .= "AND cm.code = " . $EvDisc . " ";
		}

		$Pes .= "ORDER BY cl.timestamp";
		$Res = $this->BdDiscador->executa_query_com_saida($Pes);

		//Varre os cancelamentos
		for ($i = 0; $i < count($Res); $i++) {
			$Detalhes['Geral'][$a]['Data e hora'] = $Res[$i]['timestamp'];
			$Detalhes['Geral'][$a]['Campanha'] = $Res[$i]['campaign_name'];
			$Detalhes['Geral'][$a]['Evento'] = $Res[$i]['customer_code'];
			if ($Res[$i]['phone_number'] != 0) {
				$Detalhes['Geral'][$a]['Telefone'] = "(" . $Res[$i]['phone_prefix'] . ") " . $Res[$i]['phone_number'];
			} else {
				$Detalhes['Geral'][$a]['Telefone'] = '-';
			}

			switch ($Res[$i]['cancel_name']) {
				case "url-mailing":{
						$Detalhes['Geral'][$a]['Tipo'] = "Cancelamento de evento pelo CRM";
						$Quantidade['Canceladas']['Pelo CRM']++;
						$Quantidade['Canceladas']['Evento pelo CRM']++;
					}break;
				case "url-reg":{
						$Detalhes['Geral'][$a]['Tipo'] = "Cancelamento de reagendamento pelo CRM";
						$Quantidade['Canceladas']['Pelo CRM']++;
						$Quantidade['Canceladas']['Reagendamento pelo CRM']++;
					}break;
				case "window-call":{
						$Detalhes['Geral'][$a]['Tipo'] = "Cancelamento de limitação de tentativas pelo VDT";
						$Quantidade['Canceladas']['Limitação de tentativa pelo vdt']++;
					}break;
				default:{
						$Detalhes['Geral'][$a]['Tipo'] = "Desconhecido";
					}break;
			}

			$a++;
		}

		$Saida[0] = $Quantidade;
		$Saida[1] = $Detalhes;
		return $Saida;
	}

	function filas_para_relatorio_ps() {
		$sql = "SELECT pseudonimo FROM vm50_filas WHERE mostrarrelplansimp = 't'";
		$res = $this->Bd->executa_query_com_saida($sql);
		return $res;
	}

	function filas_para_relatorio_p() {
		$sql = "SELECT pseudonimo FROM vm50_filas";
		$res = $this->Bd->executa_query_com_saida($sql);
		return $res;
	}

	function verifica_se_logou_hoje($agente) {
		$pes = "SELECT agente, situacao FROM vm50_relatorios_cc_hoje WHERE diahora >= '" . date("Y-m-d") . " 00:00' AND oque LIKE 'Login' AND agente LIKE '%" . $agente . "%' LIMIT 1";
		//$pes = "SELECT agente FROM vm50_relatorios_cc_hoje WHERE diahora >= '2014-04-24 00:00' AND agente LIKE '".$agente."%' LIMIT 1";
		$res = $this->Bd->executa_query_com_saida($pes);
		return $res;
	}

	function lista_grupos_filas() {
		$sql = "SELECT * FROM vm50_grupos";
		$res = $this->Bd->executa_query_com_saida($sql);
		return $res;
	}

	function lista_filas_pelo_grupo($idGrupo) {
		$sql = "SELECT f.nome FROM vm50_filas as f INNER JOIN vm50_grupos_filas as gf ON f.id = gf.fila WHERE gf.grupo = " . $idGrupo;
		return $sql;
		$res = $this->Bd->executa_query_com_saida($sql);
		return $res;
	}

	function lista_grupo_pelo_agente_relatorio($agente) {
		list($login, $pseudonimo) = explode("-", $agente);
		$sql = "SELECT grupo FROM vm50_agentes WHERE login = '" . $login . "'";
		$res = $this->Bd->executa_query_com_saida($sql);
		return $res[0]['grupo'];
	}

	function lista_qualificacoes_relatorio($inicio, $fim, $tipo = "option") {
		$Saida = "";
		$Pes = "SELECT classificacao FROM vm50_chamadas_classificadas WHERE data >= '" . $inicio . "' AND data <= '" . $fim . "' GROUP BY classificacao ORDER BY classificacao";
		$Res = $this->Bd->executa_query_com_saida($Pes);
		if ($tipo == "option") {
			$Saida = "";
			for ($x = 0; $x < count($Res); $x++) {
				$Saida .= '<option value="' . $Res[$x]['classificacao'] . '">' . $Res[$x]['classificacao'] . '</option>';
			}
			return $Saida;
		} else if ($tipo == "array") {
			$Saida = array();
			for ($x = 0; $x < count($Res); $x++) {
				$Saida[] = $Res[$x]['classificacao'];
			}
			return $Saida;
		}
	}

	function gerar_relatorio_qualificacoes($inicio, $fim, $qualificacao) {
		$sql = "SELECT * FROM vm50_chamadas_classificadas WHERE classificacao LIKE '" . $qualificacao . "' AND data >= '" . $inicio . "' AND data <= '" . $fim . "' ORDER BY id";
		$dados = $this->Bd->executa_query_com_saida($sql);

		for ($i = 0; $i < count($dados); $i++) {
			$saida['Detalhes'][$dados[$i]['id']] = $dados[$i];
		}
		return $saida;
	}

	function gerar_relatorio_qualificacoes_por_agente($inicio, $fim, $agente) {
		$sql = "SELECT * FROM vm50_chamadas_classificadas WHERE atendente LIKE '" . $agente . "%' AND data >= '" . $inicio . "' AND data <= '" . $fim . "' ORDER BY data";
		//return $sql;
		$dados = $this->Bd->executa_query_com_saida($sql);
		$saida = array();
		for ($i = 0; $i < count($dados); $i++) {
			$saida["quantidade"]["tipo"][$dados[$i]["classificacao"]]++;
			$saida["quantidade"]["total"]++;
		}
		$saida["detalhes"] = $dados;
		return $saida;
	}

	function pega_duracao($id_ligacao){
		$Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, diahora, id, agente, fila, numero, oque, ligacao FROM vm50_relatorios_cc WHERE ligacao = '".$id_ligacao."' ORDER BY id, diahora";
		$Res = $this->Bd->executa_query_com_saida($Pes);

		$inicioDuracao = 0;
		$duracao = 0;
		$SaidaTst = "";

		$valido = false;

		for($i = 0; $i < count($Res); $i++){
			$oque_anterior = $Res[$i-1]['oque'];
			$oque_atual = $Res[$i]['oque'];
			$oque_proximo = $Res[$i+1]['oque'];
			$SaidaTst .= $Res[$i]['oque']."<br/>";

			//Verifica se começou a conversacao
			switch($oque_atual){
				case "Em conversa&ccedil;&atilde;o":
					if($oque_anterior == "Chamando" || $oque_anterior == "Entrada") $inicioDuracao = $Res[$i]['diahorario'];
					$valido = true;
				break;
			}
			if($i == count($Res)-1) $duracao = $Res[$i]['diahorario'] - $inicioDuracao;
		}
		if(!$valido) $duracao = 0;
		return $duracao;
	}

    function verificar_transbordo($id_ligacao, $fila){
        $sql = "SELECT oque FROM vm50_relatorios_cc WHERE ligacao = '".$id_ligacao."' AND oque LIKE 'Transbordo-%' AND fila LIKE '".$fila."'";
        $res = $this->Bd->executa_query_com_saida($sql);

        if(count($res) > 0) return $res[0]['oque'];
        else return false;
    }
}
?>
