<?php
/**************************************************************
 * Nome:    CCGraf
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2009-05-12 (V1.0.0)
 * Descr.:  Grafico
 *************************************************************/


/**************************************************************
  Area dos includes
 *************************************************************/
  $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
  include_once($DirRaiz.'config.php');
  include_once($DirRaiz.'config.cc.php');
  $Modulo = $DirCCen;
  include_once($DirRaiz.$Modulo.$DirClass.'monitor.class.php');
  include_once($DirRaiz.$DirModul.'geral.modu.php');


/**************************************************************
  Definicao de variaveis
 *************************************************************/
  $Moni  = new Monitores;  // Objeto monitor
  $L_var = $_POST;         // Recebe as variaveis do formulario


/**************************************************************
  Programa Principal
 *************************************************************/
  if ($L_var['tg']>1) return false;
  for ($x=0; $x<$L_var['tg']; $x++) $LAgentes[$x] = $L_var['g'.$x];
  $Saida = grafico_agentes_hora($LAgentes,$L_var['d'],$L_var['a'],$L_var['tp']);
  return $Saida;



/**************************************************************
  Funcao grafico_agentes_hora
 *************************************************************/
 function grafico_agentes_hora($Agentes,$Per_d, $Per_a, $Tipo_per) {
   global $Moni;
   $dataAtual = date("d/m/Y");
   $hoje = 0;
   $Totaldiasmensais=array(31,29,31,30,31,30,31,31,30,31,30,31);
   //Arrumada as datas para timestamp
   list ($data_d, $horario_d) = explode (' ', $Per_d); list ($dia_d, $mes_d, $ano_d) = explode ('/', $data_d); list ($hora_d, $minuto_d) = explode (':', $horario_d);
   if($dataAtual == $data_d){
	 $hoje = 1;
   }
   list ($data_a, $horario_a) = explode (' ', $Per_a); list ($dia_a, $mes_a, $ano_a) = explode ('/', $data_a); list ($hora_a, $minuto_a) = explode (':', $horario_a);
   if(($dataAtual != $data_a) || ($hoje != 1)){
	 $hoje = 0;
   }
   $Auy_d = mktime($hora_d, $minuto_d, 0, $mes_d, $dia_d, $ano_d); // $Aux_d = $ano_d.'-'.$mes_d.'-'.$dia_d.' '.$hora_d.':'.$minuto_d;
   $Auy_a = mktime($hora_a, $minuto_a, 0, $mes_a, $dia_a, $ano_a); // $Aux_a = $ano_a.'-'.$mes_a.'-'.$dia_a.' '.$hora_a.':'.$minuto_a;
   if (!($Auy_d) || ($Auy_d<0)) return "Perodo invlido";
   if (!($Auy_a) || ($Auy_a<0)) return "Perodo invlido";
   if ($Auy_d > $Auy_a) return "Perodo invlido";
   $Tabela=$Tab1=$Tab2=array();
   $Saida  = '';
   for ($F=0; $F<count($Agentes); $F++) {
     $anos=$ano_d;
     while ($anos<=$ano_a) {
       $meses=$mes_d;
       while ( ($meses<=$mes_a) && ($anos<=$ano_a) ) {
         if ($meses==$mes_d) $dia_d1 = $dia_d;
         else $dia_d1 = '01';
         if ($meses==$mes_a) $dia_a1 = $dia_a;
         else $dia_a1 = $Totaldiasmensais[$meses-1];
         for ($dias=$dia_d1; $dias<=$dia_a1; $dias++) {
           if ($Tipo_per=="T") {
             if (($meses==$mes_d) && ($dias==$dia_d)) {
               $hora_ini = $hora_d; $minuto_ini = $minuto_d;
             } else {
               $hora_ini = '00'; $minuto_ini = '00';
             }
             if (($meses==$mes_a) && ($dias==$dia_a)) {
               $hora_fim = $hora_a; $minuto_fim = $minuto_a;
             } else {
               $hora_fim = '23'; $minuto_fim = '59';
             }
           } else {
             $hora_ini = $hora_d; $minuto_ini = $minuto_d;
             $hora_fim = $hora_a; $minuto_fim = $minuto_a;
           }
           $Aux_d = $ano_d.'-'.$meses.'-'.$dias.' '.$hora_ini.':'.$minuto_ini;
           $Aux_a = $ano_a.'-'.$meses.'-'.$dias.' '.$hora_fim.':'.$minuto_fim;
           //$Tabela = $Moni->relatorio_agentes($Agentes[$F],$Aux_d,$Aux_a);
           if($hoje == 0) $Tabela = $Moni->relatorio_agentes($Agentes[$F],$Aux_d,$Aux_a,true,'','relat');
           if($hoje == 1) $Tabela = $Moni->relatorio_agentes($Agentes[$F],$Aux_d,$Aux_a,true,'hoje','monit');
           if (!$Tabela) continue;
           if ($dias==$dia_d) $Tab1 = $Tabela;
           else {
             if (is_array($Tabela)) {
               foreach ($Tabela as $ChaveA => $TabA) {
                 if (is_array($TabA)) {
                   foreach ($TabA as $ChaveB => $TabB) {
                     if (is_array($TabB)) {
                       foreach ($TabB as $ChaveC => $TabC) {
                         if (is_array($TabC)) {
                           foreach ($TabC as $ChaveD => $TabD) {
                             if (is_array($TabD)) {
                               foreach ($TabD as $ChaveE => $TabE) {
                                 if (is_numeric($TabE)) $Tab1[$ChaveA][$ChaveB][$ChaveC][$ChaveD][$ChaveE] += $TabE;
                               }
                             } else if (is_numeric($TabD)) $Tab1[$ChaveA][$ChaveB][$ChaveC][$ChaveD] += $TabD;
                           }
                         } else if (is_numeric($TabC)) $Tab1[$ChaveA][$ChaveB][$ChaveC] += $TabC;
                       }
                     } else if (is_numeric($TabB)) $Tab1[$ChaveA][$ChaveB] += $TabB;
                   }
                 }
               }
             }
           }
         }
         $meses++;
         if ($meses==13) {
           $meses=1;
           $anos++;
         }
       }
       $anos++;
     }
     $Tab2[] = array($Agentes[$F],$Tab1);
   }
   $Saida = monta_grafico_agentes_horas($Agentes[0],$Tab1,$hora_ini,$hora_fim,$Per_d, $Per_a);
   return $Saida;
 }


/**************************************************************
  Funcao monta_grafico_agentes_horas
 *************************************************************/
 function monta_grafico_agentes_horas($Agentes,$Dados,$hora_ini,$hora_fim,$Per_d, $Per_a) {
   $Moni_Hora_inicial = $hora_ini;
   $Moni_Hora_final = $hora_fim;
   if (!$Agentes) return "Erro";
   $Campo = array();
   if ($Dados) {
     $Maior = 0;
     $Tempo = $Dados[1];
     $Aux   = $Tempo['Total DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fazendo chamada externa']['Atendendo']+$Tempo['Consulta-Realizadas']['Atendendo']+$Tempo['Consulta-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo'];
     $Aux   = $Tempo['DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo'];
     $TTota = $Aux+$Tempo['Fazendo chamada externa']['Atendendo']+$Tempo['Livre']+$Tempo['Em Pausa']+$Tempo['Consulta-Realizadas']['Atendendo']+$Tempo['Consulta-Atendidas']['Atendendo']+$Tempo['Monitorando PA']+$Tempo['Fazendo chamada externa']['Chamando'] + $Tempo['Consulta-Realizadas']['Chamando']+$Tempo['DDR']['Chamando']+$Tempo['Fila']['Chamando']+$Tempo['Transfer-FILA-Atendidas']['Chamando']+$Tempo['Transfer-DDR-Atendidas']['Chamando'];
     $TTota = $Aux+$Tempo['Fazendo chamada externa']['Atendendo']+$Tempo['Livre']+$Tempo['Em Pausa']+$Tempo['Consulta-Realizadas']['Atendendo']+$Tempo['Consulta-Atendidas']['Atendendo']+$Tempo['Monitorando PA']+$Tempo['Fazendo chamada externa']['Chamando']+$Tempo['Consulta-Realizadas']['Chamando']+$Tempo['DDR']['Chamando']+$Tempo['Fila']['Chamando']+$Tempo['Transfer-FILA-Atendidas']['Chamando']+$Tempo['Transfer-DDR-Atendidas']['Chamando'];
     if ($TTota==0) {
      $Var00 = $Var01 = $Var02 = $Var03 = $Var04 = $Var05 = 0;
     } else {
       $Var00 = $Aux/$TTota;
       $Var01 = $Tempo['Fazendo chamada externa']['Atendendo']/$TTota;
       $Var02 = $Tempo['Livre']/$TTota;
       $Var03 = $Tempo['Em Pausa']/$TTota;
       $Var04 = ($Tempo['Consulta-Realizadas']['Atendendo']+$Tempo['Consulta-Atendidas']['Atendendo'])/$TTota;
       $Var05 = $Tempo['Monitorando PA']/$TTota;
       $Var06 = ($Tempo['Fazendo chamada externa']['Chamando']+$Tempo['Consulta-Realizadas']['Chamando'])/$TTota;
       $Var07 = ($Tempo['DDR']['Chamando']+$Tempo['Fila']['Chamando']+$Tempo['Transfer-FILA-Atendidas']['Chamando']+$Tempo['Transfer-DDR-Atendidas']['Chamando'])/$TTota;
     }
     $Campo[] = array('Atendendo ligaes',$Var00);
     $Campo[] = array('Fazendo ligaes',  $Var01);
     $Campo[] = array('Livre',             $Var02);
     $Campo[] = array('Em Pausa',          $Var03);
     $Campo[] = array('Consulta',          $Var04);
     $Campo[] = array('Monitoramento',     $Var05);
     $Campo[] = array('Chamando destino',  $Var06);
     $Campo[] = array('PA tocando',        $Var07);
     $Titulo  = 'Tempos do agente '.$Agentes;
     $Titulo .= "\nPerodo: ".substr($Per_d,0,16)." a ".substr($Per_a,0,16);
     $Legenda = array();
     for ($x=0; $x<count($Campo); $x++) $Legenda[] = $Campo[$x][0].": ".sprintf("%01.1f",($Campo[$x][1]*100))."%";
     $Arquivo = gera_pizza($Titulo,$Campo,$Maior,"grafico_agentes_tempo.jpg",$Legenda);
   }
   return $Arquivo;
 }

?>
