<?php
/**************************************************************
 * Nome:    Contact Center
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-01-25 (V1.0.1)
 * Descr.:  Gera as variaveis argumento que compoem as telas de
 *          Contact Center. 
 *************************************************************/
  //ini_set("display_errors",1);


/**************************************************************
  Area dos includes
 *************************************************************/
 $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
 include_once($DirRaiz.'config.php');
 include_once($DirRaiz.'config.cc.php');
 include_once($DirRaiz.$DirClass.'usuario.class.php');
 include_once($DirRaiz.$DirCCen.$DirClass.'monitor.class.php');
 include_once($DirRaiz.$DirCCen.$DirClass.'agentes.class.php');
 include_once($DirRaiz.$DirModul.'sessao.modu.php');
 include_once($DirRaiz.$DirModul.'geral.modu.php');
 $Modulo = $DirCCen;


/**************************************************************
  Nao deixa a pagina ser chamada diretamente. Tem que ter uma
  sessao aberta.
 *************************************************************/
 verifica_sessao();


/**************************************************************
  Definicao de variaveis
 *************************************************************/
 $Moni = new Monitores; // Objeto monitor
 $Agen = new Agentes;   // Objeto agente
 $Scr = '';             // Javascript


/**************************************************************
  Programa principal
 *************************************************************/
 //Javascript
 $_SESSION['Argumentos']['script']  = '<script type="text/javascript" src="'.$LinkRaiz.$DirJavas.'geral.js"></script>'."\n";
 $_SESSION['Argumentos']['script'] .= '<script type="text/javascript" src="'.$LinkRaiz.$DirJavas.'ajax.js"></script>'."\n";
 $_SESSION['Argumentos']['script'] .= '<script type="text/javascript" src="'.$LinkRaiz.$Modulo.$DirJavas.'cc.js"></script>'."\n";
// $Scr = '<script type="text/javascript" src="'.$LinkRaiz.$DirJavas.'legenda.js"></script>'."\n";
// $_SESSION['Argumentos']['script'] .= $Scr;
 return;

/**************************************************************
  Funcao lista_mlogin
  O tipo pode ser:
  href   = saida em <a href...
 *************************************************************/
 function lista_mlogin($Tipo,$Ativo=''){
   global $Agen;
   $Mlo = $Agen->lista_metodo_logins($Ativo);
   if (!$Mlo) return $Agx;
   $Saida = '';
   if ($Tipo=='href'){
     $Saida .= '<input type="radio" name="mlog" id="mloga" value="1" class="escol"';
     if ($Mlo=='1') $Saida .= ' checked';
     $Saida .= '> AgentLogin<br />'."\n";
//     $Saida .= '<input type="radio" name="mlog" id="mlogb" value="2" class="escol"';
//     if ($Mlo=='2') $Saida .= ' checked';
//     $Saida .= '> AgentCallbacklogin<br />'."\n";
     $Saida .= '<input type="radio" name="mlog" id="mlogc" value="3" class="escol"';
     if ($Mlo=='3') $Saida .= ' checked';
     $Saida .= '> Addqueuemember</p>'."\n";
   }
   return $Saida;
 }


/**************************************************************
  Funcao altera_mlogin
 *************************************************************/
 function altera_mlogin($Dados) {
   global $Agen;
   $Saida = "";
   $Saida = $Agen->altera_metodo_logins($Dados['mlog']);
   return $Saida;
 }


/**************************************************************
  Funcao lista_grupo
  O tipo pode ser:
  href   = saida em <a href...
  option = saida em <option...
 *************************************************************/
 function lista_grupo($Tipo,$Ativo='',$Identif=''){
    global $Agen;

    $Agx = $Agen->lista_grupos($Ativo);
    if (!$Agx) return $Agx;
    $Age = $Agx[0];
    $Fil = $Agx[1];
    $Saida = '';
    if ($Tipo=='href'){
        for ($x=0; $x<count($Age); $x++){
            $i = $Age[$x]['id'];
            $pausasR = listar_pausas_grupo($i, "id_pausa");
            $qualificacoes = listar_qualificacoes_pelo_grupo($i, "id_qualificacao");
            $Saida .= '<a href="#" id="gru_'.sprintf('%09d',$i).'" onclick="mostra_grupo('.$i.')" class="listagem">'.$Age[$x]['nome'].'</a><br/>'."\n";
            $Saida .= '<input type="hidden" name="tipo_painel_'.sprintf('%09d',$i).'" id="tipo_painel_'.sprintf('%09d',$i).'" value="'.$Age[$x]['tipo_painel_pa'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="iepa_'.sprintf('%09d',$i).'" id="iepa_'.sprintf('%09d',$i).'" value="'.$Age[$x]['ignorarentradapausaauto'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="irpa_'.sprintf('%09d',$i).'" id="irpa_'.sprintf('%09d',$i).'" value="'.$Age[$x]['ignorarretiradapausaauto'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="epau_'.sprintf('%09d',$i).'" id="epau_'.sprintf('%09d',$i).'" value="'.$Age[$x]['entrarpausaauto'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="paau_'.sprintf('%09d',$i).'" id="paau_'.sprintf('%09d',$i).'" value="'.$Age[$x]['pausaautomatica'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="tepa_'.sprintf('%09d',$i).'" id="tepa_'.sprintf('%09d',$i).'" value="'.$Age[$x]['tempodepausa'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="clac_'.sprintf('%09d',$i).'" id="clac_'.sprintf('%09d',$i).'" value="'.$Age[$x]['classifica_chamadas'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="hewe_'.sprintf('%09d',$i).'" id="hewe_'.sprintf('%09d',$i).'" value="'.$Age[$x]['habenviowebservice'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="pce_'.sprintf('%09d',$i).'" id="pce_'.sprintf('%09d',$i).'" value="'.$Age[$x]['popup_chamadas_entrantes'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="nsa_'.sprintf('%09d',$i).'" id="nsa_'.sprintf('%09d',$i).'" value="'.$Age[$x]['minsaida'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="xsa_'.sprintf('%09d',$i).'" id="xsa_'.sprintf('%09d',$i).'" value="'.$Age[$x]['maxsaida'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="nin_'.sprintf('%09d',$i).'" id="nin_'.sprintf('%09d',$i).'" value="'.$Age[$x]['mininter'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="xin_'.sprintf('%09d',$i).'" id="xin_'.sprintf('%09d',$i).'" value="'.$Age[$x]['maxinter'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="ndd_'.sprintf('%09d',$i).'" id="ndd_'.sprintf('%09d',$i).'" value="'.$Age[$x]['minddr']  .'"/>'."\n";
            $Saida .= '<input type="hidden" name="xdd_'.sprintf('%09d',$i).'" id="xdd_'.sprintf('%09d',$i).'" value="'.$Age[$x]['maxddr']  .'"/>'."\n";
            $Saida .= '<input type="hidden" name="nfi_'.sprintf('%09d',$i).'" id="nfi_'.sprintf('%09d',$i).'" value="'.$Age[$x]['minfila'] .'"/>'."\n";
            $Saida .= '<input type="hidden" name="xfi_'.sprintf('%09d',$i).'" id="xfi_'.sprintf('%09d',$i).'" value="'.$Age[$x]['maxfila'] .'"/>'."\n";
            $Saida .= '<input type="hidden" name="xli_'.sprintf('%09d',$i).'" id="xli_'.sprintf('%09d',$i).'" value="'.$Age[$x]['maxlivre'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="xes_'.sprintf('%09d',$i).'" id="xes_'.sprintf('%09d',$i).'" value="'.$Age[$x]['maxesddr'].'"/>'."\n";

            $Saida .= '<input type="hidden" name="xec_'.sprintf('%09d',$i).'" id="xec_'.sprintf('%09d',$i).'" value="'.$Age[$x]['maxeco'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="xmo_'.sprintf('%09d',$i).'" id="xmo_'.sprintf('%09d',$i).'" value="'.$Age[$x]['maxmon'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="nsd_'.sprintf('%09d',$i).'" id="nsd_'.sprintf('%09d',$i).'" value="'.$Age[$x]['minsad'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="xsd_'.sprintf('%09d',$i).'" id="xsd_'.sprintf('%09d',$i).'" value="'.$Age[$x]['maxsad'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="nat_'.sprintf('%09d',$i).'" id="nat_'.sprintf('%09d',$i).'" value="'.$Age[$x]['minate'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="xat_'.sprintf('%09d',$i).'" id="xat_'.sprintf('%09d',$i).'" value="'.$Age[$x]['maxate'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="adt_'.sprintf('%09d',$i).'" id="adt_'.sprintf('%09d',$i).'" value="'.$Age[$x]['adient'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="ads_'.sprintf('%09d',$i).'" id="ads_'.sprintf('%09d',$i).'" value="'.$Age[$x]['adisai'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="nco_'.sprintf('%09d',$i).'" id="nco_'.sprintf('%09d',$i).'" value="'.$Age[$x]['mincon'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="xco_'.sprintf('%09d',$i).'" id="xco_'.sprintf('%09d',$i).'" value="'.$Age[$x]['maxcon'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="cmf_'.sprintf('%09d',$i).'" id="cmf_'.sprintf('%09d',$i).'" value="'.$Age[$x]['consultar_membros_filas'].'"/>'."\n";
            $Saida .= '<input type="hidden" name="par_'.sprintf('%09d',$i).'" id="par_'.sprintf('%09d',$i).'" value=\''.json_encode($pausasR).'\'/>'."\n";
            $Saida .= '<input type="hidden" name="qua_'.sprintf('%09d',$i).'" id="qua_'.sprintf('%09d',$i).'" value=\''.json_encode($qualificacoes).'\'/>'."\n";
            $Saida .= '<input type="hidden" name="epq_'.sprintf('%09d',$i).'" id="epq_'.sprintf('%09d',$i).'" value=\''.$Age[$x]['entrar_pausa_qualificacao'].'\'/>'."\n";
        }
        $Ifi = -1;
        $x   = 0;
        $Fim = count($Fil);
        while ($x<count($Fil)) {
            if ($Ifi != $Fil[$x]['id']) {
                if ($Ifi > -1) $Saida .= '"/>'."\n";
                $Ifi = $Fil[$x]['id'];
                $Saida .= '<input type="hidden" name="gfi_'.sprintf('%09d',$Ifi).'" id="gfi_'.sprintf('%09d',$Ifi).'" value="';
            }
            $Saida .= $Fil[$x]['fila'].',';
            $x++;
        }
        if ($Fim>0) $Saida .= '"/>'."\n";
    }
    elseif  ($Tipo=='option') {
        $Saida .= '<option value=" "> </option>';
        for ($x=0; $x<count($Age); $x++){
            $i = $Age[$x]['id'];
            $Saida .= '<option value="'.$Age[$x]['nome'].'">'.$Age[$x]['id'].'-'.$Age[$x]['nome'].'</option>';
        }
    }
    elseif  ($Tipo=='option2') {
        for ($x=0; $x<count($Age); $x++){
            $i = $Age[$x]['id'];
            $Saida .= '<option value="'.$Age[$x]['nome'].'">'.$Age[$x]['id'].'-'.$Age[$x]['nome'].'</option>';
        }
    }
    elseif  ($Tipo=='option3') {
        for ($x=0; $x<count($Age); $x++){
            $i = $Age[$x]['id'];
            $Saida .= '<option value="'.$Age[$x]['nome'].'">'.$Age[$x]['nome'].'</option>';
        }
    }
    elseif($Tipo=='javascript'){
        for ($x=0; $x<count($Age); $x++){
            $Saida .= "    o = document.createElement('option');\n\n";
            $Saida .= "    o.text  = '".$Age[$x]['nome']."';";
            $Saida .= " o.value = '".$Age[$x]['nome']."';\n";
            $Saida .= "    try { Grupo.add(o, null); }\n";
            $Saida .= "    catch (e) { Grupo.add(o); }\n\n";
        }		
    } 
    elseif ($Tipo=='javascript2') {
        for ($x=0; $x<count($Age); $x++){
            $Saida .= $Age[$x]['nome'].',';
        }
    }
    return $Saida;
 }


/**************************************************************
  Funcao apaga_grupo
 *************************************************************/
 function apaga_grupo($Dados){
   global $Agen;
   $Saida = "";
   if (!isset($Dados['identif'])) $Saida = false;
   else $Saida = $Agen->apaga_grupos($Dados['identif']);
   return $Saida;
 }


/**************************************************************
  Funcao altera_grupo
 *************************************************************/
 function altera_grupo($Dados) {
	global $Agen;
	$Saida = "";
	if (!isset($Dados['identif'])) $Saida = "Faltou";
	else {
		if($Dados["entPausaAuto"]=="f"){
			$Dados["tipoPausa"] = "";
			$Dados["tempoPausa"] = 0;
		}
		if($Dados["minate"]=="") $Dados["minate"] = 0;
        if($Dados["habEnvioWebservice"]=="") $Dados["habEnvioWebservice"] = "false";
        else $Dados["habEnvioWebservice"] = "true";
		if($Dados["pppChamEnt"]=="") $Dados["pppChamEnt"] = "false";
		else $Dados["pppChamEnt"] = "true";
		if($Dados["consultarMembrosFilas"]=="") $Dados["consultarMembrosFilas"] = "false";
		else $Dados["consultarMembrosFilas"] = "true";
		$Saida = $Agen->altera_grupos($Dados['identif'],$Dados['nome'],$Dados["tipoPainel"],$Dados["ignorarEntradaAutPausa"],$Dados["ignorarRetiradaAutPausa"],$Dados["entPausaAuto"],$Dados["tipoPausa"],$Dados["tempoPausa"],$Dados["classCham"],$Dados["pppChamEnt"],$Dados['minsai'],$Dados['maxsai'],$Dados['minint'],$Dados['maxint'],$Dados['minddr'],$Dados['maxddr'],$Dados['minfil'],$Dados['maxfil'],$Dados['maxliv'],$Dados['maxedd'],$Dados['maxeco'],$Dados['maxmon'],$Dados['minsad'],$Dados['maxsad'],$Dados['minate'],$Dados['maxate'],$Dados['adient'],$Dados['adisai'],$Dados['mincon'],$Dados['maxcon'],$Dados["consultarMembrosFilas"],$Dados["entPausaQualificacao"],$Dados["habEnvioWebservice"]);
		//return $Saida;
		if ($Saida) {
			$Filas = $Dados['filasr'];
			if (count($Filas) > 0) $Saida = $Agen->altera_grupos_filas($Dados['nome'],$Filas);
		}
		if($Saida){
			$qualificacoes = $Dados["qualr"];
			$Saida = alterar_grupos_qualificacoes($Dados["identif"], $qualificacoes);
		}
		if($Saida){
			$pausas = $Dados["pausasr"];
			$Saida = alterar_pausas_grupo($Dados['identif'], $pausas);
		}
	}
	return $Saida;
 }


/**************************************************************
  Funcao insere_grupo
 *************************************************************/
 function insere_grupo($Dados){
	global $Agen;
	$Saida = "";
	if (!isset($Dados['identif'])) $Saida = false;
	else {
		if($Dados["entPausaAuto"]=="f"){
			$Dados["tipoPausa"] = "";
			$Dados["tempoPausa"] = 0;
		}
		if($Dados["consultarMembrosFilas"]=="") $Dados["consultarMembrosFilas"] = "false";
		else $Dados["consultarMembrosFilas"] = "true";
        if($Dados["habEnvioWebservice"]=="") $Dados["habEnvioWebservice"] = "false";
        else $Dados["habEnvioWebservice"] = "true";
		$Saida = $Agen->insere_grupos($Dados['nome'],$Dados["ignorarEntradaAutPausa"],$Dados["ignorarRetiradaAutPausa"],$Dados["entPausaAuto"],$Dados["tipoPausa"],$Dados["tempoPausa"],$Dados["classCham"],$Dados['minsai'],$Dados['maxsai'],$Dados['minint'],$Dados['maxint'],$Dados['minddr'],$Dados['maxddr'],$Dados['minfil'],$Dados['maxfil'],$Dados['maxliv'],$Dados['maxedd'],$Dados['maxeco'],$Dados['maxmon'],$Dados['minsad'],$Dados['maxsad'],$Dados['minate'],$Dados['maxate'],$Dados['adient'],$Dados['adisai'],$Dados['mincon'],$Dados['maxcon'],$Dados["consultarMembrosFilas"],$Dados["entPausaQualificacao"],$Dados["habEnvioWebservice"]);
		$idGrupo = $Agen->listar_grupo_pelo_nome($Dados["nome"]);
        $idGrupo = $idGrupo[0]["id"];
		//return $Saida;
		if ($Saida) {
			$Filas = $Dados['filasr'];
			if (count($Filas) > 0) $Saida = $Agen->altera_grupos_filas($Dados['nome'],$Filas);
		}
		if($Saida){
			$qualificacoes = $Dados["qualr"];
			if(count($qualificacoes) > 0) $Saida = alterar_grupos_qualificacoes($idGrupo, $qualificacoes);
		}
		if($Saida){
			$pausas = $Dados["pausasr"];
			$Saida = alterar_pausas_grupo($idGrupo, $pausas);
		}
	}
	$pausas = $Dados["pausasr"];
	$Saida = alterar_pausas_grupo($idGrupo, $pausas);
	return $Saida;
 }

function alterar_pausas_grupo($idGrupo, $pausas){
    global $Agen;
    $saida = false;
    if($Agen->deletar_pausas_grupo($idGrupo)){
        if(!is_array($pausas)) return true;
        foreach($pausas as $valor){
            $Agen->inserir_pausa_grupo($idGrupo, $valor);
        }
        $saida = true;
    }
    return $saida;
}

function alterar_grupos_qualificacoes($idGrupo, $qualificacoes){
	global $Agen;
	$saida = true;
	if($Agen->deletar_grupos_qualificacoes($idGrupo)){
		$saida = true;
        if(is_array($qualificacoes) || is_object($qualificacoes)){
    		foreach($qualificacoes as $valor){
    			if(!$Agen->inserir_qualificacao_grupo($idGrupo, $valor)){
    				$saida = false;
    				break;
    			}
    		}
        }
	} else $saida = false;
	return $saida;
}


/**************************************************************
  Funcao escolhe_agente
 *************************************************************/
 function escolhe_agente(){
   global $Moni;
   $Age = $Moni->lista_agentes();
   $Saida = '';
   foreach ($Age as $Chave => $Valor) {
     $Saida .= '<option value="'.$Valor.'">'.$Valor.'-'.$Chave.'</option>'."\n";
   }
   return $Saida;
 }


/**************************************************************
  Funcao escolhe_agente_relator
 *************************************************************/
 function escolhe_agente_relator(){
   global $Agen;
   $Agx = $Agen->lista_agentes();
   $Age = $Agx[0];
   $Saida = '';
   if ($Age) {
     for ($x=0; $x<count($Age); $x++) $Saida .= '<option value="'.$Age[$x]['login'].'-'.$Age[$x]['nome'].'">'.$Age[$x]['login'].'-'.$Age[$x]['nome'].'</option>'."\n";
   }
   return $Saida;
 }


/**************************************************************
  Funcao escolhe_grupo_relator
 *************************************************************/
 function escolhe_grupo_relator(){
   global $Moni;
   $Age = $Moni->lista_agentes();
   $Saida = '';
   if ($Age) {
     for ($x=0; $x<count($Age); $x++) $Saida .= '<option value="'.$Age[$x]['login'].'-'.$Age[$x]['nome'].'">'.$Age[$x]['login'].'-'.$Age[$x]['nome'].'</option>'."\n";
   }
   return $Saida;
 }


/**************************************************************
  Funcao foto_agente
 *************************************************************/
 function foto_agente($Numero){
   global $LinkRaiz, $DirCCen, $DirImage;
   $Arquivo = $LinkRaiz.$DirCCen.$DirImage.$Numero."jpg";
   if (file_exists($Arquivo)) $Saida = $Arquivo;
   else $Saida = false;
   return $Saida;
 }


/**************************************************************
Funcao lista_agente
O tipo pode ser:
href   = saida em <a href...
option = saida em <option...
*************************************************************/
function lista_agente($Tipo,$Ativo='',$ListaRamal=null,$Login=''){
    global $Agen;
    $Agx = $Agen->lista_agentes($Ativo);
    $Age = $Agx[0];
    $Gru = $Agx[1];
    $Loi = $Agx[2];
    $Tur = $Agx[3];
    $Ramal = $Agx[4];
    $Saida = '';
    $TbLoginMonir = $Agen->lista_tb_login_grupo();
    $ListaTbLogin = $Agen->lista_tb_login_grupo_agente($Login);

    if ($Tipo=='href'){
        for ($x=0; $x<count($Age); $x++){
            $i = $Age[$x]['id'];
            $Saida .= '<a href="#" id="age_'.sprintf('%09d',$i).'" onclick="mostra_agente('.$i.')" class="listagem">'.$Age[$x]['login'].' - '.$Age[$x]['pseudonimo'].'</a><br/>'."\n";
            $Saida .= '<input type="hidden" name="pse_'.sprintf('%09d',$i).'" id="pse_'.sprintf('%09d',$i).'" value="'.$Age[$x]['nome'].'"/>';
            $Saida .= '<input type="hidden" name="log_'.sprintf('%09d',$i).'" id="log_'.sprintf('%09d',$i).'" value="'.$Age[$x]['login'].'"/>';
            $Saida .= '<input type="hidden" name="sen_'.sprintf('%09d',$i).'" id="sen_'.sprintf('%09d',$i).'" value="'.$Age[$x]['senha'].'"/>';
            $Saida .= '<input type="hidden" name="grp_'.sprintf('%09d',$i).'" id="grp_'.sprintf('%09d',$i).'" value="'.$Age[$x]['grupo'].'"/>';
            $Saida .= '<input type="hidden" name="hr1_'.sprintf('%09d',$i).'" id="hr1_'.sprintf('%09d',$i).'" value="'.$Age[$x]['horario1'].'"/>';
            $Saida .= '<input type="hidden" name="hr2_'.sprintf('%09d',$i).'" id="hr2_'.sprintf('%09d',$i).'" value="'.$Age[$x]['horario2'].'"/>';
            $Saida .= '<input type="hidden" name="fnc_'.sprintf('%09d',$i).'" id="fnc_'.sprintf('%09d',$i).'" value="'.$Age[$x]['funcai'].'"/>';
            $Saida .= '<input type="hidden" name="cnt_'.sprintf('%09d',$i).'" id="cnt_'.sprintf('%09d',$i).'" value="'.$Age[$x]['contexto'].'"/>';
            $Saida .= '<input type="hidden" name="npa_'.sprintf('%09d',$i).'" id="npa_'.sprintf('%09d',$i).'" value="'.$Age[$x]['notificapausaauto'].'"/>';
            $Saida .= '<input type="hidden" name="ndd_'.sprintf('%09d',$i).'" id="ndd_'.sprintf('%09d',$i).'" value="'.$Age[$x]['notificadepoisde'].'"/>';
            $Saida .= '<input type="hidden" name="nldd_'.sprintf('%09d',$i).'" id="nldd_'.sprintf('%09d',$i).'" value="'.$Age[$x]['notificalivredepoisde'].'"/>';
            $Saida .= '<input type="hidden" name="sipa_'.sprintf('%09d',$i).'" id="sipa_'.sprintf('%09d',$i).'" value="'.$Age[$x]['setar_ip_astman'].'"/>';
            $Saida .= '<input type="hidden" name="vipa_'.sprintf('%09d',$i).'" id="vipa_'.sprintf('%09d',$i).'" value="'.$Age[$x]['ip_astman'].'"/>';
        }
        
        // Grupos complementares
        $Agr = -1;
        $x   = 0;
        $Fim = count($Gru);

        while ($x<count($Gru)) {
            if ($Agr != $Gru[$x]['id']) {
                if ($Agr > -1) $Saida .= '"/>'."\n";
                
                $Agr = $Gru[$x]['id'];
                $Saida .= '<input type="hidden" name="agr_'.sprintf('%09d',$Agr).'" id="agr_'.sprintf('%09d',$Agr).'" value="';
            } 

            $Saida .= $Gru[$x]['grupo'].',';
            $x++;
        }

        if ($Fim>0) $Saida .= '"/>'."\n";

        // Logins relacionados
        $Alo = -1;
        $x   = 0;
        $Fim = count($Loi);

        while ($x<count($Loi)) {
            if ($Alo != $Loi[$x]['id']) {
                if ($Alo > -1) $Saida .= '"/>'."\n";
                
                $Alo = $Loi[$x]['id'];
                $Saida .= '<input type="hidden" name="alo_'.sprintf('%09d',$Alo).'" id="alo_'.sprintf('%09d',$Alo).'" value="';
            } 

            $Saida .= $Loi[$x]['login'].',';
            $x++;
        }

        if ($Fim>0) $Saida .= '"/>'."\n";
        
        // Turnos Agentes
        $Fag = -1;
        $x   = 0;
        $Fim = count($Tur);
        
        while ($x<count($Tur)) {
            if ($Fag != $Tur[$x]['agente']) {
                if ($Fag > -1) $Saida .= '"/>'."\n";
                
                $Fag = $Tur[$x]['agente'];
                $Saida .= '<input type="hidden" name="ftu_'.sprintf('%09d',$Fag).'" id="ftu_'.sprintf('%09d',$Fag).'" value="';
            }
            
            $Saida .= $Tur[$x]['dia_sem']."#x#".$Tur[$x]['de']."#x#".$Tur[$x]['aa']."#x#".$Tur[$x]['nom'].',';
            $x++;
        }

        if ($Fim>0) $Saida .= '"/>'."\n";
    } elseif ($Tipo=='href2'){
        for ($x=0; $x<count($Age); $x++){
            $i = $Age[$x]['login'];
            $Saida .= '<a href="#" id="age_'.sprintf('%09d',$i).'" onclick="adiciona_agente('.$i.')" class="listagem">'.$Age[$x]['login'].' - '.$Age[$x]['pseudonimo'].'</a><br/>'."\n";
            $Saida .= '<input type="hidden" name="pse_'.sprintf('%09d',$i).'" id="pse_'.sprintf('%09d',$i).'" value="'.$Age[$x]['nome'].'"/>';
            $Saida .= '<input type="hidden" name="log_'.sprintf('%09d',$i).'" id="log_'.sprintf('%09d',$i).'" value="'.$Age[$x]['login'].'"/>';
            $Saida .= '<input type="hidden" name="sen_'.sprintf('%09d',$i).'" id="sen_'.sprintf('%09d',$i).'" value="'.$Age[$x]['senha'].'"/>';
            $Saida .= '<input type="hidden" name="grp_'.sprintf('%09d',$i).'" id="grp_'.sprintf('%09d',$i).'" value="'.$Age[$x]['grupo'].'"/>';
            $Saida .= '<input type="hidden" name="hr1_'.sprintf('%09d',$i).'" id="hr1_'.sprintf('%09d',$i).'" value="'.$Age[$x]['horario1'].'"/>';
            $Saida .= '<input type="hidden" name="hr2_'.sprintf('%09d',$i).'" id="hr2_'.sprintf('%09d',$i).'" value="'.$Age[$x]['horario2'].'"/>';
            $Saida .= '<input type="hidden" name="fnc_'.sprintf('%09d',$i).'" id="fnc_'.sprintf('%09d',$i).'" value="'.$Age[$x]['funcai'].'"/>';
        }

        // Grupos complementares
        $Agr = -1;
        $x   = 0;
        $Fim = count($Gru);
        
        while ($x<count($Gru)) {
            if ($Agr != $Gru[$x]['id']) {
                if ($Agr > -1) $Saida .= '"/>'."\n";
                
                $Agr = $Gru[$x]['id'];
                $Saida .= '<input type="hidden" name="agr_'.sprintf('%09d',$Agr).'" id="agr_'.sprintf('%09d',$Agr).'" value="';
            } 

            $Saida .= $Gru[$x]['grupo'].',';
            $x++;
        }

        if ($Fim>0) $Saida .= '"/>'."\n";
        
        // Logins relacionados
        $Alo = -1;
        $x   = 0;
        $Fim = count($Loi);
        
        while ($x<count($Loi)) {
            if ($Alo != $Loi[$x]['id']) {
                if ($Alo > -1) $Saida .= '"/>'."\n";
                
                $Alo = $Loi[$x]['id'];
                $Saida .= '<input type="hidden" name="alo_'.sprintf('%09d',$Alo).'" id="alo_'.sprintf('%09d',$Alo).'" value="';
            } 

            $Saida .= $Loi[$x]['login'].',';
            $x++;
        }

        if ($Fim>0) $Saida .= '"/>'."\n";
        
        // Turnos Agentes
        $Fag = -1;
        $x   = 0;
        $Fim = count($Tur);
        
        while ($x<count($Tur)) {
            if ($Fag != $Tur[$x]['agente']) {
                if ($Fag > -1) $Saida .= '"/>'."\n";
                
                $Fag = $Tur[$x]['agente'];
                $Saida .= '<input type="hidden" name="ftu_'.sprintf('%09d',$Fag).'" id="ftu_'.sprintf('%09d',$Fag).'" value="';
            }

            $Saida .= $Tur[$x]['dia_sem']."#x#".$Tur[$x]['de']."#x#".$Tur[$x]['aa']."#x#".$Tur[$x]['nom'].',';
            $x++;
        }

        if ($Fim>0) $Saida .= '"/>'."\n";
    } elseif  ($Tipo=='option') {
        for ($x=0; $x<count($Age); $x++){
            $i = $Age[$x]['id'];
            $Saida .= '<option value="'.$Age[$x]['nome'].'">'.$Age[$x]['nome'].'</option>';
        }
    } elseif  ($Tipo=='option2') {
        for ($x=0; $x<count($Age); $x++){
            $i = $Age[$x]['id'];
            $Saida .= '<option value="'.$Age[$x]['login'].'">'.$Age[$x]['login'].'-'.$Age[$x]['pseudonimo'].' ('.$Age[$x]['funcai'].')</option>';
        }

        if($ListaRamal != null) {
            for ($x=0; $x<count($Ramal); $x++){
                $i = $Ramal[$x]['id'];
                $Saida .= '<option value="'.$Ramal[$x]['ramal'].'">'.$Ramal[$x]['ramal'].'-'.$Ramal[$x]['pseudonimo'].'</option>';
            }
        }
    } elseif  ($Tipo=='option3') {
        for ($x=0; $x<count($Age); $x++){
            $i = $Age[$x]['id'];
            $Saida .= '<option value="'.$Age[$x]['login'].'-'.$Age[$x]['pseudonimo'].'">'.$Age[$x]['login'].'-'.$Age[$x]['pseudonimo'].' ('.$Age[$x]['funcai'].')</option>';
        }
    } elseif($Tipo=='option4') {	
        $Ramais = '';
        $GruposRamais = '';
        
        for($x=0; $x<count($Age); $x++){
            if($Age['ramal']== '') {
                $i = $Age[$x]['id'];
                $Ramais .='<option value="'.$Age[$x]['login'].'">'.$Age[$x]['login'].' / '.$Age[$x]['pseudonimo'].'</option>';				
                $GruposRamais .= '<input type="hidden" name="agente_'.$i.'" id="'.$Age[$x]['login'].'" value="'.$Age[$x]['grupo'].'" />';
            } else {
                $i = $Age[$x]['id'];
                $Ramais .='<option value="'.$$Age[$x]['grupo'].'">'.$Age[$x]['ramal'].'-'.$Age[$x]['login'].' / '.$Age[$x]['pseudonimo'].'</option>';
                $GruposRamais .= '<input type="hidden" name="grupo_'.$i.'" id="'.$Age[$x]['id'].'" value="'.$Age[$x]['grupo'].'" />';
            }
        }

        $Saida = array($Ramais,$GruposRamais);
    } elseif($Tipo=='option5' ) { 
        $Ramais = '';
        $GruposRamais = '';

        for($x = 0; $x<count($Age); $x++) {
            if($Age[$x]['login'] != $Login) {
                $Achei = false;
                $y = 0;
                
                while(!$Achei) {
                    if($Age[$x]['login'] != $ListaTbLogin[$y]['loginmonitora']){
                        $y++;
                        
                        if($y>=count($ListaTbLogin))$Achei = true;
                    } else $Achei = true;
                }

                if($y>=count($ListaTbLogin)) {
                    $i = $Age[$x]['id'];
                    
                    if(strlen($Age[$x]['pseudonimo'])>25) $nomeAgente = substr($Age[$x]['pseudonimo'],0,25)."...";
                    else $nomeAgente = $Age[$x]['pseudonimo'];
                    
                    $Ramais .='<option value="'.$Age[$x]['login'].'">'.$Age[$x]['login'].' / '.$Age[$x]['pseudonimo'].'</option>';				
                    $GruposRamais .= '<input type="hidden" name="agente_'.$i.'" id="'.$Age[$x]['login'].'" value="'.$Age[$x]['grupo'].'" />';
                }
            }
        }

        $Saida = array($Ramais,$GruposRamais);
    } elseif  ($Tipo=='option6') {
        for ($x=0; $x<count($Age); $x++){
            if($Age[$x]['login'] != $Login) {
                $i = $Age[$x]['id'];
                $Saida .= '<option value="'.$Age[$x]['login'].'">'.$Age[$x]['login'].'-'.$Age[$x]['pseudonimo'].'</option>';
            }
        }
    } elseif($Tipo=='xml') {
        //$Ramais = '';
        $Ramais = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
        $Ramais.= "<agentes>\n";

        for($x = 0; $x<count($Age); $x++) {
            if($Age[$x]['login'] != $Login) {
                $Achei = false;
                $y = 0;
                
                while(!$Achei) {
                    if($Age[$x]['login'] != $ListaTbLogin[$y]['loginmonitora']){
                        $y++;
                        if($y>=count($ListaTbLogin))$Achei = true;
                    } else $Achei = true;
                }

                if($y>=count($ListaTbLogin)) {
                    $i = $Age[$x]['id'];
                    $Ramais.="<agente>\n";
                    $Ramais.="<codigo>".$Age[$x]['login']."</codigo>\n";	
                    $Ramais.="<descricao>".$Age[$x]['login'].' / '.$Age[$x]['pseudonimo']."</descricao>\n";
                    $Ramais.="</agente>\n";
                }
            }
        }

        $Ramais.= "</agentes>\n";
        Header("Content-type: application/xml; charset=iso-8859-1"); 
        $Saida = $Ramais;
    } elseif  ($Tipo=='javascript') {
        for ($x=0; $x<count($Age); $x++){
            $Saida .= "    o = document.createElement('option');\n\n";
            $Saida .= "    o.text  = '".$Age[$x]['login']."-".$Age[$x]['pseudonimo']." (".$Age[$x]['funcai'].")';";
            $Saida .= " o.value = '".$Age[$x]['login']."';\n";
            $Saida .= "    try { Fila.add(o, null); }\n";
            $Saida .= "    catch (e) { Fila.add(o); }\n\n";
        }

        if($ListaRamal != null) {
            for($x=0; $x<count($Ramal); $x++){
                $Saida .= "    o = document.createElement('option');\n\n";
                $Saida .= "    o.text  = '".$Ramal[$x]['ramal']."-".$Ramal[$x]['pseudonimo']."';";
                $Saida .= " o.value = '".$Ramal[$x]['ramal']."';\n";
                $Saida .= "    try { Fila.add(o, null); }\n";
                $Saida .= "    catch (e) { Fila.add(o); }\n\n";
            }
        }
    } elseif($Tipo == "json") $Saida = json_encode($Age);

    return $Saida;
}


/**************************************************************
  Funcao apaga_agente
 *************************************************************/
 function apaga_agente($Dados){
   global $Agen;
   $Saida = true;
   if (!isset($Dados['identif'])) $Saida = false;
   else $Saida = $Agen->apaga_agentes($Dados['identif']);
   return $Saida;
 }


/**************************************************************
Funcao altera_agente
*************************************************************/
function altera_agente($Dados,$Foto=""){
    global $Agen;
    $Saida = true;

    if (!isset($Dados['identif'])) $Saida = false;
    else {
        $Saida = $Agen->altera_agentes(
            $Dados['identif'],$Dados['nome'],
            $Dados['psed'],
            $Dados['logi'],
            $Dados['senh'],
            $Dados['hor1'],
            $Dados['hor2'],
            $Dados['grup'],
            $Dados['func'],
            $Dados['cont'],
            $Dados['notificaPausaAuto'], 
            $Dados['notificaDepoisDe'], 
            $Dados['notificaLivreDepoisDe'], 
            $Dados['setarIpAstman'], 
            $Dados['txtIpAstman']
        );

        //return $Saida;
        $Grupos = $Dados['grucr'];
        $Retorno = $Agen->altera_agentes_grupos($Dados['identif'],$Grupos);
        
        if (!$Retorno) $Saida = false;
        $Logins  = $Dados['logrr'];
        $Retorno = $Agen->altera_agentes_logins($Dados['identif'],$Logins);
        
        if (!$Retorno) $Saida = false;
        
        //Turnos
        $TurnosTotal = $Dados['totalturnos'];
        $Turnos = array();
        
        for ($x=1; $x<=$TurnosTotal; $x++) {
            $Turnos[$x]['ds'] = $Dados['diasem_'.sprintf('%03d',$x)];
            $Turnos[$x]['de'] = $Dados['de_'.sprintf('%03d',$x)];
            $Turnos[$x]['aa'] = $Dados['aa_'.sprintf('%03d',$x)];
            $Turnos[$x]['no'] = $Dados['nome_'.sprintf('%03d',$x)];
        }
        
        $Saida = $Agen->insere_agentes_turnos($Dados['nome'],$Turnos);
    }
    return $Saida;
}


/**************************************************************
Funcao insere_agente
*************************************************************/
function insere_agente($Dados){
    global $Agen;
    $Saida = "";
    
    if (!isset($Dados['identif'])) $Saida = false;
    else {
        $Saida = $Agen->insere_agentes(
            $Dados['nome'],
            $Dados['psed'],
            $Dados['logi'],
            $Dados['senh'],
            $Dados['hor1'],
            $Dados['hor2'],
            $Dados['grup'],
            $Dados['func'],
            $Dados['cont'],
            $Dados['notificaPausaAuto'], 
            $Dados['notificaDepoisDe'], 
            $Dados['notificaLivreDepoisDe'], 
            $Dados['setarIpAstman'], 
            $Dados['txtIpAstman']
        );
        
        if ($Saida) {
            $Grupos = $Dados['grucr'];
            
            for ($x=0; $x<count($Grupos); $x++) {
                if ($Saida) $Saida = $Agen->insere_agentes_grupos($Dados['psed'],$Grupos[$x]);
            }
            
            if ($Saida) {
                $Logis = $Dados['logrr'];
                
                for ($x=0; $x<count($Logis); $x++) {
                    if ($Saida) $Saida = $Agen->insere_agentes_logins($Dados['psed'],$Logis[$x]);
                }
            }
        }
        
        //Insere turnos
        $TurnosTotal = $Dados['totalturnos'];
        $Turnos = array();

        for ($x=1; $x<=$TurnosTotal; $x++) {
            $Turnos[$x]['ds'] = $Dados['diasem_'.sprintf('%03d',$x)];
            $Turnos[$x]['de'] = $Dados['de_'.sprintf('%03d',$x)];
            $Turnos[$x]['aa'] = $Dados['aa_'.sprintf('%03d',$x)];
            $Turnos[$x]['no'] = $Dados['nome_'.sprintf('%03d',$x)];
        }
        
        $Saida = $Agen->insere_agentes_turnos($Dados['nome'],$Turnos);
    }
    return $Saida;
}


/**************************************************************
  Funcao lista_distribuicao_chamada
  O tipo pode ser:
  href   = saida em <a href...
  option = saida em <option...
 *************************************************************/
 function lista_distribuicao_chamada(){
   global $Agen;
   $Age = $Agen->DistrCh;
   $Saida = '';
   $Saida .= '';
   for ($x=0; $x<count($Age); $x++) { 
     $Saida .= '<option value="'.$Age[$x].'"';
     if ($Age[$x]=="rrmemory") $Saida .= " selected";
     $Saida .= '>'.$Age[$x].'</option>';
  }
   return $Saida;
 }


/**************************************************************
  Funcao lista_fila
  O tipo pode ser:
  href   = saida em <a href...
  option = saida em <option...
 *************************************************************/
function lista_fila($Tipo,$Ativo=''){
	global $Agen;
	$Agx = $Agen->lista_filas($Ativo);
	//return print_r($Agx[1], true);
	$Fil = $Agx[0];
	$Age = $Agx[1];
	$Tur = $Agx[2];
	$Gra = $Agx[3];
	$Ram = $Agx[5];
	$Campos = array("flid" => "id", "pseu" => "pseudonimo", "nume" => "numero", "tron" => "tronco", "estr" => "estrategia", "musi" => "musica", "time" => "timeout", "tent" => "tentardenovo", "lmfl" => "limitedafila", "prio" => "prioridade", "dlen" => "delaydeencaminhamento", "dlat" => "delaydeatendimento", "rsto" => "resetatimeout", "dspa" => "distribuicaodacparalela", "stva" => "setavariavel", "anpf" => "anundeposicaonafila", "anpe" => "anunperiodicos", "anee" => "anunesperaestimada", "anse" => "anundesegundos", "sepa" => "segchamadanapa", "ensm" => "entradafilasemmembros", "rcsm" => "removechamsesemmembros", "geca" => "geraeventochamagente", "gems" => "geraeventomembstatus", "tmin" => "tempominconvatend", "tmax" => "tempomaxconvatend", "tmae" => "tempomaxespeatend", "qmfe" => "qtdemaxchamafilaesp", "qmcr" => "qtdemaxchamarecebid", "vsup" => "visivelsupervisao", "dire" => "direcao", "tadi" => "tempoadidional", "tmie" => "tempominespera", "comp" => "dinamica", "epau" => "entrarpausaauto", "paau" => "pausaautomatica", "tepa" => "tempodepausa", "mrela" => "mostrarrelplansimp", "ccham" => "classifica_chamadas");
	$Saida = '';
	if ($Tipo=='href'){
		for ($x=0; $x<count($Fil); $x++){
			$i = $Fil[$x]['id'];
			$Saida .= '<a href="#" id="fil_'.sprintf('%09d',$i).'" onclick="mostra_fila('.$i.')" class="listagem">'.$Fil[$x]['nome'].'</a><br/>'."\n";
			foreach ($Campos as $Chave => $Valor) {
				$Saida.= '<input type="hidden" name="'.$Chave.'_'.sprintf('%09d',$i).'" id="'.$Chave.'_'.sprintf('%09d',$i).'" value="'.$Fil[$x][$Valor].'"/>'."\n";
			}
		}
		//$Saida.= '<a href="#">'.count($Campos).'</a>';
		// Membros Filas
		$Fag = -1;
		$x   = 0;
		$Fim = count($Age);
		while ($x<count($Age)) {
			if ($Fag != $Age[$x]['id']) {
				if ($Fag > -1) $Saida .= '"/>'."\n";
				$Fag = $Age[$x]['id'];
				$Saida .= '<input type="hidden" name="fag_'.sprintf('%09d',$Fag).'" id="fag_'.sprintf('%09d',$Fag).'" value="';
			}
			if(trim($Age[$x]['login'])!="") $Saida .= $Age[$x]['login'].',';
			$x++;
		}
		//if ($Fim>0) $Saida .= '"/>'."\n";
		/*
		Incluido este bloco de codigo
		para listar os ramais e montar na tela
		quando o usuário for consultar a fila atraves dos links
		Lista das Filas
		*/
		$x   = 0;
		$Fim = count($Age) + count($Ram);
		while ($x<count($Ram)) {
			if ($Fag != $Ram[$x]['id']) {
				if ($Fag > -1) $Saida .= '"/>'."\n";
				$Fag = $Ram[$x]['id'];
				$Saida .= '<input type="hidden" name="fag_'.sprintf('%09d',$Fag).'" id="fag_'.sprintf('%09d',$Fag).'" value="';
			}
			$Saida .= $Ram[$x]['ramal'].',';
			$x++;
		}
		if ($Fim>0) $Saida .= '"/>'."\n";
		// Turnos Filas
		$Fag = -1;
		$x   = 0;
		$Fim = count($Tur);
		while ($x<count($Tur)) {
			if ($Fag != $Tur[$x]['fila']) {
				if ($Fag > -1) $Saida .= '"/>'."\n";
				$Fag = $Tur[$x]['fila'];
				$Saida .= '<input type="hidden" name="ftu_'.sprintf('%09d',$Fag).'" id="ftu_'.sprintf('%09d',$Fag).'" value="';
			}
			$Saida .= $Tur[$x]['dia_sem']."#x#".$Tur[$x]['de']."#x#".$Tur[$x]['aa']."#x#".$Tur[$x]['nom'].',';
			$x++;
		}
		if ($Fim>0) $Saida .= '"/>'."\n";
		// Grades Filas
		for ($x=0; $x<count($Gra); $x++) {
			$Fag = $Gra[$x]['fila'];
			if ($Gra[$x]['tipo']=="esperas") {
				for ($y=1; $y<21; $y++) {
					$Aux = 'pos'.sprintf('%02d',$y);
					$Saida .= '<input type="hidden" name="grA'.sprintf('%02d',$y).'_'.sprintf('%09d',$Fag).'" id="grA'.sprintf('%02d',$y).'_'.sprintf('%09d',$Fag).'" value="'.$Gra[$x][$Aux].'" />'."\n";
				}
			} elseif ($Gra[$x]['tipo']=="desistencias") {
				for ($y=1; $y<21; $y++) {
					$Aux = 'pos'.sprintf('%02d',$y);
					$Saida .= '<input type="hidden" name="grB'.sprintf('%02d',$y).'_'.sprintf('%09d',$Fag).'" id="grB'.sprintf('%02d',$y).'_'.sprintf('%09d',$Fag).'" value="'.$Gra[$x][$Aux].'" />'."\n";
				}
			} elseif ($Gra[$x]['tipo']=="queue") {
				for ($y=1; $y<21; $y++) {
					$Aux = 'pos'.sprintf('%02d',$y);
					$Saida .= '<input type="hidden" name="grC'.sprintf('%02d',$y).'_'.sprintf('%09d',$Fag).'" id="grC'.sprintf('%02d',$y).'_'.sprintf('%09d',$Fag).'" value="'.$Gra[$x][$Aux].'" />'."\n";
				}
			} elseif ($Gra[$x]['tipo']=="atendimentos") {
				for ($y=1; $y<21; $y++) {
					$Aux = 'pos'.sprintf('%02d',$y);
					$Saida .= '<input type="hidden" name="grD'.sprintf('%02d',$y).'_'.sprintf('%09d',$Fag).'" id="grD'.sprintf('%02d',$y).'_'.sprintf('%09d',$Fag).'" value="'.$Gra[$x][$Aux].'" />'."\n";
				}
			}
		}
	} elseif($Tipo=='href2'){
		for ($x=0; $x<count($Fil); $x++){
			$i = $Fil[$x]['id'];
			$Saida .= '<a href="#" id="'.$Fil[$x]['nome'].'" onclick="mostra_auxiliares_fila('.$i.')" class="listagem">'.$Fil[$x]['nome'].'</a><br/>'."\n";
			$Saida.= '<input type="hidden" name="nome_'.sprintf('%09d',$i).'" id="nome_'.sprintf('%09d',$i).'" value="'.$Fil[$x]["nome"].'"/>'."\n";
		}
	} elseif($Tipo=='href3'){
		for ($x=0; $x<count($Fil); $x++){
			$i = $Fil[$x]['id'];
			$Saida .= '<a href="#" id="'.$Fil[$x]['nome'].'" onclick="mostra_fha_fila('.$i.')" class="listagem">'.$Fil[$x]['nome'].'</a><br/>'."\n";
			$Saida.= '<input type="hidden" name="nome_'.sprintf('%09d',$i).'" id="nome_'.sprintf('%09d',$i).'" value="'.$Fil[$x]["nome"].'"/>'."\n";
		}
	} elseif  ($Tipo=='option') {
		for ($x=0; $x<count($Fil); $x++){
			$i = $Fil[$x]['id'];
			$Saida .= '<option value="'.$Fil[$x]['pseudonimo'].'">'.$Fil[$x]['pseudonimo'].'</option>';
		}
	} elseif  ($Tipo=='option2') {
		for ($x=0; $x<count($Fil); $x++){
			if($Fil[$x]["id_grupo_relat"] == "0") $Saida .= '<option value="'.$Fil[$x]['id'].'">'.$Fil[$x]['pseudonimo'].'</option>';
		}
	} elseif  ($Tipo=='javascript') {
		for ($x=0; $x<count($Fil); $x++){
			$Saida .= "    o = document.createElement('option');\n\n";
			$Saida .= "    o.text  = '".$Fil[$x]['pseudonimo']."';";
			$Saida .= " o.value = '".$Fil[$x]['pseudonimo']."';\n";
			$Saida .= "    try { Fila.add(o, null); }\n";
			$Saida .= "    catch (e) { Fila.add(o); }\n\n";
		}
	}
	elseif  ($Tipo=='javascript2') {
		for ($x=0; $x<count($Fil); $x++){
			$Saida .= "    o = document.createElement('option');\n\n";
			$Saida .= "    o.text  = '".$Fil[$x]['pseudonimo']."';";
			$Saida .= " o.value = '".$Fil[$x]['pseudonimo']."';\n";
			$Saida .= "    try { ".$Ativo.".add(o, null); }\n";
			$Saida .= "    catch (e) { ".$Ativo.".add(o); }\n\n";
		}
	}
	elseif($Tipo=='lista'){
		for($x=0; $x<count($Fil); $x++){
			if($Fil[$x]['dinamica']=="t"){
				$Saida .= $Fil[$x]['nome']."|";
			}
		}
	}
	elseif($Tipo=='json'){
		$Saida = json_encode($Fil);
	}
	elseif($Tipo=='listaES'){
		for($x=0; $x<count($Fil); $x++){
			$Json[$x]['pseudonimo'] = $Fil[$x]['pseudonimo'];
			$Json[$x]['direcao'] = trim($Fil[$x]['direcao']);
			$Json[$x]['classifica_chamadas'] = trim($Fil[$x]['classifica_chamadas']);
		}
		$Saida = json_encode($Json);
	}
    elseif($Tipo == "json_nome"){
        for($x = 0; $x < count($Fil); $x++){
            $json[$x]['id'] = $Fil[$x]['id'];
            $json[$x]['nome'] = $Fil[$x]['nome'];
        }
        $Saida = json_encode($json);
    }
	return $Saida;
}

/***********************************
Funcao apaga_fila
***********************************/
 function apaga_fila($Dados){
   global $Agen;
   $Saida = "";
   if (!isset($Dados['identif'])) $Saida = "erro";
   else $Saida = $Agen->apaga_filas($Dados['identif']);
   return $Saida;
 }
/**********************************
 Funcao altera_fila
**********************************/
 function altera_fila($Dados) {
   global $Agen;
   $Saida = "";
   if (!isset($Dados['identif'])) $Saida = false;
   else {
	 if($Dados["entPausaAuto"]=="f") $Dados["tipoPausa"] = "";
     $Saida = $Agen->altera_filas($Dados['identif'],$Dados["nomef"],$Dados["psedo"],$Dados["numer"],$Dados["tronc"],$Dados["estra"],$Dados["music"],$Dados["timeo"],$Dados["retry"],$Dados["maxle"],$Dados["weigh"],$Dados["wrapu"],$Dados["mdela"],$Dados["timer"],$Dados["autof"],$Dados["sintf"],$Dados["annfr"],$Dados["annpe"],$Dados["annht"],$Dados["annrs"],$Dados["ringi"],$Dados["joine"],$Dados["leave"],$Dados["evwca"],$Dados["evmbs"],$Dados["tmini"],$Dados["tmaxi"],$Dados["tmaxe"],$Dados["qmaxe"],$Dados["qmaxr"],$Dados["compo"],$Dados["entPausaAuto"],$Dados["tipoPausa"],$Dados["tempoPausa"],$Dados["vsupe"],$Dados["direc"],$Dados["tadic"],$Dados["tmine"],$Dados["mostrarEmRel"],$Dados["classCham"]);
     if ($Saida) {
       //Agentes
       $Agentes = $Dados['agenr'];
       $Saida = $Agen->altera_filas_agentes($Dados['nomef'],$Agentes);
       //return $Saida;
       //Turnos
       $TurnosTotal = $Dados['totalturnos'];
       $Turnos = array();
       for ($x=1; $x<=$TurnosTotal; $x++) {
         $Turnos[$x]['ds'] = $Dados['diasem_'.sprintf('%03d',$x)];
         $Turnos[$x]['de'] = $Dados['de_'.sprintf('%03d',$x)];
         $Turnos[$x]['aa'] = $Dados['aa_'.sprintf('%03d',$x)];
         $Turnos[$x]['no'] = $Dados['nome_'.sprintf('%03d',$x)];
       }
       $Saida = $Agen->insere_filas_turnos($Dados['nomef'],$Turnos);
       $GrupoA = array($Dados["grA_01"],$Dados["grA_02"],$Dados["grA_03"],$Dados["grA_04"],$Dados["grA_05"],$Dados["grA_06"],$Dados["grA_07"],$Dados["grA_08"],$Dados["grA_09"],$Dados["grA_10"],$Dados["grA_11"],$Dados["grA_12"],$Dados["grA_13"],$Dados["grA_14"],$Dados["grA_15"],$Dados["grA_16"],$Dados["grA_17"],$Dados["grA_18"],$Dados["grA_19"],$Dados["grA_20"]);
       $GrupoB = array($Dados["grB_01"],$Dados["grB_02"],$Dados["grB_03"],$Dados["grB_04"],$Dados["grB_05"],$Dados["grB_06"],$Dados["grB_07"],$Dados["grB_08"],$Dados["grB_09"],$Dados["grB_10"],$Dados["grB_11"],$Dados["grB_12"],$Dados["grB_13"],$Dados["grB_14"],$Dados["grB_15"],$Dados["grB_16"],$Dados["grB_17"],$Dados["grB_18"],$Dados["grB_19"],$Dados["grB_20"]);
       $GrupoC = array($Dados["grC_01"],$Dados["grC_02"],$Dados["grC_03"],$Dados["grC_04"],$Dados["grC_05"],$Dados["grC_06"],$Dados["grC_07"],$Dados["grC_08"],$Dados["grC_09"],$Dados["grC_10"],$Dados["grC_11"],$Dados["grC_12"],$Dados["grC_13"],$Dados["grC_14"],$Dados["grC_15"],$Dados["grC_16"],$Dados["grC_17"],$Dados["grC_18"],$Dados["grC_19"],$Dados["grC_20"]);
       $GrupoD = array($Dados["grD_01"],$Dados["grD_02"],$Dados["grD_03"],$Dados["grD_04"],$Dados["grD_05"],$Dados["grD_06"],$Dados["grD_07"],$Dados["grD_08"],$Dados["grD_09"],$Dados["grD_10"],$Dados["grD_11"],$Dados["grD_12"],$Dados["grD_13"],$Dados["grD_14"],$Dados["grD_15"],$Dados["grD_16"],$Dados["grD_17"],$Dados["grD_18"],$Dados["grD_19"],$Dados["grD_20"]);
       $Saida = $Agen->insere_filas_grades($Dados['nomef'],$GrupoA,$GrupoB,$GrupoC,$GrupoD);
     }
   }
   return $Saida;
 }

/**************************************************************
  Funcao insere_fila
 *************************************************************/
 function insere_fila($Dados) {
   global $Agen;
   $Saida = "";
   if (!isset($Dados['identif'])) $Saida = false;
   else {
     $Saida = "Teste";
     $Saida = $Agen->insere_filas($Dados["nomef"],$Dados["psedo"],$Dados["numer"],$Dados["tronc"],$Dados["estra"],$Dados["music"],$Dados["timeo"],$Dados["retry"],$Dados["maxle"],$Dados["weigh"],$Dados["wrapu"],$Dados["mdela"],$Dados["timer"],$Dados["autof"],$Dados["sintf"],$Dados["annfr"],$Dados["annpe"],$Dados["annht"],$Dados["annrs"],$Dados["ringi"],$Dados["joine"],$Dados["leave"],$Dados["evwca"],$Dados["evmbs"],$Dados["tmini"],$Dados["tmaxi"],$Dados["tmaxe"],$Dados["qmaxe"],$Dados["qmaxr"],$Dados["compo"],$Dados["entPausaAuto"],$Dados["tipoPausa"],$Dados["tempoPausa"],$Dados["vsupe"],$Dados["direc"],$Dados["tadic"],$Dados["tmine"]);
     if ($Saida) {
     //Insere agentes
       $Agentes = $Dados['agenr'];
       for ($x=0; $x<count($Agentes); $x++) {
         if ($Saida) $Saida = $Agen->insere_filas_agentes($Dados['nomef'],$Agentes[$x]);
       }
     //Insere turnos
       $TurnosTotal = $Dados['totalturnos'];
       $Turnos = array();
       for ($x=1; $x<=$TurnosTotal; $x++) {
         $Turnos[$x]['ds'] = $Dados['diasem_'.sprintf('%03d',$x)];
         $Turnos[$x]['de'] = $Dados['de_'.sprintf('%03d',$x)];
         $Turnos[$x]['aa'] = $Dados['aa_'.sprintf('%03d',$x)];
         $Turnos[$x]['no'] = $Dados['nome_'.sprintf('%03d',$x)];
       }
       $Saida = $Agen->insere_filas_turnos($Dados['nomef'],$Turnos);
       $GrupoA = array($Dados["grA_01"],$Dados["grA_02"],$Dados["grA_03"],$Dados["grA_04"],$Dados["grA_05"],$Dados["grA_06"],$Dados["grA_07"],$Dados["grA_08"],$Dados["grA_09"],$Dados["grA_10"],$Dados["grA_11"],$Dados["grA_12"],$Dados["grA_13"],$Dados["grA_14"],$Dados["grA_15"],$Dados["grA_16"],$Dados["grA_17"],$Dados["grA_18"],$Dados["grA_19"],$Dados["grA_20"]);
       $GrupoB = array($Dados["grB_01"],$Dados["grB_02"],$Dados["grB_03"],$Dados["grB_04"],$Dados["grB_05"],$Dados["grB_06"],$Dados["grB_07"],$Dados["grB_08"],$Dados["grB_09"],$Dados["grB_10"],$Dados["grB_11"],$Dados["grB_12"],$Dados["grB_13"],$Dados["grB_14"],$Dados["grB_15"],$Dados["grB_16"],$Dados["grB_17"],$Dados["grB_18"],$Dados["grB_19"],$Dados["grB_20"]);
       $GrupoC = array($Dados["grC_01"],$Dados["grC_02"],$Dados["grC_03"],$Dados["grC_04"],$Dados["grC_05"],$Dados["grC_06"],$Dados["grC_07"],$Dados["grC_08"],$Dados["grC_09"],$Dados["grC_10"],$Dados["grC_11"],$Dados["grC_12"],$Dados["grC_13"],$Dados["grC_14"],$Dados["grC_15"],$Dados["grC_16"],$Dados["grC_17"],$Dados["grC_18"],$Dados["grC_19"],$Dados["grC_20"]);
       $GrupoD = array($Dados["grD_01"],$Dados["grD_02"],$Dados["grD_03"],$Dados["grD_04"],$Dados["grD_05"],$Dados["grD_06"],$Dados["grD_07"],$Dados["grD_08"],$Dados["grD_09"],$Dados["grD_10"],$Dados["grD_11"],$Dados["grD_12"],$Dados["grD_13"],$Dados["grD_14"],$Dados["grD_15"],$Dados["grD_16"],$Dados["grD_17"],$Dados["grD_18"],$Dados["grD_19"],$Dados["grD_20"]);
       $Saida = $Agen->insere_filas_grades($Dados['nomef'],$GrupoA,$GrupoB,$GrupoC,$GrupoD);
     }
   }
   return $Saida;
 }


/**************************************************************
  Funcao lista_pausa
  O tipo pode ser:
  href   = saida em <a href...
  option = saida em <option...
 *************************************************************/
 function lista_pausa($Tipo,$Ativo=''){
   global $Agen;
   $Paus = $Agen->lista_pausas($Ativo);
   $Saida = '';
   if ($Tipo=='href'){
     for ($x=0; $x<count($Paus); $x++){
       $i = $Paus[$x]['id'];
       $Saida .= '<a href="#" id="pau_'.sprintf('%09d',$i).'" onclick="mostra_pausa('.$i.')" class="listagem">'.$Paus[$x]['nome'].'</a> => '.$Paus[$x]['tempomax'].'<br/>'."\n";
       $Saida .= '<input type="hidden" name="tmx_'.sprintf('%09d',$i).'" id="tmx_'.sprintf('%09d',$i).'" value="'.$Paus[$x]['tempomax'].'"/>'."\n";
       $Saida .= '<input type="hidden" name="tpp_'.sprintf('%09d',$i).'" id="tpp_'.sprintf('%09d',$i).'" value="'.$Paus[$x]['tipo'].'"/>'."\n";
       $Saida .= '<input type="hidden" name="tpr_'.sprintf('%09d',$i).'" id="tpr_'.sprintf('%09d',$i).'" value="'.$Paus[$x]['temporetirada'].'"/>'."\n";
       $Saida .= '<input type="hidden" name="rta_'.sprintf('%09d',$i).'" id="rta_'.sprintf('%09d',$i).'" value="'.$Paus[$x]['retirarauto'].'"/>'."\n";
       $Saida .= '<input type="hidden" name="cmp_'.sprintf('%09d',$i).'" id="cmp_'.sprintf('%09d',$i).'" value="'.$Paus[$x]['cormonitpa'].'"/>'."\n";
	   $Saida .= '<input type="hidden" name="hpp_'.sprintf('%09d',$i).'" id="hpp_'.sprintf('%09d',$i).'" value="'.$Paus[$x]['habilitaparapa'].'"/>'."\n";
     }
   }
   elseif  ($Tipo=='option') {
     for ($x=0; $x<count($Paus); $x++) $Saida .= '<option value="'.$Paus[$x]['nome'].'">'.$Paus[$x]['nome'].' => '.$Paus[$x]['tempomax'].'</option>';
   }
   elseif  ($Tipo=='option2') {
     for ($x=0; $x<count($Paus); $x++) {
       $Saida .= '<option value="'.$Paus[$x]['nome'].'"';
       if ($x==0) $Saida .= ' selected';
       $Saida .= '>'.$Paus[$x]['nome'].'</option>';
     }
   }
   elseif  ($Tipo=='option3') {
	 if($Ativo!=''){
		 for ($x=0; $x<count($Paus); $x++) {
		   if($Paus[$x]['habilitaparapa']=='t'){
			   $Saida .= '<option value="'.$Paus[$x]['nome'].'"';
			   $Saida .= '>'.$Paus[$x]['nome'].'</option>';
		   }
		   //$Saida .= '<input type = "hidden" id = "rta_'.$Paus[$x]['nome'].'" value = "'.$Paus[$x]['retirarauto'].'"/>';
		 }
	 } else {
		for ($x=0; $x<count($Paus); $x++) {
		   $Saida .= '<option value="'.$Paus[$x]['nome'].'"';
		   $Saida .= '>'.$Paus[$x]['nome'].'</option>';
		   //$Saida .= '<input type = "hidden" id = "rta_'.$Paus[$x]['nome'].'" value = "'.$Paus[$x]['retirarauto'].'"/>';
		 }
	 }
   } else if($Tipo == "option4"){
        for ($x=0; $x<count($Paus); $x++) {
            $Saida .= '<option value="'.$Paus[$x]['id'].'"';
            $Saida .= '>'.$Paus[$x]['nome'].'</option>';
        }
   } else if($Tipo == "array"){
        $Saida = $Paus;
   }
   return $Saida;
 }
 
 /*************************************************************
  * lista_config_pausas()
  *************************************************************/
 function lista_config_pausas(){
     global $Agen;
     $pausas = $Agen->lista_pausas();
     $Saida = "";
     for($i = 0; $i < count($pausas); $i++){
         $Saida .= '<input type="hidden" id="rta_'.$pausas[$i]['nome'].'" value="'.$pausas[$i]['retirarauto'].'"/>';
         $Saida .= '<input type="hidden" id="tmp_'.$pausas[$i]['nome'].'" value="'.$pausas[$i]['temporetirada'].'"/>';
     }
     return $Saida;
 }


/**************************************************************
  Funcao apaga_pausa
 *************************************************************/
 function apaga_pausa($Dados){
   global $Agen;
   $Saida = "";
   if (!isset($Dados['identif'])) $Saida = false;
   else $Saida = $Agen->apaga_pausas($Dados['identif']);
   return $Saida;
 }


/**************************************************************
  Funcao altera_pausa
 *************************************************************/
 function altera_pausa($Dados) {
   global $Agen;
   $Saida = "";
   if (!isset($Dados['identif'])) $Saida = false;
   else $Saida = $Agen->altera_pausas($Dados['identif'],$Dados["nome"],$Dados["tmax"],$Dados["tpaus"],$Dados['retirarAuto'],$Dados['tempoRetAuto'],$Dados['corSelecionada'],$Dados['habilitaParaPa']);
   return $Saida;
 }


/**************************************************************
  Funcao insere_pausa
 *************************************************************/
 function insere_pausa($Dados){
   global $Agen;
   $Saida = $Agen->insere_pausas($Dados["nome"],$Dados["tmax"],$Dados["tipo"], $Dados['retirarAuto'],$Dados['tempoRetAuto'],$Dados['corSelecionada'],$Dados['habilitaParaPa']);
   return $Saida;
 }











/**************************************************************
  Funcao lista_classificacao_chamada
  O tipo pode ser:
  href   = saida em <a href...
  option = saida em <option...
 *************************************************************/
 function lista_classificacao_chamada($Tipo,$Ativo=''){
   global $Agen;
   $ClaC = $Agen->lista_classificacao_chamadas($Ativo);
   $Saida = '';
   if ($Tipo=='href'){
     for ($x=0; $x<count($ClaC); $x++){
       $i = $ClaC[$x]['id'];
       $Saida .= '<a href="#" id="clc_'.sprintf('%09d',$i).'" onclick="mostra_classificacao_chamada('.$i.')" class="listagem">'.$ClaC[$x]['nome'].'</a><br/>'."\n";
     }
   }
   elseif  ($Tipo=='option') {
     for ($x=0; $x<count($ClaC); $x++) $Saida .= '<option value="'.$ClaC[$x]['id'].'">'.$ClaC[$x]['nome'].'</option>';
   }
   elseif  ($Tipo=='option2') {
     for ($x=0; $x<count($ClaC); $x++) {
       $Saida .= '<option value="'.$ClaC[$x]['nome'].'"';
       if ($x==0) $Saida .= ' selected';
       $Saida .= '>'.$ClaC[$x]['nome'].'</option>';
     }
   }
   elseif  ($Tipo=='option3') {
     for ($x=0; $x<count($ClaC); $x++) {
       $Saida .= '<option value="'.$ClaC[$x]['nome'].'"';
       $Saida .= '>'.$ClaC[$x]['nome'].'</option>';
     }
   } else if($Tipo == "array"){
    $Saida = $ClaC;
   }
   return $Saida;
 }


/**************************************************************
  Funcao apaga_classificacao_chamada
 *************************************************************/
 function apaga_classificacao_chamada($Dados){
   global $Agen;
   $Saida = "";
   if (!isset($Dados['identif'])) $Saida = false;
   else $Saida = $Agen->apaga_classificacao_chamadas($Dados['identif']);
   return $Saida;
 }


/**************************************************************
  Funcao altera_classificacao_chamada
 *************************************************************/
 function altera_classificacao_chamada($Dados) {
   global $Agen;
   $Saida = "";
   if (!isset($Dados['identif'])) $Saida = false;
   else $Saida = $Agen->altera_classificacao_chamadas($Dados['identif'],$Dados["nome"]);
   return $Saida;
 }


/**************************************************************
  Funcao insere_classificacao_chamada
 *************************************************************/
 function insere_classificacao_chamada($Dados){
   global $Agen;
   $Saida = $Agen->insere_classificacao_chamadas($Dados["nome"]);
   return $Saida;
 }

 /**************************************************************
  Funcao lista_subclassificacao_chamada
  O tipo pode ser:
  href   = saida em <a href...
  option = saida em <option...
 *************************************************************/
 function lista_subclassificacao_chamada($Tipo){
   global $Agen;
   $ClaC = $Agen->lista_subclassificacao_chamadas($Ativo);
   $Saida = '';
   if ($Tipo=='href'){
     for ($x=0; $x<count($ClaC); $x++){
       $i = $ClaC[$x]['id'];
       $Saida .= '<a href="#" onclick="mostra_subclassificacao_chamada('.$i.')" class="listagem">'.$ClaC[$x]['nome'].'</a><br/>'."\n";
       $Saida .= '<input type="hidden" id="nome_'.$i.'" value="'.$ClaC[$x]['nome'].'"/>';
       $Saida .= '<input type="hidden" id="id_pai_'.$i.'" value="'.$ClaC[$x]['id_pai'].'"/>';
     }
   } else if($Tipo == "array"){
    $Saida = $ClaC;
   }
   elseif  ($Tipo=='option') {
     for ($x=0; $x<count($ClaC); $x++) $Saida .= '<option value="'.$ClaC[$x]['id'].'">'.$ClaC[$x]['nome'].'</option>';
   }
   /*elseif  ($Tipo=='option2') {
     for ($x=0; $x<count($ClaC); $x++) {
       $Saida .= '<option value="'.$ClaC[$x]['nome'].'"';
       if ($x==0) $Saida .= ' selected';
       $Saida .= '>'.$ClaC[$x]['nome'].'</option>';
     }
   }
   elseif  ($Tipo=='option3') {
     for ($x=0; $x<count($ClaC); $x++) {
       $Saida .= '<option value="'.$ClaC[$x]['nome'].'"';
       $Saida .= '>'.$ClaC[$x]['nome'].'</option>';
     }
   }*/
   return $Saida;
 }

 /**************************************************************
  Funcao insere_classificacao_chamada
 *************************************************************/
 function insere_subclassificacao_chamada($Dados){
   global $Agen;
   if($Dados["nome"] == "") return false;
   $Saida = $Agen->insere_subclassificacao_chamadas($Dados["nome"], $Dados["id_pai"]);
   return $Saida;
 }

/**************************************************************
  Funcao altera_classificacao_chamada
 *************************************************************/
 function altera_subclassificacao_chamada($Dados) {
   global $Agen;
   $Saida = "";
   if (!isset($Dados['identif'])) $Saida = false;
   else $Saida = $Agen->altera_subclassificacao_chamadas($Dados['identif'], $Dados["nome"], $Dados["id_pai"]);
   return $Saida;
 }

/**************************************************************
  Funcao insere_mensagem_pa
  Descrição: Este método é o responsável por chamar o método
  insere_mensagem_pas contido em agentes.class.php.
 *************************************************************/
 function insere_mensagem_pa($Mensagem)
 {
 	global $Agen;
    $Agentes = $Mensagem["ramaisr"];
    if(count($Agentes) > 0)	$Saida = $Agen->insere_mensagem_pas($Mensagem["msg"], $Agentes);
    else $Saida = false;    
    return $Saida;
 }
 /**************************************************************
  Funcao apaga_mensagem_pa
  Descriçao: Este método é responsável por chamar o método 
  apaga_mensagem_pas contido em agentes.class.php
 *************************************************************/
 function apaga_mensagem_pa($Mensagem)
 {
 	global $Agen;
    $Agentes = $Mensagem["ramaisr"];
    if(count($Agentes)>0) $Saida = $Agen->apaga_mensagem_pas($Agentes);
    else $Saida = false;
    return $Saida;
 }
 /**************************************************************
  Funcao carrega_mensagem_pa
  Descriçao: Este método é responsável por chamar o método 
  carrega_mensagem_pas contido em agentes.class.php
 *************************************************************/
 function carrega_mensagem_pa($tipo_user)
 {
 	global $Agen;
    $Saida = $Agen->carrega_mensagem_pas($tipo_user);
    return $Saida;
 }














/**************************************************************
  Funcao lista_periodo
  O tipo pode ser:
  input  = saida em <input...
 *************************************************************/
 function lista_periodo($Tipo,$Ativo=''){
   global $Agen;
   $Peri = $Agen->lista_periodos($Ativo);
   $Saida = '';
   if ($Tipo=='input'){
     $Saida .= '<input type="hidden" name="total_periodos" id="total_periodos" value="'.count($Peri).'"/>'."\n";
     for ($x=0; $x<count($Peri); $x++){
       $Saida .= 'De: <input type="text" name="ppd_'.sprintf('%03d',$x).'" id="ppd_'.sprintf('%03d',$x).'" value="'.$Peri[$x]['perd'].'" onblur="{arruma_pera(\''.sprintf('%03d',$x).'\');}" class="ramal" />'."\n";
       $Saida .= 'a:  <input type="text" name="ppa_'.sprintf('%03d',$x).'" id="ppa_'.sprintf('%03d',$x).'" value="'.$Peri[$x]['pera'].'" onblur="{if (periodos_a_menor_para_maior(\''.sprintf('%03d',$x).'\')) arruma_perd(\''.sprintf('%03d',$x).'\'); else {alert(\'O horário digitado é menor que o horário anterior.\'); this.focus(); }}" class="ramal" />'."\n";
       $Saida .= '<input type="button" name="botao_p_'.sprintf('%03d',$x).'" id="botao_p_'.sprintf('%03d',$x).'" class="botao" value="Remover" onclick="{apaga_periodo(\''.$Peri[$x]['id'].'\');}" />'."\n";
       $Saida .= '<br />'."\n";
       $Difer  = subtrai_horas($Peri[$x]['pera'],$Peri[$x]['perd']);
     }
     $Pd = soma_horas($Peri[$x-1]['pera'],"00:01");
     $Pa = soma_horas($Pd,$Difer);
     $Saida .= 'De: <input type="text" name="ppd_'.sprintf('%03d',$x).'" id="ppd_'.sprintf('%03d',$x).'" value="'.$Pd.'" onblur="{arruma_pera(\''.sprintf('%03d',$x).'\');}" class="ramal"';
     if (count($Peri)>0) $Saida .= ' disabled />'."\n";
     else $Saida .= ' />'."\n";
     $Saida .= 'a:  <input type="text" name="ppa_'.sprintf('%03d',$x).'" id="ppa_'.sprintf('%03d',$x).'" value="'.$Pa.'" class="ramal" />'."\n";
   }
   return $Saida;
 }


/**************************************************************
  Funcao salva_periodo
 *************************************************************/
 function salva_periodo($Dados,$Tipo){
   global $Agen;
   $Quanti = 0;
   if ($Tipo=="S")     $Quanti = (int)$Dados['total_periodos'];
   elseif ($Tipo=="A") $Quanti = (int)$Dados['total_periodos']+1;
   for ($x=0; $x<$Quanti+1; $x++) {
     if ($x>0) $Dados['ppd_'.sprintf('%03d',$x)]= soma_horas($Pea,"00:01");
     $Pea = trim($Dados['ppa_'.sprintf('%03d',$x)]);
   }
   $Saida = $Agen->salva_periodos($Dados,$Quanti);
   return $Saida;
 }


/**************************************************************
  Funcao apaga_periodo
 *************************************************************/
 function apaga_periodo($Dados){
   global $Agen;
   $Saida = "";
   if (!isset($Dados['apaga_pe'])) $Saida = false;
   else $Saida = $Agen->apaga_periodo($Dados['apaga_pe']);
   return $Saida;
 }


/**************************************************************
  Funcao monitor_lista_filas
 *************************************************************/
 function monitor_lista_filas($Ffila=""){
   global $Moni;
   $EstadoF = $Moni->le_fila($Ffila);
   $Saida   = '';
   $Saida  .= '<p class="titulo">Filas atuais</p>';
   $Saida  .= '<table class="list">'."\n";
   for ($x=0;$x<count($EstadoF);$x++){
     $Saida .= '<tr>'."\n";
     if ($Ffila!="") {
       $Saida .= '<td class="list">'.$EstadoF[$x]['filas'].'</td>'."\n";
     }
     else {
       $Saida .= '<td class="list"><a href="javascript:void(0)" onclick={window.open(""+self.location+"&fila='.$EstadoF[$x]['filas'].'","Fila'.$x.'")} class="monitora">'.$EstadoF[$x]['filas'].'</a></td>';
     }
     $Saida .= '</tr>'."\n";
   }
   $Saida .= '</table><br/>'."\n";
   return $Saida;
 }

 /****************************************************
  Funcao:    tabela_login_grupo
  Descricao: Funcao responsavel por listar os agentes
  			 cadastrado pelo agente, na tela 
             entrada_pacommoni.tela.php  
 *****************************************************/
function tabela_login_grupo($Login, $Gru=''){
	//return $Login." - ".$Gru;
	global $Agen;
	$Aux = $Agen->tb_login_grupo($Login);
	$agentes = $Aux[0];
	$GrupoLogin = $Aux[1];
	
	$Saida .= '<p class="titulo">Agentes</p>';
	//Monta titulo de grupos
	$Saida .= '<div class="gruposramais">';
	$Saida .= '<span id="gru_todos"';
	if($Gru == '' || trim($Gru) == "Geral") $Saida .= ' class="gruporamati" ';
	else $Saida .= ' class="gruporamnat" ';
	$Saida .= ' onclick="{GG=le_objeto(\'grupesc\');GG.value=\''.'Geral'.'\';mostranovadiv(GG.value,'.$Login.');}">Geral</span>';
	for ($x=0; $x<count($GrupoLogin); $x++) {
		$Saida .= '<span id="gru_'.$GrupoLogin[$x]['id'].'"';
		if($Gru == $GrupoLogin[$x]['grupomonitora']) $Saida .= ' class="gruporamati"';
		else $Saida .= ' class="gruporamnat"';
		$Saida .= '}" onclick="{GG=le_objeto(\'grupesc\');GG.value=\''.$GrupoLogin[$x]['grupomonitora'].'\';mostranovadiv(GG.value,'.$Login.');}">';
		$Saida .= $GrupoLogin[$x]['grupomonitora'].'</span>';
	}
	$Saida .= '</div>';
	
	for($i = 0; $i < count($agentes); $i++){
		if($Gru == '' || $Gru == "Geral" || $Gru == $agentes[$i]["grupomonitora"]){
			$Saida .= '<div id="pa_monit_'.$agentes[$i]['loginmonitora'].'"';
			if($agentes[$i]['ramalmonitora']!='') $agentPa[$agentes[$i]['loginmonitora']] = $agentes[$i]['ramalmonitora'];
			else $agentPa[$agentes[$i]['loginmonitora']] = "-";
			$ajuda = $agentes[$i]["ramalmonitora"]." - ".$agentes[$i]["nome"];
			if ($agentes[$i]['situacaomonitora']=='U' || $agentes[$i]['ramalmonitora']=='') {
				$Saida .= ' class="luzramalnre"';
				$ajuda = $agentes[$i]["nome"];
			} elseif ($agentes[$i]['situacaomonitora']=='L') $Saida .= ' class="luzramalliv"';
			elseif ($agentes[$i]['situacaomonitora']=='O') $Saida .= ' class="luzramalocu"';
			elseif ($agentes[$i]['situacaomonitora']=='C') $Saida .= ' class="luzramalcha"';
			elseif ($agentes[$i]['situacaomonitora']=='P') {
				//Verifica a cor que deve ficar de acordo com o tipo de pausa
				$tipoPausa = $Agen->carrega_pausa_pelo_agente($agentes[$i]['loginmonitora']);
				$bg = $tipoPausa[0]['cormonitpa'];
				$Saida .= ' class="luzramalneu" style="background-color:#'.$bg.';  color:#FFFFFF; "';
			}
			$Saida .= '';
			$Saida .= 'onclick="menu_cadastro(\''.$agentes[$i]['login'].'\', \''.$Login.'\');" style="cursor:pointer;"';
			$Saida .= ' onMouseover="ajuda(event,\'L\',\''.$ajuda.'\');" onMouseout="ajuda(event,\'D\',\'\');" >'.$agentes[$i]['loginmonitora'].'</div>'."\n";
		}
	}
	$Saida .= "<input type='hidden' id='agentPa' value='".json_encode($agentPa)."'/>";
	return $Saida;
}

/*function tabela_login_grupo($Gru='',$Login) {
	global $Agen;
	$Aux = $Agen->tb_login_grupo($Login);
	$Grupo = $Aux[0];
	$GrupoLogin = $Aux[1];
	$NomeAgente = $Aux[2];

	$Saida = "";

	$Saida .= '<p class="titulo">Agentes</p>';
	$Saida .= '<div class="gruposramais">';
	$Saida .= '<span id="gru_todos"';
	if($Gru != '') {
		$Saida .= ' class="gruporamati" ';
		$Saida .= ' onclick="{GG=le_objeto(\'grupesc\');GG.value=\''.'Geral'.'\';mostranovadiv(GG.value,'.$Login.');}">Geral</span>';
		for ($x=0; $x<count($GrupoLogin); $x++) {
			$Saida .= '<span id="gru_'.$GrupoLogin[$x]['id'].'"';
			$Saida .= ' class="gruporamati"';
			$Saida .= '}" onclick="{GG=le_objeto(\'grupesc\');GG.value=\''.$GrupoLogin[$x]['grupomonitora'].'\';mostranovadiv(GG.value,'.$Login.');}">';
			$Saida .= $GrupoLogin[$x]['grupomonitora'].'</span>';
		}
		$Saida .= '</div>';
	}
	if($Gru == 'Geral' || $Gru =='') {
		$Saida .= '<div id="teste">';
		for($x = 0; $x <count($Grupo); $x++) {
			$ir = false;
			if($Login!="")$ir = true;
			//verifica se tem ramal logado nesse agente
			if($Grupo[$x]['ramalmonitora'] != '') {
				if ($ir) {
					if($Grupo[$x]['agentemonitora'] == $Login) {
						$Saida .= '<div id="pa_monit_'.$Grupo[$x]['ramalmonitora'].'"';
						$y = 0;
						$Achei = false;
						while(!$Achei) {
							if($Grupo[$x]['loginmonitora']==$NomeAgente[$y]['login']) {
								$Ajuda = $NomeAgente[$y]['nome'];
								$Achei = true;
							} else {
								$y++;
								if($y>=count($NomeAgente)) $Achei=true;
							}
						}
						if ($Grupo[$x]['situacaomonitora']=='U')     $Saida .= ' class="luzramalnre"';
						elseif ($Grupo[$x]['situacaomonitora']=='L') $Saida .= ' class="luzramalliv"';
						elseif ($Grupo[$x]['situacaomonitora']=='O') $Saida .= ' class="luzramalocu"';
						elseif ($Grupo[$x]['situacaomonitora']=='C') $Saida .= ' class="luzramalcha"';
						elseif ($Grupo[$x]['situacaomonitora']=='P') {
							//Verifica a cor que deve ficar de acordo com o tipo de pausa
							$tipoPausa = $Agen->carrega_pausa_pelo_agente($Grupo[$x]['loginmonitora']);
							$bg = $tipoPausa[0]['cormonitpa'];
							$Saida .= ' class="luzramalneu" style="background-color:#'.$bg.';  color:#FFFFFF; "';
						}
						$Saida .= '';
						$Saida .= 'onclick="menu_cadastro(\''.$NomeAgente[$y]['login'].'\', \''.$Login.'\');" style="cursor:pointer;"';
						$Saida .= ' onMouseover="ajuda(event,\'L\',\''.$Ajuda.'\');" onMouseout="ajuda(event,\'D\',\'\');" >'.$Grupo[$x]['ramalmonitora'].'</div>'."\n";
					}
				}
			}
		}
		$Saida .= '</div>';
	} else {
		$Saida .= '<div id="teste">';
		for($x = 0; $x <count($Grupo); $x++) {
			$ir = false;
			if($Login!="")$ir = true;
			//verifica se tem ramal logado nesse agente
			if($Grupo[$x]['ramalmonitora'] != '') {
				if ($ir) {
					if($Grupo[$x]['agentemonitora'] == $Login) {
						if($Grupo[$x]['grupomonitora']== $Gru) {
							$Saida .= '<div id="ram_'.$Grupo[$x]['loginmonitora'].'"';
							$y = 0;
							$Achei = false;
							while(!$Achei) {
								if($Grupo[$x]['loginmonitora']==$NomeAgente[$y]['login']) {
									$Ajuda = $NomeAgente[$y]['nome'];
									$Achei = true;
								} else {
									$y++;
									if($y>=count($NomeAgente)) $Achei=true;
								}
							}
							if ($Grupo[$x]['situacaomonitora']=='U')     $Saida .= ' class="luzramalnre"';
							elseif ($Grupo[$x]['situacaomonitora']=='L') $Saida .= ' class="luzramalliv"';
							elseif ($Grupo[$x]['situacaomonitora']=='O') $Saida .= ' class="luzramalocu"';
							elseif ($Grupo[$x]['situacaomonitora']=='C') $Saida .= ' class="luzramalcha"';
							elseif ($Grupo[$x]['situacaomonitora']=='P') $Saida .= ' class="luzramalpau"';
							$Saida .= ' class="luzramalliv"';
							$Saida .= '';
							$Saida .= 'onclick="menu_cadastro(\''.$NomeAgente[$y]['login'].'\', \''.$Login.'\');" style="cursor:pointer;"';
							$Saida .= ' onMouseover="ajuda(event,\'L\',\''.$Ajuda.'\');" onMouseout="ajuda(event,\'D\',\'\');" >'.$Grupo[$x]['ramalmonitora'].'</div>'."\n";
						}
					}
				}
			}
		}
		$Saida .= '</div>';
	}
	return $Saida;
}*/
 
 /****************************************************
 Funcao:    pesquisa_chat_por_periodo
 Descricao: Função responsável por criar a tabela que
 			mostra o histórico do chat para o super-
            visor.
 *****************************************************/
 function pesquisar_chat_por_periodo($De, $Ate)
 {
 	global $DirRaiz, $DirChat;
    $Saida = '<table>';
    $Saida .= '<tr><td width="50">De</td><td width="150">Para</td><td width="100">Data</td><td width="50">Ver</td></tr>';
 	$diretorio = $DirRaiz.$DirChat;
    $ponteiro = opendir($diretorio);
    
    $dataD_format = explode('/', $De);
    $De = $dataD_format[2].'-'.$dataD_format[1].'-'.$dataD_format[0];
    
    $dataA_format = explode('/', $Ate);
    $Ate = $dataA_format[2].'-'.$dataA_format[1].'-'.$dataA_format[0];
    
    while($nome_itens = readdir($ponteiro)){
    	$itens[] = $nome_itens;
    }
    
    sort($itens);
    
    foreach($itens as $nome_item)
    {
    	$nome = explode('_', $nome_item);
        $nomes_ramais = explode('-',$nome[0]);
        $agente_para = explode('-',$nome[1]);
        $data_mens = explode(".txt.bak",$nome[2]);
        if(($data_mens[0] >= $De) && ($data_mens[0] <= $Ate) && ($nome_item != '.') && ($nome_item != '..'))
        {
        	$Saida .= '<tr><td width="50">'.$nomes_ramais[0].'</td><td width="150">'.$agente_para[1].' - '.$agente_para[0].'</td><td width="100">'.$data_mens[0].'</td><td width="50"><div class="luzramalliv" style="{cursor:pointer;}" onclick="mostra_chat(\''.$diretorio.$nome_item.'\');">Ver</div></td></tr>';
        }
    }
    $Saida .= '</table>';
    return $Saida;
 }
 
 function le_arquivo_chat($caminho)
 {
 	if(filesize($caminho)!=0)
    {
 		$fp = fopen($caminho, 'r');
        $texto = fread($fp, filesize($caminho));
        fclose($fp);
        
    }
    else
    {
    	$texto = 'Arquivo em branco.';
    }
    return $texto;
 }
 
  /****************************************************
 Funcao:    salva_config_geral
 Descricao: Função responsável por salvar as configura-
 			ções gerais que o supervisor definiu na 
            tela ccger.tela.php
 *****************************************************/
 function salva_config_geral($Dados)
 {
 	global $Agen;
    $Saida = $Agen->salva_configs_geral($Dados);
    return $Saida;
 }
 
 /****************************************************
 Funcao:    carrega_config_geral
 Descricao: Funcao responsavel por carregar as confi-
 			guracoes gerais que o supervisor definiu
            na tela ccger.tela.php
 *****************************************************/
 function carrega_config_geral()
 {
 	global $Agen;
    $Saida = $Agen->carrega_configs_geral();
    return $Saida;
 }
 
 /*****************************************************
  Funcao:    lista_fila_usuario
  Descricao: Funcao responsavel por carregar a lista
             de filas em um select na tela de 
			 monitoramento
 *****************************************************/
 function lista_fila_usuario($Tipo, $user){
   global $Agen;
   $AuxF = $Agen->lista_filas($Ativo);
   $Filas = $AuxF[4];  
   if  ($Tipo=='option') {
     for ($x=0; $x<count($Filas); $x++){
       $i = $Fil[$x]['id'];
       $Saida .= '<option value="'.$Filas[$x]['pseudonimo'].'">'.$Filas[$x]['pseudonimo'].'</option>';
     } 
   }
}

/***************************************************
	Função: 	lista_filas_agente
	Descrição: 	Função responsável por carregar as
				filas que aquele agente atende em
				um array.
****************************************************/
function lista_filas_agente($Agente){
	global $Agen;
	$Res = $Agen->carrega_filas_agente($Agente, "array");
	return $Res;
}

/**************************************************
	Função:		lista_codigos_conta
    Descrição: 	Função responsável por listar
    			os códigos de conta cadastrados.
**************************************************/
function lista_codigos_conta($tipo){
	global $Agen;
    $Res = $Agen->lista_codigos_contas();
    $Saida = "";
    for($x = 0; $x < count($Res); $x++){
    	if($tipo == "href"){
        	$i = $Res[$x]['id'];
           $Saida .= '<a href="#" id="cco_'.sprintf('%09d',$i).'" onclick="mostra_cod_conta('.$i.')" class="listagem">'.$Res[$x]['codigo'].' - '.$Res[$x]['nome'].'</a><br/>'."\n";
           $Saida .= '<input type="hidden" name="id_'.sprintf('%09d',$i).'" id="id_'.sprintf('%09d',$i).'" value="'.$Res[$x]['id'].'"/>'."\n";
           $Saida .= '<input type="hidden" name="cod_'.sprintf('%09d',$i).'" id="cod_'.sprintf('%09d',$i).'" value="'.$Res[$x]['codigo'].'"/>'."\n";
           $Saida .= '<input type="hidden" name="nom_'.sprintf('%09d',$i).'" id="nom_'.sprintf('%09d',$i).'" value="'.$Res[$x]['nome'].'"/>'."\n";
        }
    }
    return $Saida;
}


/*************************************************
	Função:		altera_cod_conta
    Descrição:	Função responsável por alterar os 
    			dados do código de conta
**************************************************/
function altera_cod_conta($dados){
	global $Agen;
	$id = $dados['identif'];
    $codigo = $dados['codigo'];
    $nome = $dados['nome'];
	$Saida = $Agen->alterar_cod_conta($id, $codigo, $nome);
    return $Saida;
}

/*************************************************
	Função:		insere_cod_conta
    Descrição:	Função responsável por inserir os 
    			dados do código de conta
**************************************************/
function insere_cod_conta($dados){
	global $Agen;
    $codigo = $dados['codigo'];
    $nome = $dados['nome'];
	$Saida = $Agen->inserir_cod_conta($codigo, $nome);
    return $Saida;
}

/*************************************************
	Função:		deleta_cod_conta
    Descrição:	Função responsável por deletar os 
    			dados do código de conta
**************************************************/
function deleta_cod_conta($dados){
	global $Agen;
	$id = $dados['identif'];
	$Saida = $Agen->deletar_cod_conta($id);
    return $Saida;
}

/*************************************************
	Função:		carrega_fila_entrar_pausa_auto
    Descrição:	Carrega o campo entrarpausaauto 
    			da tabela vm50_filas
**************************************************/
function carrega_fila_entrar_pausa_auto(){
	global $Agen;
    $Saida = $Agen->carrega_fila_entrar_pausa_auto();
    return $Saida;
}

/*************************************************
	Função:		carrega_fila_retirar_pausa_auto
    Descrição:	Carrega o campo entrarpausaauto 
    			da tabela vm50_filas
**************************************************/
function carrega_fila_retirar_pausa_auto(){
	global $Agen;
    $Saida = $Agen->carrega_fila_retirar_pausa_auto();
    return $Saida;
}

function lista_dados_agente($login){
	Global $Agen;
	$Saida = $Agen->carrega_agente_por_login($login);
	return $Saida;
}

function lista_agentes_nao_relacionados(){
	Global $Agen;
	$Saida = "";
	$Agentes = $Agen->lista_agentes_nao_relacionados();
	for($i = 0; $i < count($Agentes); $i++){
		$Saida .= '<option value="'.$Agentes[$i]['id'].'">'.$Agentes[$i]['login'].' - '.$Agentes[$i]['nome'].'</option>';
	}
	return $Saida;
}

function lista_agentes_relacionados_geral(){
	Global $Agen;
	
	$Saida = "";
	$Agentes = $Agen->lista_agentes();
	$Agentes = $Agentes[0];
	for($i = 0; $i < count($Agentes); $i++){
		$Dados = $Agen->lista_agentes_relacionados($Agentes[$i]['id']);
		if(count($Dados)>0){
			for($j = 0; $j < count($Dados); $j++){
				$Saida .= $Agentes[$i]['id'].";".$Dados[$j]['id'].';'.$Dados[$j]['login'].' - '.$Dados[$j]['nome']."|";
			}
			$Saida = substr($Saida, 0, (strlen($Saida) - 1));
			$Saida .= "||";
		}
	}
	return $Saida;
}

function lista_agentes_relacionados_por_agente($login){
	Global $Agen;
	$idAgente = $Agen->lista_id_pelo_login($login);
	return $Agen->lista_agentes_relacionados($idAgente);
}

function lista_ramais_relacionados_por_ramal($ramal){
	Global $Agen;
	return $Agen->lista_ramais_relacionados($ramal);
}

function carrega_grupo_por_agente($Agente){
	Global $Agen;
	return $Agen->carrega_grupo_por_agente($Agente);
}

function carrega_alarmes_por_id_usuario($Id){
	Global $Agen;
	$Alarmes = $Agen->carrega_alarmes_por_id($Id);
	$Saida = "";
	if(count($Alarmes)>0){
		foreach($Alarmes[0] as $Chave => $valor){
			$Saida .= '<input type="hidden" name="'.$Chave.'" id="'.$Chave.'" value="'.$valor.'"/>';
		}
	}
	return $Saida;
}

/**************************************************************
  Funcao altera_alarmes
 *************************************************************/
 function altera_alarmes($Dados) {
   global $Agen;
   $Saida = "";
   ($Dados['gcon']=='on') ? $Dados['gcon'] = "t" : $Dados['gcon'] = "f";
   ($Dados['fcon']=='on') ? $Dados['fcon'] = "t" : $Dados['fcon'] = "f";
   ($Dados['xcon']=='on') ? $Dados['xcon'] = "t" : $Dados['xcon'] = "f";
   ($Dados['tpau']=='on') ? $Dados['tpau'] = "t" : $Dados['tpau'] = "f";
   ($Dados['tliv']=='on') ? $Dados['tliv'] = "t" : $Dados['tliv'] = "f";
   ($Dados['tcos']=='on') ? $Dados['tcos'] = "t" : $Dados['tcos'] = "f";
   ($Dados['tcoa']=='on') ? $Dados['tcoa'] = "t" : $Dados['tcoa'] = "f";
   ($Dados['tcon']=='on') ? $Dados['tcon'] = "t" : $Dados['tcon'] = "f";
   ($Dados['tesa']=='on') ? $Dados['tesa'] = "t" : $Dados['tesa'] = "f";
   $Saida = $Agen->altera_alarmes($Dados['usuario'], $Dados['gcon'], $Dados['fcon'], $Dados['xcon'], $Dados['tpau'], $Dados['tliv'], $Dados['tcos'], $Dados['tcoa'], $Dados['tcon'], $Dados['tesa']);
   return $Saida;
 }
 
 function lista_uf($tipo){
	Global $Agen;
	$ufs = $Agen->lista_uf();
	$saida = "";
	if($tipo == "option"){
		foreach($ufs as $uf){
			$saida .= "<option value = '".$uf['uf']."'>".$uf['uf']."</option>";
		}
	}
	return $saida;
 }
 
 function altera_config_syonet($dados){
 	 Global $Agen;
	 $saida = $Agen->alterar_config_syonet($dados["ip_crm"], $dados["usuario_crm"], $dados["senha_crm"], $dados["dominio_crm"]);
	 return $saida;
 }
 
function lista_config_syonet($tipo){
	Global $Agen;
	$dados = $Agen->listar_config_syonet();
	if($tipo == "hidden"){
		$dados = $dados[0];
		foreach($dados as $chave => $valor){
			$saida .= '<input type="hidden" id="'.$chave.'_bd" value="'.$valor.'"/>';
		}
	}
	return $saida;
}

function inclui_fila_syonet($dados){
	Global $Agen;
	if($dados["fila_crm"] == "" || $dados["operacao_crm"] == "" || $dados["empresa_crm"] == "" || $dados["mcdu_crm"] == "" || $dados["caixa_crm"] == "") return false;
	$saida = $Agen->incluir_fila_syonet($dados["fila_crm"], $dados["operacao_crm"], $dados["empresa_crm"], $dados["mcdu_crm"], $dados["caixa_crm"], $dados["email_notifica"]); 
	return $saida;
}

function altera_fila_syonet($dados){
	Global $Agen;
	if($dados["identif"] == "" || $dados["fila_crm"] == "" || $dados["operacao_crm"] == "" || $dados["empresa_crm"] == "" || $dados["mcdu_crm"] == "" || $dados["caixa_crm"] == "") return false;
	$saida = $Agen->alterar_fila_syonet($dados["identif"], $dados["fila_crm"], $dados["operacao_crm"], $dados["empresa_crm"], $dados["mcdu_crm"], $dados["caixa_crm"], $dados["email_notifica"]);
	return $saida;
}

function deleta_fila_syonet($id){
	Global $Agen;
	if($id == "") return false;
	$saida = $Agen->deletar_fila_syonet($id);
	return $saida;
}

function listar_filas_syonet($tipo){
	Global $Agen;
	$dados = $Agen->listar_filas_syonet();
	
	if($tipo == "href"){
		for($i = 0; $i < count($dados); $i++){
			$id = $dados[$i]["id"];
			$saida .= '<a href="#" id="fila_syonet_'.sprintf('%09d',$i).'" onclick="mostra_fila_syonet('.$id.')" class="listagem">'.$dados[$i]['fila_crm'].'</a><br/>'."\n";
			foreach($dados[$i] as $chave => $valor){
				$saida .= '<input type="hidden" name="'.$chave.'_'.sprintf('%09d',$id).'" id="'.$chave.'_'.sprintf('%09d',$id).'" value="'.$valor.'"/>'."\n";
			}
		}
	}
	
	return $saida;
}

function alterar_config_painel_pa($dados){
    Global $Agen;

    if($dados["identif"]=="") return;
    return $Agen->alterar_config_painel_pa($dados["identif"], $dados["ip_discador"], $dados["ddd_local"]);
}

function listar_config_painel_pa($tipo){
    Global $Agen;
    return $Agen->listar_config_painel_pa();
}

function listar_agentes_pelo_grupo($tipo, $grupo){
    Global $Agen;
    $agentes = $Agen->listar_agentes_pelo_grupo($grupo);
    if($tipo == "array"){
        $saida = $agentes;
    }
    return $saida;
}

function altera_config_email($dados){
    Global $Agen;
    $saida = $Agen->alterar_config_email($dados["email"], $dados["senha"], $dados["smtp"], $dados["porta_smtp"]);
    return $saida;
}

function carregar_conf_email($tipo){
    Global $Agen;
    $dados = $Agen->carregar_conf_email();
    if($tipo == "array") return $dados;
}

function listar_pausas_grupo($idGrupo, $tipo){
    Global $Agen;
    $dados = $Agen->listar_pausas_grupo($idGrupo);
    if($tipo=='option3'){
        for ($x=0; $x<count($dados); $x++) {
            if($dados[$x]['habilitaparapa']=='t'){
                $saida .= '<option value="'.$dados[$x]['nome'].'"';
                $saida .= '>'.$dados[$x]['nome'].'</option>';
            }
        }
    } else if($tipo == "id_pausa"){
        $i = 0;
        $saida = array();
        for ($x=0; $x<count($dados); $x++) {
            $saida[$i]["id_pausa"] = $dados[$x]["id"];
            $saida[$i]["id_grupo"] = $idGrupo;
            $i++;
        }
    }
    return $saida;
}

function listar_grupos_consultar_membros_filas(){
    Global $Agen;
    $grupos = $Agen->listar_grupos_consultar_membros_filas();
    return $grupos;
}

function listar_grupos_filas_relat($tipo){
	Global $Agen;
	$saida = "";
	$grupos = $Agen->listar_grupos_filas_relat();
	if($tipo == "href"){
		foreach($grupos as $chave => $valor){
			$i = $valor["id"];
			$filas = "";
			$saida .= '<a href="#" id="grupo_'.sprintf('%09d',$i).'" onclick="mostrar_grupo_filas_relat('.$i.')" class="listagem">'.$valor["nome"].'</a><br/>'."\n";
			$saida .= '<input type="hidden" name="id_'.sprintf('%09d',$i).'" id="id_'.sprintf('%09d',$i).'" value="'.$valor["id"].'"/>'."\n";
			$saida .= '<input type="hidden" name="nome_'.sprintf('%09d',$i).'" id="nome_'.sprintf('%09d',$i).'" value="'.$valor["nome"].'"/>'."\n";
			
			for($j = 0; $j < count($valor["filas"]); $j++){
				$filas .= $valor["filas"][$j]["id"]."|".$valor["filas"][$j]["pseudonimo"];
				if($j < count($valor["filas"])-1) $filas .= "||";
			}
			$saida .= '<input type="hidden" name="filas_'.sprintf('%09d',$i).'" id="filas_'.sprintf('%09d',$i).'" value="'.$filas.'"/>'."\n";
		}
	}
	return $saida;
}

function incluir_grupo_filas_relat($dados){
	Global $Agen;
	$id = $Agen->incluir_grupo_filas_relat($dados["nome"]);
	if(count($dados["filr"]) > 0){
		for($i = 0; $i < count($dados["filr"]); $i++){
			$Agen->alterar_grupo_fila_relat($id, $dados["filr"][$i]);
		}
	}
	if(count($dados["fill"]) > 0){
		for($i = 0; $i < count($dados["fill"]); $i++){
			$Agen->alterar_grupo_fila_relat(0, $dados["fill"][$i]);
		}
	}
	return true;
}

function alterar_grupo_filas_relat($dados){
	Global $Agen;
	if($dados["identif"] == "" || $dados["nome"] == "") return false;
	$Agen->alterar_grupo_filas_relat($dados["identif"], $dados["nome"]);
	if(count($dados["filr"]) > 0){
		for($i = 0; $i < count($dados["filr"]); $i++){
			$Agen->alterar_grupo_fila_relat($dados["identif"], $dados["filr"][$i]);
		}
	}
	if(count($dados["fill"]) > 0){
		for($i = 0; $i < count($dados["fill"]); $i++){
			$Agen->alterar_grupo_fila_relat(0, $dados["fill"][$i]);
		}
	}
	return true;
}

function deletar_grupo_filas_relat($dados){
	Global $Agen;
	if($dados["identif"] == 0) return false;
	return $Agen->deletar_grupo_filas_relat($dados["identif"]);
}

function listar_qualificacoes_pelo_grupo($idGrupo, $tipo){
	Global $Agen;
	$dados = $Agen->listar_qualificacoes_pelo_grupo($idGrupo);
	if($tipo == "id_qualificacao"){
		for($i = 0; $i < count($dados); $i++){
			$saida[] = $dados[$i]["id"];
		}
	}
	return $saida;
}

function lista_classificacao_chamada_por_grupo($idGrupo){
	Global $Agen;
	$saida = array();
	$class = $Agen->listar_qualificacoes_pelo_grupo($idGrupo);
	if(count($class) > 0){
		for($i = 0; $i < count($class); $i++){
			$saida[$i]["nome"] = $class[$i]["nome"];
			$subclass = $Agen->lista_subclassificacao_chamadas_por_grupo($class[$i]["id"]);
			$saida[$i]["subclassificacao"] = $subclass;
		}
	}
	return $saida;
}
?>
