<?php
/***************************************************
Autor:     Leandro N. de Araujo,  Renato Nogueira
Data:      08/04/2011
Descricao: Modulo da tela de Monitoramento
           de Grades de Fila
***************************************************/
 $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
 include_once($DirRaiz.'config.php');
 include_once($DirRaiz.'config.cc.php');
 $Modulo = $DirCCen;
 include_once($DirRaiz.$Modulo.$DirClass.'monitor.class.php');
 include_once($DirRaiz.$DirCCen.$DirClass.'agentes.class.php');
 include_once($DirRaiz.$DirCCen.$DirModul.'cc.modu.php');
 include_once($DirRaiz.$DirModul.'geral.modu.php');
	
 /************************
  Atributo classe Agente
 ************************/
 $Agen  = new Agentes; 
 $Moni  = new Monitores;
 

 
 $Data = date("d/m/Y");
 /****************************
  Variavel que recebe GET
 ****************************/
 $L_var  = $_GET; 
 $L_post = $_POST;

 if($L_var['function'] == "array"){
	for($i = 0; $i < $L_var['lista']; $i++){
		$ListaArray[$i] = $L_var[$i];
	}
	//$Tabela = tabela_grade_fila($ListaArray);
	tabela_grade_fila($ListaArray,$L_var['usuario']);
 }
 if($L_var['function'] == "listafila"){
    for($i = 0; $i < $L_var['lista']; $i++){
		$ListaArray[$i] = $L_var[$i];
	}
    echo lista_filas($ListaArray,$L_var['usuario']);
 }
 if($L_var['function'] == "gradeespera"){
    for($i = 0; $i < $L_var['lista']; $i++){
		$ListaArray[$i] = $L_var[$i];
	}
    echo lista_grades_espera($ListaArray,$L_var['usuario']);
 }
 if($L_var['function'] == "gradeatendimento"){
    for($i = 0; $i < $L_var['lista']; $i++){
		$ListaArray[$i] = $L_var[$i];
	}
    echo lista_grades_atendimento($ListaArray,$L_var['usuario']);
 }

 return;
 
 /*****************************************
  Funcao:      lista_filas
  Descricao:   Esta funcao recebe as filas 
               selecionadas pelo usuario
               para montar a tabela grade 
               de monitoramento de filas			   
 *****************************************/
 function lista_filas($ListaArray,$user){
  global $Agen, $Moni, $Data;
  
  list($Dia,$Mes,$Ano) = explode("/",$Data);
  $Aux_a = $Ano."-".$Mes."-".$Dia." 00:00";
  $Aux_d = $Ano."-".$Mes."-".$Dia." 23:59";
  
  $Saida  = '';
  $Saida .= '<p class="hora">Hora do sistema:'.date("d/m/y H:i:s").'</p>';
 
  $Saida .= lista_grades_desistencia($ListaArray,$user);
  
  return $Saida;
 }
 
 /****************************************************
 Funcao:      lista_grades_desistencia
 Descricao:   Funcao monta tabelas de ligacoes 
              que desistiram na fila.
			  A tabela e montada conforme arquivo 
			  ini
 ****************************************************/
 function lista_grades_desistencia($ListaArray,$user){
    global $Agen, $Moni, $Data;
	list($Dia,$Mes,$Ano) = explode("/",$Data);
	$Aux_a = $Ano."-".$Mes."-".$Dia." 00:00";
	$Aux_d = $Ano."-".$Mes."-".$Dia." 23:59";
    
	$Saida  = '';
	
	$TempoInicial = $TempoFinal = $Tempo = 0;
	
    $Array = parse_ini_file($_SERVER['DOCUMENT_ROOT'].'/vdt/tabelatxt/'.$user.'.ini',true);
	for($i = 0; $i<count($ListaArray); $i++){
	    $Dados = $Moni->relatorio_grades_filas($ListaArray[$i],$Aux_a,$Aux_d,$Array,$Tipo='desistencias');
		$Desistencias = $Dados[0];

		$Quant = $Desistencias;
	    $Saida .= '<p class="titulo">Grades de Desistncias - Fila : '.$ListaArray[$i].'</p>';
		$Saida .= '<table class="list">';
		$Saida .= '<tr>';
		
		for($x = 1; $x < count($Array[$ListaArray[$i]."_desistencias"]); $x++){
			if($x <= 9){
				$Saida .= '<td class="listT"><span class="legenda" title="Quantidade de Desistncias de no mximo ';
				$Saida .= $Array[$ListaArray[$i]."_desistencias"]['pos0'.$x].'" segundos>';
				$Saida .= $Array[$ListaArray[$i]."_desistencias"]['pos0'.$x].' segs</span></td>';
			}
			else{
				$Saida .= '<td class="listT"><span class="legenda" title="Quantidade de Desistncias de no mximo ';
				$Saida .= $Array[$ListaArray[$i]."_desistencias"]['pos'.$x].' segundos">';
				$Saida .= $Array[$ListaArray[$i]."_desistencias"]['pos'.$x].' segs</span></td>';
			}
		}
		$Saida .= '</tr>';
		$z = 1;
		
		if(!$Quant){ 
			$Saida .= '<tr>';
			while($z < 20){
				$Saida .= '<td class="list">0</td>';
				$z++;
			}
			$Saida .= '</tr>';
		}
		else{
			$Saida .= '<tr>';
			for($x = 1; $x < count($Array[$ListaArray[$i]."_desistencias"]); $x++){			
				if($x <= 9) $Saida .= '<td class="list">'.$Quant['pos0'.$x].'</td>';
				else $Saida .= '<td class="list">'.$Quant['pos'.$x].'</td>';
			}
			$Saida .= '</tr>';
		}
		$Saida .= '</table>';
	}

	
	return $Saida;
 }
 
 /****************************************************
 Funcao:      lista_grades_espera
 Descricao:   Funcao monta tabelas de ligacoes 
              que ficaram na espera 
			  em respectiva fila
			  A tabela e montada conforme arquivo 
			  ini
 ****************************************************/
 function lista_grades_espera($ListaArray,$user){
    global $Data;
    list($Dia,$Mes,$Ano) = explode("/",$Data);
    $Aux_a = $Ano."-".$Mes."-".$Dia." 00:00";
    $Aux_d = $Ano."-".$Mes."-".$Dia." 23:59";
	
	$Saida  = '';

	
	$Array = parse_ini_file($_SERVER['DOCUMENT_ROOT'].'/vdt/tabelatxt/'.$user.'.ini',true);
	for($i = 0; $i<count($ListaArray); $i++){
	    $Saida .= '<p class="titulo">Grades de Esperas - Fila : '.$ListaArray[$i].'</p>';
		$Saida .= '<table class="list">';
		$Saida .= '<tr>';
		
		for($x = 1; $x < count($Array[$ListaArray[$i]."_esperas"]); $x++){
			if($x <= 9){
				$Saida .= '<td class="listT"><span class="legenda" title="Quantidade de Esperas de no mximo ';
				$Saida .= $Array[$ListaArray[$i]."_esperas"]['pos0'.$x].' segundos">';
				$Saida .= $Array[$ListaArray[$i]."_esperas"]['pos0'.$x].' segs</span></td>';
			}
			else{
				$Saida .= '<td class="listT"><span class="legenda" title="Quantidade de Esperas de no mximo ';
				$Saida .= $Array[$ListaArray[$i]."_esperas"]['pos'.$x].' segundos">';
				$Saida .= $Array[$ListaArray[$i]."_esperas"]['pos'.$x].' segs</span></td>';
			}
		}
		$Saida .= '</tr>';
		$Saida .= '</table>';
	}

	
	return $Saida;
 }
 
 /****************************************************
 Funcao:      lista_grades_atendimento
 Descricao:   Funcao monta tabelas de ligacoes 
              que foram atendidas da fila.
			  A tabela e montada conforme arquivo 
			  ini
 ****************************************************/
 function lista_grades_atendimento($ListaArray,$user){
    global $Data;
    list($Dia,$Mes,$Ano) = explode("/",$Data);
    $Aux_a = $Ano."-".$Mes."-".$Dia." 00:00";
    $Aux_d = $Ano."-".$Mes."-".$Dia." 23:59";
 
    $Array = parse_ini_file($_SERVER['DOCUMENT_ROOT'].'/vdt/tabelatxt/'.$user.'.ini',true);
 	$Saida  = '';
	
	for($i = 0; $i<count($ListaArray); $i++){
		$Saida .= '<p class="titulo">Grades de Atendimentos - Fila : '.$ListaArray[$i].'</p>';
		$Saida .= '<table class="list">';
		$Saida .= '<tr>';
		
		for($x = 1; $x < count($Array[$ListaArray[$i]."_atendimentos"]); $x++){
			if($x <= 9){
				$Saida .= '<td class="listT"><span class="legenda" title="Quantidade Atendimento de no mximo ';
				$Saida .= $Array[$ListaArray[$i]."_atendimentos"]['pos0'.$x].' segundos">';
				$Saida .= $Array[$ListaArray[$i]."_atendimentos"]['pos0'.$x].' segs</span></td>';
			}
			else{
				$Saida .= '<td class="listT"><span class="legenda" title="Quantidade de Esperas de no mximo ';
				$Saida .= $Array[$ListaArray[$i]."_atendimentos"]['pos'.$x].' segundos">';
				$Saida .= $Array[$ListaArray[$i]."_atendimentos"]['pos'.$x].' segs</span></td>';
			}
		}
		$Saida .= '</tr>';
		$Saida .= '</table>';
	}
	
	return $Saida;
 }

 /****************************************************
 Funcao:      tabela_grade_fila
 Descricao:   Funcao cria um arquivo ini das filas 
			  com atendimentos, esperas e desistencias
			  O arquivo e criado como o id do usuario,
			  sendo unico para cada usuario

			  [fila_tipo]
			  chave = valor

Ex:           [SUPORTE_esperas]
			  pos1=0
			  pos2=10
			  ...
			  
			  [SUPORTE_desistencias]
			  pos1=15
			  pos2=30
			  ...
 ****************************************************/
 function tabela_grade_fila($ListaArray,$user){
    global $Agen;
	$Array = $ListaArray;
	$Saida = '';
	
	$Resultado['atendimentos'] = array();
	$Resultado['esperas'] 	   = array();
	$Resultado['desistencias'] = array();
	/*if(!file_exists($_SERVER['DOCUMENT_ROOT'].'/vdt/tabelatxt')){
		mkdir($_SERVER['DOCUMENT_ROOT'].'/vdt/tabelatxt');
		chgrp($_SERVER['DOCUMENT_ROOT'].'/vdt/tabelatxt','root');
		chown($_SERVER['DOCUMENT_ROOT'].'/vdt/tabelatxt','root');
		chmod($_SERVER['DOCUMENT_ROOT'].'/vdt/tabelatxt',0777);
	}*/
	$fp = fopen($_SERVER['DOCUMENT_ROOT'].'/vdt/tabelatxt/'.$user.'.ini','w+');
	
	for($i = 0; $i < count($Array); $i++){
		$Dados = $Agen->lista_campos_tabelagrade($Array[$i]);
		for($x = 0; $x < count($Dados); $x++){
			if($Dados[$x]['tipo'] != 'queue'){
				fwrite($fp,'['.$Dados[$x]['nome'].'_'.$Dados[$x]['tipo'].']'."\n");
				for($y = 1; $y <= 20; $y++){
					if($y <= 9)
						fwrite($fp,'pos0'.$y.' = '.$Dados[$x]['pos0'.$y]."\n");
					else
						fwrite($fp,'pos'.$y.' = '.$Dados[$x]['pos'.$y]."\n");
				}fwrite($fp,"\n\n");
			}
		}
	}
	fclose($fp);
	return $Saida;
 }
 
?>