<?php
/**************************************************************
 * Nome:    CCRelatmascaras
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2009-03-17 (V1.0.0)
 * Descr.:  Mascara dos relatorios Relatorios
 *************************************************************/



/**************************************************************
  Funcao monta_relatorio_estado_atual
 *************************************************************/
 function monta_relatorio_estado_atual($Dados,$LPaus,$Formato="html"){
   if (!$Dados) return "Erro";
   $Login = $Dados[0];
   $Tempo = $Dados[1];
   $Quant = $Dados[2];
   $Campo = array(
      0=>array("Tempo livre",formata_hora($Tempo['Livre'])),
      1=>array("Tempo em Pausa",formata_hora($Tempo['Em Pausa'])),
      2=>array("Tempo conversando em atendimento de Filas",formata_hora($Tempo['Fila']['Atendendo'])),
      3=>array("Tempo conversando em atendimento de Transferncias recebidas",formata_hora($Tempo['Total Transfer']['Atendendo'])),
      4=>array("Tempo conversando em atendimento de Ligaes Diretas recebidas",formata_hora($Tempo['Total DDR']['Atendendo'])),
      5=>array("Tempo conversando em atendimento de chamadas externas",formata_hora($Tempo['Chamadas externas']['Atendendo'])),
      6=>array("Tempo conversando em Sadas (fazendo chamadas externas)",formata_hora($Tempo['Fazendo chamada externa']['Atendendo'])),
      7=>array("Tempo conversando em chamadas internas realizadas",formata_hora($Tempo['Consulta-Realizadas']['Atendendo'])),
      8=>array("Tempo conversando em chamadas internas atendidas",formata_hora($Tempo['Consulta-Atendidas']['Atendendo'])),
      9=>array("Tempo chamando em sadas (fazendo chamadas externas)",formata_hora($Tempo['Fazendo chamada externa']['Chamando'])),
     10=>array("Tempo chamando em internas (fazendo chamadas internas)",formata_hora($Tempo['Consulta-Realizadas']['Chamando'])),
     11=>array("Tempo tocando (recebendo chamadas internas)",formata_hora($Tempo['Consulta-Atendidas']['Chamando'])),
     12=>array("Tempo tocando (recebendo chamadas externas)",formata_hora($Tempo['Chamadas externas']['Chamando'])),
     13=>array("Tempo logado",formata_hora($Tempo['Login'])),
     14=>array("Tempo deslogado",formata_hora($Tempo['Deslogado'])),
     15=>array("Tempo Monitorando PA",formata_hora($Tempo['Monitorando PA'])),

     16=>array("Tempo mdio conversando em sadas (fazendo chamadas externas)",formata_hora($Tempo['Fazendo chamada externa']['Atendendo-Media'])),
     17=>array("Tempo mdio conversando em atendimento",formata_hora($Tempo['Chamadas externas']['Atendendo-Media'])),
     18=>array("Tempo mdio geral conversando em chamadas externas ",formata_hora($Tempo['Total chamadas externas']['Atendendo-Media'])),
     19=>array("Tempo mdio conversando em chamadas internas realizadas",formata_hora($Tempo['Consulta-Realizadas']['Atendendo-Media'])),
     20=>array("Tempo mdio conversando em chamadas internas recebidas",formata_hora($Tempo['Consulta-Atendidas']['Atendendo-Media'])),
     21=>array("Tempo mdio geral conversando em chamadas internas",formata_hora($Tempo['Consulta']['Atendendo-Media'])),
     22=>array("Tempo mdio de demora para atendimento de chamadas externas",formata_hora($Tempo['Demora atendimento']['Chamando-Media'])),

     23=>array("Quantidade de chamadas de Filas atendidas",$Quant['Fila']['Atendendo']),
     24=>array("Quantidade de chamadas Diretas atendidas",$Quant['DDR']['Atendendo']),
     25=>array("Quantidade de transferncias atendidas",$Quant['Total transfer atendidas']['Atendendo']),
     26=>array("Quantidade total de chamadas externas atendidas",$Quant['Total externa atendidas']['Atendendo']),
     27=>array("Quantidade de transferncias efetuadas",$Quant['Total transfer efetuadas']['Chamando']),
     28=>array("Quantidade de sadas (chamadas externas completadas)",$Quant['Fazendo chamada externa']['Atendendo']),
     29=>array("Quantidade de discagens (tentativas de sadas no completadas)",$Quant['Fazendo chamada externa']['Nao Atendidas']),
     30=>array("Quantidade de pausas efetuadas",$Quant['Em Pausa']),
     31=>array("Quantidade de chamadas internas realizadas",$Quant['Consulta-Realizadas']['Atendendo']),
     32=>array("Quantidade de chamadas internas atendidas",$Quant['Consulta-Atendidas']['Atendendo']),
     33=>array("Quantidade de chamadas de filas no atendidas",$Quant['Fila']['Nao Atendidas']),
     34=>array("Quantidade de chamadas DDR no atendidas",$Quant['DDR']['Nao Atendidas']),
     35=>array("Quantidade de transferncias no atendidas",$Quant['Total transfer']['Nao Atendidas']),
     36=>array("Quantidade total de chamadas externas no atendidas",$Quant['Total externas recebidas']['Nao Atendidas']),
     37=>array("Quantidade de chamadas internas no atendidas",$Quant['Consulta-Atendidas']['Nao Atendidas'])
     );
   $Saida  = '';
   if ($Formato=="html") $Saida .= '<p class="relage">';
   if ($Formato=="xml")  $Saida .= '<table x:str border=0 cellpadding=0 cellspacing=0 style="border-collapse: collapse;table-layout:fixed;"><tr><td class=xl24 width=64>';
   $Saida .= $Login."\n";
   if ($Formato=="xls")  $Saida .= '</td></tr>';
   $Saida .= "\n";
   $Cor   = "#FFFFFF";

   if ($Formato=="html") $Saida .= '<p class="relstit">Tempos Totais</p>'."\n".'<p class="relssti">Sem atividade</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Tempos Totais</td></tr>'."\n".'<tr><td class=xl24 width=64>Sem atividade</td></tr>'."\n";
   for ($x=0; $x<=1; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   for ($k=0; $k<count($LPaus); $k++) {
     $Campos = 'Tempo '.$LPaus[$k]['nome'];
     $Aux    = $Dados[1];
     $TPauD  = $Tempo['Em Pausa Diferenciada'];
     if (is_array($TPauD)) {
       $TipoP     = $LPaus[$k]['nome'];
       if (isset($TPauD[$TipoP])) $Valor = formata_hora($TPauD[$TipoP]);
       else $Valor = formata_hora(0);
       $Saida .= imprime_linha($Campos,$Valor,$Cor);
       ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
     }
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Conversando em atendimento externo</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Conversando em atendimento externo</td></tr>'."\n";
   for ($x=2; $x<=5; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Conversando em sadas (fazendo chamadas externas)</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Conversando em sadas (fazendo chamadas externas)</td></tr>'."\n";
   for ($x=6; $x<=6; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Conversando em chamadas internas</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Conversando em chamadas internas</td></tr>'."\n";
   for ($x=7; $x<=8; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Chamando destino</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Chamando destino</td></tr>'."\n";
   for ($x=9; $x<=10; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">PA tocando</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>PA tocando</td></tr>'."\n";
   for ($x=11; $x<=12; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Logado / Deslogado</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Logado / Deslogado</td></tr>'."\n";
   for ($x=13; $x<=14; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Monitorando PA (em escuta de ligaes)</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Monitorando PA (em escuta de ligaes)</td></tr>'."\n";
   for ($x=15; $x<=15; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relstit">Tempos Mdios'."\n".'<p class="relssti">Conversando em sadas (fazendo chamadas externas)</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Tempos Mdios</td></tr>'."\n".'<tr><td class=xl24 width=64>Conversando em sadas (fazendo chamadas externas)</td></tr>'."\n";
   for ($x=16; $x<=16; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Conversando em atendimento externo</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Conversando em atendimento externo</td></tr>'."\n";
   for ($x=17; $x<=17; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Geral conversando em chamadas externas (Entrada e Sada)</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Geral conversando em chamadas externas (Entrada e Sada)</td></tr>'."\n";
   for ($x=18; $x<=18; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Conversando em chamadas internas</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Conversando em chamadas internas</td></tr>'."\n";
   for ($x=19; $x<=21; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Tempo de toque na PA para atender chamadas externas </p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Tempo de toque na PA para atender chamadas externas </td></tr>'."\n";
   for ($x=22; $x<=22; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relstit">Quantidades'."\n".'<p class="relssti">Chamadas externas atendidas</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Quantidades</td></tr>'."\n".'<tr><td class=xl24 width=64>Chamadas externas atendidas</td></tr>'."\n";
   for ($x=23; $x<=26; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Transferncias efetuadas</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Transferncias efetuadas</td></tr>'."\n";
   for ($x=27; $x<=27; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Chamadas externas realizadas</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Chamadas externas realizadas</td></tr>'."\n";
   for ($x=28; $x<=29; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Pausas efetuadas</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Pausas efetuadas</td></tr>'."\n";
   for ($x=30; $x<=30; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   for ($k=0; $k<count($LPaus); $k++) {
     $Campos = 'Quantidade '.$LPaus[$k]['nome'];
     $Aux    = $Dados[2];
     $QPauD  = $Quant['Em Pausa Diferenciada'];
     if (is_array($QPauD)) {
       $TipoP = $LPaus[$k]['nome'];
       if (isset($QPauD[$TipoP])) $Valor = $QPauD[$TipoP];
       else $Valor = '0';
       $Saida .= imprime_linha($Campos,$Valor,$Cor,$Formato);
       ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
     }
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Chamadas internas</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Chamadas internas</td></tr>'."\n";
   for ($x=31; $x<=32; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Chamadas externas no atendidas</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Chamadas externas no atendidas</td></tr>'."\n";
   for ($x=33; $x<=36; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n".'<p class="relssti">Chamadas internas no atendidas</p>'."\n".'<table class="relator">'."\n";
   if ($Formato=="xls")  $Saida .= '<tr><td class=xl24 width=64>Chamadas internas no atendidas</td></tr>'."\n";
   for ($x=37; $x<=37; $x++) {
     $Saida .= imprime_linha($Campo[$x][0],$Campo[$x][1],$Cor);
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   }
   if ($Formato=="html") $Saida .= '</table>'."\n";

   return $Saida;
 }


/**************************************************************
  Funcao monta_relatorio_estado_atual_resumido
 *************************************************************/
 function monta_relatorio_estado_atual_resumido($Agentes,$Dados){
   if (!$Agentes) return "Erro";
   $Total = array();
   for ($y=0; $y<count($Agentes); $y++) {
     if ($Dados[$y]) {
       $Login[$y] = $Dados[$y][0];
       $Tempo     = $Dados[$y][1];
       $Quant     = $Dados[$y][2];
       $Var0 = $Quant['Total externa atendidas']['Atendendo']+$Quant['Total externas recebidas']['Nao Atendidas'];
       $Var1 = $Quant['Total transfer efetuadas']['Chamando']+$Quant['Fazendo chamada externa']['Chamando']+$Quant['Consulta-Realizadas']['Chamando'];
       $VarA = $Tempo['Total externa atendidas']['Atendendo']+$Tempo['Total externas recebidas']['Nao Atendidas'];
       $VarB = $Tempo['Total transfer efetuadas']['Chamando']+$Tempo['Fazendo chamada externa']['Chamando']+$Tempo['Consulta-Realizadas']['Chamando'];
       //$Var0 = $Quant['Fila']['Atendendo']+$Quant['DDR']['Atendendo']+$Quant['Total transfer atendidas']['Atendendo']+$Quant['Total externa atendidas']['Atendendo']+$Quant['Consulta-Atendidas']['Atendendo']+$Quant['Fila']['Nao Atendidas']+$Quant['DDR']['Nao Atendidas']+$Quant['Total transfer']['Nao Atendidas']+$Quant['Total externas recebidas']['Nao Atendidas']+$Quant['Consulta-Atendidas']['Nao Atendidas'];
       //$Var1 = $Quant['Total transfer efetuadas']['Chamando']+$Quant['Fazendo chamada externa']['Atendendo']+$Quant['Fazendo chamada externa']['Nao Atendidas']+$Quant['Consulta-Realizadas']['Atendendo'];
       //$VarA = $Tempo['Fila']['Atendendo']+$Tempo['Total Transfer']['Atendendo']+$Tempo['Total DDR']['Atendendo']+$Tempo['Consulta-Atendidas']['Atendendo']+$Tempo['Consulta-Atendidas']['Chamando']+$Tempo['Fila']['Chamando']+$Tempo['Total Transfer']['Chamando']+$Tempo['Total DDR']['Chamando'];
       //$VarB = $Tempo['Fazendo chamada externa']['Atendendo']+$Tempo['Consulta-Realizadas']['Atendendo']+$Tempo['Fazendo chamada externa']['Chamando']+$Tempo['Consulta-Realizadas']['Chamando'];
      ($Var0==0) ? $Var3 = 0 : $Var3 = $VarA/$Var0;
      ($Var1==0) ? $Var4 = 0 : $Var4 = $VarB/$Var1;
       $Total[0] += $Var0;
       $Total[1] += $Var1;
       $Total[A] += $VarA;
       $Total[B] += $VarB;
       $Campo[$y] = array(
         0=>array("Recebidas",$Var0),
         1=>array("Realizadas",$Var1),
         2=>array("Total",$Var0+$Var1),
         3=>array("Tempo Mdio Recebendo Ligaes",formata_hora($Var3)),
         4=>array("Tempo Mdio Fazendo Ligaes",formata_hora($Var4)),
       );
     }
   }
   ($Total[0]==0) ? $Total[3] = 0 : $Total[3] = $Total[A]/$Total[0];
   ($Total[1]==0) ? $Total[4] = 0 : $Total[4] = $Total[B]/$Total[1];
   $Total[2] = $Total[0] + $Total[1];
   $Total[3] = formata_hora($Total[3]);
   $Total[4] = formata_hora($Total[4]);
   $Saida  = '';
   $Saida .= '<table class="relat"><tr><td class="relatT">Agentes</td>';
   for ($y=0; $y<count($Agentes); $y++) $Saida .= '<td class="relatT">'.$Agentes[$y].'</td>';
   $Saida .= '<td class="relatT">Total</td>';
   $Saida .= '</tr>'."\n";
   $Cor   = "#FFFFFF";
   for ($y=0; $y<5; $y++) {
     $Saida .= '<tr>';
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
     for ($x=0; $x<count($Agentes); $x++) {
       $Aux = $Campo[$x][$y];
       if ($x==0) $Saida .= '<td class="relat" style="font-weight:bold;text-align:left;background-color:'.$Cor.'">'.$Aux[0].'</td>';
       $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Aux[1].'</td>';
     }
     $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Total[$y].'</td>';
     $Saida .= '</tr>'."\n";
   }
   $Saida .= '</table>'."\n";
   return $Saida;
 }


/**************************************************************
  Funcao monta_relatorio_planilha_operadores
 *************************************************************/
 function monta_relatorio_planilha_operadores($Agentes,$Dados,$LPaus){
   if (!$Agentes) return "Erro";
   $Total = $TotalPh = $TotalPq = array();
   for ($y=0; $y<count($Agentes); $y++) {
     if ($Dados[$y]) {
       $Login[$y] = $Dados[$y][0];
       $Tempo     = $Dados[$y][1];
       $Quant     = $Dados[$y][2];
       $Quant['Total Agentes'] = 1;
       //Var_01
       ($Tempo['Login']==0) ? $Var_01 = 0 : $Var_01 = ($Tempo['Total DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fazendo chamada externa']['Atendendo']+$Tempo['Consulta-Realizadas']['Atendendo']+$Tempo['Consulta-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo']+$Tempo['Fazendo chamada externa']['Chamando'] + $Tempo['Consulta-Realizadas']['Chamando'])/ $Tempo['Login'];
       //Var_02
       $Var_02 =  ($Tempo['Total DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fazendo chamada externa']['Atendendo']+$Tempo['Consulta-Realizadas']['Atendendo']+$Tempo['Consulta-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo']+$Tempo['Fazendo chamada externa']['Chamando'] + $Tempo['Consulta-Realizadas']['Chamando'])/$Quant['Total Agentes'];
       //Var_09
       (($Quant['DDR']['Atendendo']+$Quant['Transfer-DDR-Atendidas']['Atendendo']+$Quant['Fila']['Atendendo']+$Quant['Transfer-FILA-Atendidas']['Atendendo'])==0) ? $Var_09 = 0 : $Var_09 = ($Tempo['DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo'])/($Quant['DDR']['Atendendo']+$Quant['Transfer-DDR-Atendidas']['Atendendo']+$Quant['Fila']['Atendendo']+$Quant['Transfer-FILA-Atendidas']['Atendendo']);
       //Var_14
       ($Quant['Fazendo chamada externa']['Atendendo']==0) ? $Var14 = 0 : $Var14 = ($Tempo['Fazendo chamada externa']['Atendendo'] / $Quant['Fazendo chamada externa']['Atendendo']);
       //Var_29
       (($Quant['DDR']['Chamando']+$Quant['Fila']['Chamando']+$Quant['Transfer-FILA-Atendidas']['Chamando']+$Quant['Transfer-DDR-Atendidas']['Chamando'])==0) ? $Var_29 = 0 : $Var_29 = ($Tempo['DDR']['Chamando']+$Tempo['Fila']['Chamando']+$Tempo['Transfer-FILA-Atendidas']['Chamando']+$Tempo['Transfer-DDR-Atendidas']['Chamando']) / ($Quant['DDR']['Chamando']+$Quant['Fila']['Chamando']+$Quant['Transfer-FILA-Atendidas']['Chamando']+$Quant['Transfer-DDR-Atendidas']['Chamando']);
       //Var_30
       ($Quant['Fazendo chamada externa']['Atendendo']==0) ? $Var30 = 0 : $Var30 = ($Tempo['Fazendo chamada externa']['Atendendo'] / $Quant['Fazendo chamada externa']['Atendendo']);
       //Var_31
       (($Quant['DDR']['Atendendo']+$Quant['Transfer-DDR-Atendidas']['Atendendo']+$Quant['Fila']['Atendendo']+$Quant['Transfer-FILA-Atendidas']['Atendendo'])==0) ? $Var31 = 0 : $Var31 = (($Tempo['DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo']) / ($Quant['DDR']['Atendendo']+$Quant['Transfer-DDR-Atendidas']['Atendendo']+$Quant['Fila']['Atendendo']+$Quant['Transfer-FILA-Atendidas']['Atendendo']));
       //Var_32
       ($Quant['Consulta-Realizadas']['Atendendo']==0) ? $Var32 = 0 : $Var32 = ($Tempo['Consulta-Realizadas']['Atendendo'] / $Quant['Consulta-Realizadas']['Atendendo']);
       $Total[1]  += ($Tempo['Total DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fazendo chamada externa']['Atendendo']+$Tempo['Consulta-Realizadas']['Atendendo']+$Tempo['Consulta-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo']+$Tempo['Fazendo chamada externa']['Chamando'] + $Tempo['Consulta-Realizadas']['Chamando']);
       $Total[2]  += ($Tempo['Total DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fazendo chamada externa']['Atendendo']+$Tempo['Consulta-Realizadas']['Atendendo']+$Tempo['Consulta-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo']);
       $Total[3]  += ($Tempo['DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo']);
       $Total[4]  += ($Quant['DDR']['Atendendo']+$Quant['Transfer-DDR-Atendidas']['Atendendo']+$Quant['Fila']['Atendendo']+$Quant['Transfer-FILA-Atendidas']['Atendendo']);
       $Total[5]  += (($Tempo['DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo'])-($Tempo['Fila']['0800115558']['Atendendo']+$Tempo['Fila']['08007700443']['Atendendo']+$Tempo['Fila']['08007732372']['Atendendo']+$Tempo['Fila']['0800 Volvo']['Atendendo']+$Tempo['Fila']['0800 Crm']['Atendendo']+$Tempo['Fila']['0800 Dafra']['Atendendo']));
       $Total[6]  += (($Quant['DDR']['Atendendo']+$Quant['Transfer-DDR-Atendidas']['Atendendo']+$Quant['Fila']['Atendendo']+$Quant['Transfer-FILA-Atendidas']['Atendendo'])-($Quant['Fila']['0800115558']['Atendendo']+$Quant['Fila']['08007700443']['Atendendo']+$Quant['Fila']['08007732372']['Atendendo']+$Quant['Fila']['0800 Volvo']['Atendendo']+$Quant['Fila']['0800 Crm']['Atendendo']+$Quant['Fila']['0800 Dafra']['Atendendo']));
       $Total[7]  += ($Tempo['Fila']['0800115558']['Atendendo']+$Tempo['Fila']['08007700443']['Atendendo']+$Tempo['Fila']['08007732372']['Atendendo']+$Tempo['Fila']['0800 Volvo']['Atendendo']+$Tempo['Fila']['0800 Crm']['Atendendo']+$Tempo['Fila']['0800 Dafra']['Atendendo']);
       $Total[8]  += ($Quant['Fila']['0800115558']['Atendendo']+$Quant['Fila']['08007700443']['Atendendo']+$Quant['Fila']['08007732372']['Atendendo']+$Quant['Fila']['0800 Volvo']['Atendendo']+$Quant['Fila']['0800 Crm']['Atendendo']+$Quant['Fila']['0800 Dafra']['Atendendo']);
       $Total[9]  += $Var_09;
       $Total[10] += ($Tempo['Fazendo chamada externa']['Atendendo']);
       $Total[11] += ($Quant['Fazendo chamada externa']['Atendendo']+$Quant['Fazendo chamada externa']['Nao Atendidas']);
       $Total[12] += $Quant['Fazendo chamada externa']['Atendendo'];
       $Total[13] += $Quant['Fazendo chamada externa']['Nao Atendidas'];
       $Total[14] += $Var_14;
       $Total[15] += ($Tempo['Consulta-Realizadas']['Atendendo']+$Tempo['Consulta-Atendidas']['Atendendo']);
       $Total[16] += ($Quant['Consulta-Realizadas']['Atendendo']+$Quant['Consulta-Atendidas']['Atendendo']);
       $Total[17] += $Quant['Total transfer efetuadas']['Chamando'];
       $Total[18] += $Tempo['Livre'];
       $Total[19] += ($Tempo['Fazendo chamada externa']['Chamando'] + $Tempo['Consulta-Realizadas']['Chamando']);
       $Total[20] += ($Tempo['Monitorando PA']+$Tempo['Consulta-funcao-Atendidas']['Atendendo']['treinamento']+$Tempo['Consulta-funcao-Realizadas']['Atendendo']['treinamento']);
       $Total[21] += $Tempo['Monitorando PA'];
       $Total[22] += ($Tempo['Consulta-funcao-Atendidas']['Atendendo']['treinamento']+$Tempo['Consulta-funcao-Realizadas']['Atendendo']['treinamento']);
       $Total[23] += ($Quant['Consulta-funcao-Atendidas']['Atendendo']['treinamento']+$Quant['Consulta-funcao-Realizadas']['Atendendo']['treinamento']);
       $Total[24] += $Tempo['Login'];
       $Total[25] += 0;
       $Total[26] += $Tempo['Deslogado'];
       $Total[27] += 0;
       $Total[28] += $Tempo['Em Pausa'];
       $Total[29] += $Quant['Em Pausa'];
       $Total[30] += $Tempo['Logado Followup'];
       $Total[31] += $Tempo['Fazendo chamada externa-funcao']['Atendendo']['ativo'];
       $Total[32] += $Quant['Fazendo chamada externa-funcao']['Atendendo']['ativo'];
       $Total[33] += $Quant['Fazendo chamada externa-funcao']['Nao Atendidas']['ativo'];
       $Total[34] += $Quant['Total externas recebidas']['Nao Atendidas'];
       $Total[35] += ($Tempo['DDR']['Chamando']+$Tempo['Fila']['Chamando']+$Tempo['Transfer-FILA-Atendidas']['Chamando']+$Tempo['Transfer-DDR-Atendidas']['Chamando']);
       $Total[36] += $Var_29;
       $Campo[$y] = array(
        0=>array("% Produtividade",        number_format( $Var_01 * 100, 2, ',', ' ')."%"),
        1=>array("Tempo mdio de operao",   formata_hora($Var_02)),
        2=>array("Tempo total em conversao", formata_hora($Tempo['Total DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fazendo chamada externa']['Atendendo']+$Tempo['Consulta-Realizadas']['Atendendo']+$Tempo['Consulta-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo'])),
        3=>array("Tempo total de atendimento (0800 + demais atendimentos)", formata_hora($Tempo['DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo'])),
        4=>array("Quantidade total de atendimento (0800 + demais atendimentos)", $Quant['DDR']['Atendendo']+$Quant['Transfer-DDR-Atendidas']['Atendendo']+$Quant['Fila']['Atendendo']+$Quant['Transfer-FILA-Atendidas']['Atendendo']),
        5=>array("Tempo de atendimento (exceto 0800)", formata_hora(($Tempo['DDR']['Atendendo']+$Tempo['Transfer-DDR-Atendidas']['Atendendo']+$Tempo['Fila']['Atendendo']+$Tempo['Transfer-FILA-Atendidas']['Atendendo'])-($Tempo['Fila']['0800115558']['Atendendo']+$Tempo['Fila']['08007700443']['Atendendo']+$Tempo['Fila']['08007732372']['Atendendo']+$Tempo['Fila']['0800 Volvo']['Atendendo']+$Tempo['Fila']['0800 Crm']['Atendendo']+$Tempo['Fila']['0800 Dafra']['Atendendo']))),
        6=>array("Quantidade de atendimentos (exceto 0800)",($Quant['DDR']['Atendendo']+$Quant['Transfer-DDR-Atendidas']['Atendendo']+$Quant['Fila']['Atendendo']+$Quant['Transfer-FILA-Atendidas']['Atendendo'])-($Quant['Fila']['0800115558']['Atendendo']+$Quant['Fila']['08007700443']['Atendendo']+$Quant['Fila']['08007732372']['Atendendo']+$Quant['Fila']['0800 Volvo']['Atendendo']+$Quant['Fila']['0800 Crm']['Atendendo']+$Quant['Fila']['0800 Dafra']['Atendendo'])),
        7=>array("Tempo de atendimento de 0800", formata_hora($Tempo['Fila']['0800115558']['Atendendo']+$Tempo['Fila']['08007700443']['Atendendo']+$Tempo['Fila']['08007732372']['Atendendo']+$Tempo['Fila']['0800 Volvo']['Atendendo']+$Tempo['Fila']['0800 Crm']['Atendendo']+$Tempo['Fila']['0800 Dafra']['Atendendo'])),
        8=>array("Quantidade de atendimento de 0800", $Quant['Fila']['0800115558']['Atendendo']+$Quant['Fila']['08007700443']['Atendendo']+$Quant['Fila']['08007732372']['Atendendo']+$Quant['Fila']['0800 Volvo']['Atendendo']+$Quant['Fila']['0800 Crm']['Atendendo']+$Quant['Fila']['0800 Dafra']['Atendendo']),
        9=>array("Tempo mdio conversando em atendimento (TMA)",formata_hora($Var_09)),
       10=>array("Tempo conversando em chamadas feitas completadas",formata_hora($Tempo['Fazendo chamada externa']['Atendendo'])),
       11=>array("Total de chamadas feitas (completadas + no completadas)",$Quant['Fazendo chamada externa']['Atendendo']+$Quant['Fazendo chamada externa']['Nao Atendidas']),
       12=>array("Quantidade de ligaes feitas completadas",$Quant['Fazendo chamada externa']['Atendendo']),
       13=>array("Quantidade de ligaes feitas no completadas (tentativas sem sucesso)",$Quant['Fazendo chamada externa']['Nao Atendidas']),

       14=>array("Tempo mdio conversando em chamadas feitas completadas",formata_hora($Var14)),

       15=>array("Tempo chamada interna (TI) (entre ramais)",formata_hora($Tempo['Consulta-Realizadas']['Atendendo']+$Tempo['Consulta-Atendidas']['Atendendo'])),
       16=>array("Quantidade de chamadas internas (entre ramais)",($Quant['Consulta-Realizadas']['Atendendo']+$Quant['Consulta-Atendidas']['Atendendo'])),
       17=>array("Quantidade de ligaes transferidas",$Quant['Total transfer efetuadas']['Chamando']),
       18=>array("Tempo livre",formata_hora($Tempo['Livre'])),
       19=>array("Tempo chamando destino",formata_hora($Tempo['Fazendo chamada externa']['Chamando'] + $Tempo['Consulta-Realizadas']['Chamando'])),
       20=>array("Tempo em treinamento (TT)",formata_hora($Tempo['Monitorando PA']+$Tempo['Consulta-funcao-Atendidas']['Atendendo']['treinamento']+$Tempo['Consulta-funcao-Realizadas']['Atendendo']['treinamento'])),
       21=>array("Tempo de monitorao (TM)",formata_hora($Tempo['Monitorando PA'])),
       22=>array("Tempo de simulao (TS)",formata_hora($Tempo['Consulta-funcao-Atendidas']['Atendendo']['treinamento']+$Tempo['Consulta-funcao-Realizadas']['Atendendo']['treinamento'])),
       23=>array("Quantidade de simulaes",$Quant['Consulta-funcao-Atendidas']['Atendendo']['treinamento']+$Quant['Consulta-funcao-Realizadas']['Atendendo']['treinamento']),
       24=>array("Tempo logado",formata_hora($Tempo['Login'])),
       25=>array("Hora do log", $Tempo['Primeiro login']),
       26=>array("Tempo deslogado",formata_hora($Tempo['Deslogado'])),
       27=>array("Hora do deslog", $Tempo['Ultimo logout']),
       28=>array("TEMPO PAUSA (TP)",formata_hora($Tempo['Em Pausa'])),
       29=>array("QUANTIDADE PAUSA (QP)",$Quant['Em Pausa']),
       30=>array("Tempo logado em Follow-up",formata_hora($Tempo['Logado Followup'])),
       31=>array("Tempo ligao realizada em Follow-Up",formata_hora($Tempo['Fazendo chamada externa-funcao']['Atendendo']['ativo'])),
       32=>array("Quantidade Ligaes realizadas em Follow-up",$Quant['Fazendo chamada externa-funcao']['Atendendo']['ativo']),
       33=>array("Quantidade tentativas sem sucesso em Follow-up",$Quant['Fazendo chamada externa-funcao']['Nao Atendidas']['ativo']),
       34=>array("Total de chamadas externas no atendidas",$Quant['Total externas recebidas']['Nao Atendidas']),
       35=>array("Tempo PA tocando (TPT)",formata_hora($Tempo['DDR']['Chamando']+$Tempo['Fila']['Chamando']+$Tempo['Transfer-FILA-Atendidas']['Chamando']+$Tempo['Transfer-DDR-Atendidas']['Chamando'])),
       36=>array("TEMPO ESPERA (TE)",formata_hora( $Var_29) )
       );
     }
   }
   ($Total[24]==0) ? $Total[0] = 0  : $Total[0] = $Total[1]/$Total[24];
   ($Total[4]==0)  ? $Total[9] = 0  : $Total[9] = $Total[3]/$Total[4];
   ($Total[12]==0) ? $Total[14] = 0 : $Total[14] = $Total[10]/$Total[12];
   $Total[0] = number_format($Total[0]*100, 2, ',', ' ')."%";
   $Total[1] = formata_hora($Total[1]/$Quant['Total Agentes']);
   $Total[2] = formata_hora($Total[2]);
   $Total[3] = formata_hora($Total[3]);
   $Total[5] = formata_hora($Total[5]);
   $Total[7] = formata_hora($Total[7]);
   $Total[9] = formata_hora($Total[9]);
   $Total[10]= formata_hora($Total[10]);
   $Total[14]= formata_hora($Total[14]);
   $Total[15]= formata_hora($Total[15]);
   $Total[18]= formata_hora($Total[18]);
   $Total[19]= formata_hora($Total[19]);
   $Total[20]= formata_hora($Total[20]);
   $Total[21]= formata_hora($Total[21]);
   $Total[22]= formata_hora($Total[22]);
   $Total[24]= formata_hora($Total[24]);
   $Total[26]= formata_hora($Total[26]);
   $Total[28]= formata_hora($Total[28]);
   $Total[30]= formata_hora($Total[30]);
   $Total[31]= formata_hora($Total[31]);
   $Total[35]= formata_hora($Total[35]);
   $Total[36]= formata_hora($Total[36]);
   $Saida  = '';
   $Saida .= '<table class="relat"><tr><td class="relatT">';
   if (substr($Agentes[0],4,1)=="-") $Saida .= 'Agentes';
   else $Saida .= 'Grupos';
   $Saida .= '</td>';
   for ($y=0; $y<count($Agentes); $y++) $Saida .= '<td class="relatT">'.$Agentes[$y].'</td>';
   $Saida .= '<td class="relatT">Total</td>';
   $Saida .= '</tr>'."\n";
   $Cor   = "#FFFFFF";
   for ($y=0; $y<35; $y++) {
     if ($y==30) { //Apos a QUANTIDADE DE PAUSA
       for ($k=0; $k<count($LPaus); $k++) {
         $Saida .= '<tr>';
         ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
         $Saida .= '<td class="relat" style="font-weight:bold;text-align:left;background-color:'.$Cor.'">Tempo '.$LPaus[$k]['nome'].'</td>';
         for ($x=0; $x<count($Agentes); $x++) {
           $Aux       = $Dados[$x][1];
           $TPauD = $Aux['Em Pausa Diferenciada'];
           if (is_array($TPauD)) {
             $TipoP     = $LPaus[$k]['nome'];
             if (isset($TPauD[$TipoP])) $VPausa = $TPauD[$TipoP];
             else $VPausa = 0;
           }
           else $VPausa = 0;
           $TotalPh[$k] += $VPausa;
           $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.formata_hora($VPausa).'</td>';
         }
         $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.formata_hora($TotalPh[$k]).'</td>';
         $Saida .= '</tr>';
         $Saida .= '<tr>';
         ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
         $Saida .= '<td class="relat" style="font-weight:bold;text-align:left;background-color:'.$Cor.'">Quantidade '.$LPaus[$k]['nome'].'</td>';
         for ($x=0; $x<count($Agentes); $x++) {
           $Aux       = $Dados[$x][2];
           $QPauD[$x] = $Aux['Em Pausa Diferenciada'];
           if (is_array($QPauD[$x])) {
             $TipoP     = $LPaus[$k]['nome'];
             if (isset($QPauD[$x][$TipoP])) $VPausa = $QPauD[$x][$TipoP];
             else $VPausa = 0;
           }
           else $VPausa = 0;
           $TotalPq[$k] += $VPausa;
           $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$VPausa.'</td>';
         }
         $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$TotalPq[$k].'</td>';
         $Saida .= '</tr>';
       }
     }

     $Saida .= '<tr>';
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
     for ($x=0; $x<count($Agentes); $x++) {
       $Aux = $Campo[$x][$y];
       if ($x==0) $Saida .= '<td class="relat" style="font-weight:bold;text-align:left;background-color:'.$Cor.'">'.$Aux[0].'</td>';
       $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Aux[1].'</td>';
     }
     $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Total[$y].'</td>';
     $Saida .= '</tr>'."\n";
   }
   $Saida .= '</table>'."\n";

   return $Saida;
 }


/**************************************************************
  Funcao monta_relatorio_ligacoes_operadores_atendidas
 *************************************************************/
 function monta_relatorio_ligacoes_operadores_atendidas($Agentes, $Dados, $De, $Aa) {
   if (!$Agentes) return "Erro";
   $Saida  = '';
//$Saida=print_r($Dados,true);
//return $Saida;
   if ($Dados) {
     $Atend = $Dados['Atendida'];
     if (count($Atend)>0) {
       $Saida .= '<table class="relat">'."\n";
       $Saida .= '<tr><td class="relatT" colspan="4">Chamadas atendidas</td></tr>'."\n";
       $Saida .= '<tr><td class="relatT">Data</td><td class="relatT">Hora</td><td class="relatT">Telefone</td><td class="relatT">Durao</td></tr>'."\n";
       for ($y=0; $y<count($Atend); $y++) {
         $Saida .= '<tr><td>'.date('d/m',$Atend[$y][0]).'</td><td>'.date('H:i',$Atend[$y][0]).'</td><td>'.$Atend[$y][1].'</td><td>'.formata_hora($Atend[$y][2]).'</td></tr>'."\n";
       }
       $Saida .= '</table><br><br>'."\n";
     }
   }
   return $Saida;
 }


/**************************************************************
  Funcao monta_relatorio_ligacoes_operadores_efetuadas
 *************************************************************/
 function monta_relatorio_ligacoes_operadores_efetuadas($Agentes, $Dados, $De, $Aa) {
   if (!$Agentes) return "Erro";
   $Saida  = '';
   if ($Dados) {
     $Reali = $Dados['Efetuadas'];
     if (count($Reali)>0) {
       $Saida .= '<table class="relat">'."\n";
       $Saida .= '<tr><td class="relatT" colspan="4">Chamadas realizadas</td></tr>'."\n";
       $Saida .= '<tr><td class="relatT">Data</td><td class="relatT">Hora</td><td class="relatT">Telefone</td><td class="relatT">Durao</td></tr>'."\n";
       for ($y=0; $y<count($Reali); $y++) {
         $Saida .= '<tr><td>'.date('d/m',$Reali[$y][0]).'</td><td>'.date('H:i',$Reali[$y][0]).'</td><td>'.$Reali[$y][1].'</td><td>'.formata_hora($Reali[$y][2]).'</td></tr>'."\n";
       }
       $Saida .= '</table><br><br>'."\n";
     }
   }
   return $Saida;
 }


/**************************************************************
  Funcao monta_relatorio_planilha_grupos_horas
 *************************************************************/
 function monta_relatorio_planilha_grupos_horas($Grupos,$Dados,$hora_ini,$hora_fim) {
   //Global  $Moni_Hora_inicial, $Moni_Hora_final;
   $Moni_Hora_inicial = $hora_ini;
   $Moni_Hora_final = $hora_fim;
   if (!$Grupos) return "Erro";
   //print_r( $Dados, $Saida );
   //return $Saida;
   $Total = array(0,0,0,0,0,0,0,0,0);
   if ($Dados) {
     $FFila  = $Grupos;
     for ($y=$Moni_Hora_inicial; $y<$Moni_Hora_final+1; $y++) {
       $Tempo = $Dados[1]['H'][$y];
       $Quant = $Dados[2]['H'][$y];
       if ($Quant['Chamadas Atendidas'] < 1)   $Quant['Chamadas Atendidas']=0;
       if ($Quant['Desistencias'] < 1)         $Quant['Desistencias']=0;
       if ($Quant['Desistencias Fila'] < 1)    $Quant['Desistencias Fila']=0;
       if ($Quant['Desistencias Cx'] < 1)      $Quant['Desistencias Cx']=0;
       if ($Quant['Desistencias Msg'] < 1)     $Quant['Desistencias Msg']=0;
       if ($Quant['Desistencias Desliga'] < 1) $Quant['Desistencias Desliga']=0;
       if ($Quant['Espera Maxima'] < 1)        $Quant['Espera Maxima']=0;
       if ($Tempo['Espera'] < 1)               $Tempo['Espera']=0;
       if ($Quant['Espera'] < 1)               $Quant['Espera']=0;
       if ($Quant['Espera']==0)                $Tempo['Media Espera'] = 0;
       else $Tempo['Media Espera'] = ($Tempo['Espera']/$Quant['Espera']);
       //$Recebidas = $Quant['Chamadas Atendidas']+$Quant['Desistencias']+$Quant['Desistencias Fila']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Recebidas = $Quant['Chamadas Atendidas']+$Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Total[0] += $Recebidas;
       $Total[1] += $Quant['Chamadas Atendidas'];
       $Total[2] += $Quant['Desistencias'];
       $Total[3] += $Quant['Desistencias Cx'];
       //$Total[4] += $Quant['Desistencias Fila'];
       $Total[4] += $Quant['Desistencias Msg'];
       $Total[5] += $Quant['Desistencias Desliga'];
       //$Total[7] += $Quant['Desistencias']+$Quant['Desistencias Fila']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Total[6] += $Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Total[7] += $Quant['Espera Maxima'];
       $Total['A'] += $Tempo['Espera'];
       $Total['B'] += $Quant['Espera'];
       ($Recebidas==0) ? $Nivel = 0 : $Nivel = $Quant['Chamadas Atendidas']/$Recebidas;
       $Campo[$y] = array(
         0=>array("Quantidade de chamadas recebidas",$Recebidas),
         1=>array("Quantidade de chamadas Atendidas por operadores",$Quant['Chamadas Atendidas']),
         2=>array("Quantidade de desistncias",$Quant['Desistencias']),
         3=>array("Quantidade de atendimentos da caixa postal",$Quant['Desistencias Cx']),
         4=>array("Quantidade total de chamadas no atendidas - Mensagem",$Quant['Desistencias Msg']),
         5=>array("Quantidade total de chamadas no atendidas - Desligamento",$Quant['Desistencias Desliga']),
         6=>array("Quantidade total de chamadas no atendidas por operadores",$Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga']),
         7=>array("Quantidade de chamadas  com tempo de espera > mximo",$Quant['Espera Maxima']),
         8=>array("Tempo mdio de espera para atendimento",formata_hora($Tempo['Media Espera'])),
         9=>array("Aproveitamento",number_format($Nivel*100, 2, ',', ' ')."%")
       );
         //4=>array("Quantidade de transbordo",$Quant['Desistencias Fila']),
     }
   }
   ($Total['B']==0) ? $Total[8] = 0 : $Total[8] = ($Total['A'] / $Total['B']);
   $Total[8] = formata_hora($Total[8]);
   ($Total[0]==0) ? $Total[9] = 0 : $Total[9] = ($Total[1] / $Total[0]);
   $Total[9] = number_format($Total[9]*100, 2, ',', ' ')."%";
   $Saida  = '';
   $Saida .= '<table class="relat"><tr><td class="relatT">';
   $Saida .= 'Horas';
   $Saida .= '</td>';
   for ($y=$Moni_Hora_inicial; $y<$Moni_Hora_final+1; $y++) $Saida .= '<td class="relatT">'.sprintf('%02d',$y).'</td>';
   $Saida .= '<td class="relatT">Total</td>';
   $Saida .= '</tr>'."\n";
   $Cor   = "#FFFFFF";
   for ($y=0; $y<10; $y++) {
     if (($y==4) || ($y==5)) continue;
     $Saida .= '<tr>';
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
     $Saida .= '<td class="relat" style="font-weight:bold;text-align:left;background-color:'.$Cor.'">'.$Campo[$Moni_Hora_inicial][$y][0].'</td>';
     for ($x=$Moni_Hora_inicial; $x<$Moni_Hora_final+1; $x++) {
       $Aux = $Campo[$x][$y];
       $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Aux[1].'</td>';
     }
     $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Total[$y].'</td>';
     $Saida .= '</tr>'."\n";
   }
   $Saida .= '</table>'."\n";
   return $Saida;
 }


/**************************************************************
  Funcao monta_relatorio_planilha_filas
 *************************************************************/
 function monta_relatorio_planilha_filas($Filas,$Dados){
   if (!$Filas) return "Erro";
   $Total = array(0,0,0,0,0,0,0,0,0);
   $Total['A'] = $Total['B'] = 0;
   for ($y=0; $y<count($Filas); $y++) {
     if ($Dados[$y]) {
       $FFila[$y] = $Dados[$y][0];
       $Tempo     = $Dados[$y][1];
       $Quant     = $Dados[$y][2];
       //$Recebidas = $Quant['Chamadas Atendidas']+$Quant['Desistencias']+$Quant['Desistencias Fila']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Recebidas = $Quant['Chamadas Atendidas']+$Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       if ($Tempo['Espera'] < 1) $Tempo['Espera']=0;
       if ($Quant['Espera'] < 1) $Quant['Espera']=0;
       if ($Quant['Espera']==0)  $Tempo['Media Espera'] = 0;
       else $Tempo['Media Espera'] = ($Tempo['Espera']/$Quant['Espera']);
       $Total[0] += $Recebidas;
       $Total[1] += $Quant['Chamadas Atendidas'];
       $Total[2] += $Quant['Desistencias'];
       $Total[3] += $Quant['Desistencias Cx'];
       //$Total[4] += $Quant['Desistencias Fila'];
       $Total[4] += $Quant['Desistencias Msg'];
       $Total[5] += $Quant['Desistencias Desliga'];
       //$Total[7] += $Quant['Desistencias']+$Quant['Desistencias Fila']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Total[6] += $Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Total[7] += $Quant['Espera Maxima'];
       $Total['A'] += $Tempo['Espera'];
       $Total['B'] += $Quant['Espera'];
       ($Recebidas==0) ? $Nivel = 0 : $Nivel = $Quant['Chamadas Atendidas']/$Recebidas;
       $Campo[$y] = array(
         0=>array("Quantidade de chamadas recebidas",$Recebidas),
         1=>array("Quantidade de chamadas Atendidas por operadores",$Quant['Chamadas Atendidas']),
         2=>array("Quantidade de desistncias",$Quant['Desistencias']),
         3=>array("Quantidade de atendimentos da caixa postal",$Quant['Desistencias Cx']),
         4=>array("Quantidade total de chamadas no atendidas - Mensagem",$Quant['Desistencias Msg']),
         5=>array("Quantidade total de chamadas no atendidas - Desligamento",$Quant['Desistencias Desliga']),
         6=>array("Quantidade total de chamadas no atendidas por operadores",$Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga']),
         7=>array("Quantidade de chamadas  com tempo de espera > mximo",$Quant['Espera Maxima']),
         8=>array("Tempo mdio de espera para atendimento",formata_hora($Tempo['Media Espera'])),
         9=>array("Aproveitamento",number_format($Nivel*100, 2, ',', ' ')."%")
       );
         //4=>array("Quantidade de transbordo",$Quant['Desistencias Fila']),
         //6=>array("Quantidade total de chamadas no atendidas por operadores",$Quant['Desistencias']+$Quant['Desistencias Fila']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga']),
     }
   }
   ($Total['B']==0) ? $Total[8] = 0  : $Total[8] = ($Total['A'] / $Total['B']);
   $Total[8] = formata_hora($Total[8]);
   ($Total[0]==0) ? $Total[9] = 0 : $Total[9] = ($Total[1] / $Total[0]);
   $Total[9] = number_format($Total[9]*100, 2, ',', ' ')."%";
   $Saida  = '';
   $Saida .= '<table class="relat"><tr><td class="relatT">';
   $Saida .= 'Filas';
   $Saida .= '</td>';
   for ($y=0; $y<count($Filas); $y++) $Saida .= '<td class="relatT">'.$FFila[$y].'</td>';
   $Saida .= '<td class="relatT">Total</td>';
   $Saida .= '</tr>'."\n";
   $Cor   = "#FFFFFF";
   for ($y=0; $y<10; $y++) {
     if (($y==4) || ($y==5)) continue;
     $Saida .= '<tr>';
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
     for ($x=0; $x<count($Filas); $x++) {
       $Aux = $Campo[$x][$y];
       if ($x==0) $Saida .= '<td class="relat" style="font-weight:bold;text-align:left;background-color:'.$Cor.'">'.$Aux[0].'</td>';
       $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Aux[1].'</td>';
     }
     $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Total[$y].'</td>';
     $Saida .= '</tr>'."\n";
   }
   $Saida .= '</table>'."\n";
   return $Saida;
 }


/**************************************************************
  Funcao monta_relatorio_planilha_filas_horas
 *************************************************************/
 function monta_relatorio_planilha_filas_horas($Filas,$Dados,$hora_ini,$hora_fim) {
   //Global  $Moni_Hora_inicial, $Moni_Hora_final;
   $Moni_Hora_inicial = $hora_ini;
   $Moni_Hora_final = $hora_fim;
   if (!$Filas) return "Erro";
   //print_r( $Dados, $Saida );
   //return $Saida;
   $Total = array(0,0,0,0,0,0,0,0,0);
   if ($Dados) {
     $FFila  = $Filas;
     for ($y=intval($Moni_Hora_inicial,10); $y<intval($Moni_Hora_final,10)+1; $y++) {
       $Tempo = $Dados[1]['H'][$y];
       $Quant = $Dados[2]['H'][$y];
       if ($Quant['Chamadas Atendidas'] < 1)   $Quant['Chamadas Atendidas']=0;
       if ($Quant['Desistencias'] < 1)         $Quant['Desistencias']=0;
       if ($Quant['Desistencias Fila'] < 1)    $Quant['Desistencias Fila']=0;
       if ($Quant['Desistencias Cx'] < 1)      $Quant['Desistencias Cx']=0;
       if ($Quant['Desistencias Msg'] < 1)     $Quant['Desistencias Msg']=0;
       if ($Quant['Desistencias Desliga'] < 1) $Quant['Desistencias Desliga']=0;
       if ($Quant['Espera Maxima'] < 1)        $Quant['Espera Maxima']=0;
       if ($Tempo['Espera'] < 1)               $Tempo['Espera']=0;
       if ($Quant['Espera'] < 1)               $Quant['Espera']=0;
       if ($Quant['Espera']==0)                $Tempo['Media Espera'] = 0;
       else $Tempo['Media Espera'] = ($Tempo['Espera']/$Quant['Espera']);
       //$Recebidas = $Quant['Chamadas Atendidas']+$Quant['Desistencias']+$Quant['Desistencias Fila']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Recebidas = $Quant['Chamadas Atendidas']+$Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Total[0] += $Recebidas;
       $Total[1] += $Quant['Chamadas Atendidas'];
       $Total[2] += $Quant['Desistencias'];
       $Total[3] += $Quant['Desistencias Cx'];
       //$Total[4] += $Quant['Desistencias Fila'];
       $Total[4] += $Quant['Desistencias Msg'];
       $Total[5] += $Quant['Desistencias Desliga'];
       //$Total[7] += $Quant['Desistencias']+$Quant['Desistencias Fila']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Total[6] += $Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Total[7] += $Quant['Espera Maxima'];
       $Total['A'] += $Tempo['Espera'];
       $Total['B'] += $Quant['Espera'];
       ($Recebidas==0) ? $Nivel = 0 : $Nivel = $Quant['Chamadas Atendidas']/$Recebidas;
       $Campo[$y] = array(
         0=>array("Quantidade de chamadas recebidas",$Recebidas),
         1=>array("Quantidade de chamadas Atendidas por operadores",$Quant['Chamadas Atendidas']),
         2=>array("Quantidade de desistncias",$Quant['Desistencias']),
         3=>array("Quantidade de atendimentos da caixa postal",$Quant['Desistencias Cx']),
         4=>array("Quantidade total de chamadas no atendidas - Mensagem",$Quant['Desistencias Msg']),
         5=>array("Quantidade total de chamadas no atendidas - Desligamento",$Quant['Desistencias Desliga']),
         6=>array("Quantidade total de chamadas no atendidas por operadores",$Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga']),
         7=>array("Quantidade de chamadas  com tempo de espera > mximo",$Quant['Espera Maxima']),
         8=>array("Tempo mdio de espera para atendimento",formata_hora($Tempo['Media Espera'])),
         9=>array("Aproveitamento",number_format($Nivel*100, 2, ',', ' ')."%")
       );
         //4=>array("Quantidade de transbordo",$Quant['Desistencias Fila']),
     }
   }
   ($Total['B']==0) ? $Total[8] = 0 : $Total[8] = ($Total['A'] / $Total['B']);
   $Total[8] = formata_hora($Total[8]);
   ($Total[0]==0) ? $Total[9] = 0 : $Total[9] = ($Total[1] / $Total[0]);
   $Total[9] = number_format($Total[9]*100, 2, ',', ' ')."%";
   $Saida  = '';
   $Saida .= '<table class="relat"><tr><td class="relatT">';
   $Saida .= 'Horas';
   $Saida .= '</td>';
   for ($y=$Moni_Hora_inicial; $y<$Moni_Hora_final+1; $y++) $Saida .= '<td class="relatT">'.sprintf('%02d',$y).'</td>';
   $Saida .= '<td class="relatT">Total</td>';
   $Saida .= '</tr>'."\n";
   $Cor   = "#FFFFFF";
   for ($y=0; $y<10; $y++) {
     if (($y==4) || ($y==5)) continue;
     $Saida .= '<tr>';
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
     $Saida .= '<td class="relat" style="font-weight:bold;text-align:left;background-color:'.$Cor.'">'.$Campo[$Moni_Hora_inicial][$y][0].'</td>';
     for ($x=intval($Moni_Hora_inicial,10); $x<intval($Moni_Hora_final,10)+1; $x++) {
       $Aux = $Campo[$x][$y];
       $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Aux[1].'</td>';
     }
     $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Total[$y].'</td>';
     $Saida .= '</tr>'."\n";
   }
   $Saida .= '</table>'."\n";
   return $Saida;
 }


/**************************************************************
  Funcao monta_relatorio_planilha_filas_dia
 *************************************************************/
 function monta_relatorio_planilha_filas_dia($Filas, $Dados, $De, $Aa) {
   if (!$Filas) return "Erro";
   list ($data_d, $horario_d) = explode (' ', $De); list ($dia_d, $mes_d, $ano_d) = explode ('/', $data_d);
   list ($data_a, $horario_a) = explode (' ', $Aa); list ($dia_a, $mes_a, $ano_a) = explode ('/', $data_a);
   //return $De ." = ".$dia_d." >> ".$Aa ." = ".$dia_a." >> ";
   //print_r( $Dados, $Saida );
   //return $Saida;
   $Total = array(0,0,0,0,0,0,0,0,0);
   if ($Dados) {
     $FFila  = $Filas;
     for ($y=intval($dia_d,10); $y<intval($dia_a,10)+1; $y++) {
       $Tempo = $Dados[$y][0];
       $Quant = $Dados[$y][1];
       if ($Quant['Chamadas Atendidas'] < 1)   $Quant['Chamadas Atendidas']=0;
       if ($Quant['Desistencias'] < 1)         $Quant['Desistencias']=0;
       if ($Quant['Desistencias Fila'] < 1)    $Quant['Desistencias Fila']=0;
       if ($Quant['Desistencias Cx'] < 1)      $Quant['Desistencias Cx']=0;
       if ($Quant['Desistencias Msg'] < 1)     $Quant['Desistencias Msg']=0;
       if ($Quant['Desistencias Desliga'] < 1) $Quant['Desistencias Desliga']=0;
       if ($Quant['Espera Maxima'] < 1)        $Quant['Espera Maxima']=0;
       if ($Tempo['Espera'] < 1)               $Tempo['Espera']=0;
       if ($Quant['Espera'] < 1)               $Quant['Espera']=0;
       if ($Quant['Espera']==0)                $Tempo['Media Espera'] = 0;
       else $Tempo['Media Espera'] = ($Tempo['Espera']/$Quant['Espera']);
       //$Recebidas = $Quant['Chamadas Atendidas']+$Quant['Desistencias']+$Quant['Desistencias Fila']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Recebidas = $Quant['Chamadas Atendidas']+$Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Total[0] += $Recebidas;
       //$Total[0] += $Quant['Chamadas Atendidas']+$Quant['Desistencias']+$Quant['Desistencias Fila']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       //$Total[0] += $Quant['Chamadas Atendidas']+$Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Total[1] += $Quant['Chamadas Atendidas'];
       $Total[2] += $Quant['Desistencias'];
       $Total[3] += $Quant['Desistencias Cx'];
       //$Total[4] += $Quant['Desistencias Fila'];
       $Total[4] += $Quant['Desistencias Msg'];
       $Total[5] += $Quant['Desistencias Desliga'];
       //$Total[7] += $Quant['Desistencias']+$Quant['Desistencias Fila']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Total[6] += $Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga'];
       $Total[7] += $Quant['Espera Maxima'];
       $Total['A'] += $Tempo['Espera'];
       $Total['B'] += $Quant['Espera'];
       ($Recebidas==0) ? $Nivel = 0 : $Nivel = $Quant['Chamadas Atendidas']/$Recebidas;
       $Campo[$y] = array(
         0=>array("Quantidade de chamadas recebidas",$Quant['Chamadas Atendidas']+$Quant['Desistencias']+$Quant['Desistencias Fila']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga']),
         1=>array("Quantidade de chamadas Atendidas por operadores",$Quant['Chamadas Atendidas']),
         2=>array("Quantidade de desistncias",$Quant['Desistencias']),
         3=>array("Quantidade de atendimentos da caixa postal",$Quant['Desistencias Cx']),
         4=>array("Quantidade total de chamadas no atendidas - Mensagem",$Quant['Desistencias Msg']),
         5=>array("Quantidade total de chamadas no atendidas - Desligamento",$Quant['Desistencias Desliga']),
         6=>array("Quantidade total de chamadas no atendidas por operadores",$Quant['Desistencias']+$Quant['Desistencias Cx']+$Quant['Desistencias Msg']+$Quant['Desistencias Desliga']),
         7=>array("Quantidade de chamadas  com tempo de espera > mximo",$Quant['Espera Maxima']),
         8=>array("Tempo mdio de espera para atendimento",formata_hora($Tempo['Media Espera'])),
         9=>array("Aproveitamento",number_format($Nivel*100, 2, ',', ' ')."%")
       );
         //4=>array("Quantidade de transbordo",$Quant['Desistencias Fila']),
     }
   }
   ($Total['B']==0) ? $Total[8] = 0 : $Total[8] = ($Total['A'] / $Total['B']);
   $Total[8] = formata_hora($Total[8]);
   ($Total[0]==0) ? $Total[9] = 0 : $Total[9] = ($Total[1] / $Total[0]);
   $Total[9] = number_format($Total[9]*100, 2, ',', ' ')."%";
   $Saida  = '';
   $Saida .= '<table class="relat"><tr><td class="relatT">';
   $Saida .= 'Horas';
   $Saida .= '</td>';
   for ($y=intval($dia_d,10); $y<intval($dia_a,10)+1; $y++) $Saida .= '<td class="relatT">'.$y.'</td>';
   $Saida .= '<td class="relatT">Total</td>';
   $Saida .= '</tr>'."\n";
   $Cor   = "#FFFFFF";
   for ($y=0; $y<10; $y++) {
     if (($y==4) || ($y==5)) continue;
     $Saida .= '<tr>';
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
     $Saida .= '<td class="relat" style="font-weight:bold;text-align:left;background-color:'.$Cor.'">'.$Campo[$dia_d][$y][0].'</td>';
     for ($x=intval($dia_d,10); $x<intval($dia_a,10)+1; $x++) {
       $Aux = $Campo[$x][$y];
       $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Aux[1].'</td>';
     }
     $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Total[$y].'</td>';
     $Saida .= '</tr>'."\n";
   }
   $Saida .= '</table>'."\n";
   return $Saida;
 }


/**************************************************************
  Funcao monta_relatorio_planilha_filas_desempenho
 *************************************************************/
 function monta_relatorio_planilha_filas_desempenho($Filas, $Dados, $hora_ini, $hora_fim) {
   $Auxd  = explode(' ', $hora_ini);
   $Auxd1 = explode('-', $Auxd[0]);
   $Auxd2 = explode(':', $Auxd[1]);
   $Auxa  = explode(' ', $hora_fim);
   $Auxa1 = explode('-', $Auxa[0]);
   $Auxa2 = explode(':', $Auxa[1]);
   if (!$Filas) return "Erro";
   if (!$Dados) return "";
   $TotalD = array();
   $DiasS  = array();
   $DiaSem = array('Dom','Seg','Ter','Qua','Qui','Sex','Sab');
   $FFila  = $Filas;
   $Quant = $Dados;
//$Saida = print_r($Quant,true);
//return $Saida;
   $Saida  = '';
   $Saida .= '<table class="relat"><tr><td class="relatT">';
   $Saida .= 'Dias do ms';
   $Saida .= '</td>';
   $DS_ini = date("w",mktime(0, 0, 0, $Auxd1[1], $Auxd1[2], $Auxd1[0]));
   for ($d = $Auxd1[2]; $d <= $Auxa1[2]; $d++) $Saida .= '<td class="relatT">'.sprintf('%02d',$d).'</td>';
   $Saida .= '<td class="relatT">Total</td>';
   $Saida .= '</tr>'."\n";
   $Saida .= '<td class="relatT">Perodos</td>'."\n";
   $DS = $DS_ini;
   $DiasUteis = 0;
   for ($d = intval($Auxd1[2],10); $d <= $Auxa1[2]; $d++) {
     $Saida .= '<td class="relatT">'.$DiaSem[$DS].'</td>';
     $DiasS[$d] = $DS;
     if (($DS>0) && ($DS<6)) $DiasUteis ++;
     $DS++;
     if ($DS>6) $DS=0;
     $TotalD[$d] = 0;
   }
   $Saida .= '<td class="relatT"></td></tr>'."\n";
   $Cor   = "#FFFFFF";
   $TotalUtil = 0;
   for ($h = intval($Auxd2[0],10); $h <= $Auxa2[0]; $h++) {
     $Total = 0;
     $Saida .= '<tr>';
     ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
     $Saida .= '<td class="relat" style="font-weight:bold;text-align:left;background-color:'.$Cor.';font-size:8pt;">'.sprintf('%02d',$h).':00 as '.sprintf('%02d',$h+1).':00</td>';
     for ($d = intval($Auxd1[2],10); $d <= $Auxa1[2]; $d++) {
       $Aux = $Quant[$d][$h]['Chamadas Atendidas']+$Quant[$d][$h]['Desistencias']+$Quant[$d][$h]['Desistencias Cx']+$Quant[$d][$h]['Desistencias Msg']+$Quant[$d][$h]['Desistencias Desliga'];
       //$Aux = $Quant[$d][$h]['Chamadas Recebidas'];
       $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Aux.'</td>';
       $Total += $Aux;
       $TotalD[$d] += $Aux;
       if (($DiasS[$d]>0) && ($DiasS[$d]<6)) $TotalUtil += $Aux;
     }
     $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Total.'</td>';
     $Saida .= '</tr>'."\n";
   }
   $Saida .= '<tr>';
   ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
   $Total = 0;
   $Saida .= '<td class="relat" style="font-weight:bold;text-align:left;background-color:'.$Cor.'">Total</td>';
   for ($d = intval($Auxd1[2],10); $d <= $Auxa1[2]; $d++) {
     $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$TotalD[$d].'</td>';
     $Total += $TotalD[$d];
   }
   $Saida .= '<td class="relat" style="background-color:'.$Cor.'">'.$Total.'</td>';
   $Saida .= '</tr>'."\n";
   $Saida .= '</table>'."\n";
   $Saida .= '<br>'."\n";
   $Saida .= '<p class="texto">Mdia em <b>'.($Auxa1[2] - $Auxd1[2]+1).'</b> dias: <b>'.sprintf("%01.2f", ($Total/($Auxa1[2] - $Auxd1[2]+1))).'</b></p>'."\n";
   $Saida .= '<p class="texto">Mdia em <b>'.$DiasUteis.'</b> dias teis: <b>'.sprintf("%01.2f", ($Total/$DiasUteis)).'</b></p>'."\n";
   return $Saida;
 }


/**************************************************************
  Funcao monta_relatorio_ligacoes_filas
 *************************************************************/
 function monta_relatorio_ligacoes_filas($Filas, $Dados, $De, $Aa) {
   if (!$Filas) return "Erro";
   $Saida  = '';
   if ($Dados) {
     $DesisT = $Dados['Desistencias'];
     $DesisF = $Dados['Desistencias Fila'];
     $DesisC = $Dados['Desistencias Cx'];
     $DesisM = $Dados['Desistencias Msg'];
     $DesisD = $Dados['Desistencias Desliga'];

     if (count($DesisT)>0) {
       $Saida .= '<table class="relat">'."\n";
       $Saida .= '<tr><td class="relatT" colspan="3">Chamadores que desistiram de esperar</td></tr>'."\n";
       $Saida .= '<tr><td class="relatT">Data</td><td class="relatT">Hora</td><td class="relatT">Telefone</td></tr>'."\n";
       for ($y=0; $y<count($DesisT); $y++) {
         $Saida .= '<tr><td>'.date('d/m',$DesisT[$y][0]).'</td><td>'.date('H:i',$DesisT[$y][0]).'</td><td>'.$DesisT[$y][1].'</td></tr>'."\n";
       }
       $Saida .= '</table><br><br>'."\n";
     }

//     if (count($DesisF)>0) {
//       $Saida .= '<table class="relat">'."\n";
//       $Saida .= '<tr><td class="relatT" colspan="3">Chamadores de transbordo</td></tr>'."\n";
//       $Saida .= '<tr><td class="relatT">Data</td><td class="relatT">Hora</td><td class="relatT">Telefone</td></tr>'."\n";
//       for ($y=0; $y<count($DesisF); $y++) {
//         $Saida .= '<tr><td>'.date('d/m',$DesisF[$y][0]).'</td><td>'.date('H:i',$DesisF[$y][0]).'</td><td>'.$DesisF[$y][1].'</td></tr>'."\n";
//       }
//       $Saida .= '</table><br><br>'."\n";
//     }

     if (count($DesisC)>0) {
       $Saida .= '<table class="relat">'."\n";
       $Saida .= '<tr><td class="relatT" colspan="3">Chamadores que foram atendidos pelo Correio de voz</td></tr>'."\n";
       $Saida .= '<tr><td class="relatT">Data</td><td class="relatT">Hora</td><td class="relatT">Telefone</td></tr>'."\n";
       for ($y=0; $y<count($DesisC); $y++) {
         $Saida .= '<tr><td>'.date('d/m',$DesisC[$y][0]).'</td><td>'.date('H:i',$DesisC[$y][0]).'</td><td>'.$DesisC[$y][1].'</td></tr>'."\n";
       }
       $Saida .= '</table><br><br>'."\n";
     }

     if (count($DesisM)>0) {
       $Saida .= '<table class="relat">'."\n";
       $Saida .= '<tr><td class="relatT" colspan="3">Chamadores que foram atendidos por mensagem e depois desconectados</td></tr>'."\n";
       $Saida .= '<tr><td class="relatT">Data</td><td class="relatT">Hora</td><td class="relatT">Telefone</td></tr>'."\n";
       for ($y=0; $y<count($DesisM); $y++) {
         $Saida .= '<tr><td>'.date('d/m',$DesisM[$y][0]).'</td><td>'.date('H:i',$DesisM[$y][0]).'</td><td>'.$DesisM[$y][1].'</td></tr>'."\n";
       }
       $Saida .= '</table><br><br>'."\n";
     }

     if (count($DesisD)>0) {
       $Saida .= '<table class="relat">'."\n";
       $Saida .= '<tr><td class="relatT" colspan="3">Chamadores que foram desconectados pelo sistema</td></tr>'."\n";
       $Saida .= '<tr><td class="relatT">Data</td><td class="relatT">Hora</td><td class="relatT">Telefone</td></tr>'."\n";
       for ($y=0; $y<count($DesisD); $y++) {
         $Saida .= '<tr><td>'.date('d/m',$DesisD[$y][0]).'</td><td>'.date('H:i',$DesisD[$y][0]).'</td><td>'.$DesisD[$y][1].'</td></tr>'."\n";
       }
       $Saida .= '</table><br><br>'."\n";
     }

   }
   return $Saida;
 }


/**************************************************************
  Funcao monta_relatorio_acumulado_grupos
 *************************************************************/
 function monta_relatorio_acumulado_grupos($Grupos,$Meses,$Dados) {
//$Saida = print_r($Dados,true);
//return $Saida;
   if (!$Grupos) return "Erro";
   $Total = array();
   for ($y=0; $y<count($Grupos); $y++) {
     for ($x=0; $x<count($Meses); $x++) {
       $Grupo = $Grupos[$y]; $Mes = $Meses[$x];
       if ($Dados[$Grupo][$Mes]) {
         $Quant = $Dados[$Grupo][$Mes][1][2];
         $Var0  = $Quant['Fila']['Atendendo']+$Quant['DDR']['Atendendo']+$Quant['Total transfer atendidas']['Atendendo']+$Quant['Total externa atendidas']['Atendendo']+$Quant['Consulta-Atendidas']['Atendendo']+$Quant['Fila']['Nao Atendidas']+$Quant['DDR']['Nao Atendidas']+$Quant['Total transfer']['Nao Atendidas']+$Quant['Total externas recebidas']['Nao Atendidas']+$Quant['Consulta-Atendidas']['Nao Atendidas'];
         $Var1  = $Quant['Total transfer efetuadas']['Chamando']+$Quant['Fazendo chamada externa']['Atendendo']+$Quant['Fazendo chamada externa']['Nao Atendidas']+$Quant['Consulta-Realizadas']['Atendendo'];
         $Total[$Grupo][0] += $Var0;
         $Total[$Grupo][1] += $Var1;
         $Campo[$Grupo][$Mes] = array($Var0,$Var1);
       }
     }
   }
   $Saida  = '';
   $Saida .= '<table class="relat"><tr><td class="relatT">Grupos</td><td class="relatT">Dados</td>';
   for ($x=0; $x<count($Meses); $x++) $Saida .= '<td class="relatT">'.$Meses[$x].'</td>';
   $Saida .= '<td class="relatT">Total</td></tr>'."\n";
   for ($y=0; $y<count($Grupos); $y++) {
     $Saida .= '<tr><td class="relat" rowspan="2">'.$Grupos[$y].'</td>';
     $Grupo = $Grupos[$y];
     for ($x=0; $x<count($Meses); $x++) {
       $Mes = $Meses[$x];
       $Aux = $Campo[$Grupo][$Mes];
       if ($x==0) $Saida .= '<td class="relat" style="background-color:#C0C0C0">Entradas</td>';
       $Saida .= '<td class="relat" style="background-color:#C0C0C0">'.number_format($Aux[0], 0, ',', '.').'</td>';
     }
     $Saida .= '<td class="relat" style="background-color:#C0C0C0">'.number_format($Total[$Grupo][0], 0, ',', '.').'</td></tr>';
     $Saida .= '<tr>';
     for ($x=0; $x<count($Meses); $x++) {
       $Mes = $Meses[$x];
       $Aux = $Campo[$Grupo][$Mes];
       if ($x==0) $Saida .= '<td class="relat" style="background-color:#FFFFFF">Sadas</td>';
       $Saida .= '<td class="relat" style="background-color:#FFFFFF">'.number_format($Aux[1], 0, ',', '.').'</td>';
     }
     $Saida .= '<td class="relat" style="background-color:#FFFFFF">'.number_format($Total[$Grupo][1], 0, ',', '.').'</td></tr>';
   }
   $Saida .= '</table>'."\n";
   return $Saida;
 }

?>
