<?php
/**************************************************************
 * Nome:    CCMoni
 * Autor:   Renato N. Lourenço
 * Data:	  2008-01-25 (V1.0.0)
 * Descr.:  Monitoramento de filas
 *************************************************************/


/**************************************************************
  Cabecalho para nao fazer cache
 *************************************************************/
 //header('Cache-Control: no-cache, must-revalidate');
 //header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');


/**************************************************************
  Area dos includes
 *************************************************************/
 $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
 include_once($DirRaiz.'config.php');
 include_once($DirRaiz.'config.cc.php');
 include_once($DirRaiz.'config.pbx.php');
 $Modulo = $DirPBX;
 include_once($DirRaiz.$Modulo.$DirModul.'pbx.modu.php');
 $Modulo = $DirCCen;
 include_once($DirRaiz.$Modulo.$DirClass.'agentes.class.php');
 

/**************************************************************
  Definicao de variaveis
 *************************************************************/
 $L_var = $_GET;         // Recebe as variaveis do formulario
 $Agen  = new Agentes;    // Objeto agentes


/**************************************************************
  Programa principal
 *************************************************************/
 if($L_var['acao'] == "nada")
 {
 	echo $Saida = estado_agente($L_var['a']);
 	return;
 }
 else if($L_var['acao'] == "verifica_fila")
 {
	 echo $Saida = verifica_fila($L_var['a']);
	 return;
 }
 else if($L_var['acao'] == "carrega_msg_pa")
 {
	 echo $Saida = carrega_msg_pa($L_var['tip'], $L_var['a']);
	 return;
 }
 else if($L_var["acao"]=="carrega_config_geral")
 {
	 echo $Saida = carrega_config_geral();
	 return;
 }
 else if($L_var["acao"]=="carrega_status_agente"){
	echo $Saida = carrega_status_agente($L_var['agente']);
	return;
 }
 else if($L_var["acao"]=="informa_situacao_discador"){
	echo $Saida = informa_situacao_discador($L_var["enderecoApi"], $L_var["situacao"], $L_var["agente"], $L_var["tipoPausa"]);
	return;
 }
 else if($L_var["acao"]=="enviarLigacaoPainel"){
    echo $Agen->enviar_ligacao_painel($L_var["agente"], $L_var["ip_discador"], $L_var["numero"], $L_var["campanha"]);
 }
 else if($L_var["acao"]=="desligarRamal"){
    echo $Agen->desligar_ramal($L_var["ramal"]);
 }
 else if($L_var["acao"]=="transferirLigacao"){
    echo $Agen->transferirLigacao($L_var["agente"], $L_var["origem"], $L_var["destino"], $L_var["status"], $L_var["numero"]);
 }
 elseif($L_var["acao"]=="carregarChamadasEspera"){
    echo carregar_chamadas_espera($L_var["filas"]);
}


/**************************************************************
  Funcao agente_logoff
 *************************************************************/
 function estado_agente($Agente){
   global $Agen;
//   $Saida = '<span id="hora" style="{display:none;}">'.date("H:i:s").'</span>'.$Agen->estado_agentes($Agente);
   $Estado = $Agen->estado_agentes($Agente);
   $Saida = $Estado[0]."#".$Estado[1]."#".$Estado[2]."#".$Estado[3]."#".$Estado[4]."#".$Estado[5]."#".date("H:i:s");
   return $Saida;
 }
 
 /**************************************************************
  Funcao verifica_fila
 *************************************************************/
 function verifica_fila($Agente){
	 global $Agen;
	 $Verifica = $Agen->verifica_fila($Agente);
	 $Saida = $Verifica;
	 return $Saida;
 }
 
 /**************************************************************
  Funcao carrega_msg_pa
 *************************************************************/
 function carrega_msg_pa($tipo, $agente){
	 global $Agen;
	 
	 $Verifica = $Agen->carrega_mensagem_pas($tipo, $agente);
	 $Saida = $Verifica;
	 return $Saida;
 }
 
 /************************************************************
 Funcao carrega_config_geral
 ************************************************************/
 function carrega_config_geral()
 {
	 global $Agen;
	 
	 $Saida = $Agen->carrega_configs_geral();
	 $Saida = $Saida[0]['popup'];
	 return $Saida;
 }
 
 /************************************************************
 Funcao carrega_config_geral
 ************************************************************/
 function carrega_status_agente($agente)
 {
	 global $Agen;
	 $Saida = $Agen->carrega_status_agente($agente);
	 $Saida = $Saida[0]['situacao']."#".$Saida[0]['ultimo'];
	 return $Saida;
 }
 
 /************************************************************
 Funcao informa_situacao_discador
 ************************************************************/
function informa_situacao_discador($enderecoApi, $situacao, $agente, $tipoPausa=""){
	global $Agen, $HabilitaEnvioIndisponivel;

	$campanhas = $Agen->carrega_filas_agente($agente, "array");
	//$a_campanhas = explode("||", $campanhas);
	for($i = 0; $i < count($campanhas); $i++){
		if($campanhas[$i]['nome']!="") $a_filas[$i] = $campanhas[$i]['nome'];
		//$aux = explode("|", $a_campanhas[$i]);
		//if($aux[0] != "") $a_filas[$i] = $aux[0];
	}
	//return print_r($a_filas, true);
	if($situacao=="Livre" || ($situacao=="Em Pausa" && $tipoPausa == "")){
		//return "notifica livre";
		$Saida = $Agen->informa_livre_discador($enderecoApi, $agente, $a_filas);
	} else {
		//return "notifica indisponivel";
		if($HabilitaEnvioIndisponivel == "sim") $Saida = $Agen->informa_indisponivel_discador($enderecoApi, $agente, $a_filas);
	}
	return $Saida;
}

function carregar_chamadas_espera($filas){
    global $DirRaiz;
    $qtd = 0;
    if(file_exists($DirRaiz."Relatorios/Sistema/chamadas_espera.json")){
        $filas = json_decode($filas);
        $file = file_get_contents($DirRaiz."Relatorios/Sistema/chamadas_espera.json");
        $dados = json_decode($file);
        foreach($filas as $chave => $valor){
            if(isset($dados->$valor)) $qtd += $dados->$valor->quantidade;
        }
    }
    return $qtd;
}
?>
