<?php

/* * ************************************************************
 * Nome:    CCRelat
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-08-31 (V1.0.0)
 * Descr.:  Relatorios
 * *********************************************************** */


/* * ************************************************************
  Area dos includes
 * *********************************************************** */
$DirRaiz = $_SERVER['DOCUMENT_ROOT'] . '/vdt/';
include_once($DirRaiz . 'config.php');
include_once($DirRaiz . 'config.cc.php');
$Modulo = $DirCCen;
include_once($DirRaiz . $Modulo . $DirClass . 'monitor.class.php');
include_once($DirRaiz . $DirModul . 'geral.modu.php');


/* * ************************************************************
  Definicao de variaveis
 * *********************************************************** */
$Moni = new Monitores;  // Objeto monitor
$L_var = $_POST;         // Recebe as variaveis do formulario


/* * ************************************************************
  Programa Principal
 * *********************************************************** */
$Arquivo = brancos_por_sublinhado($L_var['t'] . ' ' . $L_var['m'] . '.xls');
$Arqu = cria_arquivo_excel($Arquivo);
for ($x = 0; $x < $L_var['tg']; $x++)
    $LAgentes[$x] = $L_var['g' . $x];
$Imprime = planilha_chamadas_atendidas($LAgentes, $L_var['d'], $L_var['a'], $L_var['tp'], $L_var['na'], 'xls', $L_var['tipoPes'], $L_var['tcf'], $L_var['fnafl'],$L_var['filuf']);
echo planilha_chamadas_atendidas($LAgentes, $L_var['d'], $L_var['a'], $L_var['tp'], $L_var['na'], 'html', $L_var['tipoPes'], $L_var['tcf'], $L_var['fnafl'],$L_var['filuf']) . "<br/><br/>";
if ($Arqu) {
    fwrite($Arqu, $Imprime);
    fecha_arquivo_excel($Arqu);
}
return;


/* * ************************************************************
  Funcao planilha_filas_ligacoes
 * *********************************************************** */

function planilha_chamadas_atendidas($Filas, $Per_d, $Per_a, $Tipo_per, $MinimoEspera, $Formato, $tipoPes='relat', $tempoCon="", $filtroNumero="", $ufs="") {
    global $Moni;
    $dataAtual = date("d/m/Y");
    $hoje = 0;
    $ufs = explode(",", $ufs);
	//Arrumada as datas para timestamp
    list ($data, $horario) = explode(' ', $Per_d);
    list ($dia, $mes, $ano) = explode('/', $data);
    list ($hora, $minuto) = explode(':', $horario);
    if($data == $dataAtual) $hoje = 1;
    $Aux_d = mktime($hora, $minuto, 0, $mes, $dia, $ano);
    $Aux_d = $ano . '-' . $mes . '-' . $dia . ' ' . $hora . ':' . $minuto;
    list ($data, $horario) = explode(' ', $Per_a);
    list ($dia, $mes, $ano) = explode('/', $data);
    list ($hora, $minuto) = explode(':', $horario);
    if($data == $dataAtual && $hoje == 1) $hoje = 1;
    else $hoje = 0;
    $Aux_a = mktime($hora, $minuto, 0, $mes, $dia, $ano);
    $Aux_a = $ano . '-' . $mes . '-' . $dia . ' ' . $hora . ':' . $minuto;
    if (!($Aux_d) || ($Aux_d < 0))
        return "Perodo invlido";
    if (!($Aux_a) || ($Aux_a < 0))
        return "Perodo invlido";
    
    $Tabela = $DadosF = array();
    $Saida = '';


    for ($F = 0; $F < count($Filas); $F++) {
        if($hoje == 0) $Tabela = $Moni->relatorio_filas_geral($Filas[$F],$Aux_d,$Aux_a, $MinimoEspera,'', 'relat', $tempoCon, $filtroNumero);
        if($hoje == 1) $Tabela = $Moni->relatorio_filas_geral($Filas[$F],$Aux_d,$Aux_a, $MinimoEspera, 'hoje', 'monit', $tempoCon, $filtroNumero);
        //return print_r($Tabela, true);
        if($ufs[0] != ""){
            $j = 0;
            for($i = 0; $i < count($Tabela['Geral']); $i++){
                foreach($ufs as $uf){
                    if($Tabela['Geral'][$i]['UF'] == $uf){
                        $TabelaA['Geral'][$j] = $Tabela['Geral'][$i];
                        $j++;
                    }
                }
            }
            foreach($ufs as $uf){
                $TabelaA['Quantidade Desistencia-FilA'] += $Tabela['UF'][$uf]['Quantidade Desistencia-FilA'];
                $TabelaA['Quantidade Desistencia-Desligamento'] += $Tabela['UF'][$uf]['Quantidade Desistencia-Desligamento'];
                $TabelaA['Quantidade chamadas recebidas'] += $Tabela['UF'][$uf]['Quantidade chamadas recebidas'];
                $TabelaA['Quantidade chamadas atendidas'] += $Tabela['UF'][$uf]['Quantidade chamadas atendidas'];
            }
            $Tabela = $TabelaA;
        }

        $DadosF[$F] = $Tabela;
    }

    if ($Formato == "html") {
        $Saida .= '<p class="reltit">Relatrio analtico de chamadas de filas '."\n";
        $Saida .= '<p class="relper">Perodo: &nbsp;&nbsp;' . substr($Per_d, 0, 16) . '&nbsp;&nbsp;&nbsp;>>>&nbsp;&nbsp;&nbsp;' . substr($Per_a, 0, 16) . "\n";
    } elseif ($Formato == "xls") {
        $Saida .= '<table x:str border=0 cellpadding=0 cellspacing=0 style="border-collapse: collapse;table-layout:fixed;">';
        $Saida .= '<tr><td class=xl24 width=64 colspan="3">';
        $Saida .= 'Relat&oacute;rio unificado de chamadas de filas';
        $Saida .= '</td></tr><tr><td class=xl24 width=64 colspan="3">';
        $Saida .= 'Per&iacute;odo: &nbsp;&nbsp;' . substr($Per_d, 0, 16) . '&nbsp;&nbsp;&nbsp;>>>&nbsp;&nbsp;&nbsp;' . substr($Per_a, 0, 16);
        $Saida .= '</td></tr>';
    }

    $Saida .= monta_relatorio_chamadas_unificado($Filas, $DadosF, $Per_d, $Per_a, $Formato);
    if ($Formato == "xls")
        $Saida .= '<tr><td class=xl24 width=64></td></tr><tr><td class=xl24 width=64></td></tr>';

    return $Saida;
}

/* * ************************************************************
  Funcao monta_relatorio_chamadas_atendidas
 * *********************************************************** */

function monta_relatorio_chamadas_unificado($Filas, $DadosF, $De, $Aa, $Formato) {
	global $LinkRaiz, $Modulo, $DirTelas;
    $recebidas = 0;
    $atendidas = 0;
    $naoAtendidas = 0;
    $transbordo = 0;
    
    if (!$Filas) return "Erro";
    $Saida = '';

    if ($Formato == "html") $Saida .= '<table class="relat">';
    if ($Formato == "html") $Saida .= '<tr><td class="relatT" colspan="7">';
    if ($Formato == "xls") $Saida .= '<tr><td class=xl24 width=64 colspan="7">';
    $Saida .= 'Chamadas de filas</td></tr>' . "\n";
    $Saida .= '<tr>';
    if ($Formato == "html") $Saida .= '<td class="relatT">';
    if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
    $Saida .= 'Data e hora</td>';
    if ($Formato == "html") $Saida .= '<td class="relatT">';
    if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
    $Saida .= 'Atendido por</td>' . "\n";
    if ($Formato == "html") $Saida .= '<td class="relatT">';
    if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
    $Saida .= 'Telefone</td>' . "\n";
    if ($Formato == "html") $Saida .= '<td class="relatT">';
    if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
    $Saida .= 'Tempo em espera</td>' . "\n";
    if ($Formato == "html") $Saida .= '<td class="relatT">';
    if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
    $Saida .= 'Tempo em conversa&ccedil;&atilde;o</td>' . "\n";
    if ($Formato == "html") $Saida .= '<td class="relatT">';
    if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
    $Saida .= 'Status</td>' . "\n";
    if ($Formato == "html") $Saida .= '<td class="relatT">';
    if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
    $Saida .= 'Classificao</td></tr>' . "\n";

    $Cor   = "#FFFFFF";

    for($f = 0; $f < count($DadosF); $f++){
        $Dados = $DadosF[$f];

        $recebidas += $Dados['Quantidade chamadas recebidas'];
        $atendidas += $Dados['Quantidade chamadas atendidas'];
        $naoAtendidas += $Dados['Quantidade Desistencia-FilA']+$Dados['Quantidade Desistencia-Desligamento'];
        $transbordo += $Dados['Quantidade Transbordo'];

        
        for ($y = 0; $y < count($Dados['Geral']); $y++) {
            if($Dados['Geral'][$y]['Data'] != ""){
                ($Cor=="#FFFFFF") ? $Cor = "#C0C0C0" : $Cor = "#FFFFFF";
                $Saida .= '<tr>';
                if ($Formato == "html") $Saida .= '<td class="relat" style="background-color: '.$Cor.'">';
                if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
                $Saida .= $Dados['Geral'][$y]['Data'] . '</td>';
                if ($Formato == "html") $Saida .= '<td class="relat" style="background-color: '.$Cor.'">';
                if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
                $Saida .= $Dados['Geral'][$y]['Quem atendeu'] . '</td>';
                if ($Formato == "html") $Saida .= '<td class="relat" style="background-color: '.$Cor.'">';
                if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
                $Saida .= $Dados['Geral'][$y]['Numero'] . '</td>' . "\n";
                if ($Formato == "html") $Saida .= '<td class="relat" style="background-color: '.$Cor.'">';
                if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
                $Saida .= formata_hora($Dados['Geral'][$y]['Tempo em espera']) . '</td>' . "\n";
                if ($Formato == "html") $Saida .= '<td class="relat" style="background-color: '.$Cor.'">';
                if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
                $Saida .= formata_hora($Dados['Geral'][$y]['Tempo em conversacao']) . '</td>' . "\n";
                if ($Formato == "html") $Saida .= '<td class="relat" style="background-color: '.$Cor.'">';
                if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
                if($Dados['Geral'][$y]['Status'] == "Atendida") $Saida .= '<a target="_blank" href="'.$LinkRaiz.$Modulo.$DirTelas.'carregagravacao.tela.php?diahora='.$Dados['Geral'][$y]['Data'].'&numero='.$Dados['Geral'][$y]['Numero'].'&fila='.str_replace("Filas ", "", $Filas).'&agente='.$Dados['Geral'][$y]['Quem atendeu'].'">'.$Dados['Geral'][$y]['Status'] . '</a></td>' . "\n";
                else $Saida .= $Dados['Geral'][$y]['Status'] . '</td>' . "\n";
                if ($Formato == "html") $Saida .= '<td class="relat" style="background-color: '.$Cor.'">';
                if ($Formato == "xls") $Saida .= '<td class=xl24 width=64>';
                $Saida .= $Filas[$f] . '</td></tr>' . "\n";
            }
        }
    }

    $html .= '<p class="textopa">Total de chamadas recebidas: ' . $recebidas . '<br>';
    $html .= '<p class="textopa">Total de chamadas atendidas: ' . $atendidas . '<br>';
    $html .= '<p class="textopa">Total de chamadas n&atilde;o atendidas: ' . $naoAtendidas . '<br>';
    $html .= '<p class="textopa">Total de transbordadas: ' . $transbordo . '<br>';

    $html .= $Saida;

    if ($Formato == "html")
        $Saida .= '</table><br><br>' . "\n";

    return $html;
}

?>
