<?php
/**************************************************************
* Nome:    CCRelat
* Autor:   Renato N. Lourenço
* Data:      2015-01-05 (V1.0.0)
* Descr.:  Relatorios
*************************************************************/


/**************************************************************
Area dos includes
*************************************************************/
error_reporting(E_ALL);
$DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
include_once($DirRaiz.'config.php');
include_once($DirRaiz.'config.cc.php');
$Modulo = $DirCCen;
include_once($DirRaiz.$Modulo.$DirClass.'monitor.class.php');
include_once($DirRaiz.$DirModul.'geral.modu.php');
include_once($DirRaiz.$Modulo.$DirModul.'ccger.modu.php');
include_once($DirRaiz.'libs/PHPExcel/PHPExcel.php');


/**************************************************************
Definicao de variaveis
*************************************************************/
$Moni  = new Monitores;  // Objeto monitor
$L_var = $_POST;         // Recebe as variaveis do formulario

/**************************************************************
Programa Principal
*************************************************************/
$Arquivo = brancos_por_sublinhado($L_var['t'].' '.$L_var['m'].'.xls');
for ($x=0; $x<$L_var['tg']; $x++) $LQualificacoes[$x] = $L_var['g'.$x];
echo planilha_qualificacoes($LQualificacoes,$L_var['d'],$L_var['a'],$L_var['tp'],'html');
return;

function planilha_qualificacoes($qualificacoes, $inicio, $fim, $tipo_periodo, $formato){
    global $Moni;
    //Arrumada as datas para timestamp
    list ($data_d, $horario_d) = explode (' ', $inicio); list ($dia_d, $mes_d, $ano_d) = explode ('/', $data_d); list ($hora_d, $minuto_d) = explode (':', $horario_d);
    if($dataAtual == $data_d) $hoje = 1;
    list ($data_a, $horario_a) = explode (' ', $fim); list ($dia_a, $mes_a, $ano_a) = explode ('/', $data_a); list ($hora_a, $minuto_a) = explode (':', $horario_a);
    if(($dataAtual != $data_a) || ($hoje != 1)) $hoje = 0;
    $Auy_d = mktime($hora_d, $minuto_d, 0, $mes_d, $dia_d, $ano_d); // $Aux_d = $ano_d.'-'.$mes_d.'-'.$dia_d.' '.$hora_d.':'.$minuto_d;
    $Auy_a = mktime($hora_a, $minuto_a, 0, $mes_a, $dia_a, $ano_a); // $Aux_a = $ano_a.'-'.$mes_a.'-'.$dia_a.' '.$hora_a.':'.$minuto_a;
    if (!($Auy_d) || ($Auy_d<0)) return "Período inválido";
    if (!($Auy_a) || ($Auy_a<0)) return "Período inválido";
    if ($Auy_d > $Auy_a) return "Per&icute;odo in&acute;lido";
    $Aux_d = $ano . '-' . $mes . '-' . $dia . ' ' . $hora . ':' . $minuto;
    $Aux_a = $ano . '-' . $mes . '-' . $dia . ' ' . $hora . ':' . $minuto;

    for($i = 0; $i < count($qualificacoes); $i++){
        $dados[$qualificacoes[$i]] = $Moni->gerar_relatorio_qualificacoes($inicio, $fim, $qualificacoes[$i]);
    }
    
    $Saida  = '';
    /*if ($formato=="html") {
        $Saida .= '<p class="reltit">Relat&oacute;rio totalizado de qualifica&ccedil;&otilde;es'."</p>\n";
        $Saida .= '<p class="relper">Per&iacute;odo: &nbsp;&nbsp;'.substr($inicio,0,16).'&nbsp;&nbsp;&nbsp;>>>&nbsp;&nbsp;&nbsp;'.substr($fim,0,16)."</p>\n";
    } elseif ($formato=="xls") {03
        $Saida .= '<table x:str border=0 cellpadding=0 cellspacing=0 style="border-collapse: collapse;table-layout:fixed;">';
        $Saida .= '<tr><td class=xl24 width=64 colspan="3">';
        $Saida .= 'Relat&oacute;rio totalizado de qualifica&ccedil;&otilde;es';
        $Saida .= '</td></tr><tr><td class=xl24 width=64 colspan="3">';
        $Saida .= 'Per&iacute;odo: &nbsp;&nbsp;'.substr($inicio,0,16).'&nbsp;&nbsp;&nbsp;>>>&nbsp;&nbsp;&nbsp;'.substr($fim,0,16);
        $Saida .= '</td></tr>';
    }*/
    $Saida .= monta_relatorio_planilha_qualificacoes($qualificacoes,$dados,$formato);
    //if ($formato=="xls") $Saida .= '<tr><td class=xl24 width=64></td></tr><tr><td class=xl24 width=64></td></tr>';
    return $Saida;
}

function monta_relatorio_planilha_qualificacoes($qualificacoes, $dados, $formato){
    $totalQualificacoes = 0;
    $saida["html"] = '<p class="reltit">Relat&oacute;rio totalizado de qualifica&ccedil;&otilde;es'."</p>\n";;
    $saida["html"] .= "<table class='relat' style='width:200px;'><tr><td class='relatT'>";
    $saida["html"] .= "Qualifica&ccedil;&atilde;o</td>";
    $saida["html"] .= "<td class='relatT'>Total</td>";
    $saida["html"] .= "</tr>";

    for($i = 0; $i < count($qualificacoes); $i++){
    	$saida["html"] .= "<tr>";
    	$saida["html"] .= "<td class='relat'>".$qualificacoes[$i]."</td>";
    	$saida["html"] .= "<td class='relat'>".count($dados[$qualificacoes[$i]]["Detalhes"])."</td>";
    	$saida["html"] .= "</tr>";
    	$totalQualificacoes += count($dados[$qualificacoes[$i]]["Detalhes"]);
    }
    
    $saida["html"] .= "<div id='div_grafico' style='float:right;'></div>";
    $saida["tipo"] = "Qualificações Totalizado";
    
    for($i = 0; $i < count($qualificacoes); $i++){
    	$porcent = count($dados[$qualificacoes[$i]]["Detalhes"]) * 100 / $totalQualificacoes;
    	$saida["dados"][] = array($qualificacoes[$i], $porcent);
    }
    gerarRelatorioExcel($qualificacoes, $dados);
    return json_encode($saida);
}

function gerarRelatorioExcel($qualificacoes, $dados){
	global $DirRaiz, $DirDownl, $Arquivo;
	//return $DirRaiz.$DirDownl.$Arquivo;
	$phpExcel = new PHPExcel();
	$worksheet = $phpExcel->getActiveSheet();

	//Monta a tabela do excel no array
	$tabela = array();
	$tabela[] = array("Qualificação", "Quantidade");
	for($i = 0; $i < count($qualificacoes); $i++){
		$array = array($qualificacoes[$i], count($dados[$qualificacoes[$i]]["Detalhes"]));
		$tabela[] = $array;
	}
	$worksheet->fromArray($tabela);

	$worksheet->getStyle("A1")->getFont()->setBold(true);
	$worksheet->getStyle("B1")->getFont()->setBold(true);

	$worksheet->getColumnDimension("A")->setAutoSize(true);
	$worksheet->getColumnDimension("B")->setAutoSize(true);

	//Seta as Labels da tabela
	$labels = array(
		new PHPExcel_Chart_DataSeriesValues('String', 'Worksheet!$A$1', NULL, 1),
		new PHPExcel_Chart_DataSeriesValues('String', 'Worksheet!$B$1', NULL, 1)
	);

	//Seta a coluna A do gráfico
	$xAxisTickValues1 = array(
		new PHPExcel_Chart_DataSeriesValues('String', 'Worksheet!$A$2:$A$'.(1+count($qualificacoes)), NULL, 3)
	);

	//Seta os dados do gráfico
	$values = array(
		new PHPExcel_Chart_DataSeriesValues('Number', 'Worksheet!$B$2:$B$'.(1+count($qualificacoes)), NULL, 3)
	);

	$series = new PHPExcel_Chart_DataSeries(
		PHPExcel_Chart_DataSeries::TYPE_PIECHART_3D,
		NULL,
		range(0, count($values)-1),
		$labels,
		$xAxisTickValues1,
		$values
	);

	$layout = new PHPExcel_Chart_Layout();
	$layout->setShowVal(true);
	$layout->setShowPercent(false);

	//Seta a área do gráfico
	$plot = new PHPExcel_Chart_PlotArea($layout, array($series));
	//Seta a legenda do gráfico
	$legend = new PHPExcel_Chart_Legend(PHPExcel_Chart_Legend::POSITION_RIGHT, NULL, false);
	//Seta o título
	$title = new PHPExcel_Chart_Title('Qualificações Totalizado');

	//Cria o gráfico
	$chart = new PHPExcel_Chart(
		'grafico',		// name
		$title,		// title
		$legend,		// legend
		$plot,		// plotArea
		true,			// plotVisibleOnly
		0,				// displayBlanksAs
		NULL,			// xAxisLabel
		NULL			// yAxisLabel		- Pie charts don't have a Y-Axis
	);
	//Seta a posição do top left e bottom right do gráfico
	$chart->setTopLeftPosition('D1');
	$chart->setBottomRightPosition('M25');

	//	Adiciona o gráfico para o excel
	$worksheet->addChart($chart);

	$objWriter = PHPExcel_IOFactory::createWriter($phpExcel, 'Excel2007');
	$objWriter->setIncludeCharts(TRUE);
	$objWriter->save($DirRaiz.$DirDownl.$Arquivo);
}
?>