<?php
class WebSocket {
	
	private $_host;
	private $_port;
	private $_log;
	private $_socket;
	private $_clients;
	private $_changed;
	private $_debug;
    private $_debug2;
	
	public function __construct($host, $port){
		$this->_host = $host;
		$this->_port = $port;
		echo "Servidor iniciando...\n";
		$this->_debug = false;
        $this->_debug2 = false;
        if($this->_debug2) $this->printDebug("Servidor iniciando...");
		
		//Cria o socket TCP/IP
		$this->_socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
		
		//Resusa o endere? para evitar erro de "endere? j?em uso"
		socket_set_option($this->_socket, SOL_SOCKET, SO_REUSEADDR, 1);
	}
	
	public function open(){
		//Faz o bind do socket na porta. 
		socket_bind($this->_socket, $this->_host, $this->_port);
		echo "Servidor criado em: ".$this->_host.":".$this->_port."\n";
        if($this->_debug2) $this->printDebug("Servidor criado em: ".$this->_host.":".$this->_port);
		//Abre a escuta no socket
		socket_listen($this->_socket);
		echo "Servidor escutando...\n\n";
        if($this->_debug2) $this->printDebug("Servidor escutando...");
		//Cria e adiciona o socket em escuta na lista de clientes
		$this->_clients = array($this->_socket);
	}
	
	private function check_new_clients(){
		//Manuseia as conex?es
		$this->_changed = $this->_clients;

		//Retorna o id do socket
		socket_select($this->_changed, $null, $null, 0, 10);
	        
		//Verifica por novos sockets
		if (in_array($this->_socket, $this->_changed)) {
			$socket_new = socket_accept($this->_socket); //aceita o novo socket (novo cliente)
			$this->_clients[] = $socket_new; //adiciona o novo cliente na lista de clientes
			
			$header = @socket_read($socket_new, 1024); //l?os dados enviados pelo socket
                        
                        if($header === false || $header === 0) return;
			$this->perform_handshaking($header, $socket_new, $this->_host, $this->_port); //faz o handshake com o novo cliente
			
			socket_getpeername($socket_new, $ip); //pega o ip do novo cliente e guarda na vari?el $ip
			
			//make room for new socket
			$found_socket = array_search($this->_socket, $this->_changed);
			unset($this->_changed[$found_socket]);
			if($this->_debug) echo "Novo cliente conectado: ".$ip."\n";
            if($this->_debug2) $this->printDebug("Novo cliente conectado: ".$ip);
			return $socket_new;
		}
		return null;
	}
	
	public function check_new_messages(){
		$this->check_new_clients();
		$received_text = "";
		//Loop percorrendo todos os clientes
		foreach ($this->_changed as $changed_socket) {
			//Verifica se chegou mensagem nova
			while(@socket_recv($changed_socket, $buf, 1024, 0) >= 1)
			{
				$received_text = $this->unmask($buf); //unmask mensagem
				socket_getpeername($changed_socket, $ip);
				if($this->_debug) echo "Nova mensagem recebida de ".$ip.": ".$received_text."\n";
                if($this->_debug2) $this->printDebug("Nova mensagem recebida de ".$ip.": ".$received_text);
				break 2; //sai do loop
			}
			
			$this->check_client_disconnected($changed_socket);
		}
		return $received_text;
	}
	
	private function check_client_disconnected($changed_socket){
		$buf = @socket_read($changed_socket, 1024, PHP_NORMAL_READ);
		if ($buf === false || $buf === 0) { //Verifica se o cliente se desconectou
			//Remove o cliente do array de clientes
			$found_socket = array_search($changed_socket, $this->_clients);
			//socket_getpeername($changed_socket, $ip);
			unset($this->_clients[$found_socket]);
			if($this->_debug) echo "Cliente desconectado: "."\n";
            if($this->_debug2) $this->printDebug("Cliente desconectado: ");
			return $changed_socket;
		}
	}
	
	public function send_message($msg){
		$msg = $this->mask($msg);
		foreach($this->_clients as $changed_socket)
		{
			@socket_write($changed_socket,$msg,strlen($msg));
		}
		if($this->_debug) echo "Mensagem enviada para broadcast: ".$msg."\n";
        if($this->_debug2) $this->printDebug("Mensagem enviada para broadcast: ".$msg);
		return true;
	}
	
	//Unmask incoming framed message
	public function unmask($text) {
		$length = ord($text[1]) & 127;
		if($length == 126) {
			$masks = substr($text, 4, 4);
			$data = substr($text, 8);
		}
		elseif($length == 127) {
			$masks = substr($text, 10, 4);
			$data = substr($text, 14);
		}
		else {
			$masks = substr($text, 2, 4);
			$data = substr($text, 6);
		}
		$text = "";
		for ($i = 0; $i < strlen($data); ++$i) {
			$text .= $data[$i] ^ $masks[$i%4];
		}
		return $text;
	}

	//Faz o encode da mensagem para o envio.
	public function mask($text)
	{
		$b1 = 0x80 | (0x1 & 0x0f);
		$length = strlen($text);
		
		if($length <= 125)
			$header = pack('CC', $b1, $length);
		elseif($length > 125 && $length < 65536)
			$header = pack('CCn', $b1, 126, $length);
		elseif($length >= 65536)
			$header = pack('CCNN', $b1, 127, $length);
		return $header.$text;
	}
	
	//handshake com o novo cliente.
	private function perform_handshaking($receved_header,$client_conn, $host, $port)
	{
		$headers = array();
		$lines = preg_split("/\r\n/", $receved_header);
		foreach($lines as $line)
		{
			$line = chop($line);
			if(preg_match('/\A(\S+): (.*)\z/', $line, $matches))
			{
				$headers[$matches[1]] = $matches[2];
			}
		}
		if(isset($headers['Sec-WebSocket-Key'])) $secKey = $headers['Sec-WebSocket-Key'];
        else $secKey = "";
		$secAccept = base64_encode(pack('H*', sha1($secKey . '258EAFA5-E914-47DA-95CA-C5AB0DC85B11')));
		//hand shaking header
		$upgrade  = "HTTP/1.1 101 Web Socket Protocol Handshake\r\n" .
		"Upgrade: websocket\r\n" .
		"Connection: Upgrade\r\n" .
		"WebSocket-Origin: $host\r\n" .
		"WebSocket-Location: ws://".$this->_host.":".$this->_port."/vdt/websockets/ws.modu.php\r\n".
		"Sec-WebSocket-Accept:$secAccept\r\n\r\n";
		@socket_write($client_conn,$upgrade,strlen($upgrade));
	}
	
	public function close(){
		// Fecha a escuta do socket
		if(isset($sock)) socket_close($sock);
	}
	
	public function __destruct(){
		$this->close();
	}

    public function getClients(){
        return $this->_clients;
    }

    private function printDebug($log){
        $dateLog = date("Y-m-d H:i:s");
        $out = file_get_contents("/tmp/WebSocket.log");
        $out = $dateLog." - ".$log."\n".$out;
        
        file_put_contents("/tmp/WebSocket.log", $out);
    }
}
?>
