<?php
/**************************************************************
  Classe Banco
  Eh a classe principal do banco de dados.
 *************************************************************/
class BdVdtMysql {
  var $BdBanco;
  var $BdNome;
  var $BdSenha;
  var $Conexao;
  var $Base;
  
  function BdVdtMysql() {
    $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
    //include($DirRaiz.'config.php');
    include($DirRaiz."configuracoes.php");
    $this->BdLocal      = $ip_mysql_vdt;
    $this->BdPorta      = $porta_mysql_vdt;
    $this->BdBanco      = $banco_mysql_vdt;
    $this->BdNome       = $usuario_mysql_vdt;
    $this->BdSenha      = $senha_mysql_vdt;
    $this->Base         = 'Mysql'; // Pode ser Mysql ou Postgres
	$this->Conexao      = $this->conecta_banco();
    return;
   }
   
   //---------------------------------------------------
  // Funcao conecta_banco
  // Cria a conexao com o banco de dados.
  //---------------------------------------------------
  function conecta_banco() {
    if ($this->Base=='Postgres'){
      $Conecta = @pg_pconnect('host='.$this->BdLocal.' port='.$this->BdPorta.' dbname='.$this->BdBanco.' user='.$this->BdNome.' password='.$this->BdSenha);
      if (!$Conecta) $Retorno = false;
      else $Retorno = $Conecta;
    }
    elseif ($this->Base=='Mysql'){
      $Conecta = @mysql_pconnect($this->BdLocal, $this->BdNome, $this->BdSenha) or die (mysql_error()."Erro: ");
      if (!$Conecta) $Retorno = false;
      else {
        $Conecta = @mysql_select_db($this->BdBanco);
        if (!$Conecta) $Retorno = false;
        else $Retorno = $Conecta;
      }
    }
    else $Retorno = false;
    return $Retorno;
  }


  //---------------------------------------------------
  // Funcao executa_query_com_saida
  // Executa uma query que tenha como retorno linhas e
  // colunas (ex. SELECT * FROM ZZZ).
  //---------------------------------------------------
  function executa_query_com_saida($Pesquisa) {
    $Retorno = false;
    $Conecta = $this->conecta_banco();
    if ($Conecta){
      if ($this->Base=='Postgres'){
        $Resultado = @pg_query($Conecta, $Pesquisa);
//        if ($Resultado) $Retorno = pg_fetch_array($Resultado);
        if ($Resultado) {
            $Retorno = array();
            for ($x=0; $x<@pg_num_rows($Resultado); $x++){
              $Retorno[$x] = @pg_fetch_array($Resultado,$x,PGSQL_ASSOC);
            }
        }
      }
      elseif ($this->Base=='Mysql'){
        $Resultado = @mysql_query($Pesquisa);
        if ($Resultado) {
            $Retorno = array();
            for ($x=0; $x<@mysql_num_rows($Resultado); $x++){
              $Retorno[$x] = @mysql_fetch_array($Resultado, MYSQL_ASSOC);
            }
        }
      }
    }
	//$Retorno = $Pesquisa;
    return $Retorno;
  }


  //---------------------------------------------------
  // Funcao executa_query_sem_saida
  // Executa uma query que NAO TEM retorno linhas e
  // colunas (ex. UPDATE, INSERT).
  //---------------------------------------------------
  function executa_query_sem_saida($Pesquisa) {
    $Retorno = false;
    $Conecta = $this->conecta_banco();
    if ($Conecta){
      if ($this->Base=='Postgres'){
        $Resultado = @pg_query($Conecta, $Pesquisa);
        if ($Resultado) $Retorno = true;
      }
      elseif ($this->Base=='Mysql'){
        $Resultado = @mysql_query($Pesquisa);
        if ($Resultado) $Retorno = true;
      }
    }
    return $Retorno;
  }


  //---------------------------------------------------
  // Funcao limpa_query
  // Limpa a query de codigos maliciosos.
  //---------------------------------------------------
  function limpa_query($Texto) {
    $Texto = addslashes($Texto);
    $Texto = strip_tags($Texto);
    $Texto = str_replace(";",  ",", $Texto);
    $Texto = str_replace("'",  " ", $Texto);
    $Texto = str_replace("--", "-", $Texto);
    $Texto = str_replace("(",  ",", $Texto);
    $Texto = str_replace(")",  ",", $Texto);
    $Texto = str_replace("#",  "-", $Texto);
    $Texto = str_replace("=",  "-", $Texto);
    $Texto = str_replace("||", " ", $Texto);
    return $Texto;
  }


  //---------------------------------------------------
  // Funcao arruma_nome
  // Remove da variavel de caracteres invalidos
  // Soh sao permitidas maiusculas de A-Z, . e _
  //---------------------------------------------------
  function arruma_nome($Texto) {
    $Texto = strtoupper(trim($Texto));
    $Max   = strlen($Texto);
    $NText = "";
    $Antes = "";
    // Troca caracteres nao A-Z por _
    for ($x=0; $x<$Max; $x++) {
      if ((ord($Texto[$x])>=65) && (ord($Texto[$x])<=90)) $Letra = $Texto[$x];
      elseif (($Texto[$x]=='.') || ($Texto[$x]=='_'))         $Letra = $Texto[$x];
      else $Letra = "_";
      if (($Letra==$Antes) && ($Letra=="_")) $Letra="";
      $Ntext .= $Letra;
      if ($Letra!="") $Antes = $Letra;
    }
    // Nao deixa comecar com _
    $Fim = false;
    while (!$Fim){
      if ($Ntext[0]=="_") $Ntext = substr($Ntext,1);
      else $Fim = true;
    }
    // Nao deixa terminar com _
    $Fim = false;
    while (!$Fim){
      $Max = strlen($Ntext)-1;
      if ($Ntext[$Max]=="_") $Ntext = substr($Ntext,0,$Max-1);
      else $Fim = true;
    }
    return $Ntext;
  }


  //---------------------------------------------------
  // Funcao arruma_nome_com_numero
  // Remove da variavel de caracteres invalidos
  // Soh sao permitidas maiusculas de A-Z, numeros, _ e .
  //---------------------------------------------------
  function arruma_nome_com_numero($Texto) {
    $Texto = strtoupper(trim($Texto));
    $Max   = strlen($Texto);
    $NText = "";
    $Antes = "";
    // Troca caracteres nao A-Z por _
    for ($x=0; $x<$Max; $x++) {
      if ((ord($Texto[$x])>=48) && (ord($Texto[$x])<=57))     $Letra = $Texto[$x];
      elseif ((ord($Texto[$x])>=65) && (ord($Texto[$x])<=90)) $Letra = $Texto[$x];
      elseif (($Texto[$x]=='.') || ($Texto[$x]=='_'))         $Letra = $Texto[$x];
      else $Letra = "_";
      if (($Letra==$Antes) && ($Letra=="_")) $Letra="";
      $Ntext .= $Letra;
      if ($Letra!="") $Antes = $Letra;
    }
    // Nao deixa comecar com _
    $Fim = false;
    while (!$Fim){
      if ($Ntext[0]=="_") $Ntext = substr($Ntext,1);
      else $Fim = true;
    }
    // Nao deixa terminar com _
    $Fim = false;
    while (!$Fim){
      $Max = strlen($Ntext)-1;
      if ($Ntext[$Max]=="_") $Ntext = substr($Ntext,0,$Max-1);
      else $Fim = true;
    }
    return $Ntext;
  }


  //---------------------------------------------------
  // Funcao arruma_data
  // A entrada eh D M A Numeanos(qtde de numeros do ano)
  // A saida eh DD/MM/AA
  //---------------------------------------------------
  function arruma_data($D,$M,$A,$Numeanos='2') {
    $D = intval($D);
    $M = intval($M);
    $A = intval($A);
    $N = "%0".$Numeanos."d";
    $Saida = sprintf('%02d',$D)."/".sprintf('%02d',$M)."/".sprintf($N,$A);
    $Saida = $this->testa_data($Saida);
    return $Saida;
  }



  //---------------------------------------------------
  // Funcao testa_data
  // Verifica se o dado eh realmente uma data.
  // A entrada pode ser DD/MM/AA ou DD/MM/AAAA.
  //---------------------------------------------------
  function testa_data($Texto){
    $Texto = trim($Texto);
    $Sep   = "/";
    $Data  = explode($Sep, $Texto);
     // Verifica se a data estah incompleta - falta dia, mes ou ano
    if (count($Data)!=3) $Saida = "3";
     // Verifica se a data eh valida
    else {
      $Data[0] = intval($Data[0]);
      $Data[1] = intval($Data[1]);
      $Data[2] = intval($Data[2]);
      if (!checkdate($Data[1], $Data[0], $Data[2])) $Saida = false;
      else $Saida = $Texto;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao numero_brasil2americano
  // A entrada eh 99.999,99
  // A saida eh 99999.99
  //---------------------------------------------------
  function numero_brasil2americano($Numero) {
    $Numero = trim($Numero);
    $Numero = str_replace(" ",  "", $Numero);
    $Numero = str_replace(".",  "", $Numero);
    $Numero = str_replace(",", ".", $Numero);
    return $Numero;
  }


  //---------------------------------------------------
  // Funcao testa_email
  // Verifica se o e-mail digitado eh valido ou nao
  //---------------------------------------------------
  function testa_email($Email) {
    $Saida = true;
    if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $Email)) $Saida = false;
    else {
      $Email_array = explode("@", $Email);
      $Local_array = explode(".", $Email_array[0]);
      for ($i = 0; $i < sizeof($Local_array); $i++) {
       if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $Local_array[$i])) $Saida = false;
      }
      if (!ereg("^\[?[0-9\.]+\]?$", $Email_array[1])) {
        $Domain_array = explode(".", $Email_array[1]);
        if (sizeof($Domain_array) < 2) $Saida = false;
        for ($i = 0; $i < sizeof($Domain_array); $i++) {
          if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $Domain_array[$i])) $Saida = false;
        }
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao testa_permissao
  // Verifica se a variavel com a permissao eh valida
  //---------------------------------------------------
  function testa_permissao($Permissao) {
    $Permissao = $Permissao[0];
    if (($Permissao==0) || ($Permissao==1)) $Saida = true;
    else $Saida = false;
    return $Saida;
  }


}
?>
