<?php
/**************************************************************
 * Nome:    Feriado
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2009-04-11 (V1.0.1)
 * Descr.:  Cria classe de feriados
 *************************************************************/


/**************************************************************
  Classe Holyday
 *************************************************************/
class Holyday {
  var $Bd;
  var $TabelaF;
  var $Hoje;
  var $Download;


  //---------------------------------------------------
  // Construtor da classe.
  //---------------------------------------------------
  function Holyday() {
    $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
    include($DirRaiz.'config.php');
    include_once($DirRaiz.$DirClass.'bd.class.php');
    $this->Bd      = new Banco();
    $this->TabelaF = $Tb_Feria;
    $this->Hoje    = date("d/m/y");
  }


  //---------------------------------------------------
  // Funcao lista_feriado
  //---------------------------------------------------
  function lista_feriado($Ordem = 'DESC') {
    $Pes = "SELECT id, extract(day from dia) as dd, extract(month from dia) as mm, extract(year from dia) as yy, descricao,diainteiro, extract(hour from horainicio) as hhi, extract(minute from horainicio) as hmi, extract(hour from horafim) as hhf, extract(minute from horafim) as hmf FROM ".$this->TabelaF." ORDER BY dia ".$Ordem;
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else {
      for ($x=0; $x<count($Res); $x++) {
        $Res[$x]['dia']        = sprintf("%02d",$Res[$x]['dd'])."/".sprintf("%02d",$Res[$x]['mm'])."/".sprintf("%04d",$Res[$x]['yy']);
        $Res[$x]['horainicio'] = sprintf("%02d",$Res[$x]['hhi']).":".sprintf("%02d",$Res[$x]['hmi']);
        $Res[$x]['horafim']    = sprintf("%02d",$Res[$x]['hhf']).":".sprintf("%02d",$Res[$x]['hmf']);
      }
      $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao apaga_feriados
  //---------------------------------------------------
  function apaga_feriados($Identif) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    $Saida = true;
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Apa = "DELETE FROM ".$this->TabelaF." WHERE id='".$Identif."'";
      $Res = $this->Bd->executa_query_sem_saida($Apa);
      $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_feriados
  //---------------------------------------------------
  function altera_feriados($Identif,$Ddia,$Desc,$Expe,$Hini,$Hfim) {
    $Identif = trim($Identif);
    if ($Expe=='true') {
      $Hini = "NULL"; $Hfim = "NULL";
    } else {
      $Hini = '\"'.$Hini.'\"'; $Hfim = '\"'.$Hfim.'\"';
    }
    $Ddia = $Aux[2].'/'.$Aux[1].'/'.$Aux[0];
    $Troca   = "UPDATE ".$this->TabelaF." SET dia='".$Ddia."', descricao='".$Desc."', diainteiro=".$Expe.", horainicio='".$Hini."', horafim='".$Hfim."' WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_feriados
  //---------------------------------------------------
  function insere_feriados($Ddia,$Desc,$Expe,$Hini,$Hfim) {
    $Pes  = "SELECT id FROM ".$this->TabelaF." WHERE dia='".$Ddia."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Aux = explode("/", $Ddia);
      $Ddia = $Aux[2].'/'.$Aux[1].'/'.$Aux[0];
      if ($Expe=='false') $Insere = "INSERT INTO ".$this->TabelaF." (dia,descricao,diainteiro,horainicio,horafim ) VALUES ('".$Ddia."','".$Desc."',".$Expe.",'".$Hini."','".$Hfim."')";
      else  $Insere = "INSERT INTO ".$this->TabelaF." (dia,descricao,diainteiro) VALUES ('".$Ddia."','".$Desc."',".$Expe.")";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      $Saida  = $Res;
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_feriado_por_data
  // Entrada aaaa-mm-dd
  //---------------------------------------------------
  function lista_feriado_por_data($Dia) {
    $Dia = substr($Dia,0,10);
    if ((substr($Dia,4,1)!='-') || (substr($Dia,7,1)!='-')) return false;
    $Aux = explode("-", $Dia);
    $Pes = "SELECT id, descricao, diainteiro, EXTRACT(hour FROM horainicio) as hhi, EXTRACT(minute FROM horainicio) as hmi, EXTRACT(hour FROM horafim) as hhf, EXTRACT(minute FROM horafim) as hmf FROM ".$this->TabelaF." WHERE EXTRACT(day FROM dia) = ".$Aux[2]." AND EXTRACT(month FROM dia) = ".$Aux[1]." AND EXTRACT(year FROM dia) = ".$Aux[0];
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else {
      for ($x=0; $x<count($Res); $x++) {
        $Res[$x]['dia']        = sprintf("%02d",$Res[$x]['dd'])."/".sprintf("%02d",$Res[$x]['mm'])."/".sprintf("%04d",$Res[$x]['yy']);
        $Res[$x]['horainicio'] = sprintf("%02d",$Res[$x]['hhi']).":".sprintf("%02d",$Res[$x]['hmi']);
        $Res[$x]['horafim']    = sprintf("%02d",$Res[$x]['hhf']).":".sprintf("%02d",$Res[$x]['hmf']);
      }
      $Saida = $Res;
    }
    return $Saida;
  }

}
?>
