<?php
/************************************************************
Autor:Leandro N. de Araujo
Data: 2010-12-30
Descricao: Classe responsavel por habilitar ou no o realtime
		   no sistema e configurar os arquivos.conf do 
		   Asterisk no caso de no habilitado o realtime.
************************************************************/

class Realtime
{
	var $Bd;
	var $Socket;
	var $TabelaRlt;
	var $TabelaR;
	var $ArquivoCriarSchema;
	var $ArquivoCriarTables;
	var $ArquivoCriarFunction;
	var $ArquivoCriarTrigger;
    var $DropSQL;
	var $sip_conf;
	var $extconfig_conf;

/**************************************************
Construtor Realtime
Descricao: Carrega os arquivos config.php,
		   armazena o endereco dos scripts sql 
		   do diretorio script_sql da pasta vdt
		   e o endereco de onde serao criados os
		   arquivos.conf do Asterisk.
**************************************************/
	function Realtime()
	{
		$DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
    	include($DirRaiz.'config.php');
    	include_once($DirRaiz.$DirClass.'bd.class.php');
		include_once($DirRaiz.$DirClass.'soquete.class.php');
		$this->Bd = new Banco();
		$this->Socket = new Soquetes();
		$this->TabelaRlt = $Tb_Realtime;
		$this->TabelaR = $Tb_VRama;
		$this->ArquivoCriarSchema = $DirRaiz.'script_sql/create_schema.sql';
		$this->ArquivoCriarTables = $DirRaiz.'script_sql/create_tables.sql';
		$this->ArquivoCriarFunction = $DirRaiz.'script_sql/create_function.sql';
		$this->ArquivoCriarTrigger = $DirRaiz.'script_sql/create_trigger.sql';
		$this->DropSQL = $DirRaiz.'script_sql/drop_postgres.sql';
		$this->sip_conf = '/usr/src/sip.conf';
		$this->extconfig_conf = '/usr/src/extconfig.conf';
    }

/*************************************************
Funcao: status_radiobutton
Descricao: Esta funcao busca o status do relatime 
	       na tabela tb_realtime e retorna o valor 
		   para setar o radio button na tela 
		   admnrealtime.tela.php.
*************************************************/
	function status_radiobutton()
	{
		$Saida = false;
		$Pes = "SELECT * FROM ".$this->TabelaRlt;
		$Res = $this->Bd->executa_query_com_saida($Pes); 
		if($Res) $Saida = $Res;
		else $Saida = false;
		return $Saida;
	}

/*****************************************************
Funcao: cadastra_opcoes_realtime
Descricao: Responsavel por criar o schema,
		   tabelas, function e triggers do
		   PostgreSQL para funcionamento do realtime.
		   Se o realtime for desativado esta funcao
		   cria armazena os dados num schema historico 
		   e cria os arquivos.conf do Asterisk.
*****************************************************/	
	function cadastra_opcoes_realtime($Dados)
	{
	    if($Dados == 1) {
			$Saida = false;
			$fp = fopen($this->ArquivoCriarSchema,"r");
			while(!feof($fp)) {
				$Schema .= fgetc($fp);
			}
			fclose($fp);
			$Pes1 = $Schema;
			$Res1 = $this->Bd->executa_query_sem_saida($Pes1);
			if(!$Res1) $Saida = false;
			else {
				$fp = fopen($this->ArquivoCriarTables,"r");
				while(!feof($fp)) {
					$Tables .= fgetc($fp);
				}
				fclose($fp);
				$Pes2 = $Tables;
				$Res2 =  $this->Bd->executa_query_sem_saida($Pes2);
				if(!$Res2) $Saida = false;
				else {
					$fp = fopen($this->ArquivoCriarFunction,"r");
					while(!feof($fp)) {
						$Function .= fgetc($fp);
					}
					fclose($fp);
					$Pes3 = $Function;
					$Res3 = $this->Bd->executa_query_sem_saida($Pes3);
					if(!Res3) $Saida = false;
					else {
						$fp = fopen($this->ArquivoCriarTrigger,"r");
						while(!feof($fp)) {
							$Trigger .= fgetc($fp);
						}
						$Pes4 = $Trigger;
						$Res4 = $this->Bd->executa_query_sem_saida($Pes4);
						if(!$Res4) $Saida = false;
						else {
							$Pes5 = "UPDATE ".$this->TabelaRlt." SET status = '1' WHERE status = '0'";
							$Res5 = $this->Bd->executa_query_sem_saida($Pes5);
							
							if(file_exists($this->sip_conf)) {
								if(file_exists($this->sip_conf.".bak")) {
								    unlink($this->sip_conf.".bak");
									copy($this->sip_conf,$this->sip_conf.".bak");
									unlink($this->sip_conf);
								}
								else {
									copy($this->sip_conf,$this->sip_conf.".bak");
									unlink($this->sip_conf);
								}
							}
							
							$this->cria_extconfig_conf();
							$Comando = "Action: Command\r\nCommand: reload\r\n\r\n";
							$this->Socket->envia_socket($Comando);
						}
					}  
				}
			}
		}
		else {
			$Saida = false;
			$fp = fopen($this->DropSQL,"r");
			while(!feof($fp)) {
				$Drop .= fgetc($fp);
			}
			fclose($fp);
			$Pes1 = $Drop;
			$Res1 = $this->Bd->executa_query_sem_saida($Pes1);
			if(!$Res1) $Saida = false;
			else {
				$Pes2 = "UPDATE ".$this->TabelaRlt." SET status = '0' WHERE status = '1'";
				$Res2 = $this->Bd->executa_query_sem_saida($Pes2);
				$this->cria_sip_conf();
				$this->cria_extconfig_conf();
				$Comando = "Action: Command\r\nCommand: reload\r\n\r\n";
				$this->Socket->envia_socket($Comando);
			}
		}
		return $Saida;
	}

/*****************************************************
Funcao: cria_sip_conf
Descricao: Responsavel por criar o sip.conf.
*****************************************************/	
	function cria_sip_conf()
	{
		$Resultado = false;
		$Pes = "SELECT * FROM ".$this->TabelaR." ORDER BY ramal";
		$Res = $this->Bd->executa_query_com_saida($Pes); 
		if(!Res) $Resultado = false;
		else {
		   
			$fp = fopen($this->sip_conf,"w+");
			$Saida = "[general]\n\n";
			$Saida .= "port=5060\n";
			$Saida .= "bindaddr=0.0.0.0\n\n\n";
			
			$Saida .= "context=default\n";
			$Saida .= "disallow=all\n";
			$Saida .= "allow=alaw\n\n\n";
			$Saida .= "allowguest=no\n";
			$Saida .= "notifyringing=yes\n";
			$Saida .= "notifyhold=yes\n";
			$Saida .= "allowsubscribe=yes\n\n\n";
			$Saida .= "maxespirey=1800\n";
			$Saida .= "defaultexpirey=120\n\n\n";
			
			for($i = 0; $i < count($Res); $i++) {
				
				$Ramal = $this->retira_espaco($Res[$i]["ramal"]);
				$Tipo = $this->retira_espaco($Res[$i]["tipo"]);
				$DtmfMode = $this->retira_espaco($Res[$i]["dtmfmode"]);
				$CallLimit = $this->retira_espaco($Res[$i]["call_limit"]);
				$Contexto = $this->retira_espaco($Res[$i]["contexto"]);
				
				if($DtmfMode == "") $DtmfMode = "rfc2833";
				
				if($Ramal != "") {
					$Saida .= '['.$Ramal.']'."\n";
					$Saida .= "type=".$Tipo."\n";
					$Saida .= 'secret='.$Ramal."\n";
					$Saida .= "context=".$Contexto."\n";
					$Saida .= "dtmfmode=".$DtmfMode."\n";
					$Saida .= "host=dynamic\n";
					$Saida .= "call-limit=".$CallLimit."\n";
					$Saida .= "canreinvite=no\n\n";
				}
			}
			fwrite($fp,$Saida);
			fclose($fp);
		}
	}

/****************************************************
Funcao: cria_extconfig_conf
Descricao: Funcao responsavel por criar o 
		   extconfig.conf . Este arquivo habilita 
		   o realtime no asterisk.
****************************************************/	
	function cria_extconfig_conf()
	{
		//$Resultado = false;
		$Pes = "SELECT status FROM ".$this->TabelaRlt;
		$Res = $this->Bd->executa_query_com_saida($Pes);
		if($Res) {
			if($Res[0]["status"] == 1) {
				$fp = fopen($this->extconfig_conf, "w+");
				$Saida = '';
				$Saida .= "[settings]\n\n\n";
				$Saida .= "sippeers => odbc,vdt,asterisk_realtime.sip\n";
				fwrite($fp,$Saida);
				fclose($fp);
			}
			else {
				$fp = fopen($this->extconfig_conf, "w+");
				$Saida = '';
				$Saida .= "[settings]\n\n\n";
				$Saida .= ';sippeers => odbc,vdt,asterisk_realtime.sip'."\n";
				fwrite($fp,$Saida);
				fclose($fp);
			}
		}
	}

/*******************************************************
Funcao: retira_espaco
Descricao: Esta funcao retira os espacos do texto
		   retornando uma unica string.
********************************************************/
	function retira_espaco($Dados)
	{
		$Texto = trim($Dados);
		return $Texto;
	}
}
?>