<?php
/**************************************************************
 * Nome:    Soquete
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-01-30 (V1.0.1)
 * Descr.:  Cria classe para socket
 *************************************************************/


/**************************************************************
  Classe Soquetes
 *************************************************************/
class Soquetes {
  var $PHost;
  var $PPort;


  //---------------------------------------------------
  // Construtor da classe
  //---------------------------------------------------
  function Soquetes() {
    ($_SERVER['DOCUMENT_ROOT'] != "") ? $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/' : $DirRaiz = '/usr/local/apache2/htdocs/vdt/';
    include($DirRaiz.'configuracoes.php');
    $this->PHost = $host_astman_asterisk;
    $this->PPort = $porta_astman_asterisk;
  }


  //---------------------------------------------------
  // Funcao abre_socket
  //---------------------------------------------------
  function abre_socket($ip_astman) {
    if(empty($ip_astman)) $Soquete = pfsockopen($this->PHost, $this->PPort, $errnum, $errstr);
    else $Soquete = pfsockopen($ip_astman, $this->PPort, $errnum, $errstr);

    if (!$Soquete) return false;
    stream_set_timeout($Soquete,1);
    $this->le_socket($Soquete);
    return $Soquete;
  }


  //---------------------------------------------------
  // Funcao le_socket
  // Funciona quando outputformat=xml no astmanproxy.conf
  //---------------------------------------------------
  function le_socket($Soquete) {
    $Saida = array();
    $x = 0;
    $Linha = fgets($Soquete);
    while (!($Linha===false)) {
      $Linha = trim($Linha);
      if (!(($Linha == "<AsteriskManagerOutput>") ||($Linha == "</AsteriskManagerOutput>"))) {
        $Linha = preg_replace("/</",     "",    $Linha);
        $Linha = preg_replace("/>/",     "",    $Linha);
        $Linha = preg_replace("/\"/",    "",    $Linha);
        $Linha = preg_replace("/\/$/",   "",    $Linha);
        $Linha = preg_replace("/^\//",   "",    $Linha);
        $Linha = preg_replace("/&lt;/",  "<",   $Linha);
        $Linha = preg_replace("/&gt;/",  ">",   $Linha);
        $Linha = preg_replace("/&quot;/", "\"", $Linha);
        $Aux = explode(" Value=", $Linha);
        if (($Aux[0])=="UnparsedText") $Saida[$x] = $Aux[1];
        else $Saida[$x] = $Aux[0] . ": " . $Aux[1];
        $x++;
      }
      $Linha = fgets($Soquete);
    }
    !empty($Linha);
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao le_socket_standard
  // Funciona quando outputformat=standard no astmanproxy.conf
  //---------------------------------------------------
  function le_socket_standard($Soquete) {
    $Saida = array();
    $x = 0;
    $Linha = fgets($Soquete);
    while (!($Linha===false)) {
      $Saida[$x] = $Linha;
      $x++;
      $Linha = fgets($Soquete);
    }
    !empty($Linha);
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao le_socket_csv
  // Funciona quando outputformat=csv no astmanproxy.conf
  //---------------------------------------------------
  function le_socket_csv($Soquete) {
    $Saida = array();
    $Linha = fgetcsv($Soquete, "" , ",", '"');
    while (!($Linha===false)) {
      $Saida = array_merge($Saida,$Linha);
      $Linha = fgetcsv($Soquete, "" , ",", '"');
    }
    !empty($Linha);
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao envia_socket
  //---------------------------------------------------
  function envia_socket($Comando) {
    $NovoComando  = str_replace("\r\n\r\n", "", $Comando);
    $NovoComando .= "\r\n\r\n";
    $Soquete      = $this->abre_socket();
    if (!$Soquete) return false;
    fputs($Soquete,$NovoComando);
    $Saida        = $this->le_socket($Soquete);
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao envia_socket_sem_retorno
  //---------------------------------------------------
  function envia_socket_sem_retorno($Comando, $ip_astman) {
    $NovoComando  = str_replace("\r\n\r\n", "", $Comando);
    $NovoComando .= "\r\n\r\n";
    
    if(empty($ip_astman)) $Soquete = $this->abre_socket();
    else $Soquete = $this->abre_socket($ip_astman);

    if (!$Soquete) return false;
    fputs($Soquete,$NovoComando);
    fclose($Soquete);
//    $info = stream_get_meta_data($Soquete);
//    if ($info['timed_out']) return false;
    return true;
  }
}
?>
