<?php
/**************************************************************
* Nome:    Syonet
* Autor:   Renato N. Lourenço
* Data:	  2014-12-02 (V1.0.1)
* Descr.:  Cria classe de Syonet
*************************************************************/

class Syonet {
    var $bd;
    var $log;
    var $hostVdt;
    var $hostBd;
    var $portaBd;
    var $usernameBd;
    var $passwordBd;
    var $bancoBd;
    var $nusoap;
    var $mail;
    var $configSyonet;
    var $configEmail;

    /**
     * Classe Syonet responsável por toda a comunicação com o web service no Syonet.
     */
    function Syonet() {
        include_once('../libs/nusoap/nusoap.php');
        require_once('../libs/phpmailer/PHPMailerAutoload.php');

        ($_SERVER['DOCUMENT_ROOT'] != "") ? $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/' : $DirRaiz = '/usr/local/apache2/htdocs/vdt/';
        include($DirRaiz."configuracoes.php");
    	
    	$this->log = Logger::getLogger('Pami.ClientImpl'); //Inicia o log com nome da aplicação

        $this->hostVdt = $host_vdt_syonet; //Ip do servidor do vdt
        $this->hostBd = $ip_postgres_syonet; //Ip do servidor do banco de dados
        $this->portaBd = $porta_postgres_syonet; //Porta para conexão no banco de dados
        $this->usernameBd = $usuario_postgres_syonet; //Usuário para conexão no banco de dados
        $this->passwordBd = $senha_postgres_syonet; //Senha para conexão no banco de dados
        $this->bancoBd = $banco_postgres_syonet; //Nome da base

        $sql = "SELECT * FROM vm50_config_syonet";
        $this->configSyonet = $this->executa_query_com_saida($sql);
        if(count($this->configSyonet) > 0) $this->configSyonet = $this->configSyonet[0];
        else {
                $this->configSyonet["ip_crm"] = "";
        }

        $sql = "SELECT * FROM vm50_conf_email LIMIT 1";
        $this->configEmail = $this->executa_query_com_saida($sql);
        if(count($this->configEmail) > 0) $this->configEmail = $this->configEmail[0];

        $this->mail = new PHPMailer;

        $this->nusoap = new nusoap_client("http://".$this->configSyonet["ip_crm"].":8080/CollaborativeWS-CollaborativeWS/CollaborativeEventoService?wsdl", false, '', '', '', '');
        $err = $this->nusoap->getError();
        if ($err) {
            echo "Erro na conexão com o webservice syonet: " . $err . "\n";
            echo "Debug: " . htmlspecialchars($client->getDebug(), ENT_QUOTES) . "\n";
            exit();
        }
        $this->nusoap->setUseCurl('0');
    }

    function debugSyonet($msg){
        $this->log = Logger::getLogger('Pami.ClientImpl'); //Inicia o log com nome da aplicação
        $this->log->debug($msg);
    }

    /**
     * Função responsável por conectar no banco de dados a partir dos dados configurados no construtor.
     * @return Boolean
     */
    function conectar_banco(){
        $this->bd = @pg_pconnect('host='.$this->hostBd.' port='.$this->portaBd.' dbname='.$this->bancoBd.' user='.$this->usernameBd.' password='.$this->passwordBd);
        if(!$this->bd) return false;
        else return true;
    }

    /**
     * Executa o sql enviado por parametro e retorna o resultado
     * @param  String $sql
     * @return Array()
     */
    function executa_query_com_saida($sql){
        if(!$this->bd) $this->conectar_banco();
        $retorno = false;
        $resultado = @pg_query($this->bd, $sql);
        if ($resultado) {
            $retorno = array();
            for ($x=0; $x<@pg_num_rows($resultado); $x++){
                $retorno[$x] = @pg_fetch_array($resultado,$x,PGSQL_ASSOC);
            }
        }
        return $retorno;
    }


    /**
     * Função responsável por receber o nome de fila e a partir dai verificar as configurações do syonet para
     * informar ao web service quando uma mensagem caiu na caixa postal.
     * @param  String $fila
     * @return null
     */
    function informarCaixaPostal($fila, $numero, $gravacao, $data, $horario, $deixou_mensagem, $caixa_postal="") {
        $sql = "SELECT * FROM vm50_filas_syonet WHERE fila_crm LIKE '".$fila."'";
        $dadosFila = $this->executa_query_com_saida($sql);
        $dados = array();
        if(count($dadosFila) > 0){
            $dados["nome"] = 'CAIXA POSTA VDT';
            $dados["usuario"] = $this->configSyonet["usuario_crm"]; 
            $dados["senha"] = $this->configSyonet["senha_crm"]; 
            $dados["dominio"] =$this->configSyonet["dominio_crm"]; 
            $dados["grupoEvento"] = 'REVISAO'; 
            $dados["tipoEvento"] = 'OFICINA TELEFONE'; 
            $dados["idEmpresa"] = $dadosFila[0]["empresa_crm"]; //para as outras empresas enviar o codigo conforme já foi enviado
            $dados["assunto"] = 'CAIXA POSTA VDT';
            $dados["origem"] = 'CAIXA POSTAL VDT';
            $dados["dddResidencial"] = substr($numero, 0, 2); //substituir pelo ddd do telefone do cliente que ligou
            $dados["telefoneResidencial"] = substr($numero, 2); //substituir pelo telefone do cliente que ligou
            $dados["observacao"] = $data." ".$horario." Fila=".$fila; //pode enviar alguma outra informacao nesse campo
            $dados["callid"] = "http://".$this->hostVdt."/vdt".$gravacao; //substituir pelo callid da ligacao
            echo "\n\nEnviando dados: \n".print_r($dados, true);
            $this->debugSyonet("\n\nEnviando dados: \n".print_r($dados, true));
            $result = $this->nusoap->call("gerarEventoV2", $dados, 'http://evento.ws.action.syonet.com.br/', 'http://evento.ws.action.syonet.com.br/');
            
            if($dadosFila[0]["email_notifica"] != ""){
                if($deixou_mensagem) {
                    $anexo = str_replace(".WAV", ".wav49|b", $gravacao);
                    $mensagem = "Mensagem deixada pelo chamador <b>".$numero."</b> na caixa postal <b>".$caixa_postal."</b> dia <b>".$data."</b> as <b>".$horario."</b>.";
                    $this->enviar_email($dadosFila[0]["email_notifica"], "Caixa Postal VDT", $mensagem, $anexo);
                } else {
                    $mensagem = "Chamador <b>".$numero."</b> entrou na caixa postal <b>".$caixa_postal."</b> dia <b>".$data."</b> as <b>".$horario."</b> hrs e n&atilde;o deixou mensagem.";
                    $this->enviar_email($dadosFila[0]["email_notifica"], "Caixa Postal VDT", $mensagem);
                }
            }

            if ($this->nusoap->fault) {
                //echo 'Fault (Expect - The request contains an invalid SOAP body)'."\n";
                //echo print_r($result)."\n"; 
            } else {
                $err = $this->nusoap->getError();
                if ($err) {
                    echo 'Erro: ' . $err . "\n";
                    $this->debugSyonet("\nErro: ".$err);
                } else {
                    echo 'Resultado: '. print_r($result)."\n";
                    $this->debugSyonet("\nResultado: ".print_r($result, true));
                }
            }

            //echo 'Request: ' . htmlspecialchars($this->nusoap->request, ENT_QUOTES) . "\n";
            //echo 'Response: ' . htmlspecialchars($this->nusoap->response, ENT_QUOTES) . "\n";
        }
        return;
    }

    /**
     * Função responsável por receber o nome de fila e a partir dai verificar as configurações do syonet para
     * informar ao web service quando ocorre uma desistencia.
     * @param  String $fila
     * @return null
     */
    function informarDesistencia($fila, $numero, $gravacao, $data, $horario) {
        $sql = "SELECT * FROM vm50_filas_syonet WHERE fila_crm LIKE '".$fila."'";
        $dadosFila = $this->executa_query_com_saida($sql);
        $dados = array();
        if(count($dadosFila) > 0){
            $dados["nome"] = 'DESISTENCIA VDT';
            $dados["usuario"] = $this->configSyonet["usuario_crm"]; 
            $dados["senha"] = $this->configSyonet["senha_crm"]; 
            $dados["dominio"] =$this->configSyonet["dominio_crm"]; 
            $dados["grupoEvento"] = 'REVISAO'; 
            $dados["tipoEvento"] = 'OFICINA TELEFONE'; 
            $dados["idEmpresa"] = $dadosFila[0]["empresa_crm"]; //para as outras empresas enviar o codigo conforme já foi enviado
            $dados["assunto"] = 'DESISTENCIA VDT';
            $dados["origem"] = 'DESISTENCIA VDT';
            $dados["dddResidencial"] = substr($numero, 0, 2); //substituir pelo ddd do telefone do cliente que ligou
            $dados["telefoneResidencial"] = substr($numero, 2); //substituir pelo telefone do cliente que ligou
            $dados["observacao"] = $data." ".$horario." Fila=".$fila; //pode enviar alguma outra informacao nesse campo
            $dados["callid"] = ""; //substituir pelo callid da ligacao
            echo "Enviando dados: \n".print_r($dados, true);
            $this->debugSyonet("\n\nEnviando dados: \n".print_r($dados, true));
            $result = $this->nusoap->call("gerarEventoV2", $dados, 'http://evento.ws.action.syonet.com.br/', 'http://evento.ws.action.syonet.com.br/');
            
            if($dadosFila[0]["email_notifica"] != ""){
                $mensagem = "Desist&ecirc;ncia do chamador <b>".$numero."</b> dia <b>".$data."</b> as <b>".$horario."</b> hrs.";
                $this->enviar_email($dadosFila[0]["email_notifica"], "Desistência de ".$numero, $mensagem);
            }

            if ($this->nusoap->fault) {
                //echo 'Fault (Expect - The request contains an invalid SOAP body)'."\n";
                //echo print_r($result)."\n"; 
            } else {
                $err = $this->nusoap->getError();
                if ($err) {
                    echo 'Erro: ' . $err . "\n";
                    $this->debugSyonet("\nErro: ".$err);
                } else {
                    echo 'Resultado: '. print_r($result)."\n";
                    $this->debugSyonet("\nResultado: ".print_r($result, true));
                }
            }
        }

        //echo 'Request: ' . htmlspecialchars($this->nusoap->request, ENT_QUOTES) . "\n";
        //echo 'Response: ' . htmlspecialchars($this->nusoap->response, ENT_QUOTES) . "\n";
        return;
    }

    function enviar_email($para, $assunto, $mensagem, $anexo=""){
        $this->mail->isSMTP();                                  // Set mailer to use SMTP
        $this->mail->Host = $this->configEmail["smtp"];         // Specify main and backup SMTP servers
        $this->mail->SMTPAuth = true;                           // Enable SMTP authentication
        $this->mail->Username = $this->configEmail["email"];    // SMTP username
        $this->mail->Password = $this->configEmail["senha"];    // SMTP password
        $this->mail->SMTPSecure = 'tls';                        // Enable TLS encryption, `ssl` also accepted
        $this->mail->Port = $this->configEmail["porta_smtp"];   // TCP port to connect to

        $this->mail->From = $this->configEmail["email"];
        $this->mail->FromName = '..::Vdt::..';
        $this->mail->addAddress($para);                         // Add a recipient
        $this->mail->addReplyTo($this->configEmail["email"], '..::Vdt::..');

        $this->mail->isHTML(true);                              // Set email format to HTML

        $this->mail->Subject = '=?UTF-8?B?'.base64_encode($assunto).'?=';
        $this->mail->Body    = $mensagem;
        if($anexo!="") {
            $this->mail->addAttachment($anexo);                 // Optional name
            echo "Anexo: ".$anexo."\n";
        }

        if(!$this->mail->send()) {
            echo 'Message could not be sent.'."\n";
            echo 'Mailer Error: ' . $this->mail->ErrorInfo."\n";
            return false;
        } else {
            echo 'Message has been sent'."\n";
            return true;
        }
    }
}
?>
