<?php
/**************************************************************
 * Nome:    Usuario
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-01-25 (V1.0.1)
 * Descr.:  Cria classe de usuarios
 *************************************************************/


/**************************************************************
  Classe Usuarios
  Eh a classe principal de unidades de negocio.
 *************************************************************/
class Usuarios {
  var $Bd;
  var $TabelaR;
  var $TabelaP;
  var $TabelPA;
  var $TabelPD;
  var $TabelPG;
  var $TabelaM;
  var $TabelRF;
  var $TabelUG;
  var $TabelaF;
  var $TabelaG;
  var $TabelaUG;
  var $TabelaUR;
  var $TabelRA;
  var $Hoje;
  var $Login;


  //---------------------------------------------------
  // Construtor da classe.
  //---------------------------------------------------
  function Usuarios() {
    ($_SERVER['DOCUMENT_ROOT'] != "") ? $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/' : $DirRaiz = '';
    include($DirRaiz.'config.php');
    include($DirRaiz.'config.cc.php');
	include($DirRaiz.'config.pbx.php');
    include_once($DirRaiz.$DirClass.'bd.class.php');
    include_once($DirRaiz.$DirClass.'login.class.php');
    $this->Bd      = new Banco();
    $this->Login   = new Acesso();
    $this->TabelaR = $Tb_Usuar;
    $this->TabelaP = $Tb_Permi;
    $this->TabelPA = $Tb_PAgen;
    $this->TabelPD = $Tb_PDscr;
    $this->TabelPG = $Tb_PGrup;
    $this->TabelaM = $Tb_VRama;
    $this->TabelRF = $Tb_UsuFi;
	$this->TabelUG = $Tb_UsuGr;
    $this->TabelaF = $Tb_Fila;
	$this->TabelaG = $Tb_Grupo;
	$this->TabelaUG = $Tb_UsuGr;
	$this->TabelaUR = $Tb_UsuRa;
	$this->TabelRA = $Tb_Ramal;
    $this->Hoje    = date("d/m/y");
  }


  //---------------------------------------------------
  // Funcao apaga_usuarios
  //---------------------------------------------------
  function apaga_usuarios($Identif) {
    $Identif = trim($Identif);
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Apa = "DELETE FROM ".$this->TabelaR." WHERE id='".$Identif."'";
      $Res = $this->Bd->executa_query_sem_saida($Apa);
      if (!$Res) $Saida = false;
      else {
        $Apa = "DELETE FROM ".$this->TabelaP." WHERE id='".$Identif."'";
        $Res = $this->Bd->executa_query_sem_saida($Apa);
        if (!$Res) $Saida = false;
        else {
          $Apa = "DELETE FROM ".$this->TabelRF." WHERE usuario = '".$Identif."'";
          $Res = $this->Bd->executa_query_sem_saida($Apa);
        }
      }
    }
    return $Apa;
  }


  //---------------------------------------------------
  // Funcao altera_usuarios
  //---------------------------------------------------
  function altera_usuarios($Identif,$Nome,$NomeCompleto,$Email,$Ramal,$Tipo,$Licn,$Logme,$Hchrc,$Hchrl,$Hchna,$Sippr,$Regra,$Raex,$Tronr,$Coror,$Numm,$Ipdisc,$Webp,$Orbi,$Tpmo) {
    $Identif = trim($Identif);
    $Nome         = $this->Bd->arruma_nome($Nome);
    $Departamento = intval($Departamento);
    $Ramal        = intval($Ramal);
    $Hchrc        = intval($Hchrc);
    $Hchrl        = intval($Hchrl);
    $Hchna        = intval($Hchna);
    $NomeCompleto = utf8_encode($NomeCompleto);
    $EmailValido  = $this->Bd->testa_email($Email);
    $Nome  = $this->Bd->arruma_nome_com_numero($Nome);
    $Troca = "UPDATE ".$this->TabelaR." SET nome='".$Nome."', nomecompleto='".$NomeCompleto."', email='".$Email."', ramal='".$Ramal."', tipo='".$Tipo."', licenca='".$Licn."', login_mesa='".$Logme."',qteatendidas='".$Hchrc."', qterealizaat='".$Hchrl."', qterealizana='".$Hchna."', sipproxy='".$Sippr."',registra_sipproxy='".$Regra."', ramal_externo='".$Raex."', troncos_remotos=".$Tronr.", cororbita='".$Coror."', numeromesa='".$Numm."', ip_discagem='".$Ipdisc."', mostrar_webphone='".$Webp."', mostrar_orbitas='".$Orbi."', tipo_monitoramento='".$Tpmo."' WHERE id='".$Identif."'";
	//return $Troca;
    $Res   = $this->Bd->executa_query_sem_saida($Troca);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_usuarios
  //---------------------------------------------------
  function insere_usuarios($Nome,$NomeCompleto,$Email,$Ramal,$Tipo,$Licn,$Logme,$Hchrc,$Hchrl,$Hchna,$Sippr,$Regra,$Raex,$Tronr,$Coror,$Numm,$Ipdi,$Webp,$Orbi) {
    $Nome         = $this->Bd->arruma_nome($Nome);
    $NomeCompleto = utf8_encode($NomeCompleto);
    $Ramal        = intval($Ramal);
    $Hchrc        = intval($Hchrc);
    $Hchrl        = intval($Hchrl);
    $Hchna        = intval($Hchna);
    $EmailValido  = $this->Bd->testa_email($Email);
    $Pes  = "SELECT id FROM ".$this->TabelaR." WHERE nome='".$Nome."'";
	$Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO ".$this->TabelaR." (nome,nomecompleto,email,ramal,tipo,licenca,login_mesa,qteatendidas,qterealizaat,qterealizana,sipproxy,registra_sipproxy,ramal_externo,troncos_remotos,cororbita,numeromesa,ip_discagem,mostrar_webphone,mostrar_orbitas) VALUES ('".$Nome."', '".$NomeCompleto."', '".$Email."', '".$Ramal."', '".$Tipo."', '".$Licn."', '".$Logme."', '".$Hchrc."', '".$Hchrl."', '".$Hchna."', '".$Sippr."', '".$Regra."', '".$Raex."',".$Tronr.",'".$Coror."','".$Numm."', '".$Ipdi."', '".$Webp."', '".$Orbi."')";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      if (!$Res) $Saida = false;
      else {
        $Pes  = "SELECT id FROM ".$this->TabelaR." WHERE nome='".$Nome."'";
        $Res  = $this->Bd->executa_query_com_saida($Pes);
        if (!$Res) $Saida = false;
        else {
          $Saida = $this->inclui_permissoes($Res[0]['id']);
          if ($Saida) {
            $this->Login->gera_senha($Nome);
            $Saida = $Res[0]['id'];
          }
        }
      }
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao inclui_permissoes
  //---------------------------------------------------
  function inclui_permissoes($Identif) {
    $Identif = trim($Identif);
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Pes  = "SELECT id FROM ".$this->TabelaP." WHERE id='".$Identif."'";
      $Res  = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) {
        $Insere = "INSERT INTO ".$this->TabelaP." (id) VALUES ('".$Identif."')";
        $Res    = $this->Bd->executa_query_sem_saida($Insere);
        if (!$Res) $Saida = false;
        else $Saida = $this->Login->esqueci_senha($Nome);
      }
      else $Saida = false;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_permissoes
  //---------------------------------------------------
  function altera_permissoes($Identif,$Adm,$Pbtr,$Pbmo,$Pbfx,$Pbpl,$Pbrm,$Pbgr,$Pbraau,$Pbrafha,$Pbcaex,$Pbgrca,$Gvac,$Ccag,$Ccgr,$Ccfl,$Ccps,$Ccpr,$Cccl,$Ccme,$Ccut,$Ccpa,$Ccce,$Ccgfr,$Mntd,$Mnsg,$Mntg,$Mnsf,$Mntf,$Rltd,$Rlsg,$Rltg,$Rlsf,$Rltf,$Rlfx,$Grtd,$Grsg,$Grtg,$Grsf,$Grtf,$Grfx,$ModuloDiscador,$ModuloDiscadorParam,$ModuloDiscadorCadastro,$ModuloDiscadorMonitor,$ModuloDiscadorGerencia,$ModuloDiscadorUtils,$ModuloPbxGrupoTronco,$DiscadorGrupoCamp,$DiscadorGerenciaCamp,$DiscadorAgendaCamp,$Cccs,$Ccfs,$Crm_cad_vend,$Crm_cad_cli,$Crm_cad_cam,$Pecas) {
    $Identif = trim($Identif);
    if ((!is_numeric($Identif)) || (!$this->Bd->testa_permissao($Adm)) || (!$this->Bd->testa_permissao($Pbtr)) || (!$this->Bd->testa_permissao($Pbmo)) || (!$this->Bd->testa_permissao($Pbfx)) || (!$this->Bd->testa_permissao($Pbpl)) || (!$this->Bd->testa_permissao($Pbrm)) || (!$this->Bd->testa_permissao($Pbgr)) || (!$this->Bd->testa_permissao($Pbraau)) || (!$this->Bd->testa_permissao($Pbcaex)) || (!$this->Bd->testa_permissao($Pbrafha)) || (!$this->Bd->testa_permissao($Gvac)) || (!$this->Bd->testa_permissao($Ccag)) || (!$this->Bd->testa_permissao($Ccgr)) || (!$this->Bd->testa_permissao($Ccfl)) || (!$this->Bd->testa_permissao($Ccps)) || (!$this->Bd->testa_permissao($Ccpr)) || (!$this->Bd->testa_permissao($Mntd)) || (!$this->Bd->testa_permissao($Mnsg)) || (!$this->Bd->testa_permissao($Mntg)) || (!$this->Bd->testa_permissao($Mnsf)) || (!$this->Bd->testa_permissao($Mntf)) || (!$this->Bd->testa_permissao($Rltd)) || (!$this->Bd->testa_permissao($Rlsg)) || (!$this->Bd->testa_permissao($Rltg)) || (!$this->Bd->testa_permissao($Rlsf)) || (!$this->Bd->testa_permissao($Rltf)) || (!$this->Bd->testa_permissao($Rlfx)) || (!$this->Bd->testa_permissao($Grtd)) || (!$this->Bd->testa_permissao($Grsg)) || (!$this->Bd->testa_permissao($Grtg)) || (!$this->Bd->testa_permissao($Grsf)) || (!$this->Bd->testa_permissao($Grtf)) || (!$this->Bd->testa_permissao($Grfx)) || (!$this->Bd->
testa_permissao($ModuloDiscador)) || (!$this->Bd->testa_permissao($ModuloDiscadorParam)) || (!$this->Bd->testa_permissao($ModuloDiscadorCadastro)) || (!$this->Bd->testa_permissao($ModuloDiscadorMonitor)) || (!$this->Bd->testa_permissao($ModuloDiscadorGerencia)) || (!$this->Bd->testa_permissao($ModuloDiscadorUtils)) || (!$this->Bd->testa_permissao($ModuloPbxGrupoTronco)) || (!$this->Bd->testa_permissao($Ccut)) || (!$this->Bd->testa_permissao($Ccme)) || (!$this->Bd->testa_permissao($DiscadorGrupoCamp)) || (!$this->Bd->testa_permissao($DiscadorGerenciaCamp)) || (!$this->Bd->testa_permissao($DiscadorAgendaCamp)) || (!$this->Bd->testa_permissao($Ccsy)) || (!$this->Bd->testa_permissao($Ccfs)) || (!$this->Bd->testa_permissao($Crm_cad_vend)) || (!$this->Bd->testa_permissao($Crm_cad_cli)) || (!$this->Bd->testa_permissao($Crm_cad_cam)) || (!$this->Bd->testa_permissao($Ccpa)) || (!$this->Bd->testa_permissao($Ccgfr)) || (!$this->Bd->testa_permissao($Pecas)) ) $Saida = false;
    else {
      $Troca = "UPDATE ".$this->TabelaP." SET administrador=".$Adm.",pbx_troncos=".$Pbtr.",pbx_monitoramento=".$Pbmo.",pbx_feixes=".$Pbfx.",pbx_placas=".$Pbpl.",pbx_ramais=".$Pbrm.",pbx_grupo_ramais=".$Pbgr.",pbx_ramais_auxiliares=".$Pbraau.",pbx_ramais_fha=".$Pbrafha.",pbx_cad_extensoes=".$Pbcaex.",pbx_grupos_captura='".$Pbgrca."',gravacao_relat=".$Gvac.",cc_agentes=".$Ccag.",cc_grupos=".$Ccgr.",cc_filas=".$Ccfl.",cc_pausas=".$Ccps.",cc_periodos=".$Ccpr.",cc_classifica=".$Cccl.",cc_mensagem=".$Ccme.",cc_utils=".$Ccut.",cc_monit_tudo=".$Mntd.",cc_monit_seu_gru=".$Mnsg.",cc_monit_all_gru=".$Mntg.",cc_monit_sua_fil=".$Mnsf.",cc_monit_all_fil=".$Mntf.",cc_relat_tudo=".$Rltd.",cc_relat_seu_gru=".$Rlsg.",cc_relat_all_gru=".$Rltg.",cc_relat_sua_fil=".$Rlsf.",cc_relat_all_fil=".$Rltf.",cc_relat_feixes=".$Rlfx.",cc_grafi_tudo=".$Grtd.",cc_grafi_seu_gru=".$Grsg.",cc_grafi_all_gru=".$Grtg.",cc_grafi_sua_fil=".$Grsf.",cc_grafi_all_fil=".$Grtf.",cc_grafi_feixes=".$Grfx.", discador=".$ModuloDiscador.", discador_cad=".$ModuloDiscadorCadastro.", discador_param=".$ModuloDiscadorParam.", discador_moni=".$ModuloDiscadorMonitor.", discador_gerencia=".$ModuloDiscadorGerencia.", discador_utils=".$ModuloDiscadorUtils.", pbx_grupo_troncos=".$ModuloPbxGrupoTronco.", discador_grupo_camp=".$DiscadorGrupoCamp.", discador_gerencia_campanhas=".$DiscadorGerenciaCamp.", discador_agenda_campanhas = ".$DiscadorAgendaCamp.", cc_config_syonet = ".$Cccs.", cc_filas_syonet = ".$Ccfs.", crm_cad_vend = ".$Crm_cad_vend.", crm_cad_cli = ".$Crm_cad_cli.", crm_cad_cam = ".$Crm_cad_cam.", cc_painel_pa = ".$Ccpa.", cc_conf_email = ".$Ccce.", cc_grupo_filas_relatorio = ".$Ccgfr.", pecas = ".$Pecas." WHERE id='".$Identif."'";
      $Res   = $this->Bd->executa_query_sem_saida($Troca);
      if (!$Res) $Saida = false;
      else $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao inclui_usuarios_filas
  //---------------------------------------------------
  function inclui_usuarios_filas($Identif,$Filas) {
    $Identif = trim($Identif);
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Pes  = "SELECT id FROM ".$this->TabelaR." WHERE id='".$Identif."'";
      $Res  = $this->Bd->executa_query_com_saida($Pes);
      if ($Res) {
        $Apa = "DELETE FROM ".$this->TabelRF." WHERE usuario = '".$Identif."'";
        $Res = $this->Bd->executa_query_sem_saida($Apa);
        if (is_array($Filas)) {
          $Saida = true;
          for ($x=0; $x<count($Filas); $x++) {
            $Pes  = "SELECT id FROM ".$this->TabelaF." WHERE pseudonimo='".$Filas[$x]."'";
            $Res  = $this->Bd->executa_query_com_saida($Pes);
            if ($Res) {
              $Insere = "INSERT INTO ".$this->TabelRF." (usuario,fila) VALUES (".$Identif.",".$Res[0]['id'].")";
              $Res    = $this->Bd->executa_query_sem_saida($Insere);
            }
            else $Saida = $Insere;
          }
        }
        else $Saida = $Apa;
      }
      else $Saida = $Pes;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_usuarios
  //---------------------------------------------------
  function lista_usuarios($Ativo='') {
    $Pes = "SELECT * FROM ".$this->TabelaR." ORDER BY nome";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else {
      $Saida = $Res;
      for ($x=0; $x<count($Res); $x++) {
        $Res[$x]['nomecompleto'] = utf8_decode($Res[$x]['nomecompleto']);
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_usuarios_por_id
  //---------------------------------------------------
  function lista_usuarios_por_id($Identif) {
    $Identif = trim($Identif);
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Pes = "SELECT * FROM ".$this->TabelaR." WHERE id='".$Identif."'";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) $Saida = false;
      else $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_permissoes
  //---------------------------------------------------
  function lista_permissoes($Ativo='') {
    //$Pes = "SELECT ".$this->TabelaR.".nome,".$this->TabelaP.".id,".$this->TabelaP.".administrador,".$this->TabelaP.".discador,".$this->TabelaP.".pbx_troncos,".$this->TabelaP.".pbx_feixes,".$this->TabelaP.".pbx_placas,".$this->TabelaP.".pbx_ramais,".$this->TabelaP.".pbx_grupo_ramais,".$this->TabelaP.".gravacao_relat,".$this->TabelaP.".cc_agentes,".$this->TabelaP.".cc_grupos,".$this->TabelaP.".cc_filas,".$this->TabelaP.".cc_pausas,".$this->TabelaP.".cc_periodos,".$this->TabelaP.".cc_classifica,".$this->TabelaP.".cc_utils,".$this->TabelaP.".cc_monit_tudo,".$this->TabelaP.".cc_monit_seu_gru,".$this->TabelaP.".cc_monit_all_gru,".$this->TabelaP.".cc_monit_sua_fil,".$this->TabelaP.".cc_monit_all_fil,".$this->TabelaP.".cc_relat_tudo,".$this->TabelaP.".cc_relat_seu_gru,".$this->TabelaP.".cc_relat_all_gru,".$this->TabelaP.".cc_relat_sua_fil,".$this->TabelaP.".cc_relat_all_fil,".$this->TabelaP.".cc_relat_feixes,".$this->TabelaP.".cc_grafi_tudo,".$this->TabelaP.".cc_grafi_seu_gru,".$this->TabelaP.".cc_grafi_all_gru,".$this->TabelaP.".cc_grafi_sua_fil,".$this->TabelaP.".cc_grafi_all_fil,".$this->TabelaP.".cc_grafi_feixes,".$this->TabelaP.".discador_param,".$this->TabelaP.".discador_cad,".$this->TabelaP.".discador_moni,".$this->TabelaP.".discador_gerencia,".$this->TabelaP.".pbx_grupo_troncos  FROM ".$this->TabelaP." INNER JOIN ".$this->TabelaR." ON ".$this->TabelaP.".id=".$this->TabelaR.".id";
    //$Pes .= " ORDER BY ".$this->TabelaR.".nome";
	$Pes = "SELECT u.nome, p.* FROM ".$this->TabelaR." u INNER JOIN ".$this->TabelaP." p ON u.id = p.id ORDER BY u.nome";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_permissoes_por_id
  //---------------------------------------------------
  function lista_permissoes_por_id($Identif) {
    $Identif = trim($Identif);
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Pes = "SELECT p.*, u.troncos_remotos FROM ".$this->TabelaP." AS p INNER JOIN ".$this->TabelaR." AS u ON p.id = u.id WHERE p.id='".$Identif."'";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) $Saida = false;
      else {
        $Saida = $Res;
        $Pes1 = "SELECT tipo FROM ".$this->TabelaR." WHERE id='".$Identif."'";
        $Res1 = $this->Bd->executa_query_com_saida($Pes1);
        if ($Res1) $Saida[0]['tipo'] = $Res1[0]['tipo'];
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_usuarios_filas
  //---------------------------------------------------
  function lista_usuarios_filas() {
    $Pes = "SELECT ".$this->TabelRF.".usuario as usuario,".$this->TabelaF.".pseudonimo as fila FROM ".$this->TabelRF." INNER JOIN ".$this->TabelaF." ON ".$this->TabelRF.".fila=".$this->TabelaF.".id ORDER BY usuario";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }
  
  //---------------------------------------------------
  // Funcao lista_usuarios_ramais
  //---------------------------------------------------
  function lista_usuarios_ramais() {
    $Pes = "SELECT ur.usuario as usuario, r.ramal FROM ".$this->TabelaUR." ur INNER JOIN ".$this->TabelaR." u ON ur.usuario = u.id INNER JOIN ".$this->TabelRA." r ON ur.ramal = r.id order by u.nome, r.ramal";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }
  
  //----------------------------------------------------
  // Funcao lista_usuarios_grupos
  //----------------------------------------------------
  function lista_usuarios_grupos() {
	$Pes = "SELECT ".$this->TabelaUG.".usuario as usuario,".$this->TabelaG.".nome as grupo FROM ".$this->TabelaUG." INNER JOIN ".$this->TabelaG." ON ".$this->TabelaUG.".grupo=".$this->TabelaG.".id ORDER BY usuario";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_usuarios_filas_por_id
  //---------------------------------------------------
  function lista_usuarios_filas_por_id($Identif) {
    $Pes = "SELECT ".$this->TabelRF.".usuario as usuario,".$this->TabelaF.".pseudonimo as fila, ".$this->TabelaF.".nome as nome_fila FROM ".$this->TabelRF." INNER JOIN ".$this->TabelaF." ON ".$this->TabelRF.".fila=".$this->TabelaF.".id WHERE usuario='".$Identif."' ORDER BY fila";
    //return $Pes;
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_ramal_por_id
  //---------------------------------------------------
  function lista_ramal_por_id($Identif) {
    $Identif = trim($Identif);
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Pes = "SELECT ramal FROM ".$this->TabelaR." WHERE id='".$Identif."'";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) $Saida = false;
      else $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_nome_email_por_permissao
  // O parametro Permis eh o nome do campo que deve ter
  // a permissao true.
  //---------------------------------------------------
  function lista_nome_email_por_permissao($Permis) {
    $Pes = "SELECT ".$this->TabelaR.".nome_completo,".$this->TabelaR.".email FROM ".$this->TabelaP." INNER JOIN ".$this->TabelaR." ON ".$this->TabelaP.".id=".$this->TabelaR.".id WHERE ".$this->TabelaP.".".$Permis." = TRUE ";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_email_por_id
  //---------------------------------------------------
  function lista_email_por_id($Iden) {
    $Pes = "SELECT email,nome_completo FROM ".$this->TabelaR." WHERE id=".$Iden;
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_agenda
  //---------------------------------------------------
  function lista_agenda($Usuar) {
    $Pes = "SELECT id FROM ".$this->TabelaR." WHERE id=".$Usuar;
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else {
      $Pes = "SELECT * FROM ".$this->TabelPA." WHERE usuario=".$Usuar." ORDER BY nome";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) $Saida = false;
      else $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao apaga_agendas
  //---------------------------------------------------
  function apaga_agendas($Identif) {
    $Identif = trim($Identif);
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Apa = "DELETE FROM ".$this->TabelPA." WHERE id=".$Identif;
      $Res = $this->Bd->executa_query_sem_saida($Apa);
      if (!$Res) $Saida = false;
      else {
        $Apa = "DELETE FROM ".$this->TabelPA." WHERE id=".$Identif;
        $Res = $this->Bd->executa_query_sem_saida($Apa);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_agendas
  //---------------------------------------------------
  function altera_agendas($Usuario,$Identif,$Nome,$Cargo,$Empresa,$Ramal,$Residencia,$Celular,$Comercial,$Fax,$Email) {
    $Identif      = trim($Identif);
    $Ramal = intval($Ramal);
    $Troca = "UPDATE ".$this->TabelPA." SET nome='".$Nome."' ,cargo='".$Cargo."' ,empresa='".$Empresa."' ,ramal='".$Ramal."' ,tel_res='".$Residencia."' ,tel_cel='".$Celular."',tel_com='".$Comercial."',fax='".$Fax."' ,email='".$Email."' WHERE id=".$Identif;
    $Res   = $this->Bd->executa_query_sem_saida($Troca);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_agendas
  //---------------------------------------------------
  function insere_agendas($Usuario,$Nome,$Cargo,$Empresa,$Ramal,$Residencia,$Celular,$Comercial,$Fax,$Email) {
    $Ramal = intval($Ramal);
    $Pes  = "SELECT id FROM ".$this->TabelPA." WHERE nome='".$Nome."' AND usuario=".$Usuario;
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO ".$this->TabelPA." (usuario,nome,cargo,empresa,ramal,tel_res,tel_cel,tel_com,fax,email) VALUES (".$Usuario.", '".$Nome."', '".$Cargo."', '".$Empresa."', '".$Ramal."', '".$Residencia."', '".$Celular."', '".$Comercial."', '".$Fax."', '".$Email."')";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      if (!$Res) $Saida = false;
      else $Saida = $Res;
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_discagem_rapida
  //---------------------------------------------------
  function lista_discagem_rapida($Usuar) {
    $Pes = "SELECT id FROM ".$this->TabelaR." WHERE id=".$Usuar;
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else {
      $Pes = "SELECT tecla, nome, numero FROM ".$this->TabelPD." WHERE usuario=".$Usuar." ORDER BY tecla";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) $Saida = false;
      else $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_discagens_rapidas
  //---------------------------------------------------
  function altera_discagens_rapidas($Usuar,$Tecla1,$Tecla2,$Tecla3,$Tecla4,$Tecla5,$Tecla6,$Tecla7,$Tecla8,$Tecla9,$Tecla10) {
    $Pes = "SELECT id FROM ".$this->TabelaR." WHERE id=".$Usuar;
    $Res = $this->Bd->executa_query_com_saida($Pes);
    $Saida = true;
    if (!$Res) $Saida = false;
    else {
      $Numeros = array('',$Tecla1[1],$Tecla2[1],$Tecla3[1],$Tecla4[1],$Tecla5[1],$Tecla6[1],$Tecla7[1],$Tecla8[1],$Tecla9[1],$Tecla10[1]);
      $Nomes   = array('',$Tecla1[0],$Tecla2[0],$Tecla3[0],$Tecla4[0],$Tecla5[0],$Tecla6[0],$Tecla7[0],$Tecla8[0],$Tecla9[0],$Tecla10[0]);
      for ($x=1; $x<11; $x++) {
        $Pes = "SELECT id FROM ".$this->TabelPD." WHERE tecla='".$x."' AND usuario=".$Usuar;
        $Res = $this->Bd->executa_query_com_saida($Pes);
        $Agora .=$Pes."<br>";
        if (!$Res) $Acao = "INSERT INTO ".$this->TabelPD." (usuario,tecla,nome,numero) VALUES (".$Usuar.", '".$x."', '".$Nomes[$x]."', '".$Numeros[$x]."')";
        else $Acao = "UPDATE ".$this->TabelPD." SET nome='".$Nomes[$x]."', numero='".$Numeros[$x]."' WHERE id=".$Res[0]['id'];
        $Agora .=$Acao."<br>";
        $Res   = $this->Bd->executa_query_sem_saida($Acao);
        if (!$Res) $Saida = false;
        else if ($Saida) $Saida = $Res;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_grupos_persona
  //---------------------------------------------------
  function lista_grupos_persona($Usuar) {
    $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
    include($DirRaiz.'config.pbx.php');
    $Pes = "SELECT id FROM ".$this->TabelaR." WHERE id=".$Usuar;
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else {
      $Pes = "SELECT ".$Tb_Ramal.".ramal as ramal FROM ".$this->TabelPG." INNER JOIN ".$Tb_Ramal." ON ".$this->TabelPG.".ramal = ".$Tb_Ramal.".id WHERE ".$this->TabelPG.".usuario = ".$Usuar." ORDER BY ".$Tb_Ramal.".ramal";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) $Saida = false;
      else $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_grupos_persona
  //---------------------------------------------------
  function altera_grupos_persona($Usuar,$Ramais) {
    $Pes = "SELECT id FROM ".$this->TabelaR." WHERE id=".$Usuar;
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else {
      if (is_array($Ramais)) {
        $Acaod = "DELETE FROM ".$this->TabelPG." WHERE usuario = ".$Usuar;
        $Res  = $this->Bd->executa_query_sem_saida($Acaod);
        for ($x=0; $x<count($Ramais); $x++) {
          $Pes = "SELECT id FROM ".$this->TabelaM." WHERE ramal='".$Ramais[$x]."'";
          $Res = $this->Bd->executa_query_com_saida($Pes);
          if ($Res) {
            $IdR  = $Res[0]['id'];
            $Acao = "INSERT INTO ".$this->TabelPG." (usuario,ramal) VALUES (".$Usuar.", ".$IdR.")";
            $Res  = $this->Bd->executa_query_sem_saida($Acao);
            if ((!$Res) && $Saida) $Saida = false;
            else $Saida = true;
          }
        }
      }
    }
    return $Saida;
  }
  
  //---------------------------------------------------
  // Funcao inclui_usuarios_grupos
  //---------------------------------------------------
  function inclui_usuarios_grupos($Identif,$Grupos) {
    $Identif = trim($Identif);
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Pes  = "SELECT id FROM ".$this->TabelaR." WHERE id='".$Identif."'";
      $Res  = $this->Bd->executa_query_com_saida($Pes);
      if ($Res) {
        $Apa = "DELETE FROM ".$this->TabelUG." WHERE usuario = '".$Identif."'";
        $Res = $this->Bd->executa_query_sem_saida($Apa);
        if (is_array($Grupos)) {
          $Saida = true;
          for ($x=0; $x<count($Grupos); $x++) {
            $Pes  = "SELECT id FROM ".$this->TabelaG." WHERE nome='".$Grupos[$x]."'";
            $Res  = $this->Bd->executa_query_com_saida($Pes);
            if ($Res) {
              $Insere = "INSERT INTO ".$this->TabelUG." (usuario,grupo) VALUES (".$Identif.",".$Res[0]['id'].")";
              $Res    = $this->Bd->executa_query_sem_saida($Insere);
            }
            else $Saida = $Insere;
          }
        }
        else $Saida = $Apa;
      }
      else $Saida = $Pes;
    }
    return $Saida;
  }
  
  //---------------------------------------------------
  // Funcao inclui_usuarios_ramais
  //---------------------------------------------------
  function inclui_usuarios_ramais($Identif,$Ramais) {
    $Identif = trim($Identif);
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Pes  = "SELECT id FROM ".$this->TabelaR." WHERE id='".$Identif."'";
      $Res  = $this->Bd->executa_query_com_saida($Pes);
      if ($Res) {
        $Apa = "DELETE FROM ".$this->TabelaUR." WHERE usuario = '".$Identif."'";
        $Res = $this->Bd->executa_query_sem_saida($Apa);
        if (is_array($Ramais)) {
          $Saida = true;
          for ($x=0; $x<count($Ramais); $x++) {
            $Pes  = "SELECT id FROM ".$this->TabelRA." WHERE ramal='".$Ramais[$x]."'";
            $Res  = $this->Bd->executa_query_com_saida($Pes);
            if ($Res) {
              $Insere = "INSERT INTO ".$this->TabelaUR." (usuario,ramal) VALUES (".$Identif.",".$Res[0]['id'].")";
              $Res    = $this->Bd->executa_query_sem_saida($Insere);
            }
            else $Saida = $Insere;
          }
        }
        else $Saida = $Apa;
      }
      else $Saida = $Pes;
    }
    return $Saida;
  }
  
  //---------------------------------------------------
  // Funcao altera_label_ramal
  //---------------------------------------------------
  function altera_label_ramal($Identif, $Tipo){
	  $SQL = "UPDATE ".$this->TabelaR." SET labelramal = ".$Tipo." WHERE id = ".$Identif;
	  if($this->Bd->executa_query_sem_saida($SQL)) return true;
	  else return false;
  }
  
  //---------------------------------------------------
  // Funcao cor_por_mesa
  //---------------------------------------------------
  function cor_por_mesa($mesa){
	  $Pes = "SELECT cororbita FROM ".$this->TabelaR." WHERE numeromesa = ".$mesa;
	  $Res = $this->Bd->executa_query_com_saida($Pes);
	  return $Res[0]['cororbita'];
  }
}
?>
