<?php
/**************************************************************
* Nome:    Discador
* Autor:   Renato N. Lourenç* Data:	  2013-07-13 (V1.0.1)
* Descr.:  Cria a classe de discador
*************************************************************/

/**************************************************************
Classe Monitores
*************************************************************/
class Crm {
    var $DirRaiz;
	var $BdVdtMysql;
    var $Bd;

	//---------------------------------------------------
	// Construtor da classe.
	//---------------------------------------------------
	function Crm() {
		$DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
        include($DirRaiz.'config.php');
		include_once($DirRaiz.$DirClass.'bd.vdt.mysql.class.php');
        include_once($DirRaiz.$DirClass.'bd.class.php');
        $this->DirRaiz = $DirRaiz;
		$this->BdVdtMysql = new BdVdtMysql();
        $this->Bd = new Banco();
	}

    /**
     * Método para carregar os vendedores
     * @return Array vendedores
     */
	function carregarVendedores(){
		$sql = "SELECT * FROM vm50_vendedores_pecas WHERE flag = 1 ORDER BY nome_completo";
		$res = $this->BdVdtMysql->executa_query_com_saida($sql);
		return $res;
	}

    /**
     * Método usado para carregar um vendedor pelo Id
     * @param  Integer $id Id do cliente que queremos carregar
     * @return Array       Array com os dados do vendedor carregados
     */
    function carregarVendedorPorId($id){
        $sql = "SELECT * FROM vm50_vendedores_pecas WHERE id LIKE '".$id."' LIMIT 1";
        $res = $this->BdVdtMysql->executa_query_com_saida($sql);
        return $res;
    }

    /**
     * Método usado para carregar um vendedor pelo login
     * @param  String $login Login do agente que o vendedor usa
     * @return Array         Array com os dados do vendedor carregados
     */
    function carregarVendedorPorLogin($login){
        $sql = "SELECT * FROM vm50_vendedores_pecas WHERE login = '".$login."' LIMIT 1";
        $res = $this->BdVdtMysql->executa_query_com_saida($sql);
        return $res;
    }

    /**
     * Método para alterar um vendedor por id
     * @param  Integer $id            Id do vendedor a ser alterado
     * @param  String $nomeCompleto   Nome completo do vendedor
     * @param  String $nomeAbreviado  Nome abreviado do vendedor
     * @param  String $tipoCliente    Tipo de clientes que o vendedor atende
     * @param  String $login          Login que o vendedor usará
     * @param  String $pseudonimo    Pseudonimo do agente que usa o login selecionado
     * @param  Integer $id_campanha    Id da campanha a qual o vendedor faz parte
     * @return Boolean                True caso altere e false caso de erro
     */
    function alterarVendedor($id, $nomeCompleto, $nomeAbreviado, $tipoCliente, $login, $pseudonimo, $id_campanha){
        if(trim($id_campanha) == "") $id_campanha = 0;
        $sql = "UPDATE vm50_vendedores_pecas SET nome_completo = '".$nomeCompleto."', nome_abreviado = '".$nomeAbreviado."', tipo_cliente = '".$tipoCliente."', login = '".$login."', pseudonimo = '".$pseudonimo."', id_campanha = ".$id_campanha." WHERE id LIKE '".$id."'";
        $res = $this->BdVdtMysql->executa_query_sem_saida($sql);
        return $res;
    }

    /**
     * Método para inserir um novo vendedor
     * @param  String $nomeCompleto   Nome completo do vendedor
     * @param  String $nomeAbreviado  Nome abreviado do vendedor
     * @param  String $tipoCliente    Tipo de clientes que o vendedor atende
     * @param  String $login          Login que o vendedor usará
     * @param  String $pseudonimo    Pseudonimo do agente que usa o login selecionado
     * @param  Integer $id_campanha    Id da campanha a qual o vendedor faz parte
     * @return Boolean                True caso insira e false caso de erro
     */
    function inserirVendedor($nomeCompleto, $nomeAbreviado, $tipoCliente, $login, $pseudonimo, $id_campanha){
        $sql = "INSERT INTO vm50_vendedores_pecas (nome_completo, nome_abreviado, tipo_cliente, login, pseudonimo, id_campanha) VALUES ('".$nomeCompleto."', '".$nomeAbreviado."', '".$tipoCliente."', '".$login."', '".$pseudonimo."', ".$id_campanha.")";
        $res = $this->BdVdtMysql->executa_query_sem_saida($sql);
        return $res;
    }

    /**
     * Método para deletar um vendedor pelo id
     * @param  Integer $id Id do vendedor que se deseja deletar
     * @return Boolean     True caso delete e false caso de erro
     */
    function deletarVendedor($id){
        $sql = "DELETE FROM vm50_vendedores_pecas WHERE id LIKE '".$id."'";
        $res = $this->BdVdtMysql->executa_query_sem_saida($sql);
        return $res;
    }

    /**
     * Método usado para carregar os clientes do bd
     * @param  Integer $inicio      Ĺinha que irá começar a pesquisa
     * @param  Integer $quantidade  Quantidade de clientes que irá retornar a partir da linha indicada em $inicio
     * @return Array                Array com os clientes carregados
     */
    function carregarClientes($inicio=0, $quantidade=0){
        if($inicio == 0 && $quantidade == 0) $sql = "SELECT * FROM vm50_clientes_pecas ORDER BY nome";
        else if($quantidade != 0) $sql = "SELECT * FROM vm50_clientes_pecas ORDER BY nome LIMIT ".$inicio.", ".$quantidade;
        $res = $this->BdVdtMysql->executa_query_com_saida($sql);
        return $res;
    }

    /**
     * Método usado para carregar as informações de um cliente pelo id do cliente
     * @param  Integer $id Id do cliente que se deseja carregar
     * @return Array       Array com as informações do cliente carregadas
     */
    function carregarClientePorId($id){
        $sql = "SELECT * FROM vm50_clientes_pecas WHERE id = ".$id;
        $res = $this->BdVdtMysql->executa_query_com_saida($sql);
        return $res;
    }

    /**
     * Método usado para carregar as informações de um cliente pelo telefone
     * @param  String $telefone Telefone do cliente
     * @return Array            Array com as informações do cliente carregadas
     */
    function carregarClientePorTelefone($telefone){
        $fone = substr($telefone, -8);
        $sql = "SELECT * FROM vm50_clientes_pecas WHERE fone1 like '%".$fone."' OR fone2 like '%".$fone."' OR fone3 like '%".$fone."' LIMIT 1";
        $res = $this->BdVdtMysql->executa_query_com_saida($sql);
        return $res;
    }

    /**
     * Método usado para carregar as informações de um cliente pelo documento
     * @param  Integer $documento Numero do documento do cliente
     * @return Array            Array com as informações do cliente carregadas
     */
    function carregarClientePorDocumento($documento){
        $sql = "SELECT * FROM vm50_clientes_pecas WHERE documento = ".$documento." LIMIT 1";
        $res = $this->BdVdtMysql->executa_query_com_saida($sql);
        return $res;
    }

    /**
     * Método usado para carregar as informações de um cliente pelo nome
     * @param  String $documento Nome do cliente
     * @return Array             Array com as informações do cliente carregadas
     */
    function carregarClientePorNome($nome){
        $sql = "SELECT * FROM vm50_clientes_pecas WHERE nome LIKE '%".$nome."%' ORDER BY nome";
        $res = $this->BdVdtMysql->executa_query_com_saida($sql);
        return $res;
    }

    /**
     * Método usado para alterar as informações de um cliente
     * @param  Integer $id                 Id do cliente que se deseja alterar
     * @param  String $nome                Nome do cliente
     * @param  String $tipo                Tipo de cliente
     * @param  String $documento           Documento do cliente
     * @param  Double $limite_credito      Limite de crédito do cliente
     * @param  String $endereco            Endereço do cliente
     * @param  String $bairro              Bairro do cliente
     * @param  String $cidade              Cidade do cliente
     * @param  String $uf                  Estado do cliente (informar com 2 digitos. Ex.: "SP", "RJ", "MG"...)
     * @param  Integer $cep                Cep do cliente (informar apenas números. Ex.: 12345000)
     * @param  String $cnae                Cnae do cliente
     * @param  String $fone1               Telefone 1 do cliente
     * @param  String $fone2               Telefone 2 do cliente
     * @param  String $fone3               Telefone 3 do cliente
     * @param  String $contato             Nome da pessoa para contato
     * @param  Integer $aceita_contato     A pessoa aceita contato? 1 para sim e 0 para não
     * @param  Char $sexo                  Sexo do cliente (informar "M", "F" ou "" para quando o cliente não é pessoa física)
     * @param  Integer $status             Status do cliente (0 para inativo e 1 para ativo)
     * @param  String $data_cadastro       Data de cadastro do cliente (informar no formato 'yyyy-mm-dd')
     * @param  Integer $codSegmento        Código do segmento
     * @param  Integer $codBalcaoSegmento  Balcão do segmento
     * @param  Integer $codOficinaSegmento Oficina do segmento
     * @param  Integer $codServicoSegmento Serviço do segmento
     * @param  Integer $codVendaSegmento   Venda do segmento
     * @param  Double $vendaMesAtual       Total de vendas do mes atual ao cliente
     * @param  Double $vendaUlt3Meses      Total de vendas dos últimos 3 meses ao cliente
     * @param  Double $vendaUlt12Meses     Total de vendas dos últimos 12 meses ao cliente
     * @param  Double $vendaMargem         Margem de venda ao cliente
     * @param  Double $credito             Crédito do cliente
     * @param  Integer $id_vendedor        Id do vendedor do cliente
     * @return Boolean                     True caso altere e false caso de erro
     */
    function alterarCliente($id, $nome, $tipo, $documento, $limite_credito, $endereco, $bairro, $cidade, $uf, $cep, $cnae, $fone1, $fone2, $fone3, $contato, $aceita_contato, $sexo, $status, $data_cadastro, $codSegmento, $codBalcaoSegmento, $codOficinaSegmento, $codServicoSegmento, $codVendaSegmento, $vendaMesAtual, $vendaUlt3Meses, $vendaUlt12Meses, $vendaMargem, $credito, $id_vendedor){
        $sql = "UPDATE vm50_clientes_pecas SET nome = '".$nome."', tipo = '".$tipo."', documento = '".$documento."', limite_credito = ".$limite_credito.", endereco = '".$endereco."', bairro = '".$bairro."', cidade = '".$cidade."', uf = '".$uf."', cep = ".$cep.", cnae = '".$cnae."', fone1 = '".$fone1."', fone2 = '".$fone2."', fone3 = '".$fone3."', contato = '".$contato."', aceita_contato = ".$aceita_contato.", sexo = '".$sexo."', status = ".$status.", data_cadastro = '".$data_cadastro."', codSegmento = ".$codSegmento.", codBalcaoSegmento = ".$codBalcaoSegmento.", codOficinaSegmento = ".$codOficinaSegmento.", codServicoSegmento = ".$codServicoSegmento.", codVendaSegmento = ".$codVendaSegmento.", vendaMesAtual = ".$vendaMesAtual.", vendaUlt3Meses = ".$vendaUlt3Meses.", vendaUlt12Meses = ".$vendaUlt12Meses.", vendaMargem = ".$vendaMargem.", credito = ".$credito.", id_vendedor = ".$id_vendedor." WHERE id = ".$id;
        return $this->BdVdtMysql->executa_query_sem_saida($sql);
    }

    /**
     * Método usado para alterar as informações de um cliente vindas da tela de Screen Popup
     * @param  Integer $id                 Id do cliente que se deseja alterar
     * @param  String $nome                Nome do cliente
     * @param  String $documento           Documento do cliente
     * @param  String $fone1               Telefone 1 do cliente
     * @param  String $fone2               Telefone 2 do cliente
     * @param  String $fone3               Telefone 3 do cliente
     * @param  String $contato             Nome da pessoa para contato
     * @return Boolean                     True caso altere e false caso de erro
     */
    function alterarClienteScreenPopup($id, $nome, $documento, $fone1, $fone2, $fone3, $contato){
        $sql = "UPDATE vm50_clientes_pecas SET nome = '".$nome."', documento = '".$documento."', fone1 = '".$fone1."', fone2 = '".$fone2."', fone3 = '".$fone3."', contato = '".$contato."' WHERE id = ".$id;
        return $this->BdVdtMysql->executa_query_sem_saida($sql);
    }

    /**
     * Método usado para inserir um cliente
     * @param  String $nome                Nome do cliente
     * @param  String $tipo                Tipo de cliente
     * @param  String $documento           Documento do cliente
     * @param  Double $limite_credito      Limite de crédito do cliente
     * @param  String $endereco            Endereço do cliente
     * @param  String $bairro              Bairro do cliente
     * @param  String $cidade              Cidade do cliente
     * @param  String $uf                  Estado do cliente (informar com 2 digitos. Ex.: "SP", "RJ", "MG"...)
     * @param  Integer $cep                Cep do cliente (informar apenas números. Ex.: 12345000)
     * @param  String $cnae                Cnae do cliente
     * @param  String $fone1               Telefone 1 do cliente
     * @param  String $fone2               Telefone 2 do cliente
     * @param  String $fone3               Telefone 3 do cliente
     * @param  String $contato             Nome da pessoa para contato
     * @param  Integer $aceita_contato     A pessoa aceita contato? 1 para sim e 0 para não
     * @param  Char $sexo                  Sexo do cliente (informar "M", "F" ou "" para quando o cliente não é pessoa física)
     * @param  Integer $status             Status do cliente (0 para inativo e 1 para ativo)
     * @param  String $data_cadastro       Data de cadastro do cliente (informar no formato 'yyyy-mm-dd')
     * @param  Integer $codSegmento        Código do segmento
     * @param  Integer $codBalcaoSegmento  Balcão do segmento
     * @param  Integer $codOficinaSegmento Oficina do segmento
     * @param  Integer $codServicoSegmento Serviço do segmento
     * @param  Integer $codVendaSegmento   Venda do segmento
     * @param  Double $vendaMesAtual       Total de vendas do mes atual ao cliente
     * @param  Double $vendaUlt3Meses      Total de vendas dos últimos 3 meses ao cliente
     * @param  Double $vendaUlt12Meses     Total de vendas dos últimos 12 meses ao cliente
     * @param  Double $vendaMargem         Margem de venda ao cliente
     * @param  Double $credito             Crédito do cliente
     * @param  Integer $id_vendedor        Id do vendedor do cliente
     * @return Boolean                     True caso altere e false caso de erro
     */
    function inserirCliente($nome, $tipo, $documento, $limite_credito, $endereco, $bairro, $cidade, $uf, $cep, $cnae, $fone1, $fone2, $fone3, $contato, $aceita_contato, $sexo, $status, $data_cadastro, $codSegmento, $codBalcaoSegmento, $codOficinaSegmento, $codServicoSegmento, $codVendaSegmento, $vendaMesAtual, $vendaUlt3Meses, $vendaUlt12Meses, $vendaMargem, $credito, $id_vendedor){
        $sql = "INSERT INTO vm50_clientes_pecas (nome, tipo, documento, limite_credito, endereco, bairro, cidade, uf, cep, cnae, fone1, fone2, fone3, contato, aceita_contato, sexo, status, data_cadastro, codSegmento, codBalcaoSegmento, codOficinaSegmento, codServicoSegmento, codVendaSegmento, vendaMesAtual, vendaUlt3Meses, vendaUlt12Meses, vendaMargem, credito, id_vendedor) VALUES ('".$nome."', '".$tipo."', '".$documento."', ".$limite_credito.", '".$endereco."', '".$bairro."', '".$cidade."', '".$uf."', ".$cep.", '".$cnae."', '".$fone1."', '".$fone2."', '".$fone3."', '".$contato."', ".$aceita_contato.", '".$sexo."', ".$status.", '".$data_cadastro."', ".$codSegmento.", ".$codBalcaoSegmento.", ".$codOficinaSegmento.", ".$codServicoSegmento.", ".$codVendaSegmento.", ".$vendaMesAtual.", ".$vendaUlt3Meses.", ".$vendaUlt12Meses.", ".$vendaMargem.", ".$credito.", ".$id_vendedor.")";
        return $this->BdVdtMysql->executa_query_sem_saida($sql);
    }

    /**
     * Método usado para deletar um cliente do banco de dados
     * @param  Integer $id Id do cliente que se deseja deletar
     * @return Boolean     True caso caso delete, false caso de erro
     */
    function deletarCliente($id){
        $sql = "DELETE FROM vm50_clientes_pecas WHERE id = ".$id;
        $res = $this->BdVdtMysql->executa_query_sem_saida($sql);
        return $res;
    }

    /**
     * Método usado para inserir uma campanha no banco de dados
     * @param  String $nome  Nome da campanha
     * @return Boolean       True caso insira e false caso de erro
     */
    function inserirCampanha($nome){
        $sql = "INSERT INTO vm50_campanhas_pecas (nome) VALUES ('".$nome."')";
        $res = $this->Bd->executa_query_sem_saida($sql);
        return $res;
    }

    /**
     * Método usado para alterar uma campanha no banco de dados
     * @param  Integer $id   Id da campanha que se deseja alterar
     * @param  String $nome  Nome da campanha
     * @return Boolean       True caso altere e false caso de erro
     */
    function alterarCampanha($id, $nome){
        $sql = "UPDATE vm50_campanhas_pecas SET nome = '".$nome."' WHERE id = ".$id;
        $res = $this->Bd->executa_query_sem_saida($sql);
        return $res;
    }

    /**
     * Método usado para deletar uma campanha do banco de dados
     * @param  Integer $id Id da campanha que se deseja deletar
     * @return Boolean     True caso delete e false caso de erro
     */
    function deletarCampanha($id){
        $sql = "DELETE FROM vm50_campanhas_pecas WHERE id = ".$id;
        $res = $this->Bd->executa_query_sem_saida($sql);
        return $res;
    }

    /**
     * Método usado para carregar as campanhas do banco de dados
     * @return Array Array com as informações das campanhas carregadas
     */
    function carregarCampanhas(){
        $sql = "SELECT * FROM vm50_campanhas_pecas ORDER BY nome";
        $res = $this->Bd->executa_query_com_saida($sql);
        return $res;
    }

    /**
     * Método usado para gravar as chamadas classificadas no banco de dados postgres
     * @param  String $funcionarioRealizouChamada String formada pelo LOGIN-PSEUDONIMO do agente
     * @param  String $telefone                   Telefone do cliente a qual está sendo classificada
     * @param  String $qualificacao               Qualificação atribuida pelo agente
     * @param  String $data                       Data da classificação
     * @param  [type] $observacao                 [description]
     * @return [type]                             [description]
     */
    function inserirChamadaClassificada($funcionarioRealizouChamada, $telefone, $qualificacao, $data, $observacao, $idVendedor, $idCliente){
        $sql = "INSERT INTO vm50_chamadas_classificadas (atendente, telefone, classificacao, data, observacao, id_vendedor, id_cliente) VALUES ('".$funcionarioRealizouChamada."', '".$telefone."', '".$qualificacao."', '".$data."', '".$observacao."', '".$idVendedor."', '".$idCliente."')";
        $res = $this->Bd->executa_query_sem_saida($sql);
        return $res;
    }

    function inserirClienteJson($nome, $documento, $fone1, $fone2, $fone3, $contato, $id_vendedor){
        $dia = date("d");
        $mes = date("m");
        $ano = date("Y");
        
        if(!file_exists($this->DirRaiz."Relatorios/Sistema/Clientes-cadastrados/".$ano."/".$mes."/".$dia)) {
            mkdir($this->DirRaiz."Relatorios/Sistema/Clientes-cadastrados/".$ano."/".$mes."/".$dia, 0777, true);
            $fp = fopen($this->DirRaiz."Relatorios/Sistema/Clientes-cadastrados/".$ano."/".$mes."/".$dia."/clientes_cadastrados.json", "x");
            $array = array("nome" => $nome, "documento" => $documento, "fone1" => $fone1, "fone2" => $fone2, "fone3" => $fone3, "contato" => $contato, "id_vendedor" => $id_vendedor);
            fwrite($fp, "[".json_encode($array)."]");
            fclose($fp);
        } else {
            $file = file_get_contents($this->DirRaiz."Relatorios/Sistema/Clientes-cadastrados/".$ano."/".$mes."/".$dia."/clientes_cadastrados.json");
            $dados = json_decode($file);
            $dados[] = array("nome" => $nome, "documento" => $documento, "fone1" => $fone1, "fone2" => $fone2, "fone3" => $fone3, "contato" => $contato, "id_vendedor" => $id_vendedor);
            unlink($this->DirRaiz."Relatorios/Sistema/Clientes-cadastrados/".$ano."/".$mes."/".$dia."/clientes_cadastrados.json");
            $fp = fopen($this->DirRaiz."Relatorios/Sistema/Clientes-cadastrados/".$ano."/".$mes."/".$dia."/clientes_cadastrados.json", "x");
            fwrite($fp, json_encode($dados));
            fclose($fp);
        }
        return true;
    }
}
?>
