<?php
/**************************************************************
 * Nome:    Contact Center
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-01-25 (V1.0.1)
 * Descr.:  Gera as variaveis argumento que compoem as telas de
 *          Contact Center. 
 *************************************************************/
  //ini_set("display_errors",1);

/**************************************************************
  Area dos includes
 *************************************************************/
$DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
include_once($DirRaiz.'config.php');
include_once($DirRaiz.'config.vdt.php');
include_once($DirRaiz.$DirModul.'sessao.modu.php');
include_once($DirRaiz.$DirModul.'geral.modu.php');
include_once($DirRaiz.$DirCrm.$DirClass.'crm.class.php');

$Crm = new Crm();

//$_SESSION['Debug'] = "TESTE";

/**************************************************************
  Nao deixa a pagina ser chamada diretamente. Tem que ter uma
  sessao aberta.
 *************************************************************/
 verifica_sessao();
 
 
function carregarVendedores($tipo){
	global $Crm;
	$vendedores = $Crm->carregarVendedores();
    
	if($tipo == "href"){
        foreach($vendedores as $chave => $valor){
            $id = $valor["id"];
            $saida .= '<a href="#" class="listagem" onclick="mostrarVendedor(\''.$id.'\');">'.$valor["nome_completo"].'</a><br/>';
            foreach($valor as $chaveA => $valorA){
                $saida .= '<input type="hidden" id="'.$chaveA.'_'.$id.'" value="'.$valorA.'">';
            }
        }
	} else if($tipo == "select"){
        foreach($vendedores as $chave => $valor){
            $id = $valor["id"];
            $saida .= '<option value="'.$id.'">'.$valor['nome_completo'].'</option>';
        }
    }

	return $saida;
}

function carregarVendedorPorId($tipo, $id){
    global $Crm;
    $vendedor = $Crm->carregarVendedorPorId($id);
    if($tipo == "json"){
        $saida = json_encode($vendedor[0]);
    } else if($tipo == "array"){
        $saida = $vendedor[0];
    }
    return $saida;
}

function carregarVendedorPorLogin($login){
    global $Crm;
    $vendedor = $Crm->carregarVendedorPorLogin($login);
    return $vendedor;
}

function alterarVendedor($dados){
    global $Crm;
    if($dados["nome_completo"] == "" || $dados["identif"] == "") return false;
    return $Crm->alterarVendedor($dados["identif"], $dados["nome_completo"], $dados["nome_abreviado"], $dados["tipo_cliente"], $dados["login"], $dados["pseudonimo"], $dados["id_campanha"]);
}

function inserirVendedor($dados){
    global $Crm;
    if($dados["nome_completo"] == "") return false;
    return $Crm->inserirVendedor($dados["nome_completo"], $dados["nome_abreviado"], $dados["tipo_cliente"]);
}

function deletarVendedor($dados){
    global $Crm;
    if($dados["identif"] == "") return false;
    return $Crm->deletarVendedor($dados["identif"]);
}

function carregarClientes($tipo, $inicio="", $fim=""){
    global $Crm;
    
    $dados = $Crm->carregarClientes($inicio, $fim);
    if($tipo == "href"){
        foreach($dados as $chave => $valor){
            $id = $valor["id"];
            if(strlen($valor["nome"]) > 26) $nome = substr($valor["nome"], 0, 26)."...";
            else $nome = $valor["nome"];
            $saida .= '<a href="#" class="listagem" onclick="mostrarCliente(\''.$id.'\');">'.$nome.'</a><br/>';
        }
    }

    return $saida;
}

function carregarClientePorId($tipo="json", $id){
    global $Crm;

    $dados = $Crm->carregarClientePorId($id);
    return json_encode($dados[0]);
}

function carregarClientePorTelefone($telefone){
    global $Crm;

    $dados = $Crm->carregarClientePorTelefone($telefone);
    return $dados;
}

function carregarClientePorDocumento($tipo, $documento){
    global $Crm;

    $dados = $Crm->carregarClientePorDocumento($documento);
    if($tipo == "array"){
        $saida = $dados[0];
    } else if($tipo == "json"){
        $saida = json_encode($dados[0]);
    }
    return $saida;
}

function carregarClientePorNome($nome){
    global $Crm;

    $dados = $Crm->carregarClientePorNome($nome);
    return $dados;
}

function alterarCliente($dados){
    global $Crm;

    //Valida as informações vindas da tela para enviar para o banco de dados corretamente
    if($dados["identif"] == "") return false;
    if(isset($dados["aceita_contato"])) $dados["aceita_contato"] = 1;
    else $dados["aceita_contato"] = 0;
    if(isset($dados["status"])) $dados["status"] = 1;
    else $dados["status"] = 0;
    if($dados["limite_credito"] == "") $dados["limite_credito"] = 0;
    $dados["data_cadastro"] = substr($dados["data_cadastro"], 6, 4)."-".substr($dados["data_cadastro"], 3, 2)."-".substr($dados["data_cadastro"], 0, 2);
    if($dados["vendaMesAtual"] == "") $dados["vendaMesAtual"] = 0;
    if($dados["vendaUlt3Meses"] == "") $dados["vendaUlt3Meses"] = 0;
    if($dados["vendaUlt12Meses"] == "") $dados["vendaUlt12Meses"] = 0;
    if($dados["vendaMargem"] == "") $dados["vendaMargem"] = 0;
    if($dados["credito"] == "") $dados["credito"] = 0;
    if($dados["id_vendedor"] == "") $dados["id_vendedor"] = 0;

    return $Crm->alterarCliente($dados["identif"], $dados["nome"], $dados["tipo"], $dados["documento"], $dados["limite_credito"], $dados["endereco"], $dados["bairro"], $dados["cidade"], $dados["uf"], $dados["cep"], $dados["cnae"], $dados["fone1"], $dados["fone2"], $dados["fone3"], $dados["contato"], $dados["aceita_contato"], $dados["sexo"], $dados["status"], $dados["data_cadastro"], $dados["codSegmento"], $dados["codBalcaoSegmento"], $dados["codOficinaSegmento"], $dados["codServicoSegmento"], $dados["codVendaSegmento"], $dados["vendaMesAtual"], $dados["vendaUlt3Meses"], $dados["vendaUlt12Meses"], $dados["vendaMargem"], $dados["credito"], $dados["id_vendedor"]);
}

function alterarClienteScreenPopup($id, $nome, $documento, $fone1, $fone2, $fone3, $contato){
    global $Crm;
    
    if($id == "") return false;
    return $Crm->alterarClienteScreenPopup($id, $nome, $documento, $fone1, $fone2, $fone3, $contato);
}

function inserirCliente($dados){
    global $Crm;

    //Valida as informações vindas da tela para enviar para o banco de dados corretamente
    if(isset($dados["aceita_contato"])) $dados["aceita_contato"] = 1;
    else $dados["aceita_contato"] = 0;
    if(isset($dados["status"])) $dados["status"] = 1;
    else $dados["status"] = 0;
    if($dados["limite_credito"] == "") $dados["limite_credito"] = 0;
    if(!isset($dados["cep"])) $dados["cep"] = 0;
    if(!isset($dados["data_cadastro"])) $dados["data_cadastro"] = date("Y-m-d");
    else $dados["data_cadastro"] = substr($dados["data_cadastro"], 6, 4)."-".substr($dados["data_cadastro"], 3, 2)."-".substr($dados["data_cadastro"], 0, 2);
    if(!isset($dados["codSegmento"])) $dados["codSegmento"] = 0;
    if(!isset($dados["codBalcaoSegmento"])) $dados["codBalcaoSegmento"] = 0;
    if(!isset($dados["codOficinaSegmento"])) $dados["codOficinaSegmento"] = 0;
    if(!isset($dados["codServicoSegmento"])) $dados["codServicoSegmento"] = 0;
    if(!isset($dados["codVendaSegmento"])) $dados["codVendaSegmento"] = 0;
    if($dados["vendaMesAtual"] == "") $dados["vendaMesAtual"] = 0;
    if($dados["vendaUlt3Meses"] == "") $dados["vendaUlt3Meses"] = 0;
    if($dados["vendaUlt12Meses"] == "") $dados["vendaUlt12Meses"] = 0;
    if($dados["vendaMargem"] == "") $dados["vendaMargem"] = 0;
    if($dados["credito"] == "") $dados["credito"] = 0;
    if($dados["id_vendedor"] == "") $dados["id_vendedor"] = 0;

    $saida = $Crm->inserirCliente($dados["nome"], $dados["tipo"], $dados["documento"], $dados["limite_credito"], $dados["endereco"], $dados["bairro"], $dados["cidade"], $dados["uf"], $dados["cep"], $dados["cnae"], $dados["fone1"], $dados["fone2"], $dados["fone3"], $dados["contato"], $dados["aceita_contato"], $dados["sexo"], $dados["status"], $dados["data_cadastro"], $dados["codSegmento"], $dados["codBalcaoSegmento"], $dados["codOficinaSegmento"], $dados["codServicoSegmento"], $dados["codVendaSegmento"], $dados["vendaMesAtual"], $dados["vendaUlt3Meses"], $dados["vendaUlt12Meses"], $dados["vendaMargem"], $dados["credito"], $dados["id_vendedor"]);
    if($saida) $saida = $Crm->inserirClienteJson($dados["nome"], $dados["documento"], $dados["fone1"], $dados["fone2"], $dados["fone3"], $dados["contato"], $dados["id_vendedor"]);

    return $saida;
}

function deletarCliente($dados){
    global $Crm;

    //Valida as informações vindas da tela para enviar para o banco de dados corretamente
    if($dados["identif"] == "") return false;
    return $Crm->deletarCliente($dados["identif"]);
}

function inserirCampanha($dados){
    global $Crm;

    //Valida as informações vindas da tela para enviar para o banco de dados
    if($dados["nome"] == "") return false;
    return $Crm->inserirCampanha($dados["nome"]);
}

function alterarCampanha($dados){
    global $Crm;

    //Valida as informações vindas da tela para enviar para o banco de dados
    if($dados["identif"] == "") return false;
    if($dados["nome"] == "") return false;
    return $Crm->alterarCampanha($dados["identif"], $dados["nome"]);
}

function deletarCampanha($dados){
    global $Crm;

    //Valida as informações vindas da tela para enviar para o banco de dados
    if($dados["identif"] == "") return false;
    return $Crm->deletarCampanha($dados["identif"]);
}

function carregarCampanhas($tipo){
    global $Crm;

    $campanhas = $Crm->carregarCampanhas();
    if($tipo == "href"){
        foreach($campanhas as $chave => $valor){
            $id = $valor["id"];
            $saida .= '<a href="#" class="listagem" onclick="mostrarCampanha(\''.$id.'\');">'.$valor["nome"].'</a><br/>';
            foreach($valor as $chaveA => $valorA){
                $saida .= '<input type="hidden" id="'.$chaveA.'_'.$id.'" value="'.$valorA.'">';
            }
        }
    } else if($tipo == "option"){
        foreach($campanhas as $chave => $valor){
            $id = $valor["id"];
            $saida .= '<option value="'.$id.'">'.$valor["nome"].'</option>';
        }
    }
    return $saida;
}

function inserirChamadaClassificada($dados){
    global $Crm;

    if(!isset($dados["funcionarioRealizouChamada"])) return false;
    if(!isset($dados["telefone"])) return false;
    if(!isset($dados["qualificacao"])) return false;
    if(!isset($dados["data"])) return false;
    if(!isset($dados["observacao"])) return false;

    $res = $Crm->inserirChamadaClassificada($dados["funcionarioRealizouChamada"], $dados["telefone"], $dados["qualificacao"], $dados["data"], $dados["observacao"], $dados["idVendedor"], $dados["idCliente"]);
    $result = "";
    /*if($res){
    	$data["empresa"] = 3078;
    	$data["senha"] = "flr123852";
    	$data["funcionario"] = str_pad($dados["idVendedor"], 5, "0", STR_PAD_LEFT);
    	$data["cliente"] = str_pad($dados["idCliente"], 14, "0", STR_PAD_LEFT);
    	$data["qualificacao"] = $dados["qualificacao"];
    	$data["descricao"] = $dados["observacao"];
    	$json = json_encode($data);
    	
        $ch = curl_multi_init();
		$ch1 = curl_init('http://isvendas.lumetec.com.br/intelligentsales/rest/wsqualify/post');
		curl_setopt($ch1, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($ch1, CURLOPT_POSTFIELDS, $json);
		curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch1, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: '.strlen($json))
		);

        curl_multi_add_handle($ch, $ch1);

        $mres = curl_multi_exec($ch, $active);
    }*/
    
    //$debug = date("Y-m-d H:i:s")." - ".$json."\n".$result."\n\n";
    //debug($debug);
    //if($result == "Cadastro realizado com sucesso.") return true;
    //else return false;
    return $res;
}

function debug($text){
	$file = fopen("/tmp/wslumetec.log", "a");
    fwrite($file, $text);
    fclose($file);
}
?>
