//JavaScript

//Carrega os dados da tabela campanha
function mostrarVendedor(id)
{
    var identif = document.getElementById("identif");
    if(identif){
        identif.value = id;
    }

    var nome_compl = document.getElementById("nome_completo");
    var nome_completo = document.getElementById("nome_completo_"+id);

	if (nome_compl && nome_completo){
        nome_compl.value = nome_completo.value;
    }

    var nome_abrev = document.getElementById("nome_abreviado");
    var nome_abreviado = document.getElementById("nome_abreviado_"+id);
    
    if (nome_abrev && nome_abreviado){
        nome_abrev.value = nome_abreviado.value;
    }

    var tipo_clien = document.getElementById("tipo_cliente");
    var tipo_cliente = document.getElementById("tipo_cliente_"+id);
    
    if (tipo_clien && tipo_cliente){
        tipo_clien.value = tipo_cliente.value;
    }

    var logi = document.getElementById("login");
    var login = document.getElementById("login_"+id);
    
    if (logi && login){
        logi.value = login.value;
    }

    var pseudo = document.getElementById("pseudonimo");
    var pseudonimo = document.getElementById("pseudonimo_"+id);
    
    if (pseudo && pseudonimo){
        pseudo.value = pseudonimo.value;
    }

    var id_campanh = document.getElementById("id_campanha");
    var id_campanha = document.getElementById("id_campanha_"+id);
    
    if (id_campanh && id_campanha){
        id_campanh.value = id_campanha.value;
    }
}

function carregarClientes(pag){
    var limiteSup = 30;
    var limiteInf = (30 * pag) - 30;

    var pagina = document.getElementById("paginaAjax").value;
    var Oque = "?acao=carregarClientes&limiteSup="+limiteSup+"&limiteInf="+limiteInf+"&tipo=href";
    
    var xmlHttp = GetXmlHttpObject();
    xmlHttp.onreadystatechange=function()
    {
        if(xmlHttp.readyState==4)
        {
            var resposta = xmlHttp.responseText;
            document.getElementById("listaConteudo").innerHTML = resposta;
        }
    }
    xmlHttp.open("GET",pagina+Oque,true);
    xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    //xmlHttp.setRequestHeader('Content-length', Oque.length );
    xmlHttp.setRequestHeader('encoding','ISO-8859-1');
    xmlHttp.send(null);
}

function pagAnteriorCadCli(){
    var paginaAtual = document.getElementById("paginaAtual");
    if(paginaAtual.value > 1){
        paginaAtual.value--;
        carregarClientes(paginaAtual.value);
    }
}

function proximaPagCadCli(){
    var paginaAtual = document.getElementById("paginaAtual");
    paginaAtual.value++;
    carregarClientes(paginaAtual.value);
}

function mostrarCliente(id){
    var identif = document.getElementById("identif");
    if(identif){
        identif.value = id;
    }

    var aviso = document.getElementById("aviso");
    aviso.innerHTML = "Aguarde, carregando os dados do cliente...";

    var pagina = document.getElementById("paginaAjax").value;
    var Oque = "?acao=carregarClientePorId&tipo=json&id="+id;
    
    var xmlHttp = GetXmlHttpObject();
    xmlHttp.onreadystatechange=function()
    {
        if(xmlHttp.readyState==4)
        {
            aviso.innerHTML = "";
            var resposta = xmlHttp.responseText;
            var dados = JSON.parse(resposta);
            document.getElementById("nome").value = dados.nome;
            document.getElementById("tipo").value = dados.tipo;
            document.getElementById("documento").value = dados.documento;
            document.getElementById("limite_credito").value = dados.limite_credito;
            document.getElementById("endereco").value = dados.endereco;
            document.getElementById("bairro").value = dados.bairro;
            document.getElementById("cidade").value = dados.cidade;
            document.getElementById("uf").value = dados.uf;
            document.getElementById("cep").value = dados.cep;
            document.getElementById("cnae").value = dados.cnae;
            document.getElementById("fone1").value = dados.fone1;
            document.getElementById("fone2").value = dados.fone2;
            document.getElementById("fone3").value = dados.fone3;
            document.getElementById("contato").value = dados.contato;
            if(dados.aceita_contato == "0") document.getElementById("aceita_contato").checked = false;
            else document.getElementById("aceita_contato").checked = true;
            if(dados.sexo == "M") document.getElementById("sexo").value = "M";
            else if(dados.sexo == "F") document.getElementById("sexo").value = "F";
            else document.getElementById("sexo").value = "";
            if(dados.status == "0") document.getElementById("status").checked = false;
            else document.getElementById("status").checked = true;
            var data = dados.data_cadastro.split("-");
            document.getElementById("data_cadastro").value = data[2]+"/"+data[1]+"/"+data[0];
            document.getElementById("codSegmento").value = dados.codSegmento;
            document.getElementById("codBalcaoSegmento").value = dados.codBalcaoSegmento;
            document.getElementById("codOficinaSegmento").value = dados.codOficinaSegmento;
            document.getElementById("codServicoSegmento").value = dados.codServicoSegmento;
            document.getElementById("codVendaSegmento").value = dados.codVendaSegmento;
            document.getElementById("vendaMesAtual").value = dados.vendaMesAtual;
            document.getElementById("vendaUlt3Meses").value = dados.vendaUlt3Meses;
            document.getElementById("vendaUlt12Meses").value = dados.vendaUlt12Meses;
            document.getElementById("vendaMargem").value = dados.vendaMargem;
            document.getElementById("credito").value = dados.credito;
            document.getElementById("id_vendedor").value = dados.id_vendedor;
        }
    }
    xmlHttp.open("GET",pagina+Oque,true);
    xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    //xmlHttp.setRequestHeader('Content-length', Oque.length );
    xmlHttp.setRequestHeader('encoding','ISO-8859-1');
    xmlHttp.send(null);
}

function mostrarCampanha(id){
    var identif = document.getElementById("identif");
    if(identif){
        identif.value = id;
    }

    var nom = document.getElementById("nome");
    var nome = document.getElementById("nome_"+id);

    if (nom && nome){
        nom.value = nome.value;
    }
}

function carregarPseudonimo(agente){
    var pseudo = document.getElementById('pseudo_'+agente).value;
    document.getElementById("pseudonimo").value = pseudo;
}