<?php
/**************************************************************
* Nome:    Discador
* Autor:   Renato N. Lourenç* Data:	  2013-07-13 (V1.0.1)
* Descr.:  Cria a classe de discador
*************************************************************/

/**************************************************************
Classe Monitores
*************************************************************/
class Discador {
	var $Bd;
	var $BdDiscador;	
	//---------------------------------------------------
	// Construtor da classe.
	//---------------------------------------------------
	function Discador() {
		$DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
		include($DirRaiz.'config.php');
        include($DirRaiz.'configuracoes.php');
		include_once($DirRaiz.$DirClass.'bd.class.php');
		include_once($DirRaiz.$DirClass.'discador.class.php');
		$this->Bd      = new Banco();
		if($conectar_discador) $this->BdDiscador = new BdDiscador();
	}

	function carregaGrupoPelaCampanha($campanha){
		$sql = "SELECT gdc.*, gc.prioridade AS prioridade_campanha FROM vm50_grupo_de_campanhas AS gdc INNER JOIN vm50_grupos_campanhas AS gc ON gc.fk_grupo_campanha = gdc.id WHERE gc.campanha LIKE '".$campanha."'";
		//return $sql;
		$res = $this->Bd->executa_query_com_saida($sql);
		return $res;
	}
	
	function carregaCampanhasComGrupos(){
		
		$sql = "SELECT gc.campanha FROM vm50_grupos_campanhas AS gc GROUP BY gc.campanha ORDER BY gc.campanha";
		$res = $this->Bd->executa_query_com_saida($sql);
		return $res;
	}
	
	function carregaTodosGrupos(){
		//$sql = "SELECT * FROM vm50_grupo_de_campanhas";
		$sql = "SELECT ag.* FROM vm50_arvore_grupos as ag INNER JOIN vm50_campanhas as c ON c.grupo = ag.id";
		return $this->Bd->executa_query_com_saida($sql);
	}
	
	function carregaGrupoCampanha($campanha){
		$sql = "SELECT * FROM vm50_grupos_campanhas WHERE campanha LIKE '".$campanha."'";
		$res = $this->Bd->executa_query_com_saida($sql);
		return $res;
	}
	
	function carregaCampanhasPeloGrupo($grupo){
		$sql = "SELECT * FROM vm50_campanhas WHERE grupo = ".$grupo;
		$res = $this->Bd->executa_query_com_saida($sql);
		return $res;
	}

	function alterarGrupoCampanha($id, $grupo, $prioridade){
		$sql = "UPDATE vm50_arvore_grupos SET nome = '".$grupo."', prioridade='".$prioridade."' WHERE id=".$id;
		return $this->Bd->executa_query_sem_saida($sql);
	}
	
	function alterarDetalhesCampanha($idGrupo, $campanha, $prioridade){
		$sql = "SELECT id FROM vm50_grupos_campanhas WHERE prioridade=".$prioridade." AND fk_grupo_campanha = ".$idGrupo;
		$res = $this->Bd->executa_query_com_saida($sql);
		if(count($res) == 0){
			$sql = "UPDATE vm50_grupos_campanhas SET prioridade=".$prioridade." WHERE fk_grupo_campanha=".$idGrupo." AND campanha='".$campanha."'";
			//return $sql;
			$res = $this->Bd->executa_query_com_saida($sql);
			return true;
		} else {
			return false;
		}
	}
	
	function addCampanhaAoGrupo($idGrupo, $campanha){
		$sql = "INSERT INTO vm50_grupos_campanhas (fk_grupo_campanha, campanha) VALUES (".$idGrupo.", '".$campanha."')";
		return $this->Bd->executa_query_sem_saida($sql);
	}
	
	function removeCampanhaDoGrupo($idGrupo, $campanha){
		$sql = "DELETE FROM vm50_grupos_campanhas WHERE fk_grupo_campanha = ".$idGrupo." AND campanha LIKE '".$campanha."'";
		return $this->Bd->executa_query_sem_saida($sql);
	}
	
	function inserirGrupoCampanha($grupo, $prioridade){
		$sql = "INSERT INTO vm50_arvore_grupos (nome, prioridade) VALUES ('".$grupo."', ".$prioridade.")";
		return $this->Bd->executa_query_sem_saida($sql);
	}
	
	function carrega_arvore_grupos(){
		$sql = "SELECT * FROM vm50_arvore_grupos";
		return $this->Bd->executa_query_com_saida($sql);
	}
	
	function carrega_filhos_grupo($id){
		$sql = "SELECT * FROM vm50_arvore_grupos WHERE pai = ".$id." ORDER BY id";
		return $this->Bd->executa_query_com_saida($sql);
	}
	
	function carregaGrupo($id){
		$sql = "SELECT * FROM vm50_arvore_grupos WHERE id = ".$id;
		$res = $this->Bd->executa_query_com_saida($sql);
		$sql = "SELECT nome FROM vm50_arvore_grupos WHERE pai = ".$id;
		$res1 = $this->Bd->executa_query_com_saida($sql);
		$sql = "SELECT titulo FROM vm50_campanhas WHERE grupo = ".$id;
		$res2 = $this->Bd->executa_query_com_saida($sql);
		return array($res, $res1, $res2);
	}
	
	function carrega_filhos_grupos(){
		$sql = "SELECT * FROM vm50_arvore_grupos WHERE pai != 0 ORDER BY id";
		return $this->Bd->executa_query_com_saida($sql);
	}
	
	function removeFilhoGrupo($id){
		$sql = "DELETE FROM vm50_arvore_grupos WHERE id = ".$id;
		$this->Bd->executa_query_sem_saida($sql);
		$sql = "DELETE FROM vm50_campanhas WHERE grupo = ".$id;
		return $this->Bd->executa_query_sem_saida($sql);
	}
	
	function addFilhoGrupo($idGrupo, $subgrupo, $prioridade, $tipo){
		$sql = "INSERT INTO vm50_arvore_grupos (nome, pai, prioridade, tipo) VALUES ('".$subgrupo."',".$idGrupo.", ".$prioridade.", '".$tipo."')";
		return $this->Bd->executa_query_sem_saida($sql);
	}
	
	function carregaCampanhasGrupo($id){
		$sql = "SELECT * FROM vm50_campanhas";
		return $this->Bd->executa_query_com_saida($sql);
	}
	
	function carregaCampanhasGrupoPorId($id){
		$sql = "SELECT * FROM vm50_campanhas WHERE grupo = ".$id." ORDER BY titulo";
		return $this->Bd->executa_query_com_saida($sql);
	}
	
	function addCampanhaGrupo($id, $campanha){
		$sql = "INSERT INTO vm50_campanhas (titulo, grupo) VALUES ('".$campanha."', ".$id.")";
		return $this->Bd->executa_query_sem_saida($sql);
	}
	
	function carregaPrioridadeCampanha($campanha){
		$sql = "SELECT prioridade FROM vm50_campanhas WHERE titulo like '".$campanha."'";
		$out = $this->Bd->executa_query_com_saida($sql);
		return $out[0]['prioridade'];
	}
	
	function alterarPrioridadeCamp($campanha, $prioridade){
		$sql = "UPDATE vm50_campanhas SET prioridade = ".$prioridade." WHERE titulo like '".$campanha."'";
		return $this->Bd->executa_query_sem_saida($sql);
	}
	
	function carregaPrioridadeGrupo($grupo){
		$sql = "SELECT prioridade, tipo FROM vm50_arvore_grupos WHERE id = ".$grupo;
		return $this->Bd->executa_query_com_saida($sql);
	}
	
	function alterarTipoGrupo($grupo, $tipo){
		$sql = "UPDATE vm50_arvore_grupos SET tipo = '".$tipo."' WHERE id = '".$grupo."'";
		return $this->Bd->executa_query_sem_saida($sql);
	}
	
	function verificaEventoValido($evento, $campanha){
		//$sql = "select * from cancel where cancel_type_id=(select id from cancel_type where name='url-reg') and campaign_id IN ( (select id from campaign where name='ANY'), (select id from campaign where name='".$campanha."') ) and reason=2 and customer_id=(select id from customer where code='".$evento."') LIMIT 1;";
		$sql = "SELECT * FROM cancel WHERE reason = 2 AND customer_id = (select id from customer where code='".$evento."')";
		$res = $this->BdDiscador->executa_query_com_saida($sql);
		if(count($res) > 0) return false;
		else return true;
	}

	function carrega_tabela_acao($tipoCamp=""){
		if($tipoCamp == "Pesquisa") $sql = "SELECT * FROM acao where visible = 1 and campanha like 'PSQ%'";
		else if($tipoCamp == "Agendamento") $sql = "SELECT * FROM acao where visible = 1 and campanha like 'REV%'";
		else $sql = "SELECT * FROM acao where visible = 1";
		return $this->BdDiscador->executa_query_com_saida($sql);
	}
	
	function carrega_tabela_acao_simplificada(){
		$sql = "SELECT id, status FROM acao where visible = 1";
		return $this->BdDiscador->executa_query_com_saida($sql);
	}

	function alteraStatusCampanha($campanha, $status){
		$sql = "UPDATE acao SET status = ".$status." WHERE id = ".$campanha;
		return $this->BdDiscador->executa_query_sem_saida($sql);
	}
	
	function deletarCampanhaDiscador($campanha){
		$sql = "DELETE FROM acao WHERE id = ".$campanha;
		return $this->BdDiscador->executa_query_sem_saida($sql);
	}
	
	function verificaEventoReagendado($evento){
		//$sql = "select * from chamada where ts > ".time()." and extra = ".$evento." limit 1";
        /*$sql = "select * from chamada where extra=".$evento." and status=0";
        $evento =  $this->BdDiscador->executa_query_com_saida($sql);
        if(count($evento) > 0) return true;
        else return false;*/
		return false;
	}
	
	function carregaIdGrupoPorNome($nome){
		$sql = "SELECT id FROM vm50_arvore_grupos WHERE nome LIKE '".$nome."'";
		return $this->Bd->executa_query_com_saida($sql);
	}
}
?>
