<?php
/**************************************************************
 * Nome:    Contact Center
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-01-25 (V1.0.1)
 * Descr.:  Gera as variaveis argumento que compoem as telas de
 *          Contact Center. 
 *************************************************************/
  //ini_set("display_errors",1);


/**************************************************************
  Area dos includes
 *************************************************************/
 $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
 include_once($DirRaiz.'config.php');
 include_once($DirRaiz.'config.vdt.php');
 include_once($DirRaiz.$DirModul.'sessao.modu.php');
 include_once($DirRaiz.$DirModul.'geral.modu.php');
 include_once($DirRaiz.$DirJSON.'JSON.php');
 include_once($DirRaiz.$DirDiscador.$DirClass.'discador.class.php');  
 
 $json = new Services_JSON();
 $Discador = new Discador();
//$_SESSION['Debug'] = "TESTE";
/**************************************************************
  Nao deixa a pagina ser chamada diretamente. Tem que ter uma
  sessao aberta.
 *************************************************************/
 verifica_sessao();
 
 
function carregaCampanhas($enderecoApi, $tipo){
	global $json;
	//Faz o request do tipo get para pegar as campanhas da api
	$curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $enderecoApi."/discador/parametro/campanhas/conf");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HTTPGET, true);
    $result = curl_exec($curl);
    curl_close($curl);
	
	$dados = json_decode($result);
	
	foreach($dados as $chaveA => $valorA){
		if($chaveA != "group"){
		//$_SESSION['Debug'] .= print_r($valorA, true)."</br>";
			foreach($valorA as $chaveB => $valorB){
				if($chaveB != "group"){
					foreach($valorB as $chaveC => $valorC){
						$saida[$chaveB][$chaveC] = $valorC;
					}
				}
			}
		}
	}
	ksort($saida);
	if($tipo == "json"){
		$i = 0;
		$Campanhas = $saida;
		$tot = count($Campanhas);
		$CampanhasJson = array();
		foreach($Campanhas as $chaveA => $valorA){
			$CampanhasJsonA['id'] = $chaveA;
			$CampanhasJsonA['nome'] = $chaveA;
			foreach($valorA as $chaveB => $valorB){
				$CampanhasJsonA[$chaveB] = $valorB;
			}
			array_push($CampanhasJson, $CampanhasJsonA);
			$i++;
		}
		$retornoJson = json_encode($CampanhasJson);
		$Saida = $retornoJson;
	}
	
	if($tipo == "select"){
		$i = 0;
		$Campanhas = $saida;
		$CampanhasJson = array();
		foreach($Campanhas as $chaveA => $valorA){
			$CampanhasJson[$i]['id'] = $chaveA;
			$CampanhasJson[$i]['nome'] = $chaveA;
			$i++;
		}
		$retornoJson = $json->encode($CampanhasJson);
		$Saida = $retornoJson;
	}
	
	if($tipo == "href"){
		$i = 0;
		$Campanhas = $saida;
		$CampanhasString = "";
		foreach($Campanhas as $chave => $valor){
				$CampanhasString .= '<a href="#" onclick="mostrar_grupo_campanha(\''.$chave.'\');">'.$chave.'</a><br/>';
		}
		$Saida = $CampanhasString;
	}
	
	if($tipo == "href2"){
		$i = 0;
		$Campanhas = $saida;
		$CampanhasString = "";
		foreach($Campanhas as $chave => $valor){
				$CampanhasString .= '<a href="#" onclick="mostrar_agenda_campanha(\''.$chave.'\');">'.$chave.'</a><br/>';
		}
		$Saida = $CampanhasString;
	}
	
	if($tipo == "array"){
		$Saida = $saida;
	}
	
	if($tipo == "option"){
		$Campanhas = $saida;
		$Saida .= '<option value="-">&nbsp;</option>';
		foreach($Campanhas as $chave => $valor){
			$Saida .= '<option value="'.$chave.'">'.$chave.'</option>';
		}
	}
	//$_SESSION['Debug'] = print_r($Saida, true);
	
	return $Saida;
}

function carregaPrioridades($enderecoApi, $tipo){
    global $json, $Discador;
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $enderecoApi."/discador/parametro/campanhas/conf");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HTTPGET, true);
    $result = curl_exec($curl);
    curl_close($curl);

    //Começa a tratar os dados para retornar e mostrar na tabela
    $dados = $json->decode($result);

    foreach($dados as $chaveA => $valorA){
        foreach($valorA as $chaveB => $valorB){
            if($valorB != "group"){
                foreach($valorB as $chaveC => $valorC){
                    $saida[$chaveB][$chaveC] = $valorC;
                }
            }
        }
    }
    $campanhas = array();
    $prioridades = array();
    $c = 0;
    foreach($saida as $chave => $valor){
        $campanhas[] = $chave;
        $prioridades[] = $c;
	$c++;
    }

    $campanhasBanco = $Discador->carregaGruposCampanhas();
    //return print_r($campanhasBanco, true);

    for($i = 0; $i < count($campanhasBanco); $i++){
        $prioridades[$campanhasBanco[$i]['prioridade']] = '-';
    }
    return $prioridades;
    $Saida = '<option value="-"> - </option>';
    for($i = 0; $i < count($prioridades); $i++){
        if($prioridades[$i]!='-') $Saida .= '<option value="'.$prioridades[$i].'">'.$prioridades[$i].'</option>';
    }
    return $Saida;
}

function salvaCampanha($enderecoApi, $json){
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $enderecoApi."/discador/parametro/campanhas/conf"); 
	curl_setopt($ch, CURLOPT_POST, true); 
	curl_setopt($ch, CURLOPT_POSTFIELDS, $json); 
	 
	$result = curl_exec($ch); 
	curl_close($ch);
}

function deletaCampanha($enderecoApi, $idCampanha){
	$curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $enderecoApi."/discador/parametro/campanhas/".$idCampanha);
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($curl, CURLOPT_HEADER, 0); 
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "DELETE");
    $response = curl_exec($curl);
    curl_close($curl);
}

function carregaDiscador($enderecoApi, $tipo, $orderBy="campanha", $pagina="1", $filtroGrupo="-", $buscaEstatisticas="0", $tipoCamp=""){
	global $json, $LinkRaiz, $DirImage;
	$dados = carrega_tabela_acao($tipoCamp);
	$Saida = "";
	
	//Começa a tratar os dados para retornar e mostrar na tabela
	if($tipo == "gerenciamento"){
		$i = 0;
		$Discador = $dados;
		$status = 0;
		$Dados = array();
		$excluir = '';
		if($orderBy == "campanha") {
			$orderByCamp = '<a href="#null"><img src="'.$LinkRaiz.$DirImage.'dataTable/sort_asc.png"/></a>';
			$orderByStat = '<a href="#null" onclick="orderBy(\'status\')"><img src="'.$LinkRaiz.$DirImage.'dataTable/sort_both.png"/></a>';
			$orderByData = '<a href="#null" onclick="orderBy(\'data\')"><img src="'.$LinkRaiz.$DirImage.'dataTable/sort_both.png"/></a>';
		}
		if($orderBy == "status") {
			$orderByCamp = '<a href="#null" onclick="orderBy(\'campanha\')"><img src="'.$LinkRaiz.$DirImage.'dataTable/sort_both.png"/></a>';
			$orderByStat = '<a href="#null"><img src="'.$LinkRaiz.$DirImage.'dataTable/sort_asc.png"/></a>';
			$orderByData = '<a href="#null" onclick="orderBy(\'data\')"><img src="'.$LinkRaiz.$DirImage.'dataTable/sort_both.png"/></a>';
		}
		if($orderBy == "data") {
			$orderByCamp = '<a href="#null" onclick="orderBy(\'campanha\')"><img src="'.$LinkRaiz.$DirImage.'dataTable/sort_both.png" /></a>';
			$orderByStat = '<a href="#null" onclick="orderBy(\'status\')"><img src="'.$LinkRaiz.$DirImage.'dataTable/sort_both.png"/></a>';
			$orderByData = '<a href="#null"><img src="'.$LinkRaiz.$DirImage.'dataTable/sort_asc.png"/></a>';
		}
		$Saida .= '<table class="list" style="width:960px;">'."\n";
		$Saida .= '<tr>'."\n";
		$Saida .= '<td class="listT" style="font-size:8pt;">A&ccedil;&atilde;o</td>'."\n";
		$Saida .= '<td class="listT" style="font-size:8pt;">Campanha'.$orderByCamp.'</td>'."\n";
		$Saida .= '<td class="listT" style="font-size:8pt;">Status'.$orderByStat.'</td>'."\n";
		$Saida .= '<td class="listT" style="font-size:8pt;">Data'.$orderByData.'</td>'."\n";
		$Saida .= '<td class="listT" style="background-color:#ff3d3d;"><span class="list" style="font-size:8pt;" title="Total de telefones no mailing">Telef.</span></td>'."\n";
		$Saida .= '<td class="listT" style="background-color:#ff3d3d;"><span class="list" style="font-size:8pt;" title="Total de eventos no mailing">Evt.</span></td>'."\n";
		$Saida .= '<td class="listT" style="background-color:#ff3d3d;"><span class="list" style="font-size:8pt;" title="Total de eventos a processar">A proc.</span></td>'."\n";
		$Saida .= '<td class="listT" style="background-color:#ff9215;"><span class="list" style="font-size:8pt;" title="Eventos a processar via mailing">Mail</span></td>'."\n";
		$Saida .= '<td class="listT"><span class="list" style="font-size:8pt;" title="Eventos a processar via reagendamentos">Reag.</span></td>'."\n";
		$Saida .= '<td class="listT"><span class="list" style="font-size:8pt;" title="Porcentagem total de eventos a processar">% a proc.</span></td>'."\n";
		$Saida .= '<td class="listT" style="background-color:#ff9215;"><span class="list" style="font-size:8pt;" title="Porcentagem de eventos a processar via mailing">% Mail</span></td>'."\n";
		$Saida .= '<td class="listT"><span class="list" style="font-size:8pt;" title="Porcentagem de eventos a processar via reagendamentos">% Reag.</span></td>'."\n";
		$Saida .= '<td class="listT"><span class="list" style="font-size:8pt;" title="Total de telefones a processar via mailing">Telef. Mail.</span></td>'."\n";
		$Saida .= '<td class="listT"><span class="list" style="font-size:8pt;" title="Total de telefones a processar via reagendamentos">Telef. Reag.</span></td>'."\n";
		$Saida .= '<td class="listT"><span class="list" style="font-size:8pt;" title="Excluir o mailing">Excluir</span></td>'."\n";
		$Saida .= '</tr>'."\n";
		for($i = 0; $i < count($Discador); $i++){
			$Dados = $Discador[$i];
			
			$status = "";
			$acao = "";
			$excluir = "";
			
			$data = timestamp_para_humano($Dados['timestamp']);
			switch($Dados['status']){
				case 0: $acao = '<span class="botaoDisc" style="cursor:pointer;" onclick="processarCampanha(\''.$Dados['id'].'\');">Processar</span> <span class="botaoDisc" style="cursor:pointer;" onclick="pausarCampanha(\''.$Dados['id'].'\');">Pausar</span> <span class="botaoDisc" style="cursor:pointer;" onclick="pararCampanha(\''.$Dados['id'].'\');">Parar</span>';
					$status = "Pendente";
				break;
				case 1: $acao = '<span class="botaoDisc" style="cursor:pointer;" onclick="pausarCampanha(\''.$Dados['id'].'\',\'\',this);">Pausar</span> <span class="botaoDisc"  style="cursor:pointer;" onclick="pararCampanha(\''.$Dados['id'].'\',\'\',this);">Parar</span>';
					$status = "Processando";
				break;
				case 2: $acao = '<span class="botaoDisc" style="cursor:pointer;" onclick="processarCampanha(\''.$Dados['id'].'\',\'\',this);">Processar</span>';
					$excluir = '<span class="botaoDisc" style="cursor:pointer;" onclick="esconderCampanha(\''.$Dados['id'].'\');">Excluir</span>';
					$status = "Pausado";
				break;
				case 3: $acao = '<span class="botaoDisc" style="cursor:pointer;" onclick="processarCampanha(\''.$Dados['id'].'\',\'\',this);">Processar</span>';
					$excluir = '<span class="botaoDisc" style="cursor:pointer;" onclick="esconderCampanha(\''.$Dados['id'].'\');">Excluir</span>';
					$status = "Parado";
				break;
				case 4: $status = "Pendente";
				break;
				case 8: $status = "Cancelado";
				break;
				case 9: $acao = '<span class="botaoDisc" style="cursor:pointer;" onclick="reiniciarCampanha(\''.$Dados['id'].'\');">Reiniciar</span>';
					$excluir = '<span class="botaoDisc" style="cursor:pointer;" onclick="esconderCampanha(\''.$Dados['id'].'\');">Excluir</span>';
					$status = "Finalizado";
				break;
			}
			$dataAux = explode(" ", $data);
			$Dados['data'] = $dataAux[0]."<br/>".$dataAux[1];
			$Dados['acao'] = $acao;
			$Dados['excluir'] = $excluir;
			$Dados['status'] = $status;
			if($orderBy=="data") $Sort[$Dados['timestamp']] = $Dados;
			else if($orderBy=="status") $Sort[$Dados['status'].$i] = $Dados;
			else $Sort[$Dados['campanha'].$i] = $Dados;
		}
		ksort($Sort);
		$cores[0] = "#A0A0A0";
		$cores[1] = "#e5e5e5";
		$cores[2] = "#fcffe0";
		$cores[3] = "#fffae0";
		$cores[4] = "#e0ffe7";
		if($filtroGrupo!="-") $idGrupo = $filtroGrupo;
		else $idGrupo = 0;
		list($campanhasPorGrupos) = carrega_campanhas_em_grupos($idGrupo, array(), "");
		foreach($campanhasPorGrupos as $chaveA => $valorA){
			$indices = explode("|", $chaveA);
			for($i = 0; $i < count($indices); $i++){
				$montado = false;
				if($i == count($indices)-1){
					$SaidaAux = "";
					for($j = 0; $j < count($valorA); $j++){
						foreach($Sort as $chaveB => $valorB){
							if($valorB["campanha"] == $valorA[$j]){
								$montado = true;
                                $SaidaAux .= '<tr>'."\n";
                                $SaidaAux .= '<td class="list" style="padding:5px;"><span id="acao_'.$valorB['id'].'">'.$valorB['acao'].'</span></td>'."\n";
                                $SaidaAux .= '<td class="list"><a style="font-size:8pt;" href="'.$LinkRaiz.'discador/index.php?pagina=relatmembros.tela.php&fila='.$valorB['campanha'].'" target="_blank">'.$valorB['campanha'].'</a></td>'."\n";
                                $SaidaAux .= '<td class="list" style="font-size:8pt;"><span style="font-size:8pt;" id="status_'.$valorB['id'].'">'.$valorB['status'].'</span></td>'."\n";
                                $SaidaAux .= '<td class="list" style="font-size:8pt;">'.$valorB['data'].'</td>'."\n";
                                $SaidaAux .= '<td class="list" style="font-size:8pt; background-color:#ff3d3d;" title="Total de telefones no mailing">'.$valorB['eom'].'</td>'."\n";
                                $SaidaAux .= '<td class="list" style="font-size:8pt; background-color:#ff3d3d;" title="Total de eventos enviados no mailing"><span id="evt_'.$valorB['id'].'"></span></td>'."\n";
								$SaidaAux .= '<td class="list" style="font-size:8pt; background-color:#ff3d3d;" title="Eventos a processar via reagendamentos"><span id="aproc_'.$valorB['id'].'"></span></td>'."\n";
                                $SaidaAux .= '<td class="list" style="font-size:8pt; background-color:#ff9215;" title="Eventos a processar via mailing"><span id="mail_'.$valorB['id'].'"></span></td>'."\n";
                                $SaidaAux .= '<td class="list" style="font-size:8pt;" title="Eventos a processar via reagendamentos"><span id="reag_'.$valorB['id'].'"></span></td>'."\n";
								$SaidaAux .= '<td class="list" style="font-size:8pt;" title="Porcentagem total de eventos a processar"><span id="%aproc_'.$valorB['id'].'"></span></td>'."\n";
                                $SaidaAux .= '<td class="list" style="font-size:8pt; background-color:#ff9215;" title="Porcentagem de eventos a processar no mailing"><span id="%mail_'.$valorB['id'].'"></span></td>'."\n";
                                $SaidaAux .= '<td class="list" style="font-size:8pt;" title="Porcentagem de eventos a processar no reagendamento"><span id="%reag_'.$valorB['id'].'"></span></td>'."\n";
								$SaidaAux .= '<td class="list" style="font-size:8pt;" title="Total de telefones a processar via mailing"><span id="regmail_'.$valorB['id'].'"></span></td>'."\n";
                                $SaidaAux .= '<td class="list" style="font-size:8pt;" title="Total de telefones a processar reagendamentos"><span id="regreag_'.$valorB['id'].'"></span></td>'."\n";
                                $SaidaAux .= '<td class="list" style="font-size:8pt;" title="Excluir o mailing"><span id="excluir_'.$valorB['id'].'">'.$valorB['excluir'].'</span></td>'."\n";
                                $SaidaAux .= '</tr>'."\n";
							}
						}
					}
					if($montado){
						$Saida .= '<tr>'."\n";
						$Saida .= '<td class="listT" style="font-size:8pt;">A&ccedil;&atilde;o</td>'."\n";
						$Saida .= '<td class="listT" style="font-size:8pt;">Campanha</td>'."\n";
						$Saida .= '<td class="listT" style="font-size:8pt;">Status</td>'."\n";
						$Saida .= '<td class="listT" style="font-size:8pt;">Data</td>'."\n";
						$Saida .= '<td class="listT" style="background-color:#ff3d3d;"><span class="list" style="font-size:8pt;" title="Total de telefones no mailing">Telef.</span></td>'."\n";
						$Saida .= '<td class="listT" style="background-color:#ff3d3d;"><span class="list" style="font-size:8pt;" title="Total de eventos no mailing">Evt.</span></td>'."\n";
						$Saida .= '<td class="listT" style="background-color:#ff3d3d;"><span class="list" style="font-size:8pt;" title="Total de eventos a processar">A proc.</span></td>'."\n";
						$Saida .= '<td class="listT" style="background-color:#ff9215;"><span class="list" style="font-size:8pt;" title="Eventos a processar via mailing">Mail</span></td>'."\n";
						$Saida .= '<td class="listT"><span class="list" style="font-size:8pt;" title="Eventos a processar via reagendamentos">Reag.</span></td>'."\n";
						$Saida .= '<td class="listT"><span class="list" style="font-size:8pt;" title="Porcentagem total de eventos a processar">% a proc.</span></td>'."\n";
						$Saida .= '<td class="listT" style="background-color:#ff9215;"><span class="list" style="font-size:8pt;" title="Porcentagem de eventos a processar via mailing">% Mail</span></td>'."\n";
						$Saida .= '<td class="listT"><span class="list" style="font-size:8pt;" title="Porcentagem de eventos a processar via reagendamentos">% Reag.</span></td>'."\n";
						$Saida .= '<td class="listT"><span class="list" style="font-size:8pt;" title="Total de telefones a processar via mailing">Telef. Mail.</span></td>'."\n";
						$Saida .= '<td class="listT"><span class="list" style="font-size:8pt;" title="Total de telefones a processar via reagendamentos">Telef. Reag.</span></td>'."\n";
						$Saida .= '<td class="listT"><span class="list" style="font-size:8pt;" title="Excluir o mailing">Excluir</span></td>'."\n";
						$Saida .= '</tr>'."\n";
						$Saida .= $SaidaAux;
					}
				}
				if($indices[$i] != $indice[$i]){
					if($i == 0){
						$Saida .= '<tr>'."\n";
						$Saida .= '<td class="listT" colspan=15 style="{text-align:left;}">&nbsp;</td>'."\n";
						$Saida .= '</tr>'."\n";
					}
					
					if($tipoCamp=="Pesquisa"){
						//if(substr($indices[$i], 0, 8)=="PESQUISA"){
						if(substr($indices[$i], 0, 11)!="AGENDAMENTO"){
							$idGrupo = carregaIdGrupoPorNome($indices[$i]);
							$Saida .= '<tr>'."\n";
							$Saida .= '<td class="listT" colspan=15 style="{text-align:left;background-color:'.$cores[$i].';}">'.$indices[$i].' - <span id="processarGrupoCampanhas" style="cursor:pointer;" onclick="processaGrupoCampanhas('.$idGrupo.');">Processar</span> - <span id="pausarGrupoCampanhas" style="cursor:pointer;" onclick="pausaGrupoCampanhas('.$idGrupo.');">Pausar - </span><span id="pararGrupoCampanhas" style="cursor:pointer;" onclick="paraGrupoCampanhas('.$idGrupo.');">Parar</span></td>'."\n";
							$Saida .= '</tr>'."\n";
						}
					} else if($tipoCamp=="Agendamento"){
						if(substr($indices[$i], 0, 8)!="PESQUISA"){
							$idGrupo = carregaIdGrupoPorNome($indices[$i]);
							$Saida .= '<tr>'."\n";
							$Saida .= '<td class="listT" colspan=15 style="{text-align:left;background-color:'.$cores[$i].';}">'.$indices[$i].' - <span id="processarGrupoCampanhas" style="cursor:pointer;" onclick="processaGrupoCampanhas('.$idGrupo.');">Processar</span> - <span id="pausarGrupoCampanhas" style="cursor:pointer;" onclick="pausaGrupoCampanhas('.$idGrupo.');">Pausar - </span><span id="pararGrupoCampanhas" style="cursor:pointer;" onclick="paraGrupoCampanhas('.$idGrupo.');">Parar</span></td>'."\n";
							$Saida .= '</tr>'."\n";
						}
					} else {
						$idGrupo = carregaIdGrupoPorNome($indices[$i]);
						$Saida .= '<tr>'."\n";
						$Saida .= '<td class="listT" colspan=15 style="{text-align:left;background-color:'.$cores[$i].';}">'.$indices[$i].' - <span id="processarGrupoCampanhas" style="cursor:pointer;" onclick="processaGrupoCampanhas('.$idGrupo.');">Processar</span> - <span id="pausarGrupoCampanhas" style="cursor:pointer;" onclick="pausaGrupoCampanhas('.$idGrupo.');">Pausar - </span><span id="pararGrupoCampanhas" style="cursor:pointer;" onclick="paraGrupoCampanhas('.$idGrupo.');">Parar</span></td>'."\n";
						$Saida .= '</tr>'."\n";
					}
					$indice[$i] = $indices[$i];
				}
			}
		}
		
		$Saida .= '</table>';
	} else if($tipo == "em processamento"){
		$c = 0;
		$Discador = $dados;
		for($i = 0; $i < count($Discador); $i++){
			foreach($Discador[$i] as $chaveA => $valorA){
				if($chaveA == "status"){
					if($valorA == 1){
						$Saida[$c] = $Discador[$i];
					}
				}
			}
		}
		$retornoJson = $json->encode($Saida);
		$Saida = $retornoJson;
	} else if($tipo == "json"){
		$Saida = json_encode($dados);
	} else if($tipo == "array"){
		$Saida = $dados;
	}
	return $Saida;
}

function carrega_status_campanhas(){
	Global $Discador;
	return $Discador->carrega_tabela_acao_simplificada();
}

function carrega_tabela_acao($tipoCamp=""){
	Global $Discador;
	return $Discador->carrega_tabela_acao($tipoCamp);
}

function carregaIdGrupoPorNome($nome){
	Global $Discador;
	$idGrupo = $Discador->carregaIdGrupoPorNome($nome);
	return $idGrupo[0]['id'];
}

function processarCampanha($enderecoApi, $campanha){
	Global $Discador;
	/*$ch = curl_init();
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $enderecoApi."/discador/acao/status/".$campanha); 
	curl_setopt($ch, CURLOPT_POST, true); 
	curl_setopt($ch, CURLOPT_POSTFIELDS, array('status'=>"1")); 
	 
	$result = curl_exec($ch); 
	curl_close($ch);*/
	return $Discador->alteraStatusCampanha($campanha, 1);
}

function pausarCampanha($enderecoApi, $campanha){
	Global $Discador;
	/*$ch = curl_init();
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $enderecoApi."/discador/acao/status/".$campanha); 
	curl_setopt($ch, CURLOPT_POST, true); 
	curl_setopt($ch, CURLOPT_POSTFIELDS, array('status'=>"2")); 
	 
	$result = curl_exec($ch); 
	curl_close($ch);*/
	return $Discador->alteraStatusCampanha($campanha, 2);
}

function pararCampanha($enderecoApi, $campanha){
	Global $Discador;
	/*$ch = curl_init();
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $enderecoApi."/discador/acao/status/".$campanha); 
	curl_setopt($ch, CURLOPT_POST, true); 
	curl_setopt($ch, CURLOPT_POSTFIELDS, array('status'=>"3")); 
	 
	$result = curl_exec($ch); 
	curl_close($ch);*/
	return $Discador->alteraStatusCampanha($campanha, 3);
}

function reiniciarCampanha($enderecoApi, $campanha){
	Global $Discador;
	/*$ch = curl_init();
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $enderecoApi."/discador/acao/status/".$campanha); 
	curl_setopt($ch, CURLOPT_POST, true); 
	curl_setopt($ch, CURLOPT_POSTFIELDS, array('status'=>"4")); 
	 
	$result = curl_exec($ch); 
	curl_close($ch);*/
	return $Discador->alteraStatusCampanha($campanha, 1);
}

function esconderCampanha($enderecoApi, $campanha){
	Global $Discador;
	/*$ch = curl_init();
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $enderecoApi."/discador/acao/visible/".$campanha); 
	curl_setopt($ch, CURLOPT_POST, true); 
	curl_setopt($ch, CURLOPT_POSTFIELDS, array('visible'=>'0')); 
	 
	$result = curl_exec($ch); 
	curl_close($ch);*/
	return $Discador->deletarCampanhaDiscador($campanha);
}

function carregaTotalEventos($filename){
        //$file = file_get_contents("/usr/local/apache2/htdocs/vdt/mailing/TESTE2.csvf8LESJ");
        $f = fopen($filename, "r");
        if(!$f) {
                $error = error_get_last();
                if($error['type']==2) return "NÃ£o foi possÃ­vel verificar a quantidade de eventos. Erro de permissÃ£o.\n".$filename;
        }
        fclose($f);
        $file = file_get_contents($filename);
        $linhas = explode("\n", $file);
        $eventos = array();
        foreach($linhas as $linha){
                $dados = explode(";", $linha);
                $evento = trim($dados[0]);
                if(is_numeric($evento)) $eventos[$evento]++;
        }
        return $eventos;
}

function carregaTodosGrupos($tipo){
	Global $Discador, $json;
	$gruposCampanhas = array();
	$grupos = $Discador->carregaTodosGrupos();
	$Saida = "";
	
	if(count($grupos) > 0){
		foreach($grupos as $grupo){
			$gruposCampanhas[$grupo['prioridade']]['nome'] = $grupo['nome'];
			$gruposCampanhas[$grupo['prioridade']]['prioridade'] = $grupo['prioridade'];
			$gruposCampanhas[$grupo['prioridade']]['tipo'] = $grupo['tipo'];
			$campanhas = $Discador->carregaCampanhasPeloGrupo($grupo['id']);
			if(count($campanhas) > 0){
				foreach($campanhas as $campanha){
					$gruposCampanhas[$grupo['prioridade']]['campanha'][$campanha['prioridade']]['nome'] = $campanha['titulo'];
					$gruposCampanhas[$grupo['prioridade']]['campanha'][$campanha['prioridade']]['prioridade'] = $campanha['prioridade'];
				}
			}
		}
	}
	ksort($gruposCampanhas);
	if($tipo=="option"){
		foreach($gruposCampanhas as $grupo){
			$Saida .= '<option value="'.$grupo['nome'].'">'.$grupo['nome'].'</option>';
		}
	} else if($tipo=="json"){
		$Saida = $json->encode($gruposCampanhas);
	} else if($tipo=="array"){
		$Saida = $gruposCampanhas;
	}
	return $Saida;
}

function carrega_arvore_grupos($tipo, $idGrupo=0, $para="href"){
	Global $Discador;
	$arvore = $Discador->carrega_arvore_grupos();
	$Saida = "";
	
	if($tipo == "arvore"){
		$arvore = $Discador->carrega_filhos_grupo($idGrupo);
		$html = "";
		$arvoreHtml = carrega_arvore_recursivo($arvore, $html, 0, $para);
		return $arvoreHtml;
	}
	return $Saida;
}

function carrega_arvore_recursivo($arvore, $html, $level, $tipo="href"){
	Global $Discador;
	if($tipo=="href") for($i = 0; $i < $level; $i++) $ident .= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
	for($i = 0; $i < count($arvore); $i++){
		$filhos = $Discador->carrega_filhos_grupo($arvore[$i]['id']);
		if(count($filhos)==0){
			if($tipo=="href") $html .= '<span style="font-size:8pt; cursor:pointer;" onclick="mostrar_grupo_arvore('.$arvore[$i]['id'].');">'.$ident.'[+] '.$arvore[$i]['nome'].'</span><br/>';
			if($tipo=="option") $html .= '<option value="'.$arvore[$i]['id'].'">'.$arvore[$i]['nome'].'</option>';
		} else if(count($filhos)>0){
			if($tipo=="option") $html .= '<option value="'.$arvore[$i]['id'].'">'.$arvore[$i]['nome'].'</option>';
			if($tipo=="href") {
				$html .= '<span style="font-size:8pt; cursor:pointer;" onclick="mostrar_grupo_arvore('.$arvore[$i]['id'].');">'.$ident.'[-] '.$arvore[$i]['nome'].'</span><br/>';
				$level++;
			}
			$html = carrega_arvore_recursivo($filhos, $html, $level, $tipo);
			if($tipo=="href") $level--;
		}
	}
	return $html;
}

function carrega_filhos_grupos($tipo){
	Global $Discador;
	$filhos = $Discador->carrega_filhos_grupos();
	$saida = "";
	if($tipo == "option"){
		foreach($filhos as $filho){
			$saida .= "<option value='".$filho['nome']."'>".$filho["nome"]."</option>";
		}
	} else if($tipo == "json"){
		$saida = json_encode($filhos);
	}
	return $saida;
}

function carrega_pai_recursivo($id, $linha){
	Global $Discador;
	$pai = $Discador->carregaGrupo($id);
	if($pai[0][0]['pai'] == 0) {
		return $pai[0][0]["nome"].$linha;
	} else {
		$linha = carrega_pai_recursivo($pai[0][0]["pai"], $linha)."->".$pai[0][0]["nome"];
	}
	return $linha;
}

function carrega_campanhas_filhas_recursivo($id, $campanhas){
	Global $Discador;
	$filhos = $Discador->carrega_filhos_grupo($id);
	if(count($filhos) <= 0){
		$campanhasSql = $Discador->carregaCampanhasGrupoPorId($id);
		foreach($campanhasSql as $campanha){
			$campanhas[$campanha["id"]] = $campanha;
		}
	} else {
		foreach($filhos as $filho){
			$camp = carrega_campanhas_filhas_recursivo($filho["id"], $campanhas);
			foreach($camp as $c){
				$campanhas[$c["id"]] = $c;
			}
		}
	}
	return $campanhas;
}

function carrega_campanhas_em_grupos($id, $campanhas, $indices){
	Global $Discador;
	$filhos = $Discador->carrega_filhos_grupo($id);
	if(count($filhos) <= 0){
		$campanhasSql = $Discador->carregaCampanhasGrupoPorId($id);
		foreach($campanhasSql as $campanha){
			$campanhas[$indices][] = $campanha['titulo'];
		}
	} else {
		foreach($filhos as $filho){
			$indices .= $filho["nome"]."|";
			$campanhas = carrega_campanhas_em_grupos($filho["id"], $campanhas, $indices);
			$indices = $campanhas[1];
			$campanhas = $campanhas[0];
			$indices = substr($indices, 0, (strlen($indices) - (strlen($filho["nome"]) + 1)));
		}
	}
	return array($campanhas, $indices);
}

function carregaDadosEventos($filename, $tipo){
	//$file = file_get_contents("/usr/local/apache2/htdocs/vdt/mailing/TESTE2.csvf8LESJ");
	$f = fopen($filename, "r");
	if(!$f) {
		$error = error_get_last();
		if($error['type']==2) return "Não foi possível verificar a quantidade de eventos. Erro de permissão.\n".$filename;
	}
	fclose($f);
	$file = file_get_contents($filename);
	$linhas = explode("\n", $file);
	$eventos = array();
	
	if($tipo=="array"){
		foreach($linhas as $linha){
			$dados = explode(";", $linha);
			$evento = trim($dados[0]);
			if(is_numeric($evento)) $eventos[$evento][] = $dados[4].$dados[5];
		}
	}
	
	return $eventos;
}

function carregaEventosAProc($eventos, $campanha){
        Global $Discador;
        $evtAProc = array();
        $totalRegAProc = 0;
        $totalReagenda = 0;
        foreach($eventos as $evento => $qtd){
                $evt = $Discador->verificaEventoValido($evento, $campanha);
                $rea = $Discador->verificaEventoReagendado($evento);
                if($evt){
                        $totalRegAProc += $qtd;
                        $evtAProc[$evento] = $evento;
                }
                if($rea) $totalReagenda++;
                //$totalReagenda = $rea;
        }
        return array($evtAProc, $totalRegAProc, $totalReagenda);
}
?>
