//JavaScript

//Carrega os dados da tabela campanha
function tabelaCampanha()
{
	var pagina = document.getElementById('moduloCampanha').value;
	var enderecoApi = document.getElementById('pgnApi').value;
	$('#listaCampanha').edatagrid({
		url:pagina+"?acao=carregaDadosJson&tipo=jquery&enderecoApi="+enderecoApi,
		saveUrl:pagina+"?acao=salvarCampanha&enderecoApi="+enderecoApi,
		updateUrl:pagina+"?acao=salvarCampanha&enderecoApi="+enderecoApi,
		destroyUrl:pagina+"?acao=deletarCampanha&enderecoApi="+enderecoApi
	});
	//carregaCampanhas(1, "jquery");
}

//Carrega os parametros main
function carregaParametrosMain(){
	var pagina = document.getElementById('moduloParametros').value;
	var enderecoApi = document.getElementById('pgnApi').value;
	var Oque = "?acao=carregaDadosJson&enderecoApi="+enderecoApi+"&tipo=jquery";
	
	var sleep = document.getElementById("sleep");
	var debug1 = document.getElementById("debug1");
	var debug2 = document.getElementById("debug2");
	var time_zone = document.getElementById("time_zone");
	var dns = document.getElementById("dns");
	var pg_dns = document.getElementById("pg_dns");
	var pg_user = document.getElementById("pg_user");
	var pg_password = document.getElementById("pg_password");
	var asterisk_server = document.getElementById("asterisk_server");
	var asterisk_port = document.getElementById("asterisk_port");
	var busca_agentes = document.getElementById("busca_agentes");
	var asterisk_outgoing_dir = document.getElementById("asterisk_outgoing_dir");
	
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
    {
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			//var dadosJson = eval('('+resposta+')');
			var dadosJson = jsonParse(resposta);
			//preenche os campos
			sleep.value = dadosJson.sleep;
			if(dadosJson.debug == 1) debug2.checked = true;
			else debug1.checked = true;
			time_zone.value = dadosJson.time_zone;
			dns.value = dadosJson.dns;
			pg_dns.value = dadosJson.pg_dns;
			pg_user.value = dadosJson.pg_user;
			pg_password.value = dadosJson.pg_password;
			asterisk_server.value = dadosJson.asterisk_server;
			asterisk_port.value = dadosJson.asterisk_port;
			busca_agentes.value = dadosJson.busca_agentes;
			asterisk_outgoing_dir.value = dadosJson.asterisk_outgoing_dir;
		}
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

//Salva os parametros do main
function salvarParametrosMain(){
	var pagina = document.getElementById('moduloParametros').value;
	var enderecoApi = document.getElementById('pgnApi').value;
	
	var sleep = document.getElementById("sleep");
	var debug;
	var debug1 = document.getElementById("debug1");
	var debug2 = document.getElementById("debug2");
	var time_zone = document.getElementById("time_zone");
	var dns = document.getElementById("dns");
	var pg_dns = document.getElementById("pg_dns");
	var pg_user = document.getElementById("pg_user");
	var pg_password = document.getElementById("pg_password");
	var asterisk_server = document.getElementById("asterisk_server");
	var asterisk_port = document.getElementById("asterisk_port");
	var busca_agentes = document.getElementById("busca_agentes");
	var asterisk_outgoing_dir = document.getElementById("asterisk_outgoing_dir");
	
	if(sleep.value == ""){
		alert("Preencha o campo sleep.");
		return;
	}
	if(dns.value == ""){
		alert("Preencha o campo DNS.");
		return;
	}
	if(pg_dns.value == ""){
		alert("Preencha o campo DNS do Postgres.");
		return;
	}
	if(pg_user.value == ""){
		alert("Preencha o campo Username do Postgres.");
		return;
	}
	if(asterisk_server.value == ""){
		alert("Preencha o campo IP do Asterisk.");
		return;
	}
	if(asterisk_port.value == ""){
		alert("Preencha o campo Porta do Asterisk.");
		return;
	}
	if(busca_agentes.value == ""){
		alert("Preencha o campo Busca agentes.");
		return;
	}
	if(asterisk_outgoing_dir.value == ""){
		alert("Preencha o campo Diretrio do click to call.");
		return;
	}
	
	if(debug1.checked) debug = 0;
	else debug = 1;
	
	var Oque = "?acao=salvaDadosJson&enderecoApi="+enderecoApi+"&sleep="+sleep.value+"&debug="+debug+"&time_zone="+time_zone.value+"&dns="+dns.value+"&pg_dns="+pg_dns.value+"&pg_user="+pg_user.value+"&pg_password="+pg_password.value+"&asterisk_server="+asterisk_server.value+"&asterisk_port="+asterisk_port.value+"&busca_agentes="+busca_agentes.value+"&asterisk_outgoing_dir="+asterisk_outgoing_dir.value;
	
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
    {
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			alert("Parametros salvos com sucesso!");
		}
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

/***************************************************
Funcao:     tabelaGerenciamentoCampanha
Descricao:  Monta o grid com as campanhas que foram
            iniciadas, pausadas e paradas, com as 
			respectivas opes
****************************************************/
function tabelaGerenciamentoCampanha()
{
	var obj = le_objeto("modulodiscadorgerencia");
	var pagina = obj.value;

        var obj = le_objeto("wsdiscador");
        var url = obj.value;
//alert(pagina);
	$('#gerenciamentoCampanha').datagrid({
		title:'Gerenciamento Campanhas',
		iconCls:'icon-save',
		width:750,
		height:350,
		nowrap: false,
		striped: true,
		loadMsg:'',
		url:pagina+'?acao=carregarTabela',
		collapsible:true,
		remoteSort: false,
		singleSelect: true,
		columns:[[
			{title:'Campanhas',colspan:10},
			{field:'acao',title:'',width:100,rowspan:2,
			    formatter:function(value,row){
					if(row.status == 1)
						return '<a href="#" onclick="processarCampanha('+row.id+',\'pausar\');">Pausar</a>';
			        if(row.status == 2)
					    return '<a  href="#" onclick="processarCampanha('+row.id+',\'processar\')">Processar</a>';
				}
		    },
			{field:'parar',title:'',width:100,rowspan:2,
				formatter:function(value, row){
					if(row.status == 0 || row.status == 1 || row.status == 2)
						return '<a href="#" onclick="processarCampanha('+row.id+',\'parar\')">Parar</a>';
					if(row.status == 3)
						return '<a href="#" onclick="processarCampanha('+row.id+',\'processar\')">Reiniciar</a>';
				}
			},
			{field:'historico',title:'Histrico',width:100,rowspan:2,
			     formatter:function(value,row){
					 if(row.status != 0)
					 	return '<a href="#" onclick="historicoCampanha('+row.id+');">Histrico</a>';
					 else
					 	return 'No h histrico dessa campanha !!!';
			     }
			},
			{field:'download',title:'Download',width:100,rowspan:2,
				formatter:function(value,row){
					return '<a href="'+url+'acao/historico/download/'+row.id+'">Download</a>'	
				}
			}
		],[
		    {field:'id',title:'ID',width:50},
			{field:'campanha',title:'Nome',width:150},
			{field:'status',title:'Status',width:200,
			 formatter:function(value,row,index){
				 var status;
				 switch(value){
					case 0:
						status = "No Iniciado";
					break;
					case 1:
						status = "Processando...";
					break;
					case 2:
						status = "Pausado";
				    break;
					case 3:
					    status = "Parado";
				    break;
				 }return status;
			 }},
			{field:'timestamp',title:'Data', width:150,
				 formatter:function(value,row,index){
					var data = new Date(value*1000);
					var dia = data.getDate();
					var mes = data.getMonth()+1;
					var ano = data.getFullYear();
					
					var hora = data.getHours();
					if(data.getMinutes() < 10){
						var minuto = "0"+data.getMinutes();
					}
					else{
						var minuto = data.getMinutes();
					}
					if(data.getSeconds() < 10){
						var segundo = "0"+data.getSeconds();
					}else{
						var segundo = data.getSeconds();
					}
					return dia+"/"+mes+"/"+ano+" "+hora+":"+minuto+":"+segundo;
				 }
		     },
			 {field:'filename',title:'Arquivo',width:200},
			 {field:'offset',title:'Linha Atual',width:100},
			 {field:'eom',title:'Total de Linhas',width:150}
		]],
		rownumbers:true
	});
	window.setTimeout("tabelaGerenciamentoCampanha()",10000);
}

/*****************************************************
Funcao:     mostraCampanhas
            Busca no WebRestful o json as campanhas
			cadastradas pelo Ajax
			Ao obter a resposta chama uma funcao 
			para montar o select da tela
*****************************************************/
function mostraCampanhas()
{
    var obj = le_objeto("wsdiscadorgerencia");
	var pagina = obj.value;
    //var pagina = 'http://127.0.0.1:3000/discador/config';
    var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
    {
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			montaSelectCampanha(resposta);
		}
	}
        
	Oque = '';
	xmlHttp.open("GET",pagina,true);
	//xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xmlHttp.setRequestHeader('Content-Type', 'application/json');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
        //xmlHttp.setRequestHeader('encoding','UTF-8');
	xmlHttp.send(Oque);
}

function carregaVerificacao(){
$(document).ready(function(){
	$('#vm50_formulario').validate({
		rules:{
			ip_servidor:{
				required: true
			},
			porta_servidor:{
				required: true
			},
			usuario_servidor:{
				required: true	
			},
			ip_servidor_banco:{
				required: true
			},
			usuario_servidor_banco:{
				required: true	
			},
			arquivo:{
				required:true	
			}
		},
		messages:{
			ip_servidor:{
				required:"Preencha o campo IP do CTI !!!"
			},
			porta_servidor:{
				required:"Preencha o campo Porta do CTI !!!"	
			},
			usuario_servidor:{
				required:"Preencha o campo Usurio do CTI !!!"	
			},
			ip_servidor_banco:{
				required:"Preencha o campo IP do Banco !!!"	
			},
			usuario_servidor_banco:{
				required:"Preencha o campo Usurio Banco !!!"	
			},
			arquivo:{
				required:"Selecione o Arquivo para envio !!!"	
			}
		}
	});
});
}

function montaSelectCampanha(json)
{
	var resultado = jsonParse(json);
	var campanha = le_objeto("campanhas");
	
	for(var key in resultado.campanhas){
		var option = document.createElement("option");
		option.text = key;
		option.value = key;
		campanha.add(option);
	}
}

function tabelaCampanhaGerencia(tipo){
	var pagina = document.getElementById('moduloGerencia').value;
	var enderecoApi = document.getElementById('pgnApi').value;
	var divTabela = document.getElementById('divGerencia');
	var orderBy = document.getElementById('orderBy').value;
	var paginaTab = document.getElementById('paginaTab').value;
	var grupoCampanhas = document.getElementById('grupoCampanhas').value;
	var info = document.getElementById('info');
	var campanhasProcessar = document.getElementById('campanhasProcessar');
	var campanhasPausar = document.getElementById('campanhasPausar');
	var campanhasParar = document.getElementById('campanhasParar');
	var tempoRefDisc = document.getElementById('tempoRefDisc').value;
	var campanhas = document.getElementById('campanhas').value;
	var tipo = document.getElementById("tipo").value;
	//var qtdPesqFeita = document.getElementById('qtdPesqFeita');
	//var qtdPesqNeces = document.getElementById('qtdPesqNeces').value;
	if(tipo=="manual") info.innerHTML = "<p class='texto'>Aguarde, carregando a tabela...</p>";
	
	var Oque = pagina+"?acao=carregaCampanhasTabela&enderecoApi="+enderecoApi+'&orderby='+orderBy+"&pagina="+paginaTab+"&filtroGrupo="+grupoCampanhas+"&buscaEstatisticas=0&tipo="+tipo;
	/*qtdPesqFeita.value++;
	if(parseInt(qtdPesqFeita.value) >= parseInt(qtdPesqNeces)){
		Oque = pagina+"?acao=carregaCampanhasTabela&enderecoApi="+enderecoApi+'&orderby='+orderBy+"&pagina="+paginaTab+"&filtroGrupo="+grupoCampanhas+"&buscaEstatisticas=1";
		qtdPesqFeita.value = "0";
	}*/
	
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			divTabela.innerHTML = resposta;
			info.innerHTML = "";
			//carregaStatusCampanhas("manual");
		}
	}
	xmlHttp.open("GET",Oque,false);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
	carregaEstatisticasCampanhas('manual');
	if(tipo!="manual") window.setTimeout("tabelaCampanhaGerencia()", tempoRefDisc);
}

function carregaStatusCampanhas(){
	var tempoRefDisc = document.getElementById('tempoRefDisc').value;
	var pagina = document.getElementById('moduloGerencia').value;
	var Oque = pagina+"?acao=carrega_status_campanhas";
	//console.log(tempoRefDisc);
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function(){
		if(xmlHttp.readyState==4){
			var resposta = xmlHttp.responseText;
			resposta = jsonParse(resposta);
			var acao = "";
			var status = "";
			var excluir = "";
			for(var i in resposta){
				acao = "";
				status = "";
				excluir = "";
				if(resposta[i].status == "0"){
					acao = '<span class="botaoDisc" style="cursor:pointer;" onclick="processarCampanha(\''+resposta[i].id+'\');">Processar</span> <span class="botaoDisc" style="cursor:pointer;" onclick="pausarCampanha(\''+resposta[i].id+'\');">Pausar</span> <span class="botaoDisc" style="cursor:pointer;" onclick="pararCampanha(\''+resposta[i].id+'\');">Parar</span>';
					status = "Pendente";
				} else if(resposta[i].status == "1"){
					acao = '<span class="botaoDisc" style="cursor:pointer;" onclick="pausarCampanha(\''+resposta[i].id+'\',\'\',this);">Pausar</span> <span class="botaoDisc"  style="cursor:pointer;" onclick="pararCampanha(\''+resposta[i].id+'\',\'\',this);">Parar</span>';
					status = "Processando";
				} else if(resposta[i].status == "2"){
					acao = '<span class="botaoDisc" style="cursor:pointer;" onclick="processarCampanha(\''+resposta[i].id+'\',\'\',this);">Processar</span>';
					excluir = '<span class="botaoDisc" style="cursor:pointer;" onclick="esconderCampanha(\''+resposta[i].id+'\');">Excluir</span>';
					status = "Pausado";
				} else if(resposta[i].status == "3"){
					acao = '<span class="botaoDisc" style="cursor:pointer;" onclick="processarCampanha(\''+resposta[i].id+'\',\'\',this);">Processar</span>';
					excluir = '<span class="botaoDisc" style="cursor:pointer;" onclick="esconderCampanha(\''+resposta[i].id+'\');">Excluir</span>';
					status = "Parado";
				} else if(resposta[i].status == "4"){
					status = "Pendente";
				} else if(resposta[i].status == "8"){
					status = "Cancelado";
				} else if(resposta[i].status == "9"){
					acao = '<span class="botaoDisc" style="cursor:pointer;" onclick="reiniciarCampanha(\''+resposta[i].id+'\');">Reiniciar</span>';
					excluir = '<span class="botaoDisc" style="cursor:pointer;" onclick="esconderCampanha(\''+resposta[i].id+'\');">Excluir</span>';
					status = "Finalizado";
				}
				if(document.getElementById('acao_'+resposta[i].id)!=null) document.getElementById('acao_'+resposta[i].id).innerHTML = acao;
				if(document.getElementById('status_'+resposta[i].id)!=null) document.getElementById('status_'+resposta[i].id).innerHTML = status;
				if(document.getElementById('excluir_'+resposta[i].id)!=null) document.getElementById('excluir_'+resposta[i].id).innerHTML = excluir;
			}
		}
	}
	xmlHttp.open("GET",Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
	
	window.setTimeout("carregaStatusCampanhas()", tempoRefDisc);
}

function orderBy(valor){
	document.getElementById("orderBy").value = valor;
	tabelaCampanhaGerencia('manual');
}

function page(valor){
	document.getElementById("paginaTab").value = valor;
	tabelaCampanhaGerencia('manual');
}

function processarCampanha(campanha, atualizaTab){
	if(typeof atualizaTab == 'undefined') atualizaTab = '';
	var pagina = document.getElementById('moduloGerencia').value;
	var enderecoApi = document.getElementById('pgnApi').value;
	var Oque = "?acao=processarCampanha&enderecoApi="+enderecoApi+"&campanha="+campanha;
	var acao = document.getElementById('acoesPendentes');
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
    {
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			var dataHora = new Date();
			var novaString = dataHora.getHours()+':'+dataHora.getMinutes()+':'+dataHora.getSeconds()+' - Evento "<b>Processar</b>" na campanha "<b>'+campanha+'</b>"enviado para o servidor...';
			acao.innerHTML = novaString;
			document.getElementById("status_"+campanha).innerHTML = "Processando";
			//if(atualizaTab == "") tabelaCampanhaGerencia("manual");
		}
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function pausarCampanha(campanha, atualizaTab){
	var pagina = document.getElementById('moduloGerencia').value;
	var enderecoApi = document.getElementById('pgnApi').value;
	var Oque = "?acao=pausarCampanha&enderecoApi="+enderecoApi+"&campanha="+campanha;
	var acao = document.getElementById('acoesPendentes');
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
    {
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			var dataHora = new Date();
			var novaString = dataHora.getHours()+':'+dataHora.getMinutes()+':'+dataHora.getSeconds()+' - Evento "<b>Pausar</b>" na campanha "<b>'+campanha+'</b>" enviado para o servidor...';
			acao.innerHTML = novaString;
			document.getElementById("status_"+campanha).innerHTML = "Pausado";
			//if(atualizaTab=="") tabelaCampanhaGerencia("manual");
		}
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function pararCampanha(campanha, atualizaTab){
	var pagina = document.getElementById('moduloGerencia').value;
	var enderecoApi = document.getElementById('pgnApi').value;
	var Oque = "?acao=pararCampanha&enderecoApi="+enderecoApi+"&campanha="+campanha;
	var acao = document.getElementById('acoesPendentes');
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
    {
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			var dataHora = new Date();
			var novaString= dataHora.getHours()+':'+dataHora.getMinutes()+':'+dataHora.getSeconds()+' - Evento "<b>Parar</b>" da campanha "<b>'+campanha+'</b>" enviado para o servidor...';
			acao.innerHTML = novaString;
			document.getElementById("status_"+campanha).innerHTML = "Parado";
			//if(atualizaTab=="") tabelaCampanhaGerencia("manual");
		}
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function reiniciarCampanha(campanha){
	var pagina = document.getElementById('moduloGerencia').value;
	var enderecoApi = document.getElementById('pgnApi').value;
	var Oque = "?acao=reiniciarCampanha&enderecoApi="+enderecoApi+"&campanha="+campanha;
	var acao = document.getElementById('acoesPendentes');
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
    {
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			var dataHora = new Date();
			var novaString = dataHora.getHours()+':'+dataHora.getMinutes()+':'+dataHora.getSeconds()+' - Evento "<b>Reiniciar</b>" enviado para o servidor...<br/>'+acai.innerHTML;
			acao.innerHTML = novaString;
			document.getElementById("status_"+campanha).innerHTML = "Finalizado";
			//tabelaCampanhaGerencia("manual");
		}
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function carregaCampanhasSelect(){
	var pagina = document.getElementById('moduloGerencia').value;
	var enderecoApi = document.getElementById('pgnApi').value;
	var Oque = "?acao=carregaCampanhasSelect&enderecoApi="+enderecoApi;
	var sel = le_objeto('nomeCampanhaNova');
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
    {
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			//console.log(resposta);
			//var dados = eval ('(' + resposta + ')');
			var dados = jsonParse(resposta);
			var Saida = "";
			for(i = 0; i < dados.length; i++){
				var option = document.createElement('option');
				option.value = dados[i]['id'];
				option.text = dados[i]['nome'];
				sel.add(option);
			}
		}
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function carrega_agentes(){
	var campoLeft = document.getElementById("agenl[]");
	var campoRight = document.getElementById("agenr[]");
	var agentesRight = document.getElementById("agentesRight").value.split('|');
	var o;
	for(i = 0; i < campoLeft.length; i++){
		for(j = 0; j < agentesRight.length; j++){
			if(campoLeft.options[i].value == agentesRight[j]){
				o = new Option(campoLeft.options[i].text, campoLeft.options[i].value);
				try { campoRight.add(o, null);
				} catch(e) { campoRight.add(o); }
				campoLeft.remove(i);
			}
		}
	}
}

function startDiscador(){
	if(!confirm("Clique em OK para confirmar a iniciao do discador.")) return;
	var pagina = document.getElementById('moduloUtils').value;
	var enderecoApi = document.getElementById('pgnApi').value;
	var Oque = "?acao=startDiscador&enderecoApi="+enderecoApi;
	var campo = document.getElementById("statusStart");
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
    {
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			console.log(resposta);
			campo.innerHTML = "Discador iniciado!";
		}
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
	return;
}

function stopDiscador(){
	if(!confirm("Clique em Ok para confirmar a paralisao do discador.")) return;
	var pagina = document.getElementById('moduloUtils').value;
	var enderecoApi = document.getElementById('pgnApi').value;
	var Oque = "?acao=stopDiscador&enderecoApi="+enderecoApi;
	var campo = document.getElementById("statusStop");
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
    {
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			campo.innerHTML = "Discador parado!";
		}
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
	return;
}

function esconderCampanha(campanha){
	if(!confirm("Clique em OK para confirmar a excluso do registro dessa campanha.")) return;
	var pagina = document.getElementById('moduloGerencia').value;
	var enderecoApi = document.getElementById('pgnApi').value;
	var Oque = "?acao=esconderCampanha&enderecoApi="+enderecoApi+"&campanha="+campanha;
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
    {
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			tabelaCampanhaGerencia("manual");
		}
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function mostra_grupo(Numero){
	var NumeroT = Numero;
	var Numero = preenche_comzeros(Numero,9);
	var dadosJson = document.getElementById("dados_grupo_"+Numero).value;
	var dados = jsonParse(dadosJson);
	var identif = document.getElementById("identif");
	document.getElementById("grupo").value = dados.nome;
	document.getElementById("prioridadeGrupo").value = dados.prioridade;
	//preenche o tipo do grupo
	var select = document.getElementById("tipo");
	if(dados.tipo == "balanceado") select.options[0].selected = true;
	else select.options[1].selected = true;
	//preenche as campanhas daquele grupo
	carregaSelectGrupoCampanhasL();
	var selectR = document.getElementById("campanhasR[]");
	selectR.options.length = 0;
	var comando = new Object();
	comando.value = ">";
	var options = null;
	var c = 0;
	for(var campanha in dados.campanhas){
		options = document.createElement("option");
		options.value = campanha;
		options.text = campanha;
		selectR.add(options, c)
		c++;
	}
	
	for(var i = 0; i < selectR.options.length; i++) selectR.options[i].selected = false;
	identif.value = NumeroT;
}

function carregaSelectPrioridades(){
	var select = document.getElementById("prioridade");
	var pagina = document.getElementById('moduloGruposCampanhas').value;
	var enderecoApi = document.getElementById('enderecoApi').value;
	var Oque = "?acao=carregaPrioridadesSelect&enderecoApi="+enderecoApi;
	var c = 1;
	select.options.length = 0;
	var option = document.createElement("option");
	option.value = '-';
	option.text = " - ";
	select.add(option, 0);
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
        {
			if(xmlHttp.readyState==4)
			{
				var resposta = xmlHttp.responseText;
				var prioridades = resposta.split(',');
				for(i = 0; i < prioridades.length; i++){
					if(prioridades[i]!='-'){
						var option = document.createElement("option");
						option.value = prioridades[i];
						option.text = prioridades[i];
						select.add(option, c);
						c++;
					}
				}
			}
        }
        xmlHttp.open("GET",pagina+Oque,false);
        xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xmlHttp.setRequestHeader('Content-length', Oque.length );
        xmlHttp.setRequestHeader('encoding','ISO-8859-1');
        xmlHttp.send(null);
}

function paraTodasCampanhas(){
	var campanhasJson = document.getElementById("campanhas");
	var campanhas = jsonParse(campanhasJson.value);
	var botao = document.getElementById("pararTodasCampanhas");
	botao.value = "Aguarde...";
	for(var i = 0; i < campanhas.length; i++){
		if(campanhas[i].status == 1){
			pararCampanha(campanhas[i].id, "stopAll");
		}
	}
	botao.value = "Parar";
}

function pausaTodasCampanhas(){
	var campanhasJson = document.getElementById("campanhas");
	var campanhas = jsonParse(campanhasJson.value);
	var botao = document.getElementById("pausarTodasCampanhas");
	botao.value = "Aguarde...";
	for(var i = 0; i < campanhas.length; i++){
		if(campanhas[i].status == 1){
			pausarCampanha(campanhas[i].id, "pauseAll");
		}
	}
	botao.value = "Pausar";
}

function processaTodasCampanhas(){
	var campanhasJson = document.getElementById("campanhas");
	var campanhas = jsonParse(campanhasJson.value);
	var botao = document.getElementById("processarTodasCampanhas");
	botao.value = "Aguarde...";
	for(var i = 0; i < campanhas.length; i++){
		if(campanhas[i].status == 0 || campanhas[i].status == 2 || campanhas[i].status == 3){
			processarCampanha(campanhas[i].id, "processaTodos");
		}
	}
	botao.value = "Processar";
}

function paraGrupoCampanhas(idGrupo){
	var botao = document.getElementById("pararGrupoCampanhas");
	var campanhas = document.getElementById("campanhas").value;
	var campanhasArray = jsonParse(campanhas);
	botao.value = "Aguarde...";
	var pagina = document.getElementById('moduloUtils').value;
	var Oque = "?acao=carregaCampanhasGrupo&idGrupo="+idGrupo;
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			var grupos = jsonParse(resposta);
			for(var i in grupos){
				for(var j in grupos[i]){
					for(var k in grupos[i][j]){
						for(var l in campanhasArray){
							if(campanhasArray[l].campanha == grupos[i][j][k]){
								console.log(campanhasArray[l].id+" - "+grupos[i][j][k]);
								pararCampanha(campanhasArray[l].id, "stopGroup");
							}
						}
					}
				}
			}
		}
	}
	xmlHttp.open("GET",pagina+Oque,false);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
	botao.value = "Parar";
}

function pausaGrupoCampanhas(idGrupo){
	var botao = document.getElementById("pausarGrupoCampanhas");
	var campanhas = document.getElementById("campanhas").value;
	var campanhasArray = jsonParse(campanhas);
	botao.value = "Aguarde...";
	var pagina = document.getElementById('moduloUtils').value;
	var Oque = "?acao=carregaCampanhasGrupo&idGrupo="+idGrupo;
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			var grupos = jsonParse(resposta);
			for(var i in grupos){
				for(var j in grupos[i]){
					for(var k in grupos[i][j]){
						for(var l in campanhasArray){
							if(campanhasArray[l].campanha == grupos[i][j][k]){
								console.log(campanhasArray[l].id+" - "+grupos[i][j][k]);
								pausarCampanha(campanhasArray[l].id, "pauseGroup");
							}
						}
					}
				}
			}
		}
	}
	xmlHttp.open("GET",pagina+Oque,false);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
	botao.value = "Pausar";
}

function processaGrupoCampanhas(idGrupo){
	var botao = document.getElementById("processarGrupoCampanhas");
	var campanhas = document.getElementById("campanhas").value;
	var campanhasArray = jsonParse(campanhas);
	botao.value = "Aguarde...";
	var pagina = document.getElementById('moduloUtils').value;
	var Oque = "?acao=carregaCampanhasGrupo&idGrupo="+idGrupo;
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			var resposta = xmlHttp.responseText;
			var grupos = jsonParse(resposta);
			for(var i in grupos){
				for(var j in grupos[i]){
					for(var k in grupos[i][j]){
						for(var l in campanhasArray){
							if(campanhasArray[l].campanha == grupos[i][j][k]){
								console.log(campanhasArray[l].id+" - "+grupos[i][j][k]);
								processarCampanha(campanhasArray[l].id, "proccessGroup");
							}
						}
					}
				}
			}
		}
	}
	xmlHttp.open("GET",pagina+Oque,false);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
	botao.value = "Processar";
}

function carregaSelectGrupoCampanhasL(){
	var campanhasJson = document.getElementById("campanhas").value;
	var dadosCampanha = jsonParse(campanhasJson);
	var campanhasUsadas = document.getElementById("campanhasUsadas").value;
	var campanhasUsadas = jsonParse(campanhasUsadas);
	var select = document.getElementById("campanhasL[]");
	select.options.length = 0;
	var option = null;
	var c = 0;
	var campUsada = false;
	for(var i = 0; i < dadosCampanha.length; i++){
		campUsada = false;
		if(campanhasUsadas != null){
			for(var j = 0; j < campanhasUsadas.length; j++)
				if(campanhasUsadas[j] == dadosCampanha[i].nome) campUsada = true;
		}
		if(!campUsada){
			option = document.createElement("option");
			option.value = dadosCampanha[i].nome;
			option.text = dadosCampanha[i].nome;
			select.add(option, c);
			c++;
		}
	}
}

function mostraDetalhesCampanhaGrupo(campanha){
	var campanha = campanha.value;
	var numero = document.getElementById("identif").value;
	var numero = preenche_comzeros(numero,9);
	var dadosJson = document.getElementById("dados_grupo_"+numero).value;
	var dados = jsonParse(dadosJson);
	var dtCampanha = document.getElementById("dtCampanha");
	var dtPrioridade = document.getElementById("dtPrioridade");
	var divDetalhes = document.getElementById("detalhesCampanha");
	
	dtCampanha.value = campanha;
	dtPrioridade.value = "";
	
	for(var campanhaC in dados.campanhas){
		if(campanhaC == campanha){
			dtPrioridade.value = dados.campanhas[campanhaC].prioridade;
		}
	}
	divDetalhes.style = "display:block";
}

function alterarDetalhesCampanha(){
	var idGrupo = document.getElementById("identif").value;
	var campanha = document.getElementById("dtCampanha").value;
	var prioridade = document.getElementById("dtPrioridade").value;
	var infoDetalhes = document.getElementById("infoDetalhes");
	
	var pagina = document.getElementById('moduloGruposCampanhas').value;
	var Oque = "?acao=alterarDetalhes&idGrupo="+idGrupo+"&campanha="+campanha+"&prioridade="+prioridade;
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
    {
		if(xmlHttp.readyState==4) {
			var resposta = xmlHttp.responseText;
			infoDetalhes.innerHTML = resposta;
		}
		
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function addCampanhaAoGrupo(comp){
	var comp = document.getElementById(comp);
	if(comp.options[comp.selectedIndex].value != ""){
		var idGrupo = document.getElementById("identif").value;
		var campanha = comp.options[comp.selectedIndex].value;
		var statusCamp = document.getElementById("statusCamp");
		
		var pagina = document.getElementById('moduloGruposCampanhas').value;
		var Oque = "?acao=addCampanhaAoGrupo&idGrupo="+idGrupo+"&campanha="+campanha;
		var xmlHttp = GetXmlHttpObject();
		xmlHttp.onreadystatechange=function()
		{
			if(xmlHttp.readyState==4) {
				var resposta = xmlHttp.responseText;
				statusCamp.innerHTML = resposta;
			}
			
		}
		xmlHttp.open("GET",pagina+Oque,true);
		xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xmlHttp.setRequestHeader('Content-length', Oque.length );
		xmlHttp.setRequestHeader('encoding','ISO-8859-1');
		xmlHttp.send(null);
	}
}

function removeCampanhaDoGrupo(comp){
	var comp = document.getElementById(comp);
	if(comp.options[comp.selectedIndex].value != ""){
		var idGrupo = document.getElementById("identif").value;
		var campanha = comp.options[comp.selectedIndex].value;
		var statusCamp = document.getElementById("statusCamp");
		
		var pagina = document.getElementById('moduloGruposCampanhas').value;
		var Oque = "?acao=removeCampanhaDoGrupo&idGrupo="+idGrupo+"&campanha="+campanha;
		var xmlHttp = GetXmlHttpObject();
		xmlHttp.onreadystatechange=function()
		{
			if(xmlHttp.readyState==4) {
				var resposta = xmlHttp.responseText;
				statusCamp.innerHTML = resposta;
			}
			
		}
		xmlHttp.open("GET",pagina+Oque,true);
		xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xmlHttp.setRequestHeader('Content-length', Oque.length );
		xmlHttp.setRequestHeader('encoding','ISO-8859-1');
		xmlHttp.send(null);
	}
}

function monitoraCampanhas(){
	var pagina = document.getElementById('moduloGerenciaCampanhas').value;
	var campanha = document.getElementById('filtroCampanha');
	var divTabela = document.getElementById('lista');
	var tempoRefresh = document.getElementById('tempoRefresh').value;
	var qtdRegistros = document.getElementById('qtdRegistros').value;
	campanha = campanha.options[campanha.selectedIndex].value;
	var Oque = "?acao=carregarTabela&campanha="+campanha+"&qtdRegistros="+qtdRegistros;
	//var Oque = "?acao=carregarTabela&campanha=CARRAO";
	console.log(Oque);
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4) {
			var resposta = xmlHttp.responseText;
			divTabela.innerHTML = resposta;
		}
		
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
	window.setTimeout("monitoraCampanhas()", tempoRefresh*1000);
}

function mostrar_agenda_campanha(campanha){
	var campanha = document.getElementById("campanha");
	var horaInicial = document.getElementById("horainicial");
	var horaFinal = document.getElementById("horafinal");
	
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4) {
			var resposta = xmlHttp.responseText;
			divTabela.innerHTML = resposta;
		}
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function mostrar_grupo_arvore(id){
	var pagina = document.getElementById('moduloGruposCampanhas').value;
	var Oque = "?acao=carregaGrupo&grupo="+id;
	var divSubgrupos = document.getElementById("divSubgrupos");
	var nome = document.getElementById("grupo");
	var prioridade = document.getElementById("prioridadePai");
	var filhosL = document.getElementById("filhosL[]");
	var idGrupo = document.getElementById("idGrupo");
	
	carregaSelectArvoreGruposFilhos();
	document.getElementById("filhosR[]").options.length = 0;
	
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4) {
			var resposta = xmlHttp.responseText;
			var respostaObj = jsonParse(resposta);
			
			nome.value = respostaObj.nome;
			prioridadePai.value = respostaObj.prioridade;
			idGrupo.value = id;
			console.log(resposta);
			if(typeof(respostaObj.filhos)!=""){
				document.getElementById("managerSubgrupos").style = "display:block;";
				document.getElementById("botao_ag").style = "display:block;";
				document.getElementById("botao_ac").style = "display:none;";
				document.getElementById("addSubgrupos").style = "display:none;";
				document.getElementById("addSubgruposLbl").style = "display:none;";
				document.getElementById("managerCampanhas").style = "display:none;";
				document.getElementById("addCampanhaLbl").style = "display:none;";
				var obj = new Object();
				obj.value = ">";
				for(var i = 0; i < filhosL.options.length; i++){
					for(var j = 0; j < respostaObj.filhos.length; j++){
						if(respostaObj.filhos[j] == filhosL.options[i].text){
							filhosL.options[i].selected = true;
							Move(obj, "filhosL[]", "filhosR[]");
						}
					}
				}
			}
			if(respostaObj.campanhas!=""){
				montaSelectCampanhasArvoreGrupos();
				document.getElementById("managerSubgrupos").style = "display:none;";
				document.getElementById("addSubgrupos").style = "display:none;";
				document.getElementById("addSubgruposLbl").style = "display:none;";
				document.getElementById("managerCampanhas").style = "display:block;";
				document.getElementById("addCampanhaLbl").style = "display:block;";
				document.getElementById("botao_ag").style = "display:none;";
				document.getElementById("botao_ac").style = "display:block;";
			}
			if(respostaObj.filhos=="" && respostaObj.campanhas==""){
				montaSelectCampanhasArvoreGrupos();
				document.getElementById("managerSubgrupos").style = "display:none;";
				document.getElementById("addSubgrupos").style = "display:none;";
				document.getElementById("addSubgruposLbl").style = "display:none;";
				document.getElementById("managerCampanhas").style = "display:none;";
				document.getElementById("addCampanhaLbl").style = "display:none;";
				document.getElementById("botao_ag").style = "display:block;";
				document.getElementById("botao_ac").style = "display:block;"
			}
		}
	}
	xmlHttp.open("GET",pagina+Oque,true);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function carregaSelectArvoreGruposFilhos(){
	var filhosJson = document.getElementById("filhosLJson");
	var filhosObj = jsonParse(filhosJson.value);
	var filhosL = document.getElementById("filhosL[]");
	
	filhosL.options.length = 0;
	for(var i = 0; i < filhosObj.length; i++){
		var option = document.createElement("option");
		option.text = filhosObj[i].nome;
		option.value = filhosObj[i].id;
		filhosL.add(option);
	}
}

function removeFilhoGrupo(){
	var filhosR = document.getElementById("filhosR[]");
	var idGrupo = document.getElementById("idGrupo").value;
	var pagina = document.getElementById('moduloGruposCampanhas').value;
	var Oque = "?acao=removeFilhoGrupo";
	var gruposFilhos = "";
	var Oque = "";
	var statusFilhos = document.getElementById("statusFilhos");
	var xmlHttp = GetXmlHttpObject();
	for(var i = 0; i < filhosR.options.length; i++){
		if(filhosR.options[i].selected == true){
			Oque = "?acao=removeFilhoGrupo&idGrupoFilho="+filhosR.options[i].value;
			xmlHttp.onreadystatechange=function()
			{
				if(xmlHttp.readyState==4) {
					var resposta = xmlHttp.responseText;
					console.log(resposta);
					location.reload();
				}
			}
			xmlHttp.open("GET",pagina+Oque,false);
			xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
			xmlHttp.setRequestHeader('Content-length', Oque.length );
			xmlHttp.setRequestHeader('encoding','ISO-8859-1');
			xmlHttp.send(null);
		}
	}
}

function addSubgrupo(){
	var nome = document.getElementById("subgrupo").value;
	var prioridade = document.getElementById("prioridadeFilho").value;
	var idGrupo = document.getElementById("idGrupo").value;
	var tipo = document.getElementById("tipo").value;
	var pagina = document.getElementById('moduloGruposCampanhas').value;
	var Oque = "?acao=addFilhoGrupo&subGrupo="+nome+"&prioridade="+prioridade+"&idGrupo="+idGrupo+"&tipo="+tipo;
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4) {
			var resposta = xmlHttp.responseText;
			location.reload();
		}
	}
	xmlHttp.open("GET",pagina+Oque,false);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function montaSelectCampanhasArvoreGrupos(){
	var idGrupo = document.getElementById("idGrupo").value;
	var pagina = document.getElementById('moduloGruposCampanhas').value;
	var Oque = "?acao=carregaCampanhasGrupo&idGrupo="+idGrupo;
	var campanhasJson = document.getElementById("campanhasJson").value;
	var campanhasL = jsonParse(campanhasJson);
	var selectL = document.getElementById("campanhasL[]");
	var selectR = document.getElementById("campanhasR[]");
	var inserido = false;
	selectL.options.length = 0;
	selectR.options.length = 0;
	document.getElementById("prioridadeCamp").value = "";
	
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4) {
			var resposta = xmlHttp.responseText;
			console.log(resposta);
			if(resposta!=""){
				var campanhasR = jsonParse(resposta);
				for(var i = 0; i < campanhasL.length; i++){
					inserido = false;
					var option = document.createElement("option");
					option.value = campanhasL[i].nome;
					option.text = campanhasL[i].nome;
					for(var j = 0; j < campanhasR.length; j++){
						if(campanhasL[i].nome == campanhasR[j].nome){
							if(idGrupo == campanhasR[j].grupo){
								selectR.add(option);
							}
							inserido = true;
						}
					}
					if(!inserido){
						selectL.add(option);
					}
				}
			} else {
				for(var i = 0; i < campanhasL.length; i++){
					var option = document.createElement("option");
					option.value = campanhasL[i].nome;
					option.text = campanhasL[i].nome;
					selectL.add(option);
				}
			}
		}
	}
	xmlHttp.open("GET",pagina+Oque,false);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function addCampanhaGrupo(){
	var selectL = document.getElementById("campanhasL[]");
	var idGrupo = document.getElementById("idGrupo").value;
	var campanha = selectL.options[selectL.selectedIndex];
	var pagina = document.getElementById('moduloGruposCampanhas').value;
	var Oque = "?acao=addCampanhaGrupo&campanha="+campanha.value+"&idGrupo="+idGrupo;
	
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4) {
			var resposta = xmlHttp.responseText;
			console.log(resposta);
			//location.reload();
		}
	}
	xmlHttp.open("GET",pagina+Oque,false);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function mostrarPrioridadeCamp(){
	var selectR = document.getElementById("campanhasR[]");
	var campanha = selectR.options[selectR.selectedIndex];
	var pagina = document.getElementById('moduloGruposCampanhas').value;
	var Oque = "?acao=carregaPrioridadeCampanha&campanha="+campanha.value;
	var prioTxt = document.getElementById("prioridadeCamp");
	
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4) {
			var resposta = xmlHttp.responseText;
			console.log(resposta);
			prioTxt.value = resposta;
		}
	}
	xmlHttp.open("GET",pagina+Oque,false);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function alteraPrioridadeCampanha(){
	var selectR = document.getElementById("campanhasR[]");
	var campanha = selectR.options[selectR.selectedIndex];
	var prioTxt = document.getElementById("prioridadeCamp");
	var pagina = document.getElementById('moduloGruposCampanhas').value;
	var Oque = "?acao=alterarPrioridadeCamp&campanha="+campanha.value+"&prioridade="+prioTxt.value;
	
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4) {
			var resposta = xmlHttp.responseText;
			console.log(resposta);
		}
	}
	xmlHttp.open("GET",pagina+Oque,false);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function mostrarPrioridadeGrup(){
	var selectR = document.getElementById("filhosR[]");
	var grupo = selectR.options[selectR.selectedIndex];
	var pagina = document.getElementById('moduloGruposCampanhas').value;
	var Oque = "?acao=carregaPrioridadeGrupo&grupo="+grupo.value;
	var prioTxt = document.getElementById("prioridadeGrupo");
	var tipoTxt = document.getElementById("tipoGrupo");
	
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4) {
			var resposta = xmlHttp.responseText;
			console.log(resposta);
			var dados = jsonParse(resposta);
			prioTxt.value = dados.prioridade;
			tipoTxt.value = dados.tipo;
		}
	}
	xmlHttp.open("GET",pagina+Oque,false);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function alteraTipoGrupo(){
	var selectR = document.getElementById("filhosR[]");
	var grupo = selectR.options[selectR.selectedIndex];
	var tipoTxt = document.getElementById("tipoGrupo");
	var pagina = document.getElementById('moduloGruposCampanhas').value;
	var Oque = "?acao=alterarTipoGrupo&grupo="+grupo.value+"&tipo="+tipoTxt.value;
	
	var xmlHttp = GetXmlHttpObject();
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4) {
			var resposta = xmlHttp.responseText;
			console.log(resposta);
		}
	}
	xmlHttp.open("GET",pagina+Oque,false);
	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.setRequestHeader('Content-length', Oque.length );
	xmlHttp.setRequestHeader('encoding','ISO-8859-1');
	xmlHttp.send(null);
}

function carregaEstatisticasCampanhas(tipo){
	if(typeof(tipo)=="undefined") tipo = "";
	var qtdPesqFeita = document.getElementById('qtdPesqFeita');
	var qtdPesqNeces = document.getElementById('qtdPesqNeces').value;
	var pagina = document.getElementById('moduloGerencia').value;
	var oque = "?acao=carregaEstatisticasCampanha";
	var xmlHttp = GetXmlHttpObject();
	
	qtdPesqFeita.value++;
	if(parseInt(qtdPesqFeita.value) >= parseInt(qtdPesqNeces) || tipo == "manual"){
		xmlHttp.onreadystatechange=function()
		{
			if(xmlHttp.readyState==4) {
				var resposta = xmlHttp.responseText;
				var camp = jsonParse("["+resposta+"]");
				
				for(var i in camp){
					if(document.getElementById('evt_'+camp[i].id)!=null)document.getElementById('evt_'+camp[i].id).innerHTML = camp[i].estatisticas.total_eventos;
					if(document.getElementById('aproc_'+camp[i].id)!=null)document.getElementById('aproc_'+camp[i].id).innerHTML = camp[i].estatisticas.total_eventos_a_proc;
					if(document.getElementById('mail_'+camp[i].id)!=null)document.getElementById('mail_'+camp[i].id).innerHTML = camp[i].estatisticas.total_eventos_a_proc_mail;
					if(document.getElementById('reag_'+camp[i].id)!=null)document.getElementById('reag_'+camp[i].id).innerHTML = camp[i].estatisticas.total_reagendamentos;
					if(document.getElementById('%aproc_'+camp[i].id)!=null)document.getElementById('%aproc_'+camp[i].id).innerHTML = camp[i].estatisticas.porcent_eventos_a_proc;
					if(document.getElementById('%mail_'+camp[i].id)!=null)document.getElementById('%mail_'+camp[i].id).innerHTML = camp[i].estatisticas.porcent_eventos_a_proc_mail;
					if(document.getElementById('%reag_'+camp[i].id)!=null)document.getElementById('%reag_'+camp[i].id).innerHTML = camp[i].estatisticas.porcent_eventos_a_proc_reag;
					if(document.getElementById('regmail_'+camp[i].id)!=null)document.getElementById('regmail_'+camp[i].id).innerHTML = camp[i].estatisticas.telefones_a_processar_mail;
					if(document.getElementById('regreag_'+camp[i].id)!=null)document.getElementById('regreag_'+camp[i].id).innerHTML = camp[i].estatisticas.telefones_a_processar_reag;
				}
			}
		}
		xmlHttp.open("GET",pagina+oque,false);
		xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xmlHttp.setRequestHeader('Content-length', oque.length );
		xmlHttp.setRequestHeader('encoding','ISO-8859-1');
		xmlHttp.send(null);
		qtdPesqFeita.value = "0";
	}
	if(tipo!="manual") window.setTimeout("carregaEstatisticasCampanhas()", 1000);
}
