<?php
/***********************************************************
 * Nome:      grvselect.modu.php
 * Autor:     Leandro N. de Araujo
 * Data:      08/08/2011
 * Descrio: Arquivo responsavel por passar a busca da tela
 *            de gravacoes para o banco de dados
 *            e montar a tabela de
 *            resultado da pesquisa
 */

header('Cache-Control: no-cache, must-revalidate');
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');

$DirRaiz = $_SERVER['DOCUMENT_ROOT'] . '/vdt/';
include_once $DirRaiz . 'config.php';
include_once $DirRaiz . 'config.grava.php';
include_once $DirRaiz . $DirGrava . $DirClass . 'gravacao.class.php';
$Modulo = $DirGrava;

$L_var = $_GET; // Recebe as variaveis do formulario
$Grv = new Gravacao; // Objeto gravacao

if ($L_var["acao"] == "gerarelatorio") {
	$GrupoDAC = array();
	$Agentes = array();
	$Filas = array();
	$Ramais = array();
	for ($i = 0; $i < $L_var['totalgrupo']; $i++) {
		$GrupoDAC[] = $L_var['grupo' . $i];
	}
	for ($i = 0; $i < $L_var['totalfila']; $i++) {
		$Filas[] = $L_var['fila' . $i];
	}
	for ($i = 0; $i < $L_var['totalagente']; $i++) {
		$Agentes[] = $L_var['agente' . $i];
	} //echo $L_var['totalgrupo'];
	for ($i = 0; $i < $L_var['totalramal']; $i++) {
		$Ramais[] = $L_var['ramal' . $i];
	}
	echo gera_relatorio($GrupoDAC, $Filas, $Agentes, $Ramais, $L_var["numero"], $L_var["tipo"], $L_var["d"], $L_var["a"], $L_var["u"], $L_var["ligacoesacimade"], $L_var['ligacoesabaixode'], $L_var['numerofiltro']);
}
return;

/******************************************
 * Funcao:    gera_relatorio
 * Descricao: Esta funcao recebe os grupos, filas e agentes para
 *            fazer a busca na tabela de gravacoes
 */
function gera_relatorio($GrupoDAC, $Filas, $Agentes, $Ramais, $Numero, $Tipo, $Periodo_d, $Periodo_a, $Usuario, $ligacoesAcimaDe, $ligacoesAbaixoDe, $numeroFiltro) {
	global $Grv;
	list($data, $horario) = explode(" ", $Periodo_d);
	list($dia, $mes, $ano) = explode("/", $data);
	list($hora, $minuto) = explode(":", $horario);
	$dia_auxiliar_d = $ano . "-" . $mes . "-" . $dia . " " . $hora . ":" . $minuto;

	list($data, $horario) = explode(" ", $Periodo_a);
	list($dia, $mes, $ano) = explode("/", $data);
	list($hora, $minuto) = explode(":", $horario);
	$dia_auxiliar_a = $ano . "-" . $mes . "-" . $dia . " " . $hora . ":" . $minuto;

	$Numero = trim($Numero);

	$Saida = "";
	$Saida .= '<p class="titulo">Perodo selecionado: ' . $Periodo_d . "  >>>  " . $Periodo_a;
	if ($Tipo == "filtro") {
		//if(!empty($GrupoDAC) && !empty($Filas) && !empty($Agentes)){
		$Saida .= '<table class="relat"><tr><td class="relatT">Data</td>';
		$Saida .= '<td class="relatT">Hora</td>';
		$Saida .= '<td class="relatT">Durao</td>';
		$Saida .= '<td class="relatT">Ramal</td>';
		$Saida .= '<td class="relatT">Agente</td>';
		$Saida .= '<td class="relatT">Nmero Telefnico</td>';
		$Saida .= '<td class="relatT">Tipo de Ligao</td>';
		$Saida .= '<td class="relatT">Observao</td>';
		$Saida .= '<td class="relatT">Ao</td>';
		$Saida .= '</tr>';

		$Tabela1 = $Grv->relatorio_geral($GrupoDAC, $Filas, $Agentes, $Ramais, $dia_auxiliar_d, $dia_auxiliar_a, $numeroFiltro);
		//echo $Tabela1;
		//return;
		$Saida .= monta_relatorio_grupos($Tabela1, $ligacoesAcimaDe, $ligacoesAbaixoDe);
	}
	if ($Tipo == "numero") {
		if ($Numero != "") {
			$Saida .= '<table class="relat"><tr><td class="relatT">Data</td>';
			$Saida .= '<td class="relatT">Hora</td>';
			$Saida .= '<td class="relatT">Durao</td>';
			$Saida .= '<td class="relatT">Ramal</td>';
			$Saida .= '<td class="relatT">Agente</td>';
			$Saida .= '<td class="relatT">Nmero Telefnico</td>';
			$Saida .= '<td class="relatT">Tipo de Ligao</td>';
			$Saida .= '<td class="relatT">Observao</td>';
			$Saida .= '<td class="relatT">Ao</td>';
			$Saida .= '</tr>';

			$Tabela3 = $Grv->relatorio_numero($Numero, $Usuario, $dia_auxiliar_d, $dia_auxiliar_a);
			//return print_r($Tabela3, true);
			$Saida .= monta_relatorio_numero($Tabela3, $ligacoesAcimaDe, $ligacoesAbaixoDe);
			//return monta_relatorio_numero($Tabela3, $ligacoesAcimaDe, $ligacoesAbaixoDe);
		}
	}
	$Saida .= '</table>';
	return $Saida;
}

/****************************************
 * Funcao:    monta_relatorio_grupos
 * Descricao: Esta funcao monta a tabela de pesquisa somente de
 *            grupos selecionados
 */
function monta_relatorio_grupos($Tabela1, $ligacoesAcimaDe, $ligacoesAbaixoDe) {
	global $LinkRaiz, $OndeGrav, $Grv;
	//return print_r($Tabela1, true);
	if (empty($Tabela1)) {
		$Saida = '<tr><td colspan="9" class="relatT">No h registros para o filtro selecionado!!!</td></tr>';
	} else {
		$Saida = "";
		for ($i = 0; $i < count($Tabela1); $i++) {
			if (/*$Tabela1[$i]['tipo'] != "Transferencia" && */$Tabela1[$i]['id_ligacao'] != $Tabela1[$i - 1]['id_ligacao']) {
				$Data = $Tabela1[$i]['diahora'];

                $lig = $Grv->getLigacao($Tabela1[$i]['id_ligacao']);
				if($Grv->checarAtendimento($lig) === true) $Duracao = $Grv->pega_duracao($lig);
                else continue;

				if ($Duracao <= $ligacoesAcimaDe || $Duracao >= $ligacoesAbaixoDe) {
					continue;
				}

                if($Tabela1[$i]['agente_o'] != '') $agente = $Tabela1[$i]['agente_o'];
                else $agente = $Tabela1[$i]['agente_d'];

                if($Tabela1[$i]['ramal_o'] != '') $ramal = $Tabela1[$i]['ramal_o'];
                else $ramal = $Tabela1[$i]['ramal_d'];

				$Saida .= '<tr><td class="relat">';
				$Saida .= substr($Data, 6, 2) . "/" . substr($Data, 4, 2) . "/" . substr($Data, 0, 4);
				$Saida .= '</td>';
				$Saida .= '<td class="relat">' . substr($Data, 8, 2) . ":" . substr($Data, 10, 2);
				$Saida .= '</td>';
				//$Saida.='<td class="relat">'.$Tabela1[$i]['id_ligacao'];
				$Saida .= '<td class="relat">' . formata_hora($Duracao);
				$Saida .= '</td>';
				$Saida .= '<td class="relat">' . $ramal . '</td>';
				$Saida .= '<td class="relat">' . $agente . '</td>';
				if ($Tabela1[$i]['tipo'] == "interna") {
					$Saida .= '<td class="relat">' . $Tabela1[$i]['ramal_d'] . '</td>';
				} else {
					$Saida .= '<td class="relat">' . $Tabela1[$i]['numero'] . '</td>';
				}

				$Saida .= '<td class="relat">' . $Tabela1[$i]['tipo'] . '</td>';
				$Saida .= '<td class="relat">' . $Tabela1[$i]['obs'] . '</td>';
				$Arquivo = $LinkRaiz . $OndeGrav . '/' . substr($Data, 0, 4) . '/' . substr($Data, 4, 2) . '/' . substr($Data, 6, 2) . '/' . $Tabela1[$i]['gravacao'];
				$Saida .= '<td class="relat"><a href="' . $Arquivo . '" target="_blank">Ouvir</a></td></tr>' . "\n";
				$Saida .= '</tr>' . "\n";
			}
		}
	}
	return $Saida;
}

function monta_relatorio_numero($Tabela3, $ligacoesAcimaDe, $ligacoesAbaixoDe) {
    global $LinkRaiz, $OndeGrav, $Grv;
    if (empty($Tabela3)) {
        $Saida = '<tr><td colspan="9" class="relatT">No h registros para o numero digitado!!!</td></tr>';
    } else {
        for ($i = 0; $i < count($Tabela3); $i++) {
            if ($Tabela3[$i]['tipo'] != "Transferencia") {
                $Data = $Tabela3[$i]['diahora'];

                $lig = $Grv->getLigacao($Tabela3[$i]['id_ligacao']);
                if($Grv->checarAtendimento($lig) == true) $Duracao = $Grv->pega_duracao($lig);
                else continue;
		
                if ($Duracao <= $ligacoesAcimaDe || $Duracao >= $ligacoesAbaixoDe) {
                    continue;
                }

                if($Tabela3[$i]['agente_o'] != '') $agente = $Tabela3[$i]['agente_o'];
                else $agente = $Tabela3[$i]['agente_d'];

                if($Tabela3[$i]['ramal_o'] != '') $ramal = $Tabela3[$i]['ramal_o'];
                else $ramal = $Tabela3[$i]['ramal_d'];

                $Saida .= '<tr><td class="relat">';
                $Saida .= substr($Data, 6, 2) . "/" . substr($Data, 4, 2) . "/" . substr($Data, 0, 4);
                $Saida .= '</td>';
                $Saida .= '<td class="relat">' . substr($Data, 8, 2) . ":" . substr($Data, 10, 2);
                $Saida .= '</td>';
                $Saida .= '<td class="relat">' . formata_hora($Duracao);
                $Saida .= '</td>';
                $Saida .= '<td class="relat">' . $ramal . '</td>';
                $Saida .= '<td class="relat">' . $agente . '</td>';
                $Saida .= '<td class="relat">' . $Tabela3[$i]['numero'] . '</td>';
                $Saida .= '<td class="relat">' . $Tabela3[$i]['tipo'] . '</td>';
                $Saida .= '<td class="relat">' . $Tabela3[$i]['obs'] . '</td>';
                $Arquivo = $LinkRaiz . $OndeGrav . '/' . substr($Data, 0, 4) . '/' . substr($Data, 4, 2) . '/' . substr($Data, 6, 2) . '/' . $Tabela3[$i]['gravacao'];
                $Saida .= '<td class="relat"><a href="' . $Arquivo . '" target="_blank">Ouvir</a></td></tr>' . "\n";
                $Saida .= '</tr>' . "\n";
            }
        }
    }
    return $Saida;
}
?>
