CREATE OR REPLACE FUNCTION vm50_nao_insere_duplicatas() RETURNS trigger AS '
  DECLARE
    id_number INTEGER;
    numero_chamando VARCHAR;
    nome_fila VARCHAR;
    nome_pausa VARCHAR;
    nome_tronco VARCHAR;
    dados_agente RECORD;
  BEGIN

  --
  -- Descobre o nome do agente
  --
  SELECT INTO dados_agente * FROM vm50_agentes WHERE login=NEW.agente;
  IF ((NOT FOUND) OR (NEW.agente = '''')) THEN
    IF (NEW.fila = ''FILA'') THEN
      NEW.fila := NEW.numero;
      NEW.agente := ''0000'';
      NEW.numero := '''';
      SELECT INTO numero_chamando numero_orig FROM vm50_link_ligacao WHERE id_orig=NEW.ligacao OR id_dest=NEW.ligacao;
      IF FOUND THEN
        NEW.numero := numero_chamando;
      END IF;
      SELECT INTO nome_fila pseudonimo FROM vm50_filas WHERE trim(nome)=trim(NEW.fila);
      IF NOT FOUND THEN
        RETURN NULL;
      END IF;
      NEW.fila := nome_fila;
    ELSE
      IF (NEW.fila != ''Fazendo chamada externa'') AND (NEW.fila != ''DDR'') AND (NEW.fila != ''Consulta'') AND (substr(NEW.fila,0,20) != ''Transfer&ecirc;ncia-'') THEN
        RETURN NULL;
      END IF;
    END IF;
  ELSE
    -- NEW.agente := NEW.agente || ''-'' || dados_agente.nome;
    NEW.agente := NEW.agente || ''-'' || dados_agente.pseudonimo;
  END IF;

  --
  -- Descobre o nome da fila
  --
  SELECT INTO numero_chamando pseudonimo FROM vm50_filas WHERE pseudonimo=NEW.numero OR nome=NEW.numero;
  IF FOUND THEN
    SELECT INTO numero_chamando numero_orig FROM vm50_link_ligacao WHERE id_orig=NEW.ligacao OR id_dest=NEW.ligacao;
    IF FOUND THEN
      NEW.numero := numero_chamando;
    ELSE
      SELECT INTO numero_chamando numero FROM vm50_relatorios_cc WHERE ligacao=NEW.ligacao AND numero!=NEW.numero;
      IF FOUND THEN
        NEW.numero := numero_chamando;
      ELSE
        NEW.numero := '''';
      END IF;
    END IF;
  END IF;
  IF ((NEW.fila = ''FILA'') OR (NEW.fila = '''')) THEN
    SELECT INTO nome_fila numero_dest FROM vm50_link_ligacao WHERE id_orig=NEW.ligacao OR id_dest=NEW.ligacao;
    SELECT INTO numero_chamando pseudonimo FROM vm50_filas WHERE pseudonimo=nome_fila;
    IF FOUND THEN
      NEW.fila := nome_fila;
    END IF;
  END IF;

  --
  -- Arruma transferencia
  --
  IF (substr(NEW.fila,0,20) = ''Transfer&ecirc;ncia-'') THEN
    SELECT INTO nome_fila pseudonimo FROM vm50_filas WHERE trim(nome)=trim(substr(NEW.fila,21));
    IF FOUND THEN
      NEW.fila := nome_fila;
    END IF;
  ELSE
    SELECT INTO nome_fila pseudonimo FROM vm50_filas WHERE trim(nome)=trim(NEW.fila);
    IF FOUND THEN
      NEW.fila := nome_fila;
    END IF;
  END IF;
  --
  NEW.funcai := dados_agente.funcai;
  NEW.loginr := dados_agente.loginr;
  NEW.grupos := dados_agente.grupos;

  --
  -- Descobre quem estah no ramal
  --
  IF (NEW.numero != '''') THEN
    SELECT INTO dados_agente * FROM vm50_agentes WHERE ramal=NEW.numero;
    IF FOUND THEN
      NEW.numero := dados_agente.login || ''-'' || dados_agente.pseudonimo;
    END IF;
  END IF;

  --
  -- Nao permitir fila com NULL
  --
  IF (NEW.fila = ''NULL'') THEN
    RETURN NULL;
--  ELSE
--    SELECT INTO numero_chamando pseudonimo FROM vm50_filas WHERE pseudonimo=NEW.fila;
--    IF FOUND THEN
--      NEW.fila := nome_fila;
--    ELSE
--      IF (substr(NEW.fila,0,8) = ''Externo-'') THEN
--        NEW.fila := ''Fazendo chamada externa'';
--      ELSE
--        NEW.fila := '''';
--      END IF;
--    END IF;
  END IF;

  --
  -- Nao permitir consultas duplicadas
  --
  IF (NEW.fila = ''Consulta'') AND (NEW.agente = NEW.numero) THEN
    RETURN NULL;
  END IF;

  --
  -- Nao permitir numero com nome de tronco
  --
  SELECT INTO nome_tronco numero_asterisk FROM vm50_troncos WHERE numero_asterisk=NEW.numero LIMIT 1;
  IF FOUND THEN
    RETURN NULL;
  END IF;

  --
  -- Arruma o Livre
  --
  IF (NEW.oque = ''Livre'') THEN
    NEW.fila = '''';
    NEW.ligacao = '''';
  END IF;

  --
  -- Nao permitir entradas duplicadas
  --
  IF (NEW.fila!= '''') AND (NEW.ligacao!='''') AND (NEW.numero!='''') AND (NEW.oque!='''') THEN
    IF (NEW.fila = ''Fazendo chamada externa'') OR (NEW.fila = ''DDR'') OR (NEW.fila = ''Consulta'') OR (substr(NEW.fila,0,20) = ''Transfer&ecirc;ncia-'') THEN
      SELECT INTO id_number id FROM vm50_relatorios_cc WHERE agente=NEW.agente AND fila=NEW.fila AND ligacao=NEW.ligacao AND numero=NEW.numero AND oque=NEW.oque;
      IF FOUND THEN
        RETURN NULL;
      END IF;
    END IF;
  END IF;

  RETURN NEW;

 END;
' LANGUAGE 'plpgsql';




CREATE OR REPLACE FUNCTION vm50_arruma_gravacoes() RETURNS trigger AS '
  DECLARE
    dados_ligacao RECORD;
    dados_agente  RECORD;
    id_falso      CHAR(1);
    conversa      VARCHAR;
    ramal         CHAR(4);
  BEGIN

  SELECT INTO dados_ligacao * FROM vm50_link_ligacao WHERE id_orig=NEW.id_ligacao OR id_dest=NEW.id_ligacao;
  IF FOUND THEN
    -- >>>Nao deixa inserir com ramal inexistente
    IF (NEW.ramal_o > ''!'') THEN
      SELECT INTO ramal ramal FROM vm50_ramais WHERE ramal=NEW.ramal_o;
      IF NOT FOUND THEN
        NEW.ramal_o = '''';
      END IF;
    END IF;
    IF (NEW.ramal_d > ''!'') THEN
      SELECT INTO ramal ramal FROM vm50_ramais WHERE ramal=NEW.ramal_d;
      IF NOT FOUND THEN
        NEW.ramal_d = '''';
      END IF;
    END IF;
    -- <<<Nao deixa inserir com ramal inexistente

    SELECT INTO id_falso falso FROM vm50_ligacao_id WHERE id=NEW.id_ligacao;
    IF FOUND THEN
      IF (falso = ''1'') THEN
        NEW.duracao = '''';
      END IF;
    END IF;


    IF (dados_ligacao.obs = ''FILA'') THEN
      IF (dados_ligacao.conversou = ''1'') THEN
        NEW.fila    := dados_ligacao.fila_original;
        NEW.ramal_d := dados_ligacao.pa;
        SELECT INTO dados_agente * FROM vm50_agentes WHERE ramal=NEW.ramal_d;
        IF ((FOUND) AND (dados_agente.ramal=NEW.ramal_d) AND (NEW.ramal_d>''!'')) THEN
          NEW.agente_d := dados_agente.login || ''-'' || dados_agente.pseudonimo;
        ELSE
          SELECT INTO dados_agente * FROM vm50_ramais WHERE ramal=NEW.ramal_d;
          IF FOUND THEN
            NEW.usuario_d := dados_agente.pseudonimo;
          END IF;
        END IF;
        NEW.tipo := ''fila'';
--      ELSIF (dados_ligacao.obs = ''Fazendo chamada externa'') THEN
--        NEW.fila    := dados_ligacao.fila_original;
--        NEW.ramal_d := dados_ligacao.pa;
--        SELECT INTO dados_agente * FROM vm50_agentes WHERE ramal=NEW.ramal_d;
--        IF FOUND THEN
--          NEW.agente_d := dados_agente.login || ''-'' || dados_agente.pseudonimo;
--        ELSE
--          SELECT INTO dados_agente * FROM vm50_ramais WHERE ramal=NEW.ramal_d;
--          IF FOUND THEN
--            NEW.usuario_d := dados_agente.pseudonimo;
--          END IF;
--        END IF;
--        NEW.tipo := ''fila'';
      ELSE
        RETURN NULL;
      END IF;
    END IF;
--  ELSE
--    RETURN NULL;
  END IF;
  RETURN NEW;
  END;
' LANGUAGE 'plpgsql';


