<?php
/**************************************************************
 * Nome:    Gravacao
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2009-11-29 (V1.0.1)
 * Descr.:  Cria classe de gravacao
 *************************************************************/


/**************************************************************
  Classe Gravacao
 *************************************************************/
class Gravacao {
  var $Bd;
  var $TabelaR;
  var $Hoje;


  //---------------------------------------------------
  // Construtor da classe.
  //---------------------------------------------------
  function Gravacao() {
    $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
    include($DirRaiz.'config.php');
    include($DirRaiz.'config.grava.php');
    include_once($DirRaiz.$DirClass.'bd.class.php');
    include_once($DirRaiz.$DirModul.'geral.modu.php');
    $this->Bd      = new Banco();
    $this->TabelaR = $Tb_RGrav;
    $this->Hoje    = date("d/m/y");
  }


  //---------------------------------------------------
  // Funcao lista_gravacoes_por_periodo
  //---------------------------------------------------
  function lista_gravacoes_por_periodo($Per_d, $Per_a) {
    $Pes = "SELECT * FROM ".$this->TabelaR." WHERE duracao>'!' AND diahora>='".$Per_d."' AND diahora<='".$Per_a."' AND (duracao !='' AND duracao IS NOT NULL)";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) $Saida = false;
    else $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_agentes_gravacoes_por_periodo
  //---------------------------------------------------
  function lista_agentes_gravacoes_por_periodo($Per_d, $Per_a) {
    $Pes = "SELECT agente_o FROM ".$this->TabelaR." WHERE duracao>'!' AND diahora>='".$Per_d."' AND diahora<='".$Per_a."' AND (duracao !='' AND duracao IS NOT NULL) GROUP BY agente_o";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) return false;
    else {
      $Lista1 = $Lista2 = array();
      for ($x=0; $x<count($Res); $x++) {
        if ($Res[$x]['agente_o']>"") $Lista1[] = $Res[$x]['agente_o'];
      }
      $Pes = "SELECT agente_d FROM ".$this->TabelaR." WHERE duracao>'!' AND diahora>='".$Per_d."' AND diahora<='".$Per_a."' AND (duracao !='' AND duracao IS NOT NULL) GROUP BY agente_d";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) return false;
      else {
        for ($x=0; $x<count($Res); $x++) {
          if ($Res[$x]['agente_d']>"") $Lista2[] = $Res[$x]['agente_d'];
        }
        $Lista = array_merge($Lista1, $Lista2);
        $Lista = array_unique($Lista);
      }
      sort($Lista);
    }
    return $Lista;
  }


  //---------------------------------------------------
  // Funcao lista_gruposdac_gravacoes_por_periodo
  //---------------------------------------------------
  function lista_gruposdac_gravacoes_por_periodo($Per_d, $Per_a) {
    $Pes = "SELECT grupodac_o FROM ".$this->TabelaR." WHERE duracao>'!' AND diahora>='".$Per_d."' AND diahora<='".$Per_a."' AND (duracao !='' AND duracao IS NOT NULL) GROUP BY grupodac_o";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) return false;
    else {
      $Lista1 = $Lista2 = array();
      for ($x=0; $x<count($Res); $x++) {
        if ($Res[$x]['grupodac_o']>"") $Lista1[] = $Res[$x]['grupodac_o'];
      }
      $Pes = "SELECT grupodac_d FROM ".$this->TabelaR." WHERE duracao>'!' AND diahora>='".$Per_d."' AND diahora<='".$Per_a."' AND (duracao !='' AND duracao IS NOT NULL) GROUP BY grupodac_d";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) return false;
      else {
        for ($x=0; $x<count($Res); $x++) {
          if ($Res[$x]['grupodac_d']>"") $Lista1[] = $Res[$x]['grupodac_d'];
        }
        $Lista = array_merge($Lista1, $Lista2);
        $Lista = array_unique($Lista);
      }
      sort($Lista);
    }
    return $Lista;
  }


  //---------------------------------------------------
  // Funcao lista_grupospbx_gravacoes_por_periodo
  //---------------------------------------------------
  function lista_grupospbx_gravacoes_por_periodo($Per_d, $Per_a) {
    $Pes = "SELECT grupopabx_o FROM ".$this->TabelaR." WHERE duracao>'!' AND diahora>='".$Per_d."' AND diahora<='".$Per_a."' AND (duracao !='' AND duracao IS NOT NULL) GROUP BY grupopabx_o";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) return false;
    else {
      $Lista1 = $Lista2 = array();
      for ($x=0; $x<count($Res); $x++) {
        if ($Res[$x]['grupopabx_o']>"") $Lista1[] = $Res[$x]['grupopabx_o'];
      }
      $Pes = "SELECT grupopabx_d FROM ".$this->TabelaR." WHERE duracao>'!' AND diahora>='".$Per_d."' AND diahora<='".$Per_a."' AND (duracao !='' AND duracao IS NOT NULL) GROUP BY grupopabx_d";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) return false;
      else {
        for ($x=0; $x<count($Res); $x++) {
          if ($Res[$x]['grupopabx_d']>"") $Lista1[] = $Res[$x]['grupopabx_d'];
        }
        $Lista = array_merge($Lista1, $Lista2);
        $Lista = array_unique($Lista);
      }
      sort($Lista);
    }
    return $Lista;
  }


  //---------------------------------------------------
  // Funcao lista_ramais_gravacoes_por_periodo
  //---------------------------------------------------
  function lista_ramais_gravacoes_por_periodo($Per_d, $Per_a) {
    $Pes = "SELECT ramal_o FROM ".$this->TabelaR." WHERE duracao>'!' AND diahora>='".$Per_d."' AND diahora<='".$Per_a."' AND (duracao !='' AND duracao IS NOT NULL) GROUP BY ramal_o";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) return false;
    else {
      $Lista1 = $Lista2 = array();
      for ($x=0; $x<count($Res); $x++) {
        if ($Res[$x]['ramal_o']>"") $Lista1[] = $Res[$x]['ramal_o'];
      }
      $Pes = "SELECT ramal_d FROM ".$this->TabelaR." WHERE duracao>'!' AND diahora>='".$Per_d."' AND diahora<='".$Per_a."' AND (duracao !='' AND duracao IS NOT NULL) GROUP BY ramal_d";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) return false;
      else {
        for ($x=0; $x<count($Res); $x++) {
          if ($Res[$x]['ramal_d']>"") $Lista1[] = $Res[$x]['ramal_d'];
        }
        $Lista = array_merge($Lista1, $Lista2);
        $Lista = array_unique($Lista);
      }
      sort($Lista);
    }
    return $Lista;
  }


  //---------------------------------------------------
  // Funcao lista_filas_gravacoes_por_periodo
  //---------------------------------------------------
  function lista_filas_gravacoes_por_periodo($Per_d, $Per_a) {
    $Pes = "SELECT fila FROM ".$this->TabelaR." WHERE duracao>'!' AND diahora>='".$Per_d."' AND diahora<='".$Per_a."' AND (duracao !='' AND duracao IS NOT NULL) GROUP BY fila ORDER BY fila";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) return false;
    else {
      $Lista = array();
      for ($x=0; $x<count($Res); $x++) {
        if ($Res[$x]['fila']>"") $Lista[] = $Res[$x]['fila'];
      }
    }
    return $Lista;
  }


  //---------------------------------------------------
  // Funcao lista_relatorio_geral
  //---------------------------------------------------
  function lista_relatorio_geral($Per_d, $Per_a, $Agentes, $GrupDAC, $GrupPBX, $Filas, $Ramais) {
//    if ((!is_array($Agentes)) || (!is_array($GrupDAC)) || (!is_array($GrupPBX)) || (!is_array($Filas)) || (!is_array($Ramais))) return false;
    //$Pes = "SELECT * FROM ".$this->TabelaR." WHERE duracao>'!' AND diahora>='".$Per_d."' AND diahora<='".$Per_a."' AND (duracao !='' AND duracao IS NOT NULL)";
    $Pes = "SELECT * FROM ".$this->TabelaR." WHERE diahora>='".$Per_d."' AND diahora<='".$Per_a."'";
    if (count($Agentes)>0) {
      $Pes .= " AND (";
      for ($k=0; $k<count($Agentes); $k++) $Pes .= "agente_o='".$Agentes[$k]."' OR agente_d='".$Agentes[$k]."' OR ";
      $Pes = substr($Pes,0,strlen($Pes)-4);
      $Pes .= ")";
    }
    if (count($GrupDAC)>0) {
      $Pes .= " AND (";
      for ($k=0; $k<count($GrupDAC); $k++) $Pes .= "grupodac_o='".$GrupDAC[$k]."' OR grupodac_d='".$GrupDAC[$k]."' OR ";
      $Pes = substr($Pes,0,strlen($Pes)-4);
      $Pes .= ")";
    }
    if (count($GrupPBX)>0) {
      $Pes .= " AND (";
      for ($k=0; $k<count($GrupPBX); $k++) $Pes .= "grupopabx_o='".$GrupPBX[$k]."' OR grupopabx_d='".$GrupPBX[$k]."' OR ";
      $Pes = substr($Pes,0,strlen($Pes)-4);
      $Pes .= ")";
    }
    if (count($Filas)>0) {
      $Pes .= " AND (";
      for ($k=0; $k<count($Filas); $k++)   $Pes .= "fila='".$Filas[$k]."' OR ";
      $Pes = substr($Pes,0,strlen($Pes)-4);
      $Pes .= ")";
    }
    if (count($Ramais)>0) {
      $Pes .= " AND (";
      for ($k=0; $k<count($Ramais); $k++)  $Pes .= "ramal_o='".$Ramais[$k]."' OR ramal_d='".$Ramais[$k]."' OR ";
      $Pes = substr($Pes,0,strlen($Pes)-4);
      $Pes .= ")";
    }
    $Pes .= " ORDER BY diahora";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) return false;
    return $Res;
  }


  //---------------------------------------------------
  // Funcao lista_relatorio_por_telefone
  //---------------------------------------------------
  function lista_relatorio_por_telefone($Per_d, $Per_a, $Telefone) {
//    if ((!is_array($Agentes)) || (!is_array($GrupDAC)) || (!is_array($GrupPBX)) || (!is_array($Filas)) || (!is_array($Ramais))) return false;
    $Pes = "SELECT * FROM ".$this->TabelaR." WHERE duracao>'!' AND diahora>='".$Per_d."' AND diahora<='".$Per_a."' AND numero LIKE '%".$Telefone."%' AND (duracao !='' AND duracao IS NOT NULL) ORDER BY diahora";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) return false;
    return $Res;
  }


}
?>
