<?php
/**************************************************************
 * Nome:    GRVSelect
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2009-11-29 (V1.0.0)
 * Descr.:  Monta os selects

/**************************************************************
  Cabecalho para nao fazer cache
 *************************************************************/
  header('Cache-Control: no-cache, must-revalidate');
  header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');


/**************************************************************
  Area dos includes
 *************************************************************/
  $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
  include_once($DirRaiz.'config.php');
  include_once($DirRaiz.'config.grava.php');
  include_once($DirRaiz.$DirGrava.$DirClass.'gravacao.class.php');
  $Modulo = $DirGrava;


/**************************************************************
  Definicao de variaveis
 *************************************************************/
  $L_var = $_GET;         // Recebe as variaveis do formulario
  $Grv = new Gravacao; // Objeto gravacao


/**************************************************************
  Programa principal
 *************************************************************/
 if ($L_var['acao']=="geratudo") {
   echo monta_tudo($L_var['d'],$L_var['a'])."<br/><br/>";
 } elseif ($L_var['acao']=="relatorio") {
   $Agentes = array(); for ($k=0; $k<$L_var['totalagente']; $k++)    $Agentes[] = $L_var['agente'.$k];
   $GrupDAC = array(); for ($k=0; $k<$L_var['totalgruposdac']; $k++) $GrupDAC[] = $L_var['gruposdac'.$k];
   $GrupPBX = array(); for ($k=0; $k<$L_var['totalgrupospbx']; $k++) $GrupPBX[] = $L_var['grupospbx'.$k];
   $Filas   = array(); for ($k=0; $k<$L_var['totalfila']; $k++)      $Filas[]   = $L_var['fila'.$k];
   $Ramais  = array(); for ($k=0; $k<$L_var['totalramais']; $k++)    $Ramais[]  = $L_var['ramal'.$k];
   $Telefone = $L_var['numerotelefone'];
   echo resultado_pesquisa($L_var['d'],$L_var['a'],$Agentes,$GrupDAC,$GrupPBX,$Filas,$Ramais,$Telefone)."<br/><br/>";
 }
 return;



/**************************************************************
  Funcao monta_tudo
 *************************************************************/
 function monta_tudo($Per_d, $Per_a){
   global $Grv;
   $De = substr($Per_d,6,4).substr($Per_d,3,2).substr($Per_d,0,2).substr($Per_d,11,2).substr($Per_d,14,2).substr($Per_d,17,2);
   $Aa = substr($Per_a,6,4).substr($Per_a,3,2).substr($Per_a,0,2).substr($Per_a,11,2).substr($Per_a,14,2).substr($Per_a,17,2);
   if (!($De) || ($De<0)) return "Perodo invlido";
   if (!($Aa) || ($Aa<0)) return "Perodo invlido";
   $Saida  = '';

   $Agente = $Grv->lista_agentes_gravacoes_por_periodo($De, $Aa);
//$Saida = print_r($Agente);
//return $Saida;
   $Saida .= '<div id="a1" style="{display:block; width:135px; height:75px; float:left; padding:0 0 0 5px;}">'."\n";
   $Saida .= '<p class="titulo3">Agentes:</p>'."\n";
   $Saida .= '<select name="Agentes" id="Agentes" size="3" multiple style="{width:133px; float:left; margin:0;}">'."\n";
   for ($x=0; $x<count($Agente); $x++) $Saida .= '<option value="'.$Agente[$x].'">'.$Agente[$x].'</option>'."\n";
   $Saida .= '</select>'."\n";
   $Saida .= '</div>'."\n";

   $Grudac = $Grv->lista_gruposdac_gravacoes_por_periodo($De, $Aa);
   $Saida .= '<div id="a2" style="{display:block; width:135px; height:75px; float:left; padding:0 0 0 5px;}">'."\n";
   $Saida .= '<p class="titulo3">Grupos DAC:</p>'."\n";
   $Saida .= '<select name="Gruposdac" id="Gruposdac" size="3" multiple style="{width:133px; float:left; margin:0;}">'."\n";
   for ($x=0; $x<count($Grudac); $x++) $Saida .= '<option value="'.$Grudac[$x].'">'.$Grudac[$x].'</option>'."\n";
   $Saida .= '</select>'."\n";
   $Saida .= '</div>'."\n";

   $Grupbx = $Grv->lista_grupospbx_gravacoes_por_periodo($De, $Aa);
   $Saida .= '<div id="a3" style="{display:block; width:135px; height:75px; float:left; padding:0 0 0 5px;}">'."\n";
   $Saida .= '<p class="titulo3">Grupos PBX:</p>'."\n";
   $Saida .= '<select name="Grupospbx" id="Grupospbx" size="3" multiple style="{width:133px; float:left; margin:0;}">'."\n";
   for ($x=0; $x<count($Grupbx); $x++) $Saida .= '<option value="'.$Grupbx[$x].'">'.$Grupbx[$x].'</option>'."\n";
   $Saida .= '</select>'."\n";
   $Saida .= '</div>'."\n";

   $Filas = $Grv->lista_filas_gravacoes_por_periodo($De, $Aa);
   $Saida .= '<div id="a4" style="{display:block; width:135px; height:75px; float:left; padding:0 0 0 5px;}">'."\n";
   $Saida .= '<p class="titulo3">Filas:</p>'."\n";
   $Saida .= '<select name="filas" id="filas" size="3" multiple style="{width:133px; float:left; margin:0;}">'."\n";
   for ($x=0; $x<count($Filas); $x++) $Saida .= '<option value="'.$Filas[$x].'">'.$Filas[$x].'</option>'."\n";
   $Saida .= '</select>'."\n";
   $Saida .= '</div>'."\n";

   $Ramais = $Grv->lista_ramais_gravacoes_por_periodo($De, $Aa);
   $Saida .= '<div id="a5" style="{display:block; width:135px; height:75px; float:left; padding:0 0 0 5px;}">'."\n";
   $Saida .= '<p class="titulo3">Ramais:</p>'."\n";
   $Saida .= '<select name="ramais" id="ramais" size="3" multiple style="{width:133px; float:left; margin:0;}">'."\n";
   for ($x=0; $x<count($Ramais); $x++) {
     if ($Ramais[$x]!='1') $Saida .= '<option value="'.$Ramais[$x].'">'.$Ramais[$x].'</option>'."\n";
   }
   $Saida .= '</select>'."\n";
   $Saida .= '</div>'."\n";
   $Saida .= '<div style="{width:700px; height:30px; margin-top:80px;}"/>'."\n";
   $Saida .= '<span style="{float:left;}">ou pelo nmero de telefone discado/recebido <input type="text" name="numero_telefone" id="numero_telefone" class="texto" maxlength="50" style="{width:200px;}" /></span>'."\n";
   $Saida .= '<input type="button" name="botao_sx" id="botao_sx" class="botao" style="{float:right;}" value="Gera pesquisa" onclick="gera_pesquisa()"/>'."\n";
   $Saida .= '</div>'."\n";

   return $Saida;
 }



/**************************************************************
  Funcao monta_tudo
 *************************************************************/
 function resultado_pesquisa($Per_d, $Per_a, $Agentes, $GrupDAC, $GrupPBX, $Filas, $Ramais, $Telefone) {
   global $Grv, $LinkRaiz, $OndeGrav;
   $De = substr($Per_d,6,4).substr($Per_d,3,2).substr($Per_d,0,2).substr($Per_d,11,2).substr($Per_d,14,2).substr($Per_d,17,2);
   $Aa = substr($Per_a,6,4).substr($Per_a,3,2).substr($Per_a,0,2).substr($Per_a,11,2).substr($Per_a,14,2).substr($Per_a,17,2);
   if (!($De) || ($De<0)) return "Perodo invlido";
   if (!($Aa) || ($Aa<0)) return "Perodo invlido";
   if ((!is_array($Agentes)) || (!is_array($GrupDAC)) || (!is_array($GrupPBX)) || (!is_array($Filas)) || (!is_array($Ramais))) return "Erro interno. Nmero 513.";
   $Saida = '';
   if ($Telefone!="") {
     $Lista = $Grv->lista_relatorio_por_telefone($De, $Aa, $Telefone);
   } else {
     $Lista = $Grv->lista_relatorio_geral($De, $Aa, $Agentes, $GrupDAC, $GrupPBX, $Filas, $Ramais);
   }
   $Saida .= '<table class="relat">'."\n";
   $Saida .= '<tr><td class="relatT">Data</td><td class="relatT">Hora</td><td class="relatT">Durao</td><td class="relatT">Ramal</td><td class="relatT">Agente</td><td class="relatT">Nmero do Telefone</td><td class="relatT">Tipo de ligao</td><td class="relatT">Observao</td><td class="relatT"></td></tr>'."\n";
//   $Saida .= '<tr><td class="relatT">Data</td><td class="relatT">Hora</td><td class="relatT">Ramal</td><td class="relatT">Agente</td><td class="relatT">Nmero do Telefone</td><td class="relatT">Tipo de ligao</td><td class="relatT">Observao</td><td class="relatT"></td></tr>'."\n";
   for ($x=0; $x<count($Lista); $x++) {
     if($Lista[$x]['tipo'] != "Transferencia"){
     $Dia  = $Lista[$x]['dia'];
     $Hora = $Lista[$x]['hora'];
     $Saida .= '<tr><td class="relat">'.substr($Dia,0,2).'/'.substr($Dia,2,2).'/'.substr($Dia,4,4).'</td>';
     $Saida .= '<td class="relat">'.substr($Hora,0,2).':'.substr($Hora,2,2).'</td>';
     $Saida .= '<td class="relat">'.substr($Lista[$x]['duracao'],0,8).'</td>';
     if ($Lista[$x]['tipo']=="fila") {
       $Saida .= '<td class="relat">'.$Lista[$x]['ramal_o'].'</td>';
       $Saida .= '<td class="relat">'.$Lista[$x]['agente_o'].'</td>';
     } else {
       $Saida .= '<td class="relat">'.$Lista[$x]['ramal_o'].'</td>';
       $Saida .= '<td class="relat">'.$Lista[$x]['agente_o'].'</td>';
     }
     if ($Lista[$x]['tipo']=="interna") $Saida .= '<td class="relat">'.$Lista[$x]['ramal_d'].'</td>';
     else $Saida .= '<td class="relat">'.$Lista[$x]['numero'].'</td>';
     $Saida .= '<td class="relat">'.$Lista[$x]['tipo'].'</td>';
     $Saida .= '<td class="relat">'.$Lista[$x]['obs'].'</td>';
     $Ondeesta = $LinkRaiz.$OndeGrav.'/'.substr($Dia,4,4).'/'.substr($Dia,2,2).'/'.substr($Dia,0,2).'/'.$Lista[$x]['gravacao'];
     $Saida .= '<td class="relat"><a href="'.$Ondeesta.'" target="_blank">Ouvir</a></td></tr>'."\n";
   }
   }
   $Saida .= '</table>'."\n";
   return $Saida;
 }
?>
