<?php
/***********************************************************
 * Nome:      grvselect.modu.php
 * Autor:     Leandro N. de Araujo
 * Data:      08/08/2011
 * Descrio: Arquivo responsavel por passar a busca da tela 
 *            de gravacoes para o banco de dados
 *            e montar a tabela de 
 *            resultado da pesquisa 
 */

  header('Cache-Control: no-cache, must-revalidate');
  header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
  
  $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
  include_once($DirRaiz.'config.php');
  include_once($DirRaiz.'config.grava.php');
  include_once($DirRaiz.$DirGrava.$DirClass.'gravacao.class.php');
  $Modulo = $DirGrava;
  
  $L_var = $_GET;         // Recebe as variaveis do formulario
  $Grv = new Gravacao; // Objeto gravacao

  if($L_var["acao"]=="gerarelatorio"){
      $GrupoDAC = array();
      $Agentes = array();
      $Filas = array();
      for($i = 0; $i < $L_var['totalgrupo']; $i++){
          $GrupoDAC[] = $L_var['grupo'.$i];
      }
      for($i = 0; $i < $L_var['totalfila']; $i++){
          $Filas[] = $L_var['fila'.$i];
      }
      
      for($i = 0; $i < $L_var['totalagente']; $i++){
          $Agentes[] = $L_var['agente'.$i];
      }//echo $L_var['totalgrupo'];
      echo gera_relatorio($GrupoDAC,$Filas,$Agentes,$L_var["numero"],$L_var["tipo"],$L_var["d"],$L_var["a"],$L_var["u"]);
  }return;
  
  
  /******************************************
   * Funcao:    gera_relatorio
   * Descricao: Esta funcao recebe os grupos, filas e agentes para 
   *            fazer a busca na tabela de gravacoes
   */ 
  function gera_relatorio($GrupoDAC,$Filas,$Agentes,$Numero,$Tipo,$Periodo_d, $Periodo_a,$Usuario){
      global $Grv;
      list($data,$horario) = split(" ",$Periodo_d);
      list($dia,$mes,$ano) = split("/",$data);
      list($hora,$minuto)  = split(":",$horario);
      $dia_auxiliar_d = $ano."-".$mes."-".$dia." ".$hora.":".$minuto;
      
      list($data,$horario) = split(" ",$Periodo_a);
      list($dia,$mes,$ano) = split("/",$data);
      list($hora,$minuto)  = split(":",$horario);
      $dia_auxiliar_a = $ano."-".$mes."-".$dia." ".$hora.":".$minuto;
      
      $Saida = "";
      $Saida.= '<p class="titulo">Perido selecionado: '.$Periodo_d."  >>>  ".$Periodo_a;
      if($Tipo=="filtro"){
          //if(!empty($GrupoDAC) && !empty($Filas) && !empty($Agentes)){
          $Saida.= '<table class="relat"><tr><td class="relatT">Data</td>';
          $Saida.='<td class="relatT">Hora</td>';
          $Saida.='<td class="relatT">Durao</td>';
          $Saida.='<td class="relatT">Ramal</td>';
          $Saida.='<td class="relatT">Agente</td>';
          $Saida.='<td class="relatT">Nmero Telefnico</td>';
          $Saida.='<td class="relatT">Tipo de Ligao</td>';
          $Saida.='<td class="relatT">Observao</td>';
          $Saida.='<td class="relatT">Ao</td>';
          $Saida.='</tr>';

          $Tabela1 = $Grv->relatorio_geral($GrupoDAC, $Filas, $Agentes, $dia_auxiliar_d, $dia_auxiliar_a);
          $Saida .= monta_relatorio_grupos($Tabela1);
        }
	if($Tipo=="numero"){  
          if($Numero!=""){
              $Saida.= '<table class="relat"><tr><td class="relatT">Data</td>';
              $Saida.='<td class="relatT">Hora</td>';
              $Saida.='<td class="relatT">Durao</td>';
              $Saida.='<td class="relatT">Ramal</td>';
              $Saida.='<td class="relatT">Agente</td>';
              $Saida.='<td class="relatT">Nmero Telefnico</td>';
              $Saida.='<td class="relatT">Tipo de Ligao</td>';
              $Saida.='<td class="relatT">Observao</td>';
              $Saida.='<td class="relatT">Ao</td>';
              $Saida.='</tr>';

              $Tabela3 = $Grv->relatorio_numero($Numero, $Usuario, $dia_auxiliar_d, $dia_auxiliar_a);
              $Saida.= monta_relatorio_numero($Tabela3);
	  }
      }
      $Saida.='</table>';
      return $Saida;
  }
  
  
  /****************************************
   * Funcao:    monta_relatorio_grupos
   * Descricao: Esta funcao monta a tabela de pesquisa somente de 
   *            grupos selecionados 
   */
  function monta_relatorio_grupos($Tabela1){
      global $LinkRaiz, $OndeGrav;
      if(empty($Tabela1)){
          $Saida = '<tr><td colspan="9" class="relatT">No h registros para o filtro selecionado!!!</td></tr>';
      }else{
          $Saida = "";
          for($i = 0; $i < count($Tabela1); $i++){
              if($Tabela1[$i]['tipo'] != "Transferencia"){
                  $Data = $Tabela1[$i]['diahora'];
                  $Saida.='<tr><td class="relat">';
                  $Saida.= substr($Data,6,2)."/".substr($Data,4,2)."/".substr($Data,0,4);
                  $Saida.='</td>';
                  $Saida.='<td class="relat">'.substr($Data,8,2).":".  substr($Data,10,2);
                  $Saida.='</td>';
                  $Saida.='<td class="relat">'.substr($Tabela1[$i]['duracao'],0,8);
                  $Saida.='</td>';
                  $Saida.='<td class="relat">'.$Tabela1[$i]['ramal_o'].'</td>';
                  $Saida.='<td class="relat">'.$Tabela1[$i]['agente_o'].'</td>';
                  $Saida.='<td class="relat">'.$Tabela1[$i]['numero'].'</td>';
                  $Saida.='<td class="relat">'.$Tabela1[$i]['tipo'].'</td>';
                  $Saida.='<td class="relat">'.$Tabela1[$i]['obs'].'</td>';
                  $Arquivo = $LinkRaiz.$OndeGrav.'/'.substr($Data,0,4).'/'.substr($Data,4,2).'/'.substr($Data,6,2).'/'.$Tabela1[$i]['gravacao'];
                  $Saida .= '<td class="relat"><a href="'.$Arquivo.'" target="_blank">Ouvir</a></td></tr>'."\n";
                  $Saida.='</tr>'."\n";
              }
          }
      }
      return $Saida;
  }
  
  function monta_relatorio_grupo_agente($Tabela2){
      global $LinkRaiz, $OndeGrav;
      for($i = 0; $i < count($Tabela2); $i++){
          if($Tabela2[$i]['tipo'] != "Transferencia"){
              $Data = $Tabela2[$i]['diahora'];
              $Saida.='<tr><td class="relat">';
              $Saida.= substr($Data,6,2)."/".substr($Data,4,2)."/".substr($Data,0,4);
              $Saida.='</td>';
              $Saida.='<td class="relat">'.substr($Data,8,2).":".  substr($Data,10,2);
              $Saida.='</td>';
              $Saida.='<td class="relat">'.substr($Tabela2[$i]['duracao'],0,8);
              $Saida.='</td>';
              $Saida.='<td class="relat">'.$Tabela2[$i]['ramal_o'].'</td>';
              $Saida.='<td class="relat">'.$Tabela2[$i]['agente_o'].'</td>';
              $Saida.='<td class="relat">'.$Tabela2[$i]['numero'].'</td>';
              $Saida.='<td class="relat">'.$Tabela2[$i]['tipo'].'</td>';
              $Saida.='<td class="relat">'.$Tabela2[$i]['obs'].'</td>';
              $Arquivo = $LinkRaiz.$OndeGrav.'/'.substr($Data,0,4).'/'.substr($Data,4,2).'/'.substr($Data,6,2).'/'.$Tabela2[$i]['gravacao'];
              $Saida .= '<td class="relat"><a href="'.$Arquivo.'" target="_blank">Ouvir</a></td></tr>'."\n";
              $Saida.='</tr>'."\n";
          }
      }
      return $Saida;
  }

  function monta_relatorio_numero($Tabela3){
      global $LinkRaiz, $OndeGrav;
      if(empty ($Tabela3)){
          $Saida = '<tr><td colspan="9" class="relatT">No h registros para o numero digitado!!!</td></tr>';
      }else{
          for($i = 0; $i < count($Tabela3); $i++){
              if($Tabela3[$i]['tipo'] != "Transferencia"){
                  $Data = $Tabela3[$i]['diahora'];
                  $Saida.='<tr><td class="relat">';
                  $Saida.= substr($Data,6,2)."/".substr($Data,4,2)."/".substr($Data,0,4);
                  $Saida.='</td>';
                  $Saida.='<td class="relat">'.substr($Data,8,2).":".  substr($Data,10,2);
                  $Saida.='</td>';
                  $Saida.='<td class="relat">'.substr($Tabela3[$i]['duracao'],0,8);
                  $Saida.='</td>';
                  $Saida.='<td class="relat">'.$Tabela3[$i]['ramal_o'].'</td>';
                  $Saida.='<td class="relat">'.$Tabela3[$i]['agente_o'].'</td>';
                  $Saida.='<td class="relat">'.$Tabela3[$i]['numero'].'</td>';
                  $Saida.='<td class="relat">'.$Tabela3[$i]['tipo'].'</td>';
                  $Saida.='<td class="relat">'.$Tabela3[$i]['obs'].'</td>';
                  $Arquivo = $LinkRaiz.$OndeGrav.'/'.substr($Data,0,4).'/'.substr($Data,4,2).'/'.substr($Data,6,2).'/'.$Tabela3[$i]['gravacao'];
                  $Saida .= '<td class="relat"><a href="'.$Arquivo.'" target="_blank">Ouvir</a></td></tr>'."\n";
                  $Saida.='</tr>'."\n";
              }
          }
      }
      return $Saida;
  }
?>
