function atualiza_status_monit_ks(){
	var host = document.getElementById("hostSocket").value;
	var porta = document.getElementById("portaSocket").value;
	var status = document.getElementById("statusPbx");
	var dados = "";
	//Define a url do servidor WebSocket.
	var wsUri = "ws://"+host+":"+porta+"/vdt/websockets/ws.modu.php";
	//Cria o objeto do WebSocket.
	websocket = new WebSocket(wsUri); 
	
	//Define a funo para o evento onOpen
	websocket.onopen = function(ev) { // connection is open 
		status.innerHTML = "Status Pbx: <font color='#48FE51' style='font-size:8pt;'>Conectado.</font>";
	};
	
	//Define a funo para o evento onMessage
	websocket.onmessage = function(ev) {
		dados = JSON.parse(ev.data);
		if(dados==null) return;
		switch(dados.tipo){
			case "ExtensionStatus": trata_status_ramal(dados);
			break;
			case "AntennaLevel": trata_antenna_level(dados);
			break;
			case "QueueMemberPaused": trata_status_member_paused(dados);
			break;
			case "Newstate": tratar_new_state(dados);
			break;
			case "Hangup": tratar_hangup(dados);
			break;
			case "Newexten": tratar_new_exten(dados);
			break;
			case "Unlink": tratar_hangup(dados);
			break;
		}
	};
	
	//Define a funo para o evento onError
	websocket.onerror	= function(ev){
		console.log("Erro: " + ev.error);
	};
	//Define a funo para o evento onClose
	websocket.onclose 	= function(ev){
		status.innerHTML = "Status Pbx: <font color='red' style='font-size:8pt;'>Desconectado.</font>";
		window.setTimeout("atualiza_status_monit()", 1000);
	};
}

function tratar_new_state(dados){
	var ramal = document.getElementById("meu_ramal");
	var usuario = document.getElementById("meu_id").value;
	if(ramal == null) return;
	var destination = dados.destination.split("/");
	
	if(destination[0] == "SIP"){
		destination = destination[1].split("-");
		if(ramal.value == destination[0]){
			if(dados.state == "Ringing"){
				var tempo = new Date().getTime;
				document.getElementById("tempo_status").value = tempo;
				var pagina = document.getElementById("pgn_ajax").value;
				var oque = "acao=com_quem_fala&id="+usuario+"&numero="+dados.callerId;

				xmlHttp = GetXmlHttpObject();
				xmlHttp.onreadystatechange=function()
				{
					if(xmlHttp.readyState==4)
					{
						var tipo = "Entrada";
						if(dados.callerId.length == ramal.value.length) tipo = "Interna";
						var Resultado = xmlHttp.responseText;
						var dadosLinhas = ["Entrada", dados.callerId, Resultado, "-"];
						remover_linha_tabela(destination[0]+dados.callerId);
						adicionar_linha_tabela(destination[0]+dados.callerId, dadosLinhas, "list", "chamadas_espera");
					}
				}
				xmlHttp.open("POST",pagina,false);
				xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
				xmlHttp.setRequestHeader('Content-length', oque.length );
				xmlHttp.setRequestHeader('encoding','ISO-8859-1');
				xmlHttp.send(oque);
			} else if(dados.state == "Up"){
				var tempo = new Date().getTime;
				document.getElementById("tempo_status").value = tempo;
				
				var pagina = document.getElementById("pgn_ajax").value;
				var oque = "acao=com_quem_fala&id="+usuario+"&numero="+dados.callerId;

				xmlHttp = GetXmlHttpObject();
				xmlHttp.onreadystatechange=function()
				{
					if(xmlHttp.readyState==4)
					{
						var tipo = "Entrada";
						if(destination[0].length == ramal.value.length) tipo = "Interna";
						var Resultado = xmlHttp.responseText;
						remover_linha_tabela(destination[0]+dados.callerId);
						var dadosLinhas = ["Entrada", dados.callerId, destination[0], Resultado, "-"];
						adicionar_linha_tabela(destination[0]+dados.callerId, dadosLinhas, "list", "chamadas_curso");
					}
				}
				xmlHttp.open("POST",pagina,false);
				xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
				xmlHttp.setRequestHeader('Content-length', oque.length );
				xmlHttp.setRequestHeader('encoding','ISO-8859-1');
				xmlHttp.send(oque);
			}
		}
	}
}

function tratar_hangup(dados){
	if(dados.direction == "entrada"){
		var destination = dados.channel.split("/");
		
		if(destination[0] == "SIP"){
			destination = destination[1].split("-");
			document.getElementById("tempo_status").value = "";
			remover_linha_tabela(destination[0]+dados.callerId);
			var ram = document.getElementById("ram_"+destination[0]);
			if(ram != null){
				ram.className = "luzramalliv";
				ram.value = "<font style='font-size:8pt;'>Livre</font>";
			}
		}
	} else {
		var ramal = document.getElementById("meu_ramal");
		var channel = dados.channel.split("-");
		channel = channel[0].split("/");
		if(channel[0] == "SIP"){
			document.getElementById("tempo_status").value = "";
			remover_linha_tabela(channel[1]+dados.extension);
			var ram = document.getElementById("ram_"+channel[1]);
			if(ram != null){
				ram.className = "luzramalliv";
				ram.value = "<font style='font-size:8pt;'>Livre</font>";
			}
		}
	}
}

function tratar_new_exten(dados){
	var ramal = document.getElementById("meu_ramal");
	var usuario = document.getElementById("meu_id").value;
	if(ramal == null) return;
	var channel = dados.channel.split("/");
	if(channel[0] == "SIP"){
		channel = channel[1].split("-");
		if(ramal.value == channel[0]){
		
			var pagina = document.getElementById("pgn_ajax").value;
			var oque = "acao=com_quem_fala&id="+usuario+"&numero="+dados.extension;

			xmlHttp = GetXmlHttpObject();
			xmlHttp.onreadystatechange=function()
			{
				if(xmlHttp.readyState==4)
				{
					var Resultado = xmlHttp.responseText;
					remover_linha_tabela(channel[0]+dados.extension);
					var tipo = "Sada";
					if(channel[0].length == ramal.value.length) tipo = "Interna";
					var dadosLinhas = [tipo, channel[0], dados.extension, Resultado, "-"];
					adicionar_linha_tabela(channel[0]+dados.extension, dadosLinhas, "list", "chamadas_curso");
				}
			}
			xmlHttp.open("POST",pagina,false);
			xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
			xmlHttp.setRequestHeader('Content-length', oque.length );
			xmlHttp.setRequestHeader('encoding','ISO-8859-1');
			xmlHttp.send(oque);
		
		
			
		}
	}
}

function atualiza_horario_ligacao(){
	var tempo = document.getElementById("tempo_status");
	if(tempo.value != ""){
		var passou = new Date().getTime() - tempo.value;
		console.log(formata_hora(passou));
	}
	window.setTimeout("atualiza_horario_ligacao", 1000);
}

function com_quem_fala(id, numero){
	
}