<?php
/**************************************************************
 * Nome:    CPbxMonir
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-01-25 (V1.0.0)
 * Descr.:  Monitoramento de ramais
 *************************************************************/


/**************************************************************
  Cabecalho para nao fazer cache
 *************************************************************/
 header('Cache-Control: no-cache, must-revalidate');
 header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');

/**************************************************************
  Area dos includes
 *************************************************************/
  $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
  include_once($DirRaiz.'config.php');
  include_once($DirRaiz.'config.pbx.php');
  $Modulo = $DirPBX;
  include_once($DirRaiz.$DirPBX.$DirClass.'pbx.class.php');
  include_once($DirRaiz.$Modulo.$DirModul.'pbx.modu.php');

/**************************************************************
  Definicao de variaveis
 *************************************************************/
  $L_var = $_GET;          // Recebe as variaveis do formulario
  $Ppbx  = new Pbx;        // Objeto Pbx
 

/**************************************************************
  Programa principal
 *************************************************************/
if($L_var['acao']=="inserirorbita"){
    $Saida = inserir_orbita($L_var['numeromesa'], $L_var['numero']);  
} else if($L_var['acao']=="inserirramalfila"){
    $Saida = inserir_ramal_fila($L_var['ramal'], $L_var['fila']);
} else if($L_var['acao']=="removerramalfila"){
    $Saida = remover_ramal_fila($L_var['ramal'], $L_var['fila']);
} else if($L_var['acao']=="acenderauxiliar"){
    $Saida = acende_apaga_auxiliar(true);
} else if($L_var['acao']=="apagarauxiliar"){
    $Saida = acende_apaga_auxiliar(false);
} else if($L_var['acao']=="monitoraauxiliar"){
    $Saida = monitora_auxiliar();
} else if($L_var['acao']=="acenderfha"){
    $Saida = acende_apaga_fha(true);
} else if($L_var['acao']=="apagarfha"){
    $Saida = acende_apaga_fha(false);
} else if($L_var['acao']=="monitorafha"){
    $Saida = monitora_fha();
} else if($L_var['acao']=="logoff_mesa"){
    deslogar_ramal_pbx($L_var['agente']);
    $Saida = "Logoff efetuado com sucesso.";
} else if($L_var['acao']=="pausar_mesa"){
    $Saida = pausar_ramal_pbx($L_var['agente'], $L_var['tipo']);
    $Saida = "A mesa virtual entrou em pausa.";
} else if($L_var['acao']=="despausar_mesa"){
    $Saida = despausar_ramal_pbx($L_var['agente']);
    $Saida = "A mesa virtual saiu de pausa.";
}
echo $Saida;
return;


/*****************************************************************
Funções
******************************************************************/
function inserir_orbita($Mesa, $Numero) {
    Global $Ppbx;
    if($Mesa=="") return;
    if($Numero=="") return;
    return $Ppbx->inserir_orbita($Mesa, $Numero);
}

function inserir_ramal_fila($ramal, $fila){
    Global $Ppbx;
    if($ramal == "" || $fila == "") return false;
    return $Ppbx->entrar_fila($ramal, $fila);
}

function remover_ramal_fila($ramal, $fila){
    Global $Ppbx;
    if($ramal == "" || $fila == "") return false;
    return $Ppbx->sair_fila($ramal, $fila);
}

function acende_apaga_auxiliar($estado){
    Global $Ppbx;
    if(!$estado) return $Ppbx->apaga_auxiliar();
    else if($estado) return $Ppbx->acende_auxiliar();
}

function monitora_auxiliar(){
    Global $Ppbx;
    $luz = $Ppbx->monitora_auxiliar();
    return $luz[0]['auxiliar'];
}

function acende_apaga_fha($estado){
    Global $Ppbx;
    if(!$estado) return $Ppbx->apaga_fha();
    else if($estado) return $Ppbx->acende_fha();
}

function monitora_fha(){
    Global $Ppbx;
    $luz = $Ppbx->monitora_fha();
    return $luz[0]['noturno'];
}

  
?>
