<?php
/**************************************************************
 * Nome:    Geral
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2009-05-04 (V1.0.0)
 * Descr.:  Funcoes gerais
 *************************************************************/


/**************************************************************
  Area dos includes
 *************************************************************/
 $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';


/**************************************************************
  Definicao de variaveis
 *************************************************************/
 


/**************************************************************
  Funcao soma_horas
 *************************************************************/
function soma_horas($TempoA,$TempoB) {
  if (strlen($TempoA)!=5) return "00:00";
  list ($H1, $M1) = explode (":", $TempoA);
  if (strlen($TempoB)!=5) return "00:00";
  list ($H2, $M2) = explode (":", $TempoB);
  $H1 = (int)$H1; $M1 = (int)$M1;
  $H2 = (int)$H2; $M2 = (int)$M2;
  $M = $M1 + $M2;
  $H = $H1 + $H2;
  if ($M>59) {
    $H = $H + 1;
    $M = $M - 60;
  }
  $Saida = sprintf('%02d',$H).":".sprintf('%02d',$M);
  return $Saida;
}


/**************************************************************
  Funcao subtrai_horas
 *************************************************************/
function subtrai_horas($TempoA,$TempoB) {
  if (strlen($TempoA)!=5) return "00:00";
  list ($H1, $M1) = explode (":", $TempoA);
  if (strlen($TempoB)!=5) return "00:00";
  list ($H2, $M2) = explode (":", $TempoB);
  $H1 = (int)$H1; $M1 = (int)$M1;
  $H2 = (int)$H2; $M2 = (int)$M2;
  $M = $M1 - $M2;
  $H = $H1 - $H2;
  if ($M<0) {
    $M = 60 + $M;
    $H = $H - 1;
  }
  if ($H<0) $Saida = false;
  else $Saida = sprintf('%02d',$H).":".sprintf('%02d',$M);
  return $Saida;
}


/**************************************************************
  Funcao subtrai_hora
 *************************************************************/
 function subtrai_hora($Horario1,$Horario2) {
   list($H1, $M1, $S1) = explode(':', $Horario1);
   list($H2, $M2, $S2) = explode(':', $Horario2);
   $S3 = $S1 - $S2;
   while ($S3 < 0) {
     $S3 = 60 + $S3;
     $M1--;
   }
   $M3 = $M1 - $M2;
   while ($M3 < 0) {
     $M3 = 60 + $M3;
     $H1--;
   }
   $H3 = $H1 - $H2;
   if ($H3<0) $Saida = "";
   else $Saida = sprintf("%02d",$H3).":".sprintf("%02d",$M3).":".sprintf("%02d",$S3);
   return $Saida;
 }


  //---------------------------------------------------
  // Funcao formata_hora
  //---------------------------------------------------
  function formata_hora($Segundos) {
    $Aux = $Segundos;
    $Seg = $Aux % 60;
    $Aux = ($Aux - $Seg) / 60;
    $Min = $Aux % 60;
    $Aux = ($Aux - $Min) / 60;
    $Hor = $Aux;
    $Saida = sprintf("%d:%02d:%02d", $Hor, $Min, $Seg);
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao formata_hora2
  //---------------------------------------------------
  function formata_hora2($Segundos) {
    $Aux = $Segundos;
    $Seg = $Aux % 60;
    $Aux = ($Aux - $Seg) / 60;
    $Min = $Aux % 60;
    $Aux = ($Aux - $Min) / 60;
    $Hor = $Aux;
    $Saida = sprintf("%d:%02d:%02d", $Hor, $Min, $Seg);
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao tudo_em_segundos
  //---------------------------------------------------
  function tudo_em_segundos($TempoA) {
    $TempoA = trim($TempoA);
    if ((strlen($TempoA)!=5) && (strlen($TempoA)!=8)) return "oi";
    $Tempo1 = explode(":", $TempoA);
    if (strlen($TempoA)==5) {
      $H1 = 0;
      $M1 = $Tempo1[0];
      $S1 = $Tempo1[1];
    }
    else {
      $H1 = $Tempo1[0];
      $M1 = $Tempo1[1];
      $S1 = $Tempo1[2];
    }
    if ((strlen($H1)>2) || (strlen($M1)>2) || (strlen($S1)>2)) return "tchau";
    $Saida = $S1 + ($M1*60) + ($H1*3600);
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao monta_tabela_porcentagem
  //---------------------------------------------------
  function monta_tabela_porcentagem($Total,$Parte1,$Parte2=0,$CorTodo="#009900",$CorParte1="#CC0000",$CorParte2="#FF9900",$Tamanho="90px") {
    $TPar = $Tamanho/20;
    $Por1 = intval(($Parte1/$Total)*100);
    $Por3 = intval(($Parte2/$Total)*100);
    $Por2 = 100-($Por1+$Por3);
    $Said1 = $Total.'='.$Parte1.'+'.$Parte2.'->'.$Por1.' '.$Por2.' '.$Por3;
    $Saida = '';
    $Saida.= '<table class="porc" style="{width:'.$Tamanho.';}"><tr style="{margin:0;border:0;padding:0;border-collapse:collapse;height:10px;}">'."\n";
    if ($Por1>0) {
      for ($x=0; $x<=$Por1; $x=$x+5) {
        $Saida.= '<td class="porc" style="{width:'.$TPar.';background-color:'.$CorTodo.'}"></td>'."\n";
      }
    }
    for ($x=$Por1+5; $x<=($Por1+$Por2); $x=$x+5) {
      $Saida.= '<td class="porc" style="{width:'.$TPar.';background-color:'.$CorParte1.'}"></td>'."\n";
    }
    for ($x=($Por1+$Por2)+5; $x<=100; $x=$x+5) {
      $Saida.= '<td class="porc" style="{width:'.$TPar.';background-color:'.$CorParte2.'}"></td>'."\n";
    }
    $Saida.= '</tr></table>'."\n";
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_conteudo_diretorio
  // Forma pode ser (D)iretorio, (F)ile ou (T)udo
  //---------------------------------------------------
  function lista_conteudo_diretorio($Diretorio,$Forma="T") {
    //return $Diretorio;
    if (!is_dir($Diretorio)) return false;
    if (($Forma!="T") && ($Forma!="D") && ($Forma!="F")) return false;
    $Dirs  = scandir($Diretorio);
    $Saida = array();
    foreach($Dirs as $Arquivo) {
      if (($Arquivo != '.') && ($Arquivo != '..')) {
        if (is_dir($Diretorio.'/'.$Arquivo)) $Tipo='D';
        else  $Tipo='F';
        if     ($Forma == "T")   $Aux = array($Arquivo,$Tipo);
        elseif ($Tipo == $Forma) $Aux = $Arquivo;
        $Saida[] = $Aux;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao deleta_arquivos_de_diretorio
  //---------------------------------------------------
  function deleta_arquivos_de_diretorio($Diretorio,$Comeco_Arquivo="") {
    Global $DirRaiz;
    //return $Diretorio;
    $Diretorio = $DirRaiz.$Diretorio;
    if (!is_dir($Diretorio)) return false;
    $TCome = strlen($Comeco_Arquivo);
    $Dirs  = scandir($Diretorio);
    $Saida = "";
    foreach($Dirs as $Arquivo) {
      if (substr($Arquivo,0,$TCome)==$Comeco_Arquivo) unlink($Diretorio.$Arquivo);
      $Saida.= "<br>Lista=".substr($Arquivo,0,$TCome)." compara=".$Comeco_Arquivo." unlink".$Diretorio.$Arquivo;
    }
    $Saida = print_r($Dirs, true);
    return;
  }


  //---------------------------------------------------
  // Funcao monta_option_com_array
  // Selecao indica qual o item que deve sair selecionado.
  //    Em branco significa o primeiro
  //---------------------------------------------------
  function monta_option_com_array($Opcoes,$Selecao="") {
    if (!is_array ($Opcoes)) return false;
    if ($Selecao=="") $Selecao = $Opcoes[0];
    $Saida = '';
    for ($x=0; $x<count($Opcoes); $x++) {
      $Saida .= '<option value="'.$Opcoes[$x].'"';
      if ($Opcoes[$x] == $Selecao) $Saida .= ' selected';
      $Saida .= '>'.$Opcoes[$x].'</option>';
    }
    return $Saida;
  }


/**************************************************************
  Funcao imprime_linha
 *************************************************************/
  function imprime_linha($Campo,$Valor,$Cor="#FFFFFF",$Formato="html") {
    $Saida = '';
    $Saida.= ' <tr><td style="background-color:'.$Cor.'" class="relcampo"';
    if ($Formato=="xls") $Saida.= ' class=xl24 width=64';
    $Saida.= '><span style="background-color:'.$Cor.'">';
    $Saida.= $Campo;
    $Saida.= ' </span></td><td style="background-color:'.$Cor.'" class="relvalor"';
    if ($Formato=="xls") $Saida.= ' class=xl24 width=64';
    $Saida.= '>';
    $Saida.= $Valor;
    $Saida.= '</td></tr>'."\n";
    return $Saida;
  }


/**************************************************************
  Funcao brancos_por_sublinhado
 *************************************************************/
  function brancos_por_sublinhado($Variavel) {
    $Saida = str_replace(" ", "_", $Variavel);
    $Saida = str_replace("&", "_", $Saida);
    $Saida = str_replace(";", "_", $Saida);
    return $Saida;
  }


/**************************************************************
  Funcao soma_arrays
 *************************************************************/
  function soma_arrays($t1, $t2) {
    if (!(is_array($t1)) || !(is_array($t2))) return;
    foreach ($t1 as $Chave => $Valor) {
      if (is_array($Valor)) {
        if (!(isset($t2[$Chave]))) $t2[$Chave] = $Valor;
        else {
          $Aux = $t2[$Chave];
          $t2[$Chave] = soma_a($Valor, $Aux);
        }
      } elseif (is_numeric($Valor)) {
        if (!(isset($t2[$Chave]))) $t2[$Chave] = $Valor;
        else $t2[$Chave] = $t2[$Chave] + $Valor;
      }
    }
    return $t2;
  }

function timestamp_para_humano($ts) { 
    $d=getdate($ts); 
    $yr=$d["year"]; 
    $mo=$d["mon"]; 
    $da=$d["mday"]; 
    $hr=$d["hours"]; 
    $mi=$d["minutes"]; 
    $se=$d["seconds"]; 
    return date("d/m/Y H:i:s", mktime($hr,$mi,$se,$mo,$da,$yr)); 
}

function utf8_encode_recursive ($array) {
    $result = array();
    foreach ($array as $key => $value)
    {
        if (is_array($value))
        {
            $result[$key] = utf8_encode_recursive($value);
        }
        else if (is_string($value))
        {
            $result[$key] = utf8_encode($value);
        }
        else
        {
            $result[$key] = $value;
        }
    }
    return $result;
}

?>
