<?php
/**************************************************************
 * Nome:    pbx
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2009-04-13 (V1.0.1)
 * Descr.:  Cria classe de pbx
 *************************************************************/


/**************************************************************
  Classe Pbx
  Eh a classe principal de unidades de negocio.
 *************************************************************/
class Pbx {
  var $Bd;
  var $BdRelat;
  var $Cdr;
  var $Meia;
  var $TabelaR;
  var $TabelaT;
  var $TabelaF;
  var $TabelaP;
  var $TabelaL;
  var $TabelGR;
  var $TabelaD;
  var $TabelaO;
  var $TabelLL;
  var $TabelAG;
  var $TabelTM;
  var $Tabeluz;
  var $TabelUF;
  var $TabelFi;
  var $Hoje;
  var $tabelaGrupoTronco;
  var $TabelGM;
  var $Dir_conf_aterisk;


  //---------------------------------------------------
  // Construtor da classe.
  //---------------------------------------------------
  function Pbx() {
    ($_SERVER['DOCUMENT_ROOT'] != "") ? $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/' : $DirRaiz = '/usr/local/apache2/htdocs/vdt/';
    include($DirRaiz.'config.php');
    include($DirRaiz.'configuracoes.php');
    include($DirRaiz.'config.pbx.php');
    include_once($DirRaiz.$DirClass.'bd.class.php');
	include_once($DirRaiz.$DirClass.'bd.relat.class.php');
	include_once($DirRaiz.$DirClass.'cdr.class.php');
    include_once($DirRaiz.$DirModul.'geral.modu.php');
    include_once($DirRaiz.$DirClass.'soquete.class.php');
    $this->Bd      = new Banco();
	$this->BdRelat = new BancoRelat();
	if($conectar_cdr) $this->Cdr     = new Cdr();
    $this->Meia    = new Soquetes();
    $this->TabelaR = $Tb_Ramal;
    $this->TabelaT = $Tb_Tronc;
    $this->TabelaF = $Tb_Feixe;
    $this->TabelaP = $Tb_Placa;
    $this->TabelaL = $Tb_Relat;
    $this->TabelGR = $Tb_GrupR;
    $this->TabelaD = $Tb_Facil;
    $this->TabelaO = $Tb_Orbit;
    $this->TabelLL = $Tb_Ligac;
    $this->TabelAG = $Tb_PAgen;
    $this->TabelTM = $Tb_Tmesa;
    $this->Tabeluz = $Tb_LuzRa;
	$this->TabelUF = $Tb_UsuFi;
	$this->TabelFi = $Tb_Filas;
    $this->Hoje    = date("d/m/y");
	$this->tabelaGrupoTronco = $tbGrupoTronco;
	$this->TabelGM = $Tb_GruRm;
	$this->Dir_conf_aterisk = $Diretorio_config_asterisk;
  }

  //---------------------------------------------------
  // Funcao le_ramais
  //---------------------------------------------------
  function le_ramais() {
    $Pes       = "DELETE FROM ".$this->TabelaR;
    $Res       = $this->Bd->executa_query_com_saida($Pes);
    $Resultado = $this->Meia->envia_socket("Action: SIPpeers\r\n\r\n");
    if (!$Resultado) return false;
    //Verifica se estah OK
    $Aux = explode(":",$Resultado[0]);
    if (trim($Aux[1])!="Success") $Saida = false;
    else {
      for ($x=1; $x<count($Resultado); $x++){
        $Aux = explode(":",$Resultado[$x]);
        $Aux[0] = trim($Aux[0]);
        if ($Aux[0]=="ObjectName") $Ramal = trim($Aux[1]);
        if ($Aux[0]=="IPaddress")  $this->grava_ramal($Ramal,trim($Aux[1]));
      }
      $Saida = true;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao grava_ramal
  //---------------------------------------------------
  function grava_ramal($Ramal,$Ender) {
    $Ramal = trim($Ramal);
    if ( is_numeric($Ramal) && (strlen($Ramal)==4) ) {
      $Pes  = "SELECT id FROM ".$this->TabelaR." WHERE ramal='".$Ramal."'";
      $Res  = $this->Bd->executa_query_com_saida($Pes);
      if (!$Res) {
        $Insere = "INSERT INTO ".$this->TabelaR." (ramal,endereco) VALUES ('".$Ramal."', '".$Ender."')";
        $Res    = $this->Bd->executa_query_sem_saida($Insere);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
      }
      else {
        $Identif = $Res[0]['id'];
        $Troca = "UPDATE ".$this->TabelaR." SET endereco='".$Ender."' WHERE id='".$Identif."'";
        $Res   = $this->Bd->executa_query_sem_saida($Troca);
        if (!$Res) $Saida = false;
        else $Saida = $Res;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_facilidades
  //---------------------------------------------------
  function lista_facilidades() {
    $Pes1 = "SELECT * FROM ".$this->TabelaD." ORDER BY id";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else $Saida = $Res1;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_facilidades
  //---------------------------------------------------
  function altera_facilidades($Dados) {
    $Listagem = $this->lista_facilidades();
    //$Saida = "";
    for ($x=0; $x<count($Listagem); $x++){
      $i     = 'fac_'.sprintf('%09d',$Listagem[$x]['id']);
      $Troca = "UPDATE ".$this->TabelaD." SET valor='".$Dados[$i]."' WHERE id=".$Listagem[$x]['id'];
      $Res   = $this->Bd->executa_query_sem_saida($Troca);
      //$Saida .= $Troca."<br>";
    }
    $this->altera_orbitas();
    return true;
  }


  //---------------------------------------------------
  // Funcao lista_orbitas
  //---------------------------------------------------
  function lista_orbitas() {
    $Pes1 = "SELECT * FROM ".$this->TabelaO." ORDER BY orbita";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else $Saida = $Res1;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_orbitas
  //---------------------------------------------------
  function altera_orbitas() {
    $Orbitar = $this->retorna_valor_da_facilidade('Estacionar chamada');
    $Orbitar = substr($Orbitar,1,1);
    //$Saida = "";
    $Zera = "DELETE FROM ".$this->TabelaO;
    $Res  = $this->Bd->executa_query_sem_saida($Zera);
    for ($x=1; $x<21; $x++){
      $i      = $Orbitar.sprintf('%02d',$x);
      $Insere = "INSERT INTO ".$this->TabelaO." (orbita) VALUES ('".$i."')";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
    }
    return true;
  }


  //---------------------------------------------------
  // Funcao retorna_valor_da_facilidade
  //---------------------------------------------------
  function retorna_valor_da_facilidade($Facil) {
    $Pes1 = "SELECT valor FROM ".$this->TabelaD." WHERE facilidade='".$Facil."' LIMIT 1";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else $Saida = $Res1[0]['valor'];
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_troncos
  //---------------------------------------------------
  function lista_troncos($Ativo='') {
    $Pes1 = "SELECT t.*, f.nome AS nome_feixe FROM ".$this->TabelaT." AS t INNER JOIN vm50_feixes AS f ON t.feixe = f.id ORDER BY numero_vdt";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else $Saida = $Res1;
    return $Saida;
  }
  
  //---------------------------------------------------
  // Funcao lista_troncos_remotos
  //---------------------------------------------------
  function lista_troncos_remotos($Ativo='') {
    $Pes1 = "SELECT t.*, f.nome AS nome_feixe, f.host FROM vm50_troncos_remotos AS t INNER JOIN vm50_feixes_remotos AS f ON t.feixe = f.id ORDER BY numero_vdt";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
	$Pes = "SELECT * FROM vm50_troncos_remotos WHERE feixe is null";
	$Res = $this->Bd->executa_query_com_saida($Pes);
	for($i = 0; $i < count($Res); $i++){
		$Res1[] = $Res[$i];
	}
    if (!$Res1) $Saida = false;
    else $Saida = $Res1;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao apaga_troncos
  //---------------------------------------------------
  function apaga_troncos($Identif) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    $Saida = true;
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Apa = "DELETE FROM ".$this->TabelaT." WHERE id='".$Identif."'";
      $Res = $this->Bd->executa_query_sem_saida($Apa);
      $Saida = $Res;
    }
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao apaga_troncos_remotos
  //---------------------------------------------------
  function apaga_troncos_remotos($Identif) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    $Saida = true;
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Apa = "DELETE FROM vm50_troncos_remotos WHERE id='".$Identif."'";
      $Res = $this->Bd->executa_query_sem_saida($Apa);
      $Saida = $Res;
    }
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao altera_troncos
  //---------------------------------------------------
  function altera_troncos($Identif,$Nuast,$Nuvdt,$Descr,$Nulin,$Opera,$Sinal) {
    $Identif = trim($Identif);
    $Troca   = "UPDATE ".$this->TabelaT." SET numero_asterisk='".$Nuast."', numero_vdt='".$Nuvdt."', descricao='".$Descr."', numero_linha='".$Nulin."', operadora='".$Opera."', sinalizacao='".$Sinal."'  WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Saida = $Res;
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao altera_troncos
  //---------------------------------------------------
  function altera_troncos_remotos($Identif,$Nuast,$Nuvdt,$Descr,$Nulin,$Opera,$Sinal) {
    $Identif = trim($Identif);
    $Troca   = "UPDATE vm50_troncos_remotos SET numero_asterisk='".$Nuast."', numero_vdt='".$Nuvdt."', descricao='".$Descr."', numero_linha='".$Nulin."', operadora='".$Opera."', sinalizacao='".$Sinal."'  WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Saida = $Res;
    return $Saida;
  }
  
  //---------------------------------------------------
  // Funcao descobre_tronco_por_id_ligacao
  //---------------------------------------------------
  function descobre_tronco_por_id_ligacao($Id_ligacao) {
    $Pes1 = "SELECT ".$this->TabelaT.".numero_asterisk, ".$this->TabelaT.".numero_vdt, ".$this->TabelaT.".descricao, ".$this->TabelaT.".numero_linha, ".$this->TabelaT.".operadora, ".$this->TabelaT.".sinalizacao, ".$this->TabelaT.".situacao, ".$this->TabelaT.".direcao, ".$this->TabelaT.".id_externo, ".$this->TabelaT.".numeroexterno, ".$this->TabelaT.".id_interno, ".$this->TabelaT.".numerointerno, ".$this->TabelaF.".nome as nome_feixe FROM ".$this->TabelaT;
    $Pes1.= " INNER JOIN ".$this->TabelaF." ON ".$this->TabelaT.".feixe=".$this->TabelaF.".id";
    $Pes1.= " WHERE ".$this->TabelaT.".id_externo='".$Id_ligacao."' OR ".$this->TabelaT.".id_interno='".$Id_ligacao."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else $Saida = $Res1;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_troncos
  //---------------------------------------------------
  function insere_troncos($Nuast,$Nuvdt,$Descr,$Nulin,$Opera,$Sinal) {
    $Pes  = "SELECT id FROM ".$this->TabelaT." WHERE numero_vdt='".$Nuvdt."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO ".$this->TabelaT." (numero_asterisk, numero_vdt, descricao, numero_linha, operadora, sinalizacao) VALUES ('".$Nuast."','".$Nuvdt."','".$Descr."','".$Nulin."','".$Opera."','".$Sinal."')";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      $Saida  = $Res;
    }
    else $Saida = false;
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao insere_troncos_remotos
  //---------------------------------------------------
  function insere_troncos_remotos($Nuast,$Nuvdt,$Descr,$Nulin,$Opera,$Sinal) {
    $Pes  = "SELECT id FROM vm50_troncos_remotos WHERE numero_vdt='".$Nuvdt."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO vm50_troncos_remotos (numero_asterisk, numero_vdt, descricao, numero_linha, operadora, sinalizacao) VALUES ('".$Nuast."','".$Nuvdt."','".$Descr."','".$Nulin."','".$Opera."','".$Sinal."')";
	  
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      $Saida  = $Res;
    }
    else $Saida = false;
    return $Saida;
  }
  
  //---------------------------------------------------
  // Funcao lista_feixes
  //---------------------------------------------------
  function lista_feixes($Ativo='') {
    $Pes1 = "SELECT * FROM ".$this->TabelaF." ORDER BY nome";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else {
      $Pes2 = "SELECT numero_vdt, feixe FROM ".$this->TabelaT." ORDER BY feixe,numero_vdt";
      $Res2 = $this->Bd->executa_query_com_saida($Pes2);
    }
    $Saida = array($Res1,$Res2);
    return $Saida;
  }
  
  //---------------------------------------------------
  // Funcao lista_feixes
  //---------------------------------------------------
  function lista_feixes_remotos($Ativo='') {
    $Pes1 = "SELECT * FROM vm50_feixes_remotos ORDER BY nome";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else {
      $Pes2 = "SELECT numero_vdt, feixe FROM vm50_troncos_remotos ORDER BY feixe,numero_vdt";
      $Res2 = $this->Bd->executa_query_com_saida($Pes2);
    }
    $Saida = array($Res1,$Res2);
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao lista_feixes_relatorio
  //---------------------------------------------------
  function lista_feixes_relatorio($Inicio, $Fim) {
    $Feix = array();
    $Pes1 = "SELECT canal_o FROM ".$this->TabelaL." WHERE diahora >= '".$Inicio."' AND diahora <= '".$Fim."' GROUP BY canal_o ORDER BY canal_o";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if ($Res1) {
      for ($x=0; $x<count($Res1); $x++) {
        if ($Res1[$x]['canal_o']>"") {
          $Pes3 = "SELECT ".$this->TabelaF.".nome AS nome_feixe FROM ".$this->TabelaT." INNER JOIN ".$this->TabelaF." ON ".$this->TabelaT.".feixe = ".$this->TabelaF.".id WHERE ".$this->TabelaT.".numero_asterisk= '".$Res1[$x]['canal_o']."'";
          $Res3 = $this->Bd->executa_query_com_saida($Pes3);
          if ($Res3) $Feix[$Res3[0]['nome_feixe']] = $Res3[0]['nome_feixe'];
        }
      }
    }
    $Pes2 = "SELECT canal_d FROM ".$this->TabelaL." WHERE diahora >= '".$Inicio."' AND diahora <= '".$Fim."' GROUP BY canal_d ORDER BY canal_d";
    $Res2 = $this->Bd->executa_query_com_saida($Pes2);
    if ($Res2) {
      for ($x=0; $x<count($Res2); $x++) {
        if ($Res2[$x]['canal_d']>"") {
          $Pes4 = "SELECT ".$this->TabelaF.".nome AS nome_feixe FROM ".$this->TabelaT." INNER JOIN ".$this->TabelaF." ON ".$this->TabelaT.".feixe = ".$this->TabelaF.".id WHERE ".$this->TabelaT.".numero_asterisk= '".$Res2[$x]['canal_d']."'";
          $Res4 = $this->Bd->executa_query_com_saida($Pes4);
          if ($Res4) $Feix[$Res4[0]['nome_feixe']] = $Res4[0]['nome_feixe'];
        }
      }
    }
    $Aux  = $this->lista_feixes();
    $Mais = $Aux[0];
    for ($x=0; $x<count($Mais); $x++) $Feix[$Mais[$x]['nome']] = $Mais[$x]['nome'];
    sort($Feix);
    $Saida = "";
    foreach ($Feix as $key=>$value) {
       $Saida .= '<option value="'.$value.'">'.$value.'</option>';
    }
//return $Pes1."<br>".$Pes2."<br>".$Pes3."<br>".$Pes4;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_feixes
  //---------------------------------------------------
  function altera_feixes($Identif,$Nomef,$Prefi,$Tronchave,$HabilMonit) {
    $Identif = trim($Identif);
    $Troca   = "UPDATE ".$this->TabelaF." SET nome='".$Nomef."', prefixo='".$Prefi."', tronco_chave='".$Tronchave."', habilita_monitoracao='".$HabilMonit."' WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Saida = $Res;
    return $Saida;
  }
  
  //---------------------------------------------------
  // Funcao altera_feixes
  //---------------------------------------------------
  function altera_feixes_remotos($Identif,$Nomef,$Prefi,$Tronchave,$HabilMonit,$Host) {
    $Identif = trim($Identif);
    $Troca   = "UPDATE vm50_feixes_remotos SET nome='".$Nomef."', prefixo='".$Prefi."', tronco_chave='".$Tronchave."', habilita_monitoracao='".$HabilMonit."', host='".$Host."' WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_troncos_feixes
  //---------------------------------------------------
  function altera_troncos_feixes($Identif,$Troncos) {
    $Identif = intval(trim($Identif),10);
    $Apaga   = "UPDATE ".$this->TabelaT." SET feixe=NULL WHERE feixe=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Apaga);
    if (is_array($Troncos)) {
      for ($x=0; $x<count($Troncos); $x++) {
        $Saida .= $this->insere_troncos_feixes($Identif,$Troncos[$x]);
      }
    }
    return $Saida;
  }
  
  
  //---------------------------------------------------
  // Funcao altera_troncos_feixes_remotos
  //---------------------------------------------------
  function altera_troncos_feixes_remotos($Identif,$Troncos) {
    $Identif = intval(trim($Identif),10);
    $Apaga   = "UPDATE vm50_troncos_remotos SET feixe=NULL WHERE feixe=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Apaga);
    if (is_array($Troncos)) {
      for ($x=0; $x<count($Troncos); $x++) {
        $Saida .= $this->insere_troncos_feixes_remotos($Identif,$Troncos[$x]);
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_feixes
  //---------------------------------------------------
  function insere_feixes($Nomef,$Prefi,$Tronchave,$HabilMonit) {
    $Pes  = "SELECT id FROM ".$this->TabelaF." WHERE nome='".$Nomef."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO ".$this->TabelaF." (nome, prefixo, tronco_chave, habilita_monitoracao) VALUES ('".$Nomef."','".$Prefi."','".$Tronchave."', '".$HabilMonit."')";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      $Pes    = "SELECT id FROM ".$this->TabelaF." WHERE nome='".$Nomef."'";
      $Res    = $this->Bd->executa_query_com_saida($Pes);
      $Saida  = $Res[0]['id'];
    }
    else $Saida = false;
    return $Saida;
  }

  
  //---------------------------------------------------
  // Funcao insere_feixes_remotos
  //---------------------------------------------------
  function insere_feixes_remotos($Nomef,$Prefi,$Tronchave,$HabilMonit) {
    $Pes  = "SELECT id FROM vm50_feixes_remotos WHERE nome='".$Nomef."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO vm50_feixes_remotos (nome, prefixo, tronco_chave, habilita_monitoracao) VALUES ('".$Nomef."','".$Prefi."','".$Tronchave."', '".$HabilMonit."')";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      $Pes    = "SELECT id FROM vm50_feixes_remotos WHERE nome='".$Nomef."'";
      $Res    = $this->Bd->executa_query_com_saida($Pes);
      $Saida  = $Res[0]['id'];
    }
    else $Saida = false;
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao insere_troncos_feixes
  //---------------------------------------------------
  function insere_troncos_feixes($Identif,$Tronco) {
    $Pes1 = "SELECT id FROM ".$this->TabelaF." WHERE id='".$Identif."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if ($Res1) {
      $Pes2 = "UPDATE ".$this->TabelaT." SET feixe='".$Identif."' WHERE numero_vdt='".$Tronco."'";
      $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
      if (!$Res2) $Saida = false;
      else $Saida = $Res2;
    }
    else $Saida = false;
    return $Saida;
  }
  
  //---------------------------------------------------
  // Funcao insere_troncos_feixes_remotos
  //---------------------------------------------------
  function insere_troncos_feixes_remotos($Identif,$Tronco) {
    $Pes1 = "SELECT id FROM vm50_feixes_remotos WHERE id='".$Identif."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if ($Res1) {
      $Pes2 = "UPDATE vm50_troncos_remotos SET feixe='".$Identif."' WHERE numero_vdt='".$Tronco."'";
      $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
      if (!$Res2) $Saida = false;
      else $Saida = $Res2;
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao apaga_feixes
  //---------------------------------------------------
  function apaga_feixes($Identif) {
    $Identif = trim($Identif);
    $Troca   = "DELETE FROM ".$this->TabelaF." WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Apaga   = "UPDATE ".$this->TabelaT." SET feixe=NULL WHERE feixe=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Apaga);
    $Saida = $Res;
    return $Saida;
  }
  
  //---------------------------------------------------
  // Funcao apaga_feixes_remotos
  //---------------------------------------------------
  function apaga_feixes_remotos($Identif) {
    $Identif = trim($Identif);
    $Troca   = "DELETE FROM vm50_feixes_remotos WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Apaga   = "UPDATE vm50_troncos_remotos SET feixe=NULL WHERE feixe=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Apaga);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_utilizacao_feixes
  //---------------------------------------------------
  function lista_utilizacao_feixes($Ativo='') {
    $Pes1 = "SELECT * FROM ".$this->TabelaF." ORDER BY nome";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
	foreach($Res1 as $chave => $valor){
		if($valor['habilita_monitoracao']==1){
			$Pes2 = "SELECT * FROM ".$this->TabelaT." WHERE feixe = ".$valor['id']." ORDER BY numero_vdt";
			$Res2 = $this->Bd->executa_query_com_saida($Pes2);
			$Saida[$valor['nome']] = $Res2;
		}
	}
    /*if (!$Res1) $Saida = false;
    else {
      $Pes2 = "SELECT numero_vdt, feixe, situacao, direcao, numeroexterno, numerointerno, numero_linha, sinalizacao, operadora FROM ".$this->TabelaT." ORDER BY feixe,to_number(numero_vdt,'999')";
      $Res2 = $this->Bd->executa_query_com_saida($Pes2);
    }
    $Saida = array($Res1,$Res2);*/
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_placas
  //---------------------------------------------------
  function lista_placas($Ativo='') {
    $Pes1 = "SELECT * FROM ".$this->TabelaP." ORDER BY numero";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else {
      $Pes2 = "SELECT numero_vdt, placa_numero, placa_ordem FROM ".$this->TabelaT." ORDER BY placa_numero, placa_ordem, numero_vdt";
      $Res2 = $this->Bd->executa_query_com_saida($Pes2);
    }
    $Saida = array($Res1,$Res2);
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_placas
  //---------------------------------------------------
  function altera_placas($Identif,$NumPlaca,$Fabric,$Modelo) {
    $Identif = trim($Identif);
    $Troca   = "UPDATE ".$this->TabelaP." SET numero='".$NumPlaca."', fabricante='".$Fabric."', modelo='".$Modelo."' WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_troncos_placas
  //---------------------------------------------------
  function altera_troncos_placas($NumPlaca,$Troncos) {
    $Pes  = "SELECT fabricante FROM ".$this->TabelaP." WHERE numero='".$NumPlaca."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if ($Res) {
      $Apaga   = "UPDATE ".$this->TabelaT." SET placa_numero=NULL, placa_ordem=NULL WHERE placa_numero=".$NumPlaca;
      $Res     = $this->Bd->executa_query_sem_saida($Apaga);
      if (is_array($Troncos)) {
        for ($x=0; $x<count($Troncos); $x++) {
          $Saida .= $this->insere_troncos_placas($NumPlaca,$Troncos[$x]);
        }
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_placas
  //---------------------------------------------------
  function insere_placas($NumPlaca,$Fabric,$Modelo) {
    $Pes  = "SELECT id FROM ".$this->TabelaP." WHERE numero='".$NumPlaca."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO ".$this->TabelaP." (numero, fabricante, modelo) VALUES ('".$NumPlaca."','".$Fabric."','".$Modelo."')";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      $Saida  = $Res;
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_troncos_placas
  //---------------------------------------------------
  function insere_troncos_placas($NumPlaca,$Tronco) {
    $Pes  = "SELECT fabricante FROM ".$this->TabelaP." WHERE numero='".$NumPlaca."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if ($Res) {
      $Ordem = sprintf('%03d',substr($Tronco,0,3));
      $TTron = substr($Tronco,6);
      $Pes2 = "UPDATE ".$this->TabelaT." SET placa_numero=".$NumPlaca.", placa_ordem='".$Ordem."' WHERE numero_vdt='".$TTron."'";
      $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
      if (!$Res2) $Saida = false;
      else $Saida = $Res2;
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao apaga_placas
  //---------------------------------------------------
  function apaga_placas($Identif) {
    $Identif = trim($Identif);
    $Pes  = "SELECT placa_numero FROM ".$this->TabelaP." WHERE id='".$Identif."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    $NumPlaca = $Res[0]['placa_numero'];
    $Troca   = "DELETE FROM ".$this->TabelaP." WHERE id=".$Identif;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Apaga   = "UPDATE ".$this->TabelaT." SET placa_numero=NULL, placa_ordem=NULL WHERE placa_numero=".$NumPlaca;
    $Res     = $this->Bd->executa_query_sem_saida($Apaga);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_ramais
  //---------------------------------------------------
  function lista_ramais($Ativo='') {
    $Pes1 = "SELECT * FROM ".$this->TabelaR." ORDER BY ramal";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else $Saida = $Res1;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_ramais_pa
  //---------------------------------------------------
  function lista_ramais_pa($Ativo='') {
    $Pes1 = "SELECT * FROM ".$this->TabelaR." WHERE ramal_pa='1' ORDER BY ramal";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else $Saida = $Res1;
    return $Saida;
  }



  //---------------------------------------------------
  // Funcao lista_dado_ramal_por_ramal
  //---------------------------------------------------
  function lista_dado_ramal_por_ramal($Ramal) {
    $Pes1 = "SELECT * FROM ".$this->TabelaR." WHERE ramal='".$Ramal."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else $Saida = $Res1;
    return $Saida;
  }



  //---------------------------------------------------
  // Funcao descobre_nome_com_quem_fala
  //---------------------------------------------------
  function descobre_nome_com_quem_fala($Eu,$Numero) {
    $Saida = false;
    $Ehramal = $this->lista_dado_ramal_por_ramal($Numero);
    if ($Ehramal[0]['pseudonimo'] != "") $Saida = $Ehramal[0]['pseudonimo'];
    else {
      $Numero = substr($Numero,strlen($Numero)-8,8);
      $Pes = "SELECT * FROM ".$this->TabelAG." WHERE usuario='".$Eu."' AND tel_res LIKE '%".$Numero."'";
      $Res = $this->Bd->executa_query_com_saida($Pes);
      if ($Res) $Saida = $Res[0]['nome'];
      else {
        $Pes = "SELECT * FROM ".$this->TabelAG." WHERE usuario='".$Eu."' AND tel_cel LIKE '%".$Numero."'";
        $Res = $this->Bd->executa_query_com_saida($Pes);
        if ($Res) $Saida = $Res[0]['nome'];
        else {
          $Pes = "SELECT * FROM ".$this->TabelAG." WHERE usuario='".$Eu."' AND tel_com LIKE '%".$Numero."'";
          $Res = $this->Bd->executa_query_com_saida($Pes);
          if ($Res) $Saida = $Res[0]['nome'];
		  else {
			$Pes = "SELECT * FROM vm50_dscrapida WHERE usuario=".$Eu." AND numero LIKE '%".$Numero."'";
			$Res = $this->Bd->executa_query_com_saida($Pes);
			if ($Res) $Saida = $Res[0]['nome'];
		  }
        }
      }
    }
    return $Saida;
  }



  //---------------------------------------------------
  // Funcao apaga_ramais
  //---------------------------------------------------
  function apaga_ramais($Identif) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    $Saida = true;
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Apa = "DELETE FROM ".$this->TabelaR." WHERE id='".$Identif."'";
      $Res = $this->Bd->executa_query_sem_saida($Apa);
      $Saida = $Res;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_ramais
  //---------------------------------------------------
  function altera_ramais($Identif,$Nome,$Pseudo,$Canal,$Dispos,$Fabri,$Modeo,$Host,$Tipo,$Calid,$Conte,$Senha,$Usuai,$Licha,$Grcap,$Dtmfm,$Capgr,$Naste,$Ramalpa) {
    $Identif = trim($Identif);
    $Licha   = intval($Licha);
    if ($Canal=='ZAP') $Situac = 'L';
    else $Situac = 'U';
    if ($Ramalpa!='1') $Ramalpa = '0';
    $Troca   = "UPDATE ".$this->TabelaR." SET nomecomplet='".$Nome."',pseudonimo='".$Pseudo."',canal='".$Canal."',dispositivo='".$Dispos."',fabricante='".$Fabri."',modelo='".$Modeo."',host='".$Host."',tipo='".$Tipo."',callerid='".$Calid."',contexto='".$Conte."',senha='".$Senha."',username='".$Usuai."',call_limit=".$Licha.",callgroup='".$Grcap."',dtmfmode='".$Dtmfm."',pickupgroup='".$Capgr."',situacao='".$Situac."',numeroaster='".$Naste."', ramal_pa='".$Ramalpa."' WHERE id=".$Identif;
    //return $Troca;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Saida   = $Res;
    return $Saida;
  }
  
  //---------------------------------------------------
  // Funcao altera_ramais
  //---------------------------------------------------
  function altera_ramais_asterisk($identif, $nome, $pseu, $rama, $senh, $cntx, $lcha, $vmai, $canr, $host, $mdtm, $nat, $qual, $tipo, $gcap, $cgru, $cblf, $denn, $perm, $nots) {
    $identif = trim($identif);
    $Troca   = "UPDATE vm50_ramais SET nomecomplet = '".$nome."', pseudonimo = '".$pseu."', ramal = '".$rama."', senha = '".$senh."', contexto = '".$cntx."', call_limit = '".$lcha."', mailbox = '".$vmai."', can_reinvite = ".$canr.", host = '".$host."', dtmfmode = '".$mdtm."', nat = ".$nat.", qualify = ".$qual.", tipo = '".$tipo."', callgroup = '".$gcap."', pickupgroup = '".$cgru."', subscribecontext = '".$cblf."', denny = '".$denn."', permit = '".$perm."', notificarsyonet = '".$nots."', numeroaster = 'SIP/".$rama."' WHERE id = ".$identif;
    $_SESSION['debug'] = $Troca;
    $Res     = $this->Bd->executa_query_sem_saida($Troca);
    $Saida   = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_ramais
  //---------------------------------------------------
  function insere_ramais($Ramal,$Nome,$Pseudo,$Canal,$Dispos,$Fabri,$Modeo,$Host,$Tipo,$Calid,$Conte,$Senha,$Usuai,$Licha,$Grcap,$Dtmfm,$Capgr,$Naste,$Ramalpa) {
    $Pes  = "SELECT id FROM ".$this->TabelaR." WHERE ramal='".$Ramal."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Licha  = intval($Licha);
      if ($Canal=='ZAP') $Situac = 'L';
      else $Situac = 'U';
      if ($Ramalpa!='1') $Ramalpa = '0';
      $Insere = "INSERT INTO ".$this->TabelaR." (nomecomplet,pseudonimo,ramal,endereco,canal,dispositivo,fabricante,modelo,host,tipo,callerid,contexto,senha,username,call_limit,callgroup,dtmfmode,pickupgroup,situacao,numeroaster,ramal_pa) VALUES ('".$Nome."','".$Pseudo."','".$Ramal."','-none-','".$Canal."','".$Dispos."','".$Fabri."','".$Modeo."','".$Host."','".$Tipo."','".$Calid."','".$Conte."','".$Senha."','".$Usuai."',".$Licha.",'".$Grcap."','".$Dtmfm."','".$Capgr."','".$Situac."','".$Naste."','".$Ramalpa."')";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      $Saida  = $Res;
    }
    else $Saida = false;
    return $Saida;
  }

  //---------------------------------------------------
  // Funcao insere_ramais_asterisk
  //---------------------------------------------------
  function insere_ramais_asterisk($nome, $pseu, $rama, $senh, $cntx, $lcha, $vmai, $canr, $host, $mdtm, $nat, $qual, $tipo, $gcap, $cgru, $cblf, $denn, $perm, $nots) {
    $Insere   = "INSERT INTO vm50_ramais (nomecomplet, pseudonimo, ramal, senha, contexto, call_limit, mailbox, can_reinvite, host, dtmfmode, nat, qualify, tipo, callgroup, pickupgroup, subscribecontext, denny, permit, endereco, notificarsyonet, numeroaster) VALUES ('".$nome."', '".$pseu."', '".$rama."', '".$senh."', '".$cntx."', '".$lcha."',  '".$vmai."', ".$canr.", '".$host."', '".$mdtm."',  ".$nat.", ".$qual.", '".$tipo."', '".$gcap."', '".$cgru."', '".$cblf."', '".$denn."', '".$perm."', '-none-', '".$nots."', 'SIP/".$rama."')";
    $Res     = $this->Bd->executa_query_sem_saida($Insere);
    $Saida   = $Res;
	return $Saida;
  }

  //---------------------------------------------------
  // Funcao lista_grupo_ramais
  //---------------------------------------------------
  function lista_grupo_ramais($Ativo='') {
    $Pes1 = "SELECT * FROM ".$this->TabelGR." ORDER BY nome";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    if (!$Res1) $Saida = false;
    else {
      $Pes2 = "SELECT * FROM ".$this->TabelaR." ORDER BY grupo";
      $Res2 = $this->Bd->executa_query_com_saida($Pes2);
      if (!$Res2) $Saida = false;
      else $Saida = array($Res1,$Res2);
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao apaga_grupo_ramais
  //---------------------------------------------------
  function apaga_grupo_ramais($Identif) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    $Saida = true;
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Apa = "DELETE FROM ".$this->TabelGR." WHERE id='".$Identif."'";
      $Res = $this->Bd->executa_query_sem_saida($Apa);
      $Saida = $Res;
      if ($Saida) {
        $Pes2 = "UPDATE ".$this->TabelaR." SET grupo=NULL WHERE grupo=".$Identif;
        $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
        $Saida = $Res2;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao insere_grupo_ramais
  //---------------------------------------------------
  function insere_grupo_ramais($Nome) {
    $Pes  = "SELECT id FROM ".$this->TabelGR." WHERE nome='".$Nome."'";
    $Res  = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO ".$this->TabelGR." (nome) VALUES ('".$Nome."')";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      $Pes    = "SELECT id FROM ".$this->TabelGR." WHERE nome='".$Nome."'";
      $Res    = $this->Bd->executa_query_com_saida($Pes);
      $Saida  = $Res[0]['id'];
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_ramais_grupos
  //---------------------------------------------------
  function altera_ramais_grupos($Identif,$Ramais) {
    $Pes1 = "SELECT id FROM ".$this->TabelGR." WHERE id='".$Identif."'";
    $Res1 = $this->Bd->executa_query_com_saida($Pes1);
    $Saida = true;
    if ($Res1) {
      if (is_array($Ramais)) {
        for ($x=0; $x<count($Ramais); $x++) {
          $Pes2 = "UPDATE ".$this->TabelaR." SET grupo=".$Identif." WHERE ramal='".$Ramais[$x]."'";
          $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
        }
      }
    }
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_grupo_ramais
  //---------------------------------------------------
  function altera_grupo_ramais($Identif,$Nome) {
    $Identif = $this->Bd->limpa_query(trim($Identif));
    $Saida = true;
    if (!is_numeric($Identif)) $Saida = false;
    else {
      $Troca = "UPDATE ".$this->TabelGR." SET nome='".$Nome."' WHERE id='".$Identif."'";
      $Res   = $this->Bd->executa_query_sem_saida($Troca);
      $Saida = $Res;
      //return $Troca;
      if ($Saida) {
        $Pes2 = "UPDATE ".$this->TabelaR." SET grupo=NULL WHERE grupo=".$Identif;
        $Res2 = $this->Bd->executa_query_sem_saida($Pes2);
        $Saida = $Res2;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao limpa_texto
  //---------------------------------------------------
  function limpa_texto($Texto) {
    $Aux = trim($Texto);
    $Aux = str_replace("\n", "", $Aux);
    $Aux = str_replace("\r", "", $Aux);
    return $Aux;
  }




  //---------------------------------------------------
  // Funcao relatorio_feixes
  //---------------------------------------------------
  function relatorio_feixes($Feixe,$Inicio, $Fim, $tipoPes='monit') {
    $Said1 = '<br><br><spam style="font-size:12pt;">';
    $Pes2  = "SELECT ".$this->TabelaT.".numero_asterisk FROM ".$this->TabelaT." INNER JOIN ".$this->TabelaF." ON ".$this->TabelaT.".feixe = ".$this->TabelaF.".id WHERE ".$this->TabelaF.".nome= '".$Feixe."' AND ".$this->TabelaT.".sinalizacao='SIP' ORDER BY ".$this->TabelaT.".numero_asterisk";
//$K = $Pes2."<br><br>";
    if($tipoPes == 'monit') $Res2  = $this->Bd->executa_query_com_saida($Pes2);
	if($tipoPes == 'relat') $Res2  = $this->BdRelat->executa_query_com_saida($Pes2);
    $EhSIP = 0;
    if ($Res2) {
      $EhSIP = count($Res2);
      for ($s=0; $s<$EhSIP; $s++) $SipChan[$s]='L';
    }
    $Pes2  = "SELECT ".$this->TabelaT.".numero_asterisk FROM ".$this->TabelaT." INNER JOIN ".$this->TabelaF." ON ".$this->TabelaT.".feixe = ".$this->TabelaF.".id WHERE ".$this->TabelaF.".nome= '".$Feixe."' GROUP BY ".$this->TabelaT.".numero_asterisk ORDER BY ".$this->TabelaT.".numero_asterisk";
//$K.= $Pes2."<br><br>";
    if($tipoPes == 'monit') $Res2  = $this->Bd->executa_query_com_saida($Pes2);
	if($tipoPes == 'relat') $Res2  = $this->BdRelat->executa_query_com_saida($Pes2);
    if (!$Res2) return false;
    if ($EhSIP==0) $Quant['Troncos'] = count($Res2);
    elseif (count($Res2)==1) $Quant['Troncos'] = $EhSIP;
    else $Quant['Troncos'] = $EhSIP + count($Res2) -1;
    $K1 = $K2 = "";
    for ($y=0; $y<count($Res2); $y++) {
      if ($y>0) {
        $K1 .= " OR "; $K2 .= " OR ";
      }
//>>> Para suportar canais SIP
//      $K1 .= " canal_o='".$Res2[$y]['numero_asterisk']."' ";
//      $K2 .= " canal_d='".$Res2[$y]['numero_asterisk']."' ";
      $K1 .= " canal_o LIKE '".$Res2[$y]['numero_asterisk']."%' ";
      $K2 .= " canal_d LIKE '".$Res2[$y]['numero_asterisk']."%' ";
//<<< Para suportar canais SIP
    }
    $Pes1 = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, id, ligaca_o, numero_o, canal_o, ligaca_d, numero_d, canal_d, oque, direcao FROM ".$this->TabelaL." WHERE diahora >= '".$Inicio."' AND diahora <= '".$Fim."' AND (".$K1." OR ".$K2.") AND direcao='I' ORDER BY ligaca_o, diahora";
//$K.= $Pes1."<br><br>";
    if($tipoPes == 'monit') $Res1 = $this->Bd->executa_query_com_saida($Pes1);
	if($tipoPes == 'relat') $Res1 = $this->BdRelat->executa_query_com_saida($Pes1);
    $Pes2 = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, id, ligaca_o, numero_o, canal_o, ligaca_d, numero_d, canal_d, oque, direcao FROM ".$this->TabelaL." WHERE diahora >= '".$Inicio."' AND diahora <= '".$Fim."' AND (".$K1." OR ".$K2.") AND direcao='O' ORDER BY ligaca_d, diahora";
//$K.= $Pes2."<br><br>";
    if($tipoPes == 'monit') $Res2 = $this->Bd->executa_query_com_saida($Pes2);
	if($tipoPes == 'relat') $Res2 = $this->BdRelat->executa_query_com_saida($Pes2);
    $Pes3 = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, id, ligaca_o, numero_o, canal_o, ligaca_d, numero_d, canal_d, oque, direcao FROM ".$this->TabelaL." WHERE diahora >= '".$Inicio."' AND diahora <= '".$Fim."' AND (".$K1.") AND direcao='' ORDER BY diahora";
//$K.= $Pes3."<br><br>";
//return $K;
    if($tipoPes == 'monit') $Res3 = $this->Bd->executa_query_com_saida($Pes3);
	if($tipoPes == 'relat') $Res3 = $this->BdRelat->executa_query_com_saida($Pes3);
    //$Res4 = array_merge($Res1, $Res2);
    $Res  = array_merge($Res1, $Res2, $Res3);
    //Auxiliares
      $LBloq = array();
      list($Data,$Mpo) = explode(" ", $Fim); list($Ano,$Mes,$Dia) = explode("-", $Data);  list($Hor,$Min) = explode(":", $Mpo);
      $Fim2 = mktime($Hor,$Min,0,$Mes,$Dia,$Ano);
      list($Data,$Mpo) = explode(" ", $Inicio);  list($Ano,$Mes,$Dia) = explode("-", $Data);  list($Hor,$Min) = explode(":", $Mpo);
      $Ini2 = mktime($Hor,$Min,0,$Mes,$Dia,$Ano);
    if (is_array($Res)) {
      //Quantidades
      $Quant['Realizadas']['Completadas'] = 0;
      $Quant['Realizadas']['Nao completadas'] = 0;
      $Quant['Recebidas']['Humano'] = 0;
      $Quant['Recebidas']['Correio voz'] = 0;
      $Quant['Recebidas']['Mensagem'] = 0;
      $Quant['Recebidas']['Nao atendidas'] = 0;
      //Tempos
      $Tempo['Bloqueado'] = 0;
      $Tempo['Realizadas']['Conversacao'] = 0;
      $Tempo['Recebidas']['Conversacao']['Humano'] = 0;
      $Tempo['Recebidas']['Conversacao']['Correio voz'] = 0;
      $Tempo['Recebidas']['Conversacao']['Mensagem'] = 0;
      $Tempo['Realizadas']['Chamando'] = 0;
      $Tempo['Recebidas']['Chamando'] = 0;
      $Tempo['Total'] = 0;
      $Tempo['Total_nao_livre'] = 0;
      $Tempo['Livre'] = 0;
      //Primeira acao
      $Insta = trim($Res[0]['diahorario']);
      $Oque  = "";
      $Ligac = "";
      //Comeca a ler a linha do tempo
      for ($x=0; $x<count($Res); $x++) {
        if ($Res[$x]['direcao']=="I")     $LigaA = trim($Res[$x]['ligaca_o']);
        elseif ($Res[$x]['direcao']=="O") $LigaA = trim($Res[$x]['ligaca_d']);
        if (($Oque==trim($Res[$x]['oque'])) && ($Ligac==$LigaA) && ($Oque!='Livre') && ($Oque!='Bloqueado')) continue;
        if (substr(trim($Res[$x]['numero_d']),0,5)=="FILA-") continue;
        $Said1.= trim($Res[$x]['diahorario'])." | ".trim($Res[$x]['id'])." | ".trim($Res[$x]['ligaca_o'])." | ".trim($Res[$x]['numero_o'])." | ".trim($Res[$x]['canal_o'])." | ".trim($Res[$x]['ligaca_d'])." | ".trim($Res[$x]['numero_d'])." | ".trim($Res[$x]['canal_d'])." | ".trim($Res[$x]['oque'])." | ".trim($Res[$x]['direcao'])."<br>";
        $H = intval(date('G',$Insta),10);
        if ($Ligac != $LigaA) {
          $Insta = trim($Res[$x]['diahorario']); $Oque = "";
          $LCham=0; $LConv=0; $LCxPo=0; $LMens=0; $Receb=0; $Reali=0;
        }
        switch (trim($Res[$x]['oque'])) {
          case "Chamando":
            if ($LCham==0) {
              if ($Res[$x]['direcao']=="I") {
                $Receb=1;
              } elseif ($Res[$x]['direcao']=="O") {
                $Reali=1;
              }
              $LCham=1;
            }
          break;
          case "Em conversa&ccedil;&atilde;o":
            if ($LConv==0) {
              if ($Receb==1) {
                $Tempo['Recebidas']['Chamando']  += (trim($Res[$x]['diahorario']) - $Insta);
                $Tempo['H'][$H]['Recebidas']['Chamando']  += (trim($Res[$x]['diahorario']) - $Insta);
              } elseif ($Reali==1) {
                $Tempo['Realizadas']['Chamando'] += (trim($Res[$x]['diahorario']) - $Insta);
                $Tempo['H'][$H]['Realizadas']['Chamando'] += (trim($Res[$x]['diahorario']) - $Insta);
              }
            }
            $LConv=1;
          break;
          case "Caixa Postal":
            $Tempo['Recebidas']['Chamando'] += (trim($Res[$x]['diahorario']) - $Insta);
            $Quant['Recebidas']['Correio voz']++;
            $Tempo['H'][$H]['Recebidas']['Chamando'] += (trim($Res[$x]['diahorario']) - $Insta);
            $Quant['H'][$H]['Recebidas']['Correio voz']++;
            $LCxPo=1; $LConv=1; $Receb=1;
          break;
          case "Mensagem de atendimento":
            $Tempo['Recebidas']['Chamando'] += (trim($Res[$x]['diahorario']) - $Insta);
            $Quant['Recebidas']['Mensagem']++;
            $Tempo['H'][$H]['Recebidas']['Chamando'] += (trim($Res[$x]['diahorario']) - $Insta);
            $Quant['H'][$H]['Recebidas']['Mensagem']++;
            $LMens=1; $LConv=1; $Receb=1;
          break;
          case "Desligado":
            if ($LConv==0) {
              if ($Receb==1) {
                $Quant['Recebidas']['Nao atendidas']++;
                $Tempo['Recebidas']['Chamando']  += (trim($Res[$x]['diahorario']) - $Insta);
                $Quant['H'][$H]['Recebidas']['Nao atendidas']++;
                $Tempo['H'][$H]['Recebidas']['Chamando']  += (trim($Res[$x]['diahorario']) - $Insta);
                $LCxPo=0; $LMens=0; $LConv=0; $LCham=0;
              } elseif ($Reali==1) {
                $Quant['Realizadas']['Nao completadas']++;
                $Tempo['Realizadas']['Chamando'] += (trim($Res[$x]['diahorario']) - $Insta);
                $Quant['H'][$H]['Realizadas']['Nao completadas']++;
                $Tempo['H'][$H]['Realizadas']['Chamando'] += (trim($Res[$x]['diahorario']) - $Insta);
                $LCxPo=0; $LMens=0; $LConv=0; $LCham=0;
              }
            } elseif ($LConv==1) {
              if ($Receb==1) {
                if ($LCxPo==1) {
                  $Tempo['Recebidas']['Conversacao']['Correio voz'] += (trim($Res[$x]['diahorario']) - $Insta);
                  $Tempo['H'][$H]['Recebidas']['Conversacao']['Correio voz'] += (trim($Res[$x]['diahorario']) - $Insta);
                  $LCxPo=0; $LMens=0; $LConv=0; $LCham=0;
                } elseif ($LMens==1) {
                  $Tempo['Recebidas']['Conversacao']['Mensagem'] += (trim($Res[$x]['diahorario']) - $Insta);
                  $Tempo['H'][$H]['Recebidas']['Conversacao']['Mensagem'] += (trim($Res[$x]['diahorario']) - $Insta);
                  $LCxPo=0; $LMens=0; $LConv=0; $LCham=0;
                } else {
                  $Quant['Recebidas']['Humano']++;
                  $Tempo['Recebidas']['Conversacao']['Humano'] += (trim($Res[$x]['diahorario']) - $Insta);
                  $Quant['H'][$H]['Recebidas']['Humano']++;
                  $Tempo['H'][$H]['Recebidas']['Conversacao']['Humano'] += (trim($Res[$x]['diahorario']) - $Insta);
                  $LCxPo=0; $LMens=0; $LConv=0; $LCham=0;
                }
              } elseif ($Reali==1) {
                $Quant['Realizadas']['Completadas']++;
                $Tempo['Realizadas']['Conversacao'] += (trim($Res[$x]['diahorario']) - $Insta);
                $Quant['H'][$H]['Realizadas']['Completadas']++;
                $Tempo['H'][$H]['Realizadas']['Conversacao'] += (trim($Res[$x]['diahorario']) - $Insta);
                $LCxPo=0; $LMens=0; $LConv=0; $LCham=0;
              }
            }
          break;
          case "Bloqueado":
            if ($LBloq[$Res[$x]['canal_o']]==0) $LBloq[$Res[$x]['canal_o']] = trim($Res[$x]['diahorario']);
          break;
          case "Livre":
            if ($LBloq[$Res[$x]['canal_o']]>0) {
              $Tempo['Bloqueado'] += (trim($Res[$x]['diahorario']) - $LBloq[$Res[$x]['canal_o']]);
              $Tempo['H'][$H]['Bloqueado'] += (trim($Res[$x]['diahorario']) - $LBloq[$Res[$x]['canal_o']]);
              $LBloq[$Res[$x]['canal_o']]=0;
            }
          break;
        }
        $Insta = trim($Res[$x]['diahorario']);
        $Ligac = $LigaA;
        $Oque  = trim($Res[$x]['oque']);
      }
      //Se quando tirou o relatorio estava bloqueado
      foreach ($LBloq as $key=>$value) {
        if ($value>0) $Tempo['Bloqueado'] += ($Fim2 - $value);
      }
      $Tempo['Total'] = ($Fim2 - $Ini2) * $Quant['Troncos'];
      $Tempo['Total_nao_livre'] = ($Tempo['Bloqueado'] + $Tempo['Realizadas']['Conversacao'] + $Tempo['Recebidas']['Conversacao']['Humano'] + $Tempo['Recebidas']['Conversacao']['Correio voz'] + $Tempo['Recebidas']['Conversacao']['Mensagem'] + $Tempo['Realizadas']['Chamando'] + $Tempo['Recebidas']['Chamando']);
      ($Tempo['Total_nao_livre'] < $Tempo['Total']) ? $Tempo['Livre'] = ($Tempo['Total'] - $Tempo['Total_nao_livre']) : $Tempo['Livre'] = 0;
      $Aux = $this->congestionamento_feixes($Feixe,$Inicio, $Fim, $tipoPes);
        $Quant['Congestionado'] = $Aux[1]['Congestionado'];
        $Tempo['Congestionado'] = $Aux[0]['Congestionado'];
      $Saida = array($Feixe, $Tempo, $Quant);
    } else {
      $Tempo['Total'] = ($Fim2 - $Ini2) * $Quant['Troncos'];
      $Tempo['Total_nao_livre'] = ($Tempo['Bloqueado'] + $Tempo['Realizadas']['Conversacao'] + $Tempo['Recebidas']['Conversacao']['Humano'] + $Tempo['Recebidas']['Conversacao']['Correio voz'] + $Tempo['Recebidas']['Conversacao']['Mensagem'] + $Tempo['Realizadas']['Chamando'] + $Tempo['Recebidas']['Chamando']);
      ($Tempo['Total_nao_livre'] < $Tempo['Total']) ? $Tempo['Livre'] = ($Tempo['Total'] - $Tempo['Total_nao_livre']) : $Tempo['Livre'] = 0;
      $Saida = array($Feixe, $Tempo, $Quant);
    }
    return $Saida;
  }




  //---------------------------------------------------
  // Funcao congestionamento_feixes
  //---------------------------------------------------
  function congestionamento_feixes($Feixe,$Inicio, $Fim, $tipoPes='monit') {
    $Said1 = '<br><br><spam style="font-size:12pt;">';
    $Pes2  = "SELECT ".$this->TabelaT.".numero_asterisk FROM ".$this->TabelaT." INNER JOIN ".$this->TabelaF." ON ".$this->TabelaT.".feixe = ".$this->TabelaF.".id WHERE ".$this->TabelaF.".nome= '".$Feixe."' AND ".$this->TabelaT.".sinalizacao='SIP' ORDER BY ".$this->TabelaT.".numero_asterisk";
    if($tipoPes == 'monit') $Res2  = $this->Bd->executa_query_com_saida($Pes2);
	if($tipoPes == 'relat') $Res2  = $this->BdRelat->executa_query_com_saida($Pes2);
    $EhSIP = 0;
    if ($Res2) {
      $EhSIP = count($Res2);
      for ($s=0; $s<$EhSIP; $s++) $SipChan[$s]='L';
    }
    $Pes2  = "SELECT ".$this->TabelaT.".numero_asterisk FROM ".$this->TabelaT." INNER JOIN ".$this->TabelaF." ON ".$this->TabelaT.".feixe = ".$this->TabelaF.".id WHERE ".$this->TabelaF.".nome= '".$Feixe."' GROUP BY ".$this->TabelaT.".numero_asterisk ORDER BY ".$this->TabelaT.".numero_asterisk";
    if($tipoPes == 'monit') $Res2  = $this->Bd->executa_query_com_saida($Pes2);
	if($tipoPes == 'relat') $Res2  = $this->BdRelat->executa_query_com_saida($Pes2);
    if (!$Res2) return false;
    $Quant['Troncos'] = count($Res2);
    $K1 = $K2 = "";
    for ($y=0; $y<count($Res2); $y++) {
      if ($y>0) {
        $K1 .= " OR "; $K2 .= " OR ";
      }
      $K1 .= " canal_o='".$Res2[$y]['numero_asterisk']."' ";
      $K2 .= " canal_d='".$Res2[$y]['numero_asterisk']."' ";
      $Tronco[$Res2[$y]['numero_asterisk']] = 'L';
    }
    $Pes = "SELECT EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, canal_o,canal_d, oque FROM ".$this->TabelaL." WHERE diahora >= '".$Inicio."' AND diahora <= '".$Fim."' AND (".$K1." OR ".$K2.") ORDER BY diahora";
    if($tipoPes == 'monit') $Res = $this->Bd->executa_query_com_saida($Pes);
	if($tipoPes == 'relat') $Res = $this->BdRelat->executa_query_com_saida($Pes);
//return $Pes3;
    if (!is_array($Res)) $Saida = false;
    else {
      //Quantidades
      $Quant['Congestionado'] = 0;
      //Tempos
      $Tempo['Congestionado'] = 0;
      //Auxliar
      $Congesti = 0;
      list($Data,$Mpo) = explode(" ", $Fim); list($Ano,$Mes,$Dia) = explode("-", $Data);  list($Hor,$Min) = explode(":", $Mpo);
      $Fim2 = mktime($Hor,$Min,0,$Mes,$Dia,$Ano);
      //Primeira acao
      $Insta = trim($Res[0]['diahorario']);
      $Oque  = "";
      $Ligac = "";
      //Comeca a ler a linha do tempo
      for ($x=0; $x<count($Res); $x++) {
        $Said1.= trim($Res[$x]['diahorario'])." | ".trim($Res[$x]['id'])." | ".trim($Res[$x]['ligaca_o'])." | ".trim($Res[$x]['numero_o'])." | ".trim($Res[$x]['canal_o'])." | ".trim($Res[$x]['ligaca_d'])." | ".trim($Res[$x]['numero_d'])." | ".trim($Res[$x]['canal_d'])." | ".trim($Res[$x]['oque'])." | ".trim($Res[$x]['direcao'])."<br>";
        $Ca_o = trim($Res[$x]['canal_o']); $Ca_d = trim($Res[$x]['canal_d']);
        $Insta = trim($Res[$x]['diahorario']);
        $Oque  = trim($Res[$x]['oque']);
        switch (trim($Res[$x]['oque'])) {
          case "Chamando":
            if ($EhSIP>0) {
              $Aux = $this->ocupa_canal_sip($SipChan);
              if (!$Aux) {
                $Quant['Congestionado']++;
                $Tempo['Congestionado'] += (trim($Res[$x]['diahorario']) - $Congesti);
                $Congesti = 0;
              }
            } else {
              if (isset($Tronco[$Ca_o]))     $Tronco[$Ca_o] = 'O';
              elseif (isset($Tronco[$Ca_d])) $Tronco[$Ca_d] = 'O';
            }
          break;
          case "Em conversa&ccedil;&atilde;o":
            if (isset($Tronco[$Ca_o]))     $Tronco[$Ca_o] = 'O';
            elseif (isset($Tronco[$Ca_d])) $Tronco[$Ca_d] = 'O';
          break;
          case "Caixa Postal":
            if (isset($Tronco[$Ca_o]))     $Tronco[$Ca_o] = 'O';
            elseif (isset($Tronco[$Ca_d])) $Tronco[$Ca_d] = 'O';
          break;
          case "Mensagem de atendimento":
            if (isset($Tronco[$Ca_o]))     $Tronco[$Ca_o] = 'O';
            elseif (isset($Tronco[$Ca_d])) $Tronco[$Ca_d] = 'O';
          break;
          case "Desligado":
            if ($EhSIP>0) {
              $Aux = $this->livra_canal_sip($SipChan);
            } else {
              if (isset($Tronco[$Ca_o]))     $Tronco[$Ca_o] = 'L';
              elseif (isset($Tronco[$Ca_d])) $Tronco[$Ca_d] = 'L';
            }
          break;
          case "Bloqueado":
            if (isset($Tronco[$Ca_o]))     $Tronco[$Ca_o] = 'O';
            elseif (isset($Tronco[$Ca_d])) $Tronco[$Ca_d] = 'O';
          break;
          case "Livre":
            if (isset($Tronco[$Ca_o]))     $Tronco[$Ca_o] = 'L';
            elseif (isset($Tronco[$Ca_d])) $Tronco[$Ca_d] = 'L';
          break;
        }
        if ($this->testa_troncos_ocupados($Tronco)) {
          if ($Congesti==0) {
            $Congesti = $Insta;
            $Quant['Congestionado']++;
          }
        } else {
          if ($Congesti>0) {
            $Tempo['Congestionado'] += (trim($Res[$x]['diahorario']) - $Congesti);
            $Congesti = 0;
          }
        }
      }
      if ($Congesti>0) $Tempo['Congestionado'] += ($Fim2 - $Congesti);
      $Saida = array($Tempo, $Quant);
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao testa_troncos_ocupados
  //---------------------------------------------------
  function testa_troncos_ocupados($Lista) {
    if (!is_array($Lista)) return false;
    $Soma_ocupados = 0;
    $Total_troncos = 0;
    foreach ($Lista as $key=>$value) {
      if ($value == 'O') $Soma_ocupados++;
      $Total_troncos++;
    }
    if ($Soma_ocupados == $Total_troncos) $Saida = true;
    else $Saida = false;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao ocupa_canal_sip
  //---------------------------------------------------
  function ocupa_canal_sip($Lista) {
    if (!is_array($Lista)) return false;
    $s = 0;
    $Saida = false;
    while (($s<count($Lista) && (!$Saida)))  {
      if ($Lista[$s]='L') {
        $Lista[$s]='O';
        $Saida = true;
      }
      $s++;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao livra_canal_sip
  //---------------------------------------------------
  function livra_canal_sip($Lista) {
    if (!is_array($Lista)) return false;
    $s = 0;
    $Saida = false;
    while (($s<count($Lista) && (!$Saida)))  {
      if ($Lista[$s]='O') {
        $Lista[$s]='L';
        $Saida = true;
      }
      $s++;
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao conversando_com
  //---------------------------------------------------
  function conversando_com($Ramal) {
    $Dia  = date("d");
    $Mes  = date("m");
    $Ano  = date("Y");
    $Pes  = "SELECT ".$this->TabelLL.".obs, ".$this->TabelLL.".numero_dest, ".$this->TabelLL.".numero_orig, ".$this->TabelLL.".pa, to_char(".$this->TabelLL.".diahora, 'HH24:MI:SS') AS hora, to_char(".$this->TabelLL.".diahora_ult_est, 'HH24:MI:SS') AS hora_ult_est, ".$this->TabelLL.".id_orig as ligacao, ".$this->TabelLL.".tipo FROM ".$this->TabelLL;
    $Pes .= " WHERE ".$this->TabelLL.".estado='Em conversa&ccedil;&atilde;o' AND ".$this->TabelLL.".numero_orig!='' AND ".$this->TabelLL.".numero_dest!=''";
    $Pes .= " AND (".$this->TabelLL.".numero_dest='".$Ramal."' OR ".$this->TabelLL.".numero_orig='".$Ramal."')";
    $Pes .= " ORDER BY hora";
    //return $Pes;
    $Res = $this->Bd->executa_query_com_saida($Pes);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao le_chamadas_entrantes
  //---------------------------------------------------
  function le_chamadas_entrantes($Ramal,$Fila) {
    $Dia  = date("d");
    $Mes  = date("m");
    $Ano  = date("Y");
    $Pes  = "SELECT ".$this->TabelLL.".obs, ".$this->TabelLL.".numero_dest, ".$this->TabelLL.".numero_orig, ".$this->TabelLL.".pa, to_char(".$this->TabelLL.".diahora, 'HH24:MI:SS') AS hora, ".$this->TabelLL.".id_orig as ligacao FROM ".$this->TabelLL;
    $Pes .= " WHERE ".$this->TabelLL.".estado='Chamando' AND ".$this->TabelLL.".numero_orig!='' AND ".$this->TabelLL.".numero_dest!='' AND ".$this->TabelLL.".tipo = 'I'";
    if (is_array($Fila)) $Pes .= " AND (";
    else $Pes .= " AND ";
    if ($Ramal!="") $Pes .= "(".$this->TabelLL.".numero_dest='".$Ramal."' OR ".$this->TabelLL.".pa='".$Ramal."') ";
    if (is_array($Fila)) {
      $Pes .= " OR ";
      for ($x=0; $x<count($Fila); $x++) {
        $Pes .= $this->TabelLL.".numero_dest='".$Fila[$x]."' OR ".$this->TabelLL.".fila_original='".$Fila[$x]."'";
        if ($x!=count($Fila)-1) $Pes .= " OR ";
      }
      $Pes .= ")";
    }
    $Pes .= " ORDER BY diahora";
    //return $Pes;
    $Res = $this->Bd->executa_query_com_saida($Pes);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao ultimas_ligacoes_feitas
  //---------------------------------------------------
  function ultimas_ligacoes_feitas($Ramal,$Quantidade) {
    if (!($this->lista_dado_ramal_por_ramal($Ramal))) return false;
    $Quantidade = $Quantidade + 0;
    $Pes   = "SELECT DISTINCT ON (ligaca_o) EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, ligaca_o, numero_o, numero_d FROM ".$this->TabelaL." WHERE numero_o='".$Ramal."' AND numero_d!='".$Ramal."' AND numero_o != '' AND numero_d != '' ORDER BY ligaca_o DESC, diahorario DESC LIMIT ".$Quantidade;
    $Res   = $this->Bd->executa_query_com_saida($Pes);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao ultimas_ligacoes_atendidas
  //---------------------------------------------------
  function ultimas_ligacoes_atendidas($Ramal,$Quantidade) {
    if (!($this->lista_dado_ramal_por_ramal($Ramal))) return false;
    $Quantidade = $Quantidade + 0;
    $Pes   = "SELECT DISTINCT ON (ligaca_d) EXTRACT(EPOCH FROM DATE_TRUNC('second',diahora)) as diahorario, ligaca_d, numero_o, numero_d FROM ".$this->TabelaL." WHERE numero_o!='".$Ramal."' AND numero_d='".$Ramal."' AND oque='Em conversa&ccedil;&atilde;o' AND numero_o != '' AND numero_d != '' ORDER BY ligaca_d DESC, diahorario DESC LIMIT ".$Quantidade;
    $Res   = $this->Bd->executa_query_com_saida($Pes);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao ultimas_ligacoes_nao_atendidas
  //---------------------------------------------------
  function ultimas_ligacoes_nao_atendidas($Ramal,$Quantidade) {
    if (!($this->lista_dado_ramal_por_ramal($Ramal))) return false;
    $Quantidade = $Quantidade + 0;
    $Pes   = "SELECT DISTINCT ON (".$this->TabelaL.".ligaca_d) EXTRACT(EPOCH FROM DATE_TRUNC('second',".$this->TabelaL.".diahora)) as diahorario, ".$this->TabelaL.".ligaca_d, ".$this->TabelaL.".numero_o, ".$this->TabelaL.".numero_d FROM ".$this->TabelaL." INNER JOIN ";
    $Pes  .= "(SELECT DISTINCT ON (ligaca_d) ligaca_d FROM ".$this->TabelaL." WHERE numero_d='".$Ramal."' EXCEPT (SELECT DISTINCT ON (ligaca_d) ligaca_d FROM ".$this->TabelaL." WHERE numero_o!='".$Ramal."' AND numero_d='".$Ramal."' AND oque='Em conversa&ccedil;&atilde;o') ORDER BY ligaca_d DESC LIMIT ".$Quantidade.") AS id_valido ";
    $Pes  .= "ON ".$this->TabelaL.".ligaca_d = id_valido.ligaca_d ORDER BY ".$this->TabelaL.".ligaca_d DESC, diahorario DESC";
    $Res   = $this->Bd->executa_query_com_saida($Pes);
    $Saida = $Res;
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao marca_turnos_mesa
  //---------------------------------------------------
  function marca_turnos_mesa($Ramal) {
    $Pes = "SELECT fha FROM ".$this->TabelTM." WHERE ramal='".$Ramal."'";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO ".$this->TabelTM." (ramal,fha) VALUES (".$Ramal.", 1)";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      if (!$Res) $Saida = false;
      else {
        $this->altera_estado_luzes_ramal($Ramal,'noturno',1);
        $Saida = 1;
      }
    } else {
      $Situa = $Res[0]['fha'];
      ($Situa==1) ? $Situa=0 : $Situa=1;
      $Troca = "UPDATE ".$this->TabelTM." SET fha=".$Situa." WHERE ramal='".$Ramal."'";
      $Res   = $this->Bd->executa_query_sem_saida($Troca);
      if (!$Res) $Saida = false;
      else {
        $this->altera_estado_luzes_ramal($Ramal,'noturno',$Situa);
        $Saida = $Situa;
      }
    }
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao lista_luzes_ramal
  //---------------------------------------------------
  function lista_luzes_ramal($Ramal) {
    $Ramal = trim($Ramal);
    $Pes = "SELECT * FROM ".$this->Tabeluz." WHERE ramal='".$Ramal."'";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) {
      $Insere = "INSERT INTO ".$this->Tabeluz." (ramal) VALUES (".$Ramal.")";
      $Res    = $this->Bd->executa_query_sem_saida($Insere);
      if (!$Res) $Saida = false;
      else $Saida = array('cadeado' => 0, 'voicemail' => 0, 'ausente' => 0, 'noturno' => 0, 'mudo' => 0, 'autoatendimento' => 0, 'sigamesempre' => 0, 'sigamesenaoatende' => 0, 'sigameseocupado' => 0);
    } else $Saida = $Res[0];
    return $Saida;
  }


  //---------------------------------------------------
  // Funcao altera_estado_luzes_ramal
  //---------------------------------------------------
  function altera_estado_luzes_ramal($Ramal,$Luz,$Estado) {
    $Pes = "SELECT * FROM ".$this->Tabeluz." WHERE ramal='".$Ramal."'";
    $Res = $this->Bd->executa_query_com_saida($Pes);
    if (!$Res) return false;
    if (($Estado!=0) && ($Estado!=1)) return false;
    $Luzes = array('cadeado', 'voicemail', 'ausente', 'noturno', 'mudo', 'autoatendimento', 'sigamesempre', 'sigamesenaoatende', 'sigameseocupado');
    if (!(in_array($Luz, $Luzes))) return false;
    $Troca = "UPDATE ".$this->Tabeluz." SET ".$Luz."=".$Estado." WHERE ramal='".$Ramal."'";
    $Res   = $this->Bd->executa_query_sem_saida($Troca);
    if (!$Res) $Saida = false;
    else $Saida = true;
    return $Saida;
  }
  
   //----------------------------------------------------
  // Funcao gera_tela_bilhetes
  //----------------------------------------------------
  function gera_tela_bilhetes($Dados,$Query) {
    $Saida = false;
	$Pes = "SELECT * FROM cdr WHERE ".$Query;
	//return $Pes;
	$Res = $this->Cdr->executa_query_com_saida($Pes);
	if($Res)$Saida = $Res;
	else if($Res === false) $Saida = "Não foi possíel conectar.";
	//$Saida = $Res;
	return $Saida;
  }
  
  /*********************************************************
   Funcao:     insere_grupo_troncos
  *********************************************************/
  function insere_grupo_troncos($grupo, $descricaoGrupo) {
     $sql = "SELECT * FROM ".$this->tabelaGrupoTronco." WHERE nome_grupo ='".$grupo."' LIMIT 1";
     $resultado = $this->Bd->executa_query_com_saida($sql);
	 if($resultado){
		$saida = "GRUPO_CADASTRADO";	
	 }
     else{
		 $sqlUm = "INSERT INTO ".$this->tabelaGrupoTronco." (nome_grupo, descricao_grupo) VALUES ";
		 $sqlUm.= "('".$grupo."','".$descricaoGrupo."')";
		 $resultado = $this->Bd->executa_query_sem_saida($sqlUm);
		 if($resultado){
			$sqlDois = "SELECT id FROM ".$this->tabelaGrupoTronco." WHERE nome_grupo ='".$grupo."' LIMIT 1";
			$resultado = $this->Bd->executa_query_com_saida($sqlDois);
			$saida = $resultado[0]["id"];
		 }
	  }
	  return $saida;
  } 
  
  /**********************************************************
   Funcao:      atualiza_tronco_grupo
  **********************************************************/
  function atualiza_tronco_grupo($id, $troncos) {
     if(is_array($troncos)){
	    $identificador = intval(trim($id),10);
	    for($i = 0; $i < count($troncos); $i++){
  	 		$sql = "UPDATE ".$this->TabelaT." set id_grupo_tronco =".$identificador." WHERE numero_vdt='".$troncos[$i]."'";
	 		$resultado = $this->Bd->executa_query_sem_saida($sql);
		}
	 }
  }
  
  function entrar_pausa($ramal, $fila){
	//return "Action: QueueRemove\r\nQueue: ".$fila."\r\nInterface: sip/".$ramal;
	return $this->Meia->envia_socket("Action: QueueRemove\r\nQueue: ".$fila."\r\nInterface: SIP/".$ramal);
  }
  
  function sair_pausa($ramal, $fila){
	return $this->Meia->envia_socket("Action: QueueAdd\r\nQueue: ".$fila."\r\nInterface: SIP/".$ramal."\r\nPaused: false");
  }
  
  function entrar_fila($ramal, $fila){
	return $this->Meia->envia_socket("Action: QueueAdd\r\nQueue: ".$fila."\r\nInterface: SIP/".$ramal."\r\nPaused: false");
  }
  
  function sair_fila($ramal, $fila){
	//return "Action: QueueRemove\r\nQueue: ".$fila."\r\nInterface: sip/".$ramal;
	return $this->Meia->envia_socket("Action: QueueRemove\r\nQueue: ".$fila."\r\nInterface: SIP/".$ramal);
  }
  
  function inserir_orbita($mesa, $numero){
	  $Pes = "SELECT * FROM ".$this->TabelaO." WHERE numero = '".$numero."'";
	  $Res = $this->Bd->executa_query_com_saida($Pes);
	  for($i = 0; $i < count($Res); $i++){
	  	if($Res[$i]['mesa'] == ''){
			$Orbita = $Res[$i]['orbita'];
	  		$Pes = "UPDATE ".$this->TabelaO." SET mesa = ".$mesa." WHERE orbita = '".$Orbita."'";
	  		$Res = $this->Bd->executa_query_sem_saida($Pes);
		}
	  }
	  return $Orbita;
  }
  
  function retirar_orbita($orbita){
	$Pes = "UPDATE ".$this->TabelaO." SET id = '', numero = '', mesa = null WHERE orbita = '".$orbita."'";
	$Res = $this->Bd->executa_query_com_saida($Pes);
  }
  
  function lista_orbita($orbita){
	$Pes = "SELECT * FROM ".$this->TabelaO." WHERE orbita = '".$orbita."'";
	return $this->Bd->executa_query_com_saida($Pes);
  }
  
  function lista_auxiliares_filas(){
	$Pes = "SELECT r.id as id_ramal, r.ramal, f.id as id_fila, f.nome as fila FROM vm50_ramais as r INNER JOIN vm50_auxiliares_filas as af ON r.id = af.ramal INNER JOIN vm50_filas as f ON f.id = af.fila";
	$Res = $this->Bd->executa_query_com_saida($Pes);
	if(!$Res) $Saida = false;
	else $Saida = $Res;
	return $Saida;
  }
  
  function lista_auxiliares_filas_por_fila($nomeFila){
	$Pes = "SELECT r.id as id_ramal, r.ramal, f.id as id_fila, f.nome as fila FROM vm50_ramais as r INNER JOIN vm50_auxiliares_filas as af ON r.id = af.ramal INNER JOIN vm50_filas as f ON f.id = af.fila WHERE f.nome = '".$nomeFila."'";
	$Res = $this->Bd->executa_query_com_saida($Pes);
	if(!$Res) $Saida = false;
	else $Saida = $Res;
	return $Saida;
  }
  
  function inserir_ramais_auxiliares($fila, $ramal){
	$Pes = "SELECT * FROM vm50_auxiliares_filas WHERE fila = ".$fila." AND ramal = ".$ramal;
	$Res = $this->Bd->executa_query_com_saida($Pes);
	if(count($Res)==0){
		$Pes = "INSERT INTO vm50_auxiliares_filas (fila, ramal) VALUES (".$fila.", ".$ramal.")";
		$Res = $this->Bd->executa_query_sem_saida($Pes);
		return $Res;
	} else return true;
  }
  
  function remover_ramais_auxiliares($fila, $ramal){
	$Pes = "SELECT * FROM vm50_auxiliares_filas WHERE fila = ".$fila." AND ramal = ".$ramal;
	$Res = $this->Bd->executa_query_com_saida($Pes);
	if(count($Res)>0){
		$Pes = "DELETE FROM vm50_auxiliares_filas WHERE fila = ".$fila." AND ramal = ".$ramal;
		$Res = $this->Bd->executa_query_sem_saida($Pes);
		return $Res;
	} else return true;
  }
  
  function acende_auxiliar(){
	$Pes = "UPDATE ".$this->Tabeluz." SET auxiliar = 1";
	return $this->Bd->executa_query_sem_saida($Pes);
  }
  
  function apaga_auxiliar(){
	$Pes = "UPDATE ".$this->Tabeluz." SET auxiliar = 0";
	return $this->Bd->executa_query_sem_saida($Pes);
  }
  
  function monitora_auxiliar(){
	$Pes = "SELECT auxiliar FROM ".$this->Tabeluz." LIMIT 1";
	return $this->Bd->executa_query_com_saida($Pes);
  }
  
  function lista_fha_filas(){
	$Pes = "SELECT r.id as id_ramal, r.ramal, f.id as id_fila, f.nome as fila FROM vm50_ramais as r INNER JOIN vm50_fha_filas as ff ON r.id = ff.ramal INNER JOIN vm50_filas as f ON f.id = ff.fila";
	$Res = $this->Bd->executa_query_com_saida($Pes);
	if(!$Res) $Saida = false;
	else $Saida = $Res;
	return $Saida;
  }
  
  function lista_fha_filas_por_fila($nomeFila){
	$Pes = "SELECT r.id as id_ramal, r.ramal, f.id as id_fila, f.nome as fila FROM vm50_ramais as r INNER JOIN vm50_fha_filas as ff ON r.id = ff.ramal INNER JOIN vm50_filas as f ON f.id = ff.fila WHERE f.nome = '".$nomeFila."'";
	$Res = $this->Bd->executa_query_com_saida($Pes);
	if(!$Res) $Saida = false;
	else $Saida = $Res;
	return $Saida;
  }
  
  function inserir_ramais_fha($fila, $ramal){
	$Pes = "SELECT * FROM vm50_fha_filas WHERE fila = ".$fila." AND ramal = ".$ramal;
	$Res = $this->Bd->executa_query_com_saida($Pes);
	if(count($Res)==0){
		$Pes = "INSERT INTO vm50_fha_filas (fila, ramal) VALUES (".$fila.", ".$ramal.")";
		$Res = $this->Bd->executa_query_sem_saida($Pes);
		return $Res;
	} else return true;
  }
  
  function remover_ramais_fha($fila, $ramal){
	$Pes = "SELECT * FROM vm50_fha_filas WHERE fila = ".$fila." AND ramal = ".$ramal;
	$Res = $this->Bd->executa_query_com_saida($Pes);
	if(count($Res)>0){
		$Pes = "DELETE FROM vm50_fha_filas WHERE fila = ".$fila." AND ramal = ".$ramal;
		$Res = $this->Bd->executa_query_sem_saida($Pes);
		return $Res;
	} else return true;
  }
  
  function acende_fha(){
	$Pes = "UPDATE ".$this->Tabeluz." SET noturno = 1";
	return $this->Bd->executa_query_sem_saida($Pes);
  }
  
  function apaga_fha(){
	$Pes = "UPDATE ".$this->Tabeluz." SET noturno = 0";
	return $this->Bd->executa_query_sem_saida($Pes);
  }
  
  function monitora_fha(){
	$Pes = "SELECT noturno FROM ".$this->Tabeluz." LIMIT 1";
	return $this->Bd->executa_query_com_saida($Pes);
  }
  
  function pesquisa_grupo_pelo_id($id){
	$Pes = "SELECT g.* FROM ".$this->TabelGR." as g WHERE g.id = ".$id;
	return $this->Bd->executa_query_com_saida($Pes);
  }
  
  function pesquisa_ramais_relacionados(){
	$Pes = "SELECT r.* FROM ".$this->TabelaR." AS r INNER JOIN vm50_ramais_relacionados AS rr ON rr.ramal = r.id ORDER BY r.ramal";
	return $this->Bd->executa_query_com_saida($Pes);
  }
  
  function pesquisa_ramais_relacionados_por_id($id){
	$Pes = "SELECT r.* FROM ".$this->TabelaR." AS r INNER JOIN vm50_ramais_relacionados AS rr ON rr.ramal = r.id WHERE rr.pai = ".$id." ORDER BY r.ramal";
	return $this->Bd->executa_query_com_saida($Pes);
  }
  
  function inserir_ramal_relacionado($idPai, $ramal){
	$Pes = "INSERT INTO vm50_ramais_relacionados (pai, ramal) VALUES (".$idPai.", ".$ramal.")";
	return $this->Bd->executa_query_com_saida($Pes);
  }
  
  function deletar_ramais_relacionados_por_id($idPai){
	$Pes = "DELETE FROM vm50_ramais_relacionados WHERE pai = ".$idPai;
	return $this->Bd->executa_query_com_saida($Pes);
  }
  
  function pesquisa_extensoes(){
	$Pes = "SELECT * FROM vm50_extensoes";
	return $this->Bd->executa_query_com_saida($Pes);
  }
  
  function altera_extensoes($id, $nome, $codigo){
	$sql = "UPDATE vm50_extensoes SET nome = '".$nome."', codigo=".$codigo." WHERE id = ".$id;
	return $this->Bd->executa_query_sem_saida($sql);
  }
  
  function inclui_extensao($nome, $codigo){
	$sql = "INSERT INTO vm50_extensoes (nome, codigo) VALUES ('".$nome."', ".$codigo.")";
	return $this->Bd->executa_query_sem_saida($sql);
  }
  
  function deleta_extensao($identif){
	$sql = "DELETE FROM vm50_extensoes WHERE id = ".$identif;
	return $this->Bd->executa_query_sem_saida($sql);
  }
  
  function pesquisa_ramais_relatorio($per_d, $per_a, $usuario_id){
	if(isset($usuario_id) && $usuario_id != "")
        $sql = "SELECT r.ramal FROM vm50_usuarios_ramais AS ur INNER JOIN vm50_usuarios AS u ON ur.usuario = u.id INNER JOIN vm50_ramais AS r ON ur.ramal = r.id WHERE u.id = ".$usuario_id." order by u.nome, r.ramal";
    else
        $sql = "SELECT ramal FROM vm50_ramais ORDER BY ramal";

	$ram = $this->Bd->executa_query_com_saida($sql);
	if($per_d != $per_a && $per_d != "" && $per_a != ""){
		$sql = "SELECT src FROM cdr WHERE calldate >= '".$per_d." 00:00' AND calldate <= '".$per_a." 23:59' GROUP BY src ORDER BY src";
		$sql1 = $this->Cdr->executa_query_com_saida($sql);
		$sql = "SELECT dst FROM cdr WHERE calldate >= '".$per_d." 00:00' AND calldate <= '".$per_a." 23:59' GROUP BY dst ORDER BY dst";
		$sql2 = $this->Cdr->executa_query_com_saida($sql);
	} else {
		$sql = "SELECT src FROM cdr WHERE calldate LIKE '".$per_d."%' GROUP BY src ORDER BY src";
		$sql1 = $this->Cdr->executa_query_com_saida($sql);
		$sql = "SELECT dst FROM cdr WHERE calldate LIKE '".$per_d."%' GROUP BY dst ORDER BY dst";
		$sql2 = $this->Cdr->executa_query_com_saida($sql);
	}
	if(count($sql1) > count($sql2)) $qtd = count($sql1);
	else $qtd = count($sql2);	
	
	for($i = 0; $i < $qtd; $i++){
		for($j = 0; $j < count($ram); $j++){
			if(trim($ram[$j]["ramal"]) == trim($sql1[$i]["src"])){
				$ramais[$sql1[$i]['src']] = $sql1[$i]['src'];
			}
			if(trim($ram[$j]["ramal"]) == trim($sql2[$i]["dst"])){
				$ramais[$sql2[$i]['dst']] = $sql2[$i]['dst'];
			}
		}
	}
	ksort($ramais);
	return $ramais;
  }
  
  function pesquisa_servicos_mensagem_relatorio($per_d, $per_a){
	if($per_d != $per_a && $per_d != "" && $per_a != ""){
		$sql = "SELECT dst FROM cdr WHERE calldate >= '".$per_d." 00:00' AND calldate <= '".$per_a." 23:59' AND lastapp='Playback' AND dst != 's' GROUP BY dst ORDER BY dst";
		$sql1 = $this->Cdr->executa_query_com_saida($sql);
	} else {
		$sql = "SELECT dst FROM cdr WHERE calldate LIKE '".$per_d."%' AND lastapp='Playback' AND dst != 's' GROUP BY dst ORDER BY dst";
		$sql1 = $this->Cdr->executa_query_com_saida($sql);
	}
	
	for($i = 0; $i < count($sql1); $i++){
		$dst = str_replace("#", "", $sql1[$i]['dst']);
		$sql = "SELECT nome FROM vm50_extensoes WHERE codigo = ".$dst;
		$nome = $this->Bd->executa_query_com_saida($sql);
		$saida[$dst] = $nome[0]['nome'];
	}
	
	return $saida;
  }
  
  function gera_bilhetes_mensagens($periodo_d, $periodo_a, $servico){
	$sql = "SELECT * FROM cdr WHERE calldate >= '".$periodo_d." 00:00' AND calldate <= '".$periodo_a." 23:59' AND dst = '#".$servico."' AND lastapp = 'Playback' ";
	$sql .= "ORDER BY calldate";
	return $this->Cdr->executa_query_com_saida($sql);
  }
  
  function pesquisa_servicos_ivr_relatorio($per_d, $per_a){
	if($per_d != $per_a && $per_d != "" && $per_a != ""){
		$sql = "SELECT dst FROM cdr WHERE calldate >= '".$per_d." 00:00' AND calldate <= '".$per_a." 23:59' AND lastapp='Background' AND dst != 's' GROUP BY dst ORDER BY dst";
		$sql1 = $this->Cdr->executa_query_com_saida($sql);
	} else {
		$sql = "SELECT dst FROM cdr WHERE calldate LIKE '".$per_d."%' AND lastapp='Background' AND dst != 's' GROUP BY dst ORDER BY dst";
		$sql1 = $this->Cdr->executa_query_com_saida($sql);
	}
	
	for($i = 0; $i < count($sql1); $i++){
		$dst = str_replace("#", "", $sql1[$i]['dst']);
		$sql = "SELECT nome FROM vm50_extensoes WHERE codigo = ".$dst;
		$nome = $this->Bd->executa_query_com_saida($sql);
		$saida[$dst] = $nome[0]['nome'];
	}
	
	return $saida;
  }
  
  function gera_bilhetes_ivr($periodo_d, $periodo_a, $servico){
	$sql = "SELECT * FROM cdr WHERE calldate >= '".$periodo_d." 00:00' AND calldate <= '".$periodo_a." 23:59' AND dst = '".$servico."' AND lastapp = 'Background' ";
	$sql .= "ORDER BY calldate";
	return $this->Cdr->executa_query_com_saida($sql);
  }
  
  function pesquisa_filas_relatorio($per_d, $per_a){
	if($per_d != $per_a && $per_d != "" && $per_a != ""){
		$sql = "SELECT dcontext FROM cdr WHERE calldate >= '".$per_d." 00:00' AND calldate <= '".$per_a." 23:59' AND lastapp='Queue' AND dst != 's' GROUP BY dcontext ORDER BY dcontext";
		$sql1 = $this->Cdr->executa_query_com_saida($sql);
	} else {
		$sql = "SELECT dcontext FROM cdr WHERE calldate LIKE '".$per_d."%' AND lastapp='Queue' AND dst != 's' GROUP BY dcontext ORDER BY dcontext";
		$sql1 = $this->Cdr->executa_query_com_saida($sql);
	}
	
	for($i = 0; $i < count($sql1); $i++){
		$filas[$sql1[$i]['dcontext']] = $sql1[$i]['dcontext'];
	}
	
	return $filas;
  }
  
  function gera_bilhetes_fila($periodo_d, $periodo_a, $fila){
	$sql = "SELECT * FROM cdr WHERE calldate >= '".$periodo_d." 00:00' AND calldate <= '".$periodo_a." 23:59' AND dcontext = '".$fila."' AND lastapp = 'Queue' ";
	$sql .= "ORDER BY calldate";
	return $this->Cdr->executa_query_com_saida($sql);
  }
  
  function falando_com($Ramal){
	$Pes = "SELECT falandocom FROM vm50_ramais WHERE ramal = '".$Ramal."'";
	$Res = $this->Bd->executa_query_com_saida($Pes);
	return $Res;
  }
  
  function pesquisa_ramal_perso($id_usuario, $ramal){
	$Pes = "SELECT r.* FROM vm50_ramais AS r INNER JOIN vm50_grupos_perso AS gp ON gp.ramal = r.id WHERE gp.usuario = ".$id_usuario." AND r.ramal like '".$ramal."'";
	$Res = $this->Bd->executa_query_com_saida($Pes);
	return $Res;
  }
  
  function altera_ramais_sip_conf($identif, $nome, $pseu, $rama, $senh, $cntx, $lcha, $cvoz, $canr, $host, $mdtm, $nat, $qual, $tipo, $gcap, $cgru, $cblf, $denn, $perm) {
	$rama = trim($rama);
	$linhas = file_get_contents($this->Dir_conf_aterisk."sip.conf");
	$linhas = explode("\n", $linhas);
	for($i = 0; $i < count($linhas); $i++){
		if($linhas[$i] == "[".trim($rama)."]"){
			$linhas[$i+1] = 'callerid="'.$pseu.'" <'.$rama.'>';
			$linhas[$i+2] = 'secret='.$senh;
			$linhas[$i+3] = 'context='.$cntx;
			$linhas[$i+4] = 'call-limit='.$lcha;
			$linhas[$i+5] = 'mailbox='.$cvoz;
			if($canr == "0") $linhas[$i+6] = 'canreinvite=no';
			else $linhas[$i+6] = 'canreinvite=yes';
			$linhas[$i+7] = 'host='.$host;
			$linhas[$i+8] = 'dtmfmode='.$mdtm;
			if($nat == "0") $linhas[$i+9] = 'nat=no';
			else $linhas[$i+9] = 'nat=yes';
			if($qual == "0") $linhas[$i+10] = 'qualify=no';
			else $linhas[$i+10] = 'qualify=yes';
			$linhas[$i+11] = 'type='.$tipo;
			$linhas[$i+12] = 'callgroup='.$gcap;
			$linhas[$i+13] = 'pickupgroup='.$cgru;
			$linhas[$i+14] = 'subscribecontext='.$cblf;
			$linhas[$i+15] = 'deny='.$denn;
			$linhas[$i+16] = 'permit='.$perm;
		}
		$out .= $linhas[$i]."\n";
	}
	unlink($this->Dir_conf_aterisk."sip.conf");
	file_put_contents($this->Dir_conf_aterisk."sip.conf", $out);
	return true;
  }
  
  function insere_ramais_sip_conf($nome, $pseu, $rama, $senh, $cntx, $lcha, $cvoz, $canr, $host, $mdtm, $nat, $qual, $tipo, $gcap, $cgru, $cblf, $denn, $perm) {
	$rama = trim($rama);
	$linhas = file_get_contents($this->Dir_conf_aterisk."sip.conf");
	$linhas = explode("\n", $linhas);
	for($i = 0; $i < count($linhas); $i++){
		if($linhas[$i] == "[".trim($rama)."]"){
			return false;
		}
		$out .= $linhas[$i]."\n";
	}
	$out .= "\n[".trim($rama)."]\n";
	$out .= 'callerid="'.$pseu.'" <'.$rama.'>'."\n";
	$out .=  'secret='.$senh."\n";
	$out .=  'context='.$cntx."\n";
	$out .= 'call-limit='.$lcha."\n";
	$out .= 'mailbox='.$cvoz."\n";
	if($canr == "0") $out .= 'canreinvite=no'."\n";
	else $out .= 'canreinvite=yes'."\n";
	$out .= 'host='.$host."\n";
	$out .= 'dtmfmode='.$mdtm."\n";
	if($nat == "0") $out .= 'nat=no'."\n";
	else $out .= 'nat=yes'."\n";
	if($qual == "0") $out .= 'qualify=no'."\n";
	else $out .= 'qualify=yes'."\n";
	$out .= 'type='.$tipo."\n";
	$out .= 'callgroup='.$gcap."\n";
	$out .= 'pickupgroup='.$cgru."\n";
	$out .= 'subscribecontext='.$cblf."\n";
	$out .= 'deny='.$denn."\n";
	$out .= 'permit='.$perm."\n";
	unlink($this->Dir_conf_aterisk."sip.conf");
	file_put_contents($this->Dir_conf_aterisk."sip.conf", $out);
	return true;
  }
  
  function apaga_ramais_sip_conf($rama) {
	$rama = trim($rama);
	$linhas = file_get_contents($this->Dir_conf_aterisk."sip.conf");
	$linhas = explode("\n", $linhas);
	for($i = 0; $i < count($linhas); $i++){
		if($linhas[$i] == "[".trim($rama)."]"){
			while(substr($linhas[$i+1], 0, 1) != "[" && $i < count($linhas)) $i++;
            //$i += 16;
		} else $out .= $linhas[$i]."\n";
	}
	unlink($this->Dir_conf_aterisk."sip.conf");
	file_put_contents($this->Dir_conf_aterisk."sip.conf", $out);
	return true;
  }
  
  function verifica_ramal_sip_conf($rama){
	$rama = trim($rama);
	$linhas = file_get_contents($this->Dir_conf_aterisk."sip.conf");
	$linhas = explode("\n", $linhas);
	for($i = 0; $i < count($linhas); $i++){
		if($linhas[$i] == "[".trim($rama)."]"){
			return true;
		}
	}
	return false;
  }
  
  function lista_ramal_sip_conf(){
	$ramais = array();
	$j = -1;
	$linhas = file_get_contents($this->Dir_conf_aterisk."sip.conf");
	$linhas = explode("\n", $linhas);
	for($i = 0; $i < count($linhas); $i++){
        if(substr($linhas[$i], 0, 1) == "[" && is_numeric(substr($linhas[$i], 1, (strlen($linhas[$i])-2)))) {
            $j++;
            $ram = substr($linhas[$i], 1, (strlen($linhas[$i])-2));
            $ramais[$j]['ramal'] = $ram;
        } else {
            if(
                trim($linhas[$i] != "") && 
                substr($linhas[$i], 0, 1) != "[" && 
                isset($ramais[$j]['ramal']) && 
                substr($linhas[$i], 0, 1) != ";"
            ){
                list($key, $value) = explode("=", $linhas[$i]);
                
                if($key == "callerid" && substr($value, 0, 1) == '"') 
                    $ramais[$j][strtolower($key)] = substr($value, 1, (strrpos($value, '"')-1));
                else 
                    $ramais[$j][strtolower($key)] = str_replace('"', '', $value);
            }
        }
	}
	return $ramais;
  }
  
  function busca_ramal_pelo_ramal($ramal){
	$Pes = "SELECT * FROM vm50_ramais WHERE ramal = '".$ramal."'";
	return $this->Bd->executa_query_com_saida($Pes);
  }
  
  function lista_grupos_sip_conf(){
	$Pes = "SELECT * FROM vm50_grupos_captura ORDER BY id";
	$tb_grupos = $this->Bd->executa_query_com_saida($Pes);
	$linhas = file_get_contents($this->Dir_conf_aterisk."sip.conf");
	$linhas = explode("\n", $linhas);
	for($i = 0; $i < count($linhas); $i++){
		if(substr($linhas[$i], 0, 1) == "["){
			if(is_numeric(substr($linhas[$i], 1, 4)) || is_numeric(substr($linhas[$i], 1, 3))) {
				$callgroup = explode('=', $linhas[$i+12]);
				$callgroup = $callgroup[1];
				if(is_numeric(substr($linhas[$i], 1, 4))) $ramal = substr($linhas[$i], 1, 4);
				else $ramal = substr($linhas[$i], 1, 3);
				if(trim($callgroup) != "" && is_numeric(trim($callgroup))) $grupos[$callgroup] .= $ramal.",";
			}
		}
	}
	//return $grupos;
	$saida = array();
	foreach($grupos as $chave => $valor){
		for($i = 0; $i < count($tb_grupos); $i++){
			if($chave == $tb_grupos[$i]['id_asterisk']) {
				$saida[$chave]['id'] = $tb_grupos[$i]['id'];
				$saida[$chave]['nome'] = $tb_grupos[$i]['nome'];
				$saida[$chave]['ramais'] = $valor;
				break;
			}
		}
	}
	return $saida;
  }
  
  function altera_grupo_captura_asterisk($identif, $numero_asterisk, $nome){
	$Pes = "UPDATE vm50_grupos_captura SET id_asterisk = ".$numero_asterisk.", nome = '".$nome."' WHERE id = ".$identif;
	$Res = $this->Bd->executa_query_com_saida($Pes);
	return $Res;
  }
  
  function altera_ramais_grupos_asterisk($grupo, $ramaisP, $ramaisNp){
	$linhas = file_get_contents($this->Dir_conf_aterisk."sip.conf");
	$linhas = explode("\n", $linhas);
	for($i = 0; $i < count($linhas); $i++){
		if(substr($linhas[$i], 0, 1) == "[" && (is_numeric(substr($linhas[$i], 1, 4)) || is_numeric(substr($linhas[$i], 1, 3)))){
			if(is_numeric(substr($linhas[$i], 1, 4))) $ramal = substr($linhas[$i], 1, 4);
			else $ramal = substr($linhas[$i], 1, 3);
			for($j = 0; $j < count($ramaisP); $j++){
				if($ramal == $ramaisP[$j]){
					$linhas[$i+12] = "callgroup=".$grupo;
				}
			}
			for($j = 0; $j < count($ramaisNp); $j++){
				if($ramal == $ramaisNp[$j] && $linha[$i+12] == "callgroup=".$grupo){
					$linhas[$i+12] = "callgroup=";
				}
			}
		}
		$out .= $linhas[$i]."\n";
	}
	unlink($this->Dir_conf_aterisk."sip.conf");
	file_put_contents($this->Dir_conf_aterisk."sip.conf", $out);
	return true;
  }
  
  function deleta_ramais_grupos_asterisk($grupo){
	$linhas = file_get_contents($this->Dir_conf_aterisk."sip.conf");
	$linhas = explode("\n", $linhas);
	for($i = 0; $i < count($linhas); $i++){
		if($linhas[$i] == "callgroup=".$grupo){
			$linhas[$i] = "callgroup=";
		}
		$out .= $linhas[$i]."\n";
	}
	unlink($this->Dir_conf_aterisk."sip.conf");
	file_put_contents($this->Dir_conf_aterisk."sip.conf", $out);
	return true;
  }
  
  function insere_grupo_captura_asterisk($numero_asterisk, $nome){
	$pes = "SELECT id FROM vm50_grupos_captura WHERE id_asterisk = ".$numero_asterisk;
	$res = $this->Bd->executa_query_com_saida($pes);
	if(count($res) == 0){
		$pes = "INSERT INTO vm50_grupos_captura (id_asterisk, nome) VALUES (".$numero_asterisk.", '".$nome."')";
		$res = $this->Bd->executa_query_com_saida($pes);
	}
	return $res;
  }
  
  function apaga_grupo_captura_asterisk($identif){
	$pes = "DELETE FROM vm50_grupos_captura WHERE id = ".$identif;
	return $this->Bd->executa_query_com_saida($pes);
  }
  
  function pesquisa_aplicacoes_relatorio($periodo_d, $periodo_a){
        $sql = "select lastdata from cdr where calldate >= '".$periodo_d." 00:00' and calldate <= '".$periodo_a." 23:59' and lastdata not like 'SIP/%' and lastapp like 'Queue' group by lastdata";
        $res = $this->Cdr->executa_query_com_saida($sql);
        for($i = 0; $i < count($res); $i++){
                if($res[$i]['lastdata'] != ""){
                        $app = explode("|", $res[$i]['lastdata']);
                        $aplicacoes[$app[0]] = $app[0];
                }
        }
        return $aplicacoes;
  }
  
  function gera_bilhetes_aplicacoes($periodo_d, $periodo_a, $app){
        $sql = "SELECT * FROM cdr WHERE calldate >= '".$periodo_d." 00:00' AND calldate <= '".$periodo_a." 23:59' AND lastdata LIKE '".$app."%' AND lastapp = 'Queue' ";
        $sql .= "ORDER BY calldate";
        return $this->Cdr->executa_query_com_saida($sql);
  }
}
?>
