<?php
/**************************************************************
 * Nome:    PBX
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-01-25 (V1.0.1)
 * Descr.:  Gera as variaveis argumento que compoem as telas de
 *          Contact Center.
 *************************************************************/

/**************************************************************
Area dos includes
 *************************************************************/
($_SERVER['DOCUMENT_ROOT'] != "") ? $DirRaiz = $_SERVER['DOCUMENT_ROOT'] . '/vdt/' : $DirRaiz = '/usr/local/apache2/htdocs/vdt/';
include_once $DirRaiz . 'config.php';
include_once $DirRaiz . 'config.pbx.php';
include_once $DirRaiz . 'config.cc.php';
$Modulo = $DirPBX;
include_once $DirRaiz . $DirClass . 'usuario.class.php';
include_once $DirRaiz . $Modulo . $DirClass . 'pbx.class.php';
include_once $DirRaiz . $DirPBX . $DirClass . 'monitor.class.php';
include_once $DirRaiz . $DirCCen . $DirClass . 'agentes.class.php';
//include_once($DirRaiz.$DirModul.'sessao.modu.php');
include_once $DirRaiz . $DirModul . 'geral.modu.php';
include_once $DirRaiz . $DirPBX . $DirModul . 'pbxgeral.modu.php';
include_once $DirRaiz . $DirPBX . $DirRelat . 'bilrelat.modu.php';

/**************************************************************
Nao deixa a pagina ser chamada diretamente. Tem que ter uma
sessao aberta.
 *************************************************************/
//verifica_sessao();

/**************************************************************
Definicao de variaveis
 *************************************************************/
$Pxx = new Pbx; // Objeto PBX
$Usa = new Usuarios; // Objeto Usuarios
$Moni = new Monitor; // Objeto Monitor
$Agen = new Agentes; // Objeto Agentes
$Scr = ''; // Javascript

/**************************************************************
Programa principal
 *************************************************************/
//Javascript
// $Scr = '<script type="text/javascript" src="'.$LinkRaiz.$DirJavas.'geral.js"></script>'."\n";
// $_SESSION['Argumentos']['script'] .= $Scr;
$Scr = '<script type="text/javascript" src="' . $LinkRaiz . $Modulo . $DirJavas . 'pbx.js"></script>' . "\n";
$_SESSION['Argumentos']['script'] .= $Scr;
return;

/**************************************************************
Funcao lista_facili
 *************************************************************/
function lista_facili() {
	global $Pxx;
	$Fac = $Pxx->lista_facilidades();
	$Saida = '';
	//$Saida = '<input type="text" name="total_faci" id="total_faci" value="'.count($Fac).'" />'."\n";
	$Saida .= '<table>' . "\n";
	for ($x = 0; $x < count($Fac); $x++) {
		$i = $Fac[$x]['id'];
		$Saida .= '<tr>';
		$Saida .= '<td>' . $Fac[$x]['facilidade'] . '</td>';
		$Saida .= '<td><input type="text" name="fac_' . sprintf('%09d', $i) . '" id="fac_' . sprintf('%09d', $i) . '" class="texto" style="width:50px;" value="' . $Fac[$x]['valor'] . '" /></td>';
		$Saida .= '<td>' . $Fac[$x]['descricao'] . '</td>';
		$Saida .= '</tr>' . "\n";
	}
	$Saida .= '<table>' . "\n";
	return $Saida;
}

/**************************************************************
Funcao altera_facili
 *************************************************************/
function altera_facili($Dados) {
	global $Pxx;
	$Saida = "";
	$Saida = $Pxx->altera_facilidades($Dados);
	return $Saida;
}

/**************************************************************
Funcao retorna_valor_da_facili
 *************************************************************/
function retorna_valor_da_facili($Dado) {
	global $Pxx;
	$Saida = $Pxx->retorna_valor_da_facilidade($Dado);
	return $Saida;
}

/**************************************************************
Funcao lista_tronco
O tipo pode ser:
href   = saida em <a href...
option = saida em <option...
 *************************************************************/
function lista_tronco($Tipo, $Objeto = '', $Ativo = '') {
	global $Pxx;
	$Tro = $Pxx->lista_troncos($Ativo);
	$Saida = '';
	if ($Tipo == 'href') {
		for ($x = 0; $x < count($Tro); $x++) {
			$i = $Tro[$x]['id'];
			$Saida .= '<a href="#" id="tro_' . sprintf('%09d', $i) . '" onclick="mostra_tronco(' . $i . ')" class="listagem">' . $Tro[$x]['numero_vdt'] . '</a><br/>' . "\n";
			$Saida .= '<input type="hidden" name="nas_' . sprintf('%09d', $i) . '" id="nas_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['numero_asterisk'] . '"/>';
			$Saida .= '<input type="hidden" name="nuv_' . sprintf('%09d', $i) . '" id="nuv_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['numero_vdt'] . '"/>';
			$Saida .= '<input type="hidden" name="des_' . sprintf('%09d', $i) . '" id="des_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['descricao'] . '"/>';
			$Saida .= '<input type="hidden" name="nli_' . sprintf('%09d', $i) . '" id="nli_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['numero_linha'] . '"/>';
			$Saida .= '<input type="hidden" name="ope_' . sprintf('%09d', $i) . '" id="ope_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['operadora'] . '"/>';
			$Saida .= '<input type="hidden" name="sin_' . sprintf('%09d', $i) . '" id="sin_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['sinalizacao'] . '"/>';
			$Saida .= '<input type="hidden" name="pla_' . sprintf('%09d', $i) . '" id="pla_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['placa'] . '"/>';
		}
	} elseif ($Tipo == 'option') {
		for ($x = 0; $x < count($Tro); $x++) {
			$Saida .= '<option value="' . $Tro[$x]['numero_vdt'] . '">&nbsp;&nbsp;' . $Tro[$x]['numero_vdt'] . '&nbsp;&nbsp;</option>';
		}
	} elseif ($Tipo == 'option2') {
		for ($x = 0; $x < count($Tro); $x++) {
			if ($Tro[$x]['feixe'] == "") {
				$Saida .= '<option value="' . $Tro[$x]['numero_vdt'] . '">&nbsp;&nbsp;' . $Tro[$x]['numero_vdt'] . '&nbsp;&nbsp;</option>';
			}

		}
	} elseif ($Tipo == 'option3') {
		for ($x = 0; $x < count($Tro); $x++) {
			if (($Tro[$x]['placa_numero'] == "") && ($Tro[$x]['placa_ordem'] == "")) {
				$Saida .= '<option value="' . $Tro[$x]['numero_vdt'] . '">' . $Tro[$x]['numero_vdt'] . '</option>';
			}

		}
	} elseif ($Tipo == 'javascript') {
		for ($x = 0; $x < count($Tro); $x++) {
			$Saida .= "    o = document.createElement('option');\n\n";
			$Saida .= "    o.text  = '" . $Tro[$x]['numero_vdt'] . "';";
			$Saida .= "    o.value = '" . $Tro[$x]['numero_vdt'] . "';\n";
			$Saida .= "    try { " . $Objeto . ".add(o, null); }\n";
			$Saida .= "    catch (e) { " . $Objeto . ".add(o); }\n\n";
		}
	} elseif ($Tipo == 'javascript2') {
		for ($x = 0; $x < count($Tro); $x++) {
			if ($Tro[$x]['feixe'] == "") {
				$Saida .= "    o = document.createElement('option');\n\n";
				$Saida .= "    o.text  = '" . $Tro[$x]['numero_vdt'] . "';";
				$Saida .= "    o.value = '" . $Tro[$x]['numero_vdt'] . "';\n";
				$Saida .= "    try { " . $Objeto . ".add(o, null); }\n";
				$Saida .= "    catch (e) { " . $Objeto . ".add(o); }\n\n";
			}
		}
	} elseif ($Tipo == 'javascript3') {
		for ($x = 0; $x < count($Tro); $x++) {
			if (($Tro[$x]['placa_numero'] == "") && ($Tro[$x]['placa_ordem'] == "")) {
				$Saida .= "    o = document.createElement('option');\n\n";
				$Saida .= "    o.text  = '" . $Tro[$x]['numero_vdt'] . "';";
				$Saida .= "    o.value = '" . $Tro[$x]['numero_vdt'] . "';\n";
				$Saida .= "    try { " . $Objeto . ".add(o, null); }\n";
				$Saida .= "    catch (e) { " . $Objeto . ".add(o); }\n\n";
			}
		}
	} elseif ($Tipo == "monit") {
		for ($x = 0; $x < count($Tro); $x++) {
			if ($Tro[$x]['nome_feixe'] == "") {
				$Tro[$x]['nome_feixe'] = 'Sem feixe';
			}

			$Saida .= $Tro[$x]['numero_vdt'] . "|" . $Tro[$x]['descricao'] . "|" . $Tro[$x]['numero_asterisk'] . "|" . $Tro[$x]['nome_feixe'] . "|-||";
		}
	}
	return $Saida;
}

function lista_troncos_remotos($Tipo, $Objeto = '', $Ativo = '') {
	global $Pxx;
	$Tro = $Pxx->lista_troncos_remotos($Ativo);
	$Saida = '';
	if ($Tipo == 'href') {
		for ($x = 0; $x < count($Tro); $x++) {
			$i = $Tro[$x]['id'];
			$Saida .= '<a href="#" id="tro_' . sprintf('%09d', $i) . '" onclick="mostra_tronco(' . $i . ')" class="listagem">' . $Tro[$x]['numero_vdt'] . '</a><br/>' . "\n";
			$Saida .= '<input type="hidden" name="nas_' . sprintf('%09d', $i) . '" id="nas_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['numero_asterisk'] . '"/>';
			$Saida .= '<input type="hidden" name="nuv_' . sprintf('%09d', $i) . '" id="nuv_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['numero_vdt'] . '"/>';
			$Saida .= '<input type="hidden" name="des_' . sprintf('%09d', $i) . '" id="des_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['descricao'] . '"/>';
			$Saida .= '<input type="hidden" name="nli_' . sprintf('%09d', $i) . '" id="nli_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['numero_linha'] . '"/>';
			$Saida .= '<input type="hidden" name="ope_' . sprintf('%09d', $i) . '" id="ope_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['operadora'] . '"/>';
			$Saida .= '<input type="hidden" name="sin_' . sprintf('%09d', $i) . '" id="sin_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['sinalizacao'] . '"/>';
			$Saida .= '<input type="hidden" name="pla_' . sprintf('%09d', $i) . '" id="pla_' . sprintf('%09d', $i) . '" value="' . $Tro[$x]['placa'] . '"/>';
		}
	} elseif ($Tipo == 'option') {
		for ($x = 0; $x < count($Tro); $x++) {
			$Saida .= '<option value="' . $Tro[$x]['numero_vdt'] . '">&nbsp;&nbsp;' . $Tro[$x]['numero_vdt'] . '&nbsp;&nbsp;</option>';
		}
	} elseif ($Tipo == 'option2') {
		for ($x = 0; $x < count($Tro); $x++) {
			if ($Tro[$x]['feixe'] == "") {
				$Saida .= '<option value="' . $Tro[$x]['numero_vdt'] . '">&nbsp;&nbsp;' . $Tro[$x]['numero_vdt'] . '&nbsp;&nbsp;</option>';
			}

		}
	} elseif ($Tipo == 'option3') {
		for ($x = 0; $x < count($Tro); $x++) {
			if (($Tro[$x]['placa_numero'] == "") && ($Tro[$x]['placa_ordem'] == "")) {
				$Saida .= '<option value="' . $Tro[$x]['numero_vdt'] . '">' . $Tro[$x]['numero_vdt'] . '</option>';
			}

		}
	} elseif ($Tipo == 'javascript') {
		for ($x = 0; $x < count($Tro); $x++) {
			$Saida .= "    o = document.createElement('option');\n\n";
			$Saida .= "    o.text  = '" . $Tro[$x]['numero_vdt'] . "';";
			$Saida .= "    o.value = '" . $Tro[$x]['numero_vdt'] . "';\n";
			$Saida .= "    try { " . $Objeto . ".add(o, null); }\n";
			$Saida .= "    catch (e) { " . $Objeto . ".add(o); }\n\n";
		}
	} elseif ($Tipo == 'javascript2') {
		for ($x = 0; $x < count($Tro); $x++) {
			if ($Tro[$x]['feixe'] == "") {
				$Saida .= "    o = document.createElement('option');\n\n";
				$Saida .= "    o.text  = '" . $Tro[$x]['numero_vdt'] . "';";
				$Saida .= "    o.value = '" . $Tro[$x]['numero_vdt'] . "';\n";
				$Saida .= "    try { " . $Objeto . ".add(o, null); }\n";
				$Saida .= "    catch (e) { " . $Objeto . ".add(o); }\n\n";
			}
		}
	} elseif ($Tipo == 'javascript3') {
		for ($x = 0; $x < count($Tro); $x++) {
			if (($Tro[$x]['placa_numero'] == "") && ($Tro[$x]['placa_ordem'] == "")) {
				$Saida .= "    o = document.createElement('option');\n\n";
				$Saida .= "    o.text  = '" . $Tro[$x]['numero_vdt'] . "';";
				$Saida .= "    o.value = '" . $Tro[$x]['numero_vdt'] . "';\n";
				$Saida .= "    try { " . $Objeto . ".add(o, null); }\n";
				$Saida .= "    catch (e) { " . $Objeto . ".add(o); }\n\n";
			}
		}
	} elseif ($Tipo == "monit") {
		for ($x = 0; $x < count($Tro); $x++) {
			if ($Tro[$x]['nome_feixe'] == "") {
				$Tro[$x]['nome_feixe'] = 'Sem feixe';
			}

			$Saida .= $Tro[$x]['numero_vdt'] . "|" . $Tro[$x]['descricao'] . "|" . $Tro[$x]['numero_asterisk'] . "|" . $Tro[$x]['nome_feixe'] . "|" . $Tro[$x]['host'] . "||";
		}
	}
	return $Saida;
}

/**************************************************************
Funcao total_troncos
 *************************************************************/
function total_troncos() {
	global $Pxx;
	$Tro = $Pxx->lista_troncos($Ativo);
	$Saida = count($Tro);
	return $Saida;
}

/**************************************************************
Funcao apaga_tronco
 *************************************************************/
function apaga_tronco($Dados) {
	global $Pxx;
	$Saida = "";
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->apaga_troncos($Dados['identif']);
	}

	return $Saida;
}

/**************************************************************
Funcao apaga_troncos_remotos
 *************************************************************/
function apaga_troncos_remotos($Dados) {
	global $Pxx;
	$Saida = "";
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->apaga_troncos_remotos($Dados['identif']);
	}

	return $Saida;
}

/**************************************************************
Funcao altera_tronco
 *************************************************************/
function altera_tronco($Dados) {
	global $Pxx;
	$Saida = "";
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->altera_troncos($Dados['identif'], $Dados["nuas"], $Dados["nuvd"], $Dados["desc"], $Dados["nuli"], $Dados["oper"], $Dados["sina"]);
	}

	return $Saida;
}

/**************************************************************
Funcao altera_tronco
 *************************************************************/
function altera_troncos_remotos($Dados) {
	global $Pxx;
	$Saida = "";
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->altera_troncos_remotos($Dados['identif'], $Dados["nuas"], $Dados["nuvd"], $Dados["desc"], $Dados["nuli"], $Dados["oper"], $Dados["sina"]);
	}

	return $Saida;
}

/**************************************************************
Funcao insere_tronco
 *************************************************************/
function insere_tronco($Dados) {
	global $Pxx;
	$Saida = $Pxx->insere_troncos($Dados["nuas"], $Dados["nuvd"], $Dados["desc"], $Dados["nuli"], $Dados["oper"], $Dados["sina"]);
	return $Saida;
}

/**************************************************************
Funcao insere_tronco
 */
function insere_troncos_remotos($Dados) {
	global $Pxx;
	$Saida = $Pxx->insere_troncos_remotos($Dados["nuas"], $Dados["nuvd"], $Dados["desc"], $Dados["nuli"], $Dados["oper"], $Dados["sina"]);
	return $Saida;
}

/**************************************************************
Funcao lista_feixe
O tipo pode ser:
href   = saida em <a href...
option = saida em <option...
 *************************************************************/
function lista_feixe($Tipo, $Ativo = '') {
	global $Pxx;
	$Aux = $Pxx->lista_feixes($Ativo);
	$Pbb = $Aux[0];
	$Tbb = $Aux[1];
	$Saida = '';
	if ($Tipo == 'href') {
		for ($x = 0; $x < count($Pbb); $x++) {
			$i = $Pbb[$x]['id'];
			$Saida .= '<a href="#" id="fei_' . sprintf('%09d', $i) . '" onclick="mostra_feixe(' . $i . ')" class="listagem">' . $Pbb[$x]['nome'] . '</a><br/>' . "\n";
			$Saida .= '<input type="hidden" name="nom_' . sprintf('%09d', $i) . '" id="nom_' . sprintf('%09d', $i) . '" value="' . $Pbb[$x]['nome'] . '"/>';
			$Saida .= '<input type="hidden" name="pre_' . sprintf('%09d', $i) . '" id="pre_' . sprintf('%09d', $i) . '" value="' . $Pbb[$x]['prefixo'] . '"/>';
			$Saida .= '<input type="hidden" name="tch_' . sprintf('%09d', $i) . '" id="tch_' . sprintf('%09d', $i) . '" value="' . $Pbb[$x]['tronco_chave'] . '"/>';
			$Saida .= '<input type="hidden" name="ham_' . sprintf('%09d', $i) . '" id="ham_' . sprintf('%09d', $i) . '" value="' . $Pbb[$x]['habilita_monitoracao'] . '"/>';
		}
		// Troncos
		$x = 0;
		$Fx = $Tbb[$x]['feixe'];
		$Troncc = "";
		$Fim = count($Tbb);
		while ($x < count($Tbb)) {
			if ($Fx != $Tbb[$x]['feixe']) {
				$Saida .= '<input type="hidden" name="tro_' . sprintf('%09d', $Fx) . '" id="tro_' . sprintf('%09d', $Fx) . '" value="' . $Troncc . '"/>' . "\n";
				$Troncc = "";
			}
			$Troncc .= $Tbb[$x]['numero_vdt'] . ',';
			$Fx = $Tbb[$x]['feixe'];
			$x++;
		}
		$Saida .= '<input type="hidden" name="tro_' . sprintf('%09d', $Fx) . '" id="tro_' . sprintf('%09d', $Fx) . '" value="' . $Troncc . '"/>' . "\n";
		$Troncc = "";
	} elseif ($Tipo == 'option') {
		for ($x = 0; $x < count($Pbb); $x++) {
			$Saida .= '<option value="' . $Pbb[$x]['id'] . '">&nbsp;&nbsp;' . $Pbb[$x]['nome'] . '&nbsp;&nbsp;</option>';
		}
	}
	return $Saida;
}

/**************************************************************
Funcao lista_feixes_remotos
O tipo pode ser:
href   = saida em <a href...
option = saida em <option...
 */
function lista_feixes_remotos($Tipo, $Ativo = '') {
	global $Pxx;
	$Aux = $Pxx->lista_feixes_remotos($Ativo);
	$Pbb = $Aux[0];
	$Tbb = $Aux[1];
	$Saida = '';
	if ($Tipo == 'href') {
		for ($x = 0; $x < count($Pbb); $x++) {
			$i = $Pbb[$x]['id'];
			$Saida .= '<a href="#" id="fei_' . sprintf('%09d', $i) . '" onclick="mostra_feixe(' . $i . ')" class="listagem">' . $Pbb[$x]['nome'] . '</a><br/>' . "\n";
			$Saida .= '<input type="hidden" name="nom_' . sprintf('%09d', $i) . '" id="nom_' . sprintf('%09d', $i) . '" value="' . $Pbb[$x]['nome'] . '"/>';
			$Saida .= '<input type="hidden" name="pre_' . sprintf('%09d', $i) . '" id="pre_' . sprintf('%09d', $i) . '" value="' . $Pbb[$x]['prefixo'] . '"/>';
			$Saida .= '<input type="hidden" name="tch_' . sprintf('%09d', $i) . '" id="tch_' . sprintf('%09d', $i) . '" value="' . $Pbb[$x]['tronco_chave'] . '"/>';
			$Saida .= '<input type="hidden" name="ham_' . sprintf('%09d', $i) . '" id="ham_' . sprintf('%09d', $i) . '" value="' . $Pbb[$x]['habilita_monitoracao'] . '"/>';
			$Saida .= '<input type="hidden" name="hos_' . sprintf('%09d', $i) . '" id="hos_' . sprintf('%09d', $i) . '" value="' . $Pbb[$x]['host'] . '"/>';
		}
		// Troncos
		$x = 0;
		$Fx = $Tbb[$x]['feixe'];
		$Troncc = "";
		$Fim = count($Tbb);
		while ($x < count($Tbb)) {
			if ($Fx != $Tbb[$x]['feixe']) {
				$Saida .= '<input type="hidden" name="tro_' . sprintf('%09d', $Fx) . '" id="tro_' . sprintf('%09d', $Fx) . '" value="' . $Troncc . '"/>' . "\n";
				$Troncc = "";
			}
			$Troncc .= $Tbb[$x]['numero_vdt'] . ',';
			$Fx = $Tbb[$x]['feixe'];
			$x++;
		}
		$Saida .= '<input type="hidden" name="tro_' . sprintf('%09d', $Fx) . '" id="tro_' . sprintf('%09d', $Fx) . '" value="' . $Troncc . '"/>' . "\n";
		$Troncc = "";
	} elseif ($Tipo == 'option') {
		for ($x = 0; $x < count($Pbb); $x++) {
			$Saida .= '<option value="' . $Pbb[$x]['id'] . '">&nbsp;&nbsp;' . $Pbb[$x]['nome'] . '&nbsp;&nbsp;</option>';
		}
	}
	return $Saida;
}

/**************************************************************
Funcao altera_feixe
 *************************************************************/
function altera_feixe($Dados) {
	global $Pxx;
	$Saida = true;
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->altera_feixes($Dados['identif'], $Dados['nomef'], $Dados['prefi'], $Dados['tronc'], $Dados['hamo']);
		if ($Dados['tronr']) {
			$Troncos = $Dados['tronr'];
		} else {
			$Troncos = "";
		}

		$Retorno = $Pxx->altera_troncos_feixes($Dados['identif'], $Dados['tronr']);
		if (!$Retorno) {
			$Saida = false;
		}

	}
	return $Saida;
}

/**************************************************************
Funcao altera_feixes_remotos
 */
function altera_feixes_remotos($Dados) {
	global $Pxx;
	$Saida = true;
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->altera_feixes_remotos($Dados['identif'], $Dados['nomef'], $Dados['prefi'], $Dados['tronc'], $Dados['hamo'], $Dados['host']);
		if ($Dados['tronr']) {
			$Troncos = $Dados['tronr'];
		} else {
			$Troncos = "";
		}

		$Retorno = $Pxx->altera_troncos_feixes_remotos($Dados['identif'], $Dados['tronr']);
		if (!$Retorno) {
			$Saida = false;
		}

	}
	return $Saida;
}

/**************************************************************
Funcao insere_feixe
 *************************************************************/
function insere_feixe($Dados) {
	global $Pxx;
	$Saida = true;
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Identif = $Pxx->insere_feixes($Dados['nomef'], $Dados['prefi'], $Dados['tronc'], $Dados['hamo']);
		if ($Saida) {
			$Troncos = $Dados['tronr'];
			$Retorno = $Pxx->altera_troncos_feixes($Identif, $Troncos);
			if (!$Retorno) {
				$Saida = false;
			}

		}
	}
	return $Saida;
}

/**************************************************************
Funcao insere_feixes_remotos
 */
function insere_feixes_remotos($Dados) {
	global $Pxx;
	$Saida = true;
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Identif = $Pxx->insere_feixes_remotos($Dados['nomef'], $Dados['prefi'], $Dados['tronc'], $Dados['hamo']);
		if ($Saida) {
			$Troncos = $Dados['tronr'];
			$Retorno = $Pxx->altera_troncos_feixes_remotos($Identif, $Troncos);
			if (!$Retorno) {
				$Saida = false;
			}

		}
	}
	return $Saida;
}

/**************************************************************
Funcao apaga_feixe
 *************************************************************/
function apaga_feixe($Dados) {
	global $Pxx;
	$Saida = "";
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->apaga_feixes($Dados['identif']);
	}

	return $Saida;
}

/**************************************************************
Funcao apaga_feixe
 */
function apaga_feixes_remotos($Dados) {
	global $Pxx;
	$Saida = "";
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->apaga_feixes_remotos($Dados['identif']);
	}

	return $Saida;
}

/**************************************************************
Funcao lista_orbita
 *************************************************************/
function lista_orbita() {
	global $Moni, $Pxx, $Usa;
	$Moni->abrir_conexao_ami();
	$Orb = $Moni->le_estado_orbitas_ami();
	$Moni->fechar_conexao_ami();
	$Saida = "";
	for ($i = count($Orb); $i > 0; $i--) {
		$linha = $Orb[$i];
		$Number = explode("@", $linha);
		if ($Number[0] > 700 && $Number[0] <= 720) {
			$Status = explode("State:", $linha);
			$Orbs[$i - 4]['Numero'] = $Number[0];
			$Orbs[$i - 4]['Status'] = substr($Status[1], 0, 6);
			$Saida .= '<div class=';
			if (trim($Orbs[$i - 4]['Status']) == "Idle") {
				$Saida .= '"luzorbitliv"';
				$Pxx->retirar_orbita(trim($Orbs[$i - 4]['Numero']));
			} else {
				$DadosO = $Pxx->lista_orbita(trim($Orbs[$i - 4]['Numero']));
				$Numme = $DadosO[0]['mesa'];
				$CorOr = $Usa->cor_por_mesa($Numme);
				$Saida .= '"luzorbitocu" style="background-color:#' . $CorOr . '; border-color:#' . $CorOr . ';"';
				//$Ajuda = $Orbs[$i-4]['Numero']." <- ".$Num[0]['numero'];
				//$Saida.= ' onMouseover="ajuda(event,\'L\',\''.$Ajuda.'\');" onMouseout="ajuda(event,\'D\',\'\');"';
				$Saida .= ' onClick="GTSIPPhoneObj.MakeCall(\'0\', ' . $Orbs[$i - 4]['Numero'] . ', \'\');"';
			}
			$Saida .= ' id="orbita_' . sprintf('%02d', ($Orbs[$i - 4]['Numero'] - 700)) . '">rbita ' . sprintf('%02d', ($Orbs[$i - 4]['Numero'] - 700)) . '</div>';
		}
	}
	return $Saida;
}

/**************************************************************
Funcao lista_placa
O tipo pode ser:
href   = saida em <a href...
option = saida em <option...
 *************************************************************/
function lista_placa($Tipo, $Ativo = '') {
	global $Pxx;
	$Aux = $Pxx->lista_placas($Ativo);
	$Pla = $Aux[0];
	$Tbb = $Aux[1];
	$Saida = '';
	if ($Tipo == 'href') {
		for ($x = 0; $x < count($Pla); $x++) {
			$i = $Pla[$x]['id'];
			$Saida .= '<a href="#" id="pla_' . sprintf('%09d', $i) . '" onclick="mostra_placa(' . $i . ')" class="listagem">' . $Pla[$x]['numero'] . '</a><br/>' . "\n";
			$Saida .= '<input type="hidden" name="pln_' . sprintf('%09d', $i) . '" id="pln_' . sprintf('%09d', $i) . '" value="' . $Pla[$x]['numero'] . '"/>';
			$Saida .= '<input type="hidden" name="fab_' . sprintf('%09d', $i) . '" id="fab_' . sprintf('%09d', $i) . '" value="' . $Pla[$x]['fabricante'] . '"/>';
			$Saida .= '<input type="hidden" name="mod_' . sprintf('%09d', $i) . '" id="mod_' . sprintf('%09d', $i) . '" value="' . $Pla[$x]['modelo'] . '"/>';
		}
		// Troncos
		$x = 0;
		$Fx = $Tbb[$x]['placa_numero'];
		$Troncc = "";
		$Fim = count($Tbb);
		while ($x < count($Tbb)) {
			if ($Fx != $Tbb[$x]['placa_numero']) {
				$Saida .= '<input type="hidden" name="tro_' . sprintf('%09d', $Fx) . '" id="tro_' . sprintf('%09d', $Fx) . '" value="' . $Troncc . '"/>' . "\n";
				$Troncc = "";
			}
			$Troncc .= sprintf('%03d', $Tbb[$x]['placa_ordem']) . ' - ' . $Tbb[$x]['numero_vdt'] . ',';
			$Fx = $Tbb[$x]['placa_numero'];
			$x++;
		}
		$Saida .= '<input type="hidden" name="tro_' . sprintf('%09d', $Fx) . '" id="tro_' . sprintf('%09d', $Fx) . '" value="' . $Troncc . '"/>' . "\n";
		$Troncc = "";
	} elseif ($Tipo == 'option') {
		for ($x = 0; $x < count($Pla); $x++) {
			$i = $Pla[$x]['id'];
			$Saida .= '<option value="' . $Pla[$x]['numero'] . '">' . $Pla[$x]['numero'] . '</option>';
		}
	}
	return $Saida;
}

/**************************************************************
Funcao altera_placa
 *************************************************************/
function altera_placa($Dados) {
	global $Pxx;
	$Saida = true;
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->altera_placas($Dados['identif'], $Dados['nupl'], $Dados['fabr'], $Dados['mode']);
		if ($Dados['tronr']) {
			$Troncos = $Dados['tronr'];
		} else {
			$Troncos = "";
		}

		$Retorno = $Pxx->altera_troncos_placas($Dados['nupl'], $Dados['tronr']);
		if (!$Retorno) {
			$Saida = false;
		}

	}
	return $Saida;
}

/**************************************************************
Funcao insere_placa
 *************************************************************/
function insere_placa($Dados) {
	global $Pxx;
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->insere_placas($Dados['nupl'], $Dados['fabr'], $Dados['mode']);
		if ($Saida) {
			$Troncos = $Dados['tronr'];
			$Retorno = $Pxx->altera_troncos_placas($Dados['nupl'], $Troncos);
			$Naosei .= $Retorno;
			if (!$Retorno) {
				$Saida = false;
			}

		}
	}
	return $Saida;
}

/**************************************************************
Funcao apaga_placa
 *************************************************************/
function apaga_placa($Dados) {
	global $Pxx;
	$Saida = "";
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->apaga_placas($Dados['identif']);
	}

	return $Saida;
}

/**************************************************************
Funcao lista_ramal
O tipo pode ser:
href   = saida em <a href...
option = saida em <option...
 *************************************************************/
function lista_ramal($Tipo, $Objeto = '', $Ativo = '', $Grupesc = '', $Usuar = '') {
	global $Pxx, $Usa, $PesquisaStatusRamais, $Agen;
	$tmr = $PesquisaStatusRamais; //Pega o tipo de monitoramento de ramais de acordo com o cadastrado no config.php
	//$tmr = 0;
	$Ram = $Pxx->lista_ramais($Ativo);
        
	if ($Usuar != '') {
		$DadosUsu = $Usa->lista_usuarios_por_id($Usuar);
		$tipoPainel = $DadosUsu[0]['labelramal'];
	} else {
		$tipoPainel = 0;
	}
	//return $tipoPainel;
	if ($tmr == 1) {
		$EstadoRamais = monitora_ramais_ami();
	} else if ($tmr == 2) {
		$EstadoRamais = monitora_ramais_astman();
	}

	//return $EstadoRamais;
	$Saida = '';
	if ($Tipo == 'href') {
		for ($x = 0; $x < count($Ram); $x++) {
			$i = $Ram[$x]['id'];
			$AgenteRamal = $Agen->consulta_agente_do_ramal($i);
			$RamR = $Pxx->pesquisa_ramais_relacionados_por_id($i);
			$RamaisRelacionados = "";
			for ($c = 0; $c < count($RamR); $c++) {
				$RamaisRelacionados .= $RamR[$c]['id'] . '|' . $RamR[$c]['ramal'] . " - " . $RamR[$c]['nomecomplet'] . "||";
			}
			$Saida .= '<a href="#" id="ram_' . sprintf('%09d', $i) . '" onclick="mostra_ramal(' . $i . ')" class="listagem">' . $Ram[$x]['ramal'] . '</a><br/>' . "\n";
			$Saida .= '<input type="hidden" name="edr_' . sprintf('%09d', $i) . '" id="edr_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['endereco'] . '"/>';
			$Saida .= '<input type="hidden" name="nom_' . sprintf('%09d', $i) . '" id="nom_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['nomecomplet'] . '"/>';
			$Saida .= '<input type="hidden" name="pse_' . sprintf('%09d', $i) . '" id="pse_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['pseudonimo'] . '"/>';
			$Saida .= '<input type="hidden" name="can_' . sprintf('%09d', $i) . '" id="can_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['canal'] . '"/>';
			$Saida .= '<input type="hidden" name="dsp_' . sprintf('%09d', $i) . '" id="dsp_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['dispositivo'] . '"/>';
			$Saida .= '<input type="hidden" name="fbr_' . sprintf('%09d', $i) . '" id="fbr_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['fabricante'] . '"/>';
			$Saida .= '<input type="hidden" name="mdl_' . sprintf('%09d', $i) . '" id="mdl_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['modelo'] . '"/>';
			$Saida .= '<input type="hidden" name="hst_' . sprintf('%09d', $i) . '" id="hst_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['host'] . '"/>';
			$Saida .= '<input type="hidden" name="tpo_' . sprintf('%09d', $i) . '" id="tpo_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['tipo'] . '"/>';
			$Saida .= '<input type="hidden" name="cli_' . sprintf('%09d', $i) . '" id="cli_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['call_limit'] . '"/>';
			$Saida .= '<input type="hidden" name="cgr_' . sprintf('%09d', $i) . '" id="cgr_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['callgroup'] . '"/>';
			$Saida .= '<input type="hidden" name="cid_' . sprintf('%09d', $i) . '" id="cid_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['callerid'] . '"/>';
			$Saida .= '<input type="hidden" name="ctx_' . sprintf('%09d', $i) . '" id="ctx_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['contexto'] . '"/>';
			$Saida .= '<input type="hidden" name="dtm_' . sprintf('%09d', $i) . '" id="dtm_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['dtmfmode'] . '"/>';
			$Saida .= '<input type="hidden" name="pgr_' . sprintf('%09d', $i) . '" id="pgr_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['pickupgroup'] . '"/>';
			$Saida .= '<input type="hidden" name="sen_' . sprintf('%09d', $i) . '" id="sen_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['senha'] . '"/>';
			$Saida .= '<input type="hidden" name="usr_' . sprintf('%09d', $i) . '" id="usr_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['username'] . '"/>';
			$Saida .= '<input type="hidden" name="nst_' . sprintf('%09d', $i) . '" id="nst_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['numeroaster'] . '"/>';
			$Saida .= '<input type="hidden" name="rpa_' . sprintf('%09d', $i) . '" id="rpa_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['ramal_pa'] . '"/>';
			$Saida .= '<input type="hidden" name="naa_' . sprintf('%09d', $i) . '" id="naa_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['nat'] . '"/>';
			$Saida .= '<input type="hidden" name="ras_' . sprintf('%09d', $i) . '" id="ras_' . sprintf('%09d', $i) . '" value="' . $AgenteRamal[0]['id'] . '#' . $AgenteRamal[0]['login'] . ' - ' . $AgenteRamal[0]['pseudonimo'] . '"/>';
			$Saida .= '<input type="hidden" name="rar_' . sprintf('%09d', $i) . '" id="rar_' . sprintf('%09d', $i) . '" value="' . $RamaisRelacionados . '"/>';
			$Saida .= '<input type="hidden" name="vma_' . sprintf('%09d', $i) . '" id="vma_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['mailbox'] . '"/>';
			$Saida .= '<input type="hidden" name="qua_' . sprintf('%09d', $i) . '" id="qua_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['qualify'] . '"/>';
			$Saida .= '<input type="hidden" name="cbl_' . sprintf('%09d', $i) . '" id="cbl_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['subscribecontext'] . '"/>';
			$Saida .= '<input type="hidden" name="den_' . sprintf('%09d', $i) . '" id="den_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['denny'] . '"/>';
			$Saida .= '<input type="hidden" name="per_' . sprintf('%09d', $i) . '" id="per_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['permit'] . '"/>';
			$Saida .= '<input type="hidden" name="car_' . sprintf('%09d', $i) . '" id="car_' . sprintf('%09d', $i) . '" value="' . $Ram[$x]['can_reinvite'] . '"/>';
		}
	} elseif ($Tipo == 'option') {
		for ($x = 0; $x < count($Ram); $x++) {
			$i = $Ram[$x]['id'];
			$Saida .= '<option value="' . $Ram[$x]['ramal'] . '">' . $Ram[$x]['ramal'] . '</option>';
		}
	} elseif ($Tipo == 'option2') {
		for ($x = 0; $x < count($Ram); $x++) {
			if (trim($Objeto) == trim($Ram[$x]['ramal'])) {
				$Saida .= '<option value="' . $Ram[$x]['ramal'] . '">' . $Ram[$x]['ramal'] . '</option>';
			}

		}
	} elseif ($Tipo == 'option3') {
		for ($x = 0; $x < count($Ram); $x++) {
			if ($Ram[$x]['grupo'] == "") {
				$Saida .= '<option value="' . $Ram[$x]['ramal'] . '">' . $Ram[$x]['ramal'] . '</option>';
			}

		}
	} elseif ($Tipo == 'option4') {
		$Ram = $Pxx->lista_ramais_pa($Ativo);
		for ($x = 0; $x < count($Ram); $x++) {
			$i = $Ram[$x]['id'];
			$Saida .= '<option value="' . $Ram[$x]['ramal'] . '">' . $Ram[$x]['ramal'] . '</option>';
		}
	} elseif ($Tipo == 'javascript') {
		for ($x = 0; $x < count($Ram); $x++) {
			//if ($Ram[$x]['grupo'] == "") {
				$Saida .= "    o = document.createElement('option');\n\n";
				$Saida .= "    o.text  = '" . $Ram[$x]['ramal'] . "';";
				$Saida .= "    o.value = '" . $Ram[$x]['ramal'] . "';\n";
				$Saida .= "    try { " . $Objeto . ".add(o, null); }\n";
				$Saida .= "    catch (e) { " . $Objeto . ".add(o); }\n\n";
			//}
		}
	} elseif ($Tipo == "lista") {
		for ($x = 0; $x < count($Ram); $x++) {
			$i = $Ram[$x]['id'];
			$AgenteRamal = $Agen->consulta_agente_do_ramal($i);
			if (count($AgenteRamal) > 0) {
				$Saida .= trim($Ram[$x]['ramal']) . "#" . trim($AgenteRamal[0]['login']) . "##";
			}
		}
	} elseif ($Tipo == "lista2") {
		for ($x = 0; $x < count($Ram); $x++) {
			$grupoRam = $Pxx->pesquisa_grupo_pelo_id($Ram[$x]['grupo']);
			if (is_array($grupoRam) > 0) {
				$Grupo = $grupoRam[0]['nome'];
				$idGrupo = $grupoRam[0]['id'];
			} else {
				$Grupo = "-";
				$idGrupo = "-";
			}
			$Saida .= trim($Ram[$x]["ramal"]) . "#" . $Ram[$x]["pseudonimo"] . "#" . $Grupo . "#" . $idGrupo . "##";
			$grupoRam = $Pxx->pesquisa_ramal_perso($Usuar, $Ram[$x]['ramal']);
			if (count($grupoRam) > 0) {
				$Saida .= trim($Ram[$x]["ramal"]) . "#" . $Ram[$x]["pseudonimo"] . "#Meu grupo#-1##";
			}

		}
	} elseif ($Tipo == 'tabela') {
		if (substr($Grupesc, 0, 1) == 'p') {
			$Usuar = substr($Grupesc, 1);
			$Per = $Usa->lista_grupos_persona($Usuar);
		}
		for ($x = 0; $x < count($Ram); $x++) {
			$Vai = false;
			if (($Grupesc != "") && ($Grupesc == $Ram[$x]['grupo'])) {
				$Vai = true;
			} elseif ($Grupesc == "") {
				$Vai = true;
			}

			if (substr($Grupesc, 0, 1) == "p") {
				$Achei = false;
				$y = 0;
				while (!$Achei) {
					if ($Ram[$x]['ramal'] == $Per[$y]['ramal']) {
						$Vai = true;
						$Achei = true;
					} else {
						$y++;
						if ($y >= count($Per)) {
							$Achei = true;
						}

					}
				}
			}
			if ($Vai) {
				$Saida .= '<div id="ram_' . $Ram[$x]['ramal'] . '"';
				if ($tipoPainel == 0) {
					$Ajuda = $Ram[$x]['pseudonimo'];
				} else if ($tipoPainel == 1) {
					$Ajuda = $Ram[$x]['ramal'];
				}

				if ($Ram[$x]['direcao'] == "I") {
					$Ajuda .= "<-";
				} elseif ($Ram[$x]['direcao'] == "O") {
					$Ajuda .= "->";
				} elseif ($Ram[$x]['situacao'] == 'O') {
					$Ajuda .= "-Fora do gancho";
				} else {
					$Ajuda .= " ";
				}

				$Ajuda .= $Ram[$x]['falandocom'];
				if ($tmr == 1 || $tmr == 2) {
					$Status = $EstadoRamais['ramal'][$Ram[$x]['ramal']]['status'];
					if ($Status == "-1" || $Status == "4") {
						$Saida .= ' class="luzramalnre"';
					} elseif ($Status == "0") {
						$Saida .= ' class="luzramalliv"';
					} elseif ($Status == "1" || $Status == "2") {
						$Saida .= ' class="luzramalocu"';
					} elseif ($Status == "8") {
						$Saida .= ' class="luzramalcha"';
					}

				} else {
					if ($Ram[$x]['situacao'] == 'U') {
						$Saida .= ' class="luzramalnre"';
					} elseif ($Ram[$x]['situacao'] == 'L') {
						$Saida .= ' class="luzramalliv"';
					} elseif ($Ram[$x]['situacao'] == 'O') {
						$Saida .= ' class="luzramalocu"';
					} elseif ($Ram[$x]['situacao'] == 'C') {
						$Saida .= ' class="luzramalcha"';
					}

				}
				if ($tipoPainel == 0) {
					$Saida .= ' onMouseover="ajuda(event,\'L\',\'' . $Ajuda . '\');" onMouseout="ajuda(event,\'D\',\'\');" onClick="disca_numero(\'' . trim($Ram[$x]['ramal']) . '\');" >' . $Ram[$x]['ramal'] . '</div>' . "\n";
				}

				if ($tipoPainel == 1) {
					(strlen($Ram[$x]['pseudonimo']) > 8) ? $pseu = substr($Ram[$x]['pseudonimo'], 0, 5) . "..." : $pseu = $Ram[$x]['pseudonimo'];
					$Saida .= ' onMouseover="ajuda(event,\'L\',\'' . $Ajuda . '\');" onMouseout="ajuda(event,\'D\',\'\');" onClick="disca_numero(\'' . trim($Ram[$x]['ramal']) . '\');" >' . $pseu . '</div>' . "\n";
				}
			}
		}
	} else if ($Tipo == "array") {
		$Saida = $Ram;
	}
	return $Saida;
}

/**************************************************************
Funcao total_ramais
 *************************************************************/
function total_ramais() {
	global $Pxx;
	$Ram = $Pxx->lista_ramais($Ativo);
	$Saida = count($Ram);
	return $Saida;
}

/**************************************************************
Funcao apaga_ramal
 *************************************************************/
function apaga_ramal($Dados) {
	global $Pxx, $Agen;
	$Saida = "";
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->apaga_ramais($Dados['identif']);
	}

	$Saida = $Pxx->apaga_ramais_sip_conf($Dados['rama']);
	$Agen->reload_asterisk();
	return $Saida;
}

/**************************************************************
Funcao altera_ramal
 *************************************************************/
function altera_ramal($Dados) {
	global $Pxx, $Agen;
	$Saida = "";
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->altera_ramais($Dados['identif'], $Dados['nome'], $Dados['pseu'], $Dados['cana'], $Dados['disp'], $Dados['fabr'], $Dados['mode'], $Dados['host'], $Dados['tipo'], $Dados['ntif'], $Dados['cntx'], $Dados['senh'], $Dados['usua'], $Dados['lcha'], $Dados['gcap'], $Dados['mdtm'], $Dados['cgru'], $Dados['nast'], $Dados['ramalpa']);
	}

	if ($Saida) {
		$iden = trim($Dados['identif']);
		$iden = intval($iden);
		if ($Dados['rass'] != "") {
			$Saida = $Agen->inserir_agente_ramal($Dados['rass'], $iden);
		} else {
			$Saida = $Agen->deletar_agente_ramal($iden);
		}

	}
	$Saida = insere_ramais_relacionados($Dados['identif'], $Dados['ramrr']);
	return $Saida;
}

function altera_ramal_asterisk($Dados) {
	global $Pxx, $Agen;
	$Saida = "";
	if ($Dados['canr'] == "0") {
		$Dados['canr'] = "false";
	} else {
		$Dados['canr'] = "true";
	}

	if ($Dados['nat'] == "0") {
		$Dados['nat'] = "false";
	} else {
		$Dados['nat'] = "true";
	}

	if ($Dados['qual'] == "0") {
		$Dados['qual'] = "false";
	} else {
		$Dados['qual'] = "true";
	}

    if($Dados['nots'] == "0") $Dados['nots'] = "false";
    else $Dados['nots'] = "true";

	$ver = $Pxx->verifica_ramal_sip_conf($Dados['rama']);

	if ($Dados["identif"] == "") {
		$Saida = $Pxx->insere_ramais_asterisk($Dados['nome'], $Dados['pseu'], $Dados['rama'], $Dados['senh'], $Dados['cntx'], $Dados['lcha'], $Dados['vmai'], $Dados['canr'], $Dados['host'], $Dados['mdtm'], $Dados['nat'], $Dados['qual'], $Dados['tipo'], $Dados['gcap'], $Dados['cgru'], $Dados['cblf'], $Dados['denn'], $Dados['perm'], $Dados['nots']);
	} else {
		$Saida = $Pxx->altera_ramais_asterisk($Dados['identif'], $Dados['nome'], $Dados['pseu'], $Dados['rama'], $Dados['senh'], $Dados['cntx'], $Dados['lcha'], $Dados['vmai'], $Dados['canr'], $Dados['host'], $Dados['mdtm'], $Dados['nat'], $Dados['qual'], $Dados['tipo'], $Dados['gcap'], $Dados['cgru'], $Dados['cblf'], $Dados['denn'], $Dados['perm'], $Dados['nots']);
	}

	if ($ver) {
		$Saida = $Pxx->altera_ramais_sip_conf($Dados['identif'], $Dados['nome'], $Dados['pseu'], $Dados['rama'], $Dados['senh'], $Dados['cntx'], $Dados['lcha'], $Dados['vmai'], $Dados['canr'], $Dados['host'], $Dados['mdtm'], $Dados['nat'], $Dados['qual'], $Dados['tipo'], $Dados['gcap'], $Dados['cgru'], $Dados['cblf'], $Dados['denn'], $Dados['perm']);
	} else {
		$Saida = $Pxx->insere_ramais_sip_conf($Dados['nome'], $Dados['pseu'], $Dados['rama'], $Dados['senh'], $Dados['cntx'], $Dados['lcha'], $Dados['vmai'], $Dados['canr'], $Dados['host'], $Dados['mdtm'], $Dados['nat'], $Dados['qual'], $Dados['tipo'], $Dados['gcap'], $Dados['cgru'], $Dados['cblf'], $Dados['denn'], $Dados['perm']);
	}

	$iden = trim($Dados['identif']);
	$iden = intval($iden);
	if ($Dados['rass'] != "") {
		$Saida = $Agen->inserir_agente_ramal($Dados['rass'], $iden);
	} else {
		$Saida = $Agen->deletar_agente_ramal($iden);
	}

	$Agen->reload_asterisk();
	return $Saida;
}

/**************************************************************
Funcao insere_ramais_relacionados
 */
function insere_ramais_relacionados($idPai, $ramais) {
	Global $Pxx;
	if (!$idPai) {
		return false;
	}

	$idPai = intval($idPai);
	$Del = $Pxx->deletar_ramais_relacionados_por_id($idPai);
	for ($i = 0; $i < count($ramais); $i++) {
		$Pxx->inserir_ramal_relacionado($idPai, $ramais[$i]);
	}
	return true;
}

/**************************************************************
Funcao insere_ramal
 *************************************************************/
function insere_ramal($Dados) {
	global $Pxx;
	$Saida = $Pxx->insere_ramais($Dados['rama'], $Dados['nome'], $Dados['pseu'], $Dados['cana'], $Dados['disp'], $Dados['fabr'], $Dados['mode'], $Dados['host'], $Dados['tipo'], $Dados['ntif'], $Dados['cntx'], $Dados['senh'], $Dados['usua'], $Dados['lcha'], $Dados['gcap'], $Dados['mdtm'], $Dados['cgru'], $Dados['nast'], $Dados['ramalpa']);
	return $Saida;
}

/**************************************************************
Funcao insere_ramal_asterisk
 *************************************************************/
function insere_ramal_asterisk($Dados) {
	global $Pxx, $Agen;
	if ($Dados['canr'] == "0") {
		$Dados['canr'] = "false";
	} else {
		$Dados['canr'] = "true";
	}

	if ($Dados['nat'] == "0") {
		$Dados['nat'] = "false";
	} else {
		$Dados['nat'] = "true";
	}

	if ($Dados['qual'] == "0") {
		$Dados['qual'] = "false";
	} else {
		$Dados['qual'] = "true";
	}

    if($Dados['nots'] == "0") $Dados['nots'] = "false";
    else $Dados['nots'] = "true";

	$Saida = $Pxx->insere_ramais_asterisk($Dados['nome'], $Dados['pseu'], $Dados['rama'], $Dados['senh'], $Dados['cntx'], $Dados['lcha'], $Dados['vmai'], $Dados['canr'], $Dados['host'], $Dados['mdtm'], $Dados['nat'], $Dados['qual'], $Dados['tipo'], $Dados['gcap'], $Dados['cgru'], $Dados['cblf'], $Dados['denn'], $Dados['perm'], $Dados['nots']);
	if (!$Saida) {
		return false;
	}

	$Saida = $Pxx->insere_ramais_sip_conf($Dados['nome'], $Dados['pseu'], $Dados['rama'], $Dados['senh'], $Dados['cntx'], $Dados['lcha'], $Dados['vmai'], $Dados['canr'], $Dados['host'], $Dados['mdtm'], $Dados['nat'], $Dados['qual'], $Dados['tipo'], $Dados['gcap'], $Dados['cgru'], $Dados['cblf'], $Dados['denn'], $Dados['perm']);
	$Agen->reload_asterisk();
	return $Saida;
}

/**************************************************************
Funcao lista_grupo_ramal
O tipo pode ser:
href   = saida em <a href...
option = saida em <option...
 *************************************************************/
function lista_grupo_ramal($Tipo, $Ativo = '') {
	global $Pxx;
	$Aux = $Pxx->lista_grupo_ramais($Ativo);
	$Gru = $Aux[0];
	$Ram = $Aux[1];
	$Saida = '';
	if ($Tipo == 'href') {
		for ($x = 0; $x < count($Gru); $x++) {
			$i = $Gru[$x]['id'];
			$Saida .= '<a href="#" id="gru_' . sprintf('%09d', $i) . '" onclick="mostra_grupo_ramal(' . $i . ')" class="listagem">' . $Gru[$x]['nome'] . '</a><br/>' . "\n";
		}
		// Ramais
		$x = 0;
		$Rm = $Ram[$x]['grupo'];
		$Rml = "";
		while ($x < count($Ram)) {
			if ($Rm != $Ram[$x]['grupo']) {
				$Saida .= '<input type="hidden" name="ram_' . sprintf('%09d', $Rm) . '" id="ram_' . sprintf('%09d', $Rm) . '" value="' . $Rml . '"/>' . "\n";
				$Rml = "";
			}
			$Rml .= $Ram[$x]['ramal'] . ',';
			$Rm = $Ram[$x]['grupo'];
			$x++;
		}
		$Saida .= '<input type="hidden" name="ram_' . sprintf('%09d', $Rm) . '" id="ram_' . sprintf('%09d', $Rm) . '" value="' . $Rml . '"/>' . "\n";
		$Rm = "";
	} elseif ($Tipo == 'option') {
		for ($x = 0; $x < count($Gru); $x++) {
			$i = $Gru[$x]['id'];
			$Saida .= '<option value="' . $Gru[$x]['nome'] . '">' . $Gru[$x]['nome'] . '</option>';
		}
	}
	return $Saida;
}

/**************************************************************
Funcao apaga_grupo_ramal
 *************************************************************/
function apaga_grupo_ramal($Dados) {
	global $Pxx;
	$Saida = "";
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->apaga_grupo_ramais($Dados['identif']);
	}

	return $Saida;
}

/**************************************************************
Funcao altera_grupo_ramal
 *************************************************************/
function altera_grupo_ramal($Dados) {
	global $Pxx;
	$Saida = print_r($Dados, true);
	if (!isset($Dados['identif'])) {
		$Saida = false;
	} else {
		$Saida = $Pxx->altera_grupo_ramais($Dados['identif'], $Dados['nome']);
//return $Saida;
		if ($Saida) {
			$Ramais = $Dados['ramalr'];
			$Retorno = $Pxx->altera_ramais_grupos($Dados['identif'], $Ramais);
			if (!$Retorno) {
				$Saida = false;
			}

		}
	}
	return $Retorno;
}

/**************************************************************
Funcao insere_grupo_ramal
 *************************************************************/
function insere_grupo_ramal($Dados) {
	global $Pxx;
	$Saida = true;
	$Identif = $Pxx->insere_grupo_ramais($Dados['nome']);
	if ($Identif) {
		$Ramais = $Dados['ramalr'];
		$Retorno = $Pxx->altera_ramais_grupos($Identif, $Ramais);
		if (!$Retorno) {
			$Saida = false;
		}

	}
	return $Saida;
}
/**************************************************************
Funcao gera_tela_bilhete
 ***************************************************************/
function gera_tela_bilhete($Dados, $LRamal) {
	global $Pxx;
	$Saida = '';
	$Tipo = '';
	$Ramais = $LRamal;
	$DataInicio = $Dados["inicio"];
	$DataFim = $Dados["fim"];
	$Interno = $Dados["int"];
	$Externo = $Dados["ext"];
	$Entrada = $Dados["ent"];
	$filtroNumero = $Dados["filtroNumero"];
	$dataServidor = strtotime(date("d-m-Y"));
	$Imprime = '';

	list($Dia, $Mes, $Ano) = explode('/', $DataInicio);
	$dataIni = $Ano . "-" . $Mes . "-" . $Dia;
	$dataModificadaIni = strtotime($dataIni);

	list($Dia, $Mes, $Ano) = explode('/', $DataFim);
	$dataFim = $Ano . "-" . $Mes . "-" . $Dia;
	$dataModificadaFim = strtotime($dataFim);
	$Arquivo = cria_arquivo_excel('bilhetagem.xls');
	if (count($LRamal) <= 0) {
		$Saida .= '<br /><p align="center" class="reltit">Selecione ao menos um ramal !!!</p>';
	} else {
		for ($i = 0; $i < count($LRamal); $i++) {
			if ($DataInicio == '' && $DataFim == '') {
				$Saida .= '<br /><p align="center" class="reltit">Selecione por favor a data de in?io !!!</p>';
			} elseif ($DataInicio == '' && $DataFim != '') {
				$Saida .= '<br /><p align="center" class="reltit">Opera?o n? permitida !!!<br />A data de In?io deve ser selecionada!!!</p>';
			} elseif ($DataInicio != '' && $DataFim == '') {
				if (trim($filtroNumero) != "") {
					$Query = "calldate like '" . $dataIni . "%' AND ((src LIKE '" . trim($LRamal[$i]) . "' AND dst LIKE '%" . trim($filtroNumero) . "%') OR (src LIKE '%" . trim($filtroNumero) . "%' AND dst LIKE '" . trim($LRamal[$i]) . "')) ORDER BY calldate";
				} else {
					$Query = "calldate like '" . $dataIni . "%' AND (src LIKE '" . trim($LRamal[$i]) . "' OR dst LIKE '" . trim($LRamal[$i]) . "') ORDER BY calldate";
				}

			} else {
				if (trim($filtroNumero) != "") {
					$Query = "calldate >= '" . $dataIni . " 00:00' AND calldate <= '" . $dataFim . " 23:59' AND ((src LIKE '" . trim($LRamal[$i]) . "' AND dst LIKE '%" . trim($filtroNumero) . "%') OR (src LIKE '%" . trim($filtroNumero) . "%' AND dst LIKE '" . trim($LRamal[$i]) . "')) ORDER BY calldate";
				} else {
					$Query = "calldate >= '" . $dataIni . " 00:00' AND calldate <= '" . $dataFim . " 23:59' AND (src LIKE '" . trim($LRamal[$i]) . "' OR dst LIKE '" . trim($LRamal[$i]) . "') ORDER BY calldate";
				}

			}

			if ($Query) {
				$Identif = $Pxx->gera_tela_bilhetes($Dados, $Query);
			}
			$html = relatorio_todas_ligacoes($Identif, $LRamal[$i]);
			$xls = relatorio_todas_ligacoes($Identif, $LRamal[$i], 'xls');
			$Saida .= $html;
			if ($Arquivo) {
				fwrite($Arquivo, $xls);
				fecha_arquivo_excel($Arquivo);
			}
			;
		}
	}
	$Imprime = '';
	return $Saida;
}

function monitora_ramais_ami() {
	global $Moni, $Pxx;
	$Ramais = $Pxx->lista_ramais();
	$Moni->abrir_conexao_ami();
	for ($i = 0; $i < count($Ramais); $i++) {
		$Resultado = $Moni->le_estado_ramais_ami($Ramais[$i]['ramal'], $Ramais[$i]['contexto']);
		$Status = substr($Resultado[5], 7, 2);
		$Status = (int) $Status;
		$Saida['ramal'][$Ramais[$i]['ramal']]['status'] = $Status;
	}
	$Moni->fechar_conexao_ami();
	return $Saida;
}

function monitora_ramais_astman() {
	global $Moni, $Pxx;
	$Ramais = $Pxx->lista_ramais();
	for ($i = 0; $i < count($Ramais); $i++) {
		$Resultado = $Moni->le_estado_ramais_astman($Ramais[$i]['ramal'], $Ramais[$i]['contexto']);
		if ($Resultado[0] == "Response: Success" && $Resultado[1] == "Message: Extension Status") {
			//return $Resultado[5];
			$Status = substr($Resultado[5], 7, 2);
			$Status = (int) $Status;
			$Saida['ramal'][$Ramais[$i]['ramal']]['status'] = $Status;
		}
	}
	return $Saida;
}

function testa_tronco($ramal, $contexto) {
	global $Moni;
	$Moni->abrir_conexao_ami();
	$Resultado = $Moni->le_estado_ramais_ami($ramal, $contexto);
	$Moni->fechar_conexao_ami();
	return $Resultado;
}

/*************************************************************
Funcao:     insere_grupo_tronco
 *************************************************************/
function insere_grupo_tronco($dados) {
	global $Pxx;
	$saida = 0;
	if (!isset($dados["identif"])) {
		$saida = false;
	} else {
		$identificador = $Pxx->insere_grupo_troncos($dados["grupo"], $dados["descricaoGrupo"]);
		if ($identificador != "GRUPO_CADASTRADO") {
			$insereTronco = $Pxx->atualiza_tronco_grupo($identificador, $dados["troncoSelecionado"]);
			$saida = "CADASTRADO_SUCESSO";
		} else {
			$saida = $identificador;
		}
	}
	return $saida;
}

function entrar_pausa($ramal, $fila) {
	global $Pxx;
	$saida = "";
	$saida = $Pxx->entrar_pausa($ramal, $fila);
	return $saida;
}

function sair_pausa($ramal, $fila) {
	global $Pxx;
	$saida = "";
	$saida = $Pxx->sair_pausa($ramal, $fila);
	return $saida;
}

function entrar_filas($Usuario) {
	global $Usa, $Pxx;
	$dadosUsu = $Usa->lista_usuarios_por_id($Usuario);
	$verificaAusente = $Pxx->lista_luzes_ramal($dadosUsu[0]['ramal']);
	if ($verificaAusente["ausente"] == 0) {
		$Filas = $Usa->lista_usuarios_filas_por_id($Usuario);
		foreach ($Filas as $fila) {
			return $Pxx->entrar_fila($dadosUsu[0]['ramal'], $fila['fila']);
		}
	}
	return false;
}

function lista_agentes_associados($tipo = "option") {
	global $Pxx, $Agen;
	$agentesTotal = $Agen->lista_agentes();
	$agentesUsados = $Agen->lista_agentes_ramais();

	for ($i = 0; $i < count($agentesTotal[0]); $i++) {
		$agentes[$i]['id'] = $agentesTotal[0][$i]['id'];
		$agentes[$i]['login'] = $agentesTotal[0][$i]['login'];
		$agentes[$i]['pseudonimo'] = $agentesTotal[0][$i]['pseudonimo'];
	}

	if (count($agentesUsados) == 0) {
		foreach ($agentes as $agente) {
			$Saida .= '<option value="' . $agente['id'] . '">' . $agente['login'] . ' - ' . $agente['pseudonimo'] . '</option>';
		}
	} else {
		$jafoi = false;
		$Saida = "";
		foreach ($agentes as $agente) {
			$jafoi = false;
			foreach ($agentesUsados as $agenteU) {
				if ($agente['login'] == $agenteU['login']) {
					$jafoi = true;
				}
			}

			if (!$jafoi) {
				if ($tipo == "option") {
					$Saida .= '<option value="' . $agente['id'] . '">' . $agente['login'] . ' - ' . $agente['pseudonimo'] . '</option>';
				}
			}

		}
	}

	return $Saida;
}

function lista_auxiliares_filas() {
	global $Pxx;
	$dados = $Pxx->lista_auxiliares_filas();
	$aux_filas = array();
	//trata os dados vindos do BD
	foreach ($dados as $dado) {
		foreach ($dado as $chaveA => $valorA) {
			if ($chaveA == "fila") {
				$aux_filas[$valorA] .= trim($dado["ramal"]) . "|";
			}

		}
	}
	//cria os campos hidden
	$Saida = "";
	foreach ($aux_filas as $fila => $ramais) {
		$Saida .= '<input type="hidden" id="' . $fila . '" name="' . $fila . '" value="' . $ramais . '"/>' . "\n";
	}
	return $Saida;
}

function altera_ramais_auxiliares($dados) {
	global $Pxx;
	//return print_r($dados, true);
	for ($i = 0; $i < count($dados["ramaisr"]); $i++) {
		$ramal = $Pxx->lista_dado_ramal_por_ramal($dados["ramaisr"][$i]);
		if (!$Pxx->inserir_ramais_auxiliares($dados["identif"], $ramal[0]["id"])) {
			return false;
		}

	}
	for ($i = 0; $i < count($dados["ramaisl"]); $i++) {
		$ramal = $Pxx->lista_dado_ramal_por_ramal($dados["ramaisl"][$i]);
		if (!$Pxx->remover_ramais_auxiliares($dados["identif"], $ramal[0]["id"])) {
			return false;
		}

	}
	return true;
}

function lista_auxiliares_filas_por_id_usuario($Usuario) {
	global $Usa, $Pxx;
	$Filas = $Usa->lista_usuarios_filas_por_id($Usuario);
	foreach ($Filas as $fila) {
		$Auxiliares = $Pxx->lista_auxiliares_filas_por_fila($fila["nome_fila"]);
		if (count($Auxiliares) == 0 || $Auxiliares == "") {
			return "";
		}

		foreach ($Auxiliares as $auxilio) {
			$Saida .= trim($auxilio["ramal"]) . "|" . $auxilio["fila"] . "||";
		}
	}
	return $Saida;
}

function lista_ramais_mesa_e_fila() {
	global $Usa;
	$Usuarios = $Usa->lista_usuarios();
	foreach ($Usuarios as $usuario) {
		if ($usuario['tipo'] == "ME") {
			$Filas = $Usa->lista_usuarios_filas_por_id($usuario['id']);
			if (count($Filas) == 0 || $Filas == "") {
				return "";
			}

			foreach ($Filas as $fila) {
				$Saida .= $usuario['ramal'] . "|" . $fila["nome_fila"] . "||";
			}
		}
	}
	return $Saida;
}

function lista_fha_filas_por_id_usuario($Usuario) {
	global $Usa, $Pxx;
	$Filas = $Usa->lista_usuarios_filas_por_id($Usuario);
	foreach ($Filas as $fila) {
		$Auxiliares = $Pxx->lista_fha_filas_por_fila($fila["nome_fila"]);
		if (count($Auxiliares) == 0 || $Auxiliares == "") {
			return "";
		}

		foreach ($Auxiliares as $auxilio) {
			$Saida .= trim($auxilio["ramal"]) . "|" . $auxilio["fila"] . "||";
		}
	}
	return $Saida;
}

function lista_fha_filas() {
	global $Pxx;
	$dados = $Pxx->lista_fha_filas();
	$aux_filas = array();
	//trata os dados vindos do BD
	foreach ($dados as $dado) {
		foreach ($dado as $chaveA => $valorA) {
			if ($chaveA == "fila") {
				$aux_filas[$valorA] .= trim($dado["ramal"]) . "|";
			}

		}
	}
	//cria os campos hidden
	$Saida = "";
	foreach ($aux_filas as $fila => $ramais) {
		$Saida .= '<input type="hidden" id="' . $fila . '" name="' . $fila . '" value="' . $ramais . '"/>' . "\n";
	}
	return $Saida;
}

function altera_ramais_fha($dados) {
	global $Pxx;
	//return print_r($dados, true);
	for ($i = 0; $i < count($dados["ramaisr"]); $i++) {
		$ramal = $Pxx->lista_dado_ramal_por_ramal($dados["ramaisr"][$i]);
		if (!$Pxx->inserir_ramais_fha($dados["identif"], $ramal[0]["id"])) {
			return false;
		}

	}
	for ($i = 0; $i < count($dados["ramaisl"]); $i++) {
		$ramal = $Pxx->lista_dado_ramal_por_ramal($dados["ramaisl"][$i]);
		if (!$Pxx->remover_ramais_fha($dados["identif"], $ramal[0]["id"])) {
			return false;
		}

	}
	return true;
}

function lista_ramais_monit_mesa($grupo, $ramais, $contexto, $tipoLabel) {
	global $Moni, $Pxx;
	$dadosRamais = explode("##", $ramais);
	$Moni->abrir_conexao_ami();
	foreach ($dadosRamais as $dadosRamal) {
		$dados = explode("#", $dadosRamal);
		if ($dados[0] == "" || ($dados[3] == "-1" && $grupo == "")) {
			continue;
		}

		if ($grupo == "") {
			$Ajuda = "";
			$Resultado = $Moni->le_estado_ramais_ami($dados[0], $contexto);
			/*$dadosInfoRamal = le_informacoes_ramais_ami($dados[0]);
				$Ajuda_info_ramal = 'IP: '.$dadosInfoRamal["Address-IP"];
				$Ajuda_info_ramal .= "<br/>Contexto: ".$dadosInfoRamal["Context"];
				$Ajuda_info_ramal .= "<br/>Terminal: ".$dadosInfoRamal["SIP-Useragent"];
				$Ajuda_info_ramal .= "<br/>Caller ID: ".$dadosInfoRamal["Callerid"];
				$Ajuda_info_ramal .= "<br/>Status: ".$dadosInfoRamal["Status"];
			*/
			$Ajuda_info_ramal = "";
			$Status = substr($Resultado[5], 7, 2);
			$Status = (int) $Status;
			$Saida .= '<div id="ram_' . $dados[0] . '"';
			if ($Status == "-1" || $Status == "4") {
				$Saida .= ' class="luzramalnre"';
				$Ajuda = ' onMouseover="ajuda(event,\'L\',\'' . $Ajuda_info_ramal . '\',\'8\');" onMouseout="ajuda(event,\'D\',\'\');"';
				//$Saida .= $Ajuda;
			} elseif ($Status == "0") {
				$Saida .= ' class="luzramalliv"';
				$Ajuda = ' onMouseover="ajuda(event,\'L\',\'' . $Ajuda_info_ramal . '\',\'8\');" onMouseout="ajuda(event,\'D\',\'\');"';
				//$Saida .= $Ajuda;
			} elseif ($Status == "1" || $Status == "2") {
				$Saida .= ' class="luzramalocu"';
				$Ajuda_aux = $Pxx->falando_com($dados[0]);
				$Ajuda_aux = "Falando com: " . $Ajuda_aux[0]['falandocom'];
				$Ajuda_aux .= "</br></br>" . $Ajuda_info_ramal;
				$Ajuda = ' onMouseover="ajuda(event,\'L\',\'' . $Ajuda_aux . '\',\'8\');" onMouseout="ajuda(event,\'D\',\'\');"';
				$Saida .= $Ajuda;
			} elseif ($Status == "8") {
				$Saida .= ' class="luzramalcha"';
				$Ajuda_aux = $Pxx->falando_com($dados[0]);
				$Ajuda_aux = "Chamando: " . $Ajuda_aux[0]['falandocom'];
				$Ajuda_aux .= "</br></br>" . $Ajuda_info_ramal;
				$Ajuda = ' onMouseover="ajuda(event,\'L\',\'' . $Ajuda_aux . '\');" onMouseout="ajuda(event,\'D\',\'\');"';
				$Saida .= $Ajuda;
			}

			if ($tipoLabel == 0) {
				$Saida .= ' onClick="disca_numero(\'' . trim($dados[0]) . '\');" >' . $dados[0] . '</div>' . "\n";
			}

			if ($tipoLabel == 1) {
				(strlen($dados[1]) > 8) ? $pseu = substr($dados[1], 0, 5) . "..." : $pseu = $dados[1];
				$Saida .= ' onClick="disca_numero(\'' . trim($dados[0]) . '\');" style="width:90px;" >' . $dados[0] . '-' . $pseu . '</div>' . "\n";
			}
		} else {
			if ($grupo == $dados[3]) {
				$Resultado = $Moni->le_estado_ramais_ami($dados[0], $contexto);
				/*$dadosInfoRamal = le_informacoes_ramais_ami($dados[0]);
					$Ajuda_info_ramal = 'IP: '.$dadosInfoRamal["Address-IP"];
					$Ajuda_info_ramal .= "<br/>Contexto: ".$dadosInfoRamal["Context"];
					$Ajuda_info_ramal .= "<br/>Terminal: ".$dadosInfoRamal["SIP-Useragent"];
					$Ajuda_info_ramal .= "<br/>Caller ID: ".$dadosInfoRamal["Callerid"];
					$Ajuda_info_ramal .= "<br/>Status: ".$dadosInfoRamal["Status"];
				*/
				$Status = substr($Resultado[5], 7, 2);
				$Status = (int) $Status;

				$Saida .= '<div id="ram_' . $dados[0] . '"';
				if ($Status == "-1" || $Status == "4") {
					$Saida .= ' class="luzramalnre"';
					$Ajuda = ' onMouseover="ajuda(event,\'L\',\'' . $Ajuda_info_ramal . '\',\'8\');" onMouseout="ajuda(event,\'D\',\'\');"';
					//$Saida .= $Ajuda;
				} elseif ($Status == "0") {
					$Saida .= ' class="luzramalliv"';
					$Ajuda = ' onMouseover="ajuda(event,\'L\',\'' . $Ajuda_info_ramal . '\',\'8\');" onMouseout="ajuda(event,\'D\',\'\');"';
					//$Saida .= $Ajuda;
				} elseif ($Status == "1" || $Status == "2") {
					$Saida .= ' class="luzramalocu"';
					$Ajuda_aux = $Pxx->falando_com($dados[0]);
					$Ajuda_aux = "Falando com: " . $Ajuda_aux[0]['falandocom'];
					$Ajuda_aux .= "</br></br>" . $Ajuda_info_ramal;
					$Ajuda = ' onMouseover="ajuda(event,\'L\',\'' . $Ajuda_aux . '\',\'8\');" onMouseout="ajuda(event,\'D\',\'\');"';
					$Saida .= $Ajuda;
				} elseif ($Status == "8") {
					$Saida .= ' class="luzramalcha"';
					$Ajuda_aux = $Pxx->falando_com($dados[0]);
					$Ajuda_aux = "Chamando: " . $Ajuda_aux[0]['falandocom'];
					$Ajuda_aux .= "</br></br>" . $Ajuda_info_ramal;
					$Ajuda = ' onMouseover="ajuda(event,\'L\',\'' . $Ajuda_aux . '\');" onMouseout="ajuda(event,\'D\',\'\');"';
					$Saida .= $Ajuda;
				}
				if ($tipoLabel == 0) {
					$Saida .= ' onClick="disca_numero(\'' . trim($dados[0]) . '\');" >' . $dados[0] . '</div>' . "\n";
				}

				if ($tipoLabel == 1) {
					(strlen($dados[1]) > 8) ? $pseu = substr($dados[1], 0, 5) . "..." : $pseu = $dados[1];
					$Saida .= ' onClick="disca_numero(\'' . trim($dados[0]) . '\');" style="width:90px;" >' . $dados[0] . '-' . $pseu . '</div>' . "\n";
				}
			}
		}
	}
	$Moni->fechar_conexao_ami();
	//return $SaidaAux;
	return $Saida;
}

function lista_chamadas_espera($Fila) {
	global $Moni;
	$Moni = new Monitor;
	$Moni->abrir_conexao_ami();
	$DadosChamadas = $Moni->le_chamadas_espera($Fila);
	$Moni->fechar_conexao_ami();
	//return print_r($DadosChamadas, true);
	$Saida = array();
	if (count($DadosChamadas) >= 6) {
		$Chamadas = explode(":", $DadosChamadas[6]);
		$Chamadas[1] = trim($Chamadas[1]);
		//return $Chamadas[1];
		if ($Chamadas[1] > 0) {
			//return print_r($DadosChamadas);
			for ($j = 0; $j < count($DadosChamadas); $j++) {
				if ($DadosChamadas[$j] == "Event: QueueEntry\r\n") {
					$Queue = $Fila;
					$Position = explode(":", $DadosChamadas[$j + 2]);
					$Position = trim($Position[1]);
					$Channel = explode(":", $DadosChamadas[$j + 3]);
					$Channel = trim($Channel[1]);
					$CallerID = explode(":", $DadosChamadas[$j + 4]);
					$CallerID = trim($CallerID[1]);
					$CallerIDName = explode(":", $DadosChamadas[$j + 5]);
					$CallerIDName = trim($CallerIDName[1]);
					$Wait = explode(":", $DadosChamadas[$j + 6]);
					$Wait = trim($Wait[1]);

					$Saida[$Position]['numero_dest'] = $Queue;
					$Saida[$Position]['numero_orig'] = $CallerID;
					$Saida[$Position]['hora'] = $Wait;

				}
			}
		}
	}
	return $Saida;
}

function lista_chamadas_espera_todas() {
	global $Moni;
	$Moni = new Monitor;
	$Moni->abrir_conexao_ami();
	$DadosChamadas = $Moni->le_chamadas_espera_todas();
	$Moni->fechar_conexao_ami();
	$saida = array();
	for ($i = 0; $i < count($DadosChamadas); $i++) {
		if ($DadosChamadas[$i] == "" || strpos($DadosChamadas[$i], ':') === false) {
			continue;
		}

		list($chave, $valor) = explode(": ", $DadosChamadas[$i]);
		if (trim($valor) == "QueueParams") {
			list($tmp, $fila) = explode(": ", $DadosChamadas[$i + 1]);
			$fila = str_replace("\r\n", "", $fila);
			list($tmp, $qtdLigacoes) = explode(": ", $DadosChamadas[$i + 3]);
			$qtdLigacoes = str_replace("\r\n", "", $qtdLigacoes);
			$saida[$fila]["quantidade"] = $qtdLigacoes;
		}
		if (trim($valor) == "QueueEntry") {
			list($tmp, $fila) = explode(": ", $DadosChamadas[$i + 1]);
			$fila = str_replace("\r\n", "", $fila);
			list($tmp, $position) = explode(": ", $DadosChamadas[$i + 2]);
			$position = str_replace("\r\n", "", $position);
			$position = trim($position);
			list($tmp, $channel) = explode(": ", $DadosChamadas[$i + 3]);
			$channel = str_replace("\r\n", "", $channel);
			$channel = trim($channel);
			list($tmp, $callerId) = explode(": ", $DadosChamadas[$i + 4]);
			$callerId = str_replace("\r\n", "", $callerId);
			$callerId = trim($callerId);
			list($tmp, $callerIdName) = explode(": ", $DadosChamadas[$i + 5]);
			$callerIdName = str_replace("\r\n", "", $callerIdName);
			$callerIdName = trim($callerIdName);
			list($tmp, $wait) = explode(": ", $DadosChamadas[$i + 6]);
			$wait = str_replace("\r\n", "", $wait);
			$wait = trim($wait);

			$aux[$position]['numero_dest'] = $fila;
			$aux[$position]['numero_orig'] = $callerId;
			$aux[$position]['hora'] = $wait;

			$saida[$fila]["detalhes"] = $aux;
		}
	}
	return $saida;
}

function lista_ramais_nao_relacionados($tipo) {
	Global $Pxx;
	$Saida = "";
	$RamaisRelacionados = $Pxx->pesquisa_ramais_relacionados();
	$Ramais = $Pxx->lista_ramais();
	$relacionado = false;

	if ($tipo == "option") {
		for ($i = 0; $i < count($Ramais); $i++) {
			$relacionado = false;
			$SaidaTST .= 'Id: ' . $Ramais[$i]['id'];
			for ($j = 0; $j < count($RamaisRelacionados); $j++) {
				$SaidaTST .= ' Ramal: ' . $RamaisRelacionados[$j]['id'] . "</br>";
				if ($RamaisRelacionados[$j]['id'] == $Ramais[$i]['id']) {
					$relacionado = true;
					break;
				}
			}
			if ($relacionado == false) {
				$Saida .= '<option value="' . $Ramais[$i]['id'] . '">' . $Ramais[$i]['ramal'] . ' - ' . $Ramais[$i]['nomecomplet'] . '</option>';
			}

		}
	}
	return $Saida;
}

function lista_extensoes($tipo) {
	Global $Pxx;
	$Saida = "";
	$extensoes = $Pxx->pesquisa_extensoes();

	if ($tipo == "href") {
		for ($i = 0; $i < count($extensoes); $i++) {
			$id = $extensoes[$i]['id'];
			$Saida .= '<a href="#" id="ext_' . sprintf('%09d', $id) . '" onclick="mostra_extensao(' . $id . ')" class="listagem">' . $extensoes[$i]['nome'] . '</a><br/>' . "\n";
			//Campos
			$Saida .= '<input type="hidden" name="nome_' . sprintf('%09d', $id) . '" id="nome_' . sprintf('%09d', $id) . '" value="' . $extensoes[$i]["nome"] . '"/>' . "\n";
			$Saida .= '<input type="hidden" name="codigo_' . sprintf('%09d', $id) . '" id="codigo_' . sprintf('%09d', $id) . '" value="' . $extensoes[$i]["codigo"] . '"/>' . "\n";
		}
	}

	return $Saida;
}

function altera_extensoes($dados) {
	Global $Pxx;
	$altera = $Pxx->altera_extensoes($dados["identif"], $dados["nome"], $dados["codigo"]);
	return $altera;
}

function inclui_extensao($dados) {
	Global $Pxx;
	$inclui = $Pxx->inclui_extensao($dados["nome"], $dados["codigo"]);
	return $inclui;
}

function deleta_extensao($dados) {
	Global $Pxx;
	$inclui = $Pxx->deleta_extensao($dados["identif"]);
	return $inclui;
}

function logar_ramal_pbx($agente, $ramal) {
	Global $Agen;
	$agente = $Agen->carrega_agente_por_login($agente);
	return $Agen->logar_pa($agente[0]['login'], $agente[0]['senha'], trim($ramal));
}

function deslogar_ramal_pbx($agente) {
	Global $Agen;
	return $Agen->logoff($agente);
}

function lista_pausa_pbx($Tipo, $Ativo = '') {
	global $Agen;
	$Paus = $Agen->lista_pausas($Ativo);
	if ($Tipo == 'option3') {
		if ($Ativo != '') {
			for ($x = 0; $x < count($Paus); $x++) {
				if ($Paus[$x]['habilitaparapa'] == 't') {
					$Saida .= '<option value="' . $Paus[$x]['nome'] . '"';
					$Saida .= '>' . $Paus[$x]['nome'] . '</option>';
				}
			}
		} else {
			for ($x = 0; $x < count($Paus); $x++) {
				$Saida .= '<option value="' . $Paus[$x]['nome'] . '"';
				$Saida .= '>' . $Paus[$x]['nome'] . '</option>';
			}
		}
	}
	return $Saida;
}

function pausar_ramal_pbx($agente, $tipo) {
	Global $Agen;
	return $Agen->pausar($agente, $tipo);
}

function despausar_ramal_pbx($agente) {
	Global $Agen;
	return $Agen->despausar($agente);
}

function conversando_com_pelo_ramal($ramal) {
	Global $Agen;
	$agente = $Agen->descobre_agente_pelo_ramal($ramal);
	$dados = $Agen->estado_agentes($agente[0]['login']);
	$dados[] = $agente[0]['login'];
	return $dados;
}

function le_informacoes_ramais_ami($ramal) {
	Global $Moni;
	$dados = $Moni->le_informacoes_ramais_ami($ramal);
	$count = count($dados);

	for ($i = 0; $i < $count; $i++) {
		if (trim($dados[$i]) != "") {
			$dadosAux = explode(": ", $dados[$i]);
			$dadosAux[1] = preg_replace('/[^A-Za-z0-9.\-]/', '', $dadosAux[1]);
			$dadosSai[trim($dadosAux[0])] = $dadosAux[1];
		}
	}
	return $dadosSai;
}

function lista_ramal_sip_conf($Tipo) {
	Global $Pxx, $Agen;
	$Ram = $Pxx->lista_ramal_sip_conf();
	if ($Tipo == "href") {
		for ($x = 0; $x < count($Ram); $x++) {
			$dados = $Pxx->busca_ramal_pelo_ramal($Ram[$x]['ramal']);
			$i = $dados[0]['id'];
			$AgenteRamal = $Agen->consulta_agente_do_ramal($i);

            $canR = ($Ram[$x]['canreinvite']=='no') ? 0 : 1;
            $quaL = ($Ram[$x]['qualify']=='no') ? 0 : 1;

			$Saida .= '<a href="#" id="ram_' . sprintf('%09d', $x) . '" onclick="mostra_ramal(' . $x . ')" class="listagem">' . $Ram[$x]['ramal'] . '</a><br/>' . "\n";
			$Saida .= '<input type="hidden" name="ide_' . sprintf('%09d', $x) . '" id="ide_' . sprintf('%09d', $x) . '" value="' . $i . '"/>';
			$Saida .= '<input type="hidden" name="nom_' . sprintf('%09d', $x) . '" id="nom_' . sprintf('%09d', $x) . '" value="' . $dados[0]['nomecomplet'] . '"/>';
			$Saida .= '<input type="hidden" name="pse_' . sprintf('%09d', $x) . '" id="pse_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['callerid'] . '"/>';
			$Saida .= '<input type="hidden" name="hst_' . sprintf('%09d', $x) . '" id="hst_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['host'] . '"/>';
			$Saida .= '<input type="hidden" name="tpo_' . sprintf('%09d', $x) . '" id="tpo_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['type'] . '"/>';
			$Saida .= '<input type="hidden" name="cli_' . sprintf('%09d', $x) . '" id="cli_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['call-limit'] . '"/>';
			$Saida .= '<input type="hidden" name="cgr_' . sprintf('%09d', $x) . '" id="cgr_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['callgroup'] . '"/>';
			$Saida .= '<input type="hidden" name="ctx_' . sprintf('%09d', $x) . '" id="ctx_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['context'] . '"/>';
			$Saida .= '<input type="hidden" name="dtm_' . sprintf('%09d', $x) . '" id="dtm_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['dtmfmode'] . '"/>';
			$Saida .= '<input type="hidden" name="pgr_' . sprintf('%09d', $x) . '" id="pgr_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['pickupgroup'] . '"/>';
			$Saida .= '<input type="hidden" name="sen_' . sprintf('%09d', $x) . '" id="sen_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['secret'] . '"/>';
			$Saida .= '<input type="hidden" name="naa_' . sprintf('%09d', $x) . '" id="naa_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['nat'] . '"/>';
			$Saida .= '<input type="hidden" name="vma_' . sprintf('%09d', $x) . '" id="vma_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['mailbox'] . '"/>';
			$Saida .= '<input type="hidden" name="qua_' . sprintf('%09d', $x) . '" id="qua_' . sprintf('%09d', $x) . '" value="' . $quaL . '"/>';
			$Saida .= '<input type="hidden" name="cbl_' . sprintf('%09d', $x) . '" id="cbl_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['subscribecontext'] . '"/>';
			$Saida .= '<input type="hidden" name="den_' . sprintf('%09d', $x) . '" id="den_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['deny'] . '"/>';
			$Saida .= '<input type="hidden" name="per_' . sprintf('%09d', $x) . '" id="per_' . sprintf('%09d', $x) . '" value="' . $Ram[$x]['permit'] . '"/>';
			$Saida .= '<input type="hidden" name="car_' . sprintf('%09d', $x) . '" id="car_' . sprintf('%09d', $x) . '" value="' . $canR . '"/>';
			$Saida .= '<input type="hidden" name="ras_' . sprintf('%09d', $x) . '" id="ras_' . sprintf('%09d', $x) . '" value="' . $AgenteRamal[0]['id'] . '#' . $AgenteRamal[0]['login'] . ' - ' . $AgenteRamal[0]['pseudonimo'] . '"/>';
            $Saida .= '<input type="hidden" name="nos_' . sprintf('%09d', $x) . '" id="nos_' . sprintf('%09d', $x) . '" value="' . $dados[0]['notificarsyonet'] . '"/>';
		}
	} else if ($Tipo == "lista") {
		for ($x = 0; $x < count($Ram); $x++) {
			$Saida .= $Ram[$x]['ramal'] . "|" . $Ram[$x]['callerid'] . "||";
		}
	} else if ($Tipo == "option") {
		for ($x = 0; $x < count($Ram); $x++) {
			$Saida .= '<option value="' . $Ram[$x]['ramal'] . '">' . $Ram[$x]['ramal'] . "-" . $Ram[$x]['callerid'] . '</option>';
		}
	} else if ($Tipo == "array") {
		return $Ram;
	}
	return $Saida;
}

function lista_grupos_sip_conf($tipo) {
	Global $Pxx;
	$gru = $Pxx->lista_grupos_sip_conf();
	$saida = "";
	foreach ($gru as $chave => $valor) {
		$saida .= '<a href="#" id="gru_' . sprintf('%09d', $chave) . '" onclick="mostra_grupo_captura(' . $chave . ')" class="listagem">' . $valor['nome'] . '</a><br/>' . "\n";
		$saida .= '<input type="hidden" name="id_' . sprintf('%09d', $chave) . '" id="id_' . sprintf('%09d', $chave) . '" value="' . $valor['id'] . '"/>';
		$saida .= '<input type="hidden" name="nom_' . sprintf('%09d', $chave) . '" id="nom_' . sprintf('%09d', $chave) . '" value="' . $valor['nome'] . '"/>';
		$saida .= '<input type="hidden" name="ida_' . sprintf('%09d', $chave) . '" id="ida_' . sprintf('%09d', $chave) . '" value="' . $chave . '"/>';
		$saida .= '<input type="hidden" name="ram_' . sprintf('%09d', $chave) . '" id="ram_' . sprintf('%09d', $chave) . '" value="' . $valor['ramais'] . '"/>';
	}
	return $saida;
}

function altera_grupo_captura_asterisk($Dados) {
	global $Pxx, $Agen;
	$Saida = "";
	if ($Dados['identif'] == "") {
		return;
	}

	$Saida = $Pxx->altera_grupo_captura_asterisk($Dados['identif'], $Dados['numero_asterisk'], $Dados['nome']);
	$Saida = $Pxx->altera_ramais_grupos_asterisk($Dados['numero_asterisk'], $Dados['ramalr'], $Dados['ramall']);
	$Agen->reload_asterisk();
	return $Saida;
}

function insere_grupo_captura_asterisk($Dados) {
	global $Pxx, $Agen;
	$Saida = "";
	$Saida = $Pxx->insere_grupo_captura_asterisk($Dados['numero_asterisk'], $Dados['nome']);
	$Saida = $Pxx->altera_ramais_grupos_asterisk($Dados['numero_asterisk'], $Dados['ramalr'], $Dados['ramall']);
	$Agen->reload_asterisk();
	return $Saida;
}

function apaga_grupo_captura_asterisk($Dados) {
	global $Pxx, $Agen;
	$Saida = "";
	$Saida = $Pxx->apaga_grupo_captura_asterisk($Dados['identif']);
	$Saida = $Pxx->deleta_ramais_grupos_asterisk($Dados['numero_asterisk']);
	$Agen->reload_asterisk();
	return $Saida;
}

function listar_context_sip_conf($tipo) {
	global $Pxx;
	$ramais = $Pxx->lista_ramal_sip_conf();
	$saida = '';
	$contextos = array();
	if ($tipo == "option") {
		$saida = '<option value="">&nbsp;</option>';
		foreach ($ramais as $chave => $valor) {
			$contextos[$valor['context']] = $valor['context'];
		}
		foreach ($contextos as $chave => $valor) {
			if (trim($valor) != '') {
				$saida .= '<option value="' . $valor . '">' . $valor . '</option>';
			}

		}
	}
	return $saida;
}
?>
