<?php
//error_reporting(E_ALL);
//ini_set('display_errors', 1);
/**************************************************************
* Nome:    PbxMoni
* Autor:   Renato N. Loureno
* Data:	  2008-01-25 (V1.0.0)
* Descr.:  Verifica o status do pbx
*************************************************************/

/**************************************************************
Cabecalho para nao fazer cache
*************************************************************/
header('Cache-Control: no-cache, must-revalidate');
header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');

/**************************************************************
Area dos includes
*************************************************************/
// Setup include path.
ini_set(
    'include_path',
    implode(
        PATH_SEPARATOR,
        array(
            implode(DIRECTORY_SEPARATOR, array('..', '..', 'libs', 'PAMI')),
            '../../libs/log4php', '../../libs/',
            ini_get('include_path')
        )
    )
);
$DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
include_once($DirRaiz.'config.php');
include_once($DirRaiz.'config.pbx.php');
include_once($DirRaiz.$DirModul.'geral.modu.php');
$Modulo = $DirPBX;
include_once($DirRaiz.$DirPBX.$DirClass.'pbx.class.php');
include_once($DirRaiz.$Modulo.$DirModul.'pbx.modu.php');
include('../../libs/log4php/Logger.php');


/**************************************************************
Definicao de variaveis
*************************************************************/
$L_var = $_POST;          // Recebe as variaveis do formulario
$Monitor  = new Monitor;        // Objeto Monitor
$Pbx  = new Pbx;        // Objeto Monitor

/**************************************************************
Programa principal
*************************************************************/
require_once $DirRaiz.'libs/PAMI/Autoloader/Autoloader.php'; // Include PAMI autoloader.
\PAMI\Autoloader\Autoloader::register(); // Call autoloader register for PAMI autoloader.
use PAMI\Client\Impl\ClientImpl as PamiClient;
use PAMI\Message\Action\SIPShowPeerAction;
use PAMI\Message\Action\ExtensionStateAction;
use PAMI\Message\Action\CommandAction;

$options = array(
	'log4php.properties' => $DirRaiz. "websockets" . '/log4php.properties',
	'host' => $HostAsterisk,
	'port' => 5038,
	'username' => 'pami',
	'secret' => 'PAMI',
	'connect_timeout' => 10,
	'read_timeout' => 30,
	'scheme' => 'tcp://' // try tls://
);
$pamiClient = new PamiClient($options);

$Saida = "";
if($L_var['acao']=="carrega_status_ramais") echo carrega_status_ramais($L_var['ramais'], $L_var['buscaStatus']);
else if($L_var['acao']=="carrega_status_troncos") echo carrega_status_troncos($L_var['troncos']);
else if($L_var['acao']=="com_quem_fala") echo com_quem_fala($L_var['id'], $L_var['numero']);
return;

function carrega_status_ramais($ramais, $buscaStatus){
	Global $DirRaiz, $pamiClient;
	$ramais = json_decode($ramais);
	// Open the connection  
	$pamiClient->open();
	for($i = 0; $i < count($ramais); $i++){
		$response = $pamiClient->send(new SIPShowPeerAction($ramais[$i]->ramal));
		if ($response->isSuccess()) {  
			$dados[$i]['ramal'] = $ramais[$i]->ramal;
			$dados[$i]['ip'] = $response->getKey("address-ip");
			$dados[$i]['contexto'] = $response->getKey("context");
			$dados[$i]['terminal'] = $response->getKey("sip-useragent");
			$dados[$i]['caller_id'] = $response->getKey("callerid");
			$dados[$i]['registro'] = $response->getKey("reg-contact");
			if($buscaStatus!=""){
				$response2 = $pamiClient->send(new ExtensionStateAction($ramais[$i]->ramal, $ramais[$i]->contexto));
				if($response2->isSuccess()){
					$dados[$i]['status'] = $response2->getKey("status");
				}
			}
		} else {  
			echo "Failed!\n";
		}
	}
	$pamiClient->close();
    $dados = utf8_encode_recursive($dados);
	$dados = json_encode($dados);
	return $dados;
}

function carrega_status_troncos($troncos){
	Global $Monitor;
	$troncos = json_decode($troncos);
	// Open the connection  
	$Monitor->abrir_conexao_ami();
	$Tro = $Monitor->le_estado_troncos_ami();
	$Monitor->fechar_conexao_ami();
	for($i = 4; $i < count($Tro); $i++){
		$dadosTroncos = explode(" : ", $Tro[$i]);
		$dados = preg_explode("/[\s,]+/", $dadosTroncos[1]);
		if($dados[1]!=""){
			$status = explode(":", $dados[1]);
			$saida[$i-4]["exten"] = $dados[0];
			$saida[$i-4]["status"] = $status[1];
		}
	}
	
	$dados = json_encode($saida);
	return $dados;
}

function com_quem_fala($id, $numero){
	Global $Pbx;
	$Aux  = $Pbx->descobre_nome_com_quem_fala($id,trim($numero));
	
	if($Aux) $NomeAux = $Aux;
	else $NomeAux = $numero;
	return $NomeAux;
}

?>