<?php
/**************************************************************
 * Nome:    CPbxMonia
 * Autor:   Valnei M. Lorenzetti
 * Data:	  2008-01-25 (V1.0.0)
 * Descr.:  Verifica as luzes que sao para acender ou apagar
 *************************************************************/


/**************************************************************
  Cabecalho para nao fazer cache
 *************************************************************/
 header('Cache-Control: no-cache, must-revalidate');
 header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');

/**************************************************************
  Area dos includes
 *************************************************************/
  $DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
  include_once($DirRaiz.'config.php');
  include_once($DirRaiz.'config.pbx.php');
  $Modulo = $DirPBX;
  include_once($DirRaiz.$DirClass.'usuario.class.php');
  include_once($DirRaiz.$DirPBX.$DirClass.'pbx.class.php');
  include_once($DirRaiz.$Modulo.$DirModul.'pbx.modu.php');

/**************************************************************
  Definicao de variaveis
 *************************************************************/
  $L_var = $_GET;          // Recebe as variaveis do formulario
  $Ppbx  = new Pbx;        // Objeto Pbx
  $Usua  = new Usuarios;   // Objeto usuario


/**************************************************************
  Programa principal
 *************************************************************/
  $Saida = "";
  if ($L_var['acao']=="inicio")  $Saida = monitora_geral($L_var['usua']);
  if ($L_var['acao']=="noturno") $Saida = monitora_noturno($L_var['usua']);
  if ($L_var['acao']=="cadeado") $Saida = monitora_cadeado($L_var['usua'],$L_var['valor']);
  if ($L_var['acao']=="ausente") $Saida = monitora_ausente($L_var['usua'],$L_var['valor']);
  if ($L_var['acao']=="mudo")    $Saida = monitora_mudo($L_var['usua'],$L_var['valor']);
  if ($L_var['acao']=="autoatendimento")   $Saida = monitora_autoatendimento($L_var['usua'],$L_var['valor']);
  if ($L_var['acao']=="sigamesempre")      $Saida = monitora_sigamesempre($L_var['usua'],$L_var['valor']);
  if ($L_var['acao']=="sigamesenaoatende") $Saida = monitora_sigamesenaoatende($L_var['usua'],$L_var['valor']);
  if ($L_var['acao']=="sigameseocupado")   $Saida = monitora_sigameseocupado($L_var['usua'],$L_var['valor']);
  if ($L_var['acao']=="pausa")	 $Saida = entrar_pausa($L_var['ramal'],$L_var['fila']);
  echo $Saida;
  return;


/**************************************************************
  Funcao monitora_geral
 *************************************************************/
  function monitora_geral($Usuario) {
    Global $Ppbx, $Usua;
    $Aux      = $Usua->lista_usuarios_por_id($Usuario);
    if (!$Aux) return;
    $MeuRamal = $Aux[0]['ramal'];
    $Situacao = $Ppbx->lista_luzes_ramal($MeuRamal);
    if ($Situacao===false) return;
    //$Banco = array('cadeado',    'voicemail','ausente',    'noturno',    'mudo',    'autoatendimento','sigamesempre',    'sigamesenaoatende','sigameseocupado');
    //$Luzes = array('luz_cadeado','luz_cvoz', 'luz_ausente','luz_noturno','luz_mudo','luz_autoate',    'bt_sigame_sempre','bt_sigame_naoatende','bt_sigame_ocupado');
    $Banco = array('cadeado',    'ausente',    'noturno',    'mudo',    'autoatendimento','sigamesempre',    'sigamesenaoatende','sigameseocupado');
    $Luzes = array('luz_cadeado','luz_ausente','luz_noturno','luz_mudo','luz_autoate',    'bt_sigame_sempre','bt_sigame_naoatende','bt_sigame_ocupado');
    $Chave = array('cadeado',    'ausente',     '',          'mudoest', 'autoate',        'sgmsemp',         'sgmnant',            'sgmocup');
    $Saida = "";
    for ($x=0; $x<count($Luzes); $x++) {
      ($Situacao[$Banco[$x]]==0) ? $Cor='"#006600"' : $Cor='"#CC0000"';
      $Saida .= 'if (existeobj("'.$Luzes[$x].'")) {Obj=le_objeto("'.$Luzes[$x].'");Obj.style.color='.$Cor.';';
      if (substr($Luzes[$x],0,2)=='bt') $Saida .= 'Obj.style.backgroundColor='.$Cor.';}; ';
      else $Saida .= '}; ';
      if ($Chave[$x]>"") $Saida .= 'if (existeobj("'.$Chave[$x].'")) {Obj=le_objeto("'.$Chave[$x].'");Obj.value="'.$Situacao[$Banco[$x]].'";}; ';
    }
    return $Saida;
  }


/**************************************************************
  Funcao monitora_noturno
 *************************************************************/
  function monitora_noturno($Usuario) {
    Global $Ppbx, $Usua;
    $Aux      = $Usua->lista_usuarios_por_id($Usuario);
    if (!$Aux) return;
    $MeuRamal = $Aux[0]['ramal'];
    $Situacao = $Ppbx->marca_turnos_mesa($MeuRamal);
    if ($Situacao===false) return;
    $Saida = 'Obj=le_objeto("luz_noturno");Obj.style.color=';
    if ($Situacao==0) $Saida.='"#006600"';
    else $Saida.='"#CC0000"';
    return $Saida;
  }


/**************************************************************
  Funcao monitora_cadeado
 *************************************************************/
  function monitora_cadeado($Usuario,$Valor) {
    Global $Ppbx, $Usua;
    $Aux      = $Usua->lista_usuarios_por_id($Usuario);
    if (!$Aux) return;
    $MeuRamal = $Aux[0]['ramal'];
    $Situacao = $Ppbx->altera_estado_luzes_ramal($MeuRamal,'cadeado',$Valor);
    if ($Situacao===false) return;
    $Saida = 'Obj=le_objeto("luz_cadeado");Obj.style.color=';
    ($Valor==0) ? $Saida.='"#006600"' : $Saida.='"#CC0000"';
    return $Saida;
  }


/**************************************************************
  Funcao monitora_ausente
 *************************************************************/
  function monitora_ausente($Usuario,$Valor) {
    Global $Ppbx, $Usua;
    $Aux      = $Usua->lista_usuarios_por_id($Usuario);
    if (!$Aux) return;
    $MeuRamal = $Aux[0]['ramal'];
	$Filas = $Usua->lista_usuarios_filas_por_id($Usuario);
    $Situacao = $Ppbx->altera_estado_luzes_ramal($MeuRamal,'ausente',$Valor);
    if ($Situacao===false) return;
    $Saida = 'Obj=le_objeto("luz_ausente");Obj.style.color=';
    ($Valor==0) ? $Saida.='"#006600"' : $Saida.='"#CC0000"';
	if($Valor==0){
		foreach($Filas as $fila){
			sair_pausa($MeuRamal, $fila['fila']);
		}
	} else {
		foreach($Filas as $fila){
			entrar_pausa($MeuRamal, $fila['fila']);
		}
	}
    return $Saida;
  }


/**************************************************************
  Funcao monitora_mudo
 *************************************************************/
  function monitora_mudo($Usuario,$Valor) {
    Global $Ppbx, $Usua;
    $Aux      = $Usua->lista_usuarios_por_id($Usuario);
    if (!$Aux) return;
    $MeuRamal = $Aux[0]['ramal'];
    $Situacao = $Ppbx->altera_estado_luzes_ramal($MeuRamal,'mudo',$Valor);
    if ($Situacao===false) return;
    $Saida = 'Obj=le_objeto("luz_mudo");Obj.style.color=';
    ($Valor==0) ? $Saida.='"#006600"' : $Saida.='"#CC0000"';
    return $Saida;
  }


/**************************************************************
  Funcao monitora_autoatendimento
 *************************************************************/
  function monitora_autoatendimento($Usuario,$Valor) {
    Global $Ppbx, $Usua;
    $Aux      = $Usua->lista_usuarios_por_id($Usuario);
    if (!$Aux) return;
    $MeuRamal = $Aux[0]['ramal'];
    $Situacao = $Ppbx->altera_estado_luzes_ramal($MeuRamal,'autoatendimento',$Valor);
    if ($Situacao===false) return;
    $Saida = 'Obj=le_objeto("luz_autoate");Obj.style.color=';
    ($Valor==0) ? $Saida.='"#006600"' : $Saida.='"#CC0000"';
    return $Saida;
  }


/**************************************************************
  Funcao monitora_sigamesempre
 *************************************************************/
  function monitora_sigamesempre($Usuario,$Valor) {
    Global $Ppbx, $Usua;
    $Aux      = $Usua->lista_usuarios_por_id($Usuario);
    if (!$Aux) return;
    $MeuRamal = $Aux[0]['ramal'];
    $Situacao = $Ppbx->altera_estado_luzes_ramal($MeuRamal,'sigamesempre',$Valor);
//return "alert('".$Situacao."')";
    if ($Situacao===false) return;
    $Saida = 'Obj=le_objeto("bt_sigame_sempre");Obj.style.backgroundColor=';
    ($Valor==0) ? $Saida.='"#006600"' : $Saida.='"#CC0000"';
    return $Saida;
  }


/**************************************************************
  Funcao monitora_sigamesenaoatende
 *************************************************************/
  function monitora_sigamesenaoatende($Usuario,$Valor) {
    Global $Ppbx, $Usua;
    $Aux      = $Usua->lista_usuarios_por_id($Usuario);
    if (!$Aux) return;
    $MeuRamal = $Aux[0]['ramal'];
    $Situacao = $Ppbx->altera_estado_luzes_ramal($MeuRamal,'sigamesenaoatende',$Valor);
    if ($Situacao===false) return;
    $Saida = 'Obj=le_objeto("bt_sigame_naoatende");Obj.style.backgroundColor=';
    ($Valor==0) ? $Saida.='"#006600"' : $Saida.='"#CC0000"';
    return $Saida;
  }


/**************************************************************
  Funcao monitora_sigameseocupado
 *************************************************************/
  function monitora_sigameseocupado($Usuario,$Valor) {
    Global $Ppbx, $Usua;
    $Aux      = $Usua->lista_usuarios_por_id($Usuario);
    if (!$Aux) return;
    $MeuRamal = $Aux[0]['ramal'];
    $Situacao = $Ppbx->altera_estado_luzes_ramal($MeuRamal,'sigameseocupado',$Valor);
    if ($Situacao===false) return;
    $Saida = 'Obj=le_objeto("bt_sigame_ocupado");Obj.style.backgroundColor=';
    ($Valor==0) ? $Saida.='"#006600"' : $Saida.='"#CC0000"';
    return $Saida;
  }


?>
