--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: historico; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA historico;


ALTER SCHEMA historico OWNER TO postgres;

--
-- Name: realtime; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA realtime;


ALTER SCHEMA realtime OWNER TO postgres;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: postgres
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO postgres;

SET search_path = historico, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: sip; Type: TABLE; Schema: historico; Owner: postgres; Tablespace: 
--

CREATE TABLE sip (
    cod_id bigint NOT NULL,
    id_sip_ramal integer NOT NULL,
    name character varying(80) DEFAULT ''::character varying NOT NULL,
    host character varying(31) DEFAULT ''::character varying NOT NULL,
    username character varying(80) DEFAULT ''::character varying NOT NULL,
    secret character varying(80),
    type character varying(80) DEFAULT 'friend'::character varying NOT NULL,
    ipaddr character varying(80) DEFAULT ''::character varying NOT NULL,
    port integer DEFAULT 0 NOT NULL,
    regseconds numeric DEFAULT 0 NOT NULL,
    context character varying(80) DEFAULT ''::character varying NOT NULL,
    lastms character varying(80) DEFAULT ''::character varying NOT NULL,
    nat character varying(5) DEFAULT 'yes'::character varying,
    dtmfmode character varying(80) DEFAULT 'auto'::character varying NOT NULL,
    call_limit integer
);


ALTER TABLE historico.sip OWNER TO postgres;

SET search_path = public, pg_catalog;

--
-- Name: bloqueio; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE bloqueio (
    telefones integer
);


ALTER TABLE public.bloqueio OWNER TO postgres;

--
-- Name: cad_cli; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE cad_cli (
    uf character(2),
    tel1 character varying(12),
    tel2 character varying(12),
    tel3 character varying(12),
    tel4 character varying(12),
    id_entidade character varying(12),
    nm_entidade character varying(60),
    nmcompleto_entidade character varying(60),
    ds_tipoentidade character(30),
    ds_tipoentidcontato character(30),
    sgclass_entidade character(1),
    nm_entidclassif character varying(60),
    sgstatus_entidade character(2),
    prioridade integer
);


ALTER TABLE public.cad_cli OWNER TO postgres;

--
-- Name: tipocamp; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE tipocamp AS ENUM (
    'preditivo',
    'power dialing',
    'manual'
);


ALTER TYPE public.tipocamp OWNER TO postgres;

--
-- Name: crm_campanhas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE crm_campanhas (
    id integer NOT NULL,
    nome character varying(150),
    celular boolean,
    tentativafixloc integer,
    tentativafixddd integer,
    tentativacelloc integer,
    tentativacelddd integer,
    duracao timestamp without time zone,
    horafuncde character(5),
    horafuncaa character(5),
    timeoutexito integer,
    timeoutmanual integer,
    tipocampanha tipocamp,
    ativo boolean,
    pausa boolean
);


ALTER TABLE public.crm_campanhas OWNER TO postgres;

--
-- Name: crm_clientes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE crm_clientes (
    id integer NOT NULL,
    nome character varying(150),
    cpf character(11),
    endereco character varying(254),
    agendadatahora timestamp without time zone,
    agendatelefone character varying(25),
    chavecrm integer
);


ALTER TABLE public.crm_clientes OWNER TO postgres;

--
-- Name: crm_listas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE crm_listas (
    campanha_id integer NOT NULL,
    cliente_id integer NOT NULL
);


ALTER TABLE public.crm_listas OWNER TO postgres;

--
-- Name: crm_telefones_clientes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE crm_telefones_clientes (
    id integer NOT NULL,
    cliente_id integer,
    telefone character varying(25)
);


ALTER TABLE public.crm_telefones_clientes OWNER TO postgres;

--
-- Name: dblink_pkey_results; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE dblink_pkey_results AS (
	"position" integer,
	colname text
);


ALTER TYPE public.dblink_pkey_results OWNER TO postgres;

--
-- Name: distribuicao; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE distribuicao AS ENUM (
    'rrmemory',
    'ringall',
    'roundrobin',
    'leastrecent',
    'feweastcalls',
    'random'
);


ALTER TYPE public.distribuicao OWNER TO postgres;

--
-- Name: fabrica; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE fabrica AS ENUM (
    'DGV',
    'Khomp',
    'Zap'
);


ALTER TYPE public.fabrica OWNER TO postgres;

--
-- Name: foo; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE foo (
    f1 integer NOT NULL,
    f2 text NOT NULL,
    f3 text[]
);


ALTER TABLE public.foo OWNER TO postgres;

--
-- Name: funcao; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE funcao AS ENUM (
    'membro de fila',
    'ativo',
    'treinamento',
    'supervisao'
);


ALTER TYPE public.funcao OWNER TO postgres;

--
-- Name: modelos_placa; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE modelos_placa AS ENUM (
    '4FXO',
    '8FXO',
    '1E1',
    '2E1',
    '4E1',
    '1GSM',
    '2GSM',
    '3GSM',
    '4GSM'
);


ALTER TYPE public.modelos_placa OWNER TO postgres;

--
-- Name: notaatend; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE notaatend (
    id bigint NOT NULL,
    data character varying(8),
    hora character varying(8),
    numero_cliente character varying(60),
    nome_cliente character varying(60),
    agente character varying(60),
    nota smallint
);


ALTER TABLE public.notaatend OWNER TO postgres;

--
-- Name: procon; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE procon (
    numero character varying(20)
);


ALTER TABLE public.procon OWNER TO postgres;

--
-- Name: simnao; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE simnao AS ENUM (
    'no',
    'yes'
);


ALTER TYPE public.simnao OWNER TO postgres;

--
-- Name: simnaoonce; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE simnaoonce AS ENUM (
    'once',
    'no',
    'yes'
);


ALTER TYPE public.simnaoonce OWNER TO postgres;

--
-- Name: simnaostrict; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE simnaostrict AS ENUM (
    'strict',
    'no',
    'yes'
);


ALTER TYPE public.simnaostrict OWNER TO postgres;

--
-- Name: sip_ramais; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE sip_ramais (
    id bigint NOT NULL,
    name character varying(80) DEFAULT ''::character varying NOT NULL,
    host character varying(31) DEFAULT ''::character varying NOT NULL,
    username character varying(80) DEFAULT ''::character varying NOT NULL,
    secret character varying(80) DEFAULT ''::character varying,
    type character varying(80) DEFAULT 'friend'::character varying NOT NULL,
    ipaddr character varying(15) DEFAULT ''::character varying NOT NULL,
    port integer DEFAULT 0 NOT NULL,
    regseconds numeric DEFAULT 0 NOT NULL,
    context character varying(80) DEFAULT ''::character varying NOT NULL,
    lastms character varying(80) DEFAULT ''::character varying NOT NULL,
    nat character varying(5) DEFAULT 'yes'::character varying NOT NULL
);


ALTER TABLE public.sip_ramais OWNER TO postgres;

--
-- Name: tb_central; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_central (
    id_central integer NOT NULL,
    nome_central character varying(100) DEFAULT ''::character varying,
    host_central character varying(100) DEFAULT ''::character varying,
    local_central character varying(100) DEFAULT ''::character varying,
    porta integer DEFAULT 0,
    nome_projeto character varying(100) DEFAULT ''::character varying
);


ALTER TABLE public.tb_central OWNER TO postgres;

--
-- Name: tb_grupo_tronco; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_grupo_tronco (
    id integer NOT NULL,
    nome_grupo character varying(100) NOT NULL,
    descricao_grupo character varying(100) NOT NULL
);


ALTER TABLE public.tb_grupo_tronco OWNER TO postgres;

--
-- Name: tb_login_grupo; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_login_grupo (
    id bigint NOT NULL,
    loginmonitora character varying(100),
    agentemonitora character varying(100),
    ramalmonitora character varying(100),
    grupomonitora character varying,
    situacaomonitora character varying(100) DEFAULT ''::bpchar
);


ALTER TABLE public.tb_login_grupo OWNER TO postgres;

--
-- Name: tb_monitora_agente_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tb_monitora_agente_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tb_monitora_agente_id_seq OWNER TO postgres;

--
-- Name: tb_monitora_agente; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_monitora_agente (
    id integer DEFAULT nextval('tb_monitora_agente_id_seq'::regclass) NOT NULL,
    login_monitorado character varying(100) DEFAULT ''::character varying,
    grupo_monitorado character varying(100) DEFAULT ''::character varying,
    situacao_login character varying(1) DEFAULT 'L'::bpchar,
    id_central integer,
    agente_supervisor integer DEFAULT 0,
    tipo character varying(100) DEFAULT ''::character varying,
    agente_monitorado character varying(255)
);


ALTER TABLE public.tb_monitora_agente OWNER TO postgres;

--
-- Name: tb_realtime; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_realtime (
    id bigint NOT NULL,
    status bit(1)
);


ALTER TABLE public.tb_realtime OWNER TO postgres;

--
-- Name: type_atualiza_fila_agente; Type: TYPE; Schema: public; Owner: postgres
--

CREATE TYPE type_atualiza_fila_agente AS (
	id_fila smallint,
	fila text,
	id_agente smallint,
	agente text
);


ALTER TYPE public.type_atualiza_fila_agente OWNER TO postgres;

--
-- Name: vm50_agenda; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_agenda (
    id bigint NOT NULL,
    usuario bigint,
    nome character varying(100),
    cargo character varying(100),
    empresa character varying(100),
    ramal character varying(6),
    tel_res character varying(60),
    tel_cel character varying(60),
    fax character varying(60),
    email character varying(60),
    tel_com character varying(60)
);


ALTER TABLE public.vm50_agenda OWNER TO postgres;

--
-- Name: vm50_agenda_campanhas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_agenda_campanhas (
    id integer NOT NULL,
    id_campanha integer NOT NULL,
    campanha character varying(200),
    inicio character varying(8) NOT NULL,
    fim character varying(8) NOT NULL
);


ALTER TABLE public.vm50_agenda_campanhas OWNER TO postgres;

--
-- Name: vm50_agentes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_agentes (
    id integer NOT NULL,
    nome character varying(50),
    login character(4),
    senha character(4),
    ramal character(4),
    situacao character varying(50),
    falandocom character varying(50),
    id_ligacao character varying(50),
    fila character varying(50),
    tempo timestamp without time zone,
    grupo character varying(50),
    pausa character(1),
    pausafalsa character(1),
    pseudonimo character varying(50),
    horario1 character(5),
    horario2 character(5),
    funcai funcao DEFAULT 'membro de fila'::funcao,
    tipopausa character varying(50),
    loginr character varying(150),
    grupos character varying(150),
    ult_estad timestamp without time zone,
    contexto character varying(150) DEFAULT '-'::character varying NOT NULL,
    ip character varying(15) DEFAULT ''::character varying,
    filas character varying,
    notificapausaauto boolean DEFAULT false,
    notificadepoisde integer DEFAULT 15,
    notificalivredepoisde integer DEFAULT 15
);


ALTER TABLE public.vm50_agentes OWNER TO postgres;

--
-- Name: vm50_agentes_desabilitados; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_agentes_desabilitados (
    id_agente integer NOT NULL,
    id_fila integer
);


ALTER TABLE public.vm50_agentes_desabilitados OWNER TO postgres;

--
-- Name: vm50_agentes_grupos; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_agentes_grupos (
    agente smallint NOT NULL,
    grupo smallint NOT NULL
);


ALTER TABLE public.vm50_agentes_grupos OWNER TO postgres;

--
-- Name: vm50_agentes_ramais; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_agentes_ramais (
    id bigint NOT NULL,
    agente bigint NOT NULL,
    ramal bigint NOT NULL
);


ALTER TABLE public.vm50_agentes_ramais OWNER TO postgres;

--
-- Name: vm50_alarmes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_alarmes (
    grupo_congestionado boolean DEFAULT true,
    fila_congestionada boolean DEFAULT true,
    feixe_congestionado boolean DEFAULT true,
    tempo_pausa boolean DEFAULT true,
    tempo_livre boolean DEFAULT true,
    tempo_conversacao_saida boolean DEFAULT true,
    tempo_conversacao_atendimento boolean DEFAULT true,
    tempo_consulta boolean DEFAULT true,
    tempo_fila_espera boolean DEFAULT true,
    usuario integer NOT NULL
);


ALTER TABLE public.vm50_alarmes OWNER TO postgres;

--
-- Name: vm50_arvore_grupos; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_arvore_grupos (
    id integer NOT NULL,
    nome character varying(100) NOT NULL,
    pai integer DEFAULT 0 NOT NULL,
    prioridade integer,
    tipo character varying(50)
);


ALTER TABLE public.vm50_arvore_grupos OWNER TO postgres;

--
-- Name: vm50_ast_queue; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_ast_queue (
    id bigint NOT NULL,
    nome character varying(128) NOT NULL,
    context character varying(128) DEFAULT NULL::character varying,
    timeout integer,
    retry integer,
    maxlen integer,
    ringinuse character varying(5) DEFAULT NULL::character varying,
    strategy character varying(128) DEFAULT NULL::character varying,
    joinempty character varying(6) DEFAULT NULL::character varying,
    leavewhenempty character varying(5) DEFAULT NULL::character varying,
    eventmemberstatus character varying(5) DEFAULT NULL::character varying,
    eventwhencalled character varying(5) DEFAULT NULL::character varying,
    music character varying(128) DEFAULT NULL::character varying
);


ALTER TABLE public.vm50_ast_queue OWNER TO postgres;

--
-- Name: vm50_ast_queue_member; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_ast_queue_member (
    id bigint NOT NULL,
    membername character varying(50) DEFAULT NULL::character varying,
    queue_name character varying(128) DEFAULT NULL::character varying
);


ALTER TABLE public.vm50_ast_queue_member OWNER TO postgres;

--
-- Name: vm50_auxiliares_filas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_auxiliares_filas (
    id bigint NOT NULL,
    ramal bigint NOT NULL,
    fila integer NOT NULL
);


ALTER TABLE public.vm50_auxiliares_filas OWNER TO postgres;

--
-- Name: vm50_campanhas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_campanhas (
    id bigint NOT NULL,
    titulo character varying(128) NOT NULL,
    descricao text,
    grupo integer,
    prioridade integer DEFAULT 0
);


ALTER TABLE public.vm50_campanhas OWNER TO postgres;

--
-- Name: vm50_campanhas_pecas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_campanhas_pecas (
    id bigint NOT NULL,
    nome character varying
);


ALTER TABLE public.vm50_campanhas_pecas OWNER TO postgres;

--
-- Name: vm50_chamadas_classificadas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_chamadas_classificadas (
    id bigint NOT NULL,
    classificacao character varying,
    atendente character varying,
    observacao character varying,
    telefone character varying,
    id_vendedor character varying(10),
    id_cliente character varying(20),
    data timestamp without time zone
);


ALTER TABLE public.vm50_chamadas_classificadas OWNER TO postgres;

--
-- Name: vm50_chat; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_chat (
    id bigint NOT NULL,
    origem character varying(100) NOT NULL,
    destino character varying(100) NOT NULL,
    mensagem character varying(500),
    data timestamp without time zone NOT NULL,
    lido boolean DEFAULT false NOT NULL
);


ALTER TABLE public.vm50_chat OWNER TO postgres;

--
-- Name: vm50_classificacao_chamadas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_classificacao_chamadas (
    id integer NOT NULL,
    nome character varying(50),
    id_pai bigint DEFAULT 0
);


ALTER TABLE public.vm50_classificacao_chamadas OWNER TO postgres;

--
-- Name: vm50_codigo_conta; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_codigo_conta (
    id bigint NOT NULL,
    codigo integer DEFAULT 0 NOT NULL,
    nome character varying
);


ALTER TABLE public.vm50_codigo_conta OWNER TO postgres;

--
-- Name: vm50_conf_email; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_conf_email (
    id integer NOT NULL,
    email character varying,
    senha character varying,
    smtp character varying,
    porta_smtp integer
);


ALTER TABLE public.vm50_conf_email OWNER TO postgres;

--
-- Name: vm50_config_geral; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_config_geral (
    id bigint NOT NULL,
    grupo character varying(100),
    popup boolean DEFAULT false,
    refresh integer DEFAULT 2 NOT NULL,
    tipons integer DEFAULT 1 NOT NULL,
    contexto character varying(100) DEFAULT 'interno'::character varying NOT NULL,
    mostrar_qtd_chamadas boolean DEFAULT false NOT NULL,
    temporefreshestatisticas integer DEFAULT 900 NOT NULL,
    mostrar_estatisticas boolean DEFAULT false NOT NULL,
    filasdinamicas integer DEFAULT 0 NOT NULL,
    nomepausa character varying(150) DEFAULT '-'::character varying NOT NULL,
    entrarpausaauto integer DEFAULT 0 NOT NULL,
    retirarpausaauto boolean DEFAULT false NOT NULL,
    tipopausaretirar integer DEFAULT 0 NOT NULL,
    tipocontexto integer DEFAULT 0 NOT NULL,
    mostrar_offline_supervisao boolean DEFAULT false
);


ALTER TABLE public.vm50_config_geral OWNER TO postgres;

--
-- Name: vm50_config_painel_pa; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_config_painel_pa (
    id bigint NOT NULL,
    ip_discador character varying,
    ddd_local integer
);


ALTER TABLE public.vm50_config_painel_pa OWNER TO postgres;

--
-- Name: vm50_config_syonet; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_config_syonet (
    id integer NOT NULL,
    ip_crm character varying,
    usuario_crm character varying DEFAULT 'WS_VDT'::character varying,
    senha_crm character varying DEFAULT 'WS_VDT01'::character varying,
    dominio_crm character varying
);


ALTER TABLE public.vm50_config_syonet OWNER TO postgres;

--
-- Name: vm50_ddd; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_ddd (
    id bigint NOT NULL,
    uf character varying(2),
    municipio character varying(50),
    ddd integer
);


ALTER TABLE public.vm50_ddd OWNER TO postgres;

--
-- Name: vm50_discador; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_discador (
    id bigint NOT NULL,
    callid character varying(255) NOT NULL,
    ddd character varying(2) NOT NULL,
    telefone character varying(20) NOT NULL,
    campanha character varying(255) NOT NULL,
    created integer NOT NULL,
    ts integer NOT NULL,
    status integer NOT NULL,
    agent integer NOT NULL
);


ALTER TABLE public.vm50_discador OWNER TO postgres;

--
-- Name: vm50_dscrapida; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_dscrapida (
    id bigint NOT NULL,
    usuario bigint,
    tecla character(2),
    nome character varying(60),
    numero character varying(60)
);


ALTER TABLE public.vm50_dscrapida OWNER TO postgres;

--
-- Name: vm50_extensoes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_extensoes (
    id integer NOT NULL,
    nome character varying(200),
    codigo integer
);


ALTER TABLE public.vm50_extensoes OWNER TO postgres;

--
-- Name: vm50_facilidades; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_facilidades (
    id bigint NOT NULL,
    facilidade character varying(128) DEFAULT NULL::character varying,
    valor character varying(128) DEFAULT NULL::character varying,
    descricao character varying(128) DEFAULT NULL::character varying
);


ALTER TABLE public.vm50_facilidades OWNER TO postgres;

--
-- Name: vm50_feixes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_feixes (
    id bigint NOT NULL,
    nome character varying(128) DEFAULT NULL::character varying,
    prefixo character varying(5) DEFAULT NULL::character varying,
    tronco_chave character varying(128) DEFAULT NULL::character varying,
    habilita_monitoracao character(1) DEFAULT '1'::bpchar
);


ALTER TABLE public.vm50_feixes OWNER TO postgres;

--
-- Name: vm50_feixes_remotos; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_feixes_remotos (
    id bigint NOT NULL,
    nome character varying(128) DEFAULT NULL::character varying,
    prefixo character varying(5) DEFAULT NULL::character varying,
    tronco_chave character varying(128) DEFAULT NULL::character varying,
    habilita_monitoracao character(1) DEFAULT '1'::bpchar,
    host character varying(20) DEFAULT '127.0.0.1'::character varying
);


ALTER TABLE public.vm50_feixes_remotos OWNER TO postgres;

--
-- Name: vm50_feriados; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_feriados (
    id bigint NOT NULL,
    dia timestamp without time zone NOT NULL,
    descricao character varying(128) DEFAULT NULL::character varying,
    diainteiro boolean,
    horainicio time without time zone,
    horafim time without time zone
);


ALTER TABLE public.vm50_feriados OWNER TO postgres;

--
-- Name: vm50_fha_filas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_fha_filas (
    id bigint NOT NULL,
    ramal bigint NOT NULL,
    fila integer NOT NULL
);


ALTER TABLE public.vm50_fha_filas OWNER TO postgres;

--
-- Name: vm50_filas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_filas (
    id integer NOT NULL,
    nome character varying(128) NOT NULL,
    pseudonimo character varying(128) DEFAULT NULL::character varying,
    numero character varying(128) DEFAULT NULL::character varying,
    tronco character varying(128) DEFAULT NULL::character varying,
    estrategia distribuicao DEFAULT 'rrmemory'::distribuicao,
    musica character varying(128) DEFAULT 'default'::character varying,
    timeout smallint DEFAULT 12,
    tentardenovo smallint DEFAULT 2,
    limitedafila smallint DEFAULT 0,
    prioridade smallint DEFAULT 0,
    delaydeencaminhamento smallint DEFAULT 0,
    delaydeatendimento smallint DEFAULT 0,
    resetatimeout simnao DEFAULT 'no'::simnao,
    distribuicaodacparalela simnao DEFAULT 'yes'::simnao,
    setavariavel simnao DEFAULT 'yes'::simnao,
    anundeposicaonafila smallint DEFAULT 90,
    anunperiodicos smallint DEFAULT 60,
    anunesperaestimada simnaoonce DEFAULT 'once'::simnaoonce,
    anundesegundos smallint DEFAULT 10,
    segchamadanapa simnao DEFAULT 'no'::simnao,
    entradafilasemmembros simnaostrict DEFAULT 'strict'::simnaostrict,
    removechamsesemmembros simnao DEFAULT 'yes'::simnao,
    geraeventochamagente simnao DEFAULT 'yes'::simnao,
    geraeventomembstatus simnao DEFAULT 'yes'::simnao,
    tempominconvatend smallint DEFAULT 10,
    tempomaxconvatend smallint DEFAULT 10,
    tempomaxespeatend smallint DEFAULT 10,
    qtdemaxchamafilaesp smallint,
    qtdemaxchamarecebid smallint,
    visivelsupervisao simnao DEFAULT 'yes'::simnao,
    direcao character(2) DEFAULT NULL::bpchar,
    tempoadidional smallint DEFAULT 10,
    tempominespera smallint DEFAULT 10,
    entrarpausaauto boolean DEFAULT false,
    retirarpausaauto boolean DEFAULT false,
    pausaautomatica character varying(100) DEFAULT '-'::character varying,
    spa boolean DEFAULT false,
    dinamica boolean DEFAULT false,
    tempodepausa integer DEFAULT 10,
    mostrarrelplansimp boolean DEFAULT true,
    classifica_chamadas boolean,
    id_grupo_relat integer DEFAULT 0
);


ALTER TABLE public.vm50_filas OWNER TO postgres;

--
-- Name: vm50_filas_membros; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_filas_membros (
    fila smallint NOT NULL,
    agente smallint NOT NULL,
    id bigint NOT NULL,
    penalty integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.vm50_filas_membros OWNER TO postgres;

--
-- Name: vm50_filas_ramais; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_filas_ramais (
    id integer NOT NULL,
    fila bigint NOT NULL,
    ramal bigint NOT NULL,
    penalty integer DEFAULT 0
);


ALTER TABLE public.vm50_filas_ramais OWNER TO postgres;

--
-- Name: vm50_filas_syonet; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_filas_syonet (
    id bigint NOT NULL,
    fila_crm character varying,
    operacao_crm character varying,
    empresa_crm character varying,
    mcdu_crm character varying,
    caixa_postal_crm character varying,
    email_notifica character varying
);


ALTER TABLE public.vm50_filas_syonet OWNER TO postgres;

--
-- Name: vm50_grades_filas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_grades_filas (
    fila smallint NOT NULL,
    tipo character varying(20) NOT NULL,
    pos01 smallint,
    pos02 smallint,
    pos03 smallint,
    pos04 smallint,
    pos05 smallint,
    pos06 smallint,
    pos07 smallint,
    pos08 smallint,
    pos09 smallint,
    pos10 smallint,
    pos11 smallint,
    pos12 smallint,
    pos13 smallint,
    pos14 smallint,
    pos15 smallint,
    pos16 smallint,
    pos17 smallint,
    pos18 smallint,
    pos19 smallint,
    pos20 smallint
);


ALTER TABLE public.vm50_grades_filas OWNER TO postgres;

--
-- Name: vm50_gravacoes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_gravacoes (
    id_ligacao character varying(50) NOT NULL,
    gravacao character varying(128),
    dia character varying(10),
    hora character varying(10),
    agente_o character varying(50),
    ramal_o character varying(4),
    usuario_o character varying(50),
    grupopabx_o character varying(50),
    grupodac_o character varying(50),
    fila character varying(128) DEFAULT ''::character varying,
    numero character varying(50),
    agente_d character varying(50),
    ramal_d character varying(4),
    usuario_d character varying(50),
    grupopabx_d character varying(50),
    grupodac_d character varying(50),
    duracao character varying(50),
    tipo character varying(20),
    obs character varying(128),
    diahora character varying(128),
    custom_01 character varying(128),
    custom_02 character varying(128),
    custom_03 character varying(128),
    custom_04 character varying(128),
    custom_05 character varying(128)
);


ALTER TABLE public.vm50_gravacoes OWNER TO postgres;

--
-- Name: vm50_gravacoes_hoje; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_gravacoes_hoje (
    id_ligacao character varying(50) NOT NULL,
    gravacao character varying(128),
    dia character varying(10),
    hora character varying(10),
    agente_o character varying(50),
    ramal_o character varying(4),
    usuario_o character varying(50),
    grupopabx_o character varying(50),
    grupodac_o character varying(50),
    fila character varying(128) DEFAULT ''::character varying,
    numero character varying(50),
    agente_d character varying(50),
    ramal_d character varying(4),
    usuario_d character varying(50),
    grupopabx_d character varying(50),
    grupodac_d character varying(50),
    duracao character varying(50),
    tipo character varying(20),
    obs character varying(128),
    diahora character varying(128),
    custom_01 character varying(128),
    custom_02 character varying(128),
    custom_03 character varying(128),
    custom_04 character varying(128),
    custom_05 character varying(128)
);


ALTER TABLE public.vm50_gravacoes_hoje OWNER TO postgres;

--
-- Name: vm50_grupo_de_campanhas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_grupo_de_campanhas (
    id integer NOT NULL,
    nome character varying(200),
    prioridade integer,
    tipo character varying(100)
);


ALTER TABLE public.vm50_grupo_de_campanhas OWNER TO postgres;

--
-- Name: vm50_grupos; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_grupos (
    id integer NOT NULL,
    nome character varying(50),
    minsaida smallint DEFAULT 10,
    maxsaida smallint DEFAULT 60,
    mininter smallint DEFAULT 10,
    maxinter smallint DEFAULT 60,
    minddr smallint DEFAULT 10,
    maxddr smallint DEFAULT 60,
    minfila smallint DEFAULT 10,
    maxfila smallint DEFAULT 60,
    maxlivre smallint DEFAULT 60,
    maxesddr smallint DEFAULT 60,
    maxeco smallint DEFAULT 60,
    maxmon smallint DEFAULT 60,
    minsai smallint DEFAULT 60,
    maxsai smallint DEFAULT 60,
    minate smallint DEFAULT 60,
    maxate smallint DEFAULT 60,
    adient smallint DEFAULT 60,
    adisai smallint DEFAULT 60,
    mincon smallint DEFAULT 60,
    maxcon smallint DEFAULT 60,
    entrarpausaauto boolean DEFAULT false,
    pausaautomatica character varying(100),
    tempodepausa integer DEFAULT 10,
    ignorarretiradapausaauto boolean DEFAULT false,
    ignorarentradapausaauto boolean DEFAULT false,
    classifica_chamadas character varying(2) DEFAULT '-'::character varying,
    tipo_painel_pa character varying DEFAULT 'comum'::character varying,
    popup_chamadas_entrantes boolean DEFAULT false,
    consultar_membros_filas boolean DEFAULT false,
    entrar_pausa_qualificacao boolean DEFAULT false,
    habEnvioWebservice boolean DEFAULT false
);


ALTER TABLE public.vm50_grupos OWNER TO postgres;

--
-- Name: vm50_grupos_campanhas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_grupos_campanhas (
    campanha character varying(250),
    prioridade integer,
    id integer NOT NULL,
    fk_grupo_campanha integer NOT NULL
);


ALTER TABLE public.vm50_grupos_campanhas OWNER TO postgres;

--
-- Name: vm50_grupos_captura; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_grupos_captura (
    id integer NOT NULL,
    id_asterisk bigint NOT NULL,
    nome character varying(100)
);


ALTER TABLE public.vm50_grupos_captura OWNER TO postgres;

--
-- Name: vm50_grupos_filas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_grupos_filas (
    grupo smallint NOT NULL,
    fila smallint NOT NULL
);


ALTER TABLE public.vm50_grupos_filas OWNER TO postgres;

--
-- Name: vm50_grupos_filas_relat; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_grupos_filas_relat (
    id integer NOT NULL,
    nome character varying(200)
);


ALTER TABLE public.vm50_grupos_filas_relat OWNER TO postgres;

--
-- Name: vm50_grupos_membros_ramais; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_grupos_membros_ramais (
    grupo smallint NOT NULL,
    ramal smallint NOT NULL
);


ALTER TABLE public.vm50_grupos_membros_ramais OWNER TO postgres;

--
-- Name: vm50_grupos_perso; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_grupos_perso (
    usuario bigint NOT NULL,
    ramal smallint NOT NULL
);


ALTER TABLE public.vm50_grupos_perso OWNER TO postgres;

--
-- Name: vm50_grupos_qualificacoes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_grupos_qualificacoes (
    id_grupo integer NOT NULL,
    id_classificacao integer NOT NULL
);


ALTER TABLE public.vm50_grupos_qualificacoes OWNER TO postgres;

--
-- Name: vm50_grupos_ramais; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_grupos_ramais (
    id integer NOT NULL,
    nome character varying(50)
);


ALTER TABLE public.vm50_grupos_ramais OWNER TO postgres;

--
-- Name: vm50_hosts_feixes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_hosts_feixes (
    id bigint NOT NULL,
    host character varying(20)
);


ALTER TABLE public.vm50_hosts_feixes OWNER TO postgres;

--
-- Name: vm50_integracao; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_integracao (
    id bigint NOT NULL,
    agente character(4) NOT NULL,
    grupo character varying(15) NOT NULL,
    codint integer DEFAULT 0,
    acao character(50),
    diahora timestamp without time zone
);


ALTER TABLE public.vm50_integracao OWNER TO postgres;

--
-- Name: vm50_ligacao_id; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_ligacao_id (
    id character varying(50) NOT NULL,
    numero character varying(50),
    canal character varying(50),
    obs character varying(50),
    conversou character(1),
    desistiu character(1) DEFAULT '0'::bpchar,
    gravacao character varying(200),
    canal_no character varying(50),
    falso character(1) DEFAULT '0'::bpchar,
    transfere character varying(50),
    mensagem character(1) DEFAULT '0'::bpchar,
    transferiu character(1)
);


ALTER TABLE public.vm50_ligacao_id OWNER TO postgres;

--
-- Name: vm50_link_ligacao; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_link_ligacao (
    id_orig character varying(50) NOT NULL,
    numero_orig character varying(50),
    id_dest character varying(50) DEFAULT ''::character varying NOT NULL,
    numero_dest character varying(50),
    pa character varying(20),
    estado character varying(50),
    tipo character(1),
    obs character varying(50),
    diahora timestamp without time zone,
    fila_original character varying(50),
    gravacao character varying(200),
    gravacao_nova character varying(200),
    diahora_ult_est timestamp without time zone,
    conversou character(1),
    mensagem character(1) DEFAULT '0'::bpchar
);


ALTER TABLE public.vm50_link_ligacao OWNER TO postgres;

--
-- Name: vm50_logins_relacionados; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_logins_relacionados (
    agente smallint NOT NULL,
    login smallint NOT NULL
);


ALTER TABLE public.vm50_logins_relacionados OWNER TO postgres;

--
-- Name: vm50_mensagens; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_mensagens (
    id bigint NOT NULL,
    origem character varying(20) DEFAULT ''::character varying NOT NULL,
    destino character varying(20) DEFAULT ''::character varying NOT NULL,
    data timestamp without time zone,
    mensagem character varying,
    status_leitura bit(1) DEFAULT B'0'::"bit"
);


ALTER TABLE public.vm50_mensagens OWNER TO postgres;

--
-- Name: vm50_metodos_login; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_metodos_login (
    id bigint NOT NULL,
    metodo character(1) DEFAULT '1'::bpchar
);


ALTER TABLE public.vm50_metodos_login OWNER TO postgres;

--
-- Name: vm50_mostra_oculta_agente_monitora; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_mostra_oculta_agente_monitora (
    id bigint NOT NULL,
    ramal_supervisor character varying(100) DEFAULT ''::character varying,
    agente character varying(100) DEFAULT ''::character varying
);


ALTER TABLE public.vm50_mostra_oculta_agente_monitora OWNER TO postgres;

--
-- Name: vm50_orbitas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_orbitas (
    orbita character varying(50) NOT NULL,
    id character varying(50),
    numero character varying(50),
    mesa integer
);


ALTER TABLE public.vm50_orbitas OWNER TO postgres;

--
-- Name: vm50_pausas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_pausas (
    id integer NOT NULL,
    nome character varying(50),
    tempomax smallint DEFAULT 15,
    tipo character(1) DEFAULT 'I'::bpchar,
    retirarauto boolean DEFAULT false NOT NULL,
    temporetirada integer DEFAULT 0 NOT NULL,
    cormonitpa character varying(6) DEFAULT 'FF9115'::character varying NOT NULL,
    habilitaparapa boolean DEFAULT false NOT NULL
);


ALTER TABLE public.vm50_pausas OWNER TO postgres;

--
-- Name: vm50_pausas_grupos; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_pausas_grupos (
    id_grupo bigint NOT NULL,
    id_pausa bigint NOT NULL
);


ALTER TABLE public.vm50_pausas_grupos OWNER TO postgres;

--
-- Name: vm50_periodos; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_periodos (
    id integer NOT NULL,
    perd character(5),
    pera character(5)
);


ALTER TABLE public.vm50_periodos OWNER TO postgres;

--
-- Name: vm50_permissao; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_permissao (
    id bigint NOT NULL,
    administrador boolean,
    pbx_troncos boolean,
    pbx_feixes boolean,
    pbx_placas boolean,
    pbx_ramais boolean,
    pbx_grupo_ramais boolean,
    pbx_facilidades boolean,
    cc_agentes boolean,
    cc_grupos boolean,
    cc_filas boolean,
    cc_pausas boolean,
    cc_periodos boolean,
    cc_monit_tudo boolean,
    cc_monit_seu_gru boolean,
    cc_monit_all_gru boolean,
    cc_monit_sua_fil boolean,
    cc_monit_all_fil boolean,
    cc_relat_tudo boolean,
    cc_relat_seu_gru boolean,
    cc_relat_all_gru boolean,
    cc_relat_sua_fil boolean,
    cc_relat_all_fil boolean,
    cc_relat_feixes boolean,
    cc_grafi_tudo boolean,
    cc_grafi_seu_gru boolean,
    cc_grafi_all_gru boolean,
    cc_grafi_sua_fil boolean,
    cc_grafi_all_fil boolean,
    cc_grafi_feixes boolean,
    gravacao_relat boolean,
    cc_classifica boolean,
    pbx_gravacao boolean,
    discador_cad boolean DEFAULT false,
    discador boolean DEFAULT false,
    discador_moni boolean DEFAULT false,
    discador_param boolean DEFAULT false,
    discador_gerencia boolean DEFAULT false,
    pbx_grupo_troncos boolean DEFAULT false,
    cc_utils boolean DEFAULT false,
    cc_mensagem boolean DEFAULT false,
    pbx_ramais_auxiliares boolean DEFAULT false,
    pbx_ramais_fha boolean DEFAULT false,
    discador_utils boolean DEFAULT false,
    pbx_cad_extensoes boolean DEFAULT false,
    discador_grupo_camp boolean DEFAULT false,
    discador_gerencia_campanhas boolean DEFAULT false,
    discador_agenda_campanhas boolean DEFAULT false,
    pbx_monitoramento boolean DEFAULT false,
    pbx_grupos_captura boolean DEFAULT false,
    cc_config_syonet boolean DEFAULT false,
    cc_filas_syonet boolean DEFAULT false,
    crm_cad_vend boolean DEFAULT false,
    crm_cad_cli boolean DEFAULT false,
    crm_cad_cam boolean DEFAULT false,
    cc_painel_pa boolean DEFAULT false,
    cc_conf_email boolean DEFAULT false,
    cc_grupo_filas_relatorio boolean DEFAULT false,
    pecas boolean DEFAULT false
);


ALTER TABLE public.vm50_permissao OWNER TO postgres;

--
-- Name: vm50_placas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_placas (
    id integer NOT NULL,
    numero smallint,
    fabricante fabrica DEFAULT 'DGV'::fabrica,
    modelo modelos_placa DEFAULT '4FXO'::modelos_placa
);


ALTER TABLE public.vm50_placas OWNER TO postgres;

--
-- Name: vm50_ramais; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_ramais (
    id bigint NOT NULL,
    ramal character(4) NOT NULL,
    endereco character varying(15) NOT NULL,
    nomecomplet character varying(80) DEFAULT ''::character varying,
    pseudonimo character varying(80) DEFAULT ''::character varying,
    canal character varying(9) DEFAULT 'SIP'::character varying,
    dispositivo character varying(80) DEFAULT 'Softphone'::character varying,
    fabricante character varying(80) DEFAULT ''::character varying,
    modelo character varying(80) DEFAULT ''::character varying,
    host character varying(31) DEFAULT ''::character varying,
    tipo character varying(6) DEFAULT ''::character varying,
    call_limit smallint,
    callgroup character varying(50) DEFAULT NULL::character varying,
    callerid character varying(80) DEFAULT NULL::character varying,
    contexto character varying(80) DEFAULT 'restrito'::character varying,
    dtmfmode character varying(7) DEFAULT NULL::character varying,
    pickupgroup character varying(50) DEFAULT NULL::character varying,
    senha character varying(80) DEFAULT NULL::character varying,
    username character varying(80) DEFAULT ''::character varying NOT NULL,
    grupo smallint,
    situacao character(1) DEFAULT 'U'::bpchar,
    falandocom character varying(80) DEFAULT NULL::character varying,
    direcao character(1) DEFAULT ''::bpchar,
    numeroaster character varying(80) DEFAULT ''::character varying,
    faloucom character varying(80) DEFAULT NULL::character varying,
    subscribecontext character varying(80) DEFAULT ''::character varying,
    statusmail character varying(5) DEFAULT 'no'::character varying,
    mailbox character varying(80) DEFAULT ''::character varying,
    chat integer DEFAULT 0,
    ramal_pa character(1) DEFAULT '1'::bpchar,
    status_arq1 bit(1),
    status_arq2 bit(1),
    servico_vnc character varying(20) DEFAULT '-none-'::character varying,
    can_reinvite boolean DEFAULT false,
    qualify boolean DEFAULT true,
    denny character varying(100),
    permit character varying(100),
    nat boolean DEFAULT false,
    notificarsyonet boolean DEFAULT false
);


ALTER TABLE public.vm50_ramais OWNER TO postgres;

--
-- Name: vm50_ramais_luzes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_ramais_luzes (
    id bigint NOT NULL,
    ramal character(4) NOT NULL,
    cadeado smallint DEFAULT 0,
    voicemail smallint DEFAULT 0,
    ausente smallint DEFAULT 0,
    noturno smallint DEFAULT 0,
    mudo smallint DEFAULT 0,
    autoatendimento smallint DEFAULT 0,
    sigamesempre smallint DEFAULT 0,
    sigamesenaoatende smallint DEFAULT 0,
    sigameseocupado smallint DEFAULT 0,
    auxiliar smallint DEFAULT 0
);


ALTER TABLE public.vm50_ramais_luzes OWNER TO postgres;

--
-- Name: vm50_ramais_relacionados; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_ramais_relacionados (
    id integer NOT NULL,
    pai integer NOT NULL,
    ramal integer NOT NULL
);


ALTER TABLE public.vm50_ramais_relacionados OWNER TO postgres;

--
-- Name: vm50_relatorio_agentes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_relatorio_agentes (
    id integer NOT NULL,
    data timestamp without time zone,
    nome character varying(50),
    login character(4),
    grupo character varying(50)
);


ALTER TABLE public.vm50_relatorio_agentes OWNER TO postgres;

--
-- Name: vm50_relatorio_grupos; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_relatorio_grupos (
    id integer NOT NULL,
    data timestamp without time zone,
    grupoid integer,
    grupo character varying(50),
    agente character varying(50),
    login character(4)
);


ALTER TABLE public.vm50_relatorio_grupos OWNER TO postgres;

--
-- Name: vm50_relatorios_cc; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_relatorios_cc (
    id bigint NOT NULL,
    diahora timestamp without time zone,
    agente character varying(55),
    fila character varying(50),
    ligacao character varying(50),
    numero character varying(50),
    oque character varying(50),
    funcai character varying(50),
    loginr character varying(150),
    grupos character varying(150),
    canalext character varying(50),
    canalint character varying(50),
    campo_lido boolean DEFAULT false
);


ALTER TABLE public.vm50_relatorios_cc OWNER TO postgres;

--
-- Name: vm50_relatorios_cc_grupo; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_relatorios_cc_grupo (
    id bigint NOT NULL,
    grupoid integer,
    grupo character varying(50),
    agente character varying(50),
    login character(4),
    funcai character varying(50),
    data timestamp without time zone
);


ALTER TABLE public.vm50_relatorios_cc_grupo OWNER TO postgres;

--
-- Name: vm50_relatorios_cc_hoje; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_relatorios_cc_hoje (
    id bigint NOT NULL,
    diahora timestamp without time zone,
    agente character varying(55),
    fila character varying(50),
    ligacao character varying(50),
    numero character varying(50),
    oque character varying(50),
    funcai character varying(50),
    loginr character varying(150),
    grupos character varying(150),
    canalext character varying(50),
    canalint character varying(50)
);


ALTER TABLE public.vm50_relatorios_cc_hoje OWNER TO postgres;

--
-- Name: vm50_relatorios_pbx; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_relatorios_pbx (
    id bigint NOT NULL,
    diahora timestamp without time zone,
    ligaca_o character varying(50),
    numero_o character varying(50),
    canal_o character varying(50),
    ligaca_d character varying(50),
    numero_d character varying(50),
    canal_d character varying(50),
    oque character varying(50),
    direcao character(1)
);


ALTER TABLE public.vm50_relatorios_pbx OWNER TO postgres;

--
-- Name: vm50_relatorios_pbx_hoje; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_relatorios_pbx_hoje (
    id bigint NOT NULL,
    diahora timestamp without time zone,
    ligaca_o character varying(50),
    numero_o character varying(50),
    canal_o character varying(50),
    ligaca_d character varying(50),
    numero_d character varying(50),
    canal_d character varying(50),
    oque character varying(50),
    direcao character(1)
);


ALTER TABLE public.vm50_relatorios_pbx_hoje OWNER TO postgres;

--
-- Name: vm50_troncos; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_troncos (
    id integer NOT NULL,
    numero_asterisk character varying(128) DEFAULT NULL::character varying,
    numero_vdt character varying(128) DEFAULT NULL::character varying,
    descricao character varying(128) DEFAULT NULL::character varying,
    numero_linha character varying(128) DEFAULT NULL::character varying,
    operadora character varying(128) DEFAULT NULL::character varying,
    sinalizacao character varying(20) DEFAULT NULL::character varying,
    placa_numero smallint,
    placa_ordem character varying(12) DEFAULT NULL::character varying,
    feixe smallint,
    situacao character(1) DEFAULT 'L'::bpchar,
    direcao character(1) DEFAULT ''::bpchar,
    id_externo character varying(50) DEFAULT NULL::character varying,
    numeroexterno character varying(50) DEFAULT NULL::character varying,
    id_interno character varying(50) DEFAULT NULL::character varying,
    numerointerno character varying(50) DEFAULT NULL::character varying,
    canal_asterisk character varying(50) DEFAULT NULL::character varying,
    id_grupo_tronco integer
);


ALTER TABLE public.vm50_troncos OWNER TO postgres;

--
-- Name: vm50_troncos_remotos; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_troncos_remotos (
    id integer NOT NULL,
    numero_asterisk character varying(128) DEFAULT NULL::character varying,
    numero_vdt character varying(128) DEFAULT NULL::character varying,
    descricao character varying(128) DEFAULT NULL::character varying,
    numero_linha character varying(128) DEFAULT NULL::character varying,
    operadora character varying(128) DEFAULT NULL::character varying,
    sinalizacao character varying(20) DEFAULT NULL::character varying,
    placa_numero smallint,
    placa_ordem character varying(12) DEFAULT NULL::character varying,
    feixe smallint,
    situacao character(1) DEFAULT 'L'::bpchar,
    direcao character(1) DEFAULT ''::bpchar,
    id_externo character varying(50) DEFAULT NULL::character varying,
    numeroexterno character varying(50) DEFAULT NULL::character varying,
    id_interno character varying(50) DEFAULT NULL::character varying,
    numerointerno character varying(50) DEFAULT NULL::character varying,
    canal_asterisk character varying(50) DEFAULT NULL::character varying,
    id_grupo_tronco integer
);


ALTER TABLE public.vm50_troncos_remotos OWNER TO postgres;

--
-- Name: vm50_turnos_agentes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_turnos_agentes (
    id integer NOT NULL,
    agente smallint,
    dia_sem character(3),
    de character(5),
    aa character(5),
    nom character varying(50)
);


ALTER TABLE public.vm50_turnos_agentes OWNER TO postgres;

--
-- Name: vm50_turnos_filas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_turnos_filas (
    id integer NOT NULL,
    fila smallint,
    dia_sem character(3),
    de character(5),
    aa character(5),
    nom character varying(50)
);


ALTER TABLE public.vm50_turnos_filas OWNER TO postgres;

--
-- Name: vm50_turnos_usuarios; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_turnos_usuarios (
    id integer NOT NULL,
    usuario smallint,
    dia_sem character(3),
    de character(5),
    aa character(5),
    nom character varying(50)
);


ALTER TABLE public.vm50_turnos_usuarios OWNER TO postgres;

--
-- Name: vm50_turnosmesa; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_turnosmesa (
    ramal integer NOT NULL,
    fha smallint
);


ALTER TABLE public.vm50_turnosmesa OWNER TO postgres;

--
-- Name: vm50_usuarios; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_usuarios (
    id bigint NOT NULL,
    nome character varying(50),
    nomecompleto character varying(128),
    senha character varying(40),
    lingua character varying(3),
    email character varying(60),
    ramal integer,
    tipo character(2),
    licenca character varying(100),
    qteatendidas integer,
    qterealizaat integer,
    qterealizana integer,
    sipproxy character varying(100),
    labelramal integer DEFAULT 0 NOT NULL,
    cororbita character varying(6) DEFAULT 'FF0000'::character varying NOT NULL,
    numeromesa integer DEFAULT 1,
    tipo_monitoramento integer DEFAULT 0,
    troncos_remotos boolean DEFAULT false,
    mostrar_webphone boolean DEFAULT true,
    mostrar_orbitas boolean DEFAULT true,
    registra_sipproxy boolean DEFAULT true,
    ramal_externo boolean DEFAULT false,
    login_mesa character varying(4),
    ip_discagem character varying(100)
);


ALTER TABLE public.vm50_usuarios OWNER TO postgres;

--
-- Name: vm50_usuarios_filas; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_usuarios_filas (
    usuario smallint NOT NULL,
    fila smallint NOT NULL
);


ALTER TABLE public.vm50_usuarios_filas OWNER TO postgres;

--
-- Name: vm50_usuarios_grupos; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_usuarios_grupos (
    usuario smallint NOT NULL,
    grupo smallint NOT NULL
);


ALTER TABLE public.vm50_usuarios_grupos OWNER TO postgres;

--
-- Name: vm50_usuarios_ramais; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE vm50_usuarios_ramais (
    usuario smallint NOT NULL,
    ramal smallint NOT NULL
);


ALTER TABLE public.vm50_usuarios_ramais OWNER TO postgres;

SET search_path = realtime, pg_catalog;

--
-- Name: extensions_conf; Type: TABLE; Schema: realtime; Owner: postgres; Tablespace: 
--

CREATE TABLE extensions_conf (
    id integer NOT NULL,
    context character varying(20) DEFAULT ''::character varying NOT NULL,
    exten character varying(20) DEFAULT ''::character varying NOT NULL,
    priority smallint DEFAULT 0 NOT NULL,
    app character varying(20) DEFAULT ''::character varying NOT NULL,
    appdata character varying(128)
);


ALTER TABLE realtime.extensions_conf OWNER TO postgres;

--
-- Name: queue_member_table; Type: TABLE; Schema: realtime; Owner: postgres; Tablespace: 
--

CREATE TABLE queue_member_table (
    queue_name character varying(128) NOT NULL,
    interface character varying(128) NOT NULL,
    penalty bigint,
    membername character varying(128) DEFAULT NULL::character varying,
    id integer NOT NULL
);


ALTER TABLE realtime.queue_member_table OWNER TO postgres;

--
-- Name: queues_table; Type: TABLE; Schema: realtime; Owner: postgres; Tablespace: 
--

CREATE TABLE queues_table (
    name character varying(128) NOT NULL,
    musiconhold character varying(128) DEFAULT 'default'::character varying,
    announce character varying(128),
    context character varying(128),
    timeout bigint,
    monitor_join boolean,
    monitor_format character varying(128),
    queue_youarenext character varying(128),
    queue_thereare character varying(128),
    queue_callswaiting character varying(128),
    queue_holdtime character varying(128),
    queue_minutes character varying(128),
    queue_seconds character varying(128),
    queue_lessthan character varying(128),
    queue_thankyou character varying(128),
    queue_reporthold character varying(128),
    announce_frequency bigint,
    announce_round_seconds bigint,
    announce_holdtime character varying(128),
    retry bigint,
    wrapuptime bigint,
    maxlen bigint,
    servicelevel bigint,
    strategy character varying(128),
    joinempty character varying(128),
    leavewhenempty character varying(128),
    eventmemberstatus boolean,
    eventwhencalled boolean,
    reportholdtime boolean,
    memberdelay bigint,
    weight bigint,
    timeoutrestart boolean,
    setinterfacevar boolean
);


ALTER TABLE realtime.queues_table OWNER TO postgres;

--
-- Name: sip_ramal; Type: TABLE; Schema: realtime; Owner: postgres; Tablespace: 
--

CREATE TABLE sip_ramal (
    cod_id bigint NOT NULL,
    id_sip_ramal integer NOT NULL,
    name character varying(80) DEFAULT ''::character varying NOT NULL,
    host character varying(31) DEFAULT ''::character varying NOT NULL,
    username character varying(80) DEFAULT ''::character varying NOT NULL,
    secret character varying(80),
    type character varying(80) DEFAULT 'friend'::character varying NOT NULL,
    ipaddr character varying(80) DEFAULT ''::character varying NOT NULL,
    port integer DEFAULT 0 NOT NULL,
    regseconds numeric DEFAULT 0 NOT NULL,
    context character varying(80) DEFAULT ''::character varying NOT NULL,
    lastms character varying(80) DEFAULT ''::character varying NOT NULL,
    nat character varying(5) DEFAULT 'yes'::character varying,
    dtmfmode character varying(80) DEFAULT 'auto'::character varying NOT NULL,
    call_limit integer
);


ALTER TABLE realtime.sip_ramal OWNER TO postgres;

SET search_path = public, pg_catalog;

--
-- Name: altera_grupo_vm50_config_geral(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION altera_grupo_vm50_config_geral() RETURNS trigger
    AS $$
DECLARE 
BEGIN
  UPDATE vm50_config_geral SET grupo = NEW.nome WHERE grupo = OLD.nome;
  RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.altera_grupo_vm50_config_geral() OWNER TO postgres;

--
-- Name: apaga_grupo_vm50_config_geral(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION apaga_grupo_vm50_config_geral() RETURNS trigger
    AS $$
DECLARE 
BEGIN
  DELETE FROM vm50_config_geral WHERE grupo = OLD.nome;
  RETURN OLD;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.apaga_grupo_vm50_config_geral() OWNER TO postgres;

--
-- Name: cria_tronco(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION cria_tronco() RETURNS integer
    AS $$
DECLARE 
       i integer;     
       qtd integer;
       tronco integer;  
BEGIN
qtd := 500;
FOR i in 1..qtd
LOOP
        tronco := i + qtd;
	INSERT INTO vm50_troncos (numero_asterisk, numero_vdt, descricao, sinalizacao)
	VALUES ('SIP/sipp',tronco,'Tronco ' || tronco,'SIP');
END LOOP; 
return 1;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.cria_tronco() OWNER TO postgres;

--
-- Name: dblink(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink(text, text) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_record'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink(text, text) OWNER TO postgres;

--
-- Name: dblink(text, text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink(text, text, boolean) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_record'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink(text, text, boolean) OWNER TO postgres;

--
-- Name: dblink(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink(text) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_record'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink(text) OWNER TO postgres;

--
-- Name: dblink(text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink(text, boolean) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_record'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink(text, boolean) OWNER TO postgres;

--
-- Name: dblink_build_sql_delete(text, int2vector, integer, text[]); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_build_sql_delete(text, int2vector, integer, text[]) RETURNS text
    AS '$libdir/dblink', 'dblink_build_sql_delete'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_build_sql_delete(text, int2vector, integer, text[]) OWNER TO postgres;

--
-- Name: dblink_build_sql_insert(text, int2vector, integer, text[], text[]); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_build_sql_insert(text, int2vector, integer, text[], text[]) RETURNS text
    AS '$libdir/dblink', 'dblink_build_sql_insert'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_build_sql_insert(text, int2vector, integer, text[], text[]) OWNER TO postgres;

--
-- Name: dblink_build_sql_update(text, int2vector, integer, text[], text[]); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_build_sql_update(text, int2vector, integer, text[], text[]) RETURNS text
    AS '$libdir/dblink', 'dblink_build_sql_update'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_build_sql_update(text, int2vector, integer, text[], text[]) OWNER TO postgres;

--
-- Name: dblink_cancel_query(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_cancel_query(text) RETURNS text
    AS '$libdir/dblink', 'dblink_cancel_query'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_cancel_query(text) OWNER TO postgres;

--
-- Name: dblink_close(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_close(text) RETURNS text
    AS '$libdir/dblink', 'dblink_close'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_close(text) OWNER TO postgres;

--
-- Name: dblink_close(text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_close(text, boolean) RETURNS text
    AS '$libdir/dblink', 'dblink_close'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_close(text, boolean) OWNER TO postgres;

--
-- Name: dblink_close(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_close(text, text) RETURNS text
    AS '$libdir/dblink', 'dblink_close'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_close(text, text) OWNER TO postgres;

--
-- Name: dblink_close(text, text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_close(text, text, boolean) RETURNS text
    AS '$libdir/dblink', 'dblink_close'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_close(text, text, boolean) OWNER TO postgres;

--
-- Name: dblink_connect(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_connect(text) RETURNS text
    AS '$libdir/dblink', 'dblink_connect'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_connect(text) OWNER TO postgres;

--
-- Name: dblink_connect(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_connect(text, text) RETURNS text
    AS '$libdir/dblink', 'dblink_connect'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_connect(text, text) OWNER TO postgres;

--
-- Name: dblink_connect_u(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_connect_u(text) RETURNS text
    AS '$libdir/dblink', 'dblink_connect'
    LANGUAGE c STRICT SECURITY DEFINER;


ALTER FUNCTION public.dblink_connect_u(text) OWNER TO postgres;

--
-- Name: dblink_connect_u(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_connect_u(text, text) RETURNS text
    AS '$libdir/dblink', 'dblink_connect'
    LANGUAGE c STRICT SECURITY DEFINER;


ALTER FUNCTION public.dblink_connect_u(text, text) OWNER TO postgres;

--
-- Name: dblink_current_query(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_current_query() RETURNS text
    AS '$libdir/dblink', 'dblink_current_query'
    LANGUAGE c;


ALTER FUNCTION public.dblink_current_query() OWNER TO postgres;

--
-- Name: dblink_disconnect(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_disconnect() RETURNS text
    AS '$libdir/dblink', 'dblink_disconnect'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_disconnect() OWNER TO postgres;

--
-- Name: dblink_disconnect(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_disconnect(text) RETURNS text
    AS '$libdir/dblink', 'dblink_disconnect'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_disconnect(text) OWNER TO postgres;

--
-- Name: dblink_error_message(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_error_message(text) RETURNS text
    AS '$libdir/dblink', 'dblink_error_message'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_error_message(text) OWNER TO postgres;

--
-- Name: dblink_exec(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_exec(text, text) RETURNS text
    AS '$libdir/dblink', 'dblink_exec'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_exec(text, text) OWNER TO postgres;

--
-- Name: dblink_exec(text, text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_exec(text, text, boolean) RETURNS text
    AS '$libdir/dblink', 'dblink_exec'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_exec(text, text, boolean) OWNER TO postgres;

--
-- Name: dblink_exec(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_exec(text) RETURNS text
    AS '$libdir/dblink', 'dblink_exec'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_exec(text) OWNER TO postgres;

--
-- Name: dblink_exec(text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_exec(text, boolean) RETURNS text
    AS '$libdir/dblink', 'dblink_exec'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_exec(text, boolean) OWNER TO postgres;

--
-- Name: dblink_fetch(text, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_fetch(text, integer) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_fetch'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_fetch(text, integer) OWNER TO postgres;

--
-- Name: dblink_fetch(text, integer, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_fetch(text, integer, boolean) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_fetch'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_fetch(text, integer, boolean) OWNER TO postgres;

--
-- Name: dblink_fetch(text, text, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_fetch(text, text, integer) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_fetch'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_fetch(text, text, integer) OWNER TO postgres;

--
-- Name: dblink_fetch(text, text, integer, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_fetch(text, text, integer, boolean) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_fetch'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_fetch(text, text, integer, boolean) OWNER TO postgres;

--
-- Name: dblink_get_connections(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_get_connections() RETURNS text[]
    AS '$libdir/dblink', 'dblink_get_connections'
    LANGUAGE c;


ALTER FUNCTION public.dblink_get_connections() OWNER TO postgres;

--
-- Name: dblink_get_pkey(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_get_pkey(text) RETURNS SETOF dblink_pkey_results
    AS '$libdir/dblink', 'dblink_get_pkey'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_get_pkey(text) OWNER TO postgres;

--
-- Name: dblink_get_result(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_get_result(text) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_get_result'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_get_result(text) OWNER TO postgres;

--
-- Name: dblink_get_result(text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_get_result(text, boolean) RETURNS SETOF record
    AS '$libdir/dblink', 'dblink_get_result'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_get_result(text, boolean) OWNER TO postgres;

--
-- Name: dblink_is_busy(text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_is_busy(text) RETURNS integer
    AS '$libdir/dblink', 'dblink_is_busy'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_is_busy(text) OWNER TO postgres;

--
-- Name: dblink_open(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_open(text, text) RETURNS text
    AS '$libdir/dblink', 'dblink_open'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_open(text, text) OWNER TO postgres;

--
-- Name: dblink_open(text, text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_open(text, text, boolean) RETURNS text
    AS '$libdir/dblink', 'dblink_open'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_open(text, text, boolean) OWNER TO postgres;

--
-- Name: dblink_open(text, text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_open(text, text, text) RETURNS text
    AS '$libdir/dblink', 'dblink_open'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_open(text, text, text) OWNER TO postgres;

--
-- Name: dblink_open(text, text, text, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_open(text, text, text, boolean) RETURNS text
    AS '$libdir/dblink', 'dblink_open'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_open(text, text, text, boolean) OWNER TO postgres;

--
-- Name: dblink_send_query(text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION dblink_send_query(text, text) RETURNS integer
    AS '$libdir/dblink', 'dblink_send_query'
    LANGUAGE c STRICT;


ALTER FUNCTION public.dblink_send_query(text, text) OWNER TO postgres;

--
-- Name: grava_grupo_vm50_config_geral(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION grava_grupo_vm50_config_geral() RETURNS trigger
    AS $$
DECLARE 
BEGIN
  INSERT INTO vm50_config_geral (grupo) VALUES(NEW.nome);
  RETURN NEW;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.grava_grupo_vm50_config_geral() OWNER TO postgres;

--
-- Name: strip_all_triggers(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION strip_all_triggers() RETURNS text
    AS $$ DECLARE
    triggNameRecord RECORD;
    triggTableRecord RECORD;
BEGIN
    FOR triggNameRecord IN select distinct(trigger_name) from information_schema.triggers where trigger_schema = 'public' LOOP
        FOR triggTableRecord IN SELECT distinct(event_object_table) from information_schema.triggers where trigger_name = triggNameRecord.trigger_name LOOP
            RAISE NOTICE 'Dropping trigger: % on table: %', triggNameRecord.trigger_name, triggTableRecord.event_object_table;
            EXECUTE 'DROP TRIGGER ' || triggNameRecord.trigger_name || ' ON ' || triggTableRecord.event_object_table || ';';
        END LOOP;
    END LOOP;

    RETURN 'done';
END;
$$
    LANGUAGE plpgsql SECURITY DEFINER;


ALTER FUNCTION public.strip_all_triggers() OWNER TO postgres;

--
-- Name: table_log_init(integer, text, text, text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION table_log_init(integer, text, text, text, text) RETURNS void
    AS $_$
DECLARE
    level        ALIAS FOR $1;
    orig_schema  ALIAS FOR $2;
    orig_name    ALIAS FOR $3;
    log_schema   ALIAS FOR $4;
    log_name     ALIAS FOR $5;
    do_log_user  int = 0;
    level_create text = '';
    orig_qq      text;
    log_qq       text;
BEGIN
    -- Quoted qualified names
    orig_qq := quote_ident(orig_schema)||'.'||quote_ident(orig_name);
    log_qq := quote_ident(log_schema)||'.'||quote_ident(log_name);

    IF level <> 3 THEN
        level_create := level_create
            ||', trigger_id BIGSERIAL NOT NULL PRIMARY KEY';
        IF level <> 4 THEN
            level_create := level_create
                ||', trigger_user VARCHAR(32) NOT NULL';
            do_log_user := 1;
            IF level <> 5 THEN
                RAISE EXCEPTION 
                    'table_log_init: First arg has to be 3, 4 or 5.';
            END IF;
        END IF;
    END IF;
    
    EXECUTE 'CREATE TABLE '||log_qq
          ||'(LIKE '||orig_qq
          ||', trigger_mode VARCHAR(10) NOT NULL'
          ||', trigger_tuple VARCHAR(5) NOT NULL'
          ||', trigger_changed TIMESTAMPTZ NOT NULL'
          ||level_create
          ||')';
            
    EXECUTE 'CREATE TRIGGER "table_log_trigger" AFTER UPDATE OR INSERT OR DELETE ON '
          ||orig_qq||' FOR EACH ROW EXECUTE PROCEDURE table_log('
          ||quote_literal(log_name)||','
          ||do_log_user||','
          ||quote_literal(log_schema)||')';

    RETURN;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.table_log_init(integer, text, text, text, text) OWNER TO postgres;

--
-- Name: table_log_init(integer, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION table_log_init(integer, text) RETURNS void
    AS $_$
DECLARE
    level        ALIAS FOR $1;
    orig_name    ALIAS FOR $2;
BEGIN
    PERFORM table_log_init(level, orig_name, current_schema());
    RETURN;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.table_log_init(integer, text) OWNER TO postgres;

--
-- Name: table_log_init(integer, text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION table_log_init(integer, text, text) RETURNS void
    AS $_$
DECLARE
    level        ALIAS FOR $1;
    orig_name    ALIAS FOR $2;
    log_schema   ALIAS FOR $3;
BEGIN
    PERFORM table_log_init(level, current_schema(), orig_name, log_schema);
    RETURN;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.table_log_init(integer, text, text) OWNER TO postgres;

--
-- Name: table_log_init(integer, text, text, text); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION table_log_init(integer, text, text, text) RETURNS void
    AS $_$
DECLARE
    level        ALIAS FOR $1;
    orig_schema  ALIAS FOR $2;
    orig_name    ALIAS FOR $3;
    log_schema   ALIAS FOR $4;
BEGIN
    PERFORM table_log_init(level, orig_schema, orig_name, log_schema,
        CASE WHEN orig_schema=log_schema 
            THEN orig_name||'_log' ELSE orig_name END);
    RETURN;
END;
$_$
    LANGUAGE plpgsql;


ALTER FUNCTION public.table_log_init(integer, text, text, text) OWNER TO postgres;

--
-- Name: teste(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION teste() RETURNS integer
    AS $$
DECLARE 
        i integer;
BEGIN
FOR i in (SELECT id FROM vm50_ramais order by id desc LIMIT 10)
LOOP
	update vm50_ramais set servico_vnc = i where id = i ;
END LOOP;
return 1;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.teste() OWNER TO postgres;

--
-- Name: vm50_alterar_gravacoes(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION vm50_alterar_gravacoes() RETURNS trigger
    AS $$DECLARE 
BEGIN
  UPDATE vm50_gravacoes SET gravacao = NEW.gravacao, 
  dia = NEW.dia, hora = NEW.hora, agente_o = NEW.agente_o, 
  ramal_o = NEW.ramal_o, usuario_o = NEW.usuario_o, grupopabx_o = NEW.grupopabx_o, 
  grupodac_o = NEW.grupodac_o, fila = NEW.fila, numero = NEW.numero, 
  agente_d = NEW.agente_d, ramal_d = NEW.ramal_d, usuario_d = NEW.usuario_d, 
  grupopabx_d = NEW.grupopabx_d, grupodac_d = NEW.grupodac_d, duracao = NEW.duracao, 
  tipo = NEW.tipo, obs = NEW.obs, diahora = NEW.diahora, 
  custom_01 = NEW.custom_01, custom_02 = NEW.custom_02, custom_03 = NEW.custom_03, 
  custom_04 = NEW.custom_04, custom_05 = NEW.custom_05 WHERE id_ligacao = NEW.id_ligacao;
  RETURN NEW;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.vm50_alterar_gravacoes() OWNER TO postgres;

--
-- Name: vm50_amarra_conversou(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION vm50_amarra_conversou() RETURNS trigger
    AS $$
  DECLARE
    conversa VARCHAR;
  BEGIN
    SELECT INTO conversa conversou FROM vm50_link_ligacao WHERE id_orig=NEW.id OR id_dest=NEW.id;
    IF FOUND THEN
      IF (conversa = '0') THEN
        UPDATE vm50_link_ligacao SET conversou = NEW.conversou WHERE id_orig=NEW.id OR id_dest=NEW.id;
      END IF;
    END IF;
    RETURN NEW;
  END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.vm50_amarra_conversou() OWNER TO postgres;

--
-- Name: vm50_amarra_em_conversacao(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION vm50_amarra_em_conversacao() RETURNS trigger
    AS $$
  DECLARE
    conversa VARCHAR;
  BEGIN
    IF (NEW.estado = 'Em conversa&ccedil;&atilde;o') THEN
      NEW.conversou = '1';
    END IF;
    RETURN NEW;
  END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.vm50_amarra_em_conversacao() OWNER TO postgres;

--
-- Name: vm50_inserir_gravacoes(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION vm50_inserir_gravacoes() RETURNS trigger
    AS $$DECLARE 
BEGIN
  INSERT INTO vm50_gravacoes (id_ligacao, gravacao, dia, hora, agente_o, ramal_o, usuario_o, grupopabx_o, grupodac_o, fila, numero, agente_d, ramal_d, usuario_d, grupopabx_d, grupodac_d, duracao, tipo, obs, diahora, custom_01, custom_02, custom_03, custom_04, custom_05) 
  VALUES(NEW.id_ligacao, NEW.gravacao, NEW.dia, NEW.hora, NEW.agente_o, NEW.ramal_o, NEW.usuario_o, NEW.grupopabx_o, NEW.grupodac_o, NEW.fila, NEW.numero, NEW.agente_d, NEW.ramal_d, NEW.usuario_d, NEW.grupopabx_d, NEW.grupodac_d, NEW.duracao, NEW.tipo, NEW.obs, NEW.diahora, NEW.custom_01, NEW.custom_02, NEW.custom_03, NEW.custom_04, NEW.custom_05);
  RETURN NEW;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.vm50_inserir_gravacoes() OWNER TO postgres;

--
-- Name: vm50_limpa_ligacoes(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION vm50_limpa_ligacoes() RETURNS integer
    AS $$
  --
  -- Deleta dados do vm50_link_ligacoes
  --
 BEGIN
  DELETE FROM vm50_link_ligacoes;
  RETURN 0;
 END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.vm50_limpa_ligacoes() OWNER TO postgres;

--
-- Name: vm50_mudou_estado_mudou_hora(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION vm50_mudou_estado_mudou_hora() RETURNS trigger
    AS $$
  DECLARE
    id_number INTEGER;

  BEGIN
    IF (NEW.estado != OLD.estado) THEN
      NEW.diahora_ult_est := 'now';
    ELSE
      IF (NEW.numero_orig != OLD.numero_orig) THEN
        NEW.diahora_ult_est := 'now';
      ELSE
        IF (NEW.numero_dest != OLD.numero_dest) THEN
          NEW.diahora_ult_est := 'now';
        END IF;
      END IF;
    END IF;
    RETURN NEW;
  END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.vm50_mudou_estado_mudou_hora() OWNER TO postgres;

--
-- Name: vm50_nao_insere_duplicatas(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION vm50_nao_insere_duplicatas() RETURNS trigger
    AS $$
DECLARE
id_number INTEGER;
numero_chamando VARCHAR;
nome_fila VARCHAR;
nome_pausa VARCHAR;
nome_tronco VARCHAR;
dados_agente RECORD;
BEGIN

--
-- Descobre o nome do agente
--
SELECT INTO dados_agente * FROM vm50_agentes WHERE login=NEW.agente;
IF ((NOT FOUND) OR (NEW.agente = '')) THEN
IF (NEW.fila = 'FILA') THEN
NEW.fila := NEW.numero;
NEW.agente := '0000';
NEW.numero := '';
SELECT INTO numero_chamando numero_orig FROM vm50_link_ligacao WHERE id_orig=NEW.ligacao OR id_dest=NEW.ligacao;
IF FOUND THEN
NEW.numero := numero_chamando;
END IF;
SELECT INTO nome_fila pseudonimo FROM vm50_filas WHERE trim(nome)=trim(NEW.fila);
IF NOT FOUND THEN
RETURN NULL;
END IF;
NEW.fila := nome_fila;
ELSE
-- IF (NEW.fila != 'Fazendo chamada externa') AND (NEW.fila != 'DDR') AND (NEW.fila != 'Consulta') AND (substr(NEW.fila,0,20) != 'Transfer&ecirc;ncia-') THEN
-- RETURN NULL;
-- END IF;
END IF;
ELSE
-- NEW.agente := NEW.agente || '-' || dados_agente.nome;
NEW.agente := NEW.agente || '-' || dados_agente.pseudonimo;
END IF;

--
-- Descobre o nome da fila
--
SELECT INTO numero_chamando pseudonimo FROM vm50_filas WHERE pseudonimo=NEW.numero OR nome=NEW.numero;
IF FOUND THEN
SELECT INTO numero_chamando numero_orig FROM vm50_link_ligacao WHERE id_orig=NEW.ligacao OR id_dest=NEW.ligacao;
IF FOUND THEN
NEW.numero := numero_chamando;
ELSE
SELECT INTO numero_chamando numero FROM vm50_relatorios_cc_hoje WHERE ligacao=NEW.ligacao AND numero!=NEW.numero;
IF FOUND THEN
NEW.numero := numero_chamando;
ELSE
NEW.numero := '';
END IF;
END IF;
END IF;
IF ((NEW.fila = 'FILA') OR (NEW.fila = '')) THEN
SELECT INTO nome_fila numero_dest FROM vm50_link_ligacao WHERE id_orig=NEW.ligacao OR id_dest=NEW.ligacao;
SELECT INTO numero_chamando pseudonimo FROM vm50_filas WHERE pseudonimo=nome_fila;
IF FOUND THEN
NEW.fila := nome_fila;
END IF;
END IF;

--
-- Arruma transferencia
--
IF (substr(NEW.fila,0,20) = 'Transfer&ecirc;ncia-') THEN
SELECT INTO nome_fila pseudonimo FROM vm50_filas WHERE trim(nome)=trim(substr(NEW.fila,21));
IF FOUND THEN
NEW.fila := nome_fila;
END IF;
ELSE
SELECT INTO nome_fila pseudonimo FROM vm50_filas WHERE trim(nome)=trim(NEW.fila);
IF FOUND THEN
NEW.fila := nome_fila;
END IF;
END IF;
--
NEW.funcai := dados_agente.funcai;
NEW.loginr := dados_agente.loginr;
NEW.grupos := dados_agente.grupos;

--
-- Descobre quem estah no ramal
--
IF (NEW.numero != '') THEN
SELECT INTO dados_agente * FROM vm50_agentes WHERE ramal=NEW.numero;
IF FOUND THEN
NEW.numero := dados_agente.login || '-' || dados_agente.pseudonimo;
END IF;
END IF;

--
-- Nao permitir fila com NULL
--
IF (NEW.fila = 'NULL') THEN
RETURN NULL;
-- ELSE
-- SELECT INTO numero_chamando pseudonimo FROM vm50_filas WHERE pseudonimo=NEW.fila;
-- IF FOUND THEN
-- NEW.fila := nome_fila;
-- ELSE
-- IF (substr(NEW.fila,0,8) = 'Externo-') THEN
-- NEW.fila := 'Fazendo chamada externa';
-- ELSE
-- NEW.fila := '';
-- END IF;
-- END IF;
END IF;

--
-- Nao permitir consultas duplicadas
--
IF (NEW.fila = 'Consulta') AND (NEW.agente = NEW.numero) THEN
RETURN NULL;
END IF;

--
-- Nao permitir numero com nome de tronco
--
SELECT INTO nome_tronco numero_asterisk FROM vm50_troncos WHERE numero_asterisk=NEW.numero LIMIT 1;
IF FOUND THEN
RETURN NULL;
END IF;

--
-- Arruma o Livre
--
IF (NEW.oque = 'Livre') THEN
NEW.fila = '';
NEW.ligacao = '';
END IF;

--
-- Nao permitir entradas duplicadas
--
IF (NEW.fila!= '') AND (NEW.ligacao!='') AND (NEW.numero!='') AND (NEW.oque!='') THEN
IF (NEW.fila = 'Fazendo chamada externa') OR (NEW.fila = 'DDR') OR (NEW.fila = 'Consulta') OR (substr(NEW.fila,0,20) = 'Transfer&ecirc;ncia-') THEN
SELECT INTO id_number id FROM vm50_relatorios_cc_hoje WHERE agente=NEW.agente AND fila=NEW.fila AND ligacao=NEW.ligacao AND numero=NEW.numero AND oque=NEW.oque;
IF FOUND THEN
RETURN NULL;
END IF;
END IF;
END IF;

INSERT INTO vm50_relatorios_cc_hoje (diahora,agente,fila,ligacao,numero,oque,funcai,loginr,grupos,canalext,canalint) VALUES (NEW.diahora, NEW.agente, NEW.fila, NEW.ligacao, NEW.numero, NEW.oque, NEW.funcai, NEW.loginr, NEW.grupos, NEW.canalext, NEW.canalint);

RETURN NEW;

END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.vm50_nao_insere_duplicatas() OWNER TO postgres;

--
-- Name: vm50_nao_insere_duplicatas_pbx(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION vm50_nao_insere_duplicatas_pbx() RETURNS trigger
    AS $$
  DECLARE
    id_number INTEGER;
  BEGIN

  --
  -- Nao permitir entradas duplicadas
  --
--  IF (NEW.fila!= '') AND (NEW.ligacao!='') AND (NEW.numero!='') AND (NEW.oque!='') THEN
--    IF (NEW.fila = 'Fazendo chamada externa') OR (NEW.fila = 'DDR') OR (NEW.fila = 'Consulta') OR (substr(NEW.fila,0,20) = 'Transfer&ecirc;ncia-') THEN
--      SELECT INTO id_number id FROM vm50_relatorios_pbx WHERE agente=NEW.agente AND fila=NEW.fila AND ligacao=NEW.ligacao AND numero=NEW.numero AND oque=NEW.oque;
--      IF FOUND THEN
--        RETURN NULL;
--      END IF;
--    END IF;
--  END IF;

  RETURN NEW;

 END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.vm50_nao_insere_duplicatas_pbx() OWNER TO postgres;

SET search_path = realtime, pg_catalog;

--
-- Name: atualiza_dados_fila(); Type: FUNCTION; Schema: realtime; Owner: postgres
--

CREATE FUNCTION atualiza_dados_fila() RETURNS trigger
    AS $$
BEGIN
UPDATE REALTIME.QUEUES_TABLE SET NAME = NEW.NOME, MUSICONHOLD = NEW.MUSICA,
TIMEOUT = NEW.TIMEOUT, STRATEGY = NEW.ESTRATEGIA, MAXLEN = NEW.QTDEMAXCHAMAFILAESP,
RETRY = NEW.TENTARDENOVO, ANNOUNCE_HOLDTIME = NEW.ANUNESPERAESTIMADA
WHERE NAME LIKE NEW.NOME;
RETURN NEW;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION realtime.atualiza_dados_fila() OWNER TO postgres;

--
-- Name: atualiza_dados_ramais(); Type: FUNCTION; Schema: realtime; Owner: postgres
--

CREATE FUNCTION atualiza_dados_ramais() RETURNS trigger
    AS $$
BEGIN
UPDATE REALTIME.SIP_RAMAL SET NAME = NEW.NOMECOMPLET, HOST = NEW.HOST,
USERNAME = NEW.USERNAME, SECRET = NEW.SENHA, TYPE = NEW.TIPO,
CONTEXT = NEW.CONTEXTO, DTMFMODE = NEW.DTMFMODE,
CALL_LIMIT = NEW.CALL_LIMIT WHERE ID_SIP_RAMAL = NEW.ID;
RETURN NEW;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION realtime.atualiza_dados_ramais() OWNER TO postgres;

--
-- Name: deleta_dados_filas(); Type: FUNCTION; Schema: realtime; Owner: postgres
--

CREATE FUNCTION deleta_dados_filas() RETURNS trigger
    AS $$
BEGIN
DELETE FROM REALTIME.QUEUES_TABLE 
WHERE name = OLD.nome;
DELETE FROM REALTIME.QUEUE_MEMBER_TABLE
WHERE QUEUE_NAME = OLD.nome;
RETURN OLD;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION realtime.deleta_dados_filas() OWNER TO postgres;

--
-- Name: deleta_dados_membros_fila(); Type: FUNCTION; Schema: realtime; Owner: postgres
--

CREATE FUNCTION deleta_dados_membros_fila() RETURNS trigger
    AS $$
Declare ramal varchar;
        fila varchar;
BEGIN
ramal:= (SELECT vm50_ramais.ramal FROM vm50_ramais WHERE vm50_ramais.id = OLD.agente 
ORDER BY vm50_ramais.ramal);
fila:= (SELECT vm50_filas.nome FROM vm50_filas WHERE vm50_filas.id = OLD.fila
ORDER BY vm50_filas.nome);
IF(ramal != '' or fila != '')
THEN
DELETE FROM REALTIME.QUEUE_MEMBER_TABLE
WHERE QUEUE_NAME = fila AND INTERFACE = 'SIP/'||ramal;
END IF;
RETURN OLD;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION realtime.deleta_dados_membros_fila() OWNER TO postgres;

--
-- Name: deleta_dados_ramais(); Type: FUNCTION; Schema: realtime; Owner: postgres
--

CREATE FUNCTION deleta_dados_ramais() RETURNS trigger
    AS $$
BEGIN
DELETE FROM REALTIME.SIP_RAMAL 
WHERE ID_SIP_RAMAL = OLD.ID;
RETURN OLD;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION realtime.deleta_dados_ramais() OWNER TO postgres;

--
-- Name: insere_dados_fila(); Type: FUNCTION; Schema: realtime; Owner: postgres
--

CREATE FUNCTION insere_dados_fila() RETURNS trigger
    AS $$
BEGIN
INSERT INTO REALTIME.QUEUES_TABLE(NAME,MUSICONHOLD,RETRY,TIMEOUT,STRATEGY,MAXLEN,
ANNOUNCE_HOLDTIME)
VALUES(NEW.NOME,NEW.MUSICA,NEW.TENTARDENOVO,NEW.TIMEOUT,NEW.ESTRATEGIA,NEW.QTDEMAXCHAMAFILAESP,
NEW.ANUNESPERAESTIMADA);
RETURN NEW;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION realtime.insere_dados_fila() OWNER TO postgres;

--
-- Name: insere_dados_membros_filas(); Type: FUNCTION; Schema: realtime; Owner: postgres
--

CREATE FUNCTION insere_dados_membros_filas() RETURNS trigger
    AS $$
Declare ramal varchar;
        fila  varchar;
        agente varchar;
BEGIN
ramal := (SELECT vm50_ramais.ramal FROM vm50_ramais WHERE vm50_ramais.id = NEW.agente 
ORDER BY vm50_ramais.ramal);
fila := (SELECT vm50_filas.nome FROM vm50_filas WHERE vm50_filas.id = NEW.fila
ORDER BY vm50_filas.nome);
IF(ramal != '' and fila != '')
THEN
INSERT INTO REALTIME.QUEUE_MEMBER_TABLE(QUEUE_NAME,INTERFACE)
VALUES(fila,'SIP/' || ramal);
ELSE
agente := (SELECT vm50_agentes.login FROM vm50_agentes WHERE vm50_agentes.id = NEW.agente
ORDER BY vm50_agentes.login);
IF(agente != '' and fila != '')
THEN
INSERT INTO REALTIME.QUEUE_MEMBER_TABLE(QUEUE_NAME,INTERFACE)
VALUES(fila,'Agent/' || agente);
END IF;
END IF;
RETURN NEW;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION realtime.insere_dados_membros_filas() OWNER TO postgres;

--
-- Name: insere_dados_ramais(); Type: FUNCTION; Schema: realtime; Owner: postgres
--

CREATE FUNCTION insere_dados_ramais() RETURNS trigger
    AS $$
BEGIN
INSERT INTO REALTIME.SIP_RAMAL (ID_SIP_RAMAL,NAME,HOST,
USERNAME,SECRET,TYPE,CONTEXT,DTMFMODE,CALL_LIMIT)
VALUES(NEW.ID,NEW.NOMECOMPLET,NEW.HOST,NEW.USERNAME,
NEW.SENHA,NEW.TIPO,NEW.CONTEXTO,NEW.DTMFMODE,NEW.CALL_LIMIT);
RETURN NEW;
END;$$
    LANGUAGE plpgsql;


ALTER FUNCTION realtime.insere_dados_ramais() OWNER TO postgres;

SET search_path = historico, pg_catalog;

--
-- Name: sip_cod_id_seq; Type: SEQUENCE; Schema: historico; Owner: postgres
--

CREATE SEQUENCE sip_cod_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE historico.sip_cod_id_seq OWNER TO postgres;

--
-- Name: sip_cod_id_seq; Type: SEQUENCE OWNED BY; Schema: historico; Owner: postgres
--

ALTER SEQUENCE sip_cod_id_seq OWNED BY sip.cod_id;


SET search_path = public, pg_catalog;

--
-- Name: crm_campanhas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE crm_campanhas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.crm_campanhas_id_seq OWNER TO postgres;

--
-- Name: crm_campanhas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE crm_campanhas_id_seq OWNED BY crm_campanhas.id;


--
-- Name: crm_clientes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE crm_clientes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.crm_clientes_id_seq OWNER TO postgres;

--
-- Name: crm_clientes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE crm_clientes_id_seq OWNED BY crm_clientes.id;


--
-- Name: crm_telefones_clientes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE crm_telefones_clientes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.crm_telefones_clientes_id_seq OWNER TO postgres;

--
-- Name: crm_telefones_clientes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE crm_telefones_clientes_id_seq OWNED BY crm_telefones_clientes.id;


--
-- Name: notaatend_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE notaatend_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.notaatend_id_seq OWNER TO postgres;

--
-- Name: notaatend_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE notaatend_id_seq OWNED BY notaatend.id;


--
-- Name: sip_ramais_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sip_ramais_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.sip_ramais_id_seq OWNER TO postgres;

--
-- Name: sip_ramais_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE sip_ramais_id_seq OWNED BY sip_ramais.id;


--
-- Name: tb_central_id_central_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tb_central_id_central_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tb_central_id_central_seq OWNER TO postgres;

--
-- Name: tb_central_id_central_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tb_central_id_central_seq OWNED BY tb_central.id_central;


--
-- Name: tb_grupo_tronco_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tb_grupo_tronco_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tb_grupo_tronco_id_seq OWNER TO postgres;

--
-- Name: tb_grupo_tronco_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tb_grupo_tronco_id_seq OWNED BY tb_grupo_tronco.id;


--
-- Name: tb_ramal_grupo_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tb_ramal_grupo_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tb_ramal_grupo_id_seq OWNER TO postgres;

--
-- Name: tb_ramal_grupo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tb_ramal_grupo_id_seq OWNED BY tb_login_grupo.id;


--
-- Name: tb_realtime_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE tb_realtime_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tb_realtime_id_seq OWNER TO postgres;

--
-- Name: tb_realtime_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE tb_realtime_id_seq OWNED BY tb_realtime.id;


--
-- Name: vm50_agenda_campanhas_id_campanha_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_agenda_campanhas_id_campanha_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_agenda_campanhas_id_campanha_seq OWNER TO postgres;

--
-- Name: vm50_agenda_campanhas_id_campanha_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_agenda_campanhas_id_campanha_seq OWNED BY vm50_agenda_campanhas.id_campanha;


--
-- Name: vm50_agenda_campanhas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_agenda_campanhas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_agenda_campanhas_id_seq OWNER TO postgres;

--
-- Name: vm50_agenda_campanhas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_agenda_campanhas_id_seq OWNED BY vm50_agenda_campanhas.id;


--
-- Name: vm50_agenda_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_agenda_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_agenda_id_seq OWNER TO postgres;

--
-- Name: vm50_agenda_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_agenda_id_seq OWNED BY vm50_agenda.id;


--
-- Name: vm50_agentes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_agentes_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_agentes_id_seq OWNER TO postgres;

--
-- Name: vm50_agentes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_agentes_id_seq OWNED BY vm50_agentes.id;


--
-- Name: vm50_agentes_ramais_agente_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_agentes_ramais_agente_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_agentes_ramais_agente_seq OWNER TO postgres;

--
-- Name: vm50_agentes_ramais_agente_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_agentes_ramais_agente_seq OWNED BY vm50_agentes_ramais.agente;


--
-- Name: vm50_agentes_ramais_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_agentes_ramais_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_agentes_ramais_id_seq OWNER TO postgres;

--
-- Name: vm50_agentes_ramais_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_agentes_ramais_id_seq OWNED BY vm50_agentes_ramais.id;


--
-- Name: vm50_agentes_ramais_ramal_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_agentes_ramais_ramal_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_agentes_ramais_ramal_seq OWNER TO postgres;

--
-- Name: vm50_agentes_ramais_ramal_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_agentes_ramais_ramal_seq OWNED BY vm50_agentes_ramais.ramal;


--
-- Name: vm50_alarmes_usuario_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_alarmes_usuario_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_alarmes_usuario_seq OWNER TO postgres;

--
-- Name: vm50_alarmes_usuario_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_alarmes_usuario_seq OWNED BY vm50_alarmes.usuario;


--
-- Name: vm50_arvore_grupos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_arvore_grupos_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_arvore_grupos_id_seq OWNER TO postgres;

--
-- Name: vm50_arvore_grupos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_arvore_grupos_id_seq OWNED BY vm50_arvore_grupos.id;


--
-- Name: vm50_ast_queue_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_ast_queue_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_ast_queue_id_seq OWNER TO postgres;

--
-- Name: vm50_ast_queue_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_ast_queue_id_seq OWNED BY vm50_ast_queue.id;


--
-- Name: vm50_ast_queue_member_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_ast_queue_member_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_ast_queue_member_id_seq OWNER TO postgres;

--
-- Name: vm50_ast_queue_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_ast_queue_member_id_seq OWNED BY vm50_ast_queue_member.id;


--
-- Name: vm50_auxiliares_filas_fila_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_auxiliares_filas_fila_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_auxiliares_filas_fila_seq OWNER TO postgres;

--
-- Name: vm50_auxiliares_filas_fila_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_auxiliares_filas_fila_seq OWNED BY vm50_auxiliares_filas.fila;


--
-- Name: vm50_auxiliares_filas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_auxiliares_filas_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_auxiliares_filas_id_seq OWNER TO postgres;

--
-- Name: vm50_auxiliares_filas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_auxiliares_filas_id_seq OWNED BY vm50_auxiliares_filas.id;


--
-- Name: vm50_auxiliares_filas_ramal_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_auxiliares_filas_ramal_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_auxiliares_filas_ramal_seq OWNER TO postgres;

--
-- Name: vm50_auxiliares_filas_ramal_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_auxiliares_filas_ramal_seq OWNED BY vm50_auxiliares_filas.ramal;


--
-- Name: vm50_campanhas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_campanhas_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_campanhas_id_seq OWNER TO postgres;

--
-- Name: vm50_campanhas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_campanhas_id_seq OWNED BY vm50_campanhas.id;


--
-- Name: vm50_campanhas_pecas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_campanhas_pecas_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_campanhas_pecas_id_seq OWNER TO postgres;

--
-- Name: vm50_campanhas_pecas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_campanhas_pecas_id_seq OWNED BY vm50_campanhas_pecas.id;


--
-- Name: vm50_chamadas_classificadas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_chamadas_classificadas_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_chamadas_classificadas_id_seq OWNER TO postgres;

--
-- Name: vm50_chamadas_classificadas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_chamadas_classificadas_id_seq OWNED BY vm50_chamadas_classificadas.id;


--
-- Name: vm50_chat_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_chat_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_chat_id_seq OWNER TO postgres;

--
-- Name: vm50_chat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_chat_id_seq OWNED BY vm50_chat.id;


--
-- Name: vm50_classificacao_chamadas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_classificacao_chamadas_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_classificacao_chamadas_id_seq OWNER TO postgres;

--
-- Name: vm50_classificacao_chamadas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_classificacao_chamadas_id_seq OWNED BY vm50_classificacao_chamadas.id;


--
-- Name: vm50_codigo_conta_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_codigo_conta_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_codigo_conta_id_seq OWNER TO postgres;

--
-- Name: vm50_codigo_conta_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_codigo_conta_id_seq OWNED BY vm50_codigo_conta.id;


--
-- Name: vm50_conf_email_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_conf_email_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_conf_email_id_seq OWNER TO postgres;

--
-- Name: vm50_conf_email_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_conf_email_id_seq OWNED BY vm50_conf_email.id;


--
-- Name: vm50_config_geral_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_config_geral_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_config_geral_id_seq OWNER TO postgres;

--
-- Name: vm50_config_geral_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_config_geral_id_seq OWNED BY vm50_config_geral.id;


--
-- Name: vm50_config_painel_pa_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_config_painel_pa_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_config_painel_pa_id_seq OWNER TO postgres;

--
-- Name: vm50_config_painel_pa_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_config_painel_pa_id_seq OWNED BY vm50_config_painel_pa.id;


--
-- Name: vm50_config_syonet_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_config_syonet_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_config_syonet_id_seq OWNER TO postgres;

--
-- Name: vm50_config_syonet_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_config_syonet_id_seq OWNED BY vm50_config_syonet.id;


--
-- Name: vm50_ddd_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_ddd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_ddd_id_seq OWNER TO postgres;

--
-- Name: vm50_ddd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_ddd_id_seq OWNED BY vm50_ddd.id;


--
-- Name: vm50_discador_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_discador_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_discador_id_seq OWNER TO postgres;

--
-- Name: vm50_discador_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_discador_id_seq OWNED BY vm50_discador.id;


--
-- Name: vm50_dscrapida_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_dscrapida_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_dscrapida_id_seq OWNER TO postgres;

--
-- Name: vm50_dscrapida_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_dscrapida_id_seq OWNED BY vm50_dscrapida.id;


--
-- Name: vm50_extensoes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_extensoes_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_extensoes_id_seq OWNER TO postgres;

--
-- Name: vm50_extensoes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_extensoes_id_seq OWNED BY vm50_extensoes.id;


--
-- Name: vm50_facilidades_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_facilidades_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_facilidades_id_seq OWNER TO postgres;

--
-- Name: vm50_facilidades_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_facilidades_id_seq OWNED BY vm50_facilidades.id;


--
-- Name: vm50_feixes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_feixes_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_feixes_id_seq OWNER TO postgres;

--
-- Name: vm50_feixes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_feixes_id_seq OWNED BY vm50_feixes.id;


--
-- Name: vm50_feixes_remotos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_feixes_remotos_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_feixes_remotos_id_seq OWNER TO postgres;

--
-- Name: vm50_feixes_remotos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_feixes_remotos_id_seq OWNED BY vm50_feixes_remotos.id;


--
-- Name: vm50_feriados_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_feriados_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_feriados_id_seq OWNER TO postgres;

--
-- Name: vm50_feriados_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_feriados_id_seq OWNED BY vm50_feriados.id;


--
-- Name: vm50_fha_filas_fila_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_fha_filas_fila_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_fha_filas_fila_seq OWNER TO postgres;

--
-- Name: vm50_fha_filas_fila_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_fha_filas_fila_seq OWNED BY vm50_fha_filas.fila;


--
-- Name: vm50_fha_filas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_fha_filas_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_fha_filas_id_seq OWNER TO postgres;

--
-- Name: vm50_fha_filas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_fha_filas_id_seq OWNED BY vm50_fha_filas.id;


--
-- Name: vm50_fha_filas_ramal_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_fha_filas_ramal_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_fha_filas_ramal_seq OWNER TO postgres;

--
-- Name: vm50_fha_filas_ramal_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_fha_filas_ramal_seq OWNED BY vm50_fha_filas.ramal;


--
-- Name: vm50_filas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_filas_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_filas_id_seq OWNER TO postgres;

--
-- Name: vm50_filas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_filas_id_seq OWNED BY vm50_filas.id;


--
-- Name: vm50_filas_membros_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_filas_membros_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_filas_membros_id_seq OWNER TO postgres;

--
-- Name: vm50_filas_membros_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_filas_membros_id_seq OWNED BY vm50_filas_membros.id;


--
-- Name: vm50_filas_ramais_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_filas_ramais_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_filas_ramais_id_seq OWNER TO postgres;

--
-- Name: vm50_filas_ramais_id_seq1; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_filas_ramais_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_filas_ramais_id_seq1 OWNER TO postgres;

--
-- Name: vm50_filas_ramais_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_filas_ramais_id_seq1 OWNED BY vm50_filas_ramais.id;


--
-- Name: vm50_filas_syonet_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_filas_syonet_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_filas_syonet_id_seq OWNER TO postgres;

--
-- Name: vm50_filas_syonet_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_filas_syonet_id_seq OWNED BY vm50_filas_syonet.id;


--
-- Name: vm50_grupo_de_campanhas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_grupo_de_campanhas_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_grupo_de_campanhas_id_seq OWNER TO postgres;

--
-- Name: vm50_grupo_de_campanhas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_grupo_de_campanhas_id_seq OWNED BY vm50_grupo_de_campanhas.id;


--
-- Name: vm50_grupos_campanhas_fk_grupo_campanha_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_grupos_campanhas_fk_grupo_campanha_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_grupos_campanhas_fk_grupo_campanha_seq OWNER TO postgres;

--
-- Name: vm50_grupos_campanhas_fk_grupo_campanha_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_grupos_campanhas_fk_grupo_campanha_seq OWNED BY vm50_grupos_campanhas.fk_grupo_campanha;


--
-- Name: vm50_grupos_campanhas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_grupos_campanhas_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_grupos_campanhas_id_seq OWNER TO postgres;

--
-- Name: vm50_grupos_campanhas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_grupos_campanhas_id_seq OWNED BY vm50_grupos_campanhas.id;


--
-- Name: vm50_grupos_captura_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_grupos_captura_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_grupos_captura_id_seq OWNER TO postgres;

--
-- Name: vm50_grupos_captura_id_seq1; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_grupos_captura_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_grupos_captura_id_seq1 OWNER TO postgres;

--
-- Name: vm50_grupos_captura_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_grupos_captura_id_seq1 OWNED BY vm50_grupos_captura.id;


--
-- Name: vm50_grupos_filas_relat_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_grupos_filas_relat_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_grupos_filas_relat_id_seq OWNER TO postgres;

--
-- Name: vm50_grupos_filas_relat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_grupos_filas_relat_id_seq OWNED BY vm50_grupos_filas_relat.id;


--
-- Name: vm50_grupos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_grupos_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_grupos_id_seq OWNER TO postgres;

--
-- Name: vm50_grupos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_grupos_id_seq OWNED BY vm50_grupos.id;


--
-- Name: vm50_grupos_ramais_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_grupos_ramais_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_grupos_ramais_id_seq OWNER TO postgres;

--
-- Name: vm50_grupos_ramais_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_grupos_ramais_id_seq OWNED BY vm50_grupos_ramais.id;


--
-- Name: vm50_integracao_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_integracao_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    MINVALUE 0
    CACHE 1;


ALTER TABLE public.vm50_integracao_id_seq OWNER TO postgres;

--
-- Name: vm50_integracao_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_integracao_id_seq OWNED BY vm50_integracao.id;


--
-- Name: vm50_mensagens_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_mensagens_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_mensagens_id_seq OWNER TO postgres;

--
-- Name: vm50_mensagens_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_mensagens_id_seq OWNED BY vm50_mensagens.id;


--
-- Name: vm50_metodos_login_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_metodos_login_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_metodos_login_id_seq OWNER TO postgres;

--
-- Name: vm50_metodos_login_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_metodos_login_id_seq OWNED BY vm50_metodos_login.id;


--
-- Name: vm50_mostra_oculta_agente_monitora_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_mostra_oculta_agente_monitora_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_mostra_oculta_agente_monitora_id_seq OWNER TO postgres;

--
-- Name: vm50_mostra_oculta_agente_monitora_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_mostra_oculta_agente_monitora_id_seq OWNED BY vm50_mostra_oculta_agente_monitora.id;


--
-- Name: vm50_pausas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_pausas_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_pausas_id_seq OWNER TO postgres;

--
-- Name: vm50_pausas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_pausas_id_seq OWNED BY vm50_pausas.id;


--
-- Name: vm50_periodos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_periodos_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_periodos_id_seq OWNER TO postgres;

--
-- Name: vm50_periodos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_periodos_id_seq OWNED BY vm50_periodos.id;


--
-- Name: vm50_permissao_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_permissao_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_permissao_id_seq OWNER TO postgres;

--
-- Name: vm50_permissao_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_permissao_id_seq OWNED BY vm50_permissao.id;


--
-- Name: vm50_placas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_placas_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_placas_id_seq OWNER TO postgres;

--
-- Name: vm50_placas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_placas_id_seq OWNED BY vm50_placas.id;


--
-- Name: vm50_ramais_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_ramais_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_ramais_id_seq OWNER TO postgres;

--
-- Name: vm50_ramais_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_ramais_id_seq OWNED BY vm50_ramais.id;


--
-- Name: vm50_ramais_luzes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_ramais_luzes_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_ramais_luzes_id_seq OWNER TO postgres;

--
-- Name: vm50_ramais_luzes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_ramais_luzes_id_seq OWNED BY vm50_ramais_luzes.id;


--
-- Name: vm50_ramais_relacionados_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_ramais_relacionados_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_ramais_relacionados_id_seq OWNER TO postgres;

--
-- Name: vm50_ramais_relacionados_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_ramais_relacionados_id_seq OWNED BY vm50_ramais_relacionados.id;


--
-- Name: vm50_ramais_relacionados_pai_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_ramais_relacionados_pai_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_ramais_relacionados_pai_seq OWNER TO postgres;

--
-- Name: vm50_ramais_relacionados_pai_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_ramais_relacionados_pai_seq OWNED BY vm50_ramais_relacionados.pai;


--
-- Name: vm50_ramais_relacionados_ramal_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_ramais_relacionados_ramal_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_ramais_relacionados_ramal_seq OWNER TO postgres;

--
-- Name: vm50_ramais_relacionados_ramal_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_ramais_relacionados_ramal_seq OWNED BY vm50_ramais_relacionados.ramal;


--
-- Name: vm50_relatorio_agentes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_relatorio_agentes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_relatorio_agentes_id_seq OWNER TO postgres;

--
-- Name: vm50_relatorio_agentes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_relatorio_agentes_id_seq OWNED BY vm50_relatorio_agentes.id;


--
-- Name: vm50_relatorio_grupos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_relatorio_grupos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_relatorio_grupos_id_seq OWNER TO postgres;

--
-- Name: vm50_relatorio_grupos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_relatorio_grupos_id_seq OWNED BY vm50_relatorio_grupos.id;


--
-- Name: vm50_relatorios_cc_grupo_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_relatorios_cc_grupo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_relatorios_cc_grupo_id_seq OWNER TO postgres;

--
-- Name: vm50_relatorios_cc_grupo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_relatorios_cc_grupo_id_seq OWNED BY vm50_relatorios_cc_grupo.id;


--
-- Name: vm50_relatorios_cc_hoje_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_relatorios_cc_hoje_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_relatorios_cc_hoje_id_seq OWNER TO postgres;

--
-- Name: vm50_relatorios_cc_hoje_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_relatorios_cc_hoje_id_seq OWNED BY vm50_relatorios_cc_hoje.id;


--
-- Name: vm50_relatorios_cc_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_relatorios_cc_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_relatorios_cc_id_seq OWNER TO postgres;

--
-- Name: vm50_relatorios_cc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_relatorios_cc_id_seq OWNED BY vm50_relatorios_cc.id;


--
-- Name: vm50_relatorios_pbx_hoje_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_relatorios_pbx_hoje_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_relatorios_pbx_hoje_id_seq OWNER TO postgres;

--
-- Name: vm50_relatorios_pbx_hoje_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_relatorios_pbx_hoje_id_seq OWNED BY vm50_relatorios_pbx_hoje.id;


--
-- Name: vm50_relatorios_pbx_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_relatorios_pbx_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_relatorios_pbx_id_seq OWNER TO postgres;

--
-- Name: vm50_relatorios_pbx_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_relatorios_pbx_id_seq OWNED BY vm50_relatorios_pbx.id;


--
-- Name: vm50_troncos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_troncos_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_troncos_id_seq OWNER TO postgres;

--
-- Name: vm50_troncos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_troncos_id_seq OWNED BY vm50_troncos.id;


--
-- Name: vm50_troncos_remotos_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_troncos_remotos_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_troncos_remotos_id_seq OWNER TO postgres;

--
-- Name: vm50_troncos_remotos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_troncos_remotos_id_seq OWNED BY vm50_troncos_remotos.id;


--
-- Name: vm50_turnos_agentes_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_turnos_agentes_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_turnos_agentes_id_seq OWNER TO postgres;

--
-- Name: vm50_turnos_agentes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_turnos_agentes_id_seq OWNED BY vm50_turnos_agentes.id;


--
-- Name: vm50_turnos_filas_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_turnos_filas_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_turnos_filas_id_seq OWNER TO postgres;

--
-- Name: vm50_turnos_filas_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_turnos_filas_id_seq OWNED BY vm50_turnos_filas.id;


--
-- Name: vm50_turnos_usuarios_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_turnos_usuarios_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_turnos_usuarios_id_seq OWNER TO postgres;

--
-- Name: vm50_turnos_usuarios_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_turnos_usuarios_id_seq OWNED BY vm50_turnos_usuarios.id;


--
-- Name: vm50_usuarios_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE vm50_usuarios_id_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vm50_usuarios_id_seq OWNER TO postgres;

--
-- Name: vm50_usuarios_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE vm50_usuarios_id_seq OWNED BY vm50_usuarios.id;


SET search_path = realtime, pg_catalog;

--
-- Name: extensions_conf_id_seq; Type: SEQUENCE; Schema: realtime; Owner: postgres
--

CREATE SEQUENCE extensions_conf_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE realtime.extensions_conf_id_seq OWNER TO postgres;

--
-- Name: extensions_conf_id_seq; Type: SEQUENCE OWNED BY; Schema: realtime; Owner: postgres
--

ALTER SEQUENCE extensions_conf_id_seq OWNED BY extensions_conf.id;


--
-- Name: queue_member_table_id_seq; Type: SEQUENCE; Schema: realtime; Owner: postgres
--

CREATE SEQUENCE queue_member_table_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE realtime.queue_member_table_id_seq OWNER TO postgres;

--
-- Name: queue_member_table_id_seq; Type: SEQUENCE OWNED BY; Schema: realtime; Owner: postgres
--

ALTER SEQUENCE queue_member_table_id_seq OWNED BY queue_member_table.id;


--
-- Name: sip_ramal_cod_id_seq; Type: SEQUENCE; Schema: realtime; Owner: postgres
--

CREATE SEQUENCE sip_ramal_cod_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE realtime.sip_ramal_cod_id_seq OWNER TO postgres;

--
-- Name: sip_ramal_cod_id_seq; Type: SEQUENCE OWNED BY; Schema: realtime; Owner: postgres
--

ALTER SEQUENCE sip_ramal_cod_id_seq OWNED BY sip_ramal.cod_id;


SET search_path = historico, pg_catalog;

--
-- Name: cod_id; Type: DEFAULT; Schema: historico; Owner: postgres
--

ALTER TABLE sip ALTER COLUMN cod_id SET DEFAULT nextval('sip_cod_id_seq'::regclass);


SET search_path = public, pg_catalog;

--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE crm_campanhas ALTER COLUMN id SET DEFAULT nextval('crm_campanhas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE crm_clientes ALTER COLUMN id SET DEFAULT nextval('crm_clientes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE crm_telefones_clientes ALTER COLUMN id SET DEFAULT nextval('crm_telefones_clientes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE notaatend ALTER COLUMN id SET DEFAULT nextval('notaatend_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE sip_ramais ALTER COLUMN id SET DEFAULT nextval('sip_ramais_id_seq'::regclass);


--
-- Name: id_central; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tb_central ALTER COLUMN id_central SET DEFAULT nextval('tb_central_id_central_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tb_grupo_tronco ALTER COLUMN id SET DEFAULT nextval('tb_grupo_tronco_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tb_login_grupo ALTER COLUMN id SET DEFAULT nextval('tb_ramal_grupo_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE tb_realtime ALTER COLUMN id SET DEFAULT nextval('tb_realtime_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_agenda ALTER COLUMN id SET DEFAULT nextval('vm50_agenda_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_agenda_campanhas ALTER COLUMN id SET DEFAULT nextval('vm50_agenda_campanhas_id_seq'::regclass);


--
-- Name: id_campanha; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_agenda_campanhas ALTER COLUMN id_campanha SET DEFAULT nextval('vm50_agenda_campanhas_id_campanha_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_agentes ALTER COLUMN id SET DEFAULT nextval('vm50_agentes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_agentes_ramais ALTER COLUMN id SET DEFAULT nextval('vm50_agentes_ramais_id_seq'::regclass);


--
-- Name: agente; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_agentes_ramais ALTER COLUMN agente SET DEFAULT nextval('vm50_agentes_ramais_agente_seq'::regclass);


--
-- Name: ramal; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_agentes_ramais ALTER COLUMN ramal SET DEFAULT nextval('vm50_agentes_ramais_ramal_seq'::regclass);


--
-- Name: usuario; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_alarmes ALTER COLUMN usuario SET DEFAULT nextval('vm50_alarmes_usuario_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_arvore_grupos ALTER COLUMN id SET DEFAULT nextval('vm50_arvore_grupos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_ast_queue ALTER COLUMN id SET DEFAULT nextval('vm50_ast_queue_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_ast_queue_member ALTER COLUMN id SET DEFAULT nextval('vm50_ast_queue_member_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_auxiliares_filas ALTER COLUMN id SET DEFAULT nextval('vm50_auxiliares_filas_id_seq'::regclass);


--
-- Name: ramal; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_auxiliares_filas ALTER COLUMN ramal SET DEFAULT nextval('vm50_auxiliares_filas_ramal_seq'::regclass);


--
-- Name: fila; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_auxiliares_filas ALTER COLUMN fila SET DEFAULT nextval('vm50_auxiliares_filas_fila_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_campanhas ALTER COLUMN id SET DEFAULT nextval('vm50_campanhas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_campanhas_pecas ALTER COLUMN id SET DEFAULT nextval('vm50_campanhas_pecas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_chamadas_classificadas ALTER COLUMN id SET DEFAULT nextval('vm50_chamadas_classificadas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_chat ALTER COLUMN id SET DEFAULT nextval('vm50_chat_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_classificacao_chamadas ALTER COLUMN id SET DEFAULT nextval('vm50_classificacao_chamadas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_codigo_conta ALTER COLUMN id SET DEFAULT nextval('vm50_codigo_conta_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_conf_email ALTER COLUMN id SET DEFAULT nextval('vm50_conf_email_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_config_geral ALTER COLUMN id SET DEFAULT nextval('vm50_config_geral_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_config_painel_pa ALTER COLUMN id SET DEFAULT nextval('vm50_config_painel_pa_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_config_syonet ALTER COLUMN id SET DEFAULT nextval('vm50_config_syonet_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_ddd ALTER COLUMN id SET DEFAULT nextval('vm50_ddd_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_discador ALTER COLUMN id SET DEFAULT nextval('vm50_discador_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_dscrapida ALTER COLUMN id SET DEFAULT nextval('vm50_dscrapida_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_extensoes ALTER COLUMN id SET DEFAULT nextval('vm50_extensoes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_facilidades ALTER COLUMN id SET DEFAULT nextval('vm50_facilidades_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_feixes ALTER COLUMN id SET DEFAULT nextval('vm50_feixes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_feixes_remotos ALTER COLUMN id SET DEFAULT nextval('vm50_feixes_remotos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_feriados ALTER COLUMN id SET DEFAULT nextval('vm50_feriados_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_fha_filas ALTER COLUMN id SET DEFAULT nextval('vm50_fha_filas_id_seq'::regclass);


--
-- Name: ramal; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_fha_filas ALTER COLUMN ramal SET DEFAULT nextval('vm50_fha_filas_ramal_seq'::regclass);


--
-- Name: fila; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_fha_filas ALTER COLUMN fila SET DEFAULT nextval('vm50_fha_filas_fila_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_filas ALTER COLUMN id SET DEFAULT nextval('vm50_filas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_filas_membros ALTER COLUMN id SET DEFAULT nextval('vm50_filas_membros_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_filas_ramais ALTER COLUMN id SET DEFAULT nextval('vm50_filas_ramais_id_seq1'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_filas_syonet ALTER COLUMN id SET DEFAULT nextval('vm50_filas_syonet_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_grupo_de_campanhas ALTER COLUMN id SET DEFAULT nextval('vm50_grupo_de_campanhas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_grupos ALTER COLUMN id SET DEFAULT nextval('vm50_grupos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_grupos_campanhas ALTER COLUMN id SET DEFAULT nextval('vm50_grupos_campanhas_id_seq'::regclass);


--
-- Name: fk_grupo_campanha; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_grupos_campanhas ALTER COLUMN fk_grupo_campanha SET DEFAULT nextval('vm50_grupos_campanhas_fk_grupo_campanha_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_grupos_captura ALTER COLUMN id SET DEFAULT nextval('vm50_grupos_captura_id_seq1'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_grupos_filas_relat ALTER COLUMN id SET DEFAULT nextval('vm50_grupos_filas_relat_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_grupos_ramais ALTER COLUMN id SET DEFAULT nextval('vm50_grupos_ramais_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_integracao ALTER COLUMN id SET DEFAULT nextval('vm50_integracao_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_mensagens ALTER COLUMN id SET DEFAULT nextval('vm50_mensagens_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_metodos_login ALTER COLUMN id SET DEFAULT nextval('vm50_metodos_login_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_mostra_oculta_agente_monitora ALTER COLUMN id SET DEFAULT nextval('vm50_mostra_oculta_agente_monitora_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_pausas ALTER COLUMN id SET DEFAULT nextval('vm50_pausas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_periodos ALTER COLUMN id SET DEFAULT nextval('vm50_periodos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_permissao ALTER COLUMN id SET DEFAULT nextval('vm50_permissao_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_placas ALTER COLUMN id SET DEFAULT nextval('vm50_placas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_ramais ALTER COLUMN id SET DEFAULT nextval('vm50_ramais_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_ramais_luzes ALTER COLUMN id SET DEFAULT nextval('vm50_ramais_luzes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_ramais_relacionados ALTER COLUMN id SET DEFAULT nextval('vm50_ramais_relacionados_id_seq'::regclass);


--
-- Name: pai; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_ramais_relacionados ALTER COLUMN pai SET DEFAULT nextval('vm50_ramais_relacionados_pai_seq'::regclass);


--
-- Name: ramal; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_ramais_relacionados ALTER COLUMN ramal SET DEFAULT nextval('vm50_ramais_relacionados_ramal_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_relatorio_agentes ALTER COLUMN id SET DEFAULT nextval('vm50_relatorio_agentes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_relatorio_grupos ALTER COLUMN id SET DEFAULT nextval('vm50_relatorio_grupos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_relatorios_cc ALTER COLUMN id SET DEFAULT nextval('vm50_relatorios_cc_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_relatorios_cc_grupo ALTER COLUMN id SET DEFAULT nextval('vm50_relatorios_cc_grupo_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_relatorios_cc_hoje ALTER COLUMN id SET DEFAULT nextval('vm50_relatorios_cc_hoje_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_relatorios_pbx ALTER COLUMN id SET DEFAULT nextval('vm50_relatorios_pbx_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_relatorios_pbx_hoje ALTER COLUMN id SET DEFAULT nextval('vm50_relatorios_pbx_hoje_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_troncos ALTER COLUMN id SET DEFAULT nextval('vm50_troncos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_troncos_remotos ALTER COLUMN id SET DEFAULT nextval('vm50_troncos_remotos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_turnos_agentes ALTER COLUMN id SET DEFAULT nextval('vm50_turnos_agentes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_turnos_filas ALTER COLUMN id SET DEFAULT nextval('vm50_turnos_filas_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_turnos_usuarios ALTER COLUMN id SET DEFAULT nextval('vm50_turnos_usuarios_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE vm50_usuarios ALTER COLUMN id SET DEFAULT nextval('vm50_usuarios_id_seq'::regclass);


SET search_path = realtime, pg_catalog;

--
-- Name: id; Type: DEFAULT; Schema: realtime; Owner: postgres
--

ALTER TABLE extensions_conf ALTER COLUMN id SET DEFAULT nextval('extensions_conf_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: realtime; Owner: postgres
--

ALTER TABLE queue_member_table ALTER COLUMN id SET DEFAULT nextval('queue_member_table_id_seq'::regclass);


--
-- Name: cod_id; Type: DEFAULT; Schema: realtime; Owner: postgres
--

ALTER TABLE sip_ramal ALTER COLUMN cod_id SET DEFAULT nextval('sip_ramal_cod_id_seq'::regclass);


SET search_path = historico, pg_catalog;

--
-- Name: cod_id; Type: CONSTRAINT; Schema: historico; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY sip
    ADD CONSTRAINT cod_id PRIMARY KEY (cod_id);


SET search_path = public, pg_catalog;

--
-- Name: callid_unique; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_discador
    ADD CONSTRAINT callid_unique UNIQUE (callid);


--
-- Name: crm_campanhas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY crm_campanhas
    ADD CONSTRAINT crm_campanhas_pkey PRIMARY KEY (id);


--
-- Name: crm_clientes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY crm_clientes
    ADD CONSTRAINT crm_clientes_pkey PRIMARY KEY (id);


--
-- Name: crm_listas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY crm_listas
    ADD CONSTRAINT crm_listas_pkey PRIMARY KEY (campanha_id, cliente_id);


--
-- Name: crm_telefones_clientes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY crm_telefones_clientes
    ADD CONSTRAINT crm_telefones_clientes_pkey PRIMARY KEY (id);


--
-- Name: foo_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY foo
    ADD CONSTRAINT foo_pkey PRIMARY KEY (f1, f2);


--
-- Name: grupo_login; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tb_login_grupo
    ADD CONSTRAINT grupo_login UNIQUE (loginmonitora, agentemonitora, grupomonitora);


--
-- Name: id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY sip_ramais
    ADD CONSTRAINT id PRIMARY KEY (id);


--
-- Name: id_grupo_ramal; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tb_login_grupo
    ADD CONSTRAINT id_grupo_ramal PRIMARY KEY (id);


--
-- Name: id_primary_key; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_discador
    ADD CONSTRAINT id_primary_key PRIMARY KEY (id);


--
-- Name: notaatend_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY notaatend
    ADD CONSTRAINT notaatend_pkey PRIMARY KEY (id);


--
-- Name: pk; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_agentes_ramais
    ADD CONSTRAINT pk PRIMARY KEY (id);


--
-- Name: pk_agenda_campanhas; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_agenda_campanhas
    ADD CONSTRAINT pk_agenda_campanhas PRIMARY KEY (id);


--
-- Name: pk_arvore_grupos; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_arvore_grupos
    ADD CONSTRAINT pk_arvore_grupos PRIMARY KEY (id);


--
-- Name: pk_auxiliares_filas; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_auxiliares_filas
    ADD CONSTRAINT pk_auxiliares_filas PRIMARY KEY (id);


--
-- Name: pk_conf_email; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_conf_email
    ADD CONSTRAINT pk_conf_email PRIMARY KEY (id);


--
-- Name: pk_config_painel_pa; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_config_painel_pa
    ADD CONSTRAINT pk_config_painel_pa PRIMARY KEY (id);


--
-- Name: pk_fha_filas; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_fha_filas
    ADD CONSTRAINT pk_fha_filas PRIMARY KEY (id);


--
-- Name: pk_filas_ramais; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_filas_ramais
    ADD CONSTRAINT pk_filas_ramais PRIMARY KEY (id);


--
-- Name: pk_grupo_de_campanhas; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_grupo_de_campanhas
    ADD CONSTRAINT pk_grupo_de_campanhas PRIMARY KEY (id);


--
-- Name: pk_grupos_campanhas; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_grupos_campanhas
    ADD CONSTRAINT pk_grupos_campanhas PRIMARY KEY (id);


--
-- Name: pk_grupos_captura; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_grupos_captura
    ADD CONSTRAINT pk_grupos_captura PRIMARY KEY (id);


--
-- Name: pk_grupos_classificacoes; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_grupos_qualificacoes
    ADD CONSTRAINT pk_grupos_classificacoes PRIMARY KEY (id_grupo, id_classificacao);


--
-- Name: pk_hosts_feixes; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_hosts_feixes
    ADD CONSTRAINT pk_hosts_feixes PRIMARY KEY (id);


--
-- Name: pk_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_filas_membros
    ADD CONSTRAINT pk_id PRIMARY KEY (id);


--
-- Name: pk_id_fila_syonet; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_filas_syonet
    ADD CONSTRAINT pk_id_fila_syonet PRIMARY KEY (id);


--
-- Name: pk_id_ws_syonet; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_config_syonet
    ADD CONSTRAINT pk_id_ws_syonet PRIMARY KEY (id);


--
-- Name: pk_ramais_relacionados; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_ramais_relacionados
    ADD CONSTRAINT pk_ramais_relacionados PRIMARY KEY (id);


--
-- Name: pk_vm50_chat; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_chat
    ADD CONSTRAINT pk_vm50_chat PRIMARY KEY (id);


--
-- Name: pk_vm50_extensoes; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_extensoes
    ADD CONSTRAINT pk_vm50_extensoes PRIMARY KEY (id);


--
-- Name: tb_central_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tb_central
    ADD CONSTRAINT tb_central_pkey PRIMARY KEY (id_central);


--
-- Name: tb_grupo_tronco_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tb_grupo_tronco
    ADD CONSTRAINT tb_grupo_tronco_pkey PRIMARY KEY (id);


--
-- Name: tb_monitora_agente_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tb_monitora_agente
    ADD CONSTRAINT tb_monitora_agente_pkey PRIMARY KEY (id);


--
-- Name: tb_realtime_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY tb_realtime
    ADD CONSTRAINT tb_realtime_pkey PRIMARY KEY (id);


--
-- Name: unique_fila_membro; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_filas_membros
    ADD CONSTRAINT unique_fila_membro UNIQUE (fila, agente);


--
-- Name: vm50_agenda_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_agenda
    ADD CONSTRAINT vm50_agenda_pkey PRIMARY KEY (id);


--
-- Name: vm50_agentes_grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_agentes_grupos
    ADD CONSTRAINT vm50_agentes_grupos_pkey PRIMARY KEY (agente, grupo);


--
-- Name: vm50_agentes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_agentes
    ADD CONSTRAINT vm50_agentes_pkey PRIMARY KEY (id);


--
-- Name: vm50_alarmes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_alarmes
    ADD CONSTRAINT vm50_alarmes_pkey PRIMARY KEY (usuario);


--
-- Name: vm50_ast_queue_member_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_ast_queue_member
    ADD CONSTRAINT vm50_ast_queue_member_pkey PRIMARY KEY (id);


--
-- Name: vm50_ast_queue_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_ast_queue
    ADD CONSTRAINT vm50_ast_queue_pkey PRIMARY KEY (id);


--
-- Name: vm50_campanhas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_campanhas
    ADD CONSTRAINT vm50_campanhas_pkey PRIMARY KEY (id);


--
-- Name: vm50_classificacao_chamadas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_classificacao_chamadas
    ADD CONSTRAINT vm50_classificacao_chamadas_pkey PRIMARY KEY (id);


--
-- Name: vm50_ddd_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_ddd
    ADD CONSTRAINT vm50_ddd_pkey PRIMARY KEY (id);


--
-- Name: vm50_dscrapida_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_dscrapida
    ADD CONSTRAINT vm50_dscrapida_pkey PRIMARY KEY (id);


--
-- Name: vm50_facilidades_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_facilidades
    ADD CONSTRAINT vm50_facilidades_pkey PRIMARY KEY (id);


--
-- Name: vm50_feixes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_feixes
    ADD CONSTRAINT vm50_feixes_pkey PRIMARY KEY (id);


--
-- Name: vm50_feixes_remotos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_feixes_remotos
    ADD CONSTRAINT vm50_feixes_remotos_pkey PRIMARY KEY (id);


--
-- Name: vm50_feriados_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_feriados
    ADD CONSTRAINT vm50_feriados_pkey PRIMARY KEY (dia);


--
-- Name: vm50_filas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_filas
    ADD CONSTRAINT vm50_filas_pkey PRIMARY KEY (id);


--
-- Name: vm50_grades_filas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_grades_filas
    ADD CONSTRAINT vm50_grades_filas_pkey PRIMARY KEY (fila, tipo);


--
-- Name: vm50_grupos_filas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_grupos_filas
    ADD CONSTRAINT vm50_grupos_filas_pkey PRIMARY KEY (grupo, fila);


--
-- Name: vm50_grupos_membros_ramais_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_grupos_membros_ramais
    ADD CONSTRAINT vm50_grupos_membros_ramais_pkey PRIMARY KEY (grupo, ramal);


--
-- Name: vm50_grupos_perso_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_grupos_perso
    ADD CONSTRAINT vm50_grupos_perso_pkey PRIMARY KEY (usuario, ramal);


--
-- Name: vm50_grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_grupos
    ADD CONSTRAINT vm50_grupos_pkey PRIMARY KEY (id);


--
-- Name: vm50_grupos_ramais_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_grupos_ramais
    ADD CONSTRAINT vm50_grupos_ramais_pkey PRIMARY KEY (id);


--
-- Name: vm50_integracao_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_integracao
    ADD CONSTRAINT vm50_integracao_pkey PRIMARY KEY (id);


--
-- Name: vm50_ligacao_id_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_ligacao_id
    ADD CONSTRAINT vm50_ligacao_id_pkey PRIMARY KEY (id);


--
-- Name: vm50_link_ligacao_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_link_ligacao
    ADD CONSTRAINT vm50_link_ligacao_pkey PRIMARY KEY (id_orig, id_dest);


--
-- Name: vm50_logins_relacionados_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_logins_relacionados
    ADD CONSTRAINT vm50_logins_relacionados_pkey PRIMARY KEY (agente, login);


--
-- Name: vm50_mensagens_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_mensagens
    ADD CONSTRAINT vm50_mensagens_pkey PRIMARY KEY (id);


--
-- Name: vm50_metodos_login_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_metodos_login
    ADD CONSTRAINT vm50_metodos_login_pkey PRIMARY KEY (id);


--
-- Name: vm50_mostra_oculta_agente_monitora_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_mostra_oculta_agente_monitora
    ADD CONSTRAINT vm50_mostra_oculta_agente_monitora_pkey PRIMARY KEY (id);


--
-- Name: vm50_orbitas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_orbitas
    ADD CONSTRAINT vm50_orbitas_pkey PRIMARY KEY (orbita);


--
-- Name: vm50_pausas_grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_pausas_grupos
    ADD CONSTRAINT vm50_pausas_grupos_pkey PRIMARY KEY (id_grupo, id_pausa);


--
-- Name: vm50_pausas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_pausas
    ADD CONSTRAINT vm50_pausas_pkey PRIMARY KEY (id);


--
-- Name: vm50_periodos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_periodos
    ADD CONSTRAINT vm50_periodos_pkey PRIMARY KEY (id);


--
-- Name: vm50_permissao_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_permissao
    ADD CONSTRAINT vm50_permissao_pkey PRIMARY KEY (id);


--
-- Name: vm50_placas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_placas
    ADD CONSTRAINT vm50_placas_pkey PRIMARY KEY (id);


--
-- Name: vm50_ramais_luzes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_ramais_luzes
    ADD CONSTRAINT vm50_ramais_luzes_pkey PRIMARY KEY (id);


--
-- Name: vm50_ramais_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_ramais
    ADD CONSTRAINT vm50_ramais_pkey PRIMARY KEY (id);


--
-- Name: vm50_relatorio_agentes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_relatorio_agentes
    ADD CONSTRAINT vm50_relatorio_agentes_pkey PRIMARY KEY (id);


--
-- Name: vm50_relatorio_grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_relatorio_grupos
    ADD CONSTRAINT vm50_relatorio_grupos_pkey PRIMARY KEY (id);


--
-- Name: vm50_relatorios_cc_grupo_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_relatorios_cc_grupo
    ADD CONSTRAINT vm50_relatorios_cc_grupo_pkey PRIMARY KEY (id);


--
-- Name: vm50_relatorios_cc_hoje_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_relatorios_cc_hoje
    ADD CONSTRAINT vm50_relatorios_cc_hoje_pkey PRIMARY KEY (id);


--
-- Name: vm50_relatorios_cc_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_relatorios_cc
    ADD CONSTRAINT vm50_relatorios_cc_pkey PRIMARY KEY (id);


--
-- Name: vm50_relatorios_pbx_hoje_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_relatorios_pbx_hoje
    ADD CONSTRAINT vm50_relatorios_pbx_hoje_pkey PRIMARY KEY (id);


--
-- Name: vm50_relatorios_pbx_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_relatorios_pbx
    ADD CONSTRAINT vm50_relatorios_pbx_pkey PRIMARY KEY (id);


--
-- Name: vm50_troncos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_troncos
    ADD CONSTRAINT vm50_troncos_pkey PRIMARY KEY (id);


--
-- Name: vm50_troncos_remotos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_troncos_remotos
    ADD CONSTRAINT vm50_troncos_remotos_pkey PRIMARY KEY (id);


--
-- Name: vm50_turnos_agentes_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_turnos_agentes
    ADD CONSTRAINT vm50_turnos_agentes_pkey PRIMARY KEY (id);


--
-- Name: vm50_turnos_filas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_turnos_filas
    ADD CONSTRAINT vm50_turnos_filas_pkey PRIMARY KEY (id);


--
-- Name: vm50_turnos_usuarios_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_turnos_usuarios
    ADD CONSTRAINT vm50_turnos_usuarios_pkey PRIMARY KEY (id);


--
-- Name: vm50_turnosmesa_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_turnosmesa
    ADD CONSTRAINT vm50_turnosmesa_pkey PRIMARY KEY (ramal);


--
-- Name: vm50_usuarios_filas_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_usuarios_filas
    ADD CONSTRAINT vm50_usuarios_filas_pkey PRIMARY KEY (usuario, fila);


--
-- Name: vm50_usuarios_grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_usuarios_grupos
    ADD CONSTRAINT vm50_usuarios_grupos_pkey PRIMARY KEY (usuario, grupo);


--
-- Name: vm50_usuarios_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_usuarios
    ADD CONSTRAINT vm50_usuarios_pkey PRIMARY KEY (id);


--
-- Name: vm50_usuarios_ramais_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY vm50_usuarios_ramais
    ADD CONSTRAINT vm50_usuarios_ramais_pkey PRIMARY KEY (usuario, ramal);


SET search_path = realtime, pg_catalog;

--
-- Name: cod_id; Type: CONSTRAINT; Schema: realtime; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY sip_ramal
    ADD CONSTRAINT cod_id PRIMARY KEY (cod_id);


--
-- Name: extensions_conf_pkey; Type: CONSTRAINT; Schema: realtime; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY extensions_conf
    ADD CONSTRAINT extensions_conf_pkey PRIMARY KEY (id);


--
-- Name: pk_id; Type: CONSTRAINT; Schema: realtime; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY queue_member_table
    ADD CONSTRAINT pk_id PRIMARY KEY (id);


--
-- Name: queues_table_pkey; Type: CONSTRAINT; Schema: realtime; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY queues_table
    ADD CONSTRAINT queues_table_pkey PRIMARY KEY (name);


--
-- Name: unique_queue_members; Type: CONSTRAINT; Schema: realtime; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY queue_member_table
    ADD CONSTRAINT unique_queue_members UNIQUE (queue_name, interface);


SET search_path = public, pg_catalog;

--
-- Name: fki_agente; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_agente ON vm50_agentes_ramais USING btree (agente);


--
-- Name: fki_fha_filas; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_fha_filas ON vm50_fha_filas USING btree (fila);


--
-- Name: fki_fha_ramais; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_fha_ramais ON vm50_fha_filas USING btree (ramal);


--
-- Name: fki_filas; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_filas ON vm50_auxiliares_filas USING btree (fila);


--
-- Name: fki_grupo_campanhas; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_grupo_campanhas ON vm50_grupos_campanhas USING btree (fk_grupo_campanha);


--
-- Name: fki_id_agente; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_id_agente ON vm50_agentes_desabilitados USING btree (id_agente);


--
-- Name: fki_id_fila; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_id_fila ON vm50_agentes_desabilitados USING btree (id_fila);


--
-- Name: fki_ramais; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_ramais ON vm50_auxiliares_filas USING btree (ramal);


--
-- Name: fki_ramal; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX fki_ramal ON vm50_agentes_ramais USING btree (ramal);


--
-- Name: in_tb_login_grupo_01; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX in_tb_login_grupo_01 ON tb_login_grupo USING btree (agentemonitora varchar_pattern_ops);


--
-- Name: in_tb_login_grupo_02; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX in_tb_login_grupo_02 ON tb_login_grupo USING btree (grupomonitora varchar_pattern_ops);


--
-- Name: in_vm50_gravacoes_01; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX in_vm50_gravacoes_01 ON vm50_gravacoes USING btree (id_ligacao);


--
-- Name: in_vm50_gravacoes_02; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX in_vm50_gravacoes_02 ON vm50_gravacoes USING btree (gravacao);


--
-- Name: in_vm50_gravacoes_03; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX in_vm50_gravacoes_03 ON vm50_gravacoes USING btree (diahora, gravacao);


--
-- Name: in_vm50_gravacoes_hoje_01; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX in_vm50_gravacoes_hoje_01 ON vm50_gravacoes_hoje USING btree (id_ligacao);


--
-- Name: in_vm50_gravacoes_hoje_02; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX in_vm50_gravacoes_hoje_02 ON vm50_gravacoes_hoje USING btree (gravacao);


--
-- Name: in_vm50_gravacoes_hoje_03; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX in_vm50_gravacoes_hoje_03 ON vm50_gravacoes_hoje USING btree (diahora, gravacao);


--
-- Name: in_vm50_link_ligacao_01; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX in_vm50_link_ligacao_01 ON vm50_link_ligacao USING btree (numero_orig, numero_dest, pa);


--
-- Name: in_vm50_link_ligacao_02; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX in_vm50_link_ligacao_02 ON vm50_link_ligacao USING btree (id_dest);


--
-- Name: in_vm50_relatorios_cc_hoje_01; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX in_vm50_relatorios_cc_hoje_01 ON vm50_relatorios_cc_hoje USING btree (diahora, ligacao);


--
-- Name: vm50_gravacoes_1; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_gravacoes_1 ON vm50_gravacoes USING btree (gravacao);


--
-- Name: vm50_gravacoes_2; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_gravacoes_2 ON vm50_gravacoes USING btree (diahora, gravacao);


--
-- Name: vm50_gravacoes_3; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_gravacoes_3 ON vm50_gravacoes USING btree (id_ligacao);


--
-- Name: vm50_link_ligacao_11; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_link_ligacao_11 ON vm50_link_ligacao USING btree (pa);


--
-- Name: vm50_link_ligacao_12; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_link_ligacao_12 ON vm50_link_ligacao USING btree (numero_orig, numero_dest);


--
-- Name: vm50_link_ligacao_3; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_link_ligacao_3 ON vm50_link_ligacao USING btree (estado);


--
-- Name: vm50_link_ligacao_4; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_link_ligacao_4 ON vm50_link_ligacao USING btree (id_orig);


--
-- Name: vm50_link_ligacao_5; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_link_ligacao_5 ON vm50_link_ligacao USING btree (numero_orig);


--
-- Name: vm50_link_ligacao_6; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_link_ligacao_6 ON vm50_link_ligacao USING btree (numero_dest);


--
-- Name: vm50_relatorios_cc_01; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_relatorios_cc_01 ON vm50_relatorios_cc USING btree (fila, ligacao);


--
-- Name: vm50_relatorios_cc_02; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_relatorios_cc_02 ON vm50_relatorios_cc USING btree (fila, ligacao, diahora);


--
-- Name: vm50_relatorios_cc_03; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_relatorios_cc_03 ON vm50_relatorios_cc USING btree (diahora, agente varchar_pattern_ops);


--
-- Name: vm50_relatorios_cc_agente; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_relatorios_cc_agente ON vm50_relatorios_cc USING btree (agente);


--
-- Name: vm50_relatorios_cc_diahora; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_relatorios_cc_diahora ON vm50_relatorios_cc USING btree (diahora);


--
-- Name: vm50_relatorios_cc_fila; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_relatorios_cc_fila ON vm50_relatorios_cc USING btree (fila);


--
-- Name: vm50_relatorios_cc_ligacao; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_relatorios_cc_ligacao ON vm50_relatorios_cc USING btree (ligacao);


--
-- Name: vm50_troncos_feixe; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_troncos_feixe ON vm50_troncos USING btree (feixe);


--
-- Name: vm50_troncos_numero_vdt; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX vm50_troncos_numero_vdt ON vm50_troncos USING btree (numero_vdt);


--
-- Name: altera_grupo_vm50_config_gerais; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER altera_grupo_vm50_config_gerais
    AFTER UPDATE ON vm50_grupos
    FOR EACH ROW
    EXECUTE PROCEDURE altera_grupo_vm50_config_geral();


--
-- Name: alterar_vm50_gravacoes; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER alterar_vm50_gravacoes
    BEFORE UPDATE ON vm50_gravacoes_hoje
    FOR EACH ROW
    EXECUTE PROCEDURE vm50_alterar_gravacoes();


--
-- Name: apaga_grupo_vm50_config_geral; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER apaga_grupo_vm50_config_geral
    AFTER DELETE ON vm50_grupos
    FOR EACH ROW
    EXECUTE PROCEDURE apaga_grupo_vm50_config_geral();


--
-- Name: grava_grupo_vm50_config_gerais; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER grava_grupo_vm50_config_gerais
    AFTER INSERT ON vm50_grupos
    FOR EACH ROW
    EXECUTE PROCEDURE grava_grupo_vm50_config_geral();


--
-- Name: grava_vm50_gravacoes; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER grava_vm50_gravacoes
    AFTER INSERT ON vm50_gravacoes_hoje
    FOR EACH ROW
    EXECUTE PROCEDURE vm50_inserir_gravacoes();


--
-- Name: vm50_amarra_conversou; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER vm50_amarra_conversou
    BEFORE UPDATE ON vm50_ligacao_id
    FOR EACH ROW
    EXECUTE PROCEDURE vm50_amarra_conversou();


--
-- Name: vm50_amarra_em_conversacao; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER vm50_amarra_em_conversacao
    BEFORE UPDATE ON vm50_link_ligacao
    FOR EACH ROW
    EXECUTE PROCEDURE vm50_amarra_em_conversacao();


--
-- Name: vm50_mudou_estado_mudou_hora; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER vm50_mudou_estado_mudou_hora
    BEFORE UPDATE ON vm50_link_ligacao
    FOR EACH ROW
    EXECUTE PROCEDURE vm50_mudou_estado_mudou_hora();


--
-- Name: vm50_nao_insere_duplicata; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER vm50_nao_insere_duplicata
    BEFORE INSERT ON vm50_relatorios_cc
    FOR EACH ROW
    EXECUTE PROCEDURE vm50_nao_insere_duplicatas();


--
-- Name: vm50_nao_insere_duplicata_pbx; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER vm50_nao_insere_duplicata_pbx
    BEFORE INSERT ON vm50_relatorios_pbx
    FOR EACH ROW
    EXECUTE PROCEDURE vm50_nao_insere_duplicatas_pbx();

ALTER TABLE vm50_relatorios_pbx DISABLE TRIGGER vm50_nao_insere_duplicata_pbx;


--
-- Name: crm_listas_campanha_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY crm_listas
    ADD CONSTRAINT crm_listas_campanha_id_fkey FOREIGN KEY (campanha_id) REFERENCES crm_campanhas(id) ON DELETE CASCADE;


--
-- Name: crm_listas_cliente_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY crm_listas
    ADD CONSTRAINT crm_listas_cliente_id_fkey FOREIGN KEY (cliente_id) REFERENCES crm_clientes(id) ON DELETE CASCADE;


--
-- Name: crm_telefones_clientes_cliente_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY crm_telefones_clientes
    ADD CONSTRAINT crm_telefones_clientes_cliente_id_fkey FOREIGN KEY (cliente_id) REFERENCES crm_clientes(id) ON DELETE CASCADE;


--
-- Name: fk9118a7273afdc805; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tb_monitora_agente
    ADD CONSTRAINT fk9118a7273afdc805 FOREIGN KEY (id_central) REFERENCES tb_central(id_central);


--
-- Name: fk_agente; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_agentes_ramais
    ADD CONSTRAINT fk_agente FOREIGN KEY (agente) REFERENCES vm50_agentes(id);


--
-- Name: fk_fha_filas; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_fha_filas
    ADD CONSTRAINT fk_fha_filas FOREIGN KEY (fila) REFERENCES vm50_filas(id);


--
-- Name: fk_fha_ramais; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_fha_filas
    ADD CONSTRAINT fk_fha_ramais FOREIGN KEY (ramal) REFERENCES vm50_ramais(id);


--
-- Name: fk_filas; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_auxiliares_filas
    ADD CONSTRAINT fk_filas FOREIGN KEY (fila) REFERENCES vm50_filas(id);


--
-- Name: fk_grupo_campanhas; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_grupos_campanhas
    ADD CONSTRAINT fk_grupo_campanhas FOREIGN KEY (fk_grupo_campanha) REFERENCES vm50_grupo_de_campanhas(id);


--
-- Name: fk_id_agente; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_agentes_desabilitados
    ADD CONSTRAINT fk_id_agente FOREIGN KEY (id_agente) REFERENCES vm50_agentes(id);


--
-- Name: fk_id_agente_supervisor; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tb_monitora_agente
    ADD CONSTRAINT fk_id_agente_supervisor FOREIGN KEY (agente_supervisor) REFERENCES vm50_agentes(id);


--
-- Name: fk_id_classificacao; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_grupos_qualificacoes
    ADD CONSTRAINT fk_id_classificacao FOREIGN KEY (id_classificacao) REFERENCES vm50_classificacao_chamadas(id) ON DELETE CASCADE;


--
-- Name: fk_id_fila; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_agentes_desabilitados
    ADD CONSTRAINT fk_id_fila FOREIGN KEY (id_fila) REFERENCES vm50_filas(id);


--
-- Name: fk_id_grupo; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_grupos_qualificacoes
    ADD CONSTRAINT fk_id_grupo FOREIGN KEY (id_grupo) REFERENCES vm50_grupos(id) ON DELETE CASCADE;


--
-- Name: fk_id_grupo_tronco; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_troncos
    ADD CONSTRAINT fk_id_grupo_tronco FOREIGN KEY (id_grupo_tronco) REFERENCES tb_grupo_tronco(id);


--
-- Name: fk_pai_vm50_ramal; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_ramais_relacionados
    ADD CONSTRAINT fk_pai_vm50_ramal FOREIGN KEY (pai) REFERENCES vm50_ramais(id);


--
-- Name: fk_ramais; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_auxiliares_filas
    ADD CONSTRAINT fk_ramais FOREIGN KEY (ramal) REFERENCES vm50_ramais(id);


--
-- Name: fk_ramal; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_agentes_ramais
    ADD CONSTRAINT fk_ramal FOREIGN KEY (ramal) REFERENCES vm50_ramais(id);


--
-- Name: fk_ramal_vm50_ramal; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY vm50_ramais_relacionados
    ADD CONSTRAINT fk_ramal_vm50_ramal FOREIGN KEY (ramal) REFERENCES vm50_ramais(id);


--
-- Name: tb_monitora_agente_id_central_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY tb_monitora_agente
    ADD CONSTRAINT tb_monitora_agente_id_central_fkey FOREIGN KEY (id_central) REFERENCES tb_central(id_central);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: dblink_connect_u(text); Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON FUNCTION dblink_connect_u(text) FROM PUBLIC;
REVOKE ALL ON FUNCTION dblink_connect_u(text) FROM postgres;
GRANT ALL ON FUNCTION dblink_connect_u(text) TO postgres;


--
-- Name: dblink_connect_u(text, text); Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON FUNCTION dblink_connect_u(text, text) FROM PUBLIC;
REVOKE ALL ON FUNCTION dblink_connect_u(text, text) FROM postgres;
GRANT ALL ON FUNCTION dblink_connect_u(text, text) TO postgres;


INSERT INTO vm50_usuarios VALUES (1, 'VDT', 'Administrador do sistemas Vdt', 'dd8680e0c2cc4bbbf843876a6464a6f154744b24', 'br', 'nada@vdt.com.br', 245, 'SU', '', 0, 0, 0, '', 0, 'FF0000', 1, 0, false, true, true, true, false, '', '');
INSERT INTO vm50_permissao VALUES (1, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);


--
-- PostgreSQL database dump complete
--

