// DHTML determina se o browser conhece javascript
var DHTML = (document.getElementById || document.all || document.layers);


// Le objetos da pagina indepentendemente do browser
function le_objeto(Nome) {
	if (!DHTML) return;
	var Saida = "";
	if      (document.getElementById) Saida = document.getElementById(Nome);
	else if (document.all)            Saida = document.all[Nome];
	else if (document.layers)         Saida = document.layers[Nome];
	return Saida;
}


// Verifica se existe o objeto com o id
function existeobj(Nome) {
	if (!DHTML) return;
	var Saida = false;
	if (document.getElementById(Nome)) Saida = true;
//	else if (document.all[Nome])       Saida = true;
//	else if (document.layers[Nome])    Saida = true;
//var k= document.getElementById(Nome);
//alert(Nome+" "+Saida+" "+k);
	return Saida;
}


//Retorna o conteudo de um objeto da pagina 
function conteudo(Nome) {
	if (!DHTML) return;
  var Objeto = le_objeto(Nome);
  try      { Saida = Objeto.value; }
  catch(e) {
    try      { Saida = Objeto.options[Objeto.selectedIndex].text; }
    catch(e) {
      try      { Saida = Objeto.innerHTML; }
      catch(e) { return false; }
    }
  }
  return Saida;
}


//Retorna o tamanho (em caracteres) de um conteudo de um objeto da pagina
function tamanho(Nome) {
	if (!DHTML) return;
  var Campo = conteudo(Nome);
  return Campo.length;
}


//Retorna a posicao x,y do ponteiro
function le_ponteiro(evt) {
 	var x=0, y=0;
 	//evt = window.event;
	// IE
	if (document.all) {
    x = (document.documentElement && document.documentElement.scrollLeft) ? document.documentElement.scrollLeft : document.body.scrollLeft;
		y = (document.documentElement && document.documentElement.scrollTop) ? document.documentElement.scrollTop : document.body.scrollTop;
		x += window.event.clientX;
		y += window.event.clientY;
  }
	// Outros Browsers
  else {
    x = evt.pageX;
		y = evt.pageY;
  }
	var Saida = new Array(x,y);
  return Saida;
}


//Encontra em uma lista um valor
function encontra(Valor,Lista) {
	if (!DHTML) return;
  var Tam = Lista.length;
  var i = 0;
  var Saida = false;
  while ((i < Tam) && !Saida){
    if (Valor==Lista[i]) Saida = true;
    else i++;
  }
  if (Saida) return i+1;
  return Saida;
}


//Permite somente a digitacao de numeros (48-57)
//e teclas de controle (menor que 32)
function somente_numero(Teclado) {
	if (!DHTML) return;
  var TeclasN = Array(48,49,50,51,52,53,54,55,56,57);
  if (Teclado.keyCode) codTecla = Teclado.keyCode;
  else codTecla = Teclado.which;
  if (codTecla < 32) return true;
  var Aux = encontra(codTecla,TeclasN);
  if (Aux>0) return true;
  return false;
}


//Permite somente a digitacao de numeros (48-57)
//dois pontos (58)
//e teclas de controle (menor que 32)
function somente_numero_hora(Teclado) {
	if (!DHTML) return;
  var TeclasN = Array(48,49,50,51,52,53,54,55,56,57,58);
  if (Teclado.keyCode) codTecla = Teclado.keyCode;
  else codTecla = Teclado.which;
  if (codTecla < 32) return true;
  var Aux = encontra(codTecla,TeclasN);
  if (Aux>0) return true;
  return false;
}


//Permite somente a digitacao de numeros (48-57)
//de DEL (8), Menos (9) Espaco (32)
//parentesis (40-41) e barra (45)
function somente_numero_telefone(Teclado) {
	if (!DHTML) return;
  var TeclasN = Array(8,9,32,40,41,45,48,49,50,51,52,53,54,55,56,57);
  if (Teclado.keyCode) codTecla = Teclado.keyCode;
  else codTecla = Teclado.which;
  var Aux = encontra(codTecla,TeclasN);
  if (Aux>0) return true;
  return false;
}


//Escolhe o tipo de formatacao numerica
function escolhe_mascara(Campo,Tipo) {
	if (!DHTML) return;
	Escolha = conteudo(Tipo);
	if (Escolha=='I') mascara_numero_inteiro(Campo);
	else mascara_numero(Campo);
  return;
}


//Formata a saida para numeros com separacao de milhar com duas casas decimais
function mascara_numero(Campo) {
	if (!DHTML) return;
  var Milhar = '.';
  var Decima = ',';
  Numero = conteudo(Campo);
  while (Numero.lastIndexOf(Milhar)>-1) Numero = Numero.replace(Milhar, "");
  Numero = Numero.replace(Decima, "");
  Numero = Numero.replace(/^[0]+/g,"");
  Tamanh = Numero.length;
  NovoNu = '';
  Contad = 0;
  for (i=Tamanh-2; i>0; i--){
    if (Contad==3) {
       NovoNu = Milhar + NovoNu;
       Contad = 0;
    }
    NovoNu = Numero.charAt(i-1) + NovoNu;
    Contad++;
  }
  if (Tamanh==0) Decima = '';
  if (Tamanh==1) Decima = '0,0';
  if (Tamanh==2) Decima = '0,';
  NovoNu = NovoNu + Decima + Numero.charAt(Tamanh-2) + Numero.charAt(Tamanh-1);
  Objeto = le_objeto(Campo);
  Objeto.value = NovoNu;
  return;
}


//Formata a saida para numeros com separacao de milhar sem casas decimais
function mascara_numero_inteiro(Campo) {
	if (!DHTML) return;
  var Milhar = '.';
  Numero = conteudo(Campo);
  while (Numero.lastIndexOf(Milhar)>-1) Numero = Numero.replace(Milhar, "");
  Tamanh = Numero.length;
  NovoNu = '';
  Contad = 0;
  for (i=Tamanh; i>0; i--){
    if (Contad==3) {
       NovoNu = Milhar + NovoNu;
       Contad = 0;
    }
    NovoNu = Numero.charAt(i-1) + NovoNu;
    Contad++;
  }
  Objeto = le_objeto(Campo);
  Objeto.value = NovoNu;
  return;
}


//Valida um CNPJ dado
function valida_cnpj(cnpj){
	if (!DHTML) return;
  var numeros, digitos, soma, i, resultado, pos, tamanho, digitos_iguais;
  digitos_iguais = 1;
  if (cnpj.length < 14 && cnpj.length < 15) return false;
  for (i = 0; i < cnpj.length - 1; i++) {
    if (cnpj.charAt(i) != cnpj.charAt(i + 1)) {
      digitos_iguais = 0;
      break;
    }
  }
  if (!digitos_iguais) {
    tamanho = cnpj.length - 2
    numeros = cnpj.substring(0,tamanho);
    digitos = cnpj.substring(tamanho);
    soma = 0;
    pos = tamanho - 7;
    for (i = tamanho; i >= 1; i--) {
      soma += numeros.charAt(tamanho - i) * pos--;
      if (pos < 2) pos = 9;
    }
    resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
    if (resultado != digitos.charAt(0)) return false;
    tamanho = tamanho + 1;
    numeros = cnpj.substring(0,tamanho);
    soma = 0;
    pos = tamanho - 7;
    for (i = tamanho; i >= 1; i--) {
      soma += numeros.charAt(tamanho - i) * pos--;
      if (pos < 2) pos = 9;
    }
    resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
    if (resultado != digitos.charAt(1)) return false;
    return true;
  }
  else return false;
}


//Faz um objeto visibility=visible aparecer
function visivel(Identif) {
	if (!DHTML) return;
	var Objeto = new le_objeto(Identif);
  var Mostra = Objeto.style.visibility;
  if (Mostra=='visible') return false;
  Objeto.style.visibility = 'visible';
  return true;
}


//Faz um objeto visibility=hidden desaparecer
function invisivel(Identif) {
	if (!DHTML) return;
	var Objeto = new le_objeto(Identif);
  var Mostra = Objeto.style.visibility;
  if (Mostra=='hidden') return false;
  Objeto.style.visibility = 'hidden';
  return true;
}


//Faz um objeto aparecer/desaparecer dependendo do seu estado atual
function visivel_invisivel(Identif) {
	if (!DHTML) return;
	var Objeto = new le_objeto(Identif);
  var Mostra = Objeto.style.visibility;
  if (Mostra=='visible') invisivel(Identif);
  else visivel(Identif);
  return true;
}


//Faz um objeto display=none aparecer
function aparece(Identif) {
	if (!DHTML) return;
	var Objeto = new le_objeto(Identif);
  var Mostra = Objeto.style.display;
  if (Mostra=='') return false;
  Objeto.style.display = '';
  return true;
}


//Faz um objeto display=none desaparecer
function esconde(Identif) {
	if (!DHTML) return;
	var Objeto = new le_objeto(Identif);
  var Mostra = Objeto.style.display;
  if (Mostra=='none') return false;
  Objeto.style.display = 'none';
  return true;
}


//Faz um objeto aparecer/desaparecer dependendo do seu estado atual
function aparece_esconde(Identif) {
	if (!DHTML) return;
	var Objeto = new le_objeto(Identif);
  var Mostra = Objeto.style.display;
  if (Mostra=='') esconde(Identif);
  else aparece(Identif);
  return true;
}


//Faz um objeto disable=false
function habilita(Identif) {
	if (!DHTML) return;
	var Objeto = new le_objeto(Identif);
  Objeto.disabled=false;
  return;
}


//Faz um objeto disable=true
function desabilita(Identif) {
	if (!DHTML) return;
	var Objeto = new le_objeto(Identif);
  Objeto.disabled=true;
  return;
}


//Faz um objeto disable=false/true dependendo do seu estado atual
function habilita_desabilita(Identif) {
	if (!DHTML) return;
	var Objeto = new le_objeto(Identif);
  var Mostra = Objeto.disabled;
  if (Mostra) habilita(Identif);
  else desabilita(Identif);
  return true;
}


//Tira o check de um objeto
function desmarca(Identif) {
	if (!DHTML) return;
	var Objeto = new le_objeto(Identif);
	try {Objeto.checked=false;}
	catch(e) {}
  try {Objeto.value="";}
  catch(e) {}  
  return;
}


//Tira o select de um objeto
function desselect(Identif) {
	if (!DHTML) return;
	var Objeto = new le_objeto(Identif);
	Objeto.selectedIndex=0;
  return;
}


//Valida um e-mail quanto aa sua grafia
function valida_email(Texto){
  var filter = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
	if (filter.test(Texto)) return true;
  else return false;
}


//Troca os espacos em branco por sublinhado
function branco_por_sublinhado(Texto){
  Saida = Texto.replace(/ /g,"_");
  Saida = Saida.replace(/&/g,"_");
  Saida = Saida.replace(/;/g,"_");
  return Saida;
}


//Preenche com zeros um numero inteiro
function preenche_comzeros(Numero,Tamanho){
  if (!DHTML) return;
  Zero = "";
  Tamanho = parseInt(Tamanho);
  for (i = 1; i <= Tamanho; i++) Zero += "0";
  Numero = String(parseInt(Numero));
  Numero = Zero + Numero.replace(" ","");
  TamAtu = parseInt(Numero.length);
  Numero = Numero.substr(TamAtu-Tamanho,Tamanho);
  return Numero;
}


//Localiza o selectedindex de um select a partir do value
function localiza_index(Campo,Valor) {
  if (!DHTML) return;
  Obj   = le_objeto(Campo);
  Tam   = Obj.length - 1;
  Saida = -1;
  i=0;
  while (Saida<0){
    k = Obj.options[i].value;
    if (k==Valor) Saida = i;
    i++;
    if ((Saida<0) && (i>Tam)) Saida = i;
  }
  return Saida;
}



//Localiza o selectedindex de um select a partir do value texto
function localiza_index_texto(Campo,Valor){
  if (!DHTML) return;
  Obj   = le_objeto(Campo);
  Tam   = Obj.length - 1;
//  Valor = parseInt(Valor);
  Saida = -1;
  i=0;
  while (Saida<0){
//    k = parseInt(Obj.options[i].value);
    k = Obj.options[i].text;
    if (k==Valor) Saida = i;
    i++;
    if ((Saida<0) && (i>Tam)) Saida = i;
  }
  return Saida;
}



//Adiciona um option em um select
function adiciona_option(Campo,Texto,Valor){
  if (!DHTML) return;
  Obj       = le_objeto(Campo);
  Tam       = Obj.length;
  Aux       = document.createElement('option');
  Aux.text  = Valor+"-"+Texto;
  Aux.value = Valor;
  Valor     = parseInt(Valor);
  Saida     = -1;
  i         = 0;
  k         = parseInt(Obj.options[i].value);
  while (k<Valor){
    i++;
    k = parseInt(Obj.options[i].value);
  }
  Pos = Obj.options[i];
  try {
    Obj.add(Aux,Pos);
    Obj.selectedIndex = Pos;
  } catch(e){
    Obj.add(Aux);
    Obj.selectedIndex = Obj.length - 1;
  }
}



//Move um item de select para outro
//Comando pode ser >, >>, <<, <
function Move(Comando,Esquerda,Direita) {
  var De, Para;
  var Tudo = false;
  switch (Comando.value) {
    case '<<':
      Tudo = true;
   case '<':
      De   = le_objeto(Direita); 
      Para = le_objeto(Esquerda);
      break;
    case '>>':
      Tudo = true;
    case '>':
      De   = le_objeto(Esquerda);
      Para = le_objeto(Direita);
      break;
    default:
      alert("Erro, verifique o comando!");
  }
  for (var i = De.length - 1; i >= 0; i--) {
    var o = De.options[i];
    if (Tudo || o.selected) {
      De.remove(i);
      try { Para.add(o, null); } // Standard method, fails in IE (6&7 at least)
      catch (e) { Para.add(o); } // IE only
    }
  }
}



//Remove de um select um valor
function Remove_de_um_select(Objeto,Oque) {
  De = le_objeto(Oque);
  i  = localiza_index(Objeto,Oque)
  De.remove(i);
}



//Adiciona em um select um valor
function Adiciona_a_um_select(Objeto,Oque) {
  var Para = le_objeto(Objeto);
  var o    = document.createElement('option');
  o.text   = Oque;
  o.value  = Oque;
  try { Para.add(o, null); } // Standard method, fails in IE (6&7 at least)
  catch (e) { Para.add(o); } // IE only
}



//Seleciona tudo de um select
function Seleciona_tudo(Campo) {
  var Obj = le_objeto(Campo); 
  for (var i=0 ; i < Obj.length; i++) { Obj.options[i].selected = true; }
}



//Desseleciona tudo de um select
function Desseleciona_tudo(Campo) {
  var Obj = le_objeto(Campo);
  for (var i=0 ; i < Obj.length; i++) { Obj.options[i].selected = false; }
}



//Apaga todos os options de um select
function Apaga_tudo(Campo) {
  var Obj = le_objeto(Campo);
  for (var i=Obj.length-1 ; i > -1; i--) { Obj.remove(i); }
}


//Cria a funcao que pesquisa um elemento, ou grupo de
//elementos pela classe
function getElementsByClass( searchClass, domNode, tagName) {
	if (domNode == null) domNode = document;
	if (tagName == null) tagName = '*';
	var el = new Array();
	var tags = domNode.getElementsByTagName(tagName);
	var tcl = " "+searchClass+" ";
//	var tcl = searchClass;
	for(i=0,j=0; i<tags.length; i++) {
		var test = " " + tags[i].className + " ";
//alert(i + tags[i].className);
//		var test = tags[i].className;
		if (test.indexOf(tcl)!=-1) el[j++] = tags[i];
	}
	return el;
}


//Determina se existe uma variavel
function existe(variavel) {
//alert ("x"+variavel+"Y");
//alert (eval(variavel));
  try {
    if (eval(variavel)) {}
  }
  catch(err) {
    return false;
  }
  return true;
}



// Diferenca entre um horario e agora
// Tempo1 em hh:mm:ss ou mm:ss
function quantotempopassou(Tempo) {
  if ((Tempo.length!=5) && (Tempo.length!=8)) return "00:00:00";
  Tempo1 = Tempo.split(":");
  if (Tempo.length==5) {
    H1 = 0;
    M1 = Tempo1[0];
    S1 = Tempo1[1];  
  }
  else {
    H1 = Tempo1[0];
    M1 = Tempo1[1];
    S1 = Tempo1[2];  
  }
  if ((H1.length>2) || (M1.length>2) || (S1.length>2)) return "00:00:00";
  Hoje = new Date();
  H2 = Hoje.getHours();
  M2 = Hoje.getMinutes();
  S2 = Hoje.getSeconds();
  if (H1==0) H=0;
  else H = H2-H1;
  M = M2-M1;
  S = S2-S1;
  if (S<0) {
    M--;
    S = 60 + S;
  }
  if (M<0) {
    H--;
    M = 60 + M;
  }
  if (H<0) return -1;
  H = "00" + H; H = H.substr(H.length-2);
  M = "00" + M; M = M.substr(M.length-2);
  S = "00" + S; S = S.substr(S.length-2);
  Saida = H+":"+M+":"+S;
  Chega = H2+":"+M2+":"+S2;
  //alert (Chega + "---" + Saida);
  return Saida;
}



// Diferenca entre um horario e outro
// TempoA em hh:mm:ss ou mm:ss
// TempoB em hh:mm:ss ou mm:ss (menor que Tempo1)
function subtracao_entre_horas(TempoA,TempoB) {
  if ((TempoA.length!=5) && (TempoA.length!=8)) return "00:00:00";
  Tempo1 = TempoA.split(":");
  if (TempoA.length==5) {
    H1 = 0;
    M1 = Tempo1[0];
    S1 = Tempo1[1];
  }
  else {
    H1 = Tempo1[0];
    M1 = Tempo1[1];
    S1 = Tempo1[2];
  }
  if ((H1.length>2) || (M1.length>2) || (S1.length>2)) return "00:00:00";
  if ((TempoB.length!=5) && (TempoB.length!=8)) return "00:00:00";
  Tempo2 = TempoB.split(":");
  if (TempoB.length==5) {
    H2 = 0;
    M2 = Tempo2[0];
    S2 = Tempo2[1];
  }
  else {
    H2 = Tempo2[0];
    M2 = Tempo2[1];
    S2 = Tempo2[2];
  }
  if ((H2.length>2) || (M2.length>2) || (S2.length>2)) return "00:00:00";
  if (H1==0) H=0;
  else H = H1-H2;
  M = M1-M2;
  S = S1-S2;
  if (S<0) {
    M--;
    S = 60 + S;
  }
  if (M<0) {
    H--;
    M = 60 + M;
  }
  if (H<0) return "00:00:00";
  H = "00" + H; H = H.substr(H.length-2);
  M = "00" + M; M = M.substr(M.length-2);
  S = "00" + S; S = S.substr(S.length-2);
  Saida = H+":"+M+":"+S;
  Chega = H2+":"+M2+":"+S2;
  //alert (Chega + "---" + Saida);
  return Saida;
}



// Diferenca entre um horario e outro sendo que se TempoB for menor que Tempo A, considera uma virada de 24 horas
// TempoA em hh:mm:ss ou mm:ss
// TempoB em hh:mm:ss ou mm:ss (menor que Tempo1)
function subtracao_entre_horas_vira_dia(TempoA,TempoB) {
  if ((TempoA.length!=5) && (TempoA.length!=8)) return "00:00:00";
  Tempo1 = TempoA.split(":");
  if (TempoA.length==5) {
    H1 = '0';
    M1 = Tempo1[0];
    S1 = Tempo1[1];
  }
  else {
    H1 = Tempo1[0];
    M1 = Tempo1[1];
    S1 = Tempo1[2];
  }
  if ((H1.length>2) || (M1.length>2) || (S1.length>2)) return "00:00:00";
  if ((TempoB.length!=5) && (TempoB.length!=8)) return "00:00:00";
  Tempo2 = TempoB.split(":");
  if (TempoB.length==5) {
    H2 = '0';
    M2 = Tempo2[0];
    S2 = Tempo2[1];
  }
  else {
    H2 = Tempo2[0];
    M2 = Tempo2[1];
    S2 = Tempo2[2];
  }
  if ((H2.length>2) || (M2.length>2) || (S2.length>2)) return "00:00:00";
  if ((H1+' '+M1+' '+S1) < (H2+' '+M2+' '+S2)) H1 = parseInt(H1,10) + 24;
  else H1 = parseInt(H1,10);
  M1 = parseInt(M1,10); S1 = parseInt(S1,10);
  H2 = parseInt(H2,10); M2 = parseInt(M2,10); S2 = parseInt(S2,10);
  if (H1==0) H=0;
  else H = H1-H2;
  M = M1-M2;
  S = S1-S2;
  if (S<0) {
    M--;
    S = 60 + S;
  }
  if (M<0) {
    H--;
    M = 60 + M;
  }
  if (H<0) return "00:00:00";
  //if (H<0) H = 24 + H;
  H = "00" + H; H = H.substr(H.length-2);
  M = "00" + M; M = M.substr(M.length-2);
  S = "00" + S; S = S.substr(S.length-2);
  Saida = H+":"+M+":"+S;
  Chega = H2+":"+M2+":"+S2;
  //alert (Chega + "---" + Saida);
  return Saida;
}



// Soma dois horarios
// TempoA em hh:mm
// TempoB em hh:mm
function soma_horas(TempoA,TempoB) {
  if (TempoA.length!=5) return "00:00";
  Tempo1 = TempoA.split(":");
  if (TempoA.length==5) {
    H1 = Tempo1[0];
    M1 = Tempo1[1];
  }
  if ((H1.length>2) || (M1.length>2)) return "00:00";
  H1 = parseInt(H1,10); M1 = parseInt(M1,10);
  if (TempoB.length!=5) return "00:00";
  Tempo2 = TempoB.split(":");
  if (TempoB.length==5) {
    H2 = Tempo2[0];
    M2 = Tempo2[1];
  }
  if ((H2.length>2) || (M2.length>2)) return "00:00";
  H2 = parseInt(H2,10); M2 = parseInt(M2,10);
  M = M1 + M2;
  H = H1 + H2;
  if (M>59) {
    H = H + 1;
    M = M - 60;
  }
  H = "00" + H; H = H.substr(H.length-2);
  M = "00" + M; M = M.substr(M.length-2);
  Saida = H+":"+M;
  return Saida;
}



// Verifica de TempoA eh maior que TempoB
// TempoA em hh:mm
// TempoB em hh:mm
function eh_maior_entre_horas(TempoA,TempoB) {
  if (TempoA.length!=5) return false;
  Tempo1 = TempoA.split(":");
  H1 = Tempo1[0];
  M1 = Tempo1[1];
  if ((H1.length>2) || (M1.length>2)) return false;
  if (TempoB.length!=5) return false;
  Tempo2 = TempoB.split(":");
  H2 = Tempo2[0];
  M2 = Tempo2[1];
  if ((H2.length>2) || (M2.length>2)) return false;
  H = H1 - H2;
  M = M1 - M2;
  if (M<0) {
    H--;
    M = 60 + M;
  }
  if (H < 0) return false;
  if (M < 0) return false;
  return true;
}



// Converte um horario todo em segundo
// TempoA em hh:mm:ss ou mm:ss
function tudo_em_segundo(TempoA) {
  if ((TempoA.length!=5) && (TempoA.length!=8)) return 0;
  Tempo1 = TempoA.split(":");
  if (TempoA.length==5) {
    H1 = 0;
    M1 = Tempo1[0];
    S1 = Tempo1[1];
  }
  else {
    H1 = Tempo1[0];
    M1 = Tempo1[1];
    S1 = Tempo1[2];
  }
  if ((H1.length>2) || (M1.length>2) || (S1.length>2)) return 0;
  Saida = parseInt(S1) + (parseInt(M1)*60) + (parseInt(H1)*3600);
  //alert(TempoA+'=>'+H1+' '+M1+' '+S1+' '+'='+Saida);
  return Saida;
}



// passou_de_um_minuto
// TempoA em hh:mm:ss ou mm:ss
// TempoB em hh:mm:ss ou mm:ss (menor que Tempo1)
function passou_de_um_minuto(TempoA,TempoB) {
  if ((TempoA.length!=5) && (TempoA.length!=8)) return true;
  Tempo1 = TempoA.split(":");
  if (TempoA.length==5) {
    H1 = 0;
    M1 = Tempo1[0];
    S1 = Tempo1[1];
  }
  else {
    H1 = Tempo1[0];
    M1 = Tempo1[1];
    S1 = Tempo1[2];
  }
  if ((H1.length>2) || (M1.length>2) || (S1.length>2)) return true;
  if ((TempoB.length!=5) && (TempoB.length!=8)) return true;
  Tempo2 = TempoB.split(":");
  if (TempoB.length==5) {
    H2 = 0;
    M2 = Tempo2[0];
    S2 = Tempo2[1];
  }
  else {
    H2 = Tempo2[0];
    M2 = Tempo2[1];
    S2 = Tempo2[2];
  }
  if ((H2.length>2) || (M2.length>2) || (S2.length>2)) return true;
  if (H1==0) H=0;
  else H = H1-H2;
  M = M1-M2;
  S = S1-S2;
  if (S<0) {
    M--;
    S = 60 + S;
  }
  if (M<0) {
    H--;
    M = 60 + M;
  }
  if (H<0) return true;
  if (M>1) Saida = true;
  else Saida = false;
  //alert (Chega + "---" + Saida);
  return Saida;
}


// Serve para ler campos escondidos e mostrar
// em campos aparentes no formato inner.html
function de_escondido_para_aparente_ine(Escondido,Aparente,Numero) {
  for (x in Escondido) {
    Aux  = Escondido[x]+"_"+Numero;
    Obj1 = le_objeto(Aparente[x]);
    Obj2 = le_objeto(Aux);
    Obj1.value = Obj2.innerHTML;
  }
}


// Serve para ler campos escondidos e mostrar
// em campos aparentes no formato value
function de_escondido_para_aparente_val(Escondido,Aparente,Numero) {
  for (x in Escondido) {
    Aux  = Escondido[x]+"_"+Numero;
    if (document.getElementById(Aparente[x])) {
      Obj1 = le_objeto(Aparente[x]);
      if (document.getElementById(Aux)) {
        Obj2 = le_objeto(Aux);
        Obj1.value = Obj2.value;
      }
    }
  }
}


// Serve para ler campos escondidos e mostrar
// em campos aparentes no formato select unico
function de_escondido_para_aparente_sel_um(Escondido,Aparente,Numero) {
  for (x in Escondido) {
    Aux  = Escondido[x]+"_"+Numero;
    Obj1 = le_objeto(Aparente[x]);
    Obj2 = le_objeto(Aux);
    Valo = Obj2.value;
    Indi = localiza_index(Aparente[x],Valo);
    if (Indi < Obj1.length) { Obj1.selectedIndex = Indi; }
  }
}


// Serve para ler campos escondidos e mostrar
// em campos aparentes no formato select esquerda - direita
function de_escondido_para_aparente_sel_ed(Escondido,Aparente,Numero) {
  zera_combo();
  //zera_grupos();
  for (y in Escondido) {
    De   = le_objeto(Aparente[y]+"l[]");
    Para = le_objeto(Aparente[y]+"r[]");
    Aux  = Escondido[y]+"_"+Numero;
    Obj2 = le_objeto(Aux);
    if (Obj2) {
      Valo = Obj2.value;
      if (Valo.length>1) {
        FFil = Valo.split(",");
        for (x in FFil) {
          if (FFil[x].length>1) {
            De    = le_objeto(Aparente[y]+"l[]");
            Para  = le_objeto(Aparente[y]+"r[]");
            o     = document.createElement('option');
            Indi  = localiza_index(Aparente[y]+"l[]",FFil[x]);
//            Indi = localiza_index(De,FFil[x]);
            o.text = De.options[Indi].text;
            De.remove(Indi);
            o.value = FFil[x];
//            o.text = FFil[x];
            try { Para.add(o, null); } // Standard method, fails in IE (6&7 at least)
            catch (e) { Para.add(o); } // IE only
          }
        }
      }
    }
  }
}


// Serve para ler campos escondidos e mostrar
// em campos aparentes no formato select somente direita
function de_escondido_para_aparente_sel_so_dir(Escondido,Aparente,Numero) {
  zera_combo();
  for (y in Escondido) {
    Para = le_objeto(Aparente[y]+"r[]");
    Aux  = Escondido[y]+"_"+Numero;
    Obj2 = le_objeto(Aux);
    if (Obj2) {
      Valo = Obj2.value;
      if (Valo.length>1) {
        FFil = Valo.split(",");
        for (x in FFil) {
          if (FFil[x].length>1) {
            Para  = le_objeto(Aparente[y]+"r[]");
            o     = document.createElement('option');
            o.text  = FFil[x];
            o.value = FFil[x];
            try { Para.add(o, null); } // Standard method, fails in IE (6&7 at least)
            catch (e) { Para.add(o); } // IE only
          }
        }
      }
    }
  }
}



// Tira todos os options de ul select
function zera_select(Lista) {
  var i;
  var Obj = le_objeto(Lista);
  for(i=Obj.length-1; i>=0; i--) { Obj.remove(i); }
}



// Mostra ajuda quando o mouse estiver em cima
// Modo de usar:
//  - Crie no peh da tela o seguinte div:
//    <div id="ajuda" style="{width:200px; display:none; float:left; position:absolute; top:40px; background-color:#E0E0E0; border-top:1px solid #D0D0D0; border-left:1px solid #D0D0D0; border-right:2px solid #606060; border-bottom:2px solid #606060; text-align:center;}"></div>
//  - Onde quiser o help coloque o seguinte codigo:
//     onMouseover="ajuda(event,'L','Mensagem de ajuda');" onMouseout="ajuda(event,'D','');"
function ajuda(evento,Estado,Mensagem,FontSize) {
  var Obj     = le_objeto('ajuda');
  var Posicao = le_ponteiro(evento);
  var Aux     = Mensagem.split("<td");
  if (Estado=='D') {
    Obj.style.display = 'none';
  } else if (Estado=='L') {
    Obj.style.left    = Posicao[0]-100;
    Obj.style.top     = Posicao[1]-30;
	if(FontSize!=undefined) Obj.style.fontSize= FontSize+"pt";
    Obj.innerHTML     = Mensagem;
    Obj.style.display = 'block';
  }
  return;
}


// Funcao que verifica se o campo eh uma data valida
function checa_data(pObj) {
  var expReg = /^((0[1-9]|[12]\d)\/(0[1-9]|1[0-2])|30\/(0[13-9]|1[0-2])|31\/(0[13578]|1[02]))\/(19|20)?\d{2}$/;
  var aRet = true;
  if ((pObj) && (pObj.match(expReg)) && (pObj != '')) {
    var dia = pObj.substring(0,2);
    var mes = pObj.substring(3,5);
    var ano = pObj.substring(6,10);
    if ((mes == 4 || mes == 6 || mes == 9 || mes == 11 ) && dia > 30)
      aRet = false;
    else
      if ((ano % 4) != 0 && mes == 2 && dia > 28)
        aRet = false;
      else
        if ((ano%4) == 0 && mes == 2 && dia > 29)
          aRet = false;
  }  else
    aRet = false;
  return aRet;
}


// Funcao que verifica se o campo eh uma hora valida
function checa_hora(horario) {
  if ((horario) && (horario != '') && (horario.length == 5)) {
    var Hora = horario.substr(0,2);
    var Minu = horario.substr(3,2);
    if ((Hora >= '00') && (Hora <= '23')) {
      if ((Minu >= '00') && (Minu <= '59')) {
        Saida = true;
      } else {
        Saida = false;
      }
    } else {
      Saida = false;
    }
  } else {
    Saida = false;
  }
  return Saida;
}


// Funcao que gera um option completo com os dias da semana
// ds faz o selected do dia escolhido
function option_dia_da_semana(ds) {
  var Diasem = '';
  if (ds=='seg') Diasem+='<option value="seg" selected>Seg</option>';
  else           Diasem+='<option value="seg">Seg</option>';
  if (ds=='ter') Diasem+='<option value="ter" selected>Ter</option>';
  else           Diasem+='<option value="ter">Ter</option>';
  if (ds=='qua') Diasem+='<option value="qua" selected>Qua</option>';
  else           Diasem+='<option value="qua">Qua</option>';
  if (ds=='qui') Diasem+='<option value="qui" selected>Qui</option>';
  else           Diasem+='<option value="qui">Qui</option>';
  if (ds=='sex') Diasem+='<option value="sex" selected>Sex</option>';
  else           Diasem+='<option value="sex">Sex</option>';
  if (ds=='sab') Diasem+='<option value="sab" selected>Sab</option>';
  else           Diasem+='<option value="sab">Sab</option>';
  if (ds=='dom') Diasem+='<option value="dom" selected>Dom</option>';
  else           Diasem+='<option value="dom">Dom</option>';
  return Diasem;
}

// Serve para ler campos escondidos e mostrar
// em campos aparentes no formato select esquerda - direita
function de_escondido_para_aparente_sel_ed1(Escondido,Aparente,Numero) {
  //zera_combo();
  
  //zera_grupos();
  for (y in Escondido) {
    De   = le_objeto(Aparente[y]+"l[]");
    Para = le_objeto(Aparente[y]+"r[]");
    Aux  = Escondido[y]+"_"+Numero;
    Obj2 = le_objeto(Aux);
    if (Obj2) {
      Valo = Obj2.value;
      if (Valo.length>1) {
        FFil = Valo.split(",");
        for (x in FFil) {
          if (FFil[x].length>1) {
            De    = le_objeto(Aparente[y]+"l[]");
            Para  = le_objeto(Aparente[y]+"r[]");
            o     = document.createElement('option');
            Indi  = localiza_index(Aparente[y]+"l[]",FFil[x]);
//            Indi = localiza_index(De,FFil[x]);
            o.text = De.options[Indi].text;
            De.remove(Indi);
            o.value = FFil[x];
//            o.text = FFil[x];
            try { Para.add(o, null); } // Standard method, fails in IE (6&7 at least)
            catch (e) { Para.add(o); } // IE only
          }
        }
      }
    }
  }
}

function sleep(milliseconds){
	var start = new Date().getTime();
	for (var i = 0; i < 1e7; i++) {
		if ((new Date().getTime() - start) > milliseconds){
			break;
		}
	}
}

function adicionar_linha_tabela(id_linha, dados_linha, estilo, tabela){
	var tb = document.getElementById(tabela).getElementsByTagName("TBODY")[0];
	if(tb == null) return;
	var row = document.createElement("TR");
	row.id = id_linha;
	for(i = 0; i < dados_linha.length; i++){
		var td = document.createElement("TD");
		td.appendChild(document.createTextNode(dados_linha[i]));
		td.className = estilo;
		row.appendChild(td);
	}
	tb.appendChild(row);
}

function remover_linha_tabela(id_linha){
	var row_antiga = document.getElementById(id_linha);
	if(row_antiga != null){
		row_antiga.parentNode.removeChild(row_antiga);
	}
}

function formata_hora(secs){
   var date = new Date(secs*1000);
   var time = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
   return time;
}

function editarCampo(td, id){
    var span = document.getElementById(id);
    if(span.innerHTML == "") return;
    var conteudo = span.innerHTML;
    var texto = '<input type="text" value="'+conteudo+'" id="'+id+'" style="font-size:11pt; background-color:#fff;"/>';
    td.innerHTML = texto;
}
