#!/usr/bin/perl -w
#

use DBI;
use IO::Socket;


############################################################################
### Funcao para logar/deslogar agente via comando no sistema operacional ###
###                                                                      ###
### Chamada: vdt_interface [agente] [ramal] [acao]                       ###
### Sendo a acao:                                                        ###
###   1 - para logar;                                                    ###
###   0 - para deslogar.                                                 ###
### Retorna:                                                             ###
###   0 - Funcao realizada com sucesso                                   ###
###   1 - [agente] em branco                                             ###
###   2 - [ramal] em branco                                              ###
###   3 - [acao] em branco ou nao eh 0 nem 1                             ###
###   4 - [agente] inexistente no sistema                                ###
###   5 - [ramal] inexistente no sistema                                 ###
###   6 - erro na integracao com o Asterisk                              ###
###                                                                      ###
############################################################################




############################
## Definicao de variaveis ##
############################
sub pesquisa($);
my $Saida   = 0;
my $Agente  = "";
my $Senha   = "";
my $Ramal   = "";
my $Acao    = "";
my $Comando = "";
my $dbh     = DBI->connect("dbi:PgPP:dbname=vdt", "postgres", "", {AutoCommit => 1});
my $sock = new IO::Socket::INET (PeerAddr  => 'localhost', PeerPort  => '5105', Proto => 'tcp',);
 print "Could not create socket: $!\n" unless $sock;
 $sock->autoflush(1);

### Testa a existencia dos argumentos
if (!defined($ARGV[0])) {
  $Saida = 1;
} elsif (($ARGV[0] eq "") || ($ARGV[0] eq "0")) {
  $Saida = 1;
} elsif (!defined($ARGV[1])) {
  $Saida = 2;
} elsif (($ARGV[1] eq "") || ($ARGV[1] eq "0")) {
  $Saida = 2;
} elsif (!defined($ARGV[2])) {
  $Saida = 3;
} elsif (($ARGV[2] eq "") || (($ARGV[2] ne "0") && ($ARGV[2] ne "1"))) {
  $Saida = 3;
}
#print $Saida;
#print "\n";
return $Saida if ($Saida ne 0);

### Testa a validade dos argumentos
$Agente = pesquisa( "SELECT login FROM vm50_agentes WHERE login='$ARGV[0]'" );
$Saida  = 4 if ($Agente ne $ARGV[0]);
if ($Saida eq 0) {
  $Senha = pesquisa( "SELECT senha FROM vm50_agentes WHERE login='$Agente'" );
  $Ramal = pesquisa( "SELECT ramal FROM vm50_ramais  WHERE ramal='$ARGV[1]'" );
  $Saida = 5 if ($Ramal ne $ARGV[1]);
}
#print $Saida;
#print "\n";
return $Saida if ($Saida ne 0);
$Acao = $ARGV[2];

if ($Acao eq "1") {
 $Comando = "Action: Command\r\nCommand: Agent Logoff Agent/$Agente \r\n\r\n";
} elsif ($Acao eq "0") {
 $Comando = "Action: Login\r\nUsername: $Agente\r\nSecret: $Senha \r\n\r\n";
}

if ($Comando ne "") {
  print $sock $Comando;
} else {
  $Saida = 6;
}

print $Agente;
print "\n";

print $Ramal;
print "\n";

print $Acao;
print "\n";
return $Saida;




##################
## Sub Pesquisa ##
##################
sub pesquisa($) {
  my $sqlp = $_[0];
	my $res = "E";
	my $sth = $dbh->prepare($sqlp) or return "E";
	$sth->execute() or return "E";
	my $Contar = 0;
	my @data = "";
  while (@data = $sth->fetchrow_array()) {
   	$res = $data[0];
    $Contar = $Contar + 1;
  }
  $res = "E" unless defined $res;
  $sth->finish;
  $res = "E" if ($Contar gt 1);
  $res =~ s/^\s+//;    #Remove espacos antes
  $res =~ s/\s+$//;    #Remove espacos depois
	return $res;
}
