#!/usr/bin/perl -w
#

use DBI;
use IO::File;
use IO::Socket;
use POSIX qw(setsid);
use File::Spec::Functions qw(canonpath);
use File::Basename;



################################
## Le arquivo de configuracao ##
################################
my $Diretorio_Config = `pwd`;
chomp($Diretorio_Config);
my $Arquivo_Atual = canonpath($0);
my @Aux_Caminho = split(/\//, $Arquivo_Atual);
my $Aux_CaminhoT = @Aux_Caminho;
for (my $i=0; $i<$Aux_CaminhoT-1; $i++) {
  $Diretorio_Config = $Diretorio_Config."/".$Aux_Caminho[$i];
}
$Diretorio_Config = $Diretorio_Config."/";
my $Arquivo_Config = $Diretorio_Config."config.php";
open(ACONF, $Arquivo_Config) || die("Could not open file!");
my @Dados_Brutos=<ACONF>;
close(ACONF);



######################
## Monta o PID 1185 ##
######################
chdir '/'                 or die "Can't chdir to /: $!";
umask 0;
open STDIN, '/dev/null'   or die "Can't read /dev/null: $!";
open STDERR, '>>/var/log/asterisk/vdtpid.log' or die "Can't write to /dev/null: $!";
#open STDERR, '>>/var/log/asterisk/vdtamp.log' or die "Can't write to /dev/null: $!";
defined(my $pid = fork)   or die "Can't fork: $!";
open PS_F, "ps -C vdt_amp.pl -o pid|";
 my $despreza = <PS_F>;
 my $pidid = <PS_F>;
 $pidid = $pidid + 1;
close(PS_F);
if ( open PID, '>/var/run/vdt_amp.pid' ) {
  print PID "$pidid\n";
  close(PID);
}
exit if $pid;


################################
## Le arquivo de configuracao ##
################################
my $Astman_H = "Erro";
my $Astman_P = "Erro";
foreach my $Linha (@Dados_Brutos) {
  chomp($Linha);
  if ($Linha =~ m/=/) {
    (my $Campo,my $Valor)=split(/=/,$Linha);
    $Campo =~ s/ //gi;
    $Campo = substr($Campo,1);
    $Valor =~ s/"//gi;  #"
    $Valor =~ s/;//gi;
    $Valor =~ s/ //gi;
    if ($Valor =~ m/\//) {
      (my $Aux1,my $Aux2)=split(/\//,$Valor);
      $Valor = $Aux1;
    }
    if ($Campo eq "Host") {
      $Astman_H = $Valor;
    } elsif ($Campo eq "Porta") {
      $Astman_P = $Valor;
    }
  #print $Campo."=>".$Valor."-\n";
  }
}
#print $Astman_H .":". $Astman_P ."\n";


open STDOUT, '>>/var/log/asterisk/vdterrosaida.log' or die "Can't write to /dev/null: $!";


############################
## Definicao de variaveis ##
############################
sub le_meia($);
sub grava_log($);
sub grava_log2($);
sub limpa_xml($);
sub eh_numerico($);
sub analisa_entrada(@);
sub le_peerstatus(@);
sub le_enderecoip_ramal(@);
sub le_agentlogin(@);
sub le_agentlogoff(@);
sub le_pausa(@);
sub le_ligacao_fechando(@);
sub le_novo_id_ligacao(@);
sub atualiza_id_ligacao(@);
sub amarra_ligacoes(@);
sub fecha_agente_forcado(@);
sub le_novo_estado_ligacao(@);
sub entrou_na_fila(@);
sub chamando_agente(@);
sub le_quem_disca(@);
sub le_quem_atendeu(@);
sub le_agente_que_atendeu(@);
sub ligacao_desistindo(@);
sub separa_dois_pontos($);
sub fecha_ligacao(@);
sub ramal_grava_endereco_ip(@);
sub ramal_desgrava_endereco_ip($);
sub loga_agente(@);
sub desloga_agente(@);
sub pausa_agente(@);
sub nova_ligacao(@);
sub atualiza_ligacao(@);
sub ligacao_na_fila(@);
sub marca_tabela_gravacao(@);
sub registra_para_relatorio(@);
sub registra_para_relatorio_pbx(@);
sub pesquisa($);
sub pesquisa_multipla($);
sub testa_fabricante_placa($);
sub testa_fabricante_placa_ip($);
sub eh_ramal($);
sub le_alarmes(@);
sub renomeia_id(@);
sub muda_estado_placas(@);
sub muda_estado_ramal(@);
sub coloca_na_orbita(@);
sub retira_da_orbita(@);
sub desiste_da_orbita(@);
sub pesquisa_varias_linhas($);
sub trim($);


my $opt_debug    = 1; 
my $opt_debug2   = 0;
my $opt_display  = 0;
my $opt_log      = 1;
my $renomeia_gra = 0;
my $db_type      = "PgPP";
my $db_port      = "5432";
my $db_host      = "localhost";
my $db_user_name = "postgres";
my $db_password  = "";
my $db_database  = "vdt";
my $dbh  = DBI->connect("dbi:PgPP:dbname=$db_database", $db_user_name, $db_password, {AutoCommit => 1});
$dbh->trace($dbh->parse_trace_flag('SQL'));
my $sock = new IO::Socket::INET (PeerAddr  => $Astman_H, PeerPort  => $Astman_P, Proto => 'tcp',);
 print "Could not create socket: $!\n" unless $sock;
 $sock->autoflush(1);
my @Situacao_agente  = ('Livre','NLogado','Em Pausa','Chamando','Fazendo chamada externa','Em conversa&ccedil;&atilde;o','Monitorando PA','Rejeitando');
my @Situacao_ramal   = ('Em conversa&ccedil;&atilde;o','Desligado','Chamando');
my @Situacao_chamada = ('DDR','FILA','Consulta','Transfer&ecirc;ncia','Fazendo chamada externa');
my @Tipos_placas     = ('DGV', 'Khomp', 'Zap');



###############
## Le o Sock ##
###############
my($Buf, @Linha);
my $Bloco = 0;

@Linha = ();
while (1) {
  $Buf = le_meia(<$sock>);
  print "Buf=> $Buf \n" if ($opt_display);
  if (($Buf eq "</AsteriskManagerOutput>") || ($Buf eq "<AsteriskManagerOutput>")) {
    if ($opt_display) {
      for my $Linha (@Linha) {
        print " Linha=> $Linha \n";
      }
    }
    analisa_entrada(@Linha);
    @Linha = ();
  } else {
    $Buf = limpa_xml($Buf);
    grava_log($Buf) if ($opt_log);
    push @Linha, $Buf;
  }
  $sock->flush;
}   
close $sock;   


######################
## Le o Astmanproxy ##
######################
sub analisa_entrada(@) {
  my $Bandeira = 1;
  my $Buf = "";
  my $Hkey = "";
  my @testahk  = "";
  my $Saida = "";

  while ($Bandeira) {
    $Buf = $_[0];

  #>>> Verifica se exite um hardlock
  #$Saida = 1;
  #while ($Saida eq 1) {
  #  $Hkey = $Diretorio_Config ."/vdt_hk";
  #  @testahk  = ($Hkey, "0");
    #@testahk  = ("/usr/local/apache2/htdocs/vdt/vdt_hk", "0");
    #@testahk  = ("/var/www/html/vdt/vdt_hk", "0");
  #  system(@testahk);
  #  $Ops = $?;
  #  if ($Ops eq 0) {
  #    sleep(10);
  #    print "\n>>> Trava Fora \n" if ($opt_debug2);
  #    grava_log2("\n>>> Trava Fora \n") if ($opt_debug);
  #  } else {
  #    $Saida = 0;
  #  }
  #  print "\n>>> Trava OK \n" if ($opt_debug2);
  #  grava_log2("\n>>> Trava OK \n") if ($opt_debug);
  #}
  #<<< Verifica se exite um hardlock

    print "  Entrada=> $Buf \n" if ($opt_display);
    $Bandeira = 0;
    #Algum ramal se registrou / desregistrou
    $Buf = "" unless defined $Buf;
    if ($Buf eq "Event: PeerStatus") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_peerstatus(@_);
    }
    #Retorno do comando sip show peer
    elsif (substr($Buf,0,6) eq "* Name") {
      le_enderecoip_ramal(@_);
    }
    #Alguem logou na fila com callbacklogin
    elsif ($Buf eq "Event: Agentcallbacklogin")  {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_agentlogin(@_);
    }
    #Alguem logou na fila com agentlogin
    elsif ($Buf eq "Event: Agentlogin")  {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_agentlogin(@_);
    }
    #Alguem deslogou na fila via agentcallback
    elsif ($Buf eq "Event: Agentcallbacklogoff") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_agentlogoff(@_);
    }
    #Alguem deslogou na fila via agentlogin
    elsif ($Buf eq "Event: Agentlogoff") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_agentlogoff(@_);
    }
    #Alguem pausou na fila
    elsif ($Buf eq "Event: QueueMemberPaused") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_pausa(@_);
    }
    #Uma ligacao entrou na fila
    elsif ($Buf eq "Event: Join") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      entrou_na_fila(@_);
    }
    #Agente estah sendo chamado
    elsif ($Buf eq "Event: AgentCalled") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      chamando_agente(@_);
    }
    #Uma novo id de ligacao
    elsif ($Buf eq "Event: Newchannel") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_novo_id_ligacao(@_);
    }
    #Atualiza o  id de ligacao
    elsif ($Buf eq "Event: Newcallerid") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      atualiza_id_ligacao(@_);
    }
    #Uma novo estado da ligacao
    elsif (($Buf eq "Event: Newstate") || ($Buf eq "Event: Newexten")) {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_novo_estado_ligacao(@_);
    }
    #Alguem estah discando
    elsif ($Buf eq "Event: Dial") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_quem_disca(@_);
    }
    ### Tratando tranferencias entre filas >>>
    #A ligacao foi atendida
    elsif ($Buf eq "Event: AgentConnect") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_agente_que_atendeu(@_);
    }
    ### <<< Tratando tranferencias entre filas
    #A ligacao foi atendida por um agente
    elsif ($Buf eq "Event: Link") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_quem_atendeu(@_);
    }
    #Uma ligacao desligou
    elsif ($Buf eq "Event: Hangup") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_ligacao_fechando(@_);
    }
    #Uma ligacao desligou
    elsif ($Buf eq "Event: QueueCallerAbandon") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      ligacao_desistindo(@_);
    }
    #Recebeu um alarme
    elsif ($Buf eq "Event: Alarm") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      le_alarmes(@_);
    }
    #Rename por causa de transferencia
    elsif ($Buf eq "Event: Rename") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      renomeia_id(@_);
    }
    #Estaciona chamada na orbita
    elsif ($Buf eq "Event: ParkedCall") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      coloca_na_orbita(@_);
    }
    #Remove chamada na orbita
    elsif ($Buf eq "Event: UnParkedCall") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      retira_da_orbita(@_);
    }
    #Desiste na orbita
    elsif ($Buf eq "Event: ParkedCallGiveUp") {
      print "\n>>> $Buf \n" if ($opt_debug2);
      desiste_da_orbita(@_);
    }
    #Leia novamente
    elsif (scalar @_ ne 0) {
      $Bandeira = 1;
    }
    shift(@_);
  }
}


########################
## Funcoes Auxiliares ##
########################
sub le_meia($) {
  my $Linha = shift;
  $Linha =~ s/[\r]//g;   #Remove /r
  $Linha =~ s/[\n]//g;   #Remove /n
  $Linha =~ s/^\s+//;    #Remove espacos antes
  $Linha =~ s/\s+$//;    #Remove espacos depois
	return $Linha;
}

sub eh_numerico($) {
  my $Numero = shift;
  my $Saida  = 0;
  if ($Numero =~ /^[0-9]+$/) {
    $Saida = 1;
  } else {
    $Saida = 0;
  }
  return $Saida;
}

sub trim($) {
	my $string = shift;
	$string =~ s/^\s+//;
	$string =~ s/\s+$//;
	return $string;
}

sub separa_dois_pontos($) {
  my @Pecas = split(/: /, $_[0]);
  my @Saida = "";
  if (exists($Pecas[0])) {
    @Saida = ();
    for my $Elem (@Pecas) {
      push @Saida, le_meia($Elem);
	  }
  } else {
    @Saida = @Pecas;
  }
  return @Saida;
}

sub grava_log($) {
  if ( open(LOG, ">> /var/log/asterisk/astmanproxy_real.log") ) {
    my $Tempo = time;
    print LOG $Tempo." - ".$_[0]."\n";
    close(LOG);
  } else {
    warn "Couldn't log to /var/log/astmanproxy_real.log: $!\n";
  }
}

sub grava_log2($) {
  if ( open(LOG2, ">> /var/log/asterisk/vdtamp.log") ) {
    print LOG2 $_[0];
    close(LOG2);
  } else {
    warn "Couldn't log to /var/log/vdtamp.log: $!\n";
  }
}


sub limpa_xml($) {
  my $Linha = shift;
  $Linha =~ s/<//g;         #Remove <
  $Linha =~ s/>//g;         #Remove >
  $Linha =~ s/\"//g;        #Remove "
  $Linha =~ s/\/$//;        #Remove / no fim
  $Linha =~ s/^\///;        #Remove / no comeco
  $Linha =~ s/&lt;/</g;     #Coloca < no lugar
  $Linha =~ s/&gt;/>/g;     #Coloca > no lugar
  $Linha =~ s/&quot;/\"/g;  #Coloca " no lugar
  my @Aux = split(/ Value=/, $Linha);
  if (exists($Aux[0])) {
    if (exists($Aux[1])) {
      if ($Aux[0] eq "UnparsedText") {
        $Linha = $Aux[1];
      } else {
        $Linha = $Aux[0] . ": " . $Aux[1];
      }
    } else {
      $Linha = $Aux[0];
    }
    $Linha = le_meia($Linha);
  }
	return $Linha;
}


sub testa_fabricante_placa($) {
  my $Fabri = shift;
  my @Aux = "";
  my $Tronco = pesquisa( "SELECT numero_asterisk FROM vm50_troncos WHERE numero_asterisk='$Fabri'" );
  my $Achei = 0;
  if (($Tronco eq "E") || ($Tronco eq "")) {
    $Achei = -1;
  } else {
    $Achei = 0;
  }
  print ">>> testa_fabricante_placa $Fabri $Achei \n" if ($opt_debug2);
  grava_log2(">>> testa_fabricante_placa $Fabri $Achei \n") if ($opt_debug);
  return $Achei;
}


sub testa_fabricante_placa_ip($) {
  my $Fabri  = shift;
  my $FabrP  = $Fabri;
  my @Aux    = "";
  my $Total  = 0;
  my $Tronco = $Retorno = "";
  my $Achei  = -2;
  if ((substr($Fabri,0,3) eq "SIP") || (substr($Fabri,0,3) eq "IAX")) {
    @Aux = split(/-/, $Fabri);
    #>>> Corrigi o problema de canais SIP com sinal de menos no meio do nome
    $Total = @Aux;
    $FabrP = "";
    for (my $x=0; $x < $Total - 1; $x++) {
      $FabrP = $FabrP."-" if ($x gt 0);
      $FabrP = $FabrP.$Aux[$x];
    }
    #$FabrP = $Aux[0];
    #<<< Corrigi o problema de canais SIP com sinal de menos no meio do nome
    $Tronco = pesquisa( "SELECT numero_vdt FROM vm50_troncos WHERE canal_asterisk='$Fabri' LIMIT 1" );
    if (($Tronco eq "E") || ($Tronco eq "")) {
      $Tronco = pesquisa( "SELECT numero_vdt FROM vm50_troncos WHERE numero_asterisk='$FabrP' AND situacao='L' LIMIT 1" );
      if (($Tronco eq "E") || ($Tronco eq "")) {
        $Achei = -1;
      } else {
        $Achei = $Tronco;
        $sql = "UPDATE vm50_troncos SET canal_asterisk='$Fabri' WHERE numero_vdt='$Tronco'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno \n" if ($opt_debug2);
        grava_log2("$sql $Retorno \n") if ($opt_debug);
      }
    } else {
      $Achei = $Tronco;
    }
  }
  print ">>> testa_fabricante_placa_ip $Fabri $Achei \n" if ($opt_debug2);
  grava_log2(">>> testa_fabricante_placa_ip $Fabri $Achei \n") if ($opt_debug);
  return $Achei;
}


sub eh_ramal($) {
  my $Numero = shift;
  return 0 if (!(defined($Numero)));
  my $Ramal = pesquisa( "SELECT ramal FROM vm50_ramais WHERE ramal='$Numero'" );
  my $Achei = 0;
  if ($Ramal eq $Numero) {
    $Achei = 1;
  } else {
    $Achei = 0;
  }
  print ">>> eh_ramal $Numero $Achei \n" if ($opt_debug2);
  grava_log2(">>> eh_ramal $Numero $Achei \n") if ($opt_debug);
  return $Achei;
}




#######################################
## Funcoes de leitura do Astmanproxy ##
#######################################
sub le_peerstatus(@) {
  my $Linha = $Ramal = $Acao = "";
  my @Aux = @Teste = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "Peer") {
      @Teste = split(/\//, $Aux[1]);
      $Ramal = $Teste[1];   
    } elsif ($Aux[0] eq "PeerStatus") {
      $Acao = $Aux[1];   
    }
  }
  print "\n>>> le_peerstatus -> $Acao $Ramal \n" if ($opt_debug2);
  grava_log2("\n>>> le_peerstatus -> $Acao $Ramal \n") if ($opt_debug);
  if ($Acao eq "Registered") {
    print $sock "Action: Command\r\nCommand: sip show peer $Ramal \r\n\r\n";
    print "Action: Command\r\nCommand: sip show peer $Ramal \n" if ($opt_display);
  }
### Solicitacao Eduardo para nao mais derrubar no Unregistered
  elsif ($Acao eq "Unregistered") {
#    desloga_agente_forcado($Ramal);
    ramal_desgrava_endereco_ip($Ramal);
  }
###
}

##########
sub le_enderecoip_ramal(@) {
  my $Linha = $Ramal = $Endereco = "";
  my @Aux = @Teste = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "* Name") {
      $Ramal = $Aux[1];   
    } elsif ($Aux[0] eq "Addr->IP") {
      @Teste = split(/ Port /, $Aux[1]);
      $Endereco = $Teste[0];
    }
  }
  print "\n>>> le_enderecoip_ramal -> $Ramal $Endereco \n" if ($opt_debug2);
  grava_log2("\n>>> le_enderecoip_ramal -> $Ramal $Endereco \n") if ($opt_debug);
  ramal_grava_endereco_ip($Ramal, $Endereco);
}

##########
sub le_agentlogin(@) {
  my $Linha = $Agente = $Ramal = $Contexto = "";
  my @Aux = @Teste = @AuxL = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "Agent") {
      $Agente = $Aux[1];   
    } elsif ($Aux[0] eq "Loginchan") {
      grava_log2("\n>>> Loginchan -> $Aux[1] \n") if ($opt_debug);
      @Teste = split(/@/, $Aux[1]);
      $Ramal = $Teste[0];
      $Contexto = $Teste[1];    
    } elsif ($Aux[0] eq "Channel") {
      grava_log2("\n>>> Channel -> $Aux[1] \n") if ($opt_debug);
      @AuxL  = split(/\//, $Aux[1]);
      @Teste = split(/-/, $AuxL[1]);
      $Ramal = $Teste[0];
      $Contexto = $Teste[1];
    }
  }
  print LOG2 "\n>>> le_agentlogin -> $Agente $Contexto $Ramal \n" if ($opt_debug2);
  loga_agente($Agente, $Ramal);
}

##########
sub le_agentlogoff(@) {
  my $Linha = $Agente = $Ramal = $Contexto = "";
  my @Aux = @Teste = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "Agent") {
      $Agente = $Aux[1];   
    } elsif ($Aux[0] eq "Loginchan") {
      @Teste = split(/@/, $Aux[1]);
      $Ramal = $Teste[0];
      $Contexto = $Teste[1];    
    }
  }
  print LOG2 "\n>>> le_agentlogoff -> $Agente $Contexto $Ramal \n" if ($opt_debug2);
  grava_log2("\n>>> le_agentlogoff -> $Agente $Contexto $Ramal \n") if ($opt_debug);
  desloga_agente($Agente, $Ramal);
}

##########
sub le_pausa(@) {
  my $Linha = $Agente = $Pausa = "";
  my @Aux = @Teste = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "MemberName") {
      @Teste = split(/\//, $Aux[1]);
      $Agente = $Teste[1];   
    } elsif ($Aux[0] eq "Paused") {
      $Pausa = $Aux[1];
    }
  }
  print "\n>>> le_pausa -> $Agente $Pausa \n" if ($opt_debug2);
  grava_log2("\n>>> le_pausa -> $Agente $Pausa \n") if ($opt_debug);
  pausa_agente($Agente, $Pausa);
}

##########
sub entrou_na_fila(@) {
  my $Linha = $Fila = $Id_Ligacao = $Canal = $Obs = "";
  my @Aux = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "Queue") {
      $Fila = $Aux[1];   
    } elsif ($Aux[0] eq "Channel") {
      $Canal = $Aux[1];
    } elsif ($Aux[0] eq "Uniqueid") {
      $Id_Ligacao = $Aux[1];
    }
  }
  print "\n>>> entrou_na_fila -> $Fila $Id_Ligacao $Canal $Obs \n" if ($opt_debug2);
  grava_log2("\n>>> entrou_na_fila -> $Fila $Id_Ligacao $Canal $Obs \n") if ($opt_debug);
  ligacao_na_fila($Fila, $Id_Ligacao, $Canal);  
}

##########
sub chamando_agente(@) {
  my $Linha = $Agente = $Canal = $Ramal = "";
  my @Aux = @Teste = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "AgentCalled") {
      @Teste = split(/\//, $Aux[1]);
      $Agente = $Teste[1];
      $Ramal  = $Aux[1];
    } elsif ($Aux[0] eq "ChannelCalling") {
      $Canal = $Aux[1];
    }
  }
  print "\n>>> chamando_agente -> $Agente $Canal $Ramal \n" if ($opt_debug2);
  grava_log2("\n>>> chamando_agente -> $Agente $Canal $Ramal \n") if ($opt_debug);
  ligacao_no_agente($Agente, $Canal, $Ramal);
}

##########
sub le_ligacao_fechando(@) {
  my $Linha = $Id_Ligacao = $Id_Ligacao2 = $Agente = $AgenteAux = $Causa = $Canal = $Teste = $Numero = $Gravacao = "";
  my $Ramal = $Id = $Tipo = $sql = $TestePara = $ParaC = $Desis = $AuxDesis = $Retorno = $Fila = $Gravacao = "";
  my $Rejei = $DiaH = $DiaA = 0;
  my @Aux = @NumeroA = @NumeroB = @NumeroC = @Para = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    grava_log2("\n>>>$Linha \n") if ($opt_debug); 
    if ($Aux[0] eq "Uniqueid") {
      $Id_Ligacao = $Aux[1];
    } elsif ($Aux[0] eq "Channel") {
      $Canal  = $Aux[1];
      $Agente = $Canal if (substr($Canal,0,5) eq "Agent");
    } elsif ($Aux[0] eq "Cause") {
      $Causa = $Aux[1];
    }
  }
  print "\n>>> le_ligacao_fechando -> $Id_Ligacao $Canal $Agente $Causa \n" if ($opt_debug2);
  grava_log2("\n>>> le_ligacao_fechando -> $Id_Ligacao $Canal $Agente $Causa \n") if ($opt_debug);
  #>>> Corrige problema de nao marcar a duracao de transferencia
  $Gravacao = pesquisa("SELECT gravacao FROM vm50_gravacoes WHERE id_ligacao='$Id_Ligacao'");
  if ($Gravacao ne "E") {
    $DiaH = pesquisa( "SELECT diahora FROM vm50_gravacoes WHERE id_ligacao='$Id_Ligacao'" );
    if (($DiaH ne "E") && ($DiaH ne "") && ($DiaH ne "NULL")) {
      $DiaA = substr($DiaH,0,4).'-'.substr($DiaH,4,2).'-'.substr($DiaH,6,2).' '.substr($DiaH,8,2).':'.substr($DiaH,10,2).':'.substr($DiaH,12,2);
      $sql = "UPDATE vm50_gravacoes SET duracao=CURRENT_TIMESTAMP - timestamp '$DiaA' WHERE gravacao='$Gravacao'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    }
  }
  #<<< Corrige problema de nao marcar a duracao de transferencia
  return if (substr($Canal,-8) eq '<ZOMBIE>');
  #>>> Corrige problema dos falsos ids. Precisam ser falsos depois que o id principal fecha
  $TestePara = index($Canal, '-');
  if ($TestePara gt -1) {
    @Para  = split(/-/, $Canal);
    if (substr($Canal,0,5) eq "DAHDI") {
      my $Outroaux = $Para[0] . '-' . $Para[1];
      $ParaC = pesquisa( "SELECT ramal FROM vm50_ramais WHERE numeroaster='$Outroaux'" );
    } else {
      $ParaC = pesquisa( "SELECT ramal FROM vm50_ramais WHERE numeroaster='$Para[0]'" );
    }
    if (($ParaC ne "E") && ($ParaC ne "")) {
      $sql = "UPDATE vm50_ligacao_id SET falso='1' WHERE numero = '$ParaC' AND canal!='$Canal' AND transferiu='0'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    }
  }
  #<<< Corrige problema dos falsos ids. Precisam ser falsos depois que o id principal fecha
  #>>> Grava a duracao da ligacao nas gravacoes
  $DiaH = pesquisa( "SELECT diahora FROM vm50_gravacoes WHERE id_ligacao='$Id_Ligacao'" );
  if (($DiaH ne "E") && ($DiaH ne "") && ($DiaH ne "NULL")) {
    $Gravacao = pesquisa("SELECT gravacao FROM vm50_gravacoes WHERE id_ligacao='$Id_Ligacao'");
    $DiaA = substr($DiaH,0,4).'-'.substr($DiaH,4,2).'-'.substr($DiaH,6,2).' '.substr($DiaH,8,2).':'.substr($DiaH,10,2).':'.substr($DiaH,12,2);
    $sql = "UPDATE vm50_gravacoes SET duracao=CURRENT_TIMESTAMP - timestamp '$DiaA' WHERE gravacao='$Gravacao'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  }
  #<<< Grava a duracao da ligacao nas gravacoes
  muda_estado_ramal("NULL",$Canal,$Id_Ligacao,"L","","");
  if (testa_fabricante_placa($Canal) gt -1) {
    $sql = "UPDATE vm50_troncos SET situacao='L', numeroexterno='', numerointerno='', id_externo='', id_interno='', direcao='', canal_asterisk='' WHERE numero_asterisk = '$Canal' and (situacao='O' OR situacao='R')";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  } else {
    my $Numvdt = testa_fabricante_placa_ip($Canal);
    if ($Numvdt gt 0) {
      $sql = "UPDATE vm50_troncos SET situacao='L', numeroexterno='', numerointerno='', id_externo='', id_interno='', direcao='', canal_asterisk='' WHERE numero_vdt = '$Numvdt' and (situacao='O' OR situacao='R')";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    }
  }
  #registra_para_relatorio_pbx(ligacao_origem,numero_origem,canal_origem,ligacao_destino,numero_destino,canal_destino,oque);
  registra_para_relatorio_pbx($Id_Ligacao,"NULL",$Canal,"NULL","NULL","NULL","Desligado");
  $Ramal = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE canal='$Canal' ORDER BY id DESC LIMIT 1" );
  $Ramal = "" if (eh_ramal($Ramal) eq 0);
  $Desis = pesquisa( "SELECT desistiu FROM vm50_ligacao_id WHERE canal='$Canal' ORDER BY id DESC LIMIT 1" );
  $Desis = 0 if (($Desis eq "E") || ($Desis eq ""));
  #>>> Desistencia de DDR nao esta registrando
  if ($Desis eq 0) {
    my $Situ = pesquisa( "SELECT estado FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao' OR id_dest='$Id_Ligacao'" );
    $Desis = 1 if ($Situ eq "Chamando");
  }

  if (($Agente ne "") && ($Agente ne "E")) {
    @Para  = split(/\//, $Agente);
    $AgenteAux = $Para[1];
    $Id_Ligacao2 = pesquisa( "SELECT id_ligacao FROM vm50_agentes WHERE login='$AgenteAux'" );
    print ">>> le_ligacao_fechando -> $Id_Ligacao \n" if ($opt_debug2);
    grava_log2(">>> le_ligacao_fechando -> $Id_Ligacao \n") if ($opt_debug);
    fecha_ligacao($Id_Ligacao,$Rejei,$Canal);
    return if ($Id_Ligacao2 ne $Id_Ligacao);
  }

  $Agente = pesquisa( "SELECT login FROM vm50_agentes WHERE id_ligacao='$Id_Ligacao'" ) if (($Agente eq "") || ($Agente eq "E"));
  $Agente = pesquisa( "SELECT login FROM vm50_agentes WHERE ramal='$Ramal'" ) if (($Agente eq "") || ($Agente eq "E"));
  $Agente = "" if ($Agente eq "E");
  $Id_Ligacao2 = $Id_Ligacao;
  if ($Agente ne "") {
    $Fila = pesquisa( "SELECT numero_dest FROM vm50_link_ligacao WHERE pa='$Ramal'");
    if (($Fila eq "E") || ($Fila eq "")) {
      $Fila = "";
    } else {
      my $ExisteFila = pesquisa( "SELECT pseudonimo FROM vm50_filas WHERE UPPER(pseudonimo)=UPPER('$Fila')");
      if (($ExisteFila eq "E") || ($ExisteFila eq "")) {
        $Fila = "";
#      } else {
#        $Id_Ligacao2 = pesquisa( "SELECT id_ligacao FROM vm50_agentes WHERE ramal='$Ramal'" );
      }
    }
    # Corrige desligamento sem atualizar o agente  
    $sql = "UPDATE vm50_agentes SET situacao = 'Livre', ult_estad=CURRENT_TIMESTAMP, fila = '', id_ligacao = '', falandocom = '' WHERE login = '$Agente'";  
    $Retorno = $dbh->do($sql);  
    print "$sql $Retorno\n" if ($opt_debug2);  
    grava_log2("$sql $Retorno\n") if ($opt_debug);  
    # Final da correção do desligamento sem atualizar o agente
  } else {
    $Fila = "";
  }
  #<<< Desistencia de DDR nao esta registrando
  registra_para_relatorio($Agente,$Fila,$Id_Ligacao2,$Ramal,"Desligado","","","",$Canal) if ($Desis eq 0);
  registra_para_relatorio($Agente,$Fila,$Id_Ligacao2,$Ramal,"Desistencia-FilA","","","",$Canal) if ($Desis eq 1);
  ###>>> Corrige o problema de renomear o arquivo de gravacao
#  my $Gravacao = pesquisa( "SELECT gravacao FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao' OR id_dest='$Id_Ligacao'" );
#  if (-e $Gravacao) {
#    my $Novo_nome = pesquisa( "SELECT gravacao_nova FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao' OR id_dest='$Id_Ligacao'" );
#    rename($Gravacao,$Novo_nome);
#  }
  ###<<< Corrige o problema de renomear o arquivo de gravacao
  if (($Causa eq 19) || ($Causa eq 16)) {
  #if ($Causa eq 19)  {
    $Teste = fecha_ligacao_forcada($Id_Ligacao,$Agente);
    return if ($Teste ne "");
  }
  print "\n>>> le_ligacao_fechando -> $Id_Ligacao $Canal $Agente $Causa \n" if ($opt_debug2);
  grava_log2("\n>>> le_ligacao_fechando -> $Id_Ligacao $Canal $Agente $Causa \n") if ($opt_debug);
  #Reject em ligacao de fila
  if ($Causa eq "21") {
    if ((substr($Canal,0,5) eq "Local") || (substr($Canal,0,3) eq "SIP") || (substr($Canal,0,3) eq "IAX")) {
      my $testaplaca = testa_fabricante_placa_ip($Canal);
      if ($testaplaca eq 0) {
        @NumeroA = split(/@/, $Canal);
        @NumeroB = split(/-/, $NumeroA[0]);
        @NumeroC = split(/\//, $NumeroB[0]);
        $Ramal   = $NumeroC[1];
        $Id      = pesquisa( "SELECT id_ligacao FROM vm50_agentes WHERE ramal='$Ramal'" );
        $Tipo    = pesquisa( "SELECT obs FROM vm50_link_ligacao WHERE id_orig='$Id'" );
        $Agente  = pesquisa( "SELECT login FROM vm50_agentes WHERE ramal='$Ramal'" );
        $sql = "UPDATE vm50_agentes SET situacao = 'Rejeitando', ult_estad=CURRENT_TIMESTAMP WHERE ramal='$Ramal'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
        $Rejei = 1;
        registra_para_relatorio($Agente,$Tipo,$Id,$Ramal,"Rejeitado","","","",$Canal);
      }
    }
  }
  #Fim do reject em ligacao de fila
if ($Desis eq 0) {
  if ($Agente ne "") {
    $Agente = le_meia($Agente);
    $Agente = "Agent/$Agente" if (substr($Agente,0,5) ne "Agent");
    altera_situacao_agente($Agente, "NULL", "NULL", "Desligado", $Id_Ligacao);
    #>>> Verifica se o agente estava transferindo para um ramal
#    $Agente = pesquisa("SELECT login FROM vm50_agentes WHERE id_ligacao='$Id_Ligacao'");
#    if (($Agente ne "E") && ($Agente ne "")) {
#      altera_situacao_agente($Agente, "NULL", "NULL", "Desligado", $Id_Ligacao);
#      $Ramal = pesquisa( "SELECT ramal FROM vm50_agentes WHERE login='$Agente'" );
#      if (($Ramal ne "E") && ($Ramal ne "")) {
#        $Id_Ligacao = pesquisa( "SELECT id_orig FROM vm50_link_ligacao WHERE numero_dest='$Ramal' AND estado!='Desligado'" );
        #altera_situacao_agente(canal, falandocom, fila, situacao, id_ligacao);
#        altera_situacao_agente($Agente, $Ramal, "NULL", "Em conversa&ccedil;&atilde;o", $Id_Ligacao);
#      }
#    }
    #<<< Verifica se o agente estava transferindo para um ramal
  }
  print ">>> le_ligacao_fechando -> $Id_Ligacao \n" if ($opt_debug2);
  grava_log2(">>> le_ligacao_fechando -> $Id_Ligacao \n") if ($opt_debug);
  fecha_ligacao($Id_Ligacao,$Rejei,$Canal);
  if ($Id_Ligacao2 ne $Id_Ligacao) {
    print ">>> le_ligacao_fechando -> $Id_Ligacao2 \n" if ($opt_debug2);
    grava_log2(">>> le_ligacao_fechando -> $Id_Ligacao2 \n") if ($opt_debug);
    fecha_ligacao($Id_Ligacao2,$Rejei,$Canal);
  }
} else {
  if ($Agente eq "") {
    print ">>> le_ligacao_fechando -> $Id_Ligacao \n" if ($opt_debug2);
    grava_log2(">>> le_ligacao_fechando -> $Id_Ligacao \n") if ($opt_debug);
    fecha_ligacao($Id_Ligacao,$Rejei,$Canal);
  }
}
}

##########
sub le_novo_id_ligacao(@) {
  my $Linha = $Id_Ligacao = $Numero = $Canal = $Agente = "";
  my @Aux = @NumeroA = @NumeroB = "";
  my $Transferiu = 0;
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "CallerIDNum") {
      $Numero = $Aux[1];
    } elsif ($Aux[0] eq "Channel") {
      $Canal = le_meia($Aux[1]);
    } elsif ($Aux[0] eq "Uniqueid") {
      $Id_Ligacao = $Aux[1];
    }
  }
  $Numero = $Canal if (substr($Canal,0,5) eq "Agent");
  if (substr($Canal,0,5) eq "Local") {
    @NumeroA = split(/@/, $Canal);
    @NumeroB = split(/\//, $NumeroA[0]);
    $Numero = $NumeroB[1];
    #>>> Agente transfere para agente nao aparece agente, mas local
    $Agente = pesquisa("SELECT login FROM vm50_agentes WHERE ramal = '$Numero'");
    $Numero = "Agent/".$Agente if ($Agente ne "E") && ($Agente ne "");
    #<<< Agente transfere para agente nao aparece agente, mas local
  ### Trata de transferencias entre filas e ramais >>>
  } elsif ((substr($Canal,0,3) eq "SIP") || (substr($Canal,0,3) eq "IAX")) {
    my $testaplaca = testa_fabricante_placa_ip($Canal);
    if (($testaplaca gt 0) && ($Numero eq "<unknown>")) {
      #@NumeroA = split(/-/, $Canal);
      #@NumeroB = split(/\//, $NumeroA[0]);
      #$Numero = $NumeroB[1];
      #>>> Corrige o problema de canais SIP com sinal de menos no meio do nome
      @NumeroA = split(/-/, $Canal);
      my $Total = @NumeroA;
      $Numero = "";
      for (my $x=0; $x < $Total - 1; $x++) {
        $Numero = $Numero."-" if ($x gt 0);
        $Numero = $Numero.$NumeroA[$x];
      }
      #<<< Corrige o problema de canais SIP com sinal de menos no meio do nome
    } elsif ($Numero eq "<unknown>") {
      my @D_Aux = split(/-/, $Canal);
      my $D_Sip = $D_Aux[0];
      my $D_ramal = pesquisa("SELECT ramal FROM vm50_ramais WHERE numeroaster = '$D_Sip'");
      if (($D_ramal eq "E") || ($D_ramal eq "NULL") || ($D_ramal eq "")) {
        $Numero = $D_ramal;
      } else {
        @NumeroA = split(/\//, $Canal);
        @NumeroB = split(/-/, $NumeroA[1]);
        $Numero = $NumeroB[0];
      }
    }
  } elsif ((substr($Canal,0,14) eq "Transfered/SIP") || (substr($Canal,0,14) eq "Transfered/IAX")) {
    @NumeroA = split(/\//, $Canal);
    @NumeroB = split(/-/, $NumeroA[2]);
    $Numero = $NumeroB[0];
    $Transferiu = 1;
  }
  ### <<< Trata de transferencias entre filas e ramais
  print "\n>>> le_novo_id_ligacao -> $Numero $Id_Ligacao $Canal \n" if ($opt_debug2);
  grava_log2("\n>>> le_novo_id_ligacao -> $Numero $Id_Ligacao $Canal \n") if ($opt_debug);
  nova_ligacao($Id_Ligacao, $Numero, $Canal, "NULL");
}

##########
sub atualiza_id_ligacao(@) {
  my $Linha = $Id_Ligacao = $Numero = $Canal = "";
  my @Aux = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "CallerID") {
      $Numero = $Aux[1];
    } elsif ($Aux[0] eq "Channel") {
      $Canal = $Aux[1];
    } elsif ($Aux[0] eq "Uniqueid") {
      $Id_Ligacao = $Aux[1];
    }
  }
  print "\n>>> atualiza_id_ligacao -> $Numero $Id_Ligacao $Canal \n" if ($opt_debug2);
  grava_log2("\n>>> atualiza_id_ligacao -> $Numero $Id_Ligacao $Canal \n") if ($opt_debug);
  # >>> Corrige numero das chamadas com tronco SIP
  my $Nume_f = pesquisa("SELECT numero FROM vm50_ligacao_id WHERE id='$Id_Ligacao'");
  if ((substr($Nume_f,0,3) eq "SIP") && ($Numero ne "") && ($Numero ne " ") && ($Numero =~ /^\d+$/)) {
    my $sql = "UPDATE vm50_ligacao_id SET numero='$Numero' WHERE id='$Id_Ligacao'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  }
  # <<< Corrige numero das chamadas com tronco SIP
# >>> Cria o estado chamando ramal
  muda_estado_ramal("NULL",$Canal,$Id_Ligacao,"C","algu","X");
#  muda_estado_ramal("NULL",$Canal,$Id_Ligacao,"C",$Numero,"X");
# <<< Cria o estado chamando ramal
  atualiza_ligacao($Id_Ligacao, $Numero, $Canal, "NULL");
}

##########
sub le_novo_estado_ligacao(@) {
  my $Linha = $Estado = $Numero = $Aplicacao = $DadosAplicacao = $Id_Ligacao = $Canal = $Retorno = "";
  my $Situacao = $Nov_Num = $sql = "";
  my @Aux = @TesteA = @TesteB = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "State") {
      $Estado = $Aux[1];
    } elsif ($Aux[0] eq "Application") {
      $Aplicacao = $Aux[1];
    } elsif ($Aux[0] eq "AppData") {
      $DadosAplicacao = $Aux[1];
    } elsif ($Aux[0] eq "Extension") {
      $Numero = $Aux[1];
    } elsif ($Aux[0] eq "Uniqueid") {
      $Id_Ligacao = $Aux[1];
    } elsif ($Aux[0] eq "Channel") {
      $Canal = $Aux[1];
    }
  }
  if ($Aplicacao eq "Dial") {
    @TesteA = split(/\//, $DadosAplicacao);
  ### Tratando as saidas por enlace >>>
    if ($TesteA[1] eq "enlace") {
      $Numero = $TesteA[2];
      $Situacao = "Interno-".$Numero;
  ### <<< Tratando as saidas por enlace
    } elsif (exists $TesteA[2]) {
      @TesteB = split(/\|/, $TesteA[2]);
      $Numero = $TesteB[0];
      $Situacao = "Externo-".$Numero;
    }
  } elsif ($Aplicacao eq "ChanSpy") {
    @TesteA = split(/\//, $DadosAplicacao);
    if (exists $TesteA[1]) {
      @TesteB = split(/\|/, $TesteA[1]);
      $Numero = $TesteB[0];
      while (eh_ramal($Numero) eq '0') {
        $Nov_Num = substr($Numero,1);
        $Numero = $Nov_Num;
      }
      $Situacao = "Monitorando-$Numero";
      muda_estado_ramal("NULL",$Canal,$Id_Ligacao,"O",$Situacao,"O");
    }
  ### Tratando as saidas das chamadas da fila >>>
  } elsif ($Aplicacao eq "Queue") {
    @TesteB = split(/\|/, $DadosAplicacao);
    $Situacao = "FILA-".$TesteB[0]; #Ligacao caiu na fila
    #$Situacao = $TesteB[0]; #Ligacao caiu na fila
  } elsif ($Aplicacao eq "VoiceMail") {
    $Situacao = "CAIXA_POSTAL"; #Ligacao caiu na caixa postal
    $sql = "UPDATE vm50_troncos SET numerointerno='Caixa Postal', direcao='I', id_interno='' WHERE id_externo = '$Id_Ligacao'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    muda_estado_ramal("NULL",$Canal,$Id_Ligacao,"O","Caixa Postal","I");
  } elsif ($Aplicacao eq "VoiceMailMain") {
    $Situacao = "CAIXA_POSTAL"; #Ligacao caiu na caixa postal
    $sql = "UPDATE vm50_troncos SET numerointerno='Caixa Postal', direcao='I', id_interno='' WHERE id_externo = '$Id_Ligacao'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    muda_estado_ramal("NULL",$Canal,$Id_Ligacao,"O","Caixa Postal","O");
  } elsif ($Aplicacao eq "Playback") {
    $Situacao = "MSG_ATENDIMENTO"; #Ligacao caiu na Mensagem de atendimento
    $sql = "UPDATE vm50_troncos SET numerointerno='Mensagem de atendimento', direcao='I', id_interno='' WHERE id_externo = '$Id_Ligacao'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  } elsif ($Aplicacao eq "Hangup") {
    $Situacao = "DESLIGAMENTO"; #Ligacao foi derrubada pelo sistema
    muda_estado_ramal("NULL",$Canal,$Id_Ligacao,"L","","");
  ### <<< Tratando as saidas das chamadas da fila
  ### Tratando as filas que comecam com mensagem >>>
  } elsif ($Aplicacao eq "BackGround") {
    $Situacao = "COMECA COM MENSAGEM";
    $sql = "UPDATE vm50_troncos SET numerointerno='Mensagem de atendimento', direcao='I', id_interno='' WHERE id_externo = '$Id_Ligacao'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  ### <<< Tratando as filas que comecam com mensagem
  ### Resolvendo o problema de gravacoes >>>
  } elsif ($Aplicacao eq "MixMonitor") {
    #if ($DadosAplicacao =~ /\\/) {
      @TesteB = split(/\|/, $DadosAplicacao);
      $Situacao = "MARCA GRAVACAO-".$TesteB[0];
    #}
  ### <<< Resolvendo o problema de gravacoes
  ### Tratando as filas que comecam com mensagem >>>
  } elsif (($Aplicacao eq "Set") && (substr($DadosAplicacao,0,16) eq "MONITOR_FILENAME")) {
    #if ($DadosAplicacao =~ /\\/) {
      $DadosAplicacao = substr($DadosAplicacao,16);
      @TesteB = split(/\|/, $DadosAplicacao);
      $Situacao = "MARCA GRAVACAO-".$TesteB[0];
    #}
  ### <<< Resolvendo o problema de gravacoes
  ### Tratando as filas que comecam com mensagem >>>
  } elsif ($Aplicacao eq "BackGround") {
    $Situacao = "COMECA COM MENSAGEM";
  } elsif ($Estado eq "Ringing") {
   #muda_estado_ramal(ramal, canal, id, situacao, falandocom, direcao)
# >>> Cria o estado chamando ramal
#    muda_estado_ramal("NULL",$Canal,$Id_Ligacao,"O","Chamando","I");
    muda_estado_ramal("NULL",$Canal,$Id_Ligacao,"C","Chamando","I");
# <<< Cria o estado chamando ramal
  } else {
    muda_estado_ramal("NULL",$Canal,$Id_Ligacao,"O","algu","X");
  }
  ### <<< Tratando as filas que comecam com mensagem
  if ($Estado eq "Ring") {
    $Situacao = ""; #Ignorar;
  } elsif ($Estado eq "Dialing") {
    $Situacao = ""; #Ignorar;
  } elsif ($Estado eq "Answer") {
    $Situacao = "DDR"; #Indica ligacao externa e se entrou diretamente via DDR 
  } elsif ($Estado eq "DgCollectCallBlock") {
    $Situacao = ""; #Ignorar; Verifica se eh a cobrar 
  } elsif ($Estado eq "Dial") {
    $Situacao = ""; #Ignorar; Le o extention que eh para quem ele estah discando melhor usar o callerid
  } elsif ($Estado eq "Ringing") {
    $Situacao = ""; #Ignorar; Estah chamando mas eh melhor tratar no dial
  } elsif ($Estado eq "Up") {
    $Situacao = ""; #Ignorar; Atendeu mas eh melhor tratar no link 
  } elsif ($Estado eq "Down") {
    $Situacao = "DESLIGAMENTO"; #Ignorar; Desligou mas eh melhor tratar no hangup
  }
  print "\n>>> le_novo_estado_ligacao -> $Estado $Numero $Id_Ligacao $Situacao \n" if ($opt_debug2);
  grava_log2("\n>>> le_novo_estado_ligacao -> $Estado $Numero $Id_Ligacao $Situacao \n") if ($opt_debug);
  estado_ligacao($Id_Ligacao, $Situacao) if ($Situacao ne "");
}

##########
sub ligacao_desistindo(@) {
  my $Linha = $Id_Ligacao = $sql = $AuxDesis = $Retorno = "";
  my @Aux = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "Uniqueid") {
      $Id_Ligacao = $Aux[1];
    }
  }
  print "\n>>> ligacao_desistindo -> $Id_Ligacao \n" if ($opt_debug2);
  grava_log2("\n>>> ligacao_desistindo ->$Id_Ligacao \n") if ($opt_debug);
  $sql = "UPDATE vm50_ligacao_id SET desistiu = '1'  WHERE id = '$Id_Ligacao' AND conversou!='1'";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
  estado_ligacao($Id_Ligacao, "DESLIGAMENTO");
}

##########
sub le_alarmes(@) {
  my $Placa = $Tronco = $Situacao = "";
  my @Aux = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "CARD") {
      $Placa = $Aux[1];
    } elsif ($Aux[0] eq "E1") {
      $Tronco = $Aux[1];
    } elsif ($Aux[0] eq "ALARM_LOSS") {
      $Situacao = $Aux[1];
    }
  }
  if ($Situacao ne "") {
    print "\n>>> ALARM -> $Placa $Tronco $Situacao \n" if ($opt_debug2);
    grava_log2("\n>>> ALARM -> $Placa $Tronco $Situacao \n") if ($opt_debug);
    muda_estado_placas($Placa, $Situacao);
  }
}


##########
sub renomeia_id(@) {
  my $Velho = $Novo = $Id_ligacao = $sql = $Falsos = $Falsos2 = $Obs = $Retorno = $Transferiu = $Transferiu2 = $Transfere = $Transfere2 = "";
  my @Aux = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "Oldname") {
      $Velho = $Aux[1];
    } elsif ($Aux[0] eq "Newname") {
      $Novo = $Aux[1];
    } elsif ($Aux[0] eq "Uniqueid") {
      $Id_ligacao = $Aux[1];
    }
  }
  print "\n>>> renomeia  $Velho  $Novo  $Id_ligacao \n" if ($opt_debug2);
  grava_log2("\n>>> renomeia  $Velho  $Novo  $Id_ligacao  \n") if ($opt_debug);
##  if (substr($Velho,0,10) eq "Transfered") {
  my $cnov = pesquisa("SELECT id FROM vm50_ligacao_id WHERE canal='$Novo' ORDER BY id DESC LIMIT 1");
  if (($cnov eq "E") || ($cnov eq "")) {
    $cnov = pesquisa("SELECT id FROM vm50_ligacao_id WHERE id='$Id_ligacao'");
    if (($cnov eq "E") || ($cnov eq "")) {
      my $Proc = substr($Velho,0,length(trim($Velho))-2);
      my $N_id = pesquisa("SELECT id FROM vm50_ligacao_id WHERE canal LIKE '$Proc%' ORDER BY id DESC LIMIT 1");
#      $sql = "INSERT INTO vm50_ligacao_id (id, canal, canal_no, conversou) VALUES ('$Id_ligacao', '$Velho', '$Novo', '0')";
      if (($N_id ne "E") && ($N_id ne "")) {
        $Falsos     = pesquisa("SELECT falso FROM vm50_ligacao_id WHERE id='$N_id'");
        $Transfere  = pesquisa("SELECT transfere FROM vm50_ligacao_id WHERE id='$N_id'");
        $Obs        = pesquisa("SELECT obs FROM vm50_ligacao_id WHERE id='$N_id'");
        $Transferiu = pesquisa("SELECT transferiu FROM vm50_ligacao_id WHERE id='$N_id'");
        $Obs    = "Transfer&ecirc;ncia-".$Obs if ((substr($Obs,0,19) ne "Transfer&ecirc;ncia") && ($Obs ne ""));
        $sql = "UPDATE vm50_ligacao_id SET id='$Id_ligacao', canal='$Novo', falso='$Falsos', obs='$Obs', transfere='$Transfere', transferiu='$Transferiu' WHERE id='$N_id'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
        $N_id = pesquisa("SELECT id FROM vm50_ligacao_id WHERE id='$N_id'");
      }
    } else {
      $Falsos     = pesquisa("SELECT falso FROM vm50_ligacao_id WHERE id='$Id_ligacao'");
      $Transfere  = pesquisa("SELECT transfere FROM vm50_ligacao_id WHERE id='$Id_ligacao'");
      $Obs        = pesquisa("SELECT obs FROM vm50_ligacao_id WHERE id='$Id_ligacao'");
      $Transferiu = pesquisa("SELECT transferiu FROM vm50_ligacao_id WHERE id='$Id_ligacao'");
      $Obs    = "Transfer&ecirc;ncia-".$Obs if ((substr($Obs,0,19) ne "Transfer&ecirc;ncia") && ($Obs ne ""));
      $sql = "UPDATE vm50_ligacao_id SET canal_no='$Novo', falso='$Falsos', obs='$Obs', transfere='$Transfere', transferiu='$Transferiu' WHERE id='$Id_ligacao'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      $Id_ligacao = pesquisa("SELECT id FROM vm50_ligacao_id WHERE id='$Id_ligacao'");
    }
  } else {
    #$Falsos = pesquisa("SELECT falso FROM vm50_ligacao_id WHERE canal='$Novo'");
    my $cnov2 = join 'K',$cnov;
    $cnov2 = "K${cnov}P";
    my $teste   = pesquisa("SELECT id FROM vm50_ligacao_id WHERE id='$cnov'");
    $Falsos2    = pesquisa("SELECT falso FROM vm50_ligacao_id WHERE id='$cnov'");
    $Transfere2 = pesquisa("SELECT transfere FROM vm50_ligacao_id WHERE id='$cnov'");
    $Obs        = pesquisa("SELECT obs FROM vm50_ligacao_id WHERE id='$cnov'");
    $Transferiu2= pesquisa("SELECT transferiu FROM vm50_ligacao_id WHERE id='$cnov'");
    $Obs     = "Transfer&ecirc;ncia-".$Obs if ((substr($Obs,0,19) ne "Transfer&ecirc;ncia") && ($Obs ne ""));
    $sql     = "UPDATE vm50_ligacao_id SET id='$cnov2' ,canal_no='', obs='$Obs', transferiu='$Transferiu2' WHERE id='$Id_ligacao'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    $cnov2      = pesquisa("SELECT id FROM vm50_ligacao_id WHERE id='$cnov2'");
    $Falsos     = pesquisa("SELECT falso FROM vm50_ligacao_id WHERE id='$cnov2'");
    $Transfere  = pesquisa("SELECT transfere FROM vm50_ligacao_id WHERE id='$cnov2'");
    $Obs        = pesquisa("SELECT obs FROM vm50_ligacao_id WHERE id='$cnov2'");
    $Transferiu = pesquisa("SELECT transferiu FROM vm50_ligacao_id WHERE id='$cnov2'");
    $Obs     = "Transfer&ecirc;ncia-".$Obs if ((substr($Obs,0,19) ne "Transfer&ecirc;ncia") && ($Obs ne ""));
    $sql    = "UPDATE vm50_ligacao_id SET id='$Id_ligacao', canal_no='', obs='$Obs', falso='$Falsos', transfere='$Transfere', transferiu='$Transferiu' WHERE id='$cnov'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    $Id_ligacao = pesquisa("SELECT id FROM vm50_ligacao_id WHERE id='$Id_ligacao'");
    $sql = "UPDATE vm50_ligacao_id SET id='$cnov', canal_no='', falso='$Falsos2', transfere='$Transfere2', transferiu='$Transferiu2' WHERE id='$cnov2'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    $Id_ligacao = pesquisa("SELECT id FROM vm50_ligacao_id WHERE id='$cnov'");
  }
##  }
}


##########
sub coloca_na_orbita(@) {
  my $Canal = $Numero = $Orbita = $Id_ligacao = $sql = $Retorno = "";
  my @Aux = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "Channel") {
      $Canal = $Aux[1];
    } elsif ($Aux[0] eq "Exten") {
      $Orbita = $Aux[1];
    } elsif ($Aux[0] eq "CallerID") {
      $Numero = $Aux[1];
    }
  }
  print "\n>>> coloca_na_orbita  $Canal $Orbita $Numero \n" if ($opt_debug2);
  grava_log2("\n>>> coloca_na_orbita  $Canal $Orbita $Numero \n") if ($opt_debug);
  $Id_ligacao = pesquisa("SELECT id FROM vm50_ligacao_id WHERE canal='$Canal' ORDER BY id DESC LIMIT 1");
  if (($Id_ligacao ne "E") && ($Id_ligacao ne "")) {
    #$sql = "INSERT INTO vm50_orbitas (id, numero, canal) VALUES ('$Id_Ligacao', '$Numero', '$Canal')";
    $sql = "UPDATE vm50_orbitas SET id='$Id_Ligacao', numero='$Numero' WHERE orbita = '$Orbita'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    $sql = "UPDATE vm50_troncos SET situacao='R', numerointerno='&Oacute;rbita' WHERE numero_asterisk = '$Canal'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  }
}


##########
sub retira_da_orbita(@) {
  my $Canal = $Numero = $Orbita = $CPuxador = $NPuxador = $Id_ligacao = $sql = $Retorno = "";
  my @Aux = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "Channel") {
      $Canal = $Aux[1];
    } elsif ($Aux[0] eq "CallerID") {
      $Numero = $Aux[1];
    } elsif ($Aux[0] eq "Exten") {
      $Orbita = $Aux[1];
    } elsif ($Aux[0] eq "From") {
      $CPuxador = $Aux[1];
    }
  }
  print "\n>>> retira_da_orbita  $Canal $Orbita $Numero $CPuxador \n" if ($opt_debug2);
  grava_log2("\n>>> retira_da_orbita  $Canal $Orbita $Numero $CPuxador \n") if ($opt_debug);
  $Id_ligacao = pesquisa("SELECT id FROM vm50_orbitas WHERE orbita='$Orbita'");
  if (($Id_ligacao ne "E") && ($Id_ligacao ne "")) {
    #$sql = "DELETE FROM vm50_orbitas WHERE id = '$Id_ligacao' ";
    $sql = "UPDATE vm50_orbitas SET id='', numero='' WHERE orbita = '$Orbita'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    $Id_ligacao = pesquisa("SELECT id FROM vm50_ligacao_id WHERE canal='$CPuxador' ORDER BY id DESC LIMIT 1");
    if (($Id_ligacao ne "E") && ($Id_ligacao ne "")) {
      $NPuxador = pesquisa("SELECT numero FROM vm50_ligacao_id WHERE canal='$CPuxador' ORDER BY id DESC LIMIT 1");
      $sql = "UPDATE vm50_troncos SET situacao='R', id_interno='$Id_ligacao', numerointerno='$NPuxador' WHERE numero_asterisk = '$Canal'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      #muda_estado_ramal(ramal, canal, id, situacao, falandocom, direcao)
      muda_estado_ramal($NPuxador, "NULL", "NULL", "O", $Numero, "O");
    }
  }
}


##########
sub desiste_da_orbita(@) {
  my $Canal = $Numero = $Orbita = $CPuxador = $NPuxador = $Id_ligacao = $sql = $Retorno = "";
  my @Aux = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "Channel") {
      $Canal = $Aux[1];
    } elsif ($Aux[0] eq "CallerID") {
      $Numero = $Aux[1];
    } elsif ($Aux[0] eq "Exten") {
      $Orbita = $Aux[1];
    }
  }
  print "\n>>> desiste_da_orbita  $Canal $Orbita $Numero \n" if ($opt_debug2);
  grava_log2("\n>>> desiste_da_orbita  $Canal $Orbita $Numero \n") if ($opt_debug);
  $Id_ligacao = pesquisa("SELECT id FROM vm50_orbitas WHERE orbita='$Orbita'");
  if (($Id_ligacao ne "E") && ($Id_ligacao ne "")) {
    $sql = "UPDATE vm50_orbitas SET id='', numero='' WHERE orbita = '$Orbita'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  }
}



##########
sub le_quem_disca(@) {
  my $Linha = $Origem = $Destino = $Direcao = $sql = $VemOrbita = $Retorno = "";
  my @Aux = @Ll = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "DestUniqueID") {
      $Destino = $Aux[1];
    } elsif ($Aux[0] eq "SrcUniqueID") {
      $Origem = $Aux[1];
    }
  }
  print "\n>>> le_quem_disca -> $Origem $Destino \n" if ($opt_debug2);
  grava_log2("\n>>> le_quem_disca -> $Origem $Destino \n") if ($opt_debug);
  amarra_ligacoes($Origem, "NULL", $Destino, "NULL", "NULL", "Chamando", "NULL");
  ##
  grava_log2("\n>>> altera_tronco -> $Origem $Destino \n") if ($opt_debug);
  my $C_or = pesquisa( "SELECT canal FROM vm50_ligacao_id WHERE id='$Origem'" );
  my $C_de = pesquisa( "SELECT canal FROM vm50_ligacao_id WHERE id='$Destino'" );
  my $Numvdt = "";
  if (($C_or ne "E") || ($C_or ne "")) {
    if (testa_fabricante_placa($C_or) gt -1) {
      @Ll = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Origem' OR id_dest='$Origem'" );
      grava_log2(" $Ll[0]--$Ll[1]--$Ll[2]--$Ll[3] \n") if ($opt_debug);
      $sql = "UPDATE vm50_troncos SET situacao='O', numeroexterno='$Ll[1]', numerointerno='$Ll[3]', id_externo='$Ll[0]', id_interno='$Ll[2]', direcao='I' WHERE numero_asterisk = '$C_or' AND (situacao='L' OR situacao='O' OR situacao='R')";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      ##>>> Arruma orbitas presas
      $sql = "UPDATE vm50_orbitas SET id='', numero='' WHERE id = '$Ll[0]'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      ##<<< Arruma orbitas presas
      #muda_estado_ramal(ramal, canal, id, situacao, falandocom, direcao)
      muda_estado_ramal($Ll[3], "NULL", $Ll[2], "O", $Ll[1], "I");
    }
    elsif (testa_fabricante_placa($C_de) gt -1) {
      @Ll = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Destino' OR id_dest='$Destino'" );
      grava_log2(" $Ll[0]--$Ll[1]--$Ll[2]--$Ll[3] \n") if ($opt_debug);
      $VemOrbita = pesquisa( "SELECT situacao FROM vm50_troncos WHERE numero_asterisk = '$C_or'" );
      if ($VemOrbita eq 'R') {
        $Direcao = 'I';
      } else {
        $Direcao = 'O';
      }
      $sql = "UPDATE vm50_troncos SET situacao='O', numeroexterno='$Ll[3]', numerointerno='$Ll[1]', id_externo='$Ll[2]', id_interno='$Ll[0]', direcao='$Direcao' WHERE numero_asterisk = '$C_de' AND (situacao='L' OR situacao='O' OR situacao='R')";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      ##>>> Arruma orbitas presas
      $sql = "UPDATE vm50_orbitas SET id='', numero='' WHERE id = '$Ll[2]'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      ##<<< Arruma orbitas presas
      #muda_estado_ramal(ramal, canal, id, situacao, falandocom, direcao)
      muda_estado_ramal($Ll[1], "NULL", $Ll[0], "O", $Ll[3], $Direcao);
    } else {
      $Numvdt = testa_fabricante_placa_ip($C_or);
      if ($Numvdt gt 0) {
        @Ll = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Origem' OR id_dest='$Origem'" );
        grava_log2(" $Ll[0]--$Ll[1]--$Ll[2]--$Ll[3] \n") if ($opt_debug);
        $sql = "UPDATE vm50_troncos SET situacao='O', numeroexterno='$Ll[1]', numerointerno='$Ll[3]', id_externo='$Ll[0]', id_interno='$Ll[2]', direcao='I' WHERE numero_vdt = '$Numvdt' AND (situacao='L' OR situacao='O' OR situacao='R')";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
        ##>>> Arruma orbitas presas
        $sql = "UPDATE vm50_orbitas SET id='', numero='' WHERE id = '$Ll[0]'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
        ##<<< Arruma orbitas presas
        #muda_estado_ramal(ramal, canal, id, situacao, falandocom, direcao)
        muda_estado_ramal($Ll[3], "NULL", $Ll[2], "O", $Ll[1], "I");
      } else {
        $Numvdt = testa_fabricante_placa_ip($C_de);
        if ($Numvdt gt 0) {
          @Ll = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Destino' OR id_dest='$Destino'" );
          grava_log2(" $Ll[0]--$Ll[1]--$Ll[2]--$Ll[3] \n") if ($opt_debug);
          $VemOrbita = pesquisa( "SELECT situacao FROM vm50_troncos WHERE numero_vdt = '$Numvdt'" );
          if ($VemOrbita eq 'R') {
            $Direcao = 'I';
          } else {
            $Direcao = 'O';
          }
          $sql = "UPDATE vm50_troncos SET situacao='O', numeroexterno='$Ll[3]', numerointerno='$Ll[1]', id_externo='$Ll[2]', id_interno='$Ll[0]', direcao='$Direcao' WHERE numero_vdt = '$Numvdt' AND (situacao='L' OR situacao='O' OR situacao='R')";
          $Retorno = $dbh->do($sql);
          print "$sql $Retorno\n" if ($opt_debug2);
          grava_log2("$sql $Retorno\n") if ($opt_debug);
          ##>>> Arruma orbitas presas
          $sql = "UPDATE vm50_orbitas SET id='', numero='' WHERE id = '$Ll[2]'";
          $Retorno = $dbh->do($sql);
          print "$sql $Retorno\n" if ($opt_debug2);
          grava_log2("$sql $Retorno\n") if ($opt_debug);
          ##<<< Arruma orbitas presas
          #muda_estado_ramal(ramal, canal, id, situacao, falandocom, direcao)
          muda_estado_ramal($Ll[1], "NULL", $Ll[0], "O", $Ll[3], $Direcao);
        }
      }
    }
  } elsif (($C_de ne "E") || ($C_de ne "")) {
    if (testa_fabricante_placa($C_de) gt -1) {
      @Ll = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Destino' OR id_dest='$Destino'" );
      grava_log2(" $Ll[0]--$Ll[1]--$Ll[2]--$Ll[3] \n") if ($opt_debug);
      $VemOrbita = pesquisa( "SELECT situacao FROM vm50_troncos WHERE numero_asterisk = '$C_or'" );
      if ($VemOrbita eq 'R') {
        $Direcao = 'I';
      } else {
        $Direcao = 'O';
      }
      $sql = "UPDATE vm50_troncos SET situacao='O', numeroexterno='$Ll[3]', numerointerno='$Ll[1]', id_externo='$Ll[2]', id_interno='$Ll[0]', direcao='O' WHERE numero_asterisk = '$C_de' AND (situacao='L' OR situacao='O' OR situacao='R')";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      ##>>> Arruma orbitas presas
      $sql = "UPDATE vm50_orbitas SET id='', numero='' WHERE id = '$Ll[2]'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      ##<<< Arruma orbitas presas
      #muda_estado_ramal(ramal, canal, id, situacao, falandocom, direcao)
      muda_estado_ramal($Ll[1], "NULL", $Ll[0], "O", $Ll[3], "O");
    } else {
      $Numvdt = testa_fabricante_placa_ip($C_de);
      if ($Numvdt gt 0) {
        @Ll = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Destino' OR id_dest='$Destino'" );
        grava_log2(" $Ll[0]--$Ll[1]--$Ll[2]--$Ll[3] \n") if ($opt_debug);
        $VemOrbita = pesquisa( "SELECT situacao FROM vm50_troncos WHERE numero_vdt = '$Numvdt'" );
        if ($VemOrbita eq 'R') {
          $Direcao = 'I';
        } else {
          $Direcao = 'O';
        }
        $sql = "UPDATE vm50_troncos SET situacao='O', numeroexterno='$Ll[3]', numerointerno='$Ll[1]', id_externo='$Ll[2]', id_interno='$Ll[0]', direcao='O' WHERE numero_vdt = '$Numvdt' AND (situacao='L' OR situacao='O' OR situacao='R')";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
        ##>>> Arruma orbitas presas
        $sql = "UPDATE vm50_orbitas SET id='', numero='' WHERE id = '$Ll[2]'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
        ##<<< Arruma orbitas presas
        #muda_estado_ramal(ramal, canal, id, situacao, falandocom, direcao)
        muda_estado_ramal($Ll[1], "NULL", $Ll[0], "O", $Ll[3], "O");
      }
    }
  }
  ##>> Muda estado do ramal
  #muda_estado_ramal(ramal, canal, id, situacao, falandocom, direcao)
  my $NumOr = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE id='$Origem'" );
  my $NumDe = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE id='$Destino'" );
# >>> Cria o estado chamando ramal
#  muda_estado_ramal($NumOr, "", $Origem, "O", $NumDe, "O") if (eh_ramal($NumOr));
#  muda_estado_ramal($NumDe, "", $Destino, "O", $NumOr, "I") if (eh_ramal($NumDe));

#  muda_estado_ramal($NumOr, "", $Origem, "C", $NumDe, "O") if (eh_ramal($NumOr));
#  muda_estado_ramal($NumDe, "", $Destino, "C", $NumOr, "I") if (eh_ramal($NumDe));

# <<< Cria o estado chamando ramal
  ##<< Muda estado do ramal
}


##########
sub le_quem_atendeu(@) {
  my $Linha = $Origem = $Destino = $Canal1 = $Canal2 = $Agente = $Ramal = $Ramal1 = $Ramal2 = $CallID1 = $CallID2 = $sql = $Retorno = "";
  my $Num_des = $Paa = $Num_ori = "NULL";
  my @Aux = @Aux1 = @Aux2 = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    grava_log2(">>> le_quem_atendeu -> $Aux[0]: $Aux[1] \n") if ($opt_debug);
    if ($Aux[0] eq "Uniqueid2") {
      $Destino = $Aux[1];
    } elsif ($Aux[0] eq "Uniqueid1") {
      $Origem = $Aux[1];
    } elsif ($Aux[0] eq "Channel1") {
      $Canal1 = $Aux[1];
      #grava_log2(">>> atualiza_ligacao -> $Canal1 \n") if ($opt_debug);
    } elsif ($Aux[0] eq "Channel2") {
      $Canal2 = $Aux[1];
      #grava_log2(">>> atualiza_ligacao -> $Canal2 \n") if ($opt_debug);
    } elsif ($Aux[0] eq "CallerID1") {  
      $CallID1 = $Aux[1];  
      #grava_log2(">>> atualiza_ligacao -> CallID1: $CallID1 \n") if ($opt_debug);  
    } elsif ($Aux[0] eq "CallerID2") {  
      $CallID2 = $Aux[1];  
      #grava_log2(">>> atualiza_ligacao -> CallID2: $CallID2 \n") if ($opt_debug);  
    }
  }
  if ((substr($Canal1,0,5) eq "Agent") && (substr($Canal2,0,5) eq "Local")){
    #>>> Transferencia entre agentes de filas nao mostra a transferencia
    @Aux1 = split(/\//, $Canal1);
    $Agente  = $Aux1[1];
    $Paa     = pesquisa("SELECT ramal FROM vm50_agentes WHERE login='$Agente' AND situacao!='NLogado'");
    $Origem  = "NULL";
    $Origem  = pesquisa("SELECT id FROM vm50_ligacao_id WHERE numero='$Paa' AND canal LIKE 'Agent%' AND falso!='1' ORDER BY id DESC LIMIT 1") if ($Paa ne "E");
    #<<< Transferencia entre agentes de filas nao mostra a transferencia
    @Aux1 = split(/@/, $Canal2);
    @Aux2 = split(/\//, $Aux1[0]);
    $Num_des = $Aux2[1];
    $Num_ori = "NULL";
    $Num_ori = $Paa if ($Paa ne "E");
    print ">>> atualiza_ligacao -> $Destino $Canal2 \n" if ($opt_debug2);
    grava_log2(">>> atualiza_ligacao -> $Destino $Canal2 \n") if ($opt_debug);
    $sql = "UPDATE vm50_ligacao_id SET numero = '$Num_des', canal = '$Canal2', obs = 'FILA' WHERE id = '$Destino' ";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    $sql = "DELETE FROM vm50_link_ligacao WHERE id_orig = '$Destino' ";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  } elsif ((substr($Canal1,0,5) eq "Local") && (substr($Canal2,0,5) eq "Agent")){
  #Corrigindo agente unregistered
    my $SemLocal = substr($Canal2,6);
    @Aux1 = split(/@/, $SemLocal);
    if (eh_ramal($Aux1[0])) {
      @Aux1 = split(/\//, $Canal2);
      $Agente  = $Aux1[1];
      $Paa     = pesquisa( "SELECT ramal FROM vm50_agentes WHERE login='$Agente'" );
      $Paa     = "NULL" if ($Paa eq "E");
      @Aux1    = split(/@/, $Canal1);
      @Aux2 = split(/\//, $Aux1[0]);
      $Ramal   = $Aux2[1];
      $Origem  = pesquisa( "SELECT id_orig FROM vm50_link_ligacao WHERE pa='$Ramal'" );
      $Origem  = "NULL" if ($Origem eq "E");
      $Num_ori = "NULL";
      print "\n>>> altera_situacao_agente -> $Ramal Desligado $Origem \n" if ($opt_debug2);
      grava_log2("\n>>> altera_situacao_agente -> $Ramal Desligado $Origem \n") if ($opt_debug);
      altera_situacao_agente($Canal2, "", "", "Desligado", $Origem);
    }
  #Fim da correcao do agente unregistered
  } elsif((substr($Canal1,0,5) eq "Local") && (substr($Canal2,0,3) eq "SIP")) {  
      
    print "\n>>> Verificando captura\n" if ($opt_debug2);  
    grava_log2("\n>>> Verificando captura\n") if ($opt_debug);  
 
    if((eh_ramal($CallID1) eq 0) && (eh_ramal($CallID2) eq 1)){  
      print "\n>>> Eh uma captura de ligacao. Ramal $CallID2 capturando $CallID1 \n" if ($opt_debug2);  
      grava_log2("\n>>> Eh uma captura de ligacao. Ramal $CallID2 capturando $CallID1 \n") if ($opt_debug);  
        
      ##### Pesquisa os dados da ligação #####  
      @Aux = pesquisa_multipla("SELECT * FROM vm50_link_ligacao WHERE numero_orig = '$CallID1' OR numero_dest = '$CallID1' LIMIT 1");  
      ##### Final da pesquisa os dados da ligação #####  
 
      ##### Atualiza o ramal do destino, pois a ligação foi capturada #####  
      my $sql = "UPDATE vm50_link_ligacao SET numero_dest = '$CallID2', pa = '$CallID2', estado = 'Em conversa&ccedil;&atilde;o', tipo='I', obs = 'FILA', conversou='' WHERE id_orig = '$Aux[0]' AND id_dest = '$Aux[2]'";  
      $Retorno = $dbh->do($sql);  
      print "\n$sql => $Retorno \n" if ($opt_debug2);  
      grava_log2("\n$sql => $Retorno \n") if ($opt_debug);  
      ##### Final da atualização do ramal do destino #####  
        
      ##### Atualiza canal no vm50_ligacao_id #####  
      $sql = "UPDATE vm50_ligacao_id SET canal = '$Canal2' WHERE id = '$Aux[0]'";  
      $Retorno = $dbh->do($sql);  
      print "\n$sql => $Retorno \n" if ($opt_debug2);  
      grava_log2("\n$sql => $Retorno \n") if ($opt_debug);  
      if($Aux[2] ne ''){  
        $sql = "UPDATE vm50_ligacao_id SET canal = '$Canal2' WHERE id = '$Aux[2]'";  
        $Retorno = $dbh->do($sql);  
        print "\n$sql => $Retorno \n" if ($opt_debug2);  
        grava_log2("\n$sql => $Retorno \n") if ($opt_debug);  
      }  
      ##### Final do atualizar canal no vm50_ligacao_id #####  
 
      my $Agente = "";  
      $Agente = pesquisa("SELECT login FROM vm50_agentes WHERE ramal = '$CallID2'");  
      my @AuxF = split(/\//, $Canal1);  
      @Aux1 = split(/@/, $AuxF[1]);  
      my $Fila = "";  
      $Fila = pesquisa("SELECT fila FROM vm50_agentes WHERE ramal = '$Aux1[0]'");  
        
      $sql = "UPDATE vm50_agentes SET id_ligacao = '$Aux[0]' WHERE login = '$Agente' AND situacao != 'NLogado'";  
      $Retorno = $dbh->do($sql);  
      print "\n>>>$sql => $Retorno \n" if ($opt_debug2);  
      grava_log2("\n>>>$sql => $Retorno \n") if ($opt_debug);  
 
      $sql = "DELETE FROM vm50_ligacao_id WHERE id = '$Origem'";  
      $Retorno = $dbh->do($sql);  
      print "\n>>>$sql => $Retorno \n" if ($opt_debug2);  
      grava_log2("\n>>>$sql => $Retorno \n") if ($opt_debug);  
        
      #altera_situacao_agente(canal, falandocom, fila, situacao, id_ligacao);  
      print "\n>>> altera_situacao_agente -> $Agente Em conversacao $Aux[0] -> $Aux[2] \n" if ($opt_debug2);  
      grava_log2("\n>>> altera_situacao_agente -> $Agente Em conversacao $Aux[0] -> $Aux[2] \n") if ($opt_debug);  
      altera_situacao_agente("Agent/$Agente", $CallID1, $Fila, "Em conversa&ccedil;&atilde;o", $Aux[0]);  
 
      ##### Arruma a tabela vm50_ligacao_id para poder atualizar o agente original #####  
      my $Agente1 = pesquisa("SELECT login FROM vm50_agentes WHERE ramal = '$Aux1[0]'");  
      $sql = "SELECT id FROM vm50_ligacao_id WHERE canal = 'Agent/$Agente1' ORDER BY id DESC LIMIT 1";  
      my $AuxId = pesquisa($sql);  
      print "\n>>>$sql => $AuxId \n" if ($opt_debug2);  
      grava_log2("\n>>>$sql => $AuxId \n") if ($opt_debug);  
      $sql = "UPDATE vm50_ligacao_id SET canal = 'Agent/$Agente' WHERE id = '$AuxId'";  
      $Retorno = $dbh->do($sql) if(($AuxId ne 'E') && ($AuxId ne ''));  
      print "\n>>>$sql => $Retorno \n" if ($opt_debug2);  
      grava_log2("\n>>>$sql => $Retorno \n") if ($opt_debug);  
      ##### Final do arruma a tabela vm50_ligacao_id #####  
 
      $sql = "UPDATE vm50_agentes SET situacao = 'Livre', falandocom = '', id_ligacao = '', fila = '', ult_estad = CURRENT_TIMESTAMP WHERE login = '$Agente1'";  
      $Retorno = $dbh->do($sql) if(($Agente1 ne 'E') && ($Agente1 ne ''));  
      print "\n>>>$sql => $Retorno \n" if ($opt_debug2);  
      grava_log2("\n>>>$sql => $Retorno \n") if ($opt_debug);  
    }
  } else {
  #>>> Fila sem agente, soh de ramais
    $Paa = pesquisa( "SELECT pa FROM vm50_link_ligacao WHERE id_orig='$Origem' OR id_dest='$Destino' LIMIT 1" );
  #>>> Para resolver a luz de ramal desligado quando transfere
    $Ramal1 = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE id='$Origem'" );
    $Ramal2 = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE id='$Destino'" );
    $Paa = $Ramal2 if (($Paa ne $Ramal1) && ($Paa ne $Ramal2) && ($Ramal1 ne "E") && ($Ramal1 ne "") && ($Ramal2 ne "E") && ($Ramal2 ne ""));
  #<<< Para resolver a luz de ramal desligado quando transfere
    if (($Paa eq "E") || ($Paa eq "")) {
      $Paa = "NULL";
    } else {
      my $Tipo = pesquisa( "SELECT tipo FROM vm50_link_ligacao WHERE id_orig='$Origem' OR id_dest='$Destino' LIMIT 1" );
      if ($Tipo eq "I") {
        $Num_des = $Paa;
      } else {
        $Num_ori = $Paa;
      }
    }
  #<<< Fila sem agente, soh de ramais
  }
  print "\n>>> le_quem_atendeu (falso) -> $Origem $Destino $Paa \n" if ($opt_debug2);
  grava_log2("\n>>> le_quem_atendeu (falso) -> $Origem $Destino $Paa \n") if ($opt_debug);
  amarra_ligacoes($Origem, $Num_ori, $Destino, $Num_des, $Paa, "Em conversa&ccedil;&atilde;o", "NULL");
  #muda_estado_ramal(ramal, canal, id, situacao, falandocom, direcao)
#  my $NumOr = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE id='$Origem'" );
#  my $NumDe = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE id='$Destino'" );
  muda_estado_ramal($Num_ori, "", $Origem, "O", $Num_des, "O") if (eh_ramal($Num_ori));
  muda_estado_ramal($Num_des, "", $Destino, "O", $Num_ori, "I") if (eh_ramal($Num_des));
  ##<< Muda estado do ramal

}


##########
### Tratando tranferencias entre filas >>>
##########
sub le_agente_que_atendeu(@) {
  my $Linha = $Origem = $Destino = $Canal1 = $Canal2 = $Agente = $Ramal = $sql = "";
  my $Num_des = $Paa = $Num_ori = "NULL";
  my @Aux = @Aux1 = @Aux2 = "";
  for $Linha (@_) {
    print " $Linha\n" if ($opt_display);
    @Aux = separa_dois_pontos($Linha);
    if ($Aux[0] eq "BridgedChannel") {
      $Destino = $Aux[1];
    } elsif ($Aux[0] eq "Uniqueid") {
      $Origem = $Aux[1];
    } elsif ($Aux[0] eq "Channel") {
      $Canal1 = $Aux[1];
      grava_log2(">>> atualiza_ligacao -> $Canal1 \n") if ($opt_debug);
    }
  }
  if (substr($Canal1,0,5) eq "Agent") {
    @Aux1 = split(/\//, $Canal1);
    $Agente  = $Aux1[1];
  }
  $Num_ori = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE id='$Origem'" );
  return if (($Num_ori eq "") || ($Num_ori eq "E"));
  $Paa     = pesquisa( "SELECT ramal FROM vm50_agentes WHERE login='$Agente'" );
  return if (($Paa eq "") || ($Paa eq "E"));
  print "\n>>> le_agente_que_atendeu -> $Origem $Agente \n" if ($opt_debug2);
  grava_log2("\n>>> le_agente_que_atendeu  -> $Origem $Agente \n") if ($opt_debug);
  my $Teste = pesquisa( "SELECT id FROM vm50_ligacao_id WHERE id='$Destino'" );
  if ($Teste eq $Destino) {
    #amarra_ligacoes(id_origem, num_origem, id_destino, num_destino, pa, estado, obs);
    amarra_ligacoes($Origem, $Num_ori, $Destino, "NULL", $Paa, "Em conversa&ccedil;&atilde;o", "NULL");
  } else {
    amarra_ligacoes($Origem, $Num_ori, "NULL", $Destino, $Paa, "Em conversa&ccedil;&atilde;o", "NULL");
  }
 #registra_para_relatorio_pbx(ligacao_origem,numero_origem,canal_origem,ligacao_destino,numero_destino,canal_destino,oque);
  registra_para_relatorio_pbx($Origem,"NULL","NULL","NULL",$Paa,"NULL","Em conversa&ccedil;&atilde;o");
}
### <<< Tratando tranferencias entre filas




######################
## Funcoes do Banco ##
######################
sub fecha_ligacao(@) {
  my $Id    = $_[0];
  my $Re    = $_[1];
  my $Canal = $_[2];
  my $sql = $Retorno = "";
  #>> Corrige o nao desligar das ligacoes
  altera_situacao_agente($Canal, "NULL", "NULL", "Desligado",$Id) if ($Re eq 0);
  #<< Corrige o nao desligar das ligacoes
  $sql = "DELETE FROM vm50_ligacao_id WHERE id='$Id'";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
  amarra_ligacoes($Id, "NULL", "NULL", "NULL", "NULL", "Desligado", "NULL");
}


# uso fecha_ligacao_forcada(id_Ligacao,agente);
sub fecha_ligacao_forcada(@) {
  my $Id    = $_[0];  
  my $Canal = $_[1];  
  my $Saida = $sql = $Retorno = "";
  grava_log2("\n>>fecha_agente_forcado $Id $Canal \n") if ($opt_debug);
  $Saida = fecha_agente_forcado($Id,$Canal);
  $sql = "DELETE FROM vm50_ligacao_id WHERE id='$Id'";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
  $sql = "UPDATE vm50_link_ligacao SET estado = 'Desligado' WHERE id_orig = '$Id' OR id_dest = '$Id'";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
#  registra_para_relatorio("","",$Id,"","Desligado","","","");
  return $Saida;
}


#muda_estado_placas(placa, situacao)
sub muda_estado_placas(@) {
  my $Placa    = $_[0];
  my $Situacao = $_[1];
  my $sql      = $Retorno = "";
  my @Aux      = "";
  my $Total    = 0;
  $sql = "UPDATE vm50_troncos SET situacao='B', numeroexterno='', numerointerno='', id_externo='', id_interno='', direcao='', canal_asterisk='' WHERE placa_numero='$Placa'" if ($Situacao eq "1");
  $sql = "UPDATE vm50_troncos SET situacao='L', numeroexterno='', numerointerno='', id_externo='', id_interno='', direcao='', canal_asterisk='' WHERE placa_numero='$Placa'" if ($Situacao eq "0");
  if ($sql ne "") {
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  }
  @Aux  = pesquisa_varias_linhas("SELECT numero_asterisk FROM vm50_troncos WHERE placa_numero='$Placa'");
  $Total = @Aux;
  for (my $x=0; $x < $Total; $x++) {
   #registra_para_relatorio_pbx(ligacao_origem,numero_origem,canal_origem,ligacao_destino,numero_destino,canal_destino,oque);
    registra_para_relatorio_pbx("NULL","NULL",$Aux[$x],"NULL","NULL","NULL","Bloqueado") if ($Situacao eq "1");
    registra_para_relatorio_pbx("NULL","NULL",$Aux[$x],"NULL","NULL","NULL","Livre")     if ($Situacao eq "0");
  }
}


#muda_estado_ramal(ramal, canal, id, situacao, falandocom, direcao)
sub muda_estado_ramal(@) {
  my $Ramal    = $_[0];
  my $Canal    = $_[1];
  my $Id_li    = $_[2];
  my $Situacao = $_[3];
  my $Falando  = $_[4];
  my $Direcao  = $_[5];
  my $sql = $Teste = $Rama2 = $Situa2 = $PRama = $Retorno = $Temalgum = "";
  print "muda_estado_ramal $Ramal $Canal $Id_li $Situacao $Falando \n" if ($opt_debug2);
  grava_log2("muda_estado_ramal $Ramal $Canal $Id_li $Situacao  $Falando \n") if ($opt_debug);
  if (substr($Canal,0,9) eq "AsyncGoto") {
    $Canal  = substr($Canal,10);
  } elsif (substr($Canal,0,10) eq "Transfered") {
    $Canal = substr($Canal,11);
  }
  $Temalgum = pesquisa( "SELECT count(numero) FROM vm50_ligacao_id WHERE numero LIKE '$Ramal' ORDER BY id DESC LIMIT 1" ) if (($Ramal ne "NULL") && ($Ramal ne "") && ($Ramal ne "E") && ($Ramal ne "algu"));
  $Rama2 = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE numero LIKE '$Ramal' AND falso!='1' ORDER BY id DESC LIMIT 1" ) if (($Ramal ne "NULL") && ($Ramal ne "") && ($Ramal ne "E") && ($Ramal ne "algu") && ($Temalgum ne "1"));
  return if ($Rama2 eq "E");
  $Situa2 = pesquisa( "SELECT situacao FROM vm50_ramais WHERE ramal='$Falando'" ) if (($Falando ne "NULL") && ($Falando ne "") && ($Falando ne "E") && ($Falando ne "algu") && ($Falando ne "Caixa Postal"));
  if ($Situa2 ne "O") {
    $PRama = '%'.$Falando;
    $Temalgum = pesquisa( "SELECT count(numero) FROM vm50_ligacao_id WHERE numero LIKE '$PRama' ORDER BY id DESC LIMIT 1" )  if (($Falando ne "NULL") && ($Falando ne "") && ($Falando ne "E") && ($Falando ne "algu") && ($Falando ne "Caixa Postal"));
    $Rama2 = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE numero LIKE '$PRama' AND falso!='1' ORDER BY id DESC LIMIT 1" ) if (($Falando ne "NULL") && ($Falando ne "") && ($Falando ne "E") && ($Falando ne "algu") && ($Falando ne "Caixa Postal") && ($Temalgum ne "1"));
    return if ($Rama2 eq "E");
  }
  $Ramal = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE id='$Id_li'" ) if (($Ramal eq "NULL") || ($Ramal eq "")  || ($Ramal eq "E"));
  $Temalgum = pesquisa( "SELECT count(numero) FROM vm50_ligacao_id WHERE numero LIKE '$Ramal' ORDER BY id DESC LIMIT 1" ) if (($Ramal ne "NULL") && ($Ramal ne "") && ($Ramal ne "E") && ($Ramal ne "algu"));
  $Rama2 = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE numero LIKE '$Ramal' AND falso!='1' ORDER BY id DESC LIMIT 1" ) if (($Ramal ne "NULL") && ($Ramal ne "") && ($Ramal ne "E") && ($Ramal ne "algu") && ($Temalgum ne "1"));
  return if ($Rama2 eq "E");
  if (($Ramal eq "NULL") || ($Ramal eq "")  || ($Ramal eq "E")) {
    $Ramal = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE canal='$Canal' ORDER BY id DESC LIMIT 1" );
    if (($Ramal ne "") && ($Ramal ne "NULL") && ($Ramal ne "E")) {
#      $sql = "UPDATE vm50_ramais SET ramal='$Ramal', falandocom='$Falando' WHERE id='$Id_li'" if ($Ramal ne $Falando);
#      $sql = "UPDATE vm50_ramais SET ramal='$Ramal' WHERE id='$Id_li'" if ($Ramal eq $Falando);
      $Falando = pesquisa( "SELECT falandocom FROM vm50_ramais WHERE ramal='$Ramal'" ) if ($Falando eq "NULL");
      $Falando = "NULL" if ($Falando eq "E");
      $sql = "UPDATE vm50_ramais SET ramal='$Ramal', falandocom='$Falando' WHERE ramal='$Ramal'" if ($Ramal ne $Falando);
      $sql = "UPDATE vm50_ramais SET ramal='$Ramal' WHERE ramal='$Ramal'" if ($Ramal eq $Falando);
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    }
  }
  if (($Ramal ne "") && ($Ramal ne "NULL") && ($Ramal ne "E")) {
    $Teste = pesquisa( "SELECT id FROM vm50_ligacao_id WHERE numero='$Ramal' AND id!='$Id_li' AND falso!='1' LIMIT 1" );
    if (($Teste ne "") && ($Teste ne "E")) {
      $Teste = pesquisa( "SELECT id_orig FROM vm50_link_ligacao WHERE id_orig='$Id_li' OR id_dest='$Id_li'" );
    }
    if (($Teste eq "") || ($Teste eq "E") || (eh_ramal($Teste) eq 0)) {
#      $sql = "UPDATE vm50_ramais SET situacao='$Situacao' WHERE ramal='$Ramal' AND situacao!='U'";
      $Teste = pesquisa( "SELECT falandocom FROM vm50_ramais WHERE ramal='$Ramal'" );
      $Falando = "Caixa Postal" if (($Teste eq "Caixa Postal") && ($Situacao eq "O"));
      if ($Ramal eq $Falando) {
        $Falando = "algu";
        $Direcao = "X";
      }
      $Direcao = "" if ($Situacao eq "L");
      if ($Falando eq "algu") {
        if ($Direcao eq "X") {
          $sql = "UPDATE vm50_ramais SET situacao='$Situacao' WHERE ramal='$Ramal'";
        } else {
          $sql = "UPDATE vm50_ramais SET situacao='$Situacao', direcao='$Direcao' WHERE ramal='$Ramal'";
        }
      } else {
        $Falando = pesquisa( "SELECT falandocom FROM vm50_ramais WHERE ramal='$Ramal'" ) if ($Falando eq "NULL");
        $Falando = "NULL" if ($Falando eq "E");
        if ($Direcao eq "X") {
          $sql = "UPDATE vm50_ramais SET situacao='$Situacao', falandocom='$Falando' WHERE ramal='$Ramal'";
        } else {
          $sql = "UPDATE vm50_ramais SET situacao='$Situacao', falandocom='$Falando', direcao='$Direcao' WHERE ramal='$Ramal'";
        }
      }
#      $sql = "UPDATE vm50_ramais SET situacao='$Situacao', falandocom='$Falando', direcao='$Direcao' WHERE ramal='$Ramal'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      if (($Ramal ne $Falando) && (eh_ramal($Falando) eq 1)) {
        $sql = "";
        if ($Direcao eq "I") {
          $sql = "UPDATE vm50_ramais SET situacao='O', falandocom='$Ramal', direcao='O' WHERE ramal='$Falando'";
        } elsif ($Direcao eq "O") {
          $sql = "UPDATE vm50_ramais SET situacao='O', falandocom='$Ramal', direcao='I' WHERE ramal='$Falando'";
        }
        if ($sql ne "") {
          $Retorno = $dbh->do($sql);
          print "$sql $Retorno\n" if ($opt_debug2);
          grava_log2("$sql $Retorno\n") if ($opt_debug);
        }
      }
    } else {
      $Teste = pesquisa( "SELECT falandocom FROM vm50_ramais WHERE ramal='$Ramal'" );
      $Falando = "Caixa Postal" if (($Teste eq "Caixa Postal") && ($Situacao eq "O"));
      $Direcao = "" if ($Situacao eq "L");
      $sql = "";
      if ($Falando ne "algu") {
        $Falando = pesquisa( "SELECT falandocom FROM vm50_ramais WHERE ramal='$Ramal'" ) if ($Falando eq "NULL");
        $Falando = "NULL" if ($Falando eq "E");
        if ($Direcao eq "X") {
          $sql = "UPDATE vm50_ramais SET falandocom='$Falando' WHERE ramal='$Ramal'";
        } else {
          $sql = "UPDATE vm50_ramais SET falandocom='$Falando', direcao='$Direcao' WHERE ramal='$Ramal'";
        }
      }
      if ($sql ne "") {
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
      }
    }
  }
}


#uso ramal_grava_endereco_ip(ramal,endereco)
sub ramal_grava_endereco_ip(@) {
  my $Ramal    = $_[0];
  my $Endereco = $_[1];
  my $sql = $Ramal_id = $Retorno = "";
  $Ramal_id = pesquisa( "SELECT id FROM vm50_ramais WHERE ramal='$Ramal' AND endereco='$Endereco'" );
  if (($Ramal_id eq "E") || ($Ramal_id eq "")) {
    $sql = "UPDATE vm50_ramais SET endereco='-none-' WHERE endereco='$Endereco'";    
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    $sql = "UPDATE vm50_ramais SET endereco='$Endereco' WHERE ramal ='$Ramal'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  }
#  $sql = "UPDATE vm50_ramais SET situacao='L' WHERE ramal ='$Ramal' AND situacao='U'";
  $sql = "UPDATE vm50_ramais SET situacao='L' WHERE ramal ='$Ramal' AND situacao='U'";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
}


#uso ramal_desgrava_endereco_ip(ramal)
sub ramal_desgrava_endereco_ip($) {
  my $Ramal = $_[0];
  my $sql = $Retorno = "";
  $sql = "UPDATE vm50_ramais SET endereco='-none-', situacao='U' WHERE ramal ='$Ramal'";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
}


#uso loga_agente(agente, ramal)
sub loga_agente(@) {
  my $Agente = $_[0];
  my $Ramal  = $_[1];
  my $Id_Agente = $sql = $Retorno = "";
	$Id_Agente = pesquisa( "SELECT id FROM vm50_agentes WHERE login='$Agente'" );	
  if ($Id_Agente gt 0){
    $sql = "UPDATE vm50_agentes SET situacao='$Situacao_agente[0]', ramal='$Ramal', tempo=CURRENT_TIMESTAMP, fila='', falandocom='', id_ligacao='', pausa=0, pausafalsa='', tipopausa='', ult_estad=CURRENT_TIMESTAMP WHERE id = '$Id_Agente'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    registra_para_relatorio($Agente,"","",$Ramal,"Login","","","","");
  }
}

#desloga_agente(agente, ramal, tempo);
sub desloga_agente(@) {
  my $Agente = $_[0];
  my $Ramal  = $_[1];
  my $Id_Agente = $sql = $Retorno = "";
	$Id_Agente = pesquisa( "SELECT id FROM vm50_agentes WHERE login='$Agente'" );	
  if ($Id_Agente gt 0){
    $sql = "UPDATE vm50_agentes SET situacao='$Situacao_agente[1]', ramal='', tempo=NULL, fila='', falandocom='', id_ligacao='', pausa=0, pausafalsa='', tipopausa='', ult_estad=NULL WHERE id = '$Id_Agente'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    registra_para_relatorio($Agente,"","",$Ramal,"Logout","","","","");
    print $sock "Action: QueuePause\r\nInterface: Agent/$Agente\r\nPaused: false\r\n\r\n";
  }
}

#desloga_agente_forcado(ramal);
sub desloga_agente_forcado($) {
  my $Ramal = $_[0];
  my $Agente = "";
	$Agente = pesquisa( "SELECT login FROM vm50_agentes WHERE ramal='$Ramal'" );	
  if ($Agente gt 0){
    desloga_agente($Agente,"NULL","NULL");
    print $sock "Action: Command\r\nCommand: Agent Logoff Agent/$Agente \r\n\r\n";
    print "Action: Command\r\nCommand: Agent Logoff Agent/$Agente \r\n\r\n" if ($opt_display);
    registra_para_relatorio($Agente,"","","","Logout","","","","");
  }
}

#pausa_agente(ramal,pausa);
sub pausa_agente(@) {
  my $Agente = $_[0];
  my $Pausa  = $_[1];
  my $Estado = $Id_Agente = $sql = $Retorno = "";
  my $TipoP = "";
  my @Aux = "";
  if ($Pausa) {
    $Estado = $Situacao_agente[2];
  } else {
    $Estado = $Situacao_agente[0];
  }
	@Aux = pesquisa_multipla( "SELECT * FROM vm50_agentes WHERE login='$Agente'" );
  print "1=$Aux[1] 2=$Aux[2] 3=$Aux[3] 4=$Aux[4] 5=$Aux[5] 6=$Aux[6] 7=$Aux[7] 8=$Aux[8] 9=$Aux[9] 10=$Aux[10] \n" if ($opt_debug2);
  grava_log2("1=$Aux[1] 2=$Aux[2] 3=$Aux[3] 4=$Aux[4] 5=$Aux[5] 6=$Aux[6] 7=$Aux[7] 8=$Aux[8] 9=$Aux[9] 10=$Aux[10] \n") if ($opt_debug);
  #if ($Aux[5] ne 'NLogado') {
  if (($Aux[5] ne 'NLogado') && ($Aux[5] ne 'Chamando')) {
  	$Id_Agente = $Aux[0];
    if (($Id_Agente gt 0) && ($Aux[12] ne 1)){
      $TipoP = $Aux[17] if ($Pausa);
      if (($Aux[5] eq 'Livre') || ($Aux[5] eq 'Em Pausa')) {
        $sql = "UPDATE vm50_agentes SET situacao='$Estado', fila='', pausa='$Pausa', ult_estad=CURRENT_TIMESTAMP WHERE id = '$Id_Agente'";
        if (!$Pausa) {
          #$sql = "UPDATE vm50_agentes SET situacao='$Estado', fila='', pausa='$Pausa', tipopausa='', ult_estad=CURRENT_TIMESTAMP WHERE id = '$Id_Agente'";
          $sql = "UPDATE vm50_agentes SET situacao='$Estado', fila='', pausa='$Pausa', ult_estad=CURRENT_TIMESTAMP WHERE id = '$Id_Agente'";
        }
      } else {
        $sql = "UPDATE vm50_agentes SET pausa='$Pausa' WHERE id = '$Id_Agente'";
        if (!$Pausa) {
          #$sql = "UPDATE vm50_agentes SET pausa='$Pausa', tipopausa='' WHERE id = '$Id_Agente'";
          $sql = "UPDATE vm50_agentes SET pausa='$Pausa' WHERE id = '$Id_Agente'";
        }
      }
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      if (($Aux[5] eq 'Livre') || ($Aux[5] eq 'Em Pausa')) {
        registra_para_relatorio($Agente,$TipoP,"","",$Estado,"","","","");
      }
    }
  }
}

#nova_ligacao(id_ligacao, numero, canal, transferiu);
sub nova_ligacao(@) {
  my $Id_Ligacao = $_[0];
  my $Numero     = $_[1];
  my $Canal      = $_[2];
  my $Transferiu = $_[3];
  my $Conve      = "0";
  my @Aux = "";
  my $Fila = $AuxI = $sql = $Retorno = $Canal2 = $Obs = $Transferencia = "";
  $Transferiu = "0" if ($Transferiu ne "1");
  if (($Numero eq "<unknown>") || (substr($Numero,0,3) eq "SIP")) {
    $Numero = "";
  } elsif (substr($Numero,0,5) eq "Agent") {
    @Aux = split(/\//, $Numero);
	  $Numero = pesquisa( "SELECT ramal FROM vm50_agentes WHERE login='$Aux[1]'" );
	  $Numero = "" if ($Numero eq "E");
  }
  #Transferencia de ligacao externa
  if (substr($Canal,0,9) eq "AsyncGoto") {
    $Canal  = substr($Canal,10);
    $Numero = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE canal='$Canal' ORDER BY id DESC LIMIT 1" );
    $Obs    = "Fazendo chamada externa";
    $Conve  = "1";
  } elsif (substr($Canal,0,10) eq "Transfered") {
    $Canal2 = substr($Canal,11);
    $Obs = pesquisa( "SELECT obs FROM vm50_ligacao_id WHERE canal='$Canal2' ORDER BY id DESC LIMIT 1" );
    if ($Obs eq "FILA") {
      $AuxI = pesquisa( "SELECT id FROM vm50_ligacao_id WHERE canal='$Canal2' ORDER BY id DESC LIMIT 1" );
      $Transferencia = pesquisa("SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig='$AuxI' AND numero_dest>'' AND estado!='Desligado'") if (($AuxI ne "E") && ($AuxI ne ""));
    }
  } else {
    @Aux = pesquisa_multipla( "SELECT * FROM vm50_ligacao_id WHERE canal='$Canal' ORDER BY id DESC LIMIT 1" );
    if (($Canal eq "E") || ($Canal eq "")) {
      $Numero = $Aux[1];
      $Obs    = $Aux[3];
      $Conve  = $Aux[4];
      print "SELECT * FROM vm50_ligacao_id WHERE canal='$Canal' ORDER BY id DESC LIMIT 1 => $Numero $Obs $Conve \n" if ($opt_debug2);
      grava_log2("SELECT * FROM vm50_ligacao_id WHERE canal='$Canal' ORDER BY id DESC LIMIT 1 => $Numero $Obs $Conve \n") if ($opt_debug);
      if ($Obs eq "FILA") {
        $Fila = pesquisa( "SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig='$Aux[0]'" );
        $Obs   = $Obs."#-#".$Fila
      }
    }
  }
  if (testa_fabricante_placa($Canal) gt -1) {
    $sql = "UPDATE vm50_troncos SET situacao='O', numeroexterno='$Numero', id_externo='$Id_Ligacao' WHERE numero_asterisk = '$Canal' AND (situacao='L' OR situacao='O' OR situacao='R')";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  } else {
    my $Numvdt = testa_fabricante_placa_ip($Canal);
    if ($Numvdt gt 0) {
      $sql = "UPDATE vm50_troncos SET situacao='O', numeroexterno='$Numero', id_externo='$Id_Ligacao' WHERE numero_vdt = '$Numvdt' AND (situacao='L' OR situacao='O' OR situacao='R')";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    }
  }
# >>> Para corrigir o entroncamento IP
#  $Numero = '' if ((eh_ramal($Numero) eq 0) || (eh_numerico($Numero) eq 0));
# <<< Para corrigir o entroncamento IP
  $sql = "INSERT INTO vm50_ligacao_id (id, numero, canal, obs, conversou, falso, transfere, transferiu) VALUES ('$Id_Ligacao', '$Numero', '$Canal', '$Obs', '$Conve', '0', '$Transferencia', '$Transferiu')";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
# >>> Cria o estado chamando ramal
  muda_estado_ramal($Numero,$Canal,$Id_Ligacao,"C","algu","X") if (eh_ramal($Numero) eq 1);
# <<< Cria o estado chamando ramal
  registra_para_relatorio("","",$Id_Ligacao,$Numero,"Entrada","","","",$Canal);
}

#atualiza_ligacao(id_ligacao, numero, canal, obs);
sub atualiza_ligacao(@) {
  my $Id_Ligacao = $_[0];
  my $Numero     = $_[1];
  my $Canal      = $_[2];
  my $Obs        = $_[3];
  my $ANumero = $UNumero = $ACanal = $ACanal2 = $AObs = $sql = "";
  my @Aux = "";
  @Aux        = pesquisa_multipla("SELECT * FROM vm50_ligacao_id WHERE id = '$Id_Ligacao' ");
  $ANumero    = $Aux[1]; 
  $ACanal     = $Aux[2];
  $AObs       = $Aux[3];
  print "SELECT * FROM vm50_ligacao_id WHERE id = '$Id_Ligacao' -> $ANumero $ACanal $AObs \n" if ($opt_debug2);
  grava_log2("SELECT * FROM vm50_ligacao_id WHERE id = '$Id_Ligacao' -> $ANumero $ACanal $AObs  \n") if ($opt_debug);
  ###>>> Resolver problema de troncos IP que comecam com SIP
  my $NovoNum = 'SIP/'.$ANumero;
  $NovoNum = $ANumero;
  if (substr($ACanal,0,4) eq 'SIP/') {
    my @NumeroA = split(/-/, $ACanal);
    my $Total = @NumeroA;
    $ACanal2 = "";
    for (my $x=0; $x < $Total - 1; $x++) {
      $ACanal2 = $ACanal2."-" if ($x gt 0);
      $ACanal2 = $ACanal2.$NumeroA[$x];
    }
    #<<< Corrigi o problema de canais SIP com sinal de menos no meio do nome
  } else {
    $ACanal2 = $ACanal;
  }
  my $ExisNum = pesquisa("SELECT id FROM vm50_troncos WHERE canal_asterisk='$ACanal2' OR numero_asterisk='$NovoNum' LIMIT 1");
  $ANumero = "E" if (($ExisNum ne "") && ($ExisNum ne "E"));
  ###<<< Resolver problema de troncos IP que comecam com SIP
  ###Resolver o problema do reject
  $ANumero = substr($Canal,6,4) if (substr($Canal,0,5) eq "Agent");
  ###
  $UNumero = $Numero;
  ###>>> SIP estranhos
if (0==1) {
  if ($ANumero =~ /^[+-]?\d+$/ ) {
    ### ANumero eh numerico
    $ANumero = $ANumero;
  } else {
    ### ANumero nao eh numerico
    $ANumero = $Numero;
  }
}
  ###<<< SIP estranhos
  $Numero  = $ANumero if (($ANumero ne "") && ($ANumero ne "E"));
  $Canal   = $ACanal  if (($ACanal ne "") && ($ACanal  ne "E"));
  $Obs     = $AObs    if (($Obs eq "NULL")    || ($Obs eq "") && (($AObs ne "") && ($AObs ne "E")));
  ###>> Resolver o problema do BINA no tronco chamando
  #$Numero  = ''       if ((eh_ramal($Numero) eq 0) || (eh_numerico($Numero) eq 0));
  ###<<
  $sql = "UPDATE vm50_ligacao_id SET numero = '$Numero', canal = '$Canal', obs = '$Obs' WHERE id = '$Id_Ligacao' ";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
  $sql = "UPDATE vm50_link_ligacao SET numero_orig = '$Numero' WHERE id_orig = '$Id_Ligacao' ";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
  $sql = "UPDATE vm50_link_ligacao SET numero_dest = '$Numero' WHERE id_dest = '$Id_Ligacao' ";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
# >>> Resolver o problema de numeros em entroncamentos IP
  $sql = "UPDATE vm50_troncos SET numeroexterno = '$Numero' WHERE id_externo = '$Id_Ligacao' ";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
  $sql = "UPDATE vm50_troncos SET numerointerno = '$Numero' WHERE id_interno = '$Id_Ligacao' ";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
# <<< Resolver o problema de numeros em entroncamentos IP
  print ">>>numeros $Numero $UNumero \n" if ($opt_debug2);
  grava_log2(">>>numeros $Numero $UNumero \n") if ($opt_debug);
  #>>> Corrige problema de DDR quando chamada nao mostrar o bina
  $UNumero = "NULL" if ($Numero eq $UNumero);
  #$UNumero = "NULL" if (($Numero eq $UNumero) || (eh_ramal($Numero) eq 1));
  #<<< Corrige problema de DDR quando chamada nao mostrar o bina
  amarra_ligacoes($Id_Ligacao, $Numero, "NULL", $UNumero, "NULL", "NULL", "NULL");
}

#amarra_ligacoes(id_origem, num_origem, id_destino, num_destino, pa, estado, obs);
sub amarra_ligacoes(@) {
  print "\n>>> amarra_ligacoes -> 0=$_[0] 1=$_[1] 2=$_[2] 3=$_[3] 4=$_[4] 5=$_[5] 6=$_[6] \n" if ($opt_debug2);
  grava_log2("\n>>> amarra_ligacoes -> 0=$_[0] 1=$_[1] 2=$_[2] 3=$_[3] 4=$_[4] 5=$_[5] 6=$_[6] \n") if ($opt_debug);
  my $Id_or = $_[0];
  my $Nu_or = $_[1];
  my $Id_de = $_[2];
  my $Nu_de = $_[3];
  my $Pa    = $_[4];
  my $Estad = $_[5];
  my $Obs   = $_[6];
  my $Tipo  = "I";
  my $Tempo = time;
  my $ANu_or = $AId_de = $ANu_de = $APa = $AEstad = $ATipo = $AObs = $VObs = $VemOrbita = "";
  my $ObsR = $Aux = $AuxI = $AuxId2 = $PaO = $Taux = $Taux = $Erro = $sql = $Transb = $NumTr = $Direcao = "";
  my $Gravacao = "";
  my @AuxO = @Ax_li = @Ax_lk = @AuxO1 = @AOb2 = @AuxPa1 = @AuxPa2 = "";
  my $Conve  = "0";
  my $Canal  = "";
  my $Pesqui = $Retorno = "";
  my $Exis   = "E";  #Indica se eh novo link ou nao
  #>>> resolve o problema do atendimento da fila sem agentes soh ramal
  $VObs = pesquisa("SELECT obs FROM vm50_ligacao_id WHERE id = '$Id_or'");
  $VObs = pesquisa("SELECT obs FROM vm50_ligacao_id WHERE id = '$Id_de'") if (($VObs ne "FILA") && ($Id_de ne "NULL") && ($Id_de ne "") && ($Id_de ne "E"));
  #<<< resolve o problema do atendimento da fila sem agentes soh ramal
  #>>> Atendimento com mensagem tem que zerar o contador
  $sql = "UPDATE vm50_link_ligacao SET mensagem = '0', diahora=CURRENT_TIMESTAMP WHERE id_orig = '$Id_or' AND mensagem = '1'" if (($Id_or ne "") && ($Id_or ne "NULL"));
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
  #<<< Atendimento com mensagem tem que zerar o contador

  #Verifica se o id_orig eh de origem ou nao
  $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
  $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE id_dest = '$Id_de' AND id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
  $Erro   = pesquisa($Pesqui) if ($Pesqui ne "");
  return if (($Erro eq "E") && ($Estad eq "Desligado"));
  if ($Erro eq "E") {
    $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
    $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE id_dest = '$Id_de' AND id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
    $Erro   = pesquisa($Pesqui) if ($Pesqui ne "");
    if ($Erro ne "E") {
      $sql = "UPDATE vm50_link_ligacao SET estado = 'Chamando' WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
      $sql = "UPDATE vm50_link_ligacao SET estado = 'Chamando' WHERE id_dest = '$Id_de' AND id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      $Erro   = "E";
      $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
      $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE id_dest = '$Id_de' AND id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
      $Erro   = pesquisa($Pesqui) if ($Pesqui ne "");
    }
  }
  if ($Erro eq "E") {
    #Se nao for id_orig verifica se eh destino e realiza a troca origem <--> destino
#    $Erro = pesquisa( "SELECT id_orig FROM vm50_link_ligacao WHERE id_dest = '$Id_or' AND estado!='Desligado'" );
    $Erro   = "E";
    $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE id_dest = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
    $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE id_orig = '$Id_de' AND id_dest = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
    $Erro   = pesquisa($Pesqui) if ($Pesqui ne "");
    if ($Erro ne "E") {
      $Id_or="" if (!(defined($Id_or)));
      $Id_de = $Id_or;
      $Id_or = $Erro;
      $Erro  = $Nu_or;
      $Nu_or = $Nu_de;
      $Nu_de = $Erro;
    } else {
      #Se soh tiver o id_dest, pode ser que o destino seja a origem, neste caso faca a troca origem <--> destino
#      $Erro = pesquisa( "SELECT id_orig FROM vm50_link_ligacao WHERE id_orig = '$Id_de' AND estado!='Desligado'" );
      $Erro   = "E";
      $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE id_orig = '$Id_de' AND estado!='Desligado'" if (($Id_de ne "") && ($Id_de ne "NULL") && (($Id_or eq "") || ($Id_or eq "NULL")));
      $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE id_orig = '$Id_de' AND id_dest = '$Id_or' AND estado!='Desligado'" if (($Id_de ne "") && ($Id_de ne "NULL") && (($Id_or ne "") && ($Id_or ne "NULL")) && ($VObs ne "FILA") );
      $Erro   = pesquisa($Pesqui) if ($Pesqui ne "");
      if ($Erro ne "E") {
        $Id_de = $Id_or;
        $Id_or = $Erro;
        $Erro  = $Nu_or;
        $Nu_or = $Nu_de;
        $Nu_de = $Erro;
      }
    }
    #Se soh id_dest entao descobre o id_origem
  }
  return if ($Id_or eq "E");
  #Encontrei o id_or, entao leia os dados de origem (numero, observacao e existencia) caso null
  if ($Id_or ne "NULL") {
    @Ax_li = pesquisa_multipla("SELECT * FROM vm50_ligacao_id WHERE id = '$Id_or'" );
    $Nu_or = $Ax_li[1] if ($Nu_or eq "NULL");
    $Ax_li[3] = "" unless defined $Ax_li[3];
    @AuxO  = split(/#-#/,$Ax_li[3]);
    $AuxO[1] = "" unless defined $AuxO[1];
    if ($AuxO[1] gt "!") {
      $Nu_de = $AuxO[1];
      grava_log2(">>>0 Num_de-$Nu_de-  Ax_li[3]-$Ax_li[3]- \n") if ($opt_debug);
      $Ax_li[3] = "Transfer&ecirc;ncia-".$AuxO[0];
      $Estad  = "Em conversa&ccedil;&atilde;o";
      $Tipo   = "I";
      $sql = "UPDATE vm50_ligacao_id SET obs = '$AuxO[0]' WHERE id = '$Id_or' ";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    }
    grava_log2(">>>0 Num_de-$Nu_de-  Ax_li[3]-$Ax_li[3]- \n") if ($opt_debug);
    $PaO   = $Ax_li[2];
    $Obs   = "" unless defined $Obs;
    $ObsR  = $Ax_li[3] if ($Obs eq "NULL");
    $ObsR  = "" if ($ObsR eq "E");
    $Pesqui = "SELECT obs FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
    $Pesqui = "SELECT obs FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND id_dest = '$Id_de' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
    $Aux   = pesquisa($Pesqui) if ($Pesqui ne "");
    $Obs   = $ObsR if ((substr($Aux,0,19) eq "Transfer&ecirc;ncia") && ($Obs eq "NULL"));
    $Obs   = $ObsR if ($Obs eq "NULL");
    $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
    $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND id_dest = '$Id_de' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
    $Aux   = pesquisa($Pesqui) if (($Pesqui ne "") && ($Exis eq "E"));
    $Conve = $Ax_li[4] if ($Conve eq "0");;
    $Conve = "" unless defined $Conve;
    $Conve = "0" if (($Conve eq "") || ($Conve eq "E"));
    if ((exists $Ax_li[6]) && (defined $Ax_li[6])) {
      $Gravacao = $Ax_li[6] if ($Ax_li[6] ne "");
    }
  }
  #Encontrei o id_de, entao leia os dados de destino (numero e observacao) caso null
  if ($Id_de ne "NULL") {
    @Ax_li = pesquisa_multipla("SELECT * FROM vm50_ligacao_id WHERE id = '$Id_de'" );
    my $Testecar = index($Ax_li[3], '#-#');
    if ($Testecar gt -1) {
      @AuxO1 = split(/#-#/,$Ax_li[3]);
    } else {
      @AuxO1 = ("","","","","");
    }
    $AuxO1[1] = "" unless defined $AuxO1[1];
    if ($AuxO1[1] gt "!") {
      $Nu_de = $AuxO1[1];
      grava_log2(">>>00 Num_de-$Nu_de-  Ax_li[3]-$Ax_li[3]- \n") if ($opt_debug);
      $Obs = "Transfer&ecirc;ncia-".$AuxO1[0];
      @AuxPa1 = split(/@/,$PaO);
      @AuxPa2 = split(/\//,$AuxPa1[0]);
      $Pa = $AuxPa2[1];
      $Tipo   = "I";
      $Estad  = "Chamando";
#      if ($Obs eq "Transfer&ecirc;ncia-DDR") {
      if (substr($Obs,0,20) eq "Transfer&ecirc;ncia-") {
        $sql = "UPDATE vm50_ligacao_id SET obs = '$Obs' WHERE id = '$Id_de' ";      
      } else {
        $sql = "UPDATE vm50_ligacao_id SET obs = '$AuxO1[0]' WHERE id = '$Id_de' ";
      }
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      $sql = "UPDATE vm50_ligacao_id SET obs = '$AuxO1[0]' WHERE id = '$Id_or' ";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    }
    if ($AuxO[1]) {
      $Pa = $Ax_li[1];
    }
    if ((exists $Ax_li[6]) && (defined $Ax_li[6])) {
      $Gravacao = $Ax_li[6] if (($Gravacao eq "") && ($Ax_li[6] ne ""));
    }
    grava_log2(">>>00 Num_de-$Nu_de-  Ax_li[3]-$Ax_li[3]- \n") if ($opt_debug);
    if ($Nu_de eq "NULL") {
      $Nu_dR = $Ax_li[1];
      $Pesqui = "SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
      $Pesqui = "SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND id_dest = '$Id_de' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
      $Aux   = pesquisa($Pesqui) if ($Pesqui ne "");
#      $Aux   = pesquisa( "SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'" );
      $Nu_de = $Nu_dR if ((($Nu_de eq "NULL") || ($Nu_de eq "") || ($Nu_de eq "E")) && (($Aux eq "") || ($Aux eq "E")));
    }
    $Obs   = $Ax_li[3] if ($Obs eq "NULL");
  }
  print ">>>1 Num_de-$Nu_de-  Obs-$Obs-  Conve-$Conve- Estad-$Estad- \n" if ($opt_debug2);
  grava_log2(">>>1 Num_de-$Nu_de-  Obs-$Obs-  Conve-$Conve- Estad-$Estad- \n") if ($opt_debug);
  #Carrega as outras informacoes caso null
  $Pesqui = "";
  if ($Obs eq "FILA") {
    $Pesqui = "SELECT * FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
  } else {
    $Pesqui = "SELECT * FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND id_dest = '$Id_de' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")));
  }
  @Ax_lk  = pesquisa_multipla($Pesqui) if ($Pesqui ne "");
  if ($Erro ne "E") {
    $Pa = "" unless defined $Pa;
    $Pa    = $Ax_lk[4] if ($Pa    eq "NULL");
    $Estad = $Ax_lk[5] if ($Estad eq "NULL");
    $Obs   = "" unless defined $Obs;
    $Obs   = $Ax_lk[7] if ($Obs   eq "NULL");
    $Gravacao = $Ax_li[6] if (($Gravacao eq "") && (exists $Ax_li[6]));
    $Nu_de = $Ax_lk[9] if (($Obs eq "FILA") && (($Nu_de eq "NULL") || ($Nu_de eq "E") || ($Nu_de eq "")));
  }
  ###>> Para tentar resolver o problema da transferencia
  if (($Nu_or eq $Nu_de) && ($Id_or ne "NULL") && ($Nu_or ne "NULL")) {
    ##$sql = "UPDATE vm50_ligacao_id SET falso='1' WHERE id='$Id_or'";
    $sql = "UPDATE vm50_ligacao_id SET falso='1' WHERE id='$Id_or' and numero='$Nu_or' AND transferiu='0'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    ##$sql = "UPDATE vm50_ligacao_id SET falso='1' WHERE id='$Id_de'";
    $sql = "UPDATE vm50_ligacao_id SET falso='1' WHERE id='$Id_de' and numero='$Nu_de' AND transferiu='0'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  }
  ###<< Para tentar resolver o problema da transferencia
  my $QualoNumeReal1 = "";
  my $QualoNumeReal2 = "";
  $QualoNumeReal1    = pesquisa("SELECT numero FROM vm50_ligacao_id WHERE id = '$Id_or'") if (($Id_or ne "") && ($Id_or ne "E") && ($Id_or ne "NULL"));
  $QualoNumeReal2    = pesquisa("SELECT numero FROM vm50_ligacao_id WHERE id = '$Id_de'") if (($Id_de ne "") && ($Id_de ne "E") && ($Id_de ne "NULL"));
  if (($QualoNumeReal1 eq "") || ($QualoNumeReal1 eq "E") || ($QualoNumeReal2 eq "") || ($QualoNumeReal2 eq "E") || ($QualoNumeReal1 eq $QualoNumeReal2)) {
    print ">>>1a Pode voltar QualoNumeReal1=$QualoNumeReal1.  QualoNumeReal2=$QualoNumeReal2. \n" if ($opt_debug2);
    grava_log2(">>>1a Pode voltar QualoNumeReal1=$QualoNumeReal1.  QualoNumeReal2=$QualoNumeReal2. \n") if ($opt_debug);
    return if (($Nu_or eq $Nu_de) && ($Nu_or ne "") && ($Nu_or ne "NULL"));
    return if ($Nu_de eq "E");
  }
  if (($QualoNumeReal1 ne $QualoNumeReal2) && ($Nu_or eq $Nu_de)){
    $Nu_or = $QualoNumeReal1;
    $Nu_de = $QualoNumeReal2;
    #$Obs   = "DDR";
  }
  #Soh prossiga se existir o num_ori e o destino e eles nao forem iguais
  #Se o num_de tiver mais de 4 digitos eh input senao output
  if (($Tipo eq "NULL") || ($Tipo eq "") || ($Tipo eq "E")) {
    $Tipo = "I" if ((eh_ramal($Nu_de) eq 1) && (eh_numerico($Nu_de) eq 1));
    $Tipo = "O" if ((eh_ramal($Nu_de) eq 0) || (eh_numerico($Nu_de) eq 0));
  }
  #Se origem e destino tiverem 4 digitos eh consulta
  if ((eh_ramal($Nu_or) eq 1) && (eh_numerico($Nu_or) eq 1) && (eh_ramal($Nu_de) eq 1) && (eh_numerico($Nu_de) eq 1) && ($Nu_or ne "NULL") && ($Nu_de ne "NULL") && ($Obs ne "FILA")) {
    $Obs = "Consulta";
    $Pa  = $Nu_de;
  #Se destino tiver 4 digitos, a principio, eh DDR
  } elsif ((eh_ramal($Nu_de) eq 1) && ($Nu_de ne "NULL") && (eh_numerico($Nu_de) eq 1)) {
    $Obs = $ObsR  if ((substr($Obs,0,19) eq "Transfer&ecirc;ncia") || (substr($ObsR,0,19) eq "Transfer&ecirc;ncia"));
    $Obs = "DDR"  if ((($Obs eq "") || ($Obs eq "E") || ($Obs eq "NULL")) && (substr($ObsR,0,19) ne "Transfer&ecirc;ncia"));
    $Aux = $Ax_lk[3];
    $Pa  = $Nu_de if (($Nu_or ne "NULL") && ($Nu_or ne "") && ($Nu_or ne "E"));
    $Pa  = $Aux   if (substr($Obs,0,19) eq "Transfer&ecirc;ncia");
  }
  print ">>>2 Num_de-$Nu_de- Obs-$Obs- Estad-$Estad- \n" if ($opt_debug2);
  grava_log2(">>>2 Num_de-$Nu_de- Obs-$Obs- Estad-$Estad- \n") if ($opt_debug);
  #Novo link
  if ($Erro eq "E") {
    #>>> Alterado para funcionar bina de ddr
    my $Aux_id = "E";
    if ($Id_de ne "") {
      $Aux_id = pesquisa("SELECT * FROM vm50_link_ligacao WHERE id_orig = '$Id_or' OR id_dest = '$Id_de'");
    } else {
      $Aux_id = pesquisa("SELECT * FROM vm50_link_ligacao WHERE id_orig = '$Id_or'");
    }
    $Erro = "" if ($Aux_id ne "E");
    #<<< Alterado para funcionar bina de ddr
    $Aux = $Ax_lk[0];
    if ((($Ax_lk ne "E") || ($Ax_lk gt 5)) && (substr($Obs,0,19) ne "Transfer&ecirc;ncia") && (($Obs eq "NULL") || ($Obs eq "") || ($Obs eq "Chamando"))) {
      $Exis = "";
    #>>> Alterado para funcionar fazendo chamada externa no cc
      #$Erro = "";
    #<<< Alterado para funcionar fazendo chamada externa no cc
      $Estad = "Chamando";
      grava_log2(">>>2a \n") if ($opt_debug);
    }
  }
  if ($Erro eq "E") {
    $Nu_or = "" if (($Nu_or eq "NULL") || ($Nu_or eq "E"));
    $Id_de = "" if (($Id_de eq "NULL") || ($Id_de eq "E"));
    $Nu_de = "" if (($Nu_de eq "NULL") || ($Nu_de eq "E"));
    $Pa    = "" if (($Pa    eq "NULL") || ($Pa    eq "E"));
    $Pa    = $Nu_de if (($Pa eq "") && (eh_ramal($Nu_de) eq 1));
    $Estad = "Chamando" if (($Estad eq "NULL") || ($Estad eq "E") || ($Estad eq ""));
    grava_log2(">>>2b  \n") if ($opt_debug);
    $Obs   = $AObs if (($Obs  eq "NULL") || ($Obs eq "E") || ($Obs eq ""));
    if (($Tipo eq "NULL") || ($Tipo eq "") || ($Tipo eq "E")) {
      $Tipo  = "I"   if ($Obs   eq "FILA" );
      $Tipo  = "O"   if (substr($Obs,0,7) eq "Externo");
      ### Tratando as saidas por enlace >>>
      $Tipo  = "I"   if (substr($Obs,0,7) eq "Interno");
      ### <<< Tratando as saidas por enlace
    }
    $sql   = "INSERT INTO vm50_link_ligacao (id_orig, numero_orig, id_dest, numero_dest, pa, estado, tipo, obs, diahora) VALUES ('$Id_or', '$Nu_or', '$Id_de', '$Nu_de', '$Pa', '$Estad', '$Tipo', '$Obs', CURRENT_TIMESTAMP)";
  } else {
    #Verifica se existe o id do origem e do destino no ligacao_id
    $ANu_or = $Ax_lk[1];
    $AId_de = $Ax_lk[2];
    $ANu_de = $Ax_lk[3];
    $AObs   = $Ax_lk[7];
    $APa    = $Ax_lk[4];
    $AEstad = $Ax_lk[5];
    $ATipo  = $Ax_lk[6];
    print ">>>3 Num_de-$Nu_de- ANum_de-$ANu_de- Obs-$Obs- AObs-$AObs-  \n" if ($opt_debug2);
    grava_log2(">>>3 Num_de-$Nu_de- ANum_de-$ANu_de- Obs-$Obs- AObs-$AObs- Estad-$Estad- AEstad-$AEstad-  \n") if ($opt_debug);
    #Se estava em conversacao e passou a chamar eh porque eh transferencia
    if (($ObsR ne "") && ($AEstad eq "Em conversa&ccedil;&atilde;o") && ($Estad eq "Chamando")) {
      $Obs = "Transfer&ecirc;ncia-$ObsR" if ((substr($Obs,0,19) ne "Transfer&ecirc;ncia"));
    }
    if (($ObsR ne "") && ($Conve eq "1") && ($Estad eq "Chamando")) {
      $Obs = "Transfer&ecirc;ncia-$ObsR" if ((substr($Obs,0,19) ne "Transfer&ecirc;ncia"));
    }
    $Obs = $AObs if ($AObs eq "Transfer&ecirc;ncia-$Obs");
    #Ligacao externa traz o numero na observacao
    if ($Obs eq "FILA") {
      if ((eh_ramal($Nu_de) eq 1) && (eh_numerico($Nu_de) eq 1) && ((eh_ramal($ANu_de) eq 0) || (eh_numerico($Nu_de) eq 0))) {
        $Nu_de  = $ANu_de if ($ANu_de ne "");
      }
    }
    if ((substr($AObs,0,7) eq "Externo") && ($Id_de ne "NULL")) {
      @AOb2  = split(/-/,$AObs);
      $Obs   = "Fazendo chamada externa";
      $Nu_de = $AOb2[1];
      $Pa    = $Nu_or;
      $sql   = "UPDATE vm50_ligacao_id SET numero='$Nu_de', obs='$Obs' WHERE id='$Id_de' ";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      $Canal = pesquisa( "SELECT canal FROM vm50_ligacao_id WHERE id='$Id_de' " );
      $Canal = "" if ($Canal eq "E");
      registra_para_relatorio("","Externa",$Id_de,$Nu_de,$Obs,"","","",$Canal);
    }
# >>> Resolvendo o problema de entroncamento IP
    my $PlacaExt = pesquisa( "SELECT numeroexterno FROM vm50_troncos WHERE id_externo='$Id_de' " );
    if (($PlacaExt ne "NULL") && ($PlacaExt ne "") && ($PlacaExt ne "E")) {
      $Obs   = "Fazendo chamada externa";
      $Pa    = $Nu_or;
      $sql   = "UPDATE vm50_ligacao_id SET numero='$PlacaExt', obs='$Obs' WHERE id='$Id_de' ";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    }
# <<< Resolvendo o problema de entroncamento IP
    ### Resolvendo transferencias entre filas >>>
    if (($Obs eq "FILA") && ($Conve eq "1") && ($Estad eq "Chamando")) {
#      $AObs = $Obs = "Transfer&ecirc;ncia-FILA";
      $Obs = "Transfer&ecirc;ncia-FILA";
      $sql   = "UPDATE vm50_ligacao_id SET obs='Transfer&ecirc;ncia-FILA' WHERE id='$Id_or' ";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    }
    ### <<< Resolvendo transferencias entre filas
    ### Tratando as saidas por enlace >>>
#    if (substr($AObs,0,7) eq "Interno") {
#      $Obs   = "Consulta";
#      registra_para_relatorio("","Consulta",$Id_de,$Nu_de,$Obs,"","","");
#    }
    if (substr($AObs,0,7) eq "Interno") {
      @AOb2  = split(/-/,$AObs);
      $Obs   = "Consulta";
      $Nu_de = $AOb2[1];
      $Pa    = $Nu_de;
      $sql   = "UPDATE vm50_ligacao_id SET numero='$Nu_de', obs='$Obs' WHERE id='$Id_de' ";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      $Canal = pesquisa( "SELECT canal FROM vm50_ligacao_id WHERE id='$Id_de' " );
      $Canal = "" if ($Canal eq "E");
      registra_para_relatorio("","Consulta",$Id_de,$Nu_de,$Obs,"","","",$Canal);
    }
    ### <<< Tratando as saidas por enlace
    ### >>> Resolver DDR entre SIPs
    if (($Nu_de eq "E") || ($Nu_de eq "NULL") || ($Nu_de eq "")) {
      my $D_canal = pesquisa("SELECT canal_no FROM vm50_ligacao_id WHERE id = '$Id_de'");
      if (substr($D_canal,0,3) eq "SIP") {
        my @D_Aux = split(/-/, $D_canal);
        my $D_Sip = $D_Aux[0];
        my $D_ramal = pesquisa("SELECT ramal FROM vm50_ramais WHERE numeroaster = '$D_Sip'");
        $Nu_de = $D_ramal if (($D_ramal eq "E") || ($D_ramal eq "NULL") || ($D_ramal eq ""));
      }
    }
    ### <<< Resolver DDR entre SIPs
    ### Tratando os recebimentos por enlace >>>
    $Obs   = "Consulta" if ($Nu_or eq "enlace");
    ### <<< Tratando os recebimentos por enlace
    #Arruma as variaveis do link atual e do que entra
    $ANu_or = "" if ($ANu_or eq "E");
    $AId_de = "" if ($AId_de eq "E");
    $ANu_de = "" if ($ANu_de eq "E");
    $APa    = "" if ($APa    eq "E");
    $AEstad = "" if ($AEstad eq "E");
    $ATipo  = "" if ($ATipo  eq "E");
    $AObs   = "" if ($AObs   eq "E");
    $Nu_or  = "" if ($Nu_or  eq "E");
    $Id_de  = "" if ($Id_de  eq "E");
    $Nu_de  = "" if (($Nu_de eq "E") || ($Nu_de eq "NULL"));
    $Pa     = "" unless defined $Pa;
    $Pa     = "" if ($Pa     eq "E");
    $Estad  = "" if ($Estad  eq "E");
    $Tipo   = "" if ($Tipo   eq "E");
    $Obs    = "" if ($Obs    eq "E");
    print ">>>4 Num_de-$Nu_de- ANum_de-$ANu_de- Obs-$Obs- AObs-$AObs- Estad-$Estad- AEstad-$AEstad- \n" if ($opt_debug2);
    grava_log2(">>>4 Num_de-$Nu_de- ANum_de-$ANu_de- Obs-$Obs- AObs-$AObs- Estad-$Estad- AEstad-$AEstad- \n") if ($opt_debug);
    #>>>Corrige problemas do entroncamento SIP que nao mostra o numero de entrada
    my $Testa_numerosip = pesquisa("SELECT numero_asterisk FROM vm50_troncos WHERE numero_asterisk = '$ANu_de'");
    $ANu_de =  "" if (($Testa_numerosip ne "E") && ($Testa_numerosip ne ""));
    #<<<Corrige problemas do entroncamento SIP que nao mostra o numero de entrada
    #Decide que variavel serah gravada
    $Nu_or  = $ANu_or if (($Nu_or eq "NULL") || ($Nu_or eq ""));
    $Id_de  = $AId_de if (($Id_de eq "NULL") || ($Id_de eq ""));
    $Nu_de  = $ANu_de if (($Nu_de eq "NULL") || ($Nu_de eq ""));
    ### DDR nao atendido, caiu na fila
    if (!(($Obs eq "FILA") && ($Ax_li[3] eq "DDR"))) {
      $Nu_de  = $ANu_de if (($ANu_de ne "")    && ($APa ne ""));
    }
    ###
    $Nu_de  = $ANu_de if ($AObs eq "Transfer&ecirc;ncia-FILA");
    $Pa     = "" unless defined $Pa;
    $Pa     = $APa    if (($Pa    eq "NULL") || ($Pa    eq ""));
    $Pa     = $Nu_de  if ((substr($Obs,0,19) eq "Transfer&ecirc;ncia") && (eh_ramal($Nu_de) eq 1) && (eh_numerico($Nu_de) eq 1));
    $Pa     = $Nu_or  if (($Tipo  eq "O") && (eh_ramal($Nu_or) eq 1) && (eh_numerico($Nu_or) eq 1));
    $Estad  = $AEstad if ($Estad  eq "NULL");
    $Tipo   = $ATipo  if (($Tipo  eq "") && ($ATipo ne ""));
    $Obs    = $AObs   if (($Obs   eq "NULL") || ($Obs eq ""));
    $Obs    = $AObs   if ((substr($AObs,0,19) eq "Transfer&ecirc;ncia") && ($Obs eq "DDR"));
    $Obs    = "FILA"  if (($Obs   eq "DDR") && ($AObs eq "FILA"));
    $Tipo   = "I"     if ($Obs    eq "FILA");
    $Tipo   = "O"     if ($Obs    eq "Fazendo chamada externa");
#    $Obs    = pesquisa( "SELECT obs FROM vm50_ligacao_id WHERE id = '$Id_or'" ) if ((substr($AObs,0,19) eq "Transfer&ecirc;ncia") && ($Estad ne "Chamando") && ($AObs ne "Transfer&ecirc;ncia-DDR"));
    $Obs    = "DDR"   if (($Obs   eq "") || ($Obs eq "E") || ($Obs eq "NULL"));
    #Transferencia de DDR
    if (($Obs eq "DDR") && ((eh_ramal($Nu_de) eq 0) || (eh_numerico($Nu_de) eq 0))&& (eh_ramal($Nu_or) eq 1) && (eh_numerico($Nu_or) eq 1)) {
       print ">>>Caiu na transferencia-DDR -> PA: $Pa -> Num_de: $Nu_de -> Num_or: $Nu_or -> Id_orig: $Id_or -> Id_dest: $Id_de\n" if ($opt_debug2);  
       grava_log2(">>>Caiu na transfenrencia-DDR -> PA: $Pa -> Num_de: $Nu_de -> Num_or: $Nu_or -> Id_orig: $Id_or -> Id_dest: $Id_de\n") if ($opt_debug);  
       #Trata o erro de quando é captura e não transferencia  
       my $StatusAtual = pesquisa("SELECT situacao FROM vm50_agentes WHERE ramal = '$Nu_or'");  
       print ">>>StatusAtual: $StatusAtual\n" if ($opt_debug2);  
       grava_log2(">>>StatusAtual: $StatusAtual\n") if ($opt_debug);  
       if($StatusAtual ne "Em conversa&ccedil;&atilde;o"){  
         #Eh DDR mas estah invertido o destino com a origem  
         $Taux = $Id_or;  
         $Id_or   = $Id_de;  
         $Id_de   = $Taux;  
         $Taux    = $Nu_or;  
         $Nu_or   = $Nu_de;  
         $Nu_de   = $Taux;  
         $Pa      = $Nu_de;  
         $Obs     = "Transfer&ecirc;ncia-DDR";  
         $Estad   = "Chamando" if (($Estad eq $AEstad) && ($Estad eq ""));
       } else {  
         #Eh captura, mas está com o origem e destino invertidos. Corrige os dados de captura para tratar corretamente  
         $Obs = "FILA";  
         $Estad = "Em conversa&ccedil;&atilde;o";  
         my $ANu_de = $Nu_or if(eh_ramal($Nu_or) ne 'E');  
         $Nu_or = $Nu_de if(eh_ramal($Nu_or) ne 'E');  
         $Nu_de = $ANu_de if(eh_ramal($Nu_or) ne 'E');  
         $Pa = $Nu_de;  
         grava_log2(">>>Obs: $Obs\n") if ($opt_debug);  
         grava_log2(">>>Estad: $Estad\n") if ($opt_debug);  
         grava_log2(">>>Nu_or: $Nu_or\n") if ($opt_debug);  
         grava_log2(">>>Nu_de: $Nu_de\n") if ($opt_debug);  
         grava_log2(">>>PA: $Pa\n") if ($opt_debug);  
         #return;  
       }
    }
    if ($Obs eq "Transfer&ecirc;ncia-E") {
       $Estad  = "Desligado";
       $Obs    = "FILA";
    }
    #Se estiver desligando
    if ($Estad eq "Desligado") {
       $Nu_or  = $ANu_or;
       $Id_de  = $AId_de;
       $Nu_de  = $ANu_de;
       $Pa     = $APa;
       $Tipo   = $ATipo;
       $Obs    = $AObs;
       $Situacao_desl = "";
       $Situacao_desl = "Completado"  if ($AEstad eq "Em conversa&ccedil;&atilde;o");
       $Situacao_desl = "Desistencia" if ($AEstad eq "Chamando");
       $Fila = "";
       $Fila = $Nu_de if ($Obs eq "FILA");
    }
    $Conve = "1" if ($Estad eq "Em conversa&ccedil;&atilde;o");
    #>>> Numero destino nao pode ser numero quando fila de agentes recebe ligacao na fila
    my $FObs = pesquisa("SELECT obs FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'");
    my $FNde = pesquisa("SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'");
    my $FAge = "E";
    $FAge = pesquisa("SELECT login FROM vm50_agentes WHERE ramal = '$Pa' AND situacao!='NLogado'") if (($Pa ne "") && ($Pa ne "E"));
    $Nu_de = $FNde if (($FAge ne "E") && ($FAge ne "") && ($FObs eq "FILA"));
    #<<< Numero destino nao pode ser numero quando fila de agentes recebe ligacao na fila
    print ">>>5 Num_de-$Nu_de- ANum_de-$ANu_de- Obs-$Obs- AObs-$AObs- Estad-$Estad- AEstad-$AEstad- \n" if ($opt_debug2);
    grava_log2(">>>5 Num_de-$Nu_de- ANum_de-$ANu_de- Obs-$Obs- AObs-$AObs- Estad-$Estad- AEstad-$AEstad- \n") if ($opt_debug);
    ### Transbordo gera problemas com transferencia >>>
    if (substr($Obs,0,19) eq "Transfer&ecirc;ncia") {
      if ( !(substr($Obs,20) eq "DDR") && !(substr($Obs,20) eq "FILA") && !(substr($Obs,20) eq "Consulta") && !(substr($Obs,20) eq "Fazendo chamada externa") ) {
        $sql2 = "UPDATE vm50_link_ligacao SET fila_original='substr($Obs,20)' WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
        $sql2 = "UPDATE vm50_link_ligacao SET fila_original='substr($Obs,20)' WHERE id_orig = '$Id_or' AND id_dest = '$Id_de' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
#        $sql2 = "UPDATE vm50_link_ligacao SET fila_original='substr($Obs,20)' WHERE id_orig = '$Id_or'";
        $Retorno = $dbh->do($sql2);
        print "$sql2 $Retorno\n" if ($opt_debug2);
        grava_log2("$sql2 $Retorno\n") if ($opt_debug);
      }
    }
    ### <<< Transbordo gera problemas com transferencia
    ### Zerando o horario de ligacoes em transferencia >>>
    if (($Estad eq "Chamando") && (substr($Obs,0,19) eq "Transfer&ecirc;ncia") && (substr($AObs,0,19) ne "Transfer&ecirc;ncia")) {
      $sql = "UPDATE vm50_link_ligacao SET id_orig = '$Id_or', numero_orig = '$Nu_or', id_dest = '$Id_de', numero_dest = '$Nu_de', pa = '$Pa', tipo = '$Tipo', estado = '$Estad', obs = '$Obs', diahora = CURRENT_TIMESTAMP WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
      $sql = "UPDATE vm50_link_ligacao SET id_orig = '$Id_or', numero_orig = '$Nu_or', id_dest = '$Id_de', numero_dest = '$Nu_de', pa = '$Pa', tipo = '$Tipo', estado = '$Estad', obs = '$Obs', diahora = CURRENT_TIMESTAMP WHERE id_orig = '$Id_or' AND id_dest = '$Id_de' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
#      $sql = "UPDATE vm50_link_ligacao SET id_orig = '$Id_or', numero_orig = '$Nu_or', id_dest = '$Id_de', numero_dest = '$Nu_de', pa = '$Pa', tipo = '$Tipo', estado = '$Estad', obs = '$Obs', diahora = CURRENT_TIMESTAMP WHERE id_orig = '$Id_or'";
    } else {
    ### <<< Zerando o horario de ligacoes em transferencia
    ### Transbordo, marcar a fila original >>>
      $Pesqui = "SELECT fila_original FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
      $Pesqui = "SELECT fila_original FROM vm50_link_ligacao WHERE id_dest = '$Id_de' AND id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
      $Transb   = pesquisa($Pesqui) if ($Pesqui ne "");
#      $Transb   = pesquisa( "SELECT fila_original FROM vm50_link_ligacao WHERE id_orig = '$Id_or'" );
      $Gravacao = "" unless defined $Gravacao;
      if (($Conve eq '0') && ($Obs eq 'FILA') && (($Transb eq 'E') || ($Transb lt '1'))) {
        my $EhAgente = pesquisa("SELECT login FROM vm50_agentes WHERE ramal = '$Pa' AND situacao!='NLogado'");
        return if (($Nu_de eq $Pa) && ($EhAgente ne "E") && ($EhAgente ne ""));
        $Pesqui = "SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
        $Pesqui = "SELECT numero_dest FROM vm50_link_ligacao WHERE id_dest = '$Id_de' AND id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
        $NumTr  = pesquisa($Pesqui) if ($Pesqui ne "");
        $sql = "";
        $sql = "UPDATE vm50_link_ligacao SET id_orig = '$Id_or', numero_orig = '$Nu_or', id_dest = '$Id_de', numero_dest = '$Nu_de', pa = '$Pa', tipo = '$Tipo', estado = '$Estad', obs = '$Obs', fila_original='$NumTr', gravacao='$Gravacao' WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")));
        $sql = "UPDATE vm50_link_ligacao SET id_orig = '$Id_or', numero_orig = '$Nu_or', id_dest = '$Id_de', numero_dest = '$Nu_de', pa = '$Pa', tipo = '$Tipo', estado = '$Estad', obs = '$Obs', fila_original='$NumTr', gravacao='$Gravacao' WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL"));
        $sql = "UPDATE vm50_link_ligacao SET id_orig = '$Id_or', numero_orig = '$Nu_or', id_dest = '$Id_de', numero_dest = '$Nu_de', pa = '$Pa', tipo = '$Tipo', estado = '$Estad', obs = '$Obs', fila_original='$NumTr', gravacao='$Gravacao' WHERE id_dest = '$Id_de' AND id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($VObs ne "FILA") );
      } else {
        if (!(($Estad eq $AEstad) && ($AEstad ne "") && ($AEstad ne "E") && ($AEstad ne "NULL") && ($Nu_or ne $ANu_or) && ($ANu_or ne "") && ($ANu_or ne "E") && ($ANu_or ne "NULL"))) {
          $AuxId2 = pesquisa("SELECT id_orig FROM vm50_link_ligacao WHERE id_orig = '$Id_or' AND estado!='Desligado'");
          $sql = "";
          #$sql = "UPDATE vm50_link_ligacao SET id_orig = '$Id_or', numero_orig = '$Nu_or', id_dest = '$Id_de', numero_dest = '$Nu_de', pa = '$Pa', tipo = '$Tipo', estado = '$Estad', obs = '$Obs', gravacao='$Gravacao' WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && ($AuxId2 eq "E") && (($Id_de eq "") || ($Id_de eq "NULL")));
          $sql = "UPDATE vm50_link_ligacao SET id_orig = '$Id_or', numero_orig = '$Nu_or', id_dest = '$Id_de', numero_dest = '$Nu_de', pa = '$Pa', tipo = '$Tipo', estado = '$Estad', obs = '$Obs', gravacao='$Gravacao' WHERE id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && ($AuxId2 ne "E"));
          $sql = "UPDATE vm50_link_ligacao SET id_orig = '$Id_or', numero_orig = '$Nu_or', id_dest = '$Id_de', numero_dest = '$Nu_de', pa = '$Pa', tipo = '$Tipo', estado = '$Estad', obs = '$Obs', gravacao='$Gravacao' WHERE id_dest = '$Id_de' AND id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($AuxId2 eq "E") && ($VObs ne "FILA") );
        }
      }
      if ($sql ne "") {
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
      }
    ### <<< Transbordo, marcar a fila original
    }
  }
  print ">>>7 Num_de-$Nu_de- ANum_de-$ANu_de- Obs-$Obs- AObs-$AObs- \n" if ($opt_debug2);
  grava_log2(">>>7 Num_de-$Nu_de- ANum_de-$ANu_de- Obs-$Obs- AObs-$AObs-  \n") if ($opt_debug);
  ### Tratando tranferencias entre filas >>>
  if ( !( ($Estad eq "Em conversa&ccedil;&atilde;o") && ( ($Nu_de eq "") || ($Nu_de eq "E") || ($Nu_or eq "") || ($Nu_or eq "E") ) ) ) {
    $Unico = "E";
    $Ramal = $Nu_or;
    $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE (numero_orig='$Ramal' OR numero_dest='$Ramal' OR pa='$Ramal') AND id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")) && ($Nu_or ne ""));
    $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE (numero_orig='$Ramal' OR numero_dest='$Ramal' OR pa='$Ramal') AND id_dest = '$Id_de' AND id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($Nu_or ne "") && ($VObs ne "FILA") );
    $Unico   = pesquisa($Pesqui) if ($Pesqui ne "");
#    $Unico = pesquisa("SELECT id_orig FROM vm50_link_ligacao WHERE (numero_orig='$Ramal' OR numero_dest='$Ramal' OR pa='$Ramal') AND (id_orig!='$Id_or' OR id_dest!='$Id_or') AND estado!='Desligado'") if ($Nu_or ne "");
    if (($Unico eq "E") || ($Unico eq "")) {
      $Ramal = $Nu_de;
      $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE (numero_orig='$Ramal' OR numero_dest='$Ramal' OR pa='$Ramal') AND id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de eq "") || ($Id_de eq "NULL")) && ($Nu_or ne ""));
      $Pesqui = "SELECT id_orig FROM vm50_link_ligacao WHERE (numero_orig='$Ramal' OR numero_dest='$Ramal' OR pa='$Ramal') AND id_dest = '$Id_de' AND id_orig = '$Id_or' AND estado!='Desligado'" if (($Id_or ne "") && ($Id_or ne "NULL") && (($Id_de ne "") && ($Id_de ne "NULL")) && ($Nu_de ne "") && ($VObs ne "FILA") );
      $Unico   = pesquisa($Pesqui) if ($Pesqui ne "");
#      $Unico = pesquisa("SELECT id_orig FROM vm50_link_ligacao WHERE (numero_orig='$Ramal' OR numero_dest='$Ramal' OR pa='$Ramal') AND (id_orig!='$Id_de' OR id_dest!='$Id_de') AND estado!='Desligado'") if ($Nu_de ne "");
      if (($Unico eq "E") || ($Unico eq "")) {
        $Ramal = $Pa;
#        $Unico = pesquisa("SELECT id_orig FROM vm50_link_ligacao WHERE (numero_orig='$Ramal' OR numero_dest='$Ramal' OR pa='$Ramal') AND (id_orig!='$Id_de' OR id_dest!='$Id_or') AND estado!='Desligado'") if ($Pa ne "");
      }
    }
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    $Canal = pesquisa( "SELECT canal FROM vm50_ligacao_id WHERE id='$Id_or' " );
    $Canal = "" if ($Canal eq "E");
    registra_para_relatorio("",$Obs,$Id_or,$Nu_de,$Estad,"","","",$Canal);
    #Altera a observacao da ligacao_id
    $sql = "";
    $sql = "UPDATE vm50_ligacao_id SET obs = '$Obs', conversou='$Conve' WHERE id = '$Id_or'" if (substr($Obs,0,19) ne "Transfer&ecirc;ncia");
    if ($sql ne "") {
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    }
    #>> Para gravar o tronco
    my $Destino = $Nu_de;
    if ($Obs eq "FILA") {
      $Destino = "Procurando PA";
      if (($Pa ne "E") && ($Pa ne "")) {
        $Destino = $Pa;
      }
    }
    my $Achei = "Nada";
    if ($Id_or ne "") {
      $Achei = pesquisa( "SELECT numero_asterisk FROM vm50_troncos WHERE id_externo='$Id_or' " );
      if (($Achei ne "E") && ($Achei ne "")) {
        $sql = "UPDATE vm50_troncos SET numeroexterno='$Nu_or', numerointerno='$Destino', id_interno='$Id_de', direcao='I' WHERE id_externo='$Id_or' AND direcao=''";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
      } else {
        $Achei = pesquisa( "SELECT numero_asterisk FROM vm50_troncos WHERE id_interno='$Id_or' " );
        if (($Achei ne "E") && ($Achei ne "")) {
          $VemOrbita = pesquisa( "SELECT situacao FROM vm50_troncos WHERE id_interno='$Id_or' " );
          if ($VemOrbita eq 'R') {
            $Direcao = 'I';
          } else {
            $Direcao = 'O';
          }
          $sql = "UPDATE vm50_troncos SET numeroexterno='$Destino', numerointerno='$Nu_or', id_externo='$Id_de', direcao='$Direcao' WHERE id_interno='$Id_or' AND direcao=''";
          $Retorno = $dbh->do($sql);
          print "$sql $Retorno\n" if ($opt_debug2);
          grava_log2("$sql $Retorno\n") if ($opt_debug);
        }
      }
    }
    if (($Id_de ne "") && ($Achei eq "Nada")) {
      $Achei = pesquisa( "SELECT numero_asterisk FROM vm50_troncos WHERE id_externo='$Id_de' " );
      if (($Achei ne "E") && ($Achei ne "")) {
        $VemOrbita = pesquisa( "SELECT situacao FROM vm50_troncos WHERE id_externo='$Id_de' " );
        if ($VemOrbita eq 'R') {
          $Direcao = 'I';
        } else {
          $Direcao = 'O';
        }
        $sql = "UPDATE vm50_troncos SET numeroexterno='$Destino', numerointerno='$Nu_or', id_interno='$Id_or', direcao='$Direcao' WHERE id_externo='$Id_de' AND direcao=''";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
      } else {
        $Achei = pesquisa( "SELECT numero_asterisk FROM vm50_troncos WHERE id_interno='$Id_de' " );
        if (($Achei ne "E") && ($Achei ne "")) {
          $sql = "UPDATE vm50_troncos SET numeroexterno='$Nu_or', numerointerno='$Destino', id_externo='$Id_or', direcao='I' WHERE id_interno='$Id_de' AND direcao=''";
          $Retorno = $dbh->do($sql);
          print "$sql $Retorno\n" if ($opt_debug2);
          grava_log2("$sql $Retorno\n") if ($opt_debug);
        }
      }
    }
    #<< Para gravar o tronco
   #registra_para_relatorio_pbx(ligacao_origem,numero_origem,canal_origem,ligacao_destino,numero_destino,canal_destino,oque);
    registra_para_relatorio_pbx($Id_or,$Nu_or,"NULL",$Id_de,$Nu_de,"NULL",$Estad);
  ### >>> Marca gravacoes
  if ($Estad eq "Em conversa&ccedil;&atilde;o") {
    $Gravacao = pesquisa( "SELECT gravacao FROM vm50_link_ligacao WHERE id_orig='$Id_or' AND  id_dest='$Id_de'" );
    if (($Gravacao ne "") && ($Gravacao ne "E")) {
      if ($Obs eq "Fazendo chamada externa") {
        marca_tabela_gravacao($Id_or, "Fazendo chamada externa");
      } elsif ($Obs eq "Transfer&ecirc;ncia-Fazendo chamada externa") {
        marca_tabela_gravacao($Id_or, "Transfer&ecirc;ncia-Fazendo chamada externa");
      } elsif ($Obs eq "DDR") {
        marca_tabela_gravacao($Id_or, "DDR");
      } elsif ($Obs eq "Transfer&ecirc;ncia-DDR") {
        marca_tabela_gravacao($Id_or, "Transfer&ecirc;ncia-DDR");
      } elsif ($Obs eq "Consulta") {
        marca_tabela_gravacao($Id_or, "Consulta");
      } elsif ($Obs eq "Transfer&ecirc;ncia-FILA") {
        marca_tabela_gravacao($Id_or, "Transfer&ecirc;ncia-FILA");
      } elsif ($Obs eq "FILA") {
        marca_tabela_gravacao($Id_or, "Fila");
      }
    }
  }
  ### <<< Marca gravacoes
   #>> marca no ramal com quem estah falando
   print ">>>8 Estado-$Estad- NOrig-$Nu_or- NDest-$Nu_de- \n" if ($opt_debug2);
   grava_log2(">>>8 Estado-$Estad- NOrig-$Nu_or- NDest-$Nu_de- \n") if ($opt_debug);
   if (($Nu_or ne "E") && ($Nu_or ne "") && ($Nu_de ne "E") && ($Nu_de ne "")) {
     #muda_estado_ramal(ramal, canal, id, situacao, falandocom, direcao)
     if (eh_ramal($Nu_or) eq 1) {
       print "vai mudar estado do ramal \n" if ($opt_debug2);
       grava_log2("vai mudar estado do ramal \n") if ($opt_debug);
       muda_estado_ramal($Nu_or, "", $Id_or, "O", $Nu_de, "O");
     }
     if (eh_ramal($Nu_de) eq 1) {
       print "vai mudar estado do ramal \n" if ($opt_debug2);
       grava_log2("vai mudar estado do ramal \n") if ($opt_debug);
       muda_estado_ramal($Nu_de, "", $Id_de, "O", $Nu_or, "I");
     }
   }
   #<< marca no ramal com quem estah falando
    #Para gravar transferencia no relatorio
    if (substr($Obs,0,19) eq "Transfer&ecirc;ncia") {
      $Transf = 1;
    } else {
      $Transf = 0;
    }
    #Arruma os dados para salvar nos agentes
    if (($Obs eq "FILA" ) || ($ObsR eq "FILA" ) || ($Obs eq "Transfer&ecirc;ncia-FILA" )) {
      $Obs = $Nu_de;
    }
    if ($Tipo eq "O") {
      $Obs = "Fazendo chamada externa";
    } elsif (substr($Obs,0,19) ne "Transfer&ecirc;ncia") {
      $Nu_de = $Pa if ($Pa ne "");
    }
    #>>> Alterado para funcionar bina de ddr
    #if (($Nu_de ne "") && ($Nu_or ne "") && ((eh_ramal($Nu_de) eq 1) || (eh_ramal($Nu_or) eq 1))) {
    if (($Nu_de ne "") && ($Nu_or ne "") && ($Obs ne "") && ((eh_ramal($Nu_de) eq 1) || (eh_ramal($Nu_or) eq 1))) {
    #<<< Alterado para funcionar bina de ddr
      if (!(($Estad eq $AEstad) && ($AEstad ne "") && ($AEstad ne "E") && ($AEstad ne "NULL") && ($Nu_or ne $ANu_or) && ($ANu_or ne "") && ($ANu_or ne "E") && ($ANu_or ne "NULL"))) {
      #>>> Quanto transfere para ramal com agente, nao sabe que eh agente
      my $Cana1 = pesquisa( "SELECT canal FROM vm50_ligacao_id WHERE id='$Id_or' " );
      my $Cana2 = pesquisa( "SELECT canal FROM vm50_ligacao_id WHERE id='$Id_de' " );
      #<<< Quanto transfere para ramal com agente, nao sabe que eh agente
      if ((eh_ramal($Nu_de) eq 1) && ($Cana2 ne "E")) {
        $ObsR = pesquisa( "SELECT transfere FROM vm50_ligacao_id WHERE id='$Id_or' " );
        $ObsR = $Obs if (($ObsR eq "E") || ($ObsR eq ""));
        altera_situacao_agente($Cana2, $Nu_or, $ObsR, $Estad, $Id_or, $Transf);
      }
      if ((eh_ramal($Nu_or) eq 1) && ($Cana1 ne "E")) {
        $ObsR = pesquisa( "SELECT transfere FROM vm50_ligacao_id WHERE id='$Id_de' " );
        $ObsR = $Obs if (($ObsR eq "E") || ($ObsR eq ""));
        altera_situacao_agente($Cana1, $Nu_de, $ObsR, $Estad, $Id_or, $Transf);
      }
      }
    } else {
      $AuxI = pesquisa( "SELECT situacao FROM vm50_agentes WHERE id_ligacao = '$Id_or'" );
      if (($AuxI eq "Chamando") && ($Estad eq "Procurando PA")) {
        $sql = "UPDATE vm50_agentes SET falandocom = '', fila = '', situacao = 'Livre', id_ligacao='', ult_estad=CURRENT_TIMESTAMP WHERE id_ligacao = '$Id_or'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
      }
      if (($Pa ne "") && ($APa ne "") && ($APa ne "Procurando PA") && ($Pa ne $APa)) {
        $sql = "UPDATE vm50_agentes SET falandocom = '', fila = '', situacao = 'Livre', id_ligacao='', ult_estad=CURRENT_TIMESTAMP WHERE ramal='$APa'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
      }
    }
  }
  ### <<< Tratando tranferencias entre filas
}


#altera_situacao_agente(canal, falandocom, fila, situacao, id_ligacao);
sub altera_situacao_agente(@) {
  my @A = ("NULL","NULL","NULL","NULL","NULL","0");
  $A[0] = $_[0] if (exists $_[0]);
  $A[1] = $_[1] if (exists $_[1]);
  $A[2] = $_[2] if (exists $_[2]);
  $A[3] = $_[3] if (exists $_[3]);
  if ((exists $_[4]) && (defined $_[4])) {
    $A[4] = $_[4] if ($_[4] ne "");
  }
  $A[5] = $_[5] if (exists $_[5]);
  print "\n>>> altera_situacao_agente -> 0=$A[0] 1=$A[1] 2=$A[2] 3=$A[3] 4=$A[4] 5=$A[5]\n" if ($opt_debug2);
  grava_log2("\n>>> altera_situacao_agente -> 0=$A[0] 1=$A[1] 2=$A[2] 3=$A[3] 4=$A[4] 5=$A[5]\n") if ($opt_debug);
  my $Canal  = $A[0];
  my $Agente = $Forca = $Erro = $TipoP = "";
  my $AuxR = $AuxG = $AuxI = $AuxS = $AuxF = "";
  my $Unico = $AuxFP = $sql = $Pausa = $Sitt = $id_ag = "";
  my $Id_des = $Esta = $Obs = $Ta_noar = "";
  my $AFala = $AFila = $ASitu = $AIdLi = $FilaO = "";
  my $Gravacao = $Pseudon = $Novo_nome = $RFez = $RRec = $FilaO = "";
  my $Ramal = $Retorno = "";
  my @AFez = @ARec = "";
  my @Aux1 = @Aux2 = @Aux3 = @Aux4 = "";
  my @Teste = @Arquivo = "";
  my $ComQuemFalo = $TemGravacao = $TemSituacao = $MeuRamal = $MinhaFila = "";
  if (substr($Canal,0,5) eq "Agent") {
    @Teste = split(/\//, $A[0]);
    $Agente = $Teste[1];
    $Ramal  = pesquisa( "SELECT ramal FROM vm50_agentes WHERE login='$Agente' and situacao!='NLogado'" );
    $Ramal  = $A[0] if (($Ramal eq "") || ($Ramal eq "E"));
  } else {
    $Ramal  = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE canal='$Canal' ORDER BY id DESC LIMIT 1" );
  }
  my $Falan = $A[1];
  my $Fila  = $A[2];
  $FilaO = $Fila;
  if (substr($Fila,0,19) eq "Transfer&ecirc;ncia") {
    $Obs   = $Fila;
    $Fila  = substr($Fila,20);
  }
  my $Id_li = $A[4];
  my $Situa = "";
  $Situa    = $A[3] if (($A[3] ne "") && ($A[3] ne "E") && ($A[3] ne "NULL"));
  $Situa    = pesquisa( "SELECT estado FROM vm50_link_ligacao WHERE id_orig='$Id_li' OR id_dest='$Id_li'" ) if (($Situa eq "") && ($Id_li ne "NULL") && ($Id_li ne "") && ($Id_li ne "E"));
  my $Trans = "";
  $Trans = $A[5];
  $Forca = $Id_li;
  $Erro  = "E";
  print ">>>1 agente:$Agente. ramal:$Ramal. id:$Id_li. situacao:$Situa.\n" if ($opt_debug2);
  grava_log2(">>>1 agente:$Agente. ramal:$Ramal. id:$Id_li. situacao:$Situa.\n") if ($opt_debug);
  #Descobre o Agente, Ramal e ID
  $AuxR = $Ramal;
  $AuxG = $Agente;
  $AuxI = $Id_li;
  $AuxR = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE id='$Id_li'" )    if (($AuxR eq "") || ($AuxR eq "NULL"));
  $AuxG = pesquisa( "SELECT login  FROM vm50_agentes    WHERE ramal='$AuxR' and situacao!='NLogado'" )  if (($AuxR ne "") && ($AuxR ne "E"));
  $AuxI = pesquisa( "SELECT id     FROM vm50_ligacao_id WHERE canal='$Canal' ORDER BY id DESC LIMIT 1" ) if (($AuxI eq "") || ($AuxI eq "NULL"));
  #>> Resolve o nao desligar
  $Id_li = $AuxI  if (($AuxI ne "") && ($AuxI ne "NULL") && ($AuxI ne "E"));
  #<< Resolve o nao desligar
  $AuxG = $AuxR if ($AuxR eq "E");
  if (($AuxG eq "E") || ($AuxG eq "")) {
    #>> Resolve o nao desligar
    #@Aux4 = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Id_li'" );
    @Aux4 = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Id_li' OR  id_dest='$Id_li'" );
    #<< Resolve o nao desligar
    $AuxR = $Aux4[4];
    $AuxR = "" unless defined $AuxR;
    grava_log2(">>>ops1  AuxR:$AuxR. \n") if ($opt_debug);
    $AuxR = "" unless defined $AuxR;
    $AuxR = $Aux4[3] if ((eh_ramal($AuxR) eq 0) && (eh_numerico($AuxR) eq 1));
    $AuxR = "" unless defined $AuxR;
    grava_log2(">>>ops2  AuxR:$AuxR. \n") if ($opt_debug);
    $AuxR = "" unless defined $AuxR;
    $AuxR = $Aux4[1] if ((eh_ramal($AuxR) eq 0) && (eh_numerico($AuxR) eq 1));
    $AuxR = "" unless defined $AuxR;
    grava_log2(">>>ops3  AuxR:$AuxR. \n") if ($opt_debug);
    $AuxG = pesquisa( "SELECT login FROM vm50_agentes WHERE ramal='$AuxR' and situacao!='NLogado'" ) if (($AuxR ne "E") || ($AuxR ne ""));
    if (($AuxG eq "E") || ($AuxG eq "")) {
      @Aux4 = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_dest='$Id_li'" );
      $AuxR = $Aux4[4];
      $AuxR = "" unless defined $AuxR;
      grava_log2(">>>ops4  AuxR:$AuxR. \n") if ($opt_debug);
      $AuxR = $Aux4[3] if ((eh_ramal($AuxR) eq 0) && (eh_numerico($AuxR) eq 1));
      $AuxR = "" unless defined $AuxR;
      grava_log2(">>>ops5  AuxR:$AuxR. \n") if ($opt_debug);
      $AuxR = $Aux4[1] if ((eh_ramal($AuxR) eq 0) && (eh_numerico($AuxR) eq 1));
      $AuxR = "" unless defined $AuxR;
      grava_log2(">>>ops6  AuxR:$AuxR. \n") if ($opt_debug);
      $AuxG = pesquisa( "SELECT login FROM vm50_agentes WHERE ramal='$AuxR' and situacao!='NLogado'" );
    }
  }
  $AuxR = "" unless defined $AuxR;
  if (($AuxR eq "E") || ($AuxR eq "")) {
    @Aux2 = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$AuxI' OR id_dest='$AuxI'" );
    $AuxR = $Aux2[4];
    $AuxR = "" unless defined $AuxR;
    $AuxR = $Aux2[3] if ((eh_ramal($AuxR) eq 0) && (eh_numerico($AuxR) eq 1));
    $AuxR = "" unless defined $AuxR;
    @Aux3 = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_dest='$AuxI'" );
    $AuxR = $Aux3[3] if ((eh_ramal($AuxR) eq 0) && (eh_numerico($AuxR) eq 1));
    $AuxR = "" unless defined $AuxR;
    $AuxR = $Aux2[1] if ((eh_ramal($AuxR) eq 0) && (eh_numerico($AuxR) eq 1));
    $AuxR = "" unless defined $AuxR;
    $AuxR = $Aux3[1] if ((eh_ramal($AuxR) eq 0) && (eh_numerico($AuxR) eq 1));
    $AuxR = "" unless defined $AuxR;
    $AuxG = pesquisa( "SELECT login FROM vm50_agentes WHERE ramal='$AuxR' and situacao!='NLogado'" );
  }
  $Agente = $AuxG if (($Agente eq "NULL") || ($Agente eq "") || ($Agente eq "E"));
  $Ramal  = $AuxR if (($Ramal eq "NULL")  || ($Ramal eq "")  || ($Ramal eq "E"));
  $Id_li  = $AuxI;
  return if (($Agente eq "E") || ($Agente eq ""));
  return if (($Ramal eq "E") || ($Ramal eq ""));
  print ">>>2 agente:$Agente. ramal:$Ramal. id:$Id_li.\n" if ($opt_debug2);
  grava_log2(">>>2 agente:$Agente. ramal:$Ramal. id:$Id_li.\n") if ($opt_debug);
  #>>> Quando nao descobre a fila...
  if ($Fila eq "NULL") {
    $AuxF = pesquisa("SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig ='$Id_li'");
    if (($AuxF ne "E") && ($AuxF ne "")) {
      $AuxF = pesquisa("SELECT pseudonimo FROM vm50_filas WHERE pseudonimo ='$AuxF'");
      $Fila = $AuxF if (($AuxF ne "E") && ($AuxF ne "") && ($AuxF ne "NULL"));
    }
  }
  #<<< Quando nao descobre a fila...
  #Verifica se eh unico o ramal no link_ligacoes
  @Aux1 = "";
  @Aux1 = pesquisa_multipla( "SELECT * FROM vm50_agentes WHERE login = '$Agente' and situacao!='NLogado'" );
  $AuxI = $Id_li;
  $AuxS = $Aux1[5];
  if (($AuxI ne $Id_li) && ($AuxS ne "Chamando")) {
    if (($Situa eq "Desligado") && ($Forca ne "Forcado")) {
      $Unico = pesquisa("SELECT id_orig FROM vm50_link_ligacao WHERE (numero_orig='$Ramal' OR numero_dest='$Ramal' OR pa='$Ramal') AND (id_orig!='$Id_li' AND id_dest!='$Id_li') AND estado!='Desligado'");
      if (($Unico ne "") && ($Unico ne "E")) {
        $Ta_noar = pesquisa("SELECT id FROM vm50_ligacao_id WHERE id ='$Id_li'");
        return if ($Ta_noar ne "E");
      }
    }
  }
  return if (($AuxI ne $Id_li) && ($AuxS eq "Chamando") && ($Situa eq "Desligado"));
  if (substr($AuxS,0,11) eq "Monitorando") {
    $AuxI = $Aux1[7];
    return if ($AuxI ne $Id_li);
  }
  @Aux4 = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Id_li'" ) if (($Aux4[0] lt "1") || ($Aux4[0] eq "E"));
  @Aux4 = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_dest='$Id_li'" ) if (($Aux4[0] lt "1") || ($Aux4[0] eq "E"));
  $AuxFP = $Aux1[12];
  grava_log2(">>>3a AuxFP=$AuxFP Aux1[11]=$Aux1[11]\n") if ($opt_debug);
  if (($Aux1[11] ne 1) && (($AuxS eq 'Em conversa&ccedil;&atilde;o') || ($AuxS eq 'Chamando') || ($AuxS eq 'Monitorando PA') || ($Situa eq 'Em conversa&ccedil;&atilde;o') || ($Situa eq 'Chamando') || ($Situa eq 'Desligado') || ($Situa eq 'Monitorando PA'))) {
    $sql = "";
    #>>>> Remover a Pausa Falsa
    if (1) {
    if ($AuxFP eq 1) {
      if ($Situa eq "Desligado") {
        grava_log2(">>>3b desligado \n") if ($opt_debug);
        print $sock "Action: QueuePause\r\nInterface: Agent/$Agente\r\nPaused: false\r\n\r\n";
        #print "Action: QueuePause\r\nInterface: Agent/$Agente\r\nPaused: false\r\n\r\n" if ($opt_display);
        $sql = "UPDATE vm50_agentes SET pausafalsa = '' WHERE login = '$Agente' and situacao!='NLogado'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
      }
    } else {
      if ($Situa eq "Desligado") {
        grava_log2(">>>3 desligado \n") if ($opt_debug);
        print $sock "Action: QueuePause\r\nInterface: Agent/$Agente\r\nPaused: false\r\n\r\n";
        #print "Action: QueuePause\r\nInterface: Agent/$Agente\r\nPaused: false\r\n\r\n" if ($opt_display);
        $sql = "UPDATE vm50_agentes SET pausafalsa = '' WHERE login = '$Agente' and situacao!='NLogado'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
      }
      elsif (($Fila eq "DDR") || ($Fila eq "Consulta") || ($Fila eq "Fazendo chamada externa") || ($AuxS eq "Monitorando PA") || ($Situa eq "Monitorando PA") || (substr($Aux4[7],0,19) eq "Transfer&ecirc;ncia")) {
        grava_log2(">>>3c nao desligado \n") if ($opt_debug);
        grava_log2(">>>3d mandaver \n") if ($opt_debug);
        print $sock "Action: QueuePause\r\nInterface: Agent/$Agente\r\nPaused: true\r\n\r\n";
        #print "Action: QueuePause\r\nInterface: Agent/$Agente\r\nPaused: true\r\n\r\n" if ($opt_display);
        $sql = "UPDATE vm50_agentes SET pausafalsa = '1' WHERE login = '$Agente' and situacao!='NLogado'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
      }
    }
    grava_log2(">>>3d pausa:$Agente. pausafalsa:$AuxFP. auxs:$AuxS. situa:$Situa. fila:$Fila.\n") if ($opt_debug);
    }
    #<<<< Remover a Pausa Falsa
  }
  return if ($Id_li eq 'E');
  if ($Fila eq "Consulta") {
    if ($Situa eq "Desligado") {
      $Pausa = $Aux1[11];
      $Sitt = "Livre";
      $Sitt = "Em Pausa" if ($Pausa);
      $sql = "UPDATE vm50_agentes SET falandocom = '', fila = '', situacao = '$Sitt', id_ligacao = '', ult_estad=CURRENT_TIMESTAMP WHERE login = '$Agente' and situacao!='NLogado'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    } else {
      $ComQuemFalo = pesquisa("SELECT falandocom FROM vm50_agentes WHERE login = '$Agente'");
      return if (($AuxS eq 'Em conversa&ccedil;&atilde;o') && ($Situa eq '') && ($ComQuemFalo eq $Falan));
      $TemGravacao = pesquisa("SELECT gravacao FROM vm50_ligacao_id WHERE numero = '$Falan' ORDER BY id DESC LIMIT 1");
      $TemSituacao = pesquisa("SELECT obs FROM vm50_ligacao_id WHERE numero = '$Falan' ORDER BY id DESC LIMIT 1");
      return if (($TemGravacao ne 'E') && ($TemGravacao ne '') && ($TemSituacao eq 'FILA'));
      $Id_li = "" if (($Falan eq '') && ($Fila eq ''));
      if ($Falan ne 'E') {
        $sql = "UPDATE vm50_agentes SET falandocom = '$Falan', fila = '$Fila', situacao = '$Situa', id_ligacao = '$Id_li', ult_estad=CURRENT_TIMESTAMP WHERE login = '$Agente' AND ramal != '$Falan'  AND situacao!='NLogado'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
      }
    }
  } else {
    if (($Agente ne "") || (($Ramal ne "NULL") && ($Falan ne "NULL") && ($Fila ne "NULL") && ($Situa ne "NULL") && ($Id_li ne "NULL"))) {
      @Aux1 = "";
      @Aux1 = pesquisa_multipla( "SELECT * FROM vm50_agentes WHERE login = '".$Agente."' and situacao!='NLogado'" );
      $AFala = $Aux1[6];
      if ($AFala ne "E") {
        $AFila = $Aux1[8];
        $ASitu = $Aux1[5];
        $AIdLi = $Aux1[7];
        $Falan = $AFala if ($Falan eq "NULL");
        $Fila  = $AFila if ($Fila  eq "NULL");
        $Situa = $ASitu if ($Situa eq "NULL");
        $Id_li = $AIdLi if ($Id_li eq "NULL");
#        if (($Situa eq '') && ($ASitu eq 'Em conversa&ccedil;&atilde;o')) {
#          if ((($Fila eq 'DDR') || ($Fila eq 'Transfer&ecirc;ncia-DDR')) && (($AFila ne '') && ($AFila ne 'E'))) {
#            $Fila  = $AFila;
#            $Situa = $ASitu;
#          }
#        }
        if ($Situa eq "Desligado") {
          $Falan = $Fila = "";
          $Pausa = $Aux1[11];
          $Situa = "Livre";
          $Situa = "Em Pausa" if ($Pausa);
        }
        #Se fizer pausa via softfone a ligacao de pausa nao pode alterar o estado do agente
        if (($Situa ne "Livre") || ($ASitu ne "Em Pausa")) {
          $id_ag = pesquisa( "SELECT id FROM vm50_agentes WHERE id_ligacao = '$Id_li' AND login != '$Agente'");
          if ($id_ag ne "E") {
            $Pausa = pesquisa( "SELECT pausa FROM vm50_agentes WHERE login='$Agente' and situacao!='NLogado'" );
            $Sitt  = "Livre";
            if ($Pausa) {
              $Sitt  = "Em Pausa";
              $TipoP = pesquisa( "SELECT tipopausa FROM vm50_agentes WHERE login='$Agente' and situacao!='NLogado'" );
            } else {
              $TipoP = '';
            }
            #$sql = "UPDATE vm50_agentes SET falandocom = '', fila = '', situacao = '$Sitt', id_ligacao='', tipopausa='$TipoP', ult_estad=CURRENT_TIMESTAMP WHERE id_ligacao = '$Id_li' and situacao!='NLogado'";
            $sql = "UPDATE vm50_agentes SET falandocom = '', fila = '', situacao = '$Sitt', id_ligacao='', ult_estad=CURRENT_TIMESTAMP WHERE id_ligacao = '$Id_li' and situacao!='NLogado'";
            $Retorno = $dbh->do($sql);
            print "$sql $Retorno\n" if ($opt_debug2);
            grava_log2("$sql $Retorno\n") if ($opt_debug);
          }
          if (($Falan eq "") && ($Situa eq "Chamando")) {
            $Pausa = pesquisa( "SELECT pausa FROM vm50_agentes WHERE login='$Agente' and situacao!='NLogado'" );
            $Situa = "Livre";
            if ($Pausa) {
              $Sitt  = "Em Pausa";
              $TipoP = pesquisa( "SELECT tipopausa FROM vm50_agentes WHERE login='$Agente' and situacao!='NLogado'" );
            } else {
              $TipoP = '';
            }
          }
          $Id_des = $Id_li;
          $Id_li = "" if (($Falan eq '') && ($Fila eq ''));
          #$sql = "UPDATE vm50_agentes SET falandocom = '$Falan', fila = '$Fila', situacao = '$Situa', id_ligacao='$Id_li', tipopausa='$TipoP', ult_estad=CURRENT_TIMESTAMP WHERE login = '$Agente' and situacao!='NLogado'";
          $ComQuemFalo = pesquisa("SELECT falandocom FROM vm50_agentes WHERE login = '$Agente'");
          $MinhaFila   = pesquisa("SELECT fila FROM vm50_agentes WHERE login = '$Agente'");
          $EhFila      = pesquisa("SELECT pseudonimo FROM vm50_filas WHERE pseudonimo = '$MinhaFila'");
          print "ComQuemFalo:$ComQuemFalo MinhaFila:$MinhaFila EhFila:$EhFila Fila:$Fila\n" if ($opt_debug2);
          grava_log2("ComQuemFalo:$ComQuemFalo MinhaFila:$MinhaFila EhFila:$EhFila Fila:$Fila\n") if ($opt_debug);
          if (($EhFila ne 'E') && ($EhFila ne '') && ($Fila eq 'DDR')) {
            $Fila     = $EhFila;
            $MinhaSit = pesquisa("SELECT situacao FROM vm50_agentes WHERE login = '$Agente'");
            $Situa    = $MinhaSit if (($MinhaSit ne 'E') && ($MinhaSit ne ''));
          }
          #return if ($ComQuemFalo eq $Falan);
          $MeuRamal = pesquisa("SELECT ramal FROM vm50_agentes WHERE login = '$Agente'");
          $Falan = $ComQuemFalo if (($MeuRamal eq $Falan) && ($ComQuemFalo ne 'E') && ($ComQuemFalo ne ''));
          $Falan =  '' if ($MeuRamal eq $Falan);
          if ($Falan ne 'E') {
            $sql = "UPDATE vm50_agentes SET falandocom = '$Falan', fila = '$Fila', situacao = '$Situa', id_ligacao='$Id_li', ult_estad=CURRENT_TIMESTAMP WHERE login = '$Agente' AND ramal != '$Falan' AND situacao!='NLogado'";
            $Retorno = $dbh->do($sql);
            print "$sql $Retorno\n" if ($opt_debug2);
            grava_log2("$sql $Retorno\n") if ($opt_debug);
          }
          if  (($Falan eq '') && ($Fila eq '') && ($Id_li eq '')) {
            #>>> Resolve as ligacoes fantasmas
            #$sql = "UPDATE vm50_link_ligacao SET pa = '' WHERE id_orig = '$Id_des' OR id_dest = '$Id_des'";
            if ($Situa eq 'Desligado') {
              $sql = "UPDATE vm50_link_ligacao SET pa = '', estado = '' WHERE id_orig = '$Id_des' OR id_dest = '$Id_des'";
            } else {
              $sql = "UPDATE vm50_link_ligacao SET pa = '' WHERE id_orig = '$Id_des' OR id_dest = '$Id_des'";
              #>>> Resolvendo o problema de ligacoes fantasmas na fila (o agente desliga antes do cliente)
              if ($Situa eq "Desligado") {
                $sql = "UPDATE vm50_link_ligacao SET numero_orig = '', id_dest = '', numero_dest = '', pa = '', tipo = '', estado = 'Desligado', obs = '', gravacao=''  WHERE id_orig = '$Id_des' OR id_dest = '$Id_des'";
              }
              #<<< Resolvendo o problema de ligacoes fantasmas na fila
            }
            #<<< Resolve as ligacoes fantasmas
            $Retorno = $dbh->do($sql);
            print "$sql $Retorno\n" if ($opt_debug2);
            grava_log2("$sql $Retorno\n") if ($opt_debug);
          }
        }
        if ($Situa eq "Livre") {
          $Esta = pesquisa( "SELECT estado FROM vm50_link_ligacao WHERE pa='$Ramal'" );
          $Esta = "Chamando" if ($Esta ne "Desligado");
          $Obs  = pesquisa( "SELECT obs    FROM vm50_link_ligacao WHERE pa='$Ramal'" );
          if (($Obs ne "Em conversa&ccedil;&atilde;o") && ($Obs ne "E")){
            if ($Obs ne "E") {
              $sql  = "UPDATE vm50_link_ligacao SET pa = '', estado='$Esta', obs='$Obs' WHERE pa='$Ramal'";
              $Retorno = $dbh->do($sql);
              print "$sql $Retorno\n" if ($opt_debug2);
              grava_log2("$sql $Retorno\n") if ($opt_debug);
            }
          }
        }
      }
    }
  }
  ### Resolvendo o problema de gravacoes >>>
  if ($Situa eq 'Em conversa&ccedil;&atilde;o') {
    $Gravacao = pesquisa( "SELECT gravacao FROM vm50_link_ligacao WHERE id_orig='$Id_li' OR  id_dest='$Id_li'" );
    $Pseudon = pesquisa( "SELECT pseudonimo FROM vm50_agentes WHERE login='$Agente' and situacao!='NLogado'" );
    @Arquivo = split(/-/, $Gravacao);
    if ($FilaO eq "Fazendo chamada externa") {
      $Novo_nome = $Arquivo[0]."-".$Agente."-".$Pseudon."-S-".$Arquivo[1]."-".$Arquivo[2]."-".$Arquivo[3];
    } elsif ($FilaO eq "DDR") {
      $Novo_nome = $Arquivo[0]."-".$Arquivo[1]."-".$Ramal."-".$Agente."-".$Pseudon."-ED-DDR-".$Arquivo[2]."-".$Arquivo[3];
    } elsif ($FilaO eq "Consulta") {
      $RFez = pesquisa( "SELECT numero_orig FROM vm50_link_ligacao WHERE id_orig='$Id_li'" );
      $RRec = pesquisa( "SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig='$Id_li'" );
      $AFez[0] = $AFez[1] = $ARec[0] = $ARec[1] = "";
      @AFez = pesquisa_multipla( "SELECT login,pseudonimo FROM vm50_agentes WHERE ramal='$RFez' and situacao!='NLogado'" ) if (($RFez gt "1") || ($RFez eq "E"));
      @ARec = pesquisa_multipla( "SELECT login,pseudonimo FROM vm50_agentes WHERE ramal='$RRec' and situacao!='NLogado'" ) if (($RRec gt "1") || ($RRec eq "E"));
      $Novo_nome = $Arquivo[0]."-".$AFez[0]."-".$AFez[1]."-C-".$Arquivo[1]."-".$RRec."-".$ARec[0]."-".$ARec[1]."-".$Arquivo[2]."-".$Arquivo[3];
    } elsif (substr($FilaO,0,19) eq "Transfer&ecirc;ncia") {
      $Novo_nome = $Arquivo[0]."-".$Arquivo[1]."-".$Ramal."-".$Agente."-".$Pseudon."-T-".substr($FilaO,20)."-".$Arquivo[2]."-".$Arquivo[3];
    } else {
      my $QFila  = pesquisa( "SELECT pseudonimo FROM vm50_filas WHERE nome='$FilaO'" );
      $QFila     = $FilaO if (($QFila eq "E") || ($QFila eq ""));
      $Novo_nome = $Arquivo[0]."-".$Arquivo[1]."-".$Ramal."-".$Agente."-".$Pseudon."-EF-".$QFila."-".$Arquivo[2]."-".$Arquivo[3];
    }
    if ($Novo_nome ne "") {
      $sql = "UPDATE vm50_link_ligacao SET gravacao_nova = '$Novo_nome' WHERE  id_orig='$Id_li' OR id_dest='$Id_li'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      if ($renomeia_gra eq 1) {
        if (-e $Gravacao) {
         rename($Gravacao,$Novo_nome);
        }
      }
    }
  }
  ### <<< Resolvendo o problema de gravacoes
  $Obs = $Fila if (substr($Obs,0,19) ne "Transfer&ecirc;ncia");
  if (substr($Obs,0,19) ne "Transfer&ecirc;ncia") {
    $Obs = "Transfer&ecirc;ncia-$Obs" if ($Trans eq 1);
  }
  $Canal = pesquisa( "SELECT canal FROM vm50_ligacao_id WHERE id='$Id_li' " );
  $Canal = "" if ($Canal eq "E");
  if ($Situa ne "Em Pausa") {
    registra_para_relatorio($Agente,$Obs,$Id_li,$Falan,$Situa,"","","",$Canal);
  } else {
    $TipoP = pesquisa( "SELECT tipopausa FROM vm50_agentes WHERE login='$Agente' and situacao!='NLogado'" );
    registra_para_relatorio($Agente,$TipoP,$Id_li,$Falan,"Em Pausa","","","",$Canal);
  }
}

sub fecha_agente_forcado(@) {
  my $Id_li = $_[0];
  my $Canal = $_[1];
  my @AuxA = @AuxL = $TipoP = $Canal = $Retorno =  "";
  my $Agente = $Situac = $Nov_Id = $Obs = $Outro_Ramal = $PausI ="";
  my $Obs2 = $sql = $Sitt = $Pausa = $Ramal = $Teste = "";
  $Ramal  = pesquisa( "SELECT numero   FROM vm50_ligacao_id WHERE id='$Id_li'" );
  grava_log2("\n>>>fecha_agente_forcado $Id_li $Canal $Ramal \n") if ($opt_debug);
  if ((eh_ramal($Ramal) eq 0) || ($Ramal gt 9999) || (eh_numerico($Ramal) eq 0)) {
    #>> Para desligar
    #@AuxL = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Id_li'" );
    @AuxL = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Id_li' OR  id_dest='$Id_li'" );
    #<< Para desligar
    @AuxL = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Id_li'" );
    $Ramal = $AuxL[4];
    $Ramal = "" unless defined $Ramal;
    $Ramal = $AuxL[3] if ((eh_ramal($Ramal) eq 0) || (eh_numerico($Ramal) eq 0));
    $Ramal = "" unless defined $Ramal;
    $Ramal = $AuxL[1] if ((eh_ramal($Ramal) eq 0) || (eh_numerico($Ramal) eq 0));
    $Ramal = "" unless defined $Ramal;
    @AuxL = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_dest='$Id_li'" ) if ((eh_ramal($Ramal) eq 0) || (eh_numerico($Ramal) eq 0));
    $Ramal = $AuxL[4];
    $Ramal = $AuxL[3] if ((eh_ramal($Ramal) eq 0) || (eh_numerico($Ramal) eq 0));
    $Ramal = $AuxL[1] if ((eh_ramal($Ramal) eq 0) || (eh_numerico($Ramal) eq 0));
    if ((eh_ramal($Ramal) eq 0) || ($Ramal gt 9999) || (eh_numerico($Ramal) eq 0)) {
      $Id_li = pesquisa( "SELECT id_orig  FROM vm50_link_ligacao WHERE id_dest='$Id_li'" );  
      $Ramal = pesquisa( "SELECT numero   FROM vm50_ligacao_id   WHERE id='$Id_li'" );
    }
  }
  return $Id_li if ($Ramal eq "");
  #>> Para desligar
  $Teste = pesquisa( "SELECT login FROM vm50_agentes WHERE ramal='$Ramal'" );
  if ($Teste eq "E") {
    $Outro_Ramal = pesquisa( "SELECT numero_orig FROM vm50_link_ligacao WHERE id_orig='$Id_li' OR id_dest='$Id_li'" );
    $Teste = pesquisa( "SELECT login FROM vm50_agentes WHERE ramal='$Outro_Ramal'" ) if (($Outro_Ramal ne "") && ($Outro_Ramal ne "E"));
    if ($Teste eq "E") {
      $Outro_Ramal = pesquisa( "SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig='$Id_li' OR id_dest='$Id_li'" );
      $Teste = pesquisa( "SELECT login FROM vm50_agentes WHERE ramal='$Outro_Ramal'" ) if (($Outro_Ramal ne "") && ($Outro_Ramal ne "E"));
      if ($Teste ne "E") {
        $Ramal = $Outro_Ramal;
      }
    } else {
      $Ramal = $Outro_Ramal;
    }
  }
  #<< Para desligar
  @AuxA   = pesquisa_multipla( "SELECT * FROM vm50_agentes WHERE ramal='$Ramal'" );
  $Agente = $AuxA[2];
  $Situac = $AuxA[5];
  $Nov_Id = $AuxA[6];
  $PausI  = $AuxA[11];
  $FilaI  = $AuxA[8];
#  $Obs    = pesquisa( "SELECT obs FROM vm50_link_ligacao WHERE pa='$Ramal' AND (id_orig='$Id_li' OR id_dest='$Id_li')" );
  $Obs    = pesquisa( "SELECT obs FROM vm50_link_ligacao WHERE (id_orig='$Id_li' OR id_dest='$Id_li')" );
  if ($Obs ne "Consulta") {
    $Obs    = pesquisa( "SELECT obs FROM vm50_link_ligacao WHERE pa='$Ramal' AND (id_orig='$Id_li' OR id_dest='$Id_li')" );
    return $Id_li if ($Obs eq "E");
  }
  $Obs2   = pesquisa( "SELECT obs FROM vm50_link_ligacao WHERE pa='$Ramal'" );
  $Situac = "" unless defined $Situac;
  return $Id_li if ($Situac eq "Em Pausa");
  return "E" if ($Obs ne $FilaI);
  if ($Obs2 eq "FILA") {
   if ($Situac ne "Chamando") {
     if ($Obs eq "E") {
       return $Id_li;
     }
   }
  }
  $Obs    = pesquisa( "SELECT obs FROM vm50_link_ligacao WHERE id_dest='$Id_li'" ) if ($Obs eq "E");
  $Situac = "";
  if ($Obs eq "DDR") {
    $sql = "UPDATE vm50_link_ligacao SET numero_dest = '', pa = '' WHERE pa = '$Ramal'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  } elsif ($Obs eq "Consulta") {
    $Outro_Ramal = $AuxA[6];
      my $Outro_Canal = pesquisa( "SELECT canal FROM vm50_ligacao_id WHERE numero='$Ramal' ORDER BY id DESC LIMIT 1" );
    altera_situacao_agente($Outro_Canal, "NULL", "NULL", "Desligado", $Nov_Id);
#### Para registrar transferencias de chamada externa
  } elsif ($Obs eq "Fazendo chamada externa") {
    my $CaExt = pesquisa( "SELECT canal FROM vm50_ligacao_id WHERE id='$Id_li'" );
    my $IdExt = pesquisa( "SELECT id FROM vm50_ligacao_id WHERE canal='$CaExt' ORDER BY id DESC LIMIT 1" );
    my $NuExt = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE canal='$CaExt' ORDER BY id DESC LIMIT 1" );
    $Canal = pesquisa( "SELECT canal FROM vm50_ligacao_id WHERE id='$Id_li' " );
    $Canal = "" if ($Canal eq "E");
    registra_para_relatorio($Agente,'Transfer&ecirc;ncia-Fazendo chamada externa',$IdExt,$NuExt,'Chamando','','','',$Canal);
  }
### Fim do registro
  $Agente = "E" unless defined $Agente;
  if ($Agente eq "E") {
    $Ramal  = pesquisa( "SELECT pa FROM vm50_link_ligacao WHERE id_orig='$Id_li'" );  
    @AuxA   = pesquisa_multipla( "SELECT * FROM vm50_agentes WHERE ramal='$Ramal'" );
    $Agente = $AuxA[2];
  } else {
    if ($PausI) {
      $Sitt  = "Em Pausa";
      $TipoP = $AuxA[17];
    } else {
      $Sitt  = "Livre";
      print $sock "Action: QueuePause\r\nInterface: Agent/$Agente\r\nPaused: false\r\n\r\n";
      #print "Action: QueuePause\r\nInterface: Agent/$Agente\r\nPaused: false\r\n\r\n" if ($opt_display);
      $sql = "UPDATE vm50_agentes SET pausafalsa = '' WHERE login = '$Agente'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
   }
   #$sql = "UPDATE vm50_agentes SET falandocom = '', fila = '', situacao = '$Sitt', id_ligacao = '', tipopausa='$TipoP', ult_estad=CURRENT_TIMESTAMP WHERE login = '$Agente'";
   $sql = "UPDATE vm50_agentes SET falandocom = '', fila = '', situacao = '$Sitt', id_ligacao = '', ult_estad=CURRENT_TIMESTAMP WHERE login = '$Agente'";   $Retorno = $dbh->do($sql);
   print "$sql $Retorno\n" if ($opt_debug2);
   grava_log2("$sql $Retorno\n") if ($opt_debug);
   $Sitt = "Livre" unless defined $Sitt;
   $Sitt = "Livre" if (($Sitt ne "Livre") && ($Sitt ne "Em Pausa"));
   registra_para_relatorio($Agente,$TipoP,'','',$Sitt,'','','');
  }
  return "";
}

#estado_ligacao(id_Ligacao, situacao);
sub estado_ligacao(@) {
  my $Id_Ligacao = $_[0];
  my $Situacao   = $_[1];
  my $Destino    = "NULL";
  my $Ramal = $Fila = $Filaux = $sql = $Nada = $Desist = $Gravacao = $Canal = $Conve = $Retorno = $GrTo = "";
  my @Aux = @GrAux = "";
  $Canal  = pesquisa( "SELECT canal FROM vm50_ligacao_id WHERE id='$Id_Ligacao' " );
  $Canal  = "" if ($Canal eq "E");
  if (substr($Situacao,0,11) eq "Monitorando") {
    @Aux = split(/-/, $Situacao);
    $Situacao = "Monitorando PA";
    $Destino  = $Aux[1];
    $Canal    = pesquisa("SELECT canal FROM vm50_ligacao_id WHERE id='$Id_Ligacao'");
    altera_situacao_agente($Canal, $Destino, "", $Situacao, $Id_Ligacao);
  ### Tratando as saidas das chamadas da fila >>>
  } elsif (substr($Situacao,0,4) eq "FILA") {
    #@Aux    = split(/\|/, $Situacao);
    $Desist = pesquisa("SELECT desistiu FROM vm50_ligacao_id WHERE id='$Id_Ligacao'");
    if ($Desist eq 1) {
      $Filaux = substr($Situacao,5);
      $Fila   = pesquisa("SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao'");
      if (($Fila ne "E") && ($Fila ne "") && ($Fila ne $Filaux)) {
        registra_para_relatorio("","FILA",$Id_Ligacao,$Fila,"Desistencia-FilA","","","",$Canal);
        #fecha_ligacao($Id_Ligacao,0);
      } else {
        $sql = "UPDATE vm50_link_ligacao SET numero_dest='$Filaux' WHERE id_orig='$Id_Ligacao'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
        registra_para_relatorio("","FILA",$Id_Ligacao,$Filaux,"Desistencia-FilA","","","",$Canal);
        #fecha_ligacao($Id_Ligacao,0);
      }
    } else {
      $Filaux = substr($Situacao,5);
      $Fila   = pesquisa("SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao'");
      if (($Fila ne "E") && ($Fila ne "") && ($Fila ne $Filaux)) {
        ### Tratando das transferencias para fila >>>
        $Conve = pesquisa("SELECT conversou FROM vm50_ligacao_id WHERE id='$Id_Ligacao'");
        if ($Conve eq '1') {
          $Situacao = "Transfer&ecirc;ncia-FILA";
        }
        ### <<< Tratando das transferencias para fila
        $sql = "UPDATE vm50_ligacao_id SET obs='$Situacao', numero='$Destino' WHERE id='$Id_Ligacao'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
        amarra_ligacoes($Id_Ligacao, "NULL", "NULL", $Destino, "NULL", "NULL", $Filaux, "NULL");
      } else {

### >!>!>!>!>!
        if ($Fila eq "E") {
          $Ramal = pesquisa("SELECT numero FROM vm50_ligacao_id WHERE id='$Id_Ligacao'");
          $Fila  = pesquisa("SELECT id_orig FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao'");
          if ($Fila eq "E") {
            $sql = "INSERT INTO vm50_link_ligacao (id_orig, numero_orig, numero_dest, estado, obs, diahora) VALUES ('$Id_Ligacao', '$Ramal', '$Filaux', 'Chamando', '$Situacao', CURRENT_TIMESTAMP)";
          } else {
            $sql = "UPDATE vm50_link_ligacao SET numero_dest='$Filaux', estado='Chamando', obs='$Situacao' WHERE id_orig='$Id_Ligacao'";
          }
        } else {
          $sql = "UPDATE vm50_link_ligacao SET numero_dest='$Filaux' WHERE id_orig='$Id_Ligacao'";
        }
### <!<!<!<!<!
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
      }
    }
  } elsif ($Situacao eq "CAIXA_POSTAL") {
#    $Desist = pesquisa("SELECT desistiu FROM vm50_ligacao_id WHERE id='$Id_Ligacao'");
#    if ($Desist eq 1) {
      $Fila   = pesquisa("SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao'");
      if (($Fila ne "E") && ($Fila ne "")) {
        registra_para_relatorio("","FILA",$Id_Ligacao,$Fila,"Desistencia-Caixa_Postal","","","",$Canal);
        $sql = "UPDATE vm50_link_ligacao SET estado = 'Em conversa&ccedil;&atilde;o', numero_dest = 'Caixa Postal' WHERE id_orig = '$Id_Ligacao'";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
        ##fecha_ligacao($Id_Ligacao,0);
      }
#    }
  } elsif ($Situacao eq "MSG_ATENDIMENTO") {
#    $Desist = pesquisa("SELECT desistiu FROM vm50_ligacao_id WHERE id='$Id_Ligacao'");
#    if ($Desist eq 1) {
      $sql = "UPDATE vm50_ligacao_id SET mensagem='1' WHERE id='$Id_Ligacao'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      $sql = "UPDATE vm50_link_ligacao SET mensagem='1' WHERE id_orig='$Id_Ligacao' OR id_dest='$Id_Ligacao'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      $Fila   = pesquisa("SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao'");
      if (($Fila ne "E") && ($Fila ne "")) {
        registra_para_relatorio("","FILA",$Id_Ligacao,$Fila,"Desistencia-Msg_Atendimento","","","",$Canal);
        ##fecha_ligacao($Id_Ligacao,0);
      }
#    }
  } elsif ($Situacao eq "DESLIGAMENTO") {
#    $Desist = pesquisa("SELECT desistiu FROM vm50_ligacao_id WHERE id='$Id_Ligacao'");
#    if ($Desist eq 1) {
      #my $Temagente = pesquisa("SELECT login FROM vm50_agentes WHERE id_ligacao='$Id_Ligacao' AND situacao='Chamando'");
      $Ramal = pesquisa("SELECT pa FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao' OR id_dest='$Id_Ligacao'");
      my $Temagente = pesquisa("SELECT login FROM vm50_agentes WHERE ramal='$Ramal'");
      if (($Temagente ne "E") && ($Temagente ne "")) {
        $Fila   = pesquisa("SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao' OR id_dest='$Id_Ligacao'");
        if (($Fila ne "E") && ($Fila ne "")) {
          registra_para_relatorio($Temagente,"FILA",$Id_Ligacao,$Fila,"Desistencia-Desligamento","","","",$Canal);
          fecha_ligacao($Id_Ligacao,0);
        }
      } else {
        registra_para_relatorio("","FILA",$Id_Ligacao,$Fila,"Desistencia-FilA","","","",$Canal);
      }
#    }
  ### <<< Tratando as saidas das chamadas da fila
  ### Tratando as filas que comecam com mensagem >>>
  } elsif ($Situacao eq "COMECA COM MENSAGEM") {
    $Nada = "";
    ### Quando comeca com mensagem gera errado a gravacao >>>
    $sql = "UPDATE vm50_ligacao_id SET mensagem='1' WHERE id='$Id_Ligacao'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    $sql = "UPDATE vm50_link_ligacao SET mensagem='1' WHERE id_orig='$Id_Ligacao' OR id_dest='$Id_Ligacao'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    ### <<< Quando comeca com mensagem gera errado a gravacao
    #$sql = "DELETE FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao' or id_dest='$Id_Ligacao'";
    #$Retorno = $dbh->do($sql);
    #print "$sql $Retorno\n" if ($opt_debug2);
    #grava_log2("$sql $Retorno\n") if ($opt_debug);
  ### <<< Tratando as filas que comecam com mensagem
  ### Resolvendo o problema de gravacoes >>>
  } elsif (substr($Situacao,0,15) eq "MARCA GRAVACAO-") {
    $Gravacao = substr($Situacao,15);
    $Gravacao =~ s/wav49/WAV/;
if (0) {
    @GrAux = split(/./, $Gravacao);
    $GrTo  = @GrAux;
    if ($GrTo > 1) {
      $GrAux[$GrTo-1] = "WAV" if ($GrAux[$GrTo-1] ne "WAV");
      $Gravacao = "";
      for (my $gr=0; $gr<$GrTo; $gr++) {
        $Gravacao = $Gravacao.$GrAux[$gr];
      }
    } else {
      $Gravacao = $Gravacao.".WAV";
    }
}

    ### >>> Arrumar o log do pbx
    $Situacao = "MARCA GRAVACAO-$Gravacao";
    ### <<< Arrumar o log do pbx
    $sql = "UPDATE vm50_ligacao_id SET gravacao='$Gravacao' WHERE id='$Id_Ligacao'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    $Fila = pesquisa("SELECT numero_dest FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao' OR id_dest='$Id_Ligacao'");
    if ( ($Fila ne "E") && ($Fila gt "!") ) {
      $sql = "UPDATE vm50_link_ligacao SET gravacao='$Gravacao' WHERE id_orig='$Id_Ligacao' OR id_dest='$Id_Ligacao'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    }
    marca_tabela_gravacao($Id_Ligacao,"Naosei");
  ### <<< Resolvendo o problema de gravacoes
  } else {
    if ($Destino eq "NULL") {
      $sql = "UPDATE vm50_ligacao_id SET obs='$Situacao' WHERE id='$Id_Ligacao'";
    } else {
      $sql = "UPDATE vm50_ligacao_id SET obs='$Situacao', numero='$Destino' WHERE id='$Id_Ligacao'";
    }
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    amarra_ligacoes($Id_Ligacao, "NULL", "NULL", $Destino, "NULL", "NULL", $Situacao, "NULL");
  }
  #registra_para_relatorio_pbx(ligacao_origem,numero_origem,canal_origem,ligacao_destino,numero_destino,canal_destino,oque);
  registra_para_relatorio_pbx($Id_Ligacao,"NULL",$Canal,"NULL","NULL","NULL",$Situacao);
}

#ligacao_na_fila(fila, id_ligacao, obs);
sub ligacao_na_fila(@) {
  my $Fila = $_[0];
  my $Id_Ligacao = $_[1];
  my $Canal = $_[2];
  my $Obs = $Retorno = "";
  my $sql = "UPDATE vm50_ligacao_id SET canal='$Canal' WHERE id='$Id_Ligacao'";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
  #>>> Resolve o problema de filas com nome e pseudonimo distintos
  my $Pseudo = pesquisa( "SELECT pseudonimo FROM vm50_filas WHERE nome='$Fila'");
  if (($Pseudo eq "E") || ($Pseudo eq "")) {
    $Pseudo = pesquisa( "SELECT pseudonimo FROM vm50_filas WHERE pseudonimo='$Fila'");
  }
  $Fila = $Pseudo if (($Pseudo ne "E") && ($Pseudo ne ""));
  #<< Resolve o problema de filas com nome e pseudonimo distintos
  if ($Obs eq "Transfer&ecirc;ncia-E") {
    amarra_ligacoes($Id_Ligacao, "NULL", "NULL", $Fila, "", "Desligado", "FILA","", "NULL");
  } else {
    amarra_ligacoes($Id_Ligacao, "NULL", "NULL", $Fila, "Procurando PA", "Chamando", 'FILA', $Obs, "NULL");
  }
}

#ligacao_no_agente(agente, canal, ramalc);
sub ligacao_no_agente(@) {
  my $Agente = $_[0];
  my $Canal  = le_meia($_[1]);
  my $RamalC = $_[2];
  my $Id_Ligacao = $Ramal1 = "NULL";
  my $Rejeito = 0;
  my @NumeroA = @NumeroB = @Agen1 = @Agen2 = "";
  my $Ramal = $Situacao = $Falando = $Numero = $RamalA = $RamalV = $sql = $Retorno = "";
  #>>> Verifica se eh ramal o ramal
  $RamalV  = pesquisa( "SELECT ramal FROM vm50_ramais WHERE numeroaster='$RamalC'");
  if (eh_ramal($RamalV) eq 1) {
    $RamalA  = pesquisa( "SELECT nome FROM vm50_agentes WHERE ramal='$RamalV'");
    $Ramal = $RamalV if (($RamalA eq "E") || ($RamalA eq ""));
    print "Ramal $Ramal \n" if ($opt_debug2);
    grava_log2("Ramal $Ramal \n") if ($opt_debug);
  }
  #<<< Verifica se eh ramal o ramal
  #>>> Descobre o ramal do agente
  if (substr($RamalC,0,5) eq "Agent") {
    $Ramal = pesquisa( "SELECT ramal FROM vm50_agentes WHERE login='$Agente'");
    $Ramal = "" if ($Ramal eq "E");
  }
  #<<< Descobre o ramal do agente
  if (substr($Canal,0,5) eq "Local") {
    @NumeroA = split(/@/, $Canal);
    @NumeroB = split(/\//, $NumeroA[0]);
    $Ramal1     = $NumeroB[1];
    @Agen1   = pesquisa_multipla( "SELECT * FROM vm50_agentes WHERE ramal='$Ramal1'" );
    $Id_Ligacao = $Agen1[7] if (($Agen1[7] ne "E") && ($Agen1[7] ne ""));
    $Rejeito    = 1 if ($Agen1[5] eq "Rejeitando"); 
  }
  $Id_Ligacao  = pesquisa( "SELECT id FROM vm50_ligacao_id WHERE canal='$Canal' ORDER BY id DESC, canal ASC LIMIT 1" ) if ($Id_Ligacao eq "NULL");
  @Agen2    = pesquisa_multipla( "SELECT * FROM vm50_agentes WHERE login='$Agente'" );
  $Ramal    = $Agen2[4] if (($RamalA ne "") && ($RamalA ne "E"));
  $Situacao = $Agen2[5];
  $Falando  = $Agen2[6];
  $Numero   = pesquisa( "SELECT numero_orig FROM vm50_link_ligacao WHERE id_orig='$Id_Ligacao' AND estado!='Desligado'" );
  $Falando  = "" if ($Falando eq "E");
  if (substr($RamalC,0,5) ne "Agent") {
    if ($Situacao ne "Livre") {
     if ($Falando ne "") {
       return;
     }
   }
  }
  if (testa_fabricante_placa($Canal) gt -1) {
    $sql = "UPDATE vm50_troncos SET numerointerno='$Ramal' WHERE numero_asterisk = '$Canal'";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
   #registra_para_relatorio_pbx(ligacao_origem,numero_origem,canal_origem,ligacao_destino,numero_destino,canal_destino,oque);
    registra_para_relatorio_pbx("NULL","NULL",$Canal,"NULL",$Ramal,"NULL",'Chamando');
  } else {
    my $Numvdt = testa_fabricante_placa_ip($Canal);
    if ($Numvdt gt 0) {
      $sql = "UPDATE vm50_troncos SET numerointerno='$Ramal' WHERE numero_vdt = '$Numvdt'";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
     #registra_para_relatorio_pbx(ligacao_origem,numero_origem,canal_origem,ligacao_destino,numero_destino,canal_destino,oque);
      registra_para_relatorio_pbx("NULL","NULL",$Canal,"NULL",$Ramal,"NULL",'Chamando');
    }
  }
  altera_situacao_agente($Canal, "NULL", "NULL", 'Desligado',$Id_Ligacao) if ($Rejeito eq 0);
  #$Ramal = $RamalT if (($RamalA eq "E") || ($RamalA eq ""));
  amarra_ligacoes($Id_Ligacao, $Numero, "NULL", "NULL", $Ramal, "NULL", 'FILA');
  #altera_situacao_agente($Canal, $Numero, "NULL", 'Chamando',$Id_Ligacao);
  altera_situacao_agente($RamalC, $Numero, "NULL", 'Chamando',$Id_Ligacao);
}


#marca_tabela_gravacao(id_ligacao,tipo);
sub marca_tabela_gravacao(@) {
  my $Id_li    = $_[0];
  my $Tipo     = $_[1];
  my $Gravacao = $Aux = $Nome = $Ramal1 = $Numero = $Dia = $Hora = $Agente1 = $Pseudo1 = $Grudac1 = $Grupbx1 = "";
  my $Fila = $Agente2 = $Pseudo2 = $Grudac2 = $Grupbx2 = $Horario = $Idgrava = $Retorno = $TipoAux = $Ramal = "";
  my @Dados = @Teste = @AAge = @APab = "";

  $Gravacao = pesquisa( "SELECT gravacao FROM vm50_link_ligacao WHERE id_orig='$Id_li' OR  id_dest='$Id_li'" );
  $Gravacao = pesquisa( "SELECT gravacao FROM vm50_ligacao_id WHERE id='$Id_li'" ) if ($Tipo eq "Naosei");
  @Teste    = split(/\//,$Gravacao);
  $Aux      = @Teste;
  $Nome     = $Teste[$Aux-1];
  @Teste    = split(/\./,$Nome);
  $Aux      = $Teste[0];
  @Dados    = split(/-/, $Aux);
  $TipoAux  = pesquisa( "SELECT mensagem FROM vm50_ligacao_id WHERE id='$Id_li'" ) if ($Tipo eq "Naosei");
  $Tipo     = "Fila" if ($TipoAux eq "1");

   print "\n >> marca_tabela_gravacao $Id_li $Tipo $Gravacao $Nome $Aux \n" if ($opt_debug2);
  grava_log2("\n >> marca_tabela_gravacao $Id_li $Tipo $Gravacao $Nome $Aux \n") if ($opt_debug);

  if ($Tipo eq "Naosei") {
    $Numero = $Dados[0];
    $Ramal  = $Dados[1];
    $Ramal  = "" if (eh_ramal($Ramal) eq 0);
    $Dia    = $Dados[2];
    $Hora   = $Dados[3];
    $Horario = substr($Dia,4,4).substr($Dia,2,2).substr($Dia,0,2).substr($Hora,0,2).substr($Hora,2,2).substr($Hora,4,2);
    my $AuxT = length($Numero);
    my $TipoAux = pesquisa("SELECT tipo FROM vm50_gravacoes WHERE diahora='$Horario' AND substring(gravacao from 1 for $AuxT)='$Numero' AND (tipo!='Transferencia' OR  tipo!='') LIMIT 1 ");
    $Tipo = "Fila" if ($TipoAux eq "fila");
    $Tipo = $TipoAux if (($TipoAux ne "") && ($TipoAux ne "E"));
  }


  if ($Tipo eq "Fazendo chamada externa") {
    $Ramal1 = $Dados[0];
    $Numero = $Dados[1];
    $Dia    = $Dados[2];
    $Hora   = $Dados[3];
    @AAge   = pesquisa_multipla("SELECT login, nome, pseudonimo, grupo FROM vm50_agentes WHERE ramal='$Ramal1' and situacao!='NLogado'");
    @APab   = pesquisa_multipla("SELECT pseudonimo,grupo FROM vm50_ramais WHERE ramal='$Ramal1'");
    if ($AAge[0] ne "E") {
      $Agente1 = $AAge[0].'-'.$AAge[1];
      $Pseudo1 = $AAge[2];
      $Grudac1 = $AAge[3];
    }
    if ($APab[0] ne "E") {
      $Pseudo1 = $APab[0] if ($Pseudo1 eq "");
      $Grupbx1 = pesquisa("SELECT nome FROM vm50_grupos_ramais WHERE id=$APab[1]");
      $Grupbx1 = "" if ($Grupbx1 eq "E");
    }
    $Horario = substr($Dia,4,4).substr($Dia,2,2).substr($Dia,0,2).substr($Hora,0,2).substr($Hora,2,2).substr($Hora,4,2);
    #$Idgrava = pesquisa("SELECT id_ligacao FROM vm50_gravacoes WHERE id_ligacao='$Id_li'");
    $Idgrava = pesquisa("SELECT gravacao FROM vm50_gravacoes WHERE gravacao='$Nome'");
    if ($Idgrava eq "E") {
      $sql = "INSERT INTO vm50_gravacoes (id_ligacao,gravacao,dia,hora,agente_o,ramal_o,usuario_o,grupopabx_o,grupodac_o,numero,tipo,diahora) VALUES ('$Id_li','$Nome','$Dia','$Hora','$Agente1','$Ramal1','$Pseudo1','$Grupbx1','$Grudac1','$Numero','saida','$Horario')";
    } else {
      $sql = "UPDATE vm50_gravacoes SET id_ligacao='$Id_li',dia='$Dia',hora='$Hora',agente_o='$Agente1',ramal_o='$Ramal1',usuario_o='$Pseudo1',grupopabx_o='$Grupbx1',grupodac_o='$Grudac1',numero='$Numero',tipo='saida',diahora='$Horario' WHERE gravacao='$Nome'";
    }
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  } elsif ($Tipo eq "Transfer&ecirc;ncia-Fazendo chamada externa") {
    $Ramal1 = $Dados[0];
    $Numero = $Dados[1];
    $Dia    = $Dados[2];
    $Hora   = $Dados[3];
    @AAge   = pesquisa_multipla("SELECT login, nome, pseudonimo, grupo FROM vm50_agentes WHERE ramal='$Ramal1' and situacao!='NLogado'");
    @APab   = pesquisa_multipla("SELECT pseudonimo,grupo FROM vm50_ramais WHERE ramal='$Ramal1'");
    if ($AAge[0] ne "E") {
      $Agente1 = $AAge[0].'-'.$AAge[1];
      $Pseudo1 = $AAge[2];
      $Grudac1 = $AAge[3];
    }
    if ($APab[0] ne "E") {
      $Pseudo1 = $APab[0] if ($Pseudo1 eq "");
      $Grupbx1 = pesquisa("SELECT nome FROM vm50_grupos_ramais WHERE id=$APab[1]");
      $Grupbx1 = "" if ($Grupbx1 eq "E");
    }
    $Horario = substr($Dia,4,4).substr($Dia,2,2).substr($Dia,0,2).substr($Hora,0,2).substr($Hora,2,2).substr($Hora,4,2);
    #$Idgrava = pesquisa("SELECT id_ligacao FROM vm50_gravacoes WHERE id_ligacao='$Id_li'");
    $Idgrava = pesquisa("SELECT gravacao FROM vm50_gravacoes WHERE gravacao='$Nome'");
    if ($Idgrava eq "E") {
      $sql = "INSERT INTO vm50_gravacoes (id_ligacao,gravacao,dia,hora,agente_o,ramal_o,usuario_o,grupopabx_o,grupodac_o,numero,tipo,diahora) VALUES ('$Id_li','$Nome','$Dia','$Hora','$Agente1','$Ramal1','$Pseudo1','$Grupbx1','$Grudac1','$Numero','saida','$Horario')";
    } else {
      $sql = "UPDATE vm50_gravacoes SET id_ligacao='$Id_li',dia='$Dia',hora='$Hora',agente_o='$Agente1',ramal_o='$Ramal1',usuario_o='$Pseudo1',grupopabx_o='$Grupbx1',grupodac_o='$Grudac1',numero='$Numero',tipo='saida',diahora='$Horario' WHERE gravacao='$Nome'";
    }
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  } elsif ($Tipo eq "DDR") {
    $Numero  = $Dados[0];
    #$Ramal1 = $Dados[1];
    $Dia     = $Dados[2];
    $Hora    = $Dados[3];
    @AAge    = pesquisa_multipla("SELECT login, nome, pseudonimo, grupo, ramal FROM vm50_agentes WHERE ramal='$Ramal1' and situacao!='NLogado'");
    $AAge[0] = "E" if ($AAge[4] ne "$Ramal1");
    $Ramal1  = pesquisa("SELECT pa FROM vm50_link_ligacao WHERE id_orig='$Id_li'");
    @APab    = pesquisa_multipla("SELECT pseudonimo,grupo FROM vm50_ramais WHERE ramal='$Ramal1'");
    if ($AAge[0] ne "E") {
      $Agente1 = $AAge[0].'-'.$AAge[1];
      $Pseudo1 = $AAge[2];
      $Grudac1 = $AAge[3];
    }
    if ($APab[0] ne "E") {
      $Pseudo1 = $APab[0] if ($Pseudo1 eq "");
      $Grupbx1 = pesquisa("SELECT nome FROM vm50_grupos_ramais WHERE id=$APab[1]");
      $Grupbx1 = "" if ($Grupbx1 eq "E");
    }
    $Horario = substr($Dia,4,4).substr($Dia,2,2).substr($Dia,0,2).substr($Hora,0,2).substr($Hora,2,2).substr($Hora,4,2);
    #$Idgrava = pesquisa("SELECT id_ligacao FROM vm50_gravacoes WHERE id_ligacao='$Id_li'");
    $Idgrava = pesquisa("SELECT gravacao FROM vm50_gravacoes WHERE gravacao='$Nome'");
    if ($Idgrava eq "E") {
      $sql = "INSERT INTO vm50_gravacoes (id_ligacao,gravacao,dia,hora,agente_o,ramal_o,usuario_o,grupopabx_o,grupodac_o,numero,tipo,diahora) VALUES ('$Id_li','$Nome','$Dia','$Hora','$Agente1','$Ramal1','$Pseudo1','$Grupbx1','$Grudac1','$Numero','DDR','$Horario')";
    } else {
      $sql = "UPDATE vm50_gravacoes SET id_ligacao='$Id_li',dia='$Dia',hora='$Hora',agente_o='$Agente1',ramal_o='$Ramal1',usuario_o='$Pseudo1',grupopabx_o='$Grupbx1',grupodac_o='$Grudac1',numero='$Numero',tipo='DDR',diahora='$Horario' WHERE gravacao='$Nome'";
    }
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  } elsif ($Tipo eq "Transfer&ecirc;ncia-DDR") {
    $Numero = $Dados[0];
    #$Ramal1 = $Dados[1];
    $Dia    = $Dados[2];
    $Hora   = $Dados[3];
    @AAge   = pesquisa_multipla("SELECT login, nome, pseudonimo, grupo FROM vm50_agentes WHERE ramal='$Ramal1' and situacao!='NLogado'");
    $Ramal1 = pesquisa("SELECT pa FROM vm50_link_ligacao WHERE id_orig='$Id_li'");
    @APab   = pesquisa_multipla("SELECT pseudonimo,grupo FROM vm50_ramais WHERE ramal='$Ramal1'");
    if ($AAge[0] ne "E") {
      $Agente1 = $AAge[0].'-'.$AAge[1];
      $Pseudo1 = $AAge[2];
      $Grudac1 = $AAge[3];
    }
    if ($APab[0] ne "E") {
      $Pseudo1 = $APab[0] if ($Pseudo1 eq "");
      $Grupbx1 = pesquisa("SELECT nome FROM vm50_grupos_ramais WHERE id=$APab[1]");
      $Grupbx1 = "" if ($Grupbx1 eq "E");
    }
    $Horario = substr($Dia,4,4).substr($Dia,2,2).substr($Dia,0,2).substr($Hora,0,2).substr($Hora,2,2).substr($Hora,4,2);
    #$Idgrava = pesquisa("SELECT id_ligacao FROM vm50_gravacoes WHERE id_ligacao='$Id_li'");
    $Idgrava = pesquisa("SELECT gravacao FROM vm50_gravacoes WHERE gravacao='$Nome'");
    if ($Idgrava eq "E") {
      $sql = "INSERT INTO vm50_gravacoes (id_ligacao,gravacao,dia,hora,agente_o,ramal_o,usuario_o,grupopabx_o,grupodac_o,numero,tipo,diahora) VALUES ('$Id_li','$Nome','$Dia','$Hora','$Agente1','$Ramal1','$Pseudo1','$Grupbx1','$Grudac1','$Numero','DDR','$Horario')";
    } else {
      $sql = "UPDATE vm50_gravacoes SET id_ligacao='$Id_li',dia='$Dia',hora='$Hora',agente_o='$Agente1',ramal_o='$Ramal1',usuario_o='$Pseudo1',grupopabx_o='$Grupbx1',grupodac_o='$Grudac1',numero='$Numero',tipo='DDR',diahora='$Horario' WHERE gravacao='$Nome'";
    }
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  } elsif ($Tipo eq "Fila") {
    $Numero = $Dados[0];
    $Ramal  = $Dados[1];
    $Dia    = $Dados[2];
    $Hora   = $Dados[3];
    #@AAge   = pesquisa_multipla("SELECT login, nome, pseudonimo, grupo FROM vm50_agentes WHERE ramal='$Ramal1' and situacao!='NLogado'");
    @AAge   = pesquisa_multipla("SELECT login, nome, pseudonimo, grupo, ramal, fila FROM vm50_agentes WHERE id_ligacao='$Id_li' and situacao!='NLogado'");
    $Ramal1 = pesquisa("SELECT pa FROM vm50_link_ligacao WHERE id_orig='$Id_li'");
    $Ramal1 = $Ramal if (($Ramal1 eq "") || ($Ramal1 eq "E"));
    @AAge   = pesquisa_multipla("SELECT login, nome, pseudonimo, grupo, ramal, fila FROM vm50_agentes WHERE ramal='$Ramal1' and situacao!='NLogado'") if (($AAge[0] eq "E") && ($Ramal1 ne "") && ($Ramal1 ne "E"));
    if ($AAge[0] ne "E") {
      $Agente1 = $AAge[0].'-'.$AAge[1];
      $Pseudo1 = $AAge[2];
      $Grudac1 = $AAge[3];
      $Ramal1  = $AAge[4] if (($Ramal1 eq "E") || ($Ramal1 eq "") || ($Ramal1 eq "1"));
      $Fila    = $AAge[5];
    }
    @APab = pesquisa_multipla("SELECT pseudonimo,grupo FROM vm50_ramais WHERE ramal='$Ramal1'");
    if ($APab[0] ne "E") {
      $Pseudo1 = $APab[0] if ($Pseudo1 eq "");
      if (($APab[1] ne "") && ($APab[1] ne " ") && ($APab[1] =~ /^\d+$/)) {
        $Grupbx1 = "";
        $Grupbx1 = pesquisa("SELECT nome FROM vm50_grupos_ramais WHERE id=$APab[1]");
      }
      $Grupbx1 = "" if ($Grupbx1 eq "E");
    }
    $Fila = pesquisa("SELECT pseudonimo FROM vm50_filas WHERE UPPER(pseudonimo)=UPPER('$Numero')") if (($Fila eq "") || ($Fila eq "E"));
    $Fila = pesquisa("SELECT fila_original FROM vm50_link_ligacao WHERE id_orig='$APab[1]' OR id_dest='$APab[1]' AND estado!='Desligado'") if (($Fila eq "E") || ($Fila eq ""));
    $Fila = "" if ($Fila eq "E");
    $Horario = substr($Dia,4,4).substr($Dia,2,2).substr($Dia,0,2).substr($Hora,0,2).substr($Hora,2,2).substr($Hora,4,2);
    #$Idgrava = pesquisa("SELECT id_ligacao FROM vm50_gravacoes WHERE id_ligacao='$Id_li'");
    $Idgrava = pesquisa("SELECT gravacao FROM vm50_gravacoes WHERE gravacao='$Nome'");
    if ($Idgrava eq "E") {
      $sql = "INSERT INTO vm50_gravacoes (id_ligacao,gravacao,dia,hora,agente_o,ramal_o,usuario_o,grupopabx_o,grupodac_o,numero,fila,tipo,diahora) VALUES ('$Id_li','$Nome','$Dia','$Hora','$Agente1','$Ramal1','$Pseudo1','$Grupbx1','$Grudac1','$Numero','$Fila', 'fila','$Horario')";
    } else {
      $sql = "UPDATE vm50_gravacoes SET id_ligacao='$Id_li',dia='$Dia',hora='$Hora',agente_o='$Agente1',ramal_o='$Ramal1',usuario_o='$Pseudo1',grupopabx_o='$Grupbx1',grupodac_o='$Grudac1',numero='$Numero',fila='$Fila',tipo='fila',diahora='$Horario' WHERE gravacao='$Nome'";
    }
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  } elsif ($Tipo eq "Transfer&ecirc;ncia-Fila") {
    $Numero = $Dados[0];
    $Dia    = $Dados[2];
    $Hora   = $Dados[3];
    #@AAge   = pesquisa_multipla("SELECT login, nome, pseudonimo, grupo FROM vm50_agentes WHERE ramal='$Ramal1' and situacao!='NLogado'");
    @AAge   = pesquisa_multipla("SELECT login, nome, pseudonimo, grupo, ramal, fila FROM vm50_agentes WHERE id_ligacao='$Id_li' and situacao!='NLogado'");
    $Ramal1 = pesquisa_multipla("SELECT pa FROM vm50_link_ligacao WHERE id_orig='$Id_li'");
    if ($AAge[0] ne "E") {
      $Agente1 = $AAge[0].'-'.$AAge[1];
      $Pseudo1 = $AAge[2];
      $Grudac1 = $AAge[3];
      $Ramal1  = $AAge[4] if (($Ramal1 eq "E") || ($Ramal1 eq "") || ($Ramal1 eq "1"));
      $Fila    = $AAge[5];
    }
    @APab = pesquisa_multipla("SELECT pseudonimo,grupo FROM vm50_ramais WHERE ramal='$Ramal1'");
    if ($APab[0] ne "E") {
      $Pseudo1 = $APab[0] if ($Pseudo1 eq "");
      $Grupbx1 = pesquisa("SELECT nome FROM vm50_grupos_ramais WHERE id=$APab[1]");
      $Grupbx1 = "" if ($Grupbx1 eq "E");
    }
    $Fila = pesquisa("SELECT pseudonimo FROM vm50_filas WHERE UPPER(pseudonimo)=UPPER('$Numero')") if (($Fila eq "") || ($Fila eq "E"));
    $Fila = pesquisa("SELECT fila_original FROM vm50_link_ligacao WHERE id_orig='$APab[1]' OR id_dest='$APab[1]' AND estado!='Desligado'") if (($Fila eq "E") || ($Fila eq ""));
    $Fila = "" if ($Fila eq "E");
    $Horario = substr($Dia,4,4).substr($Dia,2,2).substr($Dia,0,2).substr($Hora,0,2).substr($Hora,2,2).substr($Hora,4,2);
    #$Idgrava = pesquisa("SELECT id_ligacao FROM vm50_gravacoes WHERE id_ligacao='$Id_li'");
    $Idgrava = pesquisa("SELECT gravacao FROM vm50_gravacoes WHERE gravacao='$Nome'");
    if ($Idgrava eq "E") {
      $sql = "INSERT INTO vm50_gravacoes (id_ligacao,gravacao,dia,hora,agente_o,ramal_o,usuario_o,grupopabx_o,grupodac_o,numero,fila,tipo,diahora) VALUES ('$Id_li','$Nome','$Dia','$Hora','$Agente1','$Ramal1','$Pseudo1','$Grupbx1','$Grudac1','$Numero','$Fila', 'fila','$Horario')";
    } else {
      $sql = "UPDATE vm50_gravacoes SET id_ligacao='$Id_li',dia='$Dia',hora='$Hora',agente_o='$Agente1',ramal_o='$Ramal1',usuario_o='$Pseudo1',grupopabx_o='$Grupbx1',grupodac_o='$Grudac1',numero='$Numero',fila='$Fila',tipo='fila',diahora='$Horario' WHERE gravacao='$Nome'";
    }
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  } elsif ($Tipo eq "Consulta") {
    $Ramal1 = $Dados[0];
    $Ramal2 = $Dados[1];
    $Dia    = $Dados[2];
    $Hora   = $Dados[3];
    @AAge   = pesquisa_multipla("SELECT login, nome, pseudonimo, grupo FROM vm50_agentes WHERE ramal='$Ramal1' and situacao!='NLogado'");
    if ($AAge[0] ne "E") {
      $Agente1 = $AAge[0].'-'.$AAge[1];
      $Pseudo1 = $AAge[2];
      $Grudac1 = $AAge[3];
    }
    @AAge   = pesquisa_multipla("SELECT login, nome, pseudonimo, grupo FROM vm50_agentes WHERE ramal='$Ramal2' and situacao!='NLogado'");
    if ($AAge[0] ne "E") {
      $Agente2 = $AAge[0].'-'.$AAge[1];
      $Pseudo2 = $AAge[2];
      $Grudac2 = $AAge[3];
    }
    @APab   = pesquisa_multipla("SELECT pseudonimo,grupo FROM vm50_ramais WHERE ramal='$Ramal1'");
    if ($APab[0] ne "E") {
      $Pseudo1 = $APab[0] if ($Pseudo1 eq "");
      $Grupbx1 = pesquisa("SELECT nome FROM vm50_grupos_ramais WHERE id=$APab[1]");
      $Grupbx1 = "" if ($Grupbx1 eq "E");
    }
    @APab   = pesquisa_multipla("SELECT pseudonimo,grupo FROM vm50_ramais WHERE ramal='$Ramal2'");
    if ($APab[0] ne "E") {
      $Pseudo2 = $APab[0] if ($Pseudo2 eq "");
      $Grupbx2 = pesquisa("SELECT nome FROM vm50_grupos_ramais WHERE id=$APab[1]");
      $Grupbx2 = "" if ($Grupbx2 eq "E");
    }
    $Horario = substr($Dia,4,4).substr($Dia,2,2).substr($Dia,0,2).substr($Hora,0,2).substr($Hora,2,2).substr($Hora,4,2);
    #$Idgrava = pesquisa("SELECT id_ligacao FROM vm50_gravacoes WHERE id_ligacao='$Id_li'");
    $Idgrava = pesquisa("SELECT gravacao FROM vm50_gravacoes WHERE gravacao='$Nome'");
    if ($Idgrava eq "E") {
      $sql = "INSERT INTO vm50_gravacoes (id_ligacao,gravacao,dia,hora,agente_o,ramal_o,usuario_o,grupopabx_o,grupodac_o,agente_d,ramal_d,usuario_d,grupopabx_d,grupodac_d,numero,tipo,diahora) VALUES ('$Id_li','$Nome','$Dia','$Hora','$Agente1','$Ramal1','$Pseudo1','$Grupbx1','$Grudac1','$Agente2','$Ramal2','$Pseudo2','$Grupbx2','$Grudac2','$Numero','interna','$Horario')";
    } else {
      $sql = "UPDATE vm50_gravacoes SET id_ligacao='$Id_li',dia='$Dia',hora='$Hora',agente_o='$Agente1',ramal_o='$Ramal1',usuario_o='$Pseudo1',grupopabx_o='$Grupbx1',grupodac_o='$Grudac1',numero='$Numero',agente_d='$Agente2',ramal_d='$Ramal2',usuario_d='$Pseudo2',grupopabx_d='$Grupbx2',grupodac_d='$Grudac2',tipo='interna',diahora='$Horario' WHERE gravacao='$Nome'";
    }
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
  } elsif ($Tipo eq "Naosei") {
    $Numero = $Dados[0];
    $Ramal  = $Dados[1];
    $Dia    = $Dados[2];
    $Hora   = $Dados[3];
    $Ramal = "" if (eh_ramal($Ramal) eq 0);
    $Ramal1 = pesquisa("SELECT pa FROM vm50_link_ligacao WHERE id_orig='$Id_li'");
    $Ramal1 = $Ramal if (($Ramal1 eq "") || ($Ramal1 eq "E"));
    @AAge   = pesquisa_multipla("SELECT login, nome, pseudonimo, grupo FROM vm50_agentes WHERE ramal='$Ramal1' and situacao!='NLogado'");
    @APab   = pesquisa_multipla("SELECT pseudonimo,grupo FROM vm50_ramais WHERE ramal='$Ramal1'");
    if ($AAge[0] ne "E") {
      $Agente1 = $AAge[0].'-'.$AAge[1];
      $Pseudo1 = $AAge[2];
      $Grudac1 = $AAge[3];
    }
    if ($APab[0] ne "E") {
      $Pseudo1 = $APab[0] if ($Pseudo1 eq "");
      $Grupbx1 = pesquisa("SELECT nome FROM vm50_grupos_ramais WHERE id=$APab[1]");
      $Grupbx1 = "" if ($Grupbx1 eq "E");
    }
    $Horario = substr($Dia,4,4).substr($Dia,2,2).substr($Dia,0,2).substr($Hora,0,2).substr($Hora,2,2).substr($Hora,4,2);
    #$Idgrava = pesquisa("SELECT id_ligacao FROM vm50_gravacoes WHERE id_ligacao='$Id_li'");
    $Idgrava = pesquisa("SELECT gravacao FROM vm50_gravacoes WHERE gravacao='$Nome'");
    if ($Idgrava eq "E") {
      $sql = "INSERT INTO vm50_gravacoes (id_ligacao,gravacao,dia,hora,agente_o,ramal_o,usuario_o,grupopabx_o,grupodac_o,numero,tipo,diahora) VALUES ('$Id_li','$Nome','$Dia','$Hora','$Agente1','$Ramal1','$Pseudo1','$Grupbx1','$Grudac1','$Numero','Transferencia','$Horario')";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
      $sql = "UPDATE vm50_ligacao_id SET numero='$Numero' WHERE id='$Id_li' AND numero!='$Numero' ";
      $Retorno = $dbh->do($sql);
      print "$sql $Retorno\n" if ($opt_debug2);
      grava_log2("$sql $Retorno\n") if ($opt_debug);
    }
  }
  #>>> Problema de falso id nas filas
#  my $AuxT = length($Numero);
#  $Tipo = pesquisa("SELECT tipo FROM vm50_gravacoes WHERE diahora='$Horario' AND substring(gravacao from 1 for $AuxT)='$Numero' AND (tipo!='Transferencia' OR  tipo!='') LIMIT 1 ");
#  if (($Tipo ne "") && ($Tipo ne "E")) {
#    $Fila = pesquisa("SELECT fila FROM vm50_gravacoes WHERE fila>'!' AND diahora='$Horario' AND substring(gravacao from 1 for $AuxT)='$Numero' AND (tipo!='Transferencia' OR  tipo!='') LIMIT 1 ");
#    $sql = "UPDATE vm50_gravacoes SET fila='$Fila',tipo='fila' WHERE diahora='$Horario' AND substring(gravacao from 1 for $AuxT)='$Numero'";
#    $Retorno = $dbh->do($sql);
#    print "$sql $Retorno\n" if ($opt_debug2);
#    grava_log2("$sql $Retorno\n") if ($opt_debug);
#  }
  #<<< Problema de falso id nas filas
}


#registra_para_relatorio(agente,fila,id_ligacao,numero,oque,info1,info2,info3);
sub registra_para_relatorio(@) {
  my $Agente  = $_[0];
  my $Fila    = $_[1];
  my $Id_liga = $_[2];
  my $Numero  = $_[3];
  my $Oque    = $_[4];
  my $Info1   = $_[5];
  my $Info2   = $_[6];
  my $Info3   = $_[7];
  my $Canal   = $_[8];
  my $CanalI  = "";
  my $CanalE  = "";
  my $sql     = "";
  my $AgenteV = $Retorno = "";
  my $Id_ligaAux = $NumeroAux = $TesteTransb = "";
  my @Aux     = "";
  return if (($Agente eq "E") || ($Fila eq "E") || ($Id_liga eq "E") || ($Numero eq "E") || ($Oque eq "E"));
  print "\n>>> registra_para_relatorio 0=$_[0] 1=$_[1] 2=$_[2] 3=$_[3] 4=$_[4] 5=$_[5] 6=$_[6] 7=$_[7] 8=$_[8]\n" if ($opt_debug2);
  grava_log2("\n>>> registra_para_relatorio 0=$_[0] 1=$_[1] 2=$_[2] 3=$_[3] 4=$_[4] 5=$_[5] 6=$_[6] 7=$_[7] 8=$_[8]\n") if ($opt_debug);

  if (testa_fabricante_placa($Canal) gt -1) {
    $CanalE = $Canal;
  } else {
    $CanalI = $Canal;
  }
  $Fila = "" if (($Fila eq "FILA") || ($Fila eq "E"));
  $TesteTransb = pesquisa("SELECT pseudonimo FROM vm50_filas WHERE pseudonimo='$Numero'") if ($Fila eq "");
  if (($Numero eq $TesteTransb) && ($Numero ne "")) {
    $Fila   = $Numero;
    $Numero = "";
  }
  #>>> So cadastrada pelo id de origem para evitar problemas
  $Id_ligaAux = pesquisa( "SELECT id_orig FROM vm50_link_ligacao WHERE id_dest = '$Id_liga'" ) if (($Id_liga ne "") && ($Id_liga ne "E"));
  $Id_liga    = $Id_ligaAux if (($Id_ligaAux ne "E") && ($Id_ligaAux ne ""));
  $NumeroAux  = pesquisa( "SELECT numero FROM vm50_ligacao_id WHERE id = '$Id_liga'" ) if (($Id_liga ne "") && ($Id_liga ne "E") && (($Numero eq "NULL") || ($Numero eq "") || ($Numero eq "E")));
  $Numero     = $NumeroAux if (($NumeroAux ne "E") && ($NumeroAux ne ""));
  #<<< So cadastrada pelo id de origem para evitar problemas
  if (substr($Fila,0,20) eq "Transfer&ecirc;ncia-") {
#    @Aux = pesquisa_multipla("SELECT * FROM vm50_relatorios_cc WHERE ligacao='$Id_liga' ORDER BY diahora DESC LIMIT 1");
    @Aux = pesquisa_multipla("SELECT * FROM vm50_relatorios_cc_hoje WHERE ligacao='$Id_liga' ORDER BY diahora DESC LIMIT 1");
    $Aux[2] = "" unless defined $Aux[2];
    $AgenteV = substr($Aux[2],0,4);
    $Aux[3] = "" unless defined $Aux[3];
    $Aux[4] = "" unless defined $Aux[4];
    $Aux[6] = "" unless defined $Aux[6];
    if ( ($Agente ne "") && !(($AgenteV eq $Agente) && ($Id_liga eq $Aux[4])) ) {
      if ( !(($Fila eq $Aux[3]) && ($Id_liga eq $Aux[4]) && ($Oque eq $Aux[6])) ) {
        grava_log2("-$AgenteV-$Agente-$Aux[2]- -$Id_liga-$Aux[4]- -$Fila-$Aux[3]- -$Oque-$Aux[6]- \n") if ($opt_debug);
        $sql = "INSERT INTO vm50_relatorios_cc (diahora, agente, fila, ligacao, numero, oque, canalext, canalint) VALUES (CURRENT_TIMESTAMP,'$AgenteV','$Fila','$Id_liga','$Aux[2]','$Oque','$CanalE','$CanalI')";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
        my $Pausin = pesquisa("SELECT pausa FROM vm50_agentes WHERE login='$AgenteV'");
        my $Sittu  = "Livre";
        $Sittu  = "Em Pausa" if ($Pausin);
        $sql = "INSERT INTO vm50_relatorios_cc (diahora, agente, fila, ligacao, numero, oque, canalext, canalint) VALUES (CURRENT_TIMESTAMP,'$AgenteV','','','','$Sittu','$CanalE','$CanalI')";
        $Retorno = $dbh->do($sql);
        print "$sql $Retorno\n" if ($opt_debug2);
        grava_log2("$sql $Retorno\n") if ($opt_debug);
      }
    }
  } elsif ($Fila eq "Fazendo chamada externa") {
    #>>> Resolve chamadas externas inexistentes
    my $ArqGrav = pesquisa("SELECT gravacao_nova FROM vm50_link_ligacao WHERE id_orig='$Id_liga' OR  id_dest='$Id_liga'");
    if (($ArqGrav ne "") && ($ArqGrav ne "E")) {
      return if (substr($ArqGrav,0,1) ne "/");
    }
    #<<< Resolve chamadas externas inexistentes
    my $AuxRamal = pesquisa("SELECT numero_orig FROM vm50_link_ligacao WHERE id_orig='$Id_liga' OR  id_dest='$Id_liga'");
    if (($AuxRamal ne "E") && ($AuxRamal ne "")) {
      $AgenteV = pesquisa("SELECT login FROM vm50_agentes WHERE ramal='$AuxRamal'");
      $Agente = $AgenteV if (($AgenteV ne "E") && ($AgenteV ne ""));
    }
  }
  ### Transbordo, marcar a fila original >>>
  my $Transb = pesquisa( "SELECT fila_original FROM vm50_link_ligacao WHERE id_orig = '$Id_liga'" );
  print ">>>r1 Transb=$Transb. Numero=$Numero. Fila=$Fila. \n" if ($opt_debug2);
  grava_log2(">>>r1 Transb=$Transb. Numero=$Numero. Fila=$Fila. \n") if ($opt_debug);
  if (($Transb ne 'E') && ($Transb ne '')) {
    $TesteTransb = pesquisa("SELECT pseudonimo FROM vm50_filas WHERE pseudonimo='$Transb'");
    $Numero = $Transb if ($TesteTransb ne $Transb);
    $Fila   = $Transb if (($TesteTransb eq $Transb) && (($Fila eq 'E') || ($Fila eq '') || ($Fila eq 'NULL')));
    print ">>>r2 Transb=$Transb. Numero=$Numero. Fila=$Fila. \n" if ($opt_debug2);
    grava_log2(">>>r2 Transb=$Transb. Numero=$Numero. Fila=$Fila. \n") if ($opt_debug);
  }
  ### <<< Transbordo, marcar a fila original
  $sql = "INSERT INTO vm50_relatorios_cc (diahora, agente, fila, ligacao, numero, oque, canalext, canalint) VALUES (CURRENT_TIMESTAMP,'$Agente','$Fila','$Id_liga','$Numero','$Oque','$CanalE','$CanalI')";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
}

#registra_para_relatorio_pbx(ligacao_origem,numero_origem,canal_origem,ligacao_destino,numero_destino,canal_destino,oque);
sub registra_para_relatorio_pbx(@) {
  my $Id_o = $_[0];
  my $Nu_o = $_[1];
  my $Ca_o = $_[2];
  my $Id_d = ""; $Id_d = $_[3];
  my $Nu_d = ""; $Nu_d = $_[4];
  my $Ca_d = $_[5];
  my $Oque = $_[6];
  my $Dire = "I";
  my @Aux  = "";
  my $Aux2 = "";
  my $Nada = $Retorno = "";
  my $sql = "";
  grava_log2(">>>registra_para_relatorio_pbx $_[0] $_[1] $_[2] $_[3] $_[4] $_[5] $_[6]\n") if (($opt_debug) && (exists $_[6]));
  $Id_o = "" if ($Id_o eq "NULL");
  $Nu_o = "" if ($Nu_o eq "NULL");
  $Ca_o = "" if ($Ca_o eq "NULL");
  $Id_d = "" if ($Id_d eq "NULL");
  $Nu_d = "" if ($Nu_d eq "NULL");
  $Ca_d = "" if ($Ca_d eq "NULL");
  $Oque = "" if ($Oque eq "NULL");
  return if (($Id_o eq "E") || ($Nu_o eq "E") || ($Ca_o eq "E") || ($Id_d eq "E") || ($Nu_d eq "E") || ($Ca_d eq "E") || ($Oque eq "E"));
  return if ((substr($Ca_o,0,5) eq "Agent") || (substr($Ca_d,0,5) eq "Agent"));
  return if (substr($Oque,0,15) eq "MARCA GRAVACAO-");
  return if ($Nu_o eq "<unknown>");
  #>>> Grava o canal de maneira correta, corrige o problema de canais SIP
  #@Aux  = split("-", $Ca_o);
  #$Ca_o = $Aux[0] if ($Aux[0] ne "");
  #@Aux  = split("-", $Ca_d);
  #$Ca_d = $Aux[0] if ($Aux[0] ne "");
  #<<< Grava o canal de maneira correta, corrige o problema de canais SIP
  $Nu_d = $Oque if (substr($Oque,0,4) eq "FILA");
  if (substr($Nu_d,0,11) eq "Transfered/") {
    $Nada = substr($Nu_d,11);
    @Aux  = split("<", $Nada);
    $Nu_d = $Aux[0];
  }
  if (substr($Nu_o,0,11) eq "Transfered/") {
    $Nada = substr($Nu_o,11);
    @Aux  = split("<", $Nada);
    $Nu_o = $Aux[0];
  }
  if ($Oque eq "CAIXA_POSTAL") {
    $Oque = 'Caixa Postal';
  } elsif (($Oque eq "MSG_ATENDIMENTO") || ($Oque eq "COMECA COM MENSAGEM")) {
    $Oque = 'Mensagem de atendimento';
  } elsif (($Oque eq "Bloqueado") || ($Oque eq "Livre")) {
    $sql = "INSERT INTO vm50_relatorios_pbx (diahora, canal_o, oque, direcao, ligaca_o, numero_o, ligaca_d, numero_d, canal_d) VALUES (CURRENT_TIMESTAMP,'$Ca_o','$Oque','','','','','','')";
    $Retorno = $dbh->do($sql);
    print "$sql $Retorno\n" if ($opt_debug2);
    grava_log2("$sql $Retorno\n") if ($opt_debug);
    return;
  } elsif (($Oque ne "Desligado") && ($Oque ne "Em conversa&ccedil;&atilde;o")) {
    $Oque = "";
  }
  if ($Id_o ne "") {
    @Aux = pesquisa_multipla( "SELECT * FROM vm50_ligacao_id WHERE id='$Id_o'" );
    @Aux = ("","") if (!(exists($Aux[2])));
    grava_log2("  SELECT * FROM vm50_ligacao_id WHERE id='$Id_o' -> $Aux[1] $Aux[2]\n") if (($opt_debug) && (exists $Aux[2]));
    $Nu_o = $Aux[1] if (($Nu_o eq "") && (exists $Aux[1]));
    $Ca_o = $Aux[2] if (($Ca_o eq "") && (exists $Aux[2]));
    $Aux2 = pesquisa( "SELECT estado FROM vm50_link_ligacao WHERE id_orig='$Id_o'" );
    if ($Aux2 ne "E") {
      $Oque = $Aux2 if ($Oque eq "");
      @Aux = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Id_o'" );
      grava_log2("  SELECT * FROM vm50_link_ligacao WHERE id_orig='$Id_o' -> $Aux[2] $Aux[3] $Aux[4]\n") if (($opt_debug) && (exists $Aux[2]));
      $Id_d = $Aux[2] if (($Id_d eq "") && (exists $Aux[2]));
      $Nu_d = $Aux[4] if (($Nu_d eq "") && (exists $Aux[4]));
      $Nu_d = $Aux[3] if (($Nu_d eq "") && (exists $Aux[3]));
    } else {
      $Aux2 = pesquisa( "SELECT estado FROM vm50_link_ligacao WHERE id_dest='$Id_o'" );
      if ($Aux2 ne "E") {
        $Oque = $Aux2 if ($Oque eq "");
        @Aux = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_dest='$Id_o'" );
        grava_log2("  SELECT * FROM vm50_link_ligacao WHERE id_orig='$Id_o' -> $Aux[2] $Aux[3] $Aux[4]\n") if (($opt_debug) && (exists $Aux[2]));
        $Id_o = $Id_d;
        $Nu_o = $Nu_d;
        $Aux2 = $Ca_d; $Ca_d = $Ca_o; $Ca_o = $Aux2;
        $Id_d = $Aux[2] if (($Id_d eq "") && (exists $Aux[2]));
        $Nu_d = $Aux[4] if (($Nu_d eq "") && (exists $Aux[4]));
        $Nu_d = $Aux[3] if (($Nu_d eq "") && (exists $Aux[3]));
      }
    }
    if (($Nu_d eq "") || ($Nu_d eq "E")) {
      $Nu_d = pesquisa( "SELECT falandocom FROM vm50_ramais WHERE ramal='$Nu_o'" );
      $Nu_d = "" if ($Nu_d eq "E");
    }
  } elsif ($Ca_o ne "") {
    @Aux = pesquisa_multipla( "SELECT * FROM vm50_ligacao_id WHERE canal='$Ca_o' ORDER BY id DESC LIMIT 1" );
    grava_log2("  SELECT * FROM vm50_ligacao_id WHERE canal='$Ca_o' ORDER BY id DESC LIMIT 1 -> $Aux[0] $Aux[1]\n") if ($opt_debug);
    $Id_o = $Aux[0] if (($Id_o eq "") && (exists $Aux[0]));
    $Nu_o = $Aux[1] if (($Nu_o eq "") && (exists $Aux[1]));
    $Aux2 = pesquisa( "SELECT estado FROM vm50_link_ligacao WHERE id_orig='$Id_o'" );
    if ($Aux2 ne "E") {
      $Oque = $Aux2 if ($Oque eq "");
      @Aux = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_orig='$Id_o'" );
      grava_log2("  SELECT * FROM vm50_link_ligacao WHERE id_orig='$Id_o' -> $Aux[2] $Aux[3] $Aux[4]\n") if ($opt_debug);
      $Id_d = $Aux[3] if (($Id_d eq "") && (exists $Aux[3]));
      $Nu_d = $Aux[4] if (($Nu_d eq "") && (exists $Aux[4]));
      $Nu_o = $Aux[2] if (($Nu_o eq "") && (exists $Aux[2]));
    } else {
      $Aux2 = pesquisa( "SELECT estado FROM vm50_link_ligacao WHERE id_dest='$Id_o'" );
      if ($Aux2 ne "E") {
        $Oque = $Aux2 if ($Oque eq "");
        @Aux = pesquisa_multipla( "SELECT * FROM vm50_link_ligacao WHERE id_dest='$Id_o'" );
        grava_log2("  SELECT * FROM vm50_link_ligacao WHERE id_orig='$Id_o' -> $Aux[2] $Aux[3] $Aux[4]\n") if ($opt_debug);
        $Id_o = $Id_d;
        $Nu_o = $Nu_d;
        $Aux2 = $Ca_d; $Ca_d = $Ca_o; $Ca_o = $Aux2;
        $Id_d = $Aux[2] if (($Id_d eq "") && (exists $Aux[2]));
        $Nu_d = $Aux[4] if (($Nu_d eq "") && (exists $Aux[4]));
        $Nu_d = $Aux[3] if (($Nu_d eq "") && (exists $Aux[3]));
      }
    }
    if (($Nu_d eq "") || ($Nu_d eq "E")) {
      $Nu_d = pesquisa( "SELECT falandocom FROM vm50_ramais WHERE ramal='$Nu_o'" );
      $Nu_d = "" if ($Nu_d eq "E");
    }
  }
  if ($Id_d ne "") {
    @Aux = pesquisa_multipla( "SELECT * FROM vm50_ligacao_id WHERE id='$Id_d'" );
    if (exists $Aux[1]) {
      grava_log2("  SELECT * FROM vm50_ligacao_id WHERE id='$Id_d' -> $Aux[1] $Aux[2]\n") if ($opt_debug);
    }
    $Nu_d = $Aux[1] if (($Nu_d eq "") && (exists $Aux[1]));
    $Ca_d = $Aux[2] if (($Ca_d eq "") && (exists $Aux[2]));
    $Aux2 = pesquisa( "SELECT estado FROM vm50_link_ligacao WHERE id_dest='$Id_d'" );
    if ($Aux2 ne "E") {
      $Oque = $Aux2 if ($Oque eq "");
    }
  } elsif ($Ca_d ne "") {
    @Aux = pesquisa_multipla( "SELECT * FROM vm50_ligacao_id WHERE canal='$Ca_d' ORDER BY id DESC LIMIT 1" );
    if (exists $Aux[1]) {
      grava_log2("  SELECT * FROM vm50_ligacao_id WHERE canal='$Ca_d' ORDER BY id DESC LIMIT 1 -> $Aux[0] $Aux[1]\n") if ($opt_debug);
    }
    $Id_d = $Aux[0] if (($Id_d eq "") && (exists $Aux[0]));
    $Nu_d = $Aux[1] if (($Nu_d eq "") && (exists $Aux[1]));
    $Aux2 = pesquisa( "SELECT estado FROM vm50_link_ligacao WHERE id_dest='$Id_d'" );
    if ($Aux2 ne "E") {
      $Oque = $Aux2 if ($Oque eq "");
    }
  }
  if (testa_fabricante_placa($Ca_o) gt -1) {
    $Dire = "I";
  } elsif (testa_fabricante_placa($Ca_d) gt -1) {
    $Dire = "O";
  } elsif (testa_fabricante_placa_ip($Ca_o) gt -1) {
    $Dire = "I";
  } elsif (testa_fabricante_placa_ip($Ca_d) gt -1) {
    $Dire = "O";
  }
  if ($Dire eq "I") {
    @Aux = pesquisa_multipla( "SELECT * FROM vm50_troncos WHERE numero_asterisk='$Ca_o'" );
    if (exists $Aux[12]) {
      grava_log2("  SELECT * FROM vm50_troncos WHERE numero_asterisk='$Ca_o' -> $Aux[12] $Aux[13] $Aux[14] $Aux[15]\n") if ($opt_debug);
    }
    $Id_o = $Aux[12] if (($Id_o eq "") && (exists $Aux[12]));
    $Nu_o = $Aux[13] if (($Nu_o eq "") && (exists $Aux[13]));
    $Id_d = $Aux[14] if (($Id_d eq "") && (exists $Aux[14]));
    $Nu_d = $Aux[15] if (($Nu_d eq "") && (exists $Aux[15]));
  } elsif ($Dire eq "O") {
    @Aux = pesquisa_multipla( "SELECT * FROM vm50_troncos WHERE numero_asterisk='$Ca_d'" ) if ($Dire eq "O");
    grava_log2("  SELECT * FROM vm50_troncos WHERE numero_asterisk='$Ca_d' -> $Aux[12] $Aux[13] $Aux[14] $Aux[15]\n") if ($opt_debug);
    $Id_d = $Aux[12] if (($Id_d eq "") && (exists $Aux[12]));;
    $Nu_d = $Aux[13] if (($Nu_d eq "") && (exists $Aux[13]));;
    $Id_o = $Aux[14] if (($Id_o eq "") && (exists $Aux[14]));;
    $Nu_o = $Aux[15] if (($Nu_o eq "") && (exists $Aux[15]));;
  }
  $Id_o = "" if ($Id_o eq "E");
  $Nu_o = "" if ($Nu_o eq "E");
  $Ca_o = "" if ($Ca_o eq "E");
  $Id_d = "" if ($Id_d eq "E");
  $Nu_d = "" if ($Nu_d eq "E");
  $Ca_d = "" if ($Ca_d eq "E");
  $Oque = "" if ($Oque eq "E");
  #return if (length($Oque) gt 50);
  return if ((substr($Ca_o,0,5) eq "Local") || (substr($Ca_d,0,5) eq "Local"));
  $sql = "INSERT INTO vm50_relatorios_pbx (diahora, ligaca_o, numero_o, canal_o , ligaca_d, numero_d, canal_d, oque, direcao) VALUES (CURRENT_TIMESTAMP,'$Id_o','$Nu_o','$Ca_o','$Id_d','$Nu_d','$Ca_d','$Oque','$Dire')";
  $Retorno = $dbh->do($sql);
  print "$sql $Retorno\n" if ($opt_debug2);
  grava_log2("$sql $Retorno\n") if ($opt_debug);
}


##########
sub pesquisa($) {
#	my ($sqlp) = @_;
  my $sqlp = $_[0];
	my $res = "E";
	my $sth = $dbh->prepare($sqlp) or return "E";
	$sth->execute() or return "E";
	my $Contar = 0;
	my @data = "";
  while (@data = $sth->fetchrow_array()) {
   	$res = $data[0];       
    $Contar = $Contar + 1;
  }
  $res = "E" unless defined $res;
  $sth->finish;
  $res = "E" if ($Contar gt 1);
  $res =~ s/^\s+//;    #Remove espacos antes
  $res =~ s/\s+$//;    #Remove espacos depois
  print "$sqlp -> $res\n" if ($opt_debug2);
  grava_log2("$sqlp -> $res\n") if ($opt_debug);
	return $res;
}

##########
sub pesquisa_multipla($) {
  my $sqlp  = $_[0];
	#my @res   = "";
	#my $Total = "";
	#my $k = 0;
  #my $Vazio = 0;
	my $sth = $dbh->prepare($sqlp) or return "E";
	$sth->execute();
  my @res = $sth->fetchrow_array();
  my $Total = @res;
  my $k = $sth->{NUM_OF_FIELDS};
  if ($Total ne $k) {
   grava_log2("$sqlp -> E1-$Total-$k\n") if ($opt_debug);  
   $sth->finish;
   return "E";
  }
  my $Vazio = 1;
  for (my $i=0; $i<$Total; $i++) {
    if ($res[$i]) {
      $res[$i] =~ s/^\s+//;    #Remove espacos antes
      $res[$i] =~ s/\s+$//;    #Remove espacos depois
      $Vazio = 0 if ($res[$i] ne "");
    } else {
      $Vazio = 0;
    }
  }
  if ($Vazio eq 1) {
   grava_log2("$sqlp -> E2\n") if ($opt_debug);  
   $sth->finish;
   return "E";
  }
  if (@res) {
    $res[0] = "" unless defined $res[0];
    print "$sqlp -> @res\n" if ($opt_debug2);
    $Total = "" unless defined $Total;
    $k     = "" unless defined $k;
    $sqlp  = "" unless defined $sqlp;
#    grava_log2("$sqlp -> -@res-$k-$Total\n") if ($opt_debug);
  } else {
    print "$sqlp -> --\n" if ($opt_debug2);
    grava_log2("$sqlp -> --\n") if ($opt_debug);
  }
	return @res;
}


##########
sub pesquisa_varias_linhas($) {
  my $sqlp     = $_[0];
	my @res      = ();
	my @Linha    = "";
	my $sth = $dbh->prepare($sqlp) or return "E";
	$sth->execute();
  while (@Linha = $sth->fetchrow_array) {
      push(@res, "$Linha[0]") if (length(trim($Linha[0])) gt 0);
  }
	return @res;
}
