#!/usr/bin/perl -w
#

use DBI;
use IO::File;
use IO::Socket;
use POSIX qw(setsid);
use File::Spec::Functions qw(canonpath);
use File::Basename;


################################
## Le arquivo de configuracao ##
################################
my $Diretorio_Config = `pwd`;
chomp($Diretorio_Config);
my $Arquivo_Atual = canonpath($0);
my @Aux_Caminho = split(/\//, $Arquivo_Atual);
my $Aux_CaminhoT = @Aux_Caminho;
for (my $i=0; $i<$Aux_CaminhoT-1; $i++) {
    $Diretorio_Config = $Diretorio_Config."/".$Aux_Caminho[$i];
}
$Diretorio_Config = $Diretorio_Config."/";
my $Arquivo_Config = $Diretorio_Config."config.php";
open(ACONF, $Arquivo_Config) || die("Could not open file!");
my @Dados_Brutos=<ACONF>;
close(ACONF);

######################
## Monta o PID 1185 ##
######################
chdir '/'                 or die "Can't chdir to /: $!";
umask 0;
open STDIN, '/dev/null'   or die "Can't read /dev/null: $!";
open STDERR, '>>/var/log/asterisk/vdthintserror.log' or die "Can't write to /dev/null: $!";
#open STDERR, '>>/var/log/asterisk/vdtamp.log' or die "Can't write to /dev/null: $!";
defined(my $pid = fork)   or die "Can't fork: $!";
open PS_F, "ps -C vdt_hints.pl -o pid|";
my $despreza = <PS_F>;
my $pidid = <PS_F>;
$pidid = $pidid + 1;
close(PS_F);
if ( open PID, '>/var/run/vdt_hints.pid' ) {
    print PID "$pidid\n";
    close(PID);
}
exit if $pid;


################################
## Le arquivo de configuracao ##
################################
my $Astman_H = "Erro";
my $Astman_P = "Erro";
foreach my $Linha (@Dados_Brutos) {
    chomp($Linha);
    if ($Linha =~ m/=/) {
        (my $Campo,my $Valor)=split(/=/,$Linha);
        $Campo =~ s/ //gi;
        $Campo = substr($Campo,1);
        $Valor =~ s/"//gi;  #"
        $Valor =~ s/;//gi;
        $Valor =~ s/ //gi;
        if ($Valor =~ m/\//) {
            (my $Aux1,my $Aux2)=split(/\//,$Valor);
            $Valor = $Aux1;
        }
        if ($Campo eq "Host") {
            $Astman_H = $Valor;
        } elsif ($Campo eq "Porta") {
            $Astman_P = $Valor;
        }
        #print $Campo."=>".$Valor."\n";
    }
}

#open STDOUT, '>>/var/log/asterisk/vdthintserror.log' or die "Can't write to /dev/null: $!";

############################
## Definicao de variaveis ##
############################
sub le_meia($);
sub grava_log($);
sub grava_events($);
sub limpa_xml($);
sub pesquisa_varias_linhas($);
sub trim($);
sub separa_dois_pontos($);
sub analisa_entrada(@);

sub le_agentes();
sub tratar_login(@);
sub tratar_logoff(@);
sub tratar_extension_status(@);
sub capturarAgente($);


my $opt_debug    = 0;#1
my $opt_events   = 0;
my $db_type      = "PgPP";
my $db_port      = "5432";
my $db_host      = "localhost";
my $db_user_name = "postgres";
my $db_password  = "";
my $db_database  = "vdt";
my $dbh  = DBI->connect("dbi:PgPP:dbname=$db_database", $db_user_name, $db_password, {AutoCommit => 1});
$dbh->trace($dbh->parse_trace_flag('SQL'));
my $sock = new IO::Socket::INET (PeerAddr  => $Astman_H, PeerPort  => $Astman_P, Proto => 'tcp',);
print "Could not create socket: $!\n" unless $sock;
$sock->autoflush(1);


###############
## Le o Sock ##
###############
my($Buf, @Linha);
my $Bloco = 0;
my %agents;

le_agentes();

@Linha = ();
while (1) {
    $Buf = le_meia(<$sock>);
    if (($Buf eq "</AsteriskManagerOutput>") || ($Buf eq "<AsteriskManagerOutput>")) {
        analisa_entrada(@Linha);
        @Linha = ();
    } else {
        $Buf = limpa_xml($Buf);
        push @Linha, $Buf;
    }
    $sock->flush;
}
close $sock;


######################
## Le o Astmanproxy ##
######################
sub analisa_entrada(@) {
    my $Bandeira = 1;
    my $Buf = "";
    my $Saida = "";

    while ($Bandeira) {
        $Buf = $_[0];

        grava_events($Buf) if($opt_events);
        $Bandeira = 0;
        $Buf = "" unless defined $Buf;

        #Alguem logou na fila com callbacklogin
        if ($Buf eq "Event: Agentcallbacklogin"){
            tratar_login(@_);
        }
        #Alguem logou na fila com agentlogin
        elsif ($Buf eq "Event: Agentlogin"){
            tratar_login(@_);
        }
        #Algum agente deslogou
        elsif($Buf eq "Event: Agentcallbacklogoff"){
            tratar_logoff(@_);
        }
        #Capturei um extension state
        elsif($Buf eq "Event: ExtensionStatus"){
            tratar_extension_status(@_);
        }
        #Leia novamente
        elsif (scalar @_ ne 0) {
            $Bandeira = 1;
        }

        shift(@_);
    }
}


########################
## Funcoes Auxiliares ##
########################
sub le_meia($) {
    my $Linha = shift;
    $Linha =~ s/[\r]//g;   #Remove /r
    $Linha =~ s/[\n]//g;   #Remove /n
    $Linha =~ s/^\s+//;    #Remove espacos antes
    $Linha =~ s/\s+$//;    #Remove espacos depois
    return $Linha;
}

sub limpa_xml($) {
    my $Linha = shift;
    $Linha =~ s/<//g;         #Remove <
    $Linha =~ s/>//g;         #Remove >
    $Linha =~ s/\"//g;        #Remove "
    $Linha =~ s/\/$//;        #Remove / no fim
    $Linha =~ s/^\///;        #Remove / no comeco
    $Linha =~ s/&lt;/</g;     #Coloca < no lugar
    $Linha =~ s/&gt;/>/g;     #Coloca > no lugar
    $Linha =~ s/&quot;/\"/g;  #Coloca " no lugar
    my @Aux = split(/ Value=/, $Linha);
    if (exists($Aux[0])) {
        if (exists($Aux[1])) {
            if ($Aux[0] eq "UnparsedText") {
                $Linha = $Aux[1];
            } else {
                $Linha = $Aux[0] . ": " . $Aux[1];
            }
        } else {
            $Linha = $Aux[0];
        }
        $Linha = le_meia($Linha);
    }
    return $Linha;
}

sub grava_log($) {
    if ( open(LOG, ">> /var/log/asterisk/vdthints.log") ) {
        print LOG $_[0]."\n";
        close(LOG);
    } else {
        warn "Couldn't log to /var/log/vdthints.log: $!\n";
    }
}

sub grava_events($){
    if(!$_) {
        return;
    }
    if(open(LOG, ">> /var/log/asterisk/vdthintsreal.log")) {
        print LOG "$_[0]\n";
        close(LOG);
    } else {
        warn "Couldn't log to /var/log/vdthintsreal.log: $!\n";
    }
}

sub pesquisa_varias_linhas($) {
    my $sqlp     = $_[0];
    my @res      = ();
    my @line     = ();
    my @Linha    = "";
    my $x = 0;
    my $sth = $dbh->prepare($sqlp) or return "E";
    $sth->execute();
    my $numOfFields = $sth->{NUM_OF_FIELDS};
    while (@Linha = $sth->fetchrow_array) {
        @line = ();
        for (my $i=0; $i < $numOfFields; $i++) {
            $res[$x][$i] = $Linha[$i];
        }
        $x++;
    }
    return @res;
}

sub pesquisa($) {
    my $sqlp = $_[0];
    my $res = "E";
    my $sth = $dbh->prepare($sqlp) or return "E";
    $sth->execute() or return "E";
    my $Contar = 0;
    my @data = "";

    while (@data = $sth->fetchrow_array()) {
        $res = $data[0];       
        $Contar = $Contar + 1;
    }
    
    $res = "E" unless defined $res;
    $sth->finish;
    $res = "E" if ($Contar gt 1);
    $res =~ s/^\s+//;    #Remove espacos antes
    $res =~ s/\s+$//;    #Remove espacos depois
    
    return $res;
}

sub trim($) {
    my $string = shift;
    $string =~ s/^\s+//;
    $string =~ s/\s+$//;
    return $string;
}

sub separa_dois_pontos($) {
    my @Pecas = split(/: /, $_[0]);
    my @Saida = "";
    if (exists($Pecas[0])) {
        @Saida = ();
        for my $Elem (@Pecas) {
            push @Saida, le_meia($Elem);
        }
    } else {
        @Saida = @Pecas;
    }
    return @Saida;
}


####################
# Funções
####################
sub le_agentes(){
    grava_log("\nCapturando agentes logados na carga...") if($opt_debug);
    my $sql = "SELECT login, ramal FROM vm50_agentes WHERE situacao != 'NLogado'";
    my @resultado = pesquisa_varias_linhas($sql);

    for(my $i = 0; $i < scalar(@resultado); $i++){
        $agents{$resultado[$i][0]} = $resultado[$i][1];
    }
    #debug agents
    for my $agent (keys %agents){
        grava_log("Agent $agent => $agents{$agent}") if($opt_debug);
    }
}

sub tratar_login(@){
    my $Linha = "";
    my $agente = "";
    my $ramal = "";
    my @aux = ();
    grava_log("\n");

    for $Linha (@_) {
        grava_log(">>> $Linha") if($opt_debug);
        @Aux = separa_dois_pontos($Linha);
        
        if ($Aux[0] eq "Agent") {
            $agente = $Aux[1];   
        } elsif ($Aux[0] eq "Loginchan") {
            @aux = split(/@/, $Aux[1]);
            $ramal = $aux[0];
        }
    }
    grava_log("Agente $ agente logando no ramal $ramal") if($opt_debug);

    $agents{$agente} = $ramal;
    grava_log("Agente $agente adicionado no hashmap de agentes...") if($opt_debug);
}

sub tratar_logoff(@){
    my $agente = "";
    my $Linha = "";
    grava_log("\n");

    for $Linha (@_) {
        grava_log(">>> $Linha") if($opt_debug);
        @Aux = separa_dois_pontos($Linha);
        
        if ($Aux[0] eq "Agent") {
            $agente = $Aux[1];   
        }
    }
    grava_log("Agente $agente deslogou!") if($opt_debug);

    if(defined $agents{$agente}){
        delete $agents{$agente};
        grava_log("Agente $agente removido do hashmap de agentes...") if($opt_debug);
    }
}

sub tratar_extension_status(@){
    my $Linha = $Extensao = $Contexto = $Status = "";
    grava_log("\n");

    for $Linha (@_) {
        grava_log(">>> $Linha") if($opt_debug);
        @Aux = separa_dois_pontos($Linha);

        if ($Aux[0] eq "Exten") {
            $Extensao = $Aux[1];
        } elsif ($Aux[0] eq "Context") {
            $Contexto = $Aux[1];
        } elsif ($Aux[0] eq "Status") {
            $Status = $Aux[1];
        }
    }

    my $agente = capturarAgente($Extensao);

    if($agente ne 0){
        grava_log("\nAgente encontrado: $agente") if($opt_debug);

        #Status = 1 - In Use ou Status = 2 - Busy ou Status = 16 - On Hold
        if(($Status eq "1") || ($Status eq "2") || ($Status eq "16")){
            print $sock "Action: QueuePause\r\nInterface: Agent/$agente\r\nPaused: true\r\n\r\n";
            grava_log("Agente paused: $agente\n") if($opt_debug);
        }
        #Status = 0 - Idle ou Status = 4 - Unavailable
        elsif(($Status eq "0") || ($Status eq "4")){
            my $sql = "SELECT situacao FROM vm50_agentes WHERE login LIKE '$agente'";
            my $situacao = pesquisa($sql);
            grava_log("$sql => $situacao") if($opt_debug);

            if($situacao eq "Em Pausa"){
                print $sock "Action: QueuePause\r\nInterface: Agent/$agente\r\nPaused: true\r\n\r\n";
                grava_log("Agent paused: $agente\n") if($opt_debug);
            } else {
                print $sock "Action: QueuePause\r\nInterface: Agent/$agente\r\nPaused: false\r\n\r\n";
                grava_log("Agent unpaused: $agente\n") if ($opt_debug);

                $sql = "UPDATE vm50_agentes SET situacao = 'Livre', falandocom = '', fila = '', ult_estad = CURRENT_TIMESTAMP WHERE login LIKE '$agente'";
                my $retorno = $dbh->do($sql);
                grava_log("$sql $retorno\n") if($opt_debug);

                #Registra para relatório
                $sql = "INSERT INTO vm50_relatorios_cc (diahora, agente, fila, ligacao, numero, oque, canalext, canalint) VALUES (CURRENT_TIMESTAMP,'$agente','','','','Livre','','')";
                $retorno = $dbh->do($sql);
                grava_log("$sql $retorno\n") if($opt_debug);
            }
        }
    }
}

sub capturarAgente($){
    my $ramal = $_[0];
    my $agente = 0;

    grava_log("\nTentando capturar o ramal $ramal na lista de agentes logados...") if($opt_debug);;

    for my $agent (keys %agents){
        grava_log("Verificando o agente $agent no ramal $agents{$agent}") if($opt_debug);
        if(trim($agents{$agent}) eq trim($ramal)){
            grava_log("O ramal $ramal está logado no agente $agent") if($opt_debug);
            $agente = $agent;
        }
    }

    return $agente;
}