//Libraries
var _uuid = require('node-uuid');
var WebSocketServer = require('ws').Server;

//Modules
var settings = require(__dirname + '/settings.js');
var AmiHandler = require(__dirname + '/model/AmiHandler');
var amiHandler = new AmiHandler();

//Connect to Asterisk Manager Interface (AMI)
var ami = new require('asterisk-manager')(
    settings.asterisk.ami.port,
    settings.asterisk.host,
    settings.asterisk.ami.username,
    settings.asterisk.ami.password,
    true
);

//Keep connected if it's down
ami.keepConnected();

//Initialize websocket
var wss = new WebSocketServer({ port: settings.websocket.port });

//Setup broascast function
wss.broadcast = function broascast(data){
    if(wss.clients.length == 0) return;
    //console.log("Sending broadcast message: " + data);
    var json = JSON.parse(data);    
    if(json.tipo != "QueueMemberPaused" && json.tipo != "QueueMemberStatus") console.log("Sending broadcast message: " + data);
    wss.clients.forEach(function each(client) {
        client.send(data);
    });
};

//Set events of websocket
wss.on('connection', function connection(ws){

    ws.on('message', function incoming(message){
        var json = JSON.parse(message);

        switch(json.action){
            default:
                ws.send(message);
                break;
        }
    });

    ws.send(JSON.stringify({'status': 0, 'message': 'connected'}));
});

//Get ami events
ami.on("managerevent", function(evt){
    //console.log("\nEvent: " + evt.event);
    amiHandler.handler(wss, evt, ami);
});
