var pg = require('pg');
var settings = require('../settings.js');
//var logger = require('../utilities/logger.js');

function PostgreSQL(){
    this.client = null;
    this.connString = settings.postgres.uri;

    this.init = function(){
        console.log("Init postgresql...");
        if(this.client == null) {
            this.client = new pg.Client(this.connString);
            this.client.connect();
        }
    };

    this.query = function(sql, callback){
        console.log(sql);
        //logger.info(sql);
        var query = this.client.query(sql, function(err, result){
            if(err) {
                console.log(err);
                //logger.error(sql);
            }
            callback(err, result.rows, result.fields);
        });
    };

    this.multipleQuery = function(sql, callback){
        //var client = new pg.Client(this.connString);

        var queries = [];

        for(var i = 0; i < sql.length; i++){
            console.log(sql[i]);
            //logger.info(sql);
            queries[i] = this.client.query(sql[i]);
            queries[i].on('end', endHandler);
        }

        var count = sql.length;

        function endHandler () {
            count--; // decrement count by 1
            if (count === 0) {
                // two queries have ended, lets close the connection.
                callback(null, null);
            }
        }
    }
}

module.exports = PostgreSQL;
