function Agentes(db){
    this.db = db;
    this.agentsLogged = {};

    this.loadAgentes = function(){
        var self = this;
        var sql = "SELECT * FROM vm50_agentes WHERE situacao != 'NLogado'";

        this.db.query(sql, function(err, rows){
            if(err) return;

            for(var i = 0; i < rows.length; i++){
                self.agentsLogged[rows[i].login.trim()] = {};
                self.agentsLogged[rows[i].login.trim()]["ramal"] = rows[i].ramal;
            }
        });
    };

    this.addAgentLogged = function(agente, ramal, contexto){
        this.agentsLogged[agente] = {};
    	this.agentsLogged[agente]["ramal"] = ramal;
    	this.agentsLogged[agente]["context"] = contexto;
    };

    this.removeAgentLogged = function(agente){
        if(this.agentsLogged[agente]) delete this.agentsLogged[agente];
    };

    this.getAgentLogged = function(agente){
        if(this.agentsLogged[agente]) return this.agentsLogged[agente];
        else return null;
    }
}

module.exports = Agentes;
