var PostgreSQL = require('../dao/PostgreSQL.js');
var Agentes = require('./Agentes.js');
var Ramais = require('./Ramais.js');
var Ligacoes = require('./Ligacoes.js');

function AmiHandler(){

    this.db = new PostgreSQL();
    this.db.init();

    this.agentes = new Agentes(this.db);
    this.ramais = new Ramais(this.db);
    this.ligacoes = new Ligacoes();

    //Load ramais from database
    this.ramais.loadRamais();
    this.agentes.loadAgentes();

    this.handler = function(wss, evt, ami){
        switch(evt.event){

            case "AntennaLevel":
                this.AntennaLevel(wss, evt, ami);
                break;

            case "ExtensionStatus":
                this.ExtensionStatus(wss, evt, ami);
                break;

            case "Agentcallbacklogin":
                this.Agentcallbacklogin(wss, evt, ami);
                break;

            case "Agentcallbacklogoff":
                this.Agentcallbacklogoff(wss, evt, ami);
                break;

            case "QueueMemberPaused":
                this.QueueMemberPaused(wss, evt, ami);
                break;

            case "QueueMemberStatus":
                this.QueueMemberStatus(wss, evt, ami);
                break;

            case "Dial":
                this.Dial(wss, evt, ami);
                break;

            case "Newstate":
                this.Newstate(wss, evt, ami);
                break;

            case "Hangup":
                this.Hangup(wss, evt, ami);
                break;

            case "Newexten":
                this.Newexten(wss, evt, ami);
                break;

            case "Unlink":
                this.Unlink(wss, evt, ami);
                break;
        }
    };

    this.AntennaLevel = function(wss, evt, ami){
        var res = {};

        res.tipo = evt.event;
    	res.channel = evt.channel;
    	res.signal = evt.signal;

        wss.broadcast(JSON.stringify(res));
    };

    this.ExtensionStatus = function(wss, evt, ami){
        var res = {};

        res.tipo = evt.event;
    	res.exten = evt.exten;
    	res.context = evt.context;
    	res.hint = evt.hint;
    	res.status = evt.status;

        wss.broadcast(JSON.stringify(res));
    };

    this.Agentcallbacklogin = function(wss, evt, ami){
        var res = {};

        res.tipo = evt.event;
    	res.agent = evt.agent;
    	res.loginchan = evt.loginchan;

        var dadosAg = evt.loginchan.split("@");
        this.agentes.addAgentLogged(evt.agent, dadosAg[0], dadosAg[1]);

        wss.broadcast(JSON.stringify(res));
    };

    this.Agentcallbacklogoff = function(wss, evt, ami){
        var res = {};

        res.tipo = evt.event;
    	res.agent = evt.agent;
    	res.reason = evt.reason;
    	res.loginchan = evt.loginchan;
    	res.logintime = evt.logintime;

        this.agentes.removeAgentLogged(evt.agent);

        wss.broadcast(JSON.stringify(res));
    };

    this.QueueMemberPaused = function(wss, evt, ami){
        var res = {};

        res.tipo = evt.event;
    	res.queue = evt.queue;
    	res.location = evt.location;
    	res.memberName = evt.membername;
    	res.paused = evt.paused;

        var dadosAg = evt.membername.split("/");
        var agente = this.agentes.getAgentLogged(dadosAg[1]);

        if(agente){
            res.ramal = agente.ramal;
            this.ramais.getExtensionState(ami, agente.ramal, function(err, response){
                if(!err){
                    if(response.response == "Success") res.statusRamal = response.status;
                }

                wss.broadcast(JSON.stringify(res));
            });
        }
    };

    this.QueueMemberStatus = function(wss, evt, ami){
        var res = {};

        res.tipo = evt.event;
    	res.queue = evt.queue;
    	res.location = evt.location;
    	res.memberName = evt.membername;
    	res.membership = evt.membership;
    	res.penalty = evt.penalty;
    	res.callsTaken = evt.callstaken;
    	res.status = evt.status;
    	res.pause = evt.pause;

        wss.broadcast(JSON.stringify(res));
    };

    this.Dial = function(wss, evt, ami){
        var res = {};

    	if(this.ramais.isRamal(evt.destination)) {
            var destino = this.ramais.extractRamal(evt.destination);

            res.tipo = evt.event;
        	res.channel = evt.channel;
        	res.destination = evt.destination;
            res.callerId = evt.callerid;
        	res.callerIdNum = evt.calleridnum;
        	res.callerIdName = evt.calleridname;
        	res.uniqueId = evt.uniqueid;
        	res.destUniqueId = evt.destuniqueid;
        	res.dialString = evt.dialstring;
        	res.dialStatus = evt.dialstatus;
            res.time = new Date().getTime();

            this.ligacoes.addIncommingCall(
                destino,
                evt.channel,
                evt.destination,
                evt.callerid,
                evt.calleridnum,
                evt.calleridname,
                evt.uniqueid,
                evt.destuniqueid,
                evt.dialstring,
                evt.dialstatus,
                res.time
            );

            wss.broadcast(JSON.stringify(res));
    	}
    };

    this.Newstate = function(wss, evt, ami){
        var res = {};

        var channel = this.ramais.extractRamal(evt.channel);
        var ligacao = this.ligacoes.getIncommingCall(channel);

        if(ligacao){

            res.tipo = evt.event;
    		res.destination = ligacao.destination;
    		res.callerId = ligacao.callerId;
    		res.callerIdNum = ligacao.callerIdNum;
    		res.callerIdName = ligacao.callerIdName;
    		res.uniqueId = evt.uniqueid;
    		res.state = evt.state;
    		res.time = new Date().getTime();

            this.ligacoes.updateIncommingCall(
                channel,
                evt.state,
                res.time
            );

            wss.broadcast(JSON.stringify(res));
        }
    };

    this.Hangup = function(wss, evt, ami){
        var res = {};
        var ramal = this.ramais.extractRamal(evt.channel);
        if(!ramal) this.ramais.extractRamal(evt.destination);
        var ligacao = this.ligacoes.getIncommingCall(ramal);

        if(ligacao){
            res.tipo = evt.event;
    		res.direction = "entrada";
    		res.channel = evt.channel;
    		res.callerId = ligacao.callerId;
    		res.uniqueId = evt.uniqueid;

            this.ligacoes.removeIncommingCall(ramal);

            wss.broadcast(JSON.stringify(res));
        } else {
            ligacao = this.ligacoes.getOutgoingCall(ramal);

            if(ligacao){
                res.tipo = evt.event;
        		res.direction = "saida";
        		res.channel = evt.channel;
        		res.extension = ligacao.extension;
        		res.uniqueId = evt.uniqueid;

                this.ligacoes.removeOutgoingCall(ramal);
                wss.broadcast(JSON.stringify(res));
            }
        }
    };

    this.Newexten = function(wss, evt, ami){
        var res = {};

        if(!this.ramais.isRamal(evt.channel)) return;

        var ramal = this.ramais.extractRamal(evt.channel);
        var ligacao = this.ligacoes.getOutgoingCall(ramal);

    	res.tipo = evt.event;
    	res.channel = evt.channel;
    	res.context = evt.context;
    	res.extension = evt.extension;
    	res.time = new Date().getTime();

        wss.broadcast(JSON.stringify(res));

        if(ligacao == null){
            this.ligacoes.addOutgoingCall(ramal, evt.channel, evt.context, evt.extension, res.time);
        }
    };

    this.Unlink = function(wss, evt, ami){
        var ramal = this.ramais.extractRamal(evt.channel1);
        var ligacao = this.ligacoes.getOutgoingCall(ramal);

        if(ligacao){
            var res = {};
            res.tipo = evt.event;
    		res.direction = "saida";
    		res.channel = evt.channel1;
    		res.extension = ligacao.extension;

            wss.broadcast(JSON.stringify(res));

            this.ligacoes.removeOutgoingCall(ramal);
        }
    };
}

module.exports = AmiHandler;
