function Ligacoes(){

    this.incommingCalls = {};
    this.outgoingCalls = {};

    this.addIncommingCall = function(
        id,
        channel,
        destination,
        callerId,
        callerIdNum,
        callerIdName,
        uniqueId,
        destUniqueId,
        dialString,
        dialStatus,
        time
    ){
        this.incommingCalls[id] = {};
        this.incommingCalls[id].channel = channel;
        this.incommingCalls[id].destination = destination;
        this.incommingCalls[id].callerId = callerId;
        this.incommingCalls[id].callerIdNum = callerIdNum;
        this.incommingCalls[id].callerIdName = callerIdName;
        this.incommingCalls[id].uniqueId = uniqueId;
        this.incommingCalls[id].destUniqueId = destUniqueId;
        this.incommingCalls[id].dialString = dialString;
        this.incommingCalls[id].dialStatus = dialStatus;
        this.incommingCalls[id].time = time;
    };

    this.updateIncommingCall = function(
        id,
        state,
        time
    ){
        id = id.trim();
        if(this.getIncommingCall(id)){
            this.incommingCalls[id].state = state;
            this.incommingCalls[id].time = time;
        }
    };

    this.getIncommingCall = function(id){
        id = id.trim();
        if(this.incommingCalls[id]) return this.incommingCalls[id];
        else return null;
    };

    this.getIncommingCallByUniqueId = function(uniqueId){
        this.incommingCalls.forEach(function(item, index){
            if(item.uniqueId == uniqueId) return item;
        });
    }

    this.removeIncommingCall = function(id){
        id = id.trim();
        if(this.getIncommingCall(id)) delete this.incommingCalls[id];
    };

    this.addOutgoingCall = function(
        id,
        channel,
        context,
        extension,
        time
    ){
        id = id.trim();
        this.outgoingCalls[id] = {};
        this.outgoingCalls[id].channel = channel;
        this.outgoingCalls[id].context = context;
        this.outgoingCalls[id].extension = extension;
        this.outgoingCalls[id].time = time;
    };

    this.removeOutgoingCall = function(id){
        id = id.trim();
        if(this.getOutgoingCall(id)) delete this.outgoingCalls[id];
    };

    this.getOutgoingCall = function(id){
        id = id.trim();
        if(this.outgoingCalls[id]) return this.outgoingCalls[id];
        else return null;
    };

    this.getOutgoingCallByUniqueId = function(uniqueId){
        this.outgoingCalls.forEach(function(item, index){
            if(item.uniqueId == uniqueId) return item;
        });
    }
}

module.exports = Ligacoes;
